// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});
c2.dom.select;

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__5224__auto__ = (((x == null))?null:x);
var m__5225__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__5225__auto__.call(null,x));
} else {
var m__5225__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__5225__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return (c2.dom.select.cljs$core$IFn$_invoke$arity$1 ? c2.dom.select.cljs$core$IFn$_invoke$arity$1(selector) : c2.dom.select.call(null,selector));
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render(v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args42543 = [];
var len__5627__auto___42546 = arguments.length;
var i__5628__auto___42547 = (0);
while(true){
if((i__5628__auto___42547 < len__5627__auto___42546)){
args42543.push((arguments[i__5628__auto___42547]));

var G__42548 = (i__5628__auto___42547 + (1));
i__5628__auto___42547 = G__42548;
continue;
} else {
}
break;
}

var G__42545 = args42543.length;
switch (G__42545) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42543.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;
/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args42550 = [];
var len__5627__auto___42553 = arguments.length;
var i__5628__auto___42554 = (0);
while(true){
if((i__5628__auto___42554 < len__5627__auto___42553)){
args42550.push((arguments[i__5628__auto___42554]));

var G__42555 = (i__5628__auto___42554 + (1));
i__5628__auto___42554 = G__42555;
continue;
} else {
}
break;
}

var G__42552 = args42550.length;
switch (G__42552) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42550.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;
/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom(node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom(node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__42559_42561 = c2.dom.__GT_dom(container);
var G__42560_42562 = el__$1;
goog.dom.appendChild(G__42559_42561,G__42560_42562);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__42566_42569 = c2.dom.__GT_dom(container);
var G__42567_42570 = el__$1;
var G__42568_42571 = (0);
goog.dom.insertChildAt(G__42566_42569,G__42567_42570,G__42568_42571);

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
var G__42573 = c2.dom.__GT_dom(el);
return goog.dom.removeNode(G__42573);
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom(new$);
var G__42576_42578 = new$__$1;
var G__42577_42579 = c2.dom.__GT_dom(old);
goog.dom.replaceNode(G__42576_42578,G__42577_42579);

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args42580 = [];
var len__5627__auto___42594 = arguments.length;
var i__5628__auto___42595 = (0);
while(true){
if((i__5628__auto___42595 < len__5627__auto___42594)){
args42580.push((arguments[i__5628__auto___42595]));

var G__42596 = (i__5628__auto___42595 + (1));
i__5628__auto___42595 = G__42596;
continue;
} else {
}
break;
}

var G__42582 = args42580.length;
switch (G__42582) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42580.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
var G__42583 = el__$1;
var G__42584 = cljs.core.name(x);
return goog.style.getComputedStyle(G__42583,G__42584);
} else {
if(cljs.core.map_QMARK_(x)){
var seq__42585_42598 = cljs.core.seq(x);
var chunk__42586_42599 = null;
var count__42587_42600 = (0);
var i__42588_42601 = (0);
while(true){
if((i__42588_42601 < count__42587_42600)){
var vec__42589_42602 = chunk__42586_42599.cljs$core$IIndexed$_nth$arity$2(null,i__42588_42601);
var k_42603 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42589_42602,(0),null);
var v_42604 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42589_42602,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_42603,v_42604);

var G__42605 = seq__42585_42598;
var G__42606 = chunk__42586_42599;
var G__42607 = count__42587_42600;
var G__42608 = (i__42588_42601 + (1));
seq__42585_42598 = G__42605;
chunk__42586_42599 = G__42606;
count__42587_42600 = G__42607;
i__42588_42601 = G__42608;
continue;
} else {
var temp__4425__auto___42609 = cljs.core.seq(seq__42585_42598);
if(temp__4425__auto___42609){
var seq__42585_42610__$1 = temp__4425__auto___42609;
if(cljs.core.chunked_seq_QMARK_(seq__42585_42610__$1)){
var c__5372__auto___42611 = cljs.core.chunk_first(seq__42585_42610__$1);
var G__42612 = cljs.core.chunk_rest(seq__42585_42610__$1);
var G__42613 = c__5372__auto___42611;
var G__42614 = cljs.core.count(c__5372__auto___42611);
var G__42615 = (0);
seq__42585_42598 = G__42612;
chunk__42586_42599 = G__42613;
count__42587_42600 = G__42614;
i__42588_42601 = G__42615;
continue;
} else {
var vec__42590_42616 = cljs.core.first(seq__42585_42610__$1);
var k_42617 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42590_42616,(0),null);
var v_42618 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42590_42616,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_42617,v_42618);

var G__42619 = cljs.core.next(seq__42585_42610__$1);
var G__42620 = null;
var G__42621 = (0);
var G__42622 = (0);
seq__42585_42598 = G__42619;
chunk__42586_42599 = G__42620;
count__42587_42600 = G__42621;
i__42588_42601 = G__42622;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var G__42591_42623 = c2.dom.__GT_dom(el);
var G__42592_42624 = cljs.core.name(k);
var G__42593_42625 = ((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$bottom,null,cljs.core.cst$kw$top,null,cljs.core.cst$kw$width,null,cljs.core.cst$kw$right,null,cljs.core.cst$kw$height,null,cljs.core.cst$kw$left,null], null), null).call(null,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null));
goog.style.setStyle(G__42591_42623,G__42592_42624,G__42593_42625);

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args42626 = [];
var len__5627__auto___42641 = arguments.length;
var i__5628__auto___42642 = (0);
while(true){
if((i__5628__auto___42642 < len__5627__auto___42641)){
args42626.push((arguments[i__5628__auto___42642]));

var G__42643 = (i__5628__auto___42642 + (1));
i__5628__auto___42642 = G__42643;
continue;
} else {
}
break;
}

var G__42628 = args42626.length;
switch (G__42628) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42626.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom(el).attributes;
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5341__auto__ = ((function (attrs){
return (function c2$dom$iter__42629(s__42630){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__42630__$1 = s__42630;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__42630__$1);
if(temp__4425__auto__){
var s__42630__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__42630__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__42630__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__42632 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__42631 = (0);
while(true){
if((i__42631 < size__5340__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__42631);
cljs.core.chunk_append(b__42632,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null));

var G__42645 = (i__42631 + (1));
i__42631 = G__42645;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__42632),c2$dom$iter__42629(cljs.core.chunk_rest(s__42630__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__42632),null);
}
} else {
var i = cljs.core.first(s__42630__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__42629(cljs.core.rest(s__42630__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__5341__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name(x));
} else {
if(cljs.core.map_QMARK_(x)){
var seq__42635_42646 = cljs.core.seq(x);
var chunk__42636_42647 = null;
var count__42637_42648 = (0);
var i__42638_42649 = (0);
while(true){
if((i__42638_42649 < count__42637_42648)){
var vec__42639_42650 = chunk__42636_42647.cljs$core$IIndexed$_nth$arity$2(null,i__42638_42649);
var k_42651 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42639_42650,(0),null);
var v_42652 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42639_42650,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_42651,v_42652);

var G__42653 = seq__42635_42646;
var G__42654 = chunk__42636_42647;
var G__42655 = count__42637_42648;
var G__42656 = (i__42638_42649 + (1));
seq__42635_42646 = G__42653;
chunk__42636_42647 = G__42654;
count__42637_42648 = G__42655;
i__42638_42649 = G__42656;
continue;
} else {
var temp__4425__auto___42657 = cljs.core.seq(seq__42635_42646);
if(temp__4425__auto___42657){
var seq__42635_42658__$1 = temp__4425__auto___42657;
if(cljs.core.chunked_seq_QMARK_(seq__42635_42658__$1)){
var c__5372__auto___42659 = cljs.core.chunk_first(seq__42635_42658__$1);
var G__42660 = cljs.core.chunk_rest(seq__42635_42658__$1);
var G__42661 = c__5372__auto___42659;
var G__42662 = cljs.core.count(c__5372__auto___42659);
var G__42663 = (0);
seq__42635_42646 = G__42660;
chunk__42636_42647 = G__42661;
count__42637_42648 = G__42662;
i__42638_42649 = G__42663;
continue;
} else {
var vec__42640_42664 = cljs.core.first(seq__42635_42658__$1);
var k_42665 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42640_42664,(0),null);
var v_42666 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42640_42664,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_42665,v_42666);

var G__42667 = cljs.core.next(seq__42635_42658__$1);
var G__42668 = null;
var G__42669 = (0);
var G__42670 = (0);
seq__42635_42646 = G__42667;
chunk__42636_42647 = G__42668;
count__42637_42648 = G__42669;
i__42638_42649 = G__42670;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom(el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name(k));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$style,k)){
c2.dom.style.cljs$core$IFn$_invoke$arity$2(el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name(k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args42671 = [];
var len__5627__auto___42675 = arguments.length;
var i__5628__auto___42676 = (0);
while(true){
if((i__5628__auto___42676 < len__5627__auto___42675)){
args42671.push((arguments[i__5628__auto___42676]));

var G__42677 = (i__5628__auto___42676 + (1));
i__5628__auto___42676 = G__42677;
continue;
} else {
}
break;
}

var G__42673 = args42671.length;
switch (G__42673) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42671.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__42674 = c2.dom.__GT_dom(el);
return goog.dom.getTextContent(G__42674);
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;
/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args42679 = [];
var len__5627__auto___42683 = arguments.length;
var i__5628__auto___42684 = (0);
while(true){
if((i__5628__auto___42684 < len__5627__auto___42683)){
args42679.push((arguments[i__5628__auto___42684]));

var G__42685 = (i__5628__auto___42684 + (1));
i__5628__auto___42684 = G__42685;
continue;
} else {
}
break;
}

var G__42681 = args42679.length;
switch (G__42681) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42679.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__42682 = c2.dom.__GT_dom(el);
return goog.dom.forms.getValue(G__42682);
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;
/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
var G__42690_42693 = c2.dom.__GT_dom(el);
var G__42691_42694 = cljs.core.name(class$);
var G__42692_42695 = classed_QMARK_;
goog.dom.classes.enable(G__42690_42693,G__42691_42694,G__42692_42695);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__4569__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var or__4569__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__4569__auto____$1)){
return or__4569__auto____$1;
} else {
return ((function (or__4569__auto____$1,or__4569__auto__){
return (function (p1__42696_SHARP_){
var G__42697 = ((function (or__4569__auto____$1,or__4569__auto__){
return (function (){
return (p1__42696_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p1__42696_SHARP_.cljs$core$IFn$_invoke$arity$0() : p1__42696_SHARP_.call(null));
});})(or__4569__auto____$1,or__4569__auto__))
;
var G__42698 = (10);
return setTimeout(G__42697,G__42698);
});
;})(or__4569__auto____$1,or__4569__auto__))
}
}
})();
