// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__41832__delegate = function (args){
if(cljs.core.map_QMARK_(cljs.core.first(args))){
var vec__41831 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,cljs.core.rest(args));
var tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41831,(0),null);
var body = cljs.core.nthnext(vec__41831,(1));
if(cljs.core.map_QMARK_(cljs.core.first(body))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.first(body),cljs.core.first(args)], 0)),cljs.core.rest(body));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.first(args),body);
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,args);
}
};
var G__41832 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__41833__i = 0, G__41833__a = new Array(arguments.length -  0);
while (G__41833__i < G__41833__a.length) {G__41833__a[G__41833__i] = arguments[G__41833__i + 0]; ++G__41833__i;}
  args = new cljs.core.IndexedSeq(G__41833__a,0);
} 
return G__41832__delegate.call(this,args);};
G__41832.cljs$lang$maxFixedArity = 0;
G__41832.cljs$lang$applyTo = (function (arglist__41834){
var args = cljs.core.seq(arglist__41834);
return G__41832__delegate(args);
});
G__41832.cljs$core$IFn$_invoke$arity$variadic = G__41832__delegate;
return G__41832;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5341__auto__ = (function sablono$core$update_arglists_$_iter__41841(s__41842){
return (new cljs.core.LazySeq(null,(function (){
var s__41842__$1 = s__41842;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__41842__$1);
if(temp__4425__auto__){
var s__41842__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41842__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__41842__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__41844 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__41843 = (0);
while(true){
if((i__41843 < size__5340__auto__)){
var args = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__41843);
cljs.core.chunk_append(b__41844,cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)));

var G__41847 = (i__41843 + (1));
i__41843 = G__41847;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41844),sablono$core$update_arglists_$_iter__41841(cljs.core.chunk_rest(s__41842__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41844),null);
}
} else {
var args = cljs.core.first(s__41842__$2);
return cljs.core.cons(cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)),sablono$core$update_arglists_$_iter__41841(cljs.core.rest(s__41842__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5634__auto__ = [];
var len__5627__auto___41855 = arguments.length;
var i__5628__auto___41856 = (0);
while(true){
if((i__5628__auto___41856 < len__5627__auto___41855)){
args__5634__auto__.push((arguments[i__5628__auto___41856]));

var G__41857 = (i__5628__auto___41856 + (1));
i__5628__auto___41856 = G__41857;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5341__auto__ = (function sablono$core$iter__41849(s__41850){
return (new cljs.core.LazySeq(null,(function (){
var s__41850__$1 = s__41850;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__41850__$1);
if(temp__4425__auto__){
var s__41850__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41850__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__41850__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__41852 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__41851 = (0);
while(true){
if((i__41851 < size__5340__auto__)){
var style = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__41851);
cljs.core.chunk_append(b__41852,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null));

var G__41858 = (i__41851 + (1));
i__41851 = G__41858;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41852),sablono$core$iter__41849(cljs.core.chunk_rest(s__41850__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41852),null);
}
} else {
var style = cljs.core.first(s__41850__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null),sablono$core$iter__41849(cljs.core.rest(s__41850__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq41848){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41848));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
var G__41863 = goog.dom.getDocument().body;
var G__41864 = (function (){var G__41865 = "script";
var G__41866 = {"src": src};
return goog.dom.createDom(G__41865,G__41866);
})();
return goog.dom.appendChild(G__41863,G__41864);
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js("http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to41867 = (function sablono$core$link_to41867(var_args){
var args__5634__auto__ = [];
var len__5627__auto___41870 = arguments.length;
var i__5628__auto___41871 = (0);
while(true){
if((i__5628__auto___41871 < len__5627__auto___41870)){
args__5634__auto__.push((arguments[i__5628__auto___41871]));

var G__41872 = (i__5628__auto___41871 + (1));
i__5628__auto___41871 = G__41872;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.link_to41867.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.link_to41867.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([url], 0))], null),content], null);
});

sablono.core.link_to41867.cljs$lang$maxFixedArity = (1);

sablono.core.link_to41867.cljs$lang$applyTo = (function (seq41868){
var G__41869 = cljs.core.first(seq41868);
var seq41868__$1 = cljs.core.next(seq41868);
return sablono.core.link_to41867.cljs$core$IFn$_invoke$arity$variadic(G__41869,seq41868__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs(sablono.core.link_to41867);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to41873 = (function sablono$core$mail_to41873(var_args){
var args__5634__auto__ = [];
var len__5627__auto___41878 = arguments.length;
var i__5628__auto___41879 = (0);
while(true){
if((i__5628__auto___41879 < len__5627__auto___41878)){
args__5634__auto__.push((arguments[i__5628__auto___41879]));

var G__41880 = (i__5628__auto___41879 + (1));
i__5628__auto___41879 = G__41880;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.mail_to41873.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.mail_to41873.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__41876){
var vec__41877 = p__41876;
var content = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41877,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4569__auto__ = content;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to41873.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to41873.cljs$lang$applyTo = (function (seq41874){
var G__41875 = cljs.core.first(seq41874);
var seq41874__$1 = cljs.core.next(seq41874);
return sablono.core.mail_to41873.cljs$core$IFn$_invoke$arity$variadic(G__41875,seq41874__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs(sablono.core.mail_to41873);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list41881 = (function sablono$core$unordered_list41881(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,(function (){var iter__5341__auto__ = (function sablono$core$unordered_list41881_$_iter__41888(s__41889){
return (new cljs.core.LazySeq(null,(function (){
var s__41889__$1 = s__41889;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__41889__$1);
if(temp__4425__auto__){
var s__41889__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41889__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__41889__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__41891 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__41890 = (0);
while(true){
if((i__41890 < size__5340__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__41890);
cljs.core.chunk_append(b__41891,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__41894 = (i__41890 + (1));
i__41890 = G__41894;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41891),sablono$core$unordered_list41881_$_iter__41888(cljs.core.chunk_rest(s__41889__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41891),null);
}
} else {
var x = cljs.core.first(s__41889__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$unordered_list41881_$_iter__41888(cljs.core.rest(s__41889__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs(sablono.core.unordered_list41881);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list41895 = (function sablono$core$ordered_list41895(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ol,(function (){var iter__5341__auto__ = (function sablono$core$ordered_list41895_$_iter__41902(s__41903){
return (new cljs.core.LazySeq(null,(function (){
var s__41903__$1 = s__41903;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__41903__$1);
if(temp__4425__auto__){
var s__41903__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41903__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__41903__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__41905 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__41904 = (0);
while(true){
if((i__41904 < size__5340__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__41904);
cljs.core.chunk_append(b__41905,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__41908 = (i__41904 + (1));
i__41904 = G__41908;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41905),sablono$core$ordered_list41895_$_iter__41902(cljs.core.chunk_rest(s__41903__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41905),null);
}
} else {
var x = cljs.core.first(s__41903__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$ordered_list41895_$_iter__41902(cljs.core.rest(s__41903__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs(sablono.core.ordered_list41895);
/**
 * Create an image element.
 */
sablono.core.image41909 = (function sablono$core$image41909(var_args){
var args41910 = [];
var len__5627__auto___41913 = arguments.length;
var i__5628__auto___41914 = (0);
while(true){
if((i__5628__auto___41914 < len__5627__auto___41913)){
args41910.push((arguments[i__5628__auto___41914]));

var G__41915 = (i__5628__auto___41914 + (1));
i__5628__auto___41914 = G__41915;
continue;
} else {
}
break;
}

var G__41912 = args41910.length;
switch (G__41912) {
case 1:
return sablono.core.image41909.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image41909.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41910.length)].join('')));

}
});

sablono.core.image41909.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0))], null)], null);
});

sablono.core.image41909.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0)),cljs.core.cst$kw$alt,alt], null)], null);
});

sablono.core.image41909.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs(sablono.core.image41909);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__41917_SHARP_,p2__41918_SHARP_){
return [cljs.core.str(p1__41917_SHARP_),cljs.core.str("["),cljs.core.str(p2__41918_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__41919_SHARP_,p2__41920_SHARP_){
return [cljs.core.str(p1__41919_SHARP_),cljs.core.str("-"),cljs.core.str(p2__41920_SHARP_)].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,type,cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field41921 = (function sablono$core$color_field41921(var_args){
var args41922 = [];
var len__5627__auto___41989 = arguments.length;
var i__5628__auto___41990 = (0);
while(true){
if((i__5628__auto___41990 < len__5627__auto___41989)){
args41922.push((arguments[i__5628__auto___41990]));

var G__41991 = (i__5628__auto___41990 + (1));
i__5628__auto___41990 = G__41991;
continue;
} else {
}
break;
}

var G__41924 = args41922.length;
switch (G__41924) {
case 1:
return sablono.core.color_field41921.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field41921.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41922.length)].join('')));

}
});

sablono.core.color_field41921.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.color_field41921.cljs$core$IFn$_invoke$arity$2(name__12427__auto__,null);
});

sablono.core.color_field41921.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$color)].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.color_field41921.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs(sablono.core.color_field41921);

/**
 * Creates a date input field.
 */
sablono.core.date_field41925 = (function sablono$core$date_field41925(var_args){
var args41926 = [];
var len__5627__auto___41993 = arguments.length;
var i__5628__auto___41994 = (0);
while(true){
if((i__5628__auto___41994 < len__5627__auto___41993)){
args41926.push((arguments[i__5628__auto___41994]));

var G__41995 = (i__5628__auto___41994 + (1));
i__5628__auto___41994 = G__41995;
continue;
} else {
}
break;
}

var G__41928 = args41926.length;
switch (G__41928) {
case 1:
return sablono.core.date_field41925.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field41925.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41926.length)].join('')));

}
});

sablono.core.date_field41925.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.date_field41925.cljs$core$IFn$_invoke$arity$2(name__12427__auto__,null);
});

sablono.core.date_field41925.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$date)].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.date_field41925.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs(sablono.core.date_field41925);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field41929 = (function sablono$core$datetime_field41929(var_args){
var args41930 = [];
var len__5627__auto___41997 = arguments.length;
var i__5628__auto___41998 = (0);
while(true){
if((i__5628__auto___41998 < len__5627__auto___41997)){
args41930.push((arguments[i__5628__auto___41998]));

var G__41999 = (i__5628__auto___41998 + (1));
i__5628__auto___41998 = G__41999;
continue;
} else {
}
break;
}

var G__41932 = args41930.length;
switch (G__41932) {
case 1:
return sablono.core.datetime_field41929.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field41929.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41930.length)].join('')));

}
});

sablono.core.datetime_field41929.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.datetime_field41929.cljs$core$IFn$_invoke$arity$2(name__12427__auto__,null);
});

sablono.core.datetime_field41929.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime)].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.datetime_field41929.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs(sablono.core.datetime_field41929);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field41933 = (function sablono$core$datetime_local_field41933(var_args){
var args41934 = [];
var len__5627__auto___42001 = arguments.length;
var i__5628__auto___42002 = (0);
while(true){
if((i__5628__auto___42002 < len__5627__auto___42001)){
args41934.push((arguments[i__5628__auto___42002]));

var G__42003 = (i__5628__auto___42002 + (1));
i__5628__auto___42002 = G__42003;
continue;
} else {
}
break;
}

var G__41936 = args41934.length;
switch (G__41936) {
case 1:
return sablono.core.datetime_local_field41933.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field41933.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41934.length)].join('')));

}
});

sablono.core.datetime_local_field41933.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.datetime_local_field41933.cljs$core$IFn$_invoke$arity$2(name__12427__auto__,null);
});

sablono.core.datetime_local_field41933.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime_DASH_local)].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.datetime_local_field41933.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs(sablono.core.datetime_local_field41933);

/**
 * Creates a email input field.
 */
sablono.core.email_field41937 = (function sablono$core$email_field41937(var_args){
var args41938 = [];
var len__5627__auto___42005 = arguments.length;
var i__5628__auto___42006 = (0);
while(true){
if((i__5628__auto___42006 < len__5627__auto___42005)){
args41938.push((arguments[i__5628__auto___42006]));

var G__42007 = (i__5628__auto___42006 + (1));
i__5628__auto___42006 = G__42007;
continue;
} else {
}
break;
}

var G__41940 = args41938.length;
switch (G__41940) {
case 1:
return sablono.core.email_field41937.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field41937.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41938.length)].join('')));

}
});

sablono.core.email_field41937.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.email_field41937.cljs$core$IFn$_invoke$arity$2(name__12427__auto__,null);
});

sablono.core.email_field41937.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$email)].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.email_field41937.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs(sablono.core.email_field41937);

/**
 * Creates a file input field.
 */
sablono.core.file_field41941 = (function sablono$core$file_field41941(var_args){
var args41942 = [];
var len__5627__auto___42009 = arguments.length;
var i__5628__auto___42010 = (0);
while(true){
if((i__5628__auto___42010 < len__5627__auto___42009)){
args41942.push((arguments[i__5628__auto___42010]));

var G__42011 = (i__5628__auto___42010 + (1));
i__5628__auto___42010 = G__42011;
continue;
} else {
}
break;
}

var G__41944 = args41942.length;
switch (G__41944) {
case 1:
return sablono.core.file_field41941.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field41941.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41942.length)].join('')));

}
});

sablono.core.file_field41941.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.file_field41941.cljs$core$IFn$_invoke$arity$2(name__12427__auto__,null);
});

sablono.core.file_field41941.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$file)].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.file_field41941.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs(sablono.core.file_field41941);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field41945 = (function sablono$core$hidden_field41945(var_args){
var args41946 = [];
var len__5627__auto___42013 = arguments.length;
var i__5628__auto___42014 = (0);
while(true){
if((i__5628__auto___42014 < len__5627__auto___42013)){
args41946.push((arguments[i__5628__auto___42014]));

var G__42015 = (i__5628__auto___42014 + (1));
i__5628__auto___42014 = G__42015;
continue;
} else {
}
break;
}

var G__41948 = args41946.length;
switch (G__41948) {
case 1:
return sablono.core.hidden_field41945.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field41945.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41946.length)].join('')));

}
});

sablono.core.hidden_field41945.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.hidden_field41945.cljs$core$IFn$_invoke$arity$2(name__12427__auto__,null);
});

sablono.core.hidden_field41945.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$hidden)].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.hidden_field41945.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs(sablono.core.hidden_field41945);

/**
 * Creates a month input field.
 */
sablono.core.month_field41949 = (function sablono$core$month_field41949(var_args){
var args41950 = [];
var len__5627__auto___42017 = arguments.length;
var i__5628__auto___42018 = (0);
while(true){
if((i__5628__auto___42018 < len__5627__auto___42017)){
args41950.push((arguments[i__5628__auto___42018]));

var G__42019 = (i__5628__auto___42018 + (1));
i__5628__auto___42018 = G__42019;
continue;
} else {
}
break;
}

var G__41952 = args41950.length;
switch (G__41952) {
case 1:
return sablono.core.month_field41949.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field41949.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41950.length)].join('')));

}
});

sablono.core.month_field41949.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.month_field41949.cljs$core$IFn$_invoke$arity$2(name__12427__auto__,null);
});

sablono.core.month_field41949.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$month)].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.month_field41949.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs(sablono.core.month_field41949);

/**
 * Creates a number input field.
 */
sablono.core.number_field41953 = (function sablono$core$number_field41953(var_args){
var args41954 = [];
var len__5627__auto___42021 = arguments.length;
var i__5628__auto___42022 = (0);
while(true){
if((i__5628__auto___42022 < len__5627__auto___42021)){
args41954.push((arguments[i__5628__auto___42022]));

var G__42023 = (i__5628__auto___42022 + (1));
i__5628__auto___42022 = G__42023;
continue;
} else {
}
break;
}

var G__41956 = args41954.length;
switch (G__41956) {
case 1:
return sablono.core.number_field41953.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field41953.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41954.length)].join('')));

}
});

sablono.core.number_field41953.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.number_field41953.cljs$core$IFn$_invoke$arity$2(name__12427__auto__,null);
});

sablono.core.number_field41953.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$number)].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.number_field41953.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs(sablono.core.number_field41953);

/**
 * Creates a password input field.
 */
sablono.core.password_field41957 = (function sablono$core$password_field41957(var_args){
var args41958 = [];
var len__5627__auto___42025 = arguments.length;
var i__5628__auto___42026 = (0);
while(true){
if((i__5628__auto___42026 < len__5627__auto___42025)){
args41958.push((arguments[i__5628__auto___42026]));

var G__42027 = (i__5628__auto___42026 + (1));
i__5628__auto___42026 = G__42027;
continue;
} else {
}
break;
}

var G__41960 = args41958.length;
switch (G__41960) {
case 1:
return sablono.core.password_field41957.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field41957.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41958.length)].join('')));

}
});

sablono.core.password_field41957.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.password_field41957.cljs$core$IFn$_invoke$arity$2(name__12427__auto__,null);
});

sablono.core.password_field41957.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$password)].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.password_field41957.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs(sablono.core.password_field41957);

/**
 * Creates a range input field.
 */
sablono.core.range_field41961 = (function sablono$core$range_field41961(var_args){
var args41962 = [];
var len__5627__auto___42029 = arguments.length;
var i__5628__auto___42030 = (0);
while(true){
if((i__5628__auto___42030 < len__5627__auto___42029)){
args41962.push((arguments[i__5628__auto___42030]));

var G__42031 = (i__5628__auto___42030 + (1));
i__5628__auto___42030 = G__42031;
continue;
} else {
}
break;
}

var G__41964 = args41962.length;
switch (G__41964) {
case 1:
return sablono.core.range_field41961.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field41961.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41962.length)].join('')));

}
});

sablono.core.range_field41961.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.range_field41961.cljs$core$IFn$_invoke$arity$2(name__12427__auto__,null);
});

sablono.core.range_field41961.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$range)].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.range_field41961.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs(sablono.core.range_field41961);

/**
 * Creates a search input field.
 */
sablono.core.search_field41965 = (function sablono$core$search_field41965(var_args){
var args41966 = [];
var len__5627__auto___42033 = arguments.length;
var i__5628__auto___42034 = (0);
while(true){
if((i__5628__auto___42034 < len__5627__auto___42033)){
args41966.push((arguments[i__5628__auto___42034]));

var G__42035 = (i__5628__auto___42034 + (1));
i__5628__auto___42034 = G__42035;
continue;
} else {
}
break;
}

var G__41968 = args41966.length;
switch (G__41968) {
case 1:
return sablono.core.search_field41965.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field41965.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41966.length)].join('')));

}
});

sablono.core.search_field41965.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.search_field41965.cljs$core$IFn$_invoke$arity$2(name__12427__auto__,null);
});

sablono.core.search_field41965.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$search)].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.search_field41965.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs(sablono.core.search_field41965);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field41969 = (function sablono$core$tel_field41969(var_args){
var args41970 = [];
var len__5627__auto___42037 = arguments.length;
var i__5628__auto___42038 = (0);
while(true){
if((i__5628__auto___42038 < len__5627__auto___42037)){
args41970.push((arguments[i__5628__auto___42038]));

var G__42039 = (i__5628__auto___42038 + (1));
i__5628__auto___42038 = G__42039;
continue;
} else {
}
break;
}

var G__41972 = args41970.length;
switch (G__41972) {
case 1:
return sablono.core.tel_field41969.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field41969.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41970.length)].join('')));

}
});

sablono.core.tel_field41969.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.tel_field41969.cljs$core$IFn$_invoke$arity$2(name__12427__auto__,null);
});

sablono.core.tel_field41969.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$tel)].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.tel_field41969.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs(sablono.core.tel_field41969);

/**
 * Creates a text input field.
 */
sablono.core.text_field41973 = (function sablono$core$text_field41973(var_args){
var args41974 = [];
var len__5627__auto___42041 = arguments.length;
var i__5628__auto___42042 = (0);
while(true){
if((i__5628__auto___42042 < len__5627__auto___42041)){
args41974.push((arguments[i__5628__auto___42042]));

var G__42043 = (i__5628__auto___42042 + (1));
i__5628__auto___42042 = G__42043;
continue;
} else {
}
break;
}

var G__41976 = args41974.length;
switch (G__41976) {
case 1:
return sablono.core.text_field41973.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field41973.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41974.length)].join('')));

}
});

sablono.core.text_field41973.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.text_field41973.cljs$core$IFn$_invoke$arity$2(name__12427__auto__,null);
});

sablono.core.text_field41973.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$text)].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.text_field41973.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs(sablono.core.text_field41973);

/**
 * Creates a time input field.
 */
sablono.core.time_field41977 = (function sablono$core$time_field41977(var_args){
var args41978 = [];
var len__5627__auto___42045 = arguments.length;
var i__5628__auto___42046 = (0);
while(true){
if((i__5628__auto___42046 < len__5627__auto___42045)){
args41978.push((arguments[i__5628__auto___42046]));

var G__42047 = (i__5628__auto___42046 + (1));
i__5628__auto___42046 = G__42047;
continue;
} else {
}
break;
}

var G__41980 = args41978.length;
switch (G__41980) {
case 1:
return sablono.core.time_field41977.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field41977.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41978.length)].join('')));

}
});

sablono.core.time_field41977.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.time_field41977.cljs$core$IFn$_invoke$arity$2(name__12427__auto__,null);
});

sablono.core.time_field41977.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$time)].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.time_field41977.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs(sablono.core.time_field41977);

/**
 * Creates a url input field.
 */
sablono.core.url_field41981 = (function sablono$core$url_field41981(var_args){
var args41982 = [];
var len__5627__auto___42049 = arguments.length;
var i__5628__auto___42050 = (0);
while(true){
if((i__5628__auto___42050 < len__5627__auto___42049)){
args41982.push((arguments[i__5628__auto___42050]));

var G__42051 = (i__5628__auto___42050 + (1));
i__5628__auto___42050 = G__42051;
continue;
} else {
}
break;
}

var G__41984 = args41982.length;
switch (G__41984) {
case 1:
return sablono.core.url_field41981.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field41981.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41982.length)].join('')));

}
});

sablono.core.url_field41981.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.url_field41981.cljs$core$IFn$_invoke$arity$2(name__12427__auto__,null);
});

sablono.core.url_field41981.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$url)].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.url_field41981.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs(sablono.core.url_field41981);

/**
 * Creates a week input field.
 */
sablono.core.week_field41985 = (function sablono$core$week_field41985(var_args){
var args41986 = [];
var len__5627__auto___42053 = arguments.length;
var i__5628__auto___42054 = (0);
while(true){
if((i__5628__auto___42054 < len__5627__auto___42053)){
args41986.push((arguments[i__5628__auto___42054]));

var G__42055 = (i__5628__auto___42054 + (1));
i__5628__auto___42054 = G__42055;
continue;
} else {
}
break;
}

var G__41988 = args41986.length;
switch (G__41988) {
case 1:
return sablono.core.week_field41985.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field41985.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41986.length)].join('')));

}
});

sablono.core.week_field41985.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.week_field41985.cljs$core$IFn$_invoke$arity$2(name__12427__auto__,null);
});

sablono.core.week_field41985.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$week)].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.week_field41985.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs(sablono.core.week_field41985);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box42057 = (function sablono$core$check_box42057(var_args){
var args42058 = [];
var len__5627__auto___42061 = arguments.length;
var i__5628__auto___42062 = (0);
while(true){
if((i__5628__auto___42062 < len__5627__auto___42061)){
args42058.push((arguments[i__5628__auto___42062]));

var G__42063 = (i__5628__auto___42062 + (1));
i__5628__auto___42062 = G__42063;
continue;
} else {
}
break;
}

var G__42060 = args42058.length;
switch (G__42060) {
case 1:
return sablono.core.check_box42057.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box42057.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box42057.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42058.length)].join('')));

}
});

sablono.core.check_box42057.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box42057.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.check_box42057.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box42057.cljs$core$IFn$_invoke$arity$3(name,checked_QMARK_,"true");
});

sablono.core.check_box42057.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"checkbox",cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.check_box42057.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs(sablono.core.check_box42057);
/**
 * Creates a radio button.
 */
sablono.core.radio_button42065 = (function sablono$core$radio_button42065(var_args){
var args42066 = [];
var len__5627__auto___42069 = arguments.length;
var i__5628__auto___42070 = (0);
while(true){
if((i__5628__auto___42070 < len__5627__auto___42069)){
args42066.push((arguments[i__5628__auto___42070]));

var G__42071 = (i__5628__auto___42070 + (1));
i__5628__auto___42070 = G__42071;
continue;
} else {
}
break;
}

var G__42068 = args42066.length;
switch (G__42068) {
case 1:
return sablono.core.radio_button42065.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button42065.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button42065.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42066.length)].join('')));

}
});

sablono.core.radio_button42065.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button42065.cljs$core$IFn$_invoke$arity$2(group,null);
});

sablono.core.radio_button42065.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button42065.cljs$core$IFn$_invoke$arity$3(group,checked_QMARK_,"true");
});

sablono.core.radio_button42065.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"radio",cljs.core.cst$kw$name,sablono.core.make_name(group),cljs.core.cst$kw$id,sablono.core.make_id([cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([group], 0))),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([value], 0)))].join('')),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.radio_button42065.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs(sablono.core.radio_button42065);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options42073 = (function sablono$core$select_options42073(var_args){
var args42074 = [];
var len__5627__auto___42087 = arguments.length;
var i__5628__auto___42088 = (0);
while(true){
if((i__5628__auto___42088 < len__5627__auto___42087)){
args42074.push((arguments[i__5628__auto___42088]));

var G__42089 = (i__5628__auto___42088 + (1));
i__5628__auto___42088 = G__42089;
continue;
} else {
}
break;
}

var G__42076 = args42074.length;
switch (G__42076) {
case 1:
return sablono.core.select_options42073.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options42073.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42074.length)].join('')));

}
});

sablono.core.select_options42073.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options42073.cljs$core$IFn$_invoke$arity$2(coll,null);
});

sablono.core.select_options42073.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__5341__auto__ = (function sablono$core$iter__42077(s__42078){
return (new cljs.core.LazySeq(null,(function (){
var s__42078__$1 = s__42078;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__42078__$1);
if(temp__4425__auto__){
var s__42078__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__42078__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__42078__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__42080 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__42079 = (0);
while(true){
if((i__42079 < size__5340__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__42079);
cljs.core.chunk_append(b__42080,((cljs.core.sequential_QMARK_(x))?(function (){var vec__42085 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42085,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42085,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42085,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options42073.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)));

var G__42091 = (i__42079 + (1));
i__42079 = G__42091;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__42080),sablono$core$iter__42077(cljs.core.chunk_rest(s__42078__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__42080),null);
}
} else {
var x = cljs.core.first(s__42078__$2);
return cljs.core.cons(((cljs.core.sequential_QMARK_(x))?(function (){var vec__42086 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42086,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42086,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42086,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options42073.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)),sablono$core$iter__42077(cljs.core.rest(s__42078__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(coll);
});

sablono.core.select_options42073.cljs$lang$maxFixedArity = 2;

sablono.core.select_options = sablono.core.wrap_attrs(sablono.core.select_options42073);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down42092 = (function sablono$core$drop_down42092(var_args){
var args42093 = [];
var len__5627__auto___42096 = arguments.length;
var i__5628__auto___42097 = (0);
while(true){
if((i__5628__auto___42097 < len__5627__auto___42096)){
args42093.push((arguments[i__5628__auto___42097]));

var G__42098 = (i__5628__auto___42097 + (1));
i__5628__auto___42097 = G__42098;
continue;
} else {
}
break;
}

var G__42095 = args42093.length;
switch (G__42095) {
case 2:
return sablono.core.drop_down42092.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down42092.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42093.length)].join('')));

}
});

sablono.core.drop_down42092.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down42092.cljs$core$IFn$_invoke$arity$3(name,options,null);
});

sablono.core.drop_down42092.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name)], null),(sablono.core.select_options.cljs$core$IFn$_invoke$arity$2 ? sablono.core.select_options.cljs$core$IFn$_invoke$arity$2(options,selected) : sablono.core.select_options.call(null,options,selected))], null);
});

sablono.core.drop_down42092.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs(sablono.core.drop_down42092);
/**
 * Creates a text area element.
 */
sablono.core.text_area42100 = (function sablono$core$text_area42100(var_args){
var args42101 = [];
var len__5627__auto___42104 = arguments.length;
var i__5628__auto___42105 = (0);
while(true){
if((i__5628__auto___42105 < len__5627__auto___42104)){
args42101.push((arguments[i__5628__auto___42105]));

var G__42106 = (i__5628__auto___42105 + (1));
i__5628__auto___42105 = G__42106;
continue;
} else {
}
break;
}

var G__42103 = args42101.length;
switch (G__42103) {
case 1:
return sablono.core.text_area42100.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area42100.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42101.length)].join('')));

}
});

sablono.core.text_area42100.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area42100.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.text_area42100.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$textarea,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});

sablono.core.text_area42100.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs(sablono.core.text_area42100);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label42108 = (function sablono$core$label42108(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$htmlFor,sablono.core.make_id(name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs(sablono.core.label42108);
/**
 * Creates a submit button.
 */
sablono.core.submit_button42109 = (function sablono$core$submit_button42109(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"submit",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs(sablono.core.submit_button42109);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button42110 = (function sablono$core$reset_button42110(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"reset",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs(sablono.core.reset_button42110);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to42111 = (function sablono$core$form_to42111(var_args){
var args__5634__auto__ = [];
var len__5627__auto___42116 = arguments.length;
var i__5628__auto___42117 = (0);
while(true){
if((i__5628__auto___42117 < len__5627__auto___42116)){
args__5634__auto__.push((arguments[i__5628__auto___42117]));

var G__42118 = (i__5628__auto___42117 + (1));
i__5628__auto___42117 = G__42118;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.form_to42111.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.form_to42111.cljs$core$IFn$_invoke$arity$variadic = (function (p__42114,body){
var vec__42115 = p__42114;
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42115,(0),null);
var action = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42115,(1),null);
var method_str = clojure.string.upper_case(cljs.core.name(method));
var action_uri = sablono.util.to_uri(action);
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$get,null,cljs.core.cst$kw$post,null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,method_str,cljs.core.cst$kw$action,action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,"POST",cljs.core.cst$kw$action,action_uri], null),(sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2 ? sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2("_method",method_str) : sablono.core.hidden_field.call(null,"_method",method_str))], null)),body));
});

sablono.core.form_to42111.cljs$lang$maxFixedArity = (1);

sablono.core.form_to42111.cljs$lang$applyTo = (function (seq42112){
var G__42113 = cljs.core.first(seq42112);
var seq42112__$1 = cljs.core.next(seq42112);
return sablono.core.form_to42111.cljs$core$IFn$_invoke$arity$variadic(G__42113,seq42112__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs(sablono.core.form_to42111);
