// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.dataview');
goog.require('cljs.core');
goog.require('hatti.views.photos');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.views.map');
goog.require('hatti.views.chart');
goog.require('hatti.shared');
goog.require('hatti.views.saved_charts');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('hatti.views.settings');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('hatti.utils.om.state');
goog.require('hatti.views.overview');
goog.require('hatti.views.table');
hatti.views.dataview.dataview_map = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$overview,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$overview,cljs.core.cst$kw$label,"Overview",cljs.core.cst$kw$component,hatti.views.overview_page], null),cljs.core.cst$kw$photos,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$photos,cljs.core.cst$kw$label,"Photos",cljs.core.cst$kw$component,hatti.views.photos_page], null),cljs.core.cst$kw$map,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$map,cljs.core.cst$kw$label,"Map",cljs.core.cst$kw$component,hatti.views.map_page], null),cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$table,cljs.core.cst$kw$label,"Table",cljs.core.cst$kw$component,hatti.views.table_page], null),cljs.core.cst$kw$chart,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$chart,cljs.core.cst$kw$label,"Summary Charts",cljs.core.cst$kw$component,hatti.views.chart_page], null),cljs.core.cst$kw$saved_DASH_charts,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$saved_DASH_charts,cljs.core.cst$kw$label,"Saved Charts",cljs.core.cst$kw$component,hatti.views.saved_charts_page], null),cljs.core.cst$kw$settings,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$settings,cljs.core.cst$kw$label,"Settings",cljs.core.cst$kw$component,hatti.views.settings_page], null)], null);
hatti.views.dataview_actions.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.dataview.t_hatti$views$dataview29494 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview29494 = (function (cursor,owner,meta29495){
this.cursor = cursor;
this.owner = owner;
this.meta29495 = meta29495;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview29494.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29496,meta29495__$1){
var self__ = this;
var _29496__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview29494(self__.cursor,self__.owner,meta29495__$1));
});

hatti.views.dataview.t_hatti$views$dataview29494.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29496){
var self__ = this;
var _29496__$1 = this;
return self__.meta29495;
});

hatti.views.dataview.t_hatti$views$dataview29494.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview29494.prototype.om$core$IRender$render$arity$1 = (function (this__6323__auto__){
var self__ = this;
var this__6323__auto____$1 = this;
return null;
});

hatti.views.dataview.t_hatti$views$dataview29494.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta29495], null);
});

hatti.views.dataview.t_hatti$views$dataview29494.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview29494.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview29494";

hatti.views.dataview.t_hatti$views$dataview29494.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.dataview/t_hatti$views$dataview29494");
});

hatti.views.dataview.__GT_t_hatti$views$dataview29494 = (function hatti$views$dataview$__GT_t_hatti$views$dataview29494(cursor__$1,owner__$1,meta29495){
return (new hatti.views.dataview.t_hatti$views$dataview29494(cursor__$1,owner__$1,meta29495));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview29494(cursor,owner,null));
}));
hatti.views.dataview_infobar.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__29497,owner){
var map__29498 = p__29497;
var map__29498__$1 = ((((!((map__29498 == null)))?((((map__29498.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29498.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29498):map__29498);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29498__$1,cljs.core.cst$kw$dataset_DASH_info);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29498__$1,cljs.core.cst$kw$status);
if(typeof hatti.views.dataview.t_hatti$views$dataview29500 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview29500 = (function (p__29497,owner,map__29498,dataset_info,status,meta29501){
this.p__29497 = p__29497;
this.owner = owner;
this.map__29498 = map__29498;
this.dataset_info = dataset_info;
this.status = status;
this.meta29501 = meta29501;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview29500.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__29498,map__29498__$1,dataset_info,status){
return (function (_29502,meta29501__$1){
var self__ = this;
var _29502__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview29500(self__.p__29497,self__.owner,self__.map__29498,self__.dataset_info,self__.status,meta29501__$1));
});})(map__29498,map__29498__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview29500.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__29498,map__29498__$1,dataset_info,status){
return (function (_29502){
var self__ = this;
var _29502__$1 = this;
return self__.meta29501;
});})(map__29498,map__29498__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview29500.prototype.om$core$IWillMount$ = true;

hatti.views.dataview.t_hatti$views$dataview29500.prototype.om$core$IWillMount$will_mount$arity$1 = ((function (map__29498,map__29498__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form);
var langs = hatti.ona.forms.get_languages(form);
var default_lang = hatti.ona.forms.default_lang(langs);
var lang_state = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$all,langs,cljs.core.cst$kw$default,default_lang,cljs.core.cst$kw$current,default_lang], null);
if(cljs.core.truth_(hatti.ona.forms.multilingual_QMARK_(form))){
return hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$languages], null),lang_state);
} else {
return null;
}
});})(map__29498,map__29498__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview29500.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview29500.prototype.om$core$IRender$render$arity$1 = ((function (map__29498,map__29498__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form);
var map__29503 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__29503__$1 = ((((!((map__29503 == null)))?((((map__29503.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29503.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29503):map__29503);
var dataset_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29503__$1,cljs.core.cst$kw$dataset_DASH_id);
var map__29504 = self__.dataset_info;
var map__29504__$1 = ((((!((map__29504 == null)))?((((map__29504.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29504.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29504):map__29504);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29504__$1,cljs.core.cst$kw$num_of_submissions);
var map__29505 = self__.status;
var map__29505__$1 = ((((!((map__29505 == null)))?((((map__29505.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29505.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29505):map__29505);
var loading_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29505__$1,cljs.core.cst$kw$loading_QMARK_);
var total_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29505__$1,cljs.core.cst$kw$total_DASH_records);
var G__29513 = {"className": "right rec-summary rec-margin"};
var G__29514 = (function (){var attrs29509 = (cljs.core.truth_(hatti.ona.forms.multilingual_QMARK_(form))?om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.shared.language_selector,null):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs29509))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,"language-selector"], null),attrs29509], 0))):{"id": "language-selector"}),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs29509))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs29509)], null))));
})();
var G__29515 = (function (){var G__29518 = {"id": "data-status"};
var G__29519 = (function (){var attrs29510 = (cljs.core.truth_(loading_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_spinner$fa_DASH_pulse], null):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs29510))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["rec"], null)], null),attrs29510], 0))):{"className": "rec"}),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs29510))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(hatti.utils.pluralize_number(num_of_submissions," Record"))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs29510),sablono.interpreter.interpret(hatti.utils.pluralize_number(num_of_submissions," Record"))], null))));
})();
return React.DOM.div(G__29518,G__29519);
})();
var G__29516 = (function (){var G__29520 = {"className": "divider"};
return React.DOM.div(G__29520);
})();
var G__29517 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_actions,dataset_id));
return React.DOM.div(G__29513,G__29514,G__29515,G__29516,G__29517);
});})(map__29498,map__29498__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview29500.getBasis = ((function (map__29498,map__29498__$1,dataset_info,status){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__29497,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__29498,cljs.core.cst$sym$dataset_DASH_info,cljs.core.cst$sym$status,cljs.core.cst$sym$meta29501], null);
});})(map__29498,map__29498__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview29500.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview29500.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview29500";

hatti.views.dataview.t_hatti$views$dataview29500.cljs$lang$ctorPrWriter = ((function (map__29498,map__29498__$1,dataset_info,status){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.dataview/t_hatti$views$dataview29500");
});})(map__29498,map__29498__$1,dataset_info,status))
;

hatti.views.dataview.__GT_t_hatti$views$dataview29500 = ((function (map__29498,map__29498__$1,dataset_info,status){
return (function hatti$views$dataview$__GT_t_hatti$views$dataview29500(p__29497__$1,owner__$1,map__29498__$2,dataset_info__$1,status__$1,meta29501){
return (new hatti.views.dataview.t_hatti$views$dataview29500(p__29497__$1,owner__$1,map__29498__$2,dataset_info__$1,status__$1,meta29501));
});})(map__29498,map__29498__$1,dataset_info,status))
;

}

return (new hatti.views.dataview.t_hatti$views$dataview29500(p__29497,owner,map__29498__$1,dataset_info,status,cljs.core.PersistentArrayMap.EMPTY));
}));
hatti.views.dataview.activate_view_BANG_ = (function hatti$views$dataview$activate_view_BANG_(view){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(view);
var views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
if(cljs.core.contains_QMARK_(cljs.core.set(views),view__$1)){
hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,view__$1], null));

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.tabbed_dataview.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner,opts){
if(typeof hatti.views.dataview.t_hatti$views$dataview29524 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview29524 = (function (app_state,owner,opts,meta29525){
this.app_state = app_state;
this.owner = owner;
this.opts = opts;
this.meta29525 = meta29525;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview29524.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29526,meta29525__$1){
var self__ = this;
var _29526__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview29524(self__.app_state,self__.owner,self__.opts,meta29525__$1));
});

hatti.views.dataview.t_hatti$views$dataview29524.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29526){
var self__ = this;
var _29526__$1 = this;
return self__.meta29525;
});

hatti.views.dataview.t_hatti$views$dataview29524.prototype.om$core$IInitState$ = true;

hatti.views.dataview.t_hatti$views$dataview29524.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form);
var geopoints_QMARK_ = cljs.core.cst$kw$instances_with_geopoints.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state));
var no_geodata_QMARK_ = cljs.core.not((function (){var or__4569__auto__ = geopoints_QMARK_;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var or__4569__auto____$1 = cljs.core.some(hatti.ona.forms.geopoint_QMARK_,form);
if(cljs.core.truth_(or__4569__auto____$1)){
return or__4569__auto____$1;
} else {
return cljs.core.some(hatti.ona.forms.geofield_QMARK_,form);
}
}
})());
if((no_geodata_QMARK_) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$map,cljs.core.cst$kw$selected.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(self__.app_state))))){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$selected], null),cljs.core.cst$kw$table);
} else {
}

return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$no_DASH_geodata_QMARK_,no_geodata_QMARK_], null);
});

hatti.views.dataview.t_hatti$views$dataview29524.prototype.om$core$IRenderState$ = true;

hatti.views.dataview.t_hatti$views$dataview29524.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,p__29527){
var self__ = this;
var map__29528 = p__29527;
var map__29528__$1 = ((((!((map__29528 == null)))?((((map__29528.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29528.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29528):map__29528);
var no_geodata_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29528__$1,cljs.core.cst$kw$no_DASH_geodata_QMARK_);
var ___$1 = this;
var active_view = cljs.core.cst$kw$selected.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(self__.app_state));
var view__GT_display = ((function (active_view,___$1,map__29528,map__29528__$1,no_geodata_QMARK_){
return (function (p1__29521_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(active_view,p1__29521_SHARP_)){
return "block";
} else {
return "none";
}
});})(active_view,___$1,map__29528,map__29528__$1,no_geodata_QMARK_))
;
var view__GT_cls = ((function (active_view,view__GT_display,___$1,map__29528,map__29528__$1,no_geodata_QMARK_){
return (function (p1__29522_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(active_view,p1__29522_SHARP_)){
return "clicked";
} else {
return null;
}
});})(active_view,view__GT_display,___$1,map__29528,map__29528__$1,no_geodata_QMARK_))
;
var dataviews = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview.dataview_map,cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(self__.app_state))));
var dv__GT_link = ((function (active_view,view__GT_display,view__GT_cls,dataviews,___$1,map__29528,map__29528__$1,no_geodata_QMARK_){
return (function (p__29530){
var map__29531 = p__29530;
var map__29531__$1 = ((((!((map__29531 == null)))?((((map__29531.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29531.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29531):map__29531);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29531__$1,cljs.core.cst$kw$view);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29531__$1,cljs.core.cst$kw$label);
var active_QMARK_ = cljs.core.some(((function (map__29531,map__29531__$1,view,label,active_view,view__GT_display,view__GT_cls,dataviews,___$1,map__29528,map__29528__$1,no_geodata_QMARK_){
return (function (p1__29523_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,p1__29523_SHARP_);
});})(map__29531,map__29531__$1,view,label,active_view,view__GT_display,view__GT_cls,dataviews,___$1,map__29528,map__29528__$1,no_geodata_QMARK_))
,cljs.core.cst$kw$active.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(self__.app_state)));
if(cljs.core.truth_((function (){var and__4557__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,cljs.core.cst$kw$map);
if(and__4557__auto__){
return no_geodata_QMARK_;
} else {
return and__4557__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$class,"inactive",cljs.core.cst$kw$title,"No geodata"], null),cljs.core.name(view)], null);
} else {
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,cljs.core.cst$kw$map)) && ((cljs.core.cst$kw$num_of_submissions.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state)) > hatti.constants.mapping_threshold))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$class,"inactive",cljs.core.cst$kw$title,hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic("Map does not support more than %d points.",cljs.core.array_seq([hatti.constants.mapping_threshold], 0))], null),cljs.core.name(view)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,(cljs.core.truth_(active_QMARK_)?[cljs.core.str("#/"),cljs.core.str(cljs.core.name(view))].join(''):null),cljs.core.cst$kw$class,(cljs.core.truth_(active_QMARK_)?view__GT_cls(view):"inactive")], null),label], null);

}
}
});})(active_view,view__GT_display,view__GT_cls,dataviews,___$1,map__29528,map__29528__$1,no_geodata_QMARK_))
;
var G__29534 = {"className": "tab-container dataset-tabs"};
var G__29535 = (function (){var attrs29533 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(dv__GT_link,dataviews);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs29533))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["tab-bar"], null)], null),attrs29533], 0))):{"className": "tab-bar"}),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs29533))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state),cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs29533),sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state),cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null))));
})();
var G__29536 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((function (){var iter__5341__auto__ = ((function (G__29534,G__29535,active_view,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1,map__29528,map__29528__$1,no_geodata_QMARK_){
return (function hatti$views$dataview$iter__29537(s__29538){
return (new cljs.core.LazySeq(null,((function (G__29534,G__29535,active_view,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1,map__29528,map__29528__$1,no_geodata_QMARK_){
return (function (){
var s__29538__$1 = s__29538;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__29538__$1);
if(temp__4425__auto__){
var s__29538__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__29538__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__29538__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__29540 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__29539 = (0);
while(true){
if((i__29539 < size__5340__auto__)){
var map__29555 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__29539);
var map__29555__$1 = ((((!((map__29555 == null)))?((((map__29555.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29555.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29555):map__29555);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29555__$1,cljs.core.cst$kw$component);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29555__$1,cljs.core.cst$kw$view);
cljs.core.chunk_append(b__29540,(function (){var G__29557 = {"style": {"display": view__GT_display(view)}, "className": [cljs.core.str("tab-page "),cljs.core.str(cljs.core.name(view)),cljs.core.str("-page")].join('')};
var G__29558 = (function (){var G__29559 = {"id": [cljs.core.str("tab-content"),cljs.core.str(cljs.core.name(view))].join(''), "className": "tab-content"};
var G__29560 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$3(component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null)));
return React.DOM.div(G__29559,G__29560);
})();
return React.DOM.div(G__29557,G__29558);
})());

var G__29567 = (i__29539 + (1));
i__29539 = G__29567;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29540),hatti$views$dataview$iter__29537(cljs.core.chunk_rest(s__29538__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29540),null);
}
} else {
var map__29561 = cljs.core.first(s__29538__$2);
var map__29561__$1 = ((((!((map__29561 == null)))?((((map__29561.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29561.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29561):map__29561);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29561__$1,cljs.core.cst$kw$component);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29561__$1,cljs.core.cst$kw$view);
return cljs.core.cons((function (){var G__29563 = {"style": {"display": view__GT_display(view)}, "className": [cljs.core.str("tab-page "),cljs.core.str(cljs.core.name(view)),cljs.core.str("-page")].join('')};
var G__29564 = (function (){var G__29565 = {"id": [cljs.core.str("tab-content"),cljs.core.str(cljs.core.name(view))].join(''), "className": "tab-content"};
var G__29566 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$3(component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null)));
return React.DOM.div(G__29565,G__29566);
})();
return React.DOM.div(G__29563,G__29564);
})(),hatti$views$dataview$iter__29537(cljs.core.rest(s__29538__$2)));
}
} else {
return null;
}
break;
}
});})(G__29534,G__29535,active_view,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1,map__29528,map__29528__$1,no_geodata_QMARK_))
,null,null));
});})(G__29534,G__29535,active_view,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1,map__29528,map__29528__$1,no_geodata_QMARK_))
;
return iter__5341__auto__(dataviews);
})());
return React.DOM.div(G__29534,G__29535,G__29536);
});

hatti.views.dataview.t_hatti$views$dataview29524.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$opts,cljs.core.cst$sym$meta29525], null);
});

hatti.views.dataview.t_hatti$views$dataview29524.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview29524.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview29524";

hatti.views.dataview.t_hatti$views$dataview29524.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.dataview/t_hatti$views$dataview29524");
});

hatti.views.dataview.__GT_t_hatti$views$dataview29524 = (function hatti$views$dataview$__GT_t_hatti$views$dataview29524(app_state__$1,owner__$1,opts__$1,meta29525){
return (new hatti.views.dataview.t_hatti$views$dataview29524(app_state__$1,owner__$1,opts__$1,meta29525));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview29524(app_state,owner,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
