// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('cljs_time.coerce');
goog.require('cljs.core');
goog.require('cljs_time.core');
goog.require('cljs_time.format');
goog.require('goog.date');

/**
 * @interface
 */
cljs_time.coerce.ICoerce = function(){};

/**
 * Convert `obj` to a goog.date.DateTime instance.
 */
cljs_time.coerce.to_date_time = (function cljs_time$coerce$to_date_time(obj){
if((!((obj == null))) && (!((obj.cljs_time$coerce$ICoerce$to_date_time$arity$1 == null)))){
return obj.cljs_time$coerce$ICoerce$to_date_time$arity$1(obj);
} else {
var x__5224__auto__ = (((obj == null))?null:obj);
var m__5225__auto__ = (cljs_time.coerce.to_date_time[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(obj) : m__5225__auto__.call(null,obj));
} else {
var m__5225__auto____$1 = (cljs_time.coerce.to_date_time["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(obj) : m__5225__auto____$1.call(null,obj));
} else {
throw cljs.core.missing_protocol("ICoerce.to-date-time",obj);
}
}
}
});

/**
 * Returns a DateTime instance in the UTC time zone corresponding to the given
 *   number of milliseconds after the Unix epoch.
 */
cljs_time.coerce.from_long = (function cljs_time$coerce$from_long(millis){
var G__34207 = (new goog.date.UtcDateTime());
G__34207.setTime(millis);

return G__34207;
});
/**
 * Returns DateTime instance from string using formatters in clj-time.format,
 *   returning first which parses
 */
cljs_time.coerce.from_string = (function cljs_time$coerce$from_string(s){
return cljs.core.first((function (){var iter__5341__auto__ = (function cljs_time$coerce$from_string_$_iter__34218(s__34219){
return (new cljs.core.LazySeq(null,(function (){
var s__34219__$1 = s__34219;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__34219__$1);
if(temp__4425__auto__){
var s__34219__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34219__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__34219__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__34221 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__34220 = (0);
while(true){
if((i__34220 < size__5340__auto__)){
var f = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__34220);
var d = (function (){try{return cljs_time.format.parse.cljs$core$IFn$_invoke$arity$2(f,s);
}catch (e34226){if((e34226 instanceof Error)){
var _ = e34226;
return null;
} else {
throw e34226;

}
}})();
if(cljs.core.truth_(d)){
cljs.core.chunk_append(b__34221,d);

var G__34228 = (i__34220 + (1));
i__34220 = G__34228;
continue;
} else {
var G__34229 = (i__34220 + (1));
i__34220 = G__34229;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34221),cljs_time$coerce$from_string_$_iter__34218(cljs.core.chunk_rest(s__34219__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34221),null);
}
} else {
var f = cljs.core.first(s__34219__$2);
var d = (function (){try{return cljs_time.format.parse.cljs$core$IFn$_invoke$arity$2(f,s);
}catch (e34227){if((e34227 instanceof Error)){
var _ = e34227;
return null;
} else {
throw e34227;

}
}})();
if(cljs.core.truth_(d)){
return cljs.core.cons(d,cljs_time$coerce$from_string_$_iter__34218(cljs.core.rest(s__34219__$2)));
} else {
var G__34230 = cljs.core.rest(s__34219__$2);
s__34219__$1 = G__34230;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(cljs.core.vals(cljs_time.format.formatters));
})());
});
/**
 * Returns a DateTime instance in the UTC time zone corresponding to the given
 *   Java Date object.
 */
cljs_time.coerce.from_date = (function cljs_time$coerce$from_date(date){
return cljs_time.coerce.from_long(date.getTime());
});
/**
 * Convert `obj` to the number of milliseconds after the Unix epoch.
 */
cljs_time.coerce.to_long = (function cljs_time$coerce$to_long(obj){
var temp__4423__auto__ = cljs_time.coerce.to_date_time(obj);
if(cljs.core.truth_(temp__4423__auto__)){
var dt = temp__4423__auto__;
return dt.getTime();
} else {
return null;
}
});
/**
 * Convert `obj` to Unix epoch.
 */
cljs_time.coerce.to_epoch = (function cljs_time$coerce$to_epoch(obj){
var millis = cljs_time.coerce.to_long(obj);
var and__4557__auto__ = millis;
if(cljs.core.truth_(and__4557__auto__)){
return (millis / (1000));
} else {
return and__4557__auto__;
}
});
/**
 * Convert `obj` to a JavaScript Date instance.
 */
cljs_time.coerce.to_date = (function cljs_time$coerce$to_date(obj){
var temp__4423__auto__ = cljs_time.coerce.to_date_time(obj);
if(cljs.core.truth_(temp__4423__auto__)){
var dt = temp__4423__auto__;
return (new Date(dt.getTime()));
} else {
return null;
}
});
/**
 * Returns a string representation of obj in UTC time-zone
 *   using (ISODateTimeFormat/dateTime) date-time representation.
 */
cljs_time.coerce.to_string = (function cljs_time$coerce$to_string(obj){
var temp__4423__auto__ = cljs_time.coerce.to_date_time(obj);
if(cljs.core.truth_(temp__4423__auto__)){
var dt = temp__4423__auto__;
return cljs_time.format.unparse(cljs.core.cst$kw$date_DASH_time.cljs$core$IFn$_invoke$arity$1(cljs_time.format.formatters),dt);
} else {
return null;
}
});
/**
 * Convert `obj` to a goog.date.Date instance
 */
cljs_time.coerce.to_local_date = (function cljs_time$coerce$to_local_date(obj){
var temp__4423__auto__ = cljs_time.coerce.to_date_time(obj);
if(cljs.core.truth_(temp__4423__auto__)){
var dt = temp__4423__auto__;
var G__34232 = (new goog.date.Date());
G__34232.setYear(dt.getYear());

G__34232.setMonth(dt.getMonth());

G__34232.setDate(dt.getDate());

return G__34232;
} else {
return null;
}
});
/**
 * Convert `obj` to a goog.date.DateTime instance
 */
cljs_time.coerce.to_local_date_time = (function cljs_time$coerce$to_local_date_time(obj){
var temp__4423__auto__ = cljs_time.coerce.to_date_time(obj);
if(cljs.core.truth_(temp__4423__auto__)){
var dt = temp__4423__auto__;
var G__34234 = (new goog.date.DateTime());
G__34234.setYear(dt.getYear());

G__34234.setMonth(dt.getMonth());

G__34234.setDate(dt.getDate());

G__34234.setHours(dt.getHours());

G__34234.setMinutes(dt.getMinutes());

G__34234.setSeconds(dt.getSeconds());

G__34234.setMilliseconds(dt.getMilliseconds());

return G__34234;
} else {
return null;
}
});
(cljs_time.coerce.ICoerce["null"] = true);

(cljs_time.coerce.to_date_time["null"] = (function (_){
return null;
}));

Date.prototype.cljs_time$coerce$ICoerce$ = true;

Date.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (date){
var date__$1 = this;
return cljs_time.coerce.from_date(date__$1);
});

goog.date.Date.prototype.cljs_time$coerce$ICoerce$ = true;

goog.date.Date.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (local_date){
var local_date__$1 = this;
return cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$3(cljs_time.core.year(local_date__$1),cljs_time.core.month(local_date__$1),cljs_time.core.day(local_date__$1));
});

goog.date.DateTime.prototype.cljs_time$coerce$ICoerce$ = true;

goog.date.DateTime.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (local_date_time){
var local_date_time__$1 = this;
return cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$7(cljs_time.core.year(local_date_time__$1),cljs_time.core.month(local_date_time__$1),cljs_time.core.day(local_date_time__$1),cljs_time.core.hour(local_date_time__$1),cljs_time.core.minute(local_date_time__$1),cljs_time.core.second(local_date_time__$1),cljs_time.core.milli(local_date_time__$1));
});

goog.date.UtcDateTime.prototype.cljs_time$coerce$ICoerce$ = true;

goog.date.UtcDateTime.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (date_time){
var date_time__$1 = this;
return date_time__$1;
});

(cljs_time.coerce.ICoerce["number"] = true);

(cljs_time.coerce.to_date_time["number"] = (function (long$){
return cljs_time.coerce.from_long(long$);
}));

(cljs_time.coerce.ICoerce["string"] = true);

(cljs_time.coerce.to_date_time["string"] = (function (string){
return cljs_time.coerce.from_string(string);
}));
