// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var extra_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"full-name","full-name",408178550),hatti.constants._id,new cljs.core.Keyword(null,"label","label",1718410804),"id",new cljs.core.Keyword(null,"name","name",1843675177),hatti.constants._id,new cljs.core.Keyword(null,"type","type",1174270348),"integer"], null)], null);
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
return extra_field;
} else {
return cljs.core.conj.call(null,extra_field,hatti.ona.forms.submission_time_field);
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__5634__auto__ = [];
var len__5627__auto___14483 = arguments.length;
var i__5628__auto___14484 = (0);
while(true){
if((i__5628__auto___14484 < len__5627__auto___14483)){
args__5634__auto__.push((arguments[i__5628__auto___14484]));

var G__14485 = (i__5628__auto___14484 + (1));
i__5628__auto___14484 = G__14485;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__14480){
var map__14481 = p__14480;
var map__14481__$1 = ((((!((map__14481 == null)))?((((map__14481.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14481.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14481):map__14481);
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__14481__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
return cljs.core.distinct.call(null,cljs.core.filter.call(null,hatti.ona.forms.has_data_QMARK_,cljs.core.concat.call(null,hatti.views.table.get_extra_fields.call(null,is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields.call(null,form),hatti.ona.forms.meta_fields.call(null,form,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549),cljs.core.not.call(null,is_filtered_dataview_QMARK_)))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq14478){
var G__14479 = cljs.core.first.call(null,seq14478);
var seq14478__$1 = cljs.core.next.call(null,seq14478);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__14479,seq14478__$1);
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__14486_SHARP_){
if(typeof p1__14486_SHARP_ === 'string'){
return clojure.string.lower_case.call(null,p1__14486_SHARP_);
} else {
return p1__14486_SHARP_;
}
});})(col))
;
var aval = lower.call(null,(a[(col["field"])]));
var bval = lower.call(null,(b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not.call(null,args)){
return true;
} else {
var indexed_form = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550),form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__14490){
var vec__14491 = p__14490;
var fname = cljs.core.nth.call(null,vec__14491,(0),null);
var answer = cljs.core.nth.call(null,vec__14491,(1),null);
return hatti.ona.forms.format_answer.call(null,cljs.core.get.call(null,indexed_form,fname),answer,null,true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,((function (indexed_form,query,fmt_subitem){
return (function (p1__14487_SHARP_){
return cljs.core.re_find.call(null,hatti.utils.safe_regex.call(null,query),[cljs.core.str(p1__14487_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.call(null,fmt_subitem,cljs.core.js__GT_clj.call(null,item))));
return cljs.core.seq.call(null,filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.call(null,value,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return hatti.ona.forms.format_answer.call(null,field,clj_value,language,true);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args14492 = [];
var len__5627__auto___14514 = arguments.length;
var i__5628__auto___14515 = (0);
while(true){
if((i__5628__auto___14515 < len__5627__auto___14514)){
args14492.push((arguments[i__5628__auto___14515]));

var G__14516 = (i__5628__auto___14515 + (1));
i__5628__auto___14515 = G__14516;
continue;
} else {
}
break;
}

var G__14498 = args14492.length;
switch (G__14498) {
case 1:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args14492.slice((3)),(0)));
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1 = (function (form){
return hatti.views.table.flat_form__GT_sg_columns.call(null,form,true);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2 = (function (form,get_label_QMARK_){
return hatti.views.table.flat_form__GT_sg_columns.call(null,form,get_label_QMARK_,null);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,get_label_QMARK_,language,p__14499){
var map__14500 = p__14499;
var map__14500__$1 = ((((!((map__14500 == null)))?((((map__14500.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14500.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14500):map__14500);
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__14500__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
return cljs.core.clj__GT_js.call(null,(function (){var iter__5341__auto__ = ((function (map__14500,map__14500__$1,is_filtered_dataview_QMARK_){
return (function hatti$views$table$iter__14502(s__14503){
return (new cljs.core.LazySeq(null,((function (map__14500,map__14500__$1,is_filtered_dataview_QMARK_){
return (function (){
var s__14503__$1 = s__14503;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__14503__$1);
if(temp__4425__auto__){
var s__14503__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__14503__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__14503__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__14505 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__14504 = (0);
while(true){
if((i__14504 < size__5340__auto__)){
var field = cljs.core._nth.call(null,c__5339__auto__,i__14504);
cljs.core.chunk_append.call(null,b__14505,(function (){var map__14510 = field;
var map__14510__$1 = ((((!((map__14510 == null)))?((((map__14510.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14510.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14510):map__14510);
var name = cljs.core.get.call(null,map__14510__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__14510__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__14510__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hatti.ona.forms.get_column_class.call(null,field),label,cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class.call(null,field),label]);
})());

var G__14518 = (i__14504 + (1));
i__14504 = G__14518;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14505),hatti$views$table$iter__14502.call(null,cljs.core.chunk_rest.call(null,s__14503__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14505),null);
}
} else {
var field = cljs.core.first.call(null,s__14503__$2);
return cljs.core.cons.call(null,(function (){var map__14512 = field;
var map__14512__$1 = ((((!((map__14512 == null)))?((((map__14512.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14512.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14512):map__14512);
var name = cljs.core.get.call(null,map__14512__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__14512__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__14512__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hatti.ona.forms.get_column_class.call(null,field),label,cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class.call(null,field),label]);
})(),hatti$views$table$iter__14502.call(null,cljs.core.rest.call(null,s__14503__$2)));
}
} else {
return null;
}
break;
}
});})(map__14500,map__14500__$1,is_filtered_dataview_QMARK_))
,null,null));
});})(map__14500,map__14500__$1,is_filtered_dataview_QMARK_))
;
return iter__5341__auto__.call(null,hatti.views.table.all_fields.call(null,form,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_));
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq14493){
var G__14494 = cljs.core.first.call(null,seq14493);
var seq14493__$1 = cljs.core.next.call(null,seq14493);
var G__14495 = cljs.core.first.call(null,seq14493__$1);
var seq14493__$2 = cljs.core.next.call(null,seq14493__$1);
var G__14496 = cljs.core.first.call(null,seq14493__$2);
var seq14493__$3 = cljs.core.next.call(null,seq14493__$2);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__14494,G__14495,G__14496,seq14493__$3);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (3);
hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,jQuery([cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join(''))));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = {"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": true};
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__14527(s__14528){
return (new cljs.core.LazySeq(null,(function (){
var s__14528__$1 = s__14528;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__14528__$1);
if(temp__4425__auto__){
var s__14528__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__14528__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__14528__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__14530 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__14529 = (0);
while(true){
if((i__14529 < size__5340__auto__)){
var vec__14533 = cljs.core._nth.call(null,c__5339__auto__,i__14529);
var handler_key = cljs.core.nth.call(null,vec__14533,(0),null);
var handler_function = cljs.core.nth.call(null,vec__14533,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append.call(null,b__14530,event.subscribe(handler_function));

var G__14535 = (i__14529 + (1));
i__14529 = G__14535;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14530),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__14527.call(null,cljs.core.chunk_rest.call(null,s__14528__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14530),null);
}
} else {
var vec__14534 = cljs.core.first.call(null,s__14528__$2);
var handler_key = cljs.core.nth.call(null,vec__14534,(0),null);
var handler_function = cljs.core.nth.call(null,vec__14534,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__14527.call(null,cljs.core.rest.call(null,s__14528__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__14544(s__14545){
return (new cljs.core.LazySeq(null,(function (){
var s__14545__$1 = s__14545;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__14545__$1);
if(temp__4425__auto__){
var s__14545__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__14545__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__14545__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__14547 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__14546 = (0);
while(true){
if((i__14546 < size__5340__auto__)){
var vec__14550 = cljs.core._nth.call(null,c__5339__auto__,i__14546);
var handler_key = cljs.core.nth.call(null,vec__14550,(0),null);
var handler_function = cljs.core.nth.call(null,vec__14550,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append.call(null,b__14547,event.subscribe(handler_function));

var G__14552 = (i__14546 + (1));
i__14546 = G__14552;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14547),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__14544.call(null,cljs.core.chunk_rest.call(null,s__14545__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14547),null);
}
} else {
var vec__14551 = cljs.core.first.call(null,s__14545__$2);
var handler_key = cljs.core.nth.call(null,vec__14551,(0),null);
var handler_function = cljs.core.nth.call(null,vec__14551,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__14544.call(null,cljs.core.rest.call(null,s__14545__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,p__14553){
var map__14562 = p__14553;
var map__14562__$1 = ((((!((map__14562 == null)))?((((map__14562.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14562.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14562):map__14562);
var grid_event_handlers = cljs.core.get.call(null,map__14562__$1,new cljs.core.Keyword(null,"grid-event-handlers","grid-event-handlers",1413592355));
var dataview_event_handlers = cljs.core.get.call(null,map__14562__$1,new cljs.core.Keyword(null,"dataview-event-handlers","dataview-event-handlers",-916375885));
var columns = hatti.views.table.flat_form__GT_sg_columns.call(null,form,true,current_language,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_);
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
var map__14564 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__14564__$1 = ((((!((map__14564 == null)))?((((map__14564.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14564.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14564):map__14564);
var map__14565 = cljs.core.get.call(null,map__14564__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__14565__$1 = ((((!((map__14565 == null)))?((((map__14565.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14565.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14565):map__14565);
var map__14566 = cljs.core.get.call(null,map__14565__$1,new cljs.core.Keyword(null,"paging","paging",1716279728));
var map__14566__$1 = ((((!((map__14566 == null)))?((((map__14566.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14566.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14566):map__14566);
var num_displayed_records = cljs.core.get.call(null,map__14566__$1,new cljs.core.Keyword(null,"num-displayed-records","num-displayed-records",213046400));
var total_page_count = cljs.core.get.call(null,map__14566__$1,new cljs.core.Keyword(null,"total-page-count","total-page-count",582341740));
hatti.views.table.bind_external_sg_grid_event_handlers.call(null,grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers.call(null,dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__14564,map__14564__$1,map__14565,map__14565__$1,map__14566,map__14566__$1,num_displayed_records,total_page_count,map__14562,map__14562__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__14564,map__14564__$1,map__14565,map__14565__$1,map__14566,map__14566__$1,num_displayed_records,total_page_count,map__14562,map__14562__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__14564,map__14564__$1,map__14565,map__14565__$1,map__14566,map__14566__$1,num_displayed_records,total_page_count,map__14562,map__14562__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__14564,map__14564__$1,map__14565,map__14565__$1,map__14566,map__14566__$1,num_displayed_records,total_page_count,map__14562,map__14562__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__14564,map__14564__$1,map__14565,map__14565__$1,map__14566,map__14566__$1,num_displayed_records,total_page_count,map__14562,map__14562__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
});})(columns,SlickGrid,DataView,dataview,grid,map__14564,map__14564__$1,map__14565,map__14565__$1,map__14566,map__14566__$1,num_displayed_records,total_page_count,map__14562,map__14562__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager.call(null,grid,dataview);

dataview.setPagingOptions({"pageSize": (function (){var or__4569__auto__ = num_displayed_records;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count});

dataview.setFilter(cljs.core.partial.call(null,hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js.call(null,data),hatti.constants._id);

hatti.views.table.resizeColumns.call(null,grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap.call(null);
var c__8400__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8400__auto__,event_chan){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto__,event_chan){
return (function (state_14831){
var state_val_14832 = (state_14831[(1)]);
if((state_val_14832 === (7))){
var inst_14740 = (state_14831[(7)]);
var inst_14740__$1 = (state_14831[(2)]);
var inst_14742 = (inst_14740__$1 == null);
var inst_14743 = cljs.core.not.call(null,inst_14742);
var state_14831__$1 = (function (){var statearr_14833 = state_14831;
(statearr_14833[(7)] = inst_14740__$1);

return statearr_14833;
})();
if(inst_14743){
var statearr_14834_14901 = state_14831__$1;
(statearr_14834_14901[(1)] = (8));

} else {
var statearr_14835_14902 = state_14831__$1;
(statearr_14835_14902[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (20))){
var inst_14762 = (state_14831[(8)]);
var inst_14770 = (state_14831[(9)]);
var inst_14779 = inst_14770.call(null,inst_14762);
var state_14831__$1 = state_14831;
var statearr_14836_14903 = state_14831__$1;
(statearr_14836_14903[(2)] = inst_14779);

(statearr_14836_14903[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (27))){
var state_14831__$1 = state_14831;
var statearr_14837_14904 = state_14831__$1;
(statearr_14837_14904[(2)] = null);

(statearr_14837_14904[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (1))){
var state_14831__$1 = state_14831;
var statearr_14838_14905 = state_14831__$1;
(statearr_14838_14905[(2)] = null);

(statearr_14838_14905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (24))){
var state_14831__$1 = state_14831;
var statearr_14839_14906 = state_14831__$1;
(statearr_14839_14906[(2)] = null);

(statearr_14839_14906[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (4))){
var state_14831__$1 = state_14831;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14831__$1,(7),event_chan);
} else {
if((state_val_14832 === (15))){
var inst_14740 = (state_14831[(7)]);
var state_14831__$1 = state_14831;
var statearr_14840_14907 = state_14831__$1;
(statearr_14840_14907[(2)] = inst_14740);

(statearr_14840_14907[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (21))){
var state_14831__$1 = state_14831;
var statearr_14841_14908 = state_14831__$1;
(statearr_14841_14908[(2)] = null);

(statearr_14841_14908[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (31))){
var inst_14766 = (state_14831[(10)]);
var inst_14804 = (state_14831[(2)]);
var inst_14805 = cljs.core._EQ_.call(null,inst_14766,new cljs.core.Keyword(null,"table","table",-564943036));
var state_14831__$1 = (function (){var statearr_14842 = state_14831;
(statearr_14842[(11)] = inst_14804);

return statearr_14842;
})();
if(inst_14805){
var statearr_14843_14909 = state_14831__$1;
(statearr_14843_14909[(1)] = (32));

} else {
var statearr_14844_14910 = state_14831__$1;
(statearr_14844_14910[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (32))){
var inst_14771 = (state_14831[(12)]);
var inst_14762 = (state_14831[(8)]);
var inst_14761 = (state_14831[(13)]);
var inst_14740 = (state_14831[(7)]);
var inst_14770 = (state_14831[(9)]);
var inst_14760 = (state_14831[(14)]);
var inst_14765 = (state_14831[(15)]);
var inst_14763 = (state_14831[(16)]);
var inst_14764 = (state_14831[(17)]);
var inst_14766 = (state_14831[(10)]);
var inst_14818 = cljs.core.async.chan.call(null,(1));
var inst_14819 = (function (){var new_columns = inst_14765;
var submission_clicked = inst_14762;
var submission_unclicked = inst_14763;
var get_submission_data = inst_14771;
var c__8400__auto____$1 = inst_14818;
var map__14738 = inst_14760;
var re_render = inst_14766;
var update_data_BANG_ = inst_14770;
var submission_to_rank = inst_14761;
var e = inst_14740;
var filter_by = inst_14764;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,c__8400__auto____$1,map__14738,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_14771,inst_14762,inst_14761,inst_14740,inst_14770,inst_14760,inst_14765,inst_14763,inst_14764,inst_14766,inst_14818,state_val_14832,c__8400__auto__,event_chan){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,c__8400__auto____$1,map__14738,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_14771,inst_14762,inst_14761,inst_14740,inst_14770,inst_14760,inst_14765,inst_14763,inst_14764,inst_14766,inst_14818,state_val_14832,c__8400__auto__,event_chan){
return (function (state_14816){
var state_val_14817 = (state_14816[(1)]);
if((state_val_14817 === (1))){
var inst_14807 = cljs.core.async.timeout.call(null,(20));
var state_14816__$1 = state_14816;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14816__$1,(2),inst_14807);
} else {
if((state_val_14817 === (2))){
var inst_14809 = (state_14816[(2)]);
var inst_14810 = grid.resizeCanvas();
var inst_14811 = grid.invalidateAllRows();
var inst_14812 = hatti.views.table.resizeColumns.call(null,grid);
var inst_14813 = grid.render();
var inst_14814 = hatti.views.table.init_sg_pager.call(null,grid,dataview);
var state_14816__$1 = (function (){var statearr_14845 = state_14816;
(statearr_14845[(7)] = inst_14813);

(statearr_14845[(8)] = inst_14809);

(statearr_14845[(9)] = inst_14812);

(statearr_14845[(10)] = inst_14810);

(statearr_14845[(11)] = inst_14811);

return statearr_14845;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14816__$1,inst_14814);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,c__8400__auto____$1,map__14738,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_14771,inst_14762,inst_14761,inst_14740,inst_14770,inst_14760,inst_14765,inst_14763,inst_14764,inst_14766,inst_14818,state_val_14832,c__8400__auto__,event_chan))
;
return ((function (switch__8335__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,c__8400__auto____$1,map__14738,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_14771,inst_14762,inst_14761,inst_14740,inst_14770,inst_14760,inst_14765,inst_14763,inst_14764,inst_14766,inst_14818,state_val_14832,c__8400__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__8336__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__8336__auto____0 = (function (){
var statearr_14849 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14849[(0)] = hatti$views$table$handle_table_events_$_state_machine__8336__auto__);

(statearr_14849[(1)] = (1));

return statearr_14849;
});
var hatti$views$table$handle_table_events_$_state_machine__8336__auto____1 = (function (state_14816){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_14816);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e14850){if((e14850 instanceof Object)){
var ex__8339__auto__ = e14850;
var statearr_14851_14911 = state_14816;
(statearr_14851_14911[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14816);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14850;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14912 = state_14816;
state_14816 = G__14912;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__8336__auto__ = function(state_14816){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__8336__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__8336__auto____1.call(this,state_14816);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__8336__auto____0;
hatti$views$table$handle_table_events_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__8336__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,c__8400__auto____$1,map__14738,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_14771,inst_14762,inst_14761,inst_14740,inst_14770,inst_14760,inst_14765,inst_14763,inst_14764,inst_14766,inst_14818,state_val_14832,c__8400__auto__,event_chan))
})();
var state__8402__auto__ = (function (){var statearr_14852 = f__8401__auto__.call(null);
(statearr_14852[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto____$1);

return statearr_14852;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,c__8400__auto____$1,map__14738,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_14771,inst_14762,inst_14761,inst_14740,inst_14770,inst_14760,inst_14765,inst_14763,inst_14764,inst_14766,inst_14818,state_val_14832,c__8400__auto__,event_chan))
})();
var inst_14820 = cljs.core.async.impl.dispatch.run.call(null,inst_14819);
var state_14831__$1 = (function (){var statearr_14853 = state_14831;
(statearr_14853[(18)] = inst_14820);

return statearr_14853;
})();
var statearr_14854_14913 = state_14831__$1;
(statearr_14854_14913[(2)] = inst_14818);

(statearr_14854_14913[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (33))){
var state_14831__$1 = state_14831;
var statearr_14855_14914 = state_14831__$1;
(statearr_14855_14914[(2)] = null);

(statearr_14855_14914[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (13))){
var inst_14752 = (state_14831[(2)]);
var state_14831__$1 = state_14831;
var statearr_14856_14915 = state_14831__$1;
(statearr_14856_14915[(2)] = inst_14752);

(statearr_14856_14915[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (22))){
var inst_14763 = (state_14831[(16)]);
var inst_14782 = (state_14831[(2)]);
var state_14831__$1 = (function (){var statearr_14857 = state_14831;
(statearr_14857[(19)] = inst_14782);

return statearr_14857;
})();
if(cljs.core.truth_(inst_14763)){
var statearr_14858_14916 = state_14831__$1;
(statearr_14858_14916[(1)] = (23));

} else {
var statearr_14859_14917 = state_14831__$1;
(statearr_14859_14917[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (29))){
var inst_14764 = (state_14831[(17)]);
var inst_14796 = [new cljs.core.Keyword(null,"query","query",-1288509510)];
var inst_14797 = [inst_14764];
var inst_14798 = cljs.core.PersistentHashMap.fromArrays(inst_14796,inst_14797);
var inst_14799 = cljs.core.clj__GT_js.call(null,inst_14798);
var inst_14800 = dataview.setFilterArgs(inst_14799);
var inst_14801 = dataview.refresh();
var state_14831__$1 = (function (){var statearr_14860 = state_14831;
(statearr_14860[(20)] = inst_14800);

return statearr_14860;
})();
var statearr_14861_14918 = state_14831__$1;
(statearr_14861_14918[(2)] = inst_14801);

(statearr_14861_14918[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (6))){
var inst_14827 = (state_14831[(2)]);
var state_14831__$1 = state_14831;
var statearr_14862_14919 = state_14831__$1;
(statearr_14862_14919[(2)] = inst_14827);

(statearr_14862_14919[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (28))){
var inst_14764 = (state_14831[(17)]);
var inst_14794 = (state_14831[(2)]);
var state_14831__$1 = (function (){var statearr_14863 = state_14831;
(statearr_14863[(21)] = inst_14794);

return statearr_14863;
})();
if(cljs.core.truth_(inst_14764)){
var statearr_14864_14920 = state_14831__$1;
(statearr_14864_14920[(1)] = (29));

} else {
var statearr_14865_14921 = state_14831__$1;
(statearr_14865_14921[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (25))){
var inst_14765 = (state_14831[(15)]);
var inst_14787 = (state_14831[(2)]);
var state_14831__$1 = (function (){var statearr_14866 = state_14831;
(statearr_14866[(22)] = inst_14787);

return statearr_14866;
})();
if(cljs.core.truth_(inst_14765)){
var statearr_14867_14922 = state_14831__$1;
(statearr_14867_14922[(1)] = (26));

} else {
var statearr_14868_14923 = state_14831__$1;
(statearr_14868_14923[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (34))){
var inst_14823 = (state_14831[(2)]);
var state_14831__$1 = (function (){var statearr_14869 = state_14831;
(statearr_14869[(23)] = inst_14823);

return statearr_14869;
})();
var statearr_14870_14924 = state_14831__$1;
(statearr_14870_14924[(2)] = null);

(statearr_14870_14924[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (17))){
var inst_14771 = (state_14831[(12)]);
var inst_14761 = (state_14831[(13)]);
var inst_14770 = (state_14831[(9)]);
var inst_14773 = inst_14771.call(null,hatti.constants._rank,inst_14761);
var inst_14774 = inst_14770.call(null,inst_14773);
var state_14831__$1 = state_14831;
var statearr_14871_14925 = state_14831__$1;
(statearr_14871_14925[(2)] = inst_14774);

(statearr_14871_14925[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (3))){
var inst_14829 = (state_14831[(2)]);
var state_14831__$1 = state_14831;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14831__$1,inst_14829);
} else {
if((state_val_14832 === (12))){
var state_14831__$1 = state_14831;
var statearr_14872_14926 = state_14831__$1;
(statearr_14872_14926[(2)] = false);

(statearr_14872_14926[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (2))){
var state_14831__$1 = state_14831;
var statearr_14873_14927 = state_14831__$1;
(statearr_14873_14927[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (23))){
var inst_14770 = (state_14831[(9)]);
var inst_14784 = inst_14770.call(null,null);
var state_14831__$1 = state_14831;
var statearr_14875_14928 = state_14831__$1;
(statearr_14875_14928[(2)] = inst_14784);

(statearr_14875_14928[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (19))){
var inst_14762 = (state_14831[(8)]);
var inst_14777 = (state_14831[(2)]);
var state_14831__$1 = (function (){var statearr_14876 = state_14831;
(statearr_14876[(24)] = inst_14777);

return statearr_14876;
})();
if(cljs.core.truth_(inst_14762)){
var statearr_14877_14929 = state_14831__$1;
(statearr_14877_14929[(1)] = (20));

} else {
var statearr_14878_14930 = state_14831__$1;
(statearr_14878_14930[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (11))){
var state_14831__$1 = state_14831;
var statearr_14879_14931 = state_14831__$1;
(statearr_14879_14931[(2)] = true);

(statearr_14879_14931[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (9))){
var state_14831__$1 = state_14831;
var statearr_14880_14932 = state_14831__$1;
(statearr_14880_14932[(2)] = false);

(statearr_14880_14932[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (5))){
var state_14831__$1 = state_14831;
var statearr_14881_14933 = state_14831__$1;
(statearr_14881_14933[(2)] = null);

(statearr_14881_14933[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (14))){
var inst_14740 = (state_14831[(7)]);
var inst_14757 = cljs.core.apply.call(null,cljs.core.hash_map,inst_14740);
var state_14831__$1 = state_14831;
var statearr_14882_14934 = state_14831__$1;
(statearr_14882_14934[(2)] = inst_14757);

(statearr_14882_14934[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (26))){
var inst_14765 = (state_14831[(15)]);
var inst_14789 = grid.setColumns(inst_14765);
var inst_14790 = hatti.views.table.resizeColumns.call(null,grid);
var inst_14791 = grid.render();
var state_14831__$1 = (function (){var statearr_14883 = state_14831;
(statearr_14883[(25)] = inst_14789);

(statearr_14883[(26)] = inst_14790);

return statearr_14883;
})();
var statearr_14884_14935 = state_14831__$1;
(statearr_14884_14935[(2)] = inst_14791);

(statearr_14884_14935[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (16))){
var inst_14762 = (state_14831[(8)]);
var inst_14761 = (state_14831[(13)]);
var inst_14740 = (state_14831[(7)]);
var inst_14770 = (state_14831[(9)]);
var inst_14760 = (state_14831[(14)]);
var inst_14765 = (state_14831[(15)]);
var inst_14763 = (state_14831[(16)]);
var inst_14764 = (state_14831[(17)]);
var inst_14766 = (state_14831[(10)]);
var inst_14760__$1 = (state_14831[(2)]);
var inst_14761__$1 = cljs.core.get.call(null,inst_14760__$1,new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797));
var inst_14762__$1 = cljs.core.get.call(null,inst_14760__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var inst_14763__$1 = cljs.core.get.call(null,inst_14760__$1,new cljs.core.Keyword(null,"submission-unclicked","submission-unclicked",-2099539520));
var inst_14764__$1 = cljs.core.get.call(null,inst_14760__$1,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
var inst_14765__$1 = cljs.core.get.call(null,inst_14760__$1,new cljs.core.Keyword(null,"new-columns","new-columns",-887765797));
var inst_14766__$1 = cljs.core.get.call(null,inst_14760__$1,new cljs.core.Keyword(null,"re-render","re-render",1133553258));
var inst_14767 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14768 = [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.Keyword(null,"data","data",-232669377)];
var inst_14769 = (new cljs.core.PersistentVector(null,3,(5),inst_14767,inst_14768,null));
var inst_14770__$1 = cljs.core.partial.call(null,om.core.update_BANG_,app_state,inst_14769);
var inst_14771 = (function (){var e = inst_14740;
var map__14738 = inst_14760__$1;
var submission_to_rank = inst_14761__$1;
var submission_clicked = inst_14762__$1;
var submission_unclicked = inst_14763__$1;
var filter_by = inst_14764__$1;
var new_columns = inst_14765__$1;
var re_render = inst_14766__$1;
var update_data_BANG_ = inst_14770__$1;
return ((function (e,map__14738,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_14762,inst_14761,inst_14740,inst_14770,inst_14760,inst_14765,inst_14763,inst_14764,inst_14766,inst_14760__$1,inst_14761__$1,inst_14762__$1,inst_14763__$1,inst_14764__$1,inst_14765__$1,inst_14766__$1,inst_14767,inst_14768,inst_14769,inst_14770__$1,state_val_14832,c__8400__auto__,event_chan){
return (function (field,value){
return cljs.core.first.call(null,cljs.core.filter.call(null,((function (e,map__14738,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_14762,inst_14761,inst_14740,inst_14770,inst_14760,inst_14765,inst_14763,inst_14764,inst_14766,inst_14760__$1,inst_14761__$1,inst_14762__$1,inst_14763__$1,inst_14764__$1,inst_14765__$1,inst_14766__$1,inst_14767,inst_14768,inst_14769,inst_14770__$1,state_val_14832,c__8400__auto__,event_chan){
return (function (p1__14570_SHARP_){
return cljs.core._EQ_.call(null,value,cljs.core.get.call(null,p1__14570_SHARP_,field));
});})(e,map__14738,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_14762,inst_14761,inst_14740,inst_14770,inst_14760,inst_14765,inst_14763,inst_14764,inst_14766,inst_14760__$1,inst_14761__$1,inst_14762__$1,inst_14763__$1,inst_14764__$1,inst_14765__$1,inst_14766__$1,inst_14767,inst_14768,inst_14769,inst_14770__$1,state_val_14832,c__8400__auto__,event_chan))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,app_state),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null))));
});
;})(e,map__14738,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_14762,inst_14761,inst_14740,inst_14770,inst_14760,inst_14765,inst_14763,inst_14764,inst_14766,inst_14760__$1,inst_14761__$1,inst_14762__$1,inst_14763__$1,inst_14764__$1,inst_14765__$1,inst_14766__$1,inst_14767,inst_14768,inst_14769,inst_14770__$1,state_val_14832,c__8400__auto__,event_chan))
})();
var state_14831__$1 = (function (){var statearr_14885 = state_14831;
(statearr_14885[(12)] = inst_14771);

(statearr_14885[(8)] = inst_14762__$1);

(statearr_14885[(13)] = inst_14761__$1);

(statearr_14885[(9)] = inst_14770__$1);

(statearr_14885[(14)] = inst_14760__$1);

(statearr_14885[(15)] = inst_14765__$1);

(statearr_14885[(16)] = inst_14763__$1);

(statearr_14885[(17)] = inst_14764__$1);

(statearr_14885[(10)] = inst_14766__$1);

return statearr_14885;
})();
if(cljs.core.truth_(inst_14761__$1)){
var statearr_14886_14936 = state_14831__$1;
(statearr_14886_14936[(1)] = (17));

} else {
var statearr_14887_14937 = state_14831__$1;
(statearr_14887_14937[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (30))){
var state_14831__$1 = state_14831;
var statearr_14888_14938 = state_14831__$1;
(statearr_14888_14938[(2)] = null);

(statearr_14888_14938[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (10))){
var inst_14755 = (state_14831[(2)]);
var state_14831__$1 = state_14831;
if(cljs.core.truth_(inst_14755)){
var statearr_14889_14939 = state_14831__$1;
(statearr_14889_14939[(1)] = (14));

} else {
var statearr_14890_14940 = state_14831__$1;
(statearr_14890_14940[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (18))){
var state_14831__$1 = state_14831;
var statearr_14891_14941 = state_14831__$1;
(statearr_14891_14941[(2)] = null);

(statearr_14891_14941[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14832 === (8))){
var inst_14740 = (state_14831[(7)]);
var inst_14745 = inst_14740.cljs$lang$protocol_mask$partition0$;
var inst_14746 = (inst_14745 & (64));
var inst_14747 = inst_14740.cljs$core$ISeq$;
var inst_14748 = (inst_14746) || (inst_14747);
var state_14831__$1 = state_14831;
if(cljs.core.truth_(inst_14748)){
var statearr_14892_14942 = state_14831__$1;
(statearr_14892_14942[(1)] = (11));

} else {
var statearr_14893_14943 = state_14831__$1;
(statearr_14893_14943[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto__,event_chan))
;
return ((function (switch__8335__auto__,c__8400__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__8336__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__8336__auto____0 = (function (){
var statearr_14897 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14897[(0)] = hatti$views$table$handle_table_events_$_state_machine__8336__auto__);

(statearr_14897[(1)] = (1));

return statearr_14897;
});
var hatti$views$table$handle_table_events_$_state_machine__8336__auto____1 = (function (state_14831){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_14831);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e14898){if((e14898 instanceof Object)){
var ex__8339__auto__ = e14898;
var statearr_14899_14944 = state_14831;
(statearr_14899_14944[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14831);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14898;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14945 = state_14831;
state_14831 = G__14945;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__8336__auto__ = function(state_14831){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__8336__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__8336__auto____1.call(this,state_14831);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__8336__auto____0;
hatti$views$table$handle_table_events_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__8336__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto__,event_chan))
})();
var state__8402__auto__ = (function (){var statearr_14900 = f__8401__auto__.call(null);
(statearr_14900[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto__);

return statearr_14900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});})(c__8400__auto__,event_chan))
);

return c__8400__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),k);

return colset_BANG_.call(null,k);
});
var iter__5341__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__14954(s__14955){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__14955__$1 = s__14955;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__14955__$1);
if(temp__4425__auto__){
var s__14955__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__14955__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__14955__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__14957 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__14956 = (0);
while(true){
if((i__14956 < size__5340__auto__)){
var vec__14960 = cljs.core._nth.call(null,c__5339__auto__,i__14956);
var k = cljs.core.nth.call(null,vec__14960,(0),null);
var v = cljs.core.nth.call(null,vec__14960,(1),null);
cljs.core.chunk_append.call(null,b__14957,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (i__14956,vec__14960,k,v,c__5339__auto__,size__5340__auto__,b__14957,s__14955__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(i__14956,vec__14960,k,v,c__5339__auto__,size__5340__auto__,b__14957,s__14955__$2,temp__4425__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null));

var G__14962 = (i__14956 + (1));
i__14956 = G__14962;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14957),hatti$views$table$render_options_$_iter__14954.call(null,cljs.core.chunk_rest.call(null,s__14955__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14957),null);
}
} else {
var vec__14961 = cljs.core.first.call(null,s__14955__$2);
var k = cljs.core.nth.call(null,vec__14961,(0),null);
var v = cljs.core.nth.call(null,vec__14961,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (vec__14961,k,v,s__14955__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(vec__14961,k,v,s__14955__$2,temp__4425__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__14954.call(null,cljs.core.rest.call(null,s__14955__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__5341__auto__.call(null,options);
});
cljs.core._add_method.call(null,hatti.views.label_changer,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table14964 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table14964 = (function (_,owner,meta14965){
this._ = _;
this.owner = owner;
this.meta14965 = meta14965;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table14964.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14966,meta14965__$1){
var self__ = this;
var _14966__$1 = this;
return (new hatti.views.table.t_hatti$views$table14964(self__._,self__.owner,meta14965__$1));
});

hatti.views.table.t_hatti$views$table14964.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14966){
var self__ = this;
var _14966__$1 = this;
return self__.meta14965;
});

hatti.views.table.t_hatti$views$table14964.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table14964.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),new cljs.core.Keyword(null,"label","label",1718410804)], null);
});

hatti.views.table.t_hatti$views$table14964.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table14964.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__14967){
var self__ = this;
var map__14968 = p__14967;
var map__14968__$1 = ((((!((map__14968 == null)))?((((map__14968.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14968.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14968):map__14968);
var name_or_label = cljs.core.get.call(null,map__14968__$1,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208));
var language = cljs.core.get.call(null,map__14968__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Label"], null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Name"], null)], null);
var map__14970 = om.core.get_shared.call(null,self__.owner);
var map__14970__$1 = ((((!((map__14970 == null)))?((((map__14970.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14970.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14970):map__14970);
var flat_form = cljs.core.get.call(null,map__14970__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var new_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null)));
var colset_BANG_ = ((function (options,map__14970,map__14970__$1,flat_form,new_language,___$2,map__14968,map__14968__$1,name_or_label,language){
return (function (p1__14963_SHARP_){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-columns","new-columns",-887765797),hatti.views.table.flat_form__GT_sg_columns.call(null,flat_form,cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"label","label",1718410804),p1__14963_SHARP_),new_language)], null));
});})(options,map__14970,map__14970__$1,flat_form,new_language,___$2,map__14968,map__14968__$1,name_or_label,language))
;
if(cljs.core.not_EQ_.call(null,new_language,language)){
om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"language","language",-1591107564),new_language);

colset_BANG_.call(null,name_or_label);
} else {
}

return React.DOM.div({"className": "label-changer"},React.DOM.span({"className": "label-changer-label"},"Show:"),React.DOM.div({"id": "header-display-dropdown", "className": "drop-hover"},(function (){var attrs14974 = options.call(null,name_or_label);
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs14974))?sablono.interpreter.attributes.call(null,attrs14974):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs14974))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [React.DOM.i({"className": "fa fa-angle-down"})], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs14974),React.DOM.i({"className": "fa fa-angle-down"})], null))));
})(),React.DOM.ul({"className": "submenu no-dot"},sablono.interpreter.interpret.call(null,hatti.views.table.render_options.call(null,options,self__.owner,colset_BANG_)))));
});

hatti.views.table.t_hatti$views$table14964.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta14965","meta14965",657663712,null)], null);
});

hatti.views.table.t_hatti$views$table14964.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table14964.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table14964";

hatti.views.table.t_hatti$views$table14964.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table14964");
});

hatti.views.table.__GT_t_hatti$views$table14964 = (function hatti$views$table$__GT_t_hatti$views$table14964(___$1,owner__$1,meta14965){
return (new hatti.views.table.t_hatti$views$table14964(___$1,owner__$1,meta14965));
});

}

return (new hatti.views.table.t_hatti$views$table14964(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__8400__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8400__auto__,query){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto__,query){
return (function (state_15021){
var state_val_15022 = (state_15021[(1)]);
if((state_val_15022 === (1))){
var inst_15007 = cljs.core.async.timeout.call(null,(150));
var state_15021__$1 = state_15021;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15021__$1,(2),inst_15007);
} else {
if((state_val_15022 === (2))){
var inst_15009 = (state_15021[(2)]);
var inst_15010 = input.value;
var inst_15011 = cljs.core._EQ_.call(null,query,inst_15010);
var state_15021__$1 = (function (){var statearr_15023 = state_15021;
(statearr_15023[(7)] = inst_15009);

return statearr_15023;
})();
if(inst_15011){
var statearr_15024_15035 = state_15021__$1;
(statearr_15024_15035[(1)] = (3));

} else {
var statearr_15025_15036 = state_15021__$1;
(statearr_15025_15036[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15022 === (3))){
var inst_15013 = [query_event_key];
var inst_15014 = [query];
var inst_15015 = cljs.core.PersistentHashMap.fromArrays(inst_15013,inst_15014);
var inst_15016 = cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,inst_15015);
var state_15021__$1 = state_15021;
var statearr_15026_15037 = state_15021__$1;
(statearr_15026_15037[(2)] = inst_15016);

(statearr_15026_15037[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15022 === (4))){
var state_15021__$1 = state_15021;
var statearr_15027_15038 = state_15021__$1;
(statearr_15027_15038[(2)] = null);

(statearr_15027_15038[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15022 === (5))){
var inst_15019 = (state_15021[(2)]);
var state_15021__$1 = state_15021;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15021__$1,inst_15019);
} else {
return null;
}
}
}
}
}
});})(c__8400__auto__,query))
;
return ((function (switch__8335__auto__,c__8400__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__8336__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__8336__auto____0 = (function (){
var statearr_15031 = [null,null,null,null,null,null,null,null];
(statearr_15031[(0)] = hatti$views$table$delayed_search_$_state_machine__8336__auto__);

(statearr_15031[(1)] = (1));

return statearr_15031;
});
var hatti$views$table$delayed_search_$_state_machine__8336__auto____1 = (function (state_15021){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_15021);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e15032){if((e15032 instanceof Object)){
var ex__8339__auto__ = e15032;
var statearr_15033_15039 = state_15021;
(statearr_15033_15039[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15021);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15032;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15040 = state_15021;
state_15021 = G__15040;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__8336__auto__ = function(state_15021){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__8336__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__8336__auto____1.call(this,state_15021);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__8336__auto____0;
hatti$views$table$delayed_search_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__8336__auto____1;
return hatti$views$table$delayed_search_$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto__,query))
})();
var state__8402__auto__ = (function (){var statearr_15034 = f__8401__auto__.call(null);
(statearr_15034[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto__);

return statearr_15034;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});})(c__8400__auto__,query))
);

return c__8400__auto__;
});
cljs.core._add_method.call(null,hatti.views.table_search,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table15042 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table15042 = (function (_,owner,meta15043){
this._ = _;
this.owner = owner;
this.meta15043 = meta15043;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table15042.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15044,meta15043__$1){
var self__ = this;
var _15044__$1 = this;
return (new hatti.views.table.t_hatti$views$table15042(self__._,self__.owner,meta15043__$1));
});

hatti.views.table.t_hatti$views$table15042.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15044){
var self__ = this;
var _15044__$1 = this;
return self__.meta15043;
});

hatti.views.table.t_hatti$views$table15042.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table15042.prototype.om$core$IRender$render$arity$1 = (function (this__6567__auto__){
var self__ = this;
var this__6567__auto____$1 = this;
return React.DOM.div({"className": "table-search"},React.DOM.i({"className": "fa fa-search"}),sablono.interpreter.input.call(null,{"type": "text", "placeholder": "Search", "onChange": ((function (this__6567__auto____$1){
return (function (p1__15041_SHARP_){
return hatti.views.table.delayed_search.call(null,p1__15041_SHARP_.target,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
});})(this__6567__auto____$1))
}));
});

hatti.views.table.t_hatti$views$table15042.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta15043","meta15043",273372784,null)], null);
});

hatti.views.table.t_hatti$views$table15042.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table15042.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table15042";

hatti.views.table.t_hatti$views$table15042.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table15042");
});

hatti.views.table.__GT_t_hatti$views$table15042 = (function hatti$views$table$__GT_t_hatti$views$table15042(___$1,owner__$1,meta15043){
return (new hatti.views.table.t_hatti$views$table15042(___$1,owner__$1,meta15043));
});

}

return (new hatti.views.table.t_hatti$views$table15042(_,owner,null));
}));
cljs.core._add_method.call(null,hatti.views.table_header,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app_state,owner){
if(typeof hatti.views.table.t_hatti$views$table15047 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table15047 = (function (app_state,owner,meta15048){
this.app_state = app_state;
this.owner = owner;
this.meta15048 = meta15048;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table15047.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15049,meta15048__$1){
var self__ = this;
var _15049__$1 = this;
return (new hatti.views.table.t_hatti$views$table15047(self__.app_state,self__.owner,meta15048__$1));
});

hatti.views.table.t_hatti$views$table15047.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15049){
var self__ = this;
var _15049__$1 = this;
return self__.meta15048;
});

hatti.views.table.t_hatti$views$table15047.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table15047.prototype.om$core$IRender$render$arity$1 = (function (this__6567__auto__){
var self__ = this;
var this__6567__auto____$1 = this;
return React.DOM.div({"className": "topbar"},React.DOM.div({"id": hatti.views.table.pager_id}),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.label_changer,null)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_search,self__.app_state)),React.DOM.div({"style": {"clear": "both"}}));
});

hatti.views.table.t_hatti$views$table15047.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta15048","meta15048",-609530354,null)], null);
});

hatti.views.table.t_hatti$views$table15047.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table15047.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table15047";

hatti.views.table.t_hatti$views$table15047.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table15047");
});

hatti.views.table.__GT_t_hatti$views$table15047 = (function hatti$views$table$__GT_t_hatti$views$table15047(app_state__$1,owner__$1,meta15048){
return (new hatti.views.table.t_hatti$views$table15047(app_state__$1,owner__$1,meta15048));
});

}

return (new hatti.views.table.t_hatti$views$table15047(app_state,owner,null));
}));
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){

if(cljs.core.seq.call(null,data)){
var map__15055 = om.core.get_shared.call(null,owner);
var map__15055__$1 = ((((!((map__15055 == null)))?((((map__15055.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15055.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15055):map__15055);
var flat_form = cljs.core.get.call(null,map__15055__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__15055__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
var current_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,owner,hatti.shared.language_cursor.call(null)));
var vec__15056 = hatti.views.table.sg_init.call(null,data,flat_form,current_language,is_filtered_dataview_QMARK_,slick_grid_event_handlers);
var grid = cljs.core.nth.call(null,vec__15056,(0),null);
var dataview = cljs.core.nth.call(null,vec__15056,(1),null);
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"grid","grid",402978600),grid);

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"dataview","dataview",91765671),dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
cljs.core._add_method.call(null,hatti.views.table_page,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app_state,owner,p__15059){
var map__15060 = p__15059;
var map__15060__$1 = ((((!((map__15060 == null)))?((((map__15060.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15060.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15060):map__15060);
var opts = map__15060__$1;
var slick_grid_event_handlers = cljs.core.get.call(null,map__15060__$1,new cljs.core.Keyword(null,"slick-grid-event-handlers","slick-grid-event-handlers",1990034724));

if(typeof hatti.views.table.t_hatti$views$table15062 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table15062 = (function (app_state,owner,p__15059,map__15060,opts,slick_grid_event_handlers,meta15063){
this.app_state = app_state;
this.owner = owner;
this.p__15059 = p__15059;
this.map__15060 = map__15060;
this.opts = opts;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.meta15063 = meta15063;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table15062.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__15060,map__15060__$1,opts,slick_grid_event_handlers){
return (function (_15064,meta15063__$1){
var self__ = this;
var _15064__$1 = this;
return (new hatti.views.table.t_hatti$views$table15062(self__.app_state,self__.owner,self__.p__15059,self__.map__15060,self__.opts,self__.slick_grid_event_handlers,meta15063__$1));
});})(map__15060,map__15060__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table15062.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__15060,map__15060__$1,opts,slick_grid_event_handlers){
return (function (_15064){
var self__ = this;
var _15064__$1 = this;
return self__.meta15063;
});})(map__15060,map__15060__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table15062.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table15062.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__15060,map__15060__$1,opts,slick_grid_event_handlers){
return (function (_,___$1){
var self__ = this;
var ___$2 = this;
var no_data_QMARK_ = cljs.core.empty_QMARK_.call(null,cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null)));
var map__15065 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(self__.app_state);
var map__15065__$1 = ((((!((map__15065 == null)))?((((map__15065.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15065.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15065):map__15065);
var dataset_info = map__15065__$1;
var num_of_submissions = cljs.core.get.call(null,map__15065__$1,new cljs.core.Keyword(null,"num_of_submissions","num_of_submissions",-1720943091));
var with_info = ((function (no_data_QMARK_,map__15065,map__15065__$1,dataset_info,num_of_submissions,___$2,map__15060,map__15060__$1,opts,slick_grid_event_handlers){
return (function (p1__15058_SHARP_){
return cljs.core.merge.call(null,p1__15058_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),dataset_info], null));
});})(no_data_QMARK_,map__15065,map__15065__$1,dataset_info,num_of_submissions,___$2,map__15060,map__15060__$1,opts,slick_grid_event_handlers))
;
var attrs15067 = om.core.build.call(null,hatti.views.submission_view,with_info.call(null,cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855)], null))),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge.call(null,cljs.core.select_keys.call(null,self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"role","role",-736691072),null,new cljs.core.Keyword(null,"delete-record!","delete-record!",1411848194),null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"table","table",-564943036)], null))], null));
return cljs.core.apply.call(null,React.DOM.div,((cljs.core.map_QMARK_.call(null,attrs15067))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["table-view"], null)], null),attrs15067)):{"className": "table-view"}),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs15067))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.app_state)),React.DOM.div({"id": hatti.views.table.table_id, "className": "slickgrid"},(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.span({"className": "empty-state"},"No data"):React.DOM.span(null,React.DOM.i({"className": "fa fa-spinner fa-pulse"}),"Loading...")))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs15067),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.app_state)),React.DOM.div({"id": hatti.views.table.table_id, "className": "slickgrid"},(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.span({"className": "empty-state"},"No data"):React.DOM.span(null,React.DOM.i({"className": "fa fa-spinner fa-pulse"}),"Loading...")))], null))));
});})(map__15060,map__15060__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table15062.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table15062.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (map__15060,map__15060__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
var data = cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_.call(null,data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__15076 = temp__4425__auto__;
var grid = cljs.core.nth.call(null,vec__15076,(0),null);
var dataview = cljs.core.nth.call(null,vec__15076,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.app_state,grid,dataview);
} else {
return null;
}
});})(map__15060,map__15060__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table15062.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table15062.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (map__15060,map__15060__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

var old_data = cljs.core.get_in.call(null,om.core.get_props.call(null,self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var new_data = cljs.core.get_in.call(null,next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var map__15077 = om.core.get_state.call(null,self__.owner);
var map__15077__$1 = ((((!((map__15077 == null)))?((((map__15077.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15077.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15077):map__15077);
var grid = cljs.core.get.call(null,map__15077__$1,new cljs.core.Keyword(null,"grid","grid",402978600));
var dataview = cljs.core.get.call(null,map__15077__$1,new cljs.core.Keyword(null,"dataview","dataview",91765671));
if(cljs.core.not_EQ_.call(null,old_data,new_data)){
if(cljs.core.empty_QMARK_.call(null,old_data)){
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_.call(null,new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__15079 = temp__4425__auto__;
var grid__$1 = cljs.core.nth.call(null,vec__15079,(0),null);
var dataview__$1 = cljs.core.nth.call(null,vec__15079,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.app_state,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js.call(null,new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
});})(map__15060,map__15060__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table15062.getBasis = ((function (map__15060,map__15060__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__15059","p__15059",-2036470839,null),new cljs.core.Symbol(null,"map__15060","map__15060",1737334017,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"slick-grid-event-handlers","slick-grid-event-handlers",-664401045,null),new cljs.core.Symbol(null,"meta15063","meta15063",1142110048,null)], null);
});})(map__15060,map__15060__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table15062.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table15062.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table15062";

hatti.views.table.t_hatti$views$table15062.cljs$lang$ctorPrWriter = ((function (map__15060,map__15060__$1,opts,slick_grid_event_handlers){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table15062");
});})(map__15060,map__15060__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table15062 = ((function (map__15060,map__15060__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table15062(app_state__$1,owner__$1,p__15059__$1,map__15060__$2,opts__$1,slick_grid_event_handlers__$1,meta15063){
return (new hatti.views.table.t_hatti$views$table15062(app_state__$1,owner__$1,p__15059__$1,map__15060__$2,opts__$1,slick_grid_event_handlers__$1,meta15063));
});})(map__15060,map__15060__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table15062(app_state,owner,p__15059,map__15060__$1,opts,slick_grid_event_handlers,cljs.core.PersistentArrayMap.EMPTY));
}));
