// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__8400__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8400__auto__){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto__){
return (function (state_11748){
var state_val_11749 = (state_11748[(1)]);
if((state_val_11749 === (7))){
var inst_11705 = (state_11748[(7)]);
var inst_11705__$1 = (state_11748[(2)]);
var inst_11707 = (inst_11705__$1 == null);
var inst_11708 = cljs.core.not.call(null,inst_11707);
var state_11748__$1 = (function (){var statearr_11750 = state_11748;
(statearr_11750[(7)] = inst_11705__$1);

return statearr_11750;
})();
if(inst_11708){
var statearr_11751_11788 = state_11748__$1;
(statearr_11751_11788[(1)] = (8));

} else {
var statearr_11752_11789 = state_11748__$1;
(statearr_11752_11789[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11749 === (20))){
var inst_11727 = (state_11748[(8)]);
var inst_11735 = (state_11748[(2)]);
var state_11748__$1 = (function (){var statearr_11753 = state_11748;
(statearr_11753[(9)] = inst_11735);

return statearr_11753;
})();
if(cljs.core.truth_(inst_11727)){
var statearr_11754_11790 = state_11748__$1;
(statearr_11754_11790[(1)] = (21));

} else {
var statearr_11755_11791 = state_11748__$1;
(statearr_11755_11791[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11749 === (1))){
var state_11748__$1 = state_11748;
var statearr_11756_11792 = state_11748__$1;
(statearr_11756_11792[(2)] = null);

(statearr_11756_11792[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11749 === (4))){
var state_11748__$1 = state_11748;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11748__$1,(7),agg_data_channel);
} else {
if((state_val_11749 === (15))){
var inst_11705 = (state_11748[(7)]);
var state_11748__$1 = state_11748;
var statearr_11757_11793 = state_11748__$1;
(statearr_11757_11793[(2)] = inst_11705);

(statearr_11757_11793[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11749 === (21))){
var inst_11737 = cljs.core.async.close_BANG_.call(null,agg_data_channel);
var state_11748__$1 = state_11748;
var statearr_11758_11794 = state_11748__$1;
(statearr_11758_11794[(2)] = inst_11737);

(statearr_11758_11794[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11749 === (13))){
var inst_11717 = (state_11748[(2)]);
var state_11748__$1 = state_11748;
var statearr_11759_11795 = state_11748__$1;
(statearr_11759_11795[(2)] = inst_11717);

(statearr_11759_11795[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11749 === (22))){
var state_11748__$1 = state_11748;
var statearr_11760_11796 = state_11748__$1;
(statearr_11760_11796[(2)] = null);

(statearr_11760_11796[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11749 === (6))){
var inst_11744 = (state_11748[(2)]);
var state_11748__$1 = state_11748;
var statearr_11761_11797 = state_11748__$1;
(statearr_11761_11797[(2)] = inst_11744);

(statearr_11761_11797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11749 === (17))){
var inst_11726 = (state_11748[(10)]);
var inst_11727 = (state_11748[(8)]);
var inst_11729 = callback.call(null,inst_11726,inst_11727);
var state_11748__$1 = state_11748;
var statearr_11762_11798 = state_11748__$1;
(statearr_11762_11798[(2)] = inst_11729);

(statearr_11762_11798[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11749 === (3))){
var inst_11746 = (state_11748[(2)]);
var state_11748__$1 = state_11748;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11748__$1,inst_11746);
} else {
if((state_val_11749 === (12))){
var state_11748__$1 = state_11748;
var statearr_11763_11799 = state_11748__$1;
(statearr_11763_11799[(2)] = false);

(statearr_11763_11799[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11749 === (2))){
var state_11748__$1 = state_11748;
var statearr_11764_11800 = state_11748__$1;
(statearr_11764_11800[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11749 === (23))){
var inst_11740 = (state_11748[(2)]);
var state_11748__$1 = (function (){var statearr_11766 = state_11748;
(statearr_11766[(11)] = inst_11740);

return statearr_11766;
})();
var statearr_11767_11801 = state_11748__$1;
(statearr_11767_11801[(2)] = null);

(statearr_11767_11801[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11749 === (19))){
var inst_11732 = (state_11748[(2)]);
var inst_11733 = cljs.core.async.timeout.call(null,hatti.ona.stream.small_delay);
var state_11748__$1 = (function (){var statearr_11768 = state_11748;
(statearr_11768[(12)] = inst_11732);

return statearr_11768;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11748__$1,(20),inst_11733);
} else {
if((state_val_11749 === (11))){
var state_11748__$1 = state_11748;
var statearr_11769_11802 = state_11748__$1;
(statearr_11769_11802[(2)] = true);

(statearr_11769_11802[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11749 === (9))){
var state_11748__$1 = state_11748;
var statearr_11770_11803 = state_11748__$1;
(statearr_11770_11803[(2)] = false);

(statearr_11770_11803[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11749 === (5))){
var state_11748__$1 = state_11748;
var statearr_11771_11804 = state_11748__$1;
(statearr_11771_11804[(2)] = null);

(statearr_11771_11804[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11749 === (14))){
var inst_11705 = (state_11748[(7)]);
var inst_11722 = cljs.core.apply.call(null,cljs.core.hash_map,inst_11705);
var state_11748__$1 = state_11748;
var statearr_11772_11805 = state_11748__$1;
(statearr_11772_11805[(2)] = inst_11722);

(statearr_11772_11805[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11749 === (16))){
var inst_11726 = (state_11748[(10)]);
var inst_11725 = (state_11748[(2)]);
var inst_11726__$1 = cljs.core.get.call(null,inst_11725,new cljs.core.Keyword(null,"data","data",-232669377));
var inst_11727 = cljs.core.get.call(null,inst_11725,new cljs.core.Keyword(null,"completed?","completed?",946828354));
var state_11748__$1 = (function (){var statearr_11773 = state_11748;
(statearr_11773[(10)] = inst_11726__$1);

(statearr_11773[(8)] = inst_11727);

return statearr_11773;
})();
if(cljs.core.truth_(inst_11726__$1)){
var statearr_11774_11806 = state_11748__$1;
(statearr_11774_11806[(1)] = (17));

} else {
var statearr_11775_11807 = state_11748__$1;
(statearr_11775_11807[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11749 === (10))){
var inst_11720 = (state_11748[(2)]);
var state_11748__$1 = state_11748;
if(cljs.core.truth_(inst_11720)){
var statearr_11776_11808 = state_11748__$1;
(statearr_11776_11808[(1)] = (14));

} else {
var statearr_11777_11809 = state_11748__$1;
(statearr_11777_11809[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11749 === (18))){
var state_11748__$1 = state_11748;
var statearr_11778_11810 = state_11748__$1;
(statearr_11778_11810[(2)] = null);

(statearr_11778_11810[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11749 === (8))){
var inst_11705 = (state_11748[(7)]);
var inst_11710 = inst_11705.cljs$lang$protocol_mask$partition0$;
var inst_11711 = (inst_11710 & (64));
var inst_11712 = inst_11705.cljs$core$ISeq$;
var inst_11713 = (inst_11711) || (inst_11712);
var state_11748__$1 = state_11748;
if(cljs.core.truth_(inst_11713)){
var statearr_11779_11811 = state_11748__$1;
(statearr_11779_11811[(1)] = (11));

} else {
var statearr_11780_11812 = state_11748__$1;
(statearr_11780_11812[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto__))
;
return ((function (switch__8335__auto__,c__8400__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto____0 = (function (){
var statearr_11784 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11784[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto__);

(statearr_11784[(1)] = (1));

return statearr_11784;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto____1 = (function (state_11748){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_11748);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e11785){if((e11785 instanceof Object)){
var ex__8339__auto__ = e11785;
var statearr_11786_11813 = state_11748;
(statearr_11786_11813[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11748);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11785;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11814 = state_11748;
state_11748 = G__11814;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto__ = function(state_11748){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto____1.call(this,state_11748);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto__))
})();
var state__8402__auto__ = (function (){var statearr_11787 = f__8401__auto__.call(null);
(statearr_11787[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto__);

return statearr_11787;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});})(c__8400__auto__))
);

return c__8400__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.call(null,read_count,cljs.core.inc);

cljs.core.swap_BANG_.call(null,agg,cljs.core.conj,data_chunk);

if(((cljs.core.deref.call(null,read_count) >= (100))) && (cljs.core.integer_QMARK_.call(null,Math.log10(cljs.core.deref.call(null,read_count))))){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg)], null));

cljs.core.reset_BANG_.call(null,agg,cljs.core.PersistentVector.EMPTY);

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___11821 = arguments.length;
var i__5628__auto___11822 = (0);
while(true){
if((i__5628__auto___11822 < len__5627__auto___11821)){
args__5634__auto__.push((arguments[i__5628__auto___11822]));

var G__11823 = (i__5628__auto___11822 + (1));
i__5628__auto___11822 = G__11823;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__11818){
var map__11819 = p__11818;
var map__11819__$1 = ((((!((map__11819 == null)))?((((map__11819.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11819.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11819):map__11819);
var oboe_headers = cljs.core.get.call(null,map__11819__$1,new cljs.core.Keyword(null,"oboe-headers","oboe-headers",-764778163));
var read_count = cljs.core.atom.call(null,(0));
var agg = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
var channel = cljs.core.async.chan.call(null);
var return_channel = cljs.core.async.chan.call(null);
var oboe_params = cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"headers","headers",-835030129),oboe_headers,new cljs.core.Keyword(null,"withCredentials","withCredentials",1719959454),true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__11819,map__11819__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_.call(null,cljs.core.js__GT_clj.call(null,line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__11819,map__11819__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__11819,map__11819__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg),new cljs.core.Keyword(null,"completed?","completed?",946828354),true], null));

return cljs.core.async.close_BANG_.call(null,return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__11819,map__11819__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_.call(null,channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq11815){
var G__11816 = cljs.core.first.call(null,seq11815);
var seq11815__$1 = cljs.core.next.call(null,seq11815);
var G__11817 = cljs.core.first.call(null,seq11815__$1);
var seq11815__$2 = cljs.core.next.call(null,seq11815__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11816,G__11817,seq11815__$2);
});
