// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.charting');
goog.require('cljs.core');
goog.require('c2.layout.histogram');
goog.require('hatti.maths');
goog.require('cljs_time.coerce');
goog.require('c2.scale');
goog.require('cljs_time.format');
goog.require('hatti.ona.forms');
goog.require('hatti.utils');
goog.require('c2.svg');
goog.require('clojure.string');
hatti.charting.millis_in_day = (86400000);
/**
 * Parse an integer from a string.
 */
hatti.charting.parse_int = (function hatti$charting$parse_int(st){
var ans = parseInt(st);
if(cljs.core.truth_(isNaN(ans))){
return null;
} else {
return ans;
}
});
/**
 * Converts string to integer, for typ (int|date).
 */
hatti.charting.str__GT_int = (function hatti$charting$str__GT_int(typ){
var G__11435 = typ;
switch (G__11435) {
case "int":
return hatti.charting.parse_int;

break;
case "date":
return ((function (G__11435){
return (function (date_string){
if(cljs.core.truth_(date_string)){
return hatti.maths.floor.call(null,(cljs_time.coerce.to_long.call(null,(new Date(date_string))) / hatti.charting.millis_in_day));
} else {
return null;
}
});
;})(G__11435))

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(typ)].join('')));

}
});
/**
 * Converts integers to strings, for type (int|date).
 * Optional digits parameter = number of digits after decimal, default is 1.
 */
hatti.charting.int__GT_str = (function hatti$charting$int__GT_str(var_args){
var args__5634__auto__ = [];
var len__5627__auto___11447 = arguments.length;
var i__5628__auto___11448 = (0);
while(true){
if((i__5628__auto___11448 < len__5627__auto___11447)){
args__5634__auto__.push((arguments[i__5628__auto___11448]));

var G__11449 = (i__5628__auto___11448 + (1));
i__5628__auto___11448 = G__11449;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic = (function (typ,p__11443){
var map__11444 = p__11443;
var map__11444__$1 = ((((!((map__11444 == null)))?((((map__11444.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11444.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11444):map__11444);
var digits = cljs.core.get.call(null,map__11444__$1,new cljs.core.Keyword(null,"digits","digits",-1134635061),(1));
var int_fmt_s = [cljs.core.str("%."),cljs.core.str(digits),cljs.core.str("f")].join('');
var d__GT_millis = ((function (int_fmt_s,map__11444,map__11444__$1,digits){
return (function (p1__11437_SHARP_){
return (hatti.charting.millis_in_day * p1__11437_SHARP_);
});})(int_fmt_s,map__11444,map__11444__$1,digits))
;
var date__GT_str = ((function (int_fmt_s,d__GT_millis,map__11444,map__11444__$1,digits){
return (function (p1__11438_SHARP_){
if(cljs.core.truth_(p1__11438_SHARP_)){
return moment(p1__11438_SHARP_).format("ll");
} else {
return null;
}
});})(int_fmt_s,d__GT_millis,map__11444,map__11444__$1,digits))
;
var G__11446 = typ;
switch (G__11446) {
case "int":
return ((function (G__11446,int_fmt_s,d__GT_millis,date__GT_str,map__11444,map__11444__$1,digits){
return (function (p1__11439_SHARP_){
return hatti.utils.format.call(null,int_fmt_s,p1__11439_SHARP_);
});
;})(G__11446,int_fmt_s,d__GT_millis,date__GT_str,map__11444,map__11444__$1,digits))

break;
case "date":
return ((function (G__11446,int_fmt_s,d__GT_millis,date__GT_str,map__11444,map__11444__$1,digits){
return (function (p1__11440_SHARP_){
return date__GT_str.call(null,d__GT_millis.call(null,p1__11440_SHARP_));
});
;})(G__11446,int_fmt_s,d__GT_millis,date__GT_str,map__11444,map__11444__$1,digits))

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(typ)].join('')));

}
});

hatti.charting.int__GT_str.cljs$lang$maxFixedArity = (1);

hatti.charting.int__GT_str.cljs$lang$applyTo = (function (seq11441){
var G__11442 = cljs.core.first.call(null,seq11441);
var seq11441__$1 = cljs.core.next.call(null,seq11441);
return hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic(G__11442,seq11441__$1);
});
/**
 * Converts a range of typ (int|date) to a string.
 */
hatti.charting.range__GT_str = (function hatti$charting$range__GT_str(p__11451,typ){
var vec__11454 = p__11451;
var mn = cljs.core.nth.call(null,vec__11454,(0),null);
var mx = cljs.core.nth.call(null,vec__11454,(1),null);
var vec__11455 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [hatti.maths.ceil.call(null,mn),hatti.maths.floor.call(null,mx)], null);
var mn__$1 = cljs.core.nth.call(null,vec__11455,(0),null);
var mx__$1 = cljs.core.nth.call(null,vec__11455,(1),null);
var fmt = hatti.charting.int__GT_str.call(null,typ,new cljs.core.Keyword(null,"digits","digits",-1134635061),(0));
if((mx__$1 <= mn__$1)){
return fmt.call(null,mn__$1);
} else {
return clojure.string.join.call(null," to ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fmt.call(null,mn__$1),fmt.call(null,mx__$1)], null));
}
});
/**
 * Given a list of answers, returns each one as a bin, in string form.
 * nil is mapped to nil. The bins, in order, are returned as metadata.
 * eg. (evenly-spaced-bins [1 2 10] 5 'int') => ['1 to 2' '1 to 2' '9 to 10']
 * metadata of this above value would be:
 * {:bins ['1 to 2', '3 to 4', '5 to 6', '7 to 8', '9 to 10']}
 */
hatti.charting.evenly_spaced_bins = (function hatti$charting$evenly_spaced_bins(answers,bins,typ){
var numbers = cljs.core.map.call(null,hatti.charting.str__GT_int.call(null,typ),answers);
var mx = cljs.core.reduce.call(null,cljs.core.max,cljs.core.remove.call(null,cljs.core.nil_QMARK_,numbers));
var mn = cljs.core.reduce.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,numbers));
var s = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [mn,mx], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(bins - ((1) / (10000)))], null));
var is = cljs.core.map.call(null,hatti.maths.floor,cljs.core.map.call(null,((function (numbers,mx,mn,s){
return (function (p1__11456_SHARP_){
if(cljs.core.truth_(p1__11456_SHARP_)){
return s.call(null,p1__11456_SHARP_);
} else {
return null;
}
});})(numbers,mx,mn,s))
,numbers));
var t = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),bins], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [mn,mx], null));
var lbounds = cljs.core.distinct.call(null,cljs.core.map.call(null,cljs.core.float$,cljs.core.map.call(null,t,cljs.core.range.call(null,bins))));
var ubounds = cljs.core.conj.call(null,cljs.core.mapv.call(null,((function (numbers,mx,mn,s,is,t,lbounds){
return (function (p1__11457_SHARP_){
if(cljs.core._EQ_.call(null,p1__11457_SHARP_,hatti.maths.floor.call(null,p1__11457_SHARP_))){
return (p1__11457_SHARP_ - (1));
} else {
return p1__11457_SHARP_;
}
});})(numbers,mx,mn,s,is,t,lbounds))
,cljs.core.drop.call(null,(1),lbounds)),mx);
var fmt = hatti.charting.int__GT_str.call(null,typ,new cljs.core.Keyword(null,"digits","digits",-1134635061),(0));
var strings = cljs.core.mapv.call(null,((function (numbers,mx,mn,s,is,t,lbounds,ubounds,fmt){
return (function (p1__11458_SHARP_,p2__11459_SHARP_){
return hatti.charting.range__GT_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11458_SHARP_,p2__11459_SHARP_], null),typ);
});})(numbers,mx,mn,s,is,t,lbounds,ubounds,fmt))
,lbounds,ubounds);
var results = cljs.core.map.call(null,((function (numbers,mx,mn,s,is,t,lbounds,ubounds,fmt,strings){
return (function (i){
if(cljs.core.truth_(i)){
return cljs.core.get.call(null,strings,(i | (0)));
} else {
return null;
}
});})(numbers,mx,mn,s,is,t,lbounds,ubounds,fmt,strings))
,is);
var strings__$1 = cljs.core.vec.call(null,cljs.core.distinct.call(null,strings));
return cljs.core.with_meta.call(null,results,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bins","bins",1670395210),((cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,answers),null))?cljs.core.conj.call(null,strings__$1,null):strings__$1)], null));
});
/**
 * Take chart-data from the ona API, returns label->count map.
 * eg. Input: {:field_xpath 'D' :data [{:count 2 :D ['Option_1']}]}
 * Output: {:Option_1 2}
 * eg. Input: {:field_xpath 'D' :data [{:count 1 :D ['O1' 'O_2']
 * :count 2 :D ['O1']}]}
 * Output: {:Option_1 3 :O_2 1}
 */
hatti.charting.label_count_pairs = (function hatti$charting$label_count_pairs(var_args){
var args11462 = [];
var len__5627__auto___11471 = arguments.length;
var i__5628__auto___11472 = (0);
while(true){
if((i__5628__auto___11472 < len__5627__auto___11471)){
args11462.push((arguments[i__5628__auto___11472]));

var G__11473 = (i__5628__auto___11472 + (1));
i__5628__auto___11472 = G__11473;
continue;
} else {
}
break;
}

var G__11464 = args11462.length;
switch (G__11464) {
case 1:
return hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11462.length)].join('')));

}
});

hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$1 = (function (chart_data){
return hatti.charting.label_count_pairs.call(null,chart_data,null);
});

hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2 = (function (chart_data,language){
var map__11465 = chart_data;
var map__11465__$1 = ((((!((map__11465 == null)))?((((map__11465.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11465.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11465):map__11465);
var data = cljs.core.get.call(null,map__11465__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var field_xpath = cljs.core.get.call(null,map__11465__$1,new cljs.core.Keyword(null,"field_xpath","field_xpath",1282029284));
var unboxed = (function (){var iter__5341__auto__ = ((function (map__11465,map__11465__$1,data,field_xpath){
return (function hatti$charting$iter__11467(s__11468){
return (new cljs.core.LazySeq(null,((function (map__11465,map__11465__$1,data,field_xpath){
return (function (){
var s__11468__$1 = s__11468;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__11468__$1);
if(temp__4425__auto__){
var s__11468__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11468__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__11468__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__11470 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__11469 = (0);
while(true){
if((i__11469 < size__5340__auto__)){
var data_item = cljs.core._nth.call(null,c__5339__auto__,i__11469);
cljs.core.chunk_append.call(null,b__11470,(function (){var labels = cljs.core.keyword.call(null,field_xpath).call(null,data_item);
var count = new cljs.core.Keyword(null,"count","count",2139924085).cljs$core$IFn$_invoke$arity$1(data_item);
var labelify = ((function (i__11469,labels,count,data_item,c__5339__auto__,size__5340__auto__,b__11470,s__11468__$2,temp__4425__auto__,map__11465,map__11465__$1,data,field_xpath){
return (function (p1__11460_SHARP_){
return hatti.ona.forms.get_label.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),p1__11460_SHARP_], null),language);
});})(i__11469,labels,count,data_item,c__5339__auto__,size__5340__auto__,b__11470,s__11468__$2,temp__4425__auto__,map__11465,map__11465__$1,data,field_xpath))
;
return cljs.core.map.call(null,((function (i__11469,labels,count,labelify,data_item,c__5339__auto__,size__5340__auto__,b__11470,s__11468__$2,temp__4425__auto__,map__11465,map__11465__$1,data,field_xpath){
return (function (p1__11461_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([labelify.call(null,p1__11461_SHARP_)],[count]);
});})(i__11469,labels,count,labelify,data_item,c__5339__auto__,size__5340__auto__,b__11470,s__11468__$2,temp__4425__auto__,map__11465,map__11465__$1,data,field_xpath))
,labels);
})());

var G__11475 = (i__11469 + (1));
i__11469 = G__11475;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11470),hatti$charting$iter__11467.call(null,cljs.core.chunk_rest.call(null,s__11468__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11470),null);
}
} else {
var data_item = cljs.core.first.call(null,s__11468__$2);
return cljs.core.cons.call(null,(function (){var labels = cljs.core.keyword.call(null,field_xpath).call(null,data_item);
var count = new cljs.core.Keyword(null,"count","count",2139924085).cljs$core$IFn$_invoke$arity$1(data_item);
var labelify = ((function (labels,count,data_item,s__11468__$2,temp__4425__auto__,map__11465,map__11465__$1,data,field_xpath){
return (function (p1__11460_SHARP_){
return hatti.ona.forms.get_label.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),p1__11460_SHARP_], null),language);
});})(labels,count,data_item,s__11468__$2,temp__4425__auto__,map__11465,map__11465__$1,data,field_xpath))
;
return cljs.core.map.call(null,((function (labels,count,labelify,data_item,s__11468__$2,temp__4425__auto__,map__11465,map__11465__$1,data,field_xpath){
return (function (p1__11461_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([labelify.call(null,p1__11461_SHARP_)],[count]);
});})(labels,count,labelify,data_item,s__11468__$2,temp__4425__auto__,map__11465,map__11465__$1,data,field_xpath))
,labels);
})(),hatti$charting$iter__11467.call(null,cljs.core.rest.call(null,s__11468__$2)));
}
} else {
return null;
}
break;
}
});})(map__11465,map__11465__$1,data,field_xpath))
,null,null));
});})(map__11465,map__11465__$1,data,field_xpath))
;
return iter__5341__auto__.call(null,data);
})();
return cljs.core.sort_by.call(null,cljs.core.last,cljs.core._GT_,cljs.core.apply.call(null,cljs.core.merge_with,cljs.core._PLUS_,cljs.core.flatten.call(null,unboxed)));
});

hatti.charting.label_count_pairs.cljs$lang$maxFixedArity = 2;
/**
 * Determine number of bins if there are n possible of values of data.
 *   Custom algorithm, based on a pleasant range of bins being between
 *   roughly 7 and 15 (though customizable). Idea is that we try to divide
 *   n into a number between 
 */
hatti.charting.num_bins = (function hatti$charting$num_bins(var_args){
var args__5634__auto__ = [];
var len__5627__auto___11481 = arguments.length;
var i__5628__auto___11482 = (0);
while(true){
if((i__5628__auto___11482 < len__5627__auto___11481)){
args__5634__auto__.push((arguments[i__5628__auto___11482]));

var G__11483 = (i__5628__auto___11482 + (1));
i__5628__auto___11482 = G__11483;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic = (function (n,p__11478){
var map__11479 = p__11478;
var map__11479__$1 = ((((!((map__11479 == null)))?((((map__11479.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11479.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11479):map__11479);
var data_type = cljs.core.get.call(null,map__11479__$1,new cljs.core.Keyword(null,"data-type","data-type",-326421468),"int");
var rough_min = (7);
var rough_max = (15);
var real_max = (24);
var full_range = cljs.core.range.call(null,rough_min,rough_max);
var best_guess = cljs.core.apply.call(null,cljs.core.max,cljs.core.map.call(null,cljs.core.partial.call(null,hatti.maths.gcd,n),full_range));
if((best_guess < rough_min)){
return cljs.core.apply.call(null,cljs.core.partial.call(null,cljs.core.min,real_max,n),cljs.core.map.call(null,cljs.core.partial.call(null,hatti.maths.lcm,n),full_range));
} else {
return best_guess;
}
});

hatti.charting.num_bins.cljs$lang$maxFixedArity = (1);

hatti.charting.num_bins.cljs$lang$applyTo = (function (seq11476){
var G__11477 = cljs.core.first.call(null,seq11476);
var seq11476__$1 = cljs.core.next.call(null,seq11476);
return hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic(G__11477,seq11476__$1);
});
/**
 * Turn numerical / date chart-data from ona API histogram-friendly.
 *   Return data looks like [(x dx y)] with-meta {:bins num-bins}.
 */
hatti.charting.extract_data_for_histogram = (function hatti$charting$extract_data_for_histogram(var_args){
var args__5634__auto__ = [];
var len__5627__auto___11495 = arguments.length;
var i__5628__auto___11496 = (0);
while(true){
if((i__5628__auto___11496 < len__5627__auto___11495)){
args__5634__auto__.push((arguments[i__5628__auto___11496]));

var G__11497 = (i__5628__auto___11496 + (1));
i__5628__auto___11496 = G__11497;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic = (function (chart_data,p__11486){
var map__11487 = p__11486;
var map__11487__$1 = ((((!((map__11487 == null)))?((((map__11487.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11487.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11487):map__11487);
var data_type = cljs.core.get.call(null,map__11487__$1,new cljs.core.Keyword(null,"data-type","data-type",-326421468),"int");
var map__11489 = chart_data;
var map__11489__$1 = ((((!((map__11489 == null)))?((((map__11489.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11489.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11489):map__11489);
var data = cljs.core.get.call(null,map__11489__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var field_xpath = cljs.core.get.call(null,map__11489__$1,new cljs.core.Keyword(null,"field_xpath","field_xpath",1282029284));
var retype_fn = hatti.charting.str__GT_int.call(null,data_type);
var qn_key = cljs.core.keyword.call(null,field_xpath);
var retyped_data = cljs.core.map.call(null,((function (map__11489,map__11489__$1,data,field_xpath,retype_fn,qn_key,map__11487,map__11487__$1,data_type){
return (function (el){
return cljs.core.update_in.call(null,el,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [qn_key], null),retype_fn);
});})(map__11489,map__11489__$1,data,field_xpath,retype_fn,qn_key,map__11487,map__11487__$1,data_type))
,data);
var data_range = (cljs.core.apply.call(null,cljs.core.max,cljs.core.map.call(null,qn_key,retyped_data)) - cljs.core.apply.call(null,cljs.core.min,cljs.core.map.call(null,qn_key,retyped_data)));
var bins = (((data_range === (0)))?(1):hatti.charting.num_bins.call(null,data_range,new cljs.core.Keyword(null,"data-type","data-type",-326421468),data_type));
var binned_data = c2.layout.histogram.histogram.call(null,retyped_data,new cljs.core.Keyword(null,"value","value",305978217),qn_key,new cljs.core.Keyword(null,"bins","bins",1670395210),bins);
return cljs.core.with_meta.call(null,(function (){var iter__5341__auto__ = ((function (map__11489,map__11489__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__11487,map__11487__$1,data_type){
return (function hatti$charting$iter__11491(s__11492){
return (new cljs.core.LazySeq(null,((function (map__11489,map__11489__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__11487,map__11487__$1,data_type){
return (function (){
var s__11492__$1 = s__11492;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__11492__$1);
if(temp__4425__auto__){
var s__11492__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11492__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__11492__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__11494 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__11493 = (0);
while(true){
if((i__11493 < size__5340__auto__)){
var data_item = cljs.core._nth.call(null,c__5339__auto__,i__11493);
cljs.core.chunk_append.call(null,b__11494,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,data_item)),new cljs.core.Keyword(null,"dx","dx",-381796732).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,data_item)),cljs.core.apply.call(null,cljs.core._PLUS_,cljs.core.map.call(null,new cljs.core.Keyword(null,"count","count",2139924085),data_item))], null));

var G__11498 = (i__11493 + (1));
i__11493 = G__11498;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11494),hatti$charting$iter__11491.call(null,cljs.core.chunk_rest.call(null,s__11492__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11494),null);
}
} else {
var data_item = cljs.core.first.call(null,s__11492__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,data_item)),new cljs.core.Keyword(null,"dx","dx",-381796732).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,data_item)),cljs.core.apply.call(null,cljs.core._PLUS_,cljs.core.map.call(null,new cljs.core.Keyword(null,"count","count",2139924085),data_item))], null),hatti$charting$iter__11491.call(null,cljs.core.rest.call(null,s__11492__$2)));
}
} else {
return null;
}
break;
}
});})(map__11489,map__11489__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__11487,map__11487__$1,data_type))
,null,null));
});})(map__11489,map__11489__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__11487,map__11487__$1,data_type))
;
return iter__5341__auto__.call(null,binned_data);
})(),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bins","bins",1670395210),bins], null));
});

hatti.charting.extract_data_for_histogram.cljs$lang$maxFixedArity = (1);

hatti.charting.extract_data_for_histogram.cljs$lang$applyTo = (function (seq11484){
var G__11485 = cljs.core.first.call(null,seq11484);
var seq11484__$1 = cljs.core.next.call(null,seq11484);
return hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic(G__11485,seq11484__$1);
});
/**
 * Produces a linear mapping [0,max-count] -> [0, max-length], for data which
 * is a vector, each element a map with key :count. If total-asmax?, then
 * linear map is [0,total-count] -> [0, max-length].
 */
hatti.charting.counts__GT_lengths = (function hatti$charting$counts__GT_lengths(var_args){
var args__5634__auto__ = [];
var len__5627__auto___11505 = arguments.length;
var i__5628__auto___11506 = (0);
while(true){
if((i__5628__auto___11506 < len__5627__auto___11505)){
args__5634__auto__.push((arguments[i__5628__auto___11506]));

var G__11507 = (i__5628__auto___11506 + (1));
i__5628__auto___11506 = G__11507;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic = (function (data,max_length,p__11502){
var map__11503 = p__11502;
var map__11503__$1 = ((((!((map__11503 == null)))?((((map__11503.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11503.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11503):map__11503);
var total_as_max_QMARK_ = cljs.core.get.call(null,map__11503__$1,new cljs.core.Keyword(null,"total-as-max?","total-as-max?",-1709426453));
var datamin_as_min_QMARK_ = cljs.core.get.call(null,map__11503__$1,new cljs.core.Keyword(null,"datamin-as-min?","datamin-as-min?",1074079715));
var counts = cljs.core.map.call(null,new cljs.core.Keyword(null,"count","count",2139924085),data);
var xmax = (cljs.core.truth_(total_as_max_QMARK_)?cljs.core.reduce.call(null,cljs.core._PLUS_,(0),counts):cljs.core.reduce.call(null,cljs.core.max,(0),counts));
var xmin = (cljs.core.truth_(datamin_as_min_QMARK_)?cljs.core.reduce.call(null,cljs.core.min,(0),counts):(0));
var scale = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [xmin,xmax], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),max_length], null));
return cljs.core.map.call(null,scale,counts);
});

hatti.charting.counts__GT_lengths.cljs$lang$maxFixedArity = (2);

hatti.charting.counts__GT_lengths.cljs$lang$applyTo = (function (seq11499){
var G__11500 = cljs.core.first.call(null,seq11499);
var seq11499__$1 = cljs.core.next.call(null,seq11499);
var G__11501 = cljs.core.first.call(null,seq11499__$1);
var seq11499__$2 = cljs.core.next.call(null,seq11499__$1);
return hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic(G__11500,G__11501,seq11499__$2);
});
hatti.charting.response_count_message = (function hatti$charting$response_count_message(response_count){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.t-right.t-grey","div.t-right.t-grey",-2075084293),[cljs.core.str("Based on "),cljs.core.str(response_count),cljs.core.str(" responses.")].join('')], null);
});
/**
 * Create numeric (or date) chart out of some chart-data from ona API.
 */
hatti.charting.numeric_chart = (function hatti$charting$numeric_chart(var_args){
var args__5634__auto__ = [];
var len__5627__auto___11532 = arguments.length;
var i__5628__auto___11533 = (0);
while(true){
if((i__5628__auto___11533 < len__5627__auto___11532)){
args__5634__auto__.push((arguments[i__5628__auto___11533]));

var G__11534 = (i__5628__auto___11533 + (1));
i__5628__auto___11533 = G__11534;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic = (function (chart_data,p__11510){
var map__11511 = p__11510;
var map__11511__$1 = ((((!((map__11511 == null)))?((((map__11511.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11511.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11511):map__11511);
var data_type = cljs.core.get.call(null,map__11511__$1,new cljs.core.Keyword(null,"data-type","data-type",-326421468),"int");
var chart_width = 700.0;
var chart_height = 300.0;
var margin = 33.0;
var small_margin = 2.0;
var y_lim = 8.0;
var neg_margin = (-15);
var extracted_data = hatti.charting.extract_data_for_histogram.call(null,chart_data,new cljs.core.Keyword(null,"data-type","data-type",-326421468),data_type);
var map__11513 = cljs.core.meta.call(null,chart_data);
var map__11513__$1 = ((((!((map__11513 == null)))?((((map__11513.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11513.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11513):map__11513);
var nil_count = cljs.core.get.call(null,map__11513__$1,new cljs.core.Keyword(null,"nil-count","nil-count",785567731));
var non_nil_count = cljs.core.get.call(null,map__11513__$1,new cljs.core.Keyword(null,"non-nil-count","non-nil-count",-593781457));
var bins = new cljs.core.Keyword(null,"bins","bins",1670395210).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,extracted_data));
var x_series = cljs.core.map.call(null,cljs.core.first,extracted_data);
var dx_series = cljs.core.map.call(null,cljs.core.second,extracted_data);
var y_series = cljs.core.map.call(null,cljs.core.last,extracted_data);
var xmin = cljs.core.apply.call(null,cljs.core.min,x_series);
var xmax = (cljs.core.apply.call(null,cljs.core.max,x_series) + cljs.core.last.call(null,dx_series));
var x_scale = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [xmin,xmax], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_width], null));
var y_scale = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),cljs.core.apply.call(null,cljs.core.max,y_series)], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_height], null));
var bin_width = hatti.maths.floor.call(null,((chart_width / bins) - small_margin));
var x_ticks = cljs.core.take_nth.call(null,(2),cljs.core.rest.call(null,x_series));
var fmt = hatti.charting.int__GT_str.call(null,data_type);
if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,extracted_data))){
var vec__11515 = cljs.core.first.call(null,extracted_data);
var value = cljs.core.nth.call(null,vec__11515,(0),null);
var _ = cljs.core.nth.call(null,vec__11515,(1),null);
var total = cljs.core.nth.call(null,vec__11515,(2),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),total," records have identical value: ",fmt.call(null,value)], null)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"width","width",-384071477),(margin + chart_width),new cljs.core.Keyword(null,"height","height",1025178622),(margin + chart_height)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.chart","g.chart",376683303),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [margin,(0)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),(function (){var iter__5341__auto__ = ((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__11513,map__11513__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__11511,map__11511__$1,data_type){
return (function hatti$charting$iter__11516(s__11517){
return (new cljs.core.LazySeq(null,((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__11513,map__11513__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__11511,map__11511__$1,data_type){
return (function (){
var s__11517__$1 = s__11517;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__11517__$1);
if(temp__4425__auto__){
var s__11517__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11517__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__11517__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__11519 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__11518 = (0);
while(true){
if((i__11518 < size__5340__auto__)){
var vec__11524 = cljs.core._nth.call(null,c__5339__auto__,i__11518);
var x = cljs.core.nth.call(null,vec__11524,(0),null);
var dx = cljs.core.nth.call(null,vec__11524,(1),null);
var y = cljs.core.nth.call(null,vec__11524,(2),null);
cljs.core.chunk_append.call(null,b__11519,(function (){var x_scaled = x_scale.call(null,x);
var y_scaled = y_scale.call(null,y);
var vec__11525 = (((((0) < y_scaled)) && ((y_scaled < y_lim)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [small_margin,neg_margin,"out-of-bar"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [y_scaled,small_margin,"in-bar"], null));
var y_scaled__$1 = cljs.core.nth.call(null,vec__11525,(0),null);
var txt_ht = cljs.core.nth.call(null,vec__11525,(1),null);
var txt_cls = cljs.core.nth.call(null,vec__11525,(2),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.bars","g.bars",-1370310225),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scaled,(chart_height - y_scaled__$1)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rect","rect",-108902628),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"x","x",2099068185),(1),new cljs.core.Keyword(null,"height","height",1025178622),y_scaled__$1,new cljs.core.Keyword(null,"width","width",-384071477),bin_width], null)], null)], null),(((y_scaled__$1 > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"y","y",-1757859776),txt_ht,new cljs.core.Keyword(null,"x","x",2099068185),(bin_width / 2.0),new cljs.core.Keyword(null,"dy","dy",1719547243),"1em",new cljs.core.Keyword(null,"text-anchor","text-anchor",585613696),"middle",new cljs.core.Keyword(null,"class","class",-2030961996),txt_cls], null),y], null):null)], null);
})());

var G__11535 = (i__11518 + (1));
i__11518 = G__11535;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11519),hatti$charting$iter__11516.call(null,cljs.core.chunk_rest.call(null,s__11517__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11519),null);
}
} else {
var vec__11526 = cljs.core.first.call(null,s__11517__$2);
var x = cljs.core.nth.call(null,vec__11526,(0),null);
var dx = cljs.core.nth.call(null,vec__11526,(1),null);
var y = cljs.core.nth.call(null,vec__11526,(2),null);
return cljs.core.cons.call(null,(function (){var x_scaled = x_scale.call(null,x);
var y_scaled = y_scale.call(null,y);
var vec__11527 = (((((0) < y_scaled)) && ((y_scaled < y_lim)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [small_margin,neg_margin,"out-of-bar"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [y_scaled,small_margin,"in-bar"], null));
var y_scaled__$1 = cljs.core.nth.call(null,vec__11527,(0),null);
var txt_ht = cljs.core.nth.call(null,vec__11527,(1),null);
var txt_cls = cljs.core.nth.call(null,vec__11527,(2),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.bars","g.bars",-1370310225),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scaled,(chart_height - y_scaled__$1)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rect","rect",-108902628),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"x","x",2099068185),(1),new cljs.core.Keyword(null,"height","height",1025178622),y_scaled__$1,new cljs.core.Keyword(null,"width","width",-384071477),bin_width], null)], null)], null),(((y_scaled__$1 > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"y","y",-1757859776),txt_ht,new cljs.core.Keyword(null,"x","x",2099068185),(bin_width / 2.0),new cljs.core.Keyword(null,"dy","dy",1719547243),"1em",new cljs.core.Keyword(null,"text-anchor","text-anchor",585613696),"middle",new cljs.core.Keyword(null,"class","class",-2030961996),txt_cls], null),y], null):null)], null);
})(),hatti$charting$iter__11516.call(null,cljs.core.rest.call(null,s__11517__$2)));
}
} else {
return null;
}
break;
}
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__11513,map__11513__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__11511,map__11511__$1,data_type))
,null,null));
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__11513,map__11513__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__11511,map__11511__$1,data_type))
;
return iter__5341__auto__.call(null,extracted_data);
})()], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.axis","g.axis",837167470),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_height], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"x1","x1",-1863922247),(0),new cljs.core.Keyword(null,"x2","x2",-1362513475),chart_width], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),(function (){var iter__5341__auto__ = ((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__11513,map__11513__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__11511,map__11511__$1,data_type){
return (function hatti$charting$iter__11528(s__11529){
return (new cljs.core.LazySeq(null,((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__11513,map__11513__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__11511,map__11511__$1,data_type){
return (function (){
var s__11529__$1 = s__11529;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__11529__$1);
if(temp__4425__auto__){
var s__11529__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11529__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__11529__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__11531 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__11530 = (0);
while(true){
if((i__11530 < size__5340__auto__)){
var x = cljs.core._nth.call(null,c__5339__auto__,i__11530);
cljs.core.chunk_append.call(null,b__11531,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.tick","g.tick",368840735),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scale.call(null,x),(0)], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"y","y",-1757859776),(25),new cljs.core.Keyword(null,"text-anchor","text-anchor",585613696),"middle",new cljs.core.Keyword(null,"class","class",-2030961996),data_type], null),fmt.call(null,x)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"class","class",-2030961996),"tick",new cljs.core.Keyword(null,"y2","y2",-718691301),(10),new cljs.core.Keyword(null,"x2","x2",-1362513475),(0)], null)], null)], null));

var G__11536 = (i__11530 + (1));
i__11530 = G__11536;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11531),hatti$charting$iter__11528.call(null,cljs.core.chunk_rest.call(null,s__11529__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11531),null);
}
} else {
var x = cljs.core.first.call(null,s__11529__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.tick","g.tick",368840735),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scale.call(null,x),(0)], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"y","y",-1757859776),(25),new cljs.core.Keyword(null,"text-anchor","text-anchor",585613696),"middle",new cljs.core.Keyword(null,"class","class",-2030961996),data_type], null),fmt.call(null,x)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"class","class",-2030961996),"tick",new cljs.core.Keyword(null,"y2","y2",-718691301),(10),new cljs.core.Keyword(null,"x2","x2",-1362513475),(0)], null)], null)], null),hatti$charting$iter__11528.call(null,cljs.core.rest.call(null,s__11529__$2)));
}
} else {
return null;
}
break;
}
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__11513,map__11513__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__11511,map__11511__$1,data_type))
,null,null));
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__11513,map__11513__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__11511,map__11511__$1,data_type))
;
return iter__5341__auto__.call(null,x_ticks);
})()], null)], null)], null)], null),hatti.charting.response_count_message.call(null,non_nil_count)], null);
}
});

hatti.charting.numeric_chart.cljs$lang$maxFixedArity = (1);

hatti.charting.numeric_chart.cljs$lang$applyTo = (function (seq11508){
var G__11509 = cljs.core.first.call(null,seq11508);
var seq11508__$1 = cljs.core.next.call(null,seq11508);
return hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic(G__11509,seq11508__$1);
});
/**
 * Create category bar chart out of some data + count data. Data of form:
 *   {'Label1' 1 'Label2' 2}, etc. where the numbers are counts.
 */
hatti.charting.table_chart_h = (function hatti$charting$table_chart_h(data,nil_count,non_nil_count,field_type){
var max_count = cljs.core.apply.call(null,cljs.core.max,cljs.core.vals.call(null,data));
var percent_s = ((function (max_count){
return (function (n,total){
var s = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),total], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(100)], null));
return [cljs.core.str(hatti.utils.format.call(null,"%.1f",s.call(null,n))),cljs.core.str("%")].join('');
});})(max_count))
;
var select_mult_QMARK_ = cljs.core._EQ_.call(null,field_type,"select all that apply");
var bar_div = ((select_mult_QMARK_)?new cljs.core.Keyword(null,"div.bars.select-mult","div.bars.select-mult",514551318):new cljs.core.Keyword(null,"div.bars.select-one","div.bars.select-one",-235690381));
var tdr = new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table#bar-chart.table","table#bar-chart.table",-82390780),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"thead","thead",-291875296),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th.t-right","th.t-right",-959248017),"Count"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th.t-right","th.t-right",-959248017),"Percent"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tfoot","tfoot",-701599890),((select_mult_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr.t-grey","tr.t-grey",1706085529),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"col-span","col-span",-232603210),(4)], null),hatti.charting.response_count_message.call(null,non_nil_count)], null)], null):new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr.t-grey","tr.t-grey",1706085529),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,"Total"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,non_nil_count], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,"100%"], null)], null)),(((!(select_mult_QMARK_)) && ((nil_count > (0))))?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr.t-grey","tr.t-grey",1706085529),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),"No response"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),nil_count], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353)], null)], null):null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody","tbody",-80678300),(function (){var iter__5341__auto__ = ((function (max_count,percent_s,select_mult_QMARK_,bar_div,tdr){
return (function hatti$charting$table_chart_h_$_iter__11545(s__11546){
return (new cljs.core.LazySeq(null,((function (max_count,percent_s,select_mult_QMARK_,bar_div,tdr){
return (function (){
var s__11546__$1 = s__11546;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__11546__$1);
if(temp__4425__auto__){
var s__11546__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11546__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__11546__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__11548 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__11547 = (0);
while(true){
if((i__11547 < size__5340__auto__)){
var vec__11551 = cljs.core._nth.call(null,c__5339__auto__,i__11547);
var label = cljs.core.nth.call(null,vec__11551,(0),null);
var val = cljs.core.nth.call(null,vec__11551,(1),null);
cljs.core.chunk_append.call(null,b__11548,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"title","title",636505583),label], null),label], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bar_div,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"width","width",-384071477),percent_s.call(null,val,max_count)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),val], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),percent_s.call(null,val,non_nil_count)], null)], null));

var G__11553 = (i__11547 + (1));
i__11547 = G__11553;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11548),hatti$charting$table_chart_h_$_iter__11545.call(null,cljs.core.chunk_rest.call(null,s__11546__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11548),null);
}
} else {
var vec__11552 = cljs.core.first.call(null,s__11546__$2);
var label = cljs.core.nth.call(null,vec__11552,(0),null);
var val = cljs.core.nth.call(null,vec__11552,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"title","title",636505583),label], null),label], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bar_div,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"width","width",-384071477),percent_s.call(null,val,max_count)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),val], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),percent_s.call(null,val,non_nil_count)], null)], null),hatti$charting$table_chart_h_$_iter__11545.call(null,cljs.core.rest.call(null,s__11546__$2)));
}
} else {
return null;
}
break;
}
});})(max_count,percent_s,select_mult_QMARK_,bar_div,tdr))
,null,null));
});})(max_count,percent_s,select_mult_QMARK_,bar_div,tdr))
;
return iter__5341__auto__.call(null,data);
})()], null)], null);
});
/**
 * Removes nil from Ona API chart data; adds nil- and non-nil-count metadata.
 * ex. Input:  {:field_xpath 'D' :data [{:D nil :count 5} {:D 1 :count 10}]}
 *     Output: {:field_xpath 'D' :data [{:D 1 :count 10}]}
 *             w/ metadata: {:nil-count 5 :non-nil-count 10}
 */
hatti.charting.extract_nil = (function hatti$charting$extract_nil(chart_data){
var map__11559 = chart_data;
var map__11559__$1 = ((((!((map__11559 == null)))?((((map__11559.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11559.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11559):map__11559);
var field_xpath = cljs.core.get.call(null,map__11559__$1,new cljs.core.Keyword(null,"field_xpath","field_xpath",1282029284));
var data = cljs.core.get.call(null,map__11559__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var na_QMARK_ = ((function (map__11559,map__11559__$1,field_xpath,data){
return (function (p1__11554_SHARP_){
return ((p1__11554_SHARP_ == null)) || (cljs.core._EQ_.call(null,cljs.core.PersistentVector.EMPTY,p1__11554_SHARP_));
});})(map__11559,map__11559__$1,field_xpath,data))
;
var nil_data = cljs.core.first.call(null,cljs.core.filter.call(null,((function (map__11559,map__11559__$1,field_xpath,data,na_QMARK_){
return (function (p1__11555_SHARP_){
return na_QMARK_.call(null,cljs.core.keyword.call(null,field_xpath).call(null,p1__11555_SHARP_));
});})(map__11559,map__11559__$1,field_xpath,data,na_QMARK_))
,data));
var non_nil_data = cljs.core.remove.call(null,((function (map__11559,map__11559__$1,field_xpath,data,na_QMARK_,nil_data){
return (function (p1__11556_SHARP_){
return na_QMARK_.call(null,cljs.core.keyword.call(null,field_xpath).call(null,p1__11556_SHARP_));
});})(map__11559,map__11559__$1,field_xpath,data,na_QMARK_,nil_data))
,data);
var nil_count = (function (){var temp__4423__auto__ = new cljs.core.Keyword(null,"count","count",2139924085).cljs$core$IFn$_invoke$arity$1(nil_data);
if(cljs.core.truth_(temp__4423__auto__)){
var n = temp__4423__auto__;
return n;
} else {
return (0);
}
})();
var non_nil_count = cljs.core.apply.call(null,cljs.core._PLUS_,cljs.core.map.call(null,new cljs.core.Keyword(null,"count","count",2139924085),non_nil_data));
return cljs.core.with_meta.call(null,cljs.core.assoc.call(null,chart_data,new cljs.core.Keyword(null,"data","data",-232669377),non_nil_data),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"nil-count","nil-count",785567731),nil_count,new cljs.core.Keyword(null,"non-nil-count","non-nil-count",-593781457),non_nil_count], null));
});
/**
 * Make chart depending on datatype.
 */
hatti.charting.make_chart = (function hatti$charting$make_chart(var_args){
var args11562 = [];
var len__5627__auto___11570 = arguments.length;
var i__5628__auto___11571 = (0);
while(true){
if((i__5628__auto___11571 < len__5627__auto___11570)){
args11562.push((arguments[i__5628__auto___11571]));

var G__11572 = (i__5628__auto___11571 + (1));
i__5628__auto___11571 = G__11572;
continue;
} else {
}
break;
}

var G__11564 = args11562.length;
switch (G__11564) {
case 1:
return hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11562.length)].join('')));

}
});

hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$1 = (function (chart_data){
return hatti.charting.make_chart.call(null,chart_data,null);
});

hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$2 = (function (chart_data,language){
var map__11565 = chart_data;
var map__11565__$1 = ((((!((map__11565 == null)))?((((map__11565.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11565.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11565):map__11565);
var field_label = cljs.core.get.call(null,map__11565__$1,new cljs.core.Keyword(null,"field_label","field_label",-690619633));
var data_type = cljs.core.get.call(null,map__11565__$1,new cljs.core.Keyword(null,"data_type","data_type",1391137078));
var field_xpath = cljs.core.get.call(null,map__11565__$1,new cljs.core.Keyword(null,"field_xpath","field_xpath",1282029284));
var field_type = cljs.core.get.call(null,map__11565__$1,new cljs.core.Keyword(null,"field_type","field_type",1135193526));
var chart_data__$1 = hatti.charting.extract_nil.call(null,chart_data);
var map__11566 = cljs.core.meta.call(null,chart_data__$1);
var map__11566__$1 = ((((!((map__11566 == null)))?((((map__11566.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11566.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11566):map__11566);
var nil_count = cljs.core.get.call(null,map__11566__$1,new cljs.core.Keyword(null,"nil-count","nil-count",785567731));
var non_nil_count = cljs.core.get.call(null,map__11566__$1,new cljs.core.Keyword(null,"non-nil-count","non-nil-count",-593781457));
var not_supported = ((function (map__11565,map__11565__$1,field_label,data_type,field_xpath,field_type,chart_data__$1,map__11566,map__11566__$1,nil_count,non_nil_count){
return (function (p1__11561_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"div.t-red","div.t-red",-489419212),[cljs.core.str("Aplogies. At the moment, making a chart of\n                                     this data type ("),cljs.core.str(p1__11561_SHARP_),cljs.core.str(") is not supported.")].join('')],null));
});})(map__11565,map__11565__$1,field_label,data_type,field_xpath,field_type,chart_data__$1,map__11566,map__11566__$1,nil_count,non_nil_count))
;
var chart = (((non_nil_count === (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),"No data"], null):(function (){var G__11569 = data_type;
switch (G__11569) {
case "categorized":
return hatti.charting.table_chart_h.call(null,hatti.charting.label_count_pairs.call(null,chart_data__$1,language),nil_count,non_nil_count,field_type);

break;
case "time_based":
return hatti.charting.numeric_chart.call(null,chart_data__$1,new cljs.core.Keyword(null,"data-type","data-type",-326421468),"date");

break;
case "numeric":
return hatti.charting.numeric_chart.call(null,chart_data__$1);

break;
default:
return not_supported.call(null,data_type);

}
})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"label","label",1718410804),field_label,new cljs.core.Keyword(null,"name","name",1843675177),field_xpath,new cljs.core.Keyword(null,"chart","chart",1173225425),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),chart], null)], null);
});

hatti.charting.make_chart.cljs$lang$maxFixedArity = 2;
