// Compiled by ClojureScript 1.7.145 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t_cljs$core$async17521 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17521 = (function (fn_handler,f,meta17522){
this.fn_handler = fn_handler;
this.f = f;
this.meta17522 = meta17522;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17521.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17523,meta17522__$1){
var self__ = this;
var _17523__$1 = this;
return (new cljs.core.async.t_cljs$core$async17521(self__.fn_handler,self__.f,meta17522__$1));
});

cljs.core.async.t_cljs$core$async17521.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17523){
var self__ = this;
var _17523__$1 = this;
return self__.meta17522;
});

cljs.core.async.t_cljs$core$async17521.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17521.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17521.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async17521.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fn-handler","fn-handler",648785851,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)))], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"meta17522","meta17522",1196282139,null)], null);
});

cljs.core.async.t_cljs$core$async17521.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17521.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17521";

cljs.core.async.t_cljs$core$async17521.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async17521");
});

cljs.core.async.__GT_t_cljs$core$async17521 = (function cljs$core$async$fn_handler_$___GT_t_cljs$core$async17521(fn_handler__$1,f__$1,meta17522){
return (new cljs.core.async.t_cljs$core$async17521(fn_handler__$1,f__$1,meta17522));
});

}

return (new cljs.core.async.t_cljs$core$async17521(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args17526 = [];
var len__5627__auto___17529 = arguments.length;
var i__5628__auto___17530 = (0);
while(true){
if((i__5628__auto___17530 < len__5627__auto___17529)){
args17526.push((arguments[i__5628__auto___17530]));

var G__17531 = (i__5628__auto___17530 + (1));
i__5628__auto___17530 = G__17531;
continue;
} else {
}
break;
}

var G__17528 = args17526.length;
switch (G__17528) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17526.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args17533 = [];
var len__5627__auto___17536 = arguments.length;
var i__5628__auto___17537 = (0);
while(true){
if((i__5628__auto___17537 < len__5627__auto___17536)){
args17533.push((arguments[i__5628__auto___17537]));

var G__17538 = (i__5628__auto___17537 + (1));
i__5628__auto___17537 = G__17538;
continue;
} else {
}
break;
}

var G__17535 = args17533.length;
switch (G__17535) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17533.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_17540 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_17540);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_17540,ret){
return (function (){
return fn1.call(null,val_17540);
});})(val_17540,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args17541 = [];
var len__5627__auto___17544 = arguments.length;
var i__5628__auto___17545 = (0);
while(true){
if((i__5628__auto___17545 < len__5627__auto___17544)){
args17541.push((arguments[i__5628__auto___17545]));

var G__17546 = (i__5628__auto___17545 + (1));
i__5628__auto___17545 = G__17546;
continue;
} else {
}
break;
}

var G__17543 = args17541.length;
switch (G__17543) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17541.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5472__auto___17548 = n;
var x_17549 = (0);
while(true){
if((x_17549 < n__5472__auto___17548)){
(a[x_17549] = (0));

var G__17550 = (x_17549 + (1));
x_17549 = G__17550;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__17551 = (i + (1));
i = G__17551;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async17555 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17555 = (function (alt_flag,flag,meta17556){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta17556 = meta17556;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17555.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_17557,meta17556__$1){
var self__ = this;
var _17557__$1 = this;
return (new cljs.core.async.t_cljs$core$async17555(self__.alt_flag,self__.flag,meta17556__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async17555.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_17557){
var self__ = this;
var _17557__$1 = this;
return self__.meta17556;
});})(flag))
;

cljs.core.async.t_cljs$core$async17555.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17555.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async17555.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17555.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta17556","meta17556",-1412986461,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async17555.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17555.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17555";

cljs.core.async.t_cljs$core$async17555.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async17555");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async17555 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17555(alt_flag__$1,flag__$1,meta17556){
return (new cljs.core.async.t_cljs$core$async17555(alt_flag__$1,flag__$1,meta17556));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async17555(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async17561 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17561 = (function (alt_handler,flag,cb,meta17562){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta17562 = meta17562;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17561.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17563,meta17562__$1){
var self__ = this;
var _17563__$1 = this;
return (new cljs.core.async.t_cljs$core$async17561(self__.alt_handler,self__.flag,self__.cb,meta17562__$1));
});

cljs.core.async.t_cljs$core$async17561.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17563){
var self__ = this;
var _17563__$1 = this;
return self__.meta17562;
});

cljs.core.async.t_cljs$core$async17561.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17561.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async17561.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async17561.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta17562","meta17562",-545624931,null)], null);
});

cljs.core.async.t_cljs$core$async17561.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17561.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17561";

cljs.core.async.t_cljs$core$async17561.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async17561");
});

cljs.core.async.__GT_t_cljs$core$async17561 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17561(alt_handler__$1,flag__$1,cb__$1,meta17562){
return (new cljs.core.async.t_cljs$core$async17561(alt_handler__$1,flag__$1,cb__$1,meta17562));
});

}

return (new cljs.core.async.t_cljs$core$async17561(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17564_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17564_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17565_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17565_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4569__auto__ = wport;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17566 = (i + (1));
i = G__17566;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4569__auto__ = ret;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4557__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___17572 = arguments.length;
var i__5628__auto___17573 = (0);
while(true){
if((i__5628__auto___17573 < len__5627__auto___17572)){
args__5634__auto__.push((arguments[i__5628__auto___17573]));

var G__17574 = (i__5628__auto___17573 + (1));
i__5628__auto___17573 = G__17574;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17569){
var map__17570 = p__17569;
var map__17570__$1 = ((((!((map__17570 == null)))?((((map__17570.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17570.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17570):map__17570);
var opts = map__17570__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17567){
var G__17568 = cljs.core.first.call(null,seq17567);
var seq17567__$1 = cljs.core.next.call(null,seq17567);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17568,seq17567__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args17575 = [];
var len__5627__auto___17625 = arguments.length;
var i__5628__auto___17626 = (0);
while(true){
if((i__5628__auto___17626 < len__5627__auto___17625)){
args17575.push((arguments[i__5628__auto___17626]));

var G__17627 = (i__5628__auto___17626 + (1));
i__5628__auto___17626 = G__17627;
continue;
} else {
}
break;
}

var G__17577 = args17575.length;
switch (G__17577) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17575.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__8400__auto___17629 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8400__auto___17629){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___17629){
return (function (state_17601){
var state_val_17602 = (state_17601[(1)]);
if((state_val_17602 === (7))){
var inst_17597 = (state_17601[(2)]);
var state_17601__$1 = state_17601;
var statearr_17603_17630 = state_17601__$1;
(statearr_17603_17630[(2)] = inst_17597);

(statearr_17603_17630[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17602 === (1))){
var state_17601__$1 = state_17601;
var statearr_17604_17631 = state_17601__$1;
(statearr_17604_17631[(2)] = null);

(statearr_17604_17631[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17602 === (4))){
var inst_17580 = (state_17601[(7)]);
var inst_17580__$1 = (state_17601[(2)]);
var inst_17581 = (inst_17580__$1 == null);
var state_17601__$1 = (function (){var statearr_17605 = state_17601;
(statearr_17605[(7)] = inst_17580__$1);

return statearr_17605;
})();
if(cljs.core.truth_(inst_17581)){
var statearr_17606_17632 = state_17601__$1;
(statearr_17606_17632[(1)] = (5));

} else {
var statearr_17607_17633 = state_17601__$1;
(statearr_17607_17633[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17602 === (13))){
var state_17601__$1 = state_17601;
var statearr_17608_17634 = state_17601__$1;
(statearr_17608_17634[(2)] = null);

(statearr_17608_17634[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17602 === (6))){
var inst_17580 = (state_17601[(7)]);
var state_17601__$1 = state_17601;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17601__$1,(11),to,inst_17580);
} else {
if((state_val_17602 === (3))){
var inst_17599 = (state_17601[(2)]);
var state_17601__$1 = state_17601;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17601__$1,inst_17599);
} else {
if((state_val_17602 === (12))){
var state_17601__$1 = state_17601;
var statearr_17609_17635 = state_17601__$1;
(statearr_17609_17635[(2)] = null);

(statearr_17609_17635[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17602 === (2))){
var state_17601__$1 = state_17601;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17601__$1,(4),from);
} else {
if((state_val_17602 === (11))){
var inst_17590 = (state_17601[(2)]);
var state_17601__$1 = state_17601;
if(cljs.core.truth_(inst_17590)){
var statearr_17610_17636 = state_17601__$1;
(statearr_17610_17636[(1)] = (12));

} else {
var statearr_17611_17637 = state_17601__$1;
(statearr_17611_17637[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17602 === (9))){
var state_17601__$1 = state_17601;
var statearr_17612_17638 = state_17601__$1;
(statearr_17612_17638[(2)] = null);

(statearr_17612_17638[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17602 === (5))){
var state_17601__$1 = state_17601;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17613_17639 = state_17601__$1;
(statearr_17613_17639[(1)] = (8));

} else {
var statearr_17614_17640 = state_17601__$1;
(statearr_17614_17640[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17602 === (14))){
var inst_17595 = (state_17601[(2)]);
var state_17601__$1 = state_17601;
var statearr_17615_17641 = state_17601__$1;
(statearr_17615_17641[(2)] = inst_17595);

(statearr_17615_17641[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17602 === (10))){
var inst_17587 = (state_17601[(2)]);
var state_17601__$1 = state_17601;
var statearr_17616_17642 = state_17601__$1;
(statearr_17616_17642[(2)] = inst_17587);

(statearr_17616_17642[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17602 === (8))){
var inst_17584 = cljs.core.async.close_BANG_.call(null,to);
var state_17601__$1 = state_17601;
var statearr_17617_17643 = state_17601__$1;
(statearr_17617_17643[(2)] = inst_17584);

(statearr_17617_17643[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___17629))
;
return ((function (switch__8335__auto__,c__8400__auto___17629){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_17621 = [null,null,null,null,null,null,null,null];
(statearr_17621[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_17621[(1)] = (1));

return statearr_17621;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_17601){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_17601);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e17622){if((e17622 instanceof Object)){
var ex__8339__auto__ = e17622;
var statearr_17623_17644 = state_17601;
(statearr_17623_17644[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17601);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17622;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17645 = state_17601;
state_17601 = G__17645;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_17601){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_17601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___17629))
})();
var state__8402__auto__ = (function (){var statearr_17624 = f__8401__auto__.call(null);
(statearr_17624[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___17629);

return statearr_17624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});})(c__8400__auto___17629))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__17829){
var vec__17830 = p__17829;
var v = cljs.core.nth.call(null,vec__17830,(0),null);
var p = cljs.core.nth.call(null,vec__17830,(1),null);
var job = vec__17830;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__8400__auto___18012 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8400__auto___18012,res,vec__17830,v,p,job,jobs,results){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___18012,res,vec__17830,v,p,job,jobs,results){
return (function (state_17835){
var state_val_17836 = (state_17835[(1)]);
if((state_val_17836 === (1))){
var state_17835__$1 = state_17835;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17835__$1,(2),res,v);
} else {
if((state_val_17836 === (2))){
var inst_17832 = (state_17835[(2)]);
var inst_17833 = cljs.core.async.close_BANG_.call(null,res);
var state_17835__$1 = (function (){var statearr_17837 = state_17835;
(statearr_17837[(7)] = inst_17832);

return statearr_17837;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17835__$1,inst_17833);
} else {
return null;
}
}
});})(c__8400__auto___18012,res,vec__17830,v,p,job,jobs,results))
;
return ((function (switch__8335__auto__,c__8400__auto___18012,res,vec__17830,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_17841 = [null,null,null,null,null,null,null,null];
(statearr_17841[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__);

(statearr_17841[(1)] = (1));

return statearr_17841;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1 = (function (state_17835){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_17835);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e17842){if((e17842 instanceof Object)){
var ex__8339__auto__ = e17842;
var statearr_17843_18013 = state_17835;
(statearr_17843_18013[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17835);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17842;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18014 = state_17835;
state_17835 = G__18014;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = function(state_17835){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1.call(this,state_17835);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___18012,res,vec__17830,v,p,job,jobs,results))
})();
var state__8402__auto__ = (function (){var statearr_17844 = f__8401__auto__.call(null);
(statearr_17844[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___18012);

return statearr_17844;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});})(c__8400__auto___18012,res,vec__17830,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17845){
var vec__17846 = p__17845;
var v = cljs.core.nth.call(null,vec__17846,(0),null);
var p = cljs.core.nth.call(null,vec__17846,(1),null);
var job = vec__17846;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5472__auto___18015 = n;
var __18016 = (0);
while(true){
if((__18016 < n__5472__auto___18015)){
var G__17847_18017 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__17847_18017) {
case "compute":
var c__8400__auto___18019 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__18016,c__8400__auto___18019,G__17847_18017,n__5472__auto___18015,jobs,results,process,async){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (__18016,c__8400__auto___18019,G__17847_18017,n__5472__auto___18015,jobs,results,process,async){
return (function (state_17860){
var state_val_17861 = (state_17860[(1)]);
if((state_val_17861 === (1))){
var state_17860__$1 = state_17860;
var statearr_17862_18020 = state_17860__$1;
(statearr_17862_18020[(2)] = null);

(statearr_17862_18020[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17861 === (2))){
var state_17860__$1 = state_17860;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17860__$1,(4),jobs);
} else {
if((state_val_17861 === (3))){
var inst_17858 = (state_17860[(2)]);
var state_17860__$1 = state_17860;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17860__$1,inst_17858);
} else {
if((state_val_17861 === (4))){
var inst_17850 = (state_17860[(2)]);
var inst_17851 = process.call(null,inst_17850);
var state_17860__$1 = state_17860;
if(cljs.core.truth_(inst_17851)){
var statearr_17863_18021 = state_17860__$1;
(statearr_17863_18021[(1)] = (5));

} else {
var statearr_17864_18022 = state_17860__$1;
(statearr_17864_18022[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17861 === (5))){
var state_17860__$1 = state_17860;
var statearr_17865_18023 = state_17860__$1;
(statearr_17865_18023[(2)] = null);

(statearr_17865_18023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17861 === (6))){
var state_17860__$1 = state_17860;
var statearr_17866_18024 = state_17860__$1;
(statearr_17866_18024[(2)] = null);

(statearr_17866_18024[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17861 === (7))){
var inst_17856 = (state_17860[(2)]);
var state_17860__$1 = state_17860;
var statearr_17867_18025 = state_17860__$1;
(statearr_17867_18025[(2)] = inst_17856);

(statearr_17867_18025[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__18016,c__8400__auto___18019,G__17847_18017,n__5472__auto___18015,jobs,results,process,async))
;
return ((function (__18016,switch__8335__auto__,c__8400__auto___18019,G__17847_18017,n__5472__auto___18015,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_17871 = [null,null,null,null,null,null,null];
(statearr_17871[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__);

(statearr_17871[(1)] = (1));

return statearr_17871;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1 = (function (state_17860){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_17860);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e17872){if((e17872 instanceof Object)){
var ex__8339__auto__ = e17872;
var statearr_17873_18026 = state_17860;
(statearr_17873_18026[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17860);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17872;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18027 = state_17860;
state_17860 = G__18027;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = function(state_17860){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1.call(this,state_17860);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__;
})()
;})(__18016,switch__8335__auto__,c__8400__auto___18019,G__17847_18017,n__5472__auto___18015,jobs,results,process,async))
})();
var state__8402__auto__ = (function (){var statearr_17874 = f__8401__auto__.call(null);
(statearr_17874[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___18019);

return statearr_17874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});})(__18016,c__8400__auto___18019,G__17847_18017,n__5472__auto___18015,jobs,results,process,async))
);


break;
case "async":
var c__8400__auto___18028 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__18016,c__8400__auto___18028,G__17847_18017,n__5472__auto___18015,jobs,results,process,async){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (__18016,c__8400__auto___18028,G__17847_18017,n__5472__auto___18015,jobs,results,process,async){
return (function (state_17887){
var state_val_17888 = (state_17887[(1)]);
if((state_val_17888 === (1))){
var state_17887__$1 = state_17887;
var statearr_17889_18029 = state_17887__$1;
(statearr_17889_18029[(2)] = null);

(statearr_17889_18029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17888 === (2))){
var state_17887__$1 = state_17887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17887__$1,(4),jobs);
} else {
if((state_val_17888 === (3))){
var inst_17885 = (state_17887[(2)]);
var state_17887__$1 = state_17887;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17887__$1,inst_17885);
} else {
if((state_val_17888 === (4))){
var inst_17877 = (state_17887[(2)]);
var inst_17878 = async.call(null,inst_17877);
var state_17887__$1 = state_17887;
if(cljs.core.truth_(inst_17878)){
var statearr_17890_18030 = state_17887__$1;
(statearr_17890_18030[(1)] = (5));

} else {
var statearr_17891_18031 = state_17887__$1;
(statearr_17891_18031[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17888 === (5))){
var state_17887__$1 = state_17887;
var statearr_17892_18032 = state_17887__$1;
(statearr_17892_18032[(2)] = null);

(statearr_17892_18032[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17888 === (6))){
var state_17887__$1 = state_17887;
var statearr_17893_18033 = state_17887__$1;
(statearr_17893_18033[(2)] = null);

(statearr_17893_18033[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17888 === (7))){
var inst_17883 = (state_17887[(2)]);
var state_17887__$1 = state_17887;
var statearr_17894_18034 = state_17887__$1;
(statearr_17894_18034[(2)] = inst_17883);

(statearr_17894_18034[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__18016,c__8400__auto___18028,G__17847_18017,n__5472__auto___18015,jobs,results,process,async))
;
return ((function (__18016,switch__8335__auto__,c__8400__auto___18028,G__17847_18017,n__5472__auto___18015,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_17898 = [null,null,null,null,null,null,null];
(statearr_17898[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__);

(statearr_17898[(1)] = (1));

return statearr_17898;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1 = (function (state_17887){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_17887);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e17899){if((e17899 instanceof Object)){
var ex__8339__auto__ = e17899;
var statearr_17900_18035 = state_17887;
(statearr_17900_18035[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17887);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17899;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18036 = state_17887;
state_17887 = G__18036;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = function(state_17887){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1.call(this,state_17887);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__;
})()
;})(__18016,switch__8335__auto__,c__8400__auto___18028,G__17847_18017,n__5472__auto___18015,jobs,results,process,async))
})();
var state__8402__auto__ = (function (){var statearr_17901 = f__8401__auto__.call(null);
(statearr_17901[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___18028);

return statearr_17901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});})(__18016,c__8400__auto___18028,G__17847_18017,n__5472__auto___18015,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__18037 = (__18016 + (1));
__18016 = G__18037;
continue;
} else {
}
break;
}

var c__8400__auto___18038 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8400__auto___18038,jobs,results,process,async){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___18038,jobs,results,process,async){
return (function (state_17923){
var state_val_17924 = (state_17923[(1)]);
if((state_val_17924 === (1))){
var state_17923__$1 = state_17923;
var statearr_17925_18039 = state_17923__$1;
(statearr_17925_18039[(2)] = null);

(statearr_17925_18039[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17924 === (2))){
var state_17923__$1 = state_17923;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17923__$1,(4),from);
} else {
if((state_val_17924 === (3))){
var inst_17921 = (state_17923[(2)]);
var state_17923__$1 = state_17923;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17923__$1,inst_17921);
} else {
if((state_val_17924 === (4))){
var inst_17904 = (state_17923[(7)]);
var inst_17904__$1 = (state_17923[(2)]);
var inst_17905 = (inst_17904__$1 == null);
var state_17923__$1 = (function (){var statearr_17926 = state_17923;
(statearr_17926[(7)] = inst_17904__$1);

return statearr_17926;
})();
if(cljs.core.truth_(inst_17905)){
var statearr_17927_18040 = state_17923__$1;
(statearr_17927_18040[(1)] = (5));

} else {
var statearr_17928_18041 = state_17923__$1;
(statearr_17928_18041[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17924 === (5))){
var inst_17907 = cljs.core.async.close_BANG_.call(null,jobs);
var state_17923__$1 = state_17923;
var statearr_17929_18042 = state_17923__$1;
(statearr_17929_18042[(2)] = inst_17907);

(statearr_17929_18042[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17924 === (6))){
var inst_17909 = (state_17923[(8)]);
var inst_17904 = (state_17923[(7)]);
var inst_17909__$1 = cljs.core.async.chan.call(null,(1));
var inst_17910 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17911 = [inst_17904,inst_17909__$1];
var inst_17912 = (new cljs.core.PersistentVector(null,2,(5),inst_17910,inst_17911,null));
var state_17923__$1 = (function (){var statearr_17930 = state_17923;
(statearr_17930[(8)] = inst_17909__$1);

return statearr_17930;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17923__$1,(8),jobs,inst_17912);
} else {
if((state_val_17924 === (7))){
var inst_17919 = (state_17923[(2)]);
var state_17923__$1 = state_17923;
var statearr_17931_18043 = state_17923__$1;
(statearr_17931_18043[(2)] = inst_17919);

(statearr_17931_18043[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17924 === (8))){
var inst_17909 = (state_17923[(8)]);
var inst_17914 = (state_17923[(2)]);
var state_17923__$1 = (function (){var statearr_17932 = state_17923;
(statearr_17932[(9)] = inst_17914);

return statearr_17932;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17923__$1,(9),results,inst_17909);
} else {
if((state_val_17924 === (9))){
var inst_17916 = (state_17923[(2)]);
var state_17923__$1 = (function (){var statearr_17933 = state_17923;
(statearr_17933[(10)] = inst_17916);

return statearr_17933;
})();
var statearr_17934_18044 = state_17923__$1;
(statearr_17934_18044[(2)] = null);

(statearr_17934_18044[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___18038,jobs,results,process,async))
;
return ((function (switch__8335__auto__,c__8400__auto___18038,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_17938 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17938[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__);

(statearr_17938[(1)] = (1));

return statearr_17938;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1 = (function (state_17923){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_17923);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e17939){if((e17939 instanceof Object)){
var ex__8339__auto__ = e17939;
var statearr_17940_18045 = state_17923;
(statearr_17940_18045[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17923);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17939;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18046 = state_17923;
state_17923 = G__18046;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = function(state_17923){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1.call(this,state_17923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___18038,jobs,results,process,async))
})();
var state__8402__auto__ = (function (){var statearr_17941 = f__8401__auto__.call(null);
(statearr_17941[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___18038);

return statearr_17941;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});})(c__8400__auto___18038,jobs,results,process,async))
);


var c__8400__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8400__auto__,jobs,results,process,async){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto__,jobs,results,process,async){
return (function (state_17979){
var state_val_17980 = (state_17979[(1)]);
if((state_val_17980 === (7))){
var inst_17975 = (state_17979[(2)]);
var state_17979__$1 = state_17979;
var statearr_17981_18047 = state_17979__$1;
(statearr_17981_18047[(2)] = inst_17975);

(statearr_17981_18047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17980 === (20))){
var state_17979__$1 = state_17979;
var statearr_17982_18048 = state_17979__$1;
(statearr_17982_18048[(2)] = null);

(statearr_17982_18048[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17980 === (1))){
var state_17979__$1 = state_17979;
var statearr_17983_18049 = state_17979__$1;
(statearr_17983_18049[(2)] = null);

(statearr_17983_18049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17980 === (4))){
var inst_17944 = (state_17979[(7)]);
var inst_17944__$1 = (state_17979[(2)]);
var inst_17945 = (inst_17944__$1 == null);
var state_17979__$1 = (function (){var statearr_17984 = state_17979;
(statearr_17984[(7)] = inst_17944__$1);

return statearr_17984;
})();
if(cljs.core.truth_(inst_17945)){
var statearr_17985_18050 = state_17979__$1;
(statearr_17985_18050[(1)] = (5));

} else {
var statearr_17986_18051 = state_17979__$1;
(statearr_17986_18051[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17980 === (15))){
var inst_17957 = (state_17979[(8)]);
var state_17979__$1 = state_17979;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17979__$1,(18),to,inst_17957);
} else {
if((state_val_17980 === (21))){
var inst_17970 = (state_17979[(2)]);
var state_17979__$1 = state_17979;
var statearr_17987_18052 = state_17979__$1;
(statearr_17987_18052[(2)] = inst_17970);

(statearr_17987_18052[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17980 === (13))){
var inst_17972 = (state_17979[(2)]);
var state_17979__$1 = (function (){var statearr_17988 = state_17979;
(statearr_17988[(9)] = inst_17972);

return statearr_17988;
})();
var statearr_17989_18053 = state_17979__$1;
(statearr_17989_18053[(2)] = null);

(statearr_17989_18053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17980 === (6))){
var inst_17944 = (state_17979[(7)]);
var state_17979__$1 = state_17979;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17979__$1,(11),inst_17944);
} else {
if((state_val_17980 === (17))){
var inst_17965 = (state_17979[(2)]);
var state_17979__$1 = state_17979;
if(cljs.core.truth_(inst_17965)){
var statearr_17990_18054 = state_17979__$1;
(statearr_17990_18054[(1)] = (19));

} else {
var statearr_17991_18055 = state_17979__$1;
(statearr_17991_18055[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17980 === (3))){
var inst_17977 = (state_17979[(2)]);
var state_17979__$1 = state_17979;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17979__$1,inst_17977);
} else {
if((state_val_17980 === (12))){
var inst_17954 = (state_17979[(10)]);
var state_17979__$1 = state_17979;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17979__$1,(14),inst_17954);
} else {
if((state_val_17980 === (2))){
var state_17979__$1 = state_17979;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17979__$1,(4),results);
} else {
if((state_val_17980 === (19))){
var state_17979__$1 = state_17979;
var statearr_17992_18056 = state_17979__$1;
(statearr_17992_18056[(2)] = null);

(statearr_17992_18056[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17980 === (11))){
var inst_17954 = (state_17979[(2)]);
var state_17979__$1 = (function (){var statearr_17993 = state_17979;
(statearr_17993[(10)] = inst_17954);

return statearr_17993;
})();
var statearr_17994_18057 = state_17979__$1;
(statearr_17994_18057[(2)] = null);

(statearr_17994_18057[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17980 === (9))){
var state_17979__$1 = state_17979;
var statearr_17995_18058 = state_17979__$1;
(statearr_17995_18058[(2)] = null);

(statearr_17995_18058[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17980 === (5))){
var state_17979__$1 = state_17979;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17996_18059 = state_17979__$1;
(statearr_17996_18059[(1)] = (8));

} else {
var statearr_17997_18060 = state_17979__$1;
(statearr_17997_18060[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17980 === (14))){
var inst_17959 = (state_17979[(11)]);
var inst_17957 = (state_17979[(8)]);
var inst_17957__$1 = (state_17979[(2)]);
var inst_17958 = (inst_17957__$1 == null);
var inst_17959__$1 = cljs.core.not.call(null,inst_17958);
var state_17979__$1 = (function (){var statearr_17998 = state_17979;
(statearr_17998[(11)] = inst_17959__$1);

(statearr_17998[(8)] = inst_17957__$1);

return statearr_17998;
})();
if(inst_17959__$1){
var statearr_17999_18061 = state_17979__$1;
(statearr_17999_18061[(1)] = (15));

} else {
var statearr_18000_18062 = state_17979__$1;
(statearr_18000_18062[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17980 === (16))){
var inst_17959 = (state_17979[(11)]);
var state_17979__$1 = state_17979;
var statearr_18001_18063 = state_17979__$1;
(statearr_18001_18063[(2)] = inst_17959);

(statearr_18001_18063[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17980 === (10))){
var inst_17951 = (state_17979[(2)]);
var state_17979__$1 = state_17979;
var statearr_18002_18064 = state_17979__$1;
(statearr_18002_18064[(2)] = inst_17951);

(statearr_18002_18064[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17980 === (18))){
var inst_17962 = (state_17979[(2)]);
var state_17979__$1 = state_17979;
var statearr_18003_18065 = state_17979__$1;
(statearr_18003_18065[(2)] = inst_17962);

(statearr_18003_18065[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17980 === (8))){
var inst_17948 = cljs.core.async.close_BANG_.call(null,to);
var state_17979__$1 = state_17979;
var statearr_18004_18066 = state_17979__$1;
(statearr_18004_18066[(2)] = inst_17948);

(statearr_18004_18066[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto__,jobs,results,process,async))
;
return ((function (switch__8335__auto__,c__8400__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_18008 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18008[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__);

(statearr_18008[(1)] = (1));

return statearr_18008;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1 = (function (state_17979){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_17979);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e18009){if((e18009 instanceof Object)){
var ex__8339__auto__ = e18009;
var statearr_18010_18067 = state_17979;
(statearr_18010_18067[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17979);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18009;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18068 = state_17979;
state_17979 = G__18068;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = function(state_17979){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1.call(this,state_17979);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto__,jobs,results,process,async))
})();
var state__8402__auto__ = (function (){var statearr_18011 = f__8401__auto__.call(null);
(statearr_18011[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto__);

return statearr_18011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});})(c__8400__auto__,jobs,results,process,async))
);

return c__8400__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args18069 = [];
var len__5627__auto___18072 = arguments.length;
var i__5628__auto___18073 = (0);
while(true){
if((i__5628__auto___18073 < len__5627__auto___18072)){
args18069.push((arguments[i__5628__auto___18073]));

var G__18074 = (i__5628__auto___18073 + (1));
i__5628__auto___18073 = G__18074;
continue;
} else {
}
break;
}

var G__18071 = args18069.length;
switch (G__18071) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18069.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args18076 = [];
var len__5627__auto___18079 = arguments.length;
var i__5628__auto___18080 = (0);
while(true){
if((i__5628__auto___18080 < len__5627__auto___18079)){
args18076.push((arguments[i__5628__auto___18080]));

var G__18081 = (i__5628__auto___18080 + (1));
i__5628__auto___18080 = G__18081;
continue;
} else {
}
break;
}

var G__18078 = args18076.length;
switch (G__18078) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18076.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args18083 = [];
var len__5627__auto___18136 = arguments.length;
var i__5628__auto___18137 = (0);
while(true){
if((i__5628__auto___18137 < len__5627__auto___18136)){
args18083.push((arguments[i__5628__auto___18137]));

var G__18138 = (i__5628__auto___18137 + (1));
i__5628__auto___18137 = G__18138;
continue;
} else {
}
break;
}

var G__18085 = args18083.length;
switch (G__18085) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18083.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__8400__auto___18140 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8400__auto___18140,tc,fc){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___18140,tc,fc){
return (function (state_18111){
var state_val_18112 = (state_18111[(1)]);
if((state_val_18112 === (7))){
var inst_18107 = (state_18111[(2)]);
var state_18111__$1 = state_18111;
var statearr_18113_18141 = state_18111__$1;
(statearr_18113_18141[(2)] = inst_18107);

(statearr_18113_18141[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18112 === (1))){
var state_18111__$1 = state_18111;
var statearr_18114_18142 = state_18111__$1;
(statearr_18114_18142[(2)] = null);

(statearr_18114_18142[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18112 === (4))){
var inst_18088 = (state_18111[(7)]);
var inst_18088__$1 = (state_18111[(2)]);
var inst_18089 = (inst_18088__$1 == null);
var state_18111__$1 = (function (){var statearr_18115 = state_18111;
(statearr_18115[(7)] = inst_18088__$1);

return statearr_18115;
})();
if(cljs.core.truth_(inst_18089)){
var statearr_18116_18143 = state_18111__$1;
(statearr_18116_18143[(1)] = (5));

} else {
var statearr_18117_18144 = state_18111__$1;
(statearr_18117_18144[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18112 === (13))){
var state_18111__$1 = state_18111;
var statearr_18118_18145 = state_18111__$1;
(statearr_18118_18145[(2)] = null);

(statearr_18118_18145[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18112 === (6))){
var inst_18088 = (state_18111[(7)]);
var inst_18094 = p.call(null,inst_18088);
var state_18111__$1 = state_18111;
if(cljs.core.truth_(inst_18094)){
var statearr_18119_18146 = state_18111__$1;
(statearr_18119_18146[(1)] = (9));

} else {
var statearr_18120_18147 = state_18111__$1;
(statearr_18120_18147[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18112 === (3))){
var inst_18109 = (state_18111[(2)]);
var state_18111__$1 = state_18111;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18111__$1,inst_18109);
} else {
if((state_val_18112 === (12))){
var state_18111__$1 = state_18111;
var statearr_18121_18148 = state_18111__$1;
(statearr_18121_18148[(2)] = null);

(statearr_18121_18148[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18112 === (2))){
var state_18111__$1 = state_18111;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18111__$1,(4),ch);
} else {
if((state_val_18112 === (11))){
var inst_18088 = (state_18111[(7)]);
var inst_18098 = (state_18111[(2)]);
var state_18111__$1 = state_18111;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18111__$1,(8),inst_18098,inst_18088);
} else {
if((state_val_18112 === (9))){
var state_18111__$1 = state_18111;
var statearr_18122_18149 = state_18111__$1;
(statearr_18122_18149[(2)] = tc);

(statearr_18122_18149[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18112 === (5))){
var inst_18091 = cljs.core.async.close_BANG_.call(null,tc);
var inst_18092 = cljs.core.async.close_BANG_.call(null,fc);
var state_18111__$1 = (function (){var statearr_18123 = state_18111;
(statearr_18123[(8)] = inst_18091);

return statearr_18123;
})();
var statearr_18124_18150 = state_18111__$1;
(statearr_18124_18150[(2)] = inst_18092);

(statearr_18124_18150[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18112 === (14))){
var inst_18105 = (state_18111[(2)]);
var state_18111__$1 = state_18111;
var statearr_18125_18151 = state_18111__$1;
(statearr_18125_18151[(2)] = inst_18105);

(statearr_18125_18151[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18112 === (10))){
var state_18111__$1 = state_18111;
var statearr_18126_18152 = state_18111__$1;
(statearr_18126_18152[(2)] = fc);

(statearr_18126_18152[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18112 === (8))){
var inst_18100 = (state_18111[(2)]);
var state_18111__$1 = state_18111;
if(cljs.core.truth_(inst_18100)){
var statearr_18127_18153 = state_18111__$1;
(statearr_18127_18153[(1)] = (12));

} else {
var statearr_18128_18154 = state_18111__$1;
(statearr_18128_18154[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___18140,tc,fc))
;
return ((function (switch__8335__auto__,c__8400__auto___18140,tc,fc){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_18132 = [null,null,null,null,null,null,null,null,null];
(statearr_18132[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_18132[(1)] = (1));

return statearr_18132;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_18111){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_18111);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e18133){if((e18133 instanceof Object)){
var ex__8339__auto__ = e18133;
var statearr_18134_18155 = state_18111;
(statearr_18134_18155[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18111);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18133;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18156 = state_18111;
state_18111 = G__18156;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_18111){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_18111);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___18140,tc,fc))
})();
var state__8402__auto__ = (function (){var statearr_18135 = f__8401__auto__.call(null);
(statearr_18135[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___18140);

return statearr_18135;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});})(c__8400__auto___18140,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__8400__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8400__auto__){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto__){
return (function (state_18203){
var state_val_18204 = (state_18203[(1)]);
if((state_val_18204 === (1))){
var inst_18189 = init;
var state_18203__$1 = (function (){var statearr_18205 = state_18203;
(statearr_18205[(7)] = inst_18189);

return statearr_18205;
})();
var statearr_18206_18221 = state_18203__$1;
(statearr_18206_18221[(2)] = null);

(statearr_18206_18221[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18204 === (2))){
var state_18203__$1 = state_18203;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18203__$1,(4),ch);
} else {
if((state_val_18204 === (3))){
var inst_18201 = (state_18203[(2)]);
var state_18203__$1 = state_18203;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18203__$1,inst_18201);
} else {
if((state_val_18204 === (4))){
var inst_18192 = (state_18203[(8)]);
var inst_18192__$1 = (state_18203[(2)]);
var inst_18193 = (inst_18192__$1 == null);
var state_18203__$1 = (function (){var statearr_18207 = state_18203;
(statearr_18207[(8)] = inst_18192__$1);

return statearr_18207;
})();
if(cljs.core.truth_(inst_18193)){
var statearr_18208_18222 = state_18203__$1;
(statearr_18208_18222[(1)] = (5));

} else {
var statearr_18209_18223 = state_18203__$1;
(statearr_18209_18223[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18204 === (5))){
var inst_18189 = (state_18203[(7)]);
var state_18203__$1 = state_18203;
var statearr_18210_18224 = state_18203__$1;
(statearr_18210_18224[(2)] = inst_18189);

(statearr_18210_18224[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18204 === (6))){
var inst_18192 = (state_18203[(8)]);
var inst_18189 = (state_18203[(7)]);
var inst_18196 = f.call(null,inst_18189,inst_18192);
var inst_18189__$1 = inst_18196;
var state_18203__$1 = (function (){var statearr_18211 = state_18203;
(statearr_18211[(7)] = inst_18189__$1);

return statearr_18211;
})();
var statearr_18212_18225 = state_18203__$1;
(statearr_18212_18225[(2)] = null);

(statearr_18212_18225[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18204 === (7))){
var inst_18199 = (state_18203[(2)]);
var state_18203__$1 = state_18203;
var statearr_18213_18226 = state_18203__$1;
(statearr_18213_18226[(2)] = inst_18199);

(statearr_18213_18226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__8400__auto__))
;
return ((function (switch__8335__auto__,c__8400__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__8336__auto__ = null;
var cljs$core$async$reduce_$_state_machine__8336__auto____0 = (function (){
var statearr_18217 = [null,null,null,null,null,null,null,null,null];
(statearr_18217[(0)] = cljs$core$async$reduce_$_state_machine__8336__auto__);

(statearr_18217[(1)] = (1));

return statearr_18217;
});
var cljs$core$async$reduce_$_state_machine__8336__auto____1 = (function (state_18203){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_18203);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e18218){if((e18218 instanceof Object)){
var ex__8339__auto__ = e18218;
var statearr_18219_18227 = state_18203;
(statearr_18219_18227[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18203);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18218;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18228 = state_18203;
state_18203 = G__18228;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__8336__auto__ = function(state_18203){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__8336__auto____1.call(this,state_18203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__8336__auto____0;
cljs$core$async$reduce_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__8336__auto____1;
return cljs$core$async$reduce_$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto__))
})();
var state__8402__auto__ = (function (){var statearr_18220 = f__8401__auto__.call(null);
(statearr_18220[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto__);

return statearr_18220;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});})(c__8400__auto__))
);

return c__8400__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args18229 = [];
var len__5627__auto___18281 = arguments.length;
var i__5628__auto___18282 = (0);
while(true){
if((i__5628__auto___18282 < len__5627__auto___18281)){
args18229.push((arguments[i__5628__auto___18282]));

var G__18283 = (i__5628__auto___18282 + (1));
i__5628__auto___18282 = G__18283;
continue;
} else {
}
break;
}

var G__18231 = args18229.length;
switch (G__18231) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18229.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__8400__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8400__auto__){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto__){
return (function (state_18256){
var state_val_18257 = (state_18256[(1)]);
if((state_val_18257 === (7))){
var inst_18238 = (state_18256[(2)]);
var state_18256__$1 = state_18256;
var statearr_18258_18285 = state_18256__$1;
(statearr_18258_18285[(2)] = inst_18238);

(statearr_18258_18285[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18257 === (1))){
var inst_18232 = cljs.core.seq.call(null,coll);
var inst_18233 = inst_18232;
var state_18256__$1 = (function (){var statearr_18259 = state_18256;
(statearr_18259[(7)] = inst_18233);

return statearr_18259;
})();
var statearr_18260_18286 = state_18256__$1;
(statearr_18260_18286[(2)] = null);

(statearr_18260_18286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18257 === (4))){
var inst_18233 = (state_18256[(7)]);
var inst_18236 = cljs.core.first.call(null,inst_18233);
var state_18256__$1 = state_18256;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18256__$1,(7),ch,inst_18236);
} else {
if((state_val_18257 === (13))){
var inst_18250 = (state_18256[(2)]);
var state_18256__$1 = state_18256;
var statearr_18261_18287 = state_18256__$1;
(statearr_18261_18287[(2)] = inst_18250);

(statearr_18261_18287[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18257 === (6))){
var inst_18241 = (state_18256[(2)]);
var state_18256__$1 = state_18256;
if(cljs.core.truth_(inst_18241)){
var statearr_18262_18288 = state_18256__$1;
(statearr_18262_18288[(1)] = (8));

} else {
var statearr_18263_18289 = state_18256__$1;
(statearr_18263_18289[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18257 === (3))){
var inst_18254 = (state_18256[(2)]);
var state_18256__$1 = state_18256;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18256__$1,inst_18254);
} else {
if((state_val_18257 === (12))){
var state_18256__$1 = state_18256;
var statearr_18264_18290 = state_18256__$1;
(statearr_18264_18290[(2)] = null);

(statearr_18264_18290[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18257 === (2))){
var inst_18233 = (state_18256[(7)]);
var state_18256__$1 = state_18256;
if(cljs.core.truth_(inst_18233)){
var statearr_18265_18291 = state_18256__$1;
(statearr_18265_18291[(1)] = (4));

} else {
var statearr_18266_18292 = state_18256__$1;
(statearr_18266_18292[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18257 === (11))){
var inst_18247 = cljs.core.async.close_BANG_.call(null,ch);
var state_18256__$1 = state_18256;
var statearr_18267_18293 = state_18256__$1;
(statearr_18267_18293[(2)] = inst_18247);

(statearr_18267_18293[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18257 === (9))){
var state_18256__$1 = state_18256;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18268_18294 = state_18256__$1;
(statearr_18268_18294[(1)] = (11));

} else {
var statearr_18269_18295 = state_18256__$1;
(statearr_18269_18295[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18257 === (5))){
var inst_18233 = (state_18256[(7)]);
var state_18256__$1 = state_18256;
var statearr_18270_18296 = state_18256__$1;
(statearr_18270_18296[(2)] = inst_18233);

(statearr_18270_18296[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18257 === (10))){
var inst_18252 = (state_18256[(2)]);
var state_18256__$1 = state_18256;
var statearr_18271_18297 = state_18256__$1;
(statearr_18271_18297[(2)] = inst_18252);

(statearr_18271_18297[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18257 === (8))){
var inst_18233 = (state_18256[(7)]);
var inst_18243 = cljs.core.next.call(null,inst_18233);
var inst_18233__$1 = inst_18243;
var state_18256__$1 = (function (){var statearr_18272 = state_18256;
(statearr_18272[(7)] = inst_18233__$1);

return statearr_18272;
})();
var statearr_18273_18298 = state_18256__$1;
(statearr_18273_18298[(2)] = null);

(statearr_18273_18298[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto__))
;
return ((function (switch__8335__auto__,c__8400__auto__){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_18277 = [null,null,null,null,null,null,null,null];
(statearr_18277[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_18277[(1)] = (1));

return statearr_18277;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_18256){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_18256);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e18278){if((e18278 instanceof Object)){
var ex__8339__auto__ = e18278;
var statearr_18279_18299 = state_18256;
(statearr_18279_18299[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18256);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18278;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18300 = state_18256;
state_18256 = G__18300;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_18256){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_18256);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto__))
})();
var state__8402__auto__ = (function (){var statearr_18280 = f__8401__auto__.call(null);
(statearr_18280[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto__);

return statearr_18280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});})(c__8400__auto__))
);

return c__8400__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5224__auto__ = (((_ == null))?null:_);
var m__5225__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,_);
} else {
var m__5225__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5225__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m);
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18522 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18522 = (function (mult,ch,cs,meta18523){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta18523 = meta18523;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18522.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_18524,meta18523__$1){
var self__ = this;
var _18524__$1 = this;
return (new cljs.core.async.t_cljs$core$async18522(self__.mult,self__.ch,self__.cs,meta18523__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async18522.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_18524){
var self__ = this;
var _18524__$1 = this;
return self__.meta18523;
});})(cs))
;

cljs.core.async.t_cljs$core$async18522.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18522.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async18522.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async18522.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18522.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18522.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18522.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta18523","meta18523",1791250196,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async18522.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18522.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18522";

cljs.core.async.t_cljs$core$async18522.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async18522");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async18522 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async18522(mult__$1,ch__$1,cs__$1,meta18523){
return (new cljs.core.async.t_cljs$core$async18522(mult__$1,ch__$1,cs__$1,meta18523));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async18522(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__8400__auto___18743 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8400__auto___18743,cs,m,dchan,dctr,done){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___18743,cs,m,dchan,dctr,done){
return (function (state_18655){
var state_val_18656 = (state_18655[(1)]);
if((state_val_18656 === (7))){
var inst_18651 = (state_18655[(2)]);
var state_18655__$1 = state_18655;
var statearr_18657_18744 = state_18655__$1;
(statearr_18657_18744[(2)] = inst_18651);

(statearr_18657_18744[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (20))){
var inst_18556 = (state_18655[(7)]);
var inst_18566 = cljs.core.first.call(null,inst_18556);
var inst_18567 = cljs.core.nth.call(null,inst_18566,(0),null);
var inst_18568 = cljs.core.nth.call(null,inst_18566,(1),null);
var state_18655__$1 = (function (){var statearr_18658 = state_18655;
(statearr_18658[(8)] = inst_18567);

return statearr_18658;
})();
if(cljs.core.truth_(inst_18568)){
var statearr_18659_18745 = state_18655__$1;
(statearr_18659_18745[(1)] = (22));

} else {
var statearr_18660_18746 = state_18655__$1;
(statearr_18660_18746[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (27))){
var inst_18598 = (state_18655[(9)]);
var inst_18596 = (state_18655[(10)]);
var inst_18603 = (state_18655[(11)]);
var inst_18527 = (state_18655[(12)]);
var inst_18603__$1 = cljs.core._nth.call(null,inst_18596,inst_18598);
var inst_18604 = cljs.core.async.put_BANG_.call(null,inst_18603__$1,inst_18527,done);
var state_18655__$1 = (function (){var statearr_18661 = state_18655;
(statearr_18661[(11)] = inst_18603__$1);

return statearr_18661;
})();
if(cljs.core.truth_(inst_18604)){
var statearr_18662_18747 = state_18655__$1;
(statearr_18662_18747[(1)] = (30));

} else {
var statearr_18663_18748 = state_18655__$1;
(statearr_18663_18748[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (1))){
var state_18655__$1 = state_18655;
var statearr_18664_18749 = state_18655__$1;
(statearr_18664_18749[(2)] = null);

(statearr_18664_18749[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (24))){
var inst_18556 = (state_18655[(7)]);
var inst_18573 = (state_18655[(2)]);
var inst_18574 = cljs.core.next.call(null,inst_18556);
var inst_18536 = inst_18574;
var inst_18537 = null;
var inst_18538 = (0);
var inst_18539 = (0);
var state_18655__$1 = (function (){var statearr_18665 = state_18655;
(statearr_18665[(13)] = inst_18538);

(statearr_18665[(14)] = inst_18537);

(statearr_18665[(15)] = inst_18536);

(statearr_18665[(16)] = inst_18573);

(statearr_18665[(17)] = inst_18539);

return statearr_18665;
})();
var statearr_18666_18750 = state_18655__$1;
(statearr_18666_18750[(2)] = null);

(statearr_18666_18750[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (39))){
var state_18655__$1 = state_18655;
var statearr_18670_18751 = state_18655__$1;
(statearr_18670_18751[(2)] = null);

(statearr_18670_18751[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (4))){
var inst_18527 = (state_18655[(12)]);
var inst_18527__$1 = (state_18655[(2)]);
var inst_18528 = (inst_18527__$1 == null);
var state_18655__$1 = (function (){var statearr_18671 = state_18655;
(statearr_18671[(12)] = inst_18527__$1);

return statearr_18671;
})();
if(cljs.core.truth_(inst_18528)){
var statearr_18672_18752 = state_18655__$1;
(statearr_18672_18752[(1)] = (5));

} else {
var statearr_18673_18753 = state_18655__$1;
(statearr_18673_18753[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (15))){
var inst_18538 = (state_18655[(13)]);
var inst_18537 = (state_18655[(14)]);
var inst_18536 = (state_18655[(15)]);
var inst_18539 = (state_18655[(17)]);
var inst_18552 = (state_18655[(2)]);
var inst_18553 = (inst_18539 + (1));
var tmp18667 = inst_18538;
var tmp18668 = inst_18537;
var tmp18669 = inst_18536;
var inst_18536__$1 = tmp18669;
var inst_18537__$1 = tmp18668;
var inst_18538__$1 = tmp18667;
var inst_18539__$1 = inst_18553;
var state_18655__$1 = (function (){var statearr_18674 = state_18655;
(statearr_18674[(13)] = inst_18538__$1);

(statearr_18674[(14)] = inst_18537__$1);

(statearr_18674[(15)] = inst_18536__$1);

(statearr_18674[(17)] = inst_18539__$1);

(statearr_18674[(18)] = inst_18552);

return statearr_18674;
})();
var statearr_18675_18754 = state_18655__$1;
(statearr_18675_18754[(2)] = null);

(statearr_18675_18754[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (21))){
var inst_18577 = (state_18655[(2)]);
var state_18655__$1 = state_18655;
var statearr_18679_18755 = state_18655__$1;
(statearr_18679_18755[(2)] = inst_18577);

(statearr_18679_18755[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (31))){
var inst_18603 = (state_18655[(11)]);
var inst_18607 = done.call(null,null);
var inst_18608 = cljs.core.async.untap_STAR_.call(null,m,inst_18603);
var state_18655__$1 = (function (){var statearr_18680 = state_18655;
(statearr_18680[(19)] = inst_18607);

return statearr_18680;
})();
var statearr_18681_18756 = state_18655__$1;
(statearr_18681_18756[(2)] = inst_18608);

(statearr_18681_18756[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (32))){
var inst_18598 = (state_18655[(9)]);
var inst_18596 = (state_18655[(10)]);
var inst_18595 = (state_18655[(20)]);
var inst_18597 = (state_18655[(21)]);
var inst_18610 = (state_18655[(2)]);
var inst_18611 = (inst_18598 + (1));
var tmp18676 = inst_18596;
var tmp18677 = inst_18595;
var tmp18678 = inst_18597;
var inst_18595__$1 = tmp18677;
var inst_18596__$1 = tmp18676;
var inst_18597__$1 = tmp18678;
var inst_18598__$1 = inst_18611;
var state_18655__$1 = (function (){var statearr_18682 = state_18655;
(statearr_18682[(9)] = inst_18598__$1);

(statearr_18682[(22)] = inst_18610);

(statearr_18682[(10)] = inst_18596__$1);

(statearr_18682[(20)] = inst_18595__$1);

(statearr_18682[(21)] = inst_18597__$1);

return statearr_18682;
})();
var statearr_18683_18757 = state_18655__$1;
(statearr_18683_18757[(2)] = null);

(statearr_18683_18757[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (40))){
var inst_18623 = (state_18655[(23)]);
var inst_18627 = done.call(null,null);
var inst_18628 = cljs.core.async.untap_STAR_.call(null,m,inst_18623);
var state_18655__$1 = (function (){var statearr_18684 = state_18655;
(statearr_18684[(24)] = inst_18627);

return statearr_18684;
})();
var statearr_18685_18758 = state_18655__$1;
(statearr_18685_18758[(2)] = inst_18628);

(statearr_18685_18758[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (33))){
var inst_18614 = (state_18655[(25)]);
var inst_18616 = cljs.core.chunked_seq_QMARK_.call(null,inst_18614);
var state_18655__$1 = state_18655;
if(inst_18616){
var statearr_18686_18759 = state_18655__$1;
(statearr_18686_18759[(1)] = (36));

} else {
var statearr_18687_18760 = state_18655__$1;
(statearr_18687_18760[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (13))){
var inst_18546 = (state_18655[(26)]);
var inst_18549 = cljs.core.async.close_BANG_.call(null,inst_18546);
var state_18655__$1 = state_18655;
var statearr_18688_18761 = state_18655__$1;
(statearr_18688_18761[(2)] = inst_18549);

(statearr_18688_18761[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (22))){
var inst_18567 = (state_18655[(8)]);
var inst_18570 = cljs.core.async.close_BANG_.call(null,inst_18567);
var state_18655__$1 = state_18655;
var statearr_18689_18762 = state_18655__$1;
(statearr_18689_18762[(2)] = inst_18570);

(statearr_18689_18762[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (36))){
var inst_18614 = (state_18655[(25)]);
var inst_18618 = cljs.core.chunk_first.call(null,inst_18614);
var inst_18619 = cljs.core.chunk_rest.call(null,inst_18614);
var inst_18620 = cljs.core.count.call(null,inst_18618);
var inst_18595 = inst_18619;
var inst_18596 = inst_18618;
var inst_18597 = inst_18620;
var inst_18598 = (0);
var state_18655__$1 = (function (){var statearr_18690 = state_18655;
(statearr_18690[(9)] = inst_18598);

(statearr_18690[(10)] = inst_18596);

(statearr_18690[(20)] = inst_18595);

(statearr_18690[(21)] = inst_18597);

return statearr_18690;
})();
var statearr_18691_18763 = state_18655__$1;
(statearr_18691_18763[(2)] = null);

(statearr_18691_18763[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (41))){
var inst_18614 = (state_18655[(25)]);
var inst_18630 = (state_18655[(2)]);
var inst_18631 = cljs.core.next.call(null,inst_18614);
var inst_18595 = inst_18631;
var inst_18596 = null;
var inst_18597 = (0);
var inst_18598 = (0);
var state_18655__$1 = (function (){var statearr_18692 = state_18655;
(statearr_18692[(9)] = inst_18598);

(statearr_18692[(10)] = inst_18596);

(statearr_18692[(20)] = inst_18595);

(statearr_18692[(21)] = inst_18597);

(statearr_18692[(27)] = inst_18630);

return statearr_18692;
})();
var statearr_18693_18764 = state_18655__$1;
(statearr_18693_18764[(2)] = null);

(statearr_18693_18764[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (43))){
var state_18655__$1 = state_18655;
var statearr_18694_18765 = state_18655__$1;
(statearr_18694_18765[(2)] = null);

(statearr_18694_18765[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (29))){
var inst_18639 = (state_18655[(2)]);
var state_18655__$1 = state_18655;
var statearr_18695_18766 = state_18655__$1;
(statearr_18695_18766[(2)] = inst_18639);

(statearr_18695_18766[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (44))){
var inst_18648 = (state_18655[(2)]);
var state_18655__$1 = (function (){var statearr_18696 = state_18655;
(statearr_18696[(28)] = inst_18648);

return statearr_18696;
})();
var statearr_18697_18767 = state_18655__$1;
(statearr_18697_18767[(2)] = null);

(statearr_18697_18767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (6))){
var inst_18587 = (state_18655[(29)]);
var inst_18586 = cljs.core.deref.call(null,cs);
var inst_18587__$1 = cljs.core.keys.call(null,inst_18586);
var inst_18588 = cljs.core.count.call(null,inst_18587__$1);
var inst_18589 = cljs.core.reset_BANG_.call(null,dctr,inst_18588);
var inst_18594 = cljs.core.seq.call(null,inst_18587__$1);
var inst_18595 = inst_18594;
var inst_18596 = null;
var inst_18597 = (0);
var inst_18598 = (0);
var state_18655__$1 = (function (){var statearr_18698 = state_18655;
(statearr_18698[(30)] = inst_18589);

(statearr_18698[(9)] = inst_18598);

(statearr_18698[(10)] = inst_18596);

(statearr_18698[(20)] = inst_18595);

(statearr_18698[(21)] = inst_18597);

(statearr_18698[(29)] = inst_18587__$1);

return statearr_18698;
})();
var statearr_18699_18768 = state_18655__$1;
(statearr_18699_18768[(2)] = null);

(statearr_18699_18768[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (28))){
var inst_18595 = (state_18655[(20)]);
var inst_18614 = (state_18655[(25)]);
var inst_18614__$1 = cljs.core.seq.call(null,inst_18595);
var state_18655__$1 = (function (){var statearr_18700 = state_18655;
(statearr_18700[(25)] = inst_18614__$1);

return statearr_18700;
})();
if(inst_18614__$1){
var statearr_18701_18769 = state_18655__$1;
(statearr_18701_18769[(1)] = (33));

} else {
var statearr_18702_18770 = state_18655__$1;
(statearr_18702_18770[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (25))){
var inst_18598 = (state_18655[(9)]);
var inst_18597 = (state_18655[(21)]);
var inst_18600 = (inst_18598 < inst_18597);
var inst_18601 = inst_18600;
var state_18655__$1 = state_18655;
if(cljs.core.truth_(inst_18601)){
var statearr_18703_18771 = state_18655__$1;
(statearr_18703_18771[(1)] = (27));

} else {
var statearr_18704_18772 = state_18655__$1;
(statearr_18704_18772[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (34))){
var state_18655__$1 = state_18655;
var statearr_18705_18773 = state_18655__$1;
(statearr_18705_18773[(2)] = null);

(statearr_18705_18773[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (17))){
var state_18655__$1 = state_18655;
var statearr_18706_18774 = state_18655__$1;
(statearr_18706_18774[(2)] = null);

(statearr_18706_18774[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (3))){
var inst_18653 = (state_18655[(2)]);
var state_18655__$1 = state_18655;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18655__$1,inst_18653);
} else {
if((state_val_18656 === (12))){
var inst_18582 = (state_18655[(2)]);
var state_18655__$1 = state_18655;
var statearr_18707_18775 = state_18655__$1;
(statearr_18707_18775[(2)] = inst_18582);

(statearr_18707_18775[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (2))){
var state_18655__$1 = state_18655;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18655__$1,(4),ch);
} else {
if((state_val_18656 === (23))){
var state_18655__$1 = state_18655;
var statearr_18708_18776 = state_18655__$1;
(statearr_18708_18776[(2)] = null);

(statearr_18708_18776[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (35))){
var inst_18637 = (state_18655[(2)]);
var state_18655__$1 = state_18655;
var statearr_18709_18777 = state_18655__$1;
(statearr_18709_18777[(2)] = inst_18637);

(statearr_18709_18777[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (19))){
var inst_18556 = (state_18655[(7)]);
var inst_18560 = cljs.core.chunk_first.call(null,inst_18556);
var inst_18561 = cljs.core.chunk_rest.call(null,inst_18556);
var inst_18562 = cljs.core.count.call(null,inst_18560);
var inst_18536 = inst_18561;
var inst_18537 = inst_18560;
var inst_18538 = inst_18562;
var inst_18539 = (0);
var state_18655__$1 = (function (){var statearr_18710 = state_18655;
(statearr_18710[(13)] = inst_18538);

(statearr_18710[(14)] = inst_18537);

(statearr_18710[(15)] = inst_18536);

(statearr_18710[(17)] = inst_18539);

return statearr_18710;
})();
var statearr_18711_18778 = state_18655__$1;
(statearr_18711_18778[(2)] = null);

(statearr_18711_18778[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (11))){
var inst_18536 = (state_18655[(15)]);
var inst_18556 = (state_18655[(7)]);
var inst_18556__$1 = cljs.core.seq.call(null,inst_18536);
var state_18655__$1 = (function (){var statearr_18712 = state_18655;
(statearr_18712[(7)] = inst_18556__$1);

return statearr_18712;
})();
if(inst_18556__$1){
var statearr_18713_18779 = state_18655__$1;
(statearr_18713_18779[(1)] = (16));

} else {
var statearr_18714_18780 = state_18655__$1;
(statearr_18714_18780[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (9))){
var inst_18584 = (state_18655[(2)]);
var state_18655__$1 = state_18655;
var statearr_18715_18781 = state_18655__$1;
(statearr_18715_18781[(2)] = inst_18584);

(statearr_18715_18781[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (5))){
var inst_18534 = cljs.core.deref.call(null,cs);
var inst_18535 = cljs.core.seq.call(null,inst_18534);
var inst_18536 = inst_18535;
var inst_18537 = null;
var inst_18538 = (0);
var inst_18539 = (0);
var state_18655__$1 = (function (){var statearr_18716 = state_18655;
(statearr_18716[(13)] = inst_18538);

(statearr_18716[(14)] = inst_18537);

(statearr_18716[(15)] = inst_18536);

(statearr_18716[(17)] = inst_18539);

return statearr_18716;
})();
var statearr_18717_18782 = state_18655__$1;
(statearr_18717_18782[(2)] = null);

(statearr_18717_18782[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (14))){
var state_18655__$1 = state_18655;
var statearr_18718_18783 = state_18655__$1;
(statearr_18718_18783[(2)] = null);

(statearr_18718_18783[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (45))){
var inst_18645 = (state_18655[(2)]);
var state_18655__$1 = state_18655;
var statearr_18719_18784 = state_18655__$1;
(statearr_18719_18784[(2)] = inst_18645);

(statearr_18719_18784[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (26))){
var inst_18587 = (state_18655[(29)]);
var inst_18641 = (state_18655[(2)]);
var inst_18642 = cljs.core.seq.call(null,inst_18587);
var state_18655__$1 = (function (){var statearr_18720 = state_18655;
(statearr_18720[(31)] = inst_18641);

return statearr_18720;
})();
if(inst_18642){
var statearr_18721_18785 = state_18655__$1;
(statearr_18721_18785[(1)] = (42));

} else {
var statearr_18722_18786 = state_18655__$1;
(statearr_18722_18786[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (16))){
var inst_18556 = (state_18655[(7)]);
var inst_18558 = cljs.core.chunked_seq_QMARK_.call(null,inst_18556);
var state_18655__$1 = state_18655;
if(inst_18558){
var statearr_18723_18787 = state_18655__$1;
(statearr_18723_18787[(1)] = (19));

} else {
var statearr_18724_18788 = state_18655__$1;
(statearr_18724_18788[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (38))){
var inst_18634 = (state_18655[(2)]);
var state_18655__$1 = state_18655;
var statearr_18725_18789 = state_18655__$1;
(statearr_18725_18789[(2)] = inst_18634);

(statearr_18725_18789[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (30))){
var state_18655__$1 = state_18655;
var statearr_18726_18790 = state_18655__$1;
(statearr_18726_18790[(2)] = null);

(statearr_18726_18790[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (10))){
var inst_18537 = (state_18655[(14)]);
var inst_18539 = (state_18655[(17)]);
var inst_18545 = cljs.core._nth.call(null,inst_18537,inst_18539);
var inst_18546 = cljs.core.nth.call(null,inst_18545,(0),null);
var inst_18547 = cljs.core.nth.call(null,inst_18545,(1),null);
var state_18655__$1 = (function (){var statearr_18727 = state_18655;
(statearr_18727[(26)] = inst_18546);

return statearr_18727;
})();
if(cljs.core.truth_(inst_18547)){
var statearr_18728_18791 = state_18655__$1;
(statearr_18728_18791[(1)] = (13));

} else {
var statearr_18729_18792 = state_18655__$1;
(statearr_18729_18792[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (18))){
var inst_18580 = (state_18655[(2)]);
var state_18655__$1 = state_18655;
var statearr_18730_18793 = state_18655__$1;
(statearr_18730_18793[(2)] = inst_18580);

(statearr_18730_18793[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (42))){
var state_18655__$1 = state_18655;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18655__$1,(45),dchan);
} else {
if((state_val_18656 === (37))){
var inst_18623 = (state_18655[(23)]);
var inst_18527 = (state_18655[(12)]);
var inst_18614 = (state_18655[(25)]);
var inst_18623__$1 = cljs.core.first.call(null,inst_18614);
var inst_18624 = cljs.core.async.put_BANG_.call(null,inst_18623__$1,inst_18527,done);
var state_18655__$1 = (function (){var statearr_18731 = state_18655;
(statearr_18731[(23)] = inst_18623__$1);

return statearr_18731;
})();
if(cljs.core.truth_(inst_18624)){
var statearr_18732_18794 = state_18655__$1;
(statearr_18732_18794[(1)] = (39));

} else {
var statearr_18733_18795 = state_18655__$1;
(statearr_18733_18795[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (8))){
var inst_18538 = (state_18655[(13)]);
var inst_18539 = (state_18655[(17)]);
var inst_18541 = (inst_18539 < inst_18538);
var inst_18542 = inst_18541;
var state_18655__$1 = state_18655;
if(cljs.core.truth_(inst_18542)){
var statearr_18734_18796 = state_18655__$1;
(statearr_18734_18796[(1)] = (10));

} else {
var statearr_18735_18797 = state_18655__$1;
(statearr_18735_18797[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___18743,cs,m,dchan,dctr,done))
;
return ((function (switch__8335__auto__,c__8400__auto___18743,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__8336__auto__ = null;
var cljs$core$async$mult_$_state_machine__8336__auto____0 = (function (){
var statearr_18739 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18739[(0)] = cljs$core$async$mult_$_state_machine__8336__auto__);

(statearr_18739[(1)] = (1));

return statearr_18739;
});
var cljs$core$async$mult_$_state_machine__8336__auto____1 = (function (state_18655){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_18655);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e18740){if((e18740 instanceof Object)){
var ex__8339__auto__ = e18740;
var statearr_18741_18798 = state_18655;
(statearr_18741_18798[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18655);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18740;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18799 = state_18655;
state_18655 = G__18799;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__8336__auto__ = function(state_18655){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__8336__auto____1.call(this,state_18655);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__8336__auto____0;
cljs$core$async$mult_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__8336__auto____1;
return cljs$core$async$mult_$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___18743,cs,m,dchan,dctr,done))
})();
var state__8402__auto__ = (function (){var statearr_18742 = f__8401__auto__.call(null);
(statearr_18742[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___18743);

return statearr_18742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});})(c__8400__auto___18743,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args18800 = [];
var len__5627__auto___18803 = arguments.length;
var i__5628__auto___18804 = (0);
while(true){
if((i__5628__auto___18804 < len__5627__auto___18803)){
args18800.push((arguments[i__5628__auto___18804]));

var G__18805 = (i__5628__auto___18804 + (1));
i__5628__auto___18804 = G__18805;
continue;
} else {
}
break;
}

var G__18802 = args18800.length;
switch (G__18802) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18800.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m);
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,state_map);
} else {
var m__5225__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,mode);
} else {
var m__5225__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___18817 = arguments.length;
var i__5628__auto___18818 = (0);
while(true){
if((i__5628__auto___18818 < len__5627__auto___18817)){
args__5634__auto__.push((arguments[i__5628__auto___18818]));

var G__18819 = (i__5628__auto___18818 + (1));
i__5628__auto___18818 = G__18819;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((3) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5635__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__18811){
var map__18812 = p__18811;
var map__18812__$1 = ((((!((map__18812 == null)))?((((map__18812.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18812.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18812):map__18812);
var opts = map__18812__$1;
var statearr_18814_18820 = state;
(statearr_18814_18820[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__18812,map__18812__$1,opts){
return (function (val){
var statearr_18815_18821 = state;
(statearr_18815_18821[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__18812,map__18812__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_18816_18822 = state;
(statearr_18816_18822[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq18807){
var G__18808 = cljs.core.first.call(null,seq18807);
var seq18807__$1 = cljs.core.next.call(null,seq18807);
var G__18809 = cljs.core.first.call(null,seq18807__$1);
var seq18807__$2 = cljs.core.next.call(null,seq18807__$1);
var G__18810 = cljs.core.first.call(null,seq18807__$2);
var seq18807__$3 = cljs.core.next.call(null,seq18807__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18808,G__18809,G__18810,seq18807__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18986 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18986 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta18987){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta18987 = meta18987;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18986.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18988,meta18987__$1){
var self__ = this;
var _18988__$1 = this;
return (new cljs.core.async.t_cljs$core$async18986(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta18987__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18986.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18988){
var self__ = this;
var _18988__$1 = this;
return self__.meta18987;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18986.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18986.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18986.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async18986.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18986.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18986.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18986.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18986.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18986.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta18987","meta18987",1750440554,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18986.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18986.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18986";

cljs.core.async.t_cljs$core$async18986.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async18986");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async18986 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async18986(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18987){
return (new cljs.core.async.t_cljs$core$async18986(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18987));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async18986(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8400__auto___19149 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8400__auto___19149,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___19149,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_19086){
var state_val_19087 = (state_19086[(1)]);
if((state_val_19087 === (7))){
var inst_19004 = (state_19086[(2)]);
var state_19086__$1 = state_19086;
var statearr_19088_19150 = state_19086__$1;
(statearr_19088_19150[(2)] = inst_19004);

(statearr_19088_19150[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (20))){
var inst_19016 = (state_19086[(7)]);
var state_19086__$1 = state_19086;
var statearr_19089_19151 = state_19086__$1;
(statearr_19089_19151[(2)] = inst_19016);

(statearr_19089_19151[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (27))){
var state_19086__$1 = state_19086;
var statearr_19090_19152 = state_19086__$1;
(statearr_19090_19152[(2)] = null);

(statearr_19090_19152[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (1))){
var inst_18992 = (state_19086[(8)]);
var inst_18992__$1 = calc_state.call(null);
var inst_18994 = (inst_18992__$1 == null);
var inst_18995 = cljs.core.not.call(null,inst_18994);
var state_19086__$1 = (function (){var statearr_19091 = state_19086;
(statearr_19091[(8)] = inst_18992__$1);

return statearr_19091;
})();
if(inst_18995){
var statearr_19092_19153 = state_19086__$1;
(statearr_19092_19153[(1)] = (2));

} else {
var statearr_19093_19154 = state_19086__$1;
(statearr_19093_19154[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (24))){
var inst_19039 = (state_19086[(9)]);
var inst_19060 = (state_19086[(10)]);
var inst_19046 = (state_19086[(11)]);
var inst_19060__$1 = inst_19039.call(null,inst_19046);
var state_19086__$1 = (function (){var statearr_19094 = state_19086;
(statearr_19094[(10)] = inst_19060__$1);

return statearr_19094;
})();
if(cljs.core.truth_(inst_19060__$1)){
var statearr_19095_19155 = state_19086__$1;
(statearr_19095_19155[(1)] = (29));

} else {
var statearr_19096_19156 = state_19086__$1;
(statearr_19096_19156[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (4))){
var inst_19007 = (state_19086[(2)]);
var state_19086__$1 = state_19086;
if(cljs.core.truth_(inst_19007)){
var statearr_19097_19157 = state_19086__$1;
(statearr_19097_19157[(1)] = (8));

} else {
var statearr_19098_19158 = state_19086__$1;
(statearr_19098_19158[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (15))){
var inst_19033 = (state_19086[(2)]);
var state_19086__$1 = state_19086;
if(cljs.core.truth_(inst_19033)){
var statearr_19099_19159 = state_19086__$1;
(statearr_19099_19159[(1)] = (19));

} else {
var statearr_19100_19160 = state_19086__$1;
(statearr_19100_19160[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (21))){
var inst_19038 = (state_19086[(12)]);
var inst_19038__$1 = (state_19086[(2)]);
var inst_19039 = cljs.core.get.call(null,inst_19038__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_19040 = cljs.core.get.call(null,inst_19038__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_19041 = cljs.core.get.call(null,inst_19038__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_19086__$1 = (function (){var statearr_19101 = state_19086;
(statearr_19101[(9)] = inst_19039);

(statearr_19101[(12)] = inst_19038__$1);

(statearr_19101[(13)] = inst_19040);

return statearr_19101;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_19086__$1,(22),inst_19041);
} else {
if((state_val_19087 === (31))){
var inst_19068 = (state_19086[(2)]);
var state_19086__$1 = state_19086;
if(cljs.core.truth_(inst_19068)){
var statearr_19102_19161 = state_19086__$1;
(statearr_19102_19161[(1)] = (32));

} else {
var statearr_19103_19162 = state_19086__$1;
(statearr_19103_19162[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (32))){
var inst_19045 = (state_19086[(14)]);
var state_19086__$1 = state_19086;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19086__$1,(35),out,inst_19045);
} else {
if((state_val_19087 === (33))){
var inst_19038 = (state_19086[(12)]);
var inst_19016 = inst_19038;
var state_19086__$1 = (function (){var statearr_19104 = state_19086;
(statearr_19104[(7)] = inst_19016);

return statearr_19104;
})();
var statearr_19105_19163 = state_19086__$1;
(statearr_19105_19163[(2)] = null);

(statearr_19105_19163[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (13))){
var inst_19016 = (state_19086[(7)]);
var inst_19023 = inst_19016.cljs$lang$protocol_mask$partition0$;
var inst_19024 = (inst_19023 & (64));
var inst_19025 = inst_19016.cljs$core$ISeq$;
var inst_19026 = (inst_19024) || (inst_19025);
var state_19086__$1 = state_19086;
if(cljs.core.truth_(inst_19026)){
var statearr_19106_19164 = state_19086__$1;
(statearr_19106_19164[(1)] = (16));

} else {
var statearr_19107_19165 = state_19086__$1;
(statearr_19107_19165[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (22))){
var inst_19045 = (state_19086[(14)]);
var inst_19046 = (state_19086[(11)]);
var inst_19044 = (state_19086[(2)]);
var inst_19045__$1 = cljs.core.nth.call(null,inst_19044,(0),null);
var inst_19046__$1 = cljs.core.nth.call(null,inst_19044,(1),null);
var inst_19047 = (inst_19045__$1 == null);
var inst_19048 = cljs.core._EQ_.call(null,inst_19046__$1,change);
var inst_19049 = (inst_19047) || (inst_19048);
var state_19086__$1 = (function (){var statearr_19108 = state_19086;
(statearr_19108[(14)] = inst_19045__$1);

(statearr_19108[(11)] = inst_19046__$1);

return statearr_19108;
})();
if(cljs.core.truth_(inst_19049)){
var statearr_19109_19166 = state_19086__$1;
(statearr_19109_19166[(1)] = (23));

} else {
var statearr_19110_19167 = state_19086__$1;
(statearr_19110_19167[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (36))){
var inst_19038 = (state_19086[(12)]);
var inst_19016 = inst_19038;
var state_19086__$1 = (function (){var statearr_19111 = state_19086;
(statearr_19111[(7)] = inst_19016);

return statearr_19111;
})();
var statearr_19112_19168 = state_19086__$1;
(statearr_19112_19168[(2)] = null);

(statearr_19112_19168[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (29))){
var inst_19060 = (state_19086[(10)]);
var state_19086__$1 = state_19086;
var statearr_19113_19169 = state_19086__$1;
(statearr_19113_19169[(2)] = inst_19060);

(statearr_19113_19169[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (6))){
var state_19086__$1 = state_19086;
var statearr_19114_19170 = state_19086__$1;
(statearr_19114_19170[(2)] = false);

(statearr_19114_19170[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (28))){
var inst_19056 = (state_19086[(2)]);
var inst_19057 = calc_state.call(null);
var inst_19016 = inst_19057;
var state_19086__$1 = (function (){var statearr_19115 = state_19086;
(statearr_19115[(7)] = inst_19016);

(statearr_19115[(15)] = inst_19056);

return statearr_19115;
})();
var statearr_19116_19171 = state_19086__$1;
(statearr_19116_19171[(2)] = null);

(statearr_19116_19171[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (25))){
var inst_19082 = (state_19086[(2)]);
var state_19086__$1 = state_19086;
var statearr_19117_19172 = state_19086__$1;
(statearr_19117_19172[(2)] = inst_19082);

(statearr_19117_19172[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (34))){
var inst_19080 = (state_19086[(2)]);
var state_19086__$1 = state_19086;
var statearr_19118_19173 = state_19086__$1;
(statearr_19118_19173[(2)] = inst_19080);

(statearr_19118_19173[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (17))){
var state_19086__$1 = state_19086;
var statearr_19119_19174 = state_19086__$1;
(statearr_19119_19174[(2)] = false);

(statearr_19119_19174[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (3))){
var state_19086__$1 = state_19086;
var statearr_19120_19175 = state_19086__$1;
(statearr_19120_19175[(2)] = false);

(statearr_19120_19175[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (12))){
var inst_19084 = (state_19086[(2)]);
var state_19086__$1 = state_19086;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19086__$1,inst_19084);
} else {
if((state_val_19087 === (2))){
var inst_18992 = (state_19086[(8)]);
var inst_18997 = inst_18992.cljs$lang$protocol_mask$partition0$;
var inst_18998 = (inst_18997 & (64));
var inst_18999 = inst_18992.cljs$core$ISeq$;
var inst_19000 = (inst_18998) || (inst_18999);
var state_19086__$1 = state_19086;
if(cljs.core.truth_(inst_19000)){
var statearr_19121_19176 = state_19086__$1;
(statearr_19121_19176[(1)] = (5));

} else {
var statearr_19122_19177 = state_19086__$1;
(statearr_19122_19177[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (23))){
var inst_19045 = (state_19086[(14)]);
var inst_19051 = (inst_19045 == null);
var state_19086__$1 = state_19086;
if(cljs.core.truth_(inst_19051)){
var statearr_19123_19178 = state_19086__$1;
(statearr_19123_19178[(1)] = (26));

} else {
var statearr_19124_19179 = state_19086__$1;
(statearr_19124_19179[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (35))){
var inst_19071 = (state_19086[(2)]);
var state_19086__$1 = state_19086;
if(cljs.core.truth_(inst_19071)){
var statearr_19125_19180 = state_19086__$1;
(statearr_19125_19180[(1)] = (36));

} else {
var statearr_19126_19181 = state_19086__$1;
(statearr_19126_19181[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (19))){
var inst_19016 = (state_19086[(7)]);
var inst_19035 = cljs.core.apply.call(null,cljs.core.hash_map,inst_19016);
var state_19086__$1 = state_19086;
var statearr_19127_19182 = state_19086__$1;
(statearr_19127_19182[(2)] = inst_19035);

(statearr_19127_19182[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (11))){
var inst_19016 = (state_19086[(7)]);
var inst_19020 = (inst_19016 == null);
var inst_19021 = cljs.core.not.call(null,inst_19020);
var state_19086__$1 = state_19086;
if(inst_19021){
var statearr_19128_19183 = state_19086__$1;
(statearr_19128_19183[(1)] = (13));

} else {
var statearr_19129_19184 = state_19086__$1;
(statearr_19129_19184[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (9))){
var inst_18992 = (state_19086[(8)]);
var state_19086__$1 = state_19086;
var statearr_19130_19185 = state_19086__$1;
(statearr_19130_19185[(2)] = inst_18992);

(statearr_19130_19185[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (5))){
var state_19086__$1 = state_19086;
var statearr_19131_19186 = state_19086__$1;
(statearr_19131_19186[(2)] = true);

(statearr_19131_19186[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (14))){
var state_19086__$1 = state_19086;
var statearr_19132_19187 = state_19086__$1;
(statearr_19132_19187[(2)] = false);

(statearr_19132_19187[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (26))){
var inst_19046 = (state_19086[(11)]);
var inst_19053 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_19046);
var state_19086__$1 = state_19086;
var statearr_19133_19188 = state_19086__$1;
(statearr_19133_19188[(2)] = inst_19053);

(statearr_19133_19188[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (16))){
var state_19086__$1 = state_19086;
var statearr_19134_19189 = state_19086__$1;
(statearr_19134_19189[(2)] = true);

(statearr_19134_19189[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (38))){
var inst_19076 = (state_19086[(2)]);
var state_19086__$1 = state_19086;
var statearr_19135_19190 = state_19086__$1;
(statearr_19135_19190[(2)] = inst_19076);

(statearr_19135_19190[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (30))){
var inst_19039 = (state_19086[(9)]);
var inst_19046 = (state_19086[(11)]);
var inst_19040 = (state_19086[(13)]);
var inst_19063 = cljs.core.empty_QMARK_.call(null,inst_19039);
var inst_19064 = inst_19040.call(null,inst_19046);
var inst_19065 = cljs.core.not.call(null,inst_19064);
var inst_19066 = (inst_19063) && (inst_19065);
var state_19086__$1 = state_19086;
var statearr_19136_19191 = state_19086__$1;
(statearr_19136_19191[(2)] = inst_19066);

(statearr_19136_19191[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (10))){
var inst_18992 = (state_19086[(8)]);
var inst_19012 = (state_19086[(2)]);
var inst_19013 = cljs.core.get.call(null,inst_19012,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_19014 = cljs.core.get.call(null,inst_19012,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_19015 = cljs.core.get.call(null,inst_19012,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_19016 = inst_18992;
var state_19086__$1 = (function (){var statearr_19137 = state_19086;
(statearr_19137[(7)] = inst_19016);

(statearr_19137[(16)] = inst_19015);

(statearr_19137[(17)] = inst_19014);

(statearr_19137[(18)] = inst_19013);

return statearr_19137;
})();
var statearr_19138_19192 = state_19086__$1;
(statearr_19138_19192[(2)] = null);

(statearr_19138_19192[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (18))){
var inst_19030 = (state_19086[(2)]);
var state_19086__$1 = state_19086;
var statearr_19139_19193 = state_19086__$1;
(statearr_19139_19193[(2)] = inst_19030);

(statearr_19139_19193[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (37))){
var state_19086__$1 = state_19086;
var statearr_19140_19194 = state_19086__$1;
(statearr_19140_19194[(2)] = null);

(statearr_19140_19194[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19087 === (8))){
var inst_18992 = (state_19086[(8)]);
var inst_19009 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18992);
var state_19086__$1 = state_19086;
var statearr_19141_19195 = state_19086__$1;
(statearr_19141_19195[(2)] = inst_19009);

(statearr_19141_19195[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___19149,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__8335__auto__,c__8400__auto___19149,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__8336__auto__ = null;
var cljs$core$async$mix_$_state_machine__8336__auto____0 = (function (){
var statearr_19145 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19145[(0)] = cljs$core$async$mix_$_state_machine__8336__auto__);

(statearr_19145[(1)] = (1));

return statearr_19145;
});
var cljs$core$async$mix_$_state_machine__8336__auto____1 = (function (state_19086){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_19086);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e19146){if((e19146 instanceof Object)){
var ex__8339__auto__ = e19146;
var statearr_19147_19196 = state_19086;
(statearr_19147_19196[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19086);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19146;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19197 = state_19086;
state_19086 = G__19197;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__8336__auto__ = function(state_19086){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__8336__auto____1.call(this,state_19086);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__8336__auto____0;
cljs$core$async$mix_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__8336__auto____1;
return cljs$core$async$mix_$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___19149,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__8402__auto__ = (function (){var statearr_19148 = f__8401__auto__.call(null);
(statearr_19148[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___19149);

return statearr_19148;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});})(c__8400__auto___19149,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5225__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p,v,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args19198 = [];
var len__5627__auto___19201 = arguments.length;
var i__5628__auto___19202 = (0);
while(true){
if((i__5628__auto___19202 < len__5627__auto___19201)){
args19198.push((arguments[i__5628__auto___19202]));

var G__19203 = (i__5628__auto___19202 + (1));
i__5628__auto___19202 = G__19203;
continue;
} else {
}
break;
}

var G__19200 = args19198.length;
switch (G__19200) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19198.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p);
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p,v);
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args19206 = [];
var len__5627__auto___19331 = arguments.length;
var i__5628__auto___19332 = (0);
while(true){
if((i__5628__auto___19332 < len__5627__auto___19331)){
args19206.push((arguments[i__5628__auto___19332]));

var G__19333 = (i__5628__auto___19332 + (1));
i__5628__auto___19332 = G__19333;
continue;
} else {
}
break;
}

var G__19208 = args19206.length;
switch (G__19208) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19206.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4569__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4569__auto__,mults){
return (function (p1__19205_SHARP_){
if(cljs.core.truth_(p1__19205_SHARP_.call(null,topic))){
return p1__19205_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__19205_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4569__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async19209 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19209 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta19210){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta19210 = meta19210;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19209.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_19211,meta19210__$1){
var self__ = this;
var _19211__$1 = this;
return (new cljs.core.async.t_cljs$core$async19209(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta19210__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19209.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_19211){
var self__ = this;
var _19211__$1 = this;
return self__.meta19210;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19209.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19209.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19209.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async19209.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19209.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19209.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19209.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19209.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta19210","meta19210",-1016633408,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19209.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19209.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19209";

cljs.core.async.t_cljs$core$async19209.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async19209");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async19209 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async19209(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19210){
return (new cljs.core.async.t_cljs$core$async19209(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19210));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async19209(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8400__auto___19335 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8400__auto___19335,mults,ensure_mult,p){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___19335,mults,ensure_mult,p){
return (function (state_19283){
var state_val_19284 = (state_19283[(1)]);
if((state_val_19284 === (7))){
var inst_19279 = (state_19283[(2)]);
var state_19283__$1 = state_19283;
var statearr_19285_19336 = state_19283__$1;
(statearr_19285_19336[(2)] = inst_19279);

(statearr_19285_19336[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (20))){
var state_19283__$1 = state_19283;
var statearr_19286_19337 = state_19283__$1;
(statearr_19286_19337[(2)] = null);

(statearr_19286_19337[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (1))){
var state_19283__$1 = state_19283;
var statearr_19287_19338 = state_19283__$1;
(statearr_19287_19338[(2)] = null);

(statearr_19287_19338[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (24))){
var inst_19262 = (state_19283[(7)]);
var inst_19271 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_19262);
var state_19283__$1 = state_19283;
var statearr_19288_19339 = state_19283__$1;
(statearr_19288_19339[(2)] = inst_19271);

(statearr_19288_19339[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (4))){
var inst_19214 = (state_19283[(8)]);
var inst_19214__$1 = (state_19283[(2)]);
var inst_19215 = (inst_19214__$1 == null);
var state_19283__$1 = (function (){var statearr_19289 = state_19283;
(statearr_19289[(8)] = inst_19214__$1);

return statearr_19289;
})();
if(cljs.core.truth_(inst_19215)){
var statearr_19290_19340 = state_19283__$1;
(statearr_19290_19340[(1)] = (5));

} else {
var statearr_19291_19341 = state_19283__$1;
(statearr_19291_19341[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (15))){
var inst_19256 = (state_19283[(2)]);
var state_19283__$1 = state_19283;
var statearr_19292_19342 = state_19283__$1;
(statearr_19292_19342[(2)] = inst_19256);

(statearr_19292_19342[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (21))){
var inst_19276 = (state_19283[(2)]);
var state_19283__$1 = (function (){var statearr_19293 = state_19283;
(statearr_19293[(9)] = inst_19276);

return statearr_19293;
})();
var statearr_19294_19343 = state_19283__$1;
(statearr_19294_19343[(2)] = null);

(statearr_19294_19343[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (13))){
var inst_19238 = (state_19283[(10)]);
var inst_19240 = cljs.core.chunked_seq_QMARK_.call(null,inst_19238);
var state_19283__$1 = state_19283;
if(inst_19240){
var statearr_19295_19344 = state_19283__$1;
(statearr_19295_19344[(1)] = (16));

} else {
var statearr_19296_19345 = state_19283__$1;
(statearr_19296_19345[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (22))){
var inst_19268 = (state_19283[(2)]);
var state_19283__$1 = state_19283;
if(cljs.core.truth_(inst_19268)){
var statearr_19297_19346 = state_19283__$1;
(statearr_19297_19346[(1)] = (23));

} else {
var statearr_19298_19347 = state_19283__$1;
(statearr_19298_19347[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (6))){
var inst_19214 = (state_19283[(8)]);
var inst_19264 = (state_19283[(11)]);
var inst_19262 = (state_19283[(7)]);
var inst_19262__$1 = topic_fn.call(null,inst_19214);
var inst_19263 = cljs.core.deref.call(null,mults);
var inst_19264__$1 = cljs.core.get.call(null,inst_19263,inst_19262__$1);
var state_19283__$1 = (function (){var statearr_19299 = state_19283;
(statearr_19299[(11)] = inst_19264__$1);

(statearr_19299[(7)] = inst_19262__$1);

return statearr_19299;
})();
if(cljs.core.truth_(inst_19264__$1)){
var statearr_19300_19348 = state_19283__$1;
(statearr_19300_19348[(1)] = (19));

} else {
var statearr_19301_19349 = state_19283__$1;
(statearr_19301_19349[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (25))){
var inst_19273 = (state_19283[(2)]);
var state_19283__$1 = state_19283;
var statearr_19302_19350 = state_19283__$1;
(statearr_19302_19350[(2)] = inst_19273);

(statearr_19302_19350[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (17))){
var inst_19238 = (state_19283[(10)]);
var inst_19247 = cljs.core.first.call(null,inst_19238);
var inst_19248 = cljs.core.async.muxch_STAR_.call(null,inst_19247);
var inst_19249 = cljs.core.async.close_BANG_.call(null,inst_19248);
var inst_19250 = cljs.core.next.call(null,inst_19238);
var inst_19224 = inst_19250;
var inst_19225 = null;
var inst_19226 = (0);
var inst_19227 = (0);
var state_19283__$1 = (function (){var statearr_19303 = state_19283;
(statearr_19303[(12)] = inst_19226);

(statearr_19303[(13)] = inst_19227);

(statearr_19303[(14)] = inst_19249);

(statearr_19303[(15)] = inst_19224);

(statearr_19303[(16)] = inst_19225);

return statearr_19303;
})();
var statearr_19304_19351 = state_19283__$1;
(statearr_19304_19351[(2)] = null);

(statearr_19304_19351[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (3))){
var inst_19281 = (state_19283[(2)]);
var state_19283__$1 = state_19283;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19283__$1,inst_19281);
} else {
if((state_val_19284 === (12))){
var inst_19258 = (state_19283[(2)]);
var state_19283__$1 = state_19283;
var statearr_19305_19352 = state_19283__$1;
(statearr_19305_19352[(2)] = inst_19258);

(statearr_19305_19352[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (2))){
var state_19283__$1 = state_19283;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19283__$1,(4),ch);
} else {
if((state_val_19284 === (23))){
var state_19283__$1 = state_19283;
var statearr_19306_19353 = state_19283__$1;
(statearr_19306_19353[(2)] = null);

(statearr_19306_19353[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (19))){
var inst_19214 = (state_19283[(8)]);
var inst_19264 = (state_19283[(11)]);
var inst_19266 = cljs.core.async.muxch_STAR_.call(null,inst_19264);
var state_19283__$1 = state_19283;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19283__$1,(22),inst_19266,inst_19214);
} else {
if((state_val_19284 === (11))){
var inst_19238 = (state_19283[(10)]);
var inst_19224 = (state_19283[(15)]);
var inst_19238__$1 = cljs.core.seq.call(null,inst_19224);
var state_19283__$1 = (function (){var statearr_19307 = state_19283;
(statearr_19307[(10)] = inst_19238__$1);

return statearr_19307;
})();
if(inst_19238__$1){
var statearr_19308_19354 = state_19283__$1;
(statearr_19308_19354[(1)] = (13));

} else {
var statearr_19309_19355 = state_19283__$1;
(statearr_19309_19355[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (9))){
var inst_19260 = (state_19283[(2)]);
var state_19283__$1 = state_19283;
var statearr_19310_19356 = state_19283__$1;
(statearr_19310_19356[(2)] = inst_19260);

(statearr_19310_19356[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (5))){
var inst_19221 = cljs.core.deref.call(null,mults);
var inst_19222 = cljs.core.vals.call(null,inst_19221);
var inst_19223 = cljs.core.seq.call(null,inst_19222);
var inst_19224 = inst_19223;
var inst_19225 = null;
var inst_19226 = (0);
var inst_19227 = (0);
var state_19283__$1 = (function (){var statearr_19311 = state_19283;
(statearr_19311[(12)] = inst_19226);

(statearr_19311[(13)] = inst_19227);

(statearr_19311[(15)] = inst_19224);

(statearr_19311[(16)] = inst_19225);

return statearr_19311;
})();
var statearr_19312_19357 = state_19283__$1;
(statearr_19312_19357[(2)] = null);

(statearr_19312_19357[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (14))){
var state_19283__$1 = state_19283;
var statearr_19316_19358 = state_19283__$1;
(statearr_19316_19358[(2)] = null);

(statearr_19316_19358[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (16))){
var inst_19238 = (state_19283[(10)]);
var inst_19242 = cljs.core.chunk_first.call(null,inst_19238);
var inst_19243 = cljs.core.chunk_rest.call(null,inst_19238);
var inst_19244 = cljs.core.count.call(null,inst_19242);
var inst_19224 = inst_19243;
var inst_19225 = inst_19242;
var inst_19226 = inst_19244;
var inst_19227 = (0);
var state_19283__$1 = (function (){var statearr_19317 = state_19283;
(statearr_19317[(12)] = inst_19226);

(statearr_19317[(13)] = inst_19227);

(statearr_19317[(15)] = inst_19224);

(statearr_19317[(16)] = inst_19225);

return statearr_19317;
})();
var statearr_19318_19359 = state_19283__$1;
(statearr_19318_19359[(2)] = null);

(statearr_19318_19359[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (10))){
var inst_19226 = (state_19283[(12)]);
var inst_19227 = (state_19283[(13)]);
var inst_19224 = (state_19283[(15)]);
var inst_19225 = (state_19283[(16)]);
var inst_19232 = cljs.core._nth.call(null,inst_19225,inst_19227);
var inst_19233 = cljs.core.async.muxch_STAR_.call(null,inst_19232);
var inst_19234 = cljs.core.async.close_BANG_.call(null,inst_19233);
var inst_19235 = (inst_19227 + (1));
var tmp19313 = inst_19226;
var tmp19314 = inst_19224;
var tmp19315 = inst_19225;
var inst_19224__$1 = tmp19314;
var inst_19225__$1 = tmp19315;
var inst_19226__$1 = tmp19313;
var inst_19227__$1 = inst_19235;
var state_19283__$1 = (function (){var statearr_19319 = state_19283;
(statearr_19319[(12)] = inst_19226__$1);

(statearr_19319[(13)] = inst_19227__$1);

(statearr_19319[(17)] = inst_19234);

(statearr_19319[(15)] = inst_19224__$1);

(statearr_19319[(16)] = inst_19225__$1);

return statearr_19319;
})();
var statearr_19320_19360 = state_19283__$1;
(statearr_19320_19360[(2)] = null);

(statearr_19320_19360[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (18))){
var inst_19253 = (state_19283[(2)]);
var state_19283__$1 = state_19283;
var statearr_19321_19361 = state_19283__$1;
(statearr_19321_19361[(2)] = inst_19253);

(statearr_19321_19361[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (8))){
var inst_19226 = (state_19283[(12)]);
var inst_19227 = (state_19283[(13)]);
var inst_19229 = (inst_19227 < inst_19226);
var inst_19230 = inst_19229;
var state_19283__$1 = state_19283;
if(cljs.core.truth_(inst_19230)){
var statearr_19322_19362 = state_19283__$1;
(statearr_19322_19362[(1)] = (10));

} else {
var statearr_19323_19363 = state_19283__$1;
(statearr_19323_19363[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___19335,mults,ensure_mult,p))
;
return ((function (switch__8335__auto__,c__8400__auto___19335,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_19327 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19327[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_19327[(1)] = (1));

return statearr_19327;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_19283){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_19283);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e19328){if((e19328 instanceof Object)){
var ex__8339__auto__ = e19328;
var statearr_19329_19364 = state_19283;
(statearr_19329_19364[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19283);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19328;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19365 = state_19283;
state_19283 = G__19365;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_19283){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_19283);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___19335,mults,ensure_mult,p))
})();
var state__8402__auto__ = (function (){var statearr_19330 = f__8401__auto__.call(null);
(statearr_19330[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___19335);

return statearr_19330;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});})(c__8400__auto___19335,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args19366 = [];
var len__5627__auto___19369 = arguments.length;
var i__5628__auto___19370 = (0);
while(true){
if((i__5628__auto___19370 < len__5627__auto___19369)){
args19366.push((arguments[i__5628__auto___19370]));

var G__19371 = (i__5628__auto___19370 + (1));
i__5628__auto___19370 = G__19371;
continue;
} else {
}
break;
}

var G__19368 = args19366.length;
switch (G__19368) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19366.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args19373 = [];
var len__5627__auto___19376 = arguments.length;
var i__5628__auto___19377 = (0);
while(true){
if((i__5628__auto___19377 < len__5627__auto___19376)){
args19373.push((arguments[i__5628__auto___19377]));

var G__19378 = (i__5628__auto___19377 + (1));
i__5628__auto___19377 = G__19378;
continue;
} else {
}
break;
}

var G__19375 = args19373.length;
switch (G__19375) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19373.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args19380 = [];
var len__5627__auto___19451 = arguments.length;
var i__5628__auto___19452 = (0);
while(true){
if((i__5628__auto___19452 < len__5627__auto___19451)){
args19380.push((arguments[i__5628__auto___19452]));

var G__19453 = (i__5628__auto___19452 + (1));
i__5628__auto___19452 = G__19453;
continue;
} else {
}
break;
}

var G__19382 = args19380.length;
switch (G__19382) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19380.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__8400__auto___19455 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8400__auto___19455,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___19455,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_19421){
var state_val_19422 = (state_19421[(1)]);
if((state_val_19422 === (7))){
var state_19421__$1 = state_19421;
var statearr_19423_19456 = state_19421__$1;
(statearr_19423_19456[(2)] = null);

(statearr_19423_19456[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19422 === (1))){
var state_19421__$1 = state_19421;
var statearr_19424_19457 = state_19421__$1;
(statearr_19424_19457[(2)] = null);

(statearr_19424_19457[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19422 === (4))){
var inst_19385 = (state_19421[(7)]);
var inst_19387 = (inst_19385 < cnt);
var state_19421__$1 = state_19421;
if(cljs.core.truth_(inst_19387)){
var statearr_19425_19458 = state_19421__$1;
(statearr_19425_19458[(1)] = (6));

} else {
var statearr_19426_19459 = state_19421__$1;
(statearr_19426_19459[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19422 === (15))){
var inst_19417 = (state_19421[(2)]);
var state_19421__$1 = state_19421;
var statearr_19427_19460 = state_19421__$1;
(statearr_19427_19460[(2)] = inst_19417);

(statearr_19427_19460[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19422 === (13))){
var inst_19410 = cljs.core.async.close_BANG_.call(null,out);
var state_19421__$1 = state_19421;
var statearr_19428_19461 = state_19421__$1;
(statearr_19428_19461[(2)] = inst_19410);

(statearr_19428_19461[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19422 === (6))){
var state_19421__$1 = state_19421;
var statearr_19429_19462 = state_19421__$1;
(statearr_19429_19462[(2)] = null);

(statearr_19429_19462[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19422 === (3))){
var inst_19419 = (state_19421[(2)]);
var state_19421__$1 = state_19421;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19421__$1,inst_19419);
} else {
if((state_val_19422 === (12))){
var inst_19407 = (state_19421[(8)]);
var inst_19407__$1 = (state_19421[(2)]);
var inst_19408 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_19407__$1);
var state_19421__$1 = (function (){var statearr_19430 = state_19421;
(statearr_19430[(8)] = inst_19407__$1);

return statearr_19430;
})();
if(cljs.core.truth_(inst_19408)){
var statearr_19431_19463 = state_19421__$1;
(statearr_19431_19463[(1)] = (13));

} else {
var statearr_19432_19464 = state_19421__$1;
(statearr_19432_19464[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19422 === (2))){
var inst_19384 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_19385 = (0);
var state_19421__$1 = (function (){var statearr_19433 = state_19421;
(statearr_19433[(7)] = inst_19385);

(statearr_19433[(9)] = inst_19384);

return statearr_19433;
})();
var statearr_19434_19465 = state_19421__$1;
(statearr_19434_19465[(2)] = null);

(statearr_19434_19465[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19422 === (11))){
var inst_19385 = (state_19421[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_19421,(10),Object,null,(9));
var inst_19394 = chs__$1.call(null,inst_19385);
var inst_19395 = done.call(null,inst_19385);
var inst_19396 = cljs.core.async.take_BANG_.call(null,inst_19394,inst_19395);
var state_19421__$1 = state_19421;
var statearr_19435_19466 = state_19421__$1;
(statearr_19435_19466[(2)] = inst_19396);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19421__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19422 === (9))){
var inst_19385 = (state_19421[(7)]);
var inst_19398 = (state_19421[(2)]);
var inst_19399 = (inst_19385 + (1));
var inst_19385__$1 = inst_19399;
var state_19421__$1 = (function (){var statearr_19436 = state_19421;
(statearr_19436[(10)] = inst_19398);

(statearr_19436[(7)] = inst_19385__$1);

return statearr_19436;
})();
var statearr_19437_19467 = state_19421__$1;
(statearr_19437_19467[(2)] = null);

(statearr_19437_19467[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19422 === (5))){
var inst_19405 = (state_19421[(2)]);
var state_19421__$1 = (function (){var statearr_19438 = state_19421;
(statearr_19438[(11)] = inst_19405);

return statearr_19438;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19421__$1,(12),dchan);
} else {
if((state_val_19422 === (14))){
var inst_19407 = (state_19421[(8)]);
var inst_19412 = cljs.core.apply.call(null,f,inst_19407);
var state_19421__$1 = state_19421;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19421__$1,(16),out,inst_19412);
} else {
if((state_val_19422 === (16))){
var inst_19414 = (state_19421[(2)]);
var state_19421__$1 = (function (){var statearr_19439 = state_19421;
(statearr_19439[(12)] = inst_19414);

return statearr_19439;
})();
var statearr_19440_19468 = state_19421__$1;
(statearr_19440_19468[(2)] = null);

(statearr_19440_19468[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19422 === (10))){
var inst_19389 = (state_19421[(2)]);
var inst_19390 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_19421__$1 = (function (){var statearr_19441 = state_19421;
(statearr_19441[(13)] = inst_19389);

return statearr_19441;
})();
var statearr_19442_19469 = state_19421__$1;
(statearr_19442_19469[(2)] = inst_19390);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19421__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19422 === (8))){
var inst_19403 = (state_19421[(2)]);
var state_19421__$1 = state_19421;
var statearr_19443_19470 = state_19421__$1;
(statearr_19443_19470[(2)] = inst_19403);

(statearr_19443_19470[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___19455,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__8335__auto__,c__8400__auto___19455,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_19447 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19447[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_19447[(1)] = (1));

return statearr_19447;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_19421){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_19421);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e19448){if((e19448 instanceof Object)){
var ex__8339__auto__ = e19448;
var statearr_19449_19471 = state_19421;
(statearr_19449_19471[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19421);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19448;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19472 = state_19421;
state_19421 = G__19472;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_19421){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_19421);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___19455,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__8402__auto__ = (function (){var statearr_19450 = f__8401__auto__.call(null);
(statearr_19450[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___19455);

return statearr_19450;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});})(c__8400__auto___19455,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args19474 = [];
var len__5627__auto___19530 = arguments.length;
var i__5628__auto___19531 = (0);
while(true){
if((i__5628__auto___19531 < len__5627__auto___19530)){
args19474.push((arguments[i__5628__auto___19531]));

var G__19532 = (i__5628__auto___19531 + (1));
i__5628__auto___19531 = G__19532;
continue;
} else {
}
break;
}

var G__19476 = args19474.length;
switch (G__19476) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19474.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8400__auto___19534 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8400__auto___19534,out){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___19534,out){
return (function (state_19506){
var state_val_19507 = (state_19506[(1)]);
if((state_val_19507 === (7))){
var inst_19485 = (state_19506[(7)]);
var inst_19486 = (state_19506[(8)]);
var inst_19485__$1 = (state_19506[(2)]);
var inst_19486__$1 = cljs.core.nth.call(null,inst_19485__$1,(0),null);
var inst_19487 = cljs.core.nth.call(null,inst_19485__$1,(1),null);
var inst_19488 = (inst_19486__$1 == null);
var state_19506__$1 = (function (){var statearr_19508 = state_19506;
(statearr_19508[(7)] = inst_19485__$1);

(statearr_19508[(8)] = inst_19486__$1);

(statearr_19508[(9)] = inst_19487);

return statearr_19508;
})();
if(cljs.core.truth_(inst_19488)){
var statearr_19509_19535 = state_19506__$1;
(statearr_19509_19535[(1)] = (8));

} else {
var statearr_19510_19536 = state_19506__$1;
(statearr_19510_19536[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19507 === (1))){
var inst_19477 = cljs.core.vec.call(null,chs);
var inst_19478 = inst_19477;
var state_19506__$1 = (function (){var statearr_19511 = state_19506;
(statearr_19511[(10)] = inst_19478);

return statearr_19511;
})();
var statearr_19512_19537 = state_19506__$1;
(statearr_19512_19537[(2)] = null);

(statearr_19512_19537[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19507 === (4))){
var inst_19478 = (state_19506[(10)]);
var state_19506__$1 = state_19506;
return cljs.core.async.ioc_alts_BANG_.call(null,state_19506__$1,(7),inst_19478);
} else {
if((state_val_19507 === (6))){
var inst_19502 = (state_19506[(2)]);
var state_19506__$1 = state_19506;
var statearr_19513_19538 = state_19506__$1;
(statearr_19513_19538[(2)] = inst_19502);

(statearr_19513_19538[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19507 === (3))){
var inst_19504 = (state_19506[(2)]);
var state_19506__$1 = state_19506;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19506__$1,inst_19504);
} else {
if((state_val_19507 === (2))){
var inst_19478 = (state_19506[(10)]);
var inst_19480 = cljs.core.count.call(null,inst_19478);
var inst_19481 = (inst_19480 > (0));
var state_19506__$1 = state_19506;
if(cljs.core.truth_(inst_19481)){
var statearr_19515_19539 = state_19506__$1;
(statearr_19515_19539[(1)] = (4));

} else {
var statearr_19516_19540 = state_19506__$1;
(statearr_19516_19540[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19507 === (11))){
var inst_19478 = (state_19506[(10)]);
var inst_19495 = (state_19506[(2)]);
var tmp19514 = inst_19478;
var inst_19478__$1 = tmp19514;
var state_19506__$1 = (function (){var statearr_19517 = state_19506;
(statearr_19517[(11)] = inst_19495);

(statearr_19517[(10)] = inst_19478__$1);

return statearr_19517;
})();
var statearr_19518_19541 = state_19506__$1;
(statearr_19518_19541[(2)] = null);

(statearr_19518_19541[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19507 === (9))){
var inst_19486 = (state_19506[(8)]);
var state_19506__$1 = state_19506;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19506__$1,(11),out,inst_19486);
} else {
if((state_val_19507 === (5))){
var inst_19500 = cljs.core.async.close_BANG_.call(null,out);
var state_19506__$1 = state_19506;
var statearr_19519_19542 = state_19506__$1;
(statearr_19519_19542[(2)] = inst_19500);

(statearr_19519_19542[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19507 === (10))){
var inst_19498 = (state_19506[(2)]);
var state_19506__$1 = state_19506;
var statearr_19520_19543 = state_19506__$1;
(statearr_19520_19543[(2)] = inst_19498);

(statearr_19520_19543[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19507 === (8))){
var inst_19485 = (state_19506[(7)]);
var inst_19478 = (state_19506[(10)]);
var inst_19486 = (state_19506[(8)]);
var inst_19487 = (state_19506[(9)]);
var inst_19490 = (function (){var cs = inst_19478;
var vec__19483 = inst_19485;
var v = inst_19486;
var c = inst_19487;
return ((function (cs,vec__19483,v,c,inst_19485,inst_19478,inst_19486,inst_19487,state_val_19507,c__8400__auto___19534,out){
return (function (p1__19473_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__19473_SHARP_);
});
;})(cs,vec__19483,v,c,inst_19485,inst_19478,inst_19486,inst_19487,state_val_19507,c__8400__auto___19534,out))
})();
var inst_19491 = cljs.core.filterv.call(null,inst_19490,inst_19478);
var inst_19478__$1 = inst_19491;
var state_19506__$1 = (function (){var statearr_19521 = state_19506;
(statearr_19521[(10)] = inst_19478__$1);

return statearr_19521;
})();
var statearr_19522_19544 = state_19506__$1;
(statearr_19522_19544[(2)] = null);

(statearr_19522_19544[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___19534,out))
;
return ((function (switch__8335__auto__,c__8400__auto___19534,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_19526 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19526[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_19526[(1)] = (1));

return statearr_19526;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_19506){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_19506);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e19527){if((e19527 instanceof Object)){
var ex__8339__auto__ = e19527;
var statearr_19528_19545 = state_19506;
(statearr_19528_19545[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19506);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19527;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19546 = state_19506;
state_19506 = G__19546;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_19506){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_19506);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___19534,out))
})();
var state__8402__auto__ = (function (){var statearr_19529 = f__8401__auto__.call(null);
(statearr_19529[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___19534);

return statearr_19529;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});})(c__8400__auto___19534,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args19547 = [];
var len__5627__auto___19596 = arguments.length;
var i__5628__auto___19597 = (0);
while(true){
if((i__5628__auto___19597 < len__5627__auto___19596)){
args19547.push((arguments[i__5628__auto___19597]));

var G__19598 = (i__5628__auto___19597 + (1));
i__5628__auto___19597 = G__19598;
continue;
} else {
}
break;
}

var G__19549 = args19547.length;
switch (G__19549) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19547.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8400__auto___19600 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8400__auto___19600,out){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___19600,out){
return (function (state_19573){
var state_val_19574 = (state_19573[(1)]);
if((state_val_19574 === (7))){
var inst_19555 = (state_19573[(7)]);
var inst_19555__$1 = (state_19573[(2)]);
var inst_19556 = (inst_19555__$1 == null);
var inst_19557 = cljs.core.not.call(null,inst_19556);
var state_19573__$1 = (function (){var statearr_19575 = state_19573;
(statearr_19575[(7)] = inst_19555__$1);

return statearr_19575;
})();
if(inst_19557){
var statearr_19576_19601 = state_19573__$1;
(statearr_19576_19601[(1)] = (8));

} else {
var statearr_19577_19602 = state_19573__$1;
(statearr_19577_19602[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19574 === (1))){
var inst_19550 = (0);
var state_19573__$1 = (function (){var statearr_19578 = state_19573;
(statearr_19578[(8)] = inst_19550);

return statearr_19578;
})();
var statearr_19579_19603 = state_19573__$1;
(statearr_19579_19603[(2)] = null);

(statearr_19579_19603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19574 === (4))){
var state_19573__$1 = state_19573;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19573__$1,(7),ch);
} else {
if((state_val_19574 === (6))){
var inst_19568 = (state_19573[(2)]);
var state_19573__$1 = state_19573;
var statearr_19580_19604 = state_19573__$1;
(statearr_19580_19604[(2)] = inst_19568);

(statearr_19580_19604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19574 === (3))){
var inst_19570 = (state_19573[(2)]);
var inst_19571 = cljs.core.async.close_BANG_.call(null,out);
var state_19573__$1 = (function (){var statearr_19581 = state_19573;
(statearr_19581[(9)] = inst_19570);

return statearr_19581;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19573__$1,inst_19571);
} else {
if((state_val_19574 === (2))){
var inst_19550 = (state_19573[(8)]);
var inst_19552 = (inst_19550 < n);
var state_19573__$1 = state_19573;
if(cljs.core.truth_(inst_19552)){
var statearr_19582_19605 = state_19573__$1;
(statearr_19582_19605[(1)] = (4));

} else {
var statearr_19583_19606 = state_19573__$1;
(statearr_19583_19606[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19574 === (11))){
var inst_19550 = (state_19573[(8)]);
var inst_19560 = (state_19573[(2)]);
var inst_19561 = (inst_19550 + (1));
var inst_19550__$1 = inst_19561;
var state_19573__$1 = (function (){var statearr_19584 = state_19573;
(statearr_19584[(8)] = inst_19550__$1);

(statearr_19584[(10)] = inst_19560);

return statearr_19584;
})();
var statearr_19585_19607 = state_19573__$1;
(statearr_19585_19607[(2)] = null);

(statearr_19585_19607[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19574 === (9))){
var state_19573__$1 = state_19573;
var statearr_19586_19608 = state_19573__$1;
(statearr_19586_19608[(2)] = null);

(statearr_19586_19608[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19574 === (5))){
var state_19573__$1 = state_19573;
var statearr_19587_19609 = state_19573__$1;
(statearr_19587_19609[(2)] = null);

(statearr_19587_19609[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19574 === (10))){
var inst_19565 = (state_19573[(2)]);
var state_19573__$1 = state_19573;
var statearr_19588_19610 = state_19573__$1;
(statearr_19588_19610[(2)] = inst_19565);

(statearr_19588_19610[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19574 === (8))){
var inst_19555 = (state_19573[(7)]);
var state_19573__$1 = state_19573;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19573__$1,(11),out,inst_19555);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___19600,out))
;
return ((function (switch__8335__auto__,c__8400__auto___19600,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_19592 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19592[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_19592[(1)] = (1));

return statearr_19592;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_19573){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_19573);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e19593){if((e19593 instanceof Object)){
var ex__8339__auto__ = e19593;
var statearr_19594_19611 = state_19573;
(statearr_19594_19611[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19573);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19593;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19612 = state_19573;
state_19573 = G__19612;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_19573){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_19573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___19600,out))
})();
var state__8402__auto__ = (function (){var statearr_19595 = f__8401__auto__.call(null);
(statearr_19595[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___19600);

return statearr_19595;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});})(c__8400__auto___19600,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19620 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19620 = (function (map_LT_,f,ch,meta19621){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19621 = meta19621;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19620.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19622,meta19621__$1){
var self__ = this;
var _19622__$1 = this;
return (new cljs.core.async.t_cljs$core$async19620(self__.map_LT_,self__.f,self__.ch,meta19621__$1));
});

cljs.core.async.t_cljs$core$async19620.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19622){
var self__ = this;
var _19622__$1 = this;
return self__.meta19621;
});

cljs.core.async.t_cljs$core$async19620.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19620.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19620.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19620.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19620.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async19623 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19623 = (function (map_LT_,f,ch,meta19621,_,fn1,meta19624){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19621 = meta19621;
this._ = _;
this.fn1 = fn1;
this.meta19624 = meta19624;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19623.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_19625,meta19624__$1){
var self__ = this;
var _19625__$1 = this;
return (new cljs.core.async.t_cljs$core$async19623(self__.map_LT_,self__.f,self__.ch,self__.meta19621,self__._,self__.fn1,meta19624__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async19623.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_19625){
var self__ = this;
var _19625__$1 = this;
return self__.meta19624;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19623.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19623.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19623.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__19613_SHARP_){
return f1.call(null,(((p1__19613_SHARP_ == null))?null:self__.f.call(null,p1__19613_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async19623.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19621","meta19621",484550038,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async19620","cljs.core.async/t_cljs$core$async19620",-1152892540,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta19624","meta19624",1141297274,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19623.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19623.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19623";

cljs.core.async.t_cljs$core$async19623.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async19623");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async19623 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19623(map_LT___$1,f__$1,ch__$1,meta19621__$1,___$2,fn1__$1,meta19624){
return (new cljs.core.async.t_cljs$core$async19623(map_LT___$1,f__$1,ch__$1,meta19621__$1,___$2,fn1__$1,meta19624));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async19623(self__.map_LT_,self__.f,self__.ch,self__.meta19621,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4557__auto__ = ret;
if(cljs.core.truth_(and__4557__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4557__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async19620.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19620.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async19620.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19621","meta19621",484550038,null)], null);
});

cljs.core.async.t_cljs$core$async19620.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19620.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19620";

cljs.core.async.t_cljs$core$async19620.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async19620");
});

cljs.core.async.__GT_t_cljs$core$async19620 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19620(map_LT___$1,f__$1,ch__$1,meta19621){
return (new cljs.core.async.t_cljs$core$async19620(map_LT___$1,f__$1,ch__$1,meta19621));
});

}

return (new cljs.core.async.t_cljs$core$async19620(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19629 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19629 = (function (map_GT_,f,ch,meta19630){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta19630 = meta19630;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19629.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19631,meta19630__$1){
var self__ = this;
var _19631__$1 = this;
return (new cljs.core.async.t_cljs$core$async19629(self__.map_GT_,self__.f,self__.ch,meta19630__$1));
});

cljs.core.async.t_cljs$core$async19629.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19631){
var self__ = this;
var _19631__$1 = this;
return self__.meta19630;
});

cljs.core.async.t_cljs$core$async19629.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19629.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19629.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19629.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19629.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19629.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async19629.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19630","meta19630",-604750470,null)], null);
});

cljs.core.async.t_cljs$core$async19629.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19629.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19629";

cljs.core.async.t_cljs$core$async19629.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async19629");
});

cljs.core.async.__GT_t_cljs$core$async19629 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async19629(map_GT___$1,f__$1,ch__$1,meta19630){
return (new cljs.core.async.t_cljs$core$async19629(map_GT___$1,f__$1,ch__$1,meta19630));
});

}

return (new cljs.core.async.t_cljs$core$async19629(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async19635 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19635 = (function (filter_GT_,p,ch,meta19636){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta19636 = meta19636;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19635.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19637,meta19636__$1){
var self__ = this;
var _19637__$1 = this;
return (new cljs.core.async.t_cljs$core$async19635(self__.filter_GT_,self__.p,self__.ch,meta19636__$1));
});

cljs.core.async.t_cljs$core$async19635.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19637){
var self__ = this;
var _19637__$1 = this;
return self__.meta19636;
});

cljs.core.async.t_cljs$core$async19635.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19635.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19635.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19635.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19635.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19635.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19635.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async19635.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19636","meta19636",-450190029,null)], null);
});

cljs.core.async.t_cljs$core$async19635.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19635.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19635";

cljs.core.async.t_cljs$core$async19635.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async19635");
});

cljs.core.async.__GT_t_cljs$core$async19635 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async19635(filter_GT___$1,p__$1,ch__$1,meta19636){
return (new cljs.core.async.t_cljs$core$async19635(filter_GT___$1,p__$1,ch__$1,meta19636));
});

}

return (new cljs.core.async.t_cljs$core$async19635(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args19638 = [];
var len__5627__auto___19682 = arguments.length;
var i__5628__auto___19683 = (0);
while(true){
if((i__5628__auto___19683 < len__5627__auto___19682)){
args19638.push((arguments[i__5628__auto___19683]));

var G__19684 = (i__5628__auto___19683 + (1));
i__5628__auto___19683 = G__19684;
continue;
} else {
}
break;
}

var G__19640 = args19638.length;
switch (G__19640) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19638.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8400__auto___19686 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8400__auto___19686,out){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___19686,out){
return (function (state_19661){
var state_val_19662 = (state_19661[(1)]);
if((state_val_19662 === (7))){
var inst_19657 = (state_19661[(2)]);
var state_19661__$1 = state_19661;
var statearr_19663_19687 = state_19661__$1;
(statearr_19663_19687[(2)] = inst_19657);

(statearr_19663_19687[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19662 === (1))){
var state_19661__$1 = state_19661;
var statearr_19664_19688 = state_19661__$1;
(statearr_19664_19688[(2)] = null);

(statearr_19664_19688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19662 === (4))){
var inst_19643 = (state_19661[(7)]);
var inst_19643__$1 = (state_19661[(2)]);
var inst_19644 = (inst_19643__$1 == null);
var state_19661__$1 = (function (){var statearr_19665 = state_19661;
(statearr_19665[(7)] = inst_19643__$1);

return statearr_19665;
})();
if(cljs.core.truth_(inst_19644)){
var statearr_19666_19689 = state_19661__$1;
(statearr_19666_19689[(1)] = (5));

} else {
var statearr_19667_19690 = state_19661__$1;
(statearr_19667_19690[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19662 === (6))){
var inst_19643 = (state_19661[(7)]);
var inst_19648 = p.call(null,inst_19643);
var state_19661__$1 = state_19661;
if(cljs.core.truth_(inst_19648)){
var statearr_19668_19691 = state_19661__$1;
(statearr_19668_19691[(1)] = (8));

} else {
var statearr_19669_19692 = state_19661__$1;
(statearr_19669_19692[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19662 === (3))){
var inst_19659 = (state_19661[(2)]);
var state_19661__$1 = state_19661;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19661__$1,inst_19659);
} else {
if((state_val_19662 === (2))){
var state_19661__$1 = state_19661;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19661__$1,(4),ch);
} else {
if((state_val_19662 === (11))){
var inst_19651 = (state_19661[(2)]);
var state_19661__$1 = state_19661;
var statearr_19670_19693 = state_19661__$1;
(statearr_19670_19693[(2)] = inst_19651);

(statearr_19670_19693[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19662 === (9))){
var state_19661__$1 = state_19661;
var statearr_19671_19694 = state_19661__$1;
(statearr_19671_19694[(2)] = null);

(statearr_19671_19694[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19662 === (5))){
var inst_19646 = cljs.core.async.close_BANG_.call(null,out);
var state_19661__$1 = state_19661;
var statearr_19672_19695 = state_19661__$1;
(statearr_19672_19695[(2)] = inst_19646);

(statearr_19672_19695[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19662 === (10))){
var inst_19654 = (state_19661[(2)]);
var state_19661__$1 = (function (){var statearr_19673 = state_19661;
(statearr_19673[(8)] = inst_19654);

return statearr_19673;
})();
var statearr_19674_19696 = state_19661__$1;
(statearr_19674_19696[(2)] = null);

(statearr_19674_19696[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19662 === (8))){
var inst_19643 = (state_19661[(7)]);
var state_19661__$1 = state_19661;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19661__$1,(11),out,inst_19643);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___19686,out))
;
return ((function (switch__8335__auto__,c__8400__auto___19686,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_19678 = [null,null,null,null,null,null,null,null,null];
(statearr_19678[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_19678[(1)] = (1));

return statearr_19678;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_19661){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_19661);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e19679){if((e19679 instanceof Object)){
var ex__8339__auto__ = e19679;
var statearr_19680_19697 = state_19661;
(statearr_19680_19697[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19661);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19679;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19698 = state_19661;
state_19661 = G__19698;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_19661){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_19661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___19686,out))
})();
var state__8402__auto__ = (function (){var statearr_19681 = f__8401__auto__.call(null);
(statearr_19681[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___19686);

return statearr_19681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});})(c__8400__auto___19686,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args19699 = [];
var len__5627__auto___19702 = arguments.length;
var i__5628__auto___19703 = (0);
while(true){
if((i__5628__auto___19703 < len__5627__auto___19702)){
args19699.push((arguments[i__5628__auto___19703]));

var G__19704 = (i__5628__auto___19703 + (1));
i__5628__auto___19703 = G__19704;
continue;
} else {
}
break;
}

var G__19701 = args19699.length;
switch (G__19701) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19699.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__8400__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8400__auto__){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto__){
return (function (state_19871){
var state_val_19872 = (state_19871[(1)]);
if((state_val_19872 === (7))){
var inst_19867 = (state_19871[(2)]);
var state_19871__$1 = state_19871;
var statearr_19873_19914 = state_19871__$1;
(statearr_19873_19914[(2)] = inst_19867);

(statearr_19873_19914[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (20))){
var inst_19837 = (state_19871[(7)]);
var inst_19848 = (state_19871[(2)]);
var inst_19849 = cljs.core.next.call(null,inst_19837);
var inst_19823 = inst_19849;
var inst_19824 = null;
var inst_19825 = (0);
var inst_19826 = (0);
var state_19871__$1 = (function (){var statearr_19874 = state_19871;
(statearr_19874[(8)] = inst_19826);

(statearr_19874[(9)] = inst_19825);

(statearr_19874[(10)] = inst_19848);

(statearr_19874[(11)] = inst_19824);

(statearr_19874[(12)] = inst_19823);

return statearr_19874;
})();
var statearr_19875_19915 = state_19871__$1;
(statearr_19875_19915[(2)] = null);

(statearr_19875_19915[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (1))){
var state_19871__$1 = state_19871;
var statearr_19876_19916 = state_19871__$1;
(statearr_19876_19916[(2)] = null);

(statearr_19876_19916[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (4))){
var inst_19812 = (state_19871[(13)]);
var inst_19812__$1 = (state_19871[(2)]);
var inst_19813 = (inst_19812__$1 == null);
var state_19871__$1 = (function (){var statearr_19877 = state_19871;
(statearr_19877[(13)] = inst_19812__$1);

return statearr_19877;
})();
if(cljs.core.truth_(inst_19813)){
var statearr_19878_19917 = state_19871__$1;
(statearr_19878_19917[(1)] = (5));

} else {
var statearr_19879_19918 = state_19871__$1;
(statearr_19879_19918[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (15))){
var state_19871__$1 = state_19871;
var statearr_19883_19919 = state_19871__$1;
(statearr_19883_19919[(2)] = null);

(statearr_19883_19919[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (21))){
var state_19871__$1 = state_19871;
var statearr_19884_19920 = state_19871__$1;
(statearr_19884_19920[(2)] = null);

(statearr_19884_19920[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (13))){
var inst_19826 = (state_19871[(8)]);
var inst_19825 = (state_19871[(9)]);
var inst_19824 = (state_19871[(11)]);
var inst_19823 = (state_19871[(12)]);
var inst_19833 = (state_19871[(2)]);
var inst_19834 = (inst_19826 + (1));
var tmp19880 = inst_19825;
var tmp19881 = inst_19824;
var tmp19882 = inst_19823;
var inst_19823__$1 = tmp19882;
var inst_19824__$1 = tmp19881;
var inst_19825__$1 = tmp19880;
var inst_19826__$1 = inst_19834;
var state_19871__$1 = (function (){var statearr_19885 = state_19871;
(statearr_19885[(8)] = inst_19826__$1);

(statearr_19885[(9)] = inst_19825__$1);

(statearr_19885[(11)] = inst_19824__$1);

(statearr_19885[(12)] = inst_19823__$1);

(statearr_19885[(14)] = inst_19833);

return statearr_19885;
})();
var statearr_19886_19921 = state_19871__$1;
(statearr_19886_19921[(2)] = null);

(statearr_19886_19921[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (22))){
var state_19871__$1 = state_19871;
var statearr_19887_19922 = state_19871__$1;
(statearr_19887_19922[(2)] = null);

(statearr_19887_19922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (6))){
var inst_19812 = (state_19871[(13)]);
var inst_19821 = f.call(null,inst_19812);
var inst_19822 = cljs.core.seq.call(null,inst_19821);
var inst_19823 = inst_19822;
var inst_19824 = null;
var inst_19825 = (0);
var inst_19826 = (0);
var state_19871__$1 = (function (){var statearr_19888 = state_19871;
(statearr_19888[(8)] = inst_19826);

(statearr_19888[(9)] = inst_19825);

(statearr_19888[(11)] = inst_19824);

(statearr_19888[(12)] = inst_19823);

return statearr_19888;
})();
var statearr_19889_19923 = state_19871__$1;
(statearr_19889_19923[(2)] = null);

(statearr_19889_19923[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (17))){
var inst_19837 = (state_19871[(7)]);
var inst_19841 = cljs.core.chunk_first.call(null,inst_19837);
var inst_19842 = cljs.core.chunk_rest.call(null,inst_19837);
var inst_19843 = cljs.core.count.call(null,inst_19841);
var inst_19823 = inst_19842;
var inst_19824 = inst_19841;
var inst_19825 = inst_19843;
var inst_19826 = (0);
var state_19871__$1 = (function (){var statearr_19890 = state_19871;
(statearr_19890[(8)] = inst_19826);

(statearr_19890[(9)] = inst_19825);

(statearr_19890[(11)] = inst_19824);

(statearr_19890[(12)] = inst_19823);

return statearr_19890;
})();
var statearr_19891_19924 = state_19871__$1;
(statearr_19891_19924[(2)] = null);

(statearr_19891_19924[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (3))){
var inst_19869 = (state_19871[(2)]);
var state_19871__$1 = state_19871;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19871__$1,inst_19869);
} else {
if((state_val_19872 === (12))){
var inst_19857 = (state_19871[(2)]);
var state_19871__$1 = state_19871;
var statearr_19892_19925 = state_19871__$1;
(statearr_19892_19925[(2)] = inst_19857);

(statearr_19892_19925[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (2))){
var state_19871__$1 = state_19871;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19871__$1,(4),in$);
} else {
if((state_val_19872 === (23))){
var inst_19865 = (state_19871[(2)]);
var state_19871__$1 = state_19871;
var statearr_19893_19926 = state_19871__$1;
(statearr_19893_19926[(2)] = inst_19865);

(statearr_19893_19926[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (19))){
var inst_19852 = (state_19871[(2)]);
var state_19871__$1 = state_19871;
var statearr_19894_19927 = state_19871__$1;
(statearr_19894_19927[(2)] = inst_19852);

(statearr_19894_19927[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (11))){
var inst_19837 = (state_19871[(7)]);
var inst_19823 = (state_19871[(12)]);
var inst_19837__$1 = cljs.core.seq.call(null,inst_19823);
var state_19871__$1 = (function (){var statearr_19895 = state_19871;
(statearr_19895[(7)] = inst_19837__$1);

return statearr_19895;
})();
if(inst_19837__$1){
var statearr_19896_19928 = state_19871__$1;
(statearr_19896_19928[(1)] = (14));

} else {
var statearr_19897_19929 = state_19871__$1;
(statearr_19897_19929[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (9))){
var inst_19859 = (state_19871[(2)]);
var inst_19860 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_19871__$1 = (function (){var statearr_19898 = state_19871;
(statearr_19898[(15)] = inst_19859);

return statearr_19898;
})();
if(cljs.core.truth_(inst_19860)){
var statearr_19899_19930 = state_19871__$1;
(statearr_19899_19930[(1)] = (21));

} else {
var statearr_19900_19931 = state_19871__$1;
(statearr_19900_19931[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (5))){
var inst_19815 = cljs.core.async.close_BANG_.call(null,out);
var state_19871__$1 = state_19871;
var statearr_19901_19932 = state_19871__$1;
(statearr_19901_19932[(2)] = inst_19815);

(statearr_19901_19932[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (14))){
var inst_19837 = (state_19871[(7)]);
var inst_19839 = cljs.core.chunked_seq_QMARK_.call(null,inst_19837);
var state_19871__$1 = state_19871;
if(inst_19839){
var statearr_19902_19933 = state_19871__$1;
(statearr_19902_19933[(1)] = (17));

} else {
var statearr_19903_19934 = state_19871__$1;
(statearr_19903_19934[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (16))){
var inst_19855 = (state_19871[(2)]);
var state_19871__$1 = state_19871;
var statearr_19904_19935 = state_19871__$1;
(statearr_19904_19935[(2)] = inst_19855);

(statearr_19904_19935[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (10))){
var inst_19826 = (state_19871[(8)]);
var inst_19824 = (state_19871[(11)]);
var inst_19831 = cljs.core._nth.call(null,inst_19824,inst_19826);
var state_19871__$1 = state_19871;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19871__$1,(13),out,inst_19831);
} else {
if((state_val_19872 === (18))){
var inst_19837 = (state_19871[(7)]);
var inst_19846 = cljs.core.first.call(null,inst_19837);
var state_19871__$1 = state_19871;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19871__$1,(20),out,inst_19846);
} else {
if((state_val_19872 === (8))){
var inst_19826 = (state_19871[(8)]);
var inst_19825 = (state_19871[(9)]);
var inst_19828 = (inst_19826 < inst_19825);
var inst_19829 = inst_19828;
var state_19871__$1 = state_19871;
if(cljs.core.truth_(inst_19829)){
var statearr_19905_19936 = state_19871__$1;
(statearr_19905_19936[(1)] = (10));

} else {
var statearr_19906_19937 = state_19871__$1;
(statearr_19906_19937[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto__))
;
return ((function (switch__8335__auto__,c__8400__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_19910 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19910[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__);

(statearr_19910[(1)] = (1));

return statearr_19910;
});
var cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____1 = (function (state_19871){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_19871);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e19911){if((e19911 instanceof Object)){
var ex__8339__auto__ = e19911;
var statearr_19912_19938 = state_19871;
(statearr_19912_19938[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19871);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19911;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19939 = state_19871;
state_19871 = G__19939;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__ = function(state_19871){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____1.call(this,state_19871);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto__))
})();
var state__8402__auto__ = (function (){var statearr_19913 = f__8401__auto__.call(null);
(statearr_19913[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto__);

return statearr_19913;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});})(c__8400__auto__))
);

return c__8400__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args19940 = [];
var len__5627__auto___19943 = arguments.length;
var i__5628__auto___19944 = (0);
while(true){
if((i__5628__auto___19944 < len__5627__auto___19943)){
args19940.push((arguments[i__5628__auto___19944]));

var G__19945 = (i__5628__auto___19944 + (1));
i__5628__auto___19944 = G__19945;
continue;
} else {
}
break;
}

var G__19942 = args19940.length;
switch (G__19942) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19940.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args19947 = [];
var len__5627__auto___19950 = arguments.length;
var i__5628__auto___19951 = (0);
while(true){
if((i__5628__auto___19951 < len__5627__auto___19950)){
args19947.push((arguments[i__5628__auto___19951]));

var G__19952 = (i__5628__auto___19951 + (1));
i__5628__auto___19951 = G__19952;
continue;
} else {
}
break;
}

var G__19949 = args19947.length;
switch (G__19949) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19947.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args19954 = [];
var len__5627__auto___20005 = arguments.length;
var i__5628__auto___20006 = (0);
while(true){
if((i__5628__auto___20006 < len__5627__auto___20005)){
args19954.push((arguments[i__5628__auto___20006]));

var G__20007 = (i__5628__auto___20006 + (1));
i__5628__auto___20006 = G__20007;
continue;
} else {
}
break;
}

var G__19956 = args19954.length;
switch (G__19956) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19954.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8400__auto___20009 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8400__auto___20009,out){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___20009,out){
return (function (state_19980){
var state_val_19981 = (state_19980[(1)]);
if((state_val_19981 === (7))){
var inst_19975 = (state_19980[(2)]);
var state_19980__$1 = state_19980;
var statearr_19982_20010 = state_19980__$1;
(statearr_19982_20010[(2)] = inst_19975);

(statearr_19982_20010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19981 === (1))){
var inst_19957 = null;
var state_19980__$1 = (function (){var statearr_19983 = state_19980;
(statearr_19983[(7)] = inst_19957);

return statearr_19983;
})();
var statearr_19984_20011 = state_19980__$1;
(statearr_19984_20011[(2)] = null);

(statearr_19984_20011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19981 === (4))){
var inst_19960 = (state_19980[(8)]);
var inst_19960__$1 = (state_19980[(2)]);
var inst_19961 = (inst_19960__$1 == null);
var inst_19962 = cljs.core.not.call(null,inst_19961);
var state_19980__$1 = (function (){var statearr_19985 = state_19980;
(statearr_19985[(8)] = inst_19960__$1);

return statearr_19985;
})();
if(inst_19962){
var statearr_19986_20012 = state_19980__$1;
(statearr_19986_20012[(1)] = (5));

} else {
var statearr_19987_20013 = state_19980__$1;
(statearr_19987_20013[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19981 === (6))){
var state_19980__$1 = state_19980;
var statearr_19988_20014 = state_19980__$1;
(statearr_19988_20014[(2)] = null);

(statearr_19988_20014[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19981 === (3))){
var inst_19977 = (state_19980[(2)]);
var inst_19978 = cljs.core.async.close_BANG_.call(null,out);
var state_19980__$1 = (function (){var statearr_19989 = state_19980;
(statearr_19989[(9)] = inst_19977);

return statearr_19989;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19980__$1,inst_19978);
} else {
if((state_val_19981 === (2))){
var state_19980__$1 = state_19980;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19980__$1,(4),ch);
} else {
if((state_val_19981 === (11))){
var inst_19960 = (state_19980[(8)]);
var inst_19969 = (state_19980[(2)]);
var inst_19957 = inst_19960;
var state_19980__$1 = (function (){var statearr_19990 = state_19980;
(statearr_19990[(7)] = inst_19957);

(statearr_19990[(10)] = inst_19969);

return statearr_19990;
})();
var statearr_19991_20015 = state_19980__$1;
(statearr_19991_20015[(2)] = null);

(statearr_19991_20015[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19981 === (9))){
var inst_19960 = (state_19980[(8)]);
var state_19980__$1 = state_19980;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19980__$1,(11),out,inst_19960);
} else {
if((state_val_19981 === (5))){
var inst_19957 = (state_19980[(7)]);
var inst_19960 = (state_19980[(8)]);
var inst_19964 = cljs.core._EQ_.call(null,inst_19960,inst_19957);
var state_19980__$1 = state_19980;
if(inst_19964){
var statearr_19993_20016 = state_19980__$1;
(statearr_19993_20016[(1)] = (8));

} else {
var statearr_19994_20017 = state_19980__$1;
(statearr_19994_20017[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19981 === (10))){
var inst_19972 = (state_19980[(2)]);
var state_19980__$1 = state_19980;
var statearr_19995_20018 = state_19980__$1;
(statearr_19995_20018[(2)] = inst_19972);

(statearr_19995_20018[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19981 === (8))){
var inst_19957 = (state_19980[(7)]);
var tmp19992 = inst_19957;
var inst_19957__$1 = tmp19992;
var state_19980__$1 = (function (){var statearr_19996 = state_19980;
(statearr_19996[(7)] = inst_19957__$1);

return statearr_19996;
})();
var statearr_19997_20019 = state_19980__$1;
(statearr_19997_20019[(2)] = null);

(statearr_19997_20019[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___20009,out))
;
return ((function (switch__8335__auto__,c__8400__auto___20009,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_20001 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20001[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_20001[(1)] = (1));

return statearr_20001;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_19980){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_19980);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e20002){if((e20002 instanceof Object)){
var ex__8339__auto__ = e20002;
var statearr_20003_20020 = state_19980;
(statearr_20003_20020[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19980);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20002;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20021 = state_19980;
state_19980 = G__20021;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_19980){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_19980);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___20009,out))
})();
var state__8402__auto__ = (function (){var statearr_20004 = f__8401__auto__.call(null);
(statearr_20004[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___20009);

return statearr_20004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});})(c__8400__auto___20009,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args20022 = [];
var len__5627__auto___20092 = arguments.length;
var i__5628__auto___20093 = (0);
while(true){
if((i__5628__auto___20093 < len__5627__auto___20092)){
args20022.push((arguments[i__5628__auto___20093]));

var G__20094 = (i__5628__auto___20093 + (1));
i__5628__auto___20093 = G__20094;
continue;
} else {
}
break;
}

var G__20024 = args20022.length;
switch (G__20024) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20022.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8400__auto___20096 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8400__auto___20096,out){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___20096,out){
return (function (state_20062){
var state_val_20063 = (state_20062[(1)]);
if((state_val_20063 === (7))){
var inst_20058 = (state_20062[(2)]);
var state_20062__$1 = state_20062;
var statearr_20064_20097 = state_20062__$1;
(statearr_20064_20097[(2)] = inst_20058);

(statearr_20064_20097[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20063 === (1))){
var inst_20025 = (new Array(n));
var inst_20026 = inst_20025;
var inst_20027 = (0);
var state_20062__$1 = (function (){var statearr_20065 = state_20062;
(statearr_20065[(7)] = inst_20026);

(statearr_20065[(8)] = inst_20027);

return statearr_20065;
})();
var statearr_20066_20098 = state_20062__$1;
(statearr_20066_20098[(2)] = null);

(statearr_20066_20098[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20063 === (4))){
var inst_20030 = (state_20062[(9)]);
var inst_20030__$1 = (state_20062[(2)]);
var inst_20031 = (inst_20030__$1 == null);
var inst_20032 = cljs.core.not.call(null,inst_20031);
var state_20062__$1 = (function (){var statearr_20067 = state_20062;
(statearr_20067[(9)] = inst_20030__$1);

return statearr_20067;
})();
if(inst_20032){
var statearr_20068_20099 = state_20062__$1;
(statearr_20068_20099[(1)] = (5));

} else {
var statearr_20069_20100 = state_20062__$1;
(statearr_20069_20100[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20063 === (15))){
var inst_20052 = (state_20062[(2)]);
var state_20062__$1 = state_20062;
var statearr_20070_20101 = state_20062__$1;
(statearr_20070_20101[(2)] = inst_20052);

(statearr_20070_20101[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20063 === (13))){
var state_20062__$1 = state_20062;
var statearr_20071_20102 = state_20062__$1;
(statearr_20071_20102[(2)] = null);

(statearr_20071_20102[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20063 === (6))){
var inst_20027 = (state_20062[(8)]);
var inst_20048 = (inst_20027 > (0));
var state_20062__$1 = state_20062;
if(cljs.core.truth_(inst_20048)){
var statearr_20072_20103 = state_20062__$1;
(statearr_20072_20103[(1)] = (12));

} else {
var statearr_20073_20104 = state_20062__$1;
(statearr_20073_20104[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20063 === (3))){
var inst_20060 = (state_20062[(2)]);
var state_20062__$1 = state_20062;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20062__$1,inst_20060);
} else {
if((state_val_20063 === (12))){
var inst_20026 = (state_20062[(7)]);
var inst_20050 = cljs.core.vec.call(null,inst_20026);
var state_20062__$1 = state_20062;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20062__$1,(15),out,inst_20050);
} else {
if((state_val_20063 === (2))){
var state_20062__$1 = state_20062;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20062__$1,(4),ch);
} else {
if((state_val_20063 === (11))){
var inst_20042 = (state_20062[(2)]);
var inst_20043 = (new Array(n));
var inst_20026 = inst_20043;
var inst_20027 = (0);
var state_20062__$1 = (function (){var statearr_20074 = state_20062;
(statearr_20074[(10)] = inst_20042);

(statearr_20074[(7)] = inst_20026);

(statearr_20074[(8)] = inst_20027);

return statearr_20074;
})();
var statearr_20075_20105 = state_20062__$1;
(statearr_20075_20105[(2)] = null);

(statearr_20075_20105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20063 === (9))){
var inst_20026 = (state_20062[(7)]);
var inst_20040 = cljs.core.vec.call(null,inst_20026);
var state_20062__$1 = state_20062;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20062__$1,(11),out,inst_20040);
} else {
if((state_val_20063 === (5))){
var inst_20030 = (state_20062[(9)]);
var inst_20035 = (state_20062[(11)]);
var inst_20026 = (state_20062[(7)]);
var inst_20027 = (state_20062[(8)]);
var inst_20034 = (inst_20026[inst_20027] = inst_20030);
var inst_20035__$1 = (inst_20027 + (1));
var inst_20036 = (inst_20035__$1 < n);
var state_20062__$1 = (function (){var statearr_20076 = state_20062;
(statearr_20076[(11)] = inst_20035__$1);

(statearr_20076[(12)] = inst_20034);

return statearr_20076;
})();
if(cljs.core.truth_(inst_20036)){
var statearr_20077_20106 = state_20062__$1;
(statearr_20077_20106[(1)] = (8));

} else {
var statearr_20078_20107 = state_20062__$1;
(statearr_20078_20107[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20063 === (14))){
var inst_20055 = (state_20062[(2)]);
var inst_20056 = cljs.core.async.close_BANG_.call(null,out);
var state_20062__$1 = (function (){var statearr_20080 = state_20062;
(statearr_20080[(13)] = inst_20055);

return statearr_20080;
})();
var statearr_20081_20108 = state_20062__$1;
(statearr_20081_20108[(2)] = inst_20056);

(statearr_20081_20108[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20063 === (10))){
var inst_20046 = (state_20062[(2)]);
var state_20062__$1 = state_20062;
var statearr_20082_20109 = state_20062__$1;
(statearr_20082_20109[(2)] = inst_20046);

(statearr_20082_20109[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20063 === (8))){
var inst_20035 = (state_20062[(11)]);
var inst_20026 = (state_20062[(7)]);
var tmp20079 = inst_20026;
var inst_20026__$1 = tmp20079;
var inst_20027 = inst_20035;
var state_20062__$1 = (function (){var statearr_20083 = state_20062;
(statearr_20083[(7)] = inst_20026__$1);

(statearr_20083[(8)] = inst_20027);

return statearr_20083;
})();
var statearr_20084_20110 = state_20062__$1;
(statearr_20084_20110[(2)] = null);

(statearr_20084_20110[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___20096,out))
;
return ((function (switch__8335__auto__,c__8400__auto___20096,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_20088 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20088[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_20088[(1)] = (1));

return statearr_20088;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_20062){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_20062);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e20089){if((e20089 instanceof Object)){
var ex__8339__auto__ = e20089;
var statearr_20090_20111 = state_20062;
(statearr_20090_20111[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20062);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20089;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20112 = state_20062;
state_20062 = G__20112;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_20062){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_20062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___20096,out))
})();
var state__8402__auto__ = (function (){var statearr_20091 = f__8401__auto__.call(null);
(statearr_20091[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___20096);

return statearr_20091;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});})(c__8400__auto___20096,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args20113 = [];
var len__5627__auto___20187 = arguments.length;
var i__5628__auto___20188 = (0);
while(true){
if((i__5628__auto___20188 < len__5627__auto___20187)){
args20113.push((arguments[i__5628__auto___20188]));

var G__20189 = (i__5628__auto___20188 + (1));
i__5628__auto___20188 = G__20189;
continue;
} else {
}
break;
}

var G__20115 = args20113.length;
switch (G__20115) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20113.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8400__auto___20191 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8400__auto___20191,out){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___20191,out){
return (function (state_20157){
var state_val_20158 = (state_20157[(1)]);
if((state_val_20158 === (7))){
var inst_20153 = (state_20157[(2)]);
var state_20157__$1 = state_20157;
var statearr_20159_20192 = state_20157__$1;
(statearr_20159_20192[(2)] = inst_20153);

(statearr_20159_20192[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20158 === (1))){
var inst_20116 = [];
var inst_20117 = inst_20116;
var inst_20118 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_20157__$1 = (function (){var statearr_20160 = state_20157;
(statearr_20160[(7)] = inst_20118);

(statearr_20160[(8)] = inst_20117);

return statearr_20160;
})();
var statearr_20161_20193 = state_20157__$1;
(statearr_20161_20193[(2)] = null);

(statearr_20161_20193[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20158 === (4))){
var inst_20121 = (state_20157[(9)]);
var inst_20121__$1 = (state_20157[(2)]);
var inst_20122 = (inst_20121__$1 == null);
var inst_20123 = cljs.core.not.call(null,inst_20122);
var state_20157__$1 = (function (){var statearr_20162 = state_20157;
(statearr_20162[(9)] = inst_20121__$1);

return statearr_20162;
})();
if(inst_20123){
var statearr_20163_20194 = state_20157__$1;
(statearr_20163_20194[(1)] = (5));

} else {
var statearr_20164_20195 = state_20157__$1;
(statearr_20164_20195[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20158 === (15))){
var inst_20147 = (state_20157[(2)]);
var state_20157__$1 = state_20157;
var statearr_20165_20196 = state_20157__$1;
(statearr_20165_20196[(2)] = inst_20147);

(statearr_20165_20196[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20158 === (13))){
var state_20157__$1 = state_20157;
var statearr_20166_20197 = state_20157__$1;
(statearr_20166_20197[(2)] = null);

(statearr_20166_20197[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20158 === (6))){
var inst_20117 = (state_20157[(8)]);
var inst_20142 = inst_20117.length;
var inst_20143 = (inst_20142 > (0));
var state_20157__$1 = state_20157;
if(cljs.core.truth_(inst_20143)){
var statearr_20167_20198 = state_20157__$1;
(statearr_20167_20198[(1)] = (12));

} else {
var statearr_20168_20199 = state_20157__$1;
(statearr_20168_20199[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20158 === (3))){
var inst_20155 = (state_20157[(2)]);
var state_20157__$1 = state_20157;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20157__$1,inst_20155);
} else {
if((state_val_20158 === (12))){
var inst_20117 = (state_20157[(8)]);
var inst_20145 = cljs.core.vec.call(null,inst_20117);
var state_20157__$1 = state_20157;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20157__$1,(15),out,inst_20145);
} else {
if((state_val_20158 === (2))){
var state_20157__$1 = state_20157;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20157__$1,(4),ch);
} else {
if((state_val_20158 === (11))){
var inst_20121 = (state_20157[(9)]);
var inst_20125 = (state_20157[(10)]);
var inst_20135 = (state_20157[(2)]);
var inst_20136 = [];
var inst_20137 = inst_20136.push(inst_20121);
var inst_20117 = inst_20136;
var inst_20118 = inst_20125;
var state_20157__$1 = (function (){var statearr_20169 = state_20157;
(statearr_20169[(7)] = inst_20118);

(statearr_20169[(11)] = inst_20137);

(statearr_20169[(12)] = inst_20135);

(statearr_20169[(8)] = inst_20117);

return statearr_20169;
})();
var statearr_20170_20200 = state_20157__$1;
(statearr_20170_20200[(2)] = null);

(statearr_20170_20200[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20158 === (9))){
var inst_20117 = (state_20157[(8)]);
var inst_20133 = cljs.core.vec.call(null,inst_20117);
var state_20157__$1 = state_20157;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20157__$1,(11),out,inst_20133);
} else {
if((state_val_20158 === (5))){
var inst_20118 = (state_20157[(7)]);
var inst_20121 = (state_20157[(9)]);
var inst_20125 = (state_20157[(10)]);
var inst_20125__$1 = f.call(null,inst_20121);
var inst_20126 = cljs.core._EQ_.call(null,inst_20125__$1,inst_20118);
var inst_20127 = cljs.core.keyword_identical_QMARK_.call(null,inst_20118,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_20128 = (inst_20126) || (inst_20127);
var state_20157__$1 = (function (){var statearr_20171 = state_20157;
(statearr_20171[(10)] = inst_20125__$1);

return statearr_20171;
})();
if(cljs.core.truth_(inst_20128)){
var statearr_20172_20201 = state_20157__$1;
(statearr_20172_20201[(1)] = (8));

} else {
var statearr_20173_20202 = state_20157__$1;
(statearr_20173_20202[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20158 === (14))){
var inst_20150 = (state_20157[(2)]);
var inst_20151 = cljs.core.async.close_BANG_.call(null,out);
var state_20157__$1 = (function (){var statearr_20175 = state_20157;
(statearr_20175[(13)] = inst_20150);

return statearr_20175;
})();
var statearr_20176_20203 = state_20157__$1;
(statearr_20176_20203[(2)] = inst_20151);

(statearr_20176_20203[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20158 === (10))){
var inst_20140 = (state_20157[(2)]);
var state_20157__$1 = state_20157;
var statearr_20177_20204 = state_20157__$1;
(statearr_20177_20204[(2)] = inst_20140);

(statearr_20177_20204[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20158 === (8))){
var inst_20121 = (state_20157[(9)]);
var inst_20125 = (state_20157[(10)]);
var inst_20117 = (state_20157[(8)]);
var inst_20130 = inst_20117.push(inst_20121);
var tmp20174 = inst_20117;
var inst_20117__$1 = tmp20174;
var inst_20118 = inst_20125;
var state_20157__$1 = (function (){var statearr_20178 = state_20157;
(statearr_20178[(7)] = inst_20118);

(statearr_20178[(14)] = inst_20130);

(statearr_20178[(8)] = inst_20117__$1);

return statearr_20178;
})();
var statearr_20179_20205 = state_20157__$1;
(statearr_20179_20205[(2)] = null);

(statearr_20179_20205[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___20191,out))
;
return ((function (switch__8335__auto__,c__8400__auto___20191,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_20183 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20183[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_20183[(1)] = (1));

return statearr_20183;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_20157){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_20157);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e20184){if((e20184 instanceof Object)){
var ex__8339__auto__ = e20184;
var statearr_20185_20206 = state_20157;
(statearr_20185_20206[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20157);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20184;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20207 = state_20157;
state_20157 = G__20207;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_20157){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_20157);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___20191,out))
})();
var state__8402__auto__ = (function (){var statearr_20186 = f__8401__auto__.call(null);
(statearr_20186[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___20191);

return statearr_20186;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8402__auto__);
});})(c__8400__auto___20191,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
