// Compiled by ClojureScript 1.7.145 {}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});
c2.dom.select;

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__5224__auto__ = (((x == null))?null:x);
var m__5225__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,x);
} else {
var m__5225__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,x);
} else {
throw cljs.core.missing_protocol.call(null,"IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return c2.dom.select.call(null,selector);
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render.call(null,v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args23879 = [];
var len__5627__auto___23882 = arguments.length;
var i__5628__auto___23883 = (0);
while(true){
if((i__5628__auto___23883 < len__5627__auto___23882)){
args23879.push((arguments[i__5628__auto___23883]));

var G__23884 = (i__5628__auto___23883 + (1));
i__5628__auto___23883 = G__23884;
continue;
} else {
}
break;
}

var G__23881 = args23879.length;
switch (G__23881) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23879.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;
/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args23886 = [];
var len__5627__auto___23889 = arguments.length;
var i__5628__auto___23890 = (0);
while(true){
if((i__5628__auto___23890 < len__5627__auto___23889)){
args23886.push((arguments[i__5628__auto___23890]));

var G__23891 = (i__5628__auto___23890 + (1));
i__5628__auto___23890 = G__23891;
continue;
} else {
}
break;
}

var G__23888 = args23886.length;
switch (G__23888) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23886.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;
/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom.call(null,node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom.call(null,node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.appendChild(c2.dom.__GT_dom.call(null,container),el__$1);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.insertChildAt(c2.dom.__GT_dom.call(null,container),el__$1,(0));

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
return goog.dom.removeNode(c2.dom.__GT_dom.call(null,el));
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom.call(null,new$);
goog.dom.replaceNode(new$__$1,c2.dom.__GT_dom.call(null,old));

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args23893 = [];
var len__5627__auto___23902 = arguments.length;
var i__5628__auto___23903 = (0);
while(true){
if((i__5628__auto___23903 < len__5627__auto___23902)){
args23893.push((arguments[i__5628__auto___23903]));

var G__23904 = (i__5628__auto___23903 + (1));
i__5628__auto___23903 = G__23904;
continue;
} else {
}
break;
}

var G__23895 = args23893.length;
switch (G__23895) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23893.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return goog.style.getComputedStyle(el__$1,cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__23896_23906 = cljs.core.seq.call(null,x);
var chunk__23897_23907 = null;
var count__23898_23908 = (0);
var i__23899_23909 = (0);
while(true){
if((i__23899_23909 < count__23898_23908)){
var vec__23900_23910 = cljs.core._nth.call(null,chunk__23897_23907,i__23899_23909);
var k_23911 = cljs.core.nth.call(null,vec__23900_23910,(0),null);
var v_23912 = cljs.core.nth.call(null,vec__23900_23910,(1),null);
c2.dom.style.call(null,el__$1,k_23911,v_23912);

var G__23913 = seq__23896_23906;
var G__23914 = chunk__23897_23907;
var G__23915 = count__23898_23908;
var G__23916 = (i__23899_23909 + (1));
seq__23896_23906 = G__23913;
chunk__23897_23907 = G__23914;
count__23898_23908 = G__23915;
i__23899_23909 = G__23916;
continue;
} else {
var temp__4425__auto___23917 = cljs.core.seq.call(null,seq__23896_23906);
if(temp__4425__auto___23917){
var seq__23896_23918__$1 = temp__4425__auto___23917;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23896_23918__$1)){
var c__5372__auto___23919 = cljs.core.chunk_first.call(null,seq__23896_23918__$1);
var G__23920 = cljs.core.chunk_rest.call(null,seq__23896_23918__$1);
var G__23921 = c__5372__auto___23919;
var G__23922 = cljs.core.count.call(null,c__5372__auto___23919);
var G__23923 = (0);
seq__23896_23906 = G__23920;
chunk__23897_23907 = G__23921;
count__23898_23908 = G__23922;
i__23899_23909 = G__23923;
continue;
} else {
var vec__23901_23924 = cljs.core.first.call(null,seq__23896_23918__$1);
var k_23925 = cljs.core.nth.call(null,vec__23901_23924,(0),null);
var v_23926 = cljs.core.nth.call(null,vec__23901_23924,(1),null);
c2.dom.style.call(null,el__$1,k_23925,v_23926);

var G__23927 = cljs.core.next.call(null,seq__23896_23918__$1);
var G__23928 = null;
var G__23929 = (0);
var G__23930 = (0);
seq__23896_23906 = G__23927;
chunk__23897_23907 = G__23928;
count__23898_23908 = G__23929;
i__23899_23909 = G__23930;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
goog.style.setStyle(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,k),((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"bottom","bottom",-1550509018),null,new cljs.core.Keyword(null,"top","top",-1856271961),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"right","right",-452581833),null,new cljs.core.Keyword(null,"height","height",1025178622),null,new cljs.core.Keyword(null,"left","left",-399115937),null], null), null).call(null,cljs.core.keyword.call(null,k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null)));

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args23931 = [];
var len__5627__auto___23944 = arguments.length;
var i__5628__auto___23945 = (0);
while(true){
if((i__5628__auto___23945 < len__5627__auto___23944)){
args23931.push((arguments[i__5628__auto___23945]));

var G__23946 = (i__5628__auto___23945 + (1));
i__5628__auto___23945 = G__23946;
continue;
} else {
}
break;
}

var G__23933 = args23931.length;
switch (G__23933) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23931.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom.call(null,el).attributes;
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5341__auto__ = ((function (attrs){
return (function c2$dom$iter__23934(s__23935){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__23935__$1 = s__23935;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23935__$1);
if(temp__4425__auto__){
var s__23935__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23935__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__23935__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__23937 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__23936 = (0);
while(true){
if((i__23936 < size__5340__auto__)){
var i = cljs.core._nth.call(null,c__5339__auto__,i__23936);
cljs.core.chunk_append.call(null,b__23937,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null));

var G__23948 = (i__23936 + (1));
i__23936 = G__23948;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23937),c2$dom$iter__23934.call(null,cljs.core.chunk_rest.call(null,s__23935__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23937),null);
}
} else {
var i = cljs.core.first.call(null,s__23935__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__23934.call(null,cljs.core.rest.call(null,s__23935__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__5341__auto__.call(null,cljs.core.range.call(null,attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__23938_23949 = cljs.core.seq.call(null,x);
var chunk__23939_23950 = null;
var count__23940_23951 = (0);
var i__23941_23952 = (0);
while(true){
if((i__23941_23952 < count__23940_23951)){
var vec__23942_23953 = cljs.core._nth.call(null,chunk__23939_23950,i__23941_23952);
var k_23954 = cljs.core.nth.call(null,vec__23942_23953,(0),null);
var v_23955 = cljs.core.nth.call(null,vec__23942_23953,(1),null);
c2.dom.attr.call(null,el__$1,k_23954,v_23955);

var G__23956 = seq__23938_23949;
var G__23957 = chunk__23939_23950;
var G__23958 = count__23940_23951;
var G__23959 = (i__23941_23952 + (1));
seq__23938_23949 = G__23956;
chunk__23939_23950 = G__23957;
count__23940_23951 = G__23958;
i__23941_23952 = G__23959;
continue;
} else {
var temp__4425__auto___23960 = cljs.core.seq.call(null,seq__23938_23949);
if(temp__4425__auto___23960){
var seq__23938_23961__$1 = temp__4425__auto___23960;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23938_23961__$1)){
var c__5372__auto___23962 = cljs.core.chunk_first.call(null,seq__23938_23961__$1);
var G__23963 = cljs.core.chunk_rest.call(null,seq__23938_23961__$1);
var G__23964 = c__5372__auto___23962;
var G__23965 = cljs.core.count.call(null,c__5372__auto___23962);
var G__23966 = (0);
seq__23938_23949 = G__23963;
chunk__23939_23950 = G__23964;
count__23940_23951 = G__23965;
i__23941_23952 = G__23966;
continue;
} else {
var vec__23943_23967 = cljs.core.first.call(null,seq__23938_23961__$1);
var k_23968 = cljs.core.nth.call(null,vec__23943_23967,(0),null);
var v_23969 = cljs.core.nth.call(null,vec__23943_23967,(1),null);
c2.dom.attr.call(null,el__$1,k_23968,v_23969);

var G__23970 = cljs.core.next.call(null,seq__23938_23961__$1);
var G__23971 = null;
var G__23972 = (0);
var G__23973 = (0);
seq__23938_23949 = G__23970;
chunk__23939_23950 = G__23971;
count__23940_23951 = G__23972;
i__23941_23952 = G__23973;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name.call(null,k));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"style","style",-496642736),k)){
c2.dom.style.call(null,el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name.call(null,k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args23974 = [];
var len__5627__auto___23977 = arguments.length;
var i__5628__auto___23978 = (0);
while(true){
if((i__5628__auto___23978 < len__5627__auto___23977)){
args23974.push((arguments[i__5628__auto___23978]));

var G__23979 = (i__5628__auto___23978 + (1));
i__5628__auto___23978 = G__23979;
continue;
} else {
}
break;
}

var G__23976 = args23974.length;
switch (G__23976) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23974.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.getTextContent(c2.dom.__GT_dom.call(null,el));
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;
/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args23981 = [];
var len__5627__auto___23984 = arguments.length;
var i__5628__auto___23985 = (0);
while(true){
if((i__5628__auto___23985 < len__5627__auto___23984)){
args23981.push((arguments[i__5628__auto___23985]));

var G__23986 = (i__5628__auto___23985 + (1));
i__5628__auto___23985 = G__23986;
continue;
} else {
}
break;
}

var G__23983 = args23981.length;
switch (G__23983) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23981.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.forms.getValue(c2.dom.__GT_dom.call(null,el));
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;
/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
goog.dom.classes.enable(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,class$),classed_QMARK_);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__4569__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var or__4569__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__4569__auto____$1)){
return or__4569__auto____$1;
} else {
return ((function (or__4569__auto____$1,or__4569__auto__){
return (function (p1__23988_SHARP_){
return setTimeout(((function (or__4569__auto____$1,or__4569__auto__){
return (function (){
return p1__23988_SHARP_.call(null);
});})(or__4569__auto____$1,or__4569__auto__))
,(10));
});
;})(or__4569__auto____$1,or__4569__auto__))
}
}
})();
