// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__41774__delegate = function (args){
if(cljs.core.map_QMARK_(cljs.core.first(args))){
var vec__41773 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,cljs.core.rest(args));
var tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41773,(0),null);
var body = cljs.core.nthnext(vec__41773,(1));
if(cljs.core.map_QMARK_(cljs.core.first(body))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.first(body),cljs.core.first(args)], 0)),cljs.core.rest(body));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.first(args),body);
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,args);
}
};
var G__41774 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__41775__i = 0, G__41775__a = new Array(arguments.length -  0);
while (G__41775__i < G__41775__a.length) {G__41775__a[G__41775__i] = arguments[G__41775__i + 0]; ++G__41775__i;}
  args = new cljs.core.IndexedSeq(G__41775__a,0);
} 
return G__41774__delegate.call(this,args);};
G__41774.cljs$lang$maxFixedArity = 0;
G__41774.cljs$lang$applyTo = (function (arglist__41776){
var args = cljs.core.seq(arglist__41776);
return G__41774__delegate(args);
});
G__41774.cljs$core$IFn$_invoke$arity$variadic = G__41774__delegate;
return G__41774;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5341__auto__ = (function sablono$core$update_arglists_$_iter__41783(s__41784){
return (new cljs.core.LazySeq(null,(function (){
var s__41784__$1 = s__41784;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__41784__$1);
if(temp__4425__auto__){
var s__41784__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41784__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__41784__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__41786 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__41785 = (0);
while(true){
if((i__41785 < size__5340__auto__)){
var args = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__41785);
cljs.core.chunk_append(b__41786,cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)));

var G__41789 = (i__41785 + (1));
i__41785 = G__41789;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41786),sablono$core$update_arglists_$_iter__41783(cljs.core.chunk_rest(s__41784__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41786),null);
}
} else {
var args = cljs.core.first(s__41784__$2);
return cljs.core.cons(cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)),sablono$core$update_arglists_$_iter__41783(cljs.core.rest(s__41784__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5634__auto__ = [];
var len__5627__auto___41797 = arguments.length;
var i__5628__auto___41798 = (0);
while(true){
if((i__5628__auto___41798 < len__5627__auto___41797)){
args__5634__auto__.push((arguments[i__5628__auto___41798]));

var G__41799 = (i__5628__auto___41798 + (1));
i__5628__auto___41798 = G__41799;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5341__auto__ = (function sablono$core$iter__41791(s__41792){
return (new cljs.core.LazySeq(null,(function (){
var s__41792__$1 = s__41792;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__41792__$1);
if(temp__4425__auto__){
var s__41792__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41792__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__41792__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__41794 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__41793 = (0);
while(true){
if((i__41793 < size__5340__auto__)){
var style = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__41793);
cljs.core.chunk_append(b__41794,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null));

var G__41800 = (i__41793 + (1));
i__41793 = G__41800;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41794),sablono$core$iter__41791(cljs.core.chunk_rest(s__41792__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41794),null);
}
} else {
var style = cljs.core.first(s__41792__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null),sablono$core$iter__41791(cljs.core.rest(s__41792__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq41790){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41790));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
var G__41805 = goog.dom.getDocument().body;
var G__41806 = (function (){var G__41807 = "script";
var G__41808 = {"src": src};
return goog.dom.createDom(G__41807,G__41808);
})();
return goog.dom.appendChild(G__41805,G__41806);
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js("http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to41809 = (function sablono$core$link_to41809(var_args){
var args__5634__auto__ = [];
var len__5627__auto___41812 = arguments.length;
var i__5628__auto___41813 = (0);
while(true){
if((i__5628__auto___41813 < len__5627__auto___41812)){
args__5634__auto__.push((arguments[i__5628__auto___41813]));

var G__41814 = (i__5628__auto___41813 + (1));
i__5628__auto___41813 = G__41814;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.link_to41809.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.link_to41809.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([url], 0))], null),content], null);
});

sablono.core.link_to41809.cljs$lang$maxFixedArity = (1);

sablono.core.link_to41809.cljs$lang$applyTo = (function (seq41810){
var G__41811 = cljs.core.first(seq41810);
var seq41810__$1 = cljs.core.next(seq41810);
return sablono.core.link_to41809.cljs$core$IFn$_invoke$arity$variadic(G__41811,seq41810__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs(sablono.core.link_to41809);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to41815 = (function sablono$core$mail_to41815(var_args){
var args__5634__auto__ = [];
var len__5627__auto___41820 = arguments.length;
var i__5628__auto___41821 = (0);
while(true){
if((i__5628__auto___41821 < len__5627__auto___41820)){
args__5634__auto__.push((arguments[i__5628__auto___41821]));

var G__41822 = (i__5628__auto___41821 + (1));
i__5628__auto___41821 = G__41822;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.mail_to41815.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.mail_to41815.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__41818){
var vec__41819 = p__41818;
var content = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41819,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4569__auto__ = content;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to41815.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to41815.cljs$lang$applyTo = (function (seq41816){
var G__41817 = cljs.core.first(seq41816);
var seq41816__$1 = cljs.core.next(seq41816);
return sablono.core.mail_to41815.cljs$core$IFn$_invoke$arity$variadic(G__41817,seq41816__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs(sablono.core.mail_to41815);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list41823 = (function sablono$core$unordered_list41823(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,(function (){var iter__5341__auto__ = (function sablono$core$unordered_list41823_$_iter__41830(s__41831){
return (new cljs.core.LazySeq(null,(function (){
var s__41831__$1 = s__41831;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__41831__$1);
if(temp__4425__auto__){
var s__41831__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41831__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__41831__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__41833 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__41832 = (0);
while(true){
if((i__41832 < size__5340__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__41832);
cljs.core.chunk_append(b__41833,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__41836 = (i__41832 + (1));
i__41832 = G__41836;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41833),sablono$core$unordered_list41823_$_iter__41830(cljs.core.chunk_rest(s__41831__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41833),null);
}
} else {
var x = cljs.core.first(s__41831__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$unordered_list41823_$_iter__41830(cljs.core.rest(s__41831__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs(sablono.core.unordered_list41823);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list41837 = (function sablono$core$ordered_list41837(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ol,(function (){var iter__5341__auto__ = (function sablono$core$ordered_list41837_$_iter__41844(s__41845){
return (new cljs.core.LazySeq(null,(function (){
var s__41845__$1 = s__41845;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__41845__$1);
if(temp__4425__auto__){
var s__41845__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41845__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__41845__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__41847 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__41846 = (0);
while(true){
if((i__41846 < size__5340__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__41846);
cljs.core.chunk_append(b__41847,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__41850 = (i__41846 + (1));
i__41846 = G__41850;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41847),sablono$core$ordered_list41837_$_iter__41844(cljs.core.chunk_rest(s__41845__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41847),null);
}
} else {
var x = cljs.core.first(s__41845__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$ordered_list41837_$_iter__41844(cljs.core.rest(s__41845__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs(sablono.core.ordered_list41837);
/**
 * Create an image element.
 */
sablono.core.image41851 = (function sablono$core$image41851(var_args){
var args41852 = [];
var len__5627__auto___41855 = arguments.length;
var i__5628__auto___41856 = (0);
while(true){
if((i__5628__auto___41856 < len__5627__auto___41855)){
args41852.push((arguments[i__5628__auto___41856]));

var G__41857 = (i__5628__auto___41856 + (1));
i__5628__auto___41856 = G__41857;
continue;
} else {
}
break;
}

var G__41854 = args41852.length;
switch (G__41854) {
case 1:
return sablono.core.image41851.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image41851.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41852.length)].join('')));

}
});

sablono.core.image41851.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0))], null)], null);
});

sablono.core.image41851.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0)),cljs.core.cst$kw$alt,alt], null)], null);
});

sablono.core.image41851.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs(sablono.core.image41851);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__41859_SHARP_,p2__41860_SHARP_){
return [cljs.core.str(p1__41859_SHARP_),cljs.core.str("["),cljs.core.str(p2__41860_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__41861_SHARP_,p2__41862_SHARP_){
return [cljs.core.str(p1__41861_SHARP_),cljs.core.str("-"),cljs.core.str(p2__41862_SHARP_)].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,type,cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field41863 = (function sablono$core$color_field41863(var_args){
var args41864 = [];
var len__5627__auto___41931 = arguments.length;
var i__5628__auto___41932 = (0);
while(true){
if((i__5628__auto___41932 < len__5627__auto___41931)){
args41864.push((arguments[i__5628__auto___41932]));

var G__41933 = (i__5628__auto___41932 + (1));
i__5628__auto___41932 = G__41933;
continue;
} else {
}
break;
}

var G__41866 = args41864.length;
switch (G__41866) {
case 1:
return sablono.core.color_field41863.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field41863.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41864.length)].join('')));

}
});

sablono.core.color_field41863.cljs$core$IFn$_invoke$arity$1 = (function (name__12398__auto__){
return sablono.core.color_field41863.cljs$core$IFn$_invoke$arity$2(name__12398__auto__,null);
});

sablono.core.color_field41863.cljs$core$IFn$_invoke$arity$2 = (function (name__12398__auto__,value__12399__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$color)].join(''),name__12398__auto__,value__12399__auto__);
});

sablono.core.color_field41863.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs(sablono.core.color_field41863);

/**
 * Creates a date input field.
 */
sablono.core.date_field41867 = (function sablono$core$date_field41867(var_args){
var args41868 = [];
var len__5627__auto___41935 = arguments.length;
var i__5628__auto___41936 = (0);
while(true){
if((i__5628__auto___41936 < len__5627__auto___41935)){
args41868.push((arguments[i__5628__auto___41936]));

var G__41937 = (i__5628__auto___41936 + (1));
i__5628__auto___41936 = G__41937;
continue;
} else {
}
break;
}

var G__41870 = args41868.length;
switch (G__41870) {
case 1:
return sablono.core.date_field41867.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field41867.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41868.length)].join('')));

}
});

sablono.core.date_field41867.cljs$core$IFn$_invoke$arity$1 = (function (name__12398__auto__){
return sablono.core.date_field41867.cljs$core$IFn$_invoke$arity$2(name__12398__auto__,null);
});

sablono.core.date_field41867.cljs$core$IFn$_invoke$arity$2 = (function (name__12398__auto__,value__12399__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$date)].join(''),name__12398__auto__,value__12399__auto__);
});

sablono.core.date_field41867.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs(sablono.core.date_field41867);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field41871 = (function sablono$core$datetime_field41871(var_args){
var args41872 = [];
var len__5627__auto___41939 = arguments.length;
var i__5628__auto___41940 = (0);
while(true){
if((i__5628__auto___41940 < len__5627__auto___41939)){
args41872.push((arguments[i__5628__auto___41940]));

var G__41941 = (i__5628__auto___41940 + (1));
i__5628__auto___41940 = G__41941;
continue;
} else {
}
break;
}

var G__41874 = args41872.length;
switch (G__41874) {
case 1:
return sablono.core.datetime_field41871.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field41871.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41872.length)].join('')));

}
});

sablono.core.datetime_field41871.cljs$core$IFn$_invoke$arity$1 = (function (name__12398__auto__){
return sablono.core.datetime_field41871.cljs$core$IFn$_invoke$arity$2(name__12398__auto__,null);
});

sablono.core.datetime_field41871.cljs$core$IFn$_invoke$arity$2 = (function (name__12398__auto__,value__12399__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime)].join(''),name__12398__auto__,value__12399__auto__);
});

sablono.core.datetime_field41871.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs(sablono.core.datetime_field41871);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field41875 = (function sablono$core$datetime_local_field41875(var_args){
var args41876 = [];
var len__5627__auto___41943 = arguments.length;
var i__5628__auto___41944 = (0);
while(true){
if((i__5628__auto___41944 < len__5627__auto___41943)){
args41876.push((arguments[i__5628__auto___41944]));

var G__41945 = (i__5628__auto___41944 + (1));
i__5628__auto___41944 = G__41945;
continue;
} else {
}
break;
}

var G__41878 = args41876.length;
switch (G__41878) {
case 1:
return sablono.core.datetime_local_field41875.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field41875.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41876.length)].join('')));

}
});

sablono.core.datetime_local_field41875.cljs$core$IFn$_invoke$arity$1 = (function (name__12398__auto__){
return sablono.core.datetime_local_field41875.cljs$core$IFn$_invoke$arity$2(name__12398__auto__,null);
});

sablono.core.datetime_local_field41875.cljs$core$IFn$_invoke$arity$2 = (function (name__12398__auto__,value__12399__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime_DASH_local)].join(''),name__12398__auto__,value__12399__auto__);
});

sablono.core.datetime_local_field41875.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs(sablono.core.datetime_local_field41875);

/**
 * Creates a email input field.
 */
sablono.core.email_field41879 = (function sablono$core$email_field41879(var_args){
var args41880 = [];
var len__5627__auto___41947 = arguments.length;
var i__5628__auto___41948 = (0);
while(true){
if((i__5628__auto___41948 < len__5627__auto___41947)){
args41880.push((arguments[i__5628__auto___41948]));

var G__41949 = (i__5628__auto___41948 + (1));
i__5628__auto___41948 = G__41949;
continue;
} else {
}
break;
}

var G__41882 = args41880.length;
switch (G__41882) {
case 1:
return sablono.core.email_field41879.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field41879.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41880.length)].join('')));

}
});

sablono.core.email_field41879.cljs$core$IFn$_invoke$arity$1 = (function (name__12398__auto__){
return sablono.core.email_field41879.cljs$core$IFn$_invoke$arity$2(name__12398__auto__,null);
});

sablono.core.email_field41879.cljs$core$IFn$_invoke$arity$2 = (function (name__12398__auto__,value__12399__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$email)].join(''),name__12398__auto__,value__12399__auto__);
});

sablono.core.email_field41879.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs(sablono.core.email_field41879);

/**
 * Creates a file input field.
 */
sablono.core.file_field41883 = (function sablono$core$file_field41883(var_args){
var args41884 = [];
var len__5627__auto___41951 = arguments.length;
var i__5628__auto___41952 = (0);
while(true){
if((i__5628__auto___41952 < len__5627__auto___41951)){
args41884.push((arguments[i__5628__auto___41952]));

var G__41953 = (i__5628__auto___41952 + (1));
i__5628__auto___41952 = G__41953;
continue;
} else {
}
break;
}

var G__41886 = args41884.length;
switch (G__41886) {
case 1:
return sablono.core.file_field41883.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field41883.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41884.length)].join('')));

}
});

sablono.core.file_field41883.cljs$core$IFn$_invoke$arity$1 = (function (name__12398__auto__){
return sablono.core.file_field41883.cljs$core$IFn$_invoke$arity$2(name__12398__auto__,null);
});

sablono.core.file_field41883.cljs$core$IFn$_invoke$arity$2 = (function (name__12398__auto__,value__12399__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$file)].join(''),name__12398__auto__,value__12399__auto__);
});

sablono.core.file_field41883.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs(sablono.core.file_field41883);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field41887 = (function sablono$core$hidden_field41887(var_args){
var args41888 = [];
var len__5627__auto___41955 = arguments.length;
var i__5628__auto___41956 = (0);
while(true){
if((i__5628__auto___41956 < len__5627__auto___41955)){
args41888.push((arguments[i__5628__auto___41956]));

var G__41957 = (i__5628__auto___41956 + (1));
i__5628__auto___41956 = G__41957;
continue;
} else {
}
break;
}

var G__41890 = args41888.length;
switch (G__41890) {
case 1:
return sablono.core.hidden_field41887.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field41887.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41888.length)].join('')));

}
});

sablono.core.hidden_field41887.cljs$core$IFn$_invoke$arity$1 = (function (name__12398__auto__){
return sablono.core.hidden_field41887.cljs$core$IFn$_invoke$arity$2(name__12398__auto__,null);
});

sablono.core.hidden_field41887.cljs$core$IFn$_invoke$arity$2 = (function (name__12398__auto__,value__12399__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$hidden)].join(''),name__12398__auto__,value__12399__auto__);
});

sablono.core.hidden_field41887.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs(sablono.core.hidden_field41887);

/**
 * Creates a month input field.
 */
sablono.core.month_field41891 = (function sablono$core$month_field41891(var_args){
var args41892 = [];
var len__5627__auto___41959 = arguments.length;
var i__5628__auto___41960 = (0);
while(true){
if((i__5628__auto___41960 < len__5627__auto___41959)){
args41892.push((arguments[i__5628__auto___41960]));

var G__41961 = (i__5628__auto___41960 + (1));
i__5628__auto___41960 = G__41961;
continue;
} else {
}
break;
}

var G__41894 = args41892.length;
switch (G__41894) {
case 1:
return sablono.core.month_field41891.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field41891.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41892.length)].join('')));

}
});

sablono.core.month_field41891.cljs$core$IFn$_invoke$arity$1 = (function (name__12398__auto__){
return sablono.core.month_field41891.cljs$core$IFn$_invoke$arity$2(name__12398__auto__,null);
});

sablono.core.month_field41891.cljs$core$IFn$_invoke$arity$2 = (function (name__12398__auto__,value__12399__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$month)].join(''),name__12398__auto__,value__12399__auto__);
});

sablono.core.month_field41891.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs(sablono.core.month_field41891);

/**
 * Creates a number input field.
 */
sablono.core.number_field41895 = (function sablono$core$number_field41895(var_args){
var args41896 = [];
var len__5627__auto___41963 = arguments.length;
var i__5628__auto___41964 = (0);
while(true){
if((i__5628__auto___41964 < len__5627__auto___41963)){
args41896.push((arguments[i__5628__auto___41964]));

var G__41965 = (i__5628__auto___41964 + (1));
i__5628__auto___41964 = G__41965;
continue;
} else {
}
break;
}

var G__41898 = args41896.length;
switch (G__41898) {
case 1:
return sablono.core.number_field41895.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field41895.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41896.length)].join('')));

}
});

sablono.core.number_field41895.cljs$core$IFn$_invoke$arity$1 = (function (name__12398__auto__){
return sablono.core.number_field41895.cljs$core$IFn$_invoke$arity$2(name__12398__auto__,null);
});

sablono.core.number_field41895.cljs$core$IFn$_invoke$arity$2 = (function (name__12398__auto__,value__12399__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$number)].join(''),name__12398__auto__,value__12399__auto__);
});

sablono.core.number_field41895.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs(sablono.core.number_field41895);

/**
 * Creates a password input field.
 */
sablono.core.password_field41899 = (function sablono$core$password_field41899(var_args){
var args41900 = [];
var len__5627__auto___41967 = arguments.length;
var i__5628__auto___41968 = (0);
while(true){
if((i__5628__auto___41968 < len__5627__auto___41967)){
args41900.push((arguments[i__5628__auto___41968]));

var G__41969 = (i__5628__auto___41968 + (1));
i__5628__auto___41968 = G__41969;
continue;
} else {
}
break;
}

var G__41902 = args41900.length;
switch (G__41902) {
case 1:
return sablono.core.password_field41899.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field41899.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41900.length)].join('')));

}
});

sablono.core.password_field41899.cljs$core$IFn$_invoke$arity$1 = (function (name__12398__auto__){
return sablono.core.password_field41899.cljs$core$IFn$_invoke$arity$2(name__12398__auto__,null);
});

sablono.core.password_field41899.cljs$core$IFn$_invoke$arity$2 = (function (name__12398__auto__,value__12399__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$password)].join(''),name__12398__auto__,value__12399__auto__);
});

sablono.core.password_field41899.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs(sablono.core.password_field41899);

/**
 * Creates a range input field.
 */
sablono.core.range_field41903 = (function sablono$core$range_field41903(var_args){
var args41904 = [];
var len__5627__auto___41971 = arguments.length;
var i__5628__auto___41972 = (0);
while(true){
if((i__5628__auto___41972 < len__5627__auto___41971)){
args41904.push((arguments[i__5628__auto___41972]));

var G__41973 = (i__5628__auto___41972 + (1));
i__5628__auto___41972 = G__41973;
continue;
} else {
}
break;
}

var G__41906 = args41904.length;
switch (G__41906) {
case 1:
return sablono.core.range_field41903.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field41903.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41904.length)].join('')));

}
});

sablono.core.range_field41903.cljs$core$IFn$_invoke$arity$1 = (function (name__12398__auto__){
return sablono.core.range_field41903.cljs$core$IFn$_invoke$arity$2(name__12398__auto__,null);
});

sablono.core.range_field41903.cljs$core$IFn$_invoke$arity$2 = (function (name__12398__auto__,value__12399__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$range)].join(''),name__12398__auto__,value__12399__auto__);
});

sablono.core.range_field41903.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs(sablono.core.range_field41903);

/**
 * Creates a search input field.
 */
sablono.core.search_field41907 = (function sablono$core$search_field41907(var_args){
var args41908 = [];
var len__5627__auto___41975 = arguments.length;
var i__5628__auto___41976 = (0);
while(true){
if((i__5628__auto___41976 < len__5627__auto___41975)){
args41908.push((arguments[i__5628__auto___41976]));

var G__41977 = (i__5628__auto___41976 + (1));
i__5628__auto___41976 = G__41977;
continue;
} else {
}
break;
}

var G__41910 = args41908.length;
switch (G__41910) {
case 1:
return sablono.core.search_field41907.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field41907.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41908.length)].join('')));

}
});

sablono.core.search_field41907.cljs$core$IFn$_invoke$arity$1 = (function (name__12398__auto__){
return sablono.core.search_field41907.cljs$core$IFn$_invoke$arity$2(name__12398__auto__,null);
});

sablono.core.search_field41907.cljs$core$IFn$_invoke$arity$2 = (function (name__12398__auto__,value__12399__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$search)].join(''),name__12398__auto__,value__12399__auto__);
});

sablono.core.search_field41907.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs(sablono.core.search_field41907);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field41911 = (function sablono$core$tel_field41911(var_args){
var args41912 = [];
var len__5627__auto___41979 = arguments.length;
var i__5628__auto___41980 = (0);
while(true){
if((i__5628__auto___41980 < len__5627__auto___41979)){
args41912.push((arguments[i__5628__auto___41980]));

var G__41981 = (i__5628__auto___41980 + (1));
i__5628__auto___41980 = G__41981;
continue;
} else {
}
break;
}

var G__41914 = args41912.length;
switch (G__41914) {
case 1:
return sablono.core.tel_field41911.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field41911.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41912.length)].join('')));

}
});

sablono.core.tel_field41911.cljs$core$IFn$_invoke$arity$1 = (function (name__12398__auto__){
return sablono.core.tel_field41911.cljs$core$IFn$_invoke$arity$2(name__12398__auto__,null);
});

sablono.core.tel_field41911.cljs$core$IFn$_invoke$arity$2 = (function (name__12398__auto__,value__12399__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$tel)].join(''),name__12398__auto__,value__12399__auto__);
});

sablono.core.tel_field41911.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs(sablono.core.tel_field41911);

/**
 * Creates a text input field.
 */
sablono.core.text_field41915 = (function sablono$core$text_field41915(var_args){
var args41916 = [];
var len__5627__auto___41983 = arguments.length;
var i__5628__auto___41984 = (0);
while(true){
if((i__5628__auto___41984 < len__5627__auto___41983)){
args41916.push((arguments[i__5628__auto___41984]));

var G__41985 = (i__5628__auto___41984 + (1));
i__5628__auto___41984 = G__41985;
continue;
} else {
}
break;
}

var G__41918 = args41916.length;
switch (G__41918) {
case 1:
return sablono.core.text_field41915.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field41915.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41916.length)].join('')));

}
});

sablono.core.text_field41915.cljs$core$IFn$_invoke$arity$1 = (function (name__12398__auto__){
return sablono.core.text_field41915.cljs$core$IFn$_invoke$arity$2(name__12398__auto__,null);
});

sablono.core.text_field41915.cljs$core$IFn$_invoke$arity$2 = (function (name__12398__auto__,value__12399__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$text)].join(''),name__12398__auto__,value__12399__auto__);
});

sablono.core.text_field41915.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs(sablono.core.text_field41915);

/**
 * Creates a time input field.
 */
sablono.core.time_field41919 = (function sablono$core$time_field41919(var_args){
var args41920 = [];
var len__5627__auto___41987 = arguments.length;
var i__5628__auto___41988 = (0);
while(true){
if((i__5628__auto___41988 < len__5627__auto___41987)){
args41920.push((arguments[i__5628__auto___41988]));

var G__41989 = (i__5628__auto___41988 + (1));
i__5628__auto___41988 = G__41989;
continue;
} else {
}
break;
}

var G__41922 = args41920.length;
switch (G__41922) {
case 1:
return sablono.core.time_field41919.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field41919.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41920.length)].join('')));

}
});

sablono.core.time_field41919.cljs$core$IFn$_invoke$arity$1 = (function (name__12398__auto__){
return sablono.core.time_field41919.cljs$core$IFn$_invoke$arity$2(name__12398__auto__,null);
});

sablono.core.time_field41919.cljs$core$IFn$_invoke$arity$2 = (function (name__12398__auto__,value__12399__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$time)].join(''),name__12398__auto__,value__12399__auto__);
});

sablono.core.time_field41919.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs(sablono.core.time_field41919);

/**
 * Creates a url input field.
 */
sablono.core.url_field41923 = (function sablono$core$url_field41923(var_args){
var args41924 = [];
var len__5627__auto___41991 = arguments.length;
var i__5628__auto___41992 = (0);
while(true){
if((i__5628__auto___41992 < len__5627__auto___41991)){
args41924.push((arguments[i__5628__auto___41992]));

var G__41993 = (i__5628__auto___41992 + (1));
i__5628__auto___41992 = G__41993;
continue;
} else {
}
break;
}

var G__41926 = args41924.length;
switch (G__41926) {
case 1:
return sablono.core.url_field41923.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field41923.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41924.length)].join('')));

}
});

sablono.core.url_field41923.cljs$core$IFn$_invoke$arity$1 = (function (name__12398__auto__){
return sablono.core.url_field41923.cljs$core$IFn$_invoke$arity$2(name__12398__auto__,null);
});

sablono.core.url_field41923.cljs$core$IFn$_invoke$arity$2 = (function (name__12398__auto__,value__12399__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$url)].join(''),name__12398__auto__,value__12399__auto__);
});

sablono.core.url_field41923.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs(sablono.core.url_field41923);

/**
 * Creates a week input field.
 */
sablono.core.week_field41927 = (function sablono$core$week_field41927(var_args){
var args41928 = [];
var len__5627__auto___41995 = arguments.length;
var i__5628__auto___41996 = (0);
while(true){
if((i__5628__auto___41996 < len__5627__auto___41995)){
args41928.push((arguments[i__5628__auto___41996]));

var G__41997 = (i__5628__auto___41996 + (1));
i__5628__auto___41996 = G__41997;
continue;
} else {
}
break;
}

var G__41930 = args41928.length;
switch (G__41930) {
case 1:
return sablono.core.week_field41927.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field41927.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41928.length)].join('')));

}
});

sablono.core.week_field41927.cljs$core$IFn$_invoke$arity$1 = (function (name__12398__auto__){
return sablono.core.week_field41927.cljs$core$IFn$_invoke$arity$2(name__12398__auto__,null);
});

sablono.core.week_field41927.cljs$core$IFn$_invoke$arity$2 = (function (name__12398__auto__,value__12399__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$week)].join(''),name__12398__auto__,value__12399__auto__);
});

sablono.core.week_field41927.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs(sablono.core.week_field41927);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box41999 = (function sablono$core$check_box41999(var_args){
var args42000 = [];
var len__5627__auto___42003 = arguments.length;
var i__5628__auto___42004 = (0);
while(true){
if((i__5628__auto___42004 < len__5627__auto___42003)){
args42000.push((arguments[i__5628__auto___42004]));

var G__42005 = (i__5628__auto___42004 + (1));
i__5628__auto___42004 = G__42005;
continue;
} else {
}
break;
}

var G__42002 = args42000.length;
switch (G__42002) {
case 1:
return sablono.core.check_box41999.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box41999.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box41999.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42000.length)].join('')));

}
});

sablono.core.check_box41999.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box41999.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.check_box41999.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box41999.cljs$core$IFn$_invoke$arity$3(name,checked_QMARK_,"true");
});

sablono.core.check_box41999.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"checkbox",cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.check_box41999.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs(sablono.core.check_box41999);
/**
 * Creates a radio button.
 */
sablono.core.radio_button42007 = (function sablono$core$radio_button42007(var_args){
var args42008 = [];
var len__5627__auto___42011 = arguments.length;
var i__5628__auto___42012 = (0);
while(true){
if((i__5628__auto___42012 < len__5627__auto___42011)){
args42008.push((arguments[i__5628__auto___42012]));

var G__42013 = (i__5628__auto___42012 + (1));
i__5628__auto___42012 = G__42013;
continue;
} else {
}
break;
}

var G__42010 = args42008.length;
switch (G__42010) {
case 1:
return sablono.core.radio_button42007.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button42007.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button42007.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42008.length)].join('')));

}
});

sablono.core.radio_button42007.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button42007.cljs$core$IFn$_invoke$arity$2(group,null);
});

sablono.core.radio_button42007.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button42007.cljs$core$IFn$_invoke$arity$3(group,checked_QMARK_,"true");
});

sablono.core.radio_button42007.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"radio",cljs.core.cst$kw$name,sablono.core.make_name(group),cljs.core.cst$kw$id,sablono.core.make_id([cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([group], 0))),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([value], 0)))].join('')),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.radio_button42007.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs(sablono.core.radio_button42007);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options42015 = (function sablono$core$select_options42015(var_args){
var args42016 = [];
var len__5627__auto___42029 = arguments.length;
var i__5628__auto___42030 = (0);
while(true){
if((i__5628__auto___42030 < len__5627__auto___42029)){
args42016.push((arguments[i__5628__auto___42030]));

var G__42031 = (i__5628__auto___42030 + (1));
i__5628__auto___42030 = G__42031;
continue;
} else {
}
break;
}

var G__42018 = args42016.length;
switch (G__42018) {
case 1:
return sablono.core.select_options42015.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options42015.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42016.length)].join('')));

}
});

sablono.core.select_options42015.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options42015.cljs$core$IFn$_invoke$arity$2(coll,null);
});

sablono.core.select_options42015.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__5341__auto__ = (function sablono$core$iter__42019(s__42020){
return (new cljs.core.LazySeq(null,(function (){
var s__42020__$1 = s__42020;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__42020__$1);
if(temp__4425__auto__){
var s__42020__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__42020__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__42020__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__42022 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__42021 = (0);
while(true){
if((i__42021 < size__5340__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__42021);
cljs.core.chunk_append(b__42022,((cljs.core.sequential_QMARK_(x))?(function (){var vec__42027 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42027,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42027,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42027,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options42015.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)));

var G__42033 = (i__42021 + (1));
i__42021 = G__42033;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__42022),sablono$core$iter__42019(cljs.core.chunk_rest(s__42020__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__42022),null);
}
} else {
var x = cljs.core.first(s__42020__$2);
return cljs.core.cons(((cljs.core.sequential_QMARK_(x))?(function (){var vec__42028 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42028,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42028,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42028,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options42015.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)),sablono$core$iter__42019(cljs.core.rest(s__42020__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(coll);
});

sablono.core.select_options42015.cljs$lang$maxFixedArity = 2;

sablono.core.select_options = sablono.core.wrap_attrs(sablono.core.select_options42015);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down42034 = (function sablono$core$drop_down42034(var_args){
var args42035 = [];
var len__5627__auto___42038 = arguments.length;
var i__5628__auto___42039 = (0);
while(true){
if((i__5628__auto___42039 < len__5627__auto___42038)){
args42035.push((arguments[i__5628__auto___42039]));

var G__42040 = (i__5628__auto___42039 + (1));
i__5628__auto___42039 = G__42040;
continue;
} else {
}
break;
}

var G__42037 = args42035.length;
switch (G__42037) {
case 2:
return sablono.core.drop_down42034.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down42034.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42035.length)].join('')));

}
});

sablono.core.drop_down42034.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down42034.cljs$core$IFn$_invoke$arity$3(name,options,null);
});

sablono.core.drop_down42034.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name)], null),(sablono.core.select_options.cljs$core$IFn$_invoke$arity$2 ? sablono.core.select_options.cljs$core$IFn$_invoke$arity$2(options,selected) : sablono.core.select_options.call(null,options,selected))], null);
});

sablono.core.drop_down42034.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs(sablono.core.drop_down42034);
/**
 * Creates a text area element.
 */
sablono.core.text_area42042 = (function sablono$core$text_area42042(var_args){
var args42043 = [];
var len__5627__auto___42046 = arguments.length;
var i__5628__auto___42047 = (0);
while(true){
if((i__5628__auto___42047 < len__5627__auto___42046)){
args42043.push((arguments[i__5628__auto___42047]));

var G__42048 = (i__5628__auto___42047 + (1));
i__5628__auto___42047 = G__42048;
continue;
} else {
}
break;
}

var G__42045 = args42043.length;
switch (G__42045) {
case 1:
return sablono.core.text_area42042.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area42042.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42043.length)].join('')));

}
});

sablono.core.text_area42042.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area42042.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.text_area42042.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$textarea,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});

sablono.core.text_area42042.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs(sablono.core.text_area42042);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label42050 = (function sablono$core$label42050(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$htmlFor,sablono.core.make_id(name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs(sablono.core.label42050);
/**
 * Creates a submit button.
 */
sablono.core.submit_button42051 = (function sablono$core$submit_button42051(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"submit",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs(sablono.core.submit_button42051);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button42052 = (function sablono$core$reset_button42052(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"reset",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs(sablono.core.reset_button42052);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to42053 = (function sablono$core$form_to42053(var_args){
var args__5634__auto__ = [];
var len__5627__auto___42058 = arguments.length;
var i__5628__auto___42059 = (0);
while(true){
if((i__5628__auto___42059 < len__5627__auto___42058)){
args__5634__auto__.push((arguments[i__5628__auto___42059]));

var G__42060 = (i__5628__auto___42059 + (1));
i__5628__auto___42059 = G__42060;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.form_to42053.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.form_to42053.cljs$core$IFn$_invoke$arity$variadic = (function (p__42056,body){
var vec__42057 = p__42056;
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42057,(0),null);
var action = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42057,(1),null);
var method_str = clojure.string.upper_case(cljs.core.name(method));
var action_uri = sablono.util.to_uri(action);
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$get,null,cljs.core.cst$kw$post,null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,method_str,cljs.core.cst$kw$action,action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,"POST",cljs.core.cst$kw$action,action_uri], null),(sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2 ? sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2("_method",method_str) : sablono.core.hidden_field.call(null,"_method",method_str))], null)),body));
});

sablono.core.form_to42053.cljs$lang$maxFixedArity = (1);

sablono.core.form_to42053.cljs$lang$applyTo = (function (seq42054){
var G__42055 = cljs.core.first(seq42054);
var seq42054__$1 = cljs.core.next(seq42054);
return sablono.core.form_to42053.cljs$core$IFn$_invoke$arity$variadic(G__42055,seq42054__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs(sablono.core.form_to42053);
