// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.utils.om.state');
goog.require('cljs.core');
goog.require('om.core');
/**
 * A transact! function that optionally uses swap! if this atom is not yet
 * transactable?
 */
hatti.utils.om.state.transact_BANG_ = (function hatti$utils$om$state$transact_BANG_(app_state){
if(((!((app_state == null)))?(((false) || (app_state.om$core$ITransact$))?true:(((!app_state.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(om.core.ITransact,app_state):false)):cljs.core.native_satisfies_QMARK_(om.core.ITransact,app_state))){
return om.core.transact_BANG_;
} else {
return cljs.core.swap_BANG_;
}
});
/**
 * Like om/transact! but also works on atoms that are not transactable?
 */
hatti.utils.om.state.transact_app_state_BANG_ = (function hatti$utils$om$state$transact_app_state_BANG_(var_args){
var args30180 = [];
var len__5627__auto___30183 = arguments.length;
var i__5628__auto___30184 = (0);
while(true){
if((i__5628__auto___30184 < len__5627__auto___30183)){
args30180.push((arguments[i__5628__auto___30184]));

var G__30185 = (i__5628__auto___30184 + (1));
i__5628__auto___30184 = G__30185;
continue;
} else {
}
break;
}

var G__30182 = args30180.length;
switch (G__30182) {
case 2:
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30180.length)].join('')));

}
});

hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (app_state,transact_fn){
return hatti.utils.om.state.transact_BANG_(app_state).call(null,app_state,transact_fn);
});

hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (app_state,ks,transact_fn){
return hatti.utils.om.state.transact_BANG_(app_state).call(null,app_state,(function (p1__30179_SHARP_){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(p1__30179_SHARP_,ks,transact_fn);
}));
});

hatti.utils.om.state.transact_app_state_BANG_.cljs$lang$maxFixedArity = 3;
/**
 * Like om/update! but also works on atoms that are not transactable?
 */
hatti.utils.om.state.update_app_state_BANG_ = (function hatti$utils$om$state$update_app_state_BANG_(var_args){
var args30187 = [];
var len__5627__auto___30190 = arguments.length;
var i__5628__auto___30191 = (0);
while(true){
if((i__5628__auto___30191 < len__5627__auto___30190)){
args30187.push((arguments[i__5628__auto___30191]));

var G__30192 = (i__5628__auto___30191 + (1));
i__5628__auto___30191 = G__30192;
continue;
} else {
}
break;
}

var G__30189 = args30187.length;
switch (G__30189) {
case 2:
return hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30187.length)].join('')));

}
});

hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (app_state,update_val){
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$2(app_state,(function (){
return update_val;
}));
});

hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (app_state,ks,update_val){
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,ks,(function (){
return update_val;
}));
});

hatti.utils.om.state.update_app_state_BANG_.cljs$lang$maxFixedArity = 3;
/**
 * Merges provided state into existing app-state, possibly after zoomint into
 * ks.
 */
hatti.utils.om.state.merge_into_app_state_BANG_ = (function hatti$utils$om$state$merge_into_app_state_BANG_(var_args){
var args30196 = [];
var len__5627__auto___30199 = arguments.length;
var i__5628__auto___30200 = (0);
while(true){
if((i__5628__auto___30200 < len__5627__auto___30199)){
args30196.push((arguments[i__5628__auto___30200]));

var G__30201 = (i__5628__auto___30200 + (1));
i__5628__auto___30200 = G__30201;
continue;
} else {
}
break;
}

var G__30198 = args30196.length;
switch (G__30198) {
case 2:
return hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30196.length)].join('')));

}
});

hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (app_state,state_to_merge){
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$2(app_state,(function (p1__30194_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__30194_SHARP_,state_to_merge], 0));
}));
});

hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (app_state,ks,state_to_merge){
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,ks,(function (p1__30195_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__30195_SHARP_,state_to_merge], 0));
}));
});

hatti.utils.om.state.merge_into_app_state_BANG_.cljs$lang$maxFixedArity = 3;
