// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.shared');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('sablono.core');
goog.require('hatti.utils.om.state');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('om.core');
goog.require('hatti.utils');
hatti.shared.event_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
hatti.shared.event_multi_chan = cljs.core.async.mult(hatti.shared.event_chan);
hatti.shared.event_tap = (function hatti$shared$event_tap(){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_multi_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
});
hatti.shared.external_event_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
hatti.shared.external_event_multi_chan = cljs.core.async.mult(hatti.shared.external_event_chan);
hatti.shared.external_event_tap = (function hatti$shared$external_event_tap(){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2(hatti.shared.external_event_multi_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
});
hatti.shared.default_fields = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,"_submission_time",cljs.core.cst$kw$label,"Submission Time",cljs.core.cst$kw$name,"_submission_time",cljs.core.cst$kw$type,"datetime"], null)], null);
/**
 * An initial, empty, app-state, which can be modified to change dataviews.
 */
hatti.shared.empty_app_state = (function hatti$shared$empty_app_state(){
var G__30435 = new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$views,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$all,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$overview,cljs.core.cst$kw$map,cljs.core.cst$kw$table,cljs.core.cst$kw$chart,cljs.core.cst$kw$settings], null),cljs.core.cst$kw$selected,cljs.core.cst$kw$overview], null),cljs.core.cst$kw$map_DASH_page,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$submission_DASH_clicked,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,null], null),cljs.core.cst$kw$geofield,cljs.core.PersistentArrayMap.EMPTY], null),cljs.core.cst$kw$table_DASH_page,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_clicked,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,null], null)], null),cljs.core.cst$kw$chart_DASH_page,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$visible_DASH_charts,hatti.shared.default_fields,cljs.core.cst$kw$chart_DASH_data,cljs.core.PersistentArrayMap.EMPTY], null),cljs.core.cst$kw$dataset_DASH_info,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$data,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$status,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$total_DASH_records,(0),cljs.core.cst$kw$loading_QMARK_,true], null),cljs.core.cst$kw$languages,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$current,null,cljs.core.cst$kw$all,cljs.core.PersistentVector.EMPTY], null)], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30435) : cljs.core.atom.call(null,G__30435));
});
hatti.shared.app_state = hatti.shared.empty_app_state();
/**
 * Given a function over data, run a transact on data inside app-state.
 */
hatti.shared.transact_app_data_BANG_ = (function hatti$shared$transact_app_data_BANG_(app_state,transact_fn){
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null),transact_fn);
});
/**
 * Given `data` received from the server, update the app-state.
 * Sorts by submission time, and adds rank to the data, for table + map views.
 */
hatti.shared.update_app_data_BANG_ = (function hatti$shared$update_app_data_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___30443 = arguments.length;
var i__5628__auto___30444 = (0);
while(true){
if((i__5628__auto___30444 < len__5627__auto___30443)){
args__5634__auto__.push((arguments[i__5628__auto___30444]));

var G__30445 = (i__5628__auto___30444 + (1));
i__5628__auto___30444 = G__30445;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,data,p__30440){
var map__30441 = p__30440;
var map__30441__$1 = ((((!((map__30441 == null)))?((((map__30441.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30441.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30441):map__30441);
var rerank_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30441__$1,cljs.core.cst$kw$rerank_QMARK_);
var completed_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30441__$1,cljs.core.cst$kw$completed_QMARK_);
var sort_field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30441__$1,cljs.core.cst$kw$sort_DASH_field);
var current_start_index = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__30441__$1,cljs.core.cst$kw$current_DASH_start_DASH_index,(0));
var add_rank = ((function (map__30441,map__30441__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (i,v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,hatti.constants._rank,(current_start_index + (i + (1))));
});})(map__30441,map__30441__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
;
var data__$1 = (cljs.core.truth_((function (){var and__4557__auto__ = rerank_QMARK_;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.seq(data);
} else {
return and__4557__auto__;
}
})())?cljs.core.vec(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(add_rank,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(((function (add_rank,map__30441,map__30441__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (p1__30436_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__30436_SHARP_,(function (){var or__4569__auto__ = sort_field;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.constants._submission_time;
}
})());
});})(add_rank,map__30441,map__30441__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
,data))):cljs.core.vec(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(add_rank,data)));
var total_records = cljs.core.count(data__$1);
hatti.shared.transact_app_data_BANG_(app_state,((function (add_rank,data__$1,total_records,map__30441,map__30441__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (_){
return data__$1;
});})(add_rank,data__$1,total_records,map__30441,map__30441__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
);

return hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$status], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$total_DASH_records,total_records,cljs.core.cst$kw$loading_QMARK_,cljs.core.not(completed_QMARK_)], null));
});

hatti.shared.update_app_data_BANG_.cljs$lang$maxFixedArity = (2);

hatti.shared.update_app_data_BANG_.cljs$lang$applyTo = (function (seq30437){
var G__30438 = cljs.core.first(seq30437);
var seq30437__$1 = cljs.core.next(seq30437);
var G__30439 = cljs.core.first(seq30437__$1);
var seq30437__$2 = cljs.core.next(seq30437__$1);
return hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30438,G__30439,seq30437__$2);
});
/**
 * Add to app data.
 */
hatti.shared.add_to_app_data_BANG_ = (function hatti$shared$add_to_app_data_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___30452 = arguments.length;
var i__5628__auto___30453 = (0);
while(true){
if((i__5628__auto___30453 < len__5627__auto___30452)){
args__5634__auto__.push((arguments[i__5628__auto___30453]));

var G__30454 = (i__5628__auto___30453 + (1));
i__5628__auto___30453 = G__30454;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,data,p__30449){
var map__30450 = p__30449;
var map__30450__$1 = ((((!((map__30450 == null)))?((((map__30450.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30450.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30450):map__30450);
var completed_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30450__$1,cljs.core.cst$kw$completed_QMARK_);
var old_data = cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)));
hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(app_state,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(old_data,data),cljs.core.array_seq([cljs.core.cst$kw$rerank_QMARK_,completed_QMARK_], 0));

return hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$status,cljs.core.cst$kw$loading_QMARK_], null),cljs.core.not(completed_QMARK_));
});

hatti.shared.add_to_app_data_BANG_.cljs$lang$maxFixedArity = (2);

hatti.shared.add_to_app_data_BANG_.cljs$lang$applyTo = (function (seq30446){
var G__30447 = cljs.core.first(seq30446);
var seq30446__$1 = cljs.core.next(seq30446);
var G__30448 = cljs.core.first(seq30446__$1);
var seq30446__$2 = cljs.core.next(seq30446__$1);
return hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30447,G__30448,seq30446__$2);
});
hatti.shared.language_cursor = (function hatti$shared$language_cursor(){
return om.core.ref_cursor(cljs.core.cst$kw$languages.cljs$core$IFn$_invoke$arity$1(om.core.root_cursor(hatti.shared.app_state)));
});
/**
 * A language selector and a following divider.
 */
hatti.shared.language_selector = (function hatti$shared$language_selector(_,owner){
if(typeof hatti.shared.t_hatti$shared30512 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.shared.t_hatti$shared30512 = (function (language_selector,_,owner,meta30513){
this.language_selector = language_selector;
this._ = _;
this.owner = owner;
this.meta30513 = meta30513;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.shared.t_hatti$shared30512.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30514,meta30513__$1){
var self__ = this;
var _30514__$1 = this;
return (new hatti.shared.t_hatti$shared30512(self__.language_selector,self__._,self__.owner,meta30513__$1));
});

hatti.shared.t_hatti$shared30512.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30514){
var self__ = this;
var _30514__$1 = this;
return self__.meta30513;
});

hatti.shared.t_hatti$shared30512.prototype.om$core$IRender$ = true;

hatti.shared.t_hatti$shared30512.prototype.om$core$IRender$render$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var map__30515 = om.core.observe(self__.owner,hatti.shared.language_cursor());
var map__30515__$1 = ((((!((map__30515 == null)))?((((map__30515.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30515.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30515):map__30515);
var ls = map__30515__$1;
var current = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30515__$1,cljs.core.cst$kw$current);
var all = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30515__$1,cljs.core.cst$kw$all);
var update_current = ((function (map__30515,map__30515__$1,ls,current,all,___$2){
return (function (p1__30455_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(ls,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$current], null),p1__30455_SHARP_);
});})(map__30515,map__30515__$1,ls,current,all,___$2))
;
var stringify = ((function (map__30515,map__30515__$1,ls,current,all,update_current,___$2){
return (function (p1__30456_SHARP_){
if((p1__30456_SHARP_ instanceof cljs.core.Keyword)){
return cljs.core.name(p1__30456_SHARP_);
} else {
return [cljs.core.str(p1__30456_SHARP_)].join('');
}
});})(map__30515,map__30515__$1,ls,current,all,update_current,___$2))
;
var G__30524 = {"className": "language-selector-inner"};
var G__30525 = (function (){var G__30527 = {"className": "dropdown drop-hover"};
var G__30528 = (function (){var G__30532 = {"style": {"marginRight": ".2em"}, "className": "fa fa-globe"};
return React.DOM.i(G__30532);
})();
var G__30529 = (function (){var attrs30519 = (cljs.core.truth_(hatti.ona.forms.english_QMARK_(current))?"EN":stringify(current));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs30519))?sablono.interpreter.attributes(attrs30519):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs30519))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs30519)], null))));
})();
var G__30530 = (function (){var G__30533 = {"style": {"marginLeft": ".5em"}, "className": "fa fa-angle-down"};
return React.DOM.i(G__30533);
})();
var G__30531 = (function (){var G__30534 = {"className": "submenu"};
var G__30535 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((function (){var iter__5341__auto__ = ((function (G__30534,G__30527,G__30528,G__30529,G__30530,G__30524,map__30515,map__30515__$1,ls,current,all,update_current,stringify,___$2){
return (function hatti$shared$language_selector_$_iter__30536(s__30537){
return (new cljs.core.LazySeq(null,((function (G__30534,G__30527,G__30528,G__30529,G__30530,G__30524,map__30515,map__30515__$1,ls,current,all,update_current,stringify,___$2){
return (function (){
var s__30537__$1 = s__30537;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__30537__$1);
if(temp__4425__auto__){
var s__30537__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30537__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__30537__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__30539 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__30538 = (0);
while(true){
if((i__30538 < size__5340__auto__)){
var l = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__30538);
cljs.core.chunk_append(b__30539,(function (){var G__30556 = null;
var G__30557 = (function (){var G__30558 = {"href": "#", "onClick": ((function (i__30538,G__30556,l,c__5339__auto__,size__5340__auto__,b__30539,s__30537__$2,temp__4425__auto__,G__30534,G__30527,G__30528,G__30529,G__30530,G__30524,map__30515,map__30515__$1,ls,current,all,update_current,stringify,___$2){
return (function (){
return update_current(l);
});})(i__30538,G__30556,l,c__5339__auto__,size__5340__auto__,b__30539,s__30537__$2,temp__4425__auto__,G__30534,G__30527,G__30528,G__30529,G__30530,G__30524,map__30515,map__30515__$1,ls,current,all,update_current,stringify,___$2))
};
var G__30559 = sablono.interpreter.interpret(stringify(l));
return React.DOM.a(G__30558,G__30559);
})();
return React.DOM.li(G__30556,G__30557);
})());

var G__30567 = (i__30538 + (1));
i__30538 = G__30567;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30539),hatti$shared$language_selector_$_iter__30536(cljs.core.chunk_rest(s__30537__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30539),null);
}
} else {
var l = cljs.core.first(s__30537__$2);
return cljs.core.cons((function (){var G__30562 = null;
var G__30563 = (function (){var G__30564 = {"href": "#", "onClick": ((function (G__30562,l,s__30537__$2,temp__4425__auto__,G__30534,G__30527,G__30528,G__30529,G__30530,G__30524,map__30515,map__30515__$1,ls,current,all,update_current,stringify,___$2){
return (function (){
return update_current(l);
});})(G__30562,l,s__30537__$2,temp__4425__auto__,G__30534,G__30527,G__30528,G__30529,G__30530,G__30524,map__30515,map__30515__$1,ls,current,all,update_current,stringify,___$2))
};
var G__30565 = sablono.interpreter.interpret(stringify(l));
return React.DOM.a(G__30564,G__30565);
})();
return React.DOM.li(G__30562,G__30563);
})(),hatti$shared$language_selector_$_iter__30536(cljs.core.rest(s__30537__$2)));
}
} else {
return null;
}
break;
}
});})(G__30534,G__30527,G__30528,G__30529,G__30530,G__30524,map__30515,map__30515__$1,ls,current,all,update_current,stringify,___$2))
,null,null));
});})(G__30534,G__30527,G__30528,G__30529,G__30530,G__30524,map__30515,map__30515__$1,ls,current,all,update_current,stringify,___$2))
;
return iter__5341__auto__(all);
})());
return React.DOM.ul(G__30534,G__30535);
})();
return React.DOM.span(G__30527,G__30528,G__30529,G__30530,G__30531);
})();
var G__30526 = (function (){var G__30566 = {"className": "divider"};
return React.DOM.div(G__30566);
})();
return React.DOM.div(G__30524,G__30525,G__30526);
});

hatti.shared.t_hatti$shared30512.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$language_DASH_selector,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"A language selector and a following divider."], null)),cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta30513], null);
});

hatti.shared.t_hatti$shared30512.cljs$lang$type = true;

hatti.shared.t_hatti$shared30512.cljs$lang$ctorStr = "hatti.shared/t_hatti$shared30512";

hatti.shared.t_hatti$shared30512.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.shared/t_hatti$shared30512");
});

hatti.shared.__GT_t_hatti$shared30512 = (function hatti$shared$language_selector_$___GT_t_hatti$shared30512(language_selector__$1,___$1,owner__$1,meta30513){
return (new hatti.shared.t_hatti$shared30512(language_selector__$1,___$1,owner__$1,meta30513));
});

}

return (new hatti.shared.t_hatti$shared30512(hatti$shared$language_selector,_,owner,cljs.core.PersistentArrayMap.EMPTY));
});
