// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__8400__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8400__auto__){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto__){
return (function (state_30092){
var state_val_30093 = (state_30092[(1)]);
if((state_val_30093 === (7))){
var inst_30049 = (state_30092[(7)]);
var inst_30049__$1 = (state_30092[(2)]);
var inst_30051 = (inst_30049__$1 == null);
var inst_30052 = cljs.core.not(inst_30051);
var state_30092__$1 = (function (){var statearr_30094 = state_30092;
(statearr_30094[(7)] = inst_30049__$1);

return statearr_30094;
})();
if(inst_30052){
var statearr_30095_30132 = state_30092__$1;
(statearr_30095_30132[(1)] = (8));

} else {
var statearr_30096_30133 = state_30092__$1;
(statearr_30096_30133[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30093 === (20))){
var inst_30071 = (state_30092[(8)]);
var inst_30079 = (state_30092[(2)]);
var state_30092__$1 = (function (){var statearr_30097 = state_30092;
(statearr_30097[(9)] = inst_30079);

return statearr_30097;
})();
if(cljs.core.truth_(inst_30071)){
var statearr_30098_30134 = state_30092__$1;
(statearr_30098_30134[(1)] = (21));

} else {
var statearr_30099_30135 = state_30092__$1;
(statearr_30099_30135[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30093 === (1))){
var state_30092__$1 = state_30092;
var statearr_30100_30136 = state_30092__$1;
(statearr_30100_30136[(2)] = null);

(statearr_30100_30136[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30093 === (4))){
var state_30092__$1 = state_30092;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30092__$1,(7),agg_data_channel);
} else {
if((state_val_30093 === (15))){
var inst_30049 = (state_30092[(7)]);
var state_30092__$1 = state_30092;
var statearr_30101_30137 = state_30092__$1;
(statearr_30101_30137[(2)] = inst_30049);

(statearr_30101_30137[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30093 === (21))){
var inst_30081 = cljs.core.async.close_BANG_(agg_data_channel);
var state_30092__$1 = state_30092;
var statearr_30102_30138 = state_30092__$1;
(statearr_30102_30138[(2)] = inst_30081);

(statearr_30102_30138[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30093 === (13))){
var inst_30061 = (state_30092[(2)]);
var state_30092__$1 = state_30092;
var statearr_30103_30139 = state_30092__$1;
(statearr_30103_30139[(2)] = inst_30061);

(statearr_30103_30139[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30093 === (22))){
var state_30092__$1 = state_30092;
var statearr_30104_30140 = state_30092__$1;
(statearr_30104_30140[(2)] = null);

(statearr_30104_30140[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30093 === (6))){
var inst_30088 = (state_30092[(2)]);
var state_30092__$1 = state_30092;
var statearr_30105_30141 = state_30092__$1;
(statearr_30105_30141[(2)] = inst_30088);

(statearr_30105_30141[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30093 === (17))){
var inst_30071 = (state_30092[(8)]);
var inst_30070 = (state_30092[(10)]);
var inst_30073 = (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(inst_30070,inst_30071) : callback.call(null,inst_30070,inst_30071));
var state_30092__$1 = state_30092;
var statearr_30106_30142 = state_30092__$1;
(statearr_30106_30142[(2)] = inst_30073);

(statearr_30106_30142[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30093 === (3))){
var inst_30090 = (state_30092[(2)]);
var state_30092__$1 = state_30092;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30092__$1,inst_30090);
} else {
if((state_val_30093 === (12))){
var state_30092__$1 = state_30092;
var statearr_30107_30143 = state_30092__$1;
(statearr_30107_30143[(2)] = false);

(statearr_30107_30143[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30093 === (2))){
var state_30092__$1 = state_30092;
var statearr_30108_30144 = state_30092__$1;
(statearr_30108_30144[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_30093 === (23))){
var inst_30084 = (state_30092[(2)]);
var state_30092__$1 = (function (){var statearr_30110 = state_30092;
(statearr_30110[(11)] = inst_30084);

return statearr_30110;
})();
var statearr_30111_30145 = state_30092__$1;
(statearr_30111_30145[(2)] = null);

(statearr_30111_30145[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30093 === (19))){
var inst_30076 = (state_30092[(2)]);
var inst_30077 = cljs.core.async.timeout(hatti.ona.stream.small_delay);
var state_30092__$1 = (function (){var statearr_30112 = state_30092;
(statearr_30112[(12)] = inst_30076);

return statearr_30112;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30092__$1,(20),inst_30077);
} else {
if((state_val_30093 === (11))){
var state_30092__$1 = state_30092;
var statearr_30113_30146 = state_30092__$1;
(statearr_30113_30146[(2)] = true);

(statearr_30113_30146[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30093 === (9))){
var state_30092__$1 = state_30092;
var statearr_30114_30147 = state_30092__$1;
(statearr_30114_30147[(2)] = false);

(statearr_30114_30147[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30093 === (5))){
var state_30092__$1 = state_30092;
var statearr_30115_30148 = state_30092__$1;
(statearr_30115_30148[(2)] = null);

(statearr_30115_30148[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30093 === (14))){
var inst_30049 = (state_30092[(7)]);
var inst_30066 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_30049);
var state_30092__$1 = state_30092;
var statearr_30116_30149 = state_30092__$1;
(statearr_30116_30149[(2)] = inst_30066);

(statearr_30116_30149[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30093 === (16))){
var inst_30070 = (state_30092[(10)]);
var inst_30069 = (state_30092[(2)]);
var inst_30070__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30069,cljs.core.cst$kw$data);
var inst_30071 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30069,cljs.core.cst$kw$completed_QMARK_);
var state_30092__$1 = (function (){var statearr_30117 = state_30092;
(statearr_30117[(8)] = inst_30071);

(statearr_30117[(10)] = inst_30070__$1);

return statearr_30117;
})();
if(cljs.core.truth_(inst_30070__$1)){
var statearr_30118_30150 = state_30092__$1;
(statearr_30118_30150[(1)] = (17));

} else {
var statearr_30119_30151 = state_30092__$1;
(statearr_30119_30151[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30093 === (10))){
var inst_30064 = (state_30092[(2)]);
var state_30092__$1 = state_30092;
if(cljs.core.truth_(inst_30064)){
var statearr_30120_30152 = state_30092__$1;
(statearr_30120_30152[(1)] = (14));

} else {
var statearr_30121_30153 = state_30092__$1;
(statearr_30121_30153[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30093 === (18))){
var state_30092__$1 = state_30092;
var statearr_30122_30154 = state_30092__$1;
(statearr_30122_30154[(2)] = null);

(statearr_30122_30154[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30093 === (8))){
var inst_30049 = (state_30092[(7)]);
var inst_30054 = inst_30049.cljs$lang$protocol_mask$partition0$;
var inst_30055 = (inst_30054 & (64));
var inst_30056 = inst_30049.cljs$core$ISeq$;
var inst_30057 = (inst_30055) || (inst_30056);
var state_30092__$1 = state_30092;
if(cljs.core.truth_(inst_30057)){
var statearr_30123_30155 = state_30092__$1;
(statearr_30123_30155[(1)] = (11));

} else {
var statearr_30124_30156 = state_30092__$1;
(statearr_30124_30156[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto__))
;
return ((function (switch__8335__auto__,c__8400__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto____0 = (function (){
var statearr_30128 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30128[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto__);

(statearr_30128[(1)] = (1));

return statearr_30128;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto____1 = (function (state_30092){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_30092);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e30129){if((e30129 instanceof Object)){
var ex__8339__auto__ = e30129;
var statearr_30130_30157 = state_30092;
(statearr_30130_30157[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30092);

return cljs.core.cst$kw$recur;
} else {
throw e30129;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__30158 = state_30092;
state_30092 = G__30158;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto__ = function(state_30092){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto____1.call(this,state_30092);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto__))
})();
var state__8402__auto__ = (function (){var statearr_30131 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_30131[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto__);

return statearr_30131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});})(c__8400__auto__))
);

return c__8400__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(read_count,cljs.core.inc);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(agg,cljs.core.conj,data_chunk);

if((((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)) >= (100))) && (cljs.core.integer_QMARK_(Math.log10((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)))))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg))], null));

var G__30161_30163 = agg;
var G__30162_30164 = cljs.core.PersistentVector.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__30161_30163,G__30162_30164) : cljs.core.reset_BANG_.call(null,G__30161_30163,G__30162_30164));

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___30172 = arguments.length;
var i__5628__auto___30173 = (0);
while(true){
if((i__5628__auto___30173 < len__5627__auto___30172)){
args__5634__auto__.push((arguments[i__5628__auto___30173]));

var G__30174 = (i__5628__auto___30173 + (1));
i__5628__auto___30173 = G__30174;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__30168){
var map__30169 = p__30168;
var map__30169__$1 = ((((!((map__30169 == null)))?((((map__30169.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30169.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30169):map__30169);
var oboe_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30169__$1,cljs.core.cst$kw$oboe_DASH_headers);
var read_count = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0)) : cljs.core.atom.call(null,(0)));
var agg = (function (){var G__30171 = cljs.core.PersistentVector.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30171) : cljs.core.atom.call(null,G__30171));
})();
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var return_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var oboe_params = cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$headers,oboe_headers,cljs.core.cst$kw$withCredentials,true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__30169,map__30169__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__30169,map__30169__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__30169,map__30169__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg)),cljs.core.cst$kw$completed_QMARK_,true], null));

return cljs.core.async.close_BANG_(return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__30169,map__30169__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_(channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq30165){
var G__30166 = cljs.core.first(seq30165);
var seq30165__$1 = cljs.core.next(seq30165);
var G__30167 = cljs.core.first(seq30165__$1);
var seq30165__$2 = cljs.core.next(seq30165__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30166,G__30167,seq30165__$2);
});
