// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.utils.om.state');
goog.require('cljs.core');
goog.require('om.core');
/**
 * A transact! function that optionally uses swap! if this atom is not yet
 * transactable?
 */
hatti.utils.om.state.transact_BANG_ = (function hatti$utils$om$state$transact_BANG_(app_state){
if(((!((app_state == null)))?(((false) || (app_state.om$core$ITransact$))?true:(((!app_state.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,om.core.ITransact,app_state):false)):cljs.core.native_satisfies_QMARK_.call(null,om.core.ITransact,app_state))){
return om.core.transact_BANG_;
} else {
return cljs.core.swap_BANG_;
}
});
/**
 * Like om/transact! but also works on atoms that are not transactable?
 */
hatti.utils.om.state.transact_app_state_BANG_ = (function hatti$utils$om$state$transact_app_state_BANG_(var_args){
var args8340 = [];
var len__5627__auto___8343 = arguments.length;
var i__5628__auto___8344 = (0);
while(true){
if((i__5628__auto___8344 < len__5627__auto___8343)){
args8340.push((arguments[i__5628__auto___8344]));

var G__8345 = (i__5628__auto___8344 + (1));
i__5628__auto___8344 = G__8345;
continue;
} else {
}
break;
}

var G__8342 = args8340.length;
switch (G__8342) {
case 2:
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args8340.length)].join('')));

}
});

hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (app_state,transact_fn){
return hatti.utils.om.state.transact_BANG_.call(null,app_state).call(null,app_state,transact_fn);
});

hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (app_state,ks,transact_fn){
return hatti.utils.om.state.transact_BANG_.call(null,app_state).call(null,app_state,(function (p1__8339_SHARP_){
return cljs.core.update_in.call(null,p1__8339_SHARP_,ks,transact_fn);
}));
});

hatti.utils.om.state.transact_app_state_BANG_.cljs$lang$maxFixedArity = 3;
/**
 * Like om/update! but also works on atoms that are not transactable?
 */
hatti.utils.om.state.update_app_state_BANG_ = (function hatti$utils$om$state$update_app_state_BANG_(var_args){
var args8347 = [];
var len__5627__auto___8350 = arguments.length;
var i__5628__auto___8351 = (0);
while(true){
if((i__5628__auto___8351 < len__5627__auto___8350)){
args8347.push((arguments[i__5628__auto___8351]));

var G__8352 = (i__5628__auto___8351 + (1));
i__5628__auto___8351 = G__8352;
continue;
} else {
}
break;
}

var G__8349 = args8347.length;
switch (G__8349) {
case 2:
return hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args8347.length)].join('')));

}
});

hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (app_state,update_val){
return hatti.utils.om.state.transact_app_state_BANG_.call(null,app_state,(function (){
return update_val;
}));
});

hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (app_state,ks,update_val){
return hatti.utils.om.state.transact_app_state_BANG_.call(null,app_state,ks,(function (){
return update_val;
}));
});

hatti.utils.om.state.update_app_state_BANG_.cljs$lang$maxFixedArity = 3;
/**
 * Merges provided state into existing app-state, possibly after zoomint into
 * ks.
 */
hatti.utils.om.state.merge_into_app_state_BANG_ = (function hatti$utils$om$state$merge_into_app_state_BANG_(var_args){
var args8356 = [];
var len__5627__auto___8359 = arguments.length;
var i__5628__auto___8360 = (0);
while(true){
if((i__5628__auto___8360 < len__5627__auto___8359)){
args8356.push((arguments[i__5628__auto___8360]));

var G__8361 = (i__5628__auto___8360 + (1));
i__5628__auto___8360 = G__8361;
continue;
} else {
}
break;
}

var G__8358 = args8356.length;
switch (G__8358) {
case 2:
return hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args8356.length)].join('')));

}
});

hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (app_state,state_to_merge){
return hatti.utils.om.state.transact_app_state_BANG_.call(null,app_state,(function (p1__8354_SHARP_){
return cljs.core.merge.call(null,p1__8354_SHARP_,state_to_merge);
}));
});

hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (app_state,ks,state_to_merge){
return hatti.utils.om.state.transact_app_state_BANG_.call(null,app_state,ks,(function (p1__8355_SHARP_){
return cljs.core.merge.call(null,p1__8355_SHARP_,state_to_merge);
}));
});

hatti.utils.om.state.merge_into_app_state_BANG_.cljs$lang$maxFixedArity = 3;
