// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.utils');
goog.require('hatti.utils.om.state');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten((function (){var iter__5341__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__27009(s__27010){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__27010__$1 = s__27010;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__27010__$1);
if(temp__4425__auto__){
var s__27010__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__27010__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__27010__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__27012 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__27011 = (0);
while(true){
if((i__27011 < size__5340__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__27011);
cljs.core.chunk_append(b__27012,(function (){var iter__5341__auto__ = ((function (i__27011,datum,c__5339__auto__,size__5340__auto__,b__27012,s__27010__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__27009_$_iter__27027(s__27028){
return (new cljs.core.LazySeq(null,((function (i__27011,datum,c__5339__auto__,size__5340__auto__,b__27012,s__27010__$2,temp__4425__auto__,osmfields){
return (function (){
var s__27028__$1 = s__27028;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__27028__$1);
if(temp__4425__auto____$1){
var s__27028__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__27028__$2)){
var c__5339__auto____$1 = cljs.core.chunk_first(s__27028__$2);
var size__5340__auto____$1 = cljs.core.count(c__5339__auto____$1);
var b__27030 = cljs.core.chunk_buffer(size__5340__auto____$1);
if((function (){var i__27029 = (0);
while(true){
if((i__27029 < size__5340__auto____$1)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto____$1,i__27029);
cljs.core.chunk_append(b__27030,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__27039 = (i__27029 + (1));
i__27029 = G__27039;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__27030),hatti$ona$post_process$ona_osm_link_$_iter__27009_$_iter__27027(cljs.core.chunk_rest(s__27028__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__27030),null);
}
} else {
var field = cljs.core.first(s__27028__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__27009_$_iter__27027(cljs.core.rest(s__27028__$2)));
}
} else {
return null;
}
break;
}
});})(i__27011,datum,c__5339__auto__,size__5340__auto__,b__27012,s__27010__$2,temp__4425__auto__,osmfields))
,null,null));
});})(i__27011,datum,c__5339__auto__,size__5340__auto__,b__27012,s__27010__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__(osmfields);
})());

var G__27040 = (i__27011 + (1));
i__27011 = G__27040;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__27012),hatti$ona$post_process$ona_osm_link_$_iter__27009(cljs.core.chunk_rest(s__27010__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__27012),null);
}
} else {
var datum = cljs.core.first(s__27010__$2);
return cljs.core.cons((function (){var iter__5341__auto__ = ((function (datum,s__27010__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__27009_$_iter__27033(s__27034){
return (new cljs.core.LazySeq(null,((function (datum,s__27010__$2,temp__4425__auto__,osmfields){
return (function (){
var s__27034__$1 = s__27034;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__27034__$1);
if(temp__4425__auto____$1){
var s__27034__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__27034__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__27034__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__27036 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__27035 = (0);
while(true){
if((i__27035 < size__5340__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__27035);
cljs.core.chunk_append(b__27036,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__27041 = (i__27035 + (1));
i__27035 = G__27041;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__27036),hatti$ona$post_process$ona_osm_link_$_iter__27009_$_iter__27033(cljs.core.chunk_rest(s__27034__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__27036),null);
}
} else {
var field = cljs.core.first(s__27034__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__27009_$_iter__27033(cljs.core.rest(s__27034__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__27010__$2,temp__4425__auto__,osmfields))
,null,null));
});})(datum,s__27010__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__(osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__27009(cljs.core.rest(s__27010__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__5341__auto__(data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((function (){var G__27043 = jQuery.parseXML(osm_xml_string);
return osmtogeojson(G__27043);
})(),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link(data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson(osm_xml);
var featureset = (osmgeo.cljs$core$IFn$_invoke$arity$1 ? osmgeo.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$features) : osmgeo.call(null,cljs.core.cst$kw$features));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5341__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__27066(s__27067){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__27067__$1 = s__27067;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__27067__$1);
if(temp__4425__auto__){
var s__27067__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__27067__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__27067__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__27069 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__27068 = (0);
while(true){
if((i__27068 < size__5340__auto__)){
var map__27080 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__27068);
var map__27080__$1 = ((((!((map__27080 == null)))?((((map__27080.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27080.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27080):map__27080);
var feature = map__27080__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27080__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27080__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27080__$1,cljs.core.cst$kw$geometry);
cljs.core.chunk_append(b__27069,(function (){var map__27082 = properties;
var map__27082__$1 = ((((!((map__27082 == null)))?((((map__27082.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27082.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27082):map__27082);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27082__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27082__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27082__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})());

var G__27088 = (i__27068 + (1));
i__27068 = G__27088;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__27069),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__27066(cljs.core.chunk_rest(s__27067__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__27069),null);
}
} else {
var map__27084 = cljs.core.first(s__27067__$2);
var map__27084__$1 = ((((!((map__27084 == null)))?((((map__27084.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27084.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27084):map__27084);
var feature = map__27084__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27084__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27084__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27084__$1,cljs.core.cst$kw$geometry);
return cljs.core.cons((function (){var map__27086 = properties;
var map__27086__$1 = ((((!((map__27086 == null)))?((((map__27086.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27086.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27086):map__27086);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27086__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27086__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27086__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__27066(cljs.core.rest(s__27067__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__5341__auto__(featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq(osm_fields)){
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data(data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__27089_SHARP_){
return cljs.core.re_find(/[-]?[0-9]+/,p1__27089_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val){
if(typeof osm_val === 'string'){
var temp__4423__auto__ = (function (){var G__27101 = osm_val__GT_osm_id(osm_val);
return (osm_data.cljs$core$IFn$_invoke$arity$1 ? osm_data.cljs$core$IFn$_invoke$arity$1(G__27101) : osm_data.call(null,G__27101));
})();
if(cljs.core.truth_(temp__4423__auto__)){
var osm_submission_data = temp__4423__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__5341__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__27102(s__27103){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__27103__$1 = s__27103;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__27103__$1);
if(temp__4425__auto__){
var s__27103__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__27103__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__27103__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__27105 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__27104 = (0);
while(true){
if((i__27104 < size__5340__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__27104);
cljs.core.chunk_append(b__27105,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data));

var G__27112 = (i__27104 + (1));
i__27104 = G__27112;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__27105),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__27102(cljs.core.chunk_rest(s__27103__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__27105),null);
}
} else {
var datum = cljs.core.first(s__27103__$2);
return cljs.core.cons(cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__27102(cljs.core.rest(s__27103__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__5341__auto__(data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__27108 = cljs.core.seq(osm_fields);
var chunk__27109 = null;
var count__27110 = (0);
var i__27111 = (0);
while(true){
if((i__27111 < count__27110)){
var osm_field = chunk__27109.cljs$core$IIndexed$_nth$arity$2(null,i__27111);
hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__27113 = seq__27108;
var G__27114 = chunk__27109;
var G__27115 = count__27110;
var G__27116 = (i__27111 + (1));
seq__27108 = G__27113;
chunk__27109 = G__27114;
count__27110 = G__27115;
i__27111 = G__27116;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__27108);
if(temp__4425__auto__){
var seq__27108__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__27108__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__27108__$1);
var G__27117 = cljs.core.chunk_rest(seq__27108__$1);
var G__27118 = c__5372__auto__;
var G__27119 = cljs.core.count(c__5372__auto__);
var G__27120 = (0);
seq__27108 = G__27117;
chunk__27109 = G__27118;
count__27110 = G__27119;
i__27111 = G__27120;
continue;
} else {
var osm_field = cljs.core.first(seq__27108__$1);
hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__27121 = cljs.core.next(seq__27108__$1);
var G__27122 = null;
var G__27123 = (0);
var G__27124 = (0);
seq__27108 = G__27121;
chunk__27109 = G__27122;
count__27110 = G__27123;
i__27111 = G__27124;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"id");
var fname = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"filename");
var file_url = hatti.ona.urls.media_url(media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$filename,fname,cljs.core.cst$kw$download_url,file_url,cljs.core.cst$kw$small_download_url,[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__4569__auto__ = attachments;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,"_attachments");
}
})();
var fnames = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (attachments__$1){
return (function (p1__27125_SHARP_){
return hatti.utils.last_url_param(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__27125_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap(fnames,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(fname__GT_urlobj,fname,fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Inlines media data from within _attachments into each record.
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__5634__auto__ = [];
var len__5627__auto___27138 = arguments.length;
var i__5628__auto___27139 = (0);
while(true){
if((i__5628__auto___27139 < len__5627__auto___27138)){
args__5634__auto__.push((arguments[i__5628__auto___27139]));

var G__27140 = (i__5628__auto___27139 + (1));
i__5628__auto___27139 = G__27140;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__27129){
var map__27130 = p__27129;
var map__27130__$1 = ((((!((map__27130 == null)))?((((map__27130.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27130.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27130):map__27130);
var attachments = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27130__$1,cljs.core.cst$kw$attachments);
var image_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.image_QMARK_,flat_form);
var iter__5341__auto__ = ((function (image_fields,map__27130,map__27130__$1,attachments){
return (function hatti$ona$post_process$iter__27132(s__27133){
return (new cljs.core.LazySeq(null,((function (image_fields,map__27130,map__27130__$1,attachments){
return (function (){
var s__27133__$1 = s__27133;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__27133__$1);
if(temp__4425__auto__){
var s__27133__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__27133__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__27133__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__27135 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__27134 = (0);
while(true){
if((i__27134 < size__5340__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__27134);
cljs.core.chunk_append(b__27135,(function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i__27134,attach_map,record,c__5339__auto__,size__5340__auto__,b__27135,s__27133__$2,temp__4425__auto__,image_fields,map__27130,map__27130__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__27134,attach_map,record,c__5339__auto__,size__5340__auto__,b__27135,s__27133__$2,temp__4425__auto__,image_fields,map__27130,map__27130__$1,attachments))
,record,image_fields);
})());

var G__27141 = (i__27134 + (1));
i__27134 = G__27141;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__27135),hatti$ona$post_process$iter__27132(cljs.core.chunk_rest(s__27133__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__27135),null);
}
} else {
var record = cljs.core.first(s__27133__$2);
return cljs.core.cons((function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (attach_map,record,s__27133__$2,temp__4425__auto__,image_fields,map__27130,map__27130__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__27133__$2,temp__4425__auto__,image_fields,map__27130,map__27130__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__27132(cljs.core.rest(s__27133__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__27130,map__27130__$1,attachments))
,null,null));
});})(image_fields,map__27130,map__27130__$1,attachments))
;
return iter__5341__auto__(data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq27126){
var G__27127 = cljs.core.first(seq27126);
var seq27126__$1 = cljs.core.next(seq27126);
var G__27128 = cljs.core.first(seq27126__$1);
var seq27126__$2 = cljs.core.next(seq27126__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__27127,G__27128,seq27126__$2);
});
/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(record,key,hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,key),cljs.core.array_seq([cljs.core.cst$kw$attachments,cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,"_attachments")], 0)));
});})(repeat_fields))
;
var iter__5341__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__27148(s__27149){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__27149__$1 = s__27149;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__27149__$1);
if(temp__4425__auto__){
var s__27149__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__27149__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__27149__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__27151 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__27150 = (0);
while(true){
if((i__27150 < size__5340__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__27150);
cljs.core.chunk_append(b__27151,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields));

var G__27154 = (i__27150 + (1));
i__27150 = G__27154;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__27151),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__27148(cljs.core.chunk_rest(s__27149__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__27151),null);
}
} else {
var record = cljs.core.first(s__27149__$2);
return cljs.core.cons(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__27148(cljs.core.rest(s__27149__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__5341__auto__(data);
});
/**
 * Inlines data from within _atatchments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___27162 = arguments.length;
var i__5628__auto___27163 = (0);
while(true){
if((i__5628__auto___27163 < len__5627__auto___27162)){
args__5634__auto__.push((arguments[i__5628__auto___27163]));

var G__27164 = (i__5628__auto___27163 + (1));
i__5628__auto___27163 = G__27164;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__27159){
var map__27160 = p__27159;
var map__27160__$1 = ((((!((map__27160 == null)))?((((map__27160.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27160.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27160):map__27160);
var app_data_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__27160__$1,cljs.core.cst$kw$app_DASH_data_DASH_keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_data_keys,((function (map__27160,map__27160__$1,app_data_keys){
return (function (p1__27155_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats(flat_form,hatti.ona.post_process.integrate_attachments(flat_form,p1__27155_SHARP_));
});})(map__27160,map__27160__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq27156){
var G__27157 = cljs.core.first(seq27156);
var seq27156__$1 = cljs.core.next(seq27156);
var G__27158 = cljs.core.first(seq27156__$1);
var seq27156__$2 = cljs.core.next(seq27156__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__27157,G__27158,seq27156__$2);
});
