// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.map.utils');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('hatti.constants');
goog.require('hatti.ona.forms');
goog.require('hatti.utils');
hatti.map.utils.ona_styles = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$point,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,{"radius": (6), "fillColor": "#f30", "reset": {"fillColor": "#f30"}, "color": "#fff", "border": (8), "opacity": 0.5, "fillOpacity": 0.9},cljs.core.cst$kw$hover,{"fillColor": "#631400"},cljs.core.cst$kw$clicked,{"fillColor": "#ad2300"}], null),cljs.core.cst$kw$shape,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,{"fillColor": "#f30", "color": "#666", "weight": (3), "dashArray": "3", "fillOpacity": 0.7, "opacity": 0.8},cljs.core.cst$kw$hover,{"fillColor": "#631400", "color": "#222"},cljs.core.cst$kw$clicked,{"fillColor": "#ad2300", "color": "#222"}], null),cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,{"color": "#f30", "opacity": (1), "weight": (6), "reset": {"color": "#f30"}},cljs.core.cst$kw$hover,{"color": "#631400"},cljs.core.cst$kw$clicked,{"color": "#ad2300"}], null)], null);
/**
 * Returns geotype (:point :line or :shape) based on marker.
 */
hatti.map.utils.marker__GT_geotype = (function hatti$map$utils$marker__GT_geotype(marker){
return new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,(((marker["feature"])["geometry"])["type"]));
});
/**
 * Appropriate style given style-type (:normal, :clicked, :hover), and
 * either a leaflet marker or clojurescript keyword (one of :point or :shape).
 */
hatti.map.utils.get_ona_style = (function hatti$map$utils$get_ona_style(marker_or_keyword,style_type){
var kw = (((marker_or_keyword instanceof cljs.core.Keyword))?marker_or_keyword:hatti.map.utils.marker__GT_geotype(marker_or_keyword));
var G__25175 = (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(hatti.map.utils.ona_styles) : kw.call(null,hatti.map.utils.ona_styles));
return (style_type.cljs$core$IFn$_invoke$arity$1 ? style_type.cljs$core$IFn$_invoke$arity$1(G__25175) : style_type.call(null,G__25175));
});
hatti.map.utils.equivalent_style = (function hatti$map$utils$equivalent_style(s,t){

var sc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(s);
var tc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(t);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.select_keys(sc,cljs.core.keys(tc)),cljs.core.select_keys(tc,cljs.core.keys(sc)));
});
hatti.map.utils.get_id = (function hatti$map$utils$get_id(marker){
return (((marker["feature"])["properties"])[hatti.constants._id]);
});
hatti.map.utils.get_rank = (function hatti$map$utils$get_rank(marker){
return (((marker["feature"])["properties"])[hatti.constants._rank]);
});
/**
 * Get the style of a marker. Second arg specifies style attribute to get.
 * eg. For marker m1, call like: (get-style m1) or (get-style m1 :fillColor)
 */
hatti.map.utils.get_style = (function hatti$map$utils$get_style(var_args){
var args25176 = [];
var len__5627__auto___25180 = arguments.length;
var i__5628__auto___25181 = (0);
while(true){
if((i__5628__auto___25181 < len__5627__auto___25180)){
args25176.push((arguments[i__5628__auto___25181]));

var G__25182 = (i__5628__auto___25181 + (1));
i__5628__auto___25181 = G__25182;
continue;
} else {
}
break;
}

var G__25178 = args25176.length;
switch (G__25178) {
case 1:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25176.length)].join('')));

}
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1 = (function (marker){
return (marker["options"]);
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2 = (function (marker,kw){
var G__25179 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker));
return (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(G__25179) : kw.call(null,G__25179));
});

hatti.map.utils.get_style.cljs$lang$maxFixedArity = 2;
/**
 * Check whether a marker is clicked, so it's style can be preserved.
 */
hatti.map.utils.is_clicked_QMARK_ = (function hatti$map$utils$is_clicked_QMARK_(marker){
return hatti.map.utils.equivalent_style(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker),hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
});
/**
 * Apply a style to a marker. Style comes from a function that takes marker.
 */
hatti.map.utils.re_style_marker = (function hatti$map$utils$re_style_marker(marker__GT_style,marker){
var style = (marker__GT_style.cljs$core$IFn$_invoke$arity$1 ? marker__GT_style.cljs$core$IFn$_invoke$arity$1(marker) : marker__GT_style.call(null,marker));
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return marker.setStyle(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$reset,style], null)));
} else {
return marker.setStyle(cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(style,cljs.core.cst$kw$reset,style)));
}
});
/**
 * Reset styles pulls the 'reset' property from within a markers options,
 * clearing styles to default if nothing found.
 */
hatti.map.utils.reset_style = (function hatti$map$utils$reset_style(marker){
var temp__4423__auto__ = ((marker["options"])["reset"]);
if(cljs.core.truth_(temp__4423__auto__)){
var rstyle = temp__4423__auto__;
return marker.setStyle(rstyle);
} else {
return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
}
});
/**
 * Looks at the _id in marker, and brings to top if (1) marker clicked or
 * (2) marker's id is selected (via id-selected?)
 */
hatti.map.utils.bring_to_top_if_selected = (function hatti$map$utils$bring_to_top_if_selected(id_selected_QMARK_,marker){
if(cljs.core.truth_((function (){var or__4569__auto__ = hatti.map.utils.is_clicked_QMARK_(marker);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var G__25185 = hatti.map.utils.get_id(marker);
return (id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(G__25185) : id_selected_QMARK_.call(null,G__25185));
}
})())){
return marker.bringToFront();
} else {
return null;
}
});
hatti.map.utils.apply_click_style = (function hatti$map$utils$apply_click_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
} else {
return null;
}
});
hatti.map.utils.apply_unclick_style = (function hatti$map$utils$apply_unclick_style(marker){
if(cljs.core.truth_(marker)){
return hatti.map.utils.reset_style(marker);
} else {
return null;
}
});
hatti.map.utils.apply_hover_style = (function hatti$map$utils$apply_hover_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$hover));
} else {
return null;
}
});
/**
 * Sets the default style on a marker.
 */
hatti.map.utils.clear_all_styles = (function hatti$map$utils$clear_all_styles(var_args){
var args__5634__auto__ = [];
var len__5627__auto___25195 = arguments.length;
var i__5628__auto___25196 = (0);
while(true){
if((i__5628__auto___25196 < len__5627__auto___25195)){
args__5634__auto__.push((arguments[i__5628__auto___25196]));

var G__25197 = (i__5628__auto___25196 + (1));
i__5628__auto___25196 = G__25197;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic = (function (markers,p__25188){
var map__25189 = p__25188;
var map__25189__$1 = ((((!((map__25189 == null)))?((((map__25189.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25189.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25189):map__25189);
var preserve_clicked_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__25189__$1,cljs.core.cst$kw$preserve_DASH_clicked_QMARK_,true);
var seq__25191 = cljs.core.seq(markers);
var chunk__25192 = null;
var count__25193 = (0);
var i__25194 = (0);
while(true){
if((i__25194 < count__25193)){
var marker = chunk__25192.cljs$core$IIndexed$_nth$arity$2(null,i__25194);
if(cljs.core.not((function (){var and__4557__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__4557__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__4557__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__25198 = seq__25191;
var G__25199 = chunk__25192;
var G__25200 = count__25193;
var G__25201 = (i__25194 + (1));
seq__25191 = G__25198;
chunk__25192 = G__25199;
count__25193 = G__25200;
i__25194 = G__25201;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__25191);
if(temp__4425__auto__){
var seq__25191__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__25191__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__25191__$1);
var G__25202 = cljs.core.chunk_rest(seq__25191__$1);
var G__25203 = c__5372__auto__;
var G__25204 = cljs.core.count(c__5372__auto__);
var G__25205 = (0);
seq__25191 = G__25202;
chunk__25192 = G__25203;
count__25193 = G__25204;
i__25194 = G__25205;
continue;
} else {
var marker = cljs.core.first(seq__25191__$1);
if(cljs.core.not((function (){var and__4557__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__4557__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__4557__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__25206 = cljs.core.next(seq__25191__$1);
var G__25207 = null;
var G__25208 = (0);
var G__25209 = (0);
seq__25191 = G__25206;
chunk__25192 = G__25207;
count__25193 = G__25208;
i__25194 = G__25209;
continue;
}
} else {
return null;
}
}
break;
}
});

hatti.map.utils.clear_all_styles.cljs$lang$maxFixedArity = (1);

hatti.map.utils.clear_all_styles.cljs$lang$applyTo = (function (seq25186){
var G__25187 = cljs.core.first(seq25186);
var seq25186__$1 = cljs.core.next(seq25186);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic(G__25187,seq25186__$1);
});
hatti.map.utils.read_string_or_number = (function hatti$map$utils$read_string_or_number(maybe_s){
if(typeof maybe_s === 'string'){
return cljs.reader.read_string(maybe_s);
} else {
return maybe_s;
}
});
hatti.map.utils.make_feature = (function hatti$map$utils$make_feature(geometry,record_id,index){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"Feature",cljs.core.cst$kw$properties,cljs.core.PersistentArrayMap.fromArray([cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._rank),(index + (1)),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id),record_id], true, false),cljs.core.cst$kw$geometry,geometry], null);
});
if(typeof hatti.map.utils.get_as_geom !== 'undefined'){
} else {
hatti.map.utils.get_as_geom = (function (){var method_table__5482__auto__ = (function (){var G__25210 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25210) : cljs.core.atom.call(null,G__25210));
})();
var prefer_table__5483__auto__ = (function (){var G__25211 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25211) : cljs.core.atom.call(null,G__25211));
})();
var method_cache__5484__auto__ = (function (){var G__25212 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25212) : cljs.core.atom.call(null,G__25212));
})();
var cached_hierarchy__5485__auto__ = (function (){var G__25213 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25213) : cljs.core.atom.call(null,G__25213));
})();
var hierarchy__5486__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("hatti.map.utils","get-as-geom"),((function (method_table__5482__auto__,prefer_table__5483__auto__,method_cache__5484__auto__,cached_hierarchy__5485__auto__,hierarchy__5486__auto__){
return (function() { 
var G__25216__delegate = function (record,field,p__25214){
var vec__25215 = p__25214;
var repeat_child_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25215,(0),null);
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
return cljs.core.cst$kw$repeat;
} else {
return cljs.core.cst$kw$default;

}
};
var G__25216 = function (record,field,var_args){
var p__25214 = null;
if (arguments.length > 2) {
var G__25217__i = 0, G__25217__a = new Array(arguments.length -  2);
while (G__25217__i < G__25217__a.length) {G__25217__a[G__25217__i] = arguments[G__25217__i + 2]; ++G__25217__i;}
  p__25214 = new cljs.core.IndexedSeq(G__25217__a,0);
} 
return G__25216__delegate.call(this,record,field,p__25214);};
G__25216.cljs$lang$maxFixedArity = 2;
G__25216.cljs$lang$applyTo = (function (arglist__25218){
var record = cljs.core.first(arglist__25218);
arglist__25218 = cljs.core.next(arglist__25218);
var field = cljs.core.first(arglist__25218);
var p__25214 = cljs.core.rest(arglist__25218);
return G__25216__delegate(record,field,p__25214);
});
G__25216.cljs$core$IFn$_invoke$arity$variadic = G__25216__delegate;
return G__25216;
})()
;})(method_table__5482__auto__,prefer_table__5483__auto__,method_cache__5484__auto__,cached_hierarchy__5485__auto__,hierarchy__5486__auto__))
,cljs.core.cst$kw$default,hierarchy__5486__auto__,method_table__5482__auto__,prefer_table__5483__auto__,method_cache__5484__auto__,cached_hierarchy__5485__auto__));
})();
}
hatti.map.utils.get_as_geom.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$repeat,(function (record,p__25219){
var map__25220 = p__25219;
var map__25220__$1 = ((((!((map__25220 == null)))?((((map__25220.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25220.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25220):map__25220);
var field = map__25220__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25220__$1,cljs.core.cst$kw$children);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25220__$1,cljs.core.cst$kw$full_DASH_name);
var iter__5341__auto__ = ((function (map__25220,map__25220__$1,field,children,full_name){
return (function hatti$map$utils$iter__25222(s__25223){
return (new cljs.core.LazySeq(null,((function (map__25220,map__25220__$1,field,children,full_name){
return (function (){
var s__25223__$1 = s__25223;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__25223__$1);
if(temp__4425__auto__){
var s__25223__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__25223__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__25223__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__25225 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__25224 = (0);
while(true){
if((i__25224 < size__5340__auto__)){
var child_record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__25224);
cljs.core.chunk_append(b__25225,(function (){var iter__5341__auto__ = ((function (i__25224,child_record,c__5339__auto__,size__5340__auto__,b__25225,s__25223__$2,temp__4425__auto__,map__25220,map__25220__$1,field,children,full_name){
return (function hatti$map$utils$iter__25222_$_iter__25240(s__25241){
return (new cljs.core.LazySeq(null,((function (i__25224,child_record,c__5339__auto__,size__5340__auto__,b__25225,s__25223__$2,temp__4425__auto__,map__25220,map__25220__$1,field,children,full_name){
return (function (){
var s__25241__$1 = s__25241;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__25241__$1);
if(temp__4425__auto____$1){
var s__25241__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__25241__$2)){
var c__5339__auto____$1 = cljs.core.chunk_first(s__25241__$2);
var size__5340__auto____$1 = cljs.core.count(c__5339__auto____$1);
var b__25243 = cljs.core.chunk_buffer(size__5340__auto____$1);
if((function (){var i__25242 = (0);
while(true){
if((i__25242 < size__5340__auto____$1)){
var child = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto____$1,i__25242);
cljs.core.chunk_append(b__25243,(hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)));

var G__25252 = (i__25242 + (1));
i__25242 = G__25252;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__25243),hatti$map$utils$iter__25222_$_iter__25240(cljs.core.chunk_rest(s__25241__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__25243),null);
}
} else {
var child = cljs.core.first(s__25241__$2);
return cljs.core.cons((hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)),hatti$map$utils$iter__25222_$_iter__25240(cljs.core.rest(s__25241__$2)));
}
} else {
return null;
}
break;
}
});})(i__25224,child_record,c__5339__auto__,size__5340__auto__,b__25225,s__25223__$2,temp__4425__auto__,map__25220,map__25220__$1,field,children,full_name))
,null,null));
});})(i__25224,child_record,c__5339__auto__,size__5340__auto__,b__25225,s__25223__$2,temp__4425__auto__,map__25220,map__25220__$1,field,children,full_name))
;
return iter__5341__auto__(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,children));
})());

var G__25253 = (i__25224 + (1));
i__25224 = G__25253;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__25225),hatti$map$utils$iter__25222(cljs.core.chunk_rest(s__25223__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__25225),null);
}
} else {
var child_record = cljs.core.first(s__25223__$2);
return cljs.core.cons((function (){var iter__5341__auto__ = ((function (child_record,s__25223__$2,temp__4425__auto__,map__25220,map__25220__$1,field,children,full_name){
return (function hatti$map$utils$iter__25222_$_iter__25246(s__25247){
return (new cljs.core.LazySeq(null,((function (child_record,s__25223__$2,temp__4425__auto__,map__25220,map__25220__$1,field,children,full_name){
return (function (){
var s__25247__$1 = s__25247;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__25247__$1);
if(temp__4425__auto____$1){
var s__25247__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__25247__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__25247__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__25249 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__25248 = (0);
while(true){
if((i__25248 < size__5340__auto__)){
var child = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__25248);
cljs.core.chunk_append(b__25249,(hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)));

var G__25254 = (i__25248 + (1));
i__25248 = G__25254;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__25249),hatti$map$utils$iter__25222_$_iter__25246(cljs.core.chunk_rest(s__25247__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__25249),null);
}
} else {
var child = cljs.core.first(s__25247__$2);
return cljs.core.cons((hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)),hatti$map$utils$iter__25222_$_iter__25246(cljs.core.rest(s__25247__$2)));
}
} else {
return null;
}
break;
}
});})(child_record,s__25223__$2,temp__4425__auto__,map__25220,map__25220__$1,field,children,full_name))
,null,null));
});})(child_record,s__25223__$2,temp__4425__auto__,map__25220,map__25220__$1,field,children,full_name))
;
return iter__5341__auto__(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,children));
})(),hatti$map$utils$iter__25222(cljs.core.rest(s__25223__$2)));
}
} else {
return null;
}
break;
}
});})(map__25220,map__25220__$1,field,children,full_name))
,null,null));
});})(map__25220,map__25220__$1,field,children,full_name))
;
return iter__5341__auto__(cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,full_name));
}));
hatti.map.utils.get_as_geom.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (record,geofield){
var geotype = new cljs.core.PersistentArrayMap(null, 4, ["geopoint","Point","gps","Point","geoshape","Polygon","geotrace","LineString"], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(geofield));
var parse = ((function (geotype){
return (function (s){
if((cljs.core.seq(s)) && (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(s,"n/a"))){
var iter__5341__auto__ = ((function (geotype){
return (function hatti$map$utils$iter__25257(s__25258){
return (new cljs.core.LazySeq(null,((function (geotype){
return (function (){
var s__25258__$1 = s__25258;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__25258__$1);
if(temp__4425__auto__){
var s__25258__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__25258__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__25258__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__25260 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__25259 = (0);
while(true){
if((i__25259 < size__5340__auto__)){
var coord_string = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__25259);
cljs.core.chunk_append(b__25260,(function (){var vec__25265 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25265,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25265,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25265,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25265,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})());

var G__25268 = (i__25259 + (1));
i__25259 = G__25268;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__25260),hatti$map$utils$iter__25257(cljs.core.chunk_rest(s__25258__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__25260),null);
}
} else {
var coord_string = cljs.core.first(s__25258__$2);
return cljs.core.cons((function (){var vec__25266 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25266,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25266,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25266,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25266,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})(),hatti$map$utils$iter__25257(cljs.core.rest(s__25258__$2)));
}
} else {
return null;
}
break;
}
});})(geotype))
,null,null));
});})(geotype))
;
return iter__5341__auto__(clojure.string.split.cljs$core$IFn$_invoke$arity$2(s,/;/));
} else {
return null;
}
});})(geotype))
;
var coordfn = (function (){var G__25267 = geotype;
switch (G__25267) {
case "Point":
return ((function (G__25267,geotype,parse){
return (function (p1__25255_SHARP_){
return cljs.core.first(parse(p1__25255_SHARP_));
});
;})(G__25267,geotype,parse))

break;
case "LineString":
return parse;

break;
case "Polygon":
return ((function (G__25267,geotype,parse){
return (function (p1__25256_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[parse(p1__25256_SHARP_)],null));
});
;})(G__25267,geotype,parse))

break;
default:
return cljs.core.identity;

}
})();
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(geofield));
var coords = (coordfn.cljs$core$IFn$_invoke$arity$1 ? coordfn.cljs$core$IFn$_invoke$arity$1(value) : coordfn.call(null,value));
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_(geofield))){
return cljs.core.cst$kw$geom.cljs$core$IFn$_invoke$arity$1(value);
} else {
if(cljs.core.truth_((function (){var or__4569__auto__ = (coords == null);
if(or__4569__auto__){
return or__4569__auto__;
} else {
return cljs.core.some(cljs.core.nil_QMARK_,coords);
}
})())){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,geotype,cljs.core.cst$kw$coordinates,coords], null);
}
}
}));
/**
 * Given the dataset, and the form schema, get out geojson.
 * Optional specification of field will map that field data to the geom.
 */
hatti.map.utils.as_geojson = (function hatti$map$utils$as_geojson(var_args){
var args25271 = [];
var len__5627__auto___25284 = arguments.length;
var i__5628__auto___25285 = (0);
while(true){
if((i__5628__auto___25285 < len__5627__auto___25284)){
args25271.push((arguments[i__5628__auto___25285]));

var G__25286 = (i__5628__auto___25285 + (1));
i__5628__auto___25285 = G__25286;
continue;
} else {
}
break;
}

var G__25273 = args25271.length;
switch (G__25273) {
case 2:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25271.length)].join('')));

}
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2 = (function (dataset,form){
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3(dataset,form,hatti.ona.forms.default_geofield(form));
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3 = (function (dataset,form,geofield){
if(cljs.core.truth_(geofield)){
var features = (function (){var iter__5341__auto__ = (function hatti$map$utils$iter__25274(s__25275){
return (new cljs.core.LazySeq(null,(function (){
var s__25275__$1 = s__25275;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__25275__$1);
if(temp__4425__auto__){
var s__25275__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__25275__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__25275__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__25277 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__25276 = (0);
while(true){
if((i__25276 < size__5340__auto__)){
var vec__25282 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__25276);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25282,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25282,(1),null);
var geom_or_geoms = (hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(record,geofield) : hatti.map.utils.get_as_geom.call(null,record,geofield));
if(cljs.core.truth_(geom_or_geoms)){
cljs.core.chunk_append(b__25277,((cljs.core.map_QMARK_(geom_or_geoms))?hatti.map.utils.make_feature(geom_or_geoms,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx):cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__25276,s__25275__$1,geom_or_geoms,vec__25282,idx,record,c__5339__auto__,size__5340__auto__,b__25277,s__25275__$2,temp__4425__auto__){
return (function (p1__25270_SHARP_){
return hatti.map.utils.make_feature(p1__25270_SHARP_,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx);
});})(i__25276,s__25275__$1,geom_or_geoms,vec__25282,idx,record,c__5339__auto__,size__5340__auto__,b__25277,s__25275__$2,temp__4425__auto__))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(geom_or_geoms)))));

var G__25288 = (i__25276 + (1));
i__25276 = G__25288;
continue;
} else {
var G__25289 = (i__25276 + (1));
i__25276 = G__25289;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__25277),hatti$map$utils$iter__25274(cljs.core.chunk_rest(s__25275__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__25277),null);
}
} else {
var vec__25283 = cljs.core.first(s__25275__$2);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25283,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25283,(1),null);
var geom_or_geoms = (hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(record,geofield) : hatti.map.utils.get_as_geom.call(null,record,geofield));
if(cljs.core.truth_(geom_or_geoms)){
return cljs.core.cons(((cljs.core.map_QMARK_(geom_or_geoms))?hatti.map.utils.make_feature(geom_or_geoms,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx):cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (s__25275__$1,geom_or_geoms,vec__25283,idx,record,s__25275__$2,temp__4425__auto__){
return (function (p1__25270_SHARP_){
return hatti.map.utils.make_feature(p1__25270_SHARP_,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx);
});})(s__25275__$1,geom_or_geoms,vec__25283,idx,record,s__25275__$2,temp__4425__auto__))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(geom_or_geoms)))),hatti$map$utils$iter__25274(cljs.core.rest(s__25275__$2)));
} else {
var G__25290 = cljs.core.rest(s__25275__$2);
s__25275__$1 = G__25290;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(hatti.utils.indexed(dataset));
})();
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,cljs.core.flatten(features)], null);
} else {
return null;
}
});

hatti.map.utils.as_geojson.cljs$lang$maxFixedArity = 3;
/**
 * Creates a leaflet map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_map = (function hatti$map$utils$create_map(id,p__25292){
var map__25295 = p__25292;
var map__25295__$1 = ((((!((map__25295 == null)))?((((map__25295.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25295.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25295):map__25295);
var mapbox_tiles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25295__$1,cljs.core.cst$kw$mapbox_DASH_tiles);
var include_google_maps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25295__$1,cljs.core.cst$kw$include_DASH_google_DASH_maps_QMARK_);
var layers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__25295,map__25295__$1,mapbox_tiles,include_google_maps_QMARK_){
return (function (p1__25291_SHARP_){
return L.tileLayer(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(p1__25291_SHARP_));
});})(map__25295,map__25295__$1,mapbox_tiles,include_google_maps_QMARK_))
,mapbox_tiles);
var nlayers = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name,mapbox_tiles),layers);
var named_layers = (cljs.core.truth_(include_google_maps_QMARK_)?cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(nlayers,"Google Satellite",new L.Google)):cljs.core.clj__GT_js(nlayers));
var m = L.map(id,{"layers": cljs.core.first(layers), "zoomControl": false});
var z = L.control.zoom.call(null,{"position": "bottomleft"});
z.addTo(m);

L.control.layers.call(null,named_layers,null,{"position": "bottomleft"}).addTo(m);

m.setView([(0),(0)],(1));

return m;
});
/**
 * Mouse events for markers.
 *   On click or arrow, mapped-submission-to-rank events are generated.
 *   On hover, marker is brought to the front and color changed.
 */
hatti.map.utils.register_mouse_events = (function hatti$map$utils$register_mouse_events(feature,marker,event_chan){
marker.on("click",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_rank,((feature["properties"])[hatti.constants._rank])], null));
}
}));

marker.on("mouseover",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_hover_style(marker);
}
}));

return marker.on("mouseout",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_unclick_style(marker);
}
}));
});
/**
 * Re-renders map by invalidating leaflet size.
 * If map is zoomed out beyond layer-bounds, re-zooms to layer.
 */
hatti.map.utils.re_render_map_BANG_ = (function hatti$map$utils$re_render_map_BANG_(leaflet_map,feature_layer){
var map_bounds = leaflet_map.getBounds();
var layer_bounds = feature_layer.getBounds();
leaflet_map.invalidateSize(false);

if(((leaflet_map.getZoom() === (0))) || (cljs.core.not(layer_bounds.contains(map_bounds)))){
return leaflet_map.fitBounds(layer_bounds);
} else {
return null;
}
});
/**
 * Create a map with the given GeoJSON data.
 * Adds mouse events and centers on the geojson features.
 */
hatti.map.utils.load_geo_json = (function hatti$map$utils$load_geo_json(var_args){
var args__5634__auto__ = [];
var len__5627__auto___25309 = arguments.length;
var i__5628__auto___25310 = (0);
while(true){
if((i__5628__auto___25310 < len__5627__auto___25309)){
args__5634__auto__.push((arguments[i__5628__auto___25310]));

var G__25311 = (i__5628__auto___25310 + (1));
i__5628__auto___25310 = G__25311;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((3) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((3)),(0))):null);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5635__auto__);
});

hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic = (function (m,geojson,event_chan,p__25306){
var map__25307 = p__25306;
var map__25307__$1 = ((((!((map__25307 == null)))?((((map__25307.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25307.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25307):map__25307);
var rezoom_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25307__$1,cljs.core.cst$kw$rezoom_QMARK_);
var on_events = ((function (map__25307,map__25307__$1,rezoom_QMARK_){
return (function (p1__25297_SHARP_,p2__25298_SHARP_){
return hatti.map.utils.register_mouse_events(p1__25297_SHARP_,p2__25298_SHARP_,event_chan);
});})(map__25307,map__25307__$1,rezoom_QMARK_))
;
var geometry_type = new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson)))));
var stylefn = ((function (on_events,geometry_type,map__25307,map__25307__$1,rezoom_QMARK_){
return (function (){
return hatti.map.utils.get_ona_style(geometry_type,cljs.core.cst$kw$normal);
});})(on_events,geometry_type,map__25307,map__25307__$1,rezoom_QMARK_))
;
var point__GT_marker = ((function (on_events,geometry_type,stylefn,map__25307,map__25307__$1,rezoom_QMARK_){
return (function (p1__25300_SHARP_,p2__25299_SHARP_){
return L.circleMarker(p2__25299_SHARP_);
});})(on_events,geometry_type,stylefn,map__25307,map__25307__$1,rezoom_QMARK_))
;
var feature_layer = L.geoJson(cljs.core.clj__GT_js(geojson),{"onEachFeature": on_events, "pointToLayer": point__GT_marker, "style": stylefn});
var ids = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__25307,map__25307__$1,rezoom_QMARK_){
return (function (p1__25301_SHARP_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__25301_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$properties,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id)], null));
});})(on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__25307,map__25307__$1,rezoom_QMARK_))
,cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson));
var markers = feature_layer.getLayers();
if(cljs.core.seq(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson))){
if(cljs.core.truth_(rezoom_QMARK_)){
m.fitBounds(feature_layer.getBounds());
} else {
}

feature_layer.addTo(m);
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$feature_DASH_layer,feature_layer,cljs.core.cst$kw$markers,markers,cljs.core.cst$kw$id_DASH__GT_marker,cljs.core.zipmap(ids,markers)], null);
});

hatti.map.utils.load_geo_json.cljs$lang$maxFixedArity = (3);

hatti.map.utils.load_geo_json.cljs$lang$applyTo = (function (seq25302){
var G__25303 = cljs.core.first(seq25302);
var seq25302__$1 = cljs.core.next(seq25302);
var G__25304 = cljs.core.first(seq25302__$1);
var seq25302__$2 = cljs.core.next(seq25302__$1);
var G__25305 = cljs.core.first(seq25302__$2);
var seq25302__$3 = cljs.core.next(seq25302__$2);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic(G__25303,G__25304,G__25305,seq25302__$3);
});
