// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var extra_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"full-name","full-name",408178550),hatti.constants._id,new cljs.core.Keyword(null,"label","label",1718410804),"id",new cljs.core.Keyword(null,"name","name",1843675177),hatti.constants._id,new cljs.core.Keyword(null,"type","type",1174270348),"integer"], null)], null);
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
return extra_field;
} else {
return cljs.core.conj.call(null,extra_field,hatti.ona.forms.submission_time_field);
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__5634__auto__ = [];
var len__5627__auto___10823 = arguments.length;
var i__5628__auto___10824 = (0);
while(true){
if((i__5628__auto___10824 < len__5627__auto___10823)){
args__5634__auto__.push((arguments[i__5628__auto___10824]));

var G__10825 = (i__5628__auto___10824 + (1));
i__5628__auto___10824 = G__10825;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__10820){
var map__10821 = p__10820;
var map__10821__$1 = ((((!((map__10821 == null)))?((((map__10821.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10821.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10821):map__10821);
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__10821__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
return cljs.core.distinct.call(null,cljs.core.filter.call(null,hatti.ona.forms.has_data_QMARK_,cljs.core.concat.call(null,hatti.views.table.get_extra_fields.call(null,is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields.call(null,form),hatti.ona.forms.meta_fields.call(null,form,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549),cljs.core.not.call(null,is_filtered_dataview_QMARK_)))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq10818){
var G__10819 = cljs.core.first.call(null,seq10818);
var seq10818__$1 = cljs.core.next.call(null,seq10818);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__10819,seq10818__$1);
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__10826_SHARP_){
if(typeof p1__10826_SHARP_ === 'string'){
return clojure.string.lower_case.call(null,p1__10826_SHARP_);
} else {
return p1__10826_SHARP_;
}
});})(col))
;
var aval = lower.call(null,(a[(col["field"])]));
var bval = lower.call(null,(b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not.call(null,args)){
return true;
} else {
var indexed_form = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550),form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__10830){
var vec__10831 = p__10830;
var fname = cljs.core.nth.call(null,vec__10831,(0),null);
var answer = cljs.core.nth.call(null,vec__10831,(1),null);
return hatti.ona.forms.format_answer.call(null,cljs.core.get.call(null,indexed_form,fname),answer,null,true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,((function (indexed_form,query,fmt_subitem){
return (function (p1__10827_SHARP_){
return cljs.core.re_find.call(null,hatti.utils.safe_regex.call(null,query),[cljs.core.str(p1__10827_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.call(null,fmt_subitem,cljs.core.js__GT_clj.call(null,item))));
return cljs.core.seq.call(null,filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.call(null,value,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return hatti.ona.forms.format_answer.call(null,field,clj_value,language,true);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args10832 = [];
var len__5627__auto___10854 = arguments.length;
var i__5628__auto___10855 = (0);
while(true){
if((i__5628__auto___10855 < len__5627__auto___10854)){
args10832.push((arguments[i__5628__auto___10855]));

var G__10856 = (i__5628__auto___10855 + (1));
i__5628__auto___10855 = G__10856;
continue;
} else {
}
break;
}

var G__10838 = args10832.length;
switch (G__10838) {
case 1:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args10832.slice((3)),(0)));
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1 = (function (form){
return hatti.views.table.flat_form__GT_sg_columns.call(null,form,true);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2 = (function (form,get_label_QMARK_){
return hatti.views.table.flat_form__GT_sg_columns.call(null,form,get_label_QMARK_,null);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,get_label_QMARK_,language,p__10839){
var map__10840 = p__10839;
var map__10840__$1 = ((((!((map__10840 == null)))?((((map__10840.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10840.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10840):map__10840);
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__10840__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
return cljs.core.clj__GT_js.call(null,(function (){var iter__5341__auto__ = ((function (map__10840,map__10840__$1,is_filtered_dataview_QMARK_){
return (function hatti$views$table$iter__10842(s__10843){
return (new cljs.core.LazySeq(null,((function (map__10840,map__10840__$1,is_filtered_dataview_QMARK_){
return (function (){
var s__10843__$1 = s__10843;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__10843__$1);
if(temp__4425__auto__){
var s__10843__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__10843__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__10843__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__10845 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__10844 = (0);
while(true){
if((i__10844 < size__5340__auto__)){
var field = cljs.core._nth.call(null,c__5339__auto__,i__10844);
cljs.core.chunk_append.call(null,b__10845,(function (){var map__10850 = field;
var map__10850__$1 = ((((!((map__10850 == null)))?((((map__10850.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10850.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10850):map__10850);
var name = cljs.core.get.call(null,map__10850__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__10850__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__10850__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hatti.ona.forms.get_column_class.call(null,field),label,cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class.call(null,field),label]);
})());

var G__10858 = (i__10844 + (1));
i__10844 = G__10858;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__10845),hatti$views$table$iter__10842.call(null,cljs.core.chunk_rest.call(null,s__10843__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__10845),null);
}
} else {
var field = cljs.core.first.call(null,s__10843__$2);
return cljs.core.cons.call(null,(function (){var map__10852 = field;
var map__10852__$1 = ((((!((map__10852 == null)))?((((map__10852.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10852.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10852):map__10852);
var name = cljs.core.get.call(null,map__10852__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__10852__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__10852__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hatti.ona.forms.get_column_class.call(null,field),label,cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class.call(null,field),label]);
})(),hatti$views$table$iter__10842.call(null,cljs.core.rest.call(null,s__10843__$2)));
}
} else {
return null;
}
break;
}
});})(map__10840,map__10840__$1,is_filtered_dataview_QMARK_))
,null,null));
});})(map__10840,map__10840__$1,is_filtered_dataview_QMARK_))
;
return iter__5341__auto__.call(null,hatti.views.table.all_fields.call(null,form,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_));
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq10833){
var G__10834 = cljs.core.first.call(null,seq10833);
var seq10833__$1 = cljs.core.next.call(null,seq10833);
var G__10835 = cljs.core.first.call(null,seq10833__$1);
var seq10833__$2 = cljs.core.next.call(null,seq10833__$1);
var G__10836 = cljs.core.first.call(null,seq10833__$2);
var seq10833__$3 = cljs.core.next.call(null,seq10833__$2);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__10834,G__10835,G__10836,seq10833__$3);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (3);
hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,jQuery([cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join(''))));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = {"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": true};
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__10867(s__10868){
return (new cljs.core.LazySeq(null,(function (){
var s__10868__$1 = s__10868;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__10868__$1);
if(temp__4425__auto__){
var s__10868__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__10868__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__10868__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__10870 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__10869 = (0);
while(true){
if((i__10869 < size__5340__auto__)){
var vec__10873 = cljs.core._nth.call(null,c__5339__auto__,i__10869);
var handler_key = cljs.core.nth.call(null,vec__10873,(0),null);
var handler_function = cljs.core.nth.call(null,vec__10873,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append.call(null,b__10870,event.subscribe(handler_function));

var G__10875 = (i__10869 + (1));
i__10869 = G__10875;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__10870),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__10867.call(null,cljs.core.chunk_rest.call(null,s__10868__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__10870),null);
}
} else {
var vec__10874 = cljs.core.first.call(null,s__10868__$2);
var handler_key = cljs.core.nth.call(null,vec__10874,(0),null);
var handler_function = cljs.core.nth.call(null,vec__10874,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__10867.call(null,cljs.core.rest.call(null,s__10868__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__10884(s__10885){
return (new cljs.core.LazySeq(null,(function (){
var s__10885__$1 = s__10885;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__10885__$1);
if(temp__4425__auto__){
var s__10885__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__10885__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__10885__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__10887 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__10886 = (0);
while(true){
if((i__10886 < size__5340__auto__)){
var vec__10890 = cljs.core._nth.call(null,c__5339__auto__,i__10886);
var handler_key = cljs.core.nth.call(null,vec__10890,(0),null);
var handler_function = cljs.core.nth.call(null,vec__10890,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append.call(null,b__10887,event.subscribe(handler_function));

var G__10892 = (i__10886 + (1));
i__10886 = G__10892;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__10887),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__10884.call(null,cljs.core.chunk_rest.call(null,s__10885__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__10887),null);
}
} else {
var vec__10891 = cljs.core.first.call(null,s__10885__$2);
var handler_key = cljs.core.nth.call(null,vec__10891,(0),null);
var handler_function = cljs.core.nth.call(null,vec__10891,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__10884.call(null,cljs.core.rest.call(null,s__10885__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,p__10893){
var map__10902 = p__10893;
var map__10902__$1 = ((((!((map__10902 == null)))?((((map__10902.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10902.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10902):map__10902);
var grid_event_handlers = cljs.core.get.call(null,map__10902__$1,new cljs.core.Keyword(null,"grid-event-handlers","grid-event-handlers",1413592355));
var dataview_event_handlers = cljs.core.get.call(null,map__10902__$1,new cljs.core.Keyword(null,"dataview-event-handlers","dataview-event-handlers",-916375885));
var columns = hatti.views.table.flat_form__GT_sg_columns.call(null,form,true,current_language,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_);
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
var map__10904 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__10904__$1 = ((((!((map__10904 == null)))?((((map__10904.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10904.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10904):map__10904);
var map__10905 = cljs.core.get.call(null,map__10904__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__10905__$1 = ((((!((map__10905 == null)))?((((map__10905.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10905.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10905):map__10905);
var map__10906 = cljs.core.get.call(null,map__10905__$1,new cljs.core.Keyword(null,"paging","paging",1716279728));
var map__10906__$1 = ((((!((map__10906 == null)))?((((map__10906.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10906.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10906):map__10906);
var num_displayed_records = cljs.core.get.call(null,map__10906__$1,new cljs.core.Keyword(null,"num-displayed-records","num-displayed-records",213046400));
var total_page_count = cljs.core.get.call(null,map__10906__$1,new cljs.core.Keyword(null,"total-page-count","total-page-count",582341740));
hatti.views.table.bind_external_sg_grid_event_handlers.call(null,grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers.call(null,dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__10904,map__10904__$1,map__10905,map__10905__$1,map__10906,map__10906__$1,num_displayed_records,total_page_count,map__10902,map__10902__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__10904,map__10904__$1,map__10905,map__10905__$1,map__10906,map__10906__$1,num_displayed_records,total_page_count,map__10902,map__10902__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__10904,map__10904__$1,map__10905,map__10905__$1,map__10906,map__10906__$1,num_displayed_records,total_page_count,map__10902,map__10902__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__10904,map__10904__$1,map__10905,map__10905__$1,map__10906,map__10906__$1,num_displayed_records,total_page_count,map__10902,map__10902__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__10904,map__10904__$1,map__10905,map__10905__$1,map__10906,map__10906__$1,num_displayed_records,total_page_count,map__10902,map__10902__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
});})(columns,SlickGrid,DataView,dataview,grid,map__10904,map__10904__$1,map__10905,map__10905__$1,map__10906,map__10906__$1,num_displayed_records,total_page_count,map__10902,map__10902__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager.call(null,grid,dataview);

dataview.setPagingOptions({"pageSize": (function (){var or__4569__auto__ = num_displayed_records;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count});

dataview.setFilter(cljs.core.partial.call(null,hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js.call(null,data),hatti.constants._id);

hatti.views.table.resizeColumns.call(null,grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap.call(null);
var c__7694__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto__,event_chan){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto__,event_chan){
return (function (state_11171){
var state_val_11172 = (state_11171[(1)]);
if((state_val_11172 === (7))){
var inst_11080 = (state_11171[(7)]);
var inst_11080__$1 = (state_11171[(2)]);
var inst_11082 = (inst_11080__$1 == null);
var inst_11083 = cljs.core.not.call(null,inst_11082);
var state_11171__$1 = (function (){var statearr_11173 = state_11171;
(statearr_11173[(7)] = inst_11080__$1);

return statearr_11173;
})();
if(inst_11083){
var statearr_11174_11241 = state_11171__$1;
(statearr_11174_11241[(1)] = (8));

} else {
var statearr_11175_11242 = state_11171__$1;
(statearr_11175_11242[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (20))){
var inst_11110 = (state_11171[(8)]);
var inst_11102 = (state_11171[(9)]);
var inst_11119 = inst_11110.call(null,inst_11102);
var state_11171__$1 = state_11171;
var statearr_11176_11243 = state_11171__$1;
(statearr_11176_11243[(2)] = inst_11119);

(statearr_11176_11243[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (27))){
var state_11171__$1 = state_11171;
var statearr_11177_11244 = state_11171__$1;
(statearr_11177_11244[(2)] = null);

(statearr_11177_11244[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (1))){
var state_11171__$1 = state_11171;
var statearr_11178_11245 = state_11171__$1;
(statearr_11178_11245[(2)] = null);

(statearr_11178_11245[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (24))){
var state_11171__$1 = state_11171;
var statearr_11179_11246 = state_11171__$1;
(statearr_11179_11246[(2)] = null);

(statearr_11179_11246[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (4))){
var state_11171__$1 = state_11171;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11171__$1,(7),event_chan);
} else {
if((state_val_11172 === (15))){
var inst_11080 = (state_11171[(7)]);
var state_11171__$1 = state_11171;
var statearr_11180_11247 = state_11171__$1;
(statearr_11180_11247[(2)] = inst_11080);

(statearr_11180_11247[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (21))){
var state_11171__$1 = state_11171;
var statearr_11181_11248 = state_11171__$1;
(statearr_11181_11248[(2)] = null);

(statearr_11181_11248[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (31))){
var inst_11106 = (state_11171[(10)]);
var inst_11144 = (state_11171[(2)]);
var inst_11145 = cljs.core._EQ_.call(null,inst_11106,new cljs.core.Keyword(null,"table","table",-564943036));
var state_11171__$1 = (function (){var statearr_11182 = state_11171;
(statearr_11182[(11)] = inst_11144);

return statearr_11182;
})();
if(inst_11145){
var statearr_11183_11249 = state_11171__$1;
(statearr_11183_11249[(1)] = (32));

} else {
var statearr_11184_11250 = state_11171__$1;
(statearr_11184_11250[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (32))){
var inst_11111 = (state_11171[(12)]);
var inst_11080 = (state_11171[(7)]);
var inst_11103 = (state_11171[(13)]);
var inst_11110 = (state_11171[(8)]);
var inst_11101 = (state_11171[(14)]);
var inst_11100 = (state_11171[(15)]);
var inst_11102 = (state_11171[(9)]);
var inst_11105 = (state_11171[(16)]);
var inst_11106 = (state_11171[(10)]);
var inst_11104 = (state_11171[(17)]);
var inst_11158 = cljs.core.async.chan.call(null,(1));
var inst_11159 = (function (){var new_columns = inst_11105;
var submission_clicked = inst_11102;
var submission_unclicked = inst_11103;
var get_submission_data = inst_11111;
var map__11078 = inst_11100;
var re_render = inst_11106;
var update_data_BANG_ = inst_11110;
var c__7694__auto____$1 = inst_11158;
var submission_to_rank = inst_11101;
var e = inst_11080;
var filter_by = inst_11104;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,map__11078,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,filter_by,inst_11111,inst_11080,inst_11103,inst_11110,inst_11101,inst_11100,inst_11102,inst_11105,inst_11106,inst_11104,inst_11158,state_val_11172,c__7694__auto__,event_chan){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,map__11078,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,filter_by,inst_11111,inst_11080,inst_11103,inst_11110,inst_11101,inst_11100,inst_11102,inst_11105,inst_11106,inst_11104,inst_11158,state_val_11172,c__7694__auto__,event_chan){
return (function (state_11156){
var state_val_11157 = (state_11156[(1)]);
if((state_val_11157 === (1))){
var inst_11147 = cljs.core.async.timeout.call(null,(20));
var state_11156__$1 = state_11156;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11156__$1,(2),inst_11147);
} else {
if((state_val_11157 === (2))){
var inst_11149 = (state_11156[(2)]);
var inst_11150 = grid.resizeCanvas();
var inst_11151 = grid.invalidateAllRows();
var inst_11152 = hatti.views.table.resizeColumns.call(null,grid);
var inst_11153 = grid.render();
var inst_11154 = hatti.views.table.init_sg_pager.call(null,grid,dataview);
var state_11156__$1 = (function (){var statearr_11185 = state_11156;
(statearr_11185[(7)] = inst_11150);

(statearr_11185[(8)] = inst_11152);

(statearr_11185[(9)] = inst_11149);

(statearr_11185[(10)] = inst_11151);

(statearr_11185[(11)] = inst_11153);

return statearr_11185;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11156__$1,inst_11154);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,map__11078,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,filter_by,inst_11111,inst_11080,inst_11103,inst_11110,inst_11101,inst_11100,inst_11102,inst_11105,inst_11106,inst_11104,inst_11158,state_val_11172,c__7694__auto__,event_chan))
;
return ((function (switch__7673__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,map__11078,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,filter_by,inst_11111,inst_11080,inst_11103,inst_11110,inst_11101,inst_11100,inst_11102,inst_11105,inst_11106,inst_11104,inst_11158,state_val_11172,c__7694__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__7674__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__7674__auto____0 = (function (){
var statearr_11189 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11189[(0)] = hatti$views$table$handle_table_events_$_state_machine__7674__auto__);

(statearr_11189[(1)] = (1));

return statearr_11189;
});
var hatti$views$table$handle_table_events_$_state_machine__7674__auto____1 = (function (state_11156){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_11156);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e11190){if((e11190 instanceof Object)){
var ex__7677__auto__ = e11190;
var statearr_11191_11251 = state_11156;
(statearr_11191_11251[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11156);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11190;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11252 = state_11156;
state_11156 = G__11252;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__7674__auto__ = function(state_11156){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__7674__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__7674__auto____1.call(this,state_11156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__7674__auto____0;
hatti$views$table$handle_table_events_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__7674__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,map__11078,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,filter_by,inst_11111,inst_11080,inst_11103,inst_11110,inst_11101,inst_11100,inst_11102,inst_11105,inst_11106,inst_11104,inst_11158,state_val_11172,c__7694__auto__,event_chan))
})();
var state__7696__auto__ = (function (){var statearr_11192 = f__7695__auto__.call(null);
(statearr_11192[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto____$1);

return statearr_11192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,map__11078,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,filter_by,inst_11111,inst_11080,inst_11103,inst_11110,inst_11101,inst_11100,inst_11102,inst_11105,inst_11106,inst_11104,inst_11158,state_val_11172,c__7694__auto__,event_chan))
})();
var inst_11160 = cljs.core.async.impl.dispatch.run.call(null,inst_11159);
var state_11171__$1 = (function (){var statearr_11193 = state_11171;
(statearr_11193[(18)] = inst_11160);

return statearr_11193;
})();
var statearr_11194_11253 = state_11171__$1;
(statearr_11194_11253[(2)] = inst_11158);

(statearr_11194_11253[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (33))){
var state_11171__$1 = state_11171;
var statearr_11195_11254 = state_11171__$1;
(statearr_11195_11254[(2)] = null);

(statearr_11195_11254[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (13))){
var inst_11092 = (state_11171[(2)]);
var state_11171__$1 = state_11171;
var statearr_11196_11255 = state_11171__$1;
(statearr_11196_11255[(2)] = inst_11092);

(statearr_11196_11255[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (22))){
var inst_11103 = (state_11171[(13)]);
var inst_11122 = (state_11171[(2)]);
var state_11171__$1 = (function (){var statearr_11197 = state_11171;
(statearr_11197[(19)] = inst_11122);

return statearr_11197;
})();
if(cljs.core.truth_(inst_11103)){
var statearr_11198_11256 = state_11171__$1;
(statearr_11198_11256[(1)] = (23));

} else {
var statearr_11199_11257 = state_11171__$1;
(statearr_11199_11257[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (29))){
var inst_11104 = (state_11171[(17)]);
var inst_11136 = [new cljs.core.Keyword(null,"query","query",-1288509510)];
var inst_11137 = [inst_11104];
var inst_11138 = cljs.core.PersistentHashMap.fromArrays(inst_11136,inst_11137);
var inst_11139 = cljs.core.clj__GT_js.call(null,inst_11138);
var inst_11140 = dataview.setFilterArgs(inst_11139);
var inst_11141 = dataview.refresh();
var state_11171__$1 = (function (){var statearr_11200 = state_11171;
(statearr_11200[(20)] = inst_11140);

return statearr_11200;
})();
var statearr_11201_11258 = state_11171__$1;
(statearr_11201_11258[(2)] = inst_11141);

(statearr_11201_11258[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (6))){
var inst_11167 = (state_11171[(2)]);
var state_11171__$1 = state_11171;
var statearr_11202_11259 = state_11171__$1;
(statearr_11202_11259[(2)] = inst_11167);

(statearr_11202_11259[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (28))){
var inst_11104 = (state_11171[(17)]);
var inst_11134 = (state_11171[(2)]);
var state_11171__$1 = (function (){var statearr_11203 = state_11171;
(statearr_11203[(21)] = inst_11134);

return statearr_11203;
})();
if(cljs.core.truth_(inst_11104)){
var statearr_11204_11260 = state_11171__$1;
(statearr_11204_11260[(1)] = (29));

} else {
var statearr_11205_11261 = state_11171__$1;
(statearr_11205_11261[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (25))){
var inst_11105 = (state_11171[(16)]);
var inst_11127 = (state_11171[(2)]);
var state_11171__$1 = (function (){var statearr_11206 = state_11171;
(statearr_11206[(22)] = inst_11127);

return statearr_11206;
})();
if(cljs.core.truth_(inst_11105)){
var statearr_11207_11262 = state_11171__$1;
(statearr_11207_11262[(1)] = (26));

} else {
var statearr_11208_11263 = state_11171__$1;
(statearr_11208_11263[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (34))){
var inst_11163 = (state_11171[(2)]);
var state_11171__$1 = (function (){var statearr_11209 = state_11171;
(statearr_11209[(23)] = inst_11163);

return statearr_11209;
})();
var statearr_11210_11264 = state_11171__$1;
(statearr_11210_11264[(2)] = null);

(statearr_11210_11264[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (17))){
var inst_11111 = (state_11171[(12)]);
var inst_11110 = (state_11171[(8)]);
var inst_11101 = (state_11171[(14)]);
var inst_11113 = inst_11111.call(null,hatti.constants._rank,inst_11101);
var inst_11114 = inst_11110.call(null,inst_11113);
var state_11171__$1 = state_11171;
var statearr_11211_11265 = state_11171__$1;
(statearr_11211_11265[(2)] = inst_11114);

(statearr_11211_11265[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (3))){
var inst_11169 = (state_11171[(2)]);
var state_11171__$1 = state_11171;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11171__$1,inst_11169);
} else {
if((state_val_11172 === (12))){
var state_11171__$1 = state_11171;
var statearr_11212_11266 = state_11171__$1;
(statearr_11212_11266[(2)] = false);

(statearr_11212_11266[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (2))){
var state_11171__$1 = state_11171;
var statearr_11213_11267 = state_11171__$1;
(statearr_11213_11267[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (23))){
var inst_11110 = (state_11171[(8)]);
var inst_11124 = inst_11110.call(null,null);
var state_11171__$1 = state_11171;
var statearr_11215_11268 = state_11171__$1;
(statearr_11215_11268[(2)] = inst_11124);

(statearr_11215_11268[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (19))){
var inst_11102 = (state_11171[(9)]);
var inst_11117 = (state_11171[(2)]);
var state_11171__$1 = (function (){var statearr_11216 = state_11171;
(statearr_11216[(24)] = inst_11117);

return statearr_11216;
})();
if(cljs.core.truth_(inst_11102)){
var statearr_11217_11269 = state_11171__$1;
(statearr_11217_11269[(1)] = (20));

} else {
var statearr_11218_11270 = state_11171__$1;
(statearr_11218_11270[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (11))){
var state_11171__$1 = state_11171;
var statearr_11219_11271 = state_11171__$1;
(statearr_11219_11271[(2)] = true);

(statearr_11219_11271[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (9))){
var state_11171__$1 = state_11171;
var statearr_11220_11272 = state_11171__$1;
(statearr_11220_11272[(2)] = false);

(statearr_11220_11272[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (5))){
var state_11171__$1 = state_11171;
var statearr_11221_11273 = state_11171__$1;
(statearr_11221_11273[(2)] = null);

(statearr_11221_11273[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (14))){
var inst_11080 = (state_11171[(7)]);
var inst_11097 = cljs.core.apply.call(null,cljs.core.hash_map,inst_11080);
var state_11171__$1 = state_11171;
var statearr_11222_11274 = state_11171__$1;
(statearr_11222_11274[(2)] = inst_11097);

(statearr_11222_11274[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (26))){
var inst_11105 = (state_11171[(16)]);
var inst_11129 = grid.setColumns(inst_11105);
var inst_11130 = hatti.views.table.resizeColumns.call(null,grid);
var inst_11131 = grid.render();
var state_11171__$1 = (function (){var statearr_11223 = state_11171;
(statearr_11223[(25)] = inst_11129);

(statearr_11223[(26)] = inst_11130);

return statearr_11223;
})();
var statearr_11224_11275 = state_11171__$1;
(statearr_11224_11275[(2)] = inst_11131);

(statearr_11224_11275[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (16))){
var inst_11080 = (state_11171[(7)]);
var inst_11103 = (state_11171[(13)]);
var inst_11110 = (state_11171[(8)]);
var inst_11101 = (state_11171[(14)]);
var inst_11100 = (state_11171[(15)]);
var inst_11102 = (state_11171[(9)]);
var inst_11105 = (state_11171[(16)]);
var inst_11106 = (state_11171[(10)]);
var inst_11104 = (state_11171[(17)]);
var inst_11100__$1 = (state_11171[(2)]);
var inst_11101__$1 = cljs.core.get.call(null,inst_11100__$1,new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797));
var inst_11102__$1 = cljs.core.get.call(null,inst_11100__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var inst_11103__$1 = cljs.core.get.call(null,inst_11100__$1,new cljs.core.Keyword(null,"submission-unclicked","submission-unclicked",-2099539520));
var inst_11104__$1 = cljs.core.get.call(null,inst_11100__$1,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
var inst_11105__$1 = cljs.core.get.call(null,inst_11100__$1,new cljs.core.Keyword(null,"new-columns","new-columns",-887765797));
var inst_11106__$1 = cljs.core.get.call(null,inst_11100__$1,new cljs.core.Keyword(null,"re-render","re-render",1133553258));
var inst_11107 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11108 = [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.Keyword(null,"data","data",-232669377)];
var inst_11109 = (new cljs.core.PersistentVector(null,3,(5),inst_11107,inst_11108,null));
var inst_11110__$1 = cljs.core.partial.call(null,om.core.update_BANG_,app_state,inst_11109);
var inst_11111 = (function (){var e = inst_11080;
var map__11078 = inst_11100__$1;
var submission_to_rank = inst_11101__$1;
var submission_clicked = inst_11102__$1;
var submission_unclicked = inst_11103__$1;
var filter_by = inst_11104__$1;
var new_columns = inst_11105__$1;
var re_render = inst_11106__$1;
var update_data_BANG_ = inst_11110__$1;
return ((function (e,map__11078,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_11080,inst_11103,inst_11110,inst_11101,inst_11100,inst_11102,inst_11105,inst_11106,inst_11104,inst_11100__$1,inst_11101__$1,inst_11102__$1,inst_11103__$1,inst_11104__$1,inst_11105__$1,inst_11106__$1,inst_11107,inst_11108,inst_11109,inst_11110__$1,state_val_11172,c__7694__auto__,event_chan){
return (function (field,value){
return cljs.core.first.call(null,cljs.core.filter.call(null,((function (e,map__11078,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_11080,inst_11103,inst_11110,inst_11101,inst_11100,inst_11102,inst_11105,inst_11106,inst_11104,inst_11100__$1,inst_11101__$1,inst_11102__$1,inst_11103__$1,inst_11104__$1,inst_11105__$1,inst_11106__$1,inst_11107,inst_11108,inst_11109,inst_11110__$1,state_val_11172,c__7694__auto__,event_chan){
return (function (p1__10910_SHARP_){
return cljs.core._EQ_.call(null,value,cljs.core.get.call(null,p1__10910_SHARP_,field));
});})(e,map__11078,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_11080,inst_11103,inst_11110,inst_11101,inst_11100,inst_11102,inst_11105,inst_11106,inst_11104,inst_11100__$1,inst_11101__$1,inst_11102__$1,inst_11103__$1,inst_11104__$1,inst_11105__$1,inst_11106__$1,inst_11107,inst_11108,inst_11109,inst_11110__$1,state_val_11172,c__7694__auto__,event_chan))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,app_state),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null))));
});
;})(e,map__11078,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_11080,inst_11103,inst_11110,inst_11101,inst_11100,inst_11102,inst_11105,inst_11106,inst_11104,inst_11100__$1,inst_11101__$1,inst_11102__$1,inst_11103__$1,inst_11104__$1,inst_11105__$1,inst_11106__$1,inst_11107,inst_11108,inst_11109,inst_11110__$1,state_val_11172,c__7694__auto__,event_chan))
})();
var state_11171__$1 = (function (){var statearr_11225 = state_11171;
(statearr_11225[(12)] = inst_11111);

(statearr_11225[(13)] = inst_11103__$1);

(statearr_11225[(8)] = inst_11110__$1);

(statearr_11225[(14)] = inst_11101__$1);

(statearr_11225[(15)] = inst_11100__$1);

(statearr_11225[(9)] = inst_11102__$1);

(statearr_11225[(16)] = inst_11105__$1);

(statearr_11225[(10)] = inst_11106__$1);

(statearr_11225[(17)] = inst_11104__$1);

return statearr_11225;
})();
if(cljs.core.truth_(inst_11101__$1)){
var statearr_11226_11276 = state_11171__$1;
(statearr_11226_11276[(1)] = (17));

} else {
var statearr_11227_11277 = state_11171__$1;
(statearr_11227_11277[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (30))){
var state_11171__$1 = state_11171;
var statearr_11228_11278 = state_11171__$1;
(statearr_11228_11278[(2)] = null);

(statearr_11228_11278[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (10))){
var inst_11095 = (state_11171[(2)]);
var state_11171__$1 = state_11171;
if(cljs.core.truth_(inst_11095)){
var statearr_11229_11279 = state_11171__$1;
(statearr_11229_11279[(1)] = (14));

} else {
var statearr_11230_11280 = state_11171__$1;
(statearr_11230_11280[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (18))){
var state_11171__$1 = state_11171;
var statearr_11231_11281 = state_11171__$1;
(statearr_11231_11281[(2)] = null);

(statearr_11231_11281[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11172 === (8))){
var inst_11080 = (state_11171[(7)]);
var inst_11085 = inst_11080.cljs$lang$protocol_mask$partition0$;
var inst_11086 = (inst_11085 & (64));
var inst_11087 = inst_11080.cljs$core$ISeq$;
var inst_11088 = (inst_11086) || (inst_11087);
var state_11171__$1 = state_11171;
if(cljs.core.truth_(inst_11088)){
var statearr_11232_11282 = state_11171__$1;
(statearr_11232_11282[(1)] = (11));

} else {
var statearr_11233_11283 = state_11171__$1;
(statearr_11233_11283[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto__,event_chan))
;
return ((function (switch__7673__auto__,c__7694__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__7674__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__7674__auto____0 = (function (){
var statearr_11237 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11237[(0)] = hatti$views$table$handle_table_events_$_state_machine__7674__auto__);

(statearr_11237[(1)] = (1));

return statearr_11237;
});
var hatti$views$table$handle_table_events_$_state_machine__7674__auto____1 = (function (state_11171){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_11171);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e11238){if((e11238 instanceof Object)){
var ex__7677__auto__ = e11238;
var statearr_11239_11284 = state_11171;
(statearr_11239_11284[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11171);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11238;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11285 = state_11171;
state_11171 = G__11285;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__7674__auto__ = function(state_11171){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__7674__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__7674__auto____1.call(this,state_11171);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__7674__auto____0;
hatti$views$table$handle_table_events_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__7674__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto__,event_chan))
})();
var state__7696__auto__ = (function (){var statearr_11240 = f__7695__auto__.call(null);
(statearr_11240[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto__);

return statearr_11240;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto__,event_chan))
);

return c__7694__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),k);

return colset_BANG_.call(null,k);
});
var iter__5341__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__11294(s__11295){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__11295__$1 = s__11295;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__11295__$1);
if(temp__4425__auto__){
var s__11295__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11295__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__11295__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__11297 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__11296 = (0);
while(true){
if((i__11296 < size__5340__auto__)){
var vec__11300 = cljs.core._nth.call(null,c__5339__auto__,i__11296);
var k = cljs.core.nth.call(null,vec__11300,(0),null);
var v = cljs.core.nth.call(null,vec__11300,(1),null);
cljs.core.chunk_append.call(null,b__11297,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (i__11296,vec__11300,k,v,c__5339__auto__,size__5340__auto__,b__11297,s__11295__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(i__11296,vec__11300,k,v,c__5339__auto__,size__5340__auto__,b__11297,s__11295__$2,temp__4425__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null));

var G__11302 = (i__11296 + (1));
i__11296 = G__11302;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11297),hatti$views$table$render_options_$_iter__11294.call(null,cljs.core.chunk_rest.call(null,s__11295__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11297),null);
}
} else {
var vec__11301 = cljs.core.first.call(null,s__11295__$2);
var k = cljs.core.nth.call(null,vec__11301,(0),null);
var v = cljs.core.nth.call(null,vec__11301,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (vec__11301,k,v,s__11295__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(vec__11301,k,v,s__11295__$2,temp__4425__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__11294.call(null,cljs.core.rest.call(null,s__11295__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__5341__auto__.call(null,options);
});
cljs.core._add_method.call(null,hatti.views.label_changer,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table11304 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table11304 = (function (_,owner,meta11305){
this._ = _;
this.owner = owner;
this.meta11305 = meta11305;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table11304.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11306,meta11305__$1){
var self__ = this;
var _11306__$1 = this;
return (new hatti.views.table.t_hatti$views$table11304(self__._,self__.owner,meta11305__$1));
});

hatti.views.table.t_hatti$views$table11304.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11306){
var self__ = this;
var _11306__$1 = this;
return self__.meta11305;
});

hatti.views.table.t_hatti$views$table11304.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table11304.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),new cljs.core.Keyword(null,"label","label",1718410804)], null);
});

hatti.views.table.t_hatti$views$table11304.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table11304.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__11307){
var self__ = this;
var map__11308 = p__11307;
var map__11308__$1 = ((((!((map__11308 == null)))?((((map__11308.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11308.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11308):map__11308);
var name_or_label = cljs.core.get.call(null,map__11308__$1,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208));
var language = cljs.core.get.call(null,map__11308__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Label"], null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Name"], null)], null);
var map__11310 = om.core.get_shared.call(null,self__.owner);
var map__11310__$1 = ((((!((map__11310 == null)))?((((map__11310.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11310.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11310):map__11310);
var flat_form = cljs.core.get.call(null,map__11310__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var new_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null)));
var colset_BANG_ = ((function (options,map__11310,map__11310__$1,flat_form,new_language,___$2,map__11308,map__11308__$1,name_or_label,language){
return (function (p1__11303_SHARP_){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-columns","new-columns",-887765797),hatti.views.table.flat_form__GT_sg_columns.call(null,flat_form,cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"label","label",1718410804),p1__11303_SHARP_),new_language)], null));
});})(options,map__11310,map__11310__$1,flat_form,new_language,___$2,map__11308,map__11308__$1,name_or_label,language))
;
if(cljs.core.not_EQ_.call(null,new_language,language)){
om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"language","language",-1591107564),new_language);

colset_BANG_.call(null,name_or_label);
} else {
}

return React.DOM.div({"className": "label-changer"},React.DOM.span({"className": "label-changer-label"},"Show:"),React.DOM.div({"id": "header-display-dropdown", "className": "drop-hover"},(function (){var attrs11314 = options.call(null,name_or_label);
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs11314))?sablono.interpreter.attributes.call(null,attrs11314):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs11314))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [React.DOM.i({"className": "fa fa-angle-down"})], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs11314),React.DOM.i({"className": "fa fa-angle-down"})], null))));
})(),React.DOM.ul({"className": "submenu no-dot"},sablono.interpreter.interpret.call(null,hatti.views.table.render_options.call(null,options,self__.owner,colset_BANG_)))));
});

hatti.views.table.t_hatti$views$table11304.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta11305","meta11305",2132787387,null)], null);
});

hatti.views.table.t_hatti$views$table11304.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table11304.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table11304";

hatti.views.table.t_hatti$views$table11304.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table11304");
});

hatti.views.table.__GT_t_hatti$views$table11304 = (function hatti$views$table$__GT_t_hatti$views$table11304(___$1,owner__$1,meta11305){
return (new hatti.views.table.t_hatti$views$table11304(___$1,owner__$1,meta11305));
});

}

return (new hatti.views.table.t_hatti$views$table11304(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__7694__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto__,query){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto__,query){
return (function (state_11361){
var state_val_11362 = (state_11361[(1)]);
if((state_val_11362 === (1))){
var inst_11347 = cljs.core.async.timeout.call(null,(150));
var state_11361__$1 = state_11361;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11361__$1,(2),inst_11347);
} else {
if((state_val_11362 === (2))){
var inst_11349 = (state_11361[(2)]);
var inst_11350 = input.value;
var inst_11351 = cljs.core._EQ_.call(null,query,inst_11350);
var state_11361__$1 = (function (){var statearr_11363 = state_11361;
(statearr_11363[(7)] = inst_11349);

return statearr_11363;
})();
if(inst_11351){
var statearr_11364_11375 = state_11361__$1;
(statearr_11364_11375[(1)] = (3));

} else {
var statearr_11365_11376 = state_11361__$1;
(statearr_11365_11376[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11362 === (3))){
var inst_11353 = [query_event_key];
var inst_11354 = [query];
var inst_11355 = cljs.core.PersistentHashMap.fromArrays(inst_11353,inst_11354);
var inst_11356 = cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,inst_11355);
var state_11361__$1 = state_11361;
var statearr_11366_11377 = state_11361__$1;
(statearr_11366_11377[(2)] = inst_11356);

(statearr_11366_11377[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11362 === (4))){
var state_11361__$1 = state_11361;
var statearr_11367_11378 = state_11361__$1;
(statearr_11367_11378[(2)] = null);

(statearr_11367_11378[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11362 === (5))){
var inst_11359 = (state_11361[(2)]);
var state_11361__$1 = state_11361;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11361__$1,inst_11359);
} else {
return null;
}
}
}
}
}
});})(c__7694__auto__,query))
;
return ((function (switch__7673__auto__,c__7694__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__7674__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__7674__auto____0 = (function (){
var statearr_11371 = [null,null,null,null,null,null,null,null];
(statearr_11371[(0)] = hatti$views$table$delayed_search_$_state_machine__7674__auto__);

(statearr_11371[(1)] = (1));

return statearr_11371;
});
var hatti$views$table$delayed_search_$_state_machine__7674__auto____1 = (function (state_11361){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_11361);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e11372){if((e11372 instanceof Object)){
var ex__7677__auto__ = e11372;
var statearr_11373_11379 = state_11361;
(statearr_11373_11379[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11361);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11372;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11380 = state_11361;
state_11361 = G__11380;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__7674__auto__ = function(state_11361){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__7674__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__7674__auto____1.call(this,state_11361);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__7674__auto____0;
hatti$views$table$delayed_search_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__7674__auto____1;
return hatti$views$table$delayed_search_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto__,query))
})();
var state__7696__auto__ = (function (){var statearr_11374 = f__7695__auto__.call(null);
(statearr_11374[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto__);

return statearr_11374;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto__,query))
);

return c__7694__auto__;
});
cljs.core._add_method.call(null,hatti.views.table_search,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table11382 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table11382 = (function (_,owner,meta11383){
this._ = _;
this.owner = owner;
this.meta11383 = meta11383;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table11382.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11384,meta11383__$1){
var self__ = this;
var _11384__$1 = this;
return (new hatti.views.table.t_hatti$views$table11382(self__._,self__.owner,meta11383__$1));
});

hatti.views.table.t_hatti$views$table11382.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11384){
var self__ = this;
var _11384__$1 = this;
return self__.meta11383;
});

hatti.views.table.t_hatti$views$table11382.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table11382.prototype.om$core$IRender$render$arity$1 = (function (this__6323__auto__){
var self__ = this;
var this__6323__auto____$1 = this;
return React.DOM.div({"className": "table-search"},React.DOM.i({"className": "fa fa-search"}),sablono.interpreter.input.call(null,{"type": "text", "placeholder": "Search", "onChange": ((function (this__6323__auto____$1){
return (function (p1__11381_SHARP_){
return hatti.views.table.delayed_search.call(null,p1__11381_SHARP_.target,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
});})(this__6323__auto____$1))
}));
});

hatti.views.table.t_hatti$views$table11382.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta11383","meta11383",16012416,null)], null);
});

hatti.views.table.t_hatti$views$table11382.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table11382.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table11382";

hatti.views.table.t_hatti$views$table11382.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table11382");
});

hatti.views.table.__GT_t_hatti$views$table11382 = (function hatti$views$table$__GT_t_hatti$views$table11382(___$1,owner__$1,meta11383){
return (new hatti.views.table.t_hatti$views$table11382(___$1,owner__$1,meta11383));
});

}

return (new hatti.views.table.t_hatti$views$table11382(_,owner,null));
}));
cljs.core._add_method.call(null,hatti.views.table_header,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app_state,owner){
if(typeof hatti.views.table.t_hatti$views$table11387 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table11387 = (function (app_state,owner,meta11388){
this.app_state = app_state;
this.owner = owner;
this.meta11388 = meta11388;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table11387.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11389,meta11388__$1){
var self__ = this;
var _11389__$1 = this;
return (new hatti.views.table.t_hatti$views$table11387(self__.app_state,self__.owner,meta11388__$1));
});

hatti.views.table.t_hatti$views$table11387.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11389){
var self__ = this;
var _11389__$1 = this;
return self__.meta11388;
});

hatti.views.table.t_hatti$views$table11387.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table11387.prototype.om$core$IRender$render$arity$1 = (function (this__6323__auto__){
var self__ = this;
var this__6323__auto____$1 = this;
return React.DOM.div({"className": "topbar"},React.DOM.div({"id": hatti.views.table.pager_id}),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.label_changer,null)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_search,self__.app_state)),React.DOM.div({"style": {"clear": "both"}}));
});

hatti.views.table.t_hatti$views$table11387.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta11388","meta11388",-1086518860,null)], null);
});

hatti.views.table.t_hatti$views$table11387.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table11387.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table11387";

hatti.views.table.t_hatti$views$table11387.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table11387");
});

hatti.views.table.__GT_t_hatti$views$table11387 = (function hatti$views$table$__GT_t_hatti$views$table11387(app_state__$1,owner__$1,meta11388){
return (new hatti.views.table.t_hatti$views$table11387(app_state__$1,owner__$1,meta11388));
});

}

return (new hatti.views.table.t_hatti$views$table11387(app_state,owner,null));
}));
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){

if(cljs.core.seq.call(null,data)){
var map__11395 = om.core.get_shared.call(null,owner);
var map__11395__$1 = ((((!((map__11395 == null)))?((((map__11395.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11395.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11395):map__11395);
var flat_form = cljs.core.get.call(null,map__11395__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__11395__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
var current_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,owner,hatti.shared.language_cursor.call(null)));
var vec__11396 = hatti.views.table.sg_init.call(null,data,flat_form,current_language,is_filtered_dataview_QMARK_,slick_grid_event_handlers);
var grid = cljs.core.nth.call(null,vec__11396,(0),null);
var dataview = cljs.core.nth.call(null,vec__11396,(1),null);
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"grid","grid",402978600),grid);

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"dataview","dataview",91765671),dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
cljs.core._add_method.call(null,hatti.views.table_page,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app_state,owner,p__11399){
var map__11400 = p__11399;
var map__11400__$1 = ((((!((map__11400 == null)))?((((map__11400.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11400.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11400):map__11400);
var opts = map__11400__$1;
var slick_grid_event_handlers = cljs.core.get.call(null,map__11400__$1,new cljs.core.Keyword(null,"slick-grid-event-handlers","slick-grid-event-handlers",1990034724));

if(typeof hatti.views.table.t_hatti$views$table11402 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table11402 = (function (app_state,owner,p__11399,map__11400,opts,slick_grid_event_handlers,meta11403){
this.app_state = app_state;
this.owner = owner;
this.p__11399 = p__11399;
this.map__11400 = map__11400;
this.opts = opts;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.meta11403 = meta11403;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table11402.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__11400,map__11400__$1,opts,slick_grid_event_handlers){
return (function (_11404,meta11403__$1){
var self__ = this;
var _11404__$1 = this;
return (new hatti.views.table.t_hatti$views$table11402(self__.app_state,self__.owner,self__.p__11399,self__.map__11400,self__.opts,self__.slick_grid_event_handlers,meta11403__$1));
});})(map__11400,map__11400__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table11402.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__11400,map__11400__$1,opts,slick_grid_event_handlers){
return (function (_11404){
var self__ = this;
var _11404__$1 = this;
return self__.meta11403;
});})(map__11400,map__11400__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table11402.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table11402.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__11400,map__11400__$1,opts,slick_grid_event_handlers){
return (function (_,___$1){
var self__ = this;
var ___$2 = this;
var no_data_QMARK_ = cljs.core.empty_QMARK_.call(null,cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null)));
var map__11405 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(self__.app_state);
var map__11405__$1 = ((((!((map__11405 == null)))?((((map__11405.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11405.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11405):map__11405);
var dataset_info = map__11405__$1;
var num_of_submissions = cljs.core.get.call(null,map__11405__$1,new cljs.core.Keyword(null,"num_of_submissions","num_of_submissions",-1720943091));
var with_info = ((function (no_data_QMARK_,map__11405,map__11405__$1,dataset_info,num_of_submissions,___$2,map__11400,map__11400__$1,opts,slick_grid_event_handlers){
return (function (p1__11398_SHARP_){
return cljs.core.merge.call(null,p1__11398_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),dataset_info], null));
});})(no_data_QMARK_,map__11405,map__11405__$1,dataset_info,num_of_submissions,___$2,map__11400,map__11400__$1,opts,slick_grid_event_handlers))
;
var attrs11407 = om.core.build.call(null,hatti.views.submission_view,with_info.call(null,cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855)], null))),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge.call(null,cljs.core.select_keys.call(null,self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"role","role",-736691072),null,new cljs.core.Keyword(null,"delete-record!","delete-record!",1411848194),null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"table","table",-564943036)], null))], null));
return cljs.core.apply.call(null,React.DOM.div,((cljs.core.map_QMARK_.call(null,attrs11407))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["table-view"], null)], null),attrs11407)):{"className": "table-view"}),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs11407))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.app_state)),React.DOM.div({"id": hatti.views.table.table_id, "className": "slickgrid"},(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.span({"className": "empty-state"},"No data"):React.DOM.span(null,React.DOM.i({"className": "fa fa-spinner fa-pulse"}),"Loading...")))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs11407),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.app_state)),React.DOM.div({"id": hatti.views.table.table_id, "className": "slickgrid"},(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.span({"className": "empty-state"},"No data"):React.DOM.span(null,React.DOM.i({"className": "fa fa-spinner fa-pulse"}),"Loading...")))], null))));
});})(map__11400,map__11400__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table11402.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table11402.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (map__11400,map__11400__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
var data = cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_.call(null,data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__11416 = temp__4425__auto__;
var grid = cljs.core.nth.call(null,vec__11416,(0),null);
var dataview = cljs.core.nth.call(null,vec__11416,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.app_state,grid,dataview);
} else {
return null;
}
});})(map__11400,map__11400__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table11402.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table11402.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (map__11400,map__11400__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

var old_data = cljs.core.get_in.call(null,om.core.get_props.call(null,self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var new_data = cljs.core.get_in.call(null,next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var map__11417 = om.core.get_state.call(null,self__.owner);
var map__11417__$1 = ((((!((map__11417 == null)))?((((map__11417.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11417.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11417):map__11417);
var grid = cljs.core.get.call(null,map__11417__$1,new cljs.core.Keyword(null,"grid","grid",402978600));
var dataview = cljs.core.get.call(null,map__11417__$1,new cljs.core.Keyword(null,"dataview","dataview",91765671));
if(cljs.core.not_EQ_.call(null,old_data,new_data)){
if(cljs.core.empty_QMARK_.call(null,old_data)){
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_.call(null,new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__11419 = temp__4425__auto__;
var grid__$1 = cljs.core.nth.call(null,vec__11419,(0),null);
var dataview__$1 = cljs.core.nth.call(null,vec__11419,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.app_state,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js.call(null,new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
});})(map__11400,map__11400__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table11402.getBasis = ((function (map__11400,map__11400__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__11399","p__11399",-1347395680,null),new cljs.core.Symbol(null,"map__11400","map__11400",-785109478,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"slick-grid-event-handlers","slick-grid-event-handlers",-664401045,null),new cljs.core.Symbol(null,"meta11403","meta11403",-1006810425,null)], null);
});})(map__11400,map__11400__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table11402.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table11402.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table11402";

hatti.views.table.t_hatti$views$table11402.cljs$lang$ctorPrWriter = ((function (map__11400,map__11400__$1,opts,slick_grid_event_handlers){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table11402");
});})(map__11400,map__11400__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table11402 = ((function (map__11400,map__11400__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table11402(app_state__$1,owner__$1,p__11399__$1,map__11400__$2,opts__$1,slick_grid_event_handlers__$1,meta11403){
return (new hatti.views.table.t_hatti$views$table11402(app_state__$1,owner__$1,p__11399__$1,map__11400__$2,opts__$1,slick_grid_event_handlers__$1,meta11403));
});})(map__11400,map__11400__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table11402(app_state,owner,p__11399,map__11400__$1,opts,slick_grid_event_handlers,cljs.core.PersistentArrayMap.EMPTY));
}));
