// Compiled by ClojureScript 1.7.145 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t_cljs$core$async13782 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13782 = (function (fn_handler,f,meta13783){
this.fn_handler = fn_handler;
this.f = f;
this.meta13783 = meta13783;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13782.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13784,meta13783__$1){
var self__ = this;
var _13784__$1 = this;
return (new cljs.core.async.t_cljs$core$async13782(self__.fn_handler,self__.f,meta13783__$1));
});

cljs.core.async.t_cljs$core$async13782.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13784){
var self__ = this;
var _13784__$1 = this;
return self__.meta13783;
});

cljs.core.async.t_cljs$core$async13782.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async13782.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async13782.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async13782.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fn-handler","fn-handler",648785851,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)))], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"meta13783","meta13783",430629562,null)], null);
});

cljs.core.async.t_cljs$core$async13782.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13782.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13782";

cljs.core.async.t_cljs$core$async13782.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async13782");
});

cljs.core.async.__GT_t_cljs$core$async13782 = (function cljs$core$async$fn_handler_$___GT_t_cljs$core$async13782(fn_handler__$1,f__$1,meta13783){
return (new cljs.core.async.t_cljs$core$async13782(fn_handler__$1,f__$1,meta13783));
});

}

return (new cljs.core.async.t_cljs$core$async13782(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args13787 = [];
var len__5627__auto___13790 = arguments.length;
var i__5628__auto___13791 = (0);
while(true){
if((i__5628__auto___13791 < len__5627__auto___13790)){
args13787.push((arguments[i__5628__auto___13791]));

var G__13792 = (i__5628__auto___13791 + (1));
i__5628__auto___13791 = G__13792;
continue;
} else {
}
break;
}

var G__13789 = args13787.length;
switch (G__13789) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13787.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args13794 = [];
var len__5627__auto___13797 = arguments.length;
var i__5628__auto___13798 = (0);
while(true){
if((i__5628__auto___13798 < len__5627__auto___13797)){
args13794.push((arguments[i__5628__auto___13798]));

var G__13799 = (i__5628__auto___13798 + (1));
i__5628__auto___13798 = G__13799;
continue;
} else {
}
break;
}

var G__13796 = args13794.length;
switch (G__13796) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13794.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_13801 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_13801);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_13801,ret){
return (function (){
return fn1.call(null,val_13801);
});})(val_13801,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args13802 = [];
var len__5627__auto___13805 = arguments.length;
var i__5628__auto___13806 = (0);
while(true){
if((i__5628__auto___13806 < len__5627__auto___13805)){
args13802.push((arguments[i__5628__auto___13806]));

var G__13807 = (i__5628__auto___13806 + (1));
i__5628__auto___13806 = G__13807;
continue;
} else {
}
break;
}

var G__13804 = args13802.length;
switch (G__13804) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13802.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5472__auto___13809 = n;
var x_13810 = (0);
while(true){
if((x_13810 < n__5472__auto___13809)){
(a[x_13810] = (0));

var G__13811 = (x_13810 + (1));
x_13810 = G__13811;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__13812 = (i + (1));
i = G__13812;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async13816 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13816 = (function (alt_flag,flag,meta13817){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta13817 = meta13817;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13816.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_13818,meta13817__$1){
var self__ = this;
var _13818__$1 = this;
return (new cljs.core.async.t_cljs$core$async13816(self__.alt_flag,self__.flag,meta13817__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async13816.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_13818){
var self__ = this;
var _13818__$1 = this;
return self__.meta13817;
});})(flag))
;

cljs.core.async.t_cljs$core$async13816.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async13816.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async13816.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async13816.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta13817","meta13817",-786396258,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async13816.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13816.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13816";

cljs.core.async.t_cljs$core$async13816.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async13816");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async13816 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async13816(alt_flag__$1,flag__$1,meta13817){
return (new cljs.core.async.t_cljs$core$async13816(alt_flag__$1,flag__$1,meta13817));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async13816(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async13822 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13822 = (function (alt_handler,flag,cb,meta13823){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta13823 = meta13823;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13822.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13824,meta13823__$1){
var self__ = this;
var _13824__$1 = this;
return (new cljs.core.async.t_cljs$core$async13822(self__.alt_handler,self__.flag,self__.cb,meta13823__$1));
});

cljs.core.async.t_cljs$core$async13822.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13824){
var self__ = this;
var _13824__$1 = this;
return self__.meta13823;
});

cljs.core.async.t_cljs$core$async13822.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async13822.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async13822.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async13822.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta13823","meta13823",1404348341,null)], null);
});

cljs.core.async.t_cljs$core$async13822.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13822.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13822";

cljs.core.async.t_cljs$core$async13822.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async13822");
});

cljs.core.async.__GT_t_cljs$core$async13822 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async13822(alt_handler__$1,flag__$1,cb__$1,meta13823){
return (new cljs.core.async.t_cljs$core$async13822(alt_handler__$1,flag__$1,cb__$1,meta13823));
});

}

return (new cljs.core.async.t_cljs$core$async13822(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__13825_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__13825_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__13826_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__13826_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4569__auto__ = wport;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return port;
}
})()], null));
} else {
var G__13827 = (i + (1));
i = G__13827;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4569__auto__ = ret;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4557__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___13833 = arguments.length;
var i__5628__auto___13834 = (0);
while(true){
if((i__5628__auto___13834 < len__5627__auto___13833)){
args__5634__auto__.push((arguments[i__5628__auto___13834]));

var G__13835 = (i__5628__auto___13834 + (1));
i__5628__auto___13834 = G__13835;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__13830){
var map__13831 = p__13830;
var map__13831__$1 = ((((!((map__13831 == null)))?((((map__13831.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13831.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13831):map__13831);
var opts = map__13831__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq13828){
var G__13829 = cljs.core.first.call(null,seq13828);
var seq13828__$1 = cljs.core.next.call(null,seq13828);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__13829,seq13828__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args13836 = [];
var len__5627__auto___13886 = arguments.length;
var i__5628__auto___13887 = (0);
while(true){
if((i__5628__auto___13887 < len__5627__auto___13886)){
args13836.push((arguments[i__5628__auto___13887]));

var G__13888 = (i__5628__auto___13887 + (1));
i__5628__auto___13887 = G__13888;
continue;
} else {
}
break;
}

var G__13838 = args13836.length;
switch (G__13838) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13836.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__7694__auto___13890 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___13890){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___13890){
return (function (state_13862){
var state_val_13863 = (state_13862[(1)]);
if((state_val_13863 === (7))){
var inst_13858 = (state_13862[(2)]);
var state_13862__$1 = state_13862;
var statearr_13864_13891 = state_13862__$1;
(statearr_13864_13891[(2)] = inst_13858);

(statearr_13864_13891[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13863 === (1))){
var state_13862__$1 = state_13862;
var statearr_13865_13892 = state_13862__$1;
(statearr_13865_13892[(2)] = null);

(statearr_13865_13892[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13863 === (4))){
var inst_13841 = (state_13862[(7)]);
var inst_13841__$1 = (state_13862[(2)]);
var inst_13842 = (inst_13841__$1 == null);
var state_13862__$1 = (function (){var statearr_13866 = state_13862;
(statearr_13866[(7)] = inst_13841__$1);

return statearr_13866;
})();
if(cljs.core.truth_(inst_13842)){
var statearr_13867_13893 = state_13862__$1;
(statearr_13867_13893[(1)] = (5));

} else {
var statearr_13868_13894 = state_13862__$1;
(statearr_13868_13894[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13863 === (13))){
var state_13862__$1 = state_13862;
var statearr_13869_13895 = state_13862__$1;
(statearr_13869_13895[(2)] = null);

(statearr_13869_13895[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13863 === (6))){
var inst_13841 = (state_13862[(7)]);
var state_13862__$1 = state_13862;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13862__$1,(11),to,inst_13841);
} else {
if((state_val_13863 === (3))){
var inst_13860 = (state_13862[(2)]);
var state_13862__$1 = state_13862;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13862__$1,inst_13860);
} else {
if((state_val_13863 === (12))){
var state_13862__$1 = state_13862;
var statearr_13870_13896 = state_13862__$1;
(statearr_13870_13896[(2)] = null);

(statearr_13870_13896[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13863 === (2))){
var state_13862__$1 = state_13862;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13862__$1,(4),from);
} else {
if((state_val_13863 === (11))){
var inst_13851 = (state_13862[(2)]);
var state_13862__$1 = state_13862;
if(cljs.core.truth_(inst_13851)){
var statearr_13871_13897 = state_13862__$1;
(statearr_13871_13897[(1)] = (12));

} else {
var statearr_13872_13898 = state_13862__$1;
(statearr_13872_13898[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13863 === (9))){
var state_13862__$1 = state_13862;
var statearr_13873_13899 = state_13862__$1;
(statearr_13873_13899[(2)] = null);

(statearr_13873_13899[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13863 === (5))){
var state_13862__$1 = state_13862;
if(cljs.core.truth_(close_QMARK_)){
var statearr_13874_13900 = state_13862__$1;
(statearr_13874_13900[(1)] = (8));

} else {
var statearr_13875_13901 = state_13862__$1;
(statearr_13875_13901[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13863 === (14))){
var inst_13856 = (state_13862[(2)]);
var state_13862__$1 = state_13862;
var statearr_13876_13902 = state_13862__$1;
(statearr_13876_13902[(2)] = inst_13856);

(statearr_13876_13902[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13863 === (10))){
var inst_13848 = (state_13862[(2)]);
var state_13862__$1 = state_13862;
var statearr_13877_13903 = state_13862__$1;
(statearr_13877_13903[(2)] = inst_13848);

(statearr_13877_13903[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13863 === (8))){
var inst_13845 = cljs.core.async.close_BANG_.call(null,to);
var state_13862__$1 = state_13862;
var statearr_13878_13904 = state_13862__$1;
(statearr_13878_13904[(2)] = inst_13845);

(statearr_13878_13904[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___13890))
;
return ((function (switch__7673__auto__,c__7694__auto___13890){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_13882 = [null,null,null,null,null,null,null,null];
(statearr_13882[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_13882[(1)] = (1));

return statearr_13882;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_13862){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_13862);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e13883){if((e13883 instanceof Object)){
var ex__7677__auto__ = e13883;
var statearr_13884_13905 = state_13862;
(statearr_13884_13905[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13862);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13883;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13906 = state_13862;
state_13862 = G__13906;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_13862){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_13862);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___13890))
})();
var state__7696__auto__ = (function (){var statearr_13885 = f__7695__auto__.call(null);
(statearr_13885[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___13890);

return statearr_13885;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___13890))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__14090){
var vec__14091 = p__14090;
var v = cljs.core.nth.call(null,vec__14091,(0),null);
var p = cljs.core.nth.call(null,vec__14091,(1),null);
var job = vec__14091;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__7694__auto___14273 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___14273,res,vec__14091,v,p,job,jobs,results){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___14273,res,vec__14091,v,p,job,jobs,results){
return (function (state_14096){
var state_val_14097 = (state_14096[(1)]);
if((state_val_14097 === (1))){
var state_14096__$1 = state_14096;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14096__$1,(2),res,v);
} else {
if((state_val_14097 === (2))){
var inst_14093 = (state_14096[(2)]);
var inst_14094 = cljs.core.async.close_BANG_.call(null,res);
var state_14096__$1 = (function (){var statearr_14098 = state_14096;
(statearr_14098[(7)] = inst_14093);

return statearr_14098;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14096__$1,inst_14094);
} else {
return null;
}
}
});})(c__7694__auto___14273,res,vec__14091,v,p,job,jobs,results))
;
return ((function (switch__7673__auto__,c__7694__auto___14273,res,vec__14091,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0 = (function (){
var statearr_14102 = [null,null,null,null,null,null,null,null];
(statearr_14102[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__);

(statearr_14102[(1)] = (1));

return statearr_14102;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1 = (function (state_14096){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14096);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14103){if((e14103 instanceof Object)){
var ex__7677__auto__ = e14103;
var statearr_14104_14274 = state_14096;
(statearr_14104_14274[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14096);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14103;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14275 = state_14096;
state_14096 = G__14275;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = function(state_14096){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1.call(this,state_14096);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___14273,res,vec__14091,v,p,job,jobs,results))
})();
var state__7696__auto__ = (function (){var statearr_14105 = f__7695__auto__.call(null);
(statearr_14105[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___14273);

return statearr_14105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___14273,res,vec__14091,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__14106){
var vec__14107 = p__14106;
var v = cljs.core.nth.call(null,vec__14107,(0),null);
var p = cljs.core.nth.call(null,vec__14107,(1),null);
var job = vec__14107;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5472__auto___14276 = n;
var __14277 = (0);
while(true){
if((__14277 < n__5472__auto___14276)){
var G__14108_14278 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__14108_14278) {
case "compute":
var c__7694__auto___14280 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__14277,c__7694__auto___14280,G__14108_14278,n__5472__auto___14276,jobs,results,process,async){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (__14277,c__7694__auto___14280,G__14108_14278,n__5472__auto___14276,jobs,results,process,async){
return (function (state_14121){
var state_val_14122 = (state_14121[(1)]);
if((state_val_14122 === (1))){
var state_14121__$1 = state_14121;
var statearr_14123_14281 = state_14121__$1;
(statearr_14123_14281[(2)] = null);

(statearr_14123_14281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14122 === (2))){
var state_14121__$1 = state_14121;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14121__$1,(4),jobs);
} else {
if((state_val_14122 === (3))){
var inst_14119 = (state_14121[(2)]);
var state_14121__$1 = state_14121;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14121__$1,inst_14119);
} else {
if((state_val_14122 === (4))){
var inst_14111 = (state_14121[(2)]);
var inst_14112 = process.call(null,inst_14111);
var state_14121__$1 = state_14121;
if(cljs.core.truth_(inst_14112)){
var statearr_14124_14282 = state_14121__$1;
(statearr_14124_14282[(1)] = (5));

} else {
var statearr_14125_14283 = state_14121__$1;
(statearr_14125_14283[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14122 === (5))){
var state_14121__$1 = state_14121;
var statearr_14126_14284 = state_14121__$1;
(statearr_14126_14284[(2)] = null);

(statearr_14126_14284[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14122 === (6))){
var state_14121__$1 = state_14121;
var statearr_14127_14285 = state_14121__$1;
(statearr_14127_14285[(2)] = null);

(statearr_14127_14285[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14122 === (7))){
var inst_14117 = (state_14121[(2)]);
var state_14121__$1 = state_14121;
var statearr_14128_14286 = state_14121__$1;
(statearr_14128_14286[(2)] = inst_14117);

(statearr_14128_14286[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__14277,c__7694__auto___14280,G__14108_14278,n__5472__auto___14276,jobs,results,process,async))
;
return ((function (__14277,switch__7673__auto__,c__7694__auto___14280,G__14108_14278,n__5472__auto___14276,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0 = (function (){
var statearr_14132 = [null,null,null,null,null,null,null];
(statearr_14132[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__);

(statearr_14132[(1)] = (1));

return statearr_14132;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1 = (function (state_14121){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14121);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14133){if((e14133 instanceof Object)){
var ex__7677__auto__ = e14133;
var statearr_14134_14287 = state_14121;
(statearr_14134_14287[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14121);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14133;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14288 = state_14121;
state_14121 = G__14288;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = function(state_14121){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1.call(this,state_14121);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__;
})()
;})(__14277,switch__7673__auto__,c__7694__auto___14280,G__14108_14278,n__5472__auto___14276,jobs,results,process,async))
})();
var state__7696__auto__ = (function (){var statearr_14135 = f__7695__auto__.call(null);
(statearr_14135[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___14280);

return statearr_14135;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(__14277,c__7694__auto___14280,G__14108_14278,n__5472__auto___14276,jobs,results,process,async))
);


break;
case "async":
var c__7694__auto___14289 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__14277,c__7694__auto___14289,G__14108_14278,n__5472__auto___14276,jobs,results,process,async){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (__14277,c__7694__auto___14289,G__14108_14278,n__5472__auto___14276,jobs,results,process,async){
return (function (state_14148){
var state_val_14149 = (state_14148[(1)]);
if((state_val_14149 === (1))){
var state_14148__$1 = state_14148;
var statearr_14150_14290 = state_14148__$1;
(statearr_14150_14290[(2)] = null);

(statearr_14150_14290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14149 === (2))){
var state_14148__$1 = state_14148;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14148__$1,(4),jobs);
} else {
if((state_val_14149 === (3))){
var inst_14146 = (state_14148[(2)]);
var state_14148__$1 = state_14148;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14148__$1,inst_14146);
} else {
if((state_val_14149 === (4))){
var inst_14138 = (state_14148[(2)]);
var inst_14139 = async.call(null,inst_14138);
var state_14148__$1 = state_14148;
if(cljs.core.truth_(inst_14139)){
var statearr_14151_14291 = state_14148__$1;
(statearr_14151_14291[(1)] = (5));

} else {
var statearr_14152_14292 = state_14148__$1;
(statearr_14152_14292[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14149 === (5))){
var state_14148__$1 = state_14148;
var statearr_14153_14293 = state_14148__$1;
(statearr_14153_14293[(2)] = null);

(statearr_14153_14293[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14149 === (6))){
var state_14148__$1 = state_14148;
var statearr_14154_14294 = state_14148__$1;
(statearr_14154_14294[(2)] = null);

(statearr_14154_14294[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14149 === (7))){
var inst_14144 = (state_14148[(2)]);
var state_14148__$1 = state_14148;
var statearr_14155_14295 = state_14148__$1;
(statearr_14155_14295[(2)] = inst_14144);

(statearr_14155_14295[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__14277,c__7694__auto___14289,G__14108_14278,n__5472__auto___14276,jobs,results,process,async))
;
return ((function (__14277,switch__7673__auto__,c__7694__auto___14289,G__14108_14278,n__5472__auto___14276,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0 = (function (){
var statearr_14159 = [null,null,null,null,null,null,null];
(statearr_14159[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__);

(statearr_14159[(1)] = (1));

return statearr_14159;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1 = (function (state_14148){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14148);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14160){if((e14160 instanceof Object)){
var ex__7677__auto__ = e14160;
var statearr_14161_14296 = state_14148;
(statearr_14161_14296[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14148);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14160;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14297 = state_14148;
state_14148 = G__14297;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = function(state_14148){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1.call(this,state_14148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__;
})()
;})(__14277,switch__7673__auto__,c__7694__auto___14289,G__14108_14278,n__5472__auto___14276,jobs,results,process,async))
})();
var state__7696__auto__ = (function (){var statearr_14162 = f__7695__auto__.call(null);
(statearr_14162[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___14289);

return statearr_14162;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(__14277,c__7694__auto___14289,G__14108_14278,n__5472__auto___14276,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__14298 = (__14277 + (1));
__14277 = G__14298;
continue;
} else {
}
break;
}

var c__7694__auto___14299 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___14299,jobs,results,process,async){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___14299,jobs,results,process,async){
return (function (state_14184){
var state_val_14185 = (state_14184[(1)]);
if((state_val_14185 === (1))){
var state_14184__$1 = state_14184;
var statearr_14186_14300 = state_14184__$1;
(statearr_14186_14300[(2)] = null);

(statearr_14186_14300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14185 === (2))){
var state_14184__$1 = state_14184;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14184__$1,(4),from);
} else {
if((state_val_14185 === (3))){
var inst_14182 = (state_14184[(2)]);
var state_14184__$1 = state_14184;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14184__$1,inst_14182);
} else {
if((state_val_14185 === (4))){
var inst_14165 = (state_14184[(7)]);
var inst_14165__$1 = (state_14184[(2)]);
var inst_14166 = (inst_14165__$1 == null);
var state_14184__$1 = (function (){var statearr_14187 = state_14184;
(statearr_14187[(7)] = inst_14165__$1);

return statearr_14187;
})();
if(cljs.core.truth_(inst_14166)){
var statearr_14188_14301 = state_14184__$1;
(statearr_14188_14301[(1)] = (5));

} else {
var statearr_14189_14302 = state_14184__$1;
(statearr_14189_14302[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14185 === (5))){
var inst_14168 = cljs.core.async.close_BANG_.call(null,jobs);
var state_14184__$1 = state_14184;
var statearr_14190_14303 = state_14184__$1;
(statearr_14190_14303[(2)] = inst_14168);

(statearr_14190_14303[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14185 === (6))){
var inst_14170 = (state_14184[(8)]);
var inst_14165 = (state_14184[(7)]);
var inst_14170__$1 = cljs.core.async.chan.call(null,(1));
var inst_14171 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14172 = [inst_14165,inst_14170__$1];
var inst_14173 = (new cljs.core.PersistentVector(null,2,(5),inst_14171,inst_14172,null));
var state_14184__$1 = (function (){var statearr_14191 = state_14184;
(statearr_14191[(8)] = inst_14170__$1);

return statearr_14191;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14184__$1,(8),jobs,inst_14173);
} else {
if((state_val_14185 === (7))){
var inst_14180 = (state_14184[(2)]);
var state_14184__$1 = state_14184;
var statearr_14192_14304 = state_14184__$1;
(statearr_14192_14304[(2)] = inst_14180);

(statearr_14192_14304[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14185 === (8))){
var inst_14170 = (state_14184[(8)]);
var inst_14175 = (state_14184[(2)]);
var state_14184__$1 = (function (){var statearr_14193 = state_14184;
(statearr_14193[(9)] = inst_14175);

return statearr_14193;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14184__$1,(9),results,inst_14170);
} else {
if((state_val_14185 === (9))){
var inst_14177 = (state_14184[(2)]);
var state_14184__$1 = (function (){var statearr_14194 = state_14184;
(statearr_14194[(10)] = inst_14177);

return statearr_14194;
})();
var statearr_14195_14305 = state_14184__$1;
(statearr_14195_14305[(2)] = null);

(statearr_14195_14305[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___14299,jobs,results,process,async))
;
return ((function (switch__7673__auto__,c__7694__auto___14299,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0 = (function (){
var statearr_14199 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14199[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__);

(statearr_14199[(1)] = (1));

return statearr_14199;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1 = (function (state_14184){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14184);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14200){if((e14200 instanceof Object)){
var ex__7677__auto__ = e14200;
var statearr_14201_14306 = state_14184;
(statearr_14201_14306[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14184);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14200;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14307 = state_14184;
state_14184 = G__14307;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = function(state_14184){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1.call(this,state_14184);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___14299,jobs,results,process,async))
})();
var state__7696__auto__ = (function (){var statearr_14202 = f__7695__auto__.call(null);
(statearr_14202[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___14299);

return statearr_14202;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___14299,jobs,results,process,async))
);


var c__7694__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto__,jobs,results,process,async){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto__,jobs,results,process,async){
return (function (state_14240){
var state_val_14241 = (state_14240[(1)]);
if((state_val_14241 === (7))){
var inst_14236 = (state_14240[(2)]);
var state_14240__$1 = state_14240;
var statearr_14242_14308 = state_14240__$1;
(statearr_14242_14308[(2)] = inst_14236);

(statearr_14242_14308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14241 === (20))){
var state_14240__$1 = state_14240;
var statearr_14243_14309 = state_14240__$1;
(statearr_14243_14309[(2)] = null);

(statearr_14243_14309[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14241 === (1))){
var state_14240__$1 = state_14240;
var statearr_14244_14310 = state_14240__$1;
(statearr_14244_14310[(2)] = null);

(statearr_14244_14310[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14241 === (4))){
var inst_14205 = (state_14240[(7)]);
var inst_14205__$1 = (state_14240[(2)]);
var inst_14206 = (inst_14205__$1 == null);
var state_14240__$1 = (function (){var statearr_14245 = state_14240;
(statearr_14245[(7)] = inst_14205__$1);

return statearr_14245;
})();
if(cljs.core.truth_(inst_14206)){
var statearr_14246_14311 = state_14240__$1;
(statearr_14246_14311[(1)] = (5));

} else {
var statearr_14247_14312 = state_14240__$1;
(statearr_14247_14312[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14241 === (15))){
var inst_14218 = (state_14240[(8)]);
var state_14240__$1 = state_14240;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14240__$1,(18),to,inst_14218);
} else {
if((state_val_14241 === (21))){
var inst_14231 = (state_14240[(2)]);
var state_14240__$1 = state_14240;
var statearr_14248_14313 = state_14240__$1;
(statearr_14248_14313[(2)] = inst_14231);

(statearr_14248_14313[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14241 === (13))){
var inst_14233 = (state_14240[(2)]);
var state_14240__$1 = (function (){var statearr_14249 = state_14240;
(statearr_14249[(9)] = inst_14233);

return statearr_14249;
})();
var statearr_14250_14314 = state_14240__$1;
(statearr_14250_14314[(2)] = null);

(statearr_14250_14314[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14241 === (6))){
var inst_14205 = (state_14240[(7)]);
var state_14240__$1 = state_14240;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14240__$1,(11),inst_14205);
} else {
if((state_val_14241 === (17))){
var inst_14226 = (state_14240[(2)]);
var state_14240__$1 = state_14240;
if(cljs.core.truth_(inst_14226)){
var statearr_14251_14315 = state_14240__$1;
(statearr_14251_14315[(1)] = (19));

} else {
var statearr_14252_14316 = state_14240__$1;
(statearr_14252_14316[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14241 === (3))){
var inst_14238 = (state_14240[(2)]);
var state_14240__$1 = state_14240;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14240__$1,inst_14238);
} else {
if((state_val_14241 === (12))){
var inst_14215 = (state_14240[(10)]);
var state_14240__$1 = state_14240;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14240__$1,(14),inst_14215);
} else {
if((state_val_14241 === (2))){
var state_14240__$1 = state_14240;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14240__$1,(4),results);
} else {
if((state_val_14241 === (19))){
var state_14240__$1 = state_14240;
var statearr_14253_14317 = state_14240__$1;
(statearr_14253_14317[(2)] = null);

(statearr_14253_14317[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14241 === (11))){
var inst_14215 = (state_14240[(2)]);
var state_14240__$1 = (function (){var statearr_14254 = state_14240;
(statearr_14254[(10)] = inst_14215);

return statearr_14254;
})();
var statearr_14255_14318 = state_14240__$1;
(statearr_14255_14318[(2)] = null);

(statearr_14255_14318[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14241 === (9))){
var state_14240__$1 = state_14240;
var statearr_14256_14319 = state_14240__$1;
(statearr_14256_14319[(2)] = null);

(statearr_14256_14319[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14241 === (5))){
var state_14240__$1 = state_14240;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14257_14320 = state_14240__$1;
(statearr_14257_14320[(1)] = (8));

} else {
var statearr_14258_14321 = state_14240__$1;
(statearr_14258_14321[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14241 === (14))){
var inst_14220 = (state_14240[(11)]);
var inst_14218 = (state_14240[(8)]);
var inst_14218__$1 = (state_14240[(2)]);
var inst_14219 = (inst_14218__$1 == null);
var inst_14220__$1 = cljs.core.not.call(null,inst_14219);
var state_14240__$1 = (function (){var statearr_14259 = state_14240;
(statearr_14259[(11)] = inst_14220__$1);

(statearr_14259[(8)] = inst_14218__$1);

return statearr_14259;
})();
if(inst_14220__$1){
var statearr_14260_14322 = state_14240__$1;
(statearr_14260_14322[(1)] = (15));

} else {
var statearr_14261_14323 = state_14240__$1;
(statearr_14261_14323[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14241 === (16))){
var inst_14220 = (state_14240[(11)]);
var state_14240__$1 = state_14240;
var statearr_14262_14324 = state_14240__$1;
(statearr_14262_14324[(2)] = inst_14220);

(statearr_14262_14324[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14241 === (10))){
var inst_14212 = (state_14240[(2)]);
var state_14240__$1 = state_14240;
var statearr_14263_14325 = state_14240__$1;
(statearr_14263_14325[(2)] = inst_14212);

(statearr_14263_14325[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14241 === (18))){
var inst_14223 = (state_14240[(2)]);
var state_14240__$1 = state_14240;
var statearr_14264_14326 = state_14240__$1;
(statearr_14264_14326[(2)] = inst_14223);

(statearr_14264_14326[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14241 === (8))){
var inst_14209 = cljs.core.async.close_BANG_.call(null,to);
var state_14240__$1 = state_14240;
var statearr_14265_14327 = state_14240__$1;
(statearr_14265_14327[(2)] = inst_14209);

(statearr_14265_14327[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto__,jobs,results,process,async))
;
return ((function (switch__7673__auto__,c__7694__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0 = (function (){
var statearr_14269 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14269[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__);

(statearr_14269[(1)] = (1));

return statearr_14269;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1 = (function (state_14240){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14240);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14270){if((e14270 instanceof Object)){
var ex__7677__auto__ = e14270;
var statearr_14271_14328 = state_14240;
(statearr_14271_14328[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14240);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14270;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14329 = state_14240;
state_14240 = G__14329;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = function(state_14240){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1.call(this,state_14240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto__,jobs,results,process,async))
})();
var state__7696__auto__ = (function (){var statearr_14272 = f__7695__auto__.call(null);
(statearr_14272[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto__);

return statearr_14272;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto__,jobs,results,process,async))
);

return c__7694__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args14330 = [];
var len__5627__auto___14333 = arguments.length;
var i__5628__auto___14334 = (0);
while(true){
if((i__5628__auto___14334 < len__5627__auto___14333)){
args14330.push((arguments[i__5628__auto___14334]));

var G__14335 = (i__5628__auto___14334 + (1));
i__5628__auto___14334 = G__14335;
continue;
} else {
}
break;
}

var G__14332 = args14330.length;
switch (G__14332) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14330.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args14337 = [];
var len__5627__auto___14340 = arguments.length;
var i__5628__auto___14341 = (0);
while(true){
if((i__5628__auto___14341 < len__5627__auto___14340)){
args14337.push((arguments[i__5628__auto___14341]));

var G__14342 = (i__5628__auto___14341 + (1));
i__5628__auto___14341 = G__14342;
continue;
} else {
}
break;
}

var G__14339 = args14337.length;
switch (G__14339) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14337.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args14344 = [];
var len__5627__auto___14397 = arguments.length;
var i__5628__auto___14398 = (0);
while(true){
if((i__5628__auto___14398 < len__5627__auto___14397)){
args14344.push((arguments[i__5628__auto___14398]));

var G__14399 = (i__5628__auto___14398 + (1));
i__5628__auto___14398 = G__14399;
continue;
} else {
}
break;
}

var G__14346 = args14344.length;
switch (G__14346) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14344.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__7694__auto___14401 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___14401,tc,fc){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___14401,tc,fc){
return (function (state_14372){
var state_val_14373 = (state_14372[(1)]);
if((state_val_14373 === (7))){
var inst_14368 = (state_14372[(2)]);
var state_14372__$1 = state_14372;
var statearr_14374_14402 = state_14372__$1;
(statearr_14374_14402[(2)] = inst_14368);

(statearr_14374_14402[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (1))){
var state_14372__$1 = state_14372;
var statearr_14375_14403 = state_14372__$1;
(statearr_14375_14403[(2)] = null);

(statearr_14375_14403[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (4))){
var inst_14349 = (state_14372[(7)]);
var inst_14349__$1 = (state_14372[(2)]);
var inst_14350 = (inst_14349__$1 == null);
var state_14372__$1 = (function (){var statearr_14376 = state_14372;
(statearr_14376[(7)] = inst_14349__$1);

return statearr_14376;
})();
if(cljs.core.truth_(inst_14350)){
var statearr_14377_14404 = state_14372__$1;
(statearr_14377_14404[(1)] = (5));

} else {
var statearr_14378_14405 = state_14372__$1;
(statearr_14378_14405[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (13))){
var state_14372__$1 = state_14372;
var statearr_14379_14406 = state_14372__$1;
(statearr_14379_14406[(2)] = null);

(statearr_14379_14406[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (6))){
var inst_14349 = (state_14372[(7)]);
var inst_14355 = p.call(null,inst_14349);
var state_14372__$1 = state_14372;
if(cljs.core.truth_(inst_14355)){
var statearr_14380_14407 = state_14372__$1;
(statearr_14380_14407[(1)] = (9));

} else {
var statearr_14381_14408 = state_14372__$1;
(statearr_14381_14408[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (3))){
var inst_14370 = (state_14372[(2)]);
var state_14372__$1 = state_14372;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14372__$1,inst_14370);
} else {
if((state_val_14373 === (12))){
var state_14372__$1 = state_14372;
var statearr_14382_14409 = state_14372__$1;
(statearr_14382_14409[(2)] = null);

(statearr_14382_14409[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (2))){
var state_14372__$1 = state_14372;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14372__$1,(4),ch);
} else {
if((state_val_14373 === (11))){
var inst_14349 = (state_14372[(7)]);
var inst_14359 = (state_14372[(2)]);
var state_14372__$1 = state_14372;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14372__$1,(8),inst_14359,inst_14349);
} else {
if((state_val_14373 === (9))){
var state_14372__$1 = state_14372;
var statearr_14383_14410 = state_14372__$1;
(statearr_14383_14410[(2)] = tc);

(statearr_14383_14410[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (5))){
var inst_14352 = cljs.core.async.close_BANG_.call(null,tc);
var inst_14353 = cljs.core.async.close_BANG_.call(null,fc);
var state_14372__$1 = (function (){var statearr_14384 = state_14372;
(statearr_14384[(8)] = inst_14352);

return statearr_14384;
})();
var statearr_14385_14411 = state_14372__$1;
(statearr_14385_14411[(2)] = inst_14353);

(statearr_14385_14411[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (14))){
var inst_14366 = (state_14372[(2)]);
var state_14372__$1 = state_14372;
var statearr_14386_14412 = state_14372__$1;
(statearr_14386_14412[(2)] = inst_14366);

(statearr_14386_14412[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (10))){
var state_14372__$1 = state_14372;
var statearr_14387_14413 = state_14372__$1;
(statearr_14387_14413[(2)] = fc);

(statearr_14387_14413[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (8))){
var inst_14361 = (state_14372[(2)]);
var state_14372__$1 = state_14372;
if(cljs.core.truth_(inst_14361)){
var statearr_14388_14414 = state_14372__$1;
(statearr_14388_14414[(1)] = (12));

} else {
var statearr_14389_14415 = state_14372__$1;
(statearr_14389_14415[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___14401,tc,fc))
;
return ((function (switch__7673__auto__,c__7694__auto___14401,tc,fc){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_14393 = [null,null,null,null,null,null,null,null,null];
(statearr_14393[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_14393[(1)] = (1));

return statearr_14393;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_14372){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14372);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14394){if((e14394 instanceof Object)){
var ex__7677__auto__ = e14394;
var statearr_14395_14416 = state_14372;
(statearr_14395_14416[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14372);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14394;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14417 = state_14372;
state_14372 = G__14417;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_14372){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_14372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___14401,tc,fc))
})();
var state__7696__auto__ = (function (){var statearr_14396 = f__7695__auto__.call(null);
(statearr_14396[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___14401);

return statearr_14396;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___14401,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__7694__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto__){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto__){
return (function (state_14464){
var state_val_14465 = (state_14464[(1)]);
if((state_val_14465 === (1))){
var inst_14450 = init;
var state_14464__$1 = (function (){var statearr_14466 = state_14464;
(statearr_14466[(7)] = inst_14450);

return statearr_14466;
})();
var statearr_14467_14482 = state_14464__$1;
(statearr_14467_14482[(2)] = null);

(statearr_14467_14482[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14465 === (2))){
var state_14464__$1 = state_14464;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14464__$1,(4),ch);
} else {
if((state_val_14465 === (3))){
var inst_14462 = (state_14464[(2)]);
var state_14464__$1 = state_14464;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14464__$1,inst_14462);
} else {
if((state_val_14465 === (4))){
var inst_14453 = (state_14464[(8)]);
var inst_14453__$1 = (state_14464[(2)]);
var inst_14454 = (inst_14453__$1 == null);
var state_14464__$1 = (function (){var statearr_14468 = state_14464;
(statearr_14468[(8)] = inst_14453__$1);

return statearr_14468;
})();
if(cljs.core.truth_(inst_14454)){
var statearr_14469_14483 = state_14464__$1;
(statearr_14469_14483[(1)] = (5));

} else {
var statearr_14470_14484 = state_14464__$1;
(statearr_14470_14484[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14465 === (5))){
var inst_14450 = (state_14464[(7)]);
var state_14464__$1 = state_14464;
var statearr_14471_14485 = state_14464__$1;
(statearr_14471_14485[(2)] = inst_14450);

(statearr_14471_14485[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14465 === (6))){
var inst_14450 = (state_14464[(7)]);
var inst_14453 = (state_14464[(8)]);
var inst_14457 = f.call(null,inst_14450,inst_14453);
var inst_14450__$1 = inst_14457;
var state_14464__$1 = (function (){var statearr_14472 = state_14464;
(statearr_14472[(7)] = inst_14450__$1);

return statearr_14472;
})();
var statearr_14473_14486 = state_14464__$1;
(statearr_14473_14486[(2)] = null);

(statearr_14473_14486[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14465 === (7))){
var inst_14460 = (state_14464[(2)]);
var state_14464__$1 = state_14464;
var statearr_14474_14487 = state_14464__$1;
(statearr_14474_14487[(2)] = inst_14460);

(statearr_14474_14487[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__7694__auto__))
;
return ((function (switch__7673__auto__,c__7694__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__7674__auto__ = null;
var cljs$core$async$reduce_$_state_machine__7674__auto____0 = (function (){
var statearr_14478 = [null,null,null,null,null,null,null,null,null];
(statearr_14478[(0)] = cljs$core$async$reduce_$_state_machine__7674__auto__);

(statearr_14478[(1)] = (1));

return statearr_14478;
});
var cljs$core$async$reduce_$_state_machine__7674__auto____1 = (function (state_14464){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14464);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14479){if((e14479 instanceof Object)){
var ex__7677__auto__ = e14479;
var statearr_14480_14488 = state_14464;
(statearr_14480_14488[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14464);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14479;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14489 = state_14464;
state_14464 = G__14489;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__7674__auto__ = function(state_14464){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__7674__auto____1.call(this,state_14464);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__7674__auto____0;
cljs$core$async$reduce_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__7674__auto____1;
return cljs$core$async$reduce_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto__))
})();
var state__7696__auto__ = (function (){var statearr_14481 = f__7695__auto__.call(null);
(statearr_14481[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto__);

return statearr_14481;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto__))
);

return c__7694__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args14490 = [];
var len__5627__auto___14542 = arguments.length;
var i__5628__auto___14543 = (0);
while(true){
if((i__5628__auto___14543 < len__5627__auto___14542)){
args14490.push((arguments[i__5628__auto___14543]));

var G__14544 = (i__5628__auto___14543 + (1));
i__5628__auto___14543 = G__14544;
continue;
} else {
}
break;
}

var G__14492 = args14490.length;
switch (G__14492) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14490.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__7694__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto__){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto__){
return (function (state_14517){
var state_val_14518 = (state_14517[(1)]);
if((state_val_14518 === (7))){
var inst_14499 = (state_14517[(2)]);
var state_14517__$1 = state_14517;
var statearr_14519_14546 = state_14517__$1;
(statearr_14519_14546[(2)] = inst_14499);

(statearr_14519_14546[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14518 === (1))){
var inst_14493 = cljs.core.seq.call(null,coll);
var inst_14494 = inst_14493;
var state_14517__$1 = (function (){var statearr_14520 = state_14517;
(statearr_14520[(7)] = inst_14494);

return statearr_14520;
})();
var statearr_14521_14547 = state_14517__$1;
(statearr_14521_14547[(2)] = null);

(statearr_14521_14547[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14518 === (4))){
var inst_14494 = (state_14517[(7)]);
var inst_14497 = cljs.core.first.call(null,inst_14494);
var state_14517__$1 = state_14517;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14517__$1,(7),ch,inst_14497);
} else {
if((state_val_14518 === (13))){
var inst_14511 = (state_14517[(2)]);
var state_14517__$1 = state_14517;
var statearr_14522_14548 = state_14517__$1;
(statearr_14522_14548[(2)] = inst_14511);

(statearr_14522_14548[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14518 === (6))){
var inst_14502 = (state_14517[(2)]);
var state_14517__$1 = state_14517;
if(cljs.core.truth_(inst_14502)){
var statearr_14523_14549 = state_14517__$1;
(statearr_14523_14549[(1)] = (8));

} else {
var statearr_14524_14550 = state_14517__$1;
(statearr_14524_14550[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14518 === (3))){
var inst_14515 = (state_14517[(2)]);
var state_14517__$1 = state_14517;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14517__$1,inst_14515);
} else {
if((state_val_14518 === (12))){
var state_14517__$1 = state_14517;
var statearr_14525_14551 = state_14517__$1;
(statearr_14525_14551[(2)] = null);

(statearr_14525_14551[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14518 === (2))){
var inst_14494 = (state_14517[(7)]);
var state_14517__$1 = state_14517;
if(cljs.core.truth_(inst_14494)){
var statearr_14526_14552 = state_14517__$1;
(statearr_14526_14552[(1)] = (4));

} else {
var statearr_14527_14553 = state_14517__$1;
(statearr_14527_14553[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14518 === (11))){
var inst_14508 = cljs.core.async.close_BANG_.call(null,ch);
var state_14517__$1 = state_14517;
var statearr_14528_14554 = state_14517__$1;
(statearr_14528_14554[(2)] = inst_14508);

(statearr_14528_14554[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14518 === (9))){
var state_14517__$1 = state_14517;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14529_14555 = state_14517__$1;
(statearr_14529_14555[(1)] = (11));

} else {
var statearr_14530_14556 = state_14517__$1;
(statearr_14530_14556[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14518 === (5))){
var inst_14494 = (state_14517[(7)]);
var state_14517__$1 = state_14517;
var statearr_14531_14557 = state_14517__$1;
(statearr_14531_14557[(2)] = inst_14494);

(statearr_14531_14557[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14518 === (10))){
var inst_14513 = (state_14517[(2)]);
var state_14517__$1 = state_14517;
var statearr_14532_14558 = state_14517__$1;
(statearr_14532_14558[(2)] = inst_14513);

(statearr_14532_14558[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14518 === (8))){
var inst_14494 = (state_14517[(7)]);
var inst_14504 = cljs.core.next.call(null,inst_14494);
var inst_14494__$1 = inst_14504;
var state_14517__$1 = (function (){var statearr_14533 = state_14517;
(statearr_14533[(7)] = inst_14494__$1);

return statearr_14533;
})();
var statearr_14534_14559 = state_14517__$1;
(statearr_14534_14559[(2)] = null);

(statearr_14534_14559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto__))
;
return ((function (switch__7673__auto__,c__7694__auto__){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_14538 = [null,null,null,null,null,null,null,null];
(statearr_14538[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_14538[(1)] = (1));

return statearr_14538;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_14517){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14517);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14539){if((e14539 instanceof Object)){
var ex__7677__auto__ = e14539;
var statearr_14540_14560 = state_14517;
(statearr_14540_14560[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14517);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14539;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14561 = state_14517;
state_14517 = G__14561;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_14517){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_14517);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto__))
})();
var state__7696__auto__ = (function (){var statearr_14541 = f__7695__auto__.call(null);
(statearr_14541[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto__);

return statearr_14541;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto__))
);

return c__7694__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5224__auto__ = (((_ == null))?null:_);
var m__5225__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,_);
} else {
var m__5225__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5225__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m);
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async14783 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14783 = (function (mult,ch,cs,meta14784){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta14784 = meta14784;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14783.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_14785,meta14784__$1){
var self__ = this;
var _14785__$1 = this;
return (new cljs.core.async.t_cljs$core$async14783(self__.mult,self__.ch,self__.cs,meta14784__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async14783.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_14785){
var self__ = this;
var _14785__$1 = this;
return self__.meta14784;
});})(cs))
;

cljs.core.async.t_cljs$core$async14783.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async14783.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async14783.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async14783.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async14783.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async14783.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async14783.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta14784","meta14784",269382024,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async14783.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14783.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14783";

cljs.core.async.t_cljs$core$async14783.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async14783");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async14783 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async14783(mult__$1,ch__$1,cs__$1,meta14784){
return (new cljs.core.async.t_cljs$core$async14783(mult__$1,ch__$1,cs__$1,meta14784));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async14783(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__7694__auto___15004 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___15004,cs,m,dchan,dctr,done){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___15004,cs,m,dchan,dctr,done){
return (function (state_14916){
var state_val_14917 = (state_14916[(1)]);
if((state_val_14917 === (7))){
var inst_14912 = (state_14916[(2)]);
var state_14916__$1 = state_14916;
var statearr_14918_15005 = state_14916__$1;
(statearr_14918_15005[(2)] = inst_14912);

(statearr_14918_15005[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (20))){
var inst_14817 = (state_14916[(7)]);
var inst_14827 = cljs.core.first.call(null,inst_14817);
var inst_14828 = cljs.core.nth.call(null,inst_14827,(0),null);
var inst_14829 = cljs.core.nth.call(null,inst_14827,(1),null);
var state_14916__$1 = (function (){var statearr_14919 = state_14916;
(statearr_14919[(8)] = inst_14828);

return statearr_14919;
})();
if(cljs.core.truth_(inst_14829)){
var statearr_14920_15006 = state_14916__$1;
(statearr_14920_15006[(1)] = (22));

} else {
var statearr_14921_15007 = state_14916__$1;
(statearr_14921_15007[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (27))){
var inst_14864 = (state_14916[(9)]);
var inst_14857 = (state_14916[(10)]);
var inst_14788 = (state_14916[(11)]);
var inst_14859 = (state_14916[(12)]);
var inst_14864__$1 = cljs.core._nth.call(null,inst_14857,inst_14859);
var inst_14865 = cljs.core.async.put_BANG_.call(null,inst_14864__$1,inst_14788,done);
var state_14916__$1 = (function (){var statearr_14922 = state_14916;
(statearr_14922[(9)] = inst_14864__$1);

return statearr_14922;
})();
if(cljs.core.truth_(inst_14865)){
var statearr_14923_15008 = state_14916__$1;
(statearr_14923_15008[(1)] = (30));

} else {
var statearr_14924_15009 = state_14916__$1;
(statearr_14924_15009[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (1))){
var state_14916__$1 = state_14916;
var statearr_14925_15010 = state_14916__$1;
(statearr_14925_15010[(2)] = null);

(statearr_14925_15010[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (24))){
var inst_14817 = (state_14916[(7)]);
var inst_14834 = (state_14916[(2)]);
var inst_14835 = cljs.core.next.call(null,inst_14817);
var inst_14797 = inst_14835;
var inst_14798 = null;
var inst_14799 = (0);
var inst_14800 = (0);
var state_14916__$1 = (function (){var statearr_14926 = state_14916;
(statearr_14926[(13)] = inst_14797);

(statearr_14926[(14)] = inst_14799);

(statearr_14926[(15)] = inst_14834);

(statearr_14926[(16)] = inst_14800);

(statearr_14926[(17)] = inst_14798);

return statearr_14926;
})();
var statearr_14927_15011 = state_14916__$1;
(statearr_14927_15011[(2)] = null);

(statearr_14927_15011[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (39))){
var state_14916__$1 = state_14916;
var statearr_14931_15012 = state_14916__$1;
(statearr_14931_15012[(2)] = null);

(statearr_14931_15012[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (4))){
var inst_14788 = (state_14916[(11)]);
var inst_14788__$1 = (state_14916[(2)]);
var inst_14789 = (inst_14788__$1 == null);
var state_14916__$1 = (function (){var statearr_14932 = state_14916;
(statearr_14932[(11)] = inst_14788__$1);

return statearr_14932;
})();
if(cljs.core.truth_(inst_14789)){
var statearr_14933_15013 = state_14916__$1;
(statearr_14933_15013[(1)] = (5));

} else {
var statearr_14934_15014 = state_14916__$1;
(statearr_14934_15014[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (15))){
var inst_14797 = (state_14916[(13)]);
var inst_14799 = (state_14916[(14)]);
var inst_14800 = (state_14916[(16)]);
var inst_14798 = (state_14916[(17)]);
var inst_14813 = (state_14916[(2)]);
var inst_14814 = (inst_14800 + (1));
var tmp14928 = inst_14797;
var tmp14929 = inst_14799;
var tmp14930 = inst_14798;
var inst_14797__$1 = tmp14928;
var inst_14798__$1 = tmp14930;
var inst_14799__$1 = tmp14929;
var inst_14800__$1 = inst_14814;
var state_14916__$1 = (function (){var statearr_14935 = state_14916;
(statearr_14935[(18)] = inst_14813);

(statearr_14935[(13)] = inst_14797__$1);

(statearr_14935[(14)] = inst_14799__$1);

(statearr_14935[(16)] = inst_14800__$1);

(statearr_14935[(17)] = inst_14798__$1);

return statearr_14935;
})();
var statearr_14936_15015 = state_14916__$1;
(statearr_14936_15015[(2)] = null);

(statearr_14936_15015[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (21))){
var inst_14838 = (state_14916[(2)]);
var state_14916__$1 = state_14916;
var statearr_14940_15016 = state_14916__$1;
(statearr_14940_15016[(2)] = inst_14838);

(statearr_14940_15016[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (31))){
var inst_14864 = (state_14916[(9)]);
var inst_14868 = done.call(null,null);
var inst_14869 = cljs.core.async.untap_STAR_.call(null,m,inst_14864);
var state_14916__$1 = (function (){var statearr_14941 = state_14916;
(statearr_14941[(19)] = inst_14868);

return statearr_14941;
})();
var statearr_14942_15017 = state_14916__$1;
(statearr_14942_15017[(2)] = inst_14869);

(statearr_14942_15017[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (32))){
var inst_14858 = (state_14916[(20)]);
var inst_14857 = (state_14916[(10)]);
var inst_14856 = (state_14916[(21)]);
var inst_14859 = (state_14916[(12)]);
var inst_14871 = (state_14916[(2)]);
var inst_14872 = (inst_14859 + (1));
var tmp14937 = inst_14858;
var tmp14938 = inst_14857;
var tmp14939 = inst_14856;
var inst_14856__$1 = tmp14939;
var inst_14857__$1 = tmp14938;
var inst_14858__$1 = tmp14937;
var inst_14859__$1 = inst_14872;
var state_14916__$1 = (function (){var statearr_14943 = state_14916;
(statearr_14943[(20)] = inst_14858__$1);

(statearr_14943[(10)] = inst_14857__$1);

(statearr_14943[(22)] = inst_14871);

(statearr_14943[(21)] = inst_14856__$1);

(statearr_14943[(12)] = inst_14859__$1);

return statearr_14943;
})();
var statearr_14944_15018 = state_14916__$1;
(statearr_14944_15018[(2)] = null);

(statearr_14944_15018[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (40))){
var inst_14884 = (state_14916[(23)]);
var inst_14888 = done.call(null,null);
var inst_14889 = cljs.core.async.untap_STAR_.call(null,m,inst_14884);
var state_14916__$1 = (function (){var statearr_14945 = state_14916;
(statearr_14945[(24)] = inst_14888);

return statearr_14945;
})();
var statearr_14946_15019 = state_14916__$1;
(statearr_14946_15019[(2)] = inst_14889);

(statearr_14946_15019[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (33))){
var inst_14875 = (state_14916[(25)]);
var inst_14877 = cljs.core.chunked_seq_QMARK_.call(null,inst_14875);
var state_14916__$1 = state_14916;
if(inst_14877){
var statearr_14947_15020 = state_14916__$1;
(statearr_14947_15020[(1)] = (36));

} else {
var statearr_14948_15021 = state_14916__$1;
(statearr_14948_15021[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (13))){
var inst_14807 = (state_14916[(26)]);
var inst_14810 = cljs.core.async.close_BANG_.call(null,inst_14807);
var state_14916__$1 = state_14916;
var statearr_14949_15022 = state_14916__$1;
(statearr_14949_15022[(2)] = inst_14810);

(statearr_14949_15022[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (22))){
var inst_14828 = (state_14916[(8)]);
var inst_14831 = cljs.core.async.close_BANG_.call(null,inst_14828);
var state_14916__$1 = state_14916;
var statearr_14950_15023 = state_14916__$1;
(statearr_14950_15023[(2)] = inst_14831);

(statearr_14950_15023[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (36))){
var inst_14875 = (state_14916[(25)]);
var inst_14879 = cljs.core.chunk_first.call(null,inst_14875);
var inst_14880 = cljs.core.chunk_rest.call(null,inst_14875);
var inst_14881 = cljs.core.count.call(null,inst_14879);
var inst_14856 = inst_14880;
var inst_14857 = inst_14879;
var inst_14858 = inst_14881;
var inst_14859 = (0);
var state_14916__$1 = (function (){var statearr_14951 = state_14916;
(statearr_14951[(20)] = inst_14858);

(statearr_14951[(10)] = inst_14857);

(statearr_14951[(21)] = inst_14856);

(statearr_14951[(12)] = inst_14859);

return statearr_14951;
})();
var statearr_14952_15024 = state_14916__$1;
(statearr_14952_15024[(2)] = null);

(statearr_14952_15024[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (41))){
var inst_14875 = (state_14916[(25)]);
var inst_14891 = (state_14916[(2)]);
var inst_14892 = cljs.core.next.call(null,inst_14875);
var inst_14856 = inst_14892;
var inst_14857 = null;
var inst_14858 = (0);
var inst_14859 = (0);
var state_14916__$1 = (function (){var statearr_14953 = state_14916;
(statearr_14953[(27)] = inst_14891);

(statearr_14953[(20)] = inst_14858);

(statearr_14953[(10)] = inst_14857);

(statearr_14953[(21)] = inst_14856);

(statearr_14953[(12)] = inst_14859);

return statearr_14953;
})();
var statearr_14954_15025 = state_14916__$1;
(statearr_14954_15025[(2)] = null);

(statearr_14954_15025[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (43))){
var state_14916__$1 = state_14916;
var statearr_14955_15026 = state_14916__$1;
(statearr_14955_15026[(2)] = null);

(statearr_14955_15026[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (29))){
var inst_14900 = (state_14916[(2)]);
var state_14916__$1 = state_14916;
var statearr_14956_15027 = state_14916__$1;
(statearr_14956_15027[(2)] = inst_14900);

(statearr_14956_15027[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (44))){
var inst_14909 = (state_14916[(2)]);
var state_14916__$1 = (function (){var statearr_14957 = state_14916;
(statearr_14957[(28)] = inst_14909);

return statearr_14957;
})();
var statearr_14958_15028 = state_14916__$1;
(statearr_14958_15028[(2)] = null);

(statearr_14958_15028[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (6))){
var inst_14848 = (state_14916[(29)]);
var inst_14847 = cljs.core.deref.call(null,cs);
var inst_14848__$1 = cljs.core.keys.call(null,inst_14847);
var inst_14849 = cljs.core.count.call(null,inst_14848__$1);
var inst_14850 = cljs.core.reset_BANG_.call(null,dctr,inst_14849);
var inst_14855 = cljs.core.seq.call(null,inst_14848__$1);
var inst_14856 = inst_14855;
var inst_14857 = null;
var inst_14858 = (0);
var inst_14859 = (0);
var state_14916__$1 = (function (){var statearr_14959 = state_14916;
(statearr_14959[(20)] = inst_14858);

(statearr_14959[(10)] = inst_14857);

(statearr_14959[(29)] = inst_14848__$1);

(statearr_14959[(30)] = inst_14850);

(statearr_14959[(21)] = inst_14856);

(statearr_14959[(12)] = inst_14859);

return statearr_14959;
})();
var statearr_14960_15029 = state_14916__$1;
(statearr_14960_15029[(2)] = null);

(statearr_14960_15029[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (28))){
var inst_14875 = (state_14916[(25)]);
var inst_14856 = (state_14916[(21)]);
var inst_14875__$1 = cljs.core.seq.call(null,inst_14856);
var state_14916__$1 = (function (){var statearr_14961 = state_14916;
(statearr_14961[(25)] = inst_14875__$1);

return statearr_14961;
})();
if(inst_14875__$1){
var statearr_14962_15030 = state_14916__$1;
(statearr_14962_15030[(1)] = (33));

} else {
var statearr_14963_15031 = state_14916__$1;
(statearr_14963_15031[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (25))){
var inst_14858 = (state_14916[(20)]);
var inst_14859 = (state_14916[(12)]);
var inst_14861 = (inst_14859 < inst_14858);
var inst_14862 = inst_14861;
var state_14916__$1 = state_14916;
if(cljs.core.truth_(inst_14862)){
var statearr_14964_15032 = state_14916__$1;
(statearr_14964_15032[(1)] = (27));

} else {
var statearr_14965_15033 = state_14916__$1;
(statearr_14965_15033[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (34))){
var state_14916__$1 = state_14916;
var statearr_14966_15034 = state_14916__$1;
(statearr_14966_15034[(2)] = null);

(statearr_14966_15034[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (17))){
var state_14916__$1 = state_14916;
var statearr_14967_15035 = state_14916__$1;
(statearr_14967_15035[(2)] = null);

(statearr_14967_15035[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (3))){
var inst_14914 = (state_14916[(2)]);
var state_14916__$1 = state_14916;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14916__$1,inst_14914);
} else {
if((state_val_14917 === (12))){
var inst_14843 = (state_14916[(2)]);
var state_14916__$1 = state_14916;
var statearr_14968_15036 = state_14916__$1;
(statearr_14968_15036[(2)] = inst_14843);

(statearr_14968_15036[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (2))){
var state_14916__$1 = state_14916;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14916__$1,(4),ch);
} else {
if((state_val_14917 === (23))){
var state_14916__$1 = state_14916;
var statearr_14969_15037 = state_14916__$1;
(statearr_14969_15037[(2)] = null);

(statearr_14969_15037[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (35))){
var inst_14898 = (state_14916[(2)]);
var state_14916__$1 = state_14916;
var statearr_14970_15038 = state_14916__$1;
(statearr_14970_15038[(2)] = inst_14898);

(statearr_14970_15038[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (19))){
var inst_14817 = (state_14916[(7)]);
var inst_14821 = cljs.core.chunk_first.call(null,inst_14817);
var inst_14822 = cljs.core.chunk_rest.call(null,inst_14817);
var inst_14823 = cljs.core.count.call(null,inst_14821);
var inst_14797 = inst_14822;
var inst_14798 = inst_14821;
var inst_14799 = inst_14823;
var inst_14800 = (0);
var state_14916__$1 = (function (){var statearr_14971 = state_14916;
(statearr_14971[(13)] = inst_14797);

(statearr_14971[(14)] = inst_14799);

(statearr_14971[(16)] = inst_14800);

(statearr_14971[(17)] = inst_14798);

return statearr_14971;
})();
var statearr_14972_15039 = state_14916__$1;
(statearr_14972_15039[(2)] = null);

(statearr_14972_15039[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (11))){
var inst_14797 = (state_14916[(13)]);
var inst_14817 = (state_14916[(7)]);
var inst_14817__$1 = cljs.core.seq.call(null,inst_14797);
var state_14916__$1 = (function (){var statearr_14973 = state_14916;
(statearr_14973[(7)] = inst_14817__$1);

return statearr_14973;
})();
if(inst_14817__$1){
var statearr_14974_15040 = state_14916__$1;
(statearr_14974_15040[(1)] = (16));

} else {
var statearr_14975_15041 = state_14916__$1;
(statearr_14975_15041[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (9))){
var inst_14845 = (state_14916[(2)]);
var state_14916__$1 = state_14916;
var statearr_14976_15042 = state_14916__$1;
(statearr_14976_15042[(2)] = inst_14845);

(statearr_14976_15042[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (5))){
var inst_14795 = cljs.core.deref.call(null,cs);
var inst_14796 = cljs.core.seq.call(null,inst_14795);
var inst_14797 = inst_14796;
var inst_14798 = null;
var inst_14799 = (0);
var inst_14800 = (0);
var state_14916__$1 = (function (){var statearr_14977 = state_14916;
(statearr_14977[(13)] = inst_14797);

(statearr_14977[(14)] = inst_14799);

(statearr_14977[(16)] = inst_14800);

(statearr_14977[(17)] = inst_14798);

return statearr_14977;
})();
var statearr_14978_15043 = state_14916__$1;
(statearr_14978_15043[(2)] = null);

(statearr_14978_15043[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (14))){
var state_14916__$1 = state_14916;
var statearr_14979_15044 = state_14916__$1;
(statearr_14979_15044[(2)] = null);

(statearr_14979_15044[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (45))){
var inst_14906 = (state_14916[(2)]);
var state_14916__$1 = state_14916;
var statearr_14980_15045 = state_14916__$1;
(statearr_14980_15045[(2)] = inst_14906);

(statearr_14980_15045[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (26))){
var inst_14848 = (state_14916[(29)]);
var inst_14902 = (state_14916[(2)]);
var inst_14903 = cljs.core.seq.call(null,inst_14848);
var state_14916__$1 = (function (){var statearr_14981 = state_14916;
(statearr_14981[(31)] = inst_14902);

return statearr_14981;
})();
if(inst_14903){
var statearr_14982_15046 = state_14916__$1;
(statearr_14982_15046[(1)] = (42));

} else {
var statearr_14983_15047 = state_14916__$1;
(statearr_14983_15047[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (16))){
var inst_14817 = (state_14916[(7)]);
var inst_14819 = cljs.core.chunked_seq_QMARK_.call(null,inst_14817);
var state_14916__$1 = state_14916;
if(inst_14819){
var statearr_14984_15048 = state_14916__$1;
(statearr_14984_15048[(1)] = (19));

} else {
var statearr_14985_15049 = state_14916__$1;
(statearr_14985_15049[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (38))){
var inst_14895 = (state_14916[(2)]);
var state_14916__$1 = state_14916;
var statearr_14986_15050 = state_14916__$1;
(statearr_14986_15050[(2)] = inst_14895);

(statearr_14986_15050[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (30))){
var state_14916__$1 = state_14916;
var statearr_14987_15051 = state_14916__$1;
(statearr_14987_15051[(2)] = null);

(statearr_14987_15051[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (10))){
var inst_14800 = (state_14916[(16)]);
var inst_14798 = (state_14916[(17)]);
var inst_14806 = cljs.core._nth.call(null,inst_14798,inst_14800);
var inst_14807 = cljs.core.nth.call(null,inst_14806,(0),null);
var inst_14808 = cljs.core.nth.call(null,inst_14806,(1),null);
var state_14916__$1 = (function (){var statearr_14988 = state_14916;
(statearr_14988[(26)] = inst_14807);

return statearr_14988;
})();
if(cljs.core.truth_(inst_14808)){
var statearr_14989_15052 = state_14916__$1;
(statearr_14989_15052[(1)] = (13));

} else {
var statearr_14990_15053 = state_14916__$1;
(statearr_14990_15053[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (18))){
var inst_14841 = (state_14916[(2)]);
var state_14916__$1 = state_14916;
var statearr_14991_15054 = state_14916__$1;
(statearr_14991_15054[(2)] = inst_14841);

(statearr_14991_15054[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (42))){
var state_14916__$1 = state_14916;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14916__$1,(45),dchan);
} else {
if((state_val_14917 === (37))){
var inst_14875 = (state_14916[(25)]);
var inst_14884 = (state_14916[(23)]);
var inst_14788 = (state_14916[(11)]);
var inst_14884__$1 = cljs.core.first.call(null,inst_14875);
var inst_14885 = cljs.core.async.put_BANG_.call(null,inst_14884__$1,inst_14788,done);
var state_14916__$1 = (function (){var statearr_14992 = state_14916;
(statearr_14992[(23)] = inst_14884__$1);

return statearr_14992;
})();
if(cljs.core.truth_(inst_14885)){
var statearr_14993_15055 = state_14916__$1;
(statearr_14993_15055[(1)] = (39));

} else {
var statearr_14994_15056 = state_14916__$1;
(statearr_14994_15056[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (8))){
var inst_14799 = (state_14916[(14)]);
var inst_14800 = (state_14916[(16)]);
var inst_14802 = (inst_14800 < inst_14799);
var inst_14803 = inst_14802;
var state_14916__$1 = state_14916;
if(cljs.core.truth_(inst_14803)){
var statearr_14995_15057 = state_14916__$1;
(statearr_14995_15057[(1)] = (10));

} else {
var statearr_14996_15058 = state_14916__$1;
(statearr_14996_15058[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___15004,cs,m,dchan,dctr,done))
;
return ((function (switch__7673__auto__,c__7694__auto___15004,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__7674__auto__ = null;
var cljs$core$async$mult_$_state_machine__7674__auto____0 = (function (){
var statearr_15000 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15000[(0)] = cljs$core$async$mult_$_state_machine__7674__auto__);

(statearr_15000[(1)] = (1));

return statearr_15000;
});
var cljs$core$async$mult_$_state_machine__7674__auto____1 = (function (state_14916){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14916);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e15001){if((e15001 instanceof Object)){
var ex__7677__auto__ = e15001;
var statearr_15002_15059 = state_14916;
(statearr_15002_15059[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14916);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15001;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15060 = state_14916;
state_14916 = G__15060;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__7674__auto__ = function(state_14916){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__7674__auto____1.call(this,state_14916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__7674__auto____0;
cljs$core$async$mult_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__7674__auto____1;
return cljs$core$async$mult_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___15004,cs,m,dchan,dctr,done))
})();
var state__7696__auto__ = (function (){var statearr_15003 = f__7695__auto__.call(null);
(statearr_15003[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___15004);

return statearr_15003;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___15004,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args15061 = [];
var len__5627__auto___15064 = arguments.length;
var i__5628__auto___15065 = (0);
while(true){
if((i__5628__auto___15065 < len__5627__auto___15064)){
args15061.push((arguments[i__5628__auto___15065]));

var G__15066 = (i__5628__auto___15065 + (1));
i__5628__auto___15065 = G__15066;
continue;
} else {
}
break;
}

var G__15063 = args15061.length;
switch (G__15063) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15061.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m);
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,state_map);
} else {
var m__5225__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,mode);
} else {
var m__5225__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___15078 = arguments.length;
var i__5628__auto___15079 = (0);
while(true){
if((i__5628__auto___15079 < len__5627__auto___15078)){
args__5634__auto__.push((arguments[i__5628__auto___15079]));

var G__15080 = (i__5628__auto___15079 + (1));
i__5628__auto___15079 = G__15080;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((3) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5635__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__15072){
var map__15073 = p__15072;
var map__15073__$1 = ((((!((map__15073 == null)))?((((map__15073.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15073.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15073):map__15073);
var opts = map__15073__$1;
var statearr_15075_15081 = state;
(statearr_15075_15081[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__15073,map__15073__$1,opts){
return (function (val){
var statearr_15076_15082 = state;
(statearr_15076_15082[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__15073,map__15073__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_15077_15083 = state;
(statearr_15077_15083[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq15068){
var G__15069 = cljs.core.first.call(null,seq15068);
var seq15068__$1 = cljs.core.next.call(null,seq15068);
var G__15070 = cljs.core.first.call(null,seq15068__$1);
var seq15068__$2 = cljs.core.next.call(null,seq15068__$1);
var G__15071 = cljs.core.first.call(null,seq15068__$2);
var seq15068__$3 = cljs.core.next.call(null,seq15068__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15069,G__15070,G__15071,seq15068__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async15247 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15247 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta15248){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta15248 = meta15248;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15247.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_15249,meta15248__$1){
var self__ = this;
var _15249__$1 = this;
return (new cljs.core.async.t_cljs$core$async15247(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta15248__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15247.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_15249){
var self__ = this;
var _15249__$1 = this;
return self__.meta15248;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15247.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15247.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15247.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async15247.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15247.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15247.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15247.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15247.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15247.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta15248","meta15248",-78626951,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15247.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15247.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15247";

cljs.core.async.t_cljs$core$async15247.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async15247");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async15247 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async15247(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta15248){
return (new cljs.core.async.t_cljs$core$async15247(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta15248));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async15247(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__7694__auto___15410 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___15410,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___15410,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_15347){
var state_val_15348 = (state_15347[(1)]);
if((state_val_15348 === (7))){
var inst_15265 = (state_15347[(2)]);
var state_15347__$1 = state_15347;
var statearr_15349_15411 = state_15347__$1;
(statearr_15349_15411[(2)] = inst_15265);

(statearr_15349_15411[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (20))){
var inst_15277 = (state_15347[(7)]);
var state_15347__$1 = state_15347;
var statearr_15350_15412 = state_15347__$1;
(statearr_15350_15412[(2)] = inst_15277);

(statearr_15350_15412[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (27))){
var state_15347__$1 = state_15347;
var statearr_15351_15413 = state_15347__$1;
(statearr_15351_15413[(2)] = null);

(statearr_15351_15413[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (1))){
var inst_15253 = (state_15347[(8)]);
var inst_15253__$1 = calc_state.call(null);
var inst_15255 = (inst_15253__$1 == null);
var inst_15256 = cljs.core.not.call(null,inst_15255);
var state_15347__$1 = (function (){var statearr_15352 = state_15347;
(statearr_15352[(8)] = inst_15253__$1);

return statearr_15352;
})();
if(inst_15256){
var statearr_15353_15414 = state_15347__$1;
(statearr_15353_15414[(1)] = (2));

} else {
var statearr_15354_15415 = state_15347__$1;
(statearr_15354_15415[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (24))){
var inst_15307 = (state_15347[(9)]);
var inst_15321 = (state_15347[(10)]);
var inst_15300 = (state_15347[(11)]);
var inst_15321__$1 = inst_15300.call(null,inst_15307);
var state_15347__$1 = (function (){var statearr_15355 = state_15347;
(statearr_15355[(10)] = inst_15321__$1);

return statearr_15355;
})();
if(cljs.core.truth_(inst_15321__$1)){
var statearr_15356_15416 = state_15347__$1;
(statearr_15356_15416[(1)] = (29));

} else {
var statearr_15357_15417 = state_15347__$1;
(statearr_15357_15417[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (4))){
var inst_15268 = (state_15347[(2)]);
var state_15347__$1 = state_15347;
if(cljs.core.truth_(inst_15268)){
var statearr_15358_15418 = state_15347__$1;
(statearr_15358_15418[(1)] = (8));

} else {
var statearr_15359_15419 = state_15347__$1;
(statearr_15359_15419[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (15))){
var inst_15294 = (state_15347[(2)]);
var state_15347__$1 = state_15347;
if(cljs.core.truth_(inst_15294)){
var statearr_15360_15420 = state_15347__$1;
(statearr_15360_15420[(1)] = (19));

} else {
var statearr_15361_15421 = state_15347__$1;
(statearr_15361_15421[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (21))){
var inst_15299 = (state_15347[(12)]);
var inst_15299__$1 = (state_15347[(2)]);
var inst_15300 = cljs.core.get.call(null,inst_15299__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_15301 = cljs.core.get.call(null,inst_15299__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_15302 = cljs.core.get.call(null,inst_15299__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_15347__$1 = (function (){var statearr_15362 = state_15347;
(statearr_15362[(12)] = inst_15299__$1);

(statearr_15362[(11)] = inst_15300);

(statearr_15362[(13)] = inst_15301);

return statearr_15362;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_15347__$1,(22),inst_15302);
} else {
if((state_val_15348 === (31))){
var inst_15329 = (state_15347[(2)]);
var state_15347__$1 = state_15347;
if(cljs.core.truth_(inst_15329)){
var statearr_15363_15422 = state_15347__$1;
(statearr_15363_15422[(1)] = (32));

} else {
var statearr_15364_15423 = state_15347__$1;
(statearr_15364_15423[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (32))){
var inst_15306 = (state_15347[(14)]);
var state_15347__$1 = state_15347;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15347__$1,(35),out,inst_15306);
} else {
if((state_val_15348 === (33))){
var inst_15299 = (state_15347[(12)]);
var inst_15277 = inst_15299;
var state_15347__$1 = (function (){var statearr_15365 = state_15347;
(statearr_15365[(7)] = inst_15277);

return statearr_15365;
})();
var statearr_15366_15424 = state_15347__$1;
(statearr_15366_15424[(2)] = null);

(statearr_15366_15424[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (13))){
var inst_15277 = (state_15347[(7)]);
var inst_15284 = inst_15277.cljs$lang$protocol_mask$partition0$;
var inst_15285 = (inst_15284 & (64));
var inst_15286 = inst_15277.cljs$core$ISeq$;
var inst_15287 = (inst_15285) || (inst_15286);
var state_15347__$1 = state_15347;
if(cljs.core.truth_(inst_15287)){
var statearr_15367_15425 = state_15347__$1;
(statearr_15367_15425[(1)] = (16));

} else {
var statearr_15368_15426 = state_15347__$1;
(statearr_15368_15426[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (22))){
var inst_15307 = (state_15347[(9)]);
var inst_15306 = (state_15347[(14)]);
var inst_15305 = (state_15347[(2)]);
var inst_15306__$1 = cljs.core.nth.call(null,inst_15305,(0),null);
var inst_15307__$1 = cljs.core.nth.call(null,inst_15305,(1),null);
var inst_15308 = (inst_15306__$1 == null);
var inst_15309 = cljs.core._EQ_.call(null,inst_15307__$1,change);
var inst_15310 = (inst_15308) || (inst_15309);
var state_15347__$1 = (function (){var statearr_15369 = state_15347;
(statearr_15369[(9)] = inst_15307__$1);

(statearr_15369[(14)] = inst_15306__$1);

return statearr_15369;
})();
if(cljs.core.truth_(inst_15310)){
var statearr_15370_15427 = state_15347__$1;
(statearr_15370_15427[(1)] = (23));

} else {
var statearr_15371_15428 = state_15347__$1;
(statearr_15371_15428[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (36))){
var inst_15299 = (state_15347[(12)]);
var inst_15277 = inst_15299;
var state_15347__$1 = (function (){var statearr_15372 = state_15347;
(statearr_15372[(7)] = inst_15277);

return statearr_15372;
})();
var statearr_15373_15429 = state_15347__$1;
(statearr_15373_15429[(2)] = null);

(statearr_15373_15429[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (29))){
var inst_15321 = (state_15347[(10)]);
var state_15347__$1 = state_15347;
var statearr_15374_15430 = state_15347__$1;
(statearr_15374_15430[(2)] = inst_15321);

(statearr_15374_15430[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (6))){
var state_15347__$1 = state_15347;
var statearr_15375_15431 = state_15347__$1;
(statearr_15375_15431[(2)] = false);

(statearr_15375_15431[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (28))){
var inst_15317 = (state_15347[(2)]);
var inst_15318 = calc_state.call(null);
var inst_15277 = inst_15318;
var state_15347__$1 = (function (){var statearr_15376 = state_15347;
(statearr_15376[(7)] = inst_15277);

(statearr_15376[(15)] = inst_15317);

return statearr_15376;
})();
var statearr_15377_15432 = state_15347__$1;
(statearr_15377_15432[(2)] = null);

(statearr_15377_15432[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (25))){
var inst_15343 = (state_15347[(2)]);
var state_15347__$1 = state_15347;
var statearr_15378_15433 = state_15347__$1;
(statearr_15378_15433[(2)] = inst_15343);

(statearr_15378_15433[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (34))){
var inst_15341 = (state_15347[(2)]);
var state_15347__$1 = state_15347;
var statearr_15379_15434 = state_15347__$1;
(statearr_15379_15434[(2)] = inst_15341);

(statearr_15379_15434[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (17))){
var state_15347__$1 = state_15347;
var statearr_15380_15435 = state_15347__$1;
(statearr_15380_15435[(2)] = false);

(statearr_15380_15435[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (3))){
var state_15347__$1 = state_15347;
var statearr_15381_15436 = state_15347__$1;
(statearr_15381_15436[(2)] = false);

(statearr_15381_15436[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (12))){
var inst_15345 = (state_15347[(2)]);
var state_15347__$1 = state_15347;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15347__$1,inst_15345);
} else {
if((state_val_15348 === (2))){
var inst_15253 = (state_15347[(8)]);
var inst_15258 = inst_15253.cljs$lang$protocol_mask$partition0$;
var inst_15259 = (inst_15258 & (64));
var inst_15260 = inst_15253.cljs$core$ISeq$;
var inst_15261 = (inst_15259) || (inst_15260);
var state_15347__$1 = state_15347;
if(cljs.core.truth_(inst_15261)){
var statearr_15382_15437 = state_15347__$1;
(statearr_15382_15437[(1)] = (5));

} else {
var statearr_15383_15438 = state_15347__$1;
(statearr_15383_15438[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (23))){
var inst_15306 = (state_15347[(14)]);
var inst_15312 = (inst_15306 == null);
var state_15347__$1 = state_15347;
if(cljs.core.truth_(inst_15312)){
var statearr_15384_15439 = state_15347__$1;
(statearr_15384_15439[(1)] = (26));

} else {
var statearr_15385_15440 = state_15347__$1;
(statearr_15385_15440[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (35))){
var inst_15332 = (state_15347[(2)]);
var state_15347__$1 = state_15347;
if(cljs.core.truth_(inst_15332)){
var statearr_15386_15441 = state_15347__$1;
(statearr_15386_15441[(1)] = (36));

} else {
var statearr_15387_15442 = state_15347__$1;
(statearr_15387_15442[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (19))){
var inst_15277 = (state_15347[(7)]);
var inst_15296 = cljs.core.apply.call(null,cljs.core.hash_map,inst_15277);
var state_15347__$1 = state_15347;
var statearr_15388_15443 = state_15347__$1;
(statearr_15388_15443[(2)] = inst_15296);

(statearr_15388_15443[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (11))){
var inst_15277 = (state_15347[(7)]);
var inst_15281 = (inst_15277 == null);
var inst_15282 = cljs.core.not.call(null,inst_15281);
var state_15347__$1 = state_15347;
if(inst_15282){
var statearr_15389_15444 = state_15347__$1;
(statearr_15389_15444[(1)] = (13));

} else {
var statearr_15390_15445 = state_15347__$1;
(statearr_15390_15445[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (9))){
var inst_15253 = (state_15347[(8)]);
var state_15347__$1 = state_15347;
var statearr_15391_15446 = state_15347__$1;
(statearr_15391_15446[(2)] = inst_15253);

(statearr_15391_15446[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (5))){
var state_15347__$1 = state_15347;
var statearr_15392_15447 = state_15347__$1;
(statearr_15392_15447[(2)] = true);

(statearr_15392_15447[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (14))){
var state_15347__$1 = state_15347;
var statearr_15393_15448 = state_15347__$1;
(statearr_15393_15448[(2)] = false);

(statearr_15393_15448[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (26))){
var inst_15307 = (state_15347[(9)]);
var inst_15314 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_15307);
var state_15347__$1 = state_15347;
var statearr_15394_15449 = state_15347__$1;
(statearr_15394_15449[(2)] = inst_15314);

(statearr_15394_15449[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (16))){
var state_15347__$1 = state_15347;
var statearr_15395_15450 = state_15347__$1;
(statearr_15395_15450[(2)] = true);

(statearr_15395_15450[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (38))){
var inst_15337 = (state_15347[(2)]);
var state_15347__$1 = state_15347;
var statearr_15396_15451 = state_15347__$1;
(statearr_15396_15451[(2)] = inst_15337);

(statearr_15396_15451[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (30))){
var inst_15307 = (state_15347[(9)]);
var inst_15300 = (state_15347[(11)]);
var inst_15301 = (state_15347[(13)]);
var inst_15324 = cljs.core.empty_QMARK_.call(null,inst_15300);
var inst_15325 = inst_15301.call(null,inst_15307);
var inst_15326 = cljs.core.not.call(null,inst_15325);
var inst_15327 = (inst_15324) && (inst_15326);
var state_15347__$1 = state_15347;
var statearr_15397_15452 = state_15347__$1;
(statearr_15397_15452[(2)] = inst_15327);

(statearr_15397_15452[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (10))){
var inst_15253 = (state_15347[(8)]);
var inst_15273 = (state_15347[(2)]);
var inst_15274 = cljs.core.get.call(null,inst_15273,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_15275 = cljs.core.get.call(null,inst_15273,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_15276 = cljs.core.get.call(null,inst_15273,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_15277 = inst_15253;
var state_15347__$1 = (function (){var statearr_15398 = state_15347;
(statearr_15398[(7)] = inst_15277);

(statearr_15398[(16)] = inst_15275);

(statearr_15398[(17)] = inst_15276);

(statearr_15398[(18)] = inst_15274);

return statearr_15398;
})();
var statearr_15399_15453 = state_15347__$1;
(statearr_15399_15453[(2)] = null);

(statearr_15399_15453[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (18))){
var inst_15291 = (state_15347[(2)]);
var state_15347__$1 = state_15347;
var statearr_15400_15454 = state_15347__$1;
(statearr_15400_15454[(2)] = inst_15291);

(statearr_15400_15454[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (37))){
var state_15347__$1 = state_15347;
var statearr_15401_15455 = state_15347__$1;
(statearr_15401_15455[(2)] = null);

(statearr_15401_15455[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15348 === (8))){
var inst_15253 = (state_15347[(8)]);
var inst_15270 = cljs.core.apply.call(null,cljs.core.hash_map,inst_15253);
var state_15347__$1 = state_15347;
var statearr_15402_15456 = state_15347__$1;
(statearr_15402_15456[(2)] = inst_15270);

(statearr_15402_15456[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___15410,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__7673__auto__,c__7694__auto___15410,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__7674__auto__ = null;
var cljs$core$async$mix_$_state_machine__7674__auto____0 = (function (){
var statearr_15406 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15406[(0)] = cljs$core$async$mix_$_state_machine__7674__auto__);

(statearr_15406[(1)] = (1));

return statearr_15406;
});
var cljs$core$async$mix_$_state_machine__7674__auto____1 = (function (state_15347){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_15347);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e15407){if((e15407 instanceof Object)){
var ex__7677__auto__ = e15407;
var statearr_15408_15457 = state_15347;
(statearr_15408_15457[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15347);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15407;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15458 = state_15347;
state_15347 = G__15458;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__7674__auto__ = function(state_15347){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__7674__auto____1.call(this,state_15347);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__7674__auto____0;
cljs$core$async$mix_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__7674__auto____1;
return cljs$core$async$mix_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___15410,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__7696__auto__ = (function (){var statearr_15409 = f__7695__auto__.call(null);
(statearr_15409[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___15410);

return statearr_15409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___15410,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5225__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p,v,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args15459 = [];
var len__5627__auto___15462 = arguments.length;
var i__5628__auto___15463 = (0);
while(true){
if((i__5628__auto___15463 < len__5627__auto___15462)){
args15459.push((arguments[i__5628__auto___15463]));

var G__15464 = (i__5628__auto___15463 + (1));
i__5628__auto___15463 = G__15464;
continue;
} else {
}
break;
}

var G__15461 = args15459.length;
switch (G__15461) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15459.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p);
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p,v);
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args15467 = [];
var len__5627__auto___15592 = arguments.length;
var i__5628__auto___15593 = (0);
while(true){
if((i__5628__auto___15593 < len__5627__auto___15592)){
args15467.push((arguments[i__5628__auto___15593]));

var G__15594 = (i__5628__auto___15593 + (1));
i__5628__auto___15593 = G__15594;
continue;
} else {
}
break;
}

var G__15469 = args15467.length;
switch (G__15469) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15467.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4569__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4569__auto__,mults){
return (function (p1__15466_SHARP_){
if(cljs.core.truth_(p1__15466_SHARP_.call(null,topic))){
return p1__15466_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__15466_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4569__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async15470 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15470 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta15471){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta15471 = meta15471;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15470.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_15472,meta15471__$1){
var self__ = this;
var _15472__$1 = this;
return (new cljs.core.async.t_cljs$core$async15470(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta15471__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15470.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_15472){
var self__ = this;
var _15472__$1 = this;
return self__.meta15471;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15470.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15470.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15470.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async15470.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15470.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15470.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15470.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15470.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta15471","meta15471",797443053,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15470.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15470.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15470";

cljs.core.async.t_cljs$core$async15470.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async15470");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async15470 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async15470(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta15471){
return (new cljs.core.async.t_cljs$core$async15470(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta15471));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async15470(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__7694__auto___15596 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___15596,mults,ensure_mult,p){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___15596,mults,ensure_mult,p){
return (function (state_15544){
var state_val_15545 = (state_15544[(1)]);
if((state_val_15545 === (7))){
var inst_15540 = (state_15544[(2)]);
var state_15544__$1 = state_15544;
var statearr_15546_15597 = state_15544__$1;
(statearr_15546_15597[(2)] = inst_15540);

(statearr_15546_15597[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15545 === (20))){
var state_15544__$1 = state_15544;
var statearr_15547_15598 = state_15544__$1;
(statearr_15547_15598[(2)] = null);

(statearr_15547_15598[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15545 === (1))){
var state_15544__$1 = state_15544;
var statearr_15548_15599 = state_15544__$1;
(statearr_15548_15599[(2)] = null);

(statearr_15548_15599[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15545 === (24))){
var inst_15523 = (state_15544[(7)]);
var inst_15532 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_15523);
var state_15544__$1 = state_15544;
var statearr_15549_15600 = state_15544__$1;
(statearr_15549_15600[(2)] = inst_15532);

(statearr_15549_15600[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15545 === (4))){
var inst_15475 = (state_15544[(8)]);
var inst_15475__$1 = (state_15544[(2)]);
var inst_15476 = (inst_15475__$1 == null);
var state_15544__$1 = (function (){var statearr_15550 = state_15544;
(statearr_15550[(8)] = inst_15475__$1);

return statearr_15550;
})();
if(cljs.core.truth_(inst_15476)){
var statearr_15551_15601 = state_15544__$1;
(statearr_15551_15601[(1)] = (5));

} else {
var statearr_15552_15602 = state_15544__$1;
(statearr_15552_15602[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15545 === (15))){
var inst_15517 = (state_15544[(2)]);
var state_15544__$1 = state_15544;
var statearr_15553_15603 = state_15544__$1;
(statearr_15553_15603[(2)] = inst_15517);

(statearr_15553_15603[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15545 === (21))){
var inst_15537 = (state_15544[(2)]);
var state_15544__$1 = (function (){var statearr_15554 = state_15544;
(statearr_15554[(9)] = inst_15537);

return statearr_15554;
})();
var statearr_15555_15604 = state_15544__$1;
(statearr_15555_15604[(2)] = null);

(statearr_15555_15604[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15545 === (13))){
var inst_15499 = (state_15544[(10)]);
var inst_15501 = cljs.core.chunked_seq_QMARK_.call(null,inst_15499);
var state_15544__$1 = state_15544;
if(inst_15501){
var statearr_15556_15605 = state_15544__$1;
(statearr_15556_15605[(1)] = (16));

} else {
var statearr_15557_15606 = state_15544__$1;
(statearr_15557_15606[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15545 === (22))){
var inst_15529 = (state_15544[(2)]);
var state_15544__$1 = state_15544;
if(cljs.core.truth_(inst_15529)){
var statearr_15558_15607 = state_15544__$1;
(statearr_15558_15607[(1)] = (23));

} else {
var statearr_15559_15608 = state_15544__$1;
(statearr_15559_15608[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15545 === (6))){
var inst_15475 = (state_15544[(8)]);
var inst_15525 = (state_15544[(11)]);
var inst_15523 = (state_15544[(7)]);
var inst_15523__$1 = topic_fn.call(null,inst_15475);
var inst_15524 = cljs.core.deref.call(null,mults);
var inst_15525__$1 = cljs.core.get.call(null,inst_15524,inst_15523__$1);
var state_15544__$1 = (function (){var statearr_15560 = state_15544;
(statearr_15560[(11)] = inst_15525__$1);

(statearr_15560[(7)] = inst_15523__$1);

return statearr_15560;
})();
if(cljs.core.truth_(inst_15525__$1)){
var statearr_15561_15609 = state_15544__$1;
(statearr_15561_15609[(1)] = (19));

} else {
var statearr_15562_15610 = state_15544__$1;
(statearr_15562_15610[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15545 === (25))){
var inst_15534 = (state_15544[(2)]);
var state_15544__$1 = state_15544;
var statearr_15563_15611 = state_15544__$1;
(statearr_15563_15611[(2)] = inst_15534);

(statearr_15563_15611[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15545 === (17))){
var inst_15499 = (state_15544[(10)]);
var inst_15508 = cljs.core.first.call(null,inst_15499);
var inst_15509 = cljs.core.async.muxch_STAR_.call(null,inst_15508);
var inst_15510 = cljs.core.async.close_BANG_.call(null,inst_15509);
var inst_15511 = cljs.core.next.call(null,inst_15499);
var inst_15485 = inst_15511;
var inst_15486 = null;
var inst_15487 = (0);
var inst_15488 = (0);
var state_15544__$1 = (function (){var statearr_15564 = state_15544;
(statearr_15564[(12)] = inst_15486);

(statearr_15564[(13)] = inst_15488);

(statearr_15564[(14)] = inst_15485);

(statearr_15564[(15)] = inst_15510);

(statearr_15564[(16)] = inst_15487);

return statearr_15564;
})();
var statearr_15565_15612 = state_15544__$1;
(statearr_15565_15612[(2)] = null);

(statearr_15565_15612[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15545 === (3))){
var inst_15542 = (state_15544[(2)]);
var state_15544__$1 = state_15544;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15544__$1,inst_15542);
} else {
if((state_val_15545 === (12))){
var inst_15519 = (state_15544[(2)]);
var state_15544__$1 = state_15544;
var statearr_15566_15613 = state_15544__$1;
(statearr_15566_15613[(2)] = inst_15519);

(statearr_15566_15613[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15545 === (2))){
var state_15544__$1 = state_15544;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15544__$1,(4),ch);
} else {
if((state_val_15545 === (23))){
var state_15544__$1 = state_15544;
var statearr_15567_15614 = state_15544__$1;
(statearr_15567_15614[(2)] = null);

(statearr_15567_15614[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15545 === (19))){
var inst_15475 = (state_15544[(8)]);
var inst_15525 = (state_15544[(11)]);
var inst_15527 = cljs.core.async.muxch_STAR_.call(null,inst_15525);
var state_15544__$1 = state_15544;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15544__$1,(22),inst_15527,inst_15475);
} else {
if((state_val_15545 === (11))){
var inst_15499 = (state_15544[(10)]);
var inst_15485 = (state_15544[(14)]);
var inst_15499__$1 = cljs.core.seq.call(null,inst_15485);
var state_15544__$1 = (function (){var statearr_15568 = state_15544;
(statearr_15568[(10)] = inst_15499__$1);

return statearr_15568;
})();
if(inst_15499__$1){
var statearr_15569_15615 = state_15544__$1;
(statearr_15569_15615[(1)] = (13));

} else {
var statearr_15570_15616 = state_15544__$1;
(statearr_15570_15616[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15545 === (9))){
var inst_15521 = (state_15544[(2)]);
var state_15544__$1 = state_15544;
var statearr_15571_15617 = state_15544__$1;
(statearr_15571_15617[(2)] = inst_15521);

(statearr_15571_15617[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15545 === (5))){
var inst_15482 = cljs.core.deref.call(null,mults);
var inst_15483 = cljs.core.vals.call(null,inst_15482);
var inst_15484 = cljs.core.seq.call(null,inst_15483);
var inst_15485 = inst_15484;
var inst_15486 = null;
var inst_15487 = (0);
var inst_15488 = (0);
var state_15544__$1 = (function (){var statearr_15572 = state_15544;
(statearr_15572[(12)] = inst_15486);

(statearr_15572[(13)] = inst_15488);

(statearr_15572[(14)] = inst_15485);

(statearr_15572[(16)] = inst_15487);

return statearr_15572;
})();
var statearr_15573_15618 = state_15544__$1;
(statearr_15573_15618[(2)] = null);

(statearr_15573_15618[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15545 === (14))){
var state_15544__$1 = state_15544;
var statearr_15577_15619 = state_15544__$1;
(statearr_15577_15619[(2)] = null);

(statearr_15577_15619[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15545 === (16))){
var inst_15499 = (state_15544[(10)]);
var inst_15503 = cljs.core.chunk_first.call(null,inst_15499);
var inst_15504 = cljs.core.chunk_rest.call(null,inst_15499);
var inst_15505 = cljs.core.count.call(null,inst_15503);
var inst_15485 = inst_15504;
var inst_15486 = inst_15503;
var inst_15487 = inst_15505;
var inst_15488 = (0);
var state_15544__$1 = (function (){var statearr_15578 = state_15544;
(statearr_15578[(12)] = inst_15486);

(statearr_15578[(13)] = inst_15488);

(statearr_15578[(14)] = inst_15485);

(statearr_15578[(16)] = inst_15487);

return statearr_15578;
})();
var statearr_15579_15620 = state_15544__$1;
(statearr_15579_15620[(2)] = null);

(statearr_15579_15620[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15545 === (10))){
var inst_15486 = (state_15544[(12)]);
var inst_15488 = (state_15544[(13)]);
var inst_15485 = (state_15544[(14)]);
var inst_15487 = (state_15544[(16)]);
var inst_15493 = cljs.core._nth.call(null,inst_15486,inst_15488);
var inst_15494 = cljs.core.async.muxch_STAR_.call(null,inst_15493);
var inst_15495 = cljs.core.async.close_BANG_.call(null,inst_15494);
var inst_15496 = (inst_15488 + (1));
var tmp15574 = inst_15486;
var tmp15575 = inst_15485;
var tmp15576 = inst_15487;
var inst_15485__$1 = tmp15575;
var inst_15486__$1 = tmp15574;
var inst_15487__$1 = tmp15576;
var inst_15488__$1 = inst_15496;
var state_15544__$1 = (function (){var statearr_15580 = state_15544;
(statearr_15580[(12)] = inst_15486__$1);

(statearr_15580[(13)] = inst_15488__$1);

(statearr_15580[(17)] = inst_15495);

(statearr_15580[(14)] = inst_15485__$1);

(statearr_15580[(16)] = inst_15487__$1);

return statearr_15580;
})();
var statearr_15581_15621 = state_15544__$1;
(statearr_15581_15621[(2)] = null);

(statearr_15581_15621[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15545 === (18))){
var inst_15514 = (state_15544[(2)]);
var state_15544__$1 = state_15544;
var statearr_15582_15622 = state_15544__$1;
(statearr_15582_15622[(2)] = inst_15514);

(statearr_15582_15622[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15545 === (8))){
var inst_15488 = (state_15544[(13)]);
var inst_15487 = (state_15544[(16)]);
var inst_15490 = (inst_15488 < inst_15487);
var inst_15491 = inst_15490;
var state_15544__$1 = state_15544;
if(cljs.core.truth_(inst_15491)){
var statearr_15583_15623 = state_15544__$1;
(statearr_15583_15623[(1)] = (10));

} else {
var statearr_15584_15624 = state_15544__$1;
(statearr_15584_15624[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___15596,mults,ensure_mult,p))
;
return ((function (switch__7673__auto__,c__7694__auto___15596,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_15588 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15588[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_15588[(1)] = (1));

return statearr_15588;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_15544){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_15544);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e15589){if((e15589 instanceof Object)){
var ex__7677__auto__ = e15589;
var statearr_15590_15625 = state_15544;
(statearr_15590_15625[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15544);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15589;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15626 = state_15544;
state_15544 = G__15626;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_15544){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_15544);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___15596,mults,ensure_mult,p))
})();
var state__7696__auto__ = (function (){var statearr_15591 = f__7695__auto__.call(null);
(statearr_15591[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___15596);

return statearr_15591;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___15596,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args15627 = [];
var len__5627__auto___15630 = arguments.length;
var i__5628__auto___15631 = (0);
while(true){
if((i__5628__auto___15631 < len__5627__auto___15630)){
args15627.push((arguments[i__5628__auto___15631]));

var G__15632 = (i__5628__auto___15631 + (1));
i__5628__auto___15631 = G__15632;
continue;
} else {
}
break;
}

var G__15629 = args15627.length;
switch (G__15629) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15627.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args15634 = [];
var len__5627__auto___15637 = arguments.length;
var i__5628__auto___15638 = (0);
while(true){
if((i__5628__auto___15638 < len__5627__auto___15637)){
args15634.push((arguments[i__5628__auto___15638]));

var G__15639 = (i__5628__auto___15638 + (1));
i__5628__auto___15638 = G__15639;
continue;
} else {
}
break;
}

var G__15636 = args15634.length;
switch (G__15636) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15634.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args15641 = [];
var len__5627__auto___15712 = arguments.length;
var i__5628__auto___15713 = (0);
while(true){
if((i__5628__auto___15713 < len__5627__auto___15712)){
args15641.push((arguments[i__5628__auto___15713]));

var G__15714 = (i__5628__auto___15713 + (1));
i__5628__auto___15713 = G__15714;
continue;
} else {
}
break;
}

var G__15643 = args15641.length;
switch (G__15643) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15641.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__7694__auto___15716 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___15716,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___15716,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_15682){
var state_val_15683 = (state_15682[(1)]);
if((state_val_15683 === (7))){
var state_15682__$1 = state_15682;
var statearr_15684_15717 = state_15682__$1;
(statearr_15684_15717[(2)] = null);

(statearr_15684_15717[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (1))){
var state_15682__$1 = state_15682;
var statearr_15685_15718 = state_15682__$1;
(statearr_15685_15718[(2)] = null);

(statearr_15685_15718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (4))){
var inst_15646 = (state_15682[(7)]);
var inst_15648 = (inst_15646 < cnt);
var state_15682__$1 = state_15682;
if(cljs.core.truth_(inst_15648)){
var statearr_15686_15719 = state_15682__$1;
(statearr_15686_15719[(1)] = (6));

} else {
var statearr_15687_15720 = state_15682__$1;
(statearr_15687_15720[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (15))){
var inst_15678 = (state_15682[(2)]);
var state_15682__$1 = state_15682;
var statearr_15688_15721 = state_15682__$1;
(statearr_15688_15721[(2)] = inst_15678);

(statearr_15688_15721[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (13))){
var inst_15671 = cljs.core.async.close_BANG_.call(null,out);
var state_15682__$1 = state_15682;
var statearr_15689_15722 = state_15682__$1;
(statearr_15689_15722[(2)] = inst_15671);

(statearr_15689_15722[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (6))){
var state_15682__$1 = state_15682;
var statearr_15690_15723 = state_15682__$1;
(statearr_15690_15723[(2)] = null);

(statearr_15690_15723[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (3))){
var inst_15680 = (state_15682[(2)]);
var state_15682__$1 = state_15682;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15682__$1,inst_15680);
} else {
if((state_val_15683 === (12))){
var inst_15668 = (state_15682[(8)]);
var inst_15668__$1 = (state_15682[(2)]);
var inst_15669 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_15668__$1);
var state_15682__$1 = (function (){var statearr_15691 = state_15682;
(statearr_15691[(8)] = inst_15668__$1);

return statearr_15691;
})();
if(cljs.core.truth_(inst_15669)){
var statearr_15692_15724 = state_15682__$1;
(statearr_15692_15724[(1)] = (13));

} else {
var statearr_15693_15725 = state_15682__$1;
(statearr_15693_15725[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (2))){
var inst_15645 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_15646 = (0);
var state_15682__$1 = (function (){var statearr_15694 = state_15682;
(statearr_15694[(7)] = inst_15646);

(statearr_15694[(9)] = inst_15645);

return statearr_15694;
})();
var statearr_15695_15726 = state_15682__$1;
(statearr_15695_15726[(2)] = null);

(statearr_15695_15726[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (11))){
var inst_15646 = (state_15682[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_15682,(10),Object,null,(9));
var inst_15655 = chs__$1.call(null,inst_15646);
var inst_15656 = done.call(null,inst_15646);
var inst_15657 = cljs.core.async.take_BANG_.call(null,inst_15655,inst_15656);
var state_15682__$1 = state_15682;
var statearr_15696_15727 = state_15682__$1;
(statearr_15696_15727[(2)] = inst_15657);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15682__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (9))){
var inst_15646 = (state_15682[(7)]);
var inst_15659 = (state_15682[(2)]);
var inst_15660 = (inst_15646 + (1));
var inst_15646__$1 = inst_15660;
var state_15682__$1 = (function (){var statearr_15697 = state_15682;
(statearr_15697[(7)] = inst_15646__$1);

(statearr_15697[(10)] = inst_15659);

return statearr_15697;
})();
var statearr_15698_15728 = state_15682__$1;
(statearr_15698_15728[(2)] = null);

(statearr_15698_15728[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (5))){
var inst_15666 = (state_15682[(2)]);
var state_15682__$1 = (function (){var statearr_15699 = state_15682;
(statearr_15699[(11)] = inst_15666);

return statearr_15699;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15682__$1,(12),dchan);
} else {
if((state_val_15683 === (14))){
var inst_15668 = (state_15682[(8)]);
var inst_15673 = cljs.core.apply.call(null,f,inst_15668);
var state_15682__$1 = state_15682;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15682__$1,(16),out,inst_15673);
} else {
if((state_val_15683 === (16))){
var inst_15675 = (state_15682[(2)]);
var state_15682__$1 = (function (){var statearr_15700 = state_15682;
(statearr_15700[(12)] = inst_15675);

return statearr_15700;
})();
var statearr_15701_15729 = state_15682__$1;
(statearr_15701_15729[(2)] = null);

(statearr_15701_15729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (10))){
var inst_15650 = (state_15682[(2)]);
var inst_15651 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_15682__$1 = (function (){var statearr_15702 = state_15682;
(statearr_15702[(13)] = inst_15650);

return statearr_15702;
})();
var statearr_15703_15730 = state_15682__$1;
(statearr_15703_15730[(2)] = inst_15651);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15682__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (8))){
var inst_15664 = (state_15682[(2)]);
var state_15682__$1 = state_15682;
var statearr_15704_15731 = state_15682__$1;
(statearr_15704_15731[(2)] = inst_15664);

(statearr_15704_15731[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___15716,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__7673__auto__,c__7694__auto___15716,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_15708 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15708[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_15708[(1)] = (1));

return statearr_15708;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_15682){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_15682);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e15709){if((e15709 instanceof Object)){
var ex__7677__auto__ = e15709;
var statearr_15710_15732 = state_15682;
(statearr_15710_15732[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15682);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15709;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15733 = state_15682;
state_15682 = G__15733;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_15682){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_15682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___15716,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__7696__auto__ = (function (){var statearr_15711 = f__7695__auto__.call(null);
(statearr_15711[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___15716);

return statearr_15711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___15716,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args15735 = [];
var len__5627__auto___15791 = arguments.length;
var i__5628__auto___15792 = (0);
while(true){
if((i__5628__auto___15792 < len__5627__auto___15791)){
args15735.push((arguments[i__5628__auto___15792]));

var G__15793 = (i__5628__auto___15792 + (1));
i__5628__auto___15792 = G__15793;
continue;
} else {
}
break;
}

var G__15737 = args15735.length;
switch (G__15737) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15735.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7694__auto___15795 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___15795,out){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___15795,out){
return (function (state_15767){
var state_val_15768 = (state_15767[(1)]);
if((state_val_15768 === (7))){
var inst_15747 = (state_15767[(7)]);
var inst_15746 = (state_15767[(8)]);
var inst_15746__$1 = (state_15767[(2)]);
var inst_15747__$1 = cljs.core.nth.call(null,inst_15746__$1,(0),null);
var inst_15748 = cljs.core.nth.call(null,inst_15746__$1,(1),null);
var inst_15749 = (inst_15747__$1 == null);
var state_15767__$1 = (function (){var statearr_15769 = state_15767;
(statearr_15769[(9)] = inst_15748);

(statearr_15769[(7)] = inst_15747__$1);

(statearr_15769[(8)] = inst_15746__$1);

return statearr_15769;
})();
if(cljs.core.truth_(inst_15749)){
var statearr_15770_15796 = state_15767__$1;
(statearr_15770_15796[(1)] = (8));

} else {
var statearr_15771_15797 = state_15767__$1;
(statearr_15771_15797[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (1))){
var inst_15738 = cljs.core.vec.call(null,chs);
var inst_15739 = inst_15738;
var state_15767__$1 = (function (){var statearr_15772 = state_15767;
(statearr_15772[(10)] = inst_15739);

return statearr_15772;
})();
var statearr_15773_15798 = state_15767__$1;
(statearr_15773_15798[(2)] = null);

(statearr_15773_15798[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (4))){
var inst_15739 = (state_15767[(10)]);
var state_15767__$1 = state_15767;
return cljs.core.async.ioc_alts_BANG_.call(null,state_15767__$1,(7),inst_15739);
} else {
if((state_val_15768 === (6))){
var inst_15763 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15774_15799 = state_15767__$1;
(statearr_15774_15799[(2)] = inst_15763);

(statearr_15774_15799[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (3))){
var inst_15765 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15767__$1,inst_15765);
} else {
if((state_val_15768 === (2))){
var inst_15739 = (state_15767[(10)]);
var inst_15741 = cljs.core.count.call(null,inst_15739);
var inst_15742 = (inst_15741 > (0));
var state_15767__$1 = state_15767;
if(cljs.core.truth_(inst_15742)){
var statearr_15776_15800 = state_15767__$1;
(statearr_15776_15800[(1)] = (4));

} else {
var statearr_15777_15801 = state_15767__$1;
(statearr_15777_15801[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (11))){
var inst_15739 = (state_15767[(10)]);
var inst_15756 = (state_15767[(2)]);
var tmp15775 = inst_15739;
var inst_15739__$1 = tmp15775;
var state_15767__$1 = (function (){var statearr_15778 = state_15767;
(statearr_15778[(10)] = inst_15739__$1);

(statearr_15778[(11)] = inst_15756);

return statearr_15778;
})();
var statearr_15779_15802 = state_15767__$1;
(statearr_15779_15802[(2)] = null);

(statearr_15779_15802[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (9))){
var inst_15747 = (state_15767[(7)]);
var state_15767__$1 = state_15767;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15767__$1,(11),out,inst_15747);
} else {
if((state_val_15768 === (5))){
var inst_15761 = cljs.core.async.close_BANG_.call(null,out);
var state_15767__$1 = state_15767;
var statearr_15780_15803 = state_15767__$1;
(statearr_15780_15803[(2)] = inst_15761);

(statearr_15780_15803[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (10))){
var inst_15759 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15781_15804 = state_15767__$1;
(statearr_15781_15804[(2)] = inst_15759);

(statearr_15781_15804[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (8))){
var inst_15748 = (state_15767[(9)]);
var inst_15739 = (state_15767[(10)]);
var inst_15747 = (state_15767[(7)]);
var inst_15746 = (state_15767[(8)]);
var inst_15751 = (function (){var cs = inst_15739;
var vec__15744 = inst_15746;
var v = inst_15747;
var c = inst_15748;
return ((function (cs,vec__15744,v,c,inst_15748,inst_15739,inst_15747,inst_15746,state_val_15768,c__7694__auto___15795,out){
return (function (p1__15734_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__15734_SHARP_);
});
;})(cs,vec__15744,v,c,inst_15748,inst_15739,inst_15747,inst_15746,state_val_15768,c__7694__auto___15795,out))
})();
var inst_15752 = cljs.core.filterv.call(null,inst_15751,inst_15739);
var inst_15739__$1 = inst_15752;
var state_15767__$1 = (function (){var statearr_15782 = state_15767;
(statearr_15782[(10)] = inst_15739__$1);

return statearr_15782;
})();
var statearr_15783_15805 = state_15767__$1;
(statearr_15783_15805[(2)] = null);

(statearr_15783_15805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___15795,out))
;
return ((function (switch__7673__auto__,c__7694__auto___15795,out){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_15787 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15787[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_15787[(1)] = (1));

return statearr_15787;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_15767){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_15767);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e15788){if((e15788 instanceof Object)){
var ex__7677__auto__ = e15788;
var statearr_15789_15806 = state_15767;
(statearr_15789_15806[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15767);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15788;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15807 = state_15767;
state_15767 = G__15807;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_15767){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_15767);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___15795,out))
})();
var state__7696__auto__ = (function (){var statearr_15790 = f__7695__auto__.call(null);
(statearr_15790[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___15795);

return statearr_15790;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___15795,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args15808 = [];
var len__5627__auto___15857 = arguments.length;
var i__5628__auto___15858 = (0);
while(true){
if((i__5628__auto___15858 < len__5627__auto___15857)){
args15808.push((arguments[i__5628__auto___15858]));

var G__15859 = (i__5628__auto___15858 + (1));
i__5628__auto___15858 = G__15859;
continue;
} else {
}
break;
}

var G__15810 = args15808.length;
switch (G__15810) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15808.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7694__auto___15861 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___15861,out){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___15861,out){
return (function (state_15834){
var state_val_15835 = (state_15834[(1)]);
if((state_val_15835 === (7))){
var inst_15816 = (state_15834[(7)]);
var inst_15816__$1 = (state_15834[(2)]);
var inst_15817 = (inst_15816__$1 == null);
var inst_15818 = cljs.core.not.call(null,inst_15817);
var state_15834__$1 = (function (){var statearr_15836 = state_15834;
(statearr_15836[(7)] = inst_15816__$1);

return statearr_15836;
})();
if(inst_15818){
var statearr_15837_15862 = state_15834__$1;
(statearr_15837_15862[(1)] = (8));

} else {
var statearr_15838_15863 = state_15834__$1;
(statearr_15838_15863[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15835 === (1))){
var inst_15811 = (0);
var state_15834__$1 = (function (){var statearr_15839 = state_15834;
(statearr_15839[(8)] = inst_15811);

return statearr_15839;
})();
var statearr_15840_15864 = state_15834__$1;
(statearr_15840_15864[(2)] = null);

(statearr_15840_15864[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15835 === (4))){
var state_15834__$1 = state_15834;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15834__$1,(7),ch);
} else {
if((state_val_15835 === (6))){
var inst_15829 = (state_15834[(2)]);
var state_15834__$1 = state_15834;
var statearr_15841_15865 = state_15834__$1;
(statearr_15841_15865[(2)] = inst_15829);

(statearr_15841_15865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15835 === (3))){
var inst_15831 = (state_15834[(2)]);
var inst_15832 = cljs.core.async.close_BANG_.call(null,out);
var state_15834__$1 = (function (){var statearr_15842 = state_15834;
(statearr_15842[(9)] = inst_15831);

return statearr_15842;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15834__$1,inst_15832);
} else {
if((state_val_15835 === (2))){
var inst_15811 = (state_15834[(8)]);
var inst_15813 = (inst_15811 < n);
var state_15834__$1 = state_15834;
if(cljs.core.truth_(inst_15813)){
var statearr_15843_15866 = state_15834__$1;
(statearr_15843_15866[(1)] = (4));

} else {
var statearr_15844_15867 = state_15834__$1;
(statearr_15844_15867[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15835 === (11))){
var inst_15811 = (state_15834[(8)]);
var inst_15821 = (state_15834[(2)]);
var inst_15822 = (inst_15811 + (1));
var inst_15811__$1 = inst_15822;
var state_15834__$1 = (function (){var statearr_15845 = state_15834;
(statearr_15845[(10)] = inst_15821);

(statearr_15845[(8)] = inst_15811__$1);

return statearr_15845;
})();
var statearr_15846_15868 = state_15834__$1;
(statearr_15846_15868[(2)] = null);

(statearr_15846_15868[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15835 === (9))){
var state_15834__$1 = state_15834;
var statearr_15847_15869 = state_15834__$1;
(statearr_15847_15869[(2)] = null);

(statearr_15847_15869[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15835 === (5))){
var state_15834__$1 = state_15834;
var statearr_15848_15870 = state_15834__$1;
(statearr_15848_15870[(2)] = null);

(statearr_15848_15870[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15835 === (10))){
var inst_15826 = (state_15834[(2)]);
var state_15834__$1 = state_15834;
var statearr_15849_15871 = state_15834__$1;
(statearr_15849_15871[(2)] = inst_15826);

(statearr_15849_15871[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15835 === (8))){
var inst_15816 = (state_15834[(7)]);
var state_15834__$1 = state_15834;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15834__$1,(11),out,inst_15816);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___15861,out))
;
return ((function (switch__7673__auto__,c__7694__auto___15861,out){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_15853 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15853[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_15853[(1)] = (1));

return statearr_15853;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_15834){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_15834);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e15854){if((e15854 instanceof Object)){
var ex__7677__auto__ = e15854;
var statearr_15855_15872 = state_15834;
(statearr_15855_15872[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15834);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15854;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15873 = state_15834;
state_15834 = G__15873;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_15834){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_15834);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___15861,out))
})();
var state__7696__auto__ = (function (){var statearr_15856 = f__7695__auto__.call(null);
(statearr_15856[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___15861);

return statearr_15856;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___15861,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async15881 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15881 = (function (map_LT_,f,ch,meta15882){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta15882 = meta15882;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15881.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15883,meta15882__$1){
var self__ = this;
var _15883__$1 = this;
return (new cljs.core.async.t_cljs$core$async15881(self__.map_LT_,self__.f,self__.ch,meta15882__$1));
});

cljs.core.async.t_cljs$core$async15881.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15883){
var self__ = this;
var _15883__$1 = this;
return self__.meta15882;
});

cljs.core.async.t_cljs$core$async15881.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async15881.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15881.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15881.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async15881.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async15884 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15884 = (function (map_LT_,f,ch,meta15882,_,fn1,meta15885){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta15882 = meta15882;
this._ = _;
this.fn1 = fn1;
this.meta15885 = meta15885;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15884.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_15886,meta15885__$1){
var self__ = this;
var _15886__$1 = this;
return (new cljs.core.async.t_cljs$core$async15884(self__.map_LT_,self__.f,self__.ch,self__.meta15882,self__._,self__.fn1,meta15885__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async15884.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_15886){
var self__ = this;
var _15886__$1 = this;
return self__.meta15885;
});})(___$1))
;

cljs.core.async.t_cljs$core$async15884.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async15884.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async15884.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__15874_SHARP_){
return f1.call(null,(((p1__15874_SHARP_ == null))?null:self__.f.call(null,p1__15874_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async15884.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15882","meta15882",1544186271,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async15881","cljs.core.async/t_cljs$core$async15881",-1334061870,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta15885","meta15885",1260839595,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async15884.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15884.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15884";

cljs.core.async.t_cljs$core$async15884.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async15884");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async15884 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async15884(map_LT___$1,f__$1,ch__$1,meta15882__$1,___$2,fn1__$1,meta15885){
return (new cljs.core.async.t_cljs$core$async15884(map_LT___$1,f__$1,ch__$1,meta15882__$1,___$2,fn1__$1,meta15885));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async15884(self__.map_LT_,self__.f,self__.ch,self__.meta15882,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4557__auto__ = ret;
if(cljs.core.truth_(and__4557__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4557__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async15881.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async15881.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async15881.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15882","meta15882",1544186271,null)], null);
});

cljs.core.async.t_cljs$core$async15881.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15881.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15881";

cljs.core.async.t_cljs$core$async15881.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async15881");
});

cljs.core.async.__GT_t_cljs$core$async15881 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async15881(map_LT___$1,f__$1,ch__$1,meta15882){
return (new cljs.core.async.t_cljs$core$async15881(map_LT___$1,f__$1,ch__$1,meta15882));
});

}

return (new cljs.core.async.t_cljs$core$async15881(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async15890 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15890 = (function (map_GT_,f,ch,meta15891){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta15891 = meta15891;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15890.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15892,meta15891__$1){
var self__ = this;
var _15892__$1 = this;
return (new cljs.core.async.t_cljs$core$async15890(self__.map_GT_,self__.f,self__.ch,meta15891__$1));
});

cljs.core.async.t_cljs$core$async15890.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15892){
var self__ = this;
var _15892__$1 = this;
return self__.meta15891;
});

cljs.core.async.t_cljs$core$async15890.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async15890.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15890.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async15890.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async15890.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async15890.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async15890.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15891","meta15891",1427967945,null)], null);
});

cljs.core.async.t_cljs$core$async15890.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15890.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15890";

cljs.core.async.t_cljs$core$async15890.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async15890");
});

cljs.core.async.__GT_t_cljs$core$async15890 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async15890(map_GT___$1,f__$1,ch__$1,meta15891){
return (new cljs.core.async.t_cljs$core$async15890(map_GT___$1,f__$1,ch__$1,meta15891));
});

}

return (new cljs.core.async.t_cljs$core$async15890(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async15896 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15896 = (function (filter_GT_,p,ch,meta15897){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta15897 = meta15897;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15896.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15898,meta15897__$1){
var self__ = this;
var _15898__$1 = this;
return (new cljs.core.async.t_cljs$core$async15896(self__.filter_GT_,self__.p,self__.ch,meta15897__$1));
});

cljs.core.async.t_cljs$core$async15896.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15898){
var self__ = this;
var _15898__$1 = this;
return self__.meta15897;
});

cljs.core.async.t_cljs$core$async15896.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async15896.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15896.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15896.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async15896.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async15896.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async15896.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async15896.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15897","meta15897",-1716869482,null)], null);
});

cljs.core.async.t_cljs$core$async15896.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15896.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15896";

cljs.core.async.t_cljs$core$async15896.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async15896");
});

cljs.core.async.__GT_t_cljs$core$async15896 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async15896(filter_GT___$1,p__$1,ch__$1,meta15897){
return (new cljs.core.async.t_cljs$core$async15896(filter_GT___$1,p__$1,ch__$1,meta15897));
});

}

return (new cljs.core.async.t_cljs$core$async15896(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args15899 = [];
var len__5627__auto___15943 = arguments.length;
var i__5628__auto___15944 = (0);
while(true){
if((i__5628__auto___15944 < len__5627__auto___15943)){
args15899.push((arguments[i__5628__auto___15944]));

var G__15945 = (i__5628__auto___15944 + (1));
i__5628__auto___15944 = G__15945;
continue;
} else {
}
break;
}

var G__15901 = args15899.length;
switch (G__15901) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15899.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7694__auto___15947 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___15947,out){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___15947,out){
return (function (state_15922){
var state_val_15923 = (state_15922[(1)]);
if((state_val_15923 === (7))){
var inst_15918 = (state_15922[(2)]);
var state_15922__$1 = state_15922;
var statearr_15924_15948 = state_15922__$1;
(statearr_15924_15948[(2)] = inst_15918);

(statearr_15924_15948[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15923 === (1))){
var state_15922__$1 = state_15922;
var statearr_15925_15949 = state_15922__$1;
(statearr_15925_15949[(2)] = null);

(statearr_15925_15949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15923 === (4))){
var inst_15904 = (state_15922[(7)]);
var inst_15904__$1 = (state_15922[(2)]);
var inst_15905 = (inst_15904__$1 == null);
var state_15922__$1 = (function (){var statearr_15926 = state_15922;
(statearr_15926[(7)] = inst_15904__$1);

return statearr_15926;
})();
if(cljs.core.truth_(inst_15905)){
var statearr_15927_15950 = state_15922__$1;
(statearr_15927_15950[(1)] = (5));

} else {
var statearr_15928_15951 = state_15922__$1;
(statearr_15928_15951[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15923 === (6))){
var inst_15904 = (state_15922[(7)]);
var inst_15909 = p.call(null,inst_15904);
var state_15922__$1 = state_15922;
if(cljs.core.truth_(inst_15909)){
var statearr_15929_15952 = state_15922__$1;
(statearr_15929_15952[(1)] = (8));

} else {
var statearr_15930_15953 = state_15922__$1;
(statearr_15930_15953[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15923 === (3))){
var inst_15920 = (state_15922[(2)]);
var state_15922__$1 = state_15922;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15922__$1,inst_15920);
} else {
if((state_val_15923 === (2))){
var state_15922__$1 = state_15922;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15922__$1,(4),ch);
} else {
if((state_val_15923 === (11))){
var inst_15912 = (state_15922[(2)]);
var state_15922__$1 = state_15922;
var statearr_15931_15954 = state_15922__$1;
(statearr_15931_15954[(2)] = inst_15912);

(statearr_15931_15954[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15923 === (9))){
var state_15922__$1 = state_15922;
var statearr_15932_15955 = state_15922__$1;
(statearr_15932_15955[(2)] = null);

(statearr_15932_15955[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15923 === (5))){
var inst_15907 = cljs.core.async.close_BANG_.call(null,out);
var state_15922__$1 = state_15922;
var statearr_15933_15956 = state_15922__$1;
(statearr_15933_15956[(2)] = inst_15907);

(statearr_15933_15956[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15923 === (10))){
var inst_15915 = (state_15922[(2)]);
var state_15922__$1 = (function (){var statearr_15934 = state_15922;
(statearr_15934[(8)] = inst_15915);

return statearr_15934;
})();
var statearr_15935_15957 = state_15922__$1;
(statearr_15935_15957[(2)] = null);

(statearr_15935_15957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15923 === (8))){
var inst_15904 = (state_15922[(7)]);
var state_15922__$1 = state_15922;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15922__$1,(11),out,inst_15904);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___15947,out))
;
return ((function (switch__7673__auto__,c__7694__auto___15947,out){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_15939 = [null,null,null,null,null,null,null,null,null];
(statearr_15939[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_15939[(1)] = (1));

return statearr_15939;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_15922){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_15922);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e15940){if((e15940 instanceof Object)){
var ex__7677__auto__ = e15940;
var statearr_15941_15958 = state_15922;
(statearr_15941_15958[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15922);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15940;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15959 = state_15922;
state_15922 = G__15959;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_15922){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_15922);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___15947,out))
})();
var state__7696__auto__ = (function (){var statearr_15942 = f__7695__auto__.call(null);
(statearr_15942[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___15947);

return statearr_15942;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___15947,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args15960 = [];
var len__5627__auto___15963 = arguments.length;
var i__5628__auto___15964 = (0);
while(true){
if((i__5628__auto___15964 < len__5627__auto___15963)){
args15960.push((arguments[i__5628__auto___15964]));

var G__15965 = (i__5628__auto___15964 + (1));
i__5628__auto___15964 = G__15965;
continue;
} else {
}
break;
}

var G__15962 = args15960.length;
switch (G__15962) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15960.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__7694__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto__){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto__){
return (function (state_16132){
var state_val_16133 = (state_16132[(1)]);
if((state_val_16133 === (7))){
var inst_16128 = (state_16132[(2)]);
var state_16132__$1 = state_16132;
var statearr_16134_16175 = state_16132__$1;
(statearr_16134_16175[(2)] = inst_16128);

(statearr_16134_16175[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16133 === (20))){
var inst_16098 = (state_16132[(7)]);
var inst_16109 = (state_16132[(2)]);
var inst_16110 = cljs.core.next.call(null,inst_16098);
var inst_16084 = inst_16110;
var inst_16085 = null;
var inst_16086 = (0);
var inst_16087 = (0);
var state_16132__$1 = (function (){var statearr_16135 = state_16132;
(statearr_16135[(8)] = inst_16086);

(statearr_16135[(9)] = inst_16084);

(statearr_16135[(10)] = inst_16087);

(statearr_16135[(11)] = inst_16085);

(statearr_16135[(12)] = inst_16109);

return statearr_16135;
})();
var statearr_16136_16176 = state_16132__$1;
(statearr_16136_16176[(2)] = null);

(statearr_16136_16176[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16133 === (1))){
var state_16132__$1 = state_16132;
var statearr_16137_16177 = state_16132__$1;
(statearr_16137_16177[(2)] = null);

(statearr_16137_16177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16133 === (4))){
var inst_16073 = (state_16132[(13)]);
var inst_16073__$1 = (state_16132[(2)]);
var inst_16074 = (inst_16073__$1 == null);
var state_16132__$1 = (function (){var statearr_16138 = state_16132;
(statearr_16138[(13)] = inst_16073__$1);

return statearr_16138;
})();
if(cljs.core.truth_(inst_16074)){
var statearr_16139_16178 = state_16132__$1;
(statearr_16139_16178[(1)] = (5));

} else {
var statearr_16140_16179 = state_16132__$1;
(statearr_16140_16179[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16133 === (15))){
var state_16132__$1 = state_16132;
var statearr_16144_16180 = state_16132__$1;
(statearr_16144_16180[(2)] = null);

(statearr_16144_16180[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16133 === (21))){
var state_16132__$1 = state_16132;
var statearr_16145_16181 = state_16132__$1;
(statearr_16145_16181[(2)] = null);

(statearr_16145_16181[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16133 === (13))){
var inst_16086 = (state_16132[(8)]);
var inst_16084 = (state_16132[(9)]);
var inst_16087 = (state_16132[(10)]);
var inst_16085 = (state_16132[(11)]);
var inst_16094 = (state_16132[(2)]);
var inst_16095 = (inst_16087 + (1));
var tmp16141 = inst_16086;
var tmp16142 = inst_16084;
var tmp16143 = inst_16085;
var inst_16084__$1 = tmp16142;
var inst_16085__$1 = tmp16143;
var inst_16086__$1 = tmp16141;
var inst_16087__$1 = inst_16095;
var state_16132__$1 = (function (){var statearr_16146 = state_16132;
(statearr_16146[(8)] = inst_16086__$1);

(statearr_16146[(9)] = inst_16084__$1);

(statearr_16146[(10)] = inst_16087__$1);

(statearr_16146[(11)] = inst_16085__$1);

(statearr_16146[(14)] = inst_16094);

return statearr_16146;
})();
var statearr_16147_16182 = state_16132__$1;
(statearr_16147_16182[(2)] = null);

(statearr_16147_16182[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16133 === (22))){
var state_16132__$1 = state_16132;
var statearr_16148_16183 = state_16132__$1;
(statearr_16148_16183[(2)] = null);

(statearr_16148_16183[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16133 === (6))){
var inst_16073 = (state_16132[(13)]);
var inst_16082 = f.call(null,inst_16073);
var inst_16083 = cljs.core.seq.call(null,inst_16082);
var inst_16084 = inst_16083;
var inst_16085 = null;
var inst_16086 = (0);
var inst_16087 = (0);
var state_16132__$1 = (function (){var statearr_16149 = state_16132;
(statearr_16149[(8)] = inst_16086);

(statearr_16149[(9)] = inst_16084);

(statearr_16149[(10)] = inst_16087);

(statearr_16149[(11)] = inst_16085);

return statearr_16149;
})();
var statearr_16150_16184 = state_16132__$1;
(statearr_16150_16184[(2)] = null);

(statearr_16150_16184[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16133 === (17))){
var inst_16098 = (state_16132[(7)]);
var inst_16102 = cljs.core.chunk_first.call(null,inst_16098);
var inst_16103 = cljs.core.chunk_rest.call(null,inst_16098);
var inst_16104 = cljs.core.count.call(null,inst_16102);
var inst_16084 = inst_16103;
var inst_16085 = inst_16102;
var inst_16086 = inst_16104;
var inst_16087 = (0);
var state_16132__$1 = (function (){var statearr_16151 = state_16132;
(statearr_16151[(8)] = inst_16086);

(statearr_16151[(9)] = inst_16084);

(statearr_16151[(10)] = inst_16087);

(statearr_16151[(11)] = inst_16085);

return statearr_16151;
})();
var statearr_16152_16185 = state_16132__$1;
(statearr_16152_16185[(2)] = null);

(statearr_16152_16185[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16133 === (3))){
var inst_16130 = (state_16132[(2)]);
var state_16132__$1 = state_16132;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16132__$1,inst_16130);
} else {
if((state_val_16133 === (12))){
var inst_16118 = (state_16132[(2)]);
var state_16132__$1 = state_16132;
var statearr_16153_16186 = state_16132__$1;
(statearr_16153_16186[(2)] = inst_16118);

(statearr_16153_16186[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16133 === (2))){
var state_16132__$1 = state_16132;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16132__$1,(4),in$);
} else {
if((state_val_16133 === (23))){
var inst_16126 = (state_16132[(2)]);
var state_16132__$1 = state_16132;
var statearr_16154_16187 = state_16132__$1;
(statearr_16154_16187[(2)] = inst_16126);

(statearr_16154_16187[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16133 === (19))){
var inst_16113 = (state_16132[(2)]);
var state_16132__$1 = state_16132;
var statearr_16155_16188 = state_16132__$1;
(statearr_16155_16188[(2)] = inst_16113);

(statearr_16155_16188[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16133 === (11))){
var inst_16084 = (state_16132[(9)]);
var inst_16098 = (state_16132[(7)]);
var inst_16098__$1 = cljs.core.seq.call(null,inst_16084);
var state_16132__$1 = (function (){var statearr_16156 = state_16132;
(statearr_16156[(7)] = inst_16098__$1);

return statearr_16156;
})();
if(inst_16098__$1){
var statearr_16157_16189 = state_16132__$1;
(statearr_16157_16189[(1)] = (14));

} else {
var statearr_16158_16190 = state_16132__$1;
(statearr_16158_16190[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16133 === (9))){
var inst_16120 = (state_16132[(2)]);
var inst_16121 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_16132__$1 = (function (){var statearr_16159 = state_16132;
(statearr_16159[(15)] = inst_16120);

return statearr_16159;
})();
if(cljs.core.truth_(inst_16121)){
var statearr_16160_16191 = state_16132__$1;
(statearr_16160_16191[(1)] = (21));

} else {
var statearr_16161_16192 = state_16132__$1;
(statearr_16161_16192[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16133 === (5))){
var inst_16076 = cljs.core.async.close_BANG_.call(null,out);
var state_16132__$1 = state_16132;
var statearr_16162_16193 = state_16132__$1;
(statearr_16162_16193[(2)] = inst_16076);

(statearr_16162_16193[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16133 === (14))){
var inst_16098 = (state_16132[(7)]);
var inst_16100 = cljs.core.chunked_seq_QMARK_.call(null,inst_16098);
var state_16132__$1 = state_16132;
if(inst_16100){
var statearr_16163_16194 = state_16132__$1;
(statearr_16163_16194[(1)] = (17));

} else {
var statearr_16164_16195 = state_16132__$1;
(statearr_16164_16195[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16133 === (16))){
var inst_16116 = (state_16132[(2)]);
var state_16132__$1 = state_16132;
var statearr_16165_16196 = state_16132__$1;
(statearr_16165_16196[(2)] = inst_16116);

(statearr_16165_16196[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16133 === (10))){
var inst_16087 = (state_16132[(10)]);
var inst_16085 = (state_16132[(11)]);
var inst_16092 = cljs.core._nth.call(null,inst_16085,inst_16087);
var state_16132__$1 = state_16132;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16132__$1,(13),out,inst_16092);
} else {
if((state_val_16133 === (18))){
var inst_16098 = (state_16132[(7)]);
var inst_16107 = cljs.core.first.call(null,inst_16098);
var state_16132__$1 = state_16132;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16132__$1,(20),out,inst_16107);
} else {
if((state_val_16133 === (8))){
var inst_16086 = (state_16132[(8)]);
var inst_16087 = (state_16132[(10)]);
var inst_16089 = (inst_16087 < inst_16086);
var inst_16090 = inst_16089;
var state_16132__$1 = state_16132;
if(cljs.core.truth_(inst_16090)){
var statearr_16166_16197 = state_16132__$1;
(statearr_16166_16197[(1)] = (10));

} else {
var statearr_16167_16198 = state_16132__$1;
(statearr_16167_16198[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto__))
;
return ((function (switch__7673__auto__,c__7694__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__7674__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__7674__auto____0 = (function (){
var statearr_16171 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16171[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__7674__auto__);

(statearr_16171[(1)] = (1));

return statearr_16171;
});
var cljs$core$async$mapcat_STAR__$_state_machine__7674__auto____1 = (function (state_16132){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_16132);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e16172){if((e16172 instanceof Object)){
var ex__7677__auto__ = e16172;
var statearr_16173_16199 = state_16132;
(statearr_16173_16199[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16132);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16172;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16200 = state_16132;
state_16132 = G__16200;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__7674__auto__ = function(state_16132){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__7674__auto____1.call(this,state_16132);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__7674__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__7674__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto__))
})();
var state__7696__auto__ = (function (){var statearr_16174 = f__7695__auto__.call(null);
(statearr_16174[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto__);

return statearr_16174;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto__))
);

return c__7694__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args16201 = [];
var len__5627__auto___16204 = arguments.length;
var i__5628__auto___16205 = (0);
while(true){
if((i__5628__auto___16205 < len__5627__auto___16204)){
args16201.push((arguments[i__5628__auto___16205]));

var G__16206 = (i__5628__auto___16205 + (1));
i__5628__auto___16205 = G__16206;
continue;
} else {
}
break;
}

var G__16203 = args16201.length;
switch (G__16203) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16201.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args16208 = [];
var len__5627__auto___16211 = arguments.length;
var i__5628__auto___16212 = (0);
while(true){
if((i__5628__auto___16212 < len__5627__auto___16211)){
args16208.push((arguments[i__5628__auto___16212]));

var G__16213 = (i__5628__auto___16212 + (1));
i__5628__auto___16212 = G__16213;
continue;
} else {
}
break;
}

var G__16210 = args16208.length;
switch (G__16210) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16208.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args16215 = [];
var len__5627__auto___16266 = arguments.length;
var i__5628__auto___16267 = (0);
while(true){
if((i__5628__auto___16267 < len__5627__auto___16266)){
args16215.push((arguments[i__5628__auto___16267]));

var G__16268 = (i__5628__auto___16267 + (1));
i__5628__auto___16267 = G__16268;
continue;
} else {
}
break;
}

var G__16217 = args16215.length;
switch (G__16217) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16215.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7694__auto___16270 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___16270,out){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___16270,out){
return (function (state_16241){
var state_val_16242 = (state_16241[(1)]);
if((state_val_16242 === (7))){
var inst_16236 = (state_16241[(2)]);
var state_16241__$1 = state_16241;
var statearr_16243_16271 = state_16241__$1;
(statearr_16243_16271[(2)] = inst_16236);

(statearr_16243_16271[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16242 === (1))){
var inst_16218 = null;
var state_16241__$1 = (function (){var statearr_16244 = state_16241;
(statearr_16244[(7)] = inst_16218);

return statearr_16244;
})();
var statearr_16245_16272 = state_16241__$1;
(statearr_16245_16272[(2)] = null);

(statearr_16245_16272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16242 === (4))){
var inst_16221 = (state_16241[(8)]);
var inst_16221__$1 = (state_16241[(2)]);
var inst_16222 = (inst_16221__$1 == null);
var inst_16223 = cljs.core.not.call(null,inst_16222);
var state_16241__$1 = (function (){var statearr_16246 = state_16241;
(statearr_16246[(8)] = inst_16221__$1);

return statearr_16246;
})();
if(inst_16223){
var statearr_16247_16273 = state_16241__$1;
(statearr_16247_16273[(1)] = (5));

} else {
var statearr_16248_16274 = state_16241__$1;
(statearr_16248_16274[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16242 === (6))){
var state_16241__$1 = state_16241;
var statearr_16249_16275 = state_16241__$1;
(statearr_16249_16275[(2)] = null);

(statearr_16249_16275[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16242 === (3))){
var inst_16238 = (state_16241[(2)]);
var inst_16239 = cljs.core.async.close_BANG_.call(null,out);
var state_16241__$1 = (function (){var statearr_16250 = state_16241;
(statearr_16250[(9)] = inst_16238);

return statearr_16250;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16241__$1,inst_16239);
} else {
if((state_val_16242 === (2))){
var state_16241__$1 = state_16241;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16241__$1,(4),ch);
} else {
if((state_val_16242 === (11))){
var inst_16221 = (state_16241[(8)]);
var inst_16230 = (state_16241[(2)]);
var inst_16218 = inst_16221;
var state_16241__$1 = (function (){var statearr_16251 = state_16241;
(statearr_16251[(10)] = inst_16230);

(statearr_16251[(7)] = inst_16218);

return statearr_16251;
})();
var statearr_16252_16276 = state_16241__$1;
(statearr_16252_16276[(2)] = null);

(statearr_16252_16276[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16242 === (9))){
var inst_16221 = (state_16241[(8)]);
var state_16241__$1 = state_16241;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16241__$1,(11),out,inst_16221);
} else {
if((state_val_16242 === (5))){
var inst_16221 = (state_16241[(8)]);
var inst_16218 = (state_16241[(7)]);
var inst_16225 = cljs.core._EQ_.call(null,inst_16221,inst_16218);
var state_16241__$1 = state_16241;
if(inst_16225){
var statearr_16254_16277 = state_16241__$1;
(statearr_16254_16277[(1)] = (8));

} else {
var statearr_16255_16278 = state_16241__$1;
(statearr_16255_16278[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16242 === (10))){
var inst_16233 = (state_16241[(2)]);
var state_16241__$1 = state_16241;
var statearr_16256_16279 = state_16241__$1;
(statearr_16256_16279[(2)] = inst_16233);

(statearr_16256_16279[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16242 === (8))){
var inst_16218 = (state_16241[(7)]);
var tmp16253 = inst_16218;
var inst_16218__$1 = tmp16253;
var state_16241__$1 = (function (){var statearr_16257 = state_16241;
(statearr_16257[(7)] = inst_16218__$1);

return statearr_16257;
})();
var statearr_16258_16280 = state_16241__$1;
(statearr_16258_16280[(2)] = null);

(statearr_16258_16280[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___16270,out))
;
return ((function (switch__7673__auto__,c__7694__auto___16270,out){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_16262 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16262[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_16262[(1)] = (1));

return statearr_16262;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_16241){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_16241);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e16263){if((e16263 instanceof Object)){
var ex__7677__auto__ = e16263;
var statearr_16264_16281 = state_16241;
(statearr_16264_16281[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16241);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16263;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16282 = state_16241;
state_16241 = G__16282;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_16241){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_16241);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___16270,out))
})();
var state__7696__auto__ = (function (){var statearr_16265 = f__7695__auto__.call(null);
(statearr_16265[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___16270);

return statearr_16265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___16270,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args16283 = [];
var len__5627__auto___16353 = arguments.length;
var i__5628__auto___16354 = (0);
while(true){
if((i__5628__auto___16354 < len__5627__auto___16353)){
args16283.push((arguments[i__5628__auto___16354]));

var G__16355 = (i__5628__auto___16354 + (1));
i__5628__auto___16354 = G__16355;
continue;
} else {
}
break;
}

var G__16285 = args16283.length;
switch (G__16285) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16283.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7694__auto___16357 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___16357,out){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___16357,out){
return (function (state_16323){
var state_val_16324 = (state_16323[(1)]);
if((state_val_16324 === (7))){
var inst_16319 = (state_16323[(2)]);
var state_16323__$1 = state_16323;
var statearr_16325_16358 = state_16323__$1;
(statearr_16325_16358[(2)] = inst_16319);

(statearr_16325_16358[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16324 === (1))){
var inst_16286 = (new Array(n));
var inst_16287 = inst_16286;
var inst_16288 = (0);
var state_16323__$1 = (function (){var statearr_16326 = state_16323;
(statearr_16326[(7)] = inst_16288);

(statearr_16326[(8)] = inst_16287);

return statearr_16326;
})();
var statearr_16327_16359 = state_16323__$1;
(statearr_16327_16359[(2)] = null);

(statearr_16327_16359[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16324 === (4))){
var inst_16291 = (state_16323[(9)]);
var inst_16291__$1 = (state_16323[(2)]);
var inst_16292 = (inst_16291__$1 == null);
var inst_16293 = cljs.core.not.call(null,inst_16292);
var state_16323__$1 = (function (){var statearr_16328 = state_16323;
(statearr_16328[(9)] = inst_16291__$1);

return statearr_16328;
})();
if(inst_16293){
var statearr_16329_16360 = state_16323__$1;
(statearr_16329_16360[(1)] = (5));

} else {
var statearr_16330_16361 = state_16323__$1;
(statearr_16330_16361[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16324 === (15))){
var inst_16313 = (state_16323[(2)]);
var state_16323__$1 = state_16323;
var statearr_16331_16362 = state_16323__$1;
(statearr_16331_16362[(2)] = inst_16313);

(statearr_16331_16362[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16324 === (13))){
var state_16323__$1 = state_16323;
var statearr_16332_16363 = state_16323__$1;
(statearr_16332_16363[(2)] = null);

(statearr_16332_16363[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16324 === (6))){
var inst_16288 = (state_16323[(7)]);
var inst_16309 = (inst_16288 > (0));
var state_16323__$1 = state_16323;
if(cljs.core.truth_(inst_16309)){
var statearr_16333_16364 = state_16323__$1;
(statearr_16333_16364[(1)] = (12));

} else {
var statearr_16334_16365 = state_16323__$1;
(statearr_16334_16365[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16324 === (3))){
var inst_16321 = (state_16323[(2)]);
var state_16323__$1 = state_16323;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16323__$1,inst_16321);
} else {
if((state_val_16324 === (12))){
var inst_16287 = (state_16323[(8)]);
var inst_16311 = cljs.core.vec.call(null,inst_16287);
var state_16323__$1 = state_16323;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16323__$1,(15),out,inst_16311);
} else {
if((state_val_16324 === (2))){
var state_16323__$1 = state_16323;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16323__$1,(4),ch);
} else {
if((state_val_16324 === (11))){
var inst_16303 = (state_16323[(2)]);
var inst_16304 = (new Array(n));
var inst_16287 = inst_16304;
var inst_16288 = (0);
var state_16323__$1 = (function (){var statearr_16335 = state_16323;
(statearr_16335[(7)] = inst_16288);

(statearr_16335[(10)] = inst_16303);

(statearr_16335[(8)] = inst_16287);

return statearr_16335;
})();
var statearr_16336_16366 = state_16323__$1;
(statearr_16336_16366[(2)] = null);

(statearr_16336_16366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16324 === (9))){
var inst_16287 = (state_16323[(8)]);
var inst_16301 = cljs.core.vec.call(null,inst_16287);
var state_16323__$1 = state_16323;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16323__$1,(11),out,inst_16301);
} else {
if((state_val_16324 === (5))){
var inst_16288 = (state_16323[(7)]);
var inst_16291 = (state_16323[(9)]);
var inst_16287 = (state_16323[(8)]);
var inst_16296 = (state_16323[(11)]);
var inst_16295 = (inst_16287[inst_16288] = inst_16291);
var inst_16296__$1 = (inst_16288 + (1));
var inst_16297 = (inst_16296__$1 < n);
var state_16323__$1 = (function (){var statearr_16337 = state_16323;
(statearr_16337[(12)] = inst_16295);

(statearr_16337[(11)] = inst_16296__$1);

return statearr_16337;
})();
if(cljs.core.truth_(inst_16297)){
var statearr_16338_16367 = state_16323__$1;
(statearr_16338_16367[(1)] = (8));

} else {
var statearr_16339_16368 = state_16323__$1;
(statearr_16339_16368[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16324 === (14))){
var inst_16316 = (state_16323[(2)]);
var inst_16317 = cljs.core.async.close_BANG_.call(null,out);
var state_16323__$1 = (function (){var statearr_16341 = state_16323;
(statearr_16341[(13)] = inst_16316);

return statearr_16341;
})();
var statearr_16342_16369 = state_16323__$1;
(statearr_16342_16369[(2)] = inst_16317);

(statearr_16342_16369[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16324 === (10))){
var inst_16307 = (state_16323[(2)]);
var state_16323__$1 = state_16323;
var statearr_16343_16370 = state_16323__$1;
(statearr_16343_16370[(2)] = inst_16307);

(statearr_16343_16370[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16324 === (8))){
var inst_16287 = (state_16323[(8)]);
var inst_16296 = (state_16323[(11)]);
var tmp16340 = inst_16287;
var inst_16287__$1 = tmp16340;
var inst_16288 = inst_16296;
var state_16323__$1 = (function (){var statearr_16344 = state_16323;
(statearr_16344[(7)] = inst_16288);

(statearr_16344[(8)] = inst_16287__$1);

return statearr_16344;
})();
var statearr_16345_16371 = state_16323__$1;
(statearr_16345_16371[(2)] = null);

(statearr_16345_16371[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___16357,out))
;
return ((function (switch__7673__auto__,c__7694__auto___16357,out){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_16349 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16349[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_16349[(1)] = (1));

return statearr_16349;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_16323){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_16323);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e16350){if((e16350 instanceof Object)){
var ex__7677__auto__ = e16350;
var statearr_16351_16372 = state_16323;
(statearr_16351_16372[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16323);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16350;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16373 = state_16323;
state_16323 = G__16373;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_16323){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_16323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___16357,out))
})();
var state__7696__auto__ = (function (){var statearr_16352 = f__7695__auto__.call(null);
(statearr_16352[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___16357);

return statearr_16352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___16357,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args16374 = [];
var len__5627__auto___16448 = arguments.length;
var i__5628__auto___16449 = (0);
while(true){
if((i__5628__auto___16449 < len__5627__auto___16448)){
args16374.push((arguments[i__5628__auto___16449]));

var G__16450 = (i__5628__auto___16449 + (1));
i__5628__auto___16449 = G__16450;
continue;
} else {
}
break;
}

var G__16376 = args16374.length;
switch (G__16376) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16374.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7694__auto___16452 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___16452,out){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___16452,out){
return (function (state_16418){
var state_val_16419 = (state_16418[(1)]);
if((state_val_16419 === (7))){
var inst_16414 = (state_16418[(2)]);
var state_16418__$1 = state_16418;
var statearr_16420_16453 = state_16418__$1;
(statearr_16420_16453[(2)] = inst_16414);

(statearr_16420_16453[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16419 === (1))){
var inst_16377 = [];
var inst_16378 = inst_16377;
var inst_16379 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_16418__$1 = (function (){var statearr_16421 = state_16418;
(statearr_16421[(7)] = inst_16378);

(statearr_16421[(8)] = inst_16379);

return statearr_16421;
})();
var statearr_16422_16454 = state_16418__$1;
(statearr_16422_16454[(2)] = null);

(statearr_16422_16454[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16419 === (4))){
var inst_16382 = (state_16418[(9)]);
var inst_16382__$1 = (state_16418[(2)]);
var inst_16383 = (inst_16382__$1 == null);
var inst_16384 = cljs.core.not.call(null,inst_16383);
var state_16418__$1 = (function (){var statearr_16423 = state_16418;
(statearr_16423[(9)] = inst_16382__$1);

return statearr_16423;
})();
if(inst_16384){
var statearr_16424_16455 = state_16418__$1;
(statearr_16424_16455[(1)] = (5));

} else {
var statearr_16425_16456 = state_16418__$1;
(statearr_16425_16456[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16419 === (15))){
var inst_16408 = (state_16418[(2)]);
var state_16418__$1 = state_16418;
var statearr_16426_16457 = state_16418__$1;
(statearr_16426_16457[(2)] = inst_16408);

(statearr_16426_16457[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16419 === (13))){
var state_16418__$1 = state_16418;
var statearr_16427_16458 = state_16418__$1;
(statearr_16427_16458[(2)] = null);

(statearr_16427_16458[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16419 === (6))){
var inst_16378 = (state_16418[(7)]);
var inst_16403 = inst_16378.length;
var inst_16404 = (inst_16403 > (0));
var state_16418__$1 = state_16418;
if(cljs.core.truth_(inst_16404)){
var statearr_16428_16459 = state_16418__$1;
(statearr_16428_16459[(1)] = (12));

} else {
var statearr_16429_16460 = state_16418__$1;
(statearr_16429_16460[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16419 === (3))){
var inst_16416 = (state_16418[(2)]);
var state_16418__$1 = state_16418;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16418__$1,inst_16416);
} else {
if((state_val_16419 === (12))){
var inst_16378 = (state_16418[(7)]);
var inst_16406 = cljs.core.vec.call(null,inst_16378);
var state_16418__$1 = state_16418;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16418__$1,(15),out,inst_16406);
} else {
if((state_val_16419 === (2))){
var state_16418__$1 = state_16418;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16418__$1,(4),ch);
} else {
if((state_val_16419 === (11))){
var inst_16382 = (state_16418[(9)]);
var inst_16386 = (state_16418[(10)]);
var inst_16396 = (state_16418[(2)]);
var inst_16397 = [];
var inst_16398 = inst_16397.push(inst_16382);
var inst_16378 = inst_16397;
var inst_16379 = inst_16386;
var state_16418__$1 = (function (){var statearr_16430 = state_16418;
(statearr_16430[(11)] = inst_16396);

(statearr_16430[(7)] = inst_16378);

(statearr_16430[(12)] = inst_16398);

(statearr_16430[(8)] = inst_16379);

return statearr_16430;
})();
var statearr_16431_16461 = state_16418__$1;
(statearr_16431_16461[(2)] = null);

(statearr_16431_16461[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16419 === (9))){
var inst_16378 = (state_16418[(7)]);
var inst_16394 = cljs.core.vec.call(null,inst_16378);
var state_16418__$1 = state_16418;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16418__$1,(11),out,inst_16394);
} else {
if((state_val_16419 === (5))){
var inst_16382 = (state_16418[(9)]);
var inst_16386 = (state_16418[(10)]);
var inst_16379 = (state_16418[(8)]);
var inst_16386__$1 = f.call(null,inst_16382);
var inst_16387 = cljs.core._EQ_.call(null,inst_16386__$1,inst_16379);
var inst_16388 = cljs.core.keyword_identical_QMARK_.call(null,inst_16379,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_16389 = (inst_16387) || (inst_16388);
var state_16418__$1 = (function (){var statearr_16432 = state_16418;
(statearr_16432[(10)] = inst_16386__$1);

return statearr_16432;
})();
if(cljs.core.truth_(inst_16389)){
var statearr_16433_16462 = state_16418__$1;
(statearr_16433_16462[(1)] = (8));

} else {
var statearr_16434_16463 = state_16418__$1;
(statearr_16434_16463[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16419 === (14))){
var inst_16411 = (state_16418[(2)]);
var inst_16412 = cljs.core.async.close_BANG_.call(null,out);
var state_16418__$1 = (function (){var statearr_16436 = state_16418;
(statearr_16436[(13)] = inst_16411);

return statearr_16436;
})();
var statearr_16437_16464 = state_16418__$1;
(statearr_16437_16464[(2)] = inst_16412);

(statearr_16437_16464[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16419 === (10))){
var inst_16401 = (state_16418[(2)]);
var state_16418__$1 = state_16418;
var statearr_16438_16465 = state_16418__$1;
(statearr_16438_16465[(2)] = inst_16401);

(statearr_16438_16465[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16419 === (8))){
var inst_16382 = (state_16418[(9)]);
var inst_16378 = (state_16418[(7)]);
var inst_16386 = (state_16418[(10)]);
var inst_16391 = inst_16378.push(inst_16382);
var tmp16435 = inst_16378;
var inst_16378__$1 = tmp16435;
var inst_16379 = inst_16386;
var state_16418__$1 = (function (){var statearr_16439 = state_16418;
(statearr_16439[(14)] = inst_16391);

(statearr_16439[(7)] = inst_16378__$1);

(statearr_16439[(8)] = inst_16379);

return statearr_16439;
})();
var statearr_16440_16466 = state_16418__$1;
(statearr_16440_16466[(2)] = null);

(statearr_16440_16466[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___16452,out))
;
return ((function (switch__7673__auto__,c__7694__auto___16452,out){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_16444 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16444[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_16444[(1)] = (1));

return statearr_16444;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_16418){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_16418);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e16445){if((e16445 instanceof Object)){
var ex__7677__auto__ = e16445;
var statearr_16446_16467 = state_16418;
(statearr_16446_16467[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16418);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16445;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16468 = state_16418;
state_16418 = G__16468;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_16418){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_16418);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___16452,out))
})();
var state__7696__auto__ = (function (){var statearr_16447 = f__7695__auto__.call(null);
(statearr_16447[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___16452);

return statearr_16447;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___16452,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
