// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.utils.om.state');
goog.require('cljs.core');
goog.require('om.core');
/**
 * A transact! function that optionally uses swap! if this atom is not yet
 * transactable?
 */
hatti.utils.om.state.transact_BANG_ = (function hatti$utils$om$state$transact_BANG_(app_state){
if(((!((app_state == null)))?(((false) || (app_state.om$core$ITransact$))?true:(((!app_state.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(om.core.ITransact,app_state):false)):cljs.core.native_satisfies_QMARK_(om.core.ITransact,app_state))){
return om.core.transact_BANG_;
} else {
return cljs.core.swap_BANG_;
}
});
/**
 * Like om/transact! but also works on atoms that are not transactable?
 */
hatti.utils.om.state.transact_app_state_BANG_ = (function hatti$utils$om$state$transact_app_state_BANG_(var_args){
var args94904 = [];
var len__5627__auto___94907 = arguments.length;
var i__5628__auto___94908 = (0);
while(true){
if((i__5628__auto___94908 < len__5627__auto___94907)){
args94904.push((arguments[i__5628__auto___94908]));

var G__94909 = (i__5628__auto___94908 + (1));
i__5628__auto___94908 = G__94909;
continue;
} else {
}
break;
}

var G__94906 = args94904.length;
switch (G__94906) {
case 2:
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args94904.length)].join('')));

}
});

hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (app_state,transact_fn){
return hatti.utils.om.state.transact_BANG_(app_state).call(null,app_state,transact_fn);
});

hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (app_state,ks,transact_fn){
return hatti.utils.om.state.transact_BANG_(app_state).call(null,app_state,(function (p1__94903_SHARP_){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(p1__94903_SHARP_,ks,transact_fn);
}));
});

hatti.utils.om.state.transact_app_state_BANG_.cljs$lang$maxFixedArity = 3;
/**
 * Like om/update! but also works on atoms that are not transactable?
 */
hatti.utils.om.state.update_app_state_BANG_ = (function hatti$utils$om$state$update_app_state_BANG_(var_args){
var args94911 = [];
var len__5627__auto___94914 = arguments.length;
var i__5628__auto___94915 = (0);
while(true){
if((i__5628__auto___94915 < len__5627__auto___94914)){
args94911.push((arguments[i__5628__auto___94915]));

var G__94916 = (i__5628__auto___94915 + (1));
i__5628__auto___94915 = G__94916;
continue;
} else {
}
break;
}

var G__94913 = args94911.length;
switch (G__94913) {
case 2:
return hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args94911.length)].join('')));

}
});

hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (app_state,update_val){
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$2(app_state,(function (){
return update_val;
}));
});

hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (app_state,ks,update_val){
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,ks,(function (){
return update_val;
}));
});

hatti.utils.om.state.update_app_state_BANG_.cljs$lang$maxFixedArity = 3;
/**
 * Merges provided state into existing app-state, possibly after zoomint into
 * ks.
 */
hatti.utils.om.state.merge_into_app_state_BANG_ = (function hatti$utils$om$state$merge_into_app_state_BANG_(var_args){
var args94920 = [];
var len__5627__auto___94923 = arguments.length;
var i__5628__auto___94924 = (0);
while(true){
if((i__5628__auto___94924 < len__5627__auto___94923)){
args94920.push((arguments[i__5628__auto___94924]));

var G__94925 = (i__5628__auto___94924 + (1));
i__5628__auto___94924 = G__94925;
continue;
} else {
}
break;
}

var G__94922 = args94920.length;
switch (G__94922) {
case 2:
return hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args94920.length)].join('')));

}
});

hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (app_state,state_to_merge){
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$2(app_state,(function (p1__94918_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__94918_SHARP_,state_to_merge], 0));
}));
});

hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (app_state,ks,state_to_merge){
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,ks,(function (p1__94919_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__94919_SHARP_,state_to_merge], 0));
}));
});

hatti.utils.om.state.merge_into_app_state_BANG_.cljs$lang$maxFixedArity = 3;
