// Compiled by ClojureScript 1.7.145 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__23289__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__23288 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag = cljs.core.nth.call(null,vec__23288,(0),null);
var body = cljs.core.nthnext.call(null,vec__23288,(1));
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__23289 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__23290__i = 0, G__23290__a = new Array(arguments.length -  0);
while (G__23290__i < G__23290__a.length) {G__23290__a[G__23290__i] = arguments[G__23290__i + 0]; ++G__23290__i;}
  args = new cljs.core.IndexedSeq(G__23290__a,0);
} 
return G__23289__delegate.call(this,args);};
G__23289.cljs$lang$maxFixedArity = 0;
G__23289.cljs$lang$applyTo = (function (arglist__23291){
var args = cljs.core.seq(arglist__23291);
return G__23289__delegate(args);
});
G__23289.cljs$core$IFn$_invoke$arity$variadic = G__23289__delegate;
return G__23289;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5341__auto__ = (function sablono$core$update_arglists_$_iter__23296(s__23297){
return (new cljs.core.LazySeq(null,(function (){
var s__23297__$1 = s__23297;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23297__$1);
if(temp__4425__auto__){
var s__23297__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23297__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__23297__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__23299 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__23298 = (0);
while(true){
if((i__23298 < size__5340__auto__)){
var args = cljs.core._nth.call(null,c__5339__auto__,i__23298);
cljs.core.chunk_append.call(null,b__23299,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__23300 = (i__23298 + (1));
i__23298 = G__23300;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23299),sablono$core$update_arglists_$_iter__23296.call(null,cljs.core.chunk_rest.call(null,s__23297__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23299),null);
}
} else {
var args = cljs.core.first.call(null,s__23297__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__23296.call(null,cljs.core.rest.call(null,s__23297__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5634__auto__ = [];
var len__5627__auto___23306 = arguments.length;
var i__5628__auto___23307 = (0);
while(true){
if((i__5628__auto___23307 < len__5627__auto___23306)){
args__5634__auto__.push((arguments[i__5628__auto___23307]));

var G__23308 = (i__5628__auto___23307 + (1));
i__5628__auto___23307 = G__23308;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5341__auto__ = (function sablono$core$iter__23302(s__23303){
return (new cljs.core.LazySeq(null,(function (){
var s__23303__$1 = s__23303;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23303__$1);
if(temp__4425__auto__){
var s__23303__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23303__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__23303__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__23305 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__23304 = (0);
while(true){
if((i__23304 < size__5340__auto__)){
var style = cljs.core._nth.call(null,c__5339__auto__,i__23304);
cljs.core.chunk_append.call(null,b__23305,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__23309 = (i__23304 + (1));
i__23304 = G__23309;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23305),sablono$core$iter__23302.call(null,cljs.core.chunk_rest.call(null,s__23303__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23305),null);
}
} else {
var style = cljs.core.first.call(null,s__23303__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__23302.call(null,cljs.core.rest.call(null,s__23303__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq23301){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq23301));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to23310 = (function sablono$core$link_to23310(var_args){
var args__5634__auto__ = [];
var len__5627__auto___23313 = arguments.length;
var i__5628__auto___23314 = (0);
while(true){
if((i__5628__auto___23314 < len__5627__auto___23313)){
args__5634__auto__.push((arguments[i__5628__auto___23314]));

var G__23315 = (i__5628__auto___23314 + (1));
i__5628__auto___23314 = G__23315;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.link_to23310.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.link_to23310.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to23310.cljs$lang$maxFixedArity = (1);

sablono.core.link_to23310.cljs$lang$applyTo = (function (seq23311){
var G__23312 = cljs.core.first.call(null,seq23311);
var seq23311__$1 = cljs.core.next.call(null,seq23311);
return sablono.core.link_to23310.cljs$core$IFn$_invoke$arity$variadic(G__23312,seq23311__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to23310);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to23316 = (function sablono$core$mail_to23316(var_args){
var args__5634__auto__ = [];
var len__5627__auto___23321 = arguments.length;
var i__5628__auto___23322 = (0);
while(true){
if((i__5628__auto___23322 < len__5627__auto___23321)){
args__5634__auto__.push((arguments[i__5628__auto___23322]));

var G__23323 = (i__5628__auto___23322 + (1));
i__5628__auto___23322 = G__23323;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.mail_to23316.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.mail_to23316.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__23319){
var vec__23320 = p__23319;
var content = cljs.core.nth.call(null,vec__23320,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4569__auto__ = content;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to23316.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to23316.cljs$lang$applyTo = (function (seq23317){
var G__23318 = cljs.core.first.call(null,seq23317);
var seq23317__$1 = cljs.core.next.call(null,seq23317);
return sablono.core.mail_to23316.cljs$core$IFn$_invoke$arity$variadic(G__23318,seq23317__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to23316);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list23324 = (function sablono$core$unordered_list23324(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__5341__auto__ = (function sablono$core$unordered_list23324_$_iter__23329(s__23330){
return (new cljs.core.LazySeq(null,(function (){
var s__23330__$1 = s__23330;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23330__$1);
if(temp__4425__auto__){
var s__23330__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23330__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__23330__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__23332 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__23331 = (0);
while(true){
if((i__23331 < size__5340__auto__)){
var x = cljs.core._nth.call(null,c__5339__auto__,i__23331);
cljs.core.chunk_append.call(null,b__23332,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__23333 = (i__23331 + (1));
i__23331 = G__23333;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23332),sablono$core$unordered_list23324_$_iter__23329.call(null,cljs.core.chunk_rest.call(null,s__23330__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23332),null);
}
} else {
var x = cljs.core.first.call(null,s__23330__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list23324_$_iter__23329.call(null,cljs.core.rest.call(null,s__23330__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list23324);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list23334 = (function sablono$core$ordered_list23334(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__5341__auto__ = (function sablono$core$ordered_list23334_$_iter__23339(s__23340){
return (new cljs.core.LazySeq(null,(function (){
var s__23340__$1 = s__23340;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23340__$1);
if(temp__4425__auto__){
var s__23340__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23340__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__23340__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__23342 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__23341 = (0);
while(true){
if((i__23341 < size__5340__auto__)){
var x = cljs.core._nth.call(null,c__5339__auto__,i__23341);
cljs.core.chunk_append.call(null,b__23342,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__23343 = (i__23341 + (1));
i__23341 = G__23343;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23342),sablono$core$ordered_list23334_$_iter__23339.call(null,cljs.core.chunk_rest.call(null,s__23340__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23342),null);
}
} else {
var x = cljs.core.first.call(null,s__23340__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list23334_$_iter__23339.call(null,cljs.core.rest.call(null,s__23340__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list23334);
/**
 * Create an image element.
 */
sablono.core.image23344 = (function sablono$core$image23344(var_args){
var args23345 = [];
var len__5627__auto___23348 = arguments.length;
var i__5628__auto___23349 = (0);
while(true){
if((i__5628__auto___23349 < len__5627__auto___23348)){
args23345.push((arguments[i__5628__auto___23349]));

var G__23350 = (i__5628__auto___23349 + (1));
i__5628__auto___23349 = G__23350;
continue;
} else {
}
break;
}

var G__23347 = args23345.length;
switch (G__23347) {
case 1:
return sablono.core.image23344.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image23344.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23345.length)].join('')));

}
});

sablono.core.image23344.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image23344.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image23344.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image23344);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__23352_SHARP_,p2__23353_SHARP_){
return [cljs.core.str(p1__23352_SHARP_),cljs.core.str("["),cljs.core.str(p2__23353_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__23354_SHARP_,p2__23355_SHARP_){
return [cljs.core.str(p1__23354_SHARP_),cljs.core.str("-"),cljs.core.str(p2__23355_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field23356 = (function sablono$core$color_field23356(var_args){
var args23357 = [];
var len__5627__auto___23424 = arguments.length;
var i__5628__auto___23425 = (0);
while(true){
if((i__5628__auto___23425 < len__5627__auto___23424)){
args23357.push((arguments[i__5628__auto___23425]));

var G__23426 = (i__5628__auto___23425 + (1));
i__5628__auto___23425 = G__23426;
continue;
} else {
}
break;
}

var G__23359 = args23357.length;
switch (G__23359) {
case 1:
return sablono.core.color_field23356.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field23356.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23357.length)].join('')));

}
});

sablono.core.color_field23356.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.color_field23356.call(null,name__12427__auto__,null);
});

sablono.core.color_field23356.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.color_field23356.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field23356);

/**
 * Creates a date input field.
 */
sablono.core.date_field23360 = (function sablono$core$date_field23360(var_args){
var args23361 = [];
var len__5627__auto___23428 = arguments.length;
var i__5628__auto___23429 = (0);
while(true){
if((i__5628__auto___23429 < len__5627__auto___23428)){
args23361.push((arguments[i__5628__auto___23429]));

var G__23430 = (i__5628__auto___23429 + (1));
i__5628__auto___23429 = G__23430;
continue;
} else {
}
break;
}

var G__23363 = args23361.length;
switch (G__23363) {
case 1:
return sablono.core.date_field23360.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field23360.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23361.length)].join('')));

}
});

sablono.core.date_field23360.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.date_field23360.call(null,name__12427__auto__,null);
});

sablono.core.date_field23360.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.date_field23360.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field23360);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field23364 = (function sablono$core$datetime_field23364(var_args){
var args23365 = [];
var len__5627__auto___23432 = arguments.length;
var i__5628__auto___23433 = (0);
while(true){
if((i__5628__auto___23433 < len__5627__auto___23432)){
args23365.push((arguments[i__5628__auto___23433]));

var G__23434 = (i__5628__auto___23433 + (1));
i__5628__auto___23433 = G__23434;
continue;
} else {
}
break;
}

var G__23367 = args23365.length;
switch (G__23367) {
case 1:
return sablono.core.datetime_field23364.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field23364.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23365.length)].join('')));

}
});

sablono.core.datetime_field23364.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.datetime_field23364.call(null,name__12427__auto__,null);
});

sablono.core.datetime_field23364.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.datetime_field23364.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field23364);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field23368 = (function sablono$core$datetime_local_field23368(var_args){
var args23369 = [];
var len__5627__auto___23436 = arguments.length;
var i__5628__auto___23437 = (0);
while(true){
if((i__5628__auto___23437 < len__5627__auto___23436)){
args23369.push((arguments[i__5628__auto___23437]));

var G__23438 = (i__5628__auto___23437 + (1));
i__5628__auto___23437 = G__23438;
continue;
} else {
}
break;
}

var G__23371 = args23369.length;
switch (G__23371) {
case 1:
return sablono.core.datetime_local_field23368.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field23368.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23369.length)].join('')));

}
});

sablono.core.datetime_local_field23368.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.datetime_local_field23368.call(null,name__12427__auto__,null);
});

sablono.core.datetime_local_field23368.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.datetime_local_field23368.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field23368);

/**
 * Creates a email input field.
 */
sablono.core.email_field23372 = (function sablono$core$email_field23372(var_args){
var args23373 = [];
var len__5627__auto___23440 = arguments.length;
var i__5628__auto___23441 = (0);
while(true){
if((i__5628__auto___23441 < len__5627__auto___23440)){
args23373.push((arguments[i__5628__auto___23441]));

var G__23442 = (i__5628__auto___23441 + (1));
i__5628__auto___23441 = G__23442;
continue;
} else {
}
break;
}

var G__23375 = args23373.length;
switch (G__23375) {
case 1:
return sablono.core.email_field23372.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field23372.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23373.length)].join('')));

}
});

sablono.core.email_field23372.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.email_field23372.call(null,name__12427__auto__,null);
});

sablono.core.email_field23372.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.email_field23372.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field23372);

/**
 * Creates a file input field.
 */
sablono.core.file_field23376 = (function sablono$core$file_field23376(var_args){
var args23377 = [];
var len__5627__auto___23444 = arguments.length;
var i__5628__auto___23445 = (0);
while(true){
if((i__5628__auto___23445 < len__5627__auto___23444)){
args23377.push((arguments[i__5628__auto___23445]));

var G__23446 = (i__5628__auto___23445 + (1));
i__5628__auto___23445 = G__23446;
continue;
} else {
}
break;
}

var G__23379 = args23377.length;
switch (G__23379) {
case 1:
return sablono.core.file_field23376.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field23376.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23377.length)].join('')));

}
});

sablono.core.file_field23376.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.file_field23376.call(null,name__12427__auto__,null);
});

sablono.core.file_field23376.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.file_field23376.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field23376);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field23380 = (function sablono$core$hidden_field23380(var_args){
var args23381 = [];
var len__5627__auto___23448 = arguments.length;
var i__5628__auto___23449 = (0);
while(true){
if((i__5628__auto___23449 < len__5627__auto___23448)){
args23381.push((arguments[i__5628__auto___23449]));

var G__23450 = (i__5628__auto___23449 + (1));
i__5628__auto___23449 = G__23450;
continue;
} else {
}
break;
}

var G__23383 = args23381.length;
switch (G__23383) {
case 1:
return sablono.core.hidden_field23380.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field23380.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23381.length)].join('')));

}
});

sablono.core.hidden_field23380.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.hidden_field23380.call(null,name__12427__auto__,null);
});

sablono.core.hidden_field23380.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.hidden_field23380.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field23380);

/**
 * Creates a month input field.
 */
sablono.core.month_field23384 = (function sablono$core$month_field23384(var_args){
var args23385 = [];
var len__5627__auto___23452 = arguments.length;
var i__5628__auto___23453 = (0);
while(true){
if((i__5628__auto___23453 < len__5627__auto___23452)){
args23385.push((arguments[i__5628__auto___23453]));

var G__23454 = (i__5628__auto___23453 + (1));
i__5628__auto___23453 = G__23454;
continue;
} else {
}
break;
}

var G__23387 = args23385.length;
switch (G__23387) {
case 1:
return sablono.core.month_field23384.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field23384.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23385.length)].join('')));

}
});

sablono.core.month_field23384.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.month_field23384.call(null,name__12427__auto__,null);
});

sablono.core.month_field23384.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.month_field23384.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field23384);

/**
 * Creates a number input field.
 */
sablono.core.number_field23388 = (function sablono$core$number_field23388(var_args){
var args23389 = [];
var len__5627__auto___23456 = arguments.length;
var i__5628__auto___23457 = (0);
while(true){
if((i__5628__auto___23457 < len__5627__auto___23456)){
args23389.push((arguments[i__5628__auto___23457]));

var G__23458 = (i__5628__auto___23457 + (1));
i__5628__auto___23457 = G__23458;
continue;
} else {
}
break;
}

var G__23391 = args23389.length;
switch (G__23391) {
case 1:
return sablono.core.number_field23388.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field23388.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23389.length)].join('')));

}
});

sablono.core.number_field23388.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.number_field23388.call(null,name__12427__auto__,null);
});

sablono.core.number_field23388.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.number_field23388.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field23388);

/**
 * Creates a password input field.
 */
sablono.core.password_field23392 = (function sablono$core$password_field23392(var_args){
var args23393 = [];
var len__5627__auto___23460 = arguments.length;
var i__5628__auto___23461 = (0);
while(true){
if((i__5628__auto___23461 < len__5627__auto___23460)){
args23393.push((arguments[i__5628__auto___23461]));

var G__23462 = (i__5628__auto___23461 + (1));
i__5628__auto___23461 = G__23462;
continue;
} else {
}
break;
}

var G__23395 = args23393.length;
switch (G__23395) {
case 1:
return sablono.core.password_field23392.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field23392.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23393.length)].join('')));

}
});

sablono.core.password_field23392.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.password_field23392.call(null,name__12427__auto__,null);
});

sablono.core.password_field23392.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.password_field23392.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field23392);

/**
 * Creates a range input field.
 */
sablono.core.range_field23396 = (function sablono$core$range_field23396(var_args){
var args23397 = [];
var len__5627__auto___23464 = arguments.length;
var i__5628__auto___23465 = (0);
while(true){
if((i__5628__auto___23465 < len__5627__auto___23464)){
args23397.push((arguments[i__5628__auto___23465]));

var G__23466 = (i__5628__auto___23465 + (1));
i__5628__auto___23465 = G__23466;
continue;
} else {
}
break;
}

var G__23399 = args23397.length;
switch (G__23399) {
case 1:
return sablono.core.range_field23396.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field23396.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23397.length)].join('')));

}
});

sablono.core.range_field23396.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.range_field23396.call(null,name__12427__auto__,null);
});

sablono.core.range_field23396.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.range_field23396.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field23396);

/**
 * Creates a search input field.
 */
sablono.core.search_field23400 = (function sablono$core$search_field23400(var_args){
var args23401 = [];
var len__5627__auto___23468 = arguments.length;
var i__5628__auto___23469 = (0);
while(true){
if((i__5628__auto___23469 < len__5627__auto___23468)){
args23401.push((arguments[i__5628__auto___23469]));

var G__23470 = (i__5628__auto___23469 + (1));
i__5628__auto___23469 = G__23470;
continue;
} else {
}
break;
}

var G__23403 = args23401.length;
switch (G__23403) {
case 1:
return sablono.core.search_field23400.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field23400.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23401.length)].join('')));

}
});

sablono.core.search_field23400.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.search_field23400.call(null,name__12427__auto__,null);
});

sablono.core.search_field23400.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.search_field23400.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field23400);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field23404 = (function sablono$core$tel_field23404(var_args){
var args23405 = [];
var len__5627__auto___23472 = arguments.length;
var i__5628__auto___23473 = (0);
while(true){
if((i__5628__auto___23473 < len__5627__auto___23472)){
args23405.push((arguments[i__5628__auto___23473]));

var G__23474 = (i__5628__auto___23473 + (1));
i__5628__auto___23473 = G__23474;
continue;
} else {
}
break;
}

var G__23407 = args23405.length;
switch (G__23407) {
case 1:
return sablono.core.tel_field23404.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field23404.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23405.length)].join('')));

}
});

sablono.core.tel_field23404.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.tel_field23404.call(null,name__12427__auto__,null);
});

sablono.core.tel_field23404.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.tel_field23404.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field23404);

/**
 * Creates a text input field.
 */
sablono.core.text_field23408 = (function sablono$core$text_field23408(var_args){
var args23409 = [];
var len__5627__auto___23476 = arguments.length;
var i__5628__auto___23477 = (0);
while(true){
if((i__5628__auto___23477 < len__5627__auto___23476)){
args23409.push((arguments[i__5628__auto___23477]));

var G__23478 = (i__5628__auto___23477 + (1));
i__5628__auto___23477 = G__23478;
continue;
} else {
}
break;
}

var G__23411 = args23409.length;
switch (G__23411) {
case 1:
return sablono.core.text_field23408.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field23408.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23409.length)].join('')));

}
});

sablono.core.text_field23408.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.text_field23408.call(null,name__12427__auto__,null);
});

sablono.core.text_field23408.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.text_field23408.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field23408);

/**
 * Creates a time input field.
 */
sablono.core.time_field23412 = (function sablono$core$time_field23412(var_args){
var args23413 = [];
var len__5627__auto___23480 = arguments.length;
var i__5628__auto___23481 = (0);
while(true){
if((i__5628__auto___23481 < len__5627__auto___23480)){
args23413.push((arguments[i__5628__auto___23481]));

var G__23482 = (i__5628__auto___23481 + (1));
i__5628__auto___23481 = G__23482;
continue;
} else {
}
break;
}

var G__23415 = args23413.length;
switch (G__23415) {
case 1:
return sablono.core.time_field23412.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field23412.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23413.length)].join('')));

}
});

sablono.core.time_field23412.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.time_field23412.call(null,name__12427__auto__,null);
});

sablono.core.time_field23412.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.time_field23412.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field23412);

/**
 * Creates a url input field.
 */
sablono.core.url_field23416 = (function sablono$core$url_field23416(var_args){
var args23417 = [];
var len__5627__auto___23484 = arguments.length;
var i__5628__auto___23485 = (0);
while(true){
if((i__5628__auto___23485 < len__5627__auto___23484)){
args23417.push((arguments[i__5628__auto___23485]));

var G__23486 = (i__5628__auto___23485 + (1));
i__5628__auto___23485 = G__23486;
continue;
} else {
}
break;
}

var G__23419 = args23417.length;
switch (G__23419) {
case 1:
return sablono.core.url_field23416.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field23416.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23417.length)].join('')));

}
});

sablono.core.url_field23416.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.url_field23416.call(null,name__12427__auto__,null);
});

sablono.core.url_field23416.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.url_field23416.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field23416);

/**
 * Creates a week input field.
 */
sablono.core.week_field23420 = (function sablono$core$week_field23420(var_args){
var args23421 = [];
var len__5627__auto___23488 = arguments.length;
var i__5628__auto___23489 = (0);
while(true){
if((i__5628__auto___23489 < len__5627__auto___23488)){
args23421.push((arguments[i__5628__auto___23489]));

var G__23490 = (i__5628__auto___23489 + (1));
i__5628__auto___23489 = G__23490;
continue;
} else {
}
break;
}

var G__23423 = args23421.length;
switch (G__23423) {
case 1:
return sablono.core.week_field23420.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field23420.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23421.length)].join('')));

}
});

sablono.core.week_field23420.cljs$core$IFn$_invoke$arity$1 = (function (name__12427__auto__){
return sablono.core.week_field23420.call(null,name__12427__auto__,null);
});

sablono.core.week_field23420.cljs$core$IFn$_invoke$arity$2 = (function (name__12427__auto__,value__12428__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__12427__auto__,value__12428__auto__);
});

sablono.core.week_field23420.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field23420);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box23492 = (function sablono$core$check_box23492(var_args){
var args23493 = [];
var len__5627__auto___23496 = arguments.length;
var i__5628__auto___23497 = (0);
while(true){
if((i__5628__auto___23497 < len__5627__auto___23496)){
args23493.push((arguments[i__5628__auto___23497]));

var G__23498 = (i__5628__auto___23497 + (1));
i__5628__auto___23497 = G__23498;
continue;
} else {
}
break;
}

var G__23495 = args23493.length;
switch (G__23495) {
case 1:
return sablono.core.check_box23492.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box23492.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box23492.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23493.length)].join('')));

}
});

sablono.core.check_box23492.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box23492.call(null,name,null);
});

sablono.core.check_box23492.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box23492.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box23492.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box23492.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box23492);
/**
 * Creates a radio button.
 */
sablono.core.radio_button23500 = (function sablono$core$radio_button23500(var_args){
var args23501 = [];
var len__5627__auto___23504 = arguments.length;
var i__5628__auto___23505 = (0);
while(true){
if((i__5628__auto___23505 < len__5627__auto___23504)){
args23501.push((arguments[i__5628__auto___23505]));

var G__23506 = (i__5628__auto___23505 + (1));
i__5628__auto___23505 = G__23506;
continue;
} else {
}
break;
}

var G__23503 = args23501.length;
switch (G__23503) {
case 1:
return sablono.core.radio_button23500.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button23500.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button23500.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23501.length)].join('')));

}
});

sablono.core.radio_button23500.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button23500.call(null,group,null);
});

sablono.core.radio_button23500.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button23500.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button23500.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button23500.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button23500);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options23508 = (function sablono$core$select_options23508(var_args){
var args23509 = [];
var len__5627__auto___23520 = arguments.length;
var i__5628__auto___23521 = (0);
while(true){
if((i__5628__auto___23521 < len__5627__auto___23520)){
args23509.push((arguments[i__5628__auto___23521]));

var G__23522 = (i__5628__auto___23521 + (1));
i__5628__auto___23521 = G__23522;
continue;
} else {
}
break;
}

var G__23511 = args23509.length;
switch (G__23511) {
case 1:
return sablono.core.select_options23508.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options23508.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23509.length)].join('')));

}
});

sablono.core.select_options23508.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options23508.call(null,coll,null);
});

sablono.core.select_options23508.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__5341__auto__ = (function sablono$core$iter__23512(s__23513){
return (new cljs.core.LazySeq(null,(function (){
var s__23513__$1 = s__23513;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23513__$1);
if(temp__4425__auto__){
var s__23513__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23513__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__23513__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__23515 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__23514 = (0);
while(true){
if((i__23514 < size__5340__auto__)){
var x = cljs.core._nth.call(null,c__5339__auto__,i__23514);
cljs.core.chunk_append.call(null,b__23515,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__23518 = x;
var text = cljs.core.nth.call(null,vec__23518,(0),null);
var val = cljs.core.nth.call(null,vec__23518,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__23518,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options23508.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)));

var G__23524 = (i__23514 + (1));
i__23514 = G__23524;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23515),sablono$core$iter__23512.call(null,cljs.core.chunk_rest.call(null,s__23513__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23515),null);
}
} else {
var x = cljs.core.first.call(null,s__23513__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__23519 = x;
var text = cljs.core.nth.call(null,vec__23519,(0),null);
var val = cljs.core.nth.call(null,vec__23519,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__23519,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options23508.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)),sablono$core$iter__23512.call(null,cljs.core.rest.call(null,s__23513__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,coll);
});

sablono.core.select_options23508.cljs$lang$maxFixedArity = 2;

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options23508);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down23525 = (function sablono$core$drop_down23525(var_args){
var args23526 = [];
var len__5627__auto___23529 = arguments.length;
var i__5628__auto___23530 = (0);
while(true){
if((i__5628__auto___23530 < len__5627__auto___23529)){
args23526.push((arguments[i__5628__auto___23530]));

var G__23531 = (i__5628__auto___23530 + (1));
i__5628__auto___23530 = G__23531;
continue;
} else {
}
break;
}

var G__23528 = args23526.length;
switch (G__23528) {
case 2:
return sablono.core.drop_down23525.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down23525.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23526.length)].join('')));

}
});

sablono.core.drop_down23525.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down23525.call(null,name,options,null);
});

sablono.core.drop_down23525.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down23525.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down23525);
/**
 * Creates a text area element.
 */
sablono.core.text_area23533 = (function sablono$core$text_area23533(var_args){
var args23534 = [];
var len__5627__auto___23537 = arguments.length;
var i__5628__auto___23538 = (0);
while(true){
if((i__5628__auto___23538 < len__5627__auto___23537)){
args23534.push((arguments[i__5628__auto___23538]));

var G__23539 = (i__5628__auto___23538 + (1));
i__5628__auto___23538 = G__23539;
continue;
} else {
}
break;
}

var G__23536 = args23534.length;
switch (G__23536) {
case 1:
return sablono.core.text_area23533.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area23533.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23534.length)].join('')));

}
});

sablono.core.text_area23533.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area23533.call(null,name,null);
});

sablono.core.text_area23533.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area23533.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area23533);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label23541 = (function sablono$core$label23541(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label23541);
/**
 * Creates a submit button.
 */
sablono.core.submit_button23542 = (function sablono$core$submit_button23542(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button23542);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button23543 = (function sablono$core$reset_button23543(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button23543);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to23544 = (function sablono$core$form_to23544(var_args){
var args__5634__auto__ = [];
var len__5627__auto___23549 = arguments.length;
var i__5628__auto___23550 = (0);
while(true){
if((i__5628__auto___23550 < len__5627__auto___23549)){
args__5634__auto__.push((arguments[i__5628__auto___23550]));

var G__23551 = (i__5628__auto___23550 + (1));
i__5628__auto___23550 = G__23551;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.form_to23544.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.form_to23544.cljs$core$IFn$_invoke$arity$variadic = (function (p__23547,body){
var vec__23548 = p__23547;
var method = cljs.core.nth.call(null,vec__23548,(0),null);
var action = cljs.core.nth.call(null,vec__23548,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,"_method",method_str)], null)),body));
});

sablono.core.form_to23544.cljs$lang$maxFixedArity = (1);

sablono.core.form_to23544.cljs$lang$applyTo = (function (seq23545){
var G__23546 = cljs.core.first.call(null,seq23545);
var seq23545__$1 = cljs.core.next.call(null,seq23545);
return sablono.core.form_to23544.cljs$core$IFn$_invoke$arity$variadic(G__23546,seq23545__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to23544);
