// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.shared');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('sablono.core');
goog.require('hatti.utils.om.state');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('om.core');
goog.require('hatti.utils');
hatti.shared.event_chan = cljs.core.async.chan.call(null);
hatti.shared.event_multi_chan = cljs.core.async.mult.call(null,hatti.shared.event_chan);
hatti.shared.event_tap = (function hatti$shared$event_tap(){
return cljs.core.async.tap.call(null,hatti.shared.event_multi_chan,cljs.core.async.chan.call(null));
});
hatti.shared.external_event_chan = cljs.core.async.chan.call(null);
hatti.shared.external_event_multi_chan = cljs.core.async.mult.call(null,hatti.shared.external_event_chan);
hatti.shared.external_event_tap = (function hatti$shared$external_event_tap(){
return cljs.core.async.tap.call(null,hatti.shared.external_event_multi_chan,cljs.core.async.chan.call(null));
});
hatti.shared.default_fields = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"full-name","full-name",408178550),"_submission_time",new cljs.core.Keyword(null,"label","label",1718410804),"Submission Time",new cljs.core.Keyword(null,"name","name",1843675177),"_submission_time",new cljs.core.Keyword(null,"type","type",1174270348),"datetime"], null)], null);
/**
 * An initial, empty, app-state, which can be modified to change dataviews.
 */
hatti.shared.empty_app_state = (function hatti$shared$empty_app_state(){
return cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"views","views",1450155487),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"overview","overview",-435037267),new cljs.core.Keyword(null,"map","map",1371690461),new cljs.core.Keyword(null,"table","table",-564943036),new cljs.core.Keyword(null,"chart","chart",1173225425),new cljs.core.Keyword(null,"settings","settings",1556144875)], null),new cljs.core.Keyword(null,"selected","selected",574897764),new cljs.core.Keyword(null,"overview","overview",-435037267)], null),new cljs.core.Keyword(null,"map-page","map-page",108547100),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),null], null),new cljs.core.Keyword(null,"geofield","geofield",578715548),cljs.core.PersistentArrayMap.EMPTY], null),new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),null], null)], null),new cljs.core.Keyword(null,"chart-page","chart-page",14505465),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"visible-charts","visible-charts",-1864927735),hatti.shared.default_fields,new cljs.core.Keyword(null,"chart-data","chart-data",-1181877206),cljs.core.PersistentArrayMap.EMPTY], null),new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"total-records","total-records",-1940276645),(0),new cljs.core.Keyword(null,"loading?","loading?",1905707049),true], null),new cljs.core.Keyword(null,"languages","languages",1471910331),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"current","current",-1088038603),null,new cljs.core.Keyword(null,"all","all",892129742),cljs.core.PersistentVector.EMPTY], null)], null));
});
hatti.shared.app_state = hatti.shared.empty_app_state.call(null);
/**
 * Given a function over data, run a transact on data inside app-state.
 */
hatti.shared.transact_app_data_BANG_ = (function hatti$shared$transact_app_data_BANG_(app_state,transact_fn){
return hatti.utils.om.state.transact_app_state_BANG_.call(null,app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null),transact_fn);
});
/**
 * Given `data` received from the server, update the app-state.
 * Sorts by submission time, and adds rank to the data, for table + map views.
 */
hatti.shared.update_app_data_BANG_ = (function hatti$shared$update_app_data_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___91749 = arguments.length;
var i__5628__auto___91750 = (0);
while(true){
if((i__5628__auto___91750 < len__5627__auto___91749)){
args__5634__auto__.push((arguments[i__5628__auto___91750]));

var G__91751 = (i__5628__auto___91750 + (1));
i__5628__auto___91750 = G__91751;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,data,p__91746){
var map__91747 = p__91746;
var map__91747__$1 = ((((!((map__91747 == null)))?((((map__91747.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91747.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91747):map__91747);
var rerank_QMARK_ = cljs.core.get.call(null,map__91747__$1,new cljs.core.Keyword(null,"rerank?","rerank?",-177233089));
var completed_QMARK_ = cljs.core.get.call(null,map__91747__$1,new cljs.core.Keyword(null,"completed?","completed?",946828354));
var sort_field = cljs.core.get.call(null,map__91747__$1,new cljs.core.Keyword(null,"sort-field","sort-field",-941433793));
var current_start_index = cljs.core.get.call(null,map__91747__$1,new cljs.core.Keyword(null,"current-start-index","current-start-index",-285076643),(0));
var add_rank = ((function (map__91747,map__91747__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (i,v){
return cljs.core.assoc.call(null,v,hatti.constants._rank,(current_start_index + (i + (1))));
});})(map__91747,map__91747__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
;
var data__$1 = (cljs.core.truth_((function (){var and__4557__auto__ = rerank_QMARK_;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.seq.call(null,data);
} else {
return and__4557__auto__;
}
})())?cljs.core.vec.call(null,cljs.core.map_indexed.call(null,add_rank,cljs.core.sort_by.call(null,((function (add_rank,map__91747,map__91747__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (p1__91742_SHARP_){
return cljs.core.get.call(null,p1__91742_SHARP_,(function (){var or__4569__auto__ = sort_field;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.constants._submission_time;
}
})());
});})(add_rank,map__91747,map__91747__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
,data))):cljs.core.vec.call(null,cljs.core.map_indexed.call(null,add_rank,data)));
var total_records = cljs.core.count.call(null,data__$1);
hatti.shared.transact_app_data_BANG_.call(null,app_state,((function (add_rank,data__$1,total_records,map__91747,map__91747__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (_){
return data__$1;
});})(add_rank,data__$1,total_records,map__91747,map__91747__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
);

return hatti.utils.om.state.merge_into_app_state_BANG_.call(null,app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"status","status",-1997798413)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"total-records","total-records",-1940276645),total_records,new cljs.core.Keyword(null,"loading?","loading?",1905707049),cljs.core.not.call(null,completed_QMARK_)], null));
});

hatti.shared.update_app_data_BANG_.cljs$lang$maxFixedArity = (2);

hatti.shared.update_app_data_BANG_.cljs$lang$applyTo = (function (seq91743){
var G__91744 = cljs.core.first.call(null,seq91743);
var seq91743__$1 = cljs.core.next.call(null,seq91743);
var G__91745 = cljs.core.first.call(null,seq91743__$1);
var seq91743__$2 = cljs.core.next.call(null,seq91743__$1);
return hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__91744,G__91745,seq91743__$2);
});
/**
 * Add to app data.
 */
hatti.shared.add_to_app_data_BANG_ = (function hatti$shared$add_to_app_data_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___91758 = arguments.length;
var i__5628__auto___91759 = (0);
while(true){
if((i__5628__auto___91759 < len__5627__auto___91758)){
args__5634__auto__.push((arguments[i__5628__auto___91759]));

var G__91760 = (i__5628__auto___91759 + (1));
i__5628__auto___91759 = G__91760;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,data,p__91755){
var map__91756 = p__91755;
var map__91756__$1 = ((((!((map__91756 == null)))?((((map__91756.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91756.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91756):map__91756);
var completed_QMARK_ = cljs.core.get.call(null,map__91756__$1,new cljs.core.Keyword(null,"completed?","completed?",946828354));
var old_data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,app_state));
hatti.shared.update_app_data_BANG_.call(null,app_state,cljs.core.concat.call(null,old_data,data),new cljs.core.Keyword(null,"rerank?","rerank?",-177233089),completed_QMARK_);

return hatti.utils.om.state.update_app_state_BANG_.call(null,app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"loading?","loading?",1905707049)], null),cljs.core.not.call(null,completed_QMARK_));
});

hatti.shared.add_to_app_data_BANG_.cljs$lang$maxFixedArity = (2);

hatti.shared.add_to_app_data_BANG_.cljs$lang$applyTo = (function (seq91752){
var G__91753 = cljs.core.first.call(null,seq91752);
var seq91752__$1 = cljs.core.next.call(null,seq91752);
var G__91754 = cljs.core.first.call(null,seq91752__$1);
var seq91752__$2 = cljs.core.next.call(null,seq91752__$1);
return hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__91753,G__91754,seq91752__$2);
});
hatti.shared.language_cursor = (function hatti$shared$language_cursor(){
return om.core.ref_cursor.call(null,new cljs.core.Keyword(null,"languages","languages",1471910331).cljs$core$IFn$_invoke$arity$1(om.core.root_cursor.call(null,hatti.shared.app_state)));
});
/**
 * A language selector and a following divider.
 */
hatti.shared.language_selector = (function hatti$shared$language_selector(_,owner){
if(typeof hatti.shared.t_hatti$shared91779 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.shared.t_hatti$shared91779 = (function (language_selector,_,owner,meta91780){
this.language_selector = language_selector;
this._ = _;
this.owner = owner;
this.meta91780 = meta91780;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.shared.t_hatti$shared91779.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_91781,meta91780__$1){
var self__ = this;
var _91781__$1 = this;
return (new hatti.shared.t_hatti$shared91779(self__.language_selector,self__._,self__.owner,meta91780__$1));
});

hatti.shared.t_hatti$shared91779.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_91781){
var self__ = this;
var _91781__$1 = this;
return self__.meta91780;
});

hatti.shared.t_hatti$shared91779.prototype.om$core$IRender$ = true;

hatti.shared.t_hatti$shared91779.prototype.om$core$IRender$render$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var map__91782 = om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null));
var map__91782__$1 = ((((!((map__91782 == null)))?((((map__91782.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91782.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91782):map__91782);
var ls = map__91782__$1;
var current = cljs.core.get.call(null,map__91782__$1,new cljs.core.Keyword(null,"current","current",-1088038603));
var all = cljs.core.get.call(null,map__91782__$1,new cljs.core.Keyword(null,"all","all",892129742));
var update_current = ((function (map__91782,map__91782__$1,ls,current,all,___$2){
return (function (p1__91761_SHARP_){
return om.core.update_BANG_.call(null,ls,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current","current",-1088038603)], null),p1__91761_SHARP_);
});})(map__91782,map__91782__$1,ls,current,all,___$2))
;
var stringify = ((function (map__91782,map__91782__$1,ls,current,all,update_current,___$2){
return (function (p1__91762_SHARP_){
if((p1__91762_SHARP_ instanceof cljs.core.Keyword)){
return cljs.core.name.call(null,p1__91762_SHARP_);
} else {
return [cljs.core.str(p1__91762_SHARP_)].join('');
}
});})(map__91782,map__91782__$1,ls,current,all,update_current,___$2))
;
return React.DOM.div({"className": "language-selector-inner"},React.DOM.span({"className": "dropdown drop-hover"},React.DOM.i({"style": {"marginRight": ".2em"}, "className": "fa fa-globe"}),(function (){var attrs91786 = (cljs.core.truth_(hatti.ona.forms.english_QMARK_.call(null,current))?"EN":stringify.call(null,current));
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs91786))?sablono.interpreter.attributes.call(null,attrs91786):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs91786))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs91786)], null))));
})(),React.DOM.i({"style": {"marginLeft": ".5em"}, "className": "fa fa-angle-down"}),React.DOM.ul({"className": "submenu"},cljs.core.into_array.call(null,(function (){var iter__5341__auto__ = ((function (map__91782,map__91782__$1,ls,current,all,update_current,stringify,___$2){
return (function hatti$shared$language_selector_$_iter__91791(s__91792){
return (new cljs.core.LazySeq(null,((function (map__91782,map__91782__$1,ls,current,all,update_current,stringify,___$2){
return (function (){
var s__91792__$1 = s__91792;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__91792__$1);
if(temp__4425__auto__){
var s__91792__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__91792__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__91792__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__91794 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__91793 = (0);
while(true){
if((i__91793 < size__5340__auto__)){
var l = cljs.core._nth.call(null,c__5339__auto__,i__91793);
cljs.core.chunk_append.call(null,b__91794,React.DOM.li(null,React.DOM.a({"href": "#", "onClick": ((function (i__91793,l,c__5339__auto__,size__5340__auto__,b__91794,s__91792__$2,temp__4425__auto__,map__91782,map__91782__$1,ls,current,all,update_current,stringify,___$2){
return (function (){
return update_current.call(null,l);
});})(i__91793,l,c__5339__auto__,size__5340__auto__,b__91794,s__91792__$2,temp__4425__auto__,map__91782,map__91782__$1,ls,current,all,update_current,stringify,___$2))
},sablono.interpreter.interpret.call(null,stringify.call(null,l)))));

var G__91795 = (i__91793 + (1));
i__91793 = G__91795;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91794),hatti$shared$language_selector_$_iter__91791.call(null,cljs.core.chunk_rest.call(null,s__91792__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91794),null);
}
} else {
var l = cljs.core.first.call(null,s__91792__$2);
return cljs.core.cons.call(null,React.DOM.li(null,React.DOM.a({"href": "#", "onClick": ((function (l,s__91792__$2,temp__4425__auto__,map__91782,map__91782__$1,ls,current,all,update_current,stringify,___$2){
return (function (){
return update_current.call(null,l);
});})(l,s__91792__$2,temp__4425__auto__,map__91782,map__91782__$1,ls,current,all,update_current,stringify,___$2))
},sablono.interpreter.interpret.call(null,stringify.call(null,l)))),hatti$shared$language_selector_$_iter__91791.call(null,cljs.core.rest.call(null,s__91792__$2)));
}
} else {
return null;
}
break;
}
});})(map__91782,map__91782__$1,ls,current,all,update_current,stringify,___$2))
,null,null));
});})(map__91782,map__91782__$1,ls,current,all,update_current,stringify,___$2))
;
return iter__5341__auto__.call(null,all);
})()))),React.DOM.div({"className": "divider"}));
});

hatti.shared.t_hatti$shared91779.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"language-selector","language-selector",-1895427281,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"A language selector and a following divider."], null)),new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta91780","meta91780",-2028296646,null)], null);
});

hatti.shared.t_hatti$shared91779.cljs$lang$type = true;

hatti.shared.t_hatti$shared91779.cljs$lang$ctorStr = "hatti.shared/t_hatti$shared91779";

hatti.shared.t_hatti$shared91779.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.shared/t_hatti$shared91779");
});

hatti.shared.__GT_t_hatti$shared91779 = (function hatti$shared$language_selector_$___GT_t_hatti$shared91779(language_selector__$1,___$1,owner__$1,meta91780){
return (new hatti.shared.t_hatti$shared91779(language_selector__$1,___$1,owner__$1,meta91780));
});

}

return (new hatti.shared.t_hatti$shared91779(hatti$shared$language_selector,_,owner,cljs.core.PersistentArrayMap.EMPTY));
});
