// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__8429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8429__auto__){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto__){
return (function (state_91636){
var state_val_91637 = (state_91636[(1)]);
if((state_val_91637 === (7))){
var inst_91593 = (state_91636[(7)]);
var inst_91593__$1 = (state_91636[(2)]);
var inst_91595 = (inst_91593__$1 == null);
var inst_91596 = cljs.core.not.call(null,inst_91595);
var state_91636__$1 = (function (){var statearr_91638 = state_91636;
(statearr_91638[(7)] = inst_91593__$1);

return statearr_91638;
})();
if(inst_91596){
var statearr_91639_91676 = state_91636__$1;
(statearr_91639_91676[(1)] = (8));

} else {
var statearr_91640_91677 = state_91636__$1;
(statearr_91640_91677[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91637 === (20))){
var inst_91615 = (state_91636[(8)]);
var inst_91623 = (state_91636[(2)]);
var state_91636__$1 = (function (){var statearr_91641 = state_91636;
(statearr_91641[(9)] = inst_91623);

return statearr_91641;
})();
if(cljs.core.truth_(inst_91615)){
var statearr_91642_91678 = state_91636__$1;
(statearr_91642_91678[(1)] = (21));

} else {
var statearr_91643_91679 = state_91636__$1;
(statearr_91643_91679[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91637 === (1))){
var state_91636__$1 = state_91636;
var statearr_91644_91680 = state_91636__$1;
(statearr_91644_91680[(2)] = null);

(statearr_91644_91680[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91637 === (4))){
var state_91636__$1 = state_91636;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_91636__$1,(7),agg_data_channel);
} else {
if((state_val_91637 === (15))){
var inst_91593 = (state_91636[(7)]);
var state_91636__$1 = state_91636;
var statearr_91645_91681 = state_91636__$1;
(statearr_91645_91681[(2)] = inst_91593);

(statearr_91645_91681[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91637 === (21))){
var inst_91625 = cljs.core.async.close_BANG_.call(null,agg_data_channel);
var state_91636__$1 = state_91636;
var statearr_91646_91682 = state_91636__$1;
(statearr_91646_91682[(2)] = inst_91625);

(statearr_91646_91682[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91637 === (13))){
var inst_91605 = (state_91636[(2)]);
var state_91636__$1 = state_91636;
var statearr_91647_91683 = state_91636__$1;
(statearr_91647_91683[(2)] = inst_91605);

(statearr_91647_91683[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91637 === (22))){
var state_91636__$1 = state_91636;
var statearr_91648_91684 = state_91636__$1;
(statearr_91648_91684[(2)] = null);

(statearr_91648_91684[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91637 === (6))){
var inst_91632 = (state_91636[(2)]);
var state_91636__$1 = state_91636;
var statearr_91649_91685 = state_91636__$1;
(statearr_91649_91685[(2)] = inst_91632);

(statearr_91649_91685[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91637 === (17))){
var inst_91614 = (state_91636[(10)]);
var inst_91615 = (state_91636[(8)]);
var inst_91617 = callback.call(null,inst_91614,inst_91615);
var state_91636__$1 = state_91636;
var statearr_91650_91686 = state_91636__$1;
(statearr_91650_91686[(2)] = inst_91617);

(statearr_91650_91686[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91637 === (3))){
var inst_91634 = (state_91636[(2)]);
var state_91636__$1 = state_91636;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_91636__$1,inst_91634);
} else {
if((state_val_91637 === (12))){
var state_91636__$1 = state_91636;
var statearr_91651_91687 = state_91636__$1;
(statearr_91651_91687[(2)] = false);

(statearr_91651_91687[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91637 === (2))){
var state_91636__$1 = state_91636;
var statearr_91652_91688 = state_91636__$1;
(statearr_91652_91688[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91637 === (23))){
var inst_91628 = (state_91636[(2)]);
var state_91636__$1 = (function (){var statearr_91654 = state_91636;
(statearr_91654[(11)] = inst_91628);

return statearr_91654;
})();
var statearr_91655_91689 = state_91636__$1;
(statearr_91655_91689[(2)] = null);

(statearr_91655_91689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91637 === (19))){
var inst_91620 = (state_91636[(2)]);
var inst_91621 = cljs.core.async.timeout.call(null,hatti.ona.stream.small_delay);
var state_91636__$1 = (function (){var statearr_91656 = state_91636;
(statearr_91656[(12)] = inst_91620);

return statearr_91656;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_91636__$1,(20),inst_91621);
} else {
if((state_val_91637 === (11))){
var state_91636__$1 = state_91636;
var statearr_91657_91690 = state_91636__$1;
(statearr_91657_91690[(2)] = true);

(statearr_91657_91690[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91637 === (9))){
var state_91636__$1 = state_91636;
var statearr_91658_91691 = state_91636__$1;
(statearr_91658_91691[(2)] = false);

(statearr_91658_91691[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91637 === (5))){
var state_91636__$1 = state_91636;
var statearr_91659_91692 = state_91636__$1;
(statearr_91659_91692[(2)] = null);

(statearr_91659_91692[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91637 === (14))){
var inst_91593 = (state_91636[(7)]);
var inst_91610 = cljs.core.apply.call(null,cljs.core.hash_map,inst_91593);
var state_91636__$1 = state_91636;
var statearr_91660_91693 = state_91636__$1;
(statearr_91660_91693[(2)] = inst_91610);

(statearr_91660_91693[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91637 === (16))){
var inst_91614 = (state_91636[(10)]);
var inst_91613 = (state_91636[(2)]);
var inst_91614__$1 = cljs.core.get.call(null,inst_91613,new cljs.core.Keyword(null,"data","data",-232669377));
var inst_91615 = cljs.core.get.call(null,inst_91613,new cljs.core.Keyword(null,"completed?","completed?",946828354));
var state_91636__$1 = (function (){var statearr_91661 = state_91636;
(statearr_91661[(10)] = inst_91614__$1);

(statearr_91661[(8)] = inst_91615);

return statearr_91661;
})();
if(cljs.core.truth_(inst_91614__$1)){
var statearr_91662_91694 = state_91636__$1;
(statearr_91662_91694[(1)] = (17));

} else {
var statearr_91663_91695 = state_91636__$1;
(statearr_91663_91695[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91637 === (10))){
var inst_91608 = (state_91636[(2)]);
var state_91636__$1 = state_91636;
if(cljs.core.truth_(inst_91608)){
var statearr_91664_91696 = state_91636__$1;
(statearr_91664_91696[(1)] = (14));

} else {
var statearr_91665_91697 = state_91636__$1;
(statearr_91665_91697[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91637 === (18))){
var state_91636__$1 = state_91636;
var statearr_91666_91698 = state_91636__$1;
(statearr_91666_91698[(2)] = null);

(statearr_91666_91698[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91637 === (8))){
var inst_91593 = (state_91636[(7)]);
var inst_91598 = inst_91593.cljs$lang$protocol_mask$partition0$;
var inst_91599 = (inst_91598 & (64));
var inst_91600 = inst_91593.cljs$core$ISeq$;
var inst_91601 = (inst_91599) || (inst_91600);
var state_91636__$1 = state_91636;
if(cljs.core.truth_(inst_91601)){
var statearr_91667_91699 = state_91636__$1;
(statearr_91667_91699[(1)] = (11));

} else {
var statearr_91668_91700 = state_91636__$1;
(statearr_91668_91700[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto__))
;
return ((function (switch__8364__auto__,c__8429__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto____0 = (function (){
var statearr_91672 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_91672[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto__);

(statearr_91672[(1)] = (1));

return statearr_91672;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto____1 = (function (state_91636){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_91636);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e91673){if((e91673 instanceof Object)){
var ex__8368__auto__ = e91673;
var statearr_91674_91701 = state_91636;
(statearr_91674_91701[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_91636);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e91673;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__91702 = state_91636;
state_91636 = G__91702;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto__ = function(state_91636){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto____1.call(this,state_91636);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto__))
})();
var state__8431__auto__ = (function (){var statearr_91675 = f__8430__auto__.call(null);
(statearr_91675[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto__);

return statearr_91675;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});})(c__8429__auto__))
);

return c__8429__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.call(null,read_count,cljs.core.inc);

cljs.core.swap_BANG_.call(null,agg,cljs.core.conj,data_chunk);

if(((cljs.core.deref.call(null,read_count) >= (100))) && (cljs.core.integer_QMARK_.call(null,Math.log10(cljs.core.deref.call(null,read_count))))){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg)], null));

cljs.core.reset_BANG_.call(null,agg,cljs.core.PersistentVector.EMPTY);

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___91709 = arguments.length;
var i__5628__auto___91710 = (0);
while(true){
if((i__5628__auto___91710 < len__5627__auto___91709)){
args__5634__auto__.push((arguments[i__5628__auto___91710]));

var G__91711 = (i__5628__auto___91710 + (1));
i__5628__auto___91710 = G__91711;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__91706){
var map__91707 = p__91706;
var map__91707__$1 = ((((!((map__91707 == null)))?((((map__91707.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91707.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91707):map__91707);
var oboe_headers = cljs.core.get.call(null,map__91707__$1,new cljs.core.Keyword(null,"oboe-headers","oboe-headers",-764778163));
var read_count = cljs.core.atom.call(null,(0));
var agg = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
var channel = cljs.core.async.chan.call(null);
var return_channel = cljs.core.async.chan.call(null);
var oboe_params = cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"headers","headers",-835030129),oboe_headers,new cljs.core.Keyword(null,"withCredentials","withCredentials",1719959454),true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__91707,map__91707__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_.call(null,cljs.core.js__GT_clj.call(null,line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__91707,map__91707__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__91707,map__91707__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg),new cljs.core.Keyword(null,"completed?","completed?",946828354),true], null));

return cljs.core.async.close_BANG_.call(null,return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__91707,map__91707__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_.call(null,channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq91703){
var G__91704 = cljs.core.first.call(null,seq91703);
var seq91703__$1 = cljs.core.next.call(null,seq91703);
var G__91705 = cljs.core.first.call(null,seq91703__$1);
var seq91703__$2 = cljs.core.next.call(null,seq91703__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__91704,G__91705,seq91703__$2);
});
