// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var extra_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,hatti.constants._id,cljs.core.cst$kw$label,"id",cljs.core.cst$kw$name,hatti.constants._id,cljs.core.cst$kw$type,"integer"], null)], null);
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
return extra_field;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(extra_field,hatti.ona.forms.submission_time_field);
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__5634__auto__ = [];
var len__5627__auto___97143 = arguments.length;
var i__5628__auto___97144 = (0);
while(true){
if((i__5628__auto___97144 < len__5627__auto___97143)){
args__5634__auto__.push((arguments[i__5628__auto___97144]));

var G__97145 = (i__5628__auto___97144 + (1));
i__5628__auto___97144 = G__97145;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__97140){
var map__97141 = p__97140;
var map__97141__$1 = ((((!((map__97141 == null)))?((((map__97141.cljs$lang$protocol_mask$partition0$ & (64))) || (map__97141.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__97141):map__97141);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__97141__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(hatti.views.table.get_extra_fields(is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,cljs.core.not(is_filtered_dataview_QMARK_)], 0))], 0))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq97138){
var G__97139 = cljs.core.first(seq97138);
var seq97138__$1 = cljs.core.next(seq97138);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__97139,seq97138__$1);
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__97146_SHARP_){
if(typeof p1__97146_SHARP_ === 'string'){
return clojure.string.lower_case(p1__97146_SHARP_);
} else {
return p1__97146_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__97150){
var vec__97151 = p__97150;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__97151,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__97151,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,null,true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__97147_SHARP_){
return cljs.core.re_find(hatti.utils.safe_regex(query),[cljs.core.str(p1__97147_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(field,clj_value,language,true);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args97152 = [];
var len__5627__auto___97176 = arguments.length;
var i__5628__auto___97177 = (0);
while(true){
if((i__5628__auto___97177 < len__5627__auto___97176)){
args97152.push((arguments[i__5628__auto___97177]));

var G__97178 = (i__5628__auto___97177 + (1));
i__5628__auto___97177 = G__97178;
continue;
} else {
}
break;
}

var G__97158 = args97152.length;
switch (G__97158) {
case 1:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args97152.slice((3)),(0)));
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1 = (function (form){
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2(form,true);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2 = (function (form,get_label_QMARK_){
return hatti.views.table.flat_form__GT_sg_columns(form,get_label_QMARK_,null);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,get_label_QMARK_,language,p__97159){
var map__97160 = p__97159;
var map__97160__$1 = ((((!((map__97160 == null)))?((((map__97160.cljs$lang$protocol_mask$partition0$ & (64))) || (map__97160.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__97160):map__97160);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__97160__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
return cljs.core.clj__GT_js((function (){var iter__5341__auto__ = ((function (map__97160,map__97160__$1,is_filtered_dataview_QMARK_){
return (function hatti$views$table$iter__97162(s__97163){
return (new cljs.core.LazySeq(null,((function (map__97160,map__97160__$1,is_filtered_dataview_QMARK_){
return (function (){
var s__97163__$1 = s__97163;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__97163__$1);
if(temp__4425__auto__){
var s__97163__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__97163__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__97163__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__97165 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__97164 = (0);
while(true){
if((i__97164 < size__5340__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__97164);
cljs.core.chunk_append(b__97165,(function (){var map__97172 = field;
var map__97172__$1 = ((((!((map__97172 == null)))?((((map__97172.cljs$lang$protocol_mask$partition0$ & (64))) || (map__97172.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__97172):map__97172);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__97172__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__97172__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__97172__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hatti.ona.forms.get_column_class(field),label,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class(field),label]);
})());

var G__97180 = (i__97164 + (1));
i__97164 = G__97180;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__97165),hatti$views$table$iter__97162(cljs.core.chunk_rest(s__97163__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__97165),null);
}
} else {
var field = cljs.core.first(s__97163__$2);
return cljs.core.cons((function (){var map__97174 = field;
var map__97174__$1 = ((((!((map__97174 == null)))?((((map__97174.cljs$lang$protocol_mask$partition0$ & (64))) || (map__97174.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__97174):map__97174);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__97174__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__97174__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__97174__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hatti.ona.forms.get_column_class(field),label,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class(field),label]);
})(),hatti$views$table$iter__97162(cljs.core.rest(s__97163__$2)));
}
} else {
return null;
}
break;
}
});})(map__97160,map__97160__$1,is_filtered_dataview_QMARK_))
,null,null));
});})(map__97160,map__97160__$1,is_filtered_dataview_QMARK_))
;
return iter__5341__auto__(hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0)));
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq97153){
var G__97154 = cljs.core.first(seq97153);
var seq97153__$1 = cljs.core.next(seq97153);
var G__97155 = cljs.core.first(seq97153__$1);
var seq97153__$2 = cljs.core.next(seq97153__$1);
var G__97156 = cljs.core.first(seq97153__$2);
var seq97153__$3 = cljs.core.next(seq97153__$2);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__97154,G__97155,G__97156,seq97153__$3);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (3);
hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__97182 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__97182);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = {"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": true};
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__97193(s__97194){
return (new cljs.core.LazySeq(null,(function (){
var s__97194__$1 = s__97194;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__97194__$1);
if(temp__4425__auto__){
var s__97194__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__97194__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__97194__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__97196 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__97195 = (0);
while(true){
if((i__97195 < size__5340__auto__)){
var vec__97201 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__97195);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__97201,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__97201,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__97196,event.subscribe(handler_function));

var G__97203 = (i__97195 + (1));
i__97195 = G__97203;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__97196),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__97193(cljs.core.chunk_rest(s__97194__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__97196),null);
}
} else {
var vec__97202 = cljs.core.first(s__97194__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__97202,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__97202,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__97193(cljs.core.rest(s__97194__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__97214(s__97215){
return (new cljs.core.LazySeq(null,(function (){
var s__97215__$1 = s__97215;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__97215__$1);
if(temp__4425__auto__){
var s__97215__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__97215__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__97215__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__97217 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__97216 = (0);
while(true){
if((i__97216 < size__5340__auto__)){
var vec__97222 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__97216);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__97222,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__97222,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__97217,event.subscribe(handler_function));

var G__97224 = (i__97216 + (1));
i__97216 = G__97224;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__97217),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__97214(cljs.core.chunk_rest(s__97215__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__97217),null);
}
} else {
var vec__97223 = cljs.core.first(s__97215__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__97223,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__97223,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__97214(cljs.core.rest(s__97215__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,p__97225){
var map__97234 = p__97225;
var map__97234__$1 = ((((!((map__97234 == null)))?((((map__97234.cljs$lang$protocol_mask$partition0$ & (64))) || (map__97234.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__97234):map__97234);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__97234__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__97234__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,true,current_language,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
var map__97236 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__97236__$1 = ((((!((map__97236 == null)))?((((map__97236.cljs$lang$protocol_mask$partition0$ & (64))) || (map__97236.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__97236):map__97236);
var map__97237 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__97236__$1,cljs.core.cst$kw$table_DASH_page);
var map__97237__$1 = ((((!((map__97237 == null)))?((((map__97237.cljs$lang$protocol_mask$partition0$ & (64))) || (map__97237.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__97237):map__97237);
var map__97238 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__97237__$1,cljs.core.cst$kw$paging);
var map__97238__$1 = ((((!((map__97238 == null)))?((((map__97238.cljs$lang$protocol_mask$partition0$ & (64))) || (map__97238.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__97238):map__97238);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__97238__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__97238__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__97236,map__97236__$1,map__97237,map__97237__$1,map__97238,map__97238__$1,num_displayed_records,total_page_count,map__97234,map__97234__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__97236,map__97236__$1,map__97237,map__97237__$1,map__97238,map__97238__$1,num_displayed_records,total_page_count,map__97234,map__97234__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__97236,map__97236__$1,map__97237,map__97237__$1,map__97238,map__97238__$1,num_displayed_records,total_page_count,map__97234,map__97234__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__97236,map__97236__$1,map__97237,map__97237__$1,map__97238,map__97238__$1,num_displayed_records,total_page_count,map__97234,map__97234__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__97236,map__97236__$1,map__97237,map__97237__$1,map__97238,map__97238__$1,num_displayed_records,total_page_count,map__97234,map__97234__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(columns,SlickGrid,DataView,dataview,grid,map__97236,map__97236__$1,map__97237,map__97237__$1,map__97238,map__97238__$1,num_displayed_records,total_page_count,map__97234,map__97234__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions({"pageSize": (function (){var or__4569__auto__ = num_displayed_records;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count});

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js(data),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__8429__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto__,event_chan){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto__,event_chan){
return (function (state_97503){
var state_val_97504 = (state_97503[(1)]);
if((state_val_97504 === (7))){
var inst_97412 = (state_97503[(7)]);
var inst_97412__$1 = (state_97503[(2)]);
var inst_97414 = (inst_97412__$1 == null);
var inst_97415 = cljs.core.not(inst_97414);
var state_97503__$1 = (function (){var statearr_97505 = state_97503;
(statearr_97505[(7)] = inst_97412__$1);

return statearr_97505;
})();
if(inst_97415){
var statearr_97506_97573 = state_97503__$1;
(statearr_97506_97573[(1)] = (8));

} else {
var statearr_97507_97574 = state_97503__$1;
(statearr_97507_97574[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (20))){
var inst_97434 = (state_97503[(8)]);
var inst_97442 = (state_97503[(9)]);
var inst_97451 = (inst_97442.cljs$core$IFn$_invoke$arity$1 ? inst_97442.cljs$core$IFn$_invoke$arity$1(inst_97434) : inst_97442.call(null,inst_97434));
var state_97503__$1 = state_97503;
var statearr_97508_97575 = state_97503__$1;
(statearr_97508_97575[(2)] = inst_97451);

(statearr_97508_97575[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (27))){
var state_97503__$1 = state_97503;
var statearr_97509_97576 = state_97503__$1;
(statearr_97509_97576[(2)] = null);

(statearr_97509_97576[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (1))){
var state_97503__$1 = state_97503;
var statearr_97510_97577 = state_97503__$1;
(statearr_97510_97577[(2)] = null);

(statearr_97510_97577[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (24))){
var state_97503__$1 = state_97503;
var statearr_97511_97578 = state_97503__$1;
(statearr_97511_97578[(2)] = null);

(statearr_97511_97578[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (4))){
var state_97503__$1 = state_97503;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_97503__$1,(7),event_chan);
} else {
if((state_val_97504 === (15))){
var inst_97412 = (state_97503[(7)]);
var state_97503__$1 = state_97503;
var statearr_97512_97579 = state_97503__$1;
(statearr_97512_97579[(2)] = inst_97412);

(statearr_97512_97579[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (21))){
var state_97503__$1 = state_97503;
var statearr_97513_97580 = state_97503__$1;
(statearr_97513_97580[(2)] = null);

(statearr_97513_97580[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (31))){
var inst_97438 = (state_97503[(10)]);
var inst_97476 = (state_97503[(2)]);
var inst_97477 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_97438,cljs.core.cst$kw$table);
var state_97503__$1 = (function (){var statearr_97514 = state_97503;
(statearr_97514[(11)] = inst_97476);

return statearr_97514;
})();
if(inst_97477){
var statearr_97515_97581 = state_97503__$1;
(statearr_97515_97581[(1)] = (32));

} else {
var statearr_97516_97582 = state_97503__$1;
(statearr_97516_97582[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (32))){
var inst_97434 = (state_97503[(8)]);
var inst_97412 = (state_97503[(7)]);
var inst_97433 = (state_97503[(12)]);
var inst_97442 = (state_97503[(9)]);
var inst_97435 = (state_97503[(13)]);
var inst_97437 = (state_97503[(14)]);
var inst_97432 = (state_97503[(15)]);
var inst_97438 = (state_97503[(10)]);
var inst_97436 = (state_97503[(16)]);
var inst_97443 = (state_97503[(17)]);
var inst_97490 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_97491 = (function (){var map__97410 = inst_97432;
var new_columns = inst_97437;
var submission_clicked = inst_97434;
var submission_unclicked = inst_97435;
var get_submission_data = inst_97443;
var re_render = inst_97438;
var update_data_BANG_ = inst_97442;
var submission_to_rank = inst_97433;
var e = inst_97412;
var c__8429__auto____$1 = inst_97490;
var filter_by = inst_97436;
return ((function (map__97410,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,c__8429__auto____$1,filter_by,inst_97434,inst_97412,inst_97433,inst_97442,inst_97435,inst_97437,inst_97432,inst_97438,inst_97436,inst_97443,inst_97490,state_val_97504,c__8429__auto__,event_chan){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (map__97410,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,c__8429__auto____$1,filter_by,inst_97434,inst_97412,inst_97433,inst_97442,inst_97435,inst_97437,inst_97432,inst_97438,inst_97436,inst_97443,inst_97490,state_val_97504,c__8429__auto__,event_chan){
return (function (state_97488){
var state_val_97489 = (state_97488[(1)]);
if((state_val_97489 === (1))){
var inst_97479 = cljs.core.async.timeout((20));
var state_97488__$1 = state_97488;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_97488__$1,(2),inst_97479);
} else {
if((state_val_97489 === (2))){
var inst_97481 = (state_97488[(2)]);
var inst_97482 = grid.resizeCanvas();
var inst_97483 = grid.invalidateAllRows();
var inst_97484 = hatti.views.table.resizeColumns(grid);
var inst_97485 = grid.render();
var inst_97486 = hatti.views.table.init_sg_pager(grid,dataview);
var state_97488__$1 = (function (){var statearr_97517 = state_97488;
(statearr_97517[(7)] = inst_97481);

(statearr_97517[(8)] = inst_97484);

(statearr_97517[(9)] = inst_97482);

(statearr_97517[(10)] = inst_97483);

(statearr_97517[(11)] = inst_97485);

return statearr_97517;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_97488__$1,inst_97486);
} else {
return null;
}
}
});})(map__97410,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,c__8429__auto____$1,filter_by,inst_97434,inst_97412,inst_97433,inst_97442,inst_97435,inst_97437,inst_97432,inst_97438,inst_97436,inst_97443,inst_97490,state_val_97504,c__8429__auto__,event_chan))
;
return ((function (switch__8364__auto__,map__97410,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,c__8429__auto____$1,filter_by,inst_97434,inst_97412,inst_97433,inst_97442,inst_97435,inst_97437,inst_97432,inst_97438,inst_97436,inst_97443,inst_97490,state_val_97504,c__8429__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__8365__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__8365__auto____0 = (function (){
var statearr_97521 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_97521[(0)] = hatti$views$table$handle_table_events_$_state_machine__8365__auto__);

(statearr_97521[(1)] = (1));

return statearr_97521;
});
var hatti$views$table$handle_table_events_$_state_machine__8365__auto____1 = (function (state_97488){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_97488);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e97522){if((e97522 instanceof Object)){
var ex__8368__auto__ = e97522;
var statearr_97523_97583 = state_97488;
(statearr_97523_97583[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_97488);

return cljs.core.cst$kw$recur;
} else {
throw e97522;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__97584 = state_97488;
state_97488 = G__97584;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__8365__auto__ = function(state_97488){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__8365__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__8365__auto____1.call(this,state_97488);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__8365__auto____0;
hatti$views$table$handle_table_events_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__8365__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,map__97410,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,c__8429__auto____$1,filter_by,inst_97434,inst_97412,inst_97433,inst_97442,inst_97435,inst_97437,inst_97432,inst_97438,inst_97436,inst_97443,inst_97490,state_val_97504,c__8429__auto__,event_chan))
})();
var state__8431__auto__ = (function (){var statearr_97524 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_97524[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto____$1);

return statearr_97524;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});
;})(map__97410,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,c__8429__auto____$1,filter_by,inst_97434,inst_97412,inst_97433,inst_97442,inst_97435,inst_97437,inst_97432,inst_97438,inst_97436,inst_97443,inst_97490,state_val_97504,c__8429__auto__,event_chan))
})();
var inst_97492 = cljs.core.async.impl.dispatch.run(inst_97491);
var state_97503__$1 = (function (){var statearr_97525 = state_97503;
(statearr_97525[(18)] = inst_97492);

return statearr_97525;
})();
var statearr_97526_97585 = state_97503__$1;
(statearr_97526_97585[(2)] = inst_97490);

(statearr_97526_97585[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (33))){
var state_97503__$1 = state_97503;
var statearr_97527_97586 = state_97503__$1;
(statearr_97527_97586[(2)] = null);

(statearr_97527_97586[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (13))){
var inst_97424 = (state_97503[(2)]);
var state_97503__$1 = state_97503;
var statearr_97528_97587 = state_97503__$1;
(statearr_97528_97587[(2)] = inst_97424);

(statearr_97528_97587[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (22))){
var inst_97435 = (state_97503[(13)]);
var inst_97454 = (state_97503[(2)]);
var state_97503__$1 = (function (){var statearr_97529 = state_97503;
(statearr_97529[(19)] = inst_97454);

return statearr_97529;
})();
if(cljs.core.truth_(inst_97435)){
var statearr_97530_97588 = state_97503__$1;
(statearr_97530_97588[(1)] = (23));

} else {
var statearr_97531_97589 = state_97503__$1;
(statearr_97531_97589[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (29))){
var inst_97436 = (state_97503[(16)]);
var inst_97468 = [cljs.core.cst$kw$query];
var inst_97469 = [inst_97436];
var inst_97470 = cljs.core.PersistentHashMap.fromArrays(inst_97468,inst_97469);
var inst_97471 = cljs.core.clj__GT_js(inst_97470);
var inst_97472 = dataview.setFilterArgs(inst_97471);
var inst_97473 = dataview.refresh();
var state_97503__$1 = (function (){var statearr_97532 = state_97503;
(statearr_97532[(20)] = inst_97472);

return statearr_97532;
})();
var statearr_97533_97590 = state_97503__$1;
(statearr_97533_97590[(2)] = inst_97473);

(statearr_97533_97590[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (6))){
var inst_97499 = (state_97503[(2)]);
var state_97503__$1 = state_97503;
var statearr_97534_97591 = state_97503__$1;
(statearr_97534_97591[(2)] = inst_97499);

(statearr_97534_97591[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (28))){
var inst_97436 = (state_97503[(16)]);
var inst_97466 = (state_97503[(2)]);
var state_97503__$1 = (function (){var statearr_97535 = state_97503;
(statearr_97535[(21)] = inst_97466);

return statearr_97535;
})();
if(cljs.core.truth_(inst_97436)){
var statearr_97536_97592 = state_97503__$1;
(statearr_97536_97592[(1)] = (29));

} else {
var statearr_97537_97593 = state_97503__$1;
(statearr_97537_97593[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (25))){
var inst_97437 = (state_97503[(14)]);
var inst_97459 = (state_97503[(2)]);
var state_97503__$1 = (function (){var statearr_97538 = state_97503;
(statearr_97538[(22)] = inst_97459);

return statearr_97538;
})();
if(cljs.core.truth_(inst_97437)){
var statearr_97539_97594 = state_97503__$1;
(statearr_97539_97594[(1)] = (26));

} else {
var statearr_97540_97595 = state_97503__$1;
(statearr_97540_97595[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (34))){
var inst_97495 = (state_97503[(2)]);
var state_97503__$1 = (function (){var statearr_97541 = state_97503;
(statearr_97541[(23)] = inst_97495);

return statearr_97541;
})();
var statearr_97542_97596 = state_97503__$1;
(statearr_97542_97596[(2)] = null);

(statearr_97542_97596[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (17))){
var inst_97433 = (state_97503[(12)]);
var inst_97442 = (state_97503[(9)]);
var inst_97443 = (state_97503[(17)]);
var inst_97445 = (inst_97443.cljs$core$IFn$_invoke$arity$2 ? inst_97443.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_97433) : inst_97443.call(null,hatti.constants._rank,inst_97433));
var inst_97446 = (inst_97442.cljs$core$IFn$_invoke$arity$1 ? inst_97442.cljs$core$IFn$_invoke$arity$1(inst_97445) : inst_97442.call(null,inst_97445));
var state_97503__$1 = state_97503;
var statearr_97543_97597 = state_97503__$1;
(statearr_97543_97597[(2)] = inst_97446);

(statearr_97543_97597[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (3))){
var inst_97501 = (state_97503[(2)]);
var state_97503__$1 = state_97503;
return cljs.core.async.impl.ioc_helpers.return_chan(state_97503__$1,inst_97501);
} else {
if((state_val_97504 === (12))){
var state_97503__$1 = state_97503;
var statearr_97544_97598 = state_97503__$1;
(statearr_97544_97598[(2)] = false);

(statearr_97544_97598[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (2))){
var state_97503__$1 = state_97503;
var statearr_97545_97599 = state_97503__$1;
(statearr_97545_97599[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (23))){
var inst_97442 = (state_97503[(9)]);
var inst_97456 = (inst_97442.cljs$core$IFn$_invoke$arity$1 ? inst_97442.cljs$core$IFn$_invoke$arity$1(null) : inst_97442.call(null,null));
var state_97503__$1 = state_97503;
var statearr_97547_97600 = state_97503__$1;
(statearr_97547_97600[(2)] = inst_97456);

(statearr_97547_97600[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (19))){
var inst_97434 = (state_97503[(8)]);
var inst_97449 = (state_97503[(2)]);
var state_97503__$1 = (function (){var statearr_97548 = state_97503;
(statearr_97548[(24)] = inst_97449);

return statearr_97548;
})();
if(cljs.core.truth_(inst_97434)){
var statearr_97549_97601 = state_97503__$1;
(statearr_97549_97601[(1)] = (20));

} else {
var statearr_97550_97602 = state_97503__$1;
(statearr_97550_97602[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (11))){
var state_97503__$1 = state_97503;
var statearr_97551_97603 = state_97503__$1;
(statearr_97551_97603[(2)] = true);

(statearr_97551_97603[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (9))){
var state_97503__$1 = state_97503;
var statearr_97552_97604 = state_97503__$1;
(statearr_97552_97604[(2)] = false);

(statearr_97552_97604[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (5))){
var state_97503__$1 = state_97503;
var statearr_97553_97605 = state_97503__$1;
(statearr_97553_97605[(2)] = null);

(statearr_97553_97605[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (14))){
var inst_97412 = (state_97503[(7)]);
var inst_97429 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_97412);
var state_97503__$1 = state_97503;
var statearr_97554_97606 = state_97503__$1;
(statearr_97554_97606[(2)] = inst_97429);

(statearr_97554_97606[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (26))){
var inst_97437 = (state_97503[(14)]);
var inst_97461 = grid.setColumns(inst_97437);
var inst_97462 = hatti.views.table.resizeColumns(grid);
var inst_97463 = grid.render();
var state_97503__$1 = (function (){var statearr_97555 = state_97503;
(statearr_97555[(25)] = inst_97461);

(statearr_97555[(26)] = inst_97462);

return statearr_97555;
})();
var statearr_97556_97607 = state_97503__$1;
(statearr_97556_97607[(2)] = inst_97463);

(statearr_97556_97607[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (16))){
var inst_97434 = (state_97503[(8)]);
var inst_97412 = (state_97503[(7)]);
var inst_97433 = (state_97503[(12)]);
var inst_97442 = (state_97503[(9)]);
var inst_97435 = (state_97503[(13)]);
var inst_97437 = (state_97503[(14)]);
var inst_97432 = (state_97503[(15)]);
var inst_97438 = (state_97503[(10)]);
var inst_97436 = (state_97503[(16)]);
var inst_97432__$1 = (state_97503[(2)]);
var inst_97433__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_97432__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_97434__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_97432__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_97435__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_97432__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_97436__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_97432__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_97437__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_97432__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_97438__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_97432__$1,cljs.core.cst$kw$re_DASH_render);
var inst_97439 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_97440 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_97441 = (new cljs.core.PersistentVector(null,3,(5),inst_97439,inst_97440,null));
var inst_97442__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_97441);
var inst_97443 = (function (){var e = inst_97412;
var map__97410 = inst_97432__$1;
var submission_to_rank = inst_97433__$1;
var submission_clicked = inst_97434__$1;
var submission_unclicked = inst_97435__$1;
var filter_by = inst_97436__$1;
var new_columns = inst_97437__$1;
var re_render = inst_97438__$1;
var update_data_BANG_ = inst_97442__$1;
return ((function (e,map__97410,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_97434,inst_97412,inst_97433,inst_97442,inst_97435,inst_97437,inst_97432,inst_97438,inst_97436,inst_97432__$1,inst_97433__$1,inst_97434__$1,inst_97435__$1,inst_97436__$1,inst_97437__$1,inst_97438__$1,inst_97439,inst_97440,inst_97441,inst_97442__$1,state_val_97504,c__8429__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (e,map__97410,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_97434,inst_97412,inst_97433,inst_97442,inst_97435,inst_97437,inst_97432,inst_97438,inst_97436,inst_97432__$1,inst_97433__$1,inst_97434__$1,inst_97435__$1,inst_97436__$1,inst_97437__$1,inst_97438__$1,inst_97439,inst_97440,inst_97441,inst_97442__$1,state_val_97504,c__8429__auto__,event_chan){
return (function (p1__97242_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__97242_SHARP_,field));
});})(e,map__97410,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_97434,inst_97412,inst_97433,inst_97442,inst_97435,inst_97437,inst_97432,inst_97438,inst_97436,inst_97432__$1,inst_97433__$1,inst_97434__$1,inst_97435__$1,inst_97436__$1,inst_97437__$1,inst_97438__$1,inst_97439,inst_97440,inst_97441,inst_97442__$1,state_val_97504,c__8429__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(e,map__97410,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_97434,inst_97412,inst_97433,inst_97442,inst_97435,inst_97437,inst_97432,inst_97438,inst_97436,inst_97432__$1,inst_97433__$1,inst_97434__$1,inst_97435__$1,inst_97436__$1,inst_97437__$1,inst_97438__$1,inst_97439,inst_97440,inst_97441,inst_97442__$1,state_val_97504,c__8429__auto__,event_chan))
})();
var state_97503__$1 = (function (){var statearr_97557 = state_97503;
(statearr_97557[(8)] = inst_97434__$1);

(statearr_97557[(12)] = inst_97433__$1);

(statearr_97557[(9)] = inst_97442__$1);

(statearr_97557[(13)] = inst_97435__$1);

(statearr_97557[(14)] = inst_97437__$1);

(statearr_97557[(15)] = inst_97432__$1);

(statearr_97557[(10)] = inst_97438__$1);

(statearr_97557[(16)] = inst_97436__$1);

(statearr_97557[(17)] = inst_97443);

return statearr_97557;
})();
if(cljs.core.truth_(inst_97433__$1)){
var statearr_97558_97608 = state_97503__$1;
(statearr_97558_97608[(1)] = (17));

} else {
var statearr_97559_97609 = state_97503__$1;
(statearr_97559_97609[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (30))){
var state_97503__$1 = state_97503;
var statearr_97560_97610 = state_97503__$1;
(statearr_97560_97610[(2)] = null);

(statearr_97560_97610[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (10))){
var inst_97427 = (state_97503[(2)]);
var state_97503__$1 = state_97503;
if(cljs.core.truth_(inst_97427)){
var statearr_97561_97611 = state_97503__$1;
(statearr_97561_97611[(1)] = (14));

} else {
var statearr_97562_97612 = state_97503__$1;
(statearr_97562_97612[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (18))){
var state_97503__$1 = state_97503;
var statearr_97563_97613 = state_97503__$1;
(statearr_97563_97613[(2)] = null);

(statearr_97563_97613[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97504 === (8))){
var inst_97412 = (state_97503[(7)]);
var inst_97417 = inst_97412.cljs$lang$protocol_mask$partition0$;
var inst_97418 = (inst_97417 & (64));
var inst_97419 = inst_97412.cljs$core$ISeq$;
var inst_97420 = (inst_97418) || (inst_97419);
var state_97503__$1 = state_97503;
if(cljs.core.truth_(inst_97420)){
var statearr_97564_97614 = state_97503__$1;
(statearr_97564_97614[(1)] = (11));

} else {
var statearr_97565_97615 = state_97503__$1;
(statearr_97565_97615[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto__,event_chan))
;
return ((function (switch__8364__auto__,c__8429__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__8365__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__8365__auto____0 = (function (){
var statearr_97569 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_97569[(0)] = hatti$views$table$handle_table_events_$_state_machine__8365__auto__);

(statearr_97569[(1)] = (1));

return statearr_97569;
});
var hatti$views$table$handle_table_events_$_state_machine__8365__auto____1 = (function (state_97503){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_97503);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e97570){if((e97570 instanceof Object)){
var ex__8368__auto__ = e97570;
var statearr_97571_97616 = state_97503;
(statearr_97571_97616[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_97503);

return cljs.core.cst$kw$recur;
} else {
throw e97570;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__97617 = state_97503;
state_97503 = G__97617;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__8365__auto__ = function(state_97503){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__8365__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__8365__auto____1.call(this,state_97503);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__8365__auto____0;
hatti$views$table$handle_table_events_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__8365__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto__,event_chan))
})();
var state__8431__auto__ = (function (){var statearr_97572 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_97572[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto__);

return statearr_97572;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto__,event_chan))
);

return c__8429__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$name_DASH_or_DASH_label,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__5341__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__97628(s__97629){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__97629__$1 = s__97629;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__97629__$1);
if(temp__4425__auto__){
var s__97629__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__97629__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__97629__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__97631 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__97630 = (0);
while(true){
if((i__97630 < size__5340__auto__)){
var vec__97636 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__97630);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__97636,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__97636,(1),null);
cljs.core.chunk_append(b__97631,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__97630,vec__97636,k,v,c__5339__auto__,size__5340__auto__,b__97631,s__97629__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__97630,vec__97636,k,v,c__5339__auto__,size__5340__auto__,b__97631,s__97629__$2,temp__4425__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__97638 = (i__97630 + (1));
i__97630 = G__97638;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__97631),hatti$views$table$render_options_$_iter__97628(cljs.core.chunk_rest(s__97629__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__97631),null);
}
} else {
var vec__97637 = cljs.core.first(s__97629__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__97637,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__97637,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__97637,k,v,s__97629__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__97637,k,v,s__97629__$2,temp__4425__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__97628(cljs.core.rest(s__97629__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__5341__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table97640 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table97640 = (function (_,owner,meta97641){
this._ = _;
this.owner = owner;
this.meta97641 = meta97641;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table97640.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97642,meta97641__$1){
var self__ = this;
var _97642__$1 = this;
return (new hatti.views.table.t_hatti$views$table97640(self__._,self__.owner,meta97641__$1));
});

hatti.views.table.t_hatti$views$table97640.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97642){
var self__ = this;
var _97642__$1 = this;
return self__.meta97641;
});

hatti.views.table.t_hatti$views$table97640.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table97640.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name_DASH_or_DASH_label,cljs.core.cst$kw$label], null);
});

hatti.views.table.t_hatti$views$table97640.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table97640.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__97643){
var self__ = this;
var map__97644 = p__97643;
var map__97644__$1 = ((((!((map__97644 == null)))?((((map__97644.cljs$lang$protocol_mask$partition0$ & (64))) || (map__97644.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__97644):map__97644);
var name_or_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__97644__$1,cljs.core.cst$kw$name_DASH_or_DASH_label);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__97644__$1,cljs.core.cst$kw$language);
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__97646 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__97646__$1 = ((((!((map__97646 == null)))?((((map__97646.cljs$lang$protocol_mask$partition0$ & (64))) || (map__97646.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__97646):map__97646);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__97646__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var colset_BANG_ = ((function (options,map__97646,map__97646__$1,flat_form,new_language,___$2,map__97644,map__97644__$1,name_or_label,language){
return (function (p1__97639_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns(flat_form,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__97639_SHARP_),new_language)], null));
});})(options,map__97646,map__97646__$1,flat_form,new_language,___$2,map__97644,map__97644__$1,name_or_label,language))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(name_or_label);
} else {
}

var G__97655 = {"className": "label-changer"};
var G__97656 = (function (){var G__97658 = {"className": "label-changer-label"};
var G__97659 = "Show:";
return React.DOM.span(G__97658,G__97659);
})();
var G__97657 = (function (){var G__97660 = {"id": "header-display-dropdown", "className": "drop-hover"};
var G__97661 = (function (){var attrs97650 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(name_or_label) : options.call(null,name_or_label));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs97650))?sablono.interpreter.attributes(attrs97650):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs97650))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__97663 = {"className": "fa fa-angle-down"};
return React.DOM.i(G__97663);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs97650),(function (){var G__97664 = {"className": "fa fa-angle-down"};
return React.DOM.i(G__97664);
})()], null))));
})();
var G__97662 = (function (){var G__97665 = {"className": "submenu no-dot"};
var G__97666 = sablono.interpreter.interpret(hatti.views.table.render_options(options,self__.owner,colset_BANG_));
return React.DOM.ul(G__97665,G__97666);
})();
return React.DOM.div(G__97660,G__97661,G__97662);
})();
return React.DOM.div(G__97655,G__97656,G__97657);
});

hatti.views.table.t_hatti$views$table97640.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta97641], null);
});

hatti.views.table.t_hatti$views$table97640.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table97640.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table97640";

hatti.views.table.t_hatti$views$table97640.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table97640");
});

hatti.views.table.__GT_t_hatti$views$table97640 = (function hatti$views$table$__GT_t_hatti$views$table97640(___$1,owner__$1,meta97641){
return (new hatti.views.table.t_hatti$views$table97640(___$1,owner__$1,meta97641));
});

}

return (new hatti.views.table.t_hatti$views$table97640(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__8429__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto__,query){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto__,query){
return (function (state_97709){
var state_val_97710 = (state_97709[(1)]);
if((state_val_97710 === (1))){
var inst_97695 = cljs.core.async.timeout((150));
var state_97709__$1 = state_97709;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_97709__$1,(2),inst_97695);
} else {
if((state_val_97710 === (2))){
var inst_97697 = (state_97709[(2)]);
var inst_97698 = input.value;
var inst_97699 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_97698);
var state_97709__$1 = (function (){var statearr_97711 = state_97709;
(statearr_97711[(7)] = inst_97697);

return statearr_97711;
})();
if(inst_97699){
var statearr_97712_97723 = state_97709__$1;
(statearr_97712_97723[(1)] = (3));

} else {
var statearr_97713_97724 = state_97709__$1;
(statearr_97713_97724[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_97710 === (3))){
var inst_97701 = [query_event_key];
var inst_97702 = [query];
var inst_97703 = cljs.core.PersistentHashMap.fromArrays(inst_97701,inst_97702);
var inst_97704 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_97703);
var state_97709__$1 = state_97709;
var statearr_97714_97725 = state_97709__$1;
(statearr_97714_97725[(2)] = inst_97704);

(statearr_97714_97725[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97710 === (4))){
var state_97709__$1 = state_97709;
var statearr_97715_97726 = state_97709__$1;
(statearr_97715_97726[(2)] = null);

(statearr_97715_97726[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_97710 === (5))){
var inst_97707 = (state_97709[(2)]);
var state_97709__$1 = state_97709;
return cljs.core.async.impl.ioc_helpers.return_chan(state_97709__$1,inst_97707);
} else {
return null;
}
}
}
}
}
});})(c__8429__auto__,query))
;
return ((function (switch__8364__auto__,c__8429__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__8365__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__8365__auto____0 = (function (){
var statearr_97719 = [null,null,null,null,null,null,null,null];
(statearr_97719[(0)] = hatti$views$table$delayed_search_$_state_machine__8365__auto__);

(statearr_97719[(1)] = (1));

return statearr_97719;
});
var hatti$views$table$delayed_search_$_state_machine__8365__auto____1 = (function (state_97709){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_97709);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e97720){if((e97720 instanceof Object)){
var ex__8368__auto__ = e97720;
var statearr_97721_97727 = state_97709;
(statearr_97721_97727[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_97709);

return cljs.core.cst$kw$recur;
} else {
throw e97720;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__97728 = state_97709;
state_97709 = G__97728;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__8365__auto__ = function(state_97709){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__8365__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__8365__auto____1.call(this,state_97709);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__8365__auto____0;
hatti$views$table$delayed_search_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__8365__auto____1;
return hatti$views$table$delayed_search_$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto__,query))
})();
var state__8431__auto__ = (function (){var statearr_97722 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_97722[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto__);

return statearr_97722;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto__,query))
);

return c__8429__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table97730 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table97730 = (function (_,owner,meta97731){
this._ = _;
this.owner = owner;
this.meta97731 = meta97731;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table97730.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97732,meta97731__$1){
var self__ = this;
var _97732__$1 = this;
return (new hatti.views.table.t_hatti$views$table97730(self__._,self__.owner,meta97731__$1));
});

hatti.views.table.t_hatti$views$table97730.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97732){
var self__ = this;
var _97732__$1 = this;
return self__.meta97731;
});

hatti.views.table.t_hatti$views$table97730.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table97730.prototype.om$core$IRender$render$arity$1 = (function (this__6567__auto__){
var self__ = this;
var this__6567__auto____$1 = this;
var G__97735 = {"className": "table-search"};
var G__97736 = (function (){var G__97738 = {"className": "fa fa-search"};
return React.DOM.i(G__97738);
})();
var G__97737 = (function (){var G__97739 = {"type": "text", "placeholder": "Search", "onChange": ((function (G__97735,G__97736,this__6567__auto____$1){
return (function (p1__97729_SHARP_){
return hatti.views.table.delayed_search(p1__97729_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__97735,G__97736,this__6567__auto____$1))
};
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__97739) : sablono.interpreter.input.call(null,G__97739));
})();
return React.DOM.div(G__97735,G__97736,G__97737);
});

hatti.views.table.t_hatti$views$table97730.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta97731], null);
});

hatti.views.table.t_hatti$views$table97730.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table97730.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table97730";

hatti.views.table.t_hatti$views$table97730.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table97730");
});

hatti.views.table.__GT_t_hatti$views$table97730 = (function hatti$views$table$__GT_t_hatti$views$table97730(___$1,owner__$1,meta97731){
return (new hatti.views.table.t_hatti$views$table97730(___$1,owner__$1,meta97731));
});

}

return (new hatti.views.table.t_hatti$views$table97730(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner){
if(typeof hatti.views.table.t_hatti$views$table97740 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table97740 = (function (app_state,owner,meta97741){
this.app_state = app_state;
this.owner = owner;
this.meta97741 = meta97741;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table97740.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97742,meta97741__$1){
var self__ = this;
var _97742__$1 = this;
return (new hatti.views.table.t_hatti$views$table97740(self__.app_state,self__.owner,meta97741__$1));
});

hatti.views.table.t_hatti$views$table97740.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97742){
var self__ = this;
var _97742__$1 = this;
return self__.meta97741;
});

hatti.views.table.t_hatti$views$table97740.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table97740.prototype.om$core$IRender$render$arity$1 = (function (this__6567__auto__){
var self__ = this;
var this__6567__auto____$1 = this;
var G__97745 = {"className": "topbar"};
var G__97746 = (function (){var G__97750 = {"id": hatti.views.table.pager_id};
return React.DOM.div(G__97750);
})();
var G__97747 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,null));
var G__97748 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.app_state));
var G__97749 = (function (){var G__97751 = {"style": {"clear": "both"}};
return React.DOM.div(G__97751);
})();
return React.DOM.div(G__97745,G__97746,G__97747,G__97748,G__97749);
});

hatti.views.table.t_hatti$views$table97740.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta97741], null);
});

hatti.views.table.t_hatti$views$table97740.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table97740.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table97740";

hatti.views.table.t_hatti$views$table97740.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table97740");
});

hatti.views.table.__GT_t_hatti$views$table97740 = (function hatti$views$table$__GT_t_hatti$views$table97740(app_state__$1,owner__$1,meta97741){
return (new hatti.views.table.t_hatti$views$table97740(app_state__$1,owner__$1,meta97741));
});

}

return (new hatti.views.table.t_hatti$views$table97740(app_state,owner,null));
}));
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){

if(cljs.core.seq(data)){
var map__97755 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__97755__$1 = ((((!((map__97755 == null)))?((((map__97755.cljs$lang$protocol_mask$partition0$ & (64))) || (map__97755.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__97755):map__97755);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__97755__$1,cljs.core.cst$kw$flat_DASH_form);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__97755__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__97756 = hatti.views.table.sg_init(data,flat_form,current_language,is_filtered_dataview_QMARK_,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__97756,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__97756,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner,p__97759){
var map__97760 = p__97759;
var map__97760__$1 = ((((!((map__97760 == null)))?((((map__97760.cljs$lang$protocol_mask$partition0$ & (64))) || (map__97760.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__97760):map__97760);
var opts = map__97760__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__97760__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

if(typeof hatti.views.table.t_hatti$views$table97762 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table97762 = (function (app_state,owner,p__97759,map__97760,opts,slick_grid_event_handlers,meta97763){
this.app_state = app_state;
this.owner = owner;
this.p__97759 = p__97759;
this.map__97760 = map__97760;
this.opts = opts;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.meta97763 = meta97763;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table97762.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__97760,map__97760__$1,opts,slick_grid_event_handlers){
return (function (_97764,meta97763__$1){
var self__ = this;
var _97764__$1 = this;
return (new hatti.views.table.t_hatti$views$table97762(self__.app_state,self__.owner,self__.p__97759,self__.map__97760,self__.opts,self__.slick_grid_event_handlers,meta97763__$1));
});})(map__97760,map__97760__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table97762.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__97760,map__97760__$1,opts,slick_grid_event_handlers){
return (function (_97764){
var self__ = this;
var _97764__$1 = this;
return self__.meta97763;
});})(map__97760,map__97760__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table97762.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table97762.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__97760,map__97760__$1,opts,slick_grid_event_handlers){
return (function (_,___$1){
var self__ = this;
var ___$2 = this;
var no_data_QMARK_ = cljs.core.empty_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null)));
var map__97765 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state);
var map__97765__$1 = ((((!((map__97765 == null)))?((((map__97765.cljs$lang$protocol_mask$partition0$ & (64))) || (map__97765.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__97765):map__97765);
var dataset_info = map__97765__$1;
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__97765__$1,cljs.core.cst$kw$num_of_submissions);
var with_info = ((function (no_data_QMARK_,map__97765,map__97765__$1,dataset_info,num_of_submissions,___$2,map__97760,map__97760__$1,opts,slick_grid_event_handlers){
return (function (p1__97758_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__97758_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$dataset_DASH_info,dataset_info], null)], 0));
});})(no_data_QMARK_,map__97765,map__97765__$1,dataset_info,num_of_submissions,___$2,map__97760,map__97760__$1,opts,slick_grid_event_handlers))
;
var attrs97767 = om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked], null))),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs97767))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["table-view"], null)], null),attrs97767], 0))):{"className": "table-view"}),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs97767))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.app_state)),(function (){var G__97768 = {"id": hatti.views.table.table_id, "className": "slickgrid"};
var G__97769 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__97774 = {"className": "empty-state"};
var G__97775 = "No data";
return React.DOM.span(G__97774,G__97775);
})():(function (){var G__97777 = null;
var G__97778 = (function (){var G__97780 = {"className": "fa fa-spinner fa-pulse"};
return React.DOM.i(G__97780);
})();
var G__97779 = "Loading...";
return React.DOM.span(G__97777,G__97778,G__97779);
})());
return React.DOM.div(G__97768,G__97769);
})()], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs97767),sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.app_state)),(function (){var G__97781 = {"id": hatti.views.table.table_id, "className": "slickgrid"};
var G__97782 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__97787 = {"className": "empty-state"};
var G__97788 = "No data";
return React.DOM.span(G__97787,G__97788);
})():(function (){var G__97790 = null;
var G__97791 = (function (){var G__97793 = {"className": "fa fa-spinner fa-pulse"};
return React.DOM.i(G__97793);
})();
var G__97792 = "Loading...";
return React.DOM.span(G__97790,G__97791,G__97792);
})());
return React.DOM.div(G__97781,G__97782);
})()], null))));
});})(map__97760,map__97760__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table97762.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table97762.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (map__97760,map__97760__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__97794 = temp__4425__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__97794,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__97794,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid,dataview);
} else {
return null;
}
});})(map__97760,map__97760__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table97762.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table97762.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (map__97760,map__97760__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__97795 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__97795__$1 = ((((!((map__97795 == null)))?((((map__97795.cljs$lang$protocol_mask$partition0$ & (64))) || (map__97795.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__97795):map__97795);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__97795__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__97795__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__97797 = temp__4425__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__97797,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__97797,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js(new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
});})(map__97760,map__97760__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table97762.getBasis = ((function (map__97760,map__97760__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__97759,cljs.core.cst$sym$map__97760,cljs.core.cst$sym$opts,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$meta97763], null);
});})(map__97760,map__97760__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table97762.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table97762.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table97762";

hatti.views.table.t_hatti$views$table97762.cljs$lang$ctorPrWriter = ((function (map__97760,map__97760__$1,opts,slick_grid_event_handlers){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table97762");
});})(map__97760,map__97760__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table97762 = ((function (map__97760,map__97760__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table97762(app_state__$1,owner__$1,p__97759__$1,map__97760__$2,opts__$1,slick_grid_event_handlers__$1,meta97763){
return (new hatti.views.table.t_hatti$views$table97762(app_state__$1,owner__$1,p__97759__$1,map__97760__$2,opts__$1,slick_grid_event_handlers__$1,meta97763));
});})(map__97760,map__97760__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table97762(app_state,owner,p__97759,map__97760__$1,opts,slick_grid_event_handlers,cljs.core.PersistentArrayMap.EMPTY));
}));
