// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.shared');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('sablono.core');
goog.require('hatti.utils.om.state');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('om.core');
goog.require('hatti.utils');
hatti.shared.event_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
hatti.shared.event_multi_chan = cljs.core.async.mult(hatti.shared.event_chan);
hatti.shared.event_tap = (function hatti$shared$event_tap(){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_multi_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
});
hatti.shared.external_event_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
hatti.shared.external_event_multi_chan = cljs.core.async.mult(hatti.shared.external_event_chan);
hatti.shared.external_event_tap = (function hatti$shared$external_event_tap(){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2(hatti.shared.external_event_multi_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
});
hatti.shared.default_fields = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,"_submission_time",cljs.core.cst$kw$label,"Submission Time",cljs.core.cst$kw$name,"_submission_time",cljs.core.cst$kw$type,"datetime"], null)], null);
/**
 * An initial, empty, app-state, which can be modified to change dataviews.
 */
hatti.shared.empty_app_state = (function hatti$shared$empty_app_state(){
var G__94930 = new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$views,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$all,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$overview,cljs.core.cst$kw$map,cljs.core.cst$kw$table,cljs.core.cst$kw$chart,cljs.core.cst$kw$settings], null),cljs.core.cst$kw$selected,cljs.core.cst$kw$overview], null),cljs.core.cst$kw$map_DASH_page,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$submission_DASH_clicked,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,null], null),cljs.core.cst$kw$geofield,cljs.core.PersistentArrayMap.EMPTY], null),cljs.core.cst$kw$table_DASH_page,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_clicked,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,null], null)], null),cljs.core.cst$kw$chart_DASH_page,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$visible_DASH_charts,hatti.shared.default_fields,cljs.core.cst$kw$chart_DASH_data,cljs.core.PersistentArrayMap.EMPTY], null),cljs.core.cst$kw$dataset_DASH_info,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$data,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$status,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$total_DASH_records,(0),cljs.core.cst$kw$loading_QMARK_,true], null),cljs.core.cst$kw$languages,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$current,null,cljs.core.cst$kw$all,cljs.core.PersistentVector.EMPTY], null)], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__94930) : cljs.core.atom.call(null,G__94930));
});
hatti.shared.app_state = hatti.shared.empty_app_state();
/**
 * Given a function over data, run a transact on data inside app-state.
 */
hatti.shared.transact_app_data_BANG_ = (function hatti$shared$transact_app_data_BANG_(app_state,transact_fn){
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null),transact_fn);
});
/**
 * Given `data` received from the server, update the app-state.
 * Sorts by submission time, and adds rank to the data, for table + map views.
 */
hatti.shared.update_app_data_BANG_ = (function hatti$shared$update_app_data_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___94938 = arguments.length;
var i__5628__auto___94939 = (0);
while(true){
if((i__5628__auto___94939 < len__5627__auto___94938)){
args__5634__auto__.push((arguments[i__5628__auto___94939]));

var G__94940 = (i__5628__auto___94939 + (1));
i__5628__auto___94939 = G__94940;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,data,p__94935){
var map__94936 = p__94935;
var map__94936__$1 = ((((!((map__94936 == null)))?((((map__94936.cljs$lang$protocol_mask$partition0$ & (64))) || (map__94936.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__94936):map__94936);
var rerank_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__94936__$1,cljs.core.cst$kw$rerank_QMARK_);
var completed_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__94936__$1,cljs.core.cst$kw$completed_QMARK_);
var sort_field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__94936__$1,cljs.core.cst$kw$sort_DASH_field);
var current_start_index = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__94936__$1,cljs.core.cst$kw$current_DASH_start_DASH_index,(0));
var add_rank = ((function (map__94936,map__94936__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (i,v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,hatti.constants._rank,(current_start_index + (i + (1))));
});})(map__94936,map__94936__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
;
var data__$1 = (cljs.core.truth_((function (){var and__4557__auto__ = rerank_QMARK_;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.seq(data);
} else {
return and__4557__auto__;
}
})())?cljs.core.vec(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(add_rank,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(((function (add_rank,map__94936,map__94936__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (p1__94931_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__94931_SHARP_,(function (){var or__4569__auto__ = sort_field;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.constants._submission_time;
}
})());
});})(add_rank,map__94936,map__94936__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
,data))):cljs.core.vec(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(add_rank,data)));
var total_records = cljs.core.count(data__$1);
hatti.shared.transact_app_data_BANG_(app_state,((function (add_rank,data__$1,total_records,map__94936,map__94936__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (_){
return data__$1;
});})(add_rank,data__$1,total_records,map__94936,map__94936__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
);

return hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$status], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$total_DASH_records,total_records,cljs.core.cst$kw$loading_QMARK_,cljs.core.not(completed_QMARK_)], null));
});

hatti.shared.update_app_data_BANG_.cljs$lang$maxFixedArity = (2);

hatti.shared.update_app_data_BANG_.cljs$lang$applyTo = (function (seq94932){
var G__94933 = cljs.core.first(seq94932);
var seq94932__$1 = cljs.core.next(seq94932);
var G__94934 = cljs.core.first(seq94932__$1);
var seq94932__$2 = cljs.core.next(seq94932__$1);
return hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__94933,G__94934,seq94932__$2);
});
/**
 * Add to app data.
 */
hatti.shared.add_to_app_data_BANG_ = (function hatti$shared$add_to_app_data_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___94947 = arguments.length;
var i__5628__auto___94948 = (0);
while(true){
if((i__5628__auto___94948 < len__5627__auto___94947)){
args__5634__auto__.push((arguments[i__5628__auto___94948]));

var G__94949 = (i__5628__auto___94948 + (1));
i__5628__auto___94948 = G__94949;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,data,p__94944){
var map__94945 = p__94944;
var map__94945__$1 = ((((!((map__94945 == null)))?((((map__94945.cljs$lang$protocol_mask$partition0$ & (64))) || (map__94945.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__94945):map__94945);
var completed_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__94945__$1,cljs.core.cst$kw$completed_QMARK_);
var old_data = cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)));
hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(app_state,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(old_data,data),cljs.core.array_seq([cljs.core.cst$kw$rerank_QMARK_,completed_QMARK_], 0));

return hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$status,cljs.core.cst$kw$loading_QMARK_], null),cljs.core.not(completed_QMARK_));
});

hatti.shared.add_to_app_data_BANG_.cljs$lang$maxFixedArity = (2);

hatti.shared.add_to_app_data_BANG_.cljs$lang$applyTo = (function (seq94941){
var G__94942 = cljs.core.first(seq94941);
var seq94941__$1 = cljs.core.next(seq94941);
var G__94943 = cljs.core.first(seq94941__$1);
var seq94941__$2 = cljs.core.next(seq94941__$1);
return hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__94942,G__94943,seq94941__$2);
});
hatti.shared.language_cursor = (function hatti$shared$language_cursor(){
return om.core.ref_cursor(cljs.core.cst$kw$languages.cljs$core$IFn$_invoke$arity$1(om.core.root_cursor(hatti.shared.app_state)));
});
/**
 * A language selector and a following divider.
 */
hatti.shared.language_selector = (function hatti$shared$language_selector(_,owner){
if(typeof hatti.shared.t_hatti$shared95007 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.shared.t_hatti$shared95007 = (function (language_selector,_,owner,meta95008){
this.language_selector = language_selector;
this._ = _;
this.owner = owner;
this.meta95008 = meta95008;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.shared.t_hatti$shared95007.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_95009,meta95008__$1){
var self__ = this;
var _95009__$1 = this;
return (new hatti.shared.t_hatti$shared95007(self__.language_selector,self__._,self__.owner,meta95008__$1));
});

hatti.shared.t_hatti$shared95007.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_95009){
var self__ = this;
var _95009__$1 = this;
return self__.meta95008;
});

hatti.shared.t_hatti$shared95007.prototype.om$core$IRender$ = true;

hatti.shared.t_hatti$shared95007.prototype.om$core$IRender$render$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var map__95010 = om.core.observe(self__.owner,hatti.shared.language_cursor());
var map__95010__$1 = ((((!((map__95010 == null)))?((((map__95010.cljs$lang$protocol_mask$partition0$ & (64))) || (map__95010.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__95010):map__95010);
var ls = map__95010__$1;
var current = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__95010__$1,cljs.core.cst$kw$current);
var all = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__95010__$1,cljs.core.cst$kw$all);
var update_current = ((function (map__95010,map__95010__$1,ls,current,all,___$2){
return (function (p1__94950_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(ls,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$current], null),p1__94950_SHARP_);
});})(map__95010,map__95010__$1,ls,current,all,___$2))
;
var stringify = ((function (map__95010,map__95010__$1,ls,current,all,update_current,___$2){
return (function (p1__94951_SHARP_){
if((p1__94951_SHARP_ instanceof cljs.core.Keyword)){
return cljs.core.name(p1__94951_SHARP_);
} else {
return [cljs.core.str(p1__94951_SHARP_)].join('');
}
});})(map__95010,map__95010__$1,ls,current,all,update_current,___$2))
;
var G__95019 = {"className": "language-selector-inner"};
var G__95020 = (function (){var G__95022 = {"className": "dropdown drop-hover"};
var G__95023 = (function (){var G__95027 = {"style": {"marginRight": ".2em"}, "className": "fa fa-globe"};
return React.DOM.i(G__95027);
})();
var G__95024 = (function (){var attrs95014 = (cljs.core.truth_(hatti.ona.forms.english_QMARK_(current))?"EN":stringify(current));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs95014))?sablono.interpreter.attributes(attrs95014):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs95014))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs95014)], null))));
})();
var G__95025 = (function (){var G__95028 = {"style": {"marginLeft": ".5em"}, "className": "fa fa-angle-down"};
return React.DOM.i(G__95028);
})();
var G__95026 = (function (){var G__95029 = {"className": "submenu"};
var G__95030 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((function (){var iter__5341__auto__ = ((function (G__95029,G__95022,G__95023,G__95024,G__95025,G__95019,map__95010,map__95010__$1,ls,current,all,update_current,stringify,___$2){
return (function hatti$shared$language_selector_$_iter__95031(s__95032){
return (new cljs.core.LazySeq(null,((function (G__95029,G__95022,G__95023,G__95024,G__95025,G__95019,map__95010,map__95010__$1,ls,current,all,update_current,stringify,___$2){
return (function (){
var s__95032__$1 = s__95032;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__95032__$1);
if(temp__4425__auto__){
var s__95032__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__95032__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__95032__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__95034 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__95033 = (0);
while(true){
if((i__95033 < size__5340__auto__)){
var l = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__95033);
cljs.core.chunk_append(b__95034,(function (){var G__95051 = null;
var G__95052 = (function (){var G__95053 = {"href": "#", "onClick": ((function (i__95033,G__95051,l,c__5339__auto__,size__5340__auto__,b__95034,s__95032__$2,temp__4425__auto__,G__95029,G__95022,G__95023,G__95024,G__95025,G__95019,map__95010,map__95010__$1,ls,current,all,update_current,stringify,___$2){
return (function (){
return update_current(l);
});})(i__95033,G__95051,l,c__5339__auto__,size__5340__auto__,b__95034,s__95032__$2,temp__4425__auto__,G__95029,G__95022,G__95023,G__95024,G__95025,G__95019,map__95010,map__95010__$1,ls,current,all,update_current,stringify,___$2))
};
var G__95054 = sablono.interpreter.interpret(stringify(l));
return React.DOM.a(G__95053,G__95054);
})();
return React.DOM.li(G__95051,G__95052);
})());

var G__95062 = (i__95033 + (1));
i__95033 = G__95062;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__95034),hatti$shared$language_selector_$_iter__95031(cljs.core.chunk_rest(s__95032__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__95034),null);
}
} else {
var l = cljs.core.first(s__95032__$2);
return cljs.core.cons((function (){var G__95057 = null;
var G__95058 = (function (){var G__95059 = {"href": "#", "onClick": ((function (G__95057,l,s__95032__$2,temp__4425__auto__,G__95029,G__95022,G__95023,G__95024,G__95025,G__95019,map__95010,map__95010__$1,ls,current,all,update_current,stringify,___$2){
return (function (){
return update_current(l);
});})(G__95057,l,s__95032__$2,temp__4425__auto__,G__95029,G__95022,G__95023,G__95024,G__95025,G__95019,map__95010,map__95010__$1,ls,current,all,update_current,stringify,___$2))
};
var G__95060 = sablono.interpreter.interpret(stringify(l));
return React.DOM.a(G__95059,G__95060);
})();
return React.DOM.li(G__95057,G__95058);
})(),hatti$shared$language_selector_$_iter__95031(cljs.core.rest(s__95032__$2)));
}
} else {
return null;
}
break;
}
});})(G__95029,G__95022,G__95023,G__95024,G__95025,G__95019,map__95010,map__95010__$1,ls,current,all,update_current,stringify,___$2))
,null,null));
});})(G__95029,G__95022,G__95023,G__95024,G__95025,G__95019,map__95010,map__95010__$1,ls,current,all,update_current,stringify,___$2))
;
return iter__5341__auto__(all);
})());
return React.DOM.ul(G__95029,G__95030);
})();
return React.DOM.span(G__95022,G__95023,G__95024,G__95025,G__95026);
})();
var G__95021 = (function (){var G__95061 = {"className": "divider"};
return React.DOM.div(G__95061);
})();
return React.DOM.div(G__95019,G__95020,G__95021);
});

hatti.shared.t_hatti$shared95007.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$language_DASH_selector,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"A language selector and a following divider."], null)),cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta95008], null);
});

hatti.shared.t_hatti$shared95007.cljs$lang$type = true;

hatti.shared.t_hatti$shared95007.cljs$lang$ctorStr = "hatti.shared/t_hatti$shared95007";

hatti.shared.t_hatti$shared95007.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.shared/t_hatti$shared95007");
});

hatti.shared.__GT_t_hatti$shared95007 = (function hatti$shared$language_selector_$___GT_t_hatti$shared95007(language_selector__$1,___$1,owner__$1,meta95008){
return (new hatti.shared.t_hatti$shared95007(language_selector__$1,___$1,owner__$1,meta95008));
});

}

return (new hatti.shared.t_hatti$shared95007(hatti$shared$language_selector,_,owner,cljs.core.PersistentArrayMap.EMPTY));
});
