// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.utils');
goog.require('hatti.utils.om.state');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten((function (){var iter__5341__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__95246(s__95247){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__95247__$1 = s__95247;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__95247__$1);
if(temp__4425__auto__){
var s__95247__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__95247__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__95247__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__95249 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__95248 = (0);
while(true){
if((i__95248 < size__5340__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__95248);
cljs.core.chunk_append(b__95249,(function (){var iter__5341__auto__ = ((function (i__95248,datum,c__5339__auto__,size__5340__auto__,b__95249,s__95247__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__95246_$_iter__95264(s__95265){
return (new cljs.core.LazySeq(null,((function (i__95248,datum,c__5339__auto__,size__5340__auto__,b__95249,s__95247__$2,temp__4425__auto__,osmfields){
return (function (){
var s__95265__$1 = s__95265;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__95265__$1);
if(temp__4425__auto____$1){
var s__95265__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__95265__$2)){
var c__5339__auto____$1 = cljs.core.chunk_first(s__95265__$2);
var size__5340__auto____$1 = cljs.core.count(c__5339__auto____$1);
var b__95267 = cljs.core.chunk_buffer(size__5340__auto____$1);
if((function (){var i__95266 = (0);
while(true){
if((i__95266 < size__5340__auto____$1)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto____$1,i__95266);
cljs.core.chunk_append(b__95267,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__95276 = (i__95266 + (1));
i__95266 = G__95276;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__95267),hatti$ona$post_process$ona_osm_link_$_iter__95246_$_iter__95264(cljs.core.chunk_rest(s__95265__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__95267),null);
}
} else {
var field = cljs.core.first(s__95265__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__95246_$_iter__95264(cljs.core.rest(s__95265__$2)));
}
} else {
return null;
}
break;
}
});})(i__95248,datum,c__5339__auto__,size__5340__auto__,b__95249,s__95247__$2,temp__4425__auto__,osmfields))
,null,null));
});})(i__95248,datum,c__5339__auto__,size__5340__auto__,b__95249,s__95247__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__(osmfields);
})());

var G__95277 = (i__95248 + (1));
i__95248 = G__95277;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__95249),hatti$ona$post_process$ona_osm_link_$_iter__95246(cljs.core.chunk_rest(s__95247__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__95249),null);
}
} else {
var datum = cljs.core.first(s__95247__$2);
return cljs.core.cons((function (){var iter__5341__auto__ = ((function (datum,s__95247__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__95246_$_iter__95270(s__95271){
return (new cljs.core.LazySeq(null,((function (datum,s__95247__$2,temp__4425__auto__,osmfields){
return (function (){
var s__95271__$1 = s__95271;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__95271__$1);
if(temp__4425__auto____$1){
var s__95271__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__95271__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__95271__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__95273 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__95272 = (0);
while(true){
if((i__95272 < size__5340__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__95272);
cljs.core.chunk_append(b__95273,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__95278 = (i__95272 + (1));
i__95272 = G__95278;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__95273),hatti$ona$post_process$ona_osm_link_$_iter__95246_$_iter__95270(cljs.core.chunk_rest(s__95271__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__95273),null);
}
} else {
var field = cljs.core.first(s__95271__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__95246_$_iter__95270(cljs.core.rest(s__95271__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__95247__$2,temp__4425__auto__,osmfields))
,null,null));
});})(datum,s__95247__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__(osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__95246(cljs.core.rest(s__95247__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__5341__auto__(data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((function (){var G__95280 = jQuery.parseXML(osm_xml_string);
return osmtogeojson(G__95280);
})(),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link(data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson(osm_xml);
var featureset = (osmgeo.cljs$core$IFn$_invoke$arity$1 ? osmgeo.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$features) : osmgeo.call(null,cljs.core.cst$kw$features));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5341__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__95303(s__95304){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__95304__$1 = s__95304;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__95304__$1);
if(temp__4425__auto__){
var s__95304__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__95304__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__95304__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__95306 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__95305 = (0);
while(true){
if((i__95305 < size__5340__auto__)){
var map__95317 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__95305);
var map__95317__$1 = ((((!((map__95317 == null)))?((((map__95317.cljs$lang$protocol_mask$partition0$ & (64))) || (map__95317.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__95317):map__95317);
var feature = map__95317__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__95317__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__95317__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__95317__$1,cljs.core.cst$kw$geometry);
cljs.core.chunk_append(b__95306,(function (){var map__95319 = properties;
var map__95319__$1 = ((((!((map__95319 == null)))?((((map__95319.cljs$lang$protocol_mask$partition0$ & (64))) || (map__95319.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__95319):map__95319);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__95319__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__95319__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__95319__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})());

var G__95325 = (i__95305 + (1));
i__95305 = G__95325;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__95306),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__95303(cljs.core.chunk_rest(s__95304__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__95306),null);
}
} else {
var map__95321 = cljs.core.first(s__95304__$2);
var map__95321__$1 = ((((!((map__95321 == null)))?((((map__95321.cljs$lang$protocol_mask$partition0$ & (64))) || (map__95321.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__95321):map__95321);
var feature = map__95321__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__95321__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__95321__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__95321__$1,cljs.core.cst$kw$geometry);
return cljs.core.cons((function (){var map__95323 = properties;
var map__95323__$1 = ((((!((map__95323 == null)))?((((map__95323.cljs$lang$protocol_mask$partition0$ & (64))) || (map__95323.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__95323):map__95323);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__95323__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__95323__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__95323__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__95303(cljs.core.rest(s__95304__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__5341__auto__(featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq(osm_fields)){
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data(data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__95326_SHARP_){
return cljs.core.re_find(/[-]?[0-9]+/,p1__95326_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val){
if(typeof osm_val === 'string'){
var temp__4423__auto__ = (function (){var G__95338 = osm_val__GT_osm_id(osm_val);
return (osm_data.cljs$core$IFn$_invoke$arity$1 ? osm_data.cljs$core$IFn$_invoke$arity$1(G__95338) : osm_data.call(null,G__95338));
})();
if(cljs.core.truth_(temp__4423__auto__)){
var osm_submission_data = temp__4423__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__5341__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__95339(s__95340){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__95340__$1 = s__95340;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__95340__$1);
if(temp__4425__auto__){
var s__95340__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__95340__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__95340__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__95342 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__95341 = (0);
while(true){
if((i__95341 < size__5340__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__95341);
cljs.core.chunk_append(b__95342,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data));

var G__95349 = (i__95341 + (1));
i__95341 = G__95349;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__95342),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__95339(cljs.core.chunk_rest(s__95340__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__95342),null);
}
} else {
var datum = cljs.core.first(s__95340__$2);
return cljs.core.cons(cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__95339(cljs.core.rest(s__95340__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__5341__auto__(data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__95345 = cljs.core.seq(osm_fields);
var chunk__95346 = null;
var count__95347 = (0);
var i__95348 = (0);
while(true){
if((i__95348 < count__95347)){
var osm_field = chunk__95346.cljs$core$IIndexed$_nth$arity$2(null,i__95348);
hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__95350 = seq__95345;
var G__95351 = chunk__95346;
var G__95352 = count__95347;
var G__95353 = (i__95348 + (1));
seq__95345 = G__95350;
chunk__95346 = G__95351;
count__95347 = G__95352;
i__95348 = G__95353;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__95345);
if(temp__4425__auto__){
var seq__95345__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__95345__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__95345__$1);
var G__95354 = cljs.core.chunk_rest(seq__95345__$1);
var G__95355 = c__5372__auto__;
var G__95356 = cljs.core.count(c__5372__auto__);
var G__95357 = (0);
seq__95345 = G__95354;
chunk__95346 = G__95355;
count__95347 = G__95356;
i__95348 = G__95357;
continue;
} else {
var osm_field = cljs.core.first(seq__95345__$1);
hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__95358 = cljs.core.next(seq__95345__$1);
var G__95359 = null;
var G__95360 = (0);
var G__95361 = (0);
seq__95345 = G__95358;
chunk__95346 = G__95359;
count__95347 = G__95360;
i__95348 = G__95361;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"id");
var fname = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"filename");
var file_url = hatti.ona.urls.media_url(media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$filename,fname,cljs.core.cst$kw$download_url,file_url,cljs.core.cst$kw$small_download_url,[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__4569__auto__ = attachments;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,"_attachments");
}
})();
var fnames = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (attachments__$1){
return (function (p1__95362_SHARP_){
return hatti.utils.last_url_param(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__95362_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap(fnames,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(fname__GT_urlobj,fname,fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Inlines media data from within _attachments into each record.
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__5634__auto__ = [];
var len__5627__auto___95375 = arguments.length;
var i__5628__auto___95376 = (0);
while(true){
if((i__5628__auto___95376 < len__5627__auto___95375)){
args__5634__auto__.push((arguments[i__5628__auto___95376]));

var G__95377 = (i__5628__auto___95376 + (1));
i__5628__auto___95376 = G__95377;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__95366){
var map__95367 = p__95366;
var map__95367__$1 = ((((!((map__95367 == null)))?((((map__95367.cljs$lang$protocol_mask$partition0$ & (64))) || (map__95367.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__95367):map__95367);
var attachments = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__95367__$1,cljs.core.cst$kw$attachments);
var image_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.image_QMARK_,flat_form);
var iter__5341__auto__ = ((function (image_fields,map__95367,map__95367__$1,attachments){
return (function hatti$ona$post_process$iter__95369(s__95370){
return (new cljs.core.LazySeq(null,((function (image_fields,map__95367,map__95367__$1,attachments){
return (function (){
var s__95370__$1 = s__95370;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__95370__$1);
if(temp__4425__auto__){
var s__95370__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__95370__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__95370__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__95372 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__95371 = (0);
while(true){
if((i__95371 < size__5340__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__95371);
cljs.core.chunk_append(b__95372,(function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i__95371,attach_map,record,c__5339__auto__,size__5340__auto__,b__95372,s__95370__$2,temp__4425__auto__,image_fields,map__95367,map__95367__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__95371,attach_map,record,c__5339__auto__,size__5340__auto__,b__95372,s__95370__$2,temp__4425__auto__,image_fields,map__95367,map__95367__$1,attachments))
,record,image_fields);
})());

var G__95378 = (i__95371 + (1));
i__95371 = G__95378;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__95372),hatti$ona$post_process$iter__95369(cljs.core.chunk_rest(s__95370__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__95372),null);
}
} else {
var record = cljs.core.first(s__95370__$2);
return cljs.core.cons((function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (attach_map,record,s__95370__$2,temp__4425__auto__,image_fields,map__95367,map__95367__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__95370__$2,temp__4425__auto__,image_fields,map__95367,map__95367__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__95369(cljs.core.rest(s__95370__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__95367,map__95367__$1,attachments))
,null,null));
});})(image_fields,map__95367,map__95367__$1,attachments))
;
return iter__5341__auto__(data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq95363){
var G__95364 = cljs.core.first(seq95363);
var seq95363__$1 = cljs.core.next(seq95363);
var G__95365 = cljs.core.first(seq95363__$1);
var seq95363__$2 = cljs.core.next(seq95363__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__95364,G__95365,seq95363__$2);
});
/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(record,key,hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,key),cljs.core.array_seq([cljs.core.cst$kw$attachments,cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,"_attachments")], 0)));
});})(repeat_fields))
;
var iter__5341__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__95385(s__95386){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__95386__$1 = s__95386;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__95386__$1);
if(temp__4425__auto__){
var s__95386__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__95386__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__95386__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__95388 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__95387 = (0);
while(true){
if((i__95387 < size__5340__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__95387);
cljs.core.chunk_append(b__95388,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields));

var G__95391 = (i__95387 + (1));
i__95387 = G__95391;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__95388),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__95385(cljs.core.chunk_rest(s__95386__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__95388),null);
}
} else {
var record = cljs.core.first(s__95386__$2);
return cljs.core.cons(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__95385(cljs.core.rest(s__95386__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__5341__auto__(data);
});
/**
 * Inlines data from within _atatchments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___95399 = arguments.length;
var i__5628__auto___95400 = (0);
while(true){
if((i__5628__auto___95400 < len__5627__auto___95399)){
args__5634__auto__.push((arguments[i__5628__auto___95400]));

var G__95401 = (i__5628__auto___95400 + (1));
i__5628__auto___95400 = G__95401;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__95396){
var map__95397 = p__95396;
var map__95397__$1 = ((((!((map__95397 == null)))?((((map__95397.cljs$lang$protocol_mask$partition0$ & (64))) || (map__95397.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__95397):map__95397);
var app_data_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__95397__$1,cljs.core.cst$kw$app_DASH_data_DASH_keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_data_keys,((function (map__95397,map__95397__$1,app_data_keys){
return (function (p1__95392_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats(flat_form,hatti.ona.post_process.integrate_attachments(flat_form,p1__95392_SHARP_));
});})(map__95397,map__95397__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq95393){
var G__95394 = cljs.core.first(seq95393);
var seq95393__$1 = cljs.core.next(seq95393);
var G__95395 = cljs.core.first(seq95393__$1);
var seq95393__$2 = cljs.core.next(seq95393__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__95394,G__95395,seq95393__$2);
});
