// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.map.viewby');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('hatti.utils');
goog.require('hatti.charting');
goog.require('hatti.ona.forms');
goog.require('hatti.map.style');
goog.require('hatti.map.utils');
hatti.map.viewby.marker_styler = (function hatti$map$viewby$marker_styler(id_color,id_selected_QMARK_){
return (function (marker){
var id = hatti.map.utils.get_id(marker);
var geotype = hatti.map.utils.marker__GT_geotype(marker);
var color_key = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$line,geotype))?cljs.core.cst$kw$color:cljs.core.cst$kw$fillColor);
return cljs.core.PersistentArrayMap.fromArray([color_key,(cljs.core.truth_((id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(id) : id_selected_QMARK_.call(null,id)))?(id_color.cljs$core$IFn$_invoke$arity$1 ? id_color.cljs$core$IFn$_invoke$arity$1(id) : id_color.call(null,id)):hatti.map.style.grey)], true, false);
});
});
hatti.map.viewby.move_nil_to_end = (function hatti$map$viewby$move_nil_to_end(s){
var no_nil = cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,s));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(s,no_nil)){
return s;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(no_nil,null);
}
});
hatti.map.viewby.all_but_nil_selected = (function hatti$map$viewby$all_but_nil_selected(answers){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.zipmap(answers,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(true)),new cljs.core.PersistentArrayMap(null, 1, [null,false], null)], 0));
});
/**
 * Preproccesses answers depending on the field. For multi-selects, return type
 * is a list of list of strings. For other types, a list of strings.
 */
hatti.map.viewby.preprocess_answers = (function hatti$map$viewby$preprocess_answers(field,raw_answers){
if(cljs.core.truth_(hatti.ona.forms.select_one_QMARK_(field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.text_QMARK_(field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.calculate_QMARK_(field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
return hatti.charting.evenly_spaced_bins(raw_answers,(5),"int");
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return hatti.charting.evenly_spaced_bins(raw_answers,(5),"date");
} else {
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_(field))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__94641_SHARP_){
if(cljs.core.truth_(p1__94641_SHARP_)){
return clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__94641_SHARP_,/ /);
} else {
return null;
}
}),raw_answers);
} else {
return null;
}
}
}
}
}
}
});
/**
 * Produces a set of data structures / functions for view-by.
 * answers are a list of answers, sorted by count;
 * id->answers is a mapping from id to either one or many answers
 * answer->count, answer->selected?, answer->color are maps from answer;
 * used for the legend rendering. An 'answer' is mapped from a data element,
 * eg. a bin for numbers/dates, an option for multiple/single selects.
 */
hatti.map.viewby.viewby_info = (function hatti$map$viewby$viewby_info(field,raw_answers,ids){
var fname = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var preprocessed_answers = hatti.map.viewby.preprocess_answers(field,raw_answers);
var answer__GT_count = cljs.core.frequencies(cljs.core.flatten(preprocessed_answers));
var sorted_answers = (cljs.core.truth_((function (){var or__4569__auto__ = hatti.ona.forms.categorical_QMARK_(field);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var or__4569__auto____$1 = hatti.ona.forms.text_QMARK_(field);
if(cljs.core.truth_(or__4569__auto____$1)){
return or__4569__auto____$1;
} else {
return hatti.ona.forms.calculate_QMARK_(field);
}
}
})())?cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(cljs.core.second,cljs.core._GT_,answer__GT_count)):(cljs.core.truth_((function (){var or__4569__auto__ = hatti.ona.forms.time_based_QMARK_(field);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.ona.forms.numeric_QMARK_(field);
}
})())?cljs.core.cst$kw$bins.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(preprocessed_answers)):null));
var sorted_answers_with_nil_at_end = hatti.map.viewby.move_nil_to_end(sorted_answers);
var answer__GT_color_map = hatti.map.style.answer__GT_color(field,sorted_answers);
var defaults = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$answers,sorted_answers_with_nil_at_end,cljs.core.cst$kw$id_DASH__GT_answers,cljs.core.zipmap(ids,preprocessed_answers),cljs.core.cst$kw$answer_DASH__GT_count,answer__GT_count,cljs.core.cst$kw$answer_DASH__GT_selected_QMARK_,hatti.map.viewby.all_but_nil_selected(sorted_answers),cljs.core.cst$kw$answer_DASH__GT_color,answer__GT_color_map,cljs.core.cst$kw$visible_DASH_answers,sorted_answers_with_nil_at_end,cljs.core.cst$kw$field,field], null);
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_(field))){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([defaults,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id_DASH_color,((function (fname,preprocessed_answers,answer__GT_count,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults){
return (function (){
return cljs.core.first(cljs.core.vals(answer__GT_color_map));
});})(fname,preprocessed_answers,answer__GT_count,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults))
], null)], 0));
} else {
return defaults;

}
});
/**
 * Generates id-color and id-selected? functions based on viewby-info.
 */
hatti.map.viewby.id_color_selected = (function hatti$map$viewby$id_color_selected(p__94644){
var map__94650 = p__94644;
var map__94650__$1 = ((((!((map__94650 == null)))?((((map__94650.cljs$lang$protocol_mask$partition0$ & (64))) || (map__94650.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__94650):map__94650);
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__94650__$1,cljs.core.cst$kw$field);
var id__GT_answers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__94650__$1,cljs.core.cst$kw$id_DASH__GT_answers);
var answer__GT_color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__94650__$1,cljs.core.cst$kw$answer_DASH__GT_color);
var answer__GT_selected_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__94650__$1,cljs.core.cst$kw$answer_DASH__GT_selected_QMARK_);
var G__94652 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(field);
switch (G__94652) {
case "select all that apply":
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$id_DASH_color,((function (G__94652,map__94650,map__94650__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (){
return cljs.core.first(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#f30"], null));
});})(G__94652,map__94650,map__94650__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
,cljs.core.cst$kw$id_DASH_selected_QMARK_,((function (G__94652,map__94650,map__94650__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (id){
var answers = (id__GT_answers.cljs$core$IFn$_invoke$arity$1 ? id__GT_answers.cljs$core$IFn$_invoke$arity$1(id) : id__GT_answers.call(null,id));
if((answers == null)){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(answer__GT_selected_QMARK_,answers);
} else {
return cljs.core.some(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$2(answer__GT_selected_QMARK_,answers));
}
});})(G__94652,map__94650,map__94650__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
], null);

break;
default:
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$id_DASH_color,((function (G__94652,map__94650,map__94650__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (p1__94642_SHARP_){
var G__94653 = (id__GT_answers.cljs$core$IFn$_invoke$arity$1 ? id__GT_answers.cljs$core$IFn$_invoke$arity$1(p1__94642_SHARP_) : id__GT_answers.call(null,p1__94642_SHARP_));
return (answer__GT_color.cljs$core$IFn$_invoke$arity$1 ? answer__GT_color.cljs$core$IFn$_invoke$arity$1(G__94653) : answer__GT_color.call(null,G__94653));
});})(G__94652,map__94650,map__94650__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
,cljs.core.cst$kw$id_DASH_selected_QMARK_,((function (G__94652,map__94650,map__94650__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (p1__94643_SHARP_){
var G__94654 = (id__GT_answers.cljs$core$IFn$_invoke$arity$1 ? id__GT_answers.cljs$core$IFn$_invoke$arity$1(p1__94643_SHARP_) : id__GT_answers.call(null,p1__94643_SHARP_));
return (answer__GT_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? answer__GT_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(G__94654) : answer__GT_selected_QMARK_.call(null,G__94654));
});})(G__94652,map__94650,map__94650__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
], null);

}
});
hatti.map.viewby.view_by_BANG_ = (function hatti$map$viewby$view_by_BANG_(view_by_info,markers){
var map__94662 = hatti.map.viewby.id_color_selected(view_by_info);
var map__94662__$1 = ((((!((map__94662 == null)))?((((map__94662.cljs$lang$protocol_mask$partition0$ & (64))) || (map__94662.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__94662):map__94662);
var id_selected_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__94662__$1,cljs.core.cst$kw$id_DASH_selected_QMARK_);
var id_color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__94662__$1,cljs.core.cst$kw$id_DASH_color);
var m__GT_s = hatti.map.viewby.marker_styler(id_color,id_selected_QMARK_);
var seq__94664 = cljs.core.seq(markers);
var chunk__94665 = null;
var count__94666 = (0);
var i__94667 = (0);
while(true){
if((i__94667 < count__94666)){
var marker = chunk__94665.cljs$core$IIndexed$_nth$arity$2(null,i__94667);
hatti.map.utils.re_style_marker(m__GT_s,marker);

hatti.map.utils.bring_to_top_if_selected(id_selected_QMARK_,marker);

var G__94668 = seq__94664;
var G__94669 = chunk__94665;
var G__94670 = count__94666;
var G__94671 = (i__94667 + (1));
seq__94664 = G__94668;
chunk__94665 = G__94669;
count__94666 = G__94670;
i__94667 = G__94671;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__94664);
if(temp__4425__auto__){
var seq__94664__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__94664__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__94664__$1);
var G__94672 = cljs.core.chunk_rest(seq__94664__$1);
var G__94673 = c__5372__auto__;
var G__94674 = cljs.core.count(c__5372__auto__);
var G__94675 = (0);
seq__94664 = G__94672;
chunk__94665 = G__94673;
count__94666 = G__94674;
i__94667 = G__94675;
continue;
} else {
var marker = cljs.core.first(seq__94664__$1);
hatti.map.utils.re_style_marker(m__GT_s,marker);

hatti.map.utils.bring_to_top_if_selected(id_selected_QMARK_,marker);

var G__94676 = cljs.core.next(seq__94664__$1);
var G__94677 = null;
var G__94678 = (0);
var G__94679 = (0);
seq__94664 = G__94676;
chunk__94665 = G__94677;
count__94666 = G__94678;
i__94667 = G__94679;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Given a list of answers + query, returns map from answers to true/false.
 * True if query is in the answer, false if not.
 */
hatti.map.viewby.filter_answer_data_structures = (function hatti$map$viewby$filter_answer_data_structures(answers,query,field,language){
var query_present_QMARK_ = (function (ans){
if(cljs.core.truth_(ans)){
return cljs.core.re_find(hatti.utils.safe_regex(query),hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$3(field,ans,language));
} else {
return null;
}
});
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$visible_DASH_answers,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(query_present_QMARK_,answers),cljs.core.cst$kw$answer_DASH__GT_selected_QMARK_,cljs.core.zipmap(answers,cljs.core.map.cljs$core$IFn$_invoke$arity$2(query_present_QMARK_,answers))], null);
});
/**
 * This function appropriately toggles answer->selected? when answer is clicked
 * answer->selected? is a map from answers to true/false. Special rules:
 * First click = select the answer. If nothing clicked, make everything
 * clicked.
 */
hatti.map.viewby.toggle_answer_selected = (function hatti$map$viewby$toggle_answer_selected(answer__GT_selected_QMARK_,visible_answers,answer){
var all_answers = cljs.core.vals(answer__GT_selected_QMARK_);
var all_visible_selected_QMARK_ = ((function (all_answers){
return (function (a__GT_s,visible){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.set(visible),cljs.core.set(cljs.core.keys(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.second,a__GT_s))));
});})(all_answers))
;
if((answer == null)){
return answer__GT_selected_QMARK_;
} else {
if(cljs.core.truth_(all_visible_selected_QMARK_(answer__GT_selected_QMARK_,visible_answers))){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.zipmap(all_answers,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(false)),cljs.core.PersistentArrayMap.fromArray([answer,true], true, false)], 0));
} else {
var toggled = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(answer__GT_selected_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer], null),cljs.core.not);
if(cljs.core.every_QMARK_(cljs.core.false_QMARK_,cljs.core.vals(toggled))){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.zipmap(all_answers,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(false)),hatti.map.viewby.all_but_nil_selected(visible_answers)], 0));
} else {
return toggled;
}
}
}
});
