// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.utils');
goog.require('hatti.utils.om.state');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.call(null,hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten.call(null,(function (){var iter__5341__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__91915(s__91916){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__91916__$1 = s__91916;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__91916__$1);
if(temp__4425__auto__){
var s__91916__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__91916__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__91916__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__91918 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__91917 = (0);
while(true){
if((i__91917 < size__5340__auto__)){
var datum = cljs.core._nth.call(null,c__5339__auto__,i__91917);
cljs.core.chunk_append.call(null,b__91918,(function (){var iter__5341__auto__ = ((function (i__91917,datum,c__5339__auto__,size__5340__auto__,b__91918,s__91916__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__91915_$_iter__91927(s__91928){
return (new cljs.core.LazySeq(null,((function (i__91917,datum,c__5339__auto__,size__5340__auto__,b__91918,s__91916__$2,temp__4425__auto__,osmfields){
return (function (){
var s__91928__$1 = s__91928;
while(true){
var temp__4425__auto____$1 = cljs.core.seq.call(null,s__91928__$1);
if(temp__4425__auto____$1){
var s__91928__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__91928__$2)){
var c__5339__auto____$1 = cljs.core.chunk_first.call(null,s__91928__$2);
var size__5340__auto____$1 = cljs.core.count.call(null,c__5339__auto____$1);
var b__91930 = cljs.core.chunk_buffer.call(null,size__5340__auto____$1);
if((function (){var i__91929 = (0);
while(true){
if((i__91929 < size__5340__auto____$1)){
var field = cljs.core._nth.call(null,c__5339__auto____$1,i__91929);
cljs.core.chunk_append.call(null,b__91930,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})());

var G__91935 = (i__91929 + (1));
i__91929 = G__91935;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91930),hatti$ona$post_process$ona_osm_link_$_iter__91915_$_iter__91927.call(null,cljs.core.chunk_rest.call(null,s__91928__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91930),null);
}
} else {
var field = cljs.core.first.call(null,s__91928__$2);
return cljs.core.cons.call(null,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__91915_$_iter__91927.call(null,cljs.core.rest.call(null,s__91928__$2)));
}
} else {
return null;
}
break;
}
});})(i__91917,datum,c__5339__auto__,size__5340__auto__,b__91918,s__91916__$2,temp__4425__auto__,osmfields))
,null,null));
});})(i__91917,datum,c__5339__auto__,size__5340__auto__,b__91918,s__91916__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__.call(null,osmfields);
})());

var G__91936 = (i__91917 + (1));
i__91917 = G__91936;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91918),hatti$ona$post_process$ona_osm_link_$_iter__91915.call(null,cljs.core.chunk_rest.call(null,s__91916__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91918),null);
}
} else {
var datum = cljs.core.first.call(null,s__91916__$2);
return cljs.core.cons.call(null,(function (){var iter__5341__auto__ = ((function (datum,s__91916__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__91915_$_iter__91931(s__91932){
return (new cljs.core.LazySeq(null,((function (datum,s__91916__$2,temp__4425__auto__,osmfields){
return (function (){
var s__91932__$1 = s__91932;
while(true){
var temp__4425__auto____$1 = cljs.core.seq.call(null,s__91932__$1);
if(temp__4425__auto____$1){
var s__91932__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__91932__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__91932__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__91934 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__91933 = (0);
while(true){
if((i__91933 < size__5340__auto__)){
var field = cljs.core._nth.call(null,c__5339__auto__,i__91933);
cljs.core.chunk_append.call(null,b__91934,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})());

var G__91937 = (i__91933 + (1));
i__91933 = G__91937;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91934),hatti$ona$post_process$ona_osm_link_$_iter__91915_$_iter__91931.call(null,cljs.core.chunk_rest.call(null,s__91932__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91934),null);
}
} else {
var field = cljs.core.first.call(null,s__91932__$2);
return cljs.core.cons.call(null,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__91915_$_iter__91931.call(null,cljs.core.rest.call(null,s__91932__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__91916__$2,temp__4425__auto__,osmfields))
,null,null));
});})(datum,s__91916__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__.call(null,osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__91915.call(null,cljs.core.rest.call(null,s__91916__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__5341__auto__.call(null,data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.call(null,osmtogeojson(jQuery.parseXML(osm_xml_string)),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link.call(null,data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson.call(null,osm_xml);
var featureset = osmgeo.call(null,new cljs.core.Keyword(null,"features","features",-1146962336));
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5341__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__91958(s__91959){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__91959__$1 = s__91959;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__91959__$1);
if(temp__4425__auto__){
var s__91959__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__91959__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__91959__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__91961 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__91960 = (0);
while(true){
if((i__91960 < size__5340__auto__)){
var map__91970 = cljs.core._nth.call(null,c__5339__auto__,i__91960);
var map__91970__$1 = ((((!((map__91970 == null)))?((((map__91970.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91970.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91970):map__91970);
var feature = map__91970__$1;
var type = cljs.core.get.call(null,map__91970__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var properties = cljs.core.get.call(null,map__91970__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var geometry = cljs.core.get.call(null,map__91970__$1,new cljs.core.Keyword(null,"geometry","geometry",-405034994));
cljs.core.chunk_append.call(null,b__91961,(function (){var map__91972 = properties;
var map__91972__$1 = ((((!((map__91972 == null)))?((((map__91972.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91972.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91972):map__91972);
var type__$1 = cljs.core.get.call(null,map__91972__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var id = cljs.core.get.call(null,map__91972__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tags = cljs.core.get.call(null,map__91972__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"osm-id","osm-id",-1125866420),id,new cljs.core.Keyword(null,"type","type",1174270348),type__$1,new cljs.core.Keyword(null,"geom","geom",1207084371),geometry,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(tags),new cljs.core.Keyword(null,"tags","tags",1771418977),tags], null)], true, false);
})());

var G__91978 = (i__91960 + (1));
i__91960 = G__91978;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91961),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__91958.call(null,cljs.core.chunk_rest.call(null,s__91959__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91961),null);
}
} else {
var map__91974 = cljs.core.first.call(null,s__91959__$2);
var map__91974__$1 = ((((!((map__91974 == null)))?((((map__91974.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91974.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91974):map__91974);
var feature = map__91974__$1;
var type = cljs.core.get.call(null,map__91974__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var properties = cljs.core.get.call(null,map__91974__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var geometry = cljs.core.get.call(null,map__91974__$1,new cljs.core.Keyword(null,"geometry","geometry",-405034994));
return cljs.core.cons.call(null,(function (){var map__91976 = properties;
var map__91976__$1 = ((((!((map__91976 == null)))?((((map__91976.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91976.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91976):map__91976);
var type__$1 = cljs.core.get.call(null,map__91976__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var id = cljs.core.get.call(null,map__91976__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tags = cljs.core.get.call(null,map__91976__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"osm-id","osm-id",-1125866420),id,new cljs.core.Keyword(null,"type","type",1174270348),type__$1,new cljs.core.Keyword(null,"geom","geom",1207084371),geometry,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(tags),new cljs.core.Keyword(null,"tags","tags",1771418977),tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__91958.call(null,cljs.core.rest.call(null,s__91959__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__5341__auto__.call(null,featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.call(null,hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq.call(null,osm_fields)){
var data = cljs.core.get_in.call(null,app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data.call(null,data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__91979_SHARP_){
return cljs.core.re_find.call(null,/[-]?[0-9]+/,p1__91979_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val){
if(typeof osm_val === 'string'){
var temp__4423__auto__ = osm_data.call(null,osm_val__GT_osm_id.call(null,osm_val));
if(cljs.core.truth_(temp__4423__auto__)){
var osm_submission_data = temp__4423__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__5341__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__91988(s__91989){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__91989__$1 = s__91989;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__91989__$1);
if(temp__4425__auto__){
var s__91989__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__91989__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__91989__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__91991 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__91990 = (0);
while(true){
if((i__91990 < size__5340__auto__)){
var datum = cljs.core._nth.call(null,c__5339__auto__,i__91990);
cljs.core.chunk_append.call(null,b__91991,cljs.core.update_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data));

var G__91996 = (i__91990 + (1));
i__91990 = G__91996;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91991),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__91988.call(null,cljs.core.chunk_rest.call(null,s__91989__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91991),null);
}
} else {
var datum = cljs.core.first.call(null,s__91989__$2);
return cljs.core.cons.call(null,cljs.core.update_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__91988.call(null,cljs.core.rest.call(null,s__91989__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__5341__auto__.call(null,data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__91992 = cljs.core.seq.call(null,osm_fields);
var chunk__91993 = null;
var count__91994 = (0);
var i__91995 = (0);
while(true){
if((i__91995 < count__91994)){
var osm_field = cljs.core._nth.call(null,chunk__91993,i__91995);
hatti.utils.om.state.transact_app_state_BANG_.call(null,app_state,app_state_keys,updater.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__91997 = seq__91992;
var G__91998 = chunk__91993;
var G__91999 = count__91994;
var G__92000 = (i__91995 + (1));
seq__91992 = G__91997;
chunk__91993 = G__91998;
count__91994 = G__91999;
i__91995 = G__92000;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__91992);
if(temp__4425__auto__){
var seq__91992__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__91992__$1)){
var c__5372__auto__ = cljs.core.chunk_first.call(null,seq__91992__$1);
var G__92001 = cljs.core.chunk_rest.call(null,seq__91992__$1);
var G__92002 = c__5372__auto__;
var G__92003 = cljs.core.count.call(null,c__5372__auto__);
var G__92004 = (0);
seq__91992 = G__92001;
chunk__91993 = G__92002;
count__91994 = G__92003;
i__91995 = G__92004;
continue;
} else {
var osm_field = cljs.core.first.call(null,seq__91992__$1);
hatti.utils.om.state.transact_app_state_BANG_.call(null,app_state,app_state_keys,updater.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__92005 = cljs.core.next.call(null,seq__91992__$1);
var G__92006 = null;
var G__92007 = (0);
var G__92008 = (0);
seq__91992 = G__92005;
chunk__91993 = G__92006;
count__91994 = G__92007;
i__91995 = G__92008;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.call(null,media_obj,"id");
var fname = cljs.core.get.call(null,media_obj,"filename");
var file_url = hatti.ona.urls.media_url.call(null,media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"filename","filename",-1428840783),fname,new cljs.core.Keyword(null,"download_url","download_url",-2115471203),file_url,new cljs.core.Keyword(null,"small_download_url","small_download_url",1654303565),[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__4569__auto__ = attachments;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.call(null,record,"_attachments");
}
})();
var fnames = cljs.core.map.call(null,((function (attachments__$1){
return (function (p1__92009_SHARP_){
return hatti.utils.last_url_param.call(null,cljs.core.get.call(null,p1__92009_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap.call(null,fnames,cljs.core.map.call(null,hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.call(null,fname__GT_urlobj,fname,fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Inlines media data from within _attachments into each record.
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__5634__auto__ = [];
var len__5627__auto___92020 = arguments.length;
var i__5628__auto___92021 = (0);
while(true){
if((i__5628__auto___92021 < len__5627__auto___92020)){
args__5634__auto__.push((arguments[i__5628__auto___92021]));

var G__92022 = (i__5628__auto___92021 + (1));
i__5628__auto___92021 = G__92022;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__92013){
var map__92014 = p__92013;
var map__92014__$1 = ((((!((map__92014 == null)))?((((map__92014.cljs$lang$protocol_mask$partition0$ & (64))) || (map__92014.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__92014):map__92014);
var attachments = cljs.core.get.call(null,map__92014__$1,new cljs.core.Keyword(null,"attachments","attachments",-1535547830));
var image_fields = cljs.core.filter.call(null,hatti.ona.forms.image_QMARK_,flat_form);
var iter__5341__auto__ = ((function (image_fields,map__92014,map__92014__$1,attachments){
return (function hatti$ona$post_process$iter__92016(s__92017){
return (new cljs.core.LazySeq(null,((function (image_fields,map__92014,map__92014__$1,attachments){
return (function (){
var s__92017__$1 = s__92017;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__92017__$1);
if(temp__4425__auto__){
var s__92017__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__92017__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__92017__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__92019 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__92018 = (0);
while(true){
if((i__92018 < size__5340__auto__)){
var record = cljs.core._nth.call(null,c__5339__auto__,i__92018);
cljs.core.chunk_append.call(null,b__92019,(function (){var attach_map = hatti.ona.post_process.get_attach_map.call(null,record,attachments);
return cljs.core.reduce.call(null,((function (i__92018,attach_map,record,c__5339__auto__,size__5340__auto__,b__92019,s__92017__$2,temp__4425__auto__,image_fields,map__92014,map__92014__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.call(null,record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__92018,attach_map,record,c__5339__auto__,size__5340__auto__,b__92019,s__92017__$2,temp__4425__auto__,image_fields,map__92014,map__92014__$1,attachments))
,record,image_fields);
})());

var G__92023 = (i__92018 + (1));
i__92018 = G__92023;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__92019),hatti$ona$post_process$iter__92016.call(null,cljs.core.chunk_rest.call(null,s__92017__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__92019),null);
}
} else {
var record = cljs.core.first.call(null,s__92017__$2);
return cljs.core.cons.call(null,(function (){var attach_map = hatti.ona.post_process.get_attach_map.call(null,record,attachments);
return cljs.core.reduce.call(null,((function (attach_map,record,s__92017__$2,temp__4425__auto__,image_fields,map__92014,map__92014__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.call(null,record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__92017__$2,temp__4425__auto__,image_fields,map__92014,map__92014__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__92016.call(null,cljs.core.rest.call(null,s__92017__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__92014,map__92014__$1,attachments))
,null,null));
});})(image_fields,map__92014,map__92014__$1,attachments))
;
return iter__5341__auto__.call(null,data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq92010){
var G__92011 = cljs.core.first.call(null,seq92010);
var seq92010__$1 = cljs.core.next.call(null,seq92010);
var G__92012 = cljs.core.first.call(null,seq92010__$1);
var seq92010__$2 = cljs.core.next.call(null,seq92010__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__92011,G__92012,seq92010__$2);
});
/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.call(null,hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.call(null,record,key,hatti.ona.post_process.integrate_attachments.call(null,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.call(null,record,key),new cljs.core.Keyword(null,"attachments","attachments",-1535547830),cljs.core.get.call(null,record,"_attachments")));
});})(repeat_fields))
;
var iter__5341__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__92028(s__92029){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__92029__$1 = s__92029;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__92029__$1);
if(temp__4425__auto__){
var s__92029__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__92029__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__92029__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__92031 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__92030 = (0);
while(true){
if((i__92030 < size__5340__auto__)){
var record = cljs.core._nth.call(null,c__5339__auto__,i__92030);
cljs.core.chunk_append.call(null,b__92031,cljs.core.reduce.call(null,integrate,record,repeat_fields));

var G__92032 = (i__92030 + (1));
i__92030 = G__92032;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__92031),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__92028.call(null,cljs.core.chunk_rest.call(null,s__92029__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__92031),null);
}
} else {
var record = cljs.core.first.call(null,s__92029__$2);
return cljs.core.cons.call(null,cljs.core.reduce.call(null,integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__92028.call(null,cljs.core.rest.call(null,s__92029__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__5341__auto__.call(null,data);
});
/**
 * Inlines data from within _atatchments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___92040 = arguments.length;
var i__5628__auto___92041 = (0);
while(true){
if((i__5628__auto___92041 < len__5627__auto___92040)){
args__5634__auto__.push((arguments[i__5628__auto___92041]));

var G__92042 = (i__5628__auto___92041 + (1));
i__5628__auto___92041 = G__92042;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__92037){
var map__92038 = p__92037;
var map__92038__$1 = ((((!((map__92038 == null)))?((((map__92038.cljs$lang$protocol_mask$partition0$ & (64))) || (map__92038.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__92038):map__92038);
var app_data_keys = cljs.core.get.call(null,map__92038__$1,new cljs.core.Keyword(null,"app-data-keys","app-data-keys",-662378404),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
return hatti.utils.om.state.transact_app_state_BANG_.call(null,app_state,app_data_keys,((function (map__92038,map__92038__$1,app_data_keys){
return (function (p1__92033_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats.call(null,flat_form,hatti.ona.post_process.integrate_attachments.call(null,flat_form,p1__92033_SHARP_));
});})(map__92038,map__92038__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq92034){
var G__92035 = cljs.core.first.call(null,seq92034);
var seq92034__$1 = cljs.core.next.call(null,seq92034);
var G__92036 = cljs.core.first.call(null,seq92034__$1);
var seq92034__$2 = cljs.core.next.call(null,seq92034__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__92035,G__92036,seq92034__$2);
});
