// Compiled by ClojureScript 1.7.145 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t_cljs$core$async17550 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17550 = (function (fn_handler,f,meta17551){
this.fn_handler = fn_handler;
this.f = f;
this.meta17551 = meta17551;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17550.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17552,meta17551__$1){
var self__ = this;
var _17552__$1 = this;
return (new cljs.core.async.t_cljs$core$async17550(self__.fn_handler,self__.f,meta17551__$1));
});

cljs.core.async.t_cljs$core$async17550.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17552){
var self__ = this;
var _17552__$1 = this;
return self__.meta17551;
});

cljs.core.async.t_cljs$core$async17550.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17550.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17550.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async17550.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fn-handler","fn-handler",648785851,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)))], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"meta17551","meta17551",-1749832774,null)], null);
});

cljs.core.async.t_cljs$core$async17550.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17550.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17550";

cljs.core.async.t_cljs$core$async17550.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async17550");
});

cljs.core.async.__GT_t_cljs$core$async17550 = (function cljs$core$async$fn_handler_$___GT_t_cljs$core$async17550(fn_handler__$1,f__$1,meta17551){
return (new cljs.core.async.t_cljs$core$async17550(fn_handler__$1,f__$1,meta17551));
});

}

return (new cljs.core.async.t_cljs$core$async17550(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args17555 = [];
var len__5627__auto___17558 = arguments.length;
var i__5628__auto___17559 = (0);
while(true){
if((i__5628__auto___17559 < len__5627__auto___17558)){
args17555.push((arguments[i__5628__auto___17559]));

var G__17560 = (i__5628__auto___17559 + (1));
i__5628__auto___17559 = G__17560;
continue;
} else {
}
break;
}

var G__17557 = args17555.length;
switch (G__17557) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17555.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args17562 = [];
var len__5627__auto___17565 = arguments.length;
var i__5628__auto___17566 = (0);
while(true){
if((i__5628__auto___17566 < len__5627__auto___17565)){
args17562.push((arguments[i__5628__auto___17566]));

var G__17567 = (i__5628__auto___17566 + (1));
i__5628__auto___17566 = G__17567;
continue;
} else {
}
break;
}

var G__17564 = args17562.length;
switch (G__17564) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17562.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_17569 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_17569);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_17569,ret){
return (function (){
return fn1.call(null,val_17569);
});})(val_17569,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args17570 = [];
var len__5627__auto___17573 = arguments.length;
var i__5628__auto___17574 = (0);
while(true){
if((i__5628__auto___17574 < len__5627__auto___17573)){
args17570.push((arguments[i__5628__auto___17574]));

var G__17575 = (i__5628__auto___17574 + (1));
i__5628__auto___17574 = G__17575;
continue;
} else {
}
break;
}

var G__17572 = args17570.length;
switch (G__17572) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17570.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5472__auto___17577 = n;
var x_17578 = (0);
while(true){
if((x_17578 < n__5472__auto___17577)){
(a[x_17578] = (0));

var G__17579 = (x_17578 + (1));
x_17578 = G__17579;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__17580 = (i + (1));
i = G__17580;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async17584 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17584 = (function (alt_flag,flag,meta17585){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta17585 = meta17585;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17584.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_17586,meta17585__$1){
var self__ = this;
var _17586__$1 = this;
return (new cljs.core.async.t_cljs$core$async17584(self__.alt_flag,self__.flag,meta17585__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async17584.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_17586){
var self__ = this;
var _17586__$1 = this;
return self__.meta17585;
});})(flag))
;

cljs.core.async.t_cljs$core$async17584.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17584.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async17584.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17584.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta17585","meta17585",1425810820,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async17584.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17584.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17584";

cljs.core.async.t_cljs$core$async17584.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async17584");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async17584 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17584(alt_flag__$1,flag__$1,meta17585){
return (new cljs.core.async.t_cljs$core$async17584(alt_flag__$1,flag__$1,meta17585));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async17584(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async17590 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17590 = (function (alt_handler,flag,cb,meta17591){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta17591 = meta17591;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17590.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17592,meta17591__$1){
var self__ = this;
var _17592__$1 = this;
return (new cljs.core.async.t_cljs$core$async17590(self__.alt_handler,self__.flag,self__.cb,meta17591__$1));
});

cljs.core.async.t_cljs$core$async17590.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17592){
var self__ = this;
var _17592__$1 = this;
return self__.meta17591;
});

cljs.core.async.t_cljs$core$async17590.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17590.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async17590.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async17590.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta17591","meta17591",-342025441,null)], null);
});

cljs.core.async.t_cljs$core$async17590.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17590.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17590";

cljs.core.async.t_cljs$core$async17590.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async17590");
});

cljs.core.async.__GT_t_cljs$core$async17590 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17590(alt_handler__$1,flag__$1,cb__$1,meta17591){
return (new cljs.core.async.t_cljs$core$async17590(alt_handler__$1,flag__$1,cb__$1,meta17591));
});

}

return (new cljs.core.async.t_cljs$core$async17590(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17593_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17593_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17594_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17594_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4569__auto__ = wport;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17595 = (i + (1));
i = G__17595;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4569__auto__ = ret;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4557__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___17601 = arguments.length;
var i__5628__auto___17602 = (0);
while(true){
if((i__5628__auto___17602 < len__5627__auto___17601)){
args__5634__auto__.push((arguments[i__5628__auto___17602]));

var G__17603 = (i__5628__auto___17602 + (1));
i__5628__auto___17602 = G__17603;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17598){
var map__17599 = p__17598;
var map__17599__$1 = ((((!((map__17599 == null)))?((((map__17599.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17599.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17599):map__17599);
var opts = map__17599__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17596){
var G__17597 = cljs.core.first.call(null,seq17596);
var seq17596__$1 = cljs.core.next.call(null,seq17596);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17597,seq17596__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args17604 = [];
var len__5627__auto___17654 = arguments.length;
var i__5628__auto___17655 = (0);
while(true){
if((i__5628__auto___17655 < len__5627__auto___17654)){
args17604.push((arguments[i__5628__auto___17655]));

var G__17656 = (i__5628__auto___17655 + (1));
i__5628__auto___17655 = G__17656;
continue;
} else {
}
break;
}

var G__17606 = args17604.length;
switch (G__17606) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17604.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__8429__auto___17658 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8429__auto___17658){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___17658){
return (function (state_17630){
var state_val_17631 = (state_17630[(1)]);
if((state_val_17631 === (7))){
var inst_17626 = (state_17630[(2)]);
var state_17630__$1 = state_17630;
var statearr_17632_17659 = state_17630__$1;
(statearr_17632_17659[(2)] = inst_17626);

(statearr_17632_17659[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17631 === (1))){
var state_17630__$1 = state_17630;
var statearr_17633_17660 = state_17630__$1;
(statearr_17633_17660[(2)] = null);

(statearr_17633_17660[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17631 === (4))){
var inst_17609 = (state_17630[(7)]);
var inst_17609__$1 = (state_17630[(2)]);
var inst_17610 = (inst_17609__$1 == null);
var state_17630__$1 = (function (){var statearr_17634 = state_17630;
(statearr_17634[(7)] = inst_17609__$1);

return statearr_17634;
})();
if(cljs.core.truth_(inst_17610)){
var statearr_17635_17661 = state_17630__$1;
(statearr_17635_17661[(1)] = (5));

} else {
var statearr_17636_17662 = state_17630__$1;
(statearr_17636_17662[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17631 === (13))){
var state_17630__$1 = state_17630;
var statearr_17637_17663 = state_17630__$1;
(statearr_17637_17663[(2)] = null);

(statearr_17637_17663[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17631 === (6))){
var inst_17609 = (state_17630[(7)]);
var state_17630__$1 = state_17630;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17630__$1,(11),to,inst_17609);
} else {
if((state_val_17631 === (3))){
var inst_17628 = (state_17630[(2)]);
var state_17630__$1 = state_17630;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17630__$1,inst_17628);
} else {
if((state_val_17631 === (12))){
var state_17630__$1 = state_17630;
var statearr_17638_17664 = state_17630__$1;
(statearr_17638_17664[(2)] = null);

(statearr_17638_17664[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17631 === (2))){
var state_17630__$1 = state_17630;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17630__$1,(4),from);
} else {
if((state_val_17631 === (11))){
var inst_17619 = (state_17630[(2)]);
var state_17630__$1 = state_17630;
if(cljs.core.truth_(inst_17619)){
var statearr_17639_17665 = state_17630__$1;
(statearr_17639_17665[(1)] = (12));

} else {
var statearr_17640_17666 = state_17630__$1;
(statearr_17640_17666[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17631 === (9))){
var state_17630__$1 = state_17630;
var statearr_17641_17667 = state_17630__$1;
(statearr_17641_17667[(2)] = null);

(statearr_17641_17667[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17631 === (5))){
var state_17630__$1 = state_17630;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17642_17668 = state_17630__$1;
(statearr_17642_17668[(1)] = (8));

} else {
var statearr_17643_17669 = state_17630__$1;
(statearr_17643_17669[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17631 === (14))){
var inst_17624 = (state_17630[(2)]);
var state_17630__$1 = state_17630;
var statearr_17644_17670 = state_17630__$1;
(statearr_17644_17670[(2)] = inst_17624);

(statearr_17644_17670[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17631 === (10))){
var inst_17616 = (state_17630[(2)]);
var state_17630__$1 = state_17630;
var statearr_17645_17671 = state_17630__$1;
(statearr_17645_17671[(2)] = inst_17616);

(statearr_17645_17671[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17631 === (8))){
var inst_17613 = cljs.core.async.close_BANG_.call(null,to);
var state_17630__$1 = state_17630;
var statearr_17646_17672 = state_17630__$1;
(statearr_17646_17672[(2)] = inst_17613);

(statearr_17646_17672[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___17658))
;
return ((function (switch__8364__auto__,c__8429__auto___17658){
return (function() {
var cljs$core$async$state_machine__8365__auto__ = null;
var cljs$core$async$state_machine__8365__auto____0 = (function (){
var statearr_17650 = [null,null,null,null,null,null,null,null];
(statearr_17650[(0)] = cljs$core$async$state_machine__8365__auto__);

(statearr_17650[(1)] = (1));

return statearr_17650;
});
var cljs$core$async$state_machine__8365__auto____1 = (function (state_17630){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_17630);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e17651){if((e17651 instanceof Object)){
var ex__8368__auto__ = e17651;
var statearr_17652_17673 = state_17630;
(statearr_17652_17673[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17630);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17651;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17674 = state_17630;
state_17630 = G__17674;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$state_machine__8365__auto__ = function(state_17630){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8365__auto____1.call(this,state_17630);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8365__auto____0;
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8365__auto____1;
return cljs$core$async$state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___17658))
})();
var state__8431__auto__ = (function (){var statearr_17653 = f__8430__auto__.call(null);
(statearr_17653[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___17658);

return statearr_17653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});})(c__8429__auto___17658))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__17858){
var vec__17859 = p__17858;
var v = cljs.core.nth.call(null,vec__17859,(0),null);
var p = cljs.core.nth.call(null,vec__17859,(1),null);
var job = vec__17859;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__8429__auto___18041 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8429__auto___18041,res,vec__17859,v,p,job,jobs,results){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___18041,res,vec__17859,v,p,job,jobs,results){
return (function (state_17864){
var state_val_17865 = (state_17864[(1)]);
if((state_val_17865 === (1))){
var state_17864__$1 = state_17864;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17864__$1,(2),res,v);
} else {
if((state_val_17865 === (2))){
var inst_17861 = (state_17864[(2)]);
var inst_17862 = cljs.core.async.close_BANG_.call(null,res);
var state_17864__$1 = (function (){var statearr_17866 = state_17864;
(statearr_17866[(7)] = inst_17861);

return statearr_17866;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17864__$1,inst_17862);
} else {
return null;
}
}
});})(c__8429__auto___18041,res,vec__17859,v,p,job,jobs,results))
;
return ((function (switch__8364__auto__,c__8429__auto___18041,res,vec__17859,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0 = (function (){
var statearr_17870 = [null,null,null,null,null,null,null,null];
(statearr_17870[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__);

(statearr_17870[(1)] = (1));

return statearr_17870;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1 = (function (state_17864){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_17864);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e17871){if((e17871 instanceof Object)){
var ex__8368__auto__ = e17871;
var statearr_17872_18042 = state_17864;
(statearr_17872_18042[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17864);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17871;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18043 = state_17864;
state_17864 = G__18043;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__ = function(state_17864){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1.call(this,state_17864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___18041,res,vec__17859,v,p,job,jobs,results))
})();
var state__8431__auto__ = (function (){var statearr_17873 = f__8430__auto__.call(null);
(statearr_17873[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___18041);

return statearr_17873;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});})(c__8429__auto___18041,res,vec__17859,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17874){
var vec__17875 = p__17874;
var v = cljs.core.nth.call(null,vec__17875,(0),null);
var p = cljs.core.nth.call(null,vec__17875,(1),null);
var job = vec__17875;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5472__auto___18044 = n;
var __18045 = (0);
while(true){
if((__18045 < n__5472__auto___18044)){
var G__17876_18046 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__17876_18046) {
case "compute":
var c__8429__auto___18048 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__18045,c__8429__auto___18048,G__17876_18046,n__5472__auto___18044,jobs,results,process,async){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (__18045,c__8429__auto___18048,G__17876_18046,n__5472__auto___18044,jobs,results,process,async){
return (function (state_17889){
var state_val_17890 = (state_17889[(1)]);
if((state_val_17890 === (1))){
var state_17889__$1 = state_17889;
var statearr_17891_18049 = state_17889__$1;
(statearr_17891_18049[(2)] = null);

(statearr_17891_18049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (2))){
var state_17889__$1 = state_17889;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17889__$1,(4),jobs);
} else {
if((state_val_17890 === (3))){
var inst_17887 = (state_17889[(2)]);
var state_17889__$1 = state_17889;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17889__$1,inst_17887);
} else {
if((state_val_17890 === (4))){
var inst_17879 = (state_17889[(2)]);
var inst_17880 = process.call(null,inst_17879);
var state_17889__$1 = state_17889;
if(cljs.core.truth_(inst_17880)){
var statearr_17892_18050 = state_17889__$1;
(statearr_17892_18050[(1)] = (5));

} else {
var statearr_17893_18051 = state_17889__$1;
(statearr_17893_18051[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (5))){
var state_17889__$1 = state_17889;
var statearr_17894_18052 = state_17889__$1;
(statearr_17894_18052[(2)] = null);

(statearr_17894_18052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (6))){
var state_17889__$1 = state_17889;
var statearr_17895_18053 = state_17889__$1;
(statearr_17895_18053[(2)] = null);

(statearr_17895_18053[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (7))){
var inst_17885 = (state_17889[(2)]);
var state_17889__$1 = state_17889;
var statearr_17896_18054 = state_17889__$1;
(statearr_17896_18054[(2)] = inst_17885);

(statearr_17896_18054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__18045,c__8429__auto___18048,G__17876_18046,n__5472__auto___18044,jobs,results,process,async))
;
return ((function (__18045,switch__8364__auto__,c__8429__auto___18048,G__17876_18046,n__5472__auto___18044,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0 = (function (){
var statearr_17900 = [null,null,null,null,null,null,null];
(statearr_17900[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__);

(statearr_17900[(1)] = (1));

return statearr_17900;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1 = (function (state_17889){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_17889);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e17901){if((e17901 instanceof Object)){
var ex__8368__auto__ = e17901;
var statearr_17902_18055 = state_17889;
(statearr_17902_18055[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17889);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17901;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18056 = state_17889;
state_17889 = G__18056;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__ = function(state_17889){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1.call(this,state_17889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__;
})()
;})(__18045,switch__8364__auto__,c__8429__auto___18048,G__17876_18046,n__5472__auto___18044,jobs,results,process,async))
})();
var state__8431__auto__ = (function (){var statearr_17903 = f__8430__auto__.call(null);
(statearr_17903[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___18048);

return statearr_17903;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});})(__18045,c__8429__auto___18048,G__17876_18046,n__5472__auto___18044,jobs,results,process,async))
);


break;
case "async":
var c__8429__auto___18057 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__18045,c__8429__auto___18057,G__17876_18046,n__5472__auto___18044,jobs,results,process,async){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (__18045,c__8429__auto___18057,G__17876_18046,n__5472__auto___18044,jobs,results,process,async){
return (function (state_17916){
var state_val_17917 = (state_17916[(1)]);
if((state_val_17917 === (1))){
var state_17916__$1 = state_17916;
var statearr_17918_18058 = state_17916__$1;
(statearr_17918_18058[(2)] = null);

(statearr_17918_18058[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17917 === (2))){
var state_17916__$1 = state_17916;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17916__$1,(4),jobs);
} else {
if((state_val_17917 === (3))){
var inst_17914 = (state_17916[(2)]);
var state_17916__$1 = state_17916;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17916__$1,inst_17914);
} else {
if((state_val_17917 === (4))){
var inst_17906 = (state_17916[(2)]);
var inst_17907 = async.call(null,inst_17906);
var state_17916__$1 = state_17916;
if(cljs.core.truth_(inst_17907)){
var statearr_17919_18059 = state_17916__$1;
(statearr_17919_18059[(1)] = (5));

} else {
var statearr_17920_18060 = state_17916__$1;
(statearr_17920_18060[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17917 === (5))){
var state_17916__$1 = state_17916;
var statearr_17921_18061 = state_17916__$1;
(statearr_17921_18061[(2)] = null);

(statearr_17921_18061[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17917 === (6))){
var state_17916__$1 = state_17916;
var statearr_17922_18062 = state_17916__$1;
(statearr_17922_18062[(2)] = null);

(statearr_17922_18062[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17917 === (7))){
var inst_17912 = (state_17916[(2)]);
var state_17916__$1 = state_17916;
var statearr_17923_18063 = state_17916__$1;
(statearr_17923_18063[(2)] = inst_17912);

(statearr_17923_18063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__18045,c__8429__auto___18057,G__17876_18046,n__5472__auto___18044,jobs,results,process,async))
;
return ((function (__18045,switch__8364__auto__,c__8429__auto___18057,G__17876_18046,n__5472__auto___18044,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0 = (function (){
var statearr_17927 = [null,null,null,null,null,null,null];
(statearr_17927[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__);

(statearr_17927[(1)] = (1));

return statearr_17927;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1 = (function (state_17916){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_17916);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e17928){if((e17928 instanceof Object)){
var ex__8368__auto__ = e17928;
var statearr_17929_18064 = state_17916;
(statearr_17929_18064[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17916);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17928;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18065 = state_17916;
state_17916 = G__18065;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__ = function(state_17916){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1.call(this,state_17916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__;
})()
;})(__18045,switch__8364__auto__,c__8429__auto___18057,G__17876_18046,n__5472__auto___18044,jobs,results,process,async))
})();
var state__8431__auto__ = (function (){var statearr_17930 = f__8430__auto__.call(null);
(statearr_17930[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___18057);

return statearr_17930;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});})(__18045,c__8429__auto___18057,G__17876_18046,n__5472__auto___18044,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__18066 = (__18045 + (1));
__18045 = G__18066;
continue;
} else {
}
break;
}

var c__8429__auto___18067 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8429__auto___18067,jobs,results,process,async){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___18067,jobs,results,process,async){
return (function (state_17952){
var state_val_17953 = (state_17952[(1)]);
if((state_val_17953 === (1))){
var state_17952__$1 = state_17952;
var statearr_17954_18068 = state_17952__$1;
(statearr_17954_18068[(2)] = null);

(statearr_17954_18068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17953 === (2))){
var state_17952__$1 = state_17952;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17952__$1,(4),from);
} else {
if((state_val_17953 === (3))){
var inst_17950 = (state_17952[(2)]);
var state_17952__$1 = state_17952;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17952__$1,inst_17950);
} else {
if((state_val_17953 === (4))){
var inst_17933 = (state_17952[(7)]);
var inst_17933__$1 = (state_17952[(2)]);
var inst_17934 = (inst_17933__$1 == null);
var state_17952__$1 = (function (){var statearr_17955 = state_17952;
(statearr_17955[(7)] = inst_17933__$1);

return statearr_17955;
})();
if(cljs.core.truth_(inst_17934)){
var statearr_17956_18069 = state_17952__$1;
(statearr_17956_18069[(1)] = (5));

} else {
var statearr_17957_18070 = state_17952__$1;
(statearr_17957_18070[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17953 === (5))){
var inst_17936 = cljs.core.async.close_BANG_.call(null,jobs);
var state_17952__$1 = state_17952;
var statearr_17958_18071 = state_17952__$1;
(statearr_17958_18071[(2)] = inst_17936);

(statearr_17958_18071[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17953 === (6))){
var inst_17933 = (state_17952[(7)]);
var inst_17938 = (state_17952[(8)]);
var inst_17938__$1 = cljs.core.async.chan.call(null,(1));
var inst_17939 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17940 = [inst_17933,inst_17938__$1];
var inst_17941 = (new cljs.core.PersistentVector(null,2,(5),inst_17939,inst_17940,null));
var state_17952__$1 = (function (){var statearr_17959 = state_17952;
(statearr_17959[(8)] = inst_17938__$1);

return statearr_17959;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17952__$1,(8),jobs,inst_17941);
} else {
if((state_val_17953 === (7))){
var inst_17948 = (state_17952[(2)]);
var state_17952__$1 = state_17952;
var statearr_17960_18072 = state_17952__$1;
(statearr_17960_18072[(2)] = inst_17948);

(statearr_17960_18072[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17953 === (8))){
var inst_17938 = (state_17952[(8)]);
var inst_17943 = (state_17952[(2)]);
var state_17952__$1 = (function (){var statearr_17961 = state_17952;
(statearr_17961[(9)] = inst_17943);

return statearr_17961;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17952__$1,(9),results,inst_17938);
} else {
if((state_val_17953 === (9))){
var inst_17945 = (state_17952[(2)]);
var state_17952__$1 = (function (){var statearr_17962 = state_17952;
(statearr_17962[(10)] = inst_17945);

return statearr_17962;
})();
var statearr_17963_18073 = state_17952__$1;
(statearr_17963_18073[(2)] = null);

(statearr_17963_18073[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___18067,jobs,results,process,async))
;
return ((function (switch__8364__auto__,c__8429__auto___18067,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0 = (function (){
var statearr_17967 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17967[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__);

(statearr_17967[(1)] = (1));

return statearr_17967;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1 = (function (state_17952){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_17952);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e17968){if((e17968 instanceof Object)){
var ex__8368__auto__ = e17968;
var statearr_17969_18074 = state_17952;
(statearr_17969_18074[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17952);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17968;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18075 = state_17952;
state_17952 = G__18075;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__ = function(state_17952){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1.call(this,state_17952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___18067,jobs,results,process,async))
})();
var state__8431__auto__ = (function (){var statearr_17970 = f__8430__auto__.call(null);
(statearr_17970[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___18067);

return statearr_17970;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});})(c__8429__auto___18067,jobs,results,process,async))
);


var c__8429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8429__auto__,jobs,results,process,async){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto__,jobs,results,process,async){
return (function (state_18008){
var state_val_18009 = (state_18008[(1)]);
if((state_val_18009 === (7))){
var inst_18004 = (state_18008[(2)]);
var state_18008__$1 = state_18008;
var statearr_18010_18076 = state_18008__$1;
(statearr_18010_18076[(2)] = inst_18004);

(statearr_18010_18076[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18009 === (20))){
var state_18008__$1 = state_18008;
var statearr_18011_18077 = state_18008__$1;
(statearr_18011_18077[(2)] = null);

(statearr_18011_18077[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18009 === (1))){
var state_18008__$1 = state_18008;
var statearr_18012_18078 = state_18008__$1;
(statearr_18012_18078[(2)] = null);

(statearr_18012_18078[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18009 === (4))){
var inst_17973 = (state_18008[(7)]);
var inst_17973__$1 = (state_18008[(2)]);
var inst_17974 = (inst_17973__$1 == null);
var state_18008__$1 = (function (){var statearr_18013 = state_18008;
(statearr_18013[(7)] = inst_17973__$1);

return statearr_18013;
})();
if(cljs.core.truth_(inst_17974)){
var statearr_18014_18079 = state_18008__$1;
(statearr_18014_18079[(1)] = (5));

} else {
var statearr_18015_18080 = state_18008__$1;
(statearr_18015_18080[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18009 === (15))){
var inst_17986 = (state_18008[(8)]);
var state_18008__$1 = state_18008;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18008__$1,(18),to,inst_17986);
} else {
if((state_val_18009 === (21))){
var inst_17999 = (state_18008[(2)]);
var state_18008__$1 = state_18008;
var statearr_18016_18081 = state_18008__$1;
(statearr_18016_18081[(2)] = inst_17999);

(statearr_18016_18081[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18009 === (13))){
var inst_18001 = (state_18008[(2)]);
var state_18008__$1 = (function (){var statearr_18017 = state_18008;
(statearr_18017[(9)] = inst_18001);

return statearr_18017;
})();
var statearr_18018_18082 = state_18008__$1;
(statearr_18018_18082[(2)] = null);

(statearr_18018_18082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18009 === (6))){
var inst_17973 = (state_18008[(7)]);
var state_18008__$1 = state_18008;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18008__$1,(11),inst_17973);
} else {
if((state_val_18009 === (17))){
var inst_17994 = (state_18008[(2)]);
var state_18008__$1 = state_18008;
if(cljs.core.truth_(inst_17994)){
var statearr_18019_18083 = state_18008__$1;
(statearr_18019_18083[(1)] = (19));

} else {
var statearr_18020_18084 = state_18008__$1;
(statearr_18020_18084[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18009 === (3))){
var inst_18006 = (state_18008[(2)]);
var state_18008__$1 = state_18008;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18008__$1,inst_18006);
} else {
if((state_val_18009 === (12))){
var inst_17983 = (state_18008[(10)]);
var state_18008__$1 = state_18008;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18008__$1,(14),inst_17983);
} else {
if((state_val_18009 === (2))){
var state_18008__$1 = state_18008;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18008__$1,(4),results);
} else {
if((state_val_18009 === (19))){
var state_18008__$1 = state_18008;
var statearr_18021_18085 = state_18008__$1;
(statearr_18021_18085[(2)] = null);

(statearr_18021_18085[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18009 === (11))){
var inst_17983 = (state_18008[(2)]);
var state_18008__$1 = (function (){var statearr_18022 = state_18008;
(statearr_18022[(10)] = inst_17983);

return statearr_18022;
})();
var statearr_18023_18086 = state_18008__$1;
(statearr_18023_18086[(2)] = null);

(statearr_18023_18086[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18009 === (9))){
var state_18008__$1 = state_18008;
var statearr_18024_18087 = state_18008__$1;
(statearr_18024_18087[(2)] = null);

(statearr_18024_18087[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18009 === (5))){
var state_18008__$1 = state_18008;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18025_18088 = state_18008__$1;
(statearr_18025_18088[(1)] = (8));

} else {
var statearr_18026_18089 = state_18008__$1;
(statearr_18026_18089[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18009 === (14))){
var inst_17986 = (state_18008[(8)]);
var inst_17988 = (state_18008[(11)]);
var inst_17986__$1 = (state_18008[(2)]);
var inst_17987 = (inst_17986__$1 == null);
var inst_17988__$1 = cljs.core.not.call(null,inst_17987);
var state_18008__$1 = (function (){var statearr_18027 = state_18008;
(statearr_18027[(8)] = inst_17986__$1);

(statearr_18027[(11)] = inst_17988__$1);

return statearr_18027;
})();
if(inst_17988__$1){
var statearr_18028_18090 = state_18008__$1;
(statearr_18028_18090[(1)] = (15));

} else {
var statearr_18029_18091 = state_18008__$1;
(statearr_18029_18091[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18009 === (16))){
var inst_17988 = (state_18008[(11)]);
var state_18008__$1 = state_18008;
var statearr_18030_18092 = state_18008__$1;
(statearr_18030_18092[(2)] = inst_17988);

(statearr_18030_18092[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18009 === (10))){
var inst_17980 = (state_18008[(2)]);
var state_18008__$1 = state_18008;
var statearr_18031_18093 = state_18008__$1;
(statearr_18031_18093[(2)] = inst_17980);

(statearr_18031_18093[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18009 === (18))){
var inst_17991 = (state_18008[(2)]);
var state_18008__$1 = state_18008;
var statearr_18032_18094 = state_18008__$1;
(statearr_18032_18094[(2)] = inst_17991);

(statearr_18032_18094[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18009 === (8))){
var inst_17977 = cljs.core.async.close_BANG_.call(null,to);
var state_18008__$1 = state_18008;
var statearr_18033_18095 = state_18008__$1;
(statearr_18033_18095[(2)] = inst_17977);

(statearr_18033_18095[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto__,jobs,results,process,async))
;
return ((function (switch__8364__auto__,c__8429__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0 = (function (){
var statearr_18037 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18037[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__);

(statearr_18037[(1)] = (1));

return statearr_18037;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1 = (function (state_18008){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_18008);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e18038){if((e18038 instanceof Object)){
var ex__8368__auto__ = e18038;
var statearr_18039_18096 = state_18008;
(statearr_18039_18096[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18008);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18038;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18097 = state_18008;
state_18008 = G__18097;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__ = function(state_18008){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1.call(this,state_18008);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto__,jobs,results,process,async))
})();
var state__8431__auto__ = (function (){var statearr_18040 = f__8430__auto__.call(null);
(statearr_18040[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto__);

return statearr_18040;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});})(c__8429__auto__,jobs,results,process,async))
);

return c__8429__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args18098 = [];
var len__5627__auto___18101 = arguments.length;
var i__5628__auto___18102 = (0);
while(true){
if((i__5628__auto___18102 < len__5627__auto___18101)){
args18098.push((arguments[i__5628__auto___18102]));

var G__18103 = (i__5628__auto___18102 + (1));
i__5628__auto___18102 = G__18103;
continue;
} else {
}
break;
}

var G__18100 = args18098.length;
switch (G__18100) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18098.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args18105 = [];
var len__5627__auto___18108 = arguments.length;
var i__5628__auto___18109 = (0);
while(true){
if((i__5628__auto___18109 < len__5627__auto___18108)){
args18105.push((arguments[i__5628__auto___18109]));

var G__18110 = (i__5628__auto___18109 + (1));
i__5628__auto___18109 = G__18110;
continue;
} else {
}
break;
}

var G__18107 = args18105.length;
switch (G__18107) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18105.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args18112 = [];
var len__5627__auto___18165 = arguments.length;
var i__5628__auto___18166 = (0);
while(true){
if((i__5628__auto___18166 < len__5627__auto___18165)){
args18112.push((arguments[i__5628__auto___18166]));

var G__18167 = (i__5628__auto___18166 + (1));
i__5628__auto___18166 = G__18167;
continue;
} else {
}
break;
}

var G__18114 = args18112.length;
switch (G__18114) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18112.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__8429__auto___18169 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8429__auto___18169,tc,fc){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___18169,tc,fc){
return (function (state_18140){
var state_val_18141 = (state_18140[(1)]);
if((state_val_18141 === (7))){
var inst_18136 = (state_18140[(2)]);
var state_18140__$1 = state_18140;
var statearr_18142_18170 = state_18140__$1;
(statearr_18142_18170[(2)] = inst_18136);

(statearr_18142_18170[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18141 === (1))){
var state_18140__$1 = state_18140;
var statearr_18143_18171 = state_18140__$1;
(statearr_18143_18171[(2)] = null);

(statearr_18143_18171[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18141 === (4))){
var inst_18117 = (state_18140[(7)]);
var inst_18117__$1 = (state_18140[(2)]);
var inst_18118 = (inst_18117__$1 == null);
var state_18140__$1 = (function (){var statearr_18144 = state_18140;
(statearr_18144[(7)] = inst_18117__$1);

return statearr_18144;
})();
if(cljs.core.truth_(inst_18118)){
var statearr_18145_18172 = state_18140__$1;
(statearr_18145_18172[(1)] = (5));

} else {
var statearr_18146_18173 = state_18140__$1;
(statearr_18146_18173[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18141 === (13))){
var state_18140__$1 = state_18140;
var statearr_18147_18174 = state_18140__$1;
(statearr_18147_18174[(2)] = null);

(statearr_18147_18174[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18141 === (6))){
var inst_18117 = (state_18140[(7)]);
var inst_18123 = p.call(null,inst_18117);
var state_18140__$1 = state_18140;
if(cljs.core.truth_(inst_18123)){
var statearr_18148_18175 = state_18140__$1;
(statearr_18148_18175[(1)] = (9));

} else {
var statearr_18149_18176 = state_18140__$1;
(statearr_18149_18176[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18141 === (3))){
var inst_18138 = (state_18140[(2)]);
var state_18140__$1 = state_18140;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18140__$1,inst_18138);
} else {
if((state_val_18141 === (12))){
var state_18140__$1 = state_18140;
var statearr_18150_18177 = state_18140__$1;
(statearr_18150_18177[(2)] = null);

(statearr_18150_18177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18141 === (2))){
var state_18140__$1 = state_18140;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18140__$1,(4),ch);
} else {
if((state_val_18141 === (11))){
var inst_18117 = (state_18140[(7)]);
var inst_18127 = (state_18140[(2)]);
var state_18140__$1 = state_18140;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18140__$1,(8),inst_18127,inst_18117);
} else {
if((state_val_18141 === (9))){
var state_18140__$1 = state_18140;
var statearr_18151_18178 = state_18140__$1;
(statearr_18151_18178[(2)] = tc);

(statearr_18151_18178[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18141 === (5))){
var inst_18120 = cljs.core.async.close_BANG_.call(null,tc);
var inst_18121 = cljs.core.async.close_BANG_.call(null,fc);
var state_18140__$1 = (function (){var statearr_18152 = state_18140;
(statearr_18152[(8)] = inst_18120);

return statearr_18152;
})();
var statearr_18153_18179 = state_18140__$1;
(statearr_18153_18179[(2)] = inst_18121);

(statearr_18153_18179[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18141 === (14))){
var inst_18134 = (state_18140[(2)]);
var state_18140__$1 = state_18140;
var statearr_18154_18180 = state_18140__$1;
(statearr_18154_18180[(2)] = inst_18134);

(statearr_18154_18180[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18141 === (10))){
var state_18140__$1 = state_18140;
var statearr_18155_18181 = state_18140__$1;
(statearr_18155_18181[(2)] = fc);

(statearr_18155_18181[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18141 === (8))){
var inst_18129 = (state_18140[(2)]);
var state_18140__$1 = state_18140;
if(cljs.core.truth_(inst_18129)){
var statearr_18156_18182 = state_18140__$1;
(statearr_18156_18182[(1)] = (12));

} else {
var statearr_18157_18183 = state_18140__$1;
(statearr_18157_18183[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___18169,tc,fc))
;
return ((function (switch__8364__auto__,c__8429__auto___18169,tc,fc){
return (function() {
var cljs$core$async$state_machine__8365__auto__ = null;
var cljs$core$async$state_machine__8365__auto____0 = (function (){
var statearr_18161 = [null,null,null,null,null,null,null,null,null];
(statearr_18161[(0)] = cljs$core$async$state_machine__8365__auto__);

(statearr_18161[(1)] = (1));

return statearr_18161;
});
var cljs$core$async$state_machine__8365__auto____1 = (function (state_18140){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_18140);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e18162){if((e18162 instanceof Object)){
var ex__8368__auto__ = e18162;
var statearr_18163_18184 = state_18140;
(statearr_18163_18184[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18140);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18162;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18185 = state_18140;
state_18140 = G__18185;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$state_machine__8365__auto__ = function(state_18140){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8365__auto____1.call(this,state_18140);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8365__auto____0;
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8365__auto____1;
return cljs$core$async$state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___18169,tc,fc))
})();
var state__8431__auto__ = (function (){var statearr_18164 = f__8430__auto__.call(null);
(statearr_18164[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___18169);

return statearr_18164;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});})(c__8429__auto___18169,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__8429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8429__auto__){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto__){
return (function (state_18232){
var state_val_18233 = (state_18232[(1)]);
if((state_val_18233 === (1))){
var inst_18218 = init;
var state_18232__$1 = (function (){var statearr_18234 = state_18232;
(statearr_18234[(7)] = inst_18218);

return statearr_18234;
})();
var statearr_18235_18250 = state_18232__$1;
(statearr_18235_18250[(2)] = null);

(statearr_18235_18250[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18233 === (2))){
var state_18232__$1 = state_18232;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18232__$1,(4),ch);
} else {
if((state_val_18233 === (3))){
var inst_18230 = (state_18232[(2)]);
var state_18232__$1 = state_18232;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18232__$1,inst_18230);
} else {
if((state_val_18233 === (4))){
var inst_18221 = (state_18232[(8)]);
var inst_18221__$1 = (state_18232[(2)]);
var inst_18222 = (inst_18221__$1 == null);
var state_18232__$1 = (function (){var statearr_18236 = state_18232;
(statearr_18236[(8)] = inst_18221__$1);

return statearr_18236;
})();
if(cljs.core.truth_(inst_18222)){
var statearr_18237_18251 = state_18232__$1;
(statearr_18237_18251[(1)] = (5));

} else {
var statearr_18238_18252 = state_18232__$1;
(statearr_18238_18252[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18233 === (5))){
var inst_18218 = (state_18232[(7)]);
var state_18232__$1 = state_18232;
var statearr_18239_18253 = state_18232__$1;
(statearr_18239_18253[(2)] = inst_18218);

(statearr_18239_18253[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18233 === (6))){
var inst_18218 = (state_18232[(7)]);
var inst_18221 = (state_18232[(8)]);
var inst_18225 = f.call(null,inst_18218,inst_18221);
var inst_18218__$1 = inst_18225;
var state_18232__$1 = (function (){var statearr_18240 = state_18232;
(statearr_18240[(7)] = inst_18218__$1);

return statearr_18240;
})();
var statearr_18241_18254 = state_18232__$1;
(statearr_18241_18254[(2)] = null);

(statearr_18241_18254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18233 === (7))){
var inst_18228 = (state_18232[(2)]);
var state_18232__$1 = state_18232;
var statearr_18242_18255 = state_18232__$1;
(statearr_18242_18255[(2)] = inst_18228);

(statearr_18242_18255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__8429__auto__))
;
return ((function (switch__8364__auto__,c__8429__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__8365__auto__ = null;
var cljs$core$async$reduce_$_state_machine__8365__auto____0 = (function (){
var statearr_18246 = [null,null,null,null,null,null,null,null,null];
(statearr_18246[(0)] = cljs$core$async$reduce_$_state_machine__8365__auto__);

(statearr_18246[(1)] = (1));

return statearr_18246;
});
var cljs$core$async$reduce_$_state_machine__8365__auto____1 = (function (state_18232){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_18232);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e18247){if((e18247 instanceof Object)){
var ex__8368__auto__ = e18247;
var statearr_18248_18256 = state_18232;
(statearr_18248_18256[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18232);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18247;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18257 = state_18232;
state_18232 = G__18257;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__8365__auto__ = function(state_18232){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__8365__auto____1.call(this,state_18232);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__8365__auto____0;
cljs$core$async$reduce_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__8365__auto____1;
return cljs$core$async$reduce_$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto__))
})();
var state__8431__auto__ = (function (){var statearr_18249 = f__8430__auto__.call(null);
(statearr_18249[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto__);

return statearr_18249;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});})(c__8429__auto__))
);

return c__8429__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args18258 = [];
var len__5627__auto___18310 = arguments.length;
var i__5628__auto___18311 = (0);
while(true){
if((i__5628__auto___18311 < len__5627__auto___18310)){
args18258.push((arguments[i__5628__auto___18311]));

var G__18312 = (i__5628__auto___18311 + (1));
i__5628__auto___18311 = G__18312;
continue;
} else {
}
break;
}

var G__18260 = args18258.length;
switch (G__18260) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18258.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__8429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8429__auto__){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto__){
return (function (state_18285){
var state_val_18286 = (state_18285[(1)]);
if((state_val_18286 === (7))){
var inst_18267 = (state_18285[(2)]);
var state_18285__$1 = state_18285;
var statearr_18287_18314 = state_18285__$1;
(statearr_18287_18314[(2)] = inst_18267);

(statearr_18287_18314[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18286 === (1))){
var inst_18261 = cljs.core.seq.call(null,coll);
var inst_18262 = inst_18261;
var state_18285__$1 = (function (){var statearr_18288 = state_18285;
(statearr_18288[(7)] = inst_18262);

return statearr_18288;
})();
var statearr_18289_18315 = state_18285__$1;
(statearr_18289_18315[(2)] = null);

(statearr_18289_18315[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18286 === (4))){
var inst_18262 = (state_18285[(7)]);
var inst_18265 = cljs.core.first.call(null,inst_18262);
var state_18285__$1 = state_18285;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18285__$1,(7),ch,inst_18265);
} else {
if((state_val_18286 === (13))){
var inst_18279 = (state_18285[(2)]);
var state_18285__$1 = state_18285;
var statearr_18290_18316 = state_18285__$1;
(statearr_18290_18316[(2)] = inst_18279);

(statearr_18290_18316[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18286 === (6))){
var inst_18270 = (state_18285[(2)]);
var state_18285__$1 = state_18285;
if(cljs.core.truth_(inst_18270)){
var statearr_18291_18317 = state_18285__$1;
(statearr_18291_18317[(1)] = (8));

} else {
var statearr_18292_18318 = state_18285__$1;
(statearr_18292_18318[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18286 === (3))){
var inst_18283 = (state_18285[(2)]);
var state_18285__$1 = state_18285;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18285__$1,inst_18283);
} else {
if((state_val_18286 === (12))){
var state_18285__$1 = state_18285;
var statearr_18293_18319 = state_18285__$1;
(statearr_18293_18319[(2)] = null);

(statearr_18293_18319[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18286 === (2))){
var inst_18262 = (state_18285[(7)]);
var state_18285__$1 = state_18285;
if(cljs.core.truth_(inst_18262)){
var statearr_18294_18320 = state_18285__$1;
(statearr_18294_18320[(1)] = (4));

} else {
var statearr_18295_18321 = state_18285__$1;
(statearr_18295_18321[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18286 === (11))){
var inst_18276 = cljs.core.async.close_BANG_.call(null,ch);
var state_18285__$1 = state_18285;
var statearr_18296_18322 = state_18285__$1;
(statearr_18296_18322[(2)] = inst_18276);

(statearr_18296_18322[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18286 === (9))){
var state_18285__$1 = state_18285;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18297_18323 = state_18285__$1;
(statearr_18297_18323[(1)] = (11));

} else {
var statearr_18298_18324 = state_18285__$1;
(statearr_18298_18324[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18286 === (5))){
var inst_18262 = (state_18285[(7)]);
var state_18285__$1 = state_18285;
var statearr_18299_18325 = state_18285__$1;
(statearr_18299_18325[(2)] = inst_18262);

(statearr_18299_18325[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18286 === (10))){
var inst_18281 = (state_18285[(2)]);
var state_18285__$1 = state_18285;
var statearr_18300_18326 = state_18285__$1;
(statearr_18300_18326[(2)] = inst_18281);

(statearr_18300_18326[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18286 === (8))){
var inst_18262 = (state_18285[(7)]);
var inst_18272 = cljs.core.next.call(null,inst_18262);
var inst_18262__$1 = inst_18272;
var state_18285__$1 = (function (){var statearr_18301 = state_18285;
(statearr_18301[(7)] = inst_18262__$1);

return statearr_18301;
})();
var statearr_18302_18327 = state_18285__$1;
(statearr_18302_18327[(2)] = null);

(statearr_18302_18327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto__))
;
return ((function (switch__8364__auto__,c__8429__auto__){
return (function() {
var cljs$core$async$state_machine__8365__auto__ = null;
var cljs$core$async$state_machine__8365__auto____0 = (function (){
var statearr_18306 = [null,null,null,null,null,null,null,null];
(statearr_18306[(0)] = cljs$core$async$state_machine__8365__auto__);

(statearr_18306[(1)] = (1));

return statearr_18306;
});
var cljs$core$async$state_machine__8365__auto____1 = (function (state_18285){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_18285);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e18307){if((e18307 instanceof Object)){
var ex__8368__auto__ = e18307;
var statearr_18308_18328 = state_18285;
(statearr_18308_18328[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18285);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18307;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18329 = state_18285;
state_18285 = G__18329;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$state_machine__8365__auto__ = function(state_18285){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8365__auto____1.call(this,state_18285);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8365__auto____0;
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8365__auto____1;
return cljs$core$async$state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto__))
})();
var state__8431__auto__ = (function (){var statearr_18309 = f__8430__auto__.call(null);
(statearr_18309[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto__);

return statearr_18309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});})(c__8429__auto__))
);

return c__8429__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5224__auto__ = (((_ == null))?null:_);
var m__5225__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,_);
} else {
var m__5225__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5225__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m);
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18551 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18551 = (function (mult,ch,cs,meta18552){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta18552 = meta18552;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18551.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_18553,meta18552__$1){
var self__ = this;
var _18553__$1 = this;
return (new cljs.core.async.t_cljs$core$async18551(self__.mult,self__.ch,self__.cs,meta18552__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async18551.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_18553){
var self__ = this;
var _18553__$1 = this;
return self__.meta18552;
});})(cs))
;

cljs.core.async.t_cljs$core$async18551.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18551.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async18551.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async18551.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18551.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18551.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18551.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta18552","meta18552",412721255,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async18551.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18551.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18551";

cljs.core.async.t_cljs$core$async18551.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async18551");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async18551 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async18551(mult__$1,ch__$1,cs__$1,meta18552){
return (new cljs.core.async.t_cljs$core$async18551(mult__$1,ch__$1,cs__$1,meta18552));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async18551(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__8429__auto___18772 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8429__auto___18772,cs,m,dchan,dctr,done){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___18772,cs,m,dchan,dctr,done){
return (function (state_18684){
var state_val_18685 = (state_18684[(1)]);
if((state_val_18685 === (7))){
var inst_18680 = (state_18684[(2)]);
var state_18684__$1 = state_18684;
var statearr_18686_18773 = state_18684__$1;
(statearr_18686_18773[(2)] = inst_18680);

(statearr_18686_18773[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (20))){
var inst_18585 = (state_18684[(7)]);
var inst_18595 = cljs.core.first.call(null,inst_18585);
var inst_18596 = cljs.core.nth.call(null,inst_18595,(0),null);
var inst_18597 = cljs.core.nth.call(null,inst_18595,(1),null);
var state_18684__$1 = (function (){var statearr_18687 = state_18684;
(statearr_18687[(8)] = inst_18596);

return statearr_18687;
})();
if(cljs.core.truth_(inst_18597)){
var statearr_18688_18774 = state_18684__$1;
(statearr_18688_18774[(1)] = (22));

} else {
var statearr_18689_18775 = state_18684__$1;
(statearr_18689_18775[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (27))){
var inst_18625 = (state_18684[(9)]);
var inst_18556 = (state_18684[(10)]);
var inst_18632 = (state_18684[(11)]);
var inst_18627 = (state_18684[(12)]);
var inst_18632__$1 = cljs.core._nth.call(null,inst_18625,inst_18627);
var inst_18633 = cljs.core.async.put_BANG_.call(null,inst_18632__$1,inst_18556,done);
var state_18684__$1 = (function (){var statearr_18690 = state_18684;
(statearr_18690[(11)] = inst_18632__$1);

return statearr_18690;
})();
if(cljs.core.truth_(inst_18633)){
var statearr_18691_18776 = state_18684__$1;
(statearr_18691_18776[(1)] = (30));

} else {
var statearr_18692_18777 = state_18684__$1;
(statearr_18692_18777[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (1))){
var state_18684__$1 = state_18684;
var statearr_18693_18778 = state_18684__$1;
(statearr_18693_18778[(2)] = null);

(statearr_18693_18778[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (24))){
var inst_18585 = (state_18684[(7)]);
var inst_18602 = (state_18684[(2)]);
var inst_18603 = cljs.core.next.call(null,inst_18585);
var inst_18565 = inst_18603;
var inst_18566 = null;
var inst_18567 = (0);
var inst_18568 = (0);
var state_18684__$1 = (function (){var statearr_18694 = state_18684;
(statearr_18694[(13)] = inst_18566);

(statearr_18694[(14)] = inst_18567);

(statearr_18694[(15)] = inst_18602);

(statearr_18694[(16)] = inst_18565);

(statearr_18694[(17)] = inst_18568);

return statearr_18694;
})();
var statearr_18695_18779 = state_18684__$1;
(statearr_18695_18779[(2)] = null);

(statearr_18695_18779[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (39))){
var state_18684__$1 = state_18684;
var statearr_18699_18780 = state_18684__$1;
(statearr_18699_18780[(2)] = null);

(statearr_18699_18780[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (4))){
var inst_18556 = (state_18684[(10)]);
var inst_18556__$1 = (state_18684[(2)]);
var inst_18557 = (inst_18556__$1 == null);
var state_18684__$1 = (function (){var statearr_18700 = state_18684;
(statearr_18700[(10)] = inst_18556__$1);

return statearr_18700;
})();
if(cljs.core.truth_(inst_18557)){
var statearr_18701_18781 = state_18684__$1;
(statearr_18701_18781[(1)] = (5));

} else {
var statearr_18702_18782 = state_18684__$1;
(statearr_18702_18782[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (15))){
var inst_18566 = (state_18684[(13)]);
var inst_18567 = (state_18684[(14)]);
var inst_18565 = (state_18684[(16)]);
var inst_18568 = (state_18684[(17)]);
var inst_18581 = (state_18684[(2)]);
var inst_18582 = (inst_18568 + (1));
var tmp18696 = inst_18566;
var tmp18697 = inst_18567;
var tmp18698 = inst_18565;
var inst_18565__$1 = tmp18698;
var inst_18566__$1 = tmp18696;
var inst_18567__$1 = tmp18697;
var inst_18568__$1 = inst_18582;
var state_18684__$1 = (function (){var statearr_18703 = state_18684;
(statearr_18703[(18)] = inst_18581);

(statearr_18703[(13)] = inst_18566__$1);

(statearr_18703[(14)] = inst_18567__$1);

(statearr_18703[(16)] = inst_18565__$1);

(statearr_18703[(17)] = inst_18568__$1);

return statearr_18703;
})();
var statearr_18704_18783 = state_18684__$1;
(statearr_18704_18783[(2)] = null);

(statearr_18704_18783[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (21))){
var inst_18606 = (state_18684[(2)]);
var state_18684__$1 = state_18684;
var statearr_18708_18784 = state_18684__$1;
(statearr_18708_18784[(2)] = inst_18606);

(statearr_18708_18784[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (31))){
var inst_18632 = (state_18684[(11)]);
var inst_18636 = done.call(null,null);
var inst_18637 = cljs.core.async.untap_STAR_.call(null,m,inst_18632);
var state_18684__$1 = (function (){var statearr_18709 = state_18684;
(statearr_18709[(19)] = inst_18636);

return statearr_18709;
})();
var statearr_18710_18785 = state_18684__$1;
(statearr_18710_18785[(2)] = inst_18637);

(statearr_18710_18785[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (32))){
var inst_18625 = (state_18684[(9)]);
var inst_18626 = (state_18684[(20)]);
var inst_18624 = (state_18684[(21)]);
var inst_18627 = (state_18684[(12)]);
var inst_18639 = (state_18684[(2)]);
var inst_18640 = (inst_18627 + (1));
var tmp18705 = inst_18625;
var tmp18706 = inst_18626;
var tmp18707 = inst_18624;
var inst_18624__$1 = tmp18707;
var inst_18625__$1 = tmp18705;
var inst_18626__$1 = tmp18706;
var inst_18627__$1 = inst_18640;
var state_18684__$1 = (function (){var statearr_18711 = state_18684;
(statearr_18711[(9)] = inst_18625__$1);

(statearr_18711[(22)] = inst_18639);

(statearr_18711[(20)] = inst_18626__$1);

(statearr_18711[(21)] = inst_18624__$1);

(statearr_18711[(12)] = inst_18627__$1);

return statearr_18711;
})();
var statearr_18712_18786 = state_18684__$1;
(statearr_18712_18786[(2)] = null);

(statearr_18712_18786[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (40))){
var inst_18652 = (state_18684[(23)]);
var inst_18656 = done.call(null,null);
var inst_18657 = cljs.core.async.untap_STAR_.call(null,m,inst_18652);
var state_18684__$1 = (function (){var statearr_18713 = state_18684;
(statearr_18713[(24)] = inst_18656);

return statearr_18713;
})();
var statearr_18714_18787 = state_18684__$1;
(statearr_18714_18787[(2)] = inst_18657);

(statearr_18714_18787[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (33))){
var inst_18643 = (state_18684[(25)]);
var inst_18645 = cljs.core.chunked_seq_QMARK_.call(null,inst_18643);
var state_18684__$1 = state_18684;
if(inst_18645){
var statearr_18715_18788 = state_18684__$1;
(statearr_18715_18788[(1)] = (36));

} else {
var statearr_18716_18789 = state_18684__$1;
(statearr_18716_18789[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (13))){
var inst_18575 = (state_18684[(26)]);
var inst_18578 = cljs.core.async.close_BANG_.call(null,inst_18575);
var state_18684__$1 = state_18684;
var statearr_18717_18790 = state_18684__$1;
(statearr_18717_18790[(2)] = inst_18578);

(statearr_18717_18790[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (22))){
var inst_18596 = (state_18684[(8)]);
var inst_18599 = cljs.core.async.close_BANG_.call(null,inst_18596);
var state_18684__$1 = state_18684;
var statearr_18718_18791 = state_18684__$1;
(statearr_18718_18791[(2)] = inst_18599);

(statearr_18718_18791[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (36))){
var inst_18643 = (state_18684[(25)]);
var inst_18647 = cljs.core.chunk_first.call(null,inst_18643);
var inst_18648 = cljs.core.chunk_rest.call(null,inst_18643);
var inst_18649 = cljs.core.count.call(null,inst_18647);
var inst_18624 = inst_18648;
var inst_18625 = inst_18647;
var inst_18626 = inst_18649;
var inst_18627 = (0);
var state_18684__$1 = (function (){var statearr_18719 = state_18684;
(statearr_18719[(9)] = inst_18625);

(statearr_18719[(20)] = inst_18626);

(statearr_18719[(21)] = inst_18624);

(statearr_18719[(12)] = inst_18627);

return statearr_18719;
})();
var statearr_18720_18792 = state_18684__$1;
(statearr_18720_18792[(2)] = null);

(statearr_18720_18792[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (41))){
var inst_18643 = (state_18684[(25)]);
var inst_18659 = (state_18684[(2)]);
var inst_18660 = cljs.core.next.call(null,inst_18643);
var inst_18624 = inst_18660;
var inst_18625 = null;
var inst_18626 = (0);
var inst_18627 = (0);
var state_18684__$1 = (function (){var statearr_18721 = state_18684;
(statearr_18721[(9)] = inst_18625);

(statearr_18721[(20)] = inst_18626);

(statearr_18721[(27)] = inst_18659);

(statearr_18721[(21)] = inst_18624);

(statearr_18721[(12)] = inst_18627);

return statearr_18721;
})();
var statearr_18722_18793 = state_18684__$1;
(statearr_18722_18793[(2)] = null);

(statearr_18722_18793[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (43))){
var state_18684__$1 = state_18684;
var statearr_18723_18794 = state_18684__$1;
(statearr_18723_18794[(2)] = null);

(statearr_18723_18794[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (29))){
var inst_18668 = (state_18684[(2)]);
var state_18684__$1 = state_18684;
var statearr_18724_18795 = state_18684__$1;
(statearr_18724_18795[(2)] = inst_18668);

(statearr_18724_18795[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (44))){
var inst_18677 = (state_18684[(2)]);
var state_18684__$1 = (function (){var statearr_18725 = state_18684;
(statearr_18725[(28)] = inst_18677);

return statearr_18725;
})();
var statearr_18726_18796 = state_18684__$1;
(statearr_18726_18796[(2)] = null);

(statearr_18726_18796[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (6))){
var inst_18616 = (state_18684[(29)]);
var inst_18615 = cljs.core.deref.call(null,cs);
var inst_18616__$1 = cljs.core.keys.call(null,inst_18615);
var inst_18617 = cljs.core.count.call(null,inst_18616__$1);
var inst_18618 = cljs.core.reset_BANG_.call(null,dctr,inst_18617);
var inst_18623 = cljs.core.seq.call(null,inst_18616__$1);
var inst_18624 = inst_18623;
var inst_18625 = null;
var inst_18626 = (0);
var inst_18627 = (0);
var state_18684__$1 = (function (){var statearr_18727 = state_18684;
(statearr_18727[(9)] = inst_18625);

(statearr_18727[(30)] = inst_18618);

(statearr_18727[(29)] = inst_18616__$1);

(statearr_18727[(20)] = inst_18626);

(statearr_18727[(21)] = inst_18624);

(statearr_18727[(12)] = inst_18627);

return statearr_18727;
})();
var statearr_18728_18797 = state_18684__$1;
(statearr_18728_18797[(2)] = null);

(statearr_18728_18797[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (28))){
var inst_18643 = (state_18684[(25)]);
var inst_18624 = (state_18684[(21)]);
var inst_18643__$1 = cljs.core.seq.call(null,inst_18624);
var state_18684__$1 = (function (){var statearr_18729 = state_18684;
(statearr_18729[(25)] = inst_18643__$1);

return statearr_18729;
})();
if(inst_18643__$1){
var statearr_18730_18798 = state_18684__$1;
(statearr_18730_18798[(1)] = (33));

} else {
var statearr_18731_18799 = state_18684__$1;
(statearr_18731_18799[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (25))){
var inst_18626 = (state_18684[(20)]);
var inst_18627 = (state_18684[(12)]);
var inst_18629 = (inst_18627 < inst_18626);
var inst_18630 = inst_18629;
var state_18684__$1 = state_18684;
if(cljs.core.truth_(inst_18630)){
var statearr_18732_18800 = state_18684__$1;
(statearr_18732_18800[(1)] = (27));

} else {
var statearr_18733_18801 = state_18684__$1;
(statearr_18733_18801[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (34))){
var state_18684__$1 = state_18684;
var statearr_18734_18802 = state_18684__$1;
(statearr_18734_18802[(2)] = null);

(statearr_18734_18802[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (17))){
var state_18684__$1 = state_18684;
var statearr_18735_18803 = state_18684__$1;
(statearr_18735_18803[(2)] = null);

(statearr_18735_18803[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (3))){
var inst_18682 = (state_18684[(2)]);
var state_18684__$1 = state_18684;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18684__$1,inst_18682);
} else {
if((state_val_18685 === (12))){
var inst_18611 = (state_18684[(2)]);
var state_18684__$1 = state_18684;
var statearr_18736_18804 = state_18684__$1;
(statearr_18736_18804[(2)] = inst_18611);

(statearr_18736_18804[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (2))){
var state_18684__$1 = state_18684;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18684__$1,(4),ch);
} else {
if((state_val_18685 === (23))){
var state_18684__$1 = state_18684;
var statearr_18737_18805 = state_18684__$1;
(statearr_18737_18805[(2)] = null);

(statearr_18737_18805[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (35))){
var inst_18666 = (state_18684[(2)]);
var state_18684__$1 = state_18684;
var statearr_18738_18806 = state_18684__$1;
(statearr_18738_18806[(2)] = inst_18666);

(statearr_18738_18806[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (19))){
var inst_18585 = (state_18684[(7)]);
var inst_18589 = cljs.core.chunk_first.call(null,inst_18585);
var inst_18590 = cljs.core.chunk_rest.call(null,inst_18585);
var inst_18591 = cljs.core.count.call(null,inst_18589);
var inst_18565 = inst_18590;
var inst_18566 = inst_18589;
var inst_18567 = inst_18591;
var inst_18568 = (0);
var state_18684__$1 = (function (){var statearr_18739 = state_18684;
(statearr_18739[(13)] = inst_18566);

(statearr_18739[(14)] = inst_18567);

(statearr_18739[(16)] = inst_18565);

(statearr_18739[(17)] = inst_18568);

return statearr_18739;
})();
var statearr_18740_18807 = state_18684__$1;
(statearr_18740_18807[(2)] = null);

(statearr_18740_18807[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (11))){
var inst_18565 = (state_18684[(16)]);
var inst_18585 = (state_18684[(7)]);
var inst_18585__$1 = cljs.core.seq.call(null,inst_18565);
var state_18684__$1 = (function (){var statearr_18741 = state_18684;
(statearr_18741[(7)] = inst_18585__$1);

return statearr_18741;
})();
if(inst_18585__$1){
var statearr_18742_18808 = state_18684__$1;
(statearr_18742_18808[(1)] = (16));

} else {
var statearr_18743_18809 = state_18684__$1;
(statearr_18743_18809[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (9))){
var inst_18613 = (state_18684[(2)]);
var state_18684__$1 = state_18684;
var statearr_18744_18810 = state_18684__$1;
(statearr_18744_18810[(2)] = inst_18613);

(statearr_18744_18810[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (5))){
var inst_18563 = cljs.core.deref.call(null,cs);
var inst_18564 = cljs.core.seq.call(null,inst_18563);
var inst_18565 = inst_18564;
var inst_18566 = null;
var inst_18567 = (0);
var inst_18568 = (0);
var state_18684__$1 = (function (){var statearr_18745 = state_18684;
(statearr_18745[(13)] = inst_18566);

(statearr_18745[(14)] = inst_18567);

(statearr_18745[(16)] = inst_18565);

(statearr_18745[(17)] = inst_18568);

return statearr_18745;
})();
var statearr_18746_18811 = state_18684__$1;
(statearr_18746_18811[(2)] = null);

(statearr_18746_18811[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (14))){
var state_18684__$1 = state_18684;
var statearr_18747_18812 = state_18684__$1;
(statearr_18747_18812[(2)] = null);

(statearr_18747_18812[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (45))){
var inst_18674 = (state_18684[(2)]);
var state_18684__$1 = state_18684;
var statearr_18748_18813 = state_18684__$1;
(statearr_18748_18813[(2)] = inst_18674);

(statearr_18748_18813[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (26))){
var inst_18616 = (state_18684[(29)]);
var inst_18670 = (state_18684[(2)]);
var inst_18671 = cljs.core.seq.call(null,inst_18616);
var state_18684__$1 = (function (){var statearr_18749 = state_18684;
(statearr_18749[(31)] = inst_18670);

return statearr_18749;
})();
if(inst_18671){
var statearr_18750_18814 = state_18684__$1;
(statearr_18750_18814[(1)] = (42));

} else {
var statearr_18751_18815 = state_18684__$1;
(statearr_18751_18815[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (16))){
var inst_18585 = (state_18684[(7)]);
var inst_18587 = cljs.core.chunked_seq_QMARK_.call(null,inst_18585);
var state_18684__$1 = state_18684;
if(inst_18587){
var statearr_18752_18816 = state_18684__$1;
(statearr_18752_18816[(1)] = (19));

} else {
var statearr_18753_18817 = state_18684__$1;
(statearr_18753_18817[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (38))){
var inst_18663 = (state_18684[(2)]);
var state_18684__$1 = state_18684;
var statearr_18754_18818 = state_18684__$1;
(statearr_18754_18818[(2)] = inst_18663);

(statearr_18754_18818[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (30))){
var state_18684__$1 = state_18684;
var statearr_18755_18819 = state_18684__$1;
(statearr_18755_18819[(2)] = null);

(statearr_18755_18819[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (10))){
var inst_18566 = (state_18684[(13)]);
var inst_18568 = (state_18684[(17)]);
var inst_18574 = cljs.core._nth.call(null,inst_18566,inst_18568);
var inst_18575 = cljs.core.nth.call(null,inst_18574,(0),null);
var inst_18576 = cljs.core.nth.call(null,inst_18574,(1),null);
var state_18684__$1 = (function (){var statearr_18756 = state_18684;
(statearr_18756[(26)] = inst_18575);

return statearr_18756;
})();
if(cljs.core.truth_(inst_18576)){
var statearr_18757_18820 = state_18684__$1;
(statearr_18757_18820[(1)] = (13));

} else {
var statearr_18758_18821 = state_18684__$1;
(statearr_18758_18821[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (18))){
var inst_18609 = (state_18684[(2)]);
var state_18684__$1 = state_18684;
var statearr_18759_18822 = state_18684__$1;
(statearr_18759_18822[(2)] = inst_18609);

(statearr_18759_18822[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (42))){
var state_18684__$1 = state_18684;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18684__$1,(45),dchan);
} else {
if((state_val_18685 === (37))){
var inst_18652 = (state_18684[(23)]);
var inst_18556 = (state_18684[(10)]);
var inst_18643 = (state_18684[(25)]);
var inst_18652__$1 = cljs.core.first.call(null,inst_18643);
var inst_18653 = cljs.core.async.put_BANG_.call(null,inst_18652__$1,inst_18556,done);
var state_18684__$1 = (function (){var statearr_18760 = state_18684;
(statearr_18760[(23)] = inst_18652__$1);

return statearr_18760;
})();
if(cljs.core.truth_(inst_18653)){
var statearr_18761_18823 = state_18684__$1;
(statearr_18761_18823[(1)] = (39));

} else {
var statearr_18762_18824 = state_18684__$1;
(statearr_18762_18824[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18685 === (8))){
var inst_18567 = (state_18684[(14)]);
var inst_18568 = (state_18684[(17)]);
var inst_18570 = (inst_18568 < inst_18567);
var inst_18571 = inst_18570;
var state_18684__$1 = state_18684;
if(cljs.core.truth_(inst_18571)){
var statearr_18763_18825 = state_18684__$1;
(statearr_18763_18825[(1)] = (10));

} else {
var statearr_18764_18826 = state_18684__$1;
(statearr_18764_18826[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___18772,cs,m,dchan,dctr,done))
;
return ((function (switch__8364__auto__,c__8429__auto___18772,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__8365__auto__ = null;
var cljs$core$async$mult_$_state_machine__8365__auto____0 = (function (){
var statearr_18768 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18768[(0)] = cljs$core$async$mult_$_state_machine__8365__auto__);

(statearr_18768[(1)] = (1));

return statearr_18768;
});
var cljs$core$async$mult_$_state_machine__8365__auto____1 = (function (state_18684){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_18684);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e18769){if((e18769 instanceof Object)){
var ex__8368__auto__ = e18769;
var statearr_18770_18827 = state_18684;
(statearr_18770_18827[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18684);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18769;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18828 = state_18684;
state_18684 = G__18828;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__8365__auto__ = function(state_18684){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__8365__auto____1.call(this,state_18684);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__8365__auto____0;
cljs$core$async$mult_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__8365__auto____1;
return cljs$core$async$mult_$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___18772,cs,m,dchan,dctr,done))
})();
var state__8431__auto__ = (function (){var statearr_18771 = f__8430__auto__.call(null);
(statearr_18771[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___18772);

return statearr_18771;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});})(c__8429__auto___18772,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args18829 = [];
var len__5627__auto___18832 = arguments.length;
var i__5628__auto___18833 = (0);
while(true){
if((i__5628__auto___18833 < len__5627__auto___18832)){
args18829.push((arguments[i__5628__auto___18833]));

var G__18834 = (i__5628__auto___18833 + (1));
i__5628__auto___18833 = G__18834;
continue;
} else {
}
break;
}

var G__18831 = args18829.length;
switch (G__18831) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18829.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m);
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,state_map);
} else {
var m__5225__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,mode);
} else {
var m__5225__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___18846 = arguments.length;
var i__5628__auto___18847 = (0);
while(true){
if((i__5628__auto___18847 < len__5627__auto___18846)){
args__5634__auto__.push((arguments[i__5628__auto___18847]));

var G__18848 = (i__5628__auto___18847 + (1));
i__5628__auto___18847 = G__18848;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((3) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5635__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__18840){
var map__18841 = p__18840;
var map__18841__$1 = ((((!((map__18841 == null)))?((((map__18841.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18841.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18841):map__18841);
var opts = map__18841__$1;
var statearr_18843_18849 = state;
(statearr_18843_18849[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__18841,map__18841__$1,opts){
return (function (val){
var statearr_18844_18850 = state;
(statearr_18844_18850[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__18841,map__18841__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_18845_18851 = state;
(statearr_18845_18851[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq18836){
var G__18837 = cljs.core.first.call(null,seq18836);
var seq18836__$1 = cljs.core.next.call(null,seq18836);
var G__18838 = cljs.core.first.call(null,seq18836__$1);
var seq18836__$2 = cljs.core.next.call(null,seq18836__$1);
var G__18839 = cljs.core.first.call(null,seq18836__$2);
var seq18836__$3 = cljs.core.next.call(null,seq18836__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18837,G__18838,G__18839,seq18836__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async19015 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19015 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta19016){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta19016 = meta19016;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19015.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_19017,meta19016__$1){
var self__ = this;
var _19017__$1 = this;
return (new cljs.core.async.t_cljs$core$async19015(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta19016__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19015.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_19017){
var self__ = this;
var _19017__$1 = this;
return self__.meta19016;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19015.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19015.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19015.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async19015.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19015.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19015.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19015.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19015.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19015.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta19016","meta19016",1798924835,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19015.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19015.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19015";

cljs.core.async.t_cljs$core$async19015.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async19015");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async19015 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async19015(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta19016){
return (new cljs.core.async.t_cljs$core$async19015(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta19016));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async19015(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8429__auto___19178 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8429__auto___19178,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___19178,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_19115){
var state_val_19116 = (state_19115[(1)]);
if((state_val_19116 === (7))){
var inst_19033 = (state_19115[(2)]);
var state_19115__$1 = state_19115;
var statearr_19117_19179 = state_19115__$1;
(statearr_19117_19179[(2)] = inst_19033);

(statearr_19117_19179[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (20))){
var inst_19045 = (state_19115[(7)]);
var state_19115__$1 = state_19115;
var statearr_19118_19180 = state_19115__$1;
(statearr_19118_19180[(2)] = inst_19045);

(statearr_19118_19180[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (27))){
var state_19115__$1 = state_19115;
var statearr_19119_19181 = state_19115__$1;
(statearr_19119_19181[(2)] = null);

(statearr_19119_19181[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (1))){
var inst_19021 = (state_19115[(8)]);
var inst_19021__$1 = calc_state.call(null);
var inst_19023 = (inst_19021__$1 == null);
var inst_19024 = cljs.core.not.call(null,inst_19023);
var state_19115__$1 = (function (){var statearr_19120 = state_19115;
(statearr_19120[(8)] = inst_19021__$1);

return statearr_19120;
})();
if(inst_19024){
var statearr_19121_19182 = state_19115__$1;
(statearr_19121_19182[(1)] = (2));

} else {
var statearr_19122_19183 = state_19115__$1;
(statearr_19122_19183[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (24))){
var inst_19075 = (state_19115[(9)]);
var inst_19068 = (state_19115[(10)]);
var inst_19089 = (state_19115[(11)]);
var inst_19089__$1 = inst_19068.call(null,inst_19075);
var state_19115__$1 = (function (){var statearr_19123 = state_19115;
(statearr_19123[(11)] = inst_19089__$1);

return statearr_19123;
})();
if(cljs.core.truth_(inst_19089__$1)){
var statearr_19124_19184 = state_19115__$1;
(statearr_19124_19184[(1)] = (29));

} else {
var statearr_19125_19185 = state_19115__$1;
(statearr_19125_19185[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (4))){
var inst_19036 = (state_19115[(2)]);
var state_19115__$1 = state_19115;
if(cljs.core.truth_(inst_19036)){
var statearr_19126_19186 = state_19115__$1;
(statearr_19126_19186[(1)] = (8));

} else {
var statearr_19127_19187 = state_19115__$1;
(statearr_19127_19187[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (15))){
var inst_19062 = (state_19115[(2)]);
var state_19115__$1 = state_19115;
if(cljs.core.truth_(inst_19062)){
var statearr_19128_19188 = state_19115__$1;
(statearr_19128_19188[(1)] = (19));

} else {
var statearr_19129_19189 = state_19115__$1;
(statearr_19129_19189[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (21))){
var inst_19067 = (state_19115[(12)]);
var inst_19067__$1 = (state_19115[(2)]);
var inst_19068 = cljs.core.get.call(null,inst_19067__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_19069 = cljs.core.get.call(null,inst_19067__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_19070 = cljs.core.get.call(null,inst_19067__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_19115__$1 = (function (){var statearr_19130 = state_19115;
(statearr_19130[(13)] = inst_19069);

(statearr_19130[(12)] = inst_19067__$1);

(statearr_19130[(10)] = inst_19068);

return statearr_19130;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_19115__$1,(22),inst_19070);
} else {
if((state_val_19116 === (31))){
var inst_19097 = (state_19115[(2)]);
var state_19115__$1 = state_19115;
if(cljs.core.truth_(inst_19097)){
var statearr_19131_19190 = state_19115__$1;
(statearr_19131_19190[(1)] = (32));

} else {
var statearr_19132_19191 = state_19115__$1;
(statearr_19132_19191[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (32))){
var inst_19074 = (state_19115[(14)]);
var state_19115__$1 = state_19115;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19115__$1,(35),out,inst_19074);
} else {
if((state_val_19116 === (33))){
var inst_19067 = (state_19115[(12)]);
var inst_19045 = inst_19067;
var state_19115__$1 = (function (){var statearr_19133 = state_19115;
(statearr_19133[(7)] = inst_19045);

return statearr_19133;
})();
var statearr_19134_19192 = state_19115__$1;
(statearr_19134_19192[(2)] = null);

(statearr_19134_19192[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (13))){
var inst_19045 = (state_19115[(7)]);
var inst_19052 = inst_19045.cljs$lang$protocol_mask$partition0$;
var inst_19053 = (inst_19052 & (64));
var inst_19054 = inst_19045.cljs$core$ISeq$;
var inst_19055 = (inst_19053) || (inst_19054);
var state_19115__$1 = state_19115;
if(cljs.core.truth_(inst_19055)){
var statearr_19135_19193 = state_19115__$1;
(statearr_19135_19193[(1)] = (16));

} else {
var statearr_19136_19194 = state_19115__$1;
(statearr_19136_19194[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (22))){
var inst_19075 = (state_19115[(9)]);
var inst_19074 = (state_19115[(14)]);
var inst_19073 = (state_19115[(2)]);
var inst_19074__$1 = cljs.core.nth.call(null,inst_19073,(0),null);
var inst_19075__$1 = cljs.core.nth.call(null,inst_19073,(1),null);
var inst_19076 = (inst_19074__$1 == null);
var inst_19077 = cljs.core._EQ_.call(null,inst_19075__$1,change);
var inst_19078 = (inst_19076) || (inst_19077);
var state_19115__$1 = (function (){var statearr_19137 = state_19115;
(statearr_19137[(9)] = inst_19075__$1);

(statearr_19137[(14)] = inst_19074__$1);

return statearr_19137;
})();
if(cljs.core.truth_(inst_19078)){
var statearr_19138_19195 = state_19115__$1;
(statearr_19138_19195[(1)] = (23));

} else {
var statearr_19139_19196 = state_19115__$1;
(statearr_19139_19196[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (36))){
var inst_19067 = (state_19115[(12)]);
var inst_19045 = inst_19067;
var state_19115__$1 = (function (){var statearr_19140 = state_19115;
(statearr_19140[(7)] = inst_19045);

return statearr_19140;
})();
var statearr_19141_19197 = state_19115__$1;
(statearr_19141_19197[(2)] = null);

(statearr_19141_19197[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (29))){
var inst_19089 = (state_19115[(11)]);
var state_19115__$1 = state_19115;
var statearr_19142_19198 = state_19115__$1;
(statearr_19142_19198[(2)] = inst_19089);

(statearr_19142_19198[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (6))){
var state_19115__$1 = state_19115;
var statearr_19143_19199 = state_19115__$1;
(statearr_19143_19199[(2)] = false);

(statearr_19143_19199[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (28))){
var inst_19085 = (state_19115[(2)]);
var inst_19086 = calc_state.call(null);
var inst_19045 = inst_19086;
var state_19115__$1 = (function (){var statearr_19144 = state_19115;
(statearr_19144[(7)] = inst_19045);

(statearr_19144[(15)] = inst_19085);

return statearr_19144;
})();
var statearr_19145_19200 = state_19115__$1;
(statearr_19145_19200[(2)] = null);

(statearr_19145_19200[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (25))){
var inst_19111 = (state_19115[(2)]);
var state_19115__$1 = state_19115;
var statearr_19146_19201 = state_19115__$1;
(statearr_19146_19201[(2)] = inst_19111);

(statearr_19146_19201[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (34))){
var inst_19109 = (state_19115[(2)]);
var state_19115__$1 = state_19115;
var statearr_19147_19202 = state_19115__$1;
(statearr_19147_19202[(2)] = inst_19109);

(statearr_19147_19202[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (17))){
var state_19115__$1 = state_19115;
var statearr_19148_19203 = state_19115__$1;
(statearr_19148_19203[(2)] = false);

(statearr_19148_19203[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (3))){
var state_19115__$1 = state_19115;
var statearr_19149_19204 = state_19115__$1;
(statearr_19149_19204[(2)] = false);

(statearr_19149_19204[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (12))){
var inst_19113 = (state_19115[(2)]);
var state_19115__$1 = state_19115;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19115__$1,inst_19113);
} else {
if((state_val_19116 === (2))){
var inst_19021 = (state_19115[(8)]);
var inst_19026 = inst_19021.cljs$lang$protocol_mask$partition0$;
var inst_19027 = (inst_19026 & (64));
var inst_19028 = inst_19021.cljs$core$ISeq$;
var inst_19029 = (inst_19027) || (inst_19028);
var state_19115__$1 = state_19115;
if(cljs.core.truth_(inst_19029)){
var statearr_19150_19205 = state_19115__$1;
(statearr_19150_19205[(1)] = (5));

} else {
var statearr_19151_19206 = state_19115__$1;
(statearr_19151_19206[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (23))){
var inst_19074 = (state_19115[(14)]);
var inst_19080 = (inst_19074 == null);
var state_19115__$1 = state_19115;
if(cljs.core.truth_(inst_19080)){
var statearr_19152_19207 = state_19115__$1;
(statearr_19152_19207[(1)] = (26));

} else {
var statearr_19153_19208 = state_19115__$1;
(statearr_19153_19208[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (35))){
var inst_19100 = (state_19115[(2)]);
var state_19115__$1 = state_19115;
if(cljs.core.truth_(inst_19100)){
var statearr_19154_19209 = state_19115__$1;
(statearr_19154_19209[(1)] = (36));

} else {
var statearr_19155_19210 = state_19115__$1;
(statearr_19155_19210[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (19))){
var inst_19045 = (state_19115[(7)]);
var inst_19064 = cljs.core.apply.call(null,cljs.core.hash_map,inst_19045);
var state_19115__$1 = state_19115;
var statearr_19156_19211 = state_19115__$1;
(statearr_19156_19211[(2)] = inst_19064);

(statearr_19156_19211[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (11))){
var inst_19045 = (state_19115[(7)]);
var inst_19049 = (inst_19045 == null);
var inst_19050 = cljs.core.not.call(null,inst_19049);
var state_19115__$1 = state_19115;
if(inst_19050){
var statearr_19157_19212 = state_19115__$1;
(statearr_19157_19212[(1)] = (13));

} else {
var statearr_19158_19213 = state_19115__$1;
(statearr_19158_19213[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (9))){
var inst_19021 = (state_19115[(8)]);
var state_19115__$1 = state_19115;
var statearr_19159_19214 = state_19115__$1;
(statearr_19159_19214[(2)] = inst_19021);

(statearr_19159_19214[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (5))){
var state_19115__$1 = state_19115;
var statearr_19160_19215 = state_19115__$1;
(statearr_19160_19215[(2)] = true);

(statearr_19160_19215[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (14))){
var state_19115__$1 = state_19115;
var statearr_19161_19216 = state_19115__$1;
(statearr_19161_19216[(2)] = false);

(statearr_19161_19216[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (26))){
var inst_19075 = (state_19115[(9)]);
var inst_19082 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_19075);
var state_19115__$1 = state_19115;
var statearr_19162_19217 = state_19115__$1;
(statearr_19162_19217[(2)] = inst_19082);

(statearr_19162_19217[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (16))){
var state_19115__$1 = state_19115;
var statearr_19163_19218 = state_19115__$1;
(statearr_19163_19218[(2)] = true);

(statearr_19163_19218[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (38))){
var inst_19105 = (state_19115[(2)]);
var state_19115__$1 = state_19115;
var statearr_19164_19219 = state_19115__$1;
(statearr_19164_19219[(2)] = inst_19105);

(statearr_19164_19219[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (30))){
var inst_19075 = (state_19115[(9)]);
var inst_19069 = (state_19115[(13)]);
var inst_19068 = (state_19115[(10)]);
var inst_19092 = cljs.core.empty_QMARK_.call(null,inst_19068);
var inst_19093 = inst_19069.call(null,inst_19075);
var inst_19094 = cljs.core.not.call(null,inst_19093);
var inst_19095 = (inst_19092) && (inst_19094);
var state_19115__$1 = state_19115;
var statearr_19165_19220 = state_19115__$1;
(statearr_19165_19220[(2)] = inst_19095);

(statearr_19165_19220[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (10))){
var inst_19021 = (state_19115[(8)]);
var inst_19041 = (state_19115[(2)]);
var inst_19042 = cljs.core.get.call(null,inst_19041,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_19043 = cljs.core.get.call(null,inst_19041,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_19044 = cljs.core.get.call(null,inst_19041,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_19045 = inst_19021;
var state_19115__$1 = (function (){var statearr_19166 = state_19115;
(statearr_19166[(16)] = inst_19043);

(statearr_19166[(7)] = inst_19045);

(statearr_19166[(17)] = inst_19042);

(statearr_19166[(18)] = inst_19044);

return statearr_19166;
})();
var statearr_19167_19221 = state_19115__$1;
(statearr_19167_19221[(2)] = null);

(statearr_19167_19221[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (18))){
var inst_19059 = (state_19115[(2)]);
var state_19115__$1 = state_19115;
var statearr_19168_19222 = state_19115__$1;
(statearr_19168_19222[(2)] = inst_19059);

(statearr_19168_19222[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (37))){
var state_19115__$1 = state_19115;
var statearr_19169_19223 = state_19115__$1;
(statearr_19169_19223[(2)] = null);

(statearr_19169_19223[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19116 === (8))){
var inst_19021 = (state_19115[(8)]);
var inst_19038 = cljs.core.apply.call(null,cljs.core.hash_map,inst_19021);
var state_19115__$1 = state_19115;
var statearr_19170_19224 = state_19115__$1;
(statearr_19170_19224[(2)] = inst_19038);

(statearr_19170_19224[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___19178,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__8364__auto__,c__8429__auto___19178,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__8365__auto__ = null;
var cljs$core$async$mix_$_state_machine__8365__auto____0 = (function (){
var statearr_19174 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19174[(0)] = cljs$core$async$mix_$_state_machine__8365__auto__);

(statearr_19174[(1)] = (1));

return statearr_19174;
});
var cljs$core$async$mix_$_state_machine__8365__auto____1 = (function (state_19115){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_19115);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e19175){if((e19175 instanceof Object)){
var ex__8368__auto__ = e19175;
var statearr_19176_19225 = state_19115;
(statearr_19176_19225[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19115);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19175;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19226 = state_19115;
state_19115 = G__19226;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__8365__auto__ = function(state_19115){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__8365__auto____1.call(this,state_19115);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__8365__auto____0;
cljs$core$async$mix_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__8365__auto____1;
return cljs$core$async$mix_$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___19178,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__8431__auto__ = (function (){var statearr_19177 = f__8430__auto__.call(null);
(statearr_19177[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___19178);

return statearr_19177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});})(c__8429__auto___19178,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5225__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p,v,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args19227 = [];
var len__5627__auto___19230 = arguments.length;
var i__5628__auto___19231 = (0);
while(true){
if((i__5628__auto___19231 < len__5627__auto___19230)){
args19227.push((arguments[i__5628__auto___19231]));

var G__19232 = (i__5628__auto___19231 + (1));
i__5628__auto___19231 = G__19232;
continue;
} else {
}
break;
}

var G__19229 = args19227.length;
switch (G__19229) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19227.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p);
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p,v);
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args19235 = [];
var len__5627__auto___19360 = arguments.length;
var i__5628__auto___19361 = (0);
while(true){
if((i__5628__auto___19361 < len__5627__auto___19360)){
args19235.push((arguments[i__5628__auto___19361]));

var G__19362 = (i__5628__auto___19361 + (1));
i__5628__auto___19361 = G__19362;
continue;
} else {
}
break;
}

var G__19237 = args19235.length;
switch (G__19237) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19235.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4569__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4569__auto__,mults){
return (function (p1__19234_SHARP_){
if(cljs.core.truth_(p1__19234_SHARP_.call(null,topic))){
return p1__19234_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__19234_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4569__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async19238 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19238 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta19239){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta19239 = meta19239;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19238.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_19240,meta19239__$1){
var self__ = this;
var _19240__$1 = this;
return (new cljs.core.async.t_cljs$core$async19238(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta19239__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19238.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_19240){
var self__ = this;
var _19240__$1 = this;
return self__.meta19239;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19238.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19238.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19238.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async19238.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19238.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19238.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19238.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19238.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta19239","meta19239",581127856,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19238.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19238.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19238";

cljs.core.async.t_cljs$core$async19238.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async19238");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async19238 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async19238(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19239){
return (new cljs.core.async.t_cljs$core$async19238(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19239));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async19238(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8429__auto___19364 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8429__auto___19364,mults,ensure_mult,p){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___19364,mults,ensure_mult,p){
return (function (state_19312){
var state_val_19313 = (state_19312[(1)]);
if((state_val_19313 === (7))){
var inst_19308 = (state_19312[(2)]);
var state_19312__$1 = state_19312;
var statearr_19314_19365 = state_19312__$1;
(statearr_19314_19365[(2)] = inst_19308);

(statearr_19314_19365[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19313 === (20))){
var state_19312__$1 = state_19312;
var statearr_19315_19366 = state_19312__$1;
(statearr_19315_19366[(2)] = null);

(statearr_19315_19366[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19313 === (1))){
var state_19312__$1 = state_19312;
var statearr_19316_19367 = state_19312__$1;
(statearr_19316_19367[(2)] = null);

(statearr_19316_19367[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19313 === (24))){
var inst_19291 = (state_19312[(7)]);
var inst_19300 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_19291);
var state_19312__$1 = state_19312;
var statearr_19317_19368 = state_19312__$1;
(statearr_19317_19368[(2)] = inst_19300);

(statearr_19317_19368[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19313 === (4))){
var inst_19243 = (state_19312[(8)]);
var inst_19243__$1 = (state_19312[(2)]);
var inst_19244 = (inst_19243__$1 == null);
var state_19312__$1 = (function (){var statearr_19318 = state_19312;
(statearr_19318[(8)] = inst_19243__$1);

return statearr_19318;
})();
if(cljs.core.truth_(inst_19244)){
var statearr_19319_19369 = state_19312__$1;
(statearr_19319_19369[(1)] = (5));

} else {
var statearr_19320_19370 = state_19312__$1;
(statearr_19320_19370[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19313 === (15))){
var inst_19285 = (state_19312[(2)]);
var state_19312__$1 = state_19312;
var statearr_19321_19371 = state_19312__$1;
(statearr_19321_19371[(2)] = inst_19285);

(statearr_19321_19371[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19313 === (21))){
var inst_19305 = (state_19312[(2)]);
var state_19312__$1 = (function (){var statearr_19322 = state_19312;
(statearr_19322[(9)] = inst_19305);

return statearr_19322;
})();
var statearr_19323_19372 = state_19312__$1;
(statearr_19323_19372[(2)] = null);

(statearr_19323_19372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19313 === (13))){
var inst_19267 = (state_19312[(10)]);
var inst_19269 = cljs.core.chunked_seq_QMARK_.call(null,inst_19267);
var state_19312__$1 = state_19312;
if(inst_19269){
var statearr_19324_19373 = state_19312__$1;
(statearr_19324_19373[(1)] = (16));

} else {
var statearr_19325_19374 = state_19312__$1;
(statearr_19325_19374[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19313 === (22))){
var inst_19297 = (state_19312[(2)]);
var state_19312__$1 = state_19312;
if(cljs.core.truth_(inst_19297)){
var statearr_19326_19375 = state_19312__$1;
(statearr_19326_19375[(1)] = (23));

} else {
var statearr_19327_19376 = state_19312__$1;
(statearr_19327_19376[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19313 === (6))){
var inst_19243 = (state_19312[(8)]);
var inst_19293 = (state_19312[(11)]);
var inst_19291 = (state_19312[(7)]);
var inst_19291__$1 = topic_fn.call(null,inst_19243);
var inst_19292 = cljs.core.deref.call(null,mults);
var inst_19293__$1 = cljs.core.get.call(null,inst_19292,inst_19291__$1);
var state_19312__$1 = (function (){var statearr_19328 = state_19312;
(statearr_19328[(11)] = inst_19293__$1);

(statearr_19328[(7)] = inst_19291__$1);

return statearr_19328;
})();
if(cljs.core.truth_(inst_19293__$1)){
var statearr_19329_19377 = state_19312__$1;
(statearr_19329_19377[(1)] = (19));

} else {
var statearr_19330_19378 = state_19312__$1;
(statearr_19330_19378[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19313 === (25))){
var inst_19302 = (state_19312[(2)]);
var state_19312__$1 = state_19312;
var statearr_19331_19379 = state_19312__$1;
(statearr_19331_19379[(2)] = inst_19302);

(statearr_19331_19379[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19313 === (17))){
var inst_19267 = (state_19312[(10)]);
var inst_19276 = cljs.core.first.call(null,inst_19267);
var inst_19277 = cljs.core.async.muxch_STAR_.call(null,inst_19276);
var inst_19278 = cljs.core.async.close_BANG_.call(null,inst_19277);
var inst_19279 = cljs.core.next.call(null,inst_19267);
var inst_19253 = inst_19279;
var inst_19254 = null;
var inst_19255 = (0);
var inst_19256 = (0);
var state_19312__$1 = (function (){var statearr_19332 = state_19312;
(statearr_19332[(12)] = inst_19256);

(statearr_19332[(13)] = inst_19254);

(statearr_19332[(14)] = inst_19253);

(statearr_19332[(15)] = inst_19255);

(statearr_19332[(16)] = inst_19278);

return statearr_19332;
})();
var statearr_19333_19380 = state_19312__$1;
(statearr_19333_19380[(2)] = null);

(statearr_19333_19380[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19313 === (3))){
var inst_19310 = (state_19312[(2)]);
var state_19312__$1 = state_19312;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19312__$1,inst_19310);
} else {
if((state_val_19313 === (12))){
var inst_19287 = (state_19312[(2)]);
var state_19312__$1 = state_19312;
var statearr_19334_19381 = state_19312__$1;
(statearr_19334_19381[(2)] = inst_19287);

(statearr_19334_19381[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19313 === (2))){
var state_19312__$1 = state_19312;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19312__$1,(4),ch);
} else {
if((state_val_19313 === (23))){
var state_19312__$1 = state_19312;
var statearr_19335_19382 = state_19312__$1;
(statearr_19335_19382[(2)] = null);

(statearr_19335_19382[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19313 === (19))){
var inst_19243 = (state_19312[(8)]);
var inst_19293 = (state_19312[(11)]);
var inst_19295 = cljs.core.async.muxch_STAR_.call(null,inst_19293);
var state_19312__$1 = state_19312;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19312__$1,(22),inst_19295,inst_19243);
} else {
if((state_val_19313 === (11))){
var inst_19253 = (state_19312[(14)]);
var inst_19267 = (state_19312[(10)]);
var inst_19267__$1 = cljs.core.seq.call(null,inst_19253);
var state_19312__$1 = (function (){var statearr_19336 = state_19312;
(statearr_19336[(10)] = inst_19267__$1);

return statearr_19336;
})();
if(inst_19267__$1){
var statearr_19337_19383 = state_19312__$1;
(statearr_19337_19383[(1)] = (13));

} else {
var statearr_19338_19384 = state_19312__$1;
(statearr_19338_19384[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19313 === (9))){
var inst_19289 = (state_19312[(2)]);
var state_19312__$1 = state_19312;
var statearr_19339_19385 = state_19312__$1;
(statearr_19339_19385[(2)] = inst_19289);

(statearr_19339_19385[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19313 === (5))){
var inst_19250 = cljs.core.deref.call(null,mults);
var inst_19251 = cljs.core.vals.call(null,inst_19250);
var inst_19252 = cljs.core.seq.call(null,inst_19251);
var inst_19253 = inst_19252;
var inst_19254 = null;
var inst_19255 = (0);
var inst_19256 = (0);
var state_19312__$1 = (function (){var statearr_19340 = state_19312;
(statearr_19340[(12)] = inst_19256);

(statearr_19340[(13)] = inst_19254);

(statearr_19340[(14)] = inst_19253);

(statearr_19340[(15)] = inst_19255);

return statearr_19340;
})();
var statearr_19341_19386 = state_19312__$1;
(statearr_19341_19386[(2)] = null);

(statearr_19341_19386[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19313 === (14))){
var state_19312__$1 = state_19312;
var statearr_19345_19387 = state_19312__$1;
(statearr_19345_19387[(2)] = null);

(statearr_19345_19387[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19313 === (16))){
var inst_19267 = (state_19312[(10)]);
var inst_19271 = cljs.core.chunk_first.call(null,inst_19267);
var inst_19272 = cljs.core.chunk_rest.call(null,inst_19267);
var inst_19273 = cljs.core.count.call(null,inst_19271);
var inst_19253 = inst_19272;
var inst_19254 = inst_19271;
var inst_19255 = inst_19273;
var inst_19256 = (0);
var state_19312__$1 = (function (){var statearr_19346 = state_19312;
(statearr_19346[(12)] = inst_19256);

(statearr_19346[(13)] = inst_19254);

(statearr_19346[(14)] = inst_19253);

(statearr_19346[(15)] = inst_19255);

return statearr_19346;
})();
var statearr_19347_19388 = state_19312__$1;
(statearr_19347_19388[(2)] = null);

(statearr_19347_19388[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19313 === (10))){
var inst_19256 = (state_19312[(12)]);
var inst_19254 = (state_19312[(13)]);
var inst_19253 = (state_19312[(14)]);
var inst_19255 = (state_19312[(15)]);
var inst_19261 = cljs.core._nth.call(null,inst_19254,inst_19256);
var inst_19262 = cljs.core.async.muxch_STAR_.call(null,inst_19261);
var inst_19263 = cljs.core.async.close_BANG_.call(null,inst_19262);
var inst_19264 = (inst_19256 + (1));
var tmp19342 = inst_19254;
var tmp19343 = inst_19253;
var tmp19344 = inst_19255;
var inst_19253__$1 = tmp19343;
var inst_19254__$1 = tmp19342;
var inst_19255__$1 = tmp19344;
var inst_19256__$1 = inst_19264;
var state_19312__$1 = (function (){var statearr_19348 = state_19312;
(statearr_19348[(12)] = inst_19256__$1);

(statearr_19348[(13)] = inst_19254__$1);

(statearr_19348[(14)] = inst_19253__$1);

(statearr_19348[(15)] = inst_19255__$1);

(statearr_19348[(17)] = inst_19263);

return statearr_19348;
})();
var statearr_19349_19389 = state_19312__$1;
(statearr_19349_19389[(2)] = null);

(statearr_19349_19389[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19313 === (18))){
var inst_19282 = (state_19312[(2)]);
var state_19312__$1 = state_19312;
var statearr_19350_19390 = state_19312__$1;
(statearr_19350_19390[(2)] = inst_19282);

(statearr_19350_19390[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19313 === (8))){
var inst_19256 = (state_19312[(12)]);
var inst_19255 = (state_19312[(15)]);
var inst_19258 = (inst_19256 < inst_19255);
var inst_19259 = inst_19258;
var state_19312__$1 = state_19312;
if(cljs.core.truth_(inst_19259)){
var statearr_19351_19391 = state_19312__$1;
(statearr_19351_19391[(1)] = (10));

} else {
var statearr_19352_19392 = state_19312__$1;
(statearr_19352_19392[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___19364,mults,ensure_mult,p))
;
return ((function (switch__8364__auto__,c__8429__auto___19364,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__8365__auto__ = null;
var cljs$core$async$state_machine__8365__auto____0 = (function (){
var statearr_19356 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19356[(0)] = cljs$core$async$state_machine__8365__auto__);

(statearr_19356[(1)] = (1));

return statearr_19356;
});
var cljs$core$async$state_machine__8365__auto____1 = (function (state_19312){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_19312);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e19357){if((e19357 instanceof Object)){
var ex__8368__auto__ = e19357;
var statearr_19358_19393 = state_19312;
(statearr_19358_19393[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19312);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19357;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19394 = state_19312;
state_19312 = G__19394;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$state_machine__8365__auto__ = function(state_19312){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8365__auto____1.call(this,state_19312);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8365__auto____0;
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8365__auto____1;
return cljs$core$async$state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___19364,mults,ensure_mult,p))
})();
var state__8431__auto__ = (function (){var statearr_19359 = f__8430__auto__.call(null);
(statearr_19359[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___19364);

return statearr_19359;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});})(c__8429__auto___19364,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args19395 = [];
var len__5627__auto___19398 = arguments.length;
var i__5628__auto___19399 = (0);
while(true){
if((i__5628__auto___19399 < len__5627__auto___19398)){
args19395.push((arguments[i__5628__auto___19399]));

var G__19400 = (i__5628__auto___19399 + (1));
i__5628__auto___19399 = G__19400;
continue;
} else {
}
break;
}

var G__19397 = args19395.length;
switch (G__19397) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19395.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args19402 = [];
var len__5627__auto___19405 = arguments.length;
var i__5628__auto___19406 = (0);
while(true){
if((i__5628__auto___19406 < len__5627__auto___19405)){
args19402.push((arguments[i__5628__auto___19406]));

var G__19407 = (i__5628__auto___19406 + (1));
i__5628__auto___19406 = G__19407;
continue;
} else {
}
break;
}

var G__19404 = args19402.length;
switch (G__19404) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19402.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args19409 = [];
var len__5627__auto___19480 = arguments.length;
var i__5628__auto___19481 = (0);
while(true){
if((i__5628__auto___19481 < len__5627__auto___19480)){
args19409.push((arguments[i__5628__auto___19481]));

var G__19482 = (i__5628__auto___19481 + (1));
i__5628__auto___19481 = G__19482;
continue;
} else {
}
break;
}

var G__19411 = args19409.length;
switch (G__19411) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19409.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__8429__auto___19484 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8429__auto___19484,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___19484,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_19450){
var state_val_19451 = (state_19450[(1)]);
if((state_val_19451 === (7))){
var state_19450__$1 = state_19450;
var statearr_19452_19485 = state_19450__$1;
(statearr_19452_19485[(2)] = null);

(statearr_19452_19485[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19451 === (1))){
var state_19450__$1 = state_19450;
var statearr_19453_19486 = state_19450__$1;
(statearr_19453_19486[(2)] = null);

(statearr_19453_19486[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19451 === (4))){
var inst_19414 = (state_19450[(7)]);
var inst_19416 = (inst_19414 < cnt);
var state_19450__$1 = state_19450;
if(cljs.core.truth_(inst_19416)){
var statearr_19454_19487 = state_19450__$1;
(statearr_19454_19487[(1)] = (6));

} else {
var statearr_19455_19488 = state_19450__$1;
(statearr_19455_19488[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19451 === (15))){
var inst_19446 = (state_19450[(2)]);
var state_19450__$1 = state_19450;
var statearr_19456_19489 = state_19450__$1;
(statearr_19456_19489[(2)] = inst_19446);

(statearr_19456_19489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19451 === (13))){
var inst_19439 = cljs.core.async.close_BANG_.call(null,out);
var state_19450__$1 = state_19450;
var statearr_19457_19490 = state_19450__$1;
(statearr_19457_19490[(2)] = inst_19439);

(statearr_19457_19490[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19451 === (6))){
var state_19450__$1 = state_19450;
var statearr_19458_19491 = state_19450__$1;
(statearr_19458_19491[(2)] = null);

(statearr_19458_19491[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19451 === (3))){
var inst_19448 = (state_19450[(2)]);
var state_19450__$1 = state_19450;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19450__$1,inst_19448);
} else {
if((state_val_19451 === (12))){
var inst_19436 = (state_19450[(8)]);
var inst_19436__$1 = (state_19450[(2)]);
var inst_19437 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_19436__$1);
var state_19450__$1 = (function (){var statearr_19459 = state_19450;
(statearr_19459[(8)] = inst_19436__$1);

return statearr_19459;
})();
if(cljs.core.truth_(inst_19437)){
var statearr_19460_19492 = state_19450__$1;
(statearr_19460_19492[(1)] = (13));

} else {
var statearr_19461_19493 = state_19450__$1;
(statearr_19461_19493[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19451 === (2))){
var inst_19413 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_19414 = (0);
var state_19450__$1 = (function (){var statearr_19462 = state_19450;
(statearr_19462[(9)] = inst_19413);

(statearr_19462[(7)] = inst_19414);

return statearr_19462;
})();
var statearr_19463_19494 = state_19450__$1;
(statearr_19463_19494[(2)] = null);

(statearr_19463_19494[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19451 === (11))){
var inst_19414 = (state_19450[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_19450,(10),Object,null,(9));
var inst_19423 = chs__$1.call(null,inst_19414);
var inst_19424 = done.call(null,inst_19414);
var inst_19425 = cljs.core.async.take_BANG_.call(null,inst_19423,inst_19424);
var state_19450__$1 = state_19450;
var statearr_19464_19495 = state_19450__$1;
(statearr_19464_19495[(2)] = inst_19425);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19450__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19451 === (9))){
var inst_19414 = (state_19450[(7)]);
var inst_19427 = (state_19450[(2)]);
var inst_19428 = (inst_19414 + (1));
var inst_19414__$1 = inst_19428;
var state_19450__$1 = (function (){var statearr_19465 = state_19450;
(statearr_19465[(10)] = inst_19427);

(statearr_19465[(7)] = inst_19414__$1);

return statearr_19465;
})();
var statearr_19466_19496 = state_19450__$1;
(statearr_19466_19496[(2)] = null);

(statearr_19466_19496[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19451 === (5))){
var inst_19434 = (state_19450[(2)]);
var state_19450__$1 = (function (){var statearr_19467 = state_19450;
(statearr_19467[(11)] = inst_19434);

return statearr_19467;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19450__$1,(12),dchan);
} else {
if((state_val_19451 === (14))){
var inst_19436 = (state_19450[(8)]);
var inst_19441 = cljs.core.apply.call(null,f,inst_19436);
var state_19450__$1 = state_19450;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19450__$1,(16),out,inst_19441);
} else {
if((state_val_19451 === (16))){
var inst_19443 = (state_19450[(2)]);
var state_19450__$1 = (function (){var statearr_19468 = state_19450;
(statearr_19468[(12)] = inst_19443);

return statearr_19468;
})();
var statearr_19469_19497 = state_19450__$1;
(statearr_19469_19497[(2)] = null);

(statearr_19469_19497[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19451 === (10))){
var inst_19418 = (state_19450[(2)]);
var inst_19419 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_19450__$1 = (function (){var statearr_19470 = state_19450;
(statearr_19470[(13)] = inst_19418);

return statearr_19470;
})();
var statearr_19471_19498 = state_19450__$1;
(statearr_19471_19498[(2)] = inst_19419);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19450__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19451 === (8))){
var inst_19432 = (state_19450[(2)]);
var state_19450__$1 = state_19450;
var statearr_19472_19499 = state_19450__$1;
(statearr_19472_19499[(2)] = inst_19432);

(statearr_19472_19499[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___19484,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__8364__auto__,c__8429__auto___19484,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__8365__auto__ = null;
var cljs$core$async$state_machine__8365__auto____0 = (function (){
var statearr_19476 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19476[(0)] = cljs$core$async$state_machine__8365__auto__);

(statearr_19476[(1)] = (1));

return statearr_19476;
});
var cljs$core$async$state_machine__8365__auto____1 = (function (state_19450){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_19450);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e19477){if((e19477 instanceof Object)){
var ex__8368__auto__ = e19477;
var statearr_19478_19500 = state_19450;
(statearr_19478_19500[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19450);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19477;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19501 = state_19450;
state_19450 = G__19501;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$state_machine__8365__auto__ = function(state_19450){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8365__auto____1.call(this,state_19450);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8365__auto____0;
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8365__auto____1;
return cljs$core$async$state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___19484,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__8431__auto__ = (function (){var statearr_19479 = f__8430__auto__.call(null);
(statearr_19479[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___19484);

return statearr_19479;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});})(c__8429__auto___19484,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args19503 = [];
var len__5627__auto___19559 = arguments.length;
var i__5628__auto___19560 = (0);
while(true){
if((i__5628__auto___19560 < len__5627__auto___19559)){
args19503.push((arguments[i__5628__auto___19560]));

var G__19561 = (i__5628__auto___19560 + (1));
i__5628__auto___19560 = G__19561;
continue;
} else {
}
break;
}

var G__19505 = args19503.length;
switch (G__19505) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19503.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8429__auto___19563 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8429__auto___19563,out){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___19563,out){
return (function (state_19535){
var state_val_19536 = (state_19535[(1)]);
if((state_val_19536 === (7))){
var inst_19515 = (state_19535[(7)]);
var inst_19514 = (state_19535[(8)]);
var inst_19514__$1 = (state_19535[(2)]);
var inst_19515__$1 = cljs.core.nth.call(null,inst_19514__$1,(0),null);
var inst_19516 = cljs.core.nth.call(null,inst_19514__$1,(1),null);
var inst_19517 = (inst_19515__$1 == null);
var state_19535__$1 = (function (){var statearr_19537 = state_19535;
(statearr_19537[(9)] = inst_19516);

(statearr_19537[(7)] = inst_19515__$1);

(statearr_19537[(8)] = inst_19514__$1);

return statearr_19537;
})();
if(cljs.core.truth_(inst_19517)){
var statearr_19538_19564 = state_19535__$1;
(statearr_19538_19564[(1)] = (8));

} else {
var statearr_19539_19565 = state_19535__$1;
(statearr_19539_19565[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19536 === (1))){
var inst_19506 = cljs.core.vec.call(null,chs);
var inst_19507 = inst_19506;
var state_19535__$1 = (function (){var statearr_19540 = state_19535;
(statearr_19540[(10)] = inst_19507);

return statearr_19540;
})();
var statearr_19541_19566 = state_19535__$1;
(statearr_19541_19566[(2)] = null);

(statearr_19541_19566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19536 === (4))){
var inst_19507 = (state_19535[(10)]);
var state_19535__$1 = state_19535;
return cljs.core.async.ioc_alts_BANG_.call(null,state_19535__$1,(7),inst_19507);
} else {
if((state_val_19536 === (6))){
var inst_19531 = (state_19535[(2)]);
var state_19535__$1 = state_19535;
var statearr_19542_19567 = state_19535__$1;
(statearr_19542_19567[(2)] = inst_19531);

(statearr_19542_19567[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19536 === (3))){
var inst_19533 = (state_19535[(2)]);
var state_19535__$1 = state_19535;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19535__$1,inst_19533);
} else {
if((state_val_19536 === (2))){
var inst_19507 = (state_19535[(10)]);
var inst_19509 = cljs.core.count.call(null,inst_19507);
var inst_19510 = (inst_19509 > (0));
var state_19535__$1 = state_19535;
if(cljs.core.truth_(inst_19510)){
var statearr_19544_19568 = state_19535__$1;
(statearr_19544_19568[(1)] = (4));

} else {
var statearr_19545_19569 = state_19535__$1;
(statearr_19545_19569[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19536 === (11))){
var inst_19507 = (state_19535[(10)]);
var inst_19524 = (state_19535[(2)]);
var tmp19543 = inst_19507;
var inst_19507__$1 = tmp19543;
var state_19535__$1 = (function (){var statearr_19546 = state_19535;
(statearr_19546[(11)] = inst_19524);

(statearr_19546[(10)] = inst_19507__$1);

return statearr_19546;
})();
var statearr_19547_19570 = state_19535__$1;
(statearr_19547_19570[(2)] = null);

(statearr_19547_19570[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19536 === (9))){
var inst_19515 = (state_19535[(7)]);
var state_19535__$1 = state_19535;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19535__$1,(11),out,inst_19515);
} else {
if((state_val_19536 === (5))){
var inst_19529 = cljs.core.async.close_BANG_.call(null,out);
var state_19535__$1 = state_19535;
var statearr_19548_19571 = state_19535__$1;
(statearr_19548_19571[(2)] = inst_19529);

(statearr_19548_19571[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19536 === (10))){
var inst_19527 = (state_19535[(2)]);
var state_19535__$1 = state_19535;
var statearr_19549_19572 = state_19535__$1;
(statearr_19549_19572[(2)] = inst_19527);

(statearr_19549_19572[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19536 === (8))){
var inst_19516 = (state_19535[(9)]);
var inst_19515 = (state_19535[(7)]);
var inst_19514 = (state_19535[(8)]);
var inst_19507 = (state_19535[(10)]);
var inst_19519 = (function (){var cs = inst_19507;
var vec__19512 = inst_19514;
var v = inst_19515;
var c = inst_19516;
return ((function (cs,vec__19512,v,c,inst_19516,inst_19515,inst_19514,inst_19507,state_val_19536,c__8429__auto___19563,out){
return (function (p1__19502_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__19502_SHARP_);
});
;})(cs,vec__19512,v,c,inst_19516,inst_19515,inst_19514,inst_19507,state_val_19536,c__8429__auto___19563,out))
})();
var inst_19520 = cljs.core.filterv.call(null,inst_19519,inst_19507);
var inst_19507__$1 = inst_19520;
var state_19535__$1 = (function (){var statearr_19550 = state_19535;
(statearr_19550[(10)] = inst_19507__$1);

return statearr_19550;
})();
var statearr_19551_19573 = state_19535__$1;
(statearr_19551_19573[(2)] = null);

(statearr_19551_19573[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___19563,out))
;
return ((function (switch__8364__auto__,c__8429__auto___19563,out){
return (function() {
var cljs$core$async$state_machine__8365__auto__ = null;
var cljs$core$async$state_machine__8365__auto____0 = (function (){
var statearr_19555 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19555[(0)] = cljs$core$async$state_machine__8365__auto__);

(statearr_19555[(1)] = (1));

return statearr_19555;
});
var cljs$core$async$state_machine__8365__auto____1 = (function (state_19535){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_19535);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e19556){if((e19556 instanceof Object)){
var ex__8368__auto__ = e19556;
var statearr_19557_19574 = state_19535;
(statearr_19557_19574[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19535);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19556;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19575 = state_19535;
state_19535 = G__19575;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$state_machine__8365__auto__ = function(state_19535){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8365__auto____1.call(this,state_19535);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8365__auto____0;
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8365__auto____1;
return cljs$core$async$state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___19563,out))
})();
var state__8431__auto__ = (function (){var statearr_19558 = f__8430__auto__.call(null);
(statearr_19558[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___19563);

return statearr_19558;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});})(c__8429__auto___19563,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args19576 = [];
var len__5627__auto___19625 = arguments.length;
var i__5628__auto___19626 = (0);
while(true){
if((i__5628__auto___19626 < len__5627__auto___19625)){
args19576.push((arguments[i__5628__auto___19626]));

var G__19627 = (i__5628__auto___19626 + (1));
i__5628__auto___19626 = G__19627;
continue;
} else {
}
break;
}

var G__19578 = args19576.length;
switch (G__19578) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19576.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8429__auto___19629 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8429__auto___19629,out){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___19629,out){
return (function (state_19602){
var state_val_19603 = (state_19602[(1)]);
if((state_val_19603 === (7))){
var inst_19584 = (state_19602[(7)]);
var inst_19584__$1 = (state_19602[(2)]);
var inst_19585 = (inst_19584__$1 == null);
var inst_19586 = cljs.core.not.call(null,inst_19585);
var state_19602__$1 = (function (){var statearr_19604 = state_19602;
(statearr_19604[(7)] = inst_19584__$1);

return statearr_19604;
})();
if(inst_19586){
var statearr_19605_19630 = state_19602__$1;
(statearr_19605_19630[(1)] = (8));

} else {
var statearr_19606_19631 = state_19602__$1;
(statearr_19606_19631[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19603 === (1))){
var inst_19579 = (0);
var state_19602__$1 = (function (){var statearr_19607 = state_19602;
(statearr_19607[(8)] = inst_19579);

return statearr_19607;
})();
var statearr_19608_19632 = state_19602__$1;
(statearr_19608_19632[(2)] = null);

(statearr_19608_19632[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19603 === (4))){
var state_19602__$1 = state_19602;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19602__$1,(7),ch);
} else {
if((state_val_19603 === (6))){
var inst_19597 = (state_19602[(2)]);
var state_19602__$1 = state_19602;
var statearr_19609_19633 = state_19602__$1;
(statearr_19609_19633[(2)] = inst_19597);

(statearr_19609_19633[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19603 === (3))){
var inst_19599 = (state_19602[(2)]);
var inst_19600 = cljs.core.async.close_BANG_.call(null,out);
var state_19602__$1 = (function (){var statearr_19610 = state_19602;
(statearr_19610[(9)] = inst_19599);

return statearr_19610;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19602__$1,inst_19600);
} else {
if((state_val_19603 === (2))){
var inst_19579 = (state_19602[(8)]);
var inst_19581 = (inst_19579 < n);
var state_19602__$1 = state_19602;
if(cljs.core.truth_(inst_19581)){
var statearr_19611_19634 = state_19602__$1;
(statearr_19611_19634[(1)] = (4));

} else {
var statearr_19612_19635 = state_19602__$1;
(statearr_19612_19635[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19603 === (11))){
var inst_19579 = (state_19602[(8)]);
var inst_19589 = (state_19602[(2)]);
var inst_19590 = (inst_19579 + (1));
var inst_19579__$1 = inst_19590;
var state_19602__$1 = (function (){var statearr_19613 = state_19602;
(statearr_19613[(10)] = inst_19589);

(statearr_19613[(8)] = inst_19579__$1);

return statearr_19613;
})();
var statearr_19614_19636 = state_19602__$1;
(statearr_19614_19636[(2)] = null);

(statearr_19614_19636[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19603 === (9))){
var state_19602__$1 = state_19602;
var statearr_19615_19637 = state_19602__$1;
(statearr_19615_19637[(2)] = null);

(statearr_19615_19637[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19603 === (5))){
var state_19602__$1 = state_19602;
var statearr_19616_19638 = state_19602__$1;
(statearr_19616_19638[(2)] = null);

(statearr_19616_19638[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19603 === (10))){
var inst_19594 = (state_19602[(2)]);
var state_19602__$1 = state_19602;
var statearr_19617_19639 = state_19602__$1;
(statearr_19617_19639[(2)] = inst_19594);

(statearr_19617_19639[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19603 === (8))){
var inst_19584 = (state_19602[(7)]);
var state_19602__$1 = state_19602;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19602__$1,(11),out,inst_19584);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___19629,out))
;
return ((function (switch__8364__auto__,c__8429__auto___19629,out){
return (function() {
var cljs$core$async$state_machine__8365__auto__ = null;
var cljs$core$async$state_machine__8365__auto____0 = (function (){
var statearr_19621 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19621[(0)] = cljs$core$async$state_machine__8365__auto__);

(statearr_19621[(1)] = (1));

return statearr_19621;
});
var cljs$core$async$state_machine__8365__auto____1 = (function (state_19602){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_19602);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e19622){if((e19622 instanceof Object)){
var ex__8368__auto__ = e19622;
var statearr_19623_19640 = state_19602;
(statearr_19623_19640[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19602);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19622;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19641 = state_19602;
state_19602 = G__19641;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$state_machine__8365__auto__ = function(state_19602){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8365__auto____1.call(this,state_19602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8365__auto____0;
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8365__auto____1;
return cljs$core$async$state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___19629,out))
})();
var state__8431__auto__ = (function (){var statearr_19624 = f__8430__auto__.call(null);
(statearr_19624[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___19629);

return statearr_19624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});})(c__8429__auto___19629,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19649 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19649 = (function (map_LT_,f,ch,meta19650){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19650 = meta19650;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19649.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19651,meta19650__$1){
var self__ = this;
var _19651__$1 = this;
return (new cljs.core.async.t_cljs$core$async19649(self__.map_LT_,self__.f,self__.ch,meta19650__$1));
});

cljs.core.async.t_cljs$core$async19649.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19651){
var self__ = this;
var _19651__$1 = this;
return self__.meta19650;
});

cljs.core.async.t_cljs$core$async19649.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19649.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19649.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19649.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19649.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async19652 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19652 = (function (map_LT_,f,ch,meta19650,_,fn1,meta19653){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19650 = meta19650;
this._ = _;
this.fn1 = fn1;
this.meta19653 = meta19653;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19652.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_19654,meta19653__$1){
var self__ = this;
var _19654__$1 = this;
return (new cljs.core.async.t_cljs$core$async19652(self__.map_LT_,self__.f,self__.ch,self__.meta19650,self__._,self__.fn1,meta19653__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async19652.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_19654){
var self__ = this;
var _19654__$1 = this;
return self__.meta19653;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19652.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19652.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19652.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__19642_SHARP_){
return f1.call(null,(((p1__19642_SHARP_ == null))?null:self__.f.call(null,p1__19642_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async19652.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19650","meta19650",-2124429676,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async19649","cljs.core.async/t_cljs$core$async19649",1591518900,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta19653","meta19653",-1132516374,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19652.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19652.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19652";

cljs.core.async.t_cljs$core$async19652.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async19652");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async19652 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19652(map_LT___$1,f__$1,ch__$1,meta19650__$1,___$2,fn1__$1,meta19653){
return (new cljs.core.async.t_cljs$core$async19652(map_LT___$1,f__$1,ch__$1,meta19650__$1,___$2,fn1__$1,meta19653));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async19652(self__.map_LT_,self__.f,self__.ch,self__.meta19650,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4557__auto__ = ret;
if(cljs.core.truth_(and__4557__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4557__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async19649.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19649.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async19649.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19650","meta19650",-2124429676,null)], null);
});

cljs.core.async.t_cljs$core$async19649.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19649.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19649";

cljs.core.async.t_cljs$core$async19649.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async19649");
});

cljs.core.async.__GT_t_cljs$core$async19649 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19649(map_LT___$1,f__$1,ch__$1,meta19650){
return (new cljs.core.async.t_cljs$core$async19649(map_LT___$1,f__$1,ch__$1,meta19650));
});

}

return (new cljs.core.async.t_cljs$core$async19649(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19658 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19658 = (function (map_GT_,f,ch,meta19659){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta19659 = meta19659;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19658.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19660,meta19659__$1){
var self__ = this;
var _19660__$1 = this;
return (new cljs.core.async.t_cljs$core$async19658(self__.map_GT_,self__.f,self__.ch,meta19659__$1));
});

cljs.core.async.t_cljs$core$async19658.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19660){
var self__ = this;
var _19660__$1 = this;
return self__.meta19659;
});

cljs.core.async.t_cljs$core$async19658.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19658.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19658.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19658.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19658.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19658.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async19658.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19659","meta19659",513845346,null)], null);
});

cljs.core.async.t_cljs$core$async19658.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19658.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19658";

cljs.core.async.t_cljs$core$async19658.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async19658");
});

cljs.core.async.__GT_t_cljs$core$async19658 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async19658(map_GT___$1,f__$1,ch__$1,meta19659){
return (new cljs.core.async.t_cljs$core$async19658(map_GT___$1,f__$1,ch__$1,meta19659));
});

}

return (new cljs.core.async.t_cljs$core$async19658(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async19664 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19664 = (function (filter_GT_,p,ch,meta19665){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta19665 = meta19665;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19664.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19666,meta19665__$1){
var self__ = this;
var _19666__$1 = this;
return (new cljs.core.async.t_cljs$core$async19664(self__.filter_GT_,self__.p,self__.ch,meta19665__$1));
});

cljs.core.async.t_cljs$core$async19664.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19666){
var self__ = this;
var _19666__$1 = this;
return self__.meta19665;
});

cljs.core.async.t_cljs$core$async19664.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19664.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19664.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19664.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19664.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19664.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19664.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async19664.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19665","meta19665",2125427539,null)], null);
});

cljs.core.async.t_cljs$core$async19664.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19664.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19664";

cljs.core.async.t_cljs$core$async19664.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async19664");
});

cljs.core.async.__GT_t_cljs$core$async19664 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async19664(filter_GT___$1,p__$1,ch__$1,meta19665){
return (new cljs.core.async.t_cljs$core$async19664(filter_GT___$1,p__$1,ch__$1,meta19665));
});

}

return (new cljs.core.async.t_cljs$core$async19664(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args19667 = [];
var len__5627__auto___19711 = arguments.length;
var i__5628__auto___19712 = (0);
while(true){
if((i__5628__auto___19712 < len__5627__auto___19711)){
args19667.push((arguments[i__5628__auto___19712]));

var G__19713 = (i__5628__auto___19712 + (1));
i__5628__auto___19712 = G__19713;
continue;
} else {
}
break;
}

var G__19669 = args19667.length;
switch (G__19669) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19667.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8429__auto___19715 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8429__auto___19715,out){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___19715,out){
return (function (state_19690){
var state_val_19691 = (state_19690[(1)]);
if((state_val_19691 === (7))){
var inst_19686 = (state_19690[(2)]);
var state_19690__$1 = state_19690;
var statearr_19692_19716 = state_19690__$1;
(statearr_19692_19716[(2)] = inst_19686);

(statearr_19692_19716[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19691 === (1))){
var state_19690__$1 = state_19690;
var statearr_19693_19717 = state_19690__$1;
(statearr_19693_19717[(2)] = null);

(statearr_19693_19717[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19691 === (4))){
var inst_19672 = (state_19690[(7)]);
var inst_19672__$1 = (state_19690[(2)]);
var inst_19673 = (inst_19672__$1 == null);
var state_19690__$1 = (function (){var statearr_19694 = state_19690;
(statearr_19694[(7)] = inst_19672__$1);

return statearr_19694;
})();
if(cljs.core.truth_(inst_19673)){
var statearr_19695_19718 = state_19690__$1;
(statearr_19695_19718[(1)] = (5));

} else {
var statearr_19696_19719 = state_19690__$1;
(statearr_19696_19719[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19691 === (6))){
var inst_19672 = (state_19690[(7)]);
var inst_19677 = p.call(null,inst_19672);
var state_19690__$1 = state_19690;
if(cljs.core.truth_(inst_19677)){
var statearr_19697_19720 = state_19690__$1;
(statearr_19697_19720[(1)] = (8));

} else {
var statearr_19698_19721 = state_19690__$1;
(statearr_19698_19721[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19691 === (3))){
var inst_19688 = (state_19690[(2)]);
var state_19690__$1 = state_19690;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19690__$1,inst_19688);
} else {
if((state_val_19691 === (2))){
var state_19690__$1 = state_19690;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19690__$1,(4),ch);
} else {
if((state_val_19691 === (11))){
var inst_19680 = (state_19690[(2)]);
var state_19690__$1 = state_19690;
var statearr_19699_19722 = state_19690__$1;
(statearr_19699_19722[(2)] = inst_19680);

(statearr_19699_19722[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19691 === (9))){
var state_19690__$1 = state_19690;
var statearr_19700_19723 = state_19690__$1;
(statearr_19700_19723[(2)] = null);

(statearr_19700_19723[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19691 === (5))){
var inst_19675 = cljs.core.async.close_BANG_.call(null,out);
var state_19690__$1 = state_19690;
var statearr_19701_19724 = state_19690__$1;
(statearr_19701_19724[(2)] = inst_19675);

(statearr_19701_19724[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19691 === (10))){
var inst_19683 = (state_19690[(2)]);
var state_19690__$1 = (function (){var statearr_19702 = state_19690;
(statearr_19702[(8)] = inst_19683);

return statearr_19702;
})();
var statearr_19703_19725 = state_19690__$1;
(statearr_19703_19725[(2)] = null);

(statearr_19703_19725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19691 === (8))){
var inst_19672 = (state_19690[(7)]);
var state_19690__$1 = state_19690;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19690__$1,(11),out,inst_19672);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___19715,out))
;
return ((function (switch__8364__auto__,c__8429__auto___19715,out){
return (function() {
var cljs$core$async$state_machine__8365__auto__ = null;
var cljs$core$async$state_machine__8365__auto____0 = (function (){
var statearr_19707 = [null,null,null,null,null,null,null,null,null];
(statearr_19707[(0)] = cljs$core$async$state_machine__8365__auto__);

(statearr_19707[(1)] = (1));

return statearr_19707;
});
var cljs$core$async$state_machine__8365__auto____1 = (function (state_19690){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_19690);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e19708){if((e19708 instanceof Object)){
var ex__8368__auto__ = e19708;
var statearr_19709_19726 = state_19690;
(statearr_19709_19726[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19690);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19708;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19727 = state_19690;
state_19690 = G__19727;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$state_machine__8365__auto__ = function(state_19690){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8365__auto____1.call(this,state_19690);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8365__auto____0;
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8365__auto____1;
return cljs$core$async$state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___19715,out))
})();
var state__8431__auto__ = (function (){var statearr_19710 = f__8430__auto__.call(null);
(statearr_19710[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___19715);

return statearr_19710;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});})(c__8429__auto___19715,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args19728 = [];
var len__5627__auto___19731 = arguments.length;
var i__5628__auto___19732 = (0);
while(true){
if((i__5628__auto___19732 < len__5627__auto___19731)){
args19728.push((arguments[i__5628__auto___19732]));

var G__19733 = (i__5628__auto___19732 + (1));
i__5628__auto___19732 = G__19733;
continue;
} else {
}
break;
}

var G__19730 = args19728.length;
switch (G__19730) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19728.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__8429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8429__auto__){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto__){
return (function (state_19900){
var state_val_19901 = (state_19900[(1)]);
if((state_val_19901 === (7))){
var inst_19896 = (state_19900[(2)]);
var state_19900__$1 = state_19900;
var statearr_19902_19943 = state_19900__$1;
(statearr_19902_19943[(2)] = inst_19896);

(statearr_19902_19943[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19901 === (20))){
var inst_19866 = (state_19900[(7)]);
var inst_19877 = (state_19900[(2)]);
var inst_19878 = cljs.core.next.call(null,inst_19866);
var inst_19852 = inst_19878;
var inst_19853 = null;
var inst_19854 = (0);
var inst_19855 = (0);
var state_19900__$1 = (function (){var statearr_19903 = state_19900;
(statearr_19903[(8)] = inst_19853);

(statearr_19903[(9)] = inst_19854);

(statearr_19903[(10)] = inst_19852);

(statearr_19903[(11)] = inst_19855);

(statearr_19903[(12)] = inst_19877);

return statearr_19903;
})();
var statearr_19904_19944 = state_19900__$1;
(statearr_19904_19944[(2)] = null);

(statearr_19904_19944[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19901 === (1))){
var state_19900__$1 = state_19900;
var statearr_19905_19945 = state_19900__$1;
(statearr_19905_19945[(2)] = null);

(statearr_19905_19945[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19901 === (4))){
var inst_19841 = (state_19900[(13)]);
var inst_19841__$1 = (state_19900[(2)]);
var inst_19842 = (inst_19841__$1 == null);
var state_19900__$1 = (function (){var statearr_19906 = state_19900;
(statearr_19906[(13)] = inst_19841__$1);

return statearr_19906;
})();
if(cljs.core.truth_(inst_19842)){
var statearr_19907_19946 = state_19900__$1;
(statearr_19907_19946[(1)] = (5));

} else {
var statearr_19908_19947 = state_19900__$1;
(statearr_19908_19947[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19901 === (15))){
var state_19900__$1 = state_19900;
var statearr_19912_19948 = state_19900__$1;
(statearr_19912_19948[(2)] = null);

(statearr_19912_19948[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19901 === (21))){
var state_19900__$1 = state_19900;
var statearr_19913_19949 = state_19900__$1;
(statearr_19913_19949[(2)] = null);

(statearr_19913_19949[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19901 === (13))){
var inst_19853 = (state_19900[(8)]);
var inst_19854 = (state_19900[(9)]);
var inst_19852 = (state_19900[(10)]);
var inst_19855 = (state_19900[(11)]);
var inst_19862 = (state_19900[(2)]);
var inst_19863 = (inst_19855 + (1));
var tmp19909 = inst_19853;
var tmp19910 = inst_19854;
var tmp19911 = inst_19852;
var inst_19852__$1 = tmp19911;
var inst_19853__$1 = tmp19909;
var inst_19854__$1 = tmp19910;
var inst_19855__$1 = inst_19863;
var state_19900__$1 = (function (){var statearr_19914 = state_19900;
(statearr_19914[(8)] = inst_19853__$1);

(statearr_19914[(9)] = inst_19854__$1);

(statearr_19914[(10)] = inst_19852__$1);

(statearr_19914[(11)] = inst_19855__$1);

(statearr_19914[(14)] = inst_19862);

return statearr_19914;
})();
var statearr_19915_19950 = state_19900__$1;
(statearr_19915_19950[(2)] = null);

(statearr_19915_19950[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19901 === (22))){
var state_19900__$1 = state_19900;
var statearr_19916_19951 = state_19900__$1;
(statearr_19916_19951[(2)] = null);

(statearr_19916_19951[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19901 === (6))){
var inst_19841 = (state_19900[(13)]);
var inst_19850 = f.call(null,inst_19841);
var inst_19851 = cljs.core.seq.call(null,inst_19850);
var inst_19852 = inst_19851;
var inst_19853 = null;
var inst_19854 = (0);
var inst_19855 = (0);
var state_19900__$1 = (function (){var statearr_19917 = state_19900;
(statearr_19917[(8)] = inst_19853);

(statearr_19917[(9)] = inst_19854);

(statearr_19917[(10)] = inst_19852);

(statearr_19917[(11)] = inst_19855);

return statearr_19917;
})();
var statearr_19918_19952 = state_19900__$1;
(statearr_19918_19952[(2)] = null);

(statearr_19918_19952[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19901 === (17))){
var inst_19866 = (state_19900[(7)]);
var inst_19870 = cljs.core.chunk_first.call(null,inst_19866);
var inst_19871 = cljs.core.chunk_rest.call(null,inst_19866);
var inst_19872 = cljs.core.count.call(null,inst_19870);
var inst_19852 = inst_19871;
var inst_19853 = inst_19870;
var inst_19854 = inst_19872;
var inst_19855 = (0);
var state_19900__$1 = (function (){var statearr_19919 = state_19900;
(statearr_19919[(8)] = inst_19853);

(statearr_19919[(9)] = inst_19854);

(statearr_19919[(10)] = inst_19852);

(statearr_19919[(11)] = inst_19855);

return statearr_19919;
})();
var statearr_19920_19953 = state_19900__$1;
(statearr_19920_19953[(2)] = null);

(statearr_19920_19953[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19901 === (3))){
var inst_19898 = (state_19900[(2)]);
var state_19900__$1 = state_19900;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19900__$1,inst_19898);
} else {
if((state_val_19901 === (12))){
var inst_19886 = (state_19900[(2)]);
var state_19900__$1 = state_19900;
var statearr_19921_19954 = state_19900__$1;
(statearr_19921_19954[(2)] = inst_19886);

(statearr_19921_19954[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19901 === (2))){
var state_19900__$1 = state_19900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19900__$1,(4),in$);
} else {
if((state_val_19901 === (23))){
var inst_19894 = (state_19900[(2)]);
var state_19900__$1 = state_19900;
var statearr_19922_19955 = state_19900__$1;
(statearr_19922_19955[(2)] = inst_19894);

(statearr_19922_19955[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19901 === (19))){
var inst_19881 = (state_19900[(2)]);
var state_19900__$1 = state_19900;
var statearr_19923_19956 = state_19900__$1;
(statearr_19923_19956[(2)] = inst_19881);

(statearr_19923_19956[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19901 === (11))){
var inst_19852 = (state_19900[(10)]);
var inst_19866 = (state_19900[(7)]);
var inst_19866__$1 = cljs.core.seq.call(null,inst_19852);
var state_19900__$1 = (function (){var statearr_19924 = state_19900;
(statearr_19924[(7)] = inst_19866__$1);

return statearr_19924;
})();
if(inst_19866__$1){
var statearr_19925_19957 = state_19900__$1;
(statearr_19925_19957[(1)] = (14));

} else {
var statearr_19926_19958 = state_19900__$1;
(statearr_19926_19958[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19901 === (9))){
var inst_19888 = (state_19900[(2)]);
var inst_19889 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_19900__$1 = (function (){var statearr_19927 = state_19900;
(statearr_19927[(15)] = inst_19888);

return statearr_19927;
})();
if(cljs.core.truth_(inst_19889)){
var statearr_19928_19959 = state_19900__$1;
(statearr_19928_19959[(1)] = (21));

} else {
var statearr_19929_19960 = state_19900__$1;
(statearr_19929_19960[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19901 === (5))){
var inst_19844 = cljs.core.async.close_BANG_.call(null,out);
var state_19900__$1 = state_19900;
var statearr_19930_19961 = state_19900__$1;
(statearr_19930_19961[(2)] = inst_19844);

(statearr_19930_19961[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19901 === (14))){
var inst_19866 = (state_19900[(7)]);
var inst_19868 = cljs.core.chunked_seq_QMARK_.call(null,inst_19866);
var state_19900__$1 = state_19900;
if(inst_19868){
var statearr_19931_19962 = state_19900__$1;
(statearr_19931_19962[(1)] = (17));

} else {
var statearr_19932_19963 = state_19900__$1;
(statearr_19932_19963[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19901 === (16))){
var inst_19884 = (state_19900[(2)]);
var state_19900__$1 = state_19900;
var statearr_19933_19964 = state_19900__$1;
(statearr_19933_19964[(2)] = inst_19884);

(statearr_19933_19964[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19901 === (10))){
var inst_19853 = (state_19900[(8)]);
var inst_19855 = (state_19900[(11)]);
var inst_19860 = cljs.core._nth.call(null,inst_19853,inst_19855);
var state_19900__$1 = state_19900;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19900__$1,(13),out,inst_19860);
} else {
if((state_val_19901 === (18))){
var inst_19866 = (state_19900[(7)]);
var inst_19875 = cljs.core.first.call(null,inst_19866);
var state_19900__$1 = state_19900;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19900__$1,(20),out,inst_19875);
} else {
if((state_val_19901 === (8))){
var inst_19854 = (state_19900[(9)]);
var inst_19855 = (state_19900[(11)]);
var inst_19857 = (inst_19855 < inst_19854);
var inst_19858 = inst_19857;
var state_19900__$1 = state_19900;
if(cljs.core.truth_(inst_19858)){
var statearr_19934_19965 = state_19900__$1;
(statearr_19934_19965[(1)] = (10));

} else {
var statearr_19935_19966 = state_19900__$1;
(statearr_19935_19966[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto__))
;
return ((function (switch__8364__auto__,c__8429__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__8365__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__8365__auto____0 = (function (){
var statearr_19939 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19939[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__8365__auto__);

(statearr_19939[(1)] = (1));

return statearr_19939;
});
var cljs$core$async$mapcat_STAR__$_state_machine__8365__auto____1 = (function (state_19900){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_19900);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e19940){if((e19940 instanceof Object)){
var ex__8368__auto__ = e19940;
var statearr_19941_19967 = state_19900;
(statearr_19941_19967[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19900);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19940;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19968 = state_19900;
state_19900 = G__19968;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__8365__auto__ = function(state_19900){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__8365__auto____1.call(this,state_19900);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__8365__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__8365__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto__))
})();
var state__8431__auto__ = (function (){var statearr_19942 = f__8430__auto__.call(null);
(statearr_19942[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto__);

return statearr_19942;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});})(c__8429__auto__))
);

return c__8429__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args19969 = [];
var len__5627__auto___19972 = arguments.length;
var i__5628__auto___19973 = (0);
while(true){
if((i__5628__auto___19973 < len__5627__auto___19972)){
args19969.push((arguments[i__5628__auto___19973]));

var G__19974 = (i__5628__auto___19973 + (1));
i__5628__auto___19973 = G__19974;
continue;
} else {
}
break;
}

var G__19971 = args19969.length;
switch (G__19971) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19969.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args19976 = [];
var len__5627__auto___19979 = arguments.length;
var i__5628__auto___19980 = (0);
while(true){
if((i__5628__auto___19980 < len__5627__auto___19979)){
args19976.push((arguments[i__5628__auto___19980]));

var G__19981 = (i__5628__auto___19980 + (1));
i__5628__auto___19980 = G__19981;
continue;
} else {
}
break;
}

var G__19978 = args19976.length;
switch (G__19978) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19976.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args19983 = [];
var len__5627__auto___20034 = arguments.length;
var i__5628__auto___20035 = (0);
while(true){
if((i__5628__auto___20035 < len__5627__auto___20034)){
args19983.push((arguments[i__5628__auto___20035]));

var G__20036 = (i__5628__auto___20035 + (1));
i__5628__auto___20035 = G__20036;
continue;
} else {
}
break;
}

var G__19985 = args19983.length;
switch (G__19985) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19983.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8429__auto___20038 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8429__auto___20038,out){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___20038,out){
return (function (state_20009){
var state_val_20010 = (state_20009[(1)]);
if((state_val_20010 === (7))){
var inst_20004 = (state_20009[(2)]);
var state_20009__$1 = state_20009;
var statearr_20011_20039 = state_20009__$1;
(statearr_20011_20039[(2)] = inst_20004);

(statearr_20011_20039[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20010 === (1))){
var inst_19986 = null;
var state_20009__$1 = (function (){var statearr_20012 = state_20009;
(statearr_20012[(7)] = inst_19986);

return statearr_20012;
})();
var statearr_20013_20040 = state_20009__$1;
(statearr_20013_20040[(2)] = null);

(statearr_20013_20040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20010 === (4))){
var inst_19989 = (state_20009[(8)]);
var inst_19989__$1 = (state_20009[(2)]);
var inst_19990 = (inst_19989__$1 == null);
var inst_19991 = cljs.core.not.call(null,inst_19990);
var state_20009__$1 = (function (){var statearr_20014 = state_20009;
(statearr_20014[(8)] = inst_19989__$1);

return statearr_20014;
})();
if(inst_19991){
var statearr_20015_20041 = state_20009__$1;
(statearr_20015_20041[(1)] = (5));

} else {
var statearr_20016_20042 = state_20009__$1;
(statearr_20016_20042[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20010 === (6))){
var state_20009__$1 = state_20009;
var statearr_20017_20043 = state_20009__$1;
(statearr_20017_20043[(2)] = null);

(statearr_20017_20043[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20010 === (3))){
var inst_20006 = (state_20009[(2)]);
var inst_20007 = cljs.core.async.close_BANG_.call(null,out);
var state_20009__$1 = (function (){var statearr_20018 = state_20009;
(statearr_20018[(9)] = inst_20006);

return statearr_20018;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20009__$1,inst_20007);
} else {
if((state_val_20010 === (2))){
var state_20009__$1 = state_20009;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20009__$1,(4),ch);
} else {
if((state_val_20010 === (11))){
var inst_19989 = (state_20009[(8)]);
var inst_19998 = (state_20009[(2)]);
var inst_19986 = inst_19989;
var state_20009__$1 = (function (){var statearr_20019 = state_20009;
(statearr_20019[(10)] = inst_19998);

(statearr_20019[(7)] = inst_19986);

return statearr_20019;
})();
var statearr_20020_20044 = state_20009__$1;
(statearr_20020_20044[(2)] = null);

(statearr_20020_20044[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20010 === (9))){
var inst_19989 = (state_20009[(8)]);
var state_20009__$1 = state_20009;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20009__$1,(11),out,inst_19989);
} else {
if((state_val_20010 === (5))){
var inst_19989 = (state_20009[(8)]);
var inst_19986 = (state_20009[(7)]);
var inst_19993 = cljs.core._EQ_.call(null,inst_19989,inst_19986);
var state_20009__$1 = state_20009;
if(inst_19993){
var statearr_20022_20045 = state_20009__$1;
(statearr_20022_20045[(1)] = (8));

} else {
var statearr_20023_20046 = state_20009__$1;
(statearr_20023_20046[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20010 === (10))){
var inst_20001 = (state_20009[(2)]);
var state_20009__$1 = state_20009;
var statearr_20024_20047 = state_20009__$1;
(statearr_20024_20047[(2)] = inst_20001);

(statearr_20024_20047[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20010 === (8))){
var inst_19986 = (state_20009[(7)]);
var tmp20021 = inst_19986;
var inst_19986__$1 = tmp20021;
var state_20009__$1 = (function (){var statearr_20025 = state_20009;
(statearr_20025[(7)] = inst_19986__$1);

return statearr_20025;
})();
var statearr_20026_20048 = state_20009__$1;
(statearr_20026_20048[(2)] = null);

(statearr_20026_20048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___20038,out))
;
return ((function (switch__8364__auto__,c__8429__auto___20038,out){
return (function() {
var cljs$core$async$state_machine__8365__auto__ = null;
var cljs$core$async$state_machine__8365__auto____0 = (function (){
var statearr_20030 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20030[(0)] = cljs$core$async$state_machine__8365__auto__);

(statearr_20030[(1)] = (1));

return statearr_20030;
});
var cljs$core$async$state_machine__8365__auto____1 = (function (state_20009){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_20009);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e20031){if((e20031 instanceof Object)){
var ex__8368__auto__ = e20031;
var statearr_20032_20049 = state_20009;
(statearr_20032_20049[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20009);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20031;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20050 = state_20009;
state_20009 = G__20050;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$state_machine__8365__auto__ = function(state_20009){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8365__auto____1.call(this,state_20009);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8365__auto____0;
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8365__auto____1;
return cljs$core$async$state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___20038,out))
})();
var state__8431__auto__ = (function (){var statearr_20033 = f__8430__auto__.call(null);
(statearr_20033[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___20038);

return statearr_20033;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});})(c__8429__auto___20038,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args20051 = [];
var len__5627__auto___20121 = arguments.length;
var i__5628__auto___20122 = (0);
while(true){
if((i__5628__auto___20122 < len__5627__auto___20121)){
args20051.push((arguments[i__5628__auto___20122]));

var G__20123 = (i__5628__auto___20122 + (1));
i__5628__auto___20122 = G__20123;
continue;
} else {
}
break;
}

var G__20053 = args20051.length;
switch (G__20053) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20051.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8429__auto___20125 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8429__auto___20125,out){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___20125,out){
return (function (state_20091){
var state_val_20092 = (state_20091[(1)]);
if((state_val_20092 === (7))){
var inst_20087 = (state_20091[(2)]);
var state_20091__$1 = state_20091;
var statearr_20093_20126 = state_20091__$1;
(statearr_20093_20126[(2)] = inst_20087);

(statearr_20093_20126[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20092 === (1))){
var inst_20054 = (new Array(n));
var inst_20055 = inst_20054;
var inst_20056 = (0);
var state_20091__$1 = (function (){var statearr_20094 = state_20091;
(statearr_20094[(7)] = inst_20056);

(statearr_20094[(8)] = inst_20055);

return statearr_20094;
})();
var statearr_20095_20127 = state_20091__$1;
(statearr_20095_20127[(2)] = null);

(statearr_20095_20127[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20092 === (4))){
var inst_20059 = (state_20091[(9)]);
var inst_20059__$1 = (state_20091[(2)]);
var inst_20060 = (inst_20059__$1 == null);
var inst_20061 = cljs.core.not.call(null,inst_20060);
var state_20091__$1 = (function (){var statearr_20096 = state_20091;
(statearr_20096[(9)] = inst_20059__$1);

return statearr_20096;
})();
if(inst_20061){
var statearr_20097_20128 = state_20091__$1;
(statearr_20097_20128[(1)] = (5));

} else {
var statearr_20098_20129 = state_20091__$1;
(statearr_20098_20129[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20092 === (15))){
var inst_20081 = (state_20091[(2)]);
var state_20091__$1 = state_20091;
var statearr_20099_20130 = state_20091__$1;
(statearr_20099_20130[(2)] = inst_20081);

(statearr_20099_20130[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20092 === (13))){
var state_20091__$1 = state_20091;
var statearr_20100_20131 = state_20091__$1;
(statearr_20100_20131[(2)] = null);

(statearr_20100_20131[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20092 === (6))){
var inst_20056 = (state_20091[(7)]);
var inst_20077 = (inst_20056 > (0));
var state_20091__$1 = state_20091;
if(cljs.core.truth_(inst_20077)){
var statearr_20101_20132 = state_20091__$1;
(statearr_20101_20132[(1)] = (12));

} else {
var statearr_20102_20133 = state_20091__$1;
(statearr_20102_20133[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20092 === (3))){
var inst_20089 = (state_20091[(2)]);
var state_20091__$1 = state_20091;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20091__$1,inst_20089);
} else {
if((state_val_20092 === (12))){
var inst_20055 = (state_20091[(8)]);
var inst_20079 = cljs.core.vec.call(null,inst_20055);
var state_20091__$1 = state_20091;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20091__$1,(15),out,inst_20079);
} else {
if((state_val_20092 === (2))){
var state_20091__$1 = state_20091;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20091__$1,(4),ch);
} else {
if((state_val_20092 === (11))){
var inst_20071 = (state_20091[(2)]);
var inst_20072 = (new Array(n));
var inst_20055 = inst_20072;
var inst_20056 = (0);
var state_20091__$1 = (function (){var statearr_20103 = state_20091;
(statearr_20103[(10)] = inst_20071);

(statearr_20103[(7)] = inst_20056);

(statearr_20103[(8)] = inst_20055);

return statearr_20103;
})();
var statearr_20104_20134 = state_20091__$1;
(statearr_20104_20134[(2)] = null);

(statearr_20104_20134[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20092 === (9))){
var inst_20055 = (state_20091[(8)]);
var inst_20069 = cljs.core.vec.call(null,inst_20055);
var state_20091__$1 = state_20091;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20091__$1,(11),out,inst_20069);
} else {
if((state_val_20092 === (5))){
var inst_20056 = (state_20091[(7)]);
var inst_20055 = (state_20091[(8)]);
var inst_20059 = (state_20091[(9)]);
var inst_20064 = (state_20091[(11)]);
var inst_20063 = (inst_20055[inst_20056] = inst_20059);
var inst_20064__$1 = (inst_20056 + (1));
var inst_20065 = (inst_20064__$1 < n);
var state_20091__$1 = (function (){var statearr_20105 = state_20091;
(statearr_20105[(12)] = inst_20063);

(statearr_20105[(11)] = inst_20064__$1);

return statearr_20105;
})();
if(cljs.core.truth_(inst_20065)){
var statearr_20106_20135 = state_20091__$1;
(statearr_20106_20135[(1)] = (8));

} else {
var statearr_20107_20136 = state_20091__$1;
(statearr_20107_20136[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20092 === (14))){
var inst_20084 = (state_20091[(2)]);
var inst_20085 = cljs.core.async.close_BANG_.call(null,out);
var state_20091__$1 = (function (){var statearr_20109 = state_20091;
(statearr_20109[(13)] = inst_20084);

return statearr_20109;
})();
var statearr_20110_20137 = state_20091__$1;
(statearr_20110_20137[(2)] = inst_20085);

(statearr_20110_20137[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20092 === (10))){
var inst_20075 = (state_20091[(2)]);
var state_20091__$1 = state_20091;
var statearr_20111_20138 = state_20091__$1;
(statearr_20111_20138[(2)] = inst_20075);

(statearr_20111_20138[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20092 === (8))){
var inst_20055 = (state_20091[(8)]);
var inst_20064 = (state_20091[(11)]);
var tmp20108 = inst_20055;
var inst_20055__$1 = tmp20108;
var inst_20056 = inst_20064;
var state_20091__$1 = (function (){var statearr_20112 = state_20091;
(statearr_20112[(7)] = inst_20056);

(statearr_20112[(8)] = inst_20055__$1);

return statearr_20112;
})();
var statearr_20113_20139 = state_20091__$1;
(statearr_20113_20139[(2)] = null);

(statearr_20113_20139[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___20125,out))
;
return ((function (switch__8364__auto__,c__8429__auto___20125,out){
return (function() {
var cljs$core$async$state_machine__8365__auto__ = null;
var cljs$core$async$state_machine__8365__auto____0 = (function (){
var statearr_20117 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20117[(0)] = cljs$core$async$state_machine__8365__auto__);

(statearr_20117[(1)] = (1));

return statearr_20117;
});
var cljs$core$async$state_machine__8365__auto____1 = (function (state_20091){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_20091);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e20118){if((e20118 instanceof Object)){
var ex__8368__auto__ = e20118;
var statearr_20119_20140 = state_20091;
(statearr_20119_20140[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20091);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20118;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20141 = state_20091;
state_20091 = G__20141;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$state_machine__8365__auto__ = function(state_20091){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8365__auto____1.call(this,state_20091);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8365__auto____0;
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8365__auto____1;
return cljs$core$async$state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___20125,out))
})();
var state__8431__auto__ = (function (){var statearr_20120 = f__8430__auto__.call(null);
(statearr_20120[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___20125);

return statearr_20120;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});})(c__8429__auto___20125,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args20142 = [];
var len__5627__auto___20216 = arguments.length;
var i__5628__auto___20217 = (0);
while(true){
if((i__5628__auto___20217 < len__5627__auto___20216)){
args20142.push((arguments[i__5628__auto___20217]));

var G__20218 = (i__5628__auto___20217 + (1));
i__5628__auto___20217 = G__20218;
continue;
} else {
}
break;
}

var G__20144 = args20142.length;
switch (G__20144) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20142.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8429__auto___20220 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8429__auto___20220,out){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___20220,out){
return (function (state_20186){
var state_val_20187 = (state_20186[(1)]);
if((state_val_20187 === (7))){
var inst_20182 = (state_20186[(2)]);
var state_20186__$1 = state_20186;
var statearr_20188_20221 = state_20186__$1;
(statearr_20188_20221[(2)] = inst_20182);

(statearr_20188_20221[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20187 === (1))){
var inst_20145 = [];
var inst_20146 = inst_20145;
var inst_20147 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_20186__$1 = (function (){var statearr_20189 = state_20186;
(statearr_20189[(7)] = inst_20146);

(statearr_20189[(8)] = inst_20147);

return statearr_20189;
})();
var statearr_20190_20222 = state_20186__$1;
(statearr_20190_20222[(2)] = null);

(statearr_20190_20222[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20187 === (4))){
var inst_20150 = (state_20186[(9)]);
var inst_20150__$1 = (state_20186[(2)]);
var inst_20151 = (inst_20150__$1 == null);
var inst_20152 = cljs.core.not.call(null,inst_20151);
var state_20186__$1 = (function (){var statearr_20191 = state_20186;
(statearr_20191[(9)] = inst_20150__$1);

return statearr_20191;
})();
if(inst_20152){
var statearr_20192_20223 = state_20186__$1;
(statearr_20192_20223[(1)] = (5));

} else {
var statearr_20193_20224 = state_20186__$1;
(statearr_20193_20224[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20187 === (15))){
var inst_20176 = (state_20186[(2)]);
var state_20186__$1 = state_20186;
var statearr_20194_20225 = state_20186__$1;
(statearr_20194_20225[(2)] = inst_20176);

(statearr_20194_20225[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20187 === (13))){
var state_20186__$1 = state_20186;
var statearr_20195_20226 = state_20186__$1;
(statearr_20195_20226[(2)] = null);

(statearr_20195_20226[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20187 === (6))){
var inst_20146 = (state_20186[(7)]);
var inst_20171 = inst_20146.length;
var inst_20172 = (inst_20171 > (0));
var state_20186__$1 = state_20186;
if(cljs.core.truth_(inst_20172)){
var statearr_20196_20227 = state_20186__$1;
(statearr_20196_20227[(1)] = (12));

} else {
var statearr_20197_20228 = state_20186__$1;
(statearr_20197_20228[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20187 === (3))){
var inst_20184 = (state_20186[(2)]);
var state_20186__$1 = state_20186;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20186__$1,inst_20184);
} else {
if((state_val_20187 === (12))){
var inst_20146 = (state_20186[(7)]);
var inst_20174 = cljs.core.vec.call(null,inst_20146);
var state_20186__$1 = state_20186;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20186__$1,(15),out,inst_20174);
} else {
if((state_val_20187 === (2))){
var state_20186__$1 = state_20186;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20186__$1,(4),ch);
} else {
if((state_val_20187 === (11))){
var inst_20154 = (state_20186[(10)]);
var inst_20150 = (state_20186[(9)]);
var inst_20164 = (state_20186[(2)]);
var inst_20165 = [];
var inst_20166 = inst_20165.push(inst_20150);
var inst_20146 = inst_20165;
var inst_20147 = inst_20154;
var state_20186__$1 = (function (){var statearr_20198 = state_20186;
(statearr_20198[(7)] = inst_20146);

(statearr_20198[(8)] = inst_20147);

(statearr_20198[(11)] = inst_20164);

(statearr_20198[(12)] = inst_20166);

return statearr_20198;
})();
var statearr_20199_20229 = state_20186__$1;
(statearr_20199_20229[(2)] = null);

(statearr_20199_20229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20187 === (9))){
var inst_20146 = (state_20186[(7)]);
var inst_20162 = cljs.core.vec.call(null,inst_20146);
var state_20186__$1 = state_20186;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20186__$1,(11),out,inst_20162);
} else {
if((state_val_20187 === (5))){
var inst_20147 = (state_20186[(8)]);
var inst_20154 = (state_20186[(10)]);
var inst_20150 = (state_20186[(9)]);
var inst_20154__$1 = f.call(null,inst_20150);
var inst_20155 = cljs.core._EQ_.call(null,inst_20154__$1,inst_20147);
var inst_20156 = cljs.core.keyword_identical_QMARK_.call(null,inst_20147,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_20157 = (inst_20155) || (inst_20156);
var state_20186__$1 = (function (){var statearr_20200 = state_20186;
(statearr_20200[(10)] = inst_20154__$1);

return statearr_20200;
})();
if(cljs.core.truth_(inst_20157)){
var statearr_20201_20230 = state_20186__$1;
(statearr_20201_20230[(1)] = (8));

} else {
var statearr_20202_20231 = state_20186__$1;
(statearr_20202_20231[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20187 === (14))){
var inst_20179 = (state_20186[(2)]);
var inst_20180 = cljs.core.async.close_BANG_.call(null,out);
var state_20186__$1 = (function (){var statearr_20204 = state_20186;
(statearr_20204[(13)] = inst_20179);

return statearr_20204;
})();
var statearr_20205_20232 = state_20186__$1;
(statearr_20205_20232[(2)] = inst_20180);

(statearr_20205_20232[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20187 === (10))){
var inst_20169 = (state_20186[(2)]);
var state_20186__$1 = state_20186;
var statearr_20206_20233 = state_20186__$1;
(statearr_20206_20233[(2)] = inst_20169);

(statearr_20206_20233[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20187 === (8))){
var inst_20146 = (state_20186[(7)]);
var inst_20154 = (state_20186[(10)]);
var inst_20150 = (state_20186[(9)]);
var inst_20159 = inst_20146.push(inst_20150);
var tmp20203 = inst_20146;
var inst_20146__$1 = tmp20203;
var inst_20147 = inst_20154;
var state_20186__$1 = (function (){var statearr_20207 = state_20186;
(statearr_20207[(7)] = inst_20146__$1);

(statearr_20207[(8)] = inst_20147);

(statearr_20207[(14)] = inst_20159);

return statearr_20207;
})();
var statearr_20208_20234 = state_20186__$1;
(statearr_20208_20234[(2)] = null);

(statearr_20208_20234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___20220,out))
;
return ((function (switch__8364__auto__,c__8429__auto___20220,out){
return (function() {
var cljs$core$async$state_machine__8365__auto__ = null;
var cljs$core$async$state_machine__8365__auto____0 = (function (){
var statearr_20212 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20212[(0)] = cljs$core$async$state_machine__8365__auto__);

(statearr_20212[(1)] = (1));

return statearr_20212;
});
var cljs$core$async$state_machine__8365__auto____1 = (function (state_20186){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_20186);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e20213){if((e20213 instanceof Object)){
var ex__8368__auto__ = e20213;
var statearr_20214_20235 = state_20186;
(statearr_20214_20235[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20186);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20213;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20236 = state_20186;
state_20186 = G__20236;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$state_machine__8365__auto__ = function(state_20186){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8365__auto____1.call(this,state_20186);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8365__auto____0;
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8365__auto____1;
return cljs$core$async$state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___20220,out))
})();
var state__8431__auto__ = (function (){var statearr_20215 = f__8430__auto__.call(null);
(statearr_20215[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___20220);

return statearr_20215;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});})(c__8429__auto___20220,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
