// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var extra_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,hatti.constants._id,cljs.core.cst$kw$label,"id",cljs.core.cst$kw$name,hatti.constants._id,cljs.core.cst$kw$type,"integer"], null)], null);
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
return extra_field;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(extra_field,hatti.ona.forms.submission_time_field);
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__5634__auto__ = [];
var len__5627__auto___32718 = arguments.length;
var i__5628__auto___32719 = (0);
while(true){
if((i__5628__auto___32719 < len__5627__auto___32718)){
args__5634__auto__.push((arguments[i__5628__auto___32719]));

var G__32720 = (i__5628__auto___32719 + (1));
i__5628__auto___32719 = G__32720;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__32715){
var map__32716 = p__32715;
var map__32716__$1 = ((((!((map__32716 == null)))?((((map__32716.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32716.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32716):map__32716);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32716__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(hatti.views.table.get_extra_fields(is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,cljs.core.not(is_filtered_dataview_QMARK_)], 0))], 0))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq32713){
var G__32714 = cljs.core.first(seq32713);
var seq32713__$1 = cljs.core.next(seq32713);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__32714,seq32713__$1);
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__32721_SHARP_){
if(typeof p1__32721_SHARP_ === 'string'){
return clojure.string.lower_case(p1__32721_SHARP_);
} else {
return p1__32721_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__32725){
var vec__32726 = p__32725;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32726,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32726,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,null,true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__32722_SHARP_){
return cljs.core.re_find(hatti.utils.safe_regex(query),[cljs.core.str(p1__32722_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(field,clj_value,language,true);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args32727 = [];
var len__5627__auto___32751 = arguments.length;
var i__5628__auto___32752 = (0);
while(true){
if((i__5628__auto___32752 < len__5627__auto___32751)){
args32727.push((arguments[i__5628__auto___32752]));

var G__32753 = (i__5628__auto___32752 + (1));
i__5628__auto___32752 = G__32753;
continue;
} else {
}
break;
}

var G__32733 = args32727.length;
switch (G__32733) {
case 1:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args32727.slice((3)),(0)));
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1 = (function (form){
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2(form,true);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2 = (function (form,get_label_QMARK_){
return hatti.views.table.flat_form__GT_sg_columns(form,get_label_QMARK_,null);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,get_label_QMARK_,language,p__32734){
var map__32735 = p__32734;
var map__32735__$1 = ((((!((map__32735 == null)))?((((map__32735.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32735.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32735):map__32735);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32735__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
return cljs.core.clj__GT_js((function (){var iter__5341__auto__ = ((function (map__32735,map__32735__$1,is_filtered_dataview_QMARK_){
return (function hatti$views$table$iter__32737(s__32738){
return (new cljs.core.LazySeq(null,((function (map__32735,map__32735__$1,is_filtered_dataview_QMARK_){
return (function (){
var s__32738__$1 = s__32738;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__32738__$1);
if(temp__4425__auto__){
var s__32738__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__32738__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__32738__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__32740 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__32739 = (0);
while(true){
if((i__32739 < size__5340__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__32739);
cljs.core.chunk_append(b__32740,(function (){var map__32747 = field;
var map__32747__$1 = ((((!((map__32747 == null)))?((((map__32747.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32747.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32747):map__32747);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32747__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32747__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32747__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hatti.ona.forms.get_column_class(field),label,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class(field),label]);
})());

var G__32755 = (i__32739 + (1));
i__32739 = G__32755;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__32740),hatti$views$table$iter__32737(cljs.core.chunk_rest(s__32738__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__32740),null);
}
} else {
var field = cljs.core.first(s__32738__$2);
return cljs.core.cons((function (){var map__32749 = field;
var map__32749__$1 = ((((!((map__32749 == null)))?((((map__32749.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32749.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32749):map__32749);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32749__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32749__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32749__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hatti.ona.forms.get_column_class(field),label,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class(field),label]);
})(),hatti$views$table$iter__32737(cljs.core.rest(s__32738__$2)));
}
} else {
return null;
}
break;
}
});})(map__32735,map__32735__$1,is_filtered_dataview_QMARK_))
,null,null));
});})(map__32735,map__32735__$1,is_filtered_dataview_QMARK_))
;
return iter__5341__auto__(hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0)));
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq32728){
var G__32729 = cljs.core.first(seq32728);
var seq32728__$1 = cljs.core.next(seq32728);
var G__32730 = cljs.core.first(seq32728__$1);
var seq32728__$2 = cljs.core.next(seq32728__$1);
var G__32731 = cljs.core.first(seq32728__$2);
var seq32728__$3 = cljs.core.next(seq32728__$2);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__32729,G__32730,G__32731,seq32728__$3);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (3);
hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__32757 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__32757);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = {"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": true};
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__32768(s__32769){
return (new cljs.core.LazySeq(null,(function (){
var s__32769__$1 = s__32769;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__32769__$1);
if(temp__4425__auto__){
var s__32769__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__32769__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__32769__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__32771 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__32770 = (0);
while(true){
if((i__32770 < size__5340__auto__)){
var vec__32776 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__32770);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32776,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32776,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__32771,event.subscribe(handler_function));

var G__32778 = (i__32770 + (1));
i__32770 = G__32778;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__32771),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__32768(cljs.core.chunk_rest(s__32769__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__32771),null);
}
} else {
var vec__32777 = cljs.core.first(s__32769__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32777,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32777,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__32768(cljs.core.rest(s__32769__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__32789(s__32790){
return (new cljs.core.LazySeq(null,(function (){
var s__32790__$1 = s__32790;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__32790__$1);
if(temp__4425__auto__){
var s__32790__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__32790__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__32790__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__32792 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__32791 = (0);
while(true){
if((i__32791 < size__5340__auto__)){
var vec__32797 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__32791);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32797,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32797,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__32792,event.subscribe(handler_function));

var G__32799 = (i__32791 + (1));
i__32791 = G__32799;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__32792),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__32789(cljs.core.chunk_rest(s__32790__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__32792),null);
}
} else {
var vec__32798 = cljs.core.first(s__32790__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32798,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32798,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__32789(cljs.core.rest(s__32790__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,p__32800){
var map__32809 = p__32800;
var map__32809__$1 = ((((!((map__32809 == null)))?((((map__32809.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32809.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32809):map__32809);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32809__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32809__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,true,current_language,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
var map__32811 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__32811__$1 = ((((!((map__32811 == null)))?((((map__32811.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32811.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32811):map__32811);
var map__32812 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32811__$1,cljs.core.cst$kw$table_DASH_page);
var map__32812__$1 = ((((!((map__32812 == null)))?((((map__32812.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32812.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32812):map__32812);
var map__32813 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32812__$1,cljs.core.cst$kw$paging);
var map__32813__$1 = ((((!((map__32813 == null)))?((((map__32813.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32813.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32813):map__32813);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32813__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32813__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__32811,map__32811__$1,map__32812,map__32812__$1,map__32813,map__32813__$1,num_displayed_records,total_page_count,map__32809,map__32809__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__32811,map__32811__$1,map__32812,map__32812__$1,map__32813,map__32813__$1,num_displayed_records,total_page_count,map__32809,map__32809__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__32811,map__32811__$1,map__32812,map__32812__$1,map__32813,map__32813__$1,num_displayed_records,total_page_count,map__32809,map__32809__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__32811,map__32811__$1,map__32812,map__32812__$1,map__32813,map__32813__$1,num_displayed_records,total_page_count,map__32809,map__32809__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__32811,map__32811__$1,map__32812,map__32812__$1,map__32813,map__32813__$1,num_displayed_records,total_page_count,map__32809,map__32809__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(columns,SlickGrid,DataView,dataview,grid,map__32811,map__32811__$1,map__32812,map__32812__$1,map__32813,map__32813__$1,num_displayed_records,total_page_count,map__32809,map__32809__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions({"pageSize": (function (){var or__4569__auto__ = num_displayed_records;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count});

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js(data),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__8429__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto__,event_chan){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto__,event_chan){
return (function (state_33078){
var state_val_33079 = (state_33078[(1)]);
if((state_val_33079 === (7))){
var inst_32987 = (state_33078[(7)]);
var inst_32987__$1 = (state_33078[(2)]);
var inst_32989 = (inst_32987__$1 == null);
var inst_32990 = cljs.core.not(inst_32989);
var state_33078__$1 = (function (){var statearr_33080 = state_33078;
(statearr_33080[(7)] = inst_32987__$1);

return statearr_33080;
})();
if(inst_32990){
var statearr_33081_33148 = state_33078__$1;
(statearr_33081_33148[(1)] = (8));

} else {
var statearr_33082_33149 = state_33078__$1;
(statearr_33082_33149[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (20))){
var inst_33009 = (state_33078[(8)]);
var inst_33017 = (state_33078[(9)]);
var inst_33026 = (inst_33017.cljs$core$IFn$_invoke$arity$1 ? inst_33017.cljs$core$IFn$_invoke$arity$1(inst_33009) : inst_33017.call(null,inst_33009));
var state_33078__$1 = state_33078;
var statearr_33083_33150 = state_33078__$1;
(statearr_33083_33150[(2)] = inst_33026);

(statearr_33083_33150[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (27))){
var state_33078__$1 = state_33078;
var statearr_33084_33151 = state_33078__$1;
(statearr_33084_33151[(2)] = null);

(statearr_33084_33151[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (1))){
var state_33078__$1 = state_33078;
var statearr_33085_33152 = state_33078__$1;
(statearr_33085_33152[(2)] = null);

(statearr_33085_33152[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (24))){
var state_33078__$1 = state_33078;
var statearr_33086_33153 = state_33078__$1;
(statearr_33086_33153[(2)] = null);

(statearr_33086_33153[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (4))){
var state_33078__$1 = state_33078;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33078__$1,(7),event_chan);
} else {
if((state_val_33079 === (15))){
var inst_32987 = (state_33078[(7)]);
var state_33078__$1 = state_33078;
var statearr_33087_33154 = state_33078__$1;
(statearr_33087_33154[(2)] = inst_32987);

(statearr_33087_33154[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (21))){
var state_33078__$1 = state_33078;
var statearr_33088_33155 = state_33078__$1;
(statearr_33088_33155[(2)] = null);

(statearr_33088_33155[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (31))){
var inst_33013 = (state_33078[(10)]);
var inst_33051 = (state_33078[(2)]);
var inst_33052 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33013,cljs.core.cst$kw$table);
var state_33078__$1 = (function (){var statearr_33089 = state_33078;
(statearr_33089[(11)] = inst_33051);

return statearr_33089;
})();
if(inst_33052){
var statearr_33090_33156 = state_33078__$1;
(statearr_33090_33156[(1)] = (32));

} else {
var statearr_33091_33157 = state_33078__$1;
(statearr_33091_33157[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (32))){
var inst_33008 = (state_33078[(12)]);
var inst_33013 = (state_33078[(10)]);
var inst_32987 = (state_33078[(7)]);
var inst_33009 = (state_33078[(8)]);
var inst_33010 = (state_33078[(13)]);
var inst_33018 = (state_33078[(14)]);
var inst_33012 = (state_33078[(15)]);
var inst_33017 = (state_33078[(9)]);
var inst_33011 = (state_33078[(16)]);
var inst_33007 = (state_33078[(17)]);
var inst_33065 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_33066 = (function (){var new_columns = inst_33012;
var submission_clicked = inst_33009;
var submission_unclicked = inst_33010;
var get_submission_data = inst_33018;
var re_render = inst_33013;
var update_data_BANG_ = inst_33017;
var map__32985 = inst_33007;
var submission_to_rank = inst_33008;
var e = inst_32987;
var c__8429__auto____$1 = inst_33065;
var filter_by = inst_33011;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__32985,submission_to_rank,e,c__8429__auto____$1,filter_by,inst_33008,inst_33013,inst_32987,inst_33009,inst_33010,inst_33018,inst_33012,inst_33017,inst_33011,inst_33007,inst_33065,state_val_33079,c__8429__auto__,event_chan){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__32985,submission_to_rank,e,c__8429__auto____$1,filter_by,inst_33008,inst_33013,inst_32987,inst_33009,inst_33010,inst_33018,inst_33012,inst_33017,inst_33011,inst_33007,inst_33065,state_val_33079,c__8429__auto__,event_chan){
return (function (state_33063){
var state_val_33064 = (state_33063[(1)]);
if((state_val_33064 === (1))){
var inst_33054 = cljs.core.async.timeout((20));
var state_33063__$1 = state_33063;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33063__$1,(2),inst_33054);
} else {
if((state_val_33064 === (2))){
var inst_33056 = (state_33063[(2)]);
var inst_33057 = grid.resizeCanvas();
var inst_33058 = grid.invalidateAllRows();
var inst_33059 = hatti.views.table.resizeColumns(grid);
var inst_33060 = grid.render();
var inst_33061 = hatti.views.table.init_sg_pager(grid,dataview);
var state_33063__$1 = (function (){var statearr_33092 = state_33063;
(statearr_33092[(7)] = inst_33060);

(statearr_33092[(8)] = inst_33056);

(statearr_33092[(9)] = inst_33057);

(statearr_33092[(10)] = inst_33059);

(statearr_33092[(11)] = inst_33058);

return statearr_33092;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33063__$1,inst_33061);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__32985,submission_to_rank,e,c__8429__auto____$1,filter_by,inst_33008,inst_33013,inst_32987,inst_33009,inst_33010,inst_33018,inst_33012,inst_33017,inst_33011,inst_33007,inst_33065,state_val_33079,c__8429__auto__,event_chan))
;
return ((function (switch__8364__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__32985,submission_to_rank,e,c__8429__auto____$1,filter_by,inst_33008,inst_33013,inst_32987,inst_33009,inst_33010,inst_33018,inst_33012,inst_33017,inst_33011,inst_33007,inst_33065,state_val_33079,c__8429__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__8365__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__8365__auto____0 = (function (){
var statearr_33096 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33096[(0)] = hatti$views$table$handle_table_events_$_state_machine__8365__auto__);

(statearr_33096[(1)] = (1));

return statearr_33096;
});
var hatti$views$table$handle_table_events_$_state_machine__8365__auto____1 = (function (state_33063){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_33063);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e33097){if((e33097 instanceof Object)){
var ex__8368__auto__ = e33097;
var statearr_33098_33158 = state_33063;
(statearr_33098_33158[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33063);

return cljs.core.cst$kw$recur;
} else {
throw e33097;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__33159 = state_33063;
state_33063 = G__33159;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__8365__auto__ = function(state_33063){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__8365__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__8365__auto____1.call(this,state_33063);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__8365__auto____0;
hatti$views$table$handle_table_events_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__8365__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__32985,submission_to_rank,e,c__8429__auto____$1,filter_by,inst_33008,inst_33013,inst_32987,inst_33009,inst_33010,inst_33018,inst_33012,inst_33017,inst_33011,inst_33007,inst_33065,state_val_33079,c__8429__auto__,event_chan))
})();
var state__8431__auto__ = (function (){var statearr_33099 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_33099[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto____$1);

return statearr_33099;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__32985,submission_to_rank,e,c__8429__auto____$1,filter_by,inst_33008,inst_33013,inst_32987,inst_33009,inst_33010,inst_33018,inst_33012,inst_33017,inst_33011,inst_33007,inst_33065,state_val_33079,c__8429__auto__,event_chan))
})();
var inst_33067 = cljs.core.async.impl.dispatch.run(inst_33066);
var state_33078__$1 = (function (){var statearr_33100 = state_33078;
(statearr_33100[(18)] = inst_33067);

return statearr_33100;
})();
var statearr_33101_33160 = state_33078__$1;
(statearr_33101_33160[(2)] = inst_33065);

(statearr_33101_33160[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (33))){
var state_33078__$1 = state_33078;
var statearr_33102_33161 = state_33078__$1;
(statearr_33102_33161[(2)] = null);

(statearr_33102_33161[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (13))){
var inst_32999 = (state_33078[(2)]);
var state_33078__$1 = state_33078;
var statearr_33103_33162 = state_33078__$1;
(statearr_33103_33162[(2)] = inst_32999);

(statearr_33103_33162[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (22))){
var inst_33010 = (state_33078[(13)]);
var inst_33029 = (state_33078[(2)]);
var state_33078__$1 = (function (){var statearr_33104 = state_33078;
(statearr_33104[(19)] = inst_33029);

return statearr_33104;
})();
if(cljs.core.truth_(inst_33010)){
var statearr_33105_33163 = state_33078__$1;
(statearr_33105_33163[(1)] = (23));

} else {
var statearr_33106_33164 = state_33078__$1;
(statearr_33106_33164[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (29))){
var inst_33011 = (state_33078[(16)]);
var inst_33043 = [cljs.core.cst$kw$query];
var inst_33044 = [inst_33011];
var inst_33045 = cljs.core.PersistentHashMap.fromArrays(inst_33043,inst_33044);
var inst_33046 = cljs.core.clj__GT_js(inst_33045);
var inst_33047 = dataview.setFilterArgs(inst_33046);
var inst_33048 = dataview.refresh();
var state_33078__$1 = (function (){var statearr_33107 = state_33078;
(statearr_33107[(20)] = inst_33047);

return statearr_33107;
})();
var statearr_33108_33165 = state_33078__$1;
(statearr_33108_33165[(2)] = inst_33048);

(statearr_33108_33165[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (6))){
var inst_33074 = (state_33078[(2)]);
var state_33078__$1 = state_33078;
var statearr_33109_33166 = state_33078__$1;
(statearr_33109_33166[(2)] = inst_33074);

(statearr_33109_33166[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (28))){
var inst_33011 = (state_33078[(16)]);
var inst_33041 = (state_33078[(2)]);
var state_33078__$1 = (function (){var statearr_33110 = state_33078;
(statearr_33110[(21)] = inst_33041);

return statearr_33110;
})();
if(cljs.core.truth_(inst_33011)){
var statearr_33111_33167 = state_33078__$1;
(statearr_33111_33167[(1)] = (29));

} else {
var statearr_33112_33168 = state_33078__$1;
(statearr_33112_33168[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (25))){
var inst_33012 = (state_33078[(15)]);
var inst_33034 = (state_33078[(2)]);
var state_33078__$1 = (function (){var statearr_33113 = state_33078;
(statearr_33113[(22)] = inst_33034);

return statearr_33113;
})();
if(cljs.core.truth_(inst_33012)){
var statearr_33114_33169 = state_33078__$1;
(statearr_33114_33169[(1)] = (26));

} else {
var statearr_33115_33170 = state_33078__$1;
(statearr_33115_33170[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (34))){
var inst_33070 = (state_33078[(2)]);
var state_33078__$1 = (function (){var statearr_33116 = state_33078;
(statearr_33116[(23)] = inst_33070);

return statearr_33116;
})();
var statearr_33117_33171 = state_33078__$1;
(statearr_33117_33171[(2)] = null);

(statearr_33117_33171[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (17))){
var inst_33008 = (state_33078[(12)]);
var inst_33018 = (state_33078[(14)]);
var inst_33017 = (state_33078[(9)]);
var inst_33020 = (inst_33018.cljs$core$IFn$_invoke$arity$2 ? inst_33018.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_33008) : inst_33018.call(null,hatti.constants._rank,inst_33008));
var inst_33021 = (inst_33017.cljs$core$IFn$_invoke$arity$1 ? inst_33017.cljs$core$IFn$_invoke$arity$1(inst_33020) : inst_33017.call(null,inst_33020));
var state_33078__$1 = state_33078;
var statearr_33118_33172 = state_33078__$1;
(statearr_33118_33172[(2)] = inst_33021);

(statearr_33118_33172[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (3))){
var inst_33076 = (state_33078[(2)]);
var state_33078__$1 = state_33078;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33078__$1,inst_33076);
} else {
if((state_val_33079 === (12))){
var state_33078__$1 = state_33078;
var statearr_33119_33173 = state_33078__$1;
(statearr_33119_33173[(2)] = false);

(statearr_33119_33173[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (2))){
var state_33078__$1 = state_33078;
var statearr_33120_33174 = state_33078__$1;
(statearr_33120_33174[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (23))){
var inst_33017 = (state_33078[(9)]);
var inst_33031 = (inst_33017.cljs$core$IFn$_invoke$arity$1 ? inst_33017.cljs$core$IFn$_invoke$arity$1(null) : inst_33017.call(null,null));
var state_33078__$1 = state_33078;
var statearr_33122_33175 = state_33078__$1;
(statearr_33122_33175[(2)] = inst_33031);

(statearr_33122_33175[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (19))){
var inst_33009 = (state_33078[(8)]);
var inst_33024 = (state_33078[(2)]);
var state_33078__$1 = (function (){var statearr_33123 = state_33078;
(statearr_33123[(24)] = inst_33024);

return statearr_33123;
})();
if(cljs.core.truth_(inst_33009)){
var statearr_33124_33176 = state_33078__$1;
(statearr_33124_33176[(1)] = (20));

} else {
var statearr_33125_33177 = state_33078__$1;
(statearr_33125_33177[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (11))){
var state_33078__$1 = state_33078;
var statearr_33126_33178 = state_33078__$1;
(statearr_33126_33178[(2)] = true);

(statearr_33126_33178[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (9))){
var state_33078__$1 = state_33078;
var statearr_33127_33179 = state_33078__$1;
(statearr_33127_33179[(2)] = false);

(statearr_33127_33179[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (5))){
var state_33078__$1 = state_33078;
var statearr_33128_33180 = state_33078__$1;
(statearr_33128_33180[(2)] = null);

(statearr_33128_33180[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (14))){
var inst_32987 = (state_33078[(7)]);
var inst_33004 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32987);
var state_33078__$1 = state_33078;
var statearr_33129_33181 = state_33078__$1;
(statearr_33129_33181[(2)] = inst_33004);

(statearr_33129_33181[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (26))){
var inst_33012 = (state_33078[(15)]);
var inst_33036 = grid.setColumns(inst_33012);
var inst_33037 = hatti.views.table.resizeColumns(grid);
var inst_33038 = grid.render();
var state_33078__$1 = (function (){var statearr_33130 = state_33078;
(statearr_33130[(25)] = inst_33036);

(statearr_33130[(26)] = inst_33037);

return statearr_33130;
})();
var statearr_33131_33182 = state_33078__$1;
(statearr_33131_33182[(2)] = inst_33038);

(statearr_33131_33182[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (16))){
var inst_33008 = (state_33078[(12)]);
var inst_33013 = (state_33078[(10)]);
var inst_32987 = (state_33078[(7)]);
var inst_33009 = (state_33078[(8)]);
var inst_33010 = (state_33078[(13)]);
var inst_33012 = (state_33078[(15)]);
var inst_33017 = (state_33078[(9)]);
var inst_33011 = (state_33078[(16)]);
var inst_33007 = (state_33078[(17)]);
var inst_33007__$1 = (state_33078[(2)]);
var inst_33008__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33007__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_33009__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33007__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_33010__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33007__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_33011__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33007__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_33012__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33007__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_33013__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33007__$1,cljs.core.cst$kw$re_DASH_render);
var inst_33014 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33015 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_33016 = (new cljs.core.PersistentVector(null,3,(5),inst_33014,inst_33015,null));
var inst_33017__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_33016);
var inst_33018 = (function (){var e = inst_32987;
var map__32985 = inst_33007__$1;
var submission_to_rank = inst_33008__$1;
var submission_clicked = inst_33009__$1;
var submission_unclicked = inst_33010__$1;
var filter_by = inst_33011__$1;
var new_columns = inst_33012__$1;
var re_render = inst_33013__$1;
var update_data_BANG_ = inst_33017__$1;
return ((function (e,map__32985,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_33008,inst_33013,inst_32987,inst_33009,inst_33010,inst_33012,inst_33017,inst_33011,inst_33007,inst_33007__$1,inst_33008__$1,inst_33009__$1,inst_33010__$1,inst_33011__$1,inst_33012__$1,inst_33013__$1,inst_33014,inst_33015,inst_33016,inst_33017__$1,state_val_33079,c__8429__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (e,map__32985,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_33008,inst_33013,inst_32987,inst_33009,inst_33010,inst_33012,inst_33017,inst_33011,inst_33007,inst_33007__$1,inst_33008__$1,inst_33009__$1,inst_33010__$1,inst_33011__$1,inst_33012__$1,inst_33013__$1,inst_33014,inst_33015,inst_33016,inst_33017__$1,state_val_33079,c__8429__auto__,event_chan){
return (function (p1__32817_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__32817_SHARP_,field));
});})(e,map__32985,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_33008,inst_33013,inst_32987,inst_33009,inst_33010,inst_33012,inst_33017,inst_33011,inst_33007,inst_33007__$1,inst_33008__$1,inst_33009__$1,inst_33010__$1,inst_33011__$1,inst_33012__$1,inst_33013__$1,inst_33014,inst_33015,inst_33016,inst_33017__$1,state_val_33079,c__8429__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(e,map__32985,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_33008,inst_33013,inst_32987,inst_33009,inst_33010,inst_33012,inst_33017,inst_33011,inst_33007,inst_33007__$1,inst_33008__$1,inst_33009__$1,inst_33010__$1,inst_33011__$1,inst_33012__$1,inst_33013__$1,inst_33014,inst_33015,inst_33016,inst_33017__$1,state_val_33079,c__8429__auto__,event_chan))
})();
var state_33078__$1 = (function (){var statearr_33132 = state_33078;
(statearr_33132[(12)] = inst_33008__$1);

(statearr_33132[(10)] = inst_33013__$1);

(statearr_33132[(8)] = inst_33009__$1);

(statearr_33132[(13)] = inst_33010__$1);

(statearr_33132[(14)] = inst_33018);

(statearr_33132[(15)] = inst_33012__$1);

(statearr_33132[(9)] = inst_33017__$1);

(statearr_33132[(16)] = inst_33011__$1);

(statearr_33132[(17)] = inst_33007__$1);

return statearr_33132;
})();
if(cljs.core.truth_(inst_33008__$1)){
var statearr_33133_33183 = state_33078__$1;
(statearr_33133_33183[(1)] = (17));

} else {
var statearr_33134_33184 = state_33078__$1;
(statearr_33134_33184[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (30))){
var state_33078__$1 = state_33078;
var statearr_33135_33185 = state_33078__$1;
(statearr_33135_33185[(2)] = null);

(statearr_33135_33185[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (10))){
var inst_33002 = (state_33078[(2)]);
var state_33078__$1 = state_33078;
if(cljs.core.truth_(inst_33002)){
var statearr_33136_33186 = state_33078__$1;
(statearr_33136_33186[(1)] = (14));

} else {
var statearr_33137_33187 = state_33078__$1;
(statearr_33137_33187[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (18))){
var state_33078__$1 = state_33078;
var statearr_33138_33188 = state_33078__$1;
(statearr_33138_33188[(2)] = null);

(statearr_33138_33188[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33079 === (8))){
var inst_32987 = (state_33078[(7)]);
var inst_32992 = inst_32987.cljs$lang$protocol_mask$partition0$;
var inst_32993 = (inst_32992 & (64));
var inst_32994 = inst_32987.cljs$core$ISeq$;
var inst_32995 = (inst_32993) || (inst_32994);
var state_33078__$1 = state_33078;
if(cljs.core.truth_(inst_32995)){
var statearr_33139_33189 = state_33078__$1;
(statearr_33139_33189[(1)] = (11));

} else {
var statearr_33140_33190 = state_33078__$1;
(statearr_33140_33190[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto__,event_chan))
;
return ((function (switch__8364__auto__,c__8429__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__8365__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__8365__auto____0 = (function (){
var statearr_33144 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33144[(0)] = hatti$views$table$handle_table_events_$_state_machine__8365__auto__);

(statearr_33144[(1)] = (1));

return statearr_33144;
});
var hatti$views$table$handle_table_events_$_state_machine__8365__auto____1 = (function (state_33078){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_33078);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e33145){if((e33145 instanceof Object)){
var ex__8368__auto__ = e33145;
var statearr_33146_33191 = state_33078;
(statearr_33146_33191[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33078);

return cljs.core.cst$kw$recur;
} else {
throw e33145;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__33192 = state_33078;
state_33078 = G__33192;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__8365__auto__ = function(state_33078){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__8365__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__8365__auto____1.call(this,state_33078);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__8365__auto____0;
hatti$views$table$handle_table_events_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__8365__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto__,event_chan))
})();
var state__8431__auto__ = (function (){var statearr_33147 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_33147[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto__);

return statearr_33147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto__,event_chan))
);

return c__8429__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$name_DASH_or_DASH_label,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__5341__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__33203(s__33204){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__33204__$1 = s__33204;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__33204__$1);
if(temp__4425__auto__){
var s__33204__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__33204__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__33204__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__33206 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__33205 = (0);
while(true){
if((i__33205 < size__5340__auto__)){
var vec__33211 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__33205);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33211,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33211,(1),null);
cljs.core.chunk_append(b__33206,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__33205,vec__33211,k,v,c__5339__auto__,size__5340__auto__,b__33206,s__33204__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__33205,vec__33211,k,v,c__5339__auto__,size__5340__auto__,b__33206,s__33204__$2,temp__4425__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__33213 = (i__33205 + (1));
i__33205 = G__33213;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33206),hatti$views$table$render_options_$_iter__33203(cljs.core.chunk_rest(s__33204__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33206),null);
}
} else {
var vec__33212 = cljs.core.first(s__33204__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33212,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33212,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__33212,k,v,s__33204__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__33212,k,v,s__33204__$2,temp__4425__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__33203(cljs.core.rest(s__33204__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__5341__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table33215 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table33215 = (function (_,owner,meta33216){
this._ = _;
this.owner = owner;
this.meta33216 = meta33216;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table33215.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33217,meta33216__$1){
var self__ = this;
var _33217__$1 = this;
return (new hatti.views.table.t_hatti$views$table33215(self__._,self__.owner,meta33216__$1));
});

hatti.views.table.t_hatti$views$table33215.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33217){
var self__ = this;
var _33217__$1 = this;
return self__.meta33216;
});

hatti.views.table.t_hatti$views$table33215.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table33215.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name_DASH_or_DASH_label,cljs.core.cst$kw$label], null);
});

hatti.views.table.t_hatti$views$table33215.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table33215.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__33218){
var self__ = this;
var map__33219 = p__33218;
var map__33219__$1 = ((((!((map__33219 == null)))?((((map__33219.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33219.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33219):map__33219);
var name_or_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33219__$1,cljs.core.cst$kw$name_DASH_or_DASH_label);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33219__$1,cljs.core.cst$kw$language);
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__33221 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__33221__$1 = ((((!((map__33221 == null)))?((((map__33221.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33221.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33221):map__33221);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33221__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var colset_BANG_ = ((function (options,map__33221,map__33221__$1,flat_form,new_language,___$2,map__33219,map__33219__$1,name_or_label,language){
return (function (p1__33214_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns(flat_form,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__33214_SHARP_),new_language)], null));
});})(options,map__33221,map__33221__$1,flat_form,new_language,___$2,map__33219,map__33219__$1,name_or_label,language))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(name_or_label);
} else {
}

var G__33230 = {"className": "label-changer"};
var G__33231 = (function (){var G__33233 = {"className": "label-changer-label"};
var G__33234 = "Show:";
return React.DOM.span(G__33233,G__33234);
})();
var G__33232 = (function (){var G__33235 = {"id": "header-display-dropdown", "className": "drop-hover"};
var G__33236 = (function (){var attrs33225 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(name_or_label) : options.call(null,name_or_label));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs33225))?sablono.interpreter.attributes(attrs33225):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs33225))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__33238 = {"className": "fa fa-angle-down"};
return React.DOM.i(G__33238);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs33225),(function (){var G__33239 = {"className": "fa fa-angle-down"};
return React.DOM.i(G__33239);
})()], null))));
})();
var G__33237 = (function (){var G__33240 = {"className": "submenu no-dot"};
var G__33241 = sablono.interpreter.interpret(hatti.views.table.render_options(options,self__.owner,colset_BANG_));
return React.DOM.ul(G__33240,G__33241);
})();
return React.DOM.div(G__33235,G__33236,G__33237);
})();
return React.DOM.div(G__33230,G__33231,G__33232);
});

hatti.views.table.t_hatti$views$table33215.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta33216], null);
});

hatti.views.table.t_hatti$views$table33215.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table33215.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table33215";

hatti.views.table.t_hatti$views$table33215.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table33215");
});

hatti.views.table.__GT_t_hatti$views$table33215 = (function hatti$views$table$__GT_t_hatti$views$table33215(___$1,owner__$1,meta33216){
return (new hatti.views.table.t_hatti$views$table33215(___$1,owner__$1,meta33216));
});

}

return (new hatti.views.table.t_hatti$views$table33215(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__8429__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto__,query){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto__,query){
return (function (state_33284){
var state_val_33285 = (state_33284[(1)]);
if((state_val_33285 === (1))){
var inst_33270 = cljs.core.async.timeout((150));
var state_33284__$1 = state_33284;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33284__$1,(2),inst_33270);
} else {
if((state_val_33285 === (2))){
var inst_33272 = (state_33284[(2)]);
var inst_33273 = input.value;
var inst_33274 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_33273);
var state_33284__$1 = (function (){var statearr_33286 = state_33284;
(statearr_33286[(7)] = inst_33272);

return statearr_33286;
})();
if(inst_33274){
var statearr_33287_33298 = state_33284__$1;
(statearr_33287_33298[(1)] = (3));

} else {
var statearr_33288_33299 = state_33284__$1;
(statearr_33288_33299[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33285 === (3))){
var inst_33276 = [query_event_key];
var inst_33277 = [query];
var inst_33278 = cljs.core.PersistentHashMap.fromArrays(inst_33276,inst_33277);
var inst_33279 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_33278);
var state_33284__$1 = state_33284;
var statearr_33289_33300 = state_33284__$1;
(statearr_33289_33300[(2)] = inst_33279);

(statearr_33289_33300[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33285 === (4))){
var state_33284__$1 = state_33284;
var statearr_33290_33301 = state_33284__$1;
(statearr_33290_33301[(2)] = null);

(statearr_33290_33301[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33285 === (5))){
var inst_33282 = (state_33284[(2)]);
var state_33284__$1 = state_33284;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33284__$1,inst_33282);
} else {
return null;
}
}
}
}
}
});})(c__8429__auto__,query))
;
return ((function (switch__8364__auto__,c__8429__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__8365__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__8365__auto____0 = (function (){
var statearr_33294 = [null,null,null,null,null,null,null,null];
(statearr_33294[(0)] = hatti$views$table$delayed_search_$_state_machine__8365__auto__);

(statearr_33294[(1)] = (1));

return statearr_33294;
});
var hatti$views$table$delayed_search_$_state_machine__8365__auto____1 = (function (state_33284){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_33284);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e33295){if((e33295 instanceof Object)){
var ex__8368__auto__ = e33295;
var statearr_33296_33302 = state_33284;
(statearr_33296_33302[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33284);

return cljs.core.cst$kw$recur;
} else {
throw e33295;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__33303 = state_33284;
state_33284 = G__33303;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__8365__auto__ = function(state_33284){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__8365__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__8365__auto____1.call(this,state_33284);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__8365__auto____0;
hatti$views$table$delayed_search_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__8365__auto____1;
return hatti$views$table$delayed_search_$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto__,query))
})();
var state__8431__auto__ = (function (){var statearr_33297 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_33297[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto__);

return statearr_33297;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto__,query))
);

return c__8429__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table33305 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table33305 = (function (_,owner,meta33306){
this._ = _;
this.owner = owner;
this.meta33306 = meta33306;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table33305.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33307,meta33306__$1){
var self__ = this;
var _33307__$1 = this;
return (new hatti.views.table.t_hatti$views$table33305(self__._,self__.owner,meta33306__$1));
});

hatti.views.table.t_hatti$views$table33305.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33307){
var self__ = this;
var _33307__$1 = this;
return self__.meta33306;
});

hatti.views.table.t_hatti$views$table33305.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table33305.prototype.om$core$IRender$render$arity$1 = (function (this__6567__auto__){
var self__ = this;
var this__6567__auto____$1 = this;
var G__33310 = {"className": "table-search"};
var G__33311 = (function (){var G__33313 = {"className": "fa fa-search"};
return React.DOM.i(G__33313);
})();
var G__33312 = (function (){var G__33314 = {"type": "text", "placeholder": "Search", "onChange": ((function (G__33310,G__33311,this__6567__auto____$1){
return (function (p1__33304_SHARP_){
return hatti.views.table.delayed_search(p1__33304_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__33310,G__33311,this__6567__auto____$1))
};
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__33314) : sablono.interpreter.input.call(null,G__33314));
})();
return React.DOM.div(G__33310,G__33311,G__33312);
});

hatti.views.table.t_hatti$views$table33305.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta33306], null);
});

hatti.views.table.t_hatti$views$table33305.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table33305.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table33305";

hatti.views.table.t_hatti$views$table33305.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table33305");
});

hatti.views.table.__GT_t_hatti$views$table33305 = (function hatti$views$table$__GT_t_hatti$views$table33305(___$1,owner__$1,meta33306){
return (new hatti.views.table.t_hatti$views$table33305(___$1,owner__$1,meta33306));
});

}

return (new hatti.views.table.t_hatti$views$table33305(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner){
if(typeof hatti.views.table.t_hatti$views$table33315 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table33315 = (function (app_state,owner,meta33316){
this.app_state = app_state;
this.owner = owner;
this.meta33316 = meta33316;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table33315.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33317,meta33316__$1){
var self__ = this;
var _33317__$1 = this;
return (new hatti.views.table.t_hatti$views$table33315(self__.app_state,self__.owner,meta33316__$1));
});

hatti.views.table.t_hatti$views$table33315.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33317){
var self__ = this;
var _33317__$1 = this;
return self__.meta33316;
});

hatti.views.table.t_hatti$views$table33315.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table33315.prototype.om$core$IRender$render$arity$1 = (function (this__6567__auto__){
var self__ = this;
var this__6567__auto____$1 = this;
var G__33320 = {"className": "topbar"};
var G__33321 = (function (){var G__33325 = {"id": hatti.views.table.pager_id};
return React.DOM.div(G__33325);
})();
var G__33322 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,null));
var G__33323 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.app_state));
var G__33324 = (function (){var G__33326 = {"style": {"clear": "both"}};
return React.DOM.div(G__33326);
})();
return React.DOM.div(G__33320,G__33321,G__33322,G__33323,G__33324);
});

hatti.views.table.t_hatti$views$table33315.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta33316], null);
});

hatti.views.table.t_hatti$views$table33315.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table33315.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table33315";

hatti.views.table.t_hatti$views$table33315.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table33315");
});

hatti.views.table.__GT_t_hatti$views$table33315 = (function hatti$views$table$__GT_t_hatti$views$table33315(app_state__$1,owner__$1,meta33316){
return (new hatti.views.table.t_hatti$views$table33315(app_state__$1,owner__$1,meta33316));
});

}

return (new hatti.views.table.t_hatti$views$table33315(app_state,owner,null));
}));
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){

if(cljs.core.seq(data)){
var map__33330 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__33330__$1 = ((((!((map__33330 == null)))?((((map__33330.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33330.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33330):map__33330);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33330__$1,cljs.core.cst$kw$flat_DASH_form);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33330__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__33331 = hatti.views.table.sg_init(data,flat_form,current_language,is_filtered_dataview_QMARK_,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33331,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33331,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner,p__33334){
var map__33335 = p__33334;
var map__33335__$1 = ((((!((map__33335 == null)))?((((map__33335.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33335.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33335):map__33335);
var opts = map__33335__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33335__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

if(typeof hatti.views.table.t_hatti$views$table33337 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table33337 = (function (app_state,owner,p__33334,map__33335,opts,slick_grid_event_handlers,meta33338){
this.app_state = app_state;
this.owner = owner;
this.p__33334 = p__33334;
this.map__33335 = map__33335;
this.opts = opts;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.meta33338 = meta33338;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table33337.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__33335,map__33335__$1,opts,slick_grid_event_handlers){
return (function (_33339,meta33338__$1){
var self__ = this;
var _33339__$1 = this;
return (new hatti.views.table.t_hatti$views$table33337(self__.app_state,self__.owner,self__.p__33334,self__.map__33335,self__.opts,self__.slick_grid_event_handlers,meta33338__$1));
});})(map__33335,map__33335__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table33337.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__33335,map__33335__$1,opts,slick_grid_event_handlers){
return (function (_33339){
var self__ = this;
var _33339__$1 = this;
return self__.meta33338;
});})(map__33335,map__33335__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table33337.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table33337.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__33335,map__33335__$1,opts,slick_grid_event_handlers){
return (function (_,___$1){
var self__ = this;
var ___$2 = this;
var no_data_QMARK_ = cljs.core.empty_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null)));
var map__33340 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state);
var map__33340__$1 = ((((!((map__33340 == null)))?((((map__33340.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33340.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33340):map__33340);
var dataset_info = map__33340__$1;
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33340__$1,cljs.core.cst$kw$num_of_submissions);
var with_info = ((function (no_data_QMARK_,map__33340,map__33340__$1,dataset_info,num_of_submissions,___$2,map__33335,map__33335__$1,opts,slick_grid_event_handlers){
return (function (p1__33333_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__33333_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$dataset_DASH_info,dataset_info], null)], 0));
});})(no_data_QMARK_,map__33340,map__33340__$1,dataset_info,num_of_submissions,___$2,map__33335,map__33335__$1,opts,slick_grid_event_handlers))
;
var attrs33342 = om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked], null))),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs33342))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["table-view"], null)], null),attrs33342], 0))):{"className": "table-view"}),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs33342))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.app_state)),(function (){var G__33343 = {"id": hatti.views.table.table_id, "className": "slickgrid"};
var G__33344 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__33349 = {"className": "empty-state"};
var G__33350 = "No data";
return React.DOM.span(G__33349,G__33350);
})():(function (){var G__33352 = null;
var G__33353 = (function (){var G__33355 = {"className": "fa fa-spinner fa-pulse"};
return React.DOM.i(G__33355);
})();
var G__33354 = "Loading...";
return React.DOM.span(G__33352,G__33353,G__33354);
})());
return React.DOM.div(G__33343,G__33344);
})()], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs33342),sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.app_state)),(function (){var G__33356 = {"id": hatti.views.table.table_id, "className": "slickgrid"};
var G__33357 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__33362 = {"className": "empty-state"};
var G__33363 = "No data";
return React.DOM.span(G__33362,G__33363);
})():(function (){var G__33365 = null;
var G__33366 = (function (){var G__33368 = {"className": "fa fa-spinner fa-pulse"};
return React.DOM.i(G__33368);
})();
var G__33367 = "Loading...";
return React.DOM.span(G__33365,G__33366,G__33367);
})());
return React.DOM.div(G__33356,G__33357);
})()], null))));
});})(map__33335,map__33335__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table33337.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table33337.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (map__33335,map__33335__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__33369 = temp__4425__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33369,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33369,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid,dataview);
} else {
return null;
}
});})(map__33335,map__33335__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table33337.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table33337.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (map__33335,map__33335__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__33370 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__33370__$1 = ((((!((map__33370 == null)))?((((map__33370.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33370.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33370):map__33370);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33370__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33370__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__33372 = temp__4425__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33372,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33372,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js(new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
});})(map__33335,map__33335__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table33337.getBasis = ((function (map__33335,map__33335__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__33334,cljs.core.cst$sym$map__33335,cljs.core.cst$sym$opts,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$meta33338], null);
});})(map__33335,map__33335__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table33337.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table33337.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table33337";

hatti.views.table.t_hatti$views$table33337.cljs$lang$ctorPrWriter = ((function (map__33335,map__33335__$1,opts,slick_grid_event_handlers){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table33337");
});})(map__33335,map__33335__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table33337 = ((function (map__33335,map__33335__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table33337(app_state__$1,owner__$1,p__33334__$1,map__33335__$2,opts__$1,slick_grid_event_handlers__$1,meta33338){
return (new hatti.views.table.t_hatti$views$table33337(app_state__$1,owner__$1,p__33334__$1,map__33335__$2,opts__$1,slick_grid_event_handlers__$1,meta33338));
});})(map__33335,map__33335__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table33337(app_state,owner,p__33334,map__33335__$1,opts,slick_grid_event_handlers,cljs.core.PersistentArrayMap.EMPTY));
}));
