// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__8429__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto__){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto__){
return (function (state_30150){
var state_val_30151 = (state_30150[(1)]);
if((state_val_30151 === (7))){
var inst_30107 = (state_30150[(7)]);
var inst_30107__$1 = (state_30150[(2)]);
var inst_30109 = (inst_30107__$1 == null);
var inst_30110 = cljs.core.not(inst_30109);
var state_30150__$1 = (function (){var statearr_30152 = state_30150;
(statearr_30152[(7)] = inst_30107__$1);

return statearr_30152;
})();
if(inst_30110){
var statearr_30153_30190 = state_30150__$1;
(statearr_30153_30190[(1)] = (8));

} else {
var statearr_30154_30191 = state_30150__$1;
(statearr_30154_30191[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30151 === (20))){
var inst_30129 = (state_30150[(8)]);
var inst_30137 = (state_30150[(2)]);
var state_30150__$1 = (function (){var statearr_30155 = state_30150;
(statearr_30155[(9)] = inst_30137);

return statearr_30155;
})();
if(cljs.core.truth_(inst_30129)){
var statearr_30156_30192 = state_30150__$1;
(statearr_30156_30192[(1)] = (21));

} else {
var statearr_30157_30193 = state_30150__$1;
(statearr_30157_30193[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30151 === (1))){
var state_30150__$1 = state_30150;
var statearr_30158_30194 = state_30150__$1;
(statearr_30158_30194[(2)] = null);

(statearr_30158_30194[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30151 === (4))){
var state_30150__$1 = state_30150;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30150__$1,(7),agg_data_channel);
} else {
if((state_val_30151 === (15))){
var inst_30107 = (state_30150[(7)]);
var state_30150__$1 = state_30150;
var statearr_30159_30195 = state_30150__$1;
(statearr_30159_30195[(2)] = inst_30107);

(statearr_30159_30195[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30151 === (21))){
var inst_30139 = cljs.core.async.close_BANG_(agg_data_channel);
var state_30150__$1 = state_30150;
var statearr_30160_30196 = state_30150__$1;
(statearr_30160_30196[(2)] = inst_30139);

(statearr_30160_30196[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30151 === (13))){
var inst_30119 = (state_30150[(2)]);
var state_30150__$1 = state_30150;
var statearr_30161_30197 = state_30150__$1;
(statearr_30161_30197[(2)] = inst_30119);

(statearr_30161_30197[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30151 === (22))){
var state_30150__$1 = state_30150;
var statearr_30162_30198 = state_30150__$1;
(statearr_30162_30198[(2)] = null);

(statearr_30162_30198[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30151 === (6))){
var inst_30146 = (state_30150[(2)]);
var state_30150__$1 = state_30150;
var statearr_30163_30199 = state_30150__$1;
(statearr_30163_30199[(2)] = inst_30146);

(statearr_30163_30199[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30151 === (17))){
var inst_30129 = (state_30150[(8)]);
var inst_30128 = (state_30150[(10)]);
var inst_30131 = (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(inst_30128,inst_30129) : callback.call(null,inst_30128,inst_30129));
var state_30150__$1 = state_30150;
var statearr_30164_30200 = state_30150__$1;
(statearr_30164_30200[(2)] = inst_30131);

(statearr_30164_30200[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30151 === (3))){
var inst_30148 = (state_30150[(2)]);
var state_30150__$1 = state_30150;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30150__$1,inst_30148);
} else {
if((state_val_30151 === (12))){
var state_30150__$1 = state_30150;
var statearr_30165_30201 = state_30150__$1;
(statearr_30165_30201[(2)] = false);

(statearr_30165_30201[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30151 === (2))){
var state_30150__$1 = state_30150;
var statearr_30166_30202 = state_30150__$1;
(statearr_30166_30202[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_30151 === (23))){
var inst_30142 = (state_30150[(2)]);
var state_30150__$1 = (function (){var statearr_30168 = state_30150;
(statearr_30168[(11)] = inst_30142);

return statearr_30168;
})();
var statearr_30169_30203 = state_30150__$1;
(statearr_30169_30203[(2)] = null);

(statearr_30169_30203[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30151 === (19))){
var inst_30134 = (state_30150[(2)]);
var inst_30135 = cljs.core.async.timeout(hatti.ona.stream.small_delay);
var state_30150__$1 = (function (){var statearr_30170 = state_30150;
(statearr_30170[(12)] = inst_30134);

return statearr_30170;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30150__$1,(20),inst_30135);
} else {
if((state_val_30151 === (11))){
var state_30150__$1 = state_30150;
var statearr_30171_30204 = state_30150__$1;
(statearr_30171_30204[(2)] = true);

(statearr_30171_30204[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30151 === (9))){
var state_30150__$1 = state_30150;
var statearr_30172_30205 = state_30150__$1;
(statearr_30172_30205[(2)] = false);

(statearr_30172_30205[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30151 === (5))){
var state_30150__$1 = state_30150;
var statearr_30173_30206 = state_30150__$1;
(statearr_30173_30206[(2)] = null);

(statearr_30173_30206[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30151 === (14))){
var inst_30107 = (state_30150[(7)]);
var inst_30124 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_30107);
var state_30150__$1 = state_30150;
var statearr_30174_30207 = state_30150__$1;
(statearr_30174_30207[(2)] = inst_30124);

(statearr_30174_30207[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30151 === (16))){
var inst_30128 = (state_30150[(10)]);
var inst_30127 = (state_30150[(2)]);
var inst_30128__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30127,cljs.core.cst$kw$data);
var inst_30129 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30127,cljs.core.cst$kw$completed_QMARK_);
var state_30150__$1 = (function (){var statearr_30175 = state_30150;
(statearr_30175[(8)] = inst_30129);

(statearr_30175[(10)] = inst_30128__$1);

return statearr_30175;
})();
if(cljs.core.truth_(inst_30128__$1)){
var statearr_30176_30208 = state_30150__$1;
(statearr_30176_30208[(1)] = (17));

} else {
var statearr_30177_30209 = state_30150__$1;
(statearr_30177_30209[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30151 === (10))){
var inst_30122 = (state_30150[(2)]);
var state_30150__$1 = state_30150;
if(cljs.core.truth_(inst_30122)){
var statearr_30178_30210 = state_30150__$1;
(statearr_30178_30210[(1)] = (14));

} else {
var statearr_30179_30211 = state_30150__$1;
(statearr_30179_30211[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30151 === (18))){
var state_30150__$1 = state_30150;
var statearr_30180_30212 = state_30150__$1;
(statearr_30180_30212[(2)] = null);

(statearr_30180_30212[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30151 === (8))){
var inst_30107 = (state_30150[(7)]);
var inst_30112 = inst_30107.cljs$lang$protocol_mask$partition0$;
var inst_30113 = (inst_30112 & (64));
var inst_30114 = inst_30107.cljs$core$ISeq$;
var inst_30115 = (inst_30113) || (inst_30114);
var state_30150__$1 = state_30150;
if(cljs.core.truth_(inst_30115)){
var statearr_30181_30213 = state_30150__$1;
(statearr_30181_30213[(1)] = (11));

} else {
var statearr_30182_30214 = state_30150__$1;
(statearr_30182_30214[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto__))
;
return ((function (switch__8364__auto__,c__8429__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto____0 = (function (){
var statearr_30186 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30186[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto__);

(statearr_30186[(1)] = (1));

return statearr_30186;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto____1 = (function (state_30150){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_30150);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e30187){if((e30187 instanceof Object)){
var ex__8368__auto__ = e30187;
var statearr_30188_30215 = state_30150;
(statearr_30188_30215[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30150);

return cljs.core.cst$kw$recur;
} else {
throw e30187;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__30216 = state_30150;
state_30150 = G__30216;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto__ = function(state_30150){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto____1.call(this,state_30150);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto__))
})();
var state__8431__auto__ = (function (){var statearr_30189 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_30189[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto__);

return statearr_30189;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto__))
);

return c__8429__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(read_count,cljs.core.inc);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(agg,cljs.core.conj,data_chunk);

if((((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)) >= (100))) && (cljs.core.integer_QMARK_(Math.log10((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)))))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg))], null));

var G__30219_30221 = agg;
var G__30220_30222 = cljs.core.PersistentVector.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__30219_30221,G__30220_30222) : cljs.core.reset_BANG_.call(null,G__30219_30221,G__30220_30222));

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___30230 = arguments.length;
var i__5628__auto___30231 = (0);
while(true){
if((i__5628__auto___30231 < len__5627__auto___30230)){
args__5634__auto__.push((arguments[i__5628__auto___30231]));

var G__30232 = (i__5628__auto___30231 + (1));
i__5628__auto___30231 = G__30232;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__30226){
var map__30227 = p__30226;
var map__30227__$1 = ((((!((map__30227 == null)))?((((map__30227.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30227.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30227):map__30227);
var oboe_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30227__$1,cljs.core.cst$kw$oboe_DASH_headers);
var read_count = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0)) : cljs.core.atom.call(null,(0)));
var agg = (function (){var G__30229 = cljs.core.PersistentVector.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30229) : cljs.core.atom.call(null,G__30229));
})();
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var return_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var oboe_params = cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$headers,oboe_headers,cljs.core.cst$kw$withCredentials,true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__30227,map__30227__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__30227,map__30227__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__30227,map__30227__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg)),cljs.core.cst$kw$completed_QMARK_,true], null));

return cljs.core.async.close_BANG_(return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__30227,map__30227__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_(channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq30223){
var G__30224 = cljs.core.first(seq30223);
var seq30223__$1 = cljs.core.next(seq30223);
var G__30225 = cljs.core.first(seq30223__$1);
var seq30223__$2 = cljs.core.next(seq30223__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30224,G__30225,seq30223__$2);
});
