// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.map.utils');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('hatti.constants');
goog.require('hatti.ona.forms');
goog.require('hatti.utils');
hatti.map.utils.ona_styles = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$point,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,{"radius": (6), "fillColor": "#f30", "reset": {"fillColor": "#f30"}, "color": "#fff", "border": (8), "opacity": 0.5, "fillOpacity": 0.9},cljs.core.cst$kw$hover,{"fillColor": "#631400"},cljs.core.cst$kw$clicked,{"fillColor": "#ad2300"}], null),cljs.core.cst$kw$shape,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,{"fillColor": "#f30", "color": "#666", "weight": (3), "dashArray": "3", "fillOpacity": 0.7, "opacity": 0.8},cljs.core.cst$kw$hover,{"fillColor": "#631400", "color": "#222"},cljs.core.cst$kw$clicked,{"fillColor": "#ad2300", "color": "#222"}], null),cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,{"color": "#f30", "opacity": (1), "weight": (6), "reset": {"color": "#f30"}},cljs.core.cst$kw$hover,{"color": "#631400"},cljs.core.cst$kw$clicked,{"color": "#ad2300"}], null)], null);
/**
 * Returns geotype (:point :line or :shape) based on marker.
 */
hatti.map.utils.marker__GT_geotype = (function hatti$map$utils$marker__GT_geotype(marker){
return new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,(((marker["feature"])["geometry"])["type"]));
});
/**
 * Appropriate style given style-type (:normal, :clicked, :hover), and
 * either a leaflet marker or clojurescript keyword (one of :point or :shape).
 */
hatti.map.utils.get_ona_style = (function hatti$map$utils$get_ona_style(marker_or_keyword,style_type){
var kw = (((marker_or_keyword instanceof cljs.core.Keyword))?marker_or_keyword:hatti.map.utils.marker__GT_geotype(marker_or_keyword));
var G__28956 = (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(hatti.map.utils.ona_styles) : kw.call(null,hatti.map.utils.ona_styles));
return (style_type.cljs$core$IFn$_invoke$arity$1 ? style_type.cljs$core$IFn$_invoke$arity$1(G__28956) : style_type.call(null,G__28956));
});
hatti.map.utils.equivalent_style = (function hatti$map$utils$equivalent_style(s,t){

var sc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(s);
var tc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(t);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.select_keys(sc,cljs.core.keys(tc)),cljs.core.select_keys(tc,cljs.core.keys(sc)));
});
hatti.map.utils.get_id = (function hatti$map$utils$get_id(marker){
return (((marker["feature"])["properties"])[hatti.constants._id]);
});
hatti.map.utils.get_rank = (function hatti$map$utils$get_rank(marker){
return (((marker["feature"])["properties"])[hatti.constants._rank]);
});
/**
 * Get the style of a marker. Second arg specifies style attribute to get.
 * eg. For marker m1, call like: (get-style m1) or (get-style m1 :fillColor)
 */
hatti.map.utils.get_style = (function hatti$map$utils$get_style(var_args){
var args28957 = [];
var len__5627__auto___28961 = arguments.length;
var i__5628__auto___28962 = (0);
while(true){
if((i__5628__auto___28962 < len__5627__auto___28961)){
args28957.push((arguments[i__5628__auto___28962]));

var G__28963 = (i__5628__auto___28962 + (1));
i__5628__auto___28962 = G__28963;
continue;
} else {
}
break;
}

var G__28959 = args28957.length;
switch (G__28959) {
case 1:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28957.length)].join('')));

}
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1 = (function (marker){
return (marker["options"]);
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2 = (function (marker,kw){
var G__28960 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker));
return (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(G__28960) : kw.call(null,G__28960));
});

hatti.map.utils.get_style.cljs$lang$maxFixedArity = 2;
/**
 * Check whether a marker is clicked, so it's style can be preserved.
 */
hatti.map.utils.is_clicked_QMARK_ = (function hatti$map$utils$is_clicked_QMARK_(marker){
return hatti.map.utils.equivalent_style(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker),hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
});
/**
 * Apply a style to a marker. Style comes from a function that takes marker.
 */
hatti.map.utils.re_style_marker = (function hatti$map$utils$re_style_marker(marker__GT_style,marker){
var style = (marker__GT_style.cljs$core$IFn$_invoke$arity$1 ? marker__GT_style.cljs$core$IFn$_invoke$arity$1(marker) : marker__GT_style.call(null,marker));
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return marker.setStyle(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$reset,style], null)));
} else {
return marker.setStyle(cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(style,cljs.core.cst$kw$reset,style)));
}
});
/**
 * Reset styles pulls the 'reset' property from within a markers options,
 * clearing styles to default if nothing found.
 */
hatti.map.utils.reset_style = (function hatti$map$utils$reset_style(marker){
var temp__4423__auto__ = ((marker["options"])["reset"]);
if(cljs.core.truth_(temp__4423__auto__)){
var rstyle = temp__4423__auto__;
return marker.setStyle(rstyle);
} else {
return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
}
});
/**
 * Looks at the _id in marker, and brings to top if (1) marker clicked or
 * (2) marker's id is selected (via id-selected?)
 */
hatti.map.utils.bring_to_top_if_selected = (function hatti$map$utils$bring_to_top_if_selected(id_selected_QMARK_,marker){
if(cljs.core.truth_((function (){var or__4569__auto__ = hatti.map.utils.is_clicked_QMARK_(marker);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var G__28966 = hatti.map.utils.get_id(marker);
return (id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(G__28966) : id_selected_QMARK_.call(null,G__28966));
}
})())){
return marker.bringToFront();
} else {
return null;
}
});
hatti.map.utils.apply_click_style = (function hatti$map$utils$apply_click_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
} else {
return null;
}
});
hatti.map.utils.apply_unclick_style = (function hatti$map$utils$apply_unclick_style(marker){
if(cljs.core.truth_(marker)){
return hatti.map.utils.reset_style(marker);
} else {
return null;
}
});
hatti.map.utils.apply_hover_style = (function hatti$map$utils$apply_hover_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$hover));
} else {
return null;
}
});
/**
 * Sets the default style on a marker.
 */
hatti.map.utils.clear_all_styles = (function hatti$map$utils$clear_all_styles(var_args){
var args__5634__auto__ = [];
var len__5627__auto___28976 = arguments.length;
var i__5628__auto___28977 = (0);
while(true){
if((i__5628__auto___28977 < len__5627__auto___28976)){
args__5634__auto__.push((arguments[i__5628__auto___28977]));

var G__28978 = (i__5628__auto___28977 + (1));
i__5628__auto___28977 = G__28978;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic = (function (markers,p__28969){
var map__28970 = p__28969;
var map__28970__$1 = ((((!((map__28970 == null)))?((((map__28970.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28970.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28970):map__28970);
var preserve_clicked_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28970__$1,cljs.core.cst$kw$preserve_DASH_clicked_QMARK_,true);
var seq__28972 = cljs.core.seq(markers);
var chunk__28973 = null;
var count__28974 = (0);
var i__28975 = (0);
while(true){
if((i__28975 < count__28974)){
var marker = chunk__28973.cljs$core$IIndexed$_nth$arity$2(null,i__28975);
if(cljs.core.not((function (){var and__4557__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__4557__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__4557__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__28979 = seq__28972;
var G__28980 = chunk__28973;
var G__28981 = count__28974;
var G__28982 = (i__28975 + (1));
seq__28972 = G__28979;
chunk__28973 = G__28980;
count__28974 = G__28981;
i__28975 = G__28982;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__28972);
if(temp__4425__auto__){
var seq__28972__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28972__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__28972__$1);
var G__28983 = cljs.core.chunk_rest(seq__28972__$1);
var G__28984 = c__5372__auto__;
var G__28985 = cljs.core.count(c__5372__auto__);
var G__28986 = (0);
seq__28972 = G__28983;
chunk__28973 = G__28984;
count__28974 = G__28985;
i__28975 = G__28986;
continue;
} else {
var marker = cljs.core.first(seq__28972__$1);
if(cljs.core.not((function (){var and__4557__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__4557__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__4557__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__28987 = cljs.core.next(seq__28972__$1);
var G__28988 = null;
var G__28989 = (0);
var G__28990 = (0);
seq__28972 = G__28987;
chunk__28973 = G__28988;
count__28974 = G__28989;
i__28975 = G__28990;
continue;
}
} else {
return null;
}
}
break;
}
});

hatti.map.utils.clear_all_styles.cljs$lang$maxFixedArity = (1);

hatti.map.utils.clear_all_styles.cljs$lang$applyTo = (function (seq28967){
var G__28968 = cljs.core.first(seq28967);
var seq28967__$1 = cljs.core.next(seq28967);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic(G__28968,seq28967__$1);
});
hatti.map.utils.read_string_or_number = (function hatti$map$utils$read_string_or_number(maybe_s){
if(typeof maybe_s === 'string'){
return cljs.reader.read_string(maybe_s);
} else {
return maybe_s;
}
});
hatti.map.utils.get_as_geom = (function hatti$map$utils$get_as_geom(record,geofield){
var geotype = new cljs.core.PersistentArrayMap(null, 4, ["geopoint","Point","gps","Point","geoshape","Polygon","geotrace","LineString"], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(geofield));
var parse = ((function (geotype){
return (function (s){
if((cljs.core.seq(s)) && (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(s,"n/a"))){
var iter__5341__auto__ = ((function (geotype){
return (function hatti$map$utils$get_as_geom_$_iter__29004(s__29005){
return (new cljs.core.LazySeq(null,((function (geotype){
return (function (){
var s__29005__$1 = s__29005;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__29005__$1);
if(temp__4425__auto__){
var s__29005__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__29005__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__29005__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__29007 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__29006 = (0);
while(true){
if((i__29006 < size__5340__auto__)){
var coord_string = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__29006);
cljs.core.chunk_append(b__29007,(function (){var vec__29012 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29012,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29012,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29012,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29012,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})());

var G__29015 = (i__29006 + (1));
i__29006 = G__29015;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29007),hatti$map$utils$get_as_geom_$_iter__29004(cljs.core.chunk_rest(s__29005__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29007),null);
}
} else {
var coord_string = cljs.core.first(s__29005__$2);
return cljs.core.cons((function (){var vec__29013 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29013,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29013,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29013,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29013,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})(),hatti$map$utils$get_as_geom_$_iter__29004(cljs.core.rest(s__29005__$2)));
}
} else {
return null;
}
break;
}
});})(geotype))
,null,null));
});})(geotype))
;
return iter__5341__auto__(clojure.string.split.cljs$core$IFn$_invoke$arity$2(s,/;/));
} else {
return null;
}
});})(geotype))
;
var coordfn = (function (){var G__29014 = geotype;
switch (G__29014) {
case "Point":
return ((function (G__29014,geotype,parse){
return (function (p1__28991_SHARP_){
return cljs.core.first(parse(p1__28991_SHARP_));
});
;})(G__29014,geotype,parse))

break;
case "LineString":
return parse;

break;
case "Polygon":
return ((function (G__29014,geotype,parse){
return (function (p1__28992_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[parse(p1__28992_SHARP_)],null));
});
;})(G__29014,geotype,parse))

break;
default:
return cljs.core.identity;

}
})();
var key = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(geofield);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,key);
var coords = (coordfn.cljs$core$IFn$_invoke$arity$1 ? coordfn.cljs$core$IFn$_invoke$arity$1(value) : coordfn.call(null,value));
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_(geofield))){
return cljs.core.cst$kw$geom.cljs$core$IFn$_invoke$arity$1(value);
} else {
if(cljs.core.truth_((function (){var or__4569__auto__ = (coords == null);
if(or__4569__auto__){
return or__4569__auto__;
} else {
return cljs.core.some(cljs.core.nil_QMARK_,coords);
}
})())){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,geotype,cljs.core.cst$kw$coordinates,coords], null);
}
}
});
/**
 * Given the dataset, and the form schema, get out geojson.
 * Optional specification of field will map that field data to the geom.
 */
hatti.map.utils.as_geojson = (function hatti$map$utils$as_geojson(var_args){
var args29017 = [];
var len__5627__auto___29030 = arguments.length;
var i__5628__auto___29031 = (0);
while(true){
if((i__5628__auto___29031 < len__5627__auto___29030)){
args29017.push((arguments[i__5628__auto___29031]));

var G__29032 = (i__5628__auto___29031 + (1));
i__5628__auto___29031 = G__29032;
continue;
} else {
}
break;
}

var G__29019 = args29017.length;
switch (G__29019) {
case 2:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29017.length)].join('')));

}
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2 = (function (dataset,form){
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3(dataset,form,hatti.ona.forms.default_geofield(form));
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3 = (function (dataset,form,geofield){
if(cljs.core.truth_(geofield)){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,(function (){var iter__5341__auto__ = (function hatti$map$utils$iter__29020(s__29021){
return (new cljs.core.LazySeq(null,(function (){
var s__29021__$1 = s__29021;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__29021__$1);
if(temp__4425__auto__){
var s__29021__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__29021__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__29021__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__29023 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__29022 = (0);
while(true){
if((i__29022 < size__5340__auto__)){
var vec__29028 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__29022);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29028,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29028,(1),null);
var geo = hatti.map.utils.get_as_geom(record,geofield);
if(cljs.core.truth_(geo)){
cljs.core.chunk_append(b__29023,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"Feature",cljs.core.cst$kw$properties,cljs.core.PersistentArrayMap.fromArray([cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._rank),(idx + (1)),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id),(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id))], true, false),cljs.core.cst$kw$geometry,geo], null));

var G__29034 = (i__29022 + (1));
i__29022 = G__29034;
continue;
} else {
var G__29035 = (i__29022 + (1));
i__29022 = G__29035;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29023),hatti$map$utils$iter__29020(cljs.core.chunk_rest(s__29021__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29023),null);
}
} else {
var vec__29029 = cljs.core.first(s__29021__$2);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29029,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29029,(1),null);
var geo = hatti.map.utils.get_as_geom(record,geofield);
if(cljs.core.truth_(geo)){
return cljs.core.cons(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"Feature",cljs.core.cst$kw$properties,cljs.core.PersistentArrayMap.fromArray([cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._rank),(idx + (1)),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id),(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id))], true, false),cljs.core.cst$kw$geometry,geo], null),hatti$map$utils$iter__29020(cljs.core.rest(s__29021__$2)));
} else {
var G__29036 = cljs.core.rest(s__29021__$2);
s__29021__$1 = G__29036;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(hatti.utils.indexed(dataset));
})()], null);
} else {
return null;
}
});

hatti.map.utils.as_geojson.cljs$lang$maxFixedArity = 3;
/**
 * Creates a leaflet map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_map = (function hatti$map$utils$create_map(id,p__29038){
var map__29041 = p__29038;
var map__29041__$1 = ((((!((map__29041 == null)))?((((map__29041.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29041.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29041):map__29041);
var mapbox_tiles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29041__$1,cljs.core.cst$kw$mapbox_DASH_tiles);
var include_google_maps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29041__$1,cljs.core.cst$kw$include_DASH_google_DASH_maps_QMARK_);
var layers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__29041,map__29041__$1,mapbox_tiles,include_google_maps_QMARK_){
return (function (p1__29037_SHARP_){
return L.tileLayer(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(p1__29037_SHARP_));
});})(map__29041,map__29041__$1,mapbox_tiles,include_google_maps_QMARK_))
,mapbox_tiles);
var nlayers = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name,mapbox_tiles),layers);
var named_layers = (cljs.core.truth_(include_google_maps_QMARK_)?cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(nlayers,"Google Satellite",new L.Google)):cljs.core.clj__GT_js(nlayers));
var m = L.map(id,{"layers": cljs.core.first(layers), "zoomControl": false});
var z = L.control.zoom.call(null,{"position": "bottomleft"});
z.addTo(m);

L.control.layers.call(null,named_layers,null,{"position": "bottomleft"}).addTo(m);

m.setView([(0),(0)],(1));

return m;
});
/**
 * Mouse events for markers.
 *   On click or arrow, mapped-submission-to-rank events are generated.
 *   On hover, marker is brought to the front and color changed.
 */
hatti.map.utils.register_mouse_events = (function hatti$map$utils$register_mouse_events(feature,marker,event_chan){
marker.on("click",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_rank,((feature["properties"])[hatti.constants._rank])], null));
}
}));

marker.on("mouseover",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_hover_style(marker);
}
}));

return marker.on("mouseout",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_unclick_style(marker);
}
}));
});
/**
 * Re-renders map by invalidating leaflet size.
 * If map is zoomed out beyond layer-bounds, re-zooms to layer.
 */
hatti.map.utils.re_render_map_BANG_ = (function hatti$map$utils$re_render_map_BANG_(leaflet_map,feature_layer){
var map_bounds = leaflet_map.getBounds();
var layer_bounds = feature_layer.getBounds();
leaflet_map.invalidateSize(false);

if(((leaflet_map.getZoom() === (0))) || (cljs.core.not(layer_bounds.contains(map_bounds)))){
return leaflet_map.fitBounds(layer_bounds);
} else {
return null;
}
});
/**
 * Create a map with the given GeoJSON data.
 * Adds mouse events and centers on the geojson features.
 */
hatti.map.utils.load_geo_json = (function hatti$map$utils$load_geo_json(var_args){
var args__5634__auto__ = [];
var len__5627__auto___29055 = arguments.length;
var i__5628__auto___29056 = (0);
while(true){
if((i__5628__auto___29056 < len__5627__auto___29055)){
args__5634__auto__.push((arguments[i__5628__auto___29056]));

var G__29057 = (i__5628__auto___29056 + (1));
i__5628__auto___29056 = G__29057;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((3) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((3)),(0))):null);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5635__auto__);
});

hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic = (function (m,geojson,event_chan,p__29052){
var map__29053 = p__29052;
var map__29053__$1 = ((((!((map__29053 == null)))?((((map__29053.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29053.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29053):map__29053);
var rezoom_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29053__$1,cljs.core.cst$kw$rezoom_QMARK_);
var on_events = ((function (map__29053,map__29053__$1,rezoom_QMARK_){
return (function (p1__29043_SHARP_,p2__29044_SHARP_){
return hatti.map.utils.register_mouse_events(p1__29043_SHARP_,p2__29044_SHARP_,event_chan);
});})(map__29053,map__29053__$1,rezoom_QMARK_))
;
var geometry_type = new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson)))));
var stylefn = ((function (on_events,geometry_type,map__29053,map__29053__$1,rezoom_QMARK_){
return (function (){
return hatti.map.utils.get_ona_style(geometry_type,cljs.core.cst$kw$normal);
});})(on_events,geometry_type,map__29053,map__29053__$1,rezoom_QMARK_))
;
var point__GT_marker = ((function (on_events,geometry_type,stylefn,map__29053,map__29053__$1,rezoom_QMARK_){
return (function (p1__29046_SHARP_,p2__29045_SHARP_){
return L.circleMarker(p2__29045_SHARP_);
});})(on_events,geometry_type,stylefn,map__29053,map__29053__$1,rezoom_QMARK_))
;
var feature_layer = L.geoJson(cljs.core.clj__GT_js(geojson),{"onEachFeature": on_events, "pointToLayer": point__GT_marker, "style": stylefn});
var ids = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__29053,map__29053__$1,rezoom_QMARK_){
return (function (p1__29047_SHARP_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__29047_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$properties,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id)], null));
});})(on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__29053,map__29053__$1,rezoom_QMARK_))
,cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson));
var markers = feature_layer.getLayers();
if(cljs.core.seq(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson))){
if(cljs.core.truth_(rezoom_QMARK_)){
m.fitBounds(feature_layer.getBounds());
} else {
}

feature_layer.addTo(m);
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$feature_DASH_layer,feature_layer,cljs.core.cst$kw$markers,markers,cljs.core.cst$kw$id_DASH__GT_marker,cljs.core.zipmap(ids,markers)], null);
});

hatti.map.utils.load_geo_json.cljs$lang$maxFixedArity = (3);

hatti.map.utils.load_geo_json.cljs$lang$applyTo = (function (seq29048){
var G__29049 = cljs.core.first(seq29048);
var seq29048__$1 = cljs.core.next(seq29048);
var G__29050 = cljs.core.first(seq29048__$1);
var seq29048__$2 = cljs.core.next(seq29048__$1);
var G__29051 = cljs.core.first(seq29048__$2);
var seq29048__$3 = cljs.core.next(seq29048__$2);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic(G__29049,G__29050,G__29051,seq29048__$3);
});
