// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.charting');
goog.require('cljs.core');
goog.require('c2.layout.histogram');
goog.require('hatti.maths');
goog.require('cljs_time.coerce');
goog.require('c2.scale');
goog.require('cljs_time.format');
goog.require('hatti.ona.forms');
goog.require('hatti.utils');
goog.require('c2.svg');
goog.require('clojure.string');
hatti.charting.millis_in_day = (86400000);
/**
 * Parse an integer from a string.
 */
hatti.charting.parse_int = (function hatti$charting$parse_int(st){
var ans = parseInt(st);
if(cljs.core.truth_(isNaN(ans))){
return null;
} else {
return ans;
}
});
/**
 * Converts string to integer, for typ (int|date).
 */
hatti.charting.str__GT_int = (function hatti$charting$str__GT_int(typ){
var G__78665 = typ;
switch (G__78665) {
case "int":
return hatti.charting.parse_int;

break;
case "date":
return ((function (G__78665){
return (function (date_string){
if(cljs.core.truth_(date_string)){
return hatti.maths.floor((cljs_time.coerce.to_long((new Date(date_string))) / hatti.charting.millis_in_day));
} else {
return null;
}
});
;})(G__78665))

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(typ)].join('')));

}
});
/**
 * Converts integers to strings, for type (int|date).
 * Optional digits parameter = number of digits after decimal, default is 1.
 */
hatti.charting.int__GT_str = (function hatti$charting$int__GT_str(var_args){
var args__5634__auto__ = [];
var len__5627__auto___78677 = arguments.length;
var i__5628__auto___78678 = (0);
while(true){
if((i__5628__auto___78678 < len__5627__auto___78677)){
args__5634__auto__.push((arguments[i__5628__auto___78678]));

var G__78679 = (i__5628__auto___78678 + (1));
i__5628__auto___78678 = G__78679;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic = (function (typ,p__78673){
var map__78674 = p__78673;
var map__78674__$1 = ((((!((map__78674 == null)))?((((map__78674.cljs$lang$protocol_mask$partition0$ & (64))) || (map__78674.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__78674):map__78674);
var digits = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__78674__$1,cljs.core.cst$kw$digits,(1));
var int_fmt_s = [cljs.core.str("%."),cljs.core.str(digits),cljs.core.str("f")].join('');
var d__GT_millis = ((function (int_fmt_s,map__78674,map__78674__$1,digits){
return (function (p1__78667_SHARP_){
return (hatti.charting.millis_in_day * p1__78667_SHARP_);
});})(int_fmt_s,map__78674,map__78674__$1,digits))
;
var date__GT_str = ((function (int_fmt_s,d__GT_millis,map__78674,map__78674__$1,digits){
return (function (p1__78668_SHARP_){
if(cljs.core.truth_(p1__78668_SHARP_)){
return moment(p1__78668_SHARP_).format("ll");
} else {
return null;
}
});})(int_fmt_s,d__GT_millis,map__78674,map__78674__$1,digits))
;
var G__78676 = typ;
switch (G__78676) {
case "int":
return ((function (G__78676,int_fmt_s,d__GT_millis,date__GT_str,map__78674,map__78674__$1,digits){
return (function (p1__78669_SHARP_){
return hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic(int_fmt_s,cljs.core.array_seq([p1__78669_SHARP_], 0));
});
;})(G__78676,int_fmt_s,d__GT_millis,date__GT_str,map__78674,map__78674__$1,digits))

break;
case "date":
return ((function (G__78676,int_fmt_s,d__GT_millis,date__GT_str,map__78674,map__78674__$1,digits){
return (function (p1__78670_SHARP_){
return date__GT_str(d__GT_millis(p1__78670_SHARP_));
});
;})(G__78676,int_fmt_s,d__GT_millis,date__GT_str,map__78674,map__78674__$1,digits))

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(typ)].join('')));

}
});

hatti.charting.int__GT_str.cljs$lang$maxFixedArity = (1);

hatti.charting.int__GT_str.cljs$lang$applyTo = (function (seq78671){
var G__78672 = cljs.core.first(seq78671);
var seq78671__$1 = cljs.core.next(seq78671);
return hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic(G__78672,seq78671__$1);
});
/**
 * Converts a range of typ (int|date) to a string.
 */
hatti.charting.range__GT_str = (function hatti$charting$range__GT_str(p__78681,typ){
var vec__78684 = p__78681;
var mn = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78684,(0),null);
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78684,(1),null);
var vec__78685 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [hatti.maths.ceil(mn),hatti.maths.floor(mx)], null);
var mn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78685,(0),null);
var mx__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78685,(1),null);
var fmt = hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic(typ,cljs.core.array_seq([cljs.core.cst$kw$digits,(0)], 0));
if((mx__$1 <= mn__$1)){
return (fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(mn__$1) : fmt.call(null,mn__$1));
} else {
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" to ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(mn__$1) : fmt.call(null,mn__$1)),(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(mx__$1) : fmt.call(null,mx__$1))], null));
}
});
/**
 * Given a list of answers, returns each one as a bin, in string form.
 * nil is mapped to nil. The bins, in order, are returned as metadata.
 * eg. (evenly-spaced-bins [1 2 10] 5 'int') => ['1 to 2' '1 to 2' '9 to 10']
 * metadata of this above value would be:
 * {:bins ['1 to 2', '3 to 4', '5 to 6', '7 to 8', '9 to 10']}
 */
hatti.charting.evenly_spaced_bins = (function hatti$charting$evenly_spaced_bins(answers,bins,typ){
var numbers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.charting.str__GT_int(typ),answers);
var mx = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,numbers));
var mn = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,numbers));
var s = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [mn,mx], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(bins - ((1) / (10000)))], null)], 0));
var is = cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.maths.floor,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (numbers,mx,mn,s){
return (function (p1__78686_SHARP_){
if(cljs.core.truth_(p1__78686_SHARP_)){
return (s.cljs$core$IFn$_invoke$arity$1 ? s.cljs$core$IFn$_invoke$arity$1(p1__78686_SHARP_) : s.call(null,p1__78686_SHARP_));
} else {
return null;
}
});})(numbers,mx,mn,s))
,numbers));
var t = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),bins], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [mn,mx], null)], 0));
var lbounds = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.float$,cljs.core.map.cljs$core$IFn$_invoke$arity$2(t,cljs.core.range.cljs$core$IFn$_invoke$arity$1(bins))));
var ubounds = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (numbers,mx,mn,s,is,t,lbounds){
return (function (p1__78687_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__78687_SHARP_,hatti.maths.floor(p1__78687_SHARP_))){
return (p1__78687_SHARP_ - (1));
} else {
return p1__78687_SHARP_;
}
});})(numbers,mx,mn,s,is,t,lbounds))
,cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),lbounds)),mx);
var fmt = hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic(typ,cljs.core.array_seq([cljs.core.cst$kw$digits,(0)], 0));
var strings = cljs.core.mapv.cljs$core$IFn$_invoke$arity$3(((function (numbers,mx,mn,s,is,t,lbounds,ubounds,fmt){
return (function (p1__78688_SHARP_,p2__78689_SHARP_){
return hatti.charting.range__GT_str(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__78688_SHARP_,p2__78689_SHARP_], null),typ);
});})(numbers,mx,mn,s,is,t,lbounds,ubounds,fmt))
,lbounds,ubounds);
var results = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (numbers,mx,mn,s,is,t,lbounds,ubounds,fmt,strings){
return (function (i){
if(cljs.core.truth_(i)){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(strings,(i | (0)));
} else {
return null;
}
});})(numbers,mx,mn,s,is,t,lbounds,ubounds,fmt,strings))
,is);
var strings__$1 = cljs.core.vec(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(strings));
return cljs.core.with_meta(results,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$bins,((cljs.core.contains_QMARK_(cljs.core.set(answers),null))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(strings__$1,null):strings__$1)], null));
});
/**
 * Take chart-data from the ona API, returns label->count map.
 * eg. Input: {:field_xpath 'D' :data [{:count 2 :D ['Option_1']}]}
 * Output: {:Option_1 2}
 * eg. Input: {:field_xpath 'D' :data [{:count 1 :D ['O1' 'O_2']
 * :count 2 :D ['O1']}]}
 * Output: {:Option_1 3 :O_2 1}
 */
hatti.charting.label_count_pairs = (function hatti$charting$label_count_pairs(var_args){
var args78692 = [];
var len__5627__auto___78703 = arguments.length;
var i__5628__auto___78704 = (0);
while(true){
if((i__5628__auto___78704 < len__5627__auto___78703)){
args78692.push((arguments[i__5628__auto___78704]));

var G__78705 = (i__5628__auto___78704 + (1));
i__5628__auto___78704 = G__78705;
continue;
} else {
}
break;
}

var G__78694 = args78692.length;
switch (G__78694) {
case 1:
return hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args78692.length)].join('')));

}
});

hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$1 = (function (chart_data){
return hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2(chart_data,null);
});

hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2 = (function (chart_data,language){
var map__78695 = chart_data;
var map__78695__$1 = ((((!((map__78695 == null)))?((((map__78695.cljs$lang$protocol_mask$partition0$ & (64))) || (map__78695.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__78695):map__78695);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78695__$1,cljs.core.cst$kw$data);
var field_xpath = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78695__$1,cljs.core.cst$kw$field_xpath);
var unboxed = (function (){var iter__5341__auto__ = ((function (map__78695,map__78695__$1,data,field_xpath){
return (function hatti$charting$iter__78697(s__78698){
return (new cljs.core.LazySeq(null,((function (map__78695,map__78695__$1,data,field_xpath){
return (function (){
var s__78698__$1 = s__78698;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__78698__$1);
if(temp__4425__auto__){
var s__78698__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__78698__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__78698__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__78700 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__78699 = (0);
while(true){
if((i__78699 < size__5340__auto__)){
var data_item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__78699);
cljs.core.chunk_append(b__78700,(function (){var labels = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath).call(null,data_item);
var count = cljs.core.cst$kw$count.cljs$core$IFn$_invoke$arity$1(data_item);
var labelify = ((function (i__78699,labels,count,data_item,c__5339__auto__,size__5340__auto__,b__78700,s__78698__$2,temp__4425__auto__,map__78695,map__78695__$1,data,field_xpath){
return (function (p1__78690_SHARP_){
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,p1__78690_SHARP_], null),cljs.core.array_seq([language], 0));
});})(i__78699,labels,count,data_item,c__5339__auto__,size__5340__auto__,b__78700,s__78698__$2,temp__4425__auto__,map__78695,map__78695__$1,data,field_xpath))
;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__78699,labels,count,labelify,data_item,c__5339__auto__,size__5340__auto__,b__78700,s__78698__$2,temp__4425__auto__,map__78695,map__78695__$1,data,field_xpath){
return (function (p1__78691_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([labelify(p1__78691_SHARP_)],[count]);
});})(i__78699,labels,count,labelify,data_item,c__5339__auto__,size__5340__auto__,b__78700,s__78698__$2,temp__4425__auto__,map__78695,map__78695__$1,data,field_xpath))
,labels);
})());

var G__78707 = (i__78699 + (1));
i__78699 = G__78707;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__78700),hatti$charting$iter__78697(cljs.core.chunk_rest(s__78698__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__78700),null);
}
} else {
var data_item = cljs.core.first(s__78698__$2);
return cljs.core.cons((function (){var labels = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath).call(null,data_item);
var count = cljs.core.cst$kw$count.cljs$core$IFn$_invoke$arity$1(data_item);
var labelify = ((function (labels,count,data_item,s__78698__$2,temp__4425__auto__,map__78695,map__78695__$1,data,field_xpath){
return (function (p1__78690_SHARP_){
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,p1__78690_SHARP_], null),cljs.core.array_seq([language], 0));
});})(labels,count,data_item,s__78698__$2,temp__4425__auto__,map__78695,map__78695__$1,data,field_xpath))
;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (labels,count,labelify,data_item,s__78698__$2,temp__4425__auto__,map__78695,map__78695__$1,data,field_xpath){
return (function (p1__78691_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([labelify(p1__78691_SHARP_)],[count]);
});})(labels,count,labelify,data_item,s__78698__$2,temp__4425__auto__,map__78695,map__78695__$1,data,field_xpath))
,labels);
})(),hatti$charting$iter__78697(cljs.core.rest(s__78698__$2)));
}
} else {
return null;
}
break;
}
});})(map__78695,map__78695__$1,data,field_xpath))
,null,null));
});})(map__78695,map__78695__$1,data,field_xpath))
;
return iter__5341__auto__(data);
})();
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(cljs.core.last,cljs.core._GT_,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.merge_with,cljs.core._PLUS_,cljs.core.flatten(unboxed)));
});

hatti.charting.label_count_pairs.cljs$lang$maxFixedArity = 2;
/**
 * Determine number of bins if there are n possible of values of data.
 *   Custom algorithm, based on a pleasant range of bins being between
 *   roughly 7 and 15 (though customizable). Idea is that we try to divide
 *   n into a number between 
 */
hatti.charting.num_bins = (function hatti$charting$num_bins(var_args){
var args__5634__auto__ = [];
var len__5627__auto___78713 = arguments.length;
var i__5628__auto___78714 = (0);
while(true){
if((i__5628__auto___78714 < len__5627__auto___78713)){
args__5634__auto__.push((arguments[i__5628__auto___78714]));

var G__78715 = (i__5628__auto___78714 + (1));
i__5628__auto___78714 = G__78715;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic = (function (n,p__78710){
var map__78711 = p__78710;
var map__78711__$1 = ((((!((map__78711 == null)))?((((map__78711.cljs$lang$protocol_mask$partition0$ & (64))) || (map__78711.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__78711):map__78711);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__78711__$1,cljs.core.cst$kw$data_DASH_type,"int");
var rough_min = (7);
var rough_max = (15);
var real_max = (24);
var full_range = cljs.core.range.cljs$core$IFn$_invoke$arity$2(rough_min,rough_max);
var best_guess = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.maths.gcd,n),full_range));
if((best_guess < rough_min)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(cljs.core.min,real_max,n),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.maths.lcm,n),full_range));
} else {
return best_guess;
}
});

hatti.charting.num_bins.cljs$lang$maxFixedArity = (1);

hatti.charting.num_bins.cljs$lang$applyTo = (function (seq78708){
var G__78709 = cljs.core.first(seq78708);
var seq78708__$1 = cljs.core.next(seq78708);
return hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic(G__78709,seq78708__$1);
});
/**
 * Turn numerical / date chart-data from ona API histogram-friendly.
 *   Return data looks like [(x dx y)] with-meta {:bins num-bins}.
 */
hatti.charting.extract_data_for_histogram = (function hatti$charting$extract_data_for_histogram(var_args){
var args__5634__auto__ = [];
var len__5627__auto___78729 = arguments.length;
var i__5628__auto___78730 = (0);
while(true){
if((i__5628__auto___78730 < len__5627__auto___78729)){
args__5634__auto__.push((arguments[i__5628__auto___78730]));

var G__78731 = (i__5628__auto___78730 + (1));
i__5628__auto___78730 = G__78731;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic = (function (chart_data,p__78718){
var map__78719 = p__78718;
var map__78719__$1 = ((((!((map__78719 == null)))?((((map__78719.cljs$lang$protocol_mask$partition0$ & (64))) || (map__78719.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__78719):map__78719);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__78719__$1,cljs.core.cst$kw$data_DASH_type,"int");
var map__78721 = chart_data;
var map__78721__$1 = ((((!((map__78721 == null)))?((((map__78721.cljs$lang$protocol_mask$partition0$ & (64))) || (map__78721.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__78721):map__78721);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78721__$1,cljs.core.cst$kw$data);
var field_xpath = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78721__$1,cljs.core.cst$kw$field_xpath);
var retype_fn = hatti.charting.str__GT_int(data_type);
var qn_key = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath);
var retyped_data = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__78721,map__78721__$1,data,field_xpath,retype_fn,qn_key,map__78719,map__78719__$1,data_type){
return (function (el){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(el,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [qn_key], null),retype_fn);
});})(map__78721,map__78721__$1,data,field_xpath,retype_fn,qn_key,map__78719,map__78719__$1,data_type))
,data);
var data_range = (cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(qn_key,retyped_data)) - cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.map.cljs$core$IFn$_invoke$arity$2(qn_key,retyped_data)));
var bins = (((data_range === (0)))?(1):hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic(data_range,cljs.core.array_seq([cljs.core.cst$kw$data_DASH_type,data_type], 0)));
var binned_data = c2.layout.histogram.histogram.cljs$core$IFn$_invoke$arity$variadic(retyped_data,cljs.core.array_seq([cljs.core.cst$kw$value,qn_key,cljs.core.cst$kw$bins,bins], 0));
return cljs.core.with_meta((function (){var iter__5341__auto__ = ((function (map__78721,map__78721__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__78719,map__78719__$1,data_type){
return (function hatti$charting$iter__78723(s__78724){
return (new cljs.core.LazySeq(null,((function (map__78721,map__78721__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__78719,map__78719__$1,data_type){
return (function (){
var s__78724__$1 = s__78724;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__78724__$1);
if(temp__4425__auto__){
var s__78724__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__78724__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__78724__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__78726 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__78725 = (0);
while(true){
if((i__78725 < size__5340__auto__)){
var data_item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__78725);
cljs.core.chunk_append(b__78726,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$x.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(data_item)),cljs.core.cst$kw$dx.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(data_item)),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$count,data_item))], null));

var G__78732 = (i__78725 + (1));
i__78725 = G__78732;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__78726),hatti$charting$iter__78723(cljs.core.chunk_rest(s__78724__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__78726),null);
}
} else {
var data_item = cljs.core.first(s__78724__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$x.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(data_item)),cljs.core.cst$kw$dx.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(data_item)),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$count,data_item))], null),hatti$charting$iter__78723(cljs.core.rest(s__78724__$2)));
}
} else {
return null;
}
break;
}
});})(map__78721,map__78721__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__78719,map__78719__$1,data_type))
,null,null));
});})(map__78721,map__78721__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__78719,map__78719__$1,data_type))
;
return iter__5341__auto__(binned_data);
})(),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$bins,bins], null));
});

hatti.charting.extract_data_for_histogram.cljs$lang$maxFixedArity = (1);

hatti.charting.extract_data_for_histogram.cljs$lang$applyTo = (function (seq78716){
var G__78717 = cljs.core.first(seq78716);
var seq78716__$1 = cljs.core.next(seq78716);
return hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic(G__78717,seq78716__$1);
});
/**
 * Produces a linear mapping [0,max-count] -> [0, max-length], for data which
 * is a vector, each element a map with key :count. If total-asmax?, then
 * linear map is [0,total-count] -> [0, max-length].
 */
hatti.charting.counts__GT_lengths = (function hatti$charting$counts__GT_lengths(var_args){
var args__5634__auto__ = [];
var len__5627__auto___78739 = arguments.length;
var i__5628__auto___78740 = (0);
while(true){
if((i__5628__auto___78740 < len__5627__auto___78739)){
args__5634__auto__.push((arguments[i__5628__auto___78740]));

var G__78741 = (i__5628__auto___78740 + (1));
i__5628__auto___78740 = G__78741;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic = (function (data,max_length,p__78736){
var map__78737 = p__78736;
var map__78737__$1 = ((((!((map__78737 == null)))?((((map__78737.cljs$lang$protocol_mask$partition0$ & (64))) || (map__78737.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__78737):map__78737);
var total_as_max_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78737__$1,cljs.core.cst$kw$total_DASH_as_DASH_max_QMARK_);
var datamin_as_min_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78737__$1,cljs.core.cst$kw$datamin_DASH_as_DASH_min_QMARK_);
var counts = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$count,data);
var xmax = (cljs.core.truth_(total_as_max_QMARK_)?cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),counts):cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(0),counts));
var xmin = (cljs.core.truth_(datamin_as_min_QMARK_)?cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(0),counts):(0));
var scale = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [xmin,xmax], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),max_length], null)], 0));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(scale,counts);
});

hatti.charting.counts__GT_lengths.cljs$lang$maxFixedArity = (2);

hatti.charting.counts__GT_lengths.cljs$lang$applyTo = (function (seq78733){
var G__78734 = cljs.core.first(seq78733);
var seq78733__$1 = cljs.core.next(seq78733);
var G__78735 = cljs.core.first(seq78733__$1);
var seq78733__$2 = cljs.core.next(seq78733__$1);
return hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic(G__78734,G__78735,seq78733__$2);
});
hatti.charting.response_count_message = (function hatti$charting$response_count_message(response_count){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$t_DASH_right$t_DASH_grey,[cljs.core.str("Based on "),cljs.core.str(response_count),cljs.core.str(" responses.")].join('')], null);
});
/**
 * Create numeric (or date) chart out of some chart-data from ona API.
 */
hatti.charting.numeric_chart = (function hatti$charting$numeric_chart(var_args){
var args__5634__auto__ = [];
var len__5627__auto___78770 = arguments.length;
var i__5628__auto___78771 = (0);
while(true){
if((i__5628__auto___78771 < len__5627__auto___78770)){
args__5634__auto__.push((arguments[i__5628__auto___78771]));

var G__78772 = (i__5628__auto___78771 + (1));
i__5628__auto___78771 = G__78772;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic = (function (chart_data,p__78744){
var map__78745 = p__78744;
var map__78745__$1 = ((((!((map__78745 == null)))?((((map__78745.cljs$lang$protocol_mask$partition0$ & (64))) || (map__78745.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__78745):map__78745);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__78745__$1,cljs.core.cst$kw$data_DASH_type,"int");
var chart_width = 700.0;
var chart_height = 300.0;
var margin = 33.0;
var small_margin = 2.0;
var y_lim = 8.0;
var neg_margin = (-15);
var extracted_data = hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic(chart_data,cljs.core.array_seq([cljs.core.cst$kw$data_DASH_type,data_type], 0));
var map__78747 = cljs.core.meta(chart_data);
var map__78747__$1 = ((((!((map__78747 == null)))?((((map__78747.cljs$lang$protocol_mask$partition0$ & (64))) || (map__78747.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__78747):map__78747);
var nil_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78747__$1,cljs.core.cst$kw$nil_DASH_count);
var non_nil_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78747__$1,cljs.core.cst$kw$non_DASH_nil_DASH_count);
var bins = cljs.core.cst$kw$bins.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(extracted_data));
var x_series = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,extracted_data);
var dx_series = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.second,extracted_data);
var y_series = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.last,extracted_data);
var xmin = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,x_series);
var xmax = (cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,x_series) + cljs.core.last(dx_series));
var x_scale = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [xmin,xmax], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_width], null)], 0));
var y_scale = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,y_series)], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_height], null)], 0));
var bin_width = hatti.maths.floor(((chart_width / bins) - small_margin));
var x_ticks = cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2((2),cljs.core.rest(x_series));
var fmt = hatti.charting.int__GT_str(data_type);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(extracted_data))){
var vec__78749 = cljs.core.first(extracted_data);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78749,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78749,(1),null);
var total = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78749,(2),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,total," records have identical value: ",(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(value) : fmt.call(null,value))], null)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$svg,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$width,(margin + chart_width),cljs.core.cst$kw$height,(margin + chart_height)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$chart,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [margin,(0)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,(function (){var iter__5341__auto__ = ((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__78747,map__78747__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__78745,map__78745__$1,data_type){
return (function hatti$charting$iter__78750(s__78751){
return (new cljs.core.LazySeq(null,((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__78747,map__78747__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__78745,map__78745__$1,data_type){
return (function (){
var s__78751__$1 = s__78751;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__78751__$1);
if(temp__4425__auto__){
var s__78751__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__78751__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__78751__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__78753 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__78752 = (0);
while(true){
if((i__78752 < size__5340__auto__)){
var vec__78760 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__78752);
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78760,(0),null);
var dx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78760,(1),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78760,(2),null);
cljs.core.chunk_append(b__78753,(function (){var x_scaled = (x_scale.cljs$core$IFn$_invoke$arity$1 ? x_scale.cljs$core$IFn$_invoke$arity$1(x) : x_scale.call(null,x));
var y_scaled = (y_scale.cljs$core$IFn$_invoke$arity$1 ? y_scale.cljs$core$IFn$_invoke$arity$1(y) : y_scale.call(null,y));
var vec__78761 = (((((0) < y_scaled)) && ((y_scaled < y_lim)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [small_margin,neg_margin,"out-of-bar"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [y_scaled,small_margin,"in-bar"], null));
var y_scaled__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78761,(0),null);
var txt_ht = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78761,(1),null);
var txt_cls = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78761,(2),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$bars,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scaled,(chart_height - y_scaled__$1)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rect,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,(1),cljs.core.cst$kw$height,y_scaled__$1,cljs.core.cst$kw$width,bin_width], null)], null)], null),(((y_scaled__$1 > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$y,txt_ht,cljs.core.cst$kw$x,(bin_width / 2.0),cljs.core.cst$kw$dy,"1em",cljs.core.cst$kw$text_DASH_anchor,"middle",cljs.core.cst$kw$class,txt_cls], null),y], null):null)], null);
})());

var G__78773 = (i__78752 + (1));
i__78752 = G__78773;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__78753),hatti$charting$iter__78750(cljs.core.chunk_rest(s__78751__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__78753),null);
}
} else {
var vec__78762 = cljs.core.first(s__78751__$2);
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78762,(0),null);
var dx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78762,(1),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78762,(2),null);
return cljs.core.cons((function (){var x_scaled = (x_scale.cljs$core$IFn$_invoke$arity$1 ? x_scale.cljs$core$IFn$_invoke$arity$1(x) : x_scale.call(null,x));
var y_scaled = (y_scale.cljs$core$IFn$_invoke$arity$1 ? y_scale.cljs$core$IFn$_invoke$arity$1(y) : y_scale.call(null,y));
var vec__78763 = (((((0) < y_scaled)) && ((y_scaled < y_lim)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [small_margin,neg_margin,"out-of-bar"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [y_scaled,small_margin,"in-bar"], null));
var y_scaled__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78763,(0),null);
var txt_ht = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78763,(1),null);
var txt_cls = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78763,(2),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$bars,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scaled,(chart_height - y_scaled__$1)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rect,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,(1),cljs.core.cst$kw$height,y_scaled__$1,cljs.core.cst$kw$width,bin_width], null)], null)], null),(((y_scaled__$1 > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$y,txt_ht,cljs.core.cst$kw$x,(bin_width / 2.0),cljs.core.cst$kw$dy,"1em",cljs.core.cst$kw$text_DASH_anchor,"middle",cljs.core.cst$kw$class,txt_cls], null),y], null):null)], null);
})(),hatti$charting$iter__78750(cljs.core.rest(s__78751__$2)));
}
} else {
return null;
}
break;
}
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__78747,map__78747__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__78745,map__78745__$1,data_type))
,null,null));
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__78747,map__78747__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__78745,map__78745__$1,data_type))
;
return iter__5341__auto__(extracted_data);
})()], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$axis,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_height], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$x1,(0),cljs.core.cst$kw$x2,chart_width], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,(function (){var iter__5341__auto__ = ((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__78747,map__78747__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__78745,map__78745__$1,data_type){
return (function hatti$charting$iter__78764(s__78765){
return (new cljs.core.LazySeq(null,((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__78747,map__78747__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__78745,map__78745__$1,data_type){
return (function (){
var s__78765__$1 = s__78765;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__78765__$1);
if(temp__4425__auto__){
var s__78765__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__78765__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__78765__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__78767 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__78766 = (0);
while(true){
if((i__78766 < size__5340__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__78766);
cljs.core.chunk_append(b__78767,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$tick,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(x_scale.cljs$core$IFn$_invoke$arity$1 ? x_scale.cljs$core$IFn$_invoke$arity$1(x) : x_scale.call(null,x)),(0)], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$y,(25),cljs.core.cst$kw$text_DASH_anchor,"middle",cljs.core.cst$kw$class,data_type], null),(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(x) : fmt.call(null,x))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$class,"tick",cljs.core.cst$kw$y2,(10),cljs.core.cst$kw$x2,(0)], null)], null)], null));

var G__78774 = (i__78766 + (1));
i__78766 = G__78774;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__78767),hatti$charting$iter__78764(cljs.core.chunk_rest(s__78765__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__78767),null);
}
} else {
var x = cljs.core.first(s__78765__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$tick,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(x_scale.cljs$core$IFn$_invoke$arity$1 ? x_scale.cljs$core$IFn$_invoke$arity$1(x) : x_scale.call(null,x)),(0)], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$y,(25),cljs.core.cst$kw$text_DASH_anchor,"middle",cljs.core.cst$kw$class,data_type], null),(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(x) : fmt.call(null,x))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$class,"tick",cljs.core.cst$kw$y2,(10),cljs.core.cst$kw$x2,(0)], null)], null)], null),hatti$charting$iter__78764(cljs.core.rest(s__78765__$2)));
}
} else {
return null;
}
break;
}
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__78747,map__78747__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__78745,map__78745__$1,data_type))
,null,null));
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__78747,map__78747__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__78745,map__78745__$1,data_type))
;
return iter__5341__auto__(x_ticks);
})()], null)], null)], null)], null),hatti.charting.response_count_message(non_nil_count)], null);
}
});

hatti.charting.numeric_chart.cljs$lang$maxFixedArity = (1);

hatti.charting.numeric_chart.cljs$lang$applyTo = (function (seq78742){
var G__78743 = cljs.core.first(seq78742);
var seq78742__$1 = cljs.core.next(seq78742);
return hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic(G__78743,seq78742__$1);
});
/**
 * Create category bar chart out of some data + count data. Data of form:
 *   {'Label1' 1 'Label2' 2}, etc. where the numbers are counts.
 */
hatti.charting.table_chart_h = (function hatti$charting$table_chart_h(data,nil_count,non_nil_count,field_type){
var max_count = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.vals(data));
var percent_s = ((function (max_count){
return (function (n,total){
var s = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),total], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(100)], null)], 0));
return [cljs.core.str(hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic("%.1f",cljs.core.array_seq([(s.cljs$core$IFn$_invoke$arity$1 ? s.cljs$core$IFn$_invoke$arity$1(n) : s.call(null,n))], 0))),cljs.core.str("%")].join('');
});})(max_count))
;
var select_mult_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(field_type,"select all that apply");
var bar_div = ((select_mult_QMARK_)?cljs.core.cst$kw$div$bars$select_DASH_mult:cljs.core.cst$kw$div$bars$select_DASH_one);
var tdr = cljs.core.cst$kw$td$t_DASH_right;
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table_SHARP_bar_DASH_chart$table,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$thead,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th$t_DASH_right,"Count"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th$t_DASH_right,"Percent"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tfoot,((select_mult_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr$t_DASH_grey,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$col_DASH_span,(4)], null),hatti.charting.response_count_message(non_nil_count)], null)], null):new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr$t_DASH_grey,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,"Total"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,non_nil_count], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,"100%"], null)], null)),(((!(select_mult_QMARK_)) && ((nil_count > (0))))?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr$t_DASH_grey,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,"No response"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,nil_count], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td], null)], null):null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,(function (){var iter__5341__auto__ = ((function (max_count,percent_s,select_mult_QMARK_,bar_div,tdr){
return (function hatti$charting$table_chart_h_$_iter__78785(s__78786){
return (new cljs.core.LazySeq(null,((function (max_count,percent_s,select_mult_QMARK_,bar_div,tdr){
return (function (){
var s__78786__$1 = s__78786;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__78786__$1);
if(temp__4425__auto__){
var s__78786__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__78786__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__78786__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__78788 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__78787 = (0);
while(true){
if((i__78787 < size__5340__auto__)){
var vec__78793 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__78787);
var label = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78793,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78793,(1),null);
cljs.core.chunk_append(b__78788,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,label], null),label], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bar_div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$width,percent_s(val,max_count)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,val], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,percent_s(val,non_nil_count)], null)], null));

var G__78795 = (i__78787 + (1));
i__78787 = G__78795;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__78788),hatti$charting$table_chart_h_$_iter__78785(cljs.core.chunk_rest(s__78786__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__78788),null);
}
} else {
var vec__78794 = cljs.core.first(s__78786__$2);
var label = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78794,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78794,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,label], null),label], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bar_div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$width,percent_s(val,max_count)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,val], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,percent_s(val,non_nil_count)], null)], null),hatti$charting$table_chart_h_$_iter__78785(cljs.core.rest(s__78786__$2)));
}
} else {
return null;
}
break;
}
});})(max_count,percent_s,select_mult_QMARK_,bar_div,tdr))
,null,null));
});})(max_count,percent_s,select_mult_QMARK_,bar_div,tdr))
;
return iter__5341__auto__(data);
})()], null)], null);
});
/**
 * Removes nil from Ona API chart data; adds nil- and non-nil-count metadata.
 * ex. Input:  {:field_xpath 'D' :data [{:D nil :count 5} {:D 1 :count 10}]}
 *     Output: {:field_xpath 'D' :data [{:D 1 :count 10}]}
 *             w/ metadata: {:nil-count 5 :non-nil-count 10}
 */
hatti.charting.extract_nil = (function hatti$charting$extract_nil(chart_data){
var map__78801 = chart_data;
var map__78801__$1 = ((((!((map__78801 == null)))?((((map__78801.cljs$lang$protocol_mask$partition0$ & (64))) || (map__78801.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__78801):map__78801);
var field_xpath = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78801__$1,cljs.core.cst$kw$field_xpath);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78801__$1,cljs.core.cst$kw$data);
var na_QMARK_ = ((function (map__78801,map__78801__$1,field_xpath,data){
return (function (p1__78796_SHARP_){
return ((p1__78796_SHARP_ == null)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__78796_SHARP_));
});})(map__78801,map__78801__$1,field_xpath,data))
;
var nil_data = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__78801,map__78801__$1,field_xpath,data,na_QMARK_){
return (function (p1__78797_SHARP_){
return na_QMARK_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath).call(null,p1__78797_SHARP_));
});})(map__78801,map__78801__$1,field_xpath,data,na_QMARK_))
,data));
var non_nil_data = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (map__78801,map__78801__$1,field_xpath,data,na_QMARK_,nil_data){
return (function (p1__78798_SHARP_){
return na_QMARK_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath).call(null,p1__78798_SHARP_));
});})(map__78801,map__78801__$1,field_xpath,data,na_QMARK_,nil_data))
,data);
var nil_count = (function (){var temp__4423__auto__ = cljs.core.cst$kw$count.cljs$core$IFn$_invoke$arity$1(nil_data);
if(cljs.core.truth_(temp__4423__auto__)){
var n = temp__4423__auto__;
return n;
} else {
return (0);
}
})();
var non_nil_count = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$count,non_nil_data));
return cljs.core.with_meta(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(chart_data,cljs.core.cst$kw$data,non_nil_data),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$nil_DASH_count,nil_count,cljs.core.cst$kw$non_DASH_nil_DASH_count,non_nil_count], null));
});
/**
 * Make chart depending on datatype.
 */
hatti.charting.make_chart = (function hatti$charting$make_chart(var_args){
var args78804 = [];
var len__5627__auto___78812 = arguments.length;
var i__5628__auto___78813 = (0);
while(true){
if((i__5628__auto___78813 < len__5627__auto___78812)){
args78804.push((arguments[i__5628__auto___78813]));

var G__78814 = (i__5628__auto___78813 + (1));
i__5628__auto___78813 = G__78814;
continue;
} else {
}
break;
}

var G__78806 = args78804.length;
switch (G__78806) {
case 1:
return hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args78804.length)].join('')));

}
});

hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$1 = (function (chart_data){
return hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$2(chart_data,null);
});

hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$2 = (function (chart_data,language){
var map__78807 = chart_data;
var map__78807__$1 = ((((!((map__78807 == null)))?((((map__78807.cljs$lang$protocol_mask$partition0$ & (64))) || (map__78807.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__78807):map__78807);
var field_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78807__$1,cljs.core.cst$kw$field_label);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78807__$1,cljs.core.cst$kw$data_type);
var field_xpath = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78807__$1,cljs.core.cst$kw$field_xpath);
var field_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78807__$1,cljs.core.cst$kw$field_type);
var chart_data__$1 = hatti.charting.extract_nil(chart_data);
var map__78808 = cljs.core.meta(chart_data__$1);
var map__78808__$1 = ((((!((map__78808 == null)))?((((map__78808.cljs$lang$protocol_mask$partition0$ & (64))) || (map__78808.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__78808):map__78808);
var nil_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78808__$1,cljs.core.cst$kw$nil_DASH_count);
var non_nil_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78808__$1,cljs.core.cst$kw$non_DASH_nil_DASH_count);
var not_supported = ((function (map__78807,map__78807__$1,field_label,data_type,field_xpath,field_type,chart_data__$1,map__78808,map__78808__$1,nil_count,non_nil_count){
return (function (p1__78803_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$div$t_DASH_red,[cljs.core.str("Aplogies. At the moment, making a chart of\n                                     this data type ("),cljs.core.str(p1__78803_SHARP_),cljs.core.str(") is not supported.")].join('')],null));
});})(map__78807,map__78807__$1,field_label,data_type,field_xpath,field_type,chart_data__$1,map__78808,map__78808__$1,nil_count,non_nil_count))
;
var chart = (((non_nil_count === (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"No data"], null):(function (){var G__78811 = data_type;
switch (G__78811) {
case "categorized":
return hatti.charting.table_chart_h(hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2(chart_data__$1,language),nil_count,non_nil_count,field_type);

break;
case "time_based":
return hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic(chart_data__$1,cljs.core.array_seq([cljs.core.cst$kw$data_DASH_type,"date"], 0));

break;
case "numeric":
return hatti.charting.numeric_chart(chart_data__$1);

break;
default:
return not_supported(data_type);

}
})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$label,field_label,cljs.core.cst$kw$name,field_xpath,cljs.core.cst$kw$chart,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,chart], null)], null);
});

hatti.charting.make_chart.cljs$lang$maxFixedArity = 2;
