// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.map.viewby');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('hatti.utils');
goog.require('hatti.charting');
goog.require('hatti.ona.forms');
goog.require('hatti.map.utils');
/**
 * Saturated qualitative palette from colorbrewer.
 * Saturated red+brown disabled due to clash with the :clicked color.
 */
hatti.map.viewby.qualitative_palette = new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#1f78b4","#33a02c","#6a3d9a","#ffff99","#b15928","#a6cee3","#b2df8a","#fb9a99","#fdbf6f","#cab2d6"], null);
/**
 * Color palette of YlGnBl from colorbrewer.
 */
hatti.map.viewby.sequential_palette = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#ffffcc","#bdd7e7","#6baed6","#3182bd","#08519c"], null);
/**
 * A Grey Color for deselected points.
 */
hatti.map.viewby.grey = "#d9d9d9";
hatti.map.viewby.marker_styler = (function hatti$map$viewby$marker_styler(id_color,id_selected_QMARK_){
return (function (marker){
var id = hatti.map.utils.get_id.call(null,marker);
var geotype = hatti.map.utils.marker__GT_geotype.call(null,marker);
var color_key = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"line","line",212345235),geotype))?new cljs.core.Keyword(null,"color","color",1011675173):new cljs.core.Keyword(null,"fillColor","fillColor",-176906116));
return cljs.core.PersistentArrayMap.fromArray([color_key,(cljs.core.truth_(id_selected_QMARK_.call(null,id))?id_color.call(null,id):hatti.map.viewby.grey)], true, false);
});
});
hatti.map.viewby.move_nil_to_end = (function hatti$map$viewby$move_nil_to_end(s){
var no_nil = cljs.core.vec.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,s));
if(cljs.core._EQ_.call(null,s,no_nil)){
return s;
} else {
return cljs.core.conj.call(null,no_nil,null);
}
});
hatti.map.viewby.all_but_nil_selected = (function hatti$map$viewby$all_but_nil_selected(answers){
return cljs.core.merge.call(null,cljs.core.zipmap.call(null,answers,cljs.core.repeat.call(null,true)),new cljs.core.PersistentArrayMap(null, 1, [null,false], null));
});
/**
 * Preproccesses answers depending on the field. For multi-selects, return type
 * is a list of list of strings. For other types, a list of strings.
 */
hatti.map.viewby.preprocess_answers = (function hatti$map$viewby$preprocess_answers(field,raw_answers){
if(cljs.core.truth_(hatti.ona.forms.select_one_QMARK_.call(null,field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.text_QMARK_.call(null,field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.calculate_QMARK_.call(null,field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_.call(null,field))){
return hatti.charting.evenly_spaced_bins.call(null,raw_answers,(5),"int");
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_.call(null,field))){
return hatti.charting.evenly_spaced_bins.call(null,raw_answers,(5),"date");
} else {
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_.call(null,field))){
return cljs.core.map.call(null,(function (p1__11577_SHARP_){
if(cljs.core.truth_(p1__11577_SHARP_)){
return clojure.string.split.call(null,p1__11577_SHARP_,/ /);
} else {
return null;
}
}),raw_answers);
} else {
return null;
}
}
}
}
}
}
});
/**
 * Returns the appropriate set of colors given the field.
 */
hatti.map.viewby.field__GT_colors = (function hatti$map$viewby$field__GT_colors(field){
if(cljs.core.truth_(hatti.ona.forms.select_one_QMARK_.call(null,field))){
if((cljs.core.count.call(null,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(field)) <= cljs.core.count.call(null,hatti.map.viewby.qualitative_palette))){
return hatti.map.viewby.qualitative_palette;
} else {
return cljs.core.repeat.call(null,"#f30");
}
} else {
if(cljs.core.truth_(hatti.ona.forms.calculate_QMARK_.call(null,field))){
return hatti.map.viewby.qualitative_palette;
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_.call(null,field))){
return hatti.map.viewby.sequential_palette;
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_.call(null,field))){
return hatti.map.viewby.sequential_palette;
} else {
if(cljs.core.truth_(hatti.ona.forms.text_QMARK_.call(null,field))){
return cljs.core.repeat.call(null,"#f30");
} else {
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_.call(null,field))){
return cljs.core.repeat.call(null,"#f30");
} else {
return null;
}
}
}
}
}
}
});
/**
 * Produces a set of data structures / functions for view-by.
 * answers are a list of answers, sorted by count;
 * id->answers is a mapping from id to either one or many answers
 * answer->count, answer->selected?, answer->color are maps from answer;
 * used for the legend rendering. An 'answer' is mapped from a data element,
 * eg. a bin for numbers/dates, an option for multiple/single selects.
 */
hatti.map.viewby.viewby_info = (function hatti$map$viewby$viewby_info(field,raw_answers,ids){
var fname = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var ans_s = hatti.map.viewby.preprocess_answers.call(null,field,raw_answers);
var answer__GT_count = cljs.core.frequencies.call(null,cljs.core.flatten.call(null,ans_s));
var sorted = (cljs.core.truth_((function (){var or__4569__auto__ = hatti.ona.forms.categorical_QMARK_.call(null,field);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var or__4569__auto____$1 = hatti.ona.forms.text_QMARK_.call(null,field);
if(cljs.core.truth_(or__4569__auto____$1)){
return or__4569__auto____$1;
} else {
return hatti.ona.forms.calculate_QMARK_.call(null,field);
}
}
})())?cljs.core.map.call(null,cljs.core.first,cljs.core.sort_by.call(null,cljs.core.second,cljs.core._GT_,answer__GT_count)):(cljs.core.truth_((function (){var or__4569__auto__ = hatti.ona.forms.time_based_QMARK_.call(null,field);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.ona.forms.numeric_QMARK_.call(null,field);
}
})())?new cljs.core.Keyword(null,"bins","bins",1670395210).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,ans_s)):null));
var sorted_nil_at_end = hatti.map.viewby.move_nil_to_end.call(null,sorted);
var colors = hatti.map.viewby.field__GT_colors.call(null,field);
var defaults = new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"answers","answers",-2066449770),sorted_nil_at_end,new cljs.core.Keyword(null,"id->answers","id->answers",-655129337),cljs.core.zipmap.call(null,ids,ans_s),new cljs.core.Keyword(null,"answer->count","answer->count",-99425122),answer__GT_count,new cljs.core.Keyword(null,"answer->selected?","answer->selected?",2082517958),hatti.map.viewby.all_but_nil_selected.call(null,sorted),new cljs.core.Keyword(null,"answer->color","answer->color",-142632854),cljs.core.zipmap.call(null,sorted,colors),new cljs.core.Keyword(null,"visible-answers","visible-answers",-771956023),sorted_nil_at_end,new cljs.core.Keyword(null,"field","field",-1302436500),field], null);
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_.call(null,field))){
return cljs.core.merge.call(null,defaults,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id-color","id-color",-484052665),((function (fname,ans_s,answer__GT_count,sorted,sorted_nil_at_end,colors,defaults){
return (function (){
return cljs.core.first.call(null,colors);
});})(fname,ans_s,answer__GT_count,sorted,sorted_nil_at_end,colors,defaults))
], null));
} else {
return defaults;

}
});
/**
 * Generates id-color and id-selected? functions based on viewby-info.
 */
hatti.map.viewby.id_color_selected = (function hatti$map$viewby$id_color_selected(p__11580){
var map__11584 = p__11580;
var map__11584__$1 = ((((!((map__11584 == null)))?((((map__11584.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11584.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11584):map__11584);
var field = cljs.core.get.call(null,map__11584__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var id__GT_answers = cljs.core.get.call(null,map__11584__$1,new cljs.core.Keyword(null,"id->answers","id->answers",-655129337));
var answer__GT_color = cljs.core.get.call(null,map__11584__$1,new cljs.core.Keyword(null,"answer->color","answer->color",-142632854));
var answer__GT_selected_QMARK_ = cljs.core.get.call(null,map__11584__$1,new cljs.core.Keyword(null,"answer->selected?","answer->selected?",2082517958));
var G__11586 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(field);
switch (G__11586) {
case "select all that apply":
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id-color","id-color",-484052665),((function (G__11586,map__11584,map__11584__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (){
return cljs.core.first.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#f30"], null));
});})(G__11586,map__11584,map__11584__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
,new cljs.core.Keyword(null,"id-selected?","id-selected?",1326938375),((function (G__11586,map__11584,map__11584__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (id){
var answers = id__GT_answers.call(null,id);
if((answers == null)){
return cljs.core.get.call(null,answer__GT_selected_QMARK_,answers);
} else {
return cljs.core.some.call(null,cljs.core.identity,cljs.core.map.call(null,answer__GT_selected_QMARK_,answers));
}
});})(G__11586,map__11584,map__11584__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
], null);

break;
default:
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id-color","id-color",-484052665),((function (G__11586,map__11584,map__11584__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (p1__11578_SHARP_){
return answer__GT_color.call(null,id__GT_answers.call(null,p1__11578_SHARP_));
});})(G__11586,map__11584,map__11584__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
,new cljs.core.Keyword(null,"id-selected?","id-selected?",1326938375),((function (G__11586,map__11584,map__11584__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (p1__11579_SHARP_){
return answer__GT_selected_QMARK_.call(null,id__GT_answers.call(null,p1__11579_SHARP_));
});})(G__11586,map__11584,map__11584__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
], null);

}
});
hatti.map.viewby.view_by_BANG_ = (function hatti$map$viewby$view_by_BANG_(view_by_info,markers){
var map__11594 = hatti.map.viewby.id_color_selected.call(null,view_by_info);
var map__11594__$1 = ((((!((map__11594 == null)))?((((map__11594.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11594.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11594):map__11594);
var id_selected_QMARK_ = cljs.core.get.call(null,map__11594__$1,new cljs.core.Keyword(null,"id-selected?","id-selected?",1326938375));
var id_color = cljs.core.get.call(null,map__11594__$1,new cljs.core.Keyword(null,"id-color","id-color",-484052665));
var m__GT_s = hatti.map.viewby.marker_styler.call(null,id_color,id_selected_QMARK_);
var seq__11596 = cljs.core.seq.call(null,markers);
var chunk__11597 = null;
var count__11598 = (0);
var i__11599 = (0);
while(true){
if((i__11599 < count__11598)){
var marker = cljs.core._nth.call(null,chunk__11597,i__11599);
hatti.map.utils.re_style_marker.call(null,m__GT_s,marker);

hatti.map.utils.bring_to_top_if_selected.call(null,id_selected_QMARK_,marker);

var G__11600 = seq__11596;
var G__11601 = chunk__11597;
var G__11602 = count__11598;
var G__11603 = (i__11599 + (1));
seq__11596 = G__11600;
chunk__11597 = G__11601;
count__11598 = G__11602;
i__11599 = G__11603;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__11596);
if(temp__4425__auto__){
var seq__11596__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11596__$1)){
var c__5372__auto__ = cljs.core.chunk_first.call(null,seq__11596__$1);
var G__11604 = cljs.core.chunk_rest.call(null,seq__11596__$1);
var G__11605 = c__5372__auto__;
var G__11606 = cljs.core.count.call(null,c__5372__auto__);
var G__11607 = (0);
seq__11596 = G__11604;
chunk__11597 = G__11605;
count__11598 = G__11606;
i__11599 = G__11607;
continue;
} else {
var marker = cljs.core.first.call(null,seq__11596__$1);
hatti.map.utils.re_style_marker.call(null,m__GT_s,marker);

hatti.map.utils.bring_to_top_if_selected.call(null,id_selected_QMARK_,marker);

var G__11608 = cljs.core.next.call(null,seq__11596__$1);
var G__11609 = null;
var G__11610 = (0);
var G__11611 = (0);
seq__11596 = G__11608;
chunk__11597 = G__11609;
count__11598 = G__11610;
i__11599 = G__11611;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Given a list of answers + query, returns map from answers to true/false.
 * True if query is in the answer, false if not.
 */
hatti.map.viewby.filter_answer_data_structures = (function hatti$map$viewby$filter_answer_data_structures(answers,query,field,language){
var query_present_QMARK_ = (function (ans){
if(cljs.core.truth_(ans)){
return cljs.core.re_find.call(null,hatti.utils.safe_regex.call(null,query),hatti.ona.forms.format_answer.call(null,field,ans,language));
} else {
return null;
}
});
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"visible-answers","visible-answers",-771956023),cljs.core.filter.call(null,query_present_QMARK_,answers),new cljs.core.Keyword(null,"answer->selected?","answer->selected?",2082517958),cljs.core.zipmap.call(null,answers,cljs.core.map.call(null,query_present_QMARK_,answers))], null);
});
/**
 * This function appropriately toggles answer->selected? when answer is clicked
 * answer->selected? is a map from answers to true/false. Special rules:
 * First click = select the answer. If nothing clicked, make everything
 * clicked.
 */
hatti.map.viewby.toggle_answer_selected = (function hatti$map$viewby$toggle_answer_selected(answer__GT_selected_QMARK_,visible_answers,answer){
var all_answers = cljs.core.vals.call(null,answer__GT_selected_QMARK_);
var all_visible_selected_QMARK_ = ((function (all_answers){
return (function (a__GT_s,visible){
return cljs.core._EQ_.call(null,cljs.core.set.call(null,visible),cljs.core.set.call(null,cljs.core.keys.call(null,cljs.core.filter.call(null,cljs.core.second,a__GT_s))));
});})(all_answers))
;
if((answer == null)){
return answer__GT_selected_QMARK_;
} else {
if(cljs.core.truth_(all_visible_selected_QMARK_.call(null,answer__GT_selected_QMARK_,visible_answers))){
return cljs.core.merge.call(null,cljs.core.zipmap.call(null,all_answers,cljs.core.repeat.call(null,false)),cljs.core.PersistentArrayMap.fromArray([answer,true], true, false));
} else {
var toggled = cljs.core.update_in.call(null,answer__GT_selected_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer], null),cljs.core.not);
if(cljs.core.every_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.vals.call(null,toggled))){
return cljs.core.merge.call(null,cljs.core.zipmap.call(null,all_answers,cljs.core.repeat.call(null,false)),hatti.map.viewby.all_but_nil_selected.call(null,visible_answers));
} else {
return toggled;
}
}
}
});
