// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.utils');
goog.require('hatti.utils.om.state');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.call(null,hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten.call(null,(function (){var iter__5341__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__12804(s__12805){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__12805__$1 = s__12805;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__12805__$1);
if(temp__4425__auto__){
var s__12805__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__12805__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__12805__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__12807 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__12806 = (0);
while(true){
if((i__12806 < size__5340__auto__)){
var datum = cljs.core._nth.call(null,c__5339__auto__,i__12806);
cljs.core.chunk_append.call(null,b__12807,(function (){var iter__5341__auto__ = ((function (i__12806,datum,c__5339__auto__,size__5340__auto__,b__12807,s__12805__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__12804_$_iter__12816(s__12817){
return (new cljs.core.LazySeq(null,((function (i__12806,datum,c__5339__auto__,size__5340__auto__,b__12807,s__12805__$2,temp__4425__auto__,osmfields){
return (function (){
var s__12817__$1 = s__12817;
while(true){
var temp__4425__auto____$1 = cljs.core.seq.call(null,s__12817__$1);
if(temp__4425__auto____$1){
var s__12817__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__12817__$2)){
var c__5339__auto____$1 = cljs.core.chunk_first.call(null,s__12817__$2);
var size__5340__auto____$1 = cljs.core.count.call(null,c__5339__auto____$1);
var b__12819 = cljs.core.chunk_buffer.call(null,size__5340__auto____$1);
if((function (){var i__12818 = (0);
while(true){
if((i__12818 < size__5340__auto____$1)){
var field = cljs.core._nth.call(null,c__5339__auto____$1,i__12818);
cljs.core.chunk_append.call(null,b__12819,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})());

var G__12824 = (i__12818 + (1));
i__12818 = G__12824;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12819),hatti$ona$post_process$ona_osm_link_$_iter__12804_$_iter__12816.call(null,cljs.core.chunk_rest.call(null,s__12817__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12819),null);
}
} else {
var field = cljs.core.first.call(null,s__12817__$2);
return cljs.core.cons.call(null,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__12804_$_iter__12816.call(null,cljs.core.rest.call(null,s__12817__$2)));
}
} else {
return null;
}
break;
}
});})(i__12806,datum,c__5339__auto__,size__5340__auto__,b__12807,s__12805__$2,temp__4425__auto__,osmfields))
,null,null));
});})(i__12806,datum,c__5339__auto__,size__5340__auto__,b__12807,s__12805__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__.call(null,osmfields);
})());

var G__12825 = (i__12806 + (1));
i__12806 = G__12825;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12807),hatti$ona$post_process$ona_osm_link_$_iter__12804.call(null,cljs.core.chunk_rest.call(null,s__12805__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12807),null);
}
} else {
var datum = cljs.core.first.call(null,s__12805__$2);
return cljs.core.cons.call(null,(function (){var iter__5341__auto__ = ((function (datum,s__12805__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__12804_$_iter__12820(s__12821){
return (new cljs.core.LazySeq(null,((function (datum,s__12805__$2,temp__4425__auto__,osmfields){
return (function (){
var s__12821__$1 = s__12821;
while(true){
var temp__4425__auto____$1 = cljs.core.seq.call(null,s__12821__$1);
if(temp__4425__auto____$1){
var s__12821__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__12821__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__12821__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__12823 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__12822 = (0);
while(true){
if((i__12822 < size__5340__auto__)){
var field = cljs.core._nth.call(null,c__5339__auto__,i__12822);
cljs.core.chunk_append.call(null,b__12823,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})());

var G__12826 = (i__12822 + (1));
i__12822 = G__12826;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12823),hatti$ona$post_process$ona_osm_link_$_iter__12804_$_iter__12820.call(null,cljs.core.chunk_rest.call(null,s__12821__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12823),null);
}
} else {
var field = cljs.core.first.call(null,s__12821__$2);
return cljs.core.cons.call(null,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__12804_$_iter__12820.call(null,cljs.core.rest.call(null,s__12821__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__12805__$2,temp__4425__auto__,osmfields))
,null,null));
});})(datum,s__12805__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__.call(null,osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__12804.call(null,cljs.core.rest.call(null,s__12805__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__5341__auto__.call(null,data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.call(null,osmtogeojson(jQuery.parseXML(osm_xml_string)),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link.call(null,data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson.call(null,osm_xml);
var featureset = osmgeo.call(null,new cljs.core.Keyword(null,"features","features",-1146962336));
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5341__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__12847(s__12848){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__12848__$1 = s__12848;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__12848__$1);
if(temp__4425__auto__){
var s__12848__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__12848__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__12848__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__12850 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__12849 = (0);
while(true){
if((i__12849 < size__5340__auto__)){
var map__12859 = cljs.core._nth.call(null,c__5339__auto__,i__12849);
var map__12859__$1 = ((((!((map__12859 == null)))?((((map__12859.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12859.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12859):map__12859);
var feature = map__12859__$1;
var type = cljs.core.get.call(null,map__12859__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var properties = cljs.core.get.call(null,map__12859__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var geometry = cljs.core.get.call(null,map__12859__$1,new cljs.core.Keyword(null,"geometry","geometry",-405034994));
cljs.core.chunk_append.call(null,b__12850,(function (){var map__12861 = properties;
var map__12861__$1 = ((((!((map__12861 == null)))?((((map__12861.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12861.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12861):map__12861);
var type__$1 = cljs.core.get.call(null,map__12861__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var id = cljs.core.get.call(null,map__12861__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tags = cljs.core.get.call(null,map__12861__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"osm-id","osm-id",-1125866420),id,new cljs.core.Keyword(null,"type","type",1174270348),type__$1,new cljs.core.Keyword(null,"geom","geom",1207084371),geometry,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(tags),new cljs.core.Keyword(null,"tags","tags",1771418977),tags], null)], true, false);
})());

var G__12867 = (i__12849 + (1));
i__12849 = G__12867;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12850),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__12847.call(null,cljs.core.chunk_rest.call(null,s__12848__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12850),null);
}
} else {
var map__12863 = cljs.core.first.call(null,s__12848__$2);
var map__12863__$1 = ((((!((map__12863 == null)))?((((map__12863.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12863.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12863):map__12863);
var feature = map__12863__$1;
var type = cljs.core.get.call(null,map__12863__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var properties = cljs.core.get.call(null,map__12863__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var geometry = cljs.core.get.call(null,map__12863__$1,new cljs.core.Keyword(null,"geometry","geometry",-405034994));
return cljs.core.cons.call(null,(function (){var map__12865 = properties;
var map__12865__$1 = ((((!((map__12865 == null)))?((((map__12865.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12865.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12865):map__12865);
var type__$1 = cljs.core.get.call(null,map__12865__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var id = cljs.core.get.call(null,map__12865__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tags = cljs.core.get.call(null,map__12865__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"osm-id","osm-id",-1125866420),id,new cljs.core.Keyword(null,"type","type",1174270348),type__$1,new cljs.core.Keyword(null,"geom","geom",1207084371),geometry,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(tags),new cljs.core.Keyword(null,"tags","tags",1771418977),tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__12847.call(null,cljs.core.rest.call(null,s__12848__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__5341__auto__.call(null,featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.call(null,hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq.call(null,osm_fields)){
var data = cljs.core.get_in.call(null,app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data.call(null,data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__12868_SHARP_){
return cljs.core.re_find.call(null,/[-]?[0-9]+/,p1__12868_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val){
if(typeof osm_val === 'string'){
var temp__4423__auto__ = osm_data.call(null,osm_val__GT_osm_id.call(null,osm_val));
if(cljs.core.truth_(temp__4423__auto__)){
var osm_submission_data = temp__4423__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__5341__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__12877(s__12878){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__12878__$1 = s__12878;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__12878__$1);
if(temp__4425__auto__){
var s__12878__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__12878__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__12878__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__12880 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__12879 = (0);
while(true){
if((i__12879 < size__5340__auto__)){
var datum = cljs.core._nth.call(null,c__5339__auto__,i__12879);
cljs.core.chunk_append.call(null,b__12880,cljs.core.update_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data));

var G__12885 = (i__12879 + (1));
i__12879 = G__12885;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12880),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__12877.call(null,cljs.core.chunk_rest.call(null,s__12878__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12880),null);
}
} else {
var datum = cljs.core.first.call(null,s__12878__$2);
return cljs.core.cons.call(null,cljs.core.update_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__12877.call(null,cljs.core.rest.call(null,s__12878__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__5341__auto__.call(null,data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__12881 = cljs.core.seq.call(null,osm_fields);
var chunk__12882 = null;
var count__12883 = (0);
var i__12884 = (0);
while(true){
if((i__12884 < count__12883)){
var osm_field = cljs.core._nth.call(null,chunk__12882,i__12884);
hatti.utils.om.state.transact_app_state_BANG_.call(null,app_state,app_state_keys,updater.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__12886 = seq__12881;
var G__12887 = chunk__12882;
var G__12888 = count__12883;
var G__12889 = (i__12884 + (1));
seq__12881 = G__12886;
chunk__12882 = G__12887;
count__12883 = G__12888;
i__12884 = G__12889;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__12881);
if(temp__4425__auto__){
var seq__12881__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12881__$1)){
var c__5372__auto__ = cljs.core.chunk_first.call(null,seq__12881__$1);
var G__12890 = cljs.core.chunk_rest.call(null,seq__12881__$1);
var G__12891 = c__5372__auto__;
var G__12892 = cljs.core.count.call(null,c__5372__auto__);
var G__12893 = (0);
seq__12881 = G__12890;
chunk__12882 = G__12891;
count__12883 = G__12892;
i__12884 = G__12893;
continue;
} else {
var osm_field = cljs.core.first.call(null,seq__12881__$1);
hatti.utils.om.state.transact_app_state_BANG_.call(null,app_state,app_state_keys,updater.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__12894 = cljs.core.next.call(null,seq__12881__$1);
var G__12895 = null;
var G__12896 = (0);
var G__12897 = (0);
seq__12881 = G__12894;
chunk__12882 = G__12895;
count__12883 = G__12896;
i__12884 = G__12897;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.call(null,media_obj,"id");
var fname = cljs.core.get.call(null,media_obj,"filename");
var file_url = hatti.ona.urls.media_url.call(null,media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"filename","filename",-1428840783),fname,new cljs.core.Keyword(null,"download_url","download_url",-2115471203),file_url,new cljs.core.Keyword(null,"small_download_url","small_download_url",1654303565),[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__4569__auto__ = attachments;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.call(null,record,"_attachments");
}
})();
var fnames = cljs.core.map.call(null,((function (attachments__$1){
return (function (p1__12898_SHARP_){
return hatti.utils.last_url_param.call(null,cljs.core.get.call(null,p1__12898_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap.call(null,fnames,cljs.core.map.call(null,hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.call(null,fname__GT_urlobj,fname,fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Inlines media data from within _attachments into each record.
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__5634__auto__ = [];
var len__5627__auto___12909 = arguments.length;
var i__5628__auto___12910 = (0);
while(true){
if((i__5628__auto___12910 < len__5627__auto___12909)){
args__5634__auto__.push((arguments[i__5628__auto___12910]));

var G__12911 = (i__5628__auto___12910 + (1));
i__5628__auto___12910 = G__12911;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__12902){
var map__12903 = p__12902;
var map__12903__$1 = ((((!((map__12903 == null)))?((((map__12903.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12903.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12903):map__12903);
var attachments = cljs.core.get.call(null,map__12903__$1,new cljs.core.Keyword(null,"attachments","attachments",-1535547830));
var image_fields = cljs.core.filter.call(null,hatti.ona.forms.image_QMARK_,flat_form);
var iter__5341__auto__ = ((function (image_fields,map__12903,map__12903__$1,attachments){
return (function hatti$ona$post_process$iter__12905(s__12906){
return (new cljs.core.LazySeq(null,((function (image_fields,map__12903,map__12903__$1,attachments){
return (function (){
var s__12906__$1 = s__12906;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__12906__$1);
if(temp__4425__auto__){
var s__12906__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__12906__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__12906__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__12908 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__12907 = (0);
while(true){
if((i__12907 < size__5340__auto__)){
var record = cljs.core._nth.call(null,c__5339__auto__,i__12907);
cljs.core.chunk_append.call(null,b__12908,(function (){var attach_map = hatti.ona.post_process.get_attach_map.call(null,record,attachments);
return cljs.core.reduce.call(null,((function (i__12907,attach_map,record,c__5339__auto__,size__5340__auto__,b__12908,s__12906__$2,temp__4425__auto__,image_fields,map__12903,map__12903__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.call(null,record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__12907,attach_map,record,c__5339__auto__,size__5340__auto__,b__12908,s__12906__$2,temp__4425__auto__,image_fields,map__12903,map__12903__$1,attachments))
,record,image_fields);
})());

var G__12912 = (i__12907 + (1));
i__12907 = G__12912;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12908),hatti$ona$post_process$iter__12905.call(null,cljs.core.chunk_rest.call(null,s__12906__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12908),null);
}
} else {
var record = cljs.core.first.call(null,s__12906__$2);
return cljs.core.cons.call(null,(function (){var attach_map = hatti.ona.post_process.get_attach_map.call(null,record,attachments);
return cljs.core.reduce.call(null,((function (attach_map,record,s__12906__$2,temp__4425__auto__,image_fields,map__12903,map__12903__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.call(null,record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__12906__$2,temp__4425__auto__,image_fields,map__12903,map__12903__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__12905.call(null,cljs.core.rest.call(null,s__12906__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__12903,map__12903__$1,attachments))
,null,null));
});})(image_fields,map__12903,map__12903__$1,attachments))
;
return iter__5341__auto__.call(null,data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq12899){
var G__12900 = cljs.core.first.call(null,seq12899);
var seq12899__$1 = cljs.core.next.call(null,seq12899);
var G__12901 = cljs.core.first.call(null,seq12899__$1);
var seq12899__$2 = cljs.core.next.call(null,seq12899__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__12900,G__12901,seq12899__$2);
});
/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.call(null,hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.call(null,record,key,hatti.ona.post_process.integrate_attachments.call(null,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.call(null,record,key),new cljs.core.Keyword(null,"attachments","attachments",-1535547830),cljs.core.get.call(null,record,"_attachments")));
});})(repeat_fields))
;
var iter__5341__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__12917(s__12918){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__12918__$1 = s__12918;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__12918__$1);
if(temp__4425__auto__){
var s__12918__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__12918__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__12918__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__12920 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__12919 = (0);
while(true){
if((i__12919 < size__5340__auto__)){
var record = cljs.core._nth.call(null,c__5339__auto__,i__12919);
cljs.core.chunk_append.call(null,b__12920,cljs.core.reduce.call(null,integrate,record,repeat_fields));

var G__12921 = (i__12919 + (1));
i__12919 = G__12921;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12920),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__12917.call(null,cljs.core.chunk_rest.call(null,s__12918__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12920),null);
}
} else {
var record = cljs.core.first.call(null,s__12918__$2);
return cljs.core.cons.call(null,cljs.core.reduce.call(null,integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__12917.call(null,cljs.core.rest.call(null,s__12918__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__5341__auto__.call(null,data);
});
/**
 * Inlines data from within _atatchments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___12929 = arguments.length;
var i__5628__auto___12930 = (0);
while(true){
if((i__5628__auto___12930 < len__5627__auto___12929)){
args__5634__auto__.push((arguments[i__5628__auto___12930]));

var G__12931 = (i__5628__auto___12930 + (1));
i__5628__auto___12930 = G__12931;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__12926){
var map__12927 = p__12926;
var map__12927__$1 = ((((!((map__12927 == null)))?((((map__12927.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12927.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12927):map__12927);
var app_data_keys = cljs.core.get.call(null,map__12927__$1,new cljs.core.Keyword(null,"app-data-keys","app-data-keys",-662378404),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
return hatti.utils.om.state.transact_app_state_BANG_.call(null,app_state,app_data_keys,((function (map__12927,map__12927__$1,app_data_keys){
return (function (p1__12922_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats.call(null,flat_form,hatti.ona.post_process.integrate_attachments.call(null,flat_form,p1__12922_SHARP_));
});})(map__12927,map__12927__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq12923){
var G__12924 = cljs.core.first.call(null,seq12923);
var seq12923__$1 = cljs.core.next.call(null,seq12923);
var G__12925 = cljs.core.first.call(null,seq12923__$1);
var seq12923__$2 = cljs.core.next.call(null,seq12923__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12924,G__12925,seq12923__$2);
});
