// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__26061__delegate = function (args){
if(cljs.core.map_QMARK_(cljs.core.first(args))){
var vec__26060 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,cljs.core.rest(args));
var tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26060,(0),null);
var body = cljs.core.nthnext(vec__26060,(1));
if(cljs.core.map_QMARK_(cljs.core.first(body))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.first(body),cljs.core.first(args)], 0)),cljs.core.rest(body));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.first(args),body);
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,args);
}
};
var G__26061 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__26062__i = 0, G__26062__a = new Array(arguments.length -  0);
while (G__26062__i < G__26062__a.length) {G__26062__a[G__26062__i] = arguments[G__26062__i + 0]; ++G__26062__i;}
  args = new cljs.core.IndexedSeq(G__26062__a,0);
} 
return G__26061__delegate.call(this,args);};
G__26061.cljs$lang$maxFixedArity = 0;
G__26061.cljs$lang$applyTo = (function (arglist__26063){
var args = cljs.core.seq(arglist__26063);
return G__26061__delegate(args);
});
G__26061.cljs$core$IFn$_invoke$arity$variadic = G__26061__delegate;
return G__26061;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5341__auto__ = (function sablono$core$update_arglists_$_iter__26070(s__26071){
return (new cljs.core.LazySeq(null,(function (){
var s__26071__$1 = s__26071;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__26071__$1);
if(temp__4425__auto__){
var s__26071__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__26071__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__26071__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__26073 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__26072 = (0);
while(true){
if((i__26072 < size__5340__auto__)){
var args = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__26072);
cljs.core.chunk_append(b__26073,cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)));

var G__26076 = (i__26072 + (1));
i__26072 = G__26076;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__26073),sablono$core$update_arglists_$_iter__26070(cljs.core.chunk_rest(s__26071__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__26073),null);
}
} else {
var args = cljs.core.first(s__26071__$2);
return cljs.core.cons(cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)),sablono$core$update_arglists_$_iter__26070(cljs.core.rest(s__26071__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5634__auto__ = [];
var len__5627__auto___26084 = arguments.length;
var i__5628__auto___26085 = (0);
while(true){
if((i__5628__auto___26085 < len__5627__auto___26084)){
args__5634__auto__.push((arguments[i__5628__auto___26085]));

var G__26086 = (i__5628__auto___26085 + (1));
i__5628__auto___26085 = G__26086;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5341__auto__ = (function sablono$core$iter__26078(s__26079){
return (new cljs.core.LazySeq(null,(function (){
var s__26079__$1 = s__26079;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__26079__$1);
if(temp__4425__auto__){
var s__26079__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__26079__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__26079__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__26081 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__26080 = (0);
while(true){
if((i__26080 < size__5340__auto__)){
var style = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__26080);
cljs.core.chunk_append(b__26081,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null));

var G__26087 = (i__26080 + (1));
i__26080 = G__26087;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__26081),sablono$core$iter__26078(cljs.core.chunk_rest(s__26079__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__26081),null);
}
} else {
var style = cljs.core.first(s__26079__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null),sablono$core$iter__26078(cljs.core.rest(s__26079__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq26077){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26077));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
var G__26092 = goog.dom.getDocument().body;
var G__26093 = (function (){var G__26094 = "script";
var G__26095 = {"src": src};
return goog.dom.createDom(G__26094,G__26095);
})();
return goog.dom.appendChild(G__26092,G__26093);
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js("http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to26096 = (function sablono$core$link_to26096(var_args){
var args__5634__auto__ = [];
var len__5627__auto___26099 = arguments.length;
var i__5628__auto___26100 = (0);
while(true){
if((i__5628__auto___26100 < len__5627__auto___26099)){
args__5634__auto__.push((arguments[i__5628__auto___26100]));

var G__26101 = (i__5628__auto___26100 + (1));
i__5628__auto___26100 = G__26101;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.link_to26096.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.link_to26096.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([url], 0))], null),content], null);
});

sablono.core.link_to26096.cljs$lang$maxFixedArity = (1);

sablono.core.link_to26096.cljs$lang$applyTo = (function (seq26097){
var G__26098 = cljs.core.first(seq26097);
var seq26097__$1 = cljs.core.next(seq26097);
return sablono.core.link_to26096.cljs$core$IFn$_invoke$arity$variadic(G__26098,seq26097__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs(sablono.core.link_to26096);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to26102 = (function sablono$core$mail_to26102(var_args){
var args__5634__auto__ = [];
var len__5627__auto___26107 = arguments.length;
var i__5628__auto___26108 = (0);
while(true){
if((i__5628__auto___26108 < len__5627__auto___26107)){
args__5634__auto__.push((arguments[i__5628__auto___26108]));

var G__26109 = (i__5628__auto___26108 + (1));
i__5628__auto___26108 = G__26109;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.mail_to26102.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.mail_to26102.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__26105){
var vec__26106 = p__26105;
var content = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26106,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4569__auto__ = content;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to26102.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to26102.cljs$lang$applyTo = (function (seq26103){
var G__26104 = cljs.core.first(seq26103);
var seq26103__$1 = cljs.core.next(seq26103);
return sablono.core.mail_to26102.cljs$core$IFn$_invoke$arity$variadic(G__26104,seq26103__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs(sablono.core.mail_to26102);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list26110 = (function sablono$core$unordered_list26110(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,(function (){var iter__5341__auto__ = (function sablono$core$unordered_list26110_$_iter__26117(s__26118){
return (new cljs.core.LazySeq(null,(function (){
var s__26118__$1 = s__26118;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__26118__$1);
if(temp__4425__auto__){
var s__26118__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__26118__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__26118__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__26120 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__26119 = (0);
while(true){
if((i__26119 < size__5340__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__26119);
cljs.core.chunk_append(b__26120,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__26123 = (i__26119 + (1));
i__26119 = G__26123;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__26120),sablono$core$unordered_list26110_$_iter__26117(cljs.core.chunk_rest(s__26118__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__26120),null);
}
} else {
var x = cljs.core.first(s__26118__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$unordered_list26110_$_iter__26117(cljs.core.rest(s__26118__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs(sablono.core.unordered_list26110);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list26124 = (function sablono$core$ordered_list26124(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ol,(function (){var iter__5341__auto__ = (function sablono$core$ordered_list26124_$_iter__26131(s__26132){
return (new cljs.core.LazySeq(null,(function (){
var s__26132__$1 = s__26132;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__26132__$1);
if(temp__4425__auto__){
var s__26132__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__26132__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__26132__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__26134 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__26133 = (0);
while(true){
if((i__26133 < size__5340__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__26133);
cljs.core.chunk_append(b__26134,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__26137 = (i__26133 + (1));
i__26133 = G__26137;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__26134),sablono$core$ordered_list26124_$_iter__26131(cljs.core.chunk_rest(s__26132__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__26134),null);
}
} else {
var x = cljs.core.first(s__26132__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$ordered_list26124_$_iter__26131(cljs.core.rest(s__26132__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs(sablono.core.ordered_list26124);
/**
 * Create an image element.
 */
sablono.core.image26138 = (function sablono$core$image26138(var_args){
var args26139 = [];
var len__5627__auto___26142 = arguments.length;
var i__5628__auto___26143 = (0);
while(true){
if((i__5628__auto___26143 < len__5627__auto___26142)){
args26139.push((arguments[i__5628__auto___26143]));

var G__26144 = (i__5628__auto___26143 + (1));
i__5628__auto___26143 = G__26144;
continue;
} else {
}
break;
}

var G__26141 = args26139.length;
switch (G__26141) {
case 1:
return sablono.core.image26138.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image26138.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26139.length)].join('')));

}
});

sablono.core.image26138.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0))], null)], null);
});

sablono.core.image26138.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0)),cljs.core.cst$kw$alt,alt], null)], null);
});

sablono.core.image26138.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs(sablono.core.image26138);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__26146_SHARP_,p2__26147_SHARP_){
return [cljs.core.str(p1__26146_SHARP_),cljs.core.str("["),cljs.core.str(p2__26147_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__26148_SHARP_,p2__26149_SHARP_){
return [cljs.core.str(p1__26148_SHARP_),cljs.core.str("-"),cljs.core.str(p2__26149_SHARP_)].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,type,cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field26150 = (function sablono$core$color_field26150(var_args){
var args26151 = [];
var len__5627__auto___26218 = arguments.length;
var i__5628__auto___26219 = (0);
while(true){
if((i__5628__auto___26219 < len__5627__auto___26218)){
args26151.push((arguments[i__5628__auto___26219]));

var G__26220 = (i__5628__auto___26219 + (1));
i__5628__auto___26219 = G__26220;
continue;
} else {
}
break;
}

var G__26153 = args26151.length;
switch (G__26153) {
case 1:
return sablono.core.color_field26150.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field26150.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26151.length)].join('')));

}
});

sablono.core.color_field26150.cljs$core$IFn$_invoke$arity$1 = (function (name__14445__auto__){
return sablono.core.color_field26150.cljs$core$IFn$_invoke$arity$2(name__14445__auto__,null);
});

sablono.core.color_field26150.cljs$core$IFn$_invoke$arity$2 = (function (name__14445__auto__,value__14446__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$color)].join(''),name__14445__auto__,value__14446__auto__);
});

sablono.core.color_field26150.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs(sablono.core.color_field26150);

/**
 * Creates a date input field.
 */
sablono.core.date_field26154 = (function sablono$core$date_field26154(var_args){
var args26155 = [];
var len__5627__auto___26222 = arguments.length;
var i__5628__auto___26223 = (0);
while(true){
if((i__5628__auto___26223 < len__5627__auto___26222)){
args26155.push((arguments[i__5628__auto___26223]));

var G__26224 = (i__5628__auto___26223 + (1));
i__5628__auto___26223 = G__26224;
continue;
} else {
}
break;
}

var G__26157 = args26155.length;
switch (G__26157) {
case 1:
return sablono.core.date_field26154.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field26154.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26155.length)].join('')));

}
});

sablono.core.date_field26154.cljs$core$IFn$_invoke$arity$1 = (function (name__14445__auto__){
return sablono.core.date_field26154.cljs$core$IFn$_invoke$arity$2(name__14445__auto__,null);
});

sablono.core.date_field26154.cljs$core$IFn$_invoke$arity$2 = (function (name__14445__auto__,value__14446__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$date)].join(''),name__14445__auto__,value__14446__auto__);
});

sablono.core.date_field26154.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs(sablono.core.date_field26154);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field26158 = (function sablono$core$datetime_field26158(var_args){
var args26159 = [];
var len__5627__auto___26226 = arguments.length;
var i__5628__auto___26227 = (0);
while(true){
if((i__5628__auto___26227 < len__5627__auto___26226)){
args26159.push((arguments[i__5628__auto___26227]));

var G__26228 = (i__5628__auto___26227 + (1));
i__5628__auto___26227 = G__26228;
continue;
} else {
}
break;
}

var G__26161 = args26159.length;
switch (G__26161) {
case 1:
return sablono.core.datetime_field26158.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field26158.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26159.length)].join('')));

}
});

sablono.core.datetime_field26158.cljs$core$IFn$_invoke$arity$1 = (function (name__14445__auto__){
return sablono.core.datetime_field26158.cljs$core$IFn$_invoke$arity$2(name__14445__auto__,null);
});

sablono.core.datetime_field26158.cljs$core$IFn$_invoke$arity$2 = (function (name__14445__auto__,value__14446__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime)].join(''),name__14445__auto__,value__14446__auto__);
});

sablono.core.datetime_field26158.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs(sablono.core.datetime_field26158);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field26162 = (function sablono$core$datetime_local_field26162(var_args){
var args26163 = [];
var len__5627__auto___26230 = arguments.length;
var i__5628__auto___26231 = (0);
while(true){
if((i__5628__auto___26231 < len__5627__auto___26230)){
args26163.push((arguments[i__5628__auto___26231]));

var G__26232 = (i__5628__auto___26231 + (1));
i__5628__auto___26231 = G__26232;
continue;
} else {
}
break;
}

var G__26165 = args26163.length;
switch (G__26165) {
case 1:
return sablono.core.datetime_local_field26162.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field26162.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26163.length)].join('')));

}
});

sablono.core.datetime_local_field26162.cljs$core$IFn$_invoke$arity$1 = (function (name__14445__auto__){
return sablono.core.datetime_local_field26162.cljs$core$IFn$_invoke$arity$2(name__14445__auto__,null);
});

sablono.core.datetime_local_field26162.cljs$core$IFn$_invoke$arity$2 = (function (name__14445__auto__,value__14446__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime_DASH_local)].join(''),name__14445__auto__,value__14446__auto__);
});

sablono.core.datetime_local_field26162.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs(sablono.core.datetime_local_field26162);

/**
 * Creates a email input field.
 */
sablono.core.email_field26166 = (function sablono$core$email_field26166(var_args){
var args26167 = [];
var len__5627__auto___26234 = arguments.length;
var i__5628__auto___26235 = (0);
while(true){
if((i__5628__auto___26235 < len__5627__auto___26234)){
args26167.push((arguments[i__5628__auto___26235]));

var G__26236 = (i__5628__auto___26235 + (1));
i__5628__auto___26235 = G__26236;
continue;
} else {
}
break;
}

var G__26169 = args26167.length;
switch (G__26169) {
case 1:
return sablono.core.email_field26166.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field26166.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26167.length)].join('')));

}
});

sablono.core.email_field26166.cljs$core$IFn$_invoke$arity$1 = (function (name__14445__auto__){
return sablono.core.email_field26166.cljs$core$IFn$_invoke$arity$2(name__14445__auto__,null);
});

sablono.core.email_field26166.cljs$core$IFn$_invoke$arity$2 = (function (name__14445__auto__,value__14446__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$email)].join(''),name__14445__auto__,value__14446__auto__);
});

sablono.core.email_field26166.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs(sablono.core.email_field26166);

/**
 * Creates a file input field.
 */
sablono.core.file_field26170 = (function sablono$core$file_field26170(var_args){
var args26171 = [];
var len__5627__auto___26238 = arguments.length;
var i__5628__auto___26239 = (0);
while(true){
if((i__5628__auto___26239 < len__5627__auto___26238)){
args26171.push((arguments[i__5628__auto___26239]));

var G__26240 = (i__5628__auto___26239 + (1));
i__5628__auto___26239 = G__26240;
continue;
} else {
}
break;
}

var G__26173 = args26171.length;
switch (G__26173) {
case 1:
return sablono.core.file_field26170.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field26170.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26171.length)].join('')));

}
});

sablono.core.file_field26170.cljs$core$IFn$_invoke$arity$1 = (function (name__14445__auto__){
return sablono.core.file_field26170.cljs$core$IFn$_invoke$arity$2(name__14445__auto__,null);
});

sablono.core.file_field26170.cljs$core$IFn$_invoke$arity$2 = (function (name__14445__auto__,value__14446__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$file)].join(''),name__14445__auto__,value__14446__auto__);
});

sablono.core.file_field26170.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs(sablono.core.file_field26170);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field26174 = (function sablono$core$hidden_field26174(var_args){
var args26175 = [];
var len__5627__auto___26242 = arguments.length;
var i__5628__auto___26243 = (0);
while(true){
if((i__5628__auto___26243 < len__5627__auto___26242)){
args26175.push((arguments[i__5628__auto___26243]));

var G__26244 = (i__5628__auto___26243 + (1));
i__5628__auto___26243 = G__26244;
continue;
} else {
}
break;
}

var G__26177 = args26175.length;
switch (G__26177) {
case 1:
return sablono.core.hidden_field26174.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field26174.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26175.length)].join('')));

}
});

sablono.core.hidden_field26174.cljs$core$IFn$_invoke$arity$1 = (function (name__14445__auto__){
return sablono.core.hidden_field26174.cljs$core$IFn$_invoke$arity$2(name__14445__auto__,null);
});

sablono.core.hidden_field26174.cljs$core$IFn$_invoke$arity$2 = (function (name__14445__auto__,value__14446__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$hidden)].join(''),name__14445__auto__,value__14446__auto__);
});

sablono.core.hidden_field26174.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs(sablono.core.hidden_field26174);

/**
 * Creates a month input field.
 */
sablono.core.month_field26178 = (function sablono$core$month_field26178(var_args){
var args26179 = [];
var len__5627__auto___26246 = arguments.length;
var i__5628__auto___26247 = (0);
while(true){
if((i__5628__auto___26247 < len__5627__auto___26246)){
args26179.push((arguments[i__5628__auto___26247]));

var G__26248 = (i__5628__auto___26247 + (1));
i__5628__auto___26247 = G__26248;
continue;
} else {
}
break;
}

var G__26181 = args26179.length;
switch (G__26181) {
case 1:
return sablono.core.month_field26178.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field26178.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26179.length)].join('')));

}
});

sablono.core.month_field26178.cljs$core$IFn$_invoke$arity$1 = (function (name__14445__auto__){
return sablono.core.month_field26178.cljs$core$IFn$_invoke$arity$2(name__14445__auto__,null);
});

sablono.core.month_field26178.cljs$core$IFn$_invoke$arity$2 = (function (name__14445__auto__,value__14446__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$month)].join(''),name__14445__auto__,value__14446__auto__);
});

sablono.core.month_field26178.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs(sablono.core.month_field26178);

/**
 * Creates a number input field.
 */
sablono.core.number_field26182 = (function sablono$core$number_field26182(var_args){
var args26183 = [];
var len__5627__auto___26250 = arguments.length;
var i__5628__auto___26251 = (0);
while(true){
if((i__5628__auto___26251 < len__5627__auto___26250)){
args26183.push((arguments[i__5628__auto___26251]));

var G__26252 = (i__5628__auto___26251 + (1));
i__5628__auto___26251 = G__26252;
continue;
} else {
}
break;
}

var G__26185 = args26183.length;
switch (G__26185) {
case 1:
return sablono.core.number_field26182.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field26182.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26183.length)].join('')));

}
});

sablono.core.number_field26182.cljs$core$IFn$_invoke$arity$1 = (function (name__14445__auto__){
return sablono.core.number_field26182.cljs$core$IFn$_invoke$arity$2(name__14445__auto__,null);
});

sablono.core.number_field26182.cljs$core$IFn$_invoke$arity$2 = (function (name__14445__auto__,value__14446__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$number)].join(''),name__14445__auto__,value__14446__auto__);
});

sablono.core.number_field26182.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs(sablono.core.number_field26182);

/**
 * Creates a password input field.
 */
sablono.core.password_field26186 = (function sablono$core$password_field26186(var_args){
var args26187 = [];
var len__5627__auto___26254 = arguments.length;
var i__5628__auto___26255 = (0);
while(true){
if((i__5628__auto___26255 < len__5627__auto___26254)){
args26187.push((arguments[i__5628__auto___26255]));

var G__26256 = (i__5628__auto___26255 + (1));
i__5628__auto___26255 = G__26256;
continue;
} else {
}
break;
}

var G__26189 = args26187.length;
switch (G__26189) {
case 1:
return sablono.core.password_field26186.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field26186.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26187.length)].join('')));

}
});

sablono.core.password_field26186.cljs$core$IFn$_invoke$arity$1 = (function (name__14445__auto__){
return sablono.core.password_field26186.cljs$core$IFn$_invoke$arity$2(name__14445__auto__,null);
});

sablono.core.password_field26186.cljs$core$IFn$_invoke$arity$2 = (function (name__14445__auto__,value__14446__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$password)].join(''),name__14445__auto__,value__14446__auto__);
});

sablono.core.password_field26186.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs(sablono.core.password_field26186);

/**
 * Creates a range input field.
 */
sablono.core.range_field26190 = (function sablono$core$range_field26190(var_args){
var args26191 = [];
var len__5627__auto___26258 = arguments.length;
var i__5628__auto___26259 = (0);
while(true){
if((i__5628__auto___26259 < len__5627__auto___26258)){
args26191.push((arguments[i__5628__auto___26259]));

var G__26260 = (i__5628__auto___26259 + (1));
i__5628__auto___26259 = G__26260;
continue;
} else {
}
break;
}

var G__26193 = args26191.length;
switch (G__26193) {
case 1:
return sablono.core.range_field26190.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field26190.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26191.length)].join('')));

}
});

sablono.core.range_field26190.cljs$core$IFn$_invoke$arity$1 = (function (name__14445__auto__){
return sablono.core.range_field26190.cljs$core$IFn$_invoke$arity$2(name__14445__auto__,null);
});

sablono.core.range_field26190.cljs$core$IFn$_invoke$arity$2 = (function (name__14445__auto__,value__14446__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$range)].join(''),name__14445__auto__,value__14446__auto__);
});

sablono.core.range_field26190.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs(sablono.core.range_field26190);

/**
 * Creates a search input field.
 */
sablono.core.search_field26194 = (function sablono$core$search_field26194(var_args){
var args26195 = [];
var len__5627__auto___26262 = arguments.length;
var i__5628__auto___26263 = (0);
while(true){
if((i__5628__auto___26263 < len__5627__auto___26262)){
args26195.push((arguments[i__5628__auto___26263]));

var G__26264 = (i__5628__auto___26263 + (1));
i__5628__auto___26263 = G__26264;
continue;
} else {
}
break;
}

var G__26197 = args26195.length;
switch (G__26197) {
case 1:
return sablono.core.search_field26194.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field26194.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26195.length)].join('')));

}
});

sablono.core.search_field26194.cljs$core$IFn$_invoke$arity$1 = (function (name__14445__auto__){
return sablono.core.search_field26194.cljs$core$IFn$_invoke$arity$2(name__14445__auto__,null);
});

sablono.core.search_field26194.cljs$core$IFn$_invoke$arity$2 = (function (name__14445__auto__,value__14446__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$search)].join(''),name__14445__auto__,value__14446__auto__);
});

sablono.core.search_field26194.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs(sablono.core.search_field26194);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field26198 = (function sablono$core$tel_field26198(var_args){
var args26199 = [];
var len__5627__auto___26266 = arguments.length;
var i__5628__auto___26267 = (0);
while(true){
if((i__5628__auto___26267 < len__5627__auto___26266)){
args26199.push((arguments[i__5628__auto___26267]));

var G__26268 = (i__5628__auto___26267 + (1));
i__5628__auto___26267 = G__26268;
continue;
} else {
}
break;
}

var G__26201 = args26199.length;
switch (G__26201) {
case 1:
return sablono.core.tel_field26198.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field26198.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26199.length)].join('')));

}
});

sablono.core.tel_field26198.cljs$core$IFn$_invoke$arity$1 = (function (name__14445__auto__){
return sablono.core.tel_field26198.cljs$core$IFn$_invoke$arity$2(name__14445__auto__,null);
});

sablono.core.tel_field26198.cljs$core$IFn$_invoke$arity$2 = (function (name__14445__auto__,value__14446__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$tel)].join(''),name__14445__auto__,value__14446__auto__);
});

sablono.core.tel_field26198.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs(sablono.core.tel_field26198);

/**
 * Creates a text input field.
 */
sablono.core.text_field26202 = (function sablono$core$text_field26202(var_args){
var args26203 = [];
var len__5627__auto___26270 = arguments.length;
var i__5628__auto___26271 = (0);
while(true){
if((i__5628__auto___26271 < len__5627__auto___26270)){
args26203.push((arguments[i__5628__auto___26271]));

var G__26272 = (i__5628__auto___26271 + (1));
i__5628__auto___26271 = G__26272;
continue;
} else {
}
break;
}

var G__26205 = args26203.length;
switch (G__26205) {
case 1:
return sablono.core.text_field26202.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field26202.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26203.length)].join('')));

}
});

sablono.core.text_field26202.cljs$core$IFn$_invoke$arity$1 = (function (name__14445__auto__){
return sablono.core.text_field26202.cljs$core$IFn$_invoke$arity$2(name__14445__auto__,null);
});

sablono.core.text_field26202.cljs$core$IFn$_invoke$arity$2 = (function (name__14445__auto__,value__14446__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$text)].join(''),name__14445__auto__,value__14446__auto__);
});

sablono.core.text_field26202.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs(sablono.core.text_field26202);

/**
 * Creates a time input field.
 */
sablono.core.time_field26206 = (function sablono$core$time_field26206(var_args){
var args26207 = [];
var len__5627__auto___26274 = arguments.length;
var i__5628__auto___26275 = (0);
while(true){
if((i__5628__auto___26275 < len__5627__auto___26274)){
args26207.push((arguments[i__5628__auto___26275]));

var G__26276 = (i__5628__auto___26275 + (1));
i__5628__auto___26275 = G__26276;
continue;
} else {
}
break;
}

var G__26209 = args26207.length;
switch (G__26209) {
case 1:
return sablono.core.time_field26206.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field26206.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26207.length)].join('')));

}
});

sablono.core.time_field26206.cljs$core$IFn$_invoke$arity$1 = (function (name__14445__auto__){
return sablono.core.time_field26206.cljs$core$IFn$_invoke$arity$2(name__14445__auto__,null);
});

sablono.core.time_field26206.cljs$core$IFn$_invoke$arity$2 = (function (name__14445__auto__,value__14446__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$time)].join(''),name__14445__auto__,value__14446__auto__);
});

sablono.core.time_field26206.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs(sablono.core.time_field26206);

/**
 * Creates a url input field.
 */
sablono.core.url_field26210 = (function sablono$core$url_field26210(var_args){
var args26211 = [];
var len__5627__auto___26278 = arguments.length;
var i__5628__auto___26279 = (0);
while(true){
if((i__5628__auto___26279 < len__5627__auto___26278)){
args26211.push((arguments[i__5628__auto___26279]));

var G__26280 = (i__5628__auto___26279 + (1));
i__5628__auto___26279 = G__26280;
continue;
} else {
}
break;
}

var G__26213 = args26211.length;
switch (G__26213) {
case 1:
return sablono.core.url_field26210.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field26210.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26211.length)].join('')));

}
});

sablono.core.url_field26210.cljs$core$IFn$_invoke$arity$1 = (function (name__14445__auto__){
return sablono.core.url_field26210.cljs$core$IFn$_invoke$arity$2(name__14445__auto__,null);
});

sablono.core.url_field26210.cljs$core$IFn$_invoke$arity$2 = (function (name__14445__auto__,value__14446__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$url)].join(''),name__14445__auto__,value__14446__auto__);
});

sablono.core.url_field26210.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs(sablono.core.url_field26210);

/**
 * Creates a week input field.
 */
sablono.core.week_field26214 = (function sablono$core$week_field26214(var_args){
var args26215 = [];
var len__5627__auto___26282 = arguments.length;
var i__5628__auto___26283 = (0);
while(true){
if((i__5628__auto___26283 < len__5627__auto___26282)){
args26215.push((arguments[i__5628__auto___26283]));

var G__26284 = (i__5628__auto___26283 + (1));
i__5628__auto___26283 = G__26284;
continue;
} else {
}
break;
}

var G__26217 = args26215.length;
switch (G__26217) {
case 1:
return sablono.core.week_field26214.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field26214.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26215.length)].join('')));

}
});

sablono.core.week_field26214.cljs$core$IFn$_invoke$arity$1 = (function (name__14445__auto__){
return sablono.core.week_field26214.cljs$core$IFn$_invoke$arity$2(name__14445__auto__,null);
});

sablono.core.week_field26214.cljs$core$IFn$_invoke$arity$2 = (function (name__14445__auto__,value__14446__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$week)].join(''),name__14445__auto__,value__14446__auto__);
});

sablono.core.week_field26214.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs(sablono.core.week_field26214);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box26286 = (function sablono$core$check_box26286(var_args){
var args26287 = [];
var len__5627__auto___26290 = arguments.length;
var i__5628__auto___26291 = (0);
while(true){
if((i__5628__auto___26291 < len__5627__auto___26290)){
args26287.push((arguments[i__5628__auto___26291]));

var G__26292 = (i__5628__auto___26291 + (1));
i__5628__auto___26291 = G__26292;
continue;
} else {
}
break;
}

var G__26289 = args26287.length;
switch (G__26289) {
case 1:
return sablono.core.check_box26286.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box26286.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box26286.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26287.length)].join('')));

}
});

sablono.core.check_box26286.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box26286.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.check_box26286.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box26286.cljs$core$IFn$_invoke$arity$3(name,checked_QMARK_,"true");
});

sablono.core.check_box26286.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"checkbox",cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.check_box26286.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs(sablono.core.check_box26286);
/**
 * Creates a radio button.
 */
sablono.core.radio_button26294 = (function sablono$core$radio_button26294(var_args){
var args26295 = [];
var len__5627__auto___26298 = arguments.length;
var i__5628__auto___26299 = (0);
while(true){
if((i__5628__auto___26299 < len__5627__auto___26298)){
args26295.push((arguments[i__5628__auto___26299]));

var G__26300 = (i__5628__auto___26299 + (1));
i__5628__auto___26299 = G__26300;
continue;
} else {
}
break;
}

var G__26297 = args26295.length;
switch (G__26297) {
case 1:
return sablono.core.radio_button26294.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button26294.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button26294.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26295.length)].join('')));

}
});

sablono.core.radio_button26294.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button26294.cljs$core$IFn$_invoke$arity$2(group,null);
});

sablono.core.radio_button26294.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button26294.cljs$core$IFn$_invoke$arity$3(group,checked_QMARK_,"true");
});

sablono.core.radio_button26294.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"radio",cljs.core.cst$kw$name,sablono.core.make_name(group),cljs.core.cst$kw$id,sablono.core.make_id([cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([group], 0))),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([value], 0)))].join('')),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.radio_button26294.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs(sablono.core.radio_button26294);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options26302 = (function sablono$core$select_options26302(var_args){
var args26303 = [];
var len__5627__auto___26316 = arguments.length;
var i__5628__auto___26317 = (0);
while(true){
if((i__5628__auto___26317 < len__5627__auto___26316)){
args26303.push((arguments[i__5628__auto___26317]));

var G__26318 = (i__5628__auto___26317 + (1));
i__5628__auto___26317 = G__26318;
continue;
} else {
}
break;
}

var G__26305 = args26303.length;
switch (G__26305) {
case 1:
return sablono.core.select_options26302.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options26302.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26303.length)].join('')));

}
});

sablono.core.select_options26302.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options26302.cljs$core$IFn$_invoke$arity$2(coll,null);
});

sablono.core.select_options26302.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__5341__auto__ = (function sablono$core$iter__26306(s__26307){
return (new cljs.core.LazySeq(null,(function (){
var s__26307__$1 = s__26307;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__26307__$1);
if(temp__4425__auto__){
var s__26307__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__26307__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__26307__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__26309 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__26308 = (0);
while(true){
if((i__26308 < size__5340__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__26308);
cljs.core.chunk_append(b__26309,((cljs.core.sequential_QMARK_(x))?(function (){var vec__26314 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26314,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26314,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26314,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options26302.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)));

var G__26320 = (i__26308 + (1));
i__26308 = G__26320;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__26309),sablono$core$iter__26306(cljs.core.chunk_rest(s__26307__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__26309),null);
}
} else {
var x = cljs.core.first(s__26307__$2);
return cljs.core.cons(((cljs.core.sequential_QMARK_(x))?(function (){var vec__26315 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26315,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26315,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26315,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options26302.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)),sablono$core$iter__26306(cljs.core.rest(s__26307__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(coll);
});

sablono.core.select_options26302.cljs$lang$maxFixedArity = 2;

sablono.core.select_options = sablono.core.wrap_attrs(sablono.core.select_options26302);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down26321 = (function sablono$core$drop_down26321(var_args){
var args26322 = [];
var len__5627__auto___26325 = arguments.length;
var i__5628__auto___26326 = (0);
while(true){
if((i__5628__auto___26326 < len__5627__auto___26325)){
args26322.push((arguments[i__5628__auto___26326]));

var G__26327 = (i__5628__auto___26326 + (1));
i__5628__auto___26326 = G__26327;
continue;
} else {
}
break;
}

var G__26324 = args26322.length;
switch (G__26324) {
case 2:
return sablono.core.drop_down26321.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down26321.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26322.length)].join('')));

}
});

sablono.core.drop_down26321.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down26321.cljs$core$IFn$_invoke$arity$3(name,options,null);
});

sablono.core.drop_down26321.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name)], null),(sablono.core.select_options.cljs$core$IFn$_invoke$arity$2 ? sablono.core.select_options.cljs$core$IFn$_invoke$arity$2(options,selected) : sablono.core.select_options.call(null,options,selected))], null);
});

sablono.core.drop_down26321.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs(sablono.core.drop_down26321);
/**
 * Creates a text area element.
 */
sablono.core.text_area26329 = (function sablono$core$text_area26329(var_args){
var args26330 = [];
var len__5627__auto___26333 = arguments.length;
var i__5628__auto___26334 = (0);
while(true){
if((i__5628__auto___26334 < len__5627__auto___26333)){
args26330.push((arguments[i__5628__auto___26334]));

var G__26335 = (i__5628__auto___26334 + (1));
i__5628__auto___26334 = G__26335;
continue;
} else {
}
break;
}

var G__26332 = args26330.length;
switch (G__26332) {
case 1:
return sablono.core.text_area26329.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area26329.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26330.length)].join('')));

}
});

sablono.core.text_area26329.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area26329.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.text_area26329.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$textarea,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});

sablono.core.text_area26329.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs(sablono.core.text_area26329);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label26337 = (function sablono$core$label26337(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$htmlFor,sablono.core.make_id(name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs(sablono.core.label26337);
/**
 * Creates a submit button.
 */
sablono.core.submit_button26338 = (function sablono$core$submit_button26338(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"submit",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs(sablono.core.submit_button26338);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button26339 = (function sablono$core$reset_button26339(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"reset",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs(sablono.core.reset_button26339);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to26340 = (function sablono$core$form_to26340(var_args){
var args__5634__auto__ = [];
var len__5627__auto___26345 = arguments.length;
var i__5628__auto___26346 = (0);
while(true){
if((i__5628__auto___26346 < len__5627__auto___26345)){
args__5634__auto__.push((arguments[i__5628__auto___26346]));

var G__26347 = (i__5628__auto___26346 + (1));
i__5628__auto___26346 = G__26347;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.form_to26340.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.form_to26340.cljs$core$IFn$_invoke$arity$variadic = (function (p__26343,body){
var vec__26344 = p__26343;
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26344,(0),null);
var action = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26344,(1),null);
var method_str = clojure.string.upper_case(cljs.core.name(method));
var action_uri = sablono.util.to_uri(action);
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$get,null,cljs.core.cst$kw$post,null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,method_str,cljs.core.cst$kw$action,action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,"POST",cljs.core.cst$kw$action,action_uri], null),(sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2 ? sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2("_method",method_str) : sablono.core.hidden_field.call(null,"_method",method_str))], null)),body));
});

sablono.core.form_to26340.cljs$lang$maxFixedArity = (1);

sablono.core.form_to26340.cljs$lang$applyTo = (function (seq26341){
var G__26342 = cljs.core.first(seq26341);
var seq26341__$1 = cljs.core.next(seq26341);
return sablono.core.form_to26340.cljs$core$IFn$_invoke$arity$variadic(G__26342,seq26341__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs(sablono.core.form_to26340);
