// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var extra_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,hatti.constants._id,cljs.core.cst$kw$label,"id",cljs.core.cst$kw$name,hatti.constants._id,cljs.core.cst$kw$type,"integer"], null)], null);
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
return extra_field;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(extra_field,hatti.ona.forms.submission_time_field);
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__5634__auto__ = [];
var len__5627__auto___16928 = arguments.length;
var i__5628__auto___16929 = (0);
while(true){
if((i__5628__auto___16929 < len__5627__auto___16928)){
args__5634__auto__.push((arguments[i__5628__auto___16929]));

var G__16930 = (i__5628__auto___16929 + (1));
i__5628__auto___16929 = G__16930;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__16925){
var map__16926 = p__16925;
var map__16926__$1 = ((((!((map__16926 == null)))?((((map__16926.cljs$lang$protocol_mask$partition0$ & (64))) || (map__16926.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16926):map__16926);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16926__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(hatti.views.table.get_extra_fields(is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,cljs.core.not(is_filtered_dataview_QMARK_)], 0))], 0))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq16923){
var G__16924 = cljs.core.first(seq16923);
var seq16923__$1 = cljs.core.next(seq16923);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__16924,seq16923__$1);
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__16931_SHARP_){
if(typeof p1__16931_SHARP_ === 'string'){
return clojure.string.lower_case(p1__16931_SHARP_);
} else {
return p1__16931_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__16935){
var vec__16936 = p__16935;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16936,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16936,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,null,true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__16932_SHARP_){
return cljs.core.re_find(hatti.utils.safe_regex(query),[cljs.core.str(p1__16932_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(field,clj_value,language,true);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args16937 = [];
var len__5627__auto___16961 = arguments.length;
var i__5628__auto___16962 = (0);
while(true){
if((i__5628__auto___16962 < len__5627__auto___16961)){
args16937.push((arguments[i__5628__auto___16962]));

var G__16963 = (i__5628__auto___16962 + (1));
i__5628__auto___16962 = G__16963;
continue;
} else {
}
break;
}

var G__16943 = args16937.length;
switch (G__16943) {
case 1:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args16937.slice((3)),(0)));
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1 = (function (form){
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2(form,true);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2 = (function (form,get_label_QMARK_){
return hatti.views.table.flat_form__GT_sg_columns(form,get_label_QMARK_,null);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,get_label_QMARK_,language,p__16944){
var map__16945 = p__16944;
var map__16945__$1 = ((((!((map__16945 == null)))?((((map__16945.cljs$lang$protocol_mask$partition0$ & (64))) || (map__16945.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16945):map__16945);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16945__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
return cljs.core.clj__GT_js((function (){var iter__5341__auto__ = ((function (map__16945,map__16945__$1,is_filtered_dataview_QMARK_){
return (function hatti$views$table$iter__16947(s__16948){
return (new cljs.core.LazySeq(null,((function (map__16945,map__16945__$1,is_filtered_dataview_QMARK_){
return (function (){
var s__16948__$1 = s__16948;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__16948__$1);
if(temp__4425__auto__){
var s__16948__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__16948__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__16948__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__16950 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__16949 = (0);
while(true){
if((i__16949 < size__5340__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__16949);
cljs.core.chunk_append(b__16950,(function (){var map__16957 = field;
var map__16957__$1 = ((((!((map__16957 == null)))?((((map__16957.cljs$lang$protocol_mask$partition0$ & (64))) || (map__16957.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16957):map__16957);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16957__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16957__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16957__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hatti.ona.forms.get_column_class(field),label,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class(field),label]);
})());

var G__16965 = (i__16949 + (1));
i__16949 = G__16965;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__16950),hatti$views$table$iter__16947(cljs.core.chunk_rest(s__16948__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__16950),null);
}
} else {
var field = cljs.core.first(s__16948__$2);
return cljs.core.cons((function (){var map__16959 = field;
var map__16959__$1 = ((((!((map__16959 == null)))?((((map__16959.cljs$lang$protocol_mask$partition0$ & (64))) || (map__16959.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16959):map__16959);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16959__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16959__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16959__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hatti.ona.forms.get_column_class(field),label,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class(field),label]);
})(),hatti$views$table$iter__16947(cljs.core.rest(s__16948__$2)));
}
} else {
return null;
}
break;
}
});})(map__16945,map__16945__$1,is_filtered_dataview_QMARK_))
,null,null));
});})(map__16945,map__16945__$1,is_filtered_dataview_QMARK_))
;
return iter__5341__auto__(hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0)));
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq16938){
var G__16939 = cljs.core.first(seq16938);
var seq16938__$1 = cljs.core.next(seq16938);
var G__16940 = cljs.core.first(seq16938__$1);
var seq16938__$2 = cljs.core.next(seq16938__$1);
var G__16941 = cljs.core.first(seq16938__$2);
var seq16938__$3 = cljs.core.next(seq16938__$2);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__16939,G__16940,G__16941,seq16938__$3);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (3);
hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__16967 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__16967);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = {"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": true};
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__16978(s__16979){
return (new cljs.core.LazySeq(null,(function (){
var s__16979__$1 = s__16979;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__16979__$1);
if(temp__4425__auto__){
var s__16979__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__16979__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__16979__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__16981 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__16980 = (0);
while(true){
if((i__16980 < size__5340__auto__)){
var vec__16986 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__16980);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16986,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16986,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__16981,event.subscribe(handler_function));

var G__16988 = (i__16980 + (1));
i__16980 = G__16988;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__16981),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__16978(cljs.core.chunk_rest(s__16979__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__16981),null);
}
} else {
var vec__16987 = cljs.core.first(s__16979__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16987,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16987,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__16978(cljs.core.rest(s__16979__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__16999(s__17000){
return (new cljs.core.LazySeq(null,(function (){
var s__17000__$1 = s__17000;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__17000__$1);
if(temp__4425__auto__){
var s__17000__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__17000__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__17000__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__17002 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__17001 = (0);
while(true){
if((i__17001 < size__5340__auto__)){
var vec__17007 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__17001);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17007,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17007,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__17002,event.subscribe(handler_function));

var G__17009 = (i__17001 + (1));
i__17001 = G__17009;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__17002),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__16999(cljs.core.chunk_rest(s__17000__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__17002),null);
}
} else {
var vec__17008 = cljs.core.first(s__17000__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17008,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17008,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__16999(cljs.core.rest(s__17000__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,p__17010){
var map__17019 = p__17010;
var map__17019__$1 = ((((!((map__17019 == null)))?((((map__17019.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17019.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17019):map__17019);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17019__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17019__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,true,current_language,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
var map__17021 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__17021__$1 = ((((!((map__17021 == null)))?((((map__17021.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17021.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17021):map__17021);
var map__17022 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17021__$1,cljs.core.cst$kw$table_DASH_page);
var map__17022__$1 = ((((!((map__17022 == null)))?((((map__17022.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17022.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17022):map__17022);
var map__17023 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17022__$1,cljs.core.cst$kw$paging);
var map__17023__$1 = ((((!((map__17023 == null)))?((((map__17023.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17023.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17023):map__17023);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17023__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17023__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__17021,map__17021__$1,map__17022,map__17022__$1,map__17023,map__17023__$1,num_displayed_records,total_page_count,map__17019,map__17019__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__17021,map__17021__$1,map__17022,map__17022__$1,map__17023,map__17023__$1,num_displayed_records,total_page_count,map__17019,map__17019__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__17021,map__17021__$1,map__17022,map__17022__$1,map__17023,map__17023__$1,num_displayed_records,total_page_count,map__17019,map__17019__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__17021,map__17021__$1,map__17022,map__17022__$1,map__17023,map__17023__$1,num_displayed_records,total_page_count,map__17019,map__17019__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__17021,map__17021__$1,map__17022,map__17022__$1,map__17023,map__17023__$1,num_displayed_records,total_page_count,map__17019,map__17019__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(columns,SlickGrid,DataView,dataview,grid,map__17021,map__17021__$1,map__17022,map__17022__$1,map__17023,map__17023__$1,num_displayed_records,total_page_count,map__17019,map__17019__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions({"pageSize": (function (){var or__4569__auto__ = num_displayed_records;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count});

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js(data),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__10205__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__10205__auto__,event_chan){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (c__10205__auto__,event_chan){
return (function (state_17288){
var state_val_17289 = (state_17288[(1)]);
if((state_val_17289 === (7))){
var inst_17197 = (state_17288[(7)]);
var inst_17197__$1 = (state_17288[(2)]);
var inst_17199 = (inst_17197__$1 == null);
var inst_17200 = cljs.core.not(inst_17199);
var state_17288__$1 = (function (){var statearr_17290 = state_17288;
(statearr_17290[(7)] = inst_17197__$1);

return statearr_17290;
})();
if(inst_17200){
var statearr_17291_17358 = state_17288__$1;
(statearr_17291_17358[(1)] = (8));

} else {
var statearr_17292_17359 = state_17288__$1;
(statearr_17292_17359[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (20))){
var inst_17227 = (state_17288[(8)]);
var inst_17219 = (state_17288[(9)]);
var inst_17236 = (inst_17227.cljs$core$IFn$_invoke$arity$1 ? inst_17227.cljs$core$IFn$_invoke$arity$1(inst_17219) : inst_17227.call(null,inst_17219));
var state_17288__$1 = state_17288;
var statearr_17293_17360 = state_17288__$1;
(statearr_17293_17360[(2)] = inst_17236);

(statearr_17293_17360[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (27))){
var state_17288__$1 = state_17288;
var statearr_17294_17361 = state_17288__$1;
(statearr_17294_17361[(2)] = null);

(statearr_17294_17361[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (1))){
var state_17288__$1 = state_17288;
var statearr_17295_17362 = state_17288__$1;
(statearr_17295_17362[(2)] = null);

(statearr_17295_17362[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (24))){
var state_17288__$1 = state_17288;
var statearr_17296_17363 = state_17288__$1;
(statearr_17296_17363[(2)] = null);

(statearr_17296_17363[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (4))){
var state_17288__$1 = state_17288;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17288__$1,(7),event_chan);
} else {
if((state_val_17289 === (15))){
var inst_17197 = (state_17288[(7)]);
var state_17288__$1 = state_17288;
var statearr_17297_17364 = state_17288__$1;
(statearr_17297_17364[(2)] = inst_17197);

(statearr_17297_17364[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (21))){
var state_17288__$1 = state_17288;
var statearr_17298_17365 = state_17288__$1;
(statearr_17298_17365[(2)] = null);

(statearr_17298_17365[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (31))){
var inst_17223 = (state_17288[(10)]);
var inst_17261 = (state_17288[(2)]);
var inst_17262 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17223,cljs.core.cst$kw$table);
var state_17288__$1 = (function (){var statearr_17299 = state_17288;
(statearr_17299[(11)] = inst_17261);

return statearr_17299;
})();
if(inst_17262){
var statearr_17300_17366 = state_17288__$1;
(statearr_17300_17366[(1)] = (32));

} else {
var statearr_17301_17367 = state_17288__$1;
(statearr_17301_17367[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (32))){
var inst_17197 = (state_17288[(7)]);
var inst_17227 = (state_17288[(8)]);
var inst_17218 = (state_17288[(12)]);
var inst_17223 = (state_17288[(10)]);
var inst_17217 = (state_17288[(13)]);
var inst_17222 = (state_17288[(14)]);
var inst_17228 = (state_17288[(15)]);
var inst_17219 = (state_17288[(9)]);
var inst_17221 = (state_17288[(16)]);
var inst_17220 = (state_17288[(17)]);
var inst_17275 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_17276 = (function (){var new_columns = inst_17222;
var map__17195 = inst_17217;
var submission_clicked = inst_17219;
var submission_unclicked = inst_17220;
var get_submission_data = inst_17228;
var re_render = inst_17223;
var update_data_BANG_ = inst_17227;
var submission_to_rank = inst_17218;
var e = inst_17197;
var filter_by = inst_17221;
var c__10205__auto____$1 = inst_17275;
return ((function (new_columns,map__17195,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,c__10205__auto____$1,inst_17197,inst_17227,inst_17218,inst_17223,inst_17217,inst_17222,inst_17228,inst_17219,inst_17221,inst_17220,inst_17275,state_val_17289,c__10205__auto__,event_chan){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (new_columns,map__17195,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,c__10205__auto____$1,inst_17197,inst_17227,inst_17218,inst_17223,inst_17217,inst_17222,inst_17228,inst_17219,inst_17221,inst_17220,inst_17275,state_val_17289,c__10205__auto__,event_chan){
return (function (state_17273){
var state_val_17274 = (state_17273[(1)]);
if((state_val_17274 === (1))){
var inst_17264 = cljs.core.async.timeout((20));
var state_17273__$1 = state_17273;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17273__$1,(2),inst_17264);
} else {
if((state_val_17274 === (2))){
var inst_17266 = (state_17273[(2)]);
var inst_17267 = grid.resizeCanvas();
var inst_17268 = grid.invalidateAllRows();
var inst_17269 = hatti.views.table.resizeColumns(grid);
var inst_17270 = grid.render();
var inst_17271 = hatti.views.table.init_sg_pager(grid,dataview);
var state_17273__$1 = (function (){var statearr_17302 = state_17273;
(statearr_17302[(7)] = inst_17266);

(statearr_17302[(8)] = inst_17270);

(statearr_17302[(9)] = inst_17269);

(statearr_17302[(10)] = inst_17267);

(statearr_17302[(11)] = inst_17268);

return statearr_17302;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17273__$1,inst_17271);
} else {
return null;
}
}
});})(new_columns,map__17195,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,c__10205__auto____$1,inst_17197,inst_17227,inst_17218,inst_17223,inst_17217,inst_17222,inst_17228,inst_17219,inst_17221,inst_17220,inst_17275,state_val_17289,c__10205__auto__,event_chan))
;
return ((function (switch__10138__auto__,new_columns,map__17195,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,c__10205__auto____$1,inst_17197,inst_17227,inst_17218,inst_17223,inst_17217,inst_17222,inst_17228,inst_17219,inst_17221,inst_17220,inst_17275,state_val_17289,c__10205__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__10139__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__10139__auto____0 = (function (){
var statearr_17306 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17306[(0)] = hatti$views$table$handle_table_events_$_state_machine__10139__auto__);

(statearr_17306[(1)] = (1));

return statearr_17306;
});
var hatti$views$table$handle_table_events_$_state_machine__10139__auto____1 = (function (state_17273){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_17273);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e17307){if((e17307 instanceof Object)){
var ex__10142__auto__ = e17307;
var statearr_17308_17368 = state_17273;
(statearr_17308_17368[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17273);

return cljs.core.cst$kw$recur;
} else {
throw e17307;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__17369 = state_17273;
state_17273 = G__17369;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__10139__auto__ = function(state_17273){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__10139__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__10139__auto____1.call(this,state_17273);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__10139__auto____0;
hatti$views$table$handle_table_events_$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__10139__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__10139__auto__;
})()
;})(switch__10138__auto__,new_columns,map__17195,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,c__10205__auto____$1,inst_17197,inst_17227,inst_17218,inst_17223,inst_17217,inst_17222,inst_17228,inst_17219,inst_17221,inst_17220,inst_17275,state_val_17289,c__10205__auto__,event_chan))
})();
var state__10207__auto__ = (function (){var statearr_17309 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_17309[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto____$1);

return statearr_17309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});
;})(new_columns,map__17195,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,c__10205__auto____$1,inst_17197,inst_17227,inst_17218,inst_17223,inst_17217,inst_17222,inst_17228,inst_17219,inst_17221,inst_17220,inst_17275,state_val_17289,c__10205__auto__,event_chan))
})();
var inst_17277 = cljs.core.async.impl.dispatch.run(inst_17276);
var state_17288__$1 = (function (){var statearr_17310 = state_17288;
(statearr_17310[(18)] = inst_17277);

return statearr_17310;
})();
var statearr_17311_17370 = state_17288__$1;
(statearr_17311_17370[(2)] = inst_17275);

(statearr_17311_17370[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (33))){
var state_17288__$1 = state_17288;
var statearr_17312_17371 = state_17288__$1;
(statearr_17312_17371[(2)] = null);

(statearr_17312_17371[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (13))){
var inst_17209 = (state_17288[(2)]);
var state_17288__$1 = state_17288;
var statearr_17313_17372 = state_17288__$1;
(statearr_17313_17372[(2)] = inst_17209);

(statearr_17313_17372[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (22))){
var inst_17220 = (state_17288[(17)]);
var inst_17239 = (state_17288[(2)]);
var state_17288__$1 = (function (){var statearr_17314 = state_17288;
(statearr_17314[(19)] = inst_17239);

return statearr_17314;
})();
if(cljs.core.truth_(inst_17220)){
var statearr_17315_17373 = state_17288__$1;
(statearr_17315_17373[(1)] = (23));

} else {
var statearr_17316_17374 = state_17288__$1;
(statearr_17316_17374[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (29))){
var inst_17221 = (state_17288[(16)]);
var inst_17253 = [cljs.core.cst$kw$query];
var inst_17254 = [inst_17221];
var inst_17255 = cljs.core.PersistentHashMap.fromArrays(inst_17253,inst_17254);
var inst_17256 = cljs.core.clj__GT_js(inst_17255);
var inst_17257 = dataview.setFilterArgs(inst_17256);
var inst_17258 = dataview.refresh();
var state_17288__$1 = (function (){var statearr_17317 = state_17288;
(statearr_17317[(20)] = inst_17257);

return statearr_17317;
})();
var statearr_17318_17375 = state_17288__$1;
(statearr_17318_17375[(2)] = inst_17258);

(statearr_17318_17375[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (6))){
var inst_17284 = (state_17288[(2)]);
var state_17288__$1 = state_17288;
var statearr_17319_17376 = state_17288__$1;
(statearr_17319_17376[(2)] = inst_17284);

(statearr_17319_17376[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (28))){
var inst_17221 = (state_17288[(16)]);
var inst_17251 = (state_17288[(2)]);
var state_17288__$1 = (function (){var statearr_17320 = state_17288;
(statearr_17320[(21)] = inst_17251);

return statearr_17320;
})();
if(cljs.core.truth_(inst_17221)){
var statearr_17321_17377 = state_17288__$1;
(statearr_17321_17377[(1)] = (29));

} else {
var statearr_17322_17378 = state_17288__$1;
(statearr_17322_17378[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (25))){
var inst_17222 = (state_17288[(14)]);
var inst_17244 = (state_17288[(2)]);
var state_17288__$1 = (function (){var statearr_17323 = state_17288;
(statearr_17323[(22)] = inst_17244);

return statearr_17323;
})();
if(cljs.core.truth_(inst_17222)){
var statearr_17324_17379 = state_17288__$1;
(statearr_17324_17379[(1)] = (26));

} else {
var statearr_17325_17380 = state_17288__$1;
(statearr_17325_17380[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (34))){
var inst_17280 = (state_17288[(2)]);
var state_17288__$1 = (function (){var statearr_17326 = state_17288;
(statearr_17326[(23)] = inst_17280);

return statearr_17326;
})();
var statearr_17327_17381 = state_17288__$1;
(statearr_17327_17381[(2)] = null);

(statearr_17327_17381[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (17))){
var inst_17227 = (state_17288[(8)]);
var inst_17218 = (state_17288[(12)]);
var inst_17228 = (state_17288[(15)]);
var inst_17230 = (inst_17228.cljs$core$IFn$_invoke$arity$2 ? inst_17228.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_17218) : inst_17228.call(null,hatti.constants._rank,inst_17218));
var inst_17231 = (inst_17227.cljs$core$IFn$_invoke$arity$1 ? inst_17227.cljs$core$IFn$_invoke$arity$1(inst_17230) : inst_17227.call(null,inst_17230));
var state_17288__$1 = state_17288;
var statearr_17328_17382 = state_17288__$1;
(statearr_17328_17382[(2)] = inst_17231);

(statearr_17328_17382[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (3))){
var inst_17286 = (state_17288[(2)]);
var state_17288__$1 = state_17288;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17288__$1,inst_17286);
} else {
if((state_val_17289 === (12))){
var state_17288__$1 = state_17288;
var statearr_17329_17383 = state_17288__$1;
(statearr_17329_17383[(2)] = false);

(statearr_17329_17383[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (2))){
var state_17288__$1 = state_17288;
var statearr_17330_17384 = state_17288__$1;
(statearr_17330_17384[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (23))){
var inst_17227 = (state_17288[(8)]);
var inst_17241 = (inst_17227.cljs$core$IFn$_invoke$arity$1 ? inst_17227.cljs$core$IFn$_invoke$arity$1(null) : inst_17227.call(null,null));
var state_17288__$1 = state_17288;
var statearr_17332_17385 = state_17288__$1;
(statearr_17332_17385[(2)] = inst_17241);

(statearr_17332_17385[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (19))){
var inst_17219 = (state_17288[(9)]);
var inst_17234 = (state_17288[(2)]);
var state_17288__$1 = (function (){var statearr_17333 = state_17288;
(statearr_17333[(24)] = inst_17234);

return statearr_17333;
})();
if(cljs.core.truth_(inst_17219)){
var statearr_17334_17386 = state_17288__$1;
(statearr_17334_17386[(1)] = (20));

} else {
var statearr_17335_17387 = state_17288__$1;
(statearr_17335_17387[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (11))){
var state_17288__$1 = state_17288;
var statearr_17336_17388 = state_17288__$1;
(statearr_17336_17388[(2)] = true);

(statearr_17336_17388[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (9))){
var state_17288__$1 = state_17288;
var statearr_17337_17389 = state_17288__$1;
(statearr_17337_17389[(2)] = false);

(statearr_17337_17389[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (5))){
var state_17288__$1 = state_17288;
var statearr_17338_17390 = state_17288__$1;
(statearr_17338_17390[(2)] = null);

(statearr_17338_17390[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (14))){
var inst_17197 = (state_17288[(7)]);
var inst_17214 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_17197);
var state_17288__$1 = state_17288;
var statearr_17339_17391 = state_17288__$1;
(statearr_17339_17391[(2)] = inst_17214);

(statearr_17339_17391[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (26))){
var inst_17222 = (state_17288[(14)]);
var inst_17246 = grid.setColumns(inst_17222);
var inst_17247 = hatti.views.table.resizeColumns(grid);
var inst_17248 = grid.render();
var state_17288__$1 = (function (){var statearr_17340 = state_17288;
(statearr_17340[(25)] = inst_17246);

(statearr_17340[(26)] = inst_17247);

return statearr_17340;
})();
var statearr_17341_17392 = state_17288__$1;
(statearr_17341_17392[(2)] = inst_17248);

(statearr_17341_17392[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (16))){
var inst_17197 = (state_17288[(7)]);
var inst_17227 = (state_17288[(8)]);
var inst_17218 = (state_17288[(12)]);
var inst_17223 = (state_17288[(10)]);
var inst_17217 = (state_17288[(13)]);
var inst_17222 = (state_17288[(14)]);
var inst_17219 = (state_17288[(9)]);
var inst_17221 = (state_17288[(16)]);
var inst_17220 = (state_17288[(17)]);
var inst_17217__$1 = (state_17288[(2)]);
var inst_17218__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17217__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_17219__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17217__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_17220__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17217__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_17221__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17217__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_17222__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17217__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_17223__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17217__$1,cljs.core.cst$kw$re_DASH_render);
var inst_17224 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17225 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_17226 = (new cljs.core.PersistentVector(null,3,(5),inst_17224,inst_17225,null));
var inst_17227__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_17226);
var inst_17228 = (function (){var e = inst_17197;
var map__17195 = inst_17217__$1;
var submission_to_rank = inst_17218__$1;
var submission_clicked = inst_17219__$1;
var submission_unclicked = inst_17220__$1;
var filter_by = inst_17221__$1;
var new_columns = inst_17222__$1;
var re_render = inst_17223__$1;
var update_data_BANG_ = inst_17227__$1;
return ((function (e,map__17195,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_17197,inst_17227,inst_17218,inst_17223,inst_17217,inst_17222,inst_17219,inst_17221,inst_17220,inst_17217__$1,inst_17218__$1,inst_17219__$1,inst_17220__$1,inst_17221__$1,inst_17222__$1,inst_17223__$1,inst_17224,inst_17225,inst_17226,inst_17227__$1,state_val_17289,c__10205__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (e,map__17195,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_17197,inst_17227,inst_17218,inst_17223,inst_17217,inst_17222,inst_17219,inst_17221,inst_17220,inst_17217__$1,inst_17218__$1,inst_17219__$1,inst_17220__$1,inst_17221__$1,inst_17222__$1,inst_17223__$1,inst_17224,inst_17225,inst_17226,inst_17227__$1,state_val_17289,c__10205__auto__,event_chan){
return (function (p1__17027_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__17027_SHARP_,field));
});})(e,map__17195,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_17197,inst_17227,inst_17218,inst_17223,inst_17217,inst_17222,inst_17219,inst_17221,inst_17220,inst_17217__$1,inst_17218__$1,inst_17219__$1,inst_17220__$1,inst_17221__$1,inst_17222__$1,inst_17223__$1,inst_17224,inst_17225,inst_17226,inst_17227__$1,state_val_17289,c__10205__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(e,map__17195,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_17197,inst_17227,inst_17218,inst_17223,inst_17217,inst_17222,inst_17219,inst_17221,inst_17220,inst_17217__$1,inst_17218__$1,inst_17219__$1,inst_17220__$1,inst_17221__$1,inst_17222__$1,inst_17223__$1,inst_17224,inst_17225,inst_17226,inst_17227__$1,state_val_17289,c__10205__auto__,event_chan))
})();
var state_17288__$1 = (function (){var statearr_17342 = state_17288;
(statearr_17342[(8)] = inst_17227__$1);

(statearr_17342[(12)] = inst_17218__$1);

(statearr_17342[(10)] = inst_17223__$1);

(statearr_17342[(13)] = inst_17217__$1);

(statearr_17342[(14)] = inst_17222__$1);

(statearr_17342[(15)] = inst_17228);

(statearr_17342[(9)] = inst_17219__$1);

(statearr_17342[(16)] = inst_17221__$1);

(statearr_17342[(17)] = inst_17220__$1);

return statearr_17342;
})();
if(cljs.core.truth_(inst_17218__$1)){
var statearr_17343_17393 = state_17288__$1;
(statearr_17343_17393[(1)] = (17));

} else {
var statearr_17344_17394 = state_17288__$1;
(statearr_17344_17394[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (30))){
var state_17288__$1 = state_17288;
var statearr_17345_17395 = state_17288__$1;
(statearr_17345_17395[(2)] = null);

(statearr_17345_17395[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (10))){
var inst_17212 = (state_17288[(2)]);
var state_17288__$1 = state_17288;
if(cljs.core.truth_(inst_17212)){
var statearr_17346_17396 = state_17288__$1;
(statearr_17346_17396[(1)] = (14));

} else {
var statearr_17347_17397 = state_17288__$1;
(statearr_17347_17397[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (18))){
var state_17288__$1 = state_17288;
var statearr_17348_17398 = state_17288__$1;
(statearr_17348_17398[(2)] = null);

(statearr_17348_17398[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17289 === (8))){
var inst_17197 = (state_17288[(7)]);
var inst_17202 = inst_17197.cljs$lang$protocol_mask$partition0$;
var inst_17203 = (inst_17202 & (64));
var inst_17204 = inst_17197.cljs$core$ISeq$;
var inst_17205 = (inst_17203) || (inst_17204);
var state_17288__$1 = state_17288;
if(cljs.core.truth_(inst_17205)){
var statearr_17349_17399 = state_17288__$1;
(statearr_17349_17399[(1)] = (11));

} else {
var statearr_17350_17400 = state_17288__$1;
(statearr_17350_17400[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10205__auto__,event_chan))
;
return ((function (switch__10138__auto__,c__10205__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__10139__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__10139__auto____0 = (function (){
var statearr_17354 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17354[(0)] = hatti$views$table$handle_table_events_$_state_machine__10139__auto__);

(statearr_17354[(1)] = (1));

return statearr_17354;
});
var hatti$views$table$handle_table_events_$_state_machine__10139__auto____1 = (function (state_17288){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_17288);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e17355){if((e17355 instanceof Object)){
var ex__10142__auto__ = e17355;
var statearr_17356_17401 = state_17288;
(statearr_17356_17401[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17288);

return cljs.core.cst$kw$recur;
} else {
throw e17355;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__17402 = state_17288;
state_17288 = G__17402;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__10139__auto__ = function(state_17288){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__10139__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__10139__auto____1.call(this,state_17288);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__10139__auto____0;
hatti$views$table$handle_table_events_$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__10139__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__10139__auto__;
})()
;})(switch__10138__auto__,c__10205__auto__,event_chan))
})();
var state__10207__auto__ = (function (){var statearr_17357 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_17357[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto__);

return statearr_17357;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});})(c__10205__auto__,event_chan))
);

return c__10205__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$name_DASH_or_DASH_label,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__5341__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__17413(s__17414){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__17414__$1 = s__17414;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__17414__$1);
if(temp__4425__auto__){
var s__17414__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__17414__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__17414__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__17416 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__17415 = (0);
while(true){
if((i__17415 < size__5340__auto__)){
var vec__17421 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__17415);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17421,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17421,(1),null);
cljs.core.chunk_append(b__17416,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__17415,vec__17421,k,v,c__5339__auto__,size__5340__auto__,b__17416,s__17414__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__17415,vec__17421,k,v,c__5339__auto__,size__5340__auto__,b__17416,s__17414__$2,temp__4425__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__17423 = (i__17415 + (1));
i__17415 = G__17423;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__17416),hatti$views$table$render_options_$_iter__17413(cljs.core.chunk_rest(s__17414__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__17416),null);
}
} else {
var vec__17422 = cljs.core.first(s__17414__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17422,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17422,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__17422,k,v,s__17414__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__17422,k,v,s__17414__$2,temp__4425__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__17413(cljs.core.rest(s__17414__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__5341__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table17425 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table17425 = (function (_,owner,meta17426){
this._ = _;
this.owner = owner;
this.meta17426 = meta17426;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table17425.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17427,meta17426__$1){
var self__ = this;
var _17427__$1 = this;
return (new hatti.views.table.t_hatti$views$table17425(self__._,self__.owner,meta17426__$1));
});

hatti.views.table.t_hatti$views$table17425.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17427){
var self__ = this;
var _17427__$1 = this;
return self__.meta17426;
});

hatti.views.table.t_hatti$views$table17425.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table17425.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name_DASH_or_DASH_label,cljs.core.cst$kw$label], null);
});

hatti.views.table.t_hatti$views$table17425.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table17425.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__17428){
var self__ = this;
var map__17429 = p__17428;
var map__17429__$1 = ((((!((map__17429 == null)))?((((map__17429.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17429.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17429):map__17429);
var name_or_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17429__$1,cljs.core.cst$kw$name_DASH_or_DASH_label);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17429__$1,cljs.core.cst$kw$language);
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__17431 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__17431__$1 = ((((!((map__17431 == null)))?((((map__17431.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17431.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17431):map__17431);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17431__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var colset_BANG_ = ((function (options,map__17431,map__17431__$1,flat_form,new_language,___$2,map__17429,map__17429__$1,name_or_label,language){
return (function (p1__17424_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns(flat_form,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__17424_SHARP_),new_language)], null));
});})(options,map__17431,map__17431__$1,flat_form,new_language,___$2,map__17429,map__17429__$1,name_or_label,language))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(name_or_label);
} else {
}

var G__17440 = {"className": "label-changer"};
var G__17441 = (function (){var G__17443 = {"className": "label-changer-label"};
var G__17444 = "Show:";
return React.DOM.span(G__17443,G__17444);
})();
var G__17442 = (function (){var G__17445 = {"id": "header-display-dropdown", "className": "drop-hover"};
var G__17446 = (function (){var attrs17435 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(name_or_label) : options.call(null,name_or_label));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs17435))?sablono.interpreter.attributes(attrs17435):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs17435))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__17448 = {"className": "fa fa-angle-down"};
return React.DOM.i(G__17448);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs17435),(function (){var G__17449 = {"className": "fa fa-angle-down"};
return React.DOM.i(G__17449);
})()], null))));
})();
var G__17447 = (function (){var G__17450 = {"className": "submenu no-dot"};
var G__17451 = sablono.interpreter.interpret(hatti.views.table.render_options(options,self__.owner,colset_BANG_));
return React.DOM.ul(G__17450,G__17451);
})();
return React.DOM.div(G__17445,G__17446,G__17447);
})();
return React.DOM.div(G__17440,G__17441,G__17442);
});

hatti.views.table.t_hatti$views$table17425.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta17426], null);
});

hatti.views.table.t_hatti$views$table17425.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table17425.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table17425";

hatti.views.table.t_hatti$views$table17425.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table17425");
});

hatti.views.table.__GT_t_hatti$views$table17425 = (function hatti$views$table$__GT_t_hatti$views$table17425(___$1,owner__$1,meta17426){
return (new hatti.views.table.t_hatti$views$table17425(___$1,owner__$1,meta17426));
});

}

return (new hatti.views.table.t_hatti$views$table17425(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__10205__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__10205__auto__,query){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (c__10205__auto__,query){
return (function (state_17494){
var state_val_17495 = (state_17494[(1)]);
if((state_val_17495 === (1))){
var inst_17480 = cljs.core.async.timeout((150));
var state_17494__$1 = state_17494;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17494__$1,(2),inst_17480);
} else {
if((state_val_17495 === (2))){
var inst_17482 = (state_17494[(2)]);
var inst_17483 = input.value;
var inst_17484 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_17483);
var state_17494__$1 = (function (){var statearr_17496 = state_17494;
(statearr_17496[(7)] = inst_17482);

return statearr_17496;
})();
if(inst_17484){
var statearr_17497_17508 = state_17494__$1;
(statearr_17497_17508[(1)] = (3));

} else {
var statearr_17498_17509 = state_17494__$1;
(statearr_17498_17509[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17495 === (3))){
var inst_17486 = [query_event_key];
var inst_17487 = [query];
var inst_17488 = cljs.core.PersistentHashMap.fromArrays(inst_17486,inst_17487);
var inst_17489 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_17488);
var state_17494__$1 = state_17494;
var statearr_17499_17510 = state_17494__$1;
(statearr_17499_17510[(2)] = inst_17489);

(statearr_17499_17510[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17495 === (4))){
var state_17494__$1 = state_17494;
var statearr_17500_17511 = state_17494__$1;
(statearr_17500_17511[(2)] = null);

(statearr_17500_17511[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17495 === (5))){
var inst_17492 = (state_17494[(2)]);
var state_17494__$1 = state_17494;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17494__$1,inst_17492);
} else {
return null;
}
}
}
}
}
});})(c__10205__auto__,query))
;
return ((function (switch__10138__auto__,c__10205__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__10139__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__10139__auto____0 = (function (){
var statearr_17504 = [null,null,null,null,null,null,null,null];
(statearr_17504[(0)] = hatti$views$table$delayed_search_$_state_machine__10139__auto__);

(statearr_17504[(1)] = (1));

return statearr_17504;
});
var hatti$views$table$delayed_search_$_state_machine__10139__auto____1 = (function (state_17494){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_17494);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e17505){if((e17505 instanceof Object)){
var ex__10142__auto__ = e17505;
var statearr_17506_17512 = state_17494;
(statearr_17506_17512[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17494);

return cljs.core.cst$kw$recur;
} else {
throw e17505;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__17513 = state_17494;
state_17494 = G__17513;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__10139__auto__ = function(state_17494){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__10139__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__10139__auto____1.call(this,state_17494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__10139__auto____0;
hatti$views$table$delayed_search_$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__10139__auto____1;
return hatti$views$table$delayed_search_$_state_machine__10139__auto__;
})()
;})(switch__10138__auto__,c__10205__auto__,query))
})();
var state__10207__auto__ = (function (){var statearr_17507 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_17507[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto__);

return statearr_17507;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});})(c__10205__auto__,query))
);

return c__10205__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table17515 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table17515 = (function (_,owner,meta17516){
this._ = _;
this.owner = owner;
this.meta17516 = meta17516;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table17515.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17517,meta17516__$1){
var self__ = this;
var _17517__$1 = this;
return (new hatti.views.table.t_hatti$views$table17515(self__._,self__.owner,meta17516__$1));
});

hatti.views.table.t_hatti$views$table17515.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17517){
var self__ = this;
var _17517__$1 = this;
return self__.meta17516;
});

hatti.views.table.t_hatti$views$table17515.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table17515.prototype.om$core$IRender$render$arity$1 = (function (this__8157__auto__){
var self__ = this;
var this__8157__auto____$1 = this;
var G__17520 = {"className": "table-search"};
var G__17521 = (function (){var G__17523 = {"className": "fa fa-search"};
return React.DOM.i(G__17523);
})();
var G__17522 = (function (){var G__17524 = {"type": "text", "placeholder": "Search", "onChange": ((function (G__17520,G__17521,this__8157__auto____$1){
return (function (p1__17514_SHARP_){
return hatti.views.table.delayed_search(p1__17514_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__17520,G__17521,this__8157__auto____$1))
};
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__17524) : sablono.interpreter.input.call(null,G__17524));
})();
return React.DOM.div(G__17520,G__17521,G__17522);
});

hatti.views.table.t_hatti$views$table17515.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta17516], null);
});

hatti.views.table.t_hatti$views$table17515.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table17515.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table17515";

hatti.views.table.t_hatti$views$table17515.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table17515");
});

hatti.views.table.__GT_t_hatti$views$table17515 = (function hatti$views$table$__GT_t_hatti$views$table17515(___$1,owner__$1,meta17516){
return (new hatti.views.table.t_hatti$views$table17515(___$1,owner__$1,meta17516));
});

}

return (new hatti.views.table.t_hatti$views$table17515(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner){
if(typeof hatti.views.table.t_hatti$views$table17525 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table17525 = (function (app_state,owner,meta17526){
this.app_state = app_state;
this.owner = owner;
this.meta17526 = meta17526;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table17525.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17527,meta17526__$1){
var self__ = this;
var _17527__$1 = this;
return (new hatti.views.table.t_hatti$views$table17525(self__.app_state,self__.owner,meta17526__$1));
});

hatti.views.table.t_hatti$views$table17525.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17527){
var self__ = this;
var _17527__$1 = this;
return self__.meta17526;
});

hatti.views.table.t_hatti$views$table17525.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table17525.prototype.om$core$IRender$render$arity$1 = (function (this__8157__auto__){
var self__ = this;
var this__8157__auto____$1 = this;
var G__17530 = {"className": "topbar"};
var G__17531 = (function (){var G__17535 = {"id": hatti.views.table.pager_id};
return React.DOM.div(G__17535);
})();
var G__17532 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,null));
var G__17533 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.app_state));
var G__17534 = (function (){var G__17536 = {"style": {"clear": "both"}};
return React.DOM.div(G__17536);
})();
return React.DOM.div(G__17530,G__17531,G__17532,G__17533,G__17534);
});

hatti.views.table.t_hatti$views$table17525.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta17526], null);
});

hatti.views.table.t_hatti$views$table17525.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table17525.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table17525";

hatti.views.table.t_hatti$views$table17525.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table17525");
});

hatti.views.table.__GT_t_hatti$views$table17525 = (function hatti$views$table$__GT_t_hatti$views$table17525(app_state__$1,owner__$1,meta17526){
return (new hatti.views.table.t_hatti$views$table17525(app_state__$1,owner__$1,meta17526));
});

}

return (new hatti.views.table.t_hatti$views$table17525(app_state,owner,null));
}));
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){

if(cljs.core.seq(data)){
var map__17540 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__17540__$1 = ((((!((map__17540 == null)))?((((map__17540.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17540.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17540):map__17540);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17540__$1,cljs.core.cst$kw$flat_DASH_form);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17540__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__17541 = hatti.views.table.sg_init(data,flat_form,current_language,is_filtered_dataview_QMARK_,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17541,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17541,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner,p__17544){
var map__17545 = p__17544;
var map__17545__$1 = ((((!((map__17545 == null)))?((((map__17545.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17545.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17545):map__17545);
var opts = map__17545__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17545__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

if(typeof hatti.views.table.t_hatti$views$table17547 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table17547 = (function (app_state,owner,p__17544,map__17545,opts,slick_grid_event_handlers,meta17548){
this.app_state = app_state;
this.owner = owner;
this.p__17544 = p__17544;
this.map__17545 = map__17545;
this.opts = opts;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.meta17548 = meta17548;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table17547.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__17545,map__17545__$1,opts,slick_grid_event_handlers){
return (function (_17549,meta17548__$1){
var self__ = this;
var _17549__$1 = this;
return (new hatti.views.table.t_hatti$views$table17547(self__.app_state,self__.owner,self__.p__17544,self__.map__17545,self__.opts,self__.slick_grid_event_handlers,meta17548__$1));
});})(map__17545,map__17545__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table17547.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__17545,map__17545__$1,opts,slick_grid_event_handlers){
return (function (_17549){
var self__ = this;
var _17549__$1 = this;
return self__.meta17548;
});})(map__17545,map__17545__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table17547.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table17547.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__17545,map__17545__$1,opts,slick_grid_event_handlers){
return (function (_,___$1){
var self__ = this;
var ___$2 = this;
var no_data_QMARK_ = cljs.core.empty_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null)));
var map__17550 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state);
var map__17550__$1 = ((((!((map__17550 == null)))?((((map__17550.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17550.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17550):map__17550);
var dataset_info = map__17550__$1;
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17550__$1,cljs.core.cst$kw$num_of_submissions);
var with_info = ((function (no_data_QMARK_,map__17550,map__17550__$1,dataset_info,num_of_submissions,___$2,map__17545,map__17545__$1,opts,slick_grid_event_handlers){
return (function (p1__17543_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__17543_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$dataset_DASH_info,dataset_info], null)], 0));
});})(no_data_QMARK_,map__17550,map__17550__$1,dataset_info,num_of_submissions,___$2,map__17545,map__17545__$1,opts,slick_grid_event_handlers))
;
var attrs17552 = om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked], null))),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs17552))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["table-view"], null)], null),attrs17552], 0))):{"className": "table-view"}),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs17552))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.app_state)),(function (){var G__17553 = {"id": hatti.views.table.table_id, "className": "slickgrid"};
var G__17554 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__17559 = {"className": "empty-state"};
var G__17560 = "No data";
return React.DOM.span(G__17559,G__17560);
})():(function (){var G__17562 = null;
var G__17563 = (function (){var G__17565 = {"className": "fa fa-spinner fa-pulse"};
return React.DOM.i(G__17565);
})();
var G__17564 = "Loading...";
return React.DOM.span(G__17562,G__17563,G__17564);
})());
return React.DOM.div(G__17553,G__17554);
})()], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs17552),sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.app_state)),(function (){var G__17566 = {"id": hatti.views.table.table_id, "className": "slickgrid"};
var G__17567 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__17572 = {"className": "empty-state"};
var G__17573 = "No data";
return React.DOM.span(G__17572,G__17573);
})():(function (){var G__17575 = null;
var G__17576 = (function (){var G__17578 = {"className": "fa fa-spinner fa-pulse"};
return React.DOM.i(G__17578);
})();
var G__17577 = "Loading...";
return React.DOM.span(G__17575,G__17576,G__17577);
})());
return React.DOM.div(G__17566,G__17567);
})()], null))));
});})(map__17545,map__17545__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table17547.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table17547.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (map__17545,map__17545__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__17579 = temp__4425__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17579,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17579,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid,dataview);
} else {
return null;
}
});})(map__17545,map__17545__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table17547.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table17547.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (map__17545,map__17545__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__17580 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__17580__$1 = ((((!((map__17580 == null)))?((((map__17580.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17580.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17580):map__17580);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17580__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17580__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__17582 = temp__4425__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17582,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17582,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js(new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
});})(map__17545,map__17545__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table17547.getBasis = ((function (map__17545,map__17545__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__17544,cljs.core.cst$sym$map__17545,cljs.core.cst$sym$opts,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$meta17548], null);
});})(map__17545,map__17545__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table17547.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table17547.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table17547";

hatti.views.table.t_hatti$views$table17547.cljs$lang$ctorPrWriter = ((function (map__17545,map__17545__$1,opts,slick_grid_event_handlers){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table17547");
});})(map__17545,map__17545__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table17547 = ((function (map__17545,map__17545__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table17547(app_state__$1,owner__$1,p__17544__$1,map__17545__$2,opts__$1,slick_grid_event_handlers__$1,meta17548){
return (new hatti.views.table.t_hatti$views$table17547(app_state__$1,owner__$1,p__17544__$1,map__17545__$2,opts__$1,slick_grid_event_handlers__$1,meta17548));
});})(map__17545,map__17545__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table17547(app_state,owner,p__17544,map__17545__$1,opts,slick_grid_event_handlers,cljs.core.PersistentArrayMap.EMPTY));
}));
