// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string.format');
goog.require('goog.string');
goog.require('inflections.core');
hatti.utils.url = (function hatti$utils$url(var_args){
var args__5634__auto__ = [];
var len__5627__auto___8818 = arguments.length;
var i__5628__auto___8819 = (0);
while(true){
if((i__5628__auto___8819 < len__5627__auto___8818)){
args__5634__auto__.push((arguments[i__5628__auto___8819]));

var G__8820 = (i__5628__auto___8819 + (1));
i__5628__auto___8819 = G__8820;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return hatti.utils.url.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

hatti.utils.url.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("/",args);
});

hatti.utils.url.cljs$lang$maxFixedArity = (0);

hatti.utils.url.cljs$lang$applyTo = (function (seq8817){
return hatti.utils.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq8817));
});
/**
 * Get last parameter form url
 */
hatti.utils.last_url_param = (function hatti$utils$last_url_param(url){
var last_param = cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str(url)].join(''),/\//));
return cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str(last_param)].join(''),/.json/));
});
/**
 * Convert json to js using JSON.parse
 */
hatti.utils.json__GT_js = (function hatti$utils$json__GT_js(s){
return JSON.parse(s);
});
/**
 * Convert json string to cljs object.
 * Fast, but doesn't preserve keywords.
 */
hatti.utils.json__GT_cljs = (function hatti$utils$json__GT_cljs(s){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(hatti.utils.json__GT_js(s));
});
/**
 * Convert json string to cljs via js.
 * Slow method, but preserves keywords, and appropriate for small json.
 */
hatti.utils.json__GT_js__GT_cljs = (function hatti$utils$json__GT_js__GT_cljs(s){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(hatti.utils.json__GT_js(s),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Formats a string using goog.string.format, so we can use format in cljx.
 */
hatti.utils.format = (function hatti$utils$format(var_args){
var args__5634__auto__ = [];
var len__5627__auto___8823 = arguments.length;
var i__5628__auto___8824 = (0);
while(true){
if((i__5628__auto___8824 < len__5627__auto___8823)){
args__5634__auto__.push((arguments[i__5628__auto___8824]));

var G__8825 = (i__5628__auto___8824 + (1));
i__5628__auto___8824 = G__8825;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(goog.string.format,fmt,args);
});

hatti.utils.format.cljs$lang$maxFixedArity = (1);

hatti.utils.format.cljs$lang$applyTo = (function (seq8821){
var G__8822 = cljs.core.first(seq8821);
var seq8821__$1 = cljs.core.next(seq8821);
return hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic(G__8822,seq8821__$1);
});
/**
 * Create a safe (escaped) js regex out of a string.
 * By default, creates regex with ignore case option.
 */
hatti.utils.safe_regex = (function hatti$utils$safe_regex(var_args){
var args__5634__auto__ = [];
var len__5627__auto___8831 = arguments.length;
var i__5628__auto___8832 = (0);
while(true){
if((i__5628__auto___8832 < len__5627__auto___8831)){
args__5634__auto__.push((arguments[i__5628__auto___8832]));

var G__8833 = (i__5628__auto___8832 + (1));
i__5628__auto___8832 = G__8833;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.utils.safe_regex.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.utils.safe_regex.cljs$core$IFn$_invoke$arity$variadic = (function (s,p__8828){
var map__8829 = p__8828;
var map__8829__$1 = ((((!((map__8829 == null)))?((((map__8829.cljs$lang$protocol_mask$partition0$ & (64))) || (map__8829.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__8829):map__8829);
var ignore_case_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__8829__$1,cljs.core.cst$kw$ignore_DASH_case_QMARK_,true);
var s__$1 = s.replace(/\/[\-\[\]\\/\{\}\(\)\*\+\?\.\\\^\$\|]\//,"\\$&");
return (new RegExp(s__$1,"i"));

});

hatti.utils.safe_regex.cljs$lang$maxFixedArity = (1);

hatti.utils.safe_regex.cljs$lang$applyTo = (function (seq8826){
var G__8827 = cljs.core.first(seq8826);
var seq8826__$1 = cljs.core.next(seq8826);
return hatti.utils.safe_regex.cljs$core$IFn$_invoke$arity$variadic(G__8827,seq8826__$1);
});
/**
 * Given a seq, produces a two-el seq. [a b c] => [[0 a] [1 b] [2 c]].
 */
hatti.utils.indexed = (function hatti$utils$indexed(coll){
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,coll);
});
/**
 * Helper function to create a click function that prevents default
 */
hatti.utils.click_fn = (function hatti$utils$click_fn(f){
return (function (event){
event.preventDefault();

return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
});
/**
 * Create an appropriately pluralized string prefix by number.
 */
hatti.utils.pluralize_number = (function hatti$utils$pluralize_number(number,kind){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [number,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),number))?kind:inflections.core.plural(kind))], null));
});
/**
 * True if substring is a substring of string
 */
hatti.utils.substring_QMARK_ = (function hatti$utils$substring_QMARK_(var_args){
var args8834 = [];
var len__5627__auto___8843 = arguments.length;
var i__5628__auto___8844 = (0);
while(true){
if((i__5628__auto___8844 < len__5627__auto___8843)){
args8834.push((arguments[i__5628__auto___8844]));

var G__8845 = (i__5628__auto___8844 + (1));
i__5628__auto___8844 = G__8845;
continue;
} else {
}
break;
}

var G__8839 = args8834.length;
switch (G__8839) {
case 2:
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args8834.slice((2)),(0)));
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (substring,string){
return cljs.core.complement(cljs.core.nil_QMARK_).call(null,cljs.core.re_find(cljs.core.re_pattern(substring),string));
});

hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (substring,string,p__8840){
var map__8841 = p__8840;
var map__8841__$1 = ((((!((map__8841 == null)))?((((map__8841.cljs$lang$protocol_mask$partition0$ & (64))) || (map__8841.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__8841):map__8841);
var case_sensitive_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8841__$1,cljs.core.cst$kw$case_DASH_sensitive_QMARK_);
if(cljs.core.truth_(case_sensitive_QMARK_)){
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2(substring,string);
} else {
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2(clojure.string.lower_case(substring),clojure.string.lower_case(string));
}
});

hatti.utils.substring_QMARK_.cljs$lang$applyTo = (function (seq8835){
var G__8836 = cljs.core.first(seq8835);
var seq8835__$1 = cljs.core.next(seq8835);
var G__8837 = cljs.core.first(seq8835__$1);
var seq8835__$2 = cljs.core.next(seq8835__$1);
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__8836,G__8837,seq8835__$2);
});

hatti.utils.substring_QMARK_.cljs$lang$maxFixedArity = (2);
hatti.utils.hyphen__GT_camel_case = (function hatti$utils$hyphen__GT_camel_case(source_string){
return clojure.string.replace(source_string,/(-)(.)/,(function (p1__8847_SHARP_){
var vec__8849 = p1__8847_SHARP_;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8849,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8849,(1),null);
var letter_to_uppercase = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8849,(2),null);
return clojure.string.upper_case(letter_to_uppercase);
}));
});
