// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('cljs_time.internal.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.format');
cljs_time.internal.core._EQ_ = (function cljs_time$internal$core$_EQ_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___18737 = arguments.length;
var i__5628__auto___18738 = (0);
while(true){
if((i__5628__auto___18738 < len__5627__auto___18737)){
args__5634__auto__.push((arguments[i__5628__auto___18738]));

var G__18739 = (i__5628__auto___18738 + (1));
i__5628__auto___18738 = G__18739;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return cljs_time.internal.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

cljs_time.internal.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(cljs.core.every_QMARK_((function (p1__18734_SHARP_){
return (p1__18734_SHARP_ instanceof goog.date.Date);
}),args)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18735_SHARP_){
return p1__18735_SHARP_.getTime();
}),args));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);

}
});

cljs_time.internal.core._EQ_.cljs$lang$maxFixedArity = (0);

cljs_time.internal.core._EQ_.cljs$lang$applyTo = (function (seq18736){
return cljs_time.internal.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18736));
});
cljs_time.internal.core.leap_year_QMARK_ = (function cljs_time$internal$core$leap_year_QMARK_(y){
if((cljs.core.mod(y,(400)) === (0))){
return true;
} else {
if((cljs.core.mod(y,(100)) === (0))){
return false;
} else {
if((cljs.core.mod(y,(4)) === (0))){
return true;
} else {
return false;

}
}
}
});
cljs_time.internal.core.days_in_month = new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [(31),(28),(31),(30),(31),(30),(31),(31),(30),(31),(30),(31)], null);
cljs_time.internal.core.year_corrected_dim = (function cljs_time$internal$core$year_corrected_dim(year,month){
var G__18742 = (function (){var G__18743 = (cljs.core.truth_(cljs_time.internal.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([month,(1)], 0)))?(11):(month - (1)));
return (cljs_time.internal.core.days_in_month.cljs$core$IFn$_invoke$arity$1 ? cljs_time.internal.core.days_in_month.cljs$core$IFn$_invoke$arity$1(G__18743) : cljs_time.internal.core.days_in_month.call(null,G__18743));
})();
var G__18742__$1 = (cljs.core.truth_((function (){var and__4557__auto__ = cljs_time.internal.core.leap_year_QMARK_(year);
if(cljs.core.truth_(and__4557__auto__)){
return cljs_time.internal.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([month,(2)], 0));
} else {
return and__4557__auto__;
}
})())?(G__18742 + (1)):G__18742);
return G__18742__$1;
});
cljs_time.internal.core.valid_date_QMARK_ = (function cljs_time$internal$core$valid_date_QMARK_(p__18744){
var map__18747 = p__18744;
var map__18747__$1 = ((((!((map__18747 == null)))?((((map__18747.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18747.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18747):map__18747);
var d = map__18747__$1;
var years = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18747__$1,cljs.core.cst$kw$years);
var months = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18747__$1,cljs.core.cst$kw$months);
var days = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18747__$1,cljs.core.cst$kw$days);
var hours = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18747__$1,cljs.core.cst$kw$hours);
var minutes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18747__$1,cljs.core.cst$kw$minutes);
var seconds = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18747__$1,cljs.core.cst$kw$seconds);
var millis = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18747__$1,cljs.core.cst$kw$millis);
var months__$1 = (months + (1));
var _GT__LT_ = ((function (months__$1,map__18747,map__18747__$1,d,years,months,days,hours,minutes,seconds,millis){
return (function cljs_time$internal$core$valid_date_QMARK__$__GT__LT_(a,b,x){
return ((x >= a)) && ((x <= b));
});})(months__$1,map__18747,map__18747__$1,d,years,months,days,hours,minutes,seconds,millis))
;
if(cljs.core.truth_((function (){var and__4557__auto__ = years;
if(cljs.core.truth_(and__4557__auto__)){
var and__4557__auto____$1 = _GT__LT_((1),(12),months__$1);
if(cljs.core.truth_(and__4557__auto____$1)){
var and__4557__auto____$2 = _GT__LT_((1),cljs_time.internal.core.year_corrected_dim(years,months__$1),days);
if(cljs.core.truth_(and__4557__auto____$2)){
var and__4557__auto____$3 = _GT__LT_((0),(23),hours);
if(cljs.core.truth_(and__4557__auto____$3)){
var and__4557__auto____$4 = _GT__LT_((0),(59),minutes);
if(cljs.core.truth_(and__4557__auto____$4)){
var and__4557__auto____$5 = _GT__LT_((0),(60),seconds);
if(cljs.core.truth_(and__4557__auto____$5)){
return _GT__LT_((0),(999),millis);
} else {
return and__4557__auto____$5;
}
} else {
return and__4557__auto____$4;
}
} else {
return and__4557__auto____$3;
}
} else {
return and__4557__auto____$2;
}
} else {
return and__4557__auto____$1;
}
} else {
return and__4557__auto__;
}
})())){
return d;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Date is not valid",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,cljs.core.cst$kw$invalid_DASH_date,cljs.core.cst$kw$date,d], null));
}
});
cljs_time.internal.core.index_of = (function cljs_time$internal$core$index_of(coll,x){
return cljs.core.first(cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (p1__18750_SHARP_,p2__18749_SHARP_){
if(cljs.core.truth_(cljs_time.internal.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p2__18749_SHARP_,x], 0)))){
return p1__18750_SHARP_;
} else {
return null;
}
}),coll));
});
cljs_time.internal.core.period = (function cljs_time$internal$core$period(var_args){
var args18751 = [];
var len__5627__auto___18757 = arguments.length;
var i__5628__auto___18758 = (0);
while(true){
if((i__5628__auto___18758 < len__5627__auto___18757)){
args18751.push((arguments[i__5628__auto___18758]));

var G__18759 = (i__5628__auto___18758 + (1));
i__5628__auto___18758 = G__18759;
continue;
} else {
}
break;
}

var G__18756 = args18751.length;
switch (G__18756) {
case 2:
return cljs_time.internal.core.period.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args18751.slice((2)),(0)));
return cljs_time.internal.core.period.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs_time.internal.core.period.cljs$core$IFn$_invoke$arity$2 = (function (period,value){
return cljs.core.with_meta(cljs.core.PersistentArrayMap.fromArray([period,value], true, false),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$type,cljs.core.cst$kw$cljs_DASH_time$core_SLASH_period], null));
});

cljs_time.internal.core.period.cljs$core$IFn$_invoke$arity$variadic = (function (p1,v1,kvs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc,cljs_time.internal.core.period.cljs$core$IFn$_invoke$arity$2(p1,v1),kvs);
});

cljs_time.internal.core.period.cljs$lang$applyTo = (function (seq18752){
var G__18753 = cljs.core.first(seq18752);
var seq18752__$1 = cljs.core.next(seq18752);
var G__18754 = cljs.core.first(seq18752__$1);
var seq18752__$2 = cljs.core.next(seq18752__$1);
return cljs_time.internal.core.period.cljs$core$IFn$_invoke$arity$variadic(G__18753,G__18754,seq18752__$2);
});

cljs_time.internal.core.period.cljs$lang$maxFixedArity = (2);
/**
 * Formats a string using goog.string.format.
 */
cljs_time.internal.core.format = (function cljs_time$internal$core$format(var_args){
var args__5634__auto__ = [];
var len__5627__auto___18763 = arguments.length;
var i__5628__auto___18764 = (0);
while(true){
if((i__5628__auto___18764 < len__5627__auto___18763)){
args__5634__auto__.push((arguments[i__5628__auto___18764]));

var G__18765 = (i__5628__auto___18764 + (1));
i__5628__auto___18764 = G__18765;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return cljs_time.internal.core.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

cljs_time.internal.core.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
var args__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
if(((x instanceof cljs.core.Keyword)) || ((x instanceof cljs.core.Symbol))){
return [cljs.core.str(x)].join('');
} else {
return x;
}
}),args);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(goog.string.format,fmt,args__$1);
});

cljs_time.internal.core.format.cljs$lang$maxFixedArity = (1);

cljs_time.internal.core.format.cljs$lang$applyTo = (function (seq18761){
var G__18762 = cljs.core.first(seq18761);
var seq18761__$1 = cljs.core.next(seq18761);
return cljs_time.internal.core.format.cljs$core$IFn$_invoke$arity$variadic(G__18762,seq18761__$1);
});
/**
 * Remove the need to pull in gstring/format code in advanced compilation
 */
cljs_time.internal.core.zero_pad = (function cljs_time$internal$core$zero_pad(var_args){
var args18766 = [];
var len__5627__auto___18769 = arguments.length;
var i__5628__auto___18770 = (0);
while(true){
if((i__5628__auto___18770 < len__5627__auto___18769)){
args18766.push((arguments[i__5628__auto___18770]));

var G__18771 = (i__5628__auto___18770 + (1));
i__5628__auto___18770 = G__18771;
continue;
} else {
}
break;
}

var G__18768 = args18766.length;
switch (G__18768) {
case 1:
return cljs_time.internal.core.zero_pad.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.core.zero_pad.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18766.length)].join('')));

}
});

cljs_time.internal.core.zero_pad.cljs$core$IFn$_invoke$arity$1 = (function (n){
if((((0) <= n)) && ((n <= (9)))){
return [cljs.core.str("0"),cljs.core.str(n)].join('');
} else {
return [cljs.core.str(n)].join('');
}
});

cljs_time.internal.core.zero_pad.cljs$core$IFn$_invoke$arity$2 = (function (n,zeros){
if(((1) > zeros)){
return [cljs.core.str(n)].join('');
} else {
return [cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.take.cljs$core$IFn$_invoke$arity$2((zeros - cljs.core.count([cljs.core.str(n)].join(''))),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("0")))),cljs.core.str(n)].join('');
}
});

cljs_time.internal.core.zero_pad.cljs$lang$maxFixedArity = 2;
