// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('c2.maths');
goog.require('cljs.core');
c2.maths.Pi = Math.PI;
c2.maths.Tau = ((2) * c2.maths.Pi);
c2.maths.e = Math.E;
c2.maths.radians_per_degree = (c2.maths.Pi / (180));
c2.maths.rad = (function c2$maths$rad(x){
return (c2.maths.radians_per_degree * x);
});
c2.maths.deg = (function c2$maths$deg(x){
return (x / c2.maths.radians_per_degree);
});
c2.maths.sin = (function c2$maths$sin(x){
return Math.sin(x);
});
c2.maths.asin = (function c2$maths$asin(x){
return Math.asin(x);
});
c2.maths.cos = (function c2$maths$cos(x){
return Math.cos(x);
});
c2.maths.acos = (function c2$maths$acos(x){
return Math.acos(x);
});
c2.maths.tan = (function c2$maths$tan(x){
return Math.tan(x);
});
c2.maths.atan = (function c2$maths$atan(x){
return Math.atan(x);
});
c2.maths.expt = (function c2$maths$expt(var_args){
var args18942 = [];
var len__5627__auto___18945 = arguments.length;
var i__5628__auto___18946 = (0);
while(true){
if((i__5628__auto___18946 < len__5627__auto___18945)){
args18942.push((arguments[i__5628__auto___18946]));

var G__18947 = (i__5628__auto___18946 + (1));
i__5628__auto___18946 = G__18947;
continue;
} else {
}
break;
}

var G__18944 = args18942.length;
switch (G__18944) {
case 1:
return c2.maths.expt.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.maths.expt.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18942.length)].join('')));

}
});

c2.maths.expt.cljs$core$IFn$_invoke$arity$1 = (function (x){
return Math.exp(x);
});

c2.maths.expt.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return Math.pow(x,y);
});

c2.maths.expt.cljs$lang$maxFixedArity = 2;
c2.maths.sq = (function c2$maths$sq(x){
return c2.maths.expt.cljs$core$IFn$_invoke$arity$2(x,(2));
});
c2.maths.sqrt = (function c2$maths$sqrt(x){
return Math.sqrt(x);
});
c2.maths.floor = (function c2$maths$floor(x){
return Math.floor(x);
});
c2.maths.ceil = (function c2$maths$ceil(x){
return Math.ceil(x);
});
c2.maths.abs = (function c2$maths$abs(x){
return Math.abs(x);
});
c2.maths.log = (function c2$maths$log(var_args){
var args18949 = [];
var len__5627__auto___18952 = arguments.length;
var i__5628__auto___18953 = (0);
while(true){
if((i__5628__auto___18953 < len__5627__auto___18952)){
args18949.push((arguments[i__5628__auto___18953]));

var G__18954 = (i__5628__auto___18953 + (1));
i__5628__auto___18953 = G__18954;
continue;
} else {
}
break;
}

var G__18951 = args18949.length;
switch (G__18951) {
case 1:
return c2.maths.log.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.maths.log.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18949.length)].join('')));

}
});

c2.maths.log.cljs$core$IFn$_invoke$arity$1 = (function (x){
return Math.log(x);
});

c2.maths.log.cljs$core$IFn$_invoke$arity$2 = (function (base,x){
return (Math.log(x) / Math.log(base));
});

c2.maths.log.cljs$lang$maxFixedArity = 2;
c2.maths.log10 = (function c2$maths$log10(x){
return (Math.log(x) / Math.LN10);
});
/**
 * Returns 2-vector of min and max elements in xs.
 */
c2.maths.extent = (function c2$maths$extent(xs){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,xs),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,xs)], null);
});
/**
 * Arithemetic mean of collection
 */
c2.maths.mean = (function c2$maths$mean(xs){
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,xs) / cljs.core.count(xs));
});
/**
 * Median of a collection.
 */
c2.maths.median = (function c2$maths$median(xs){
var sorted = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(xs);
var n = cljs.core.count(xs);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(1))){
return cljs.core.first(sorted);
} else {
if(cljs.core.odd_QMARK_(n)){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(sorted,((n + (1)) / (2)));
} else {
var mid = (n / (2));
return c2.maths.mean(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.nth.cljs$core$IFn$_invoke$arity$2(sorted,c2.maths.floor(mid)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(sorted,c2.maths.ceil(mid))], null));

}
}
});
/**
 * Inclusive range; same as core/range, but includes the end.
 */
c2.maths.irange = (function c2$maths$irange(var_args){
var args18956 = [];
var len__5627__auto___18959 = arguments.length;
var i__5628__auto___18960 = (0);
while(true){
if((i__5628__auto___18960 < len__5627__auto___18959)){
args18956.push((arguments[i__5628__auto___18960]));

var G__18961 = (i__5628__auto___18960 + (1));
i__5628__auto___18960 = G__18961;
continue;
} else {
}
break;
}

var G__18958 = args18956.length;
switch (G__18958) {
case 1:
return c2.maths.irange.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.maths.irange.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.maths.irange.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18956.length)].join('')));

}
});

c2.maths.irange.cljs$core$IFn$_invoke$arity$1 = (function (start){
return cljs.core.range.cljs$core$IFn$_invoke$arity$1(start);
});

c2.maths.irange.cljs$core$IFn$_invoke$arity$2 = (function (start,end){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.range.cljs$core$IFn$_invoke$arity$2(start,end),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [end], null));
});

c2.maths.irange.cljs$core$IFn$_invoke$arity$3 = (function (start,end,step){
var r = cljs.core.range.cljs$core$IFn$_invoke$arity$3(start,end,step);
if((cljs.core.mod(cljs.core.first(r),step) === cljs.core.mod(end,step))){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(r,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [end], null));
} else {
return r;
}
});

c2.maths.irange.cljs$lang$maxFixedArity = 3;
/**
 * Checks if bottom <= x <= top.
 */
c2.maths.within_QMARK_ = (function c2$maths$within_QMARK_(x,p__18963){
var vec__18965 = p__18963;
var bottom = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18965,(0),null);
var top = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18965,(1),null);
return ((bottom <= x)) && ((x <= top));
});
c2.maths.add = (function c2$maths$add(var_args){
var args__5634__auto__ = [];
var len__5627__auto___18967 = arguments.length;
var i__5628__auto___18968 = (0);
while(true){
if((i__5628__auto___18968 < len__5627__auto___18967)){
args__5634__auto__.push((arguments[i__5628__auto___18968]));

var G__18969 = (i__5628__auto___18968 + (1));
i__5628__auto___18968 = G__18969;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return c2.maths.add.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

c2.maths.add.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A + B);
} else {
if((cljs.core.coll_QMARK_(A)) && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,cljs.core.replicate(cljs.core.count(B),A),B);
} else {
if((cljs.core.coll_QMARK_(A)) && (typeof B === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,A,cljs.core.replicate(cljs.core.count(A),B));
} else {
return null;
}
}
}
}
}),args);
});

c2.maths.add.cljs$lang$maxFixedArity = (0);

c2.maths.add.cljs$lang$applyTo = (function (seq18966){
return c2.maths.add.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18966));
});
c2.maths.sub = (function c2$maths$sub(var_args){
var args__5634__auto__ = [];
var len__5627__auto___18971 = arguments.length;
var i__5628__auto___18972 = (0);
while(true){
if((i__5628__auto___18972 < len__5627__auto___18971)){
args__5634__auto__.push((arguments[i__5628__auto___18972]));

var G__18973 = (i__5628__auto___18972 + (1));
i__5628__auto___18972 = G__18973;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return c2.maths.sub.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

c2.maths.sub.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(args),(1))){
if((typeof (0) === 'number') && (typeof cljs.core.first(args) === 'number')){
return ((0) - cljs.core.first(args));
} else {
if((cljs.core.coll_QMARK_((0))) && (cljs.core.coll_QMARK_(cljs.core.first(args)))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,(0),cljs.core.first(args));
} else {
if((typeof (0) === 'number') && (cljs.core.coll_QMARK_(cljs.core.first(args)))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,cljs.core.replicate(cljs.core.count(cljs.core.first(args)),(0)),cljs.core.first(args));
} else {
if((cljs.core.coll_QMARK_((0))) && (typeof cljs.core.first(args) === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,(0),cljs.core.replicate(cljs.core.count((0)),cljs.core.first(args)));
} else {
return null;
}
}
}
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A - B);
} else {
if((cljs.core.coll_QMARK_(A)) && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,cljs.core.replicate(cljs.core.count(B),A),B);
} else {
if((cljs.core.coll_QMARK_(A)) && (typeof B === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,A,cljs.core.replicate(cljs.core.count(A),B));
} else {
return null;
}
}
}
}
}),args);
}
});

c2.maths.sub.cljs$lang$maxFixedArity = (0);

c2.maths.sub.cljs$lang$applyTo = (function (seq18970){
return c2.maths.sub.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18970));
});
c2.maths.mul = (function c2$maths$mul(var_args){
var args__5634__auto__ = [];
var len__5627__auto___18975 = arguments.length;
var i__5628__auto___18976 = (0);
while(true){
if((i__5628__auto___18976 < len__5627__auto___18975)){
args__5634__auto__.push((arguments[i__5628__auto___18976]));

var G__18977 = (i__5628__auto___18976 + (1));
i__5628__auto___18976 = G__18977;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return c2.maths.mul.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

c2.maths.mul.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A * B);
} else {
if((cljs.core.coll_QMARK_(A)) && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,cljs.core.replicate(cljs.core.count(B),A),B);
} else {
if((cljs.core.coll_QMARK_(A)) && (typeof B === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,A,cljs.core.replicate(cljs.core.count(A),B));
} else {
return null;
}
}
}
}
}),args);
});

c2.maths.mul.cljs$lang$maxFixedArity = (0);

c2.maths.mul.cljs$lang$applyTo = (function (seq18974){
return c2.maths.mul.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18974));
});
c2.maths.div = (function c2$maths$div(var_args){
var args__5634__auto__ = [];
var len__5627__auto___18979 = arguments.length;
var i__5628__auto___18980 = (0);
while(true){
if((i__5628__auto___18980 < len__5627__auto___18979)){
args__5634__auto__.push((arguments[i__5628__auto___18980]));

var G__18981 = (i__5628__auto___18980 + (1));
i__5628__auto___18980 = G__18981;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return c2.maths.div.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

c2.maths.div.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(args),(1))){
if((typeof (1) === 'number') && (typeof cljs.core.first(args) === 'number')){
return ((1) / cljs.core.first(args));
} else {
if((cljs.core.coll_QMARK_((1))) && (cljs.core.coll_QMARK_(cljs.core.first(args)))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(1),cljs.core.first(args));
} else {
if((typeof (1) === 'number') && (cljs.core.coll_QMARK_(cljs.core.first(args)))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,cljs.core.replicate(cljs.core.count(cljs.core.first(args)),(1)),cljs.core.first(args));
} else {
if((cljs.core.coll_QMARK_((1))) && (typeof cljs.core.first(args) === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(1),cljs.core.replicate(cljs.core.count((1)),cljs.core.first(args)));
} else {
return null;
}
}
}
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A / B);
} else {
if((cljs.core.coll_QMARK_(A)) && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,cljs.core.replicate(cljs.core.count(B),A),B);
} else {
if((cljs.core.coll_QMARK_(A)) && (typeof B === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,A,cljs.core.replicate(cljs.core.count(A),B));
} else {
return null;
}
}
}
}
}),args);
}
});

c2.maths.div.cljs$lang$maxFixedArity = (0);

c2.maths.div.cljs$lang$applyTo = (function (seq18978){
return c2.maths.div.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18978));
});
/**
 * Returns the quantiles of a dataset.
 * 
 * Kwargs:
 * 
 *   > *:probs*: ntiles of the data to return, defaults to `[0 0.25 0.5 0.75 1]`
 * 
 *   Algorithm is the same as R's quantile type=7.
 *   Transcribed from Jason Davies; https://github.com/jasondavies/science.js/blob/master/src/stats/quantiles.js
 */
c2.maths.quantile = (function c2$maths$quantile(var_args){
var args__5634__auto__ = [];
var len__5627__auto___18997 = arguments.length;
var i__5628__auto___18998 = (0);
while(true){
if((i__5628__auto___18998 < len__5627__auto___18997)){
args__5634__auto__.push((arguments[i__5628__auto___18998]));

var G__18999 = (i__5628__auto___18998 + (1));
i__5628__auto___18998 = G__18999;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return c2.maths.quantile.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

c2.maths.quantile.cljs$core$IFn$_invoke$arity$variadic = (function (data,p__18984){
var map__18985 = p__18984;
var map__18985__$1 = ((((!((map__18985 == null)))?((((map__18985.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18985.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18985):map__18985);
var probs = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18985__$1,cljs.core.cst$kw$probs,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),0.25,0.5,0.75,(1)], null));
var xs = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.sort.cljs$core$IFn$_invoke$arity$1(data));
var n_1 = (cljs.core.count(xs) - (1));
var iter__5341__auto__ = ((function (xs,n_1,map__18985,map__18985__$1,probs){
return (function c2$maths$iter__18987(s__18988){
return (new cljs.core.LazySeq(null,((function (xs,n_1,map__18985,map__18985__$1,probs){
return (function (){
var s__18988__$1 = s__18988;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__18988__$1);
if(temp__4425__auto__){
var s__18988__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__18988__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__18988__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__18990 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__18989 = (0);
while(true){
if((i__18989 < size__5340__auto__)){
var q = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__18989);
cljs.core.chunk_append(b__18990,(function (){var index = ((q * n_1) + (1));
var lo = (c2.maths.floor(index) | (0));
var h = (index - lo);
var a = (function (){var G__18995 = (lo - (1));
return (xs.cljs$core$IFn$_invoke$arity$1 ? xs.cljs$core$IFn$_invoke$arity$1(G__18995) : xs.call(null,G__18995));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(h,(0))){
return a;
} else {
return (a + (h * ((xs.cljs$core$IFn$_invoke$arity$1 ? xs.cljs$core$IFn$_invoke$arity$1(lo) : xs.call(null,lo)) - a)));
}
})());

var G__19000 = (i__18989 + (1));
i__18989 = G__19000;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18990),c2$maths$iter__18987(cljs.core.chunk_rest(s__18988__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18990),null);
}
} else {
var q = cljs.core.first(s__18988__$2);
return cljs.core.cons((function (){var index = ((q * n_1) + (1));
var lo = (c2.maths.floor(index) | (0));
var h = (index - lo);
var a = (function (){var G__18996 = (lo - (1));
return (xs.cljs$core$IFn$_invoke$arity$1 ? xs.cljs$core$IFn$_invoke$arity$1(G__18996) : xs.call(null,G__18996));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(h,(0))){
return a;
} else {
return (a + (h * ((xs.cljs$core$IFn$_invoke$arity$1 ? xs.cljs$core$IFn$_invoke$arity$1(lo) : xs.call(null,lo)) - a)));
}
})(),c2$maths$iter__18987(cljs.core.rest(s__18988__$2)));
}
} else {
return null;
}
break;
}
});})(xs,n_1,map__18985,map__18985__$1,probs))
,null,null));
});})(xs,n_1,map__18985,map__18985__$1,probs))
;
return iter__5341__auto__(probs);
});

c2.maths.quantile.cljs$lang$maxFixedArity = (1);

c2.maths.quantile.cljs$lang$applyTo = (function (seq18982){
var G__18983 = cljs.core.first(seq18982);
var seq18982__$1 = cljs.core.next(seq18982);
return c2.maths.quantile.cljs$core$IFn$_invoke$arity$variadic(G__18983,seq18982__$1);
});
