// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});
c2.dom.select;

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__5224__auto__ = (((x == null))?null:x);
var m__5225__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__5225__auto__.call(null,x));
} else {
var m__5225__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__5225__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return (c2.dom.select.cljs$core$IFn$_invoke$arity$1 ? c2.dom.select.cljs$core$IFn$_invoke$arity$1(selector) : c2.dom.select.call(null,selector));
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render(v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args26772 = [];
var len__5627__auto___26775 = arguments.length;
var i__5628__auto___26776 = (0);
while(true){
if((i__5628__auto___26776 < len__5627__auto___26775)){
args26772.push((arguments[i__5628__auto___26776]));

var G__26777 = (i__5628__auto___26776 + (1));
i__5628__auto___26776 = G__26777;
continue;
} else {
}
break;
}

var G__26774 = args26772.length;
switch (G__26774) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26772.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;
/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args26779 = [];
var len__5627__auto___26782 = arguments.length;
var i__5628__auto___26783 = (0);
while(true){
if((i__5628__auto___26783 < len__5627__auto___26782)){
args26779.push((arguments[i__5628__auto___26783]));

var G__26784 = (i__5628__auto___26783 + (1));
i__5628__auto___26783 = G__26784;
continue;
} else {
}
break;
}

var G__26781 = args26779.length;
switch (G__26781) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26779.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;
/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom(node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom(node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__26788_26790 = c2.dom.__GT_dom(container);
var G__26789_26791 = el__$1;
goog.dom.appendChild(G__26788_26790,G__26789_26791);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__26795_26798 = c2.dom.__GT_dom(container);
var G__26796_26799 = el__$1;
var G__26797_26800 = (0);
goog.dom.insertChildAt(G__26795_26798,G__26796_26799,G__26797_26800);

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
var G__26802 = c2.dom.__GT_dom(el);
return goog.dom.removeNode(G__26802);
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom(new$);
var G__26805_26807 = new$__$1;
var G__26806_26808 = c2.dom.__GT_dom(old);
goog.dom.replaceNode(G__26805_26807,G__26806_26808);

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args26809 = [];
var len__5627__auto___26823 = arguments.length;
var i__5628__auto___26824 = (0);
while(true){
if((i__5628__auto___26824 < len__5627__auto___26823)){
args26809.push((arguments[i__5628__auto___26824]));

var G__26825 = (i__5628__auto___26824 + (1));
i__5628__auto___26824 = G__26825;
continue;
} else {
}
break;
}

var G__26811 = args26809.length;
switch (G__26811) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26809.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
var G__26812 = el__$1;
var G__26813 = cljs.core.name(x);
return goog.style.getComputedStyle(G__26812,G__26813);
} else {
if(cljs.core.map_QMARK_(x)){
var seq__26814_26827 = cljs.core.seq(x);
var chunk__26815_26828 = null;
var count__26816_26829 = (0);
var i__26817_26830 = (0);
while(true){
if((i__26817_26830 < count__26816_26829)){
var vec__26818_26831 = chunk__26815_26828.cljs$core$IIndexed$_nth$arity$2(null,i__26817_26830);
var k_26832 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26818_26831,(0),null);
var v_26833 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26818_26831,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_26832,v_26833);

var G__26834 = seq__26814_26827;
var G__26835 = chunk__26815_26828;
var G__26836 = count__26816_26829;
var G__26837 = (i__26817_26830 + (1));
seq__26814_26827 = G__26834;
chunk__26815_26828 = G__26835;
count__26816_26829 = G__26836;
i__26817_26830 = G__26837;
continue;
} else {
var temp__4425__auto___26838 = cljs.core.seq(seq__26814_26827);
if(temp__4425__auto___26838){
var seq__26814_26839__$1 = temp__4425__auto___26838;
if(cljs.core.chunked_seq_QMARK_(seq__26814_26839__$1)){
var c__5372__auto___26840 = cljs.core.chunk_first(seq__26814_26839__$1);
var G__26841 = cljs.core.chunk_rest(seq__26814_26839__$1);
var G__26842 = c__5372__auto___26840;
var G__26843 = cljs.core.count(c__5372__auto___26840);
var G__26844 = (0);
seq__26814_26827 = G__26841;
chunk__26815_26828 = G__26842;
count__26816_26829 = G__26843;
i__26817_26830 = G__26844;
continue;
} else {
var vec__26819_26845 = cljs.core.first(seq__26814_26839__$1);
var k_26846 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26819_26845,(0),null);
var v_26847 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26819_26845,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_26846,v_26847);

var G__26848 = cljs.core.next(seq__26814_26839__$1);
var G__26849 = null;
var G__26850 = (0);
var G__26851 = (0);
seq__26814_26827 = G__26848;
chunk__26815_26828 = G__26849;
count__26816_26829 = G__26850;
i__26817_26830 = G__26851;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var G__26820_26852 = c2.dom.__GT_dom(el);
var G__26821_26853 = cljs.core.name(k);
var G__26822_26854 = ((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$bottom,null,cljs.core.cst$kw$top,null,cljs.core.cst$kw$width,null,cljs.core.cst$kw$right,null,cljs.core.cst$kw$height,null,cljs.core.cst$kw$left,null], null), null).call(null,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null));
goog.style.setStyle(G__26820_26852,G__26821_26853,G__26822_26854);

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args26855 = [];
var len__5627__auto___26870 = arguments.length;
var i__5628__auto___26871 = (0);
while(true){
if((i__5628__auto___26871 < len__5627__auto___26870)){
args26855.push((arguments[i__5628__auto___26871]));

var G__26872 = (i__5628__auto___26871 + (1));
i__5628__auto___26871 = G__26872;
continue;
} else {
}
break;
}

var G__26857 = args26855.length;
switch (G__26857) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26855.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom(el).attributes;
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5341__auto__ = ((function (attrs){
return (function c2$dom$iter__26858(s__26859){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__26859__$1 = s__26859;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__26859__$1);
if(temp__4425__auto__){
var s__26859__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__26859__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__26859__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__26861 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__26860 = (0);
while(true){
if((i__26860 < size__5340__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__26860);
cljs.core.chunk_append(b__26861,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null));

var G__26874 = (i__26860 + (1));
i__26860 = G__26874;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__26861),c2$dom$iter__26858(cljs.core.chunk_rest(s__26859__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__26861),null);
}
} else {
var i = cljs.core.first(s__26859__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__26858(cljs.core.rest(s__26859__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__5341__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name(x));
} else {
if(cljs.core.map_QMARK_(x)){
var seq__26864_26875 = cljs.core.seq(x);
var chunk__26865_26876 = null;
var count__26866_26877 = (0);
var i__26867_26878 = (0);
while(true){
if((i__26867_26878 < count__26866_26877)){
var vec__26868_26879 = chunk__26865_26876.cljs$core$IIndexed$_nth$arity$2(null,i__26867_26878);
var k_26880 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26868_26879,(0),null);
var v_26881 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26868_26879,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_26880,v_26881);

var G__26882 = seq__26864_26875;
var G__26883 = chunk__26865_26876;
var G__26884 = count__26866_26877;
var G__26885 = (i__26867_26878 + (1));
seq__26864_26875 = G__26882;
chunk__26865_26876 = G__26883;
count__26866_26877 = G__26884;
i__26867_26878 = G__26885;
continue;
} else {
var temp__4425__auto___26886 = cljs.core.seq(seq__26864_26875);
if(temp__4425__auto___26886){
var seq__26864_26887__$1 = temp__4425__auto___26886;
if(cljs.core.chunked_seq_QMARK_(seq__26864_26887__$1)){
var c__5372__auto___26888 = cljs.core.chunk_first(seq__26864_26887__$1);
var G__26889 = cljs.core.chunk_rest(seq__26864_26887__$1);
var G__26890 = c__5372__auto___26888;
var G__26891 = cljs.core.count(c__5372__auto___26888);
var G__26892 = (0);
seq__26864_26875 = G__26889;
chunk__26865_26876 = G__26890;
count__26866_26877 = G__26891;
i__26867_26878 = G__26892;
continue;
} else {
var vec__26869_26893 = cljs.core.first(seq__26864_26887__$1);
var k_26894 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26869_26893,(0),null);
var v_26895 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26869_26893,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_26894,v_26895);

var G__26896 = cljs.core.next(seq__26864_26887__$1);
var G__26897 = null;
var G__26898 = (0);
var G__26899 = (0);
seq__26864_26875 = G__26896;
chunk__26865_26876 = G__26897;
count__26866_26877 = G__26898;
i__26867_26878 = G__26899;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom(el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name(k));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$style,k)){
c2.dom.style.cljs$core$IFn$_invoke$arity$2(el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name(k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args26900 = [];
var len__5627__auto___26904 = arguments.length;
var i__5628__auto___26905 = (0);
while(true){
if((i__5628__auto___26905 < len__5627__auto___26904)){
args26900.push((arguments[i__5628__auto___26905]));

var G__26906 = (i__5628__auto___26905 + (1));
i__5628__auto___26905 = G__26906;
continue;
} else {
}
break;
}

var G__26902 = args26900.length;
switch (G__26902) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26900.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__26903 = c2.dom.__GT_dom(el);
return goog.dom.getTextContent(G__26903);
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;
/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args26908 = [];
var len__5627__auto___26912 = arguments.length;
var i__5628__auto___26913 = (0);
while(true){
if((i__5628__auto___26913 < len__5627__auto___26912)){
args26908.push((arguments[i__5628__auto___26913]));

var G__26914 = (i__5628__auto___26913 + (1));
i__5628__auto___26913 = G__26914;
continue;
} else {
}
break;
}

var G__26910 = args26908.length;
switch (G__26910) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26908.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__26911 = c2.dom.__GT_dom(el);
return goog.dom.forms.getValue(G__26911);
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;
/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
var G__26919_26922 = c2.dom.__GT_dom(el);
var G__26920_26923 = cljs.core.name(class$);
var G__26921_26924 = classed_QMARK_;
goog.dom.classes.enable(G__26919_26922,G__26920_26923,G__26921_26924);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__4569__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var or__4569__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__4569__auto____$1)){
return or__4569__auto____$1;
} else {
return ((function (or__4569__auto____$1,or__4569__auto__){
return (function (p1__26925_SHARP_){
var G__26926 = ((function (or__4569__auto____$1,or__4569__auto__){
return (function (){
return (p1__26925_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p1__26925_SHARP_.cljs$core$IFn$_invoke$arity$0() : p1__26925_SHARP_.call(null));
});})(or__4569__auto____$1,or__4569__auto__))
;
var G__26927 = (10);
return setTimeout(G__26926,G__26927);
});
;})(or__4569__auto____$1,or__4569__auto__))
}
}
})();
