// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('chimera.string');
goog.require('cljs.core');
goog.require('chimera.core');
goog.require('clojure.string');
goog.require('cljs.pprint');
chimera.string.email_regex = /^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,6}$/i;
chimera.string.twitter_username_regex = /^[A-Za-z0-9_]*$/;
chimera.string.domain_name_regex = /([a-z0-9|-]+\.)*[a-z0-9|-]+\.[a-z]+/;
chimera.string.truncate_if_longer_than = (50);
chimera.string.ellipsis_start = (36);
chimera.string.ellipsis_stop_from_end = (12);
/**
 * Return true if string value is true else false
 */
chimera.string.str_is_true_QMARK_ = (function chimera$string$str_is_true_QMARK_(value){
var and__6531__auto__ = value;
if(cljs.core.truth_(and__6531__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clojure.string.lower_case(value),"true");
} else {
return and__6531__auto__;
}
});
chimera.string.chars__GT_entities = new cljs.core.PersistentArrayMap(null, 5, ["<","&lt;",">","&gt;","&","&amp;","\"","&quot;","'","&#39;"], null);
chimera.string.vowel_QMARK_ = cljs.core.set("aeiou");
chimera.string.parenthesize_suffix = (function chimera$string$parenthesize_suffix(prefix,suffix){
return [cljs.core.str(prefix),cljs.core.str(" ("),cljs.core.str(suffix),cljs.core.str(")")].join('');
});
/**
 * Shorten a string to a certain length with middle ellipsis.
 */
chimera.string.truncate_with_ellipsis = (function chimera$string$truncate_with_ellipsis(s){
if((cljs.core.count(s) > chimera.string.truncate_if_longer_than)){
var end_start = (cljs.core.count(s) - chimera.string.ellipsis_stop_from_end);
return [cljs.core.str(cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,(0),chimera.string.ellipsis_start)),cljs.core.str("..."),cljs.core.str(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,end_start))].join('');
} else {
return s;
}
});
/**
 * Return the first character of a string capitalized.
 */
chimera.string.first_cap = (function chimera$string$first_cap(s){
return clojure.string.capitalize([cljs.core.str(cljs.core.first(s))].join(''));
});
/**
 * True if `s` is an email address.
 */
chimera.string.is_email_QMARK_ = (function chimera$string$is_email_QMARK_(s){
return cljs.core.first(s.match(chimera.string.email_regex));
});
/**
 * True if `s` is a valid twitter username
 */
chimera.string.is_twitter_username_QMARK_ = (function chimera$string$is_twitter_username_QMARK_(s){
return cljs.core.first(s.match(chimera.string.twitter_username_regex));
});
/**
 * Wrap the count of a collection in parens and postfix.
 */
chimera.string.postfix_paren_count = (function chimera$string$postfix_paren_count(prefix,collection){
return chimera.string.parenthesize_suffix(prefix,cljs.core.count(collection));
});
/**
 * True if `s` ends with the passed suffix.
 */
chimera.string.ends_with_QMARK_ = (function chimera$string$ends_with_QMARK_(s,suffix){
var offset = (cljs.core.count(s) - cljs.core.count(suffix));
return ((offset >= (0))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(suffix,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,offset)));
});
/**
 * Serialize a Clojure map to JavaScript string map.
 */
chimera.string.map__GT_js_string_map = (function chimera$string$map__GT_js_string_map(m){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.flatten(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["{",cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",(function (){var iter__7326__auto__ = (function chimera$string$map__GT_js_string_map_$_iter__45954(s__45955){
return (new cljs.core.LazySeq(null,(function (){
var s__45955__$1 = s__45955;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__45955__$1);
if(temp__4657__auto__){
var s__45955__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__45955__$2)){
var c__7324__auto__ = cljs.core.chunk_first(s__45955__$2);
var size__7325__auto__ = cljs.core.count(c__7324__auto__);
var b__45957 = cljs.core.chunk_buffer(size__7325__auto__);
if((function (){var i__45956 = (0);
while(true){
if((i__45956 < size__7325__auto__)){
var vec__45966 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7324__auto__,i__45956);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45966,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45966,(1),null);
cljs.core.chunk_append(b__45957,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["\"",cljs.core.name(k),"\":\"",v,"\""], null));

var G__45972 = (i__45956 + (1));
i__45956 = G__45972;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__45957),chimera$string$map__GT_js_string_map_$_iter__45954(cljs.core.chunk_rest(s__45955__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__45957),null);
}
} else {
var vec__45969 = cljs.core.first(s__45955__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45969,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45969,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["\"",cljs.core.name(k),"\":\"",v,"\""], null),chimera$string$map__GT_js_string_map_$_iter__45954(cljs.core.rest(s__45955__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7326__auto__(m);
})()),"}"], null)));
});
/**
 * True if the first letter of `s` is a vowel.
 */
chimera.string.begins_with_vowel_QMARK_ = (function chimera$string$begins_with_vowel_QMARK_(s){
var G__45974 = cljs.core.first(clojure.string.lower_case(cljs.core.first(s)));
return (chimera.string.vowel_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.vowel_QMARK_.cljs$core$IFn$_invoke$arity$1(G__45974) : chimera.string.vowel_QMARK_.call(null,G__45974));
});
/**
 * If `s` is a string and equal to 'false' in lower case return false,
 * otherwise return `s`.
 */
chimera.string.false_str__GT_false = (function chimera$string$false_str__GT_false(s){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((function (){var and__6531__auto__ = typeof s === 'string';
if(and__6531__auto__){
return clojure.string.lower_case(s);
} else {
return and__6531__auto__;
}
})(),"false")){
return false;
} else {
return s;
}
});
/**
 * Render a JSON error as a string for the user.
 */
chimera.string.error_json__GT_str = (function chimera$string$error_json__GT_str(json){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("<br/>",(function (){var iter__7326__auto__ = (function chimera$string$error_json__GT_str_$_iter__45997(s__45998){
return (new cljs.core.LazySeq(null,(function (){
var s__45998__$1 = s__45998;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__45998__$1);
if(temp__4657__auto__){
var s__45998__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__45998__$2)){
var c__7324__auto__ = cljs.core.chunk_first(s__45998__$2);
var size__7325__auto__ = cljs.core.count(c__7324__auto__);
var b__46000 = cljs.core.chunk_buffer(size__7325__auto__);
if((function (){var i__45999 = (0);
while(true){
if((i__45999 < size__7325__auto__)){
var vec__46011 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7324__auto__,i__45999);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46011,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46011,(1),null);
var key = clojure.string.capitalize(cljs.core.name(k));
var value = (function (){var G__46014 = v;
if(cljs.core.vector_QMARK_(v)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__46014);
} else {
return G__46014;
}
})();
cljs.core.chunk_append(b__46000,[cljs.core.str(key),cljs.core.str(": "),cljs.core.str(value)].join(''));

var G__46019 = (i__45999 + (1));
i__45999 = G__46019;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__46000),chimera$string$error_json__GT_str_$_iter__45997(cljs.core.chunk_rest(s__45998__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__46000),null);
}
} else {
var vec__46015 = cljs.core.first(s__45998__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46015,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46015,(1),null);
var key = clojure.string.capitalize(cljs.core.name(k));
var value = (function (){var G__46018 = v;
if(cljs.core.vector_QMARK_(v)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__46018);
} else {
return G__46018;
}
})();
return cljs.core.cons([cljs.core.str(key),cljs.core.str(": "),cljs.core.str(value)].join(''),chimera$string$error_json__GT_str_$_iter__45997(cljs.core.rest(s__45998__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7326__auto__(json);
})());
});
/**
 * Build an unescaped string.
 */
chimera.string.unescape = (function chimera$string$unescape(s){
if(typeof s === 'string'){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (r,p__46024){
var vec__46025 = p__46024;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46025,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46025,(1),null);
return clojure.string.replace(r,cljs.core.re_pattern(v),[cljs.core.str(k)].join(''));
}),s,chimera.string.chars__GT_entities);
} else {
return s;
}
});
/**
 * Checks if a variable is null
 */
chimera.string.is_null_QMARK_ = (function chimera$string$is_null_QMARK_(s){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("null",s);
});
/**
 * Checks if a variable is null or nil
 */
chimera.string.is_null_or_nil_QMARK_ = (function chimera$string$is_null_or_nil_QMARK_(s){
var or__6543__auto__ = chimera.string.is_null_QMARK_(s);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return (s == null);
}
});
chimera.string.is_not_null_QMARK_ = cljs.core.complement(chimera.string.is_null_QMARK_);
chimera.string.safe_lower_case = (function chimera$string$safe_lower_case(str){
if(typeof str === 'string'){
return clojure.string.lower_case(str);
} else {
return null;
}
});
/**
 * True if substring is a substring of `s`
 */
chimera.string.substring_QMARK_ = (function chimera$string$substring_QMARK_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___46035 = arguments.length;
var i__7652__auto___46036 = (0);
while(true){
if((i__7652__auto___46036 < len__7651__auto___46035)){
args__7658__auto__.push((arguments[i__7652__auto___46036]));

var G__46037 = (i__7652__auto___46036 + (1));
i__7652__auto___46036 = G__46037;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (substring,s,p__46031){
var map__46032 = p__46031;
var map__46032__$1 = ((((!((map__46032 == null)))?((((map__46032.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46032.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46032):map__46032);
var case_sensitive_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__46032__$1,cljs.core.cst$kw$case_DASH_sensitive_QMARK_,true);
if(cljs.core.truth_((function (){var or__6543__auto__ = cljs.core.empty_QMARK_(s);
if(or__6543__auto__){
return or__6543__auto__;
} else {
return chimera.string.is_null_QMARK_(s);
}
})())){
return false;
} else {
var G__46034 = cljs.core.re_find(cljs.core.re_pattern([cljs.core.str((cljs.core.truth_(case_sensitive_QMARK_)?null:"(?i)")),cljs.core.str(substring)].join('')),s);
return (chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(G__46034) : chimera.core.not_nil_QMARK_.call(null,G__46034));
}
});

chimera.string.substring_QMARK_.cljs$lang$maxFixedArity = (2);

chimera.string.substring_QMARK_.cljs$lang$applyTo = (function (seq46028){
var G__46029 = cljs.core.first(seq46028);
var seq46028__$1 = cljs.core.next(seq46028);
var G__46030 = cljs.core.first(seq46028__$1);
var seq46028__$2 = cljs.core.next(seq46028__$1);
return chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__46029,G__46030,seq46028__$2);
});

/**
 * Insert a comma into numbers in thousands and higher
 */
chimera.string.humanize_number = (function chimera$string$humanize_number(n){
return cljs.pprint.cl_format.cljs$core$IFn$_invoke$arity$variadic(null,"~:d",cljs.core.array_seq([n], 0));
});
/**
 * Escape for types. Replaces characters in the string with this base on
 *   chars->entities map.
 */
chimera.string.escape_for_type = (function chimera$string$escape_for_type(x){
if((x == null)){
return "null";
} else {
if(typeof x === 'string'){
return clojure.string.escape(x,chimera.string.chars__GT_entities);
} else {
return x;

}
}
});
chimera.string.get_query_params_str = (function chimera$string$get_query_params_str(var_args){
var args__7658__auto__ = [];
var len__7651__auto___46045 = arguments.length;
var i__7652__auto___46046 = (0);
while(true){
if((i__7652__auto___46046 < len__7651__auto___46045)){
args__7658__auto__.push((arguments[i__7652__auto___46046]));

var G__46047 = (i__7652__auto___46046 + (1));
i__7652__auto___46046 = G__46047;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return chimera.string.get_query_params_str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

chimera.string.get_query_params_str.cljs$core$IFn$_invoke$arity$variadic = (function (query_params_map,p__46040){
var vec__46041 = p__46040;
var query_param_str = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46041,(0),null);

var query_param_str__$1 = [cljs.core.str(query_param_str)].join('');
var query_param_str_blank_QMARK_ = clojure.string.blank_QMARK_(query_param_str__$1);
var key = cljs.core.first(cljs.core.keys(query_params_map));
var query_param_key = cljs.core.name((function (){var or__6543__auto__ = key;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return "";
}
})());
var query_param_val = (function (){var and__6531__auto__ = key;
if(cljs.core.truth_(and__6531__auto__)){
return (key.cljs$core$IFn$_invoke$arity$1 ? key.cljs$core$IFn$_invoke$arity$1(query_params_map) : key.call(null,query_params_map));
} else {
return and__6531__auto__;
}
})();
var G__46044 = cljs.core.count(query_params_map);
switch (G__46044) {
case (0):
return "";

break;
case (1):
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(((query_param_str_blank_QMARK_)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?",query_param_key,"=",query_param_val], null):new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [query_param_str__$1,"&",query_param_key,"=",query_param_val], null)));

break;
default:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(chimera.string.get_query_params_str,((query_param_str_blank_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [query_params_map,[cljs.core.str("?")].join('')], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.rest(query_params_map)),(function (){var new_query_param_str = [cljs.core.str(query_param_str__$1),cljs.core.str(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query_param_str__$1,"?"))?null:"&")),cljs.core.str(query_param_key),cljs.core.str("="),cljs.core.str(query_param_val)].join('');
return new_query_param_str;
})()], null)));

}
});

chimera.string.get_query_params_str.cljs$lang$maxFixedArity = (1);

chimera.string.get_query_params_str.cljs$lang$applyTo = (function (seq46038){
var G__46039 = cljs.core.first(seq46038);
var seq46038__$1 = cljs.core.next(seq46038);
return chimera.string.get_query_params_str.cljs$core$IFn$_invoke$arity$variadic(G__46039,seq46038__$1);
});

