// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core');
goog.require('goog.math.Long');
goog.require('goog.math.Integer');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.array');
goog.require('goog.string.StringBuffer');
cljs.core._STAR_clojurescript_version_STAR_ = "1.9.293";
cljs.core._STAR_unchecked_if_STAR_ = false;
if(typeof cljs.core.PROTOCOL_SENTINEL !== 'undefined'){
} else {
cljs.core.PROTOCOL_SENTINEL = ({});
}

/** @define {string} */
goog.define("cljs.core._STAR_target_STAR_","default");
/**
 * Var bound to the current namespace. Only used for bootstrapping.
 * @type {*}
 */
cljs.core._STAR_ns_STAR_ = null;
/**
 * @type {*}
 */
cljs.core._STAR_out_STAR_ = null;
cljs.core._STAR_assert_STAR_ = true;
if(typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined'){
} else {
/**
 * Each runtime environment provides a different way to print output.
 *   Whatever function *print-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_fn_STAR_ = (function cljs$core$_STAR_print_fn_STAR_(_){
throw (new Error("No *print-fn* fn set for evaluation environment"));
});
}
if(typeof cljs.core._STAR_print_err_fn_STAR_ !== 'undefined'){
} else {
/**
 * Each runtime environment provides a different way to print error output.
 *   Whatever function *print-err-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_err_fn_STAR_ = (function cljs$core$_STAR_print_err_fn_STAR_(_){
throw (new Error("No *print-err-fn* fn set for evaluation environment"));
});
}
/**
 * Set *print-fn* to f.
 */
cljs.core.set_print_fn_BANG_ = (function cljs$core$set_print_fn_BANG_(f){
return cljs.core._STAR_print_fn_STAR_ = f;
});
/**
 * Set *print-err-fn* to f.
 */
cljs.core.set_print_err_fn_BANG_ = (function cljs$core$set_print_err_fn_BANG_(f){
return cljs.core._STAR_print_err_fn_STAR_ = f;
});
/**
 * When set to true, output will be flushed whenever a newline is printed.
 * 
 *   Defaults to true.
 */
cljs.core._STAR_flush_on_newline_STAR_ = true;
/**
 * When set to logical false will drop newlines from printing calls.
 *   This is to work around the implicit newlines emitted by standard JavaScript
 *   console objects.
 */
cljs.core._STAR_print_newline_STAR_ = true;
/**
 * When set to logical false, strings and characters will be printed with
 *   non-alphanumeric characters converted to the appropriate escape sequences.
 * 
 *   Defaults to true
 */
cljs.core._STAR_print_readably_STAR_ = true;
/**
 * If set to logical true, when printing an object, its metadata will also
 *   be printed in a form that can be read back by the reader.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_meta_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 *   their type when read in later.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_dup_STAR_ = false;
/**
 * *print-length* controls how many items of each collection the
 *   printer will print. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   number of items of each collection to print. If a collection contains
 *   more items, the printer will print items up to the limit followed by
 *   '...' to represent the remaining items. The root binding is nil
 *   indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_length_STAR_ = null;
/**
 * *print-level* controls how many levels deep the printer will
 *   print nested objects. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   level to print. Each argument to print is at level 0; if an argument is a
 *   collection, its items are at level 1; and so on. If an object is a
 *   collection and is at a level greater than or equal to the value bound to
 *   *print-level*, the printer prints '#' to represent it. The root binding
 *   is nil indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_level_STAR_ = null;
if(typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined'){
} else {
/**
 * @type {*}
 */
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function cljs$core$pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$flush_DASH_on_DASH_newline,cljs.core._STAR_flush_on_newline_STAR_,cljs.core.cst$kw$readably,cljs.core._STAR_print_readably_STAR_,cljs.core.cst$kw$meta,cljs.core._STAR_print_meta_STAR_,cljs.core.cst$kw$dup,cljs.core._STAR_print_dup_STAR_,cljs.core.cst$kw$print_DASH_length,cljs.core._STAR_print_length_STAR_], null);
});
/**
 * Set *print-fn* to console.log
 */
cljs.core.enable_console_print_BANG_ = (function cljs$core$enable_console_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core._STAR_print_fn_STAR_ = (function() { 
var G__22343__delegate = function (args){
return console.log.apply(console,(cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args) : cljs.core.into_array.call(null,args)));
};
var G__22343 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__22344__i = 0, G__22344__a = new Array(arguments.length -  0);
while (G__22344__i < G__22344__a.length) {G__22344__a[G__22344__i] = arguments[G__22344__i + 0]; ++G__22344__i;}
  args = new cljs.core.IndexedSeq(G__22344__a,0);
} 
return G__22343__delegate.call(this,args);};
G__22343.cljs$lang$maxFixedArity = 0;
G__22343.cljs$lang$applyTo = (function (arglist__22345){
var args = cljs.core.seq(arglist__22345);
return G__22343__delegate(args);
});
G__22343.cljs$core$IFn$_invoke$arity$variadic = G__22343__delegate;
return G__22343;
})()
;

cljs.core._STAR_print_err_fn_STAR_ = (function() { 
var G__22346__delegate = function (args){
return console.error.apply(console,(cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args) : cljs.core.into_array.call(null,args)));
};
var G__22346 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__22347__i = 0, G__22347__a = new Array(arguments.length -  0);
while (G__22347__i < G__22347__a.length) {G__22347__a[G__22347__i] = arguments[G__22347__i + 0]; ++G__22347__i;}
  args = new cljs.core.IndexedSeq(G__22347__a,0);
} 
return G__22346__delegate.call(this,args);};
G__22346.cljs$lang$maxFixedArity = 0;
G__22346.cljs$lang$applyTo = (function (arglist__22348){
var args = cljs.core.seq(arglist__22348);
return G__22346__delegate(args);
});
G__22346.cljs$core$IFn$_invoke$arity$variadic = G__22346__delegate;
return G__22346;
})()
;

return null;
});
/**
 * Internal - do not use!
 */
cljs.core.truth_ = (function cljs$core$truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;

/**
 * Tests if 2 arguments are the same object
 */
cljs.core.identical_QMARK_ = (function cljs$core$identical_QMARK_(x,y){
return (x === y);
});
/**
 * Returns true if x is nil, false otherwise.
 */
cljs.core.nil_QMARK_ = (function cljs$core$nil_QMARK_(x){
return (x == null);
});
/**
 * Returns true if x is a JavaScript array.
 */
cljs.core.array_QMARK_ = (function cljs$core$array_QMARK_(x){
if((cljs.core._STAR_target_STAR_ === "nodejs")){
return Array.isArray(x);
} else {
return (x instanceof Array);
}
});
/**
 * Returns true if x is a JavaScript number.
 */
cljs.core.number_QMARK_ = (function cljs$core$number_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true if x is logical false, false otherwise.
 */
cljs.core.not = (function cljs$core$not(x){
if((x == null)){
return true;
} else {
if(x === false){
return true;
} else {
return false;

}
}
});
/**
 * Returns true if x is not nil, false otherwise.
 */
cljs.core.some_QMARK_ = (function cljs$core$some_QMARK_(x){
return !((x == null));
});
/**
 * Returns true if x's constructor is Object
 */
cljs.core.object_QMARK_ = (function cljs$core$object_QMARK_(x){
if(!((x == null))){
return (x.constructor === Object);
} else {
return false;
}
});
/**
 * Returns true if x is a JavaScript string.
 */
cljs.core.string_QMARK_ = (function cljs$core$string_QMARK_(x){
return goog.isString(x);
});
/**
 * Returns true if x is a JavaScript string of length one.
 */
cljs.core.char_QMARK_ = (function cljs$core$char_QMARK_(x){
return (typeof x === 'string') && (((1) === x.length));
});
/**
 * Returns true if given any argument.
 */
cljs.core.any_QMARK_ = (function cljs$core$any_QMARK_(x){
return true;
});
/**
 * Internal - do not use!
 */
cljs.core.native_satisfies_QMARK_ = (function cljs$core$native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[goog.typeOf(x__$1)])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function cljs$core$is_proto_(x){
return (x.constructor.prototype === x);
});
/**
 * When compiled for a command-line target, whatever function
 *   *main-cli-fn* is set to will be called with the command-line
 *   argv as arguments
 */
cljs.core._STAR_main_cli_fn_STAR_ = null;
/**
 * Return x's constructor.
 */
cljs.core.type = (function cljs$core$type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function cljs$core$missing_protocol(proto,obj){
var ty = cljs.core.type(obj);
var ty__$1 = (cljs.core.truth_((function (){var and__6531__auto__ = ty;
if(cljs.core.truth_(and__6531__auto__)){
return ty.cljs$lang$type;
} else {
return and__6531__auto__;
}
})())?ty.cljs$lang$ctorStr:goog.typeOf(obj));
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function cljs$core$type__GT_str(ty){
var temp__4655__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__4655__auto__)){
var s = temp__4655__auto__;
return s;
} else {
return [cljs.core.str(ty)].join('');
}
});
cljs.core.load_file = (function cljs$core$load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.nodeGlobalRequire(file);
}
});
if((typeof Symbol !== 'undefined') && ((goog.typeOf(Symbol) === "function"))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
/**
 * @enum {string}
 */
cljs.core.CHAR_MAP = ({"]": "_RBRACK_", "'": "_SINGLEQUOTE_", "=": "_EQ_", "\"": "_DOUBLEQUOTE_", "!": "_BANG_", "*": "_STAR_", "%": "_PERCENT_", "|": "_BAR_", "~": "_TILDE_", "/": "_SLASH_", "\\": "_BSLASH_", "-": "_", "?": "_QMARK_", "&": "_AMPERSAND_", ":": "_COLON_", "<": "_LT_", "{": "_LBRACE_", "}": "_RBRACE_", "[": "_LBRACK_", "#": "_SHARP_", "^": "_CARET_", "+": "_PLUS_", "@": "_CIRCA_", ">": "_GT_"});
/**
 * @enum {string}
 */
cljs.core.DEMUNGE_MAP = ({"_RBRACE_": "}", "_COLON_": ":", "_BANG_": "!", "_QMARK_": "?", "_BSLASH_": "\\\\", "_SLASH_": "/", "_PERCENT_": "%", "_PLUS_": "+", "_SHARP_": "#", "_LBRACE_": "{", "_BAR_": "|", "_LBRACK_": "[", "_EQ_": "=", "_": "-", "_TILDE_": "~", "_RBRACK_": "]", "_GT_": ">", "_SINGLEQUOTE_": "'", "_CIRCA_": "@", "_AMPERSAND_": "&", "_DOUBLEQUOTE_": "\\\"", "_CARET_": "^", "_LT_": "<", "_STAR_": "*"});
cljs.core.DEMUNGE_PATTERN = null;
/**
 * Returns highest resolution time offered by host in milliseconds.
 */
cljs.core.system_time = (function cljs$core$system_time(){
if((typeof performance !== 'undefined') && (!((performance.now == null)))){
return performance.now();
} else {
if((typeof process !== 'undefined') && (!((process.hrtime == null)))){
var t = process.hrtime();
return ((((t[(0)]) * 1.0E9) + (t[(1)])) / 1000000.0);
} else {
return (new Date()).getTime();

}
}
});
/**
 * Construct a JavaScript array of the specified dimensions. Accepts ignored
 *   type argument for compatibility with Clojure. Note that there is no efficient
 *   way to allocate multi-dimensional arrays in JavaScript; as such, this function
 *   will run in polynomial time when called with 3 or more arguments.
 */
cljs.core.make_array = (function cljs$core$make_array(var_args){
var args22349 = [];
var len__7651__auto___22355 = arguments.length;
var i__7652__auto___22356 = (0);
while(true){
if((i__7652__auto___22356 < len__7651__auto___22355)){
args22349.push((arguments[i__7652__auto___22356]));

var G__22357 = (i__7652__auto___22356 + (1));
i__7652__auto___22356 = G__22357;
continue;
} else {
}
break;
}

var G__22354 = args22349.length;
switch (G__22354) {
case 1:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args22349.slice((2)),(0),null));
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = (function (size){
return (new Array(size));
});

cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = (function (type,size){
return (new Array(size));
});

cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic = (function (type,size,more_sizes){
var dims = more_sizes;
var dimarray = (new Array(size));
var n__7461__auto___22359 = dimarray.length;
var i_22360 = (0);
while(true){
if((i_22360 < n__7461__auto___22359)){
(dimarray[i_22360] = (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.make_array,null,dims) : cljs.core.apply.call(null,cljs.core.make_array,null,dims)));

var G__22361 = (i_22360 + (1));
i_22360 = G__22361;
continue;
} else {
}
break;
}

return dimarray;
});

cljs.core.make_array.cljs$lang$applyTo = (function (seq22350){
var G__22351 = cljs.core.first(seq22350);
var seq22350__$1 = cljs.core.next(seq22350);
var G__22352 = cljs.core.first(seq22350__$1);
var seq22350__$2 = cljs.core.next(seq22350__$1);
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic(G__22351,G__22352,seq22350__$2);
});

cljs.core.make_array.cljs$lang$maxFixedArity = (2);

/**
 * Returns a javascript array, cloned from the passed in array
 */
cljs.core.aclone = (function cljs$core$aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__7461__auto___22362 = len;
var i_22363 = (0);
while(true){
if((i_22363 < n__7461__auto___22362)){
(new_arr[i_22363] = (arr[i_22363]));

var G__22364 = (i_22363 + (1));
i_22363 = G__22364;
continue;
} else {
}
break;
}

return new_arr;
});
/**
 * Creates a new javascript array.
 * @param {...*} var_args
 */
cljs.core.array = (function cljs$core$array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__22365 = (i + (1));
i = G__22365;
continue;
} else {
return a;
}
break;
}
});
/**
 * Returns the value at the index.
 */
cljs.core.aget = (function cljs$core$aget(var_args){
var args22366 = [];
var len__7651__auto___22375 = arguments.length;
var i__7652__auto___22376 = (0);
while(true){
if((i__7652__auto___22376 < len__7651__auto___22375)){
args22366.push((arguments[i__7652__auto___22376]));

var G__22377 = (i__7652__auto___22376 + (1));
i__7652__auto___22376 = G__22377;
continue;
} else {
}
break;
}

var G__22371 = args22366.length;
switch (G__22371) {
case 2:
return cljs.core.aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args22366.slice((2)),(0),null));
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = (function (array,i){
return (array[i]);
});

cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = (function (array,i,idxs){
var G__22372 = cljs.core.aget;
var G__22373 = (array[i]);
var G__22374 = idxs;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__22372,G__22373,G__22374) : cljs.core.apply.call(null,G__22372,G__22373,G__22374));
});

cljs.core.aget.cljs$lang$applyTo = (function (seq22367){
var G__22368 = cljs.core.first(seq22367);
var seq22367__$1 = cljs.core.next(seq22367);
var G__22369 = cljs.core.first(seq22367__$1);
var seq22367__$2 = cljs.core.next(seq22367__$1);
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(G__22368,G__22369,seq22367__$2);
});

cljs.core.aget.cljs$lang$maxFixedArity = (2);

/**
 * Sets the value at the index.
 */
cljs.core.aset = (function cljs$core$aset(var_args){
var args22379 = [];
var len__7651__auto___22390 = arguments.length;
var i__7652__auto___22391 = (0);
while(true){
if((i__7652__auto___22391 < len__7651__auto___22390)){
args22379.push((arguments[i__7652__auto___22391]));

var G__22392 = (i__7652__auto___22391 + (1));
i__7652__auto___22391 = G__22392;
continue;
} else {
}
break;
}

var G__22385 = args22379.length;
switch (G__22385) {
case 3:
return cljs.core.aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args22379.slice((3)),(0),null));
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7670__auto__);

}
});

cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = (function (array,i,val){
return (array[i] = val);
});

cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idx2,idxv){
var G__22386 = cljs.core.aset;
var G__22387 = (array[idx]);
var G__22388 = idx2;
var G__22389 = idxv;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__22386,G__22387,G__22388,G__22389) : cljs.core.apply.call(null,G__22386,G__22387,G__22388,G__22389));
});

cljs.core.aset.cljs$lang$applyTo = (function (seq22380){
var G__22381 = cljs.core.first(seq22380);
var seq22380__$1 = cljs.core.next(seq22380);
var G__22382 = cljs.core.first(seq22380__$1);
var seq22380__$2 = cljs.core.next(seq22380__$1);
var G__22383 = cljs.core.first(seq22380__$2);
var seq22380__$3 = cljs.core.next(seq22380__$2);
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(G__22381,G__22382,G__22383,seq22380__$3);
});

cljs.core.aset.cljs$lang$maxFixedArity = (3);

/**
 * Returns the length of the array. Works on arrays of all types.
 */
cljs.core.alength = (function cljs$core$alength(array){
return array.length;
});
/**
 * Returns an array with components set to the values in aseq. Optional type
 *   argument accepted for compatibility with Clojure.
 */
cljs.core.into_array = (function cljs$core$into_array(var_args){
var args22394 = [];
var len__7651__auto___22400 = arguments.length;
var i__7652__auto___22401 = (0);
while(true){
if((i__7652__auto___22401 < len__7651__auto___22400)){
args22394.push((arguments[i__7652__auto___22401]));

var G__22402 = (i__7652__auto___22401 + (1));
i__7652__auto___22401 = G__22402;
continue;
} else {
}
break;
}

var G__22396 = args22394.length;
switch (G__22396) {
case 1:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22394.length)].join('')));

}
});

cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = (function (aseq){
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);
});

cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = (function (type,aseq){
var G__22397 = (function (a,x){
a.push(x);

return a;
});
var G__22398 = [];
var G__22399 = aseq;
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__22397,G__22398,G__22399) : cljs.core.reduce.call(null,G__22397,G__22398,G__22399));
});

cljs.core.into_array.cljs$lang$maxFixedArity = 2;

/**
 * Invoke JavaScript object method via string. Needed when the
 *   string is not a valid unquoted property name.
 */
cljs.core.js_invoke = (function cljs$core$js_invoke(var_args){
var args__7658__auto__ = [];
var len__7651__auto___22407 = arguments.length;
var i__7652__auto___22408 = (0);
while(true){
if((i__7652__auto___22408 < len__7651__auto___22407)){
args__7658__auto__.push((arguments[i__7652__auto___22408]));

var G__22409 = (i__7652__auto___22408 + (1));
i__7652__auto___22408 = G__22409;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = (function (obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
});

cljs.core.js_invoke.cljs$lang$maxFixedArity = (2);

cljs.core.js_invoke.cljs$lang$applyTo = (function (seq22404){
var G__22405 = cljs.core.first(seq22404);
var seq22404__$1 = cljs.core.next(seq22404);
var G__22406 = cljs.core.first(seq22404__$1);
var seq22404__$2 = cljs.core.next(seq22404__$1);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(G__22405,G__22406,seq22404__$2);
});


/**
 * Marker protocol
 * @interface
 */
cljs.core.Fn = function(){};


/**
 * Protocol for adding the ability to invoke an object as a function.
 *   For example, a vector can also be used to look up a value:
 *   ([1 2 3 4] 1) => 2
 * @interface
 */
cljs.core.IFn = function(){};

cljs.core._invoke = (function cljs$core$_invoke(var_args){
var args22410 = [];
var len__7651__auto___22413 = arguments.length;
var i__7652__auto___22414 = (0);
while(true){
if((i__7652__auto___22414 < len__7651__auto___22413)){
args22410.push((arguments[i__7652__auto___22414]));

var G__22415 = (i__7652__auto___22414 + (1));
i__7652__auto___22414 = G__22415;
continue;
} else {
}
break;
}

var G__22412 = args22410.length;
switch (G__22412) {
case 1:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
case 9:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
case 11:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));

break;
case 12:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));

break;
case 13:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));

break;
case 14:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));

break;
case 15:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));

break;
case 16:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));

break;
case 17:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));

break;
case 18:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));

break;
case 19:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));

break;
case 20:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));

break;
case 21:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));

break;
case 22:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22410.length)].join('')));

}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = (function (this$){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$1 == null)))){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7207__auto__.call(null,this$));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7207__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = (function (this$,a){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$2 == null)))){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__7207__auto__.call(null,this$,a));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,a) : m__7207__auto____$1.call(null,this$,a));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = (function (this$,a,b){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$3 == null)))){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__7207__auto__.call(null,this$,a,b));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__7207__auto____$1.call(null,this$,a,b));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = (function (this$,a,b,c){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$4 == null)))){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__7207__auto__.call(null,this$,a,b,c));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__7207__auto____$1.call(null,this$,a,b,c));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = (function (this$,a,b,c,d){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$5 == null)))){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$5 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__7207__auto__.call(null,this$,a,b,c,d));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$5 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__7207__auto____$1.call(null,this$,a,b,c,d));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = (function (this$,a,b,c,d,e){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$6 == null)))){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$6 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__7207__auto__.call(null,this$,a,b,c,d,e));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$6 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__7207__auto____$1.call(null,this$,a,b,c,d,e));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = (function (this$,a,b,c,d,e,f){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$7 == null)))){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$7 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__7207__auto__.call(null,this$,a,b,c,d,e,f));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$7 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = (function (this$,a,b,c,d,e,f,g){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$8 == null)))){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$8 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$8 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = (function (this$,a,b,c,d,e,f,g,h){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$9 == null)))){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$9 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$9 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = (function (this$,a,b,c,d,e,f,g,h,i){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$10 == null)))){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$10 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$10 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$11 == null)))){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$11 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$11 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$12 == null)))){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$12 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$12 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$13 == null)))){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$13 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$13 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$14 == null)))){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$14 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$14 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$15 == null)))){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$15 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$15 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$16 == null)))){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$16 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$16 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$17 == null)))){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$17 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$17 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$18 == null)))){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$18 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$18 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$19 == null)))){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$19 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$19 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$20 == null)))){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$20 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$20 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$21 == null)))){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$21 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$21 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$22 == null)))){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$22 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$22 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$lang$maxFixedArity = 22;



/**
 * Protocol for cloning a value.
 * @interface
 */
cljs.core.ICloneable = function(){};

/**
 * Creates a clone of value.
 */
cljs.core._clone = (function cljs$core$_clone(value){
if((!((value == null))) && (!((value.cljs$core$ICloneable$_clone$arity$1 == null)))){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
var x__7206__auto__ = (((value == null))?null:value);
var m__7207__auto__ = (cljs.core._clone[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__7207__auto__.call(null,value));
} else {
var m__7207__auto____$1 = (cljs.core._clone["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(value) : m__7207__auto____$1.call(null,value));
} else {
throw cljs.core.missing_protocol("ICloneable.-clone",value);
}
}
}
});


/**
 * Protocol for adding the ability to count a collection in constant time.
 * @interface
 */
cljs.core.ICounted = function(){};

/**
 * Calculates the count of coll in constant time. Used by cljs.core/count.
 */
cljs.core._count = (function cljs$core$_count(coll){
if((!((coll == null))) && (!((coll.cljs$core$ICounted$_count$arity$1 == null)))){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._count[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._count["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("ICounted.-count",coll);
}
}
}
});


/**
 * Protocol for creating an empty collection.
 * @interface
 */
cljs.core.IEmptyableCollection = function(){};

/**
 * Returns an empty collection of the same category as coll. Used
 *   by cljs.core/empty.
 */
cljs.core._empty = (function cljs$core$_empty(coll){
if((!((coll == null))) && (!((coll.cljs$core$IEmptyableCollection$_empty$arity$1 == null)))){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._empty[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._empty["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);
}
}
}
});


/**
 * Protocol for adding to a collection.
 * @interface
 */
cljs.core.ICollection = function(){};

/**
 * Returns a new collection of coll with o added to it. The new item
 *   should be added to the most efficient place, e.g.
 *   (conj [1 2 3 4] 5) => [1 2 3 4 5]
 *   (conj '(2 3 4 5) 1) => '(1 2 3 4 5)
 */
cljs.core._conj = (function cljs$core$_conj(coll,o){
if((!((coll == null))) && (!((coll.cljs$core$ICollection$_conj$arity$2 == null)))){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._conj[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__7207__auto__.call(null,coll,o));
} else {
var m__7207__auto____$1 = (cljs.core._conj["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,o) : m__7207__auto____$1.call(null,coll,o));
} else {
throw cljs.core.missing_protocol("ICollection.-conj",coll);
}
}
}
});


/**
 * Protocol for collections to provide indexed-based access to their items.
 * @interface
 */
cljs.core.IIndexed = function(){};

/**
 * Returns the value at the index n in the collection coll.
 *   Returns not-found if index n is out of bounds and not-found is supplied.
 */
cljs.core._nth = (function cljs$core$_nth(var_args){
var args22417 = [];
var len__7651__auto___22420 = arguments.length;
var i__7652__auto___22421 = (0);
while(true){
if((i__7652__auto___22421 < len__7651__auto___22420)){
args22417.push((arguments[i__7652__auto___22421]));

var G__22422 = (i__7652__auto___22421 + (1));
i__7652__auto___22421 = G__22422;
continue;
} else {
}
break;
}

var G__22419 = args22417.length;
switch (G__22419) {
case 2:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22417.length)].join('')));

}
});

cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if((!((coll == null))) && (!((coll.cljs$core$IIndexed$_nth$arity$2 == null)))){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._nth[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__7207__auto__.call(null,coll,n));
} else {
var m__7207__auto____$1 = (cljs.core._nth["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,n) : m__7207__auto____$1.call(null,coll,n));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
}
});

cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if((!((coll == null))) && (!((coll.cljs$core$IIndexed$_nth$arity$3 == null)))){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._nth[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__7207__auto__.call(null,coll,n,not_found));
} else {
var m__7207__auto____$1 = (cljs.core._nth["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__7207__auto____$1.call(null,coll,n,not_found));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
}
});

cljs.core._nth.cljs$lang$maxFixedArity = 3;



/**
 * Marker protocol indicating an array sequence.
 * @interface
 */
cljs.core.ASeq = function(){};


/**
 * Protocol for collections to provide access to their items as sequences.
 * @interface
 */
cljs.core.ISeq = function(){};

/**
 * Returns the first item in the collection coll. Used by cljs.core/first.
 */
cljs.core._first = (function cljs$core$_first(coll){
if((!((coll == null))) && (!((coll.cljs$core$ISeq$_first$arity$1 == null)))){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._first[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._first["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-first",coll);
}
}
}
});

/**
 * Returns a new collection of coll without the first item. It should
 *   always return a seq, e.g.
 *   (rest []) => ()
 *   (rest nil) => ()
 */
cljs.core._rest = (function cljs$core$_rest(coll){
if((!((coll == null))) && (!((coll.cljs$core$ISeq$_rest$arity$1 == null)))){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._rest[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._rest["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-rest",coll);
}
}
}
});


/**
 * Protocol for accessing the next items of a collection.
 * @interface
 */
cljs.core.INext = function(){};

/**
 * Returns a new collection of coll without the first item. In contrast to
 *   rest, it should return nil if there are no more items, e.g.
 *   (next []) => nil
 *   (next nil) => nil
 */
cljs.core._next = (function cljs$core$_next(coll){
if((!((coll == null))) && (!((coll.cljs$core$INext$_next$arity$1 == null)))){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._next[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._next["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("INext.-next",coll);
}
}
}
});


/**
 * Protocol for looking up a value in a data structure.
 * @interface
 */
cljs.core.ILookup = function(){};

/**
 * Use k to look up a value in o. If not-found is supplied and k is not
 *   a valid value that can be used for look up, not-found is returned.
 */
cljs.core._lookup = (function cljs$core$_lookup(var_args){
var args22424 = [];
var len__7651__auto___22427 = arguments.length;
var i__7652__auto___22428 = (0);
while(true){
if((i__7652__auto___22428 < len__7651__auto___22427)){
args22424.push((arguments[i__7652__auto___22428]));

var G__22429 = (i__7652__auto___22428 + (1));
i__7652__auto___22428 = G__22429;
continue;
} else {
}
break;
}

var G__22426 = args22424.length;
switch (G__22426) {
case 2:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22424.length)].join('')));

}
});

cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((!((o == null))) && (!((o.cljs$core$ILookup$_lookup$arity$2 == null)))){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._lookup[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__7207__auto__.call(null,o,k));
} else {
var m__7207__auto____$1 = (cljs.core._lookup["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(o,k) : m__7207__auto____$1.call(null,o,k));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
}
});

cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if((!((o == null))) && (!((o.cljs$core$ILookup$_lookup$arity$3 == null)))){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._lookup[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__7207__auto__.call(null,o,k,not_found));
} else {
var m__7207__auto____$1 = (cljs.core._lookup["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__7207__auto____$1.call(null,o,k,not_found));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
}
});

cljs.core._lookup.cljs$lang$maxFixedArity = 3;



/**
 * Protocol for adding associativity to collections.
 * @interface
 */
cljs.core.IAssociative = function(){};

/**
 * Returns true if k is a key in coll.
 */
cljs.core._contains_key_QMARK_ = (function cljs$core$_contains_key_QMARK_(coll,k){
if((!((coll == null))) && (!((coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 == null)))){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._contains_key_QMARK_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__7207__auto__.call(null,coll,k));
} else {
var m__7207__auto____$1 = (cljs.core._contains_key_QMARK_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,k) : m__7207__auto____$1.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);
}
}
}
});

/**
 * Returns a new collection of coll with a mapping from key k to
 *   value v added to it.
 */
cljs.core._assoc = (function cljs$core$_assoc(coll,k,v){
if((!((coll == null))) && (!((coll.cljs$core$IAssociative$_assoc$arity$3 == null)))){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._assoc[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__7207__auto__.call(null,coll,k,v));
} else {
var m__7207__auto____$1 = (cljs.core._assoc["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__7207__auto____$1.call(null,coll,k,v));
} else {
throw cljs.core.missing_protocol("IAssociative.-assoc",coll);
}
}
}
});


/**
 * Protocol for adding mapping functionality to collections.
 * @interface
 */
cljs.core.IMap = function(){};

/**
 * Returns a new collection of coll without the mapping for key k.
 */
cljs.core._dissoc = (function cljs$core$_dissoc(coll,k){
if((!((coll == null))) && (!((coll.cljs$core$IMap$_dissoc$arity$2 == null)))){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._dissoc[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__7207__auto__.call(null,coll,k));
} else {
var m__7207__auto____$1 = (cljs.core._dissoc["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,k) : m__7207__auto____$1.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IMap.-dissoc",coll);
}
}
}
});


/**
 * Protocol for examining a map entry.
 * @interface
 */
cljs.core.IMapEntry = function(){};

/**
 * Returns the key of the map entry.
 */
cljs.core._key = (function cljs$core$_key(coll){
if((!((coll == null))) && (!((coll.cljs$core$IMapEntry$_key$arity$1 == null)))){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._key[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._key["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-key",coll);
}
}
}
});

/**
 * Returns the value of the map entry.
 */
cljs.core._val = (function cljs$core$_val(coll){
if((!((coll == null))) && (!((coll.cljs$core$IMapEntry$_val$arity$1 == null)))){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._val[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._val["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-val",coll);
}
}
}
});


/**
 * Protocol for adding set functionality to a collection.
 * @interface
 */
cljs.core.ISet = function(){};

/**
 * Returns a new collection of coll that does not contain v.
 */
cljs.core._disjoin = (function cljs$core$_disjoin(coll,v){
if((!((coll == null))) && (!((coll.cljs$core$ISet$_disjoin$arity$2 == null)))){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._disjoin[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__7207__auto__.call(null,coll,v));
} else {
var m__7207__auto____$1 = (cljs.core._disjoin["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,v) : m__7207__auto____$1.call(null,coll,v));
} else {
throw cljs.core.missing_protocol("ISet.-disjoin",coll);
}
}
}
});


/**
 * Protocol for collections to provide access to their items as stacks. The top
 *   of the stack should be accessed in the most efficient way for the different
 *   data structures.
 * @interface
 */
cljs.core.IStack = function(){};

/**
 * Returns the item from the top of the stack. Is used by cljs.core/peek.
 */
cljs.core._peek = (function cljs$core$_peek(coll){
if((!((coll == null))) && (!((coll.cljs$core$IStack$_peek$arity$1 == null)))){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._peek[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._peek["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-peek",coll);
}
}
}
});

/**
 * Returns a new stack without the item on top of the stack. Is used
 *   by cljs.core/pop.
 */
cljs.core._pop = (function cljs$core$_pop(coll){
if((!((coll == null))) && (!((coll.cljs$core$IStack$_pop$arity$1 == null)))){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._pop[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._pop["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-pop",coll);
}
}
}
});


/**
 * Protocol for adding vector functionality to collections.
 * @interface
 */
cljs.core.IVector = function(){};

/**
 * Returns a new vector with value val added at position n.
 */
cljs.core._assoc_n = (function cljs$core$_assoc_n(coll,n,val){
if((!((coll == null))) && (!((coll.cljs$core$IVector$_assoc_n$arity$3 == null)))){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._assoc_n[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__7207__auto__.call(null,coll,n,val));
} else {
var m__7207__auto____$1 = (cljs.core._assoc_n["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__7207__auto____$1.call(null,coll,n,val));
} else {
throw cljs.core.missing_protocol("IVector.-assoc-n",coll);
}
}
}
});


/**
 * Protocol for adding dereference functionality to a reference.
 * @interface
 */
cljs.core.IDeref = function(){};

/**
 * Returns the value of the reference o.
 */
cljs.core._deref = (function cljs$core$_deref(o){
if((!((o == null))) && (!((o.cljs$core$IDeref$_deref$arity$1 == null)))){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._deref[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__7207__auto__.call(null,o));
} else {
var m__7207__auto____$1 = (cljs.core._deref["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__7207__auto____$1.call(null,o));
} else {
throw cljs.core.missing_protocol("IDeref.-deref",o);
}
}
}
});


/**
 * @interface
 */
cljs.core.IDerefWithTimeout = function(){};

cljs.core._deref_with_timeout = (function cljs$core$_deref_with_timeout(o,msec,timeout_val){
if((!((o == null))) && (!((o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3 == null)))){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._deref_with_timeout[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__7207__auto__.call(null,o,msec,timeout_val));
} else {
var m__7207__auto____$1 = (cljs.core._deref_with_timeout["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__7207__auto____$1.call(null,o,msec,timeout_val));
} else {
throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);
}
}
}
});


/**
 * Protocol for accessing the metadata of an object.
 * @interface
 */
cljs.core.IMeta = function(){};

/**
 * Returns the metadata of object o.
 */
cljs.core._meta = (function cljs$core$_meta(o){
if((!((o == null))) && (!((o.cljs$core$IMeta$_meta$arity$1 == null)))){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._meta[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__7207__auto__.call(null,o));
} else {
var m__7207__auto____$1 = (cljs.core._meta["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__7207__auto____$1.call(null,o));
} else {
throw cljs.core.missing_protocol("IMeta.-meta",o);
}
}
}
});


/**
 * Protocol for adding metadata to an object.
 * @interface
 */
cljs.core.IWithMeta = function(){};

/**
 * Returns a new object with value of o and metadata meta added to it.
 */
cljs.core._with_meta = (function cljs$core$_with_meta(o,meta){
if((!((o == null))) && (!((o.cljs$core$IWithMeta$_with_meta$arity$2 == null)))){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._with_meta[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__7207__auto__.call(null,o,meta));
} else {
var m__7207__auto____$1 = (cljs.core._with_meta["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(o,meta) : m__7207__auto____$1.call(null,o,meta));
} else {
throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);
}
}
}
});


/**
 * Protocol for seq types that can reduce themselves.
 *   Called by cljs.core/reduce.
 * @interface
 */
cljs.core.IReduce = function(){};

/**
 * f should be a function of 2 arguments. If start is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc.
 */
cljs.core._reduce = (function cljs$core$_reduce(var_args){
var args22431 = [];
var len__7651__auto___22434 = arguments.length;
var i__7652__auto___22435 = (0);
while(true){
if((i__7652__auto___22435 < len__7651__auto___22434)){
args22431.push((arguments[i__7652__auto___22435]));

var G__22436 = (i__7652__auto___22435 + (1));
i__7652__auto___22435 = G__22436;
continue;
} else {
}
break;
}

var G__22433 = args22431.length;
switch (G__22433) {
case 2:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22431.length)].join('')));

}
});

cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = (function (coll,f){
if((!((coll == null))) && (!((coll.cljs$core$IReduce$_reduce$arity$2 == null)))){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._reduce[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__7207__auto__.call(null,coll,f));
} else {
var m__7207__auto____$1 = (cljs.core._reduce["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,f) : m__7207__auto____$1.call(null,coll,f));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
}
});

cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = (function (coll,f,start){
if((!((coll == null))) && (!((coll.cljs$core$IReduce$_reduce$arity$3 == null)))){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._reduce[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__7207__auto__.call(null,coll,f,start));
} else {
var m__7207__auto____$1 = (cljs.core._reduce["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__7207__auto____$1.call(null,coll,f,start));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
}
});

cljs.core._reduce.cljs$lang$maxFixedArity = 3;



/**
 * Protocol for associative types that can reduce themselves
 *   via a function of key and val. Called by cljs.core/reduce-kv.
 * @interface
 */
cljs.core.IKVReduce = function(){};

/**
 * Reduces an associative collection and returns the result. f should be
 *   a function that takes three arguments.
 */
cljs.core._kv_reduce = (function cljs$core$_kv_reduce(coll,f,init){
if((!((coll == null))) && (!((coll.cljs$core$IKVReduce$_kv_reduce$arity$3 == null)))){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._kv_reduce[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__7207__auto__.call(null,coll,f,init));
} else {
var m__7207__auto____$1 = (cljs.core._kv_reduce["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__7207__auto____$1.call(null,coll,f,init));
} else {
throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);
}
}
}
});


/**
 * Protocol for adding value comparison functionality to a type.
 * @interface
 */
cljs.core.IEquiv = function(){};

/**
 * Returns true if o and other are equal, false otherwise.
 */
cljs.core._equiv = (function cljs$core$_equiv(o,other){
if((!((o == null))) && (!((o.cljs$core$IEquiv$_equiv$arity$2 == null)))){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._equiv[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__7207__auto__.call(null,o,other));
} else {
var m__7207__auto____$1 = (cljs.core._equiv["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(o,other) : m__7207__auto____$1.call(null,o,other));
} else {
throw cljs.core.missing_protocol("IEquiv.-equiv",o);
}
}
}
});


/**
 * Protocol for adding hashing functionality to a type.
 * @interface
 */
cljs.core.IHash = function(){};

/**
 * Returns the hash code of o.
 */
cljs.core._hash = (function cljs$core$_hash(o){
if((!((o == null))) && (!((o.cljs$core$IHash$_hash$arity$1 == null)))){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._hash[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__7207__auto__.call(null,o));
} else {
var m__7207__auto____$1 = (cljs.core._hash["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__7207__auto____$1.call(null,o));
} else {
throw cljs.core.missing_protocol("IHash.-hash",o);
}
}
}
});


/**
 * Protocol for adding the ability to a type to be transformed into a sequence.
 * @interface
 */
cljs.core.ISeqable = function(){};

/**
 * Returns a seq of o, or nil if o is empty.
 */
cljs.core._seq = (function cljs$core$_seq(o){
if((!((o == null))) && (!((o.cljs$core$ISeqable$_seq$arity$1 == null)))){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._seq[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__7207__auto__.call(null,o));
} else {
var m__7207__auto____$1 = (cljs.core._seq["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__7207__auto____$1.call(null,o));
} else {
throw cljs.core.missing_protocol("ISeqable.-seq",o);
}
}
}
});


/**
 * Marker interface indicating a persistent collection of sequential items
 * @interface
 */
cljs.core.ISequential = function(){};


/**
 * Marker interface indicating a persistent list
 * @interface
 */
cljs.core.IList = function(){};


/**
 * Marker interface indicating a record object
 * @interface
 */
cljs.core.IRecord = function(){};


/**
 * Protocol for reversing a seq.
 * @interface
 */
cljs.core.IReversible = function(){};

/**
 * Returns a seq of the items in coll in reversed order.
 */
cljs.core._rseq = (function cljs$core$_rseq(coll){
if((!((coll == null))) && (!((coll.cljs$core$IReversible$_rseq$arity$1 == null)))){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._rseq[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._rseq["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IReversible.-rseq",coll);
}
}
}
});


/**
 * Protocol for a collection which can represent their items
 *   in a sorted manner. 
 * @interface
 */
cljs.core.ISorted = function(){};

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 */
cljs.core._sorted_seq = (function cljs$core$_sorted_seq(coll,ascending_QMARK_){
if((!((coll == null))) && (!((coll.cljs$core$ISorted$_sorted_seq$arity$2 == null)))){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._sorted_seq[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__7207__auto__.call(null,coll,ascending_QMARK_));
} else {
var m__7207__auto____$1 = (cljs.core._sorted_seq["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__7207__auto____$1.call(null,coll,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);
}
}
}
});

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 *   If ascending is true, the result should contain all items which are > or >=
 *   than k. If ascending is false, the result should contain all items which
 *   are < or <= than k, e.g.
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)
 */
cljs.core._sorted_seq_from = (function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){
if((!((coll == null))) && (!((coll.cljs$core$ISorted$_sorted_seq_from$arity$3 == null)))){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._sorted_seq_from[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__7207__auto__.call(null,coll,k,ascending_QMARK_));
} else {
var m__7207__auto____$1 = (cljs.core._sorted_seq_from["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__7207__auto____$1.call(null,coll,k,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);
}
}
}
});

/**
 * Returns the key for entry.
 */
cljs.core._entry_key = (function cljs$core$_entry_key(coll,entry){
if((!((coll == null))) && (!((coll.cljs$core$ISorted$_entry_key$arity$2 == null)))){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._entry_key[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__7207__auto__.call(null,coll,entry));
} else {
var m__7207__auto____$1 = (cljs.core._entry_key["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__7207__auto____$1.call(null,coll,entry));
} else {
throw cljs.core.missing_protocol("ISorted.-entry-key",coll);
}
}
}
});

/**
 * Returns the comparator for coll.
 */
cljs.core._comparator = (function cljs$core$_comparator(coll){
if((!((coll == null))) && (!((coll.cljs$core$ISorted$_comparator$arity$1 == null)))){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._comparator[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._comparator["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISorted.-comparator",coll);
}
}
}
});


/**
 * Protocol for writing. Currently only implemented by StringBufferWriter.
 * @interface
 */
cljs.core.IWriter = function(){};

/**
 * Writes s with writer and returns the result.
 */
cljs.core._write = (function cljs$core$_write(writer,s){
if((!((writer == null))) && (!((writer.cljs$core$IWriter$_write$arity$2 == null)))){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
var x__7206__auto__ = (((writer == null))?null:writer);
var m__7207__auto__ = (cljs.core._write[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__7207__auto__.call(null,writer,s));
} else {
var m__7207__auto____$1 = (cljs.core._write["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(writer,s) : m__7207__auto____$1.call(null,writer,s));
} else {
throw cljs.core.missing_protocol("IWriter.-write",writer);
}
}
}
});

/**
 * Flush writer.
 */
cljs.core._flush = (function cljs$core$_flush(writer){
if((!((writer == null))) && (!((writer.cljs$core$IWriter$_flush$arity$1 == null)))){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
var x__7206__auto__ = (((writer == null))?null:writer);
var m__7207__auto__ = (cljs.core._flush[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__7207__auto__.call(null,writer));
} else {
var m__7207__auto____$1 = (cljs.core._flush["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(writer) : m__7207__auto____$1.call(null,writer));
} else {
throw cljs.core.missing_protocol("IWriter.-flush",writer);
}
}
}
});


/**
 * The old IPrintable protocol's implementation consisted of building a giant
 * list of strings to concatenate.  This involved lots of concat calls,
 * intermediate vectors, and lazy-seqs, and was very slow in some older JS
 * engines.  IPrintWithWriter implements printing via the IWriter protocol, so it
 * be implemented efficiently in terms of e.g. a StringBuffer append.
 * @interface
 */
cljs.core.IPrintWithWriter = function(){};

cljs.core._pr_writer = (function cljs$core$_pr_writer(o,writer,opts){
if((!((o == null))) && (!((o.cljs$core$IPrintWithWriter$_pr_writer$arity$3 == null)))){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._pr_writer[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__7207__auto__.call(null,o,writer,opts));
} else {
var m__7207__auto____$1 = (cljs.core._pr_writer["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__7207__auto____$1.call(null,o,writer,opts));
} else {
throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);
}
}
}
});


/**
 * Protocol for types which can have a deferred realization. Currently only
 *   implemented by Delay and LazySeq.
 * @interface
 */
cljs.core.IPending = function(){};

/**
 * Returns true if a value for x has been produced, false otherwise.
 */
cljs.core._realized_QMARK_ = (function cljs$core$_realized_QMARK_(x){
if((!((x == null))) && (!((x.cljs$core$IPending$_realized_QMARK_$arity$1 == null)))){
return x.cljs$core$IPending$_realized_QMARK_$arity$1(x);
} else {
var x__7206__auto__ = (((x == null))?null:x);
var m__7207__auto__ = (cljs.core._realized_QMARK_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__7207__auto__.call(null,x));
} else {
var m__7207__auto____$1 = (cljs.core._realized_QMARK_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__7207__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("IPending.-realized?",x);
}
}
}
});


/**
 * Protocol for types that can be watched. Currently only implemented by Atom.
 * @interface
 */
cljs.core.IWatchable = function(){};

/**
 * Calls all watchers with this, oldval and newval.
 */
cljs.core._notify_watches = (function cljs$core$_notify_watches(this$,oldval,newval){
if((!((this$ == null))) && (!((this$.cljs$core$IWatchable$_notify_watches$arity$3 == null)))){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._notify_watches[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__7207__auto__.call(null,this$,oldval,newval));
} else {
var m__7207__auto____$1 = (cljs.core._notify_watches["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__7207__auto____$1.call(null,this$,oldval,newval));
} else {
throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);
}
}
}
});

/**
 * Adds a watcher function f to this. Keys must be unique per reference,
 *   and can be used to remove the watch with -remove-watch.
 */
cljs.core._add_watch = (function cljs$core$_add_watch(this$,key,f){
if((!((this$ == null))) && (!((this$.cljs$core$IWatchable$_add_watch$arity$3 == null)))){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._add_watch[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__7207__auto__.call(null,this$,key,f));
} else {
var m__7207__auto____$1 = (cljs.core._add_watch["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__7207__auto____$1.call(null,this$,key,f));
} else {
throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);
}
}
}
});

/**
 * Removes watcher that corresponds to key from this.
 */
cljs.core._remove_watch = (function cljs$core$_remove_watch(this$,key){
if((!((this$ == null))) && (!((this$.cljs$core$IWatchable$_remove_watch$arity$2 == null)))){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._remove_watch[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__7207__auto__.call(null,this$,key));
} else {
var m__7207__auto____$1 = (cljs.core._remove_watch["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,key) : m__7207__auto____$1.call(null,this$,key));
} else {
throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);
}
}
}
});


/**
 * Protocol for collections which can transformed to transients.
 * @interface
 */
cljs.core.IEditableCollection = function(){};

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core._as_transient = (function cljs$core$_as_transient(coll){
if((!((coll == null))) && (!((coll.cljs$core$IEditableCollection$_as_transient$arity$1 == null)))){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._as_transient[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._as_transient["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);
}
}
}
});


/**
 * Protocol for adding basic functionality to transient collections.
 * @interface
 */
cljs.core.ITransientCollection = function(){};

/**
 * Adds value val to tcoll and returns tcoll.
 */
cljs.core._conj_BANG_ = (function cljs$core$_conj_BANG_(tcoll,val){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2 == null)))){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
var x__7206__auto__ = (((tcoll == null))?null:tcoll);
var m__7207__auto__ = (cljs.core._conj_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__7207__auto__.call(null,tcoll,val));
} else {
var m__7207__auto____$1 = (cljs.core._conj_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__7207__auto____$1.call(null,tcoll,val));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);
}
}
}
});

/**
 * Creates a persistent data structure from tcoll and returns it.
 */
cljs.core._persistent_BANG_ = (function cljs$core$_persistent_BANG_(tcoll){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 == null)))){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
var x__7206__auto__ = (((tcoll == null))?null:tcoll);
var m__7207__auto__ = (cljs.core._persistent_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__7207__auto__.call(null,tcoll));
} else {
var m__7207__auto____$1 = (cljs.core._persistent_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll) : m__7207__auto____$1.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);
}
}
}
});


/**
 * Protocol for adding associativity to transient collections.
 * @interface
 */
cljs.core.ITransientAssociative = function(){};

/**
 * Returns a new transient collection of tcoll with a mapping from key to
 *   val added to it.
 */
cljs.core._assoc_BANG_ = (function cljs$core$_assoc_BANG_(tcoll,key,val){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 == null)))){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
var x__7206__auto__ = (((tcoll == null))?null:tcoll);
var m__7207__auto__ = (cljs.core._assoc_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__7207__auto__.call(null,tcoll,key,val));
} else {
var m__7207__auto____$1 = (cljs.core._assoc_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__7207__auto____$1.call(null,tcoll,key,val));
} else {
throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);
}
}
}
});


/**
 * Protocol for adding mapping functionality to transient collections.
 * @interface
 */
cljs.core.ITransientMap = function(){};

/**
 * Returns a new transient collection of tcoll without the mapping for key.
 */
cljs.core._dissoc_BANG_ = (function cljs$core$_dissoc_BANG_(tcoll,key){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 == null)))){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
var x__7206__auto__ = (((tcoll == null))?null:tcoll);
var m__7207__auto__ = (cljs.core._dissoc_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__7207__auto__.call(null,tcoll,key));
} else {
var m__7207__auto____$1 = (cljs.core._dissoc_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__7207__auto____$1.call(null,tcoll,key));
} else {
throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);
}
}
}
});


/**
 * Protocol for adding vector functionality to transient collections.
 * @interface
 */
cljs.core.ITransientVector = function(){};

/**
 * Returns tcoll with value val added at position n.
 */
cljs.core._assoc_n_BANG_ = (function cljs$core$_assoc_n_BANG_(tcoll,n,val){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 == null)))){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
var x__7206__auto__ = (((tcoll == null))?null:tcoll);
var m__7207__auto__ = (cljs.core._assoc_n_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__7207__auto__.call(null,tcoll,n,val));
} else {
var m__7207__auto____$1 = (cljs.core._assoc_n_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__7207__auto____$1.call(null,tcoll,n,val));
} else {
throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);
}
}
}
});

/**
 * Returns tcoll with the last item removed from it.
 */
cljs.core._pop_BANG_ = (function cljs$core$_pop_BANG_(tcoll){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1 == null)))){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
var x__7206__auto__ = (((tcoll == null))?null:tcoll);
var m__7207__auto__ = (cljs.core._pop_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__7207__auto__.call(null,tcoll));
} else {
var m__7207__auto____$1 = (cljs.core._pop_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll) : m__7207__auto____$1.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);
}
}
}
});


/**
 * Protocol for adding set functionality to a transient collection.
 * @interface
 */
cljs.core.ITransientSet = function(){};

/**
 * Returns tcoll without v.
 */
cljs.core._disjoin_BANG_ = (function cljs$core$_disjoin_BANG_(tcoll,v){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 == null)))){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
var x__7206__auto__ = (((tcoll == null))?null:tcoll);
var m__7207__auto__ = (cljs.core._disjoin_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__7207__auto__.call(null,tcoll,v));
} else {
var m__7207__auto____$1 = (cljs.core._disjoin_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__7207__auto____$1.call(null,tcoll,v));
} else {
throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);
}
}
}
});


/**
 * Protocol for values that can be compared.
 * @interface
 */
cljs.core.IComparable = function(){};

/**
 * Returns a negative number, zero, or a positive number when x is logically
 *   'less than', 'equal to', or 'greater than' y.
 */
cljs.core._compare = (function cljs$core$_compare(x,y){
if((!((x == null))) && (!((x.cljs$core$IComparable$_compare$arity$2 == null)))){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
var x__7206__auto__ = (((x == null))?null:x);
var m__7207__auto__ = (cljs.core._compare[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__7207__auto__.call(null,x,y));
} else {
var m__7207__auto____$1 = (cljs.core._compare["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(x,y) : m__7207__auto____$1.call(null,x,y));
} else {
throw cljs.core.missing_protocol("IComparable.-compare",x);
}
}
}
});


/**
 * Protocol for accessing the items of a chunk.
 * @interface
 */
cljs.core.IChunk = function(){};

/**
 * Return a new chunk of coll with the first item removed.
 */
cljs.core._drop_first = (function cljs$core$_drop_first(coll){
if((!((coll == null))) && (!((coll.cljs$core$IChunk$_drop_first$arity$1 == null)))){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._drop_first[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._drop_first["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunk.-drop-first",coll);
}
}
}
});


/**
 * Protocol for accessing a collection as sequential chunks.
 * @interface
 */
cljs.core.IChunkedSeq = function(){};

/**
 * Returns the first chunk in coll.
 */
cljs.core._chunked_first = (function cljs$core$_chunked_first(coll){
if((!((coll == null))) && (!((coll.cljs$core$IChunkedSeq$_chunked_first$arity$1 == null)))){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._chunked_first[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._chunked_first["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);
}
}
}
});

/**
 * Return a new collection of coll with the first chunk removed.
 */
cljs.core._chunked_rest = (function cljs$core$_chunked_rest(coll){
if((!((coll == null))) && (!((coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1 == null)))){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._chunked_rest[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._chunked_rest["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);
}
}
}
});


/**
 * Protocol for accessing the chunks of a collection.
 * @interface
 */
cljs.core.IChunkedNext = function(){};

/**
 * Returns a new collection of coll without the first chunk.
 */
cljs.core._chunked_next = (function cljs$core$_chunked_next(coll){
if((!((coll == null))) && (!((coll.cljs$core$IChunkedNext$_chunked_next$arity$1 == null)))){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._chunked_next[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._chunked_next["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);
}
}
}
});


/**
 * Protocol for adding a name.
 * @interface
 */
cljs.core.INamed = function(){};

/**
 * Returns the name String of x.
 */
cljs.core._name = (function cljs$core$_name(x){
if((!((x == null))) && (!((x.cljs$core$INamed$_name$arity$1 == null)))){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
var x__7206__auto__ = (((x == null))?null:x);
var m__7207__auto__ = (cljs.core._name[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__7207__auto__.call(null,x));
} else {
var m__7207__auto____$1 = (cljs.core._name["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__7207__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-name",x);
}
}
}
});

/**
 * Returns the namespace String of x.
 */
cljs.core._namespace = (function cljs$core$_namespace(x){
if((!((x == null))) && (!((x.cljs$core$INamed$_namespace$arity$1 == null)))){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
var x__7206__auto__ = (((x == null))?null:x);
var m__7207__auto__ = (cljs.core._namespace[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__7207__auto__.call(null,x));
} else {
var m__7207__auto____$1 = (cljs.core._namespace["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__7207__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-namespace",x);
}
}
}
});


/**
 * Marker protocol indicating an atom.
 * @interface
 */
cljs.core.IAtom = function(){};


/**
 * Protocol for adding resetting functionality.
 * @interface
 */
cljs.core.IReset = function(){};

/**
 * Sets the value of o to new-value.
 */
cljs.core._reset_BANG_ = (function cljs$core$_reset_BANG_(o,new_value){
if((!((o == null))) && (!((o.cljs$core$IReset$_reset_BANG_$arity$2 == null)))){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._reset_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__7207__auto__.call(null,o,new_value));
} else {
var m__7207__auto____$1 = (cljs.core._reset_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__7207__auto____$1.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IReset.-reset!",o);
}
}
}
});


/**
 * Protocol for adding swapping functionality.
 * @interface
 */
cljs.core.ISwap = function(){};

/**
 * Swaps the value of o to be (apply f current-value-of-atom args).
 */
cljs.core._swap_BANG_ = (function cljs$core$_swap_BANG_(var_args){
var args22438 = [];
var len__7651__auto___22441 = arguments.length;
var i__7652__auto___22442 = (0);
while(true){
if((i__7652__auto___22442 < len__7651__auto___22441)){
args22438.push((arguments[i__7652__auto___22442]));

var G__22443 = (i__7652__auto___22442 + (1));
i__7652__auto___22442 = G__22443;
continue;
} else {
}
break;
}

var G__22440 = args22438.length;
switch (G__22440) {
case 2:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22438.length)].join('')));

}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (o,f){
if((!((o == null))) && (!((o.cljs$core$ISwap$_swap_BANG_$arity$2 == null)))){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__7207__auto__.call(null,o,f));
} else {
var m__7207__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(o,f) : m__7207__auto____$1.call(null,o,f));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (o,f,a){
if((!((o == null))) && (!((o.cljs$core$ISwap$_swap_BANG_$arity$3 == null)))){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__7207__auto__.call(null,o,f,a));
} else {
var m__7207__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__7207__auto____$1.call(null,o,f,a));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (o,f,a,b){
if((!((o == null))) && (!((o.cljs$core$ISwap$_swap_BANG_$arity$4 == null)))){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__7207__auto__.call(null,o,f,a,b));
} else {
var m__7207__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__7207__auto____$1.call(null,o,f,a,b));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (o,f,a,b,xs){
if((!((o == null))) && (!((o.cljs$core$ISwap$_swap_BANG_$arity$5 == null)))){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$5 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__7207__auto__.call(null,o,f,a,b,xs));
} else {
var m__7207__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$5 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__7207__auto____$1.call(null,o,f,a,b,xs));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5;



/**
 * Protocol for adding volatile functionality.
 * @interface
 */
cljs.core.IVolatile = function(){};

/**
 * Sets the value of volatile o to new-value without regard for the
 *   current value. Returns new-value.
 */
cljs.core._vreset_BANG_ = (function cljs$core$_vreset_BANG_(o,new_value){
if((!((o == null))) && (!((o.cljs$core$IVolatile$_vreset_BANG_$arity$2 == null)))){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._vreset_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__7207__auto__.call(null,o,new_value));
} else {
var m__7207__auto____$1 = (cljs.core._vreset_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__7207__auto____$1.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IVolatile.-vreset!",o);
}
}
}
});


/**
 * Protocol for iterating over a collection.
 * @interface
 */
cljs.core.IIterable = function(){};

/**
 * Returns an iterator for coll.
 */
cljs.core._iterator = (function cljs$core$_iterator(coll){
if((!((coll == null))) && (!((coll.cljs$core$IIterable$_iterator$arity$1 == null)))){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._iterator[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._iterator["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IIterable.-iterator",coll);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IWriter}
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
});

cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
});

cljs.core.StringBufferWriter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sb], null);
});

cljs.core.StringBufferWriter.cljs$lang$type = true;

cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";

cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/StringBufferWriter");
});

cljs.core.__GT_StringBufferWriter = (function cljs$core$__GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
 * Support so that collections can implement toString without
 * loading all the printing machinery.
 */
cljs.core.pr_str_STAR_ = (function cljs$core$pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());

writer.cljs$core$IWriter$_flush$arity$1(null);

return [cljs.core.str(sb)].join('');
});
cljs.core.int_rotate_left = (function cljs$core$int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((typeof Math.imul !== 'undefined') && (!((Math.imul((4294967295),(5)) === (0))))){
cljs.core.imul = (function cljs$core$imul(a,b){
return Math.imul(a,b);
});
} else {
cljs.core.imul = (function cljs$core$imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = ((3432918353) | (0));
cljs.core.m3_C2 = ((461845907) | (0));
cljs.core.m3_mix_K1 = (function cljs$core$m3_mix_K1(k1){
return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul((k1 | (0)),cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function cljs$core$m3_mix_H1(h1,k1){
return ((cljs.core.imul(cljs.core.int_rotate_left(((h1 | (0)) ^ (k1 | (0))),(13)),(5)) + ((3864292196) | (0))) | (0));
});
cljs.core.m3_fmix = (function cljs$core$m3_fmix(h1,len){
var h1__$1 = (h1 | (0));
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul(h1__$3,((2246822507) | (0)));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul(h1__$5,((3266489909) | (0)));
return (h1__$6 ^ (h1__$6 >>> (16)));
});
cljs.core.m3_hash_int = (function cljs$core$m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1(in$);
var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);
return cljs.core.m3_fmix(h1,(4));
}
});
cljs.core.m3_hash_unencoded_chars = (function cljs$core$m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__22445 = (i + (2));
var G__22446 = cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__22445;
h1 = G__22446;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));
});



cljs.core.string_hash_cache = {};
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function cljs$core$hash_string_STAR_(s){
if(!((s == null))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__22449 = (i + (1));
var G__22450 = (cljs.core.imul((31),hash) + s.charCodeAt(i));
i = G__22449;
hash = G__22450;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function cljs$core$add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_(k);
(cljs.core.string_hash_cache[k] = h);

cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1));

return h;
});
cljs.core.hash_string = (function cljs$core$hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
cljs.core.string_hash_cache = {};

cljs.core.string_hash_cache_count = (0);
} else {
}

if((k == null)){
return (0);
} else {
var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache(k);
}
}
});
/**
 * Returns the hash code of its argument. Note this is the hash code
 * consistent with =.
 */
cljs.core.hash = (function cljs$core$hash(o){
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (4194304))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IHash$)))?true:false):false)){
return o.cljs$core$IHash$_hash$arity$1(null);
} else {
if(typeof o === 'number'){
if(cljs.core.truth_(isFinite(o))){
return (Math.floor(o) % (2147483647));
} else {
var G__22458 = o;
switch (G__22458) {
case Infinity:
return (2146435072);

break;
case -Infinity:
return (-1048576);

break;
default:
return (2146959360);

}
}
} else {
if(o === true){
return (1231);
} else {
if(o === false){
return (1237);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int(cljs.core.hash_string(o));
} else {
if((o instanceof Date)){
return o.valueOf();
} else {
if((o == null)){
return (0);
} else {
return cljs.core._hash(o);

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function cljs$core$hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
/**
 * Evaluates x and tests if it is an instance of the type
 *   c. Returns true or false
 */
cljs.core.instance_QMARK_ = (function cljs$core$instance_QMARK_(c,x){
return (x instanceof c);
});
/**
 * Return true if x is a Symbol
 */
cljs.core.symbol_QMARK_ = (function cljs$core$symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function cljs$core$hash_symbol(sym){
return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));
});
cljs.core.compare_symbols = (function cljs$core$compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__6531__auto__ = cljs.core.not(a.ns);
if(and__6531__auto__){
return b.ns;
} else {
return and__6531__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__22466 = a.ns;
var G__22467 = b.ns;
return goog.array.defaultCompare(G__22466,G__22467);
})();
if(((0) === nsc)){
var G__22468 = a.name;
var G__22469 = b.name;
return goog.array.defaultCompare(G__22468,G__22469);
} else {
return nsc;
}
}
} else {
var G__22470 = a.name;
var G__22471 = b.name;
return goog.array.defaultCompare(G__22470,G__22471);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Symbol.prototype.toString = (function (){
var self__ = this;
var _ = this;
return self__.str;
});

cljs.core.Symbol.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
});

cljs.core.Symbol.prototype.call = (function() {
var G__22473 = null;
var G__22473__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$2 ? cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym) : cljs.core.get.call(null,coll,sym));
});
var G__22473__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$3 ? cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found) : cljs.core.get.call(null,coll,sym,not_found));
});
G__22473 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__22473__2.call(this,self__,coll);
case 3:
return G__22473__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22473.cljs$core$IFn$_invoke$arity$2 = G__22473__2;
G__22473.cljs$core$IFn$_invoke$arity$3 = G__22473__3;
return G__22473;
})()
;

cljs.core.Symbol.prototype.apply = (function (self__,args22472){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args22472)));
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var sym = this;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$2 ? cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym) : cljs.core.get.call(null,coll,sym));
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var sym = this;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$3 ? cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found) : cljs.core.get.call(null,coll,sym,not_found));
});

cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
});

cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function (sym){
var self__ = this;
var sym__$1 = this;
var h__6978__auto__ = self__._hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_symbol(sym__$1);
self__._hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,self__.str);
});

cljs.core.Symbol.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns,cljs.core.cst$sym$name,cljs.core.cst$sym$str,cljs.core.with_meta(cljs.core.cst$sym$_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$_meta], null);
});

cljs.core.Symbol.cljs$lang$type = true;

cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";

cljs.core.Symbol.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/Symbol");
});

cljs.core.__GT_Symbol = (function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

/**
 * Returns a Symbol with the given namespace and name.
 */
cljs.core.symbol = (function cljs$core$symbol(var_args){
var args22474 = [];
var len__7651__auto___22477 = arguments.length;
var i__7652__auto___22478 = (0);
while(true){
if((i__7652__auto___22478 < len__7651__auto___22477)){
args22474.push((arguments[i__7652__auto___22478]));

var G__22479 = (i__7652__auto___22478 + (1));
i__7652__auto___22478 = G__22479;
continue;
} else {
}
break;
}

var G__22476 = args22474.length;
switch (G__22476) {
case 1:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22474.length)].join('')));

}
});

cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = (function (name){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
var idx = name.indexOf("/");
if((idx < (1))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null,name);
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(name.substring((0),idx),name.substring((idx + (1)),name.length));
}
}
});

cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
var sym_str = ((!((ns == null)))?[cljs.core.str(ns),cljs.core.str("/"),cljs.core.str(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
});

cljs.core.symbol.cljs$lang$maxFixedArity = 2;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IDeref}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 6717441;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Var.prototype.isMacro = (function (){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).cljs$lang$macro;
});

cljs.core.Var.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [cljs.core.str("#'"),cljs.core.str(self__.sym)].join('');
});

cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
});

cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Var.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Var(self__.val,self__.sym,new_meta));
});

cljs.core.Var.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
if((other instanceof cljs.core.Var)){
var G__22482 = this$__$1.sym;
var G__22483 = other.sym;
return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(G__22482,G__22483) : cljs.core._EQ_.call(null,G__22482,G__22483));
} else {
return false;
}
});

cljs.core.Var.prototype.cljs$core$IHash$_hash$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.hash_symbol(self__.sym);
});

cljs.core.Var.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Var.prototype.call = (function() {
var G__22528 = null;
var G__22528__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null);
});
var G__22528__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a);
});
var G__22528__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b);
});
var G__22528__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c);
});
var G__22528__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d);
});
var G__22528__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e);
});
var G__22528__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f);
});
var G__22528__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g);
});
var G__22528__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h);
});
var G__22528__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i);
});
var G__22528__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j);
});
var G__22528__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k);
});
var G__22528__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});
var G__22528__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});
var G__22528__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});
var G__22528__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});
var G__22528__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});
var G__22528__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});
var G__22528__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});
var G__22528__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});
var G__22528__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});
var G__22528__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__22484 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
var G__22485 = a;
var G__22486 = b;
var G__22487 = c;
var G__22488 = d;
var G__22489 = e;
var G__22490 = f;
var G__22491 = g;
var G__22492 = h;
var G__22493 = i;
var G__22494 = j;
var G__22495 = k;
var G__22496 = l;
var G__22497 = m;
var G__22498 = n;
var G__22499 = o;
var G__22500 = p;
var G__22501 = q;
var G__22502 = r;
var G__22503 = s;
var G__22504 = t;
var G__22505 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__22484,G__22485,G__22486,G__22487,G__22488,G__22489,G__22490,G__22491,G__22492,G__22493,G__22494,G__22495,G__22496,G__22497,G__22498,G__22499,G__22500,G__22501,G__22502,G__22503,G__22504,G__22505) : cljs.core.apply.call(null,G__22484,G__22485,G__22486,G__22487,G__22488,G__22489,G__22490,G__22491,G__22492,G__22493,G__22494,G__22495,G__22496,G__22497,G__22498,G__22499,G__22500,G__22501,G__22502,G__22503,G__22504,G__22505));
});
G__22528 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__22528__1.call(this,self__);
case 2:
return G__22528__2.call(this,self__,a);
case 3:
return G__22528__3.call(this,self__,a,b);
case 4:
return G__22528__4.call(this,self__,a,b,c);
case 5:
return G__22528__5.call(this,self__,a,b,c,d);
case 6:
return G__22528__6.call(this,self__,a,b,c,d,e);
case 7:
return G__22528__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__22528__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__22528__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__22528__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__22528__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__22528__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__22528__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__22528__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__22528__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__22528__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__22528__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__22528__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__22528__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__22528__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__22528__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__22528__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22528.cljs$core$IFn$_invoke$arity$1 = G__22528__1;
G__22528.cljs$core$IFn$_invoke$arity$2 = G__22528__2;
G__22528.cljs$core$IFn$_invoke$arity$3 = G__22528__3;
G__22528.cljs$core$IFn$_invoke$arity$4 = G__22528__4;
G__22528.cljs$core$IFn$_invoke$arity$5 = G__22528__5;
G__22528.cljs$core$IFn$_invoke$arity$6 = G__22528__6;
G__22528.cljs$core$IFn$_invoke$arity$7 = G__22528__7;
G__22528.cljs$core$IFn$_invoke$arity$8 = G__22528__8;
G__22528.cljs$core$IFn$_invoke$arity$9 = G__22528__9;
G__22528.cljs$core$IFn$_invoke$arity$10 = G__22528__10;
G__22528.cljs$core$IFn$_invoke$arity$11 = G__22528__11;
G__22528.cljs$core$IFn$_invoke$arity$12 = G__22528__12;
G__22528.cljs$core$IFn$_invoke$arity$13 = G__22528__13;
G__22528.cljs$core$IFn$_invoke$arity$14 = G__22528__14;
G__22528.cljs$core$IFn$_invoke$arity$15 = G__22528__15;
G__22528.cljs$core$IFn$_invoke$arity$16 = G__22528__16;
G__22528.cljs$core$IFn$_invoke$arity$17 = G__22528__17;
G__22528.cljs$core$IFn$_invoke$arity$18 = G__22528__18;
G__22528.cljs$core$IFn$_invoke$arity$19 = G__22528__19;
G__22528.cljs$core$IFn$_invoke$arity$20 = G__22528__20;
G__22528.cljs$core$IFn$_invoke$arity$21 = G__22528__21;
G__22528.cljs$core$IFn$_invoke$arity$22 = G__22528__22;
return G__22528;
})()
;

cljs.core.Var.prototype.apply = (function (self__,args22481){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args22481)));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__22506 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
var G__22507 = a;
var G__22508 = b;
var G__22509 = c;
var G__22510 = d;
var G__22511 = e;
var G__22512 = f;
var G__22513 = g;
var G__22514 = h;
var G__22515 = i;
var G__22516 = j;
var G__22517 = k;
var G__22518 = l;
var G__22519 = m;
var G__22520 = n;
var G__22521 = o;
var G__22522 = p;
var G__22523 = q;
var G__22524 = r;
var G__22525 = s;
var G__22526 = t;
var G__22527 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__22506,G__22507,G__22508,G__22509,G__22510,G__22511,G__22512,G__22513,G__22514,G__22515,G__22516,G__22517,G__22518,G__22519,G__22520,G__22521,G__22522,G__22523,G__22524,G__22525,G__22526,G__22527) : cljs.core.apply.call(null,G__22506,G__22507,G__22508,G__22509,G__22510,G__22511,G__22512,G__22513,G__22514,G__22515,G__22516,G__22517,G__22518,G__22519,G__22520,G__22521,G__22522,G__22523,G__22524,G__22525,G__22526,G__22527));
});

cljs.core.Var.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$val,cljs.core.cst$sym$sym,cljs.core.cst$sym$_meta], null);
});

cljs.core.Var.cljs$lang$type = true;

cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";

cljs.core.Var.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/Var");
});

cljs.core.__GT_Var = (function cljs$core$__GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});

/**
 * Returns true if v is of type cljs.core.Var
 */
cljs.core.var_QMARK_ = (function cljs$core$var_QMARK_(v){
return (v instanceof cljs.core.Var);
});


/**
 * Return true if x implements IIterable protocol.
 */
cljs.core.iterable_QMARK_ = (function cljs$core$iterable_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIterable$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
}
});
/**
 * Clone the supplied value which must implement ICloneable.
 */
cljs.core.clone = (function cljs$core$clone(value){
return cljs.core._clone(value);
});
/**
 * Return true if x implements ICloneable protocol.
 */
cljs.core.cloneable_QMARK_ = (function cljs$core$cloneable_QMARK_(value){
if(!((value == null))){
if(((value.cljs$lang$protocol_mask$partition1$ & (8192))) || ((cljs.core.PROTOCOL_SENTINEL === value.cljs$core$ICloneable$))){
return true;
} else {
if((!value.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
}
});
/**
 * Returns a seq on the collection. If the collection is
 *   empty, returns nil.  (seq nil) returns nil. seq also works on
 *   Strings.
 */
cljs.core.seq = (function cljs$core$seq(coll){
if((coll == null)){
return null;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$)))?true:false):false)){
return coll.cljs$core$ISeqable$_seq$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){
return cljs.core._seq(coll);
} else {
throw (new Error([cljs.core.str(coll),cljs.core.str(" is not ISeqable")].join('')));

}
}
}
}
}
});
/**
 * Returns the first item in the collection. Calls seq on its
 *   argument. If coll is nil, returns nil.
 */
cljs.core.first = (function cljs$core$first(coll){
if((coll == null)){
return null;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$)))?true:false):false)){
return coll.cljs$core$ISeq$_first$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if((s == null)){
return null;
} else {
return cljs.core._first(s);
}
}
}
});
/**
 * Returns a possibly empty seq of the items after the first. Calls seq on its
 *   argument.
 */
cljs.core.rest = (function cljs$core$rest(coll){
if(!((coll == null))){
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$)))?true:false):false)){
return coll.cljs$core$ISeq$_rest$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if(s){
return cljs.core._rest(s);
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a seq of the items after the first. Calls seq on its
 *   argument.  If there are no more items, returns nil
 */
cljs.core.next = (function cljs$core$next(coll){
if((coll == null)){
return null;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$)))?true:false):false)){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
}
});
/**
 * Equality. Returns true if x equals y, false if not. Compares
 *   numbers and collections in a type-independent manner.  Clojure's immutable data
 *   structures define -equiv (and thus =) as a value, not an identity,
 *   comparison.
 */
cljs.core._EQ_ = (function cljs$core$_EQ_(var_args){
var args22541 = [];
var len__7651__auto___22547 = arguments.length;
var i__7652__auto___22548 = (0);
while(true){
if((i__7652__auto___22548 < len__7651__auto___22547)){
args22541.push((arguments[i__7652__auto___22548]));

var G__22549 = (i__7652__auto___22548 + (1));
i__7652__auto___22548 = G__22549;
continue;
} else {
}
break;
}

var G__22546 = args22541.length;
switch (G__22546) {
case 1:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args22541.slice((2)),(0),null));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
if((x == null)){
return (y == null);
} else {
return ((x === y)) || (cljs.core._equiv(x,y));
}
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__22551 = y;
var G__22552 = cljs.core.first(more);
var G__22553 = cljs.core.next(more);
x = G__22551;
y = G__22552;
more = G__22553;
continue;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._EQ_.cljs$lang$applyTo = (function (seq22542){
var G__22543 = cljs.core.first(seq22542);
var seq22542__$1 = cljs.core.next(seq22542);
var G__22544 = cljs.core.first(seq22542__$1);
var seq22542__$2 = cljs.core.next(seq22542__$1);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(G__22543,G__22544,seq22542__$2);
});

cljs.core._EQ_.cljs$lang$maxFixedArity = (2);


/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
})
cljs.core.ES6Iterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return ({"value": x, "done": false});
} else {
return ({"value": null, "done": true});
}
});

cljs.core.ES6Iterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ES6Iterator.cljs$lang$type = true;

cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";

cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ES6Iterator");
});

cljs.core.__GT_ES6Iterator = (function cljs$core$__GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

/**
 * EXPERIMENTAL: Return a ES2015 compatible iterator for coll.
 */
cljs.core.es6_iterator = (function cljs$core$es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq(coll)));
});

/**
* @constructor
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.value;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
self__._rest = (cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(self__.iter) : cljs.core.es6_iterator_seq.call(null,self__.iter));
} else {
}

return self__._rest;
});

cljs.core.ES6IteratorSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value,cljs.core.cst$sym$iter,cljs.core.with_meta(cljs.core.cst$sym$_rest,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ES6IteratorSeq.cljs$lang$type = true;

cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";

cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ES6IteratorSeq");
});

cljs.core.__GT_ES6IteratorSeq = (function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

/**
 * EXPERIMENTAL: Given an ES2015 compatible iterator return a seq.
 */
cljs.core.es6_iterator_seq = (function cljs$core$es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return cljs.core.List.EMPTY;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
 * Mix final collection hash for ordered or unordered collections.
 * hash-basis is the combined collection hash, count is the number
 * of elements included in the basis. Note this is the hash code
 * consistent with =, different from .hashCode.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.mix_collection_hash = (function cljs$core$mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1(hash_basis);
var h1__$1 = cljs.core.m3_mix_H1(h1,k1);
return cljs.core.m3_fmix(h1__$1,count);
});
/**
 * Returns the hash code, consistent with =, for an external ordered
 * collection implementing Iterable.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_ordered_coll = (function cljs$core$hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__22554 = (n + (1));
var G__22555 = ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__22556 = cljs.core.next(coll__$1);
n = G__22554;
hash_code = G__22555;
coll__$1 = G__22556;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash((1),(0));
/**
 * Returns the hash code, consistent with =, for an external unordered
 * collection implementing Iterable. For maps, the iterator should
 * return map entries whose hash is computed as
 *   (hash-ordered-coll [k v]).
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_unordered_coll = (function cljs$core$hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__22557 = (n + (1));
var G__22558 = ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__22559 = cljs.core.next(coll__$1);
n = G__22557;
hash_code = G__22558;
coll__$1 = G__22559;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash((0),(0));


(cljs.core.ICounted["null"] = true);

(cljs.core._count["null"] = (function (_){
return (0);
}));
Date.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL;

Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var o__$1 = this;
return ((other instanceof Date)) && ((o__$1.valueOf() === other.valueOf()));
});

Date.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL;

Date.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof Date)){
var G__22560 = this$__$1.valueOf();
var G__22561 = other.valueOf();
return goog.array.defaultCompare(G__22560,G__22561);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});

/**
 * @interface
 */
cljs.core.Inst = function(){};

cljs.core.inst_ms_STAR_ = (function cljs$core$inst_ms_STAR_(inst){
if((!((inst == null))) && (!((inst.cljs$core$Inst$inst_ms_STAR_$arity$1 == null)))){
return inst.cljs$core$Inst$inst_ms_STAR_$arity$1(inst);
} else {
var x__7206__auto__ = (((inst == null))?null:inst);
var m__7207__auto__ = (cljs.core.inst_ms_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__7207__auto__.call(null,inst));
} else {
var m__7207__auto____$1 = (cljs.core.inst_ms_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(inst) : m__7207__auto____$1.call(null,inst));
} else {
throw cljs.core.missing_protocol("Inst.inst-ms*",inst);
}
}
}
});

Date.prototype.cljs$core$Inst$ = cljs.core.PROTOCOL_SENTINEL;

Date.prototype.cljs$core$Inst$inst_ms_STAR_$arity$1 = (function (inst){
var inst__$1 = this;
return inst__$1.getTime();
});
/**
 * Return the number of milliseconds since January 1, 1970, 00:00:00 GMT
 */
cljs.core.inst_ms = (function cljs$core$inst_ms(inst){
return cljs.core.inst_ms_STAR_(inst);
});
/**
 * Return true if x satisfies Inst
 */
cljs.core.inst_QMARK_ = (function cljs$core$inst_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$Inst$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
}
});
(cljs.core.IEquiv["number"] = true);

(cljs.core._equiv["number"] = (function (x,o){
return (x === o);
}));
(cljs.core.Fn["function"] = true);

(cljs.core.IMeta["function"] = true);

(cljs.core._meta["function"] = (function (_){
return null;
}));
(cljs.core.IHash["_"] = true);

(cljs.core._hash["_"] = (function (o){
return goog.getUid(o);
}));
/**
 * Returns a number one greater than num.
 */
cljs.core.inc = (function cljs$core$inc(x){
return (x + (1));
});

/**
* @constructor
 * @implements {cljs.core.IDeref}
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function (o){
var self__ = this;
var o__$1 = this;
return self__.val;
});

cljs.core.Reduced.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$val], null);
});

cljs.core.Reduced.cljs$lang$type = true;

cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";

cljs.core.Reduced.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/Reduced");
});

cljs.core.__GT_Reduced = (function cljs$core$__GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
 * Wraps x in a way such that a reduce will terminate with the value x
 */
cljs.core.reduced = (function cljs$core$reduced(x){
return (new cljs.core.Reduced(x));
});
/**
 * Returns true if x is the result of a call to reduced
 */
cljs.core.reduced_QMARK_ = (function cljs$core$reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
 * If x is already reduced?, returns it, else returns (reduced x)
 */
cljs.core.ensure_reduced = (function cljs$core$ensure_reduced(x){
if(cljs.core.reduced_QMARK_(x)){
return x;
} else {
return cljs.core.reduced(x);
}
});
/**
 * If x is reduced?, returns (deref x), else returns x
 */
cljs.core.unreduced = (function cljs$core$unreduced(x){
if(cljs.core.reduced_QMARK_(x)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(x) : cljs.core.deref.call(null,x));
} else {
return x;
}
});
/**
 * Also reader macro: @var/@atom/@delay. Returns the
 * most-recently-committed value of ref. When applied to a var
 * or atom, returns its current state. When applied to a delay, forces
 * it if not already forced. See also - realized?.
 */
cljs.core.deref = (function cljs$core$deref(o){
return cljs.core._deref(o);
});
/**
 * Accepts any collection which satisfies the ICount and IIndexed protocols and
 * reduces them without incurring seq initialization
 */
cljs.core.ci_reduce = (function cljs$core$ci_reduce(var_args){
var args22564 = [];
var len__7651__auto___22573 = arguments.length;
var i__7652__auto___22574 = (0);
while(true){
if((i__7652__auto___22574 < len__7651__auto___22573)){
args22564.push((arguments[i__7652__auto___22574]));

var G__22575 = (i__7652__auto___22574 + (1));
i__7652__auto___22574 = G__22575;
continue;
} else {
}
break;
}

var G__22566 = args22564.length;
switch (G__22566) {
case 2:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22564.length)].join('')));

}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = (function (cicoll,f){
var cnt = cljs.core._count(cicoll);
if((cnt === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,(0));
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__22567 = val;
var G__22568 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__22567,G__22568) : f.call(null,G__22567,G__22568));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__22577 = nval;
var G__22578 = (n + (1));
val = G__22577;
n = G__22578;
continue;
}
} else {
return val;
}
break;
}
}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = (function (cicoll,f,val){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__22569 = val__$1;
var G__22570 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__22569,G__22570) : f.call(null,G__22569,G__22570));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__22579 = nval;
var G__22580 = (n + (1));
val__$1 = G__22579;
n = G__22580;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4 = (function (cicoll,f,val,idx){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__22571 = val__$1;
var G__22572 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__22571,G__22572) : f.call(null,G__22571,G__22572));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__22581 = nval;
var G__22582 = (n + (1));
val__$1 = G__22581;
n = G__22582;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.ci_reduce.cljs$lang$maxFixedArity = 4;

cljs.core.array_reduce = (function cljs$core$array_reduce(var_args){
var args22583 = [];
var len__7651__auto___22592 = arguments.length;
var i__7652__auto___22593 = (0);
while(true){
if((i__7652__auto___22593 < len__7651__auto___22592)){
args22583.push((arguments[i__7652__auto___22593]));

var G__22594 = (i__7652__auto___22593 + (1));
i__7652__auto___22593 = G__22594;
continue;
} else {
}
break;
}

var G__22585 = args22583.length;
switch (G__22585) {
case 2:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22583.length)].join('')));

}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = (function (arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__22586 = val;
var G__22587 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__22586,G__22587) : f.call(null,G__22586,G__22587));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__22596 = nval;
var G__22597 = (n + (1));
val = G__22596;
n = G__22597;
continue;
}
} else {
return val;
}
break;
}
}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = (function (arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__22588 = val__$1;
var G__22589 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__22588,G__22589) : f.call(null,G__22588,G__22589));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__22598 = nval;
var G__22599 = (n + (1));
val__$1 = G__22598;
n = G__22599;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = (function (arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__22590 = val__$1;
var G__22591 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__22590,G__22591) : f.call(null,G__22590,G__22591));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__22600 = nval;
var G__22601 = (n + (1));
val__$1 = G__22600;
n = G__22601;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.array_reduce.cljs$lang$maxFixedArity = 4;







/**
 * Returns true if coll implements count in constant time
 */
cljs.core.counted_QMARK_ = (function cljs$core$counted_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICounted$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
}
});
/**
 * Returns true if coll implements nth in constant time
 */
cljs.core.indexed_QMARK_ = (function cljs$core$indexed_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIndexed$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
}
});
cljs.core._indexOf = (function cljs$core$_indexOf(var_args){
var args22606 = [];
var len__7651__auto___22609 = arguments.length;
var i__7652__auto___22610 = (0);
while(true){
if((i__7652__auto___22610 < len__7651__auto___22609)){
args22606.push((arguments[i__7652__auto___22610]));

var G__22611 = (i__7652__auto___22610 + (1));
i__7652__auto___22610 = G__22611;
continue;
} else {
}
break;
}

var G__22608 = args22606.length;
switch (G__22608) {
case 2:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22606.length)].join('')));

}
});

cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});

cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3 = (function (coll,x,start){
var len = (cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll));
if((start >= len)){
return (-1);
} else {
var idx = (((start > (0)))?start:(((start < (0)))?(function (){var x__6874__auto__ = (0);
var y__6875__auto__ = (start + len);
return ((x__6874__auto__ > y__6875__auto__) ? x__6874__auto__ : y__6875__auto__);
})():start
));
while(true){
if((idx < len)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((cljs.core.nth.cljs$core$IFn$_invoke$arity$2 ? cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx) : cljs.core.nth.call(null,coll,idx)),x)){
return idx;
} else {
var G__22613 = (idx + (1));
idx = G__22613;
continue;
}
} else {
return (-1);
}
break;
}
}
});

cljs.core._indexOf.cljs$lang$maxFixedArity = 3;

cljs.core._lastIndexOf = (function cljs$core$_lastIndexOf(var_args){
var args22614 = [];
var len__7651__auto___22617 = arguments.length;
var i__7652__auto___22618 = (0);
while(true){
if((i__7652__auto___22618 < len__7651__auto___22617)){
args22614.push((arguments[i__7652__auto___22618]));

var G__22619 = (i__7652__auto___22618 + (1));
i__7652__auto___22618 = G__22619;
continue;
} else {
}
break;
}

var G__22616 = args22614.length;
switch (G__22616) {
case 2:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22614.length)].join('')));

}
});

cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll)));
});

cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3 = (function (coll,x,start){
var len = (cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll));
if((len === (0))){
return (-1);
} else {
var idx = (((start > (0)))?(function (){var x__6881__auto__ = (len - (1));
var y__6882__auto__ = start;
return ((x__6881__auto__ < y__6882__auto__) ? x__6881__auto__ : y__6882__auto__);
})():(((start < (0)))?(len + start):start
));
while(true){
if((idx >= (0))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((cljs.core.nth.cljs$core$IFn$_invoke$arity$2 ? cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx) : cljs.core.nth.call(null,coll,idx)),x)){
return idx;
} else {
var G__22621 = (idx - (1));
idx = G__22621;
continue;
}
} else {
return (-1);
}
break;
}
}
});

cljs.core._lastIndexOf.cljs$lang$maxFixedArity = 3;


/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.IndexedSeqIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.IndexedSeqIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.IndexedSeqIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.IndexedSeqIterator.cljs$lang$type = true;

cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";

cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/IndexedSeqIterator");
});

cljs.core.__GT_IndexedSeqIterator = (function cljs$core$__GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.IndexedSeq = (function (arr,i,meta){
this.arr = arr;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 166592766;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.IndexedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.IndexedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.IndexedSeq.prototype.indexOf = (function() {
var G__22622 = null;
var G__22622__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__22622__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__22622 = function(x,start){
switch(arguments.length){
case 1:
return G__22622__1.call(this,x);
case 2:
return G__22622__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22622.cljs$core$IFn$_invoke$arity$1 = G__22622__1;
G__22622.cljs$core$IFn$_invoke$arity$2 = G__22622__2;
return G__22622;
})()
;

cljs.core.IndexedSeq.prototype.lastIndexOf = (function() {
var G__22623 = null;
var G__22623__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll)));
});
var G__22623__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__22623 = function(x,start){
switch(arguments.length){
case 1:
return G__22623__1.call(this,x);
case 2:
return G__22623__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22623.cljs$core$IFn$_invoke$arity$1 = G__22623__1;
G__22623.cljs$core$IFn$_invoke$arity$2 = G__22623__2;
return G__22623;
})()
;

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return not_found;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i,self__.meta));
});

cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var x__6874__auto__ = (0);
var y__6875__auto__ = (self__.arr.length - self__.i);
return ((x__6874__auto__ > y__6875__auto__) ? x__6874__auto__ : y__6875__auto__);
});

cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var c = cljs.core._count(coll__$1);
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1,other) : cljs.core.equiv_sequential.call(null,coll__$1,other));
});

cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.i < self__.arr.length)){
return this$__$1;
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i,new_meta));
});

cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o,coll__$1) : cljs.core.cons.call(null,o,coll__$1));
});

cljs.core.IndexedSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$meta], null);
});

cljs.core.IndexedSeq.cljs$lang$type = true;

cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";

cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/IndexedSeq");
});

cljs.core.__GT_IndexedSeq = (function cljs$core$__GT_IndexedSeq(arr,i,meta){
return (new cljs.core.IndexedSeq(arr,i,meta));
});

(cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
/**
 * Create seq from a primitive JavaScript Array-like.
 */
cljs.core.prim_seq = (function cljs$core$prim_seq(var_args){
var args22624 = [];
var len__7651__auto___22627 = arguments.length;
var i__7652__auto___22628 = (0);
while(true){
if((i__7652__auto___22628 < len__7651__auto___22627)){
args22624.push((arguments[i__7652__auto___22628]));

var G__22629 = (i__7652__auto___22628 + (1));
i__7652__auto___22628 = G__22629;
continue;
} else {
}
break;
}

var G__22626 = args22624.length;
switch (G__22626) {
case 1:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22624.length)].join('')));

}
});

cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = (function (prim){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));
});

cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = (function (prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i,null));
} else {
return null;
}
});

cljs.core.prim_seq.cljs$lang$maxFixedArity = 2;

/**
 * Create a seq from a JavaScript array.
 */
cljs.core.array_seq = (function cljs$core$array_seq(var_args){
var args22631 = [];
var len__7651__auto___22634 = arguments.length;
var i__7652__auto___22635 = (0);
while(true){
if((i__7652__auto___22635 < len__7651__auto___22634)){
args22631.push((arguments[i__7652__auto___22635]));

var G__22636 = (i__7652__auto___22635 + (1));
i__7652__auto___22635 = G__22636;
continue;
} else {
}
break;
}

var G__22633 = args22631.length;
switch (G__22633) {
case 1:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22631.length)].join('')));

}
});

cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = (function (array){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));
});

cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = (function (array,i){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);
});

cljs.core.array_seq.cljs$lang$maxFixedArity = 2;



/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.RSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.RSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.RSeq.prototype.indexOf = (function() {
var G__22640 = null;
var G__22640__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__22640__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__22640 = function(x,start){
switch(arguments.length){
case 1:
return G__22640__1.call(this,x);
case 2:
return G__22640__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22640.cljs$core$IFn$_invoke$arity$1 = G__22640__1;
G__22640.cljs$core$IFn$_invoke$arity$2 = G__22640__2;
return G__22640;
})()
;

cljs.core.RSeq.prototype.lastIndexOf = (function() {
var G__22641 = null;
var G__22641__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll)));
});
var G__22641__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__22641 = function(x,start){
switch(arguments.length){
case 1:
return G__22641__1.call(this,x);
case 2:
return G__22641__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22641.cljs$core$IFn$_invoke$arity$1 = G__22641__1;
G__22641.cljs$core$IFn$_invoke$arity$2 = G__22641__2;
return G__22641;
})()
;

cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
});

cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
});

cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
});

cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1,other) : cljs.core.equiv_sequential.call(null,coll__$1,other));
});

cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__22638 = cljs.core.List.EMPTY;
var G__22639 = self__.meta;
return (cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2(G__22638,G__22639) : cljs.core.with_meta.call(null,G__22638,G__22639));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (col,f){
var self__ = this;
var col__$1 = this;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,col__$1) : cljs.core.seq_reduce.call(null,f,col__$1));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (col,f,start){
var self__ = this;
var col__$1 = this;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,col__$1) : cljs.core.seq_reduce.call(null,f,start,col__$1));
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci,self__.i);
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
});

cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o,coll__$1) : cljs.core.cons.call(null,o,coll__$1));
});

cljs.core.RSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ci,cljs.core.cst$sym$i,cljs.core.cst$sym$meta], null);
});

cljs.core.RSeq.cljs$lang$type = true;

cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";

cljs.core.RSeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/RSeq");
});

cljs.core.__GT_RSeq = (function cljs$core$__GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

(cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
/**
 * Same as (first (next x))
 */
cljs.core.second = (function cljs$core$second(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (first (first x))
 */
cljs.core.ffirst = (function cljs$core$ffirst(coll){
return cljs.core.first(cljs.core.first(coll));
});
/**
 * Same as (next (first x))
 */
cljs.core.nfirst = (function cljs$core$nfirst(coll){
return cljs.core.next(cljs.core.first(coll));
});
/**
 * Same as (first (next x))
 */
cljs.core.fnext = (function cljs$core$fnext(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (next (next x))
 */
cljs.core.nnext = (function cljs$core$nnext(coll){
return cljs.core.next(cljs.core.next(coll));
});
/**
 * Return the last item in coll, in linear time
 */
cljs.core.last = (function cljs$core$last(s){
while(true){
var sn = cljs.core.next(s);
if(!((sn == null))){
var G__22642 = sn;
s = G__22642;
continue;
} else {
return cljs.core.first(s);
}
break;
}
});
(cljs.core.IEquiv["_"] = true);

(cljs.core._equiv["_"] = (function (x,o){
return (x === o);
}));
/**
 * conj[oin]. Returns a new collection with the xs
 *   'added'. (conj nil item) returns (item).  The 'addition' may
 *   happen at different 'places' depending on the concrete type.
 */
cljs.core.conj = (function cljs$core$conj(var_args){
var args22643 = [];
var len__7651__auto___22649 = arguments.length;
var i__7652__auto___22650 = (0);
while(true){
if((i__7652__auto___22650 < len__7651__auto___22649)){
args22643.push((arguments[i__7652__auto___22650]));

var G__22651 = (i__7652__auto___22650 + (1));
i__7652__auto___22650 = G__22651;
continue;
} else {
}
break;
}

var G__22648 = args22643.length;
switch (G__22648) {
case 0:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args22643.slice((2)),(0),null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
if(!((coll == null))){
return cljs.core._conj(coll,x);
} else {
var x__7380__auto__ = x;
return cljs.core._conj(cljs.core.List.EMPTY,x__7380__auto__);
}
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__22653 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
var G__22654 = cljs.core.first(xs);
var G__22655 = cljs.core.next(xs);
coll = G__22653;
x = G__22654;
xs = G__22655;
continue;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
break;
}
});

cljs.core.conj.cljs$lang$applyTo = (function (seq22644){
var G__22645 = cljs.core.first(seq22644);
var seq22644__$1 = cljs.core.next(seq22644);
var G__22646 = cljs.core.first(seq22644__$1);
var seq22644__$2 = cljs.core.next(seq22644__$1);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(G__22645,G__22646,seq22644__$2);
});

cljs.core.conj.cljs$lang$maxFixedArity = (2);

/**
 * Returns an empty collection of the same category as coll, or nil
 */
cljs.core.empty = (function cljs$core$empty(coll){
if((coll == null)){
return null;
} else {
return cljs.core._empty(coll);
}
});
cljs.core.accumulating_seq_count = (function cljs$core$accumulating_seq_count(coll){
var s = cljs.core.seq(coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_(s)){
return (acc + cljs.core._count(s));
} else {
var G__22656 = cljs.core.next(s);
var G__22657 = (acc + (1));
s = G__22656;
acc = G__22657;
continue;
}
break;
}
});
/**
 * Returns the number of items in the collection. (count nil) returns
 *   0.  Also works on strings, arrays, and Maps
 */
cljs.core.count = (function cljs$core$count(coll){
if(!((coll == null))){
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ICounted$)))?true:false):false)){
return coll.cljs$core$ICounted$_count$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$)))?true:false):false)){
return cljs.core.accumulating_seq_count(coll);
} else {
return cljs.core._count(coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function cljs$core$linear_traversal_nth(var_args){
var args22662 = [];
var len__7651__auto___22665 = arguments.length;
var i__7652__auto___22666 = (0);
while(true){
if((i__7652__auto___22666 < len__7651__auto___22665)){
args22662.push((arguments[i__7652__auto___22666]));

var G__22667 = (i__7652__auto___22666 + (1));
i__7652__auto___22666 = G__22667;
continue;
} else {
}
break;
}

var G__22664 = args22662.length;
switch (G__22664) {
case 2:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22662.length)].join('')));

}
});

cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.seq(coll)){
var G__22669 = cljs.core.next(coll);
var G__22670 = (n - (1));
coll = G__22669;
n = G__22670;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
});

cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.seq(coll)){
var G__22671 = cljs.core.next(coll);
var G__22672 = (n - (1));
var G__22673 = not_found;
coll = G__22671;
n = G__22672;
not_found = G__22673;
continue;
} else {
return not_found;

}
}
}
}
break;
}
});

cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3;

/**
 * Returns the value at the index. get returns nil if index out of
 *   bounds, nth throws an exception unless not-found is supplied.  nth
 *   also works for strings, arrays, regex Matchers and Lists, and,
 *   in O(n) time, for sequences.
 */
cljs.core.nth = (function cljs$core$nth(var_args){
var args22674 = [];
var len__7651__auto___22681 = arguments.length;
var i__7652__auto___22682 = (0);
while(true){
if((i__7652__auto___22682 < len__7651__auto___22681)){
args22674.push((arguments[i__7652__auto___22682]));

var G__22683 = (i__7652__auto___22682 + (1));
i__7652__auto___22682 = G__22683;
continue;
} else {
}
break;
}

var G__22676 = args22674.length;
switch (G__22676) {
case 2:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22674.length)].join('')));

}
});

cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if(!(typeof n === 'number')){
throw (new Error("Index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$)))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((n >= (0))) && ((n < coll.length))){
return (coll[n]);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(typeof coll === 'string'){
if(((n >= (0))) && ((n < coll.length))){
return coll.charAt(n);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$)))?true:false):false)){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});

cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if(!(typeof n === 'number')){
throw (new Error("Index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$)))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((n >= (0))) && ((n < coll.length))){
return (coll[n]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if(((n >= (0))) && ((n < coll.length))){
return coll.charAt(n);
} else {
return not_found;
}
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$)))?true:false):false)){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});

cljs.core.nth.cljs$lang$maxFixedArity = 3;

/**
 * Returns the nth rest of coll, coll when n is 0.
 */
cljs.core.nthrest = (function cljs$core$nthrest(coll,n){
var n__$1 = n;
var xs = coll;
while(true){
if(((n__$1 > (0))) && (cljs.core.seq(xs))){
var G__22685 = (n__$1 - (1));
var G__22686 = cljs.core.rest(xs);
n__$1 = G__22685;
xs = G__22686;
continue;
} else {
return xs;
}
break;
}
});
/**
 * Returns the value mapped to key, not-found or nil if key not present.
 */
cljs.core.get = (function cljs$core$get(var_args){
var args22687 = [];
var len__7651__auto___22692 = arguments.length;
var i__7652__auto___22693 = (0);
while(true){
if((i__7652__auto___22693 < len__7651__auto___22692)){
args22687.push((arguments[i__7652__auto___22693]));

var G__22694 = (i__7652__auto___22693 + (1));
i__7652__auto___22693 = G__22694;
continue;
} else {
}
break;
}

var G__22689 = args22687.length;
switch (G__22689) {
case 2:
return cljs.core.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22687.length)].join('')));

}
});

cljs.core.get.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((o == null)){
return null;
} else {
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$)))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$2(null,k);
} else {
if(cljs.core.array_QMARK_(o)){
if((k < o.length)){
return (o[(k | (0))]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((cljs.core.some_QMARK_(k)) && ((k < o.length))){
return (o[(k | (0))]);
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);
} else {
return null;

}
}
}
}
}
});

cljs.core.get.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if(!((o == null))){
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$)))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
} else {
if(cljs.core.array_QMARK_(o)){
if((k < o.length)){
return (o[(k | (0))]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[(k | (0))]);
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
});

cljs.core.get.cljs$lang$maxFixedArity = 3;

/**
 * assoc[iate]. When applied to a map, returns a new map of the
 * same (hashed/sorted) type, that contains the mapping of key(s) to
 * val(s). When applied to a vector, returns a new vector that
 * contains val at index.
 */
cljs.core.assoc = (function cljs$core$assoc(var_args){
var args22696 = [];
var len__7651__auto___22703 = arguments.length;
var i__7652__auto___22704 = (0);
while(true){
if((i__7652__auto___22704 < len__7651__auto___22703)){
args22696.push((arguments[i__7652__auto___22704]));

var G__22705 = (i__7652__auto___22704 + (1));
i__7652__auto___22704 = G__22705;
continue;
} else {
}
break;
}

var G__22702 = args22696.length;
switch (G__22702) {
case 3:
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args22696.slice((3)),(0),null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7670__auto__);

}
});

cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = (function (coll,k,v){
if(!((coll == null))){
return cljs.core._assoc(coll,k,v);
} else {
return cljs.core.PersistentHashMap.fromArrays([k],[v]);
}
});

cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,v,kvs){
while(true){
var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);
if(cljs.core.truth_(kvs)){
var G__22707 = ret;
var G__22708 = cljs.core.first(kvs);
var G__22709 = cljs.core.second(kvs);
var G__22710 = cljs.core.nnext(kvs);
coll = G__22707;
k = G__22708;
v = G__22709;
kvs = G__22710;
continue;
} else {
return ret;
}
break;
}
});

cljs.core.assoc.cljs$lang$applyTo = (function (seq22697){
var G__22698 = cljs.core.first(seq22697);
var seq22697__$1 = cljs.core.next(seq22697);
var G__22699 = cljs.core.first(seq22697__$1);
var seq22697__$2 = cljs.core.next(seq22697__$1);
var G__22700 = cljs.core.first(seq22697__$2);
var seq22697__$3 = cljs.core.next(seq22697__$2);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__22698,G__22699,G__22700,seq22697__$3);
});

cljs.core.assoc.cljs$lang$maxFixedArity = (3);

/**
 * dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
 *   that does not contain a mapping for key(s).
 */
cljs.core.dissoc = (function cljs$core$dissoc(var_args){
var args22711 = [];
var len__7651__auto___22717 = arguments.length;
var i__7652__auto___22718 = (0);
while(true){
if((i__7652__auto___22718 < len__7651__auto___22717)){
args22711.push((arguments[i__7652__auto___22718]));

var G__22719 = (i__7652__auto___22718 + (1));
i__7652__auto___22718 = G__22719;
continue;
} else {
}
break;
}

var G__22716 = args22711.length;
switch (G__22716) {
case 1:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args22711.slice((2)),(0),null));
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc(coll,k);
}
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__22721 = ret;
var G__22722 = cljs.core.first(ks);
var G__22723 = cljs.core.next(ks);
coll = G__22721;
k = G__22722;
ks = G__22723;
continue;
} else {
return ret;
}
}
break;
}
});

cljs.core.dissoc.cljs$lang$applyTo = (function (seq22712){
var G__22713 = cljs.core.first(seq22712);
var seq22712__$1 = cljs.core.next(seq22712);
var G__22714 = cljs.core.first(seq22712__$1);
var seq22712__$2 = cljs.core.next(seq22712__$1);
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__22713,G__22714,seq22712__$2);
});

cljs.core.dissoc.cljs$lang$maxFixedArity = (2);

/**
 * Return true if f is a JavaScript function or satisfies the Fn protocol.
 */
cljs.core.fn_QMARK_ = (function cljs$core$fn_QMARK_(f){
var or__6543__auto__ = goog.isFunction(f);
if(or__6543__auto__){
return or__6543__auto__;
} else {
if(!((f == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$Fn$))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
}
}
});

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 393217;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
});

cljs.core.MetaFn.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.MetaFn.prototype.call = (function() {
var G__22729 = null;
var G__22729__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});
var G__22729__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
});
var G__22729__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
});
var G__22729__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
});
var G__22729__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
});
var G__22729__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
});
var G__22729__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
});
var G__22729__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
});
var G__22729__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
});
var G__22729__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
});
var G__22729__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
});
var G__22729__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
});
var G__22729__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});
var G__22729__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});
var G__22729__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});
var G__22729__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});
var G__22729__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});
var G__22729__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});
var G__22729__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});
var G__22729__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});
var G__22729__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});
var G__22729__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : cljs.core.apply.call(null,self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
});
G__22729 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__22729__1.call(this,self__);
case 2:
return G__22729__2.call(this,self__,a);
case 3:
return G__22729__3.call(this,self__,a,b);
case 4:
return G__22729__4.call(this,self__,a,b,c);
case 5:
return G__22729__5.call(this,self__,a,b,c,d);
case 6:
return G__22729__6.call(this,self__,a,b,c,d,e);
case 7:
return G__22729__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__22729__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__22729__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__22729__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__22729__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__22729__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__22729__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__22729__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__22729__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__22729__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__22729__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__22729__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__22729__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__22729__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__22729__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__22729__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22729.cljs$core$IFn$_invoke$arity$1 = G__22729__1;
G__22729.cljs$core$IFn$_invoke$arity$2 = G__22729__2;
G__22729.cljs$core$IFn$_invoke$arity$3 = G__22729__3;
G__22729.cljs$core$IFn$_invoke$arity$4 = G__22729__4;
G__22729.cljs$core$IFn$_invoke$arity$5 = G__22729__5;
G__22729.cljs$core$IFn$_invoke$arity$6 = G__22729__6;
G__22729.cljs$core$IFn$_invoke$arity$7 = G__22729__7;
G__22729.cljs$core$IFn$_invoke$arity$8 = G__22729__8;
G__22729.cljs$core$IFn$_invoke$arity$9 = G__22729__9;
G__22729.cljs$core$IFn$_invoke$arity$10 = G__22729__10;
G__22729.cljs$core$IFn$_invoke$arity$11 = G__22729__11;
G__22729.cljs$core$IFn$_invoke$arity$12 = G__22729__12;
G__22729.cljs$core$IFn$_invoke$arity$13 = G__22729__13;
G__22729.cljs$core$IFn$_invoke$arity$14 = G__22729__14;
G__22729.cljs$core$IFn$_invoke$arity$15 = G__22729__15;
G__22729.cljs$core$IFn$_invoke$arity$16 = G__22729__16;
G__22729.cljs$core$IFn$_invoke$arity$17 = G__22729__17;
G__22729.cljs$core$IFn$_invoke$arity$18 = G__22729__18;
G__22729.cljs$core$IFn$_invoke$arity$19 = G__22729__19;
G__22729.cljs$core$IFn$_invoke$arity$20 = G__22729__20;
G__22729.cljs$core$IFn$_invoke$arity$21 = G__22729__21;
G__22729.cljs$core$IFn$_invoke$arity$22 = G__22729__22;
return G__22729;
})()
;

cljs.core.MetaFn.prototype.apply = (function (self__,args22728){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args22728)));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : cljs.core.apply.call(null,self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
});

cljs.core.MetaFn.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$afn,cljs.core.cst$sym$meta], null);
});

cljs.core.MetaFn.cljs$lang$type = true;

cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";

cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/MetaFn");
});

cljs.core.__GT_MetaFn = (function cljs$core$__GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
 * Returns an object of the same type and value as obj, with
 *   map m as its metadata.
 */
cljs.core.with_meta = (function cljs$core$with_meta(o,meta){
if(goog.isFunction(o)){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta(o,meta);
}
}
});
/**
 * Returns the metadata of obj, returns nil if there is no metadata.
 */
cljs.core.meta = (function cljs$core$meta(o){
if((function (){var and__6531__auto__ = !((o == null));
if(and__6531__auto__){
if(!((o == null))){
if(((o.cljs$lang$protocol_mask$partition0$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMeta$))){
return true;
} else {
if((!o.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
}
} else {
return and__6531__auto__;
}
})()){
return cljs.core._meta(o);
} else {
return null;
}
});
/**
 * For a list or queue, same as first, for a vector, same as, but much
 *   more efficient than, last. If the collection is empty, returns nil.
 */
cljs.core.peek = (function cljs$core$peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek(coll);
}
});
/**
 * For a list or queue, returns a new list/queue without the first
 *   item, for a vector, returns a new vector without the last item.
 *   Note - not the same as next/butlast.
 */
cljs.core.pop = (function cljs$core$pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop(coll);
}
});
/**
 * disj[oin]. Returns a new set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj = (function cljs$core$disj(var_args){
var args22734 = [];
var len__7651__auto___22740 = arguments.length;
var i__7652__auto___22741 = (0);
while(true){
if((i__7652__auto___22741 < len__7651__auto___22740)){
args22734.push((arguments[i__7652__auto___22741]));

var G__22742 = (i__7652__auto___22741 + (1));
i__7652__auto___22741 = G__22742;
continue;
} else {
}
break;
}

var G__22739 = args22734.length;
switch (G__22739) {
case 1:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args22734.slice((2)),(0),null));
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin(coll,k);
}
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__22744 = ret;
var G__22745 = cljs.core.first(ks);
var G__22746 = cljs.core.next(ks);
coll = G__22744;
k = G__22745;
ks = G__22746;
continue;
} else {
return ret;
}
}
break;
}
});

cljs.core.disj.cljs$lang$applyTo = (function (seq22735){
var G__22736 = cljs.core.first(seq22735);
var seq22735__$1 = cljs.core.next(seq22735);
var G__22737 = cljs.core.first(seq22735__$1);
var seq22735__$2 = cljs.core.next(seq22735__$1);
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(G__22736,G__22737,seq22735__$2);
});

cljs.core.disj.cljs$lang$maxFixedArity = (2);

/**
 * Returns true if coll has no items - same as (not (seq coll)).
 *   Please use the idiom (seq x) rather than (not (empty? x))
 */
cljs.core.empty_QMARK_ = (function cljs$core$empty_QMARK_(coll){
return ((coll == null)) || (cljs.core.not(cljs.core.seq(coll)));
});
/**
 * Returns true if x satisfies ICollection
 */
cljs.core.coll_QMARK_ = (function cljs$core$coll_QMARK_(x){
if((x == null)){
return false;
} else {
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (8))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICollection$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
}
}
});
/**
 * Returns true if x satisfies ISet
 */
cljs.core.set_QMARK_ = (function cljs$core$set_QMARK_(x){
if((x == null)){
return false;
} else {
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
}
}
});
/**
 * Returns true if coll implements Associative
 */
cljs.core.associative_QMARK_ = (function cljs$core$associative_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IAssociative$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
}
});
/**
 * Returns true if coll satisfies ISequential
 */
cljs.core.sequential_QMARK_ = (function cljs$core$sequential_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
}
});
/**
 * Returns true if coll satisfies ISorted
 */
cljs.core.sorted_QMARK_ = (function cljs$core$sorted_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (268435456))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISorted$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
}
});
/**
 * Returns true if coll satisfies IReduce
 */
cljs.core.reduceable_QMARK_ = (function cljs$core$reduceable_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IReduce$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
}
});
/**
 * Return true if x satisfies IMap
 */
cljs.core.map_QMARK_ = (function cljs$core$map_QMARK_(x){
if((x == null)){
return false;
} else {
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
}
}
});
/**
 * Return true if x satisfies IRecord
 */
cljs.core.record_QMARK_ = (function cljs$core$record_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (67108864))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IRecord$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
}
});
/**
 * Return true if x satisfies IVector
 */
cljs.core.vector_QMARK_ = (function cljs$core$vector_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (16384))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IVector$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
}
});

/**
 * Return true if x is satisfies IChunkedSeq.
 */
cljs.core.chunked_seq_QMARK_ = (function cljs$core$chunked_seq_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition1$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IChunkedSeq$))){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Create JavaSript object from an even number arguments representing
 *   interleaved keys and values.
 */
cljs.core.js_obj = (function cljs$core$js_obj(var_args){
var args22767 = [];
var len__7651__auto___22773 = arguments.length;
var i__7652__auto___22774 = (0);
while(true){
if((i__7652__auto___22774 < len__7651__auto___22773)){
args22767.push((arguments[i__7652__auto___22774]));

var G__22775 = (i__7652__auto___22774 + (1));
i__7652__auto___22774 = G__22775;
continue;
} else {
}
break;
}

var G__22770 = args22767.length;
switch (G__22770) {
case 0:
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args22767.slice((0)),(0),null));
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__7670__auto__);

}
});

cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = (function (){
return {};
});

cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(goog.object.create,keyvals) : cljs.core.apply.call(null,goog.object.create,keyvals));
});

cljs.core.js_obj.cljs$lang$applyTo = (function (seq22768){
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq22768));
});

cljs.core.js_obj.cljs$lang$maxFixedArity = (0);

/**
 * Return the JavaScript keys for an object.
 */
cljs.core.js_keys = (function cljs$core$js_keys(obj){
var keys = [];
var G__22779_22781 = obj;
var G__22780_22782 = ((function (G__22779_22781,keys){
return (function (val,key,obj__$1){
return keys.push(key);
});})(G__22779_22781,keys))
;
goog.object.forEach(G__22779_22781,G__22780_22782);

return keys;
});
/**
 * Delete a property from a JavaScript object.
 */
cljs.core.js_delete = (function cljs$core$js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function cljs$core$array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__22783 = (i__$1 + (1));
var G__22784 = (j__$1 + (1));
var G__22785 = (len__$1 - (1));
i__$1 = G__22783;
j__$1 = G__22784;
len__$1 = G__22785;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function cljs$core$array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__22786 = (i__$1 - (1));
var G__22787 = (j__$1 - (1));
var G__22788 = (len__$1 - (1));
i__$1 = G__22786;
j__$1 = G__22787;
len__$1 = G__22788;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = {};
/**
 * Returns true if x is the value false, false otherwise.
 */
cljs.core.false_QMARK_ = (function cljs$core$false_QMARK_(x){
return x === false;
});
/**
 * Returns true if x is the value true, false otherwise.
 */
cljs.core.true_QMARK_ = (function cljs$core$true_QMARK_(x){
return x === true;
});
/**
 * Return true if x is a Boolean
 */
cljs.core.boolean_QMARK_ = (function cljs$core$boolean_QMARK_(x){
return (x === true) || (x === false);
});
/**
 * Returns true if x identical to the JavaScript undefined value.
 */
cljs.core.undefined_QMARK_ = (function cljs$core$undefined_QMARK_(x){
return (void 0 === x);
});
/**
 * Return true if s satisfies ISeq
 */
cljs.core.seq_QMARK_ = (function cljs$core$seq_QMARK_(s){
if((s == null)){
return false;
} else {
if(!((s == null))){
if(((s.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeq$))){
return true;
} else {
if((!s.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
}
}
});
/**
 * Return true if s satisfies ISeqable
 */
cljs.core.seqable_QMARK_ = (function cljs$core$seqable_QMARK_(s){
if(!((s == null))){
if(((s.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeqable$))){
return true;
} else {
if((!s.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s);
}
});
/**
 * Coerce to boolean
 */
cljs.core.boolean$ = (function cljs$core$boolean(x){
if((x == null)){
return false;
} else {
if(x === false){
return false;
} else {
return true;

}
}
});
/**
 * Returns true if f returns true for fn? or satisfies IFn.
 */
cljs.core.ifn_QMARK_ = (function cljs$core$ifn_QMARK_(f){
var or__6543__auto__ = cljs.core.fn_QMARK_(f);
if(or__6543__auto__){
return or__6543__auto__;
} else {
if(!((f == null))){
if(((f.cljs$lang$protocol_mask$partition0$ & (1))) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$IFn$))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
}
}
});
/**
 * Returns true if n is a JavaScript number with no decimal part.
 */
cljs.core.integer_QMARK_ = (function cljs$core$integer_QMARK_(n){
return (typeof n === 'number') && (!(isNaN(n))) && (!((n === Infinity))) && ((parseFloat(n) === parseInt(n,(10))));
});
/**
 * Return true if x satisfies integer? or is an instance of goog.math.Integer
 * or goog.math.Long.
 */
cljs.core.int_QMARK_ = (function cljs$core$int_QMARK_(x){
return (cljs.core.integer_QMARK_(x)) || ((x instanceof goog.math.Integer)) || ((x instanceof goog.math.Long));
});
/**
 * Return true if x satisfies int? and is positive.
 */
cljs.core.pos_int_QMARK_ = (function cljs$core$pos_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x > (0));
} else {
if((x instanceof goog.math.Integer)){
return (cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero()));
} else {
if((x instanceof goog.math.Long)){
return (cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero()));
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is positive.
 */
cljs.core.neg_int_QMARK_ = (function cljs$core$neg_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x < (0));
} else {
if((x instanceof goog.math.Integer)){
return x.isNegative();
} else {
if((x instanceof goog.math.Long)){
return x.isNegative();
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is a natural integer value.
 */
cljs.core.nat_int_QMARK_ = (function cljs$core$nat_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (!((x < (0)))) || ((x === (0)));
} else {
if((x instanceof goog.math.Integer)){
var or__6543__auto__ = cljs.core.not(x.isNegative());
if(or__6543__auto__){
return or__6543__auto__;
} else {
return x.isZero();
}
} else {
if((x instanceof goog.math.Long)){
var or__6543__auto__ = cljs.core.not(x.isNegative());
if(or__6543__auto__){
return or__6543__auto__;
} else {
return x.isZero();
}
} else {
return false;

}
}
}
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.float_QMARK_ = (function cljs$core$float_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.double_QMARK_ = (function cljs$core$double_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for Infinity and -Infinity values.
 */
cljs.core.infinite_QMARK_ = (function cljs$core$infinite_QMARK_(x){
return ((x === Number.POSITIVE_INFINITY)) || ((x === Number.NEGATIVE_INFINITY));
});
/**
 * Returns true if key is present in the given collection, otherwise
 *   returns false.  Note that for numerically indexed collections like
 *   vectors and arrays, this tests if the numeric key is within the
 *   range of indexes. 'contains?' operates constant or logarithmic time;
 *   it will not perform a linear search for a value.  See also 'some'.
 */
cljs.core.contains_QMARK_ = (function cljs$core$contains_QMARK_(coll,v){
if((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core.find = (function cljs$core$find(coll,k){
if((!((coll == null))) && (cljs.core.associative_QMARK_(coll)) && (cljs.core.contains_QMARK_(coll,k))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k)], null);
} else {
return null;
}
});
/**
 * Returns true if no two of the arguments are =
 */
cljs.core.distinct_QMARK_ = (function cljs$core$distinct_QMARK_(var_args){
var args22799 = [];
var len__7651__auto___22805 = arguments.length;
var i__7652__auto___22806 = (0);
while(true){
if((i__7652__auto___22806 < len__7651__auto___22805)){
args22799.push((arguments[i__7652__auto___22806]));

var G__22807 = (i__7652__auto___22806 + (1));
i__7652__auto___22806 = G__22807;
continue;
} else {
}
break;
}

var G__22804 = args22799.length;
switch (G__22804) {
case 1:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args22799.slice((2)),(0),null));
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
if(!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y))){
var s = cljs.core.PersistentHashSet.fromArray([x,y], true);
var xs = more;
while(true){
var x__$1 = cljs.core.first(xs);
var etc = cljs.core.next(xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_(s,x__$1)){
return false;
} else {
var G__22809 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);
var G__22810 = etc;
s = G__22809;
xs = G__22810;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
});

cljs.core.distinct_QMARK_.cljs$lang$applyTo = (function (seq22800){
var G__22801 = cljs.core.first(seq22800);
var seq22800__$1 = cljs.core.next(seq22800);
var G__22802 = cljs.core.first(seq22800__$1);
var seq22800__$2 = cljs.core.next(seq22800__$1);
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__22801,G__22802,seq22800__$2);
});

cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = (2);

/**
 * Comparator. Returns a negative number, zero, or a positive number
 *   when x is logically 'less than', 'equal to', or 'greater than'
 *   y. Uses IComparable if available and google.array.defaultCompare for objects
 *  of the same type and special-cases nil to be less than any other object.
 */
cljs.core.compare = (function cljs$core$compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if(typeof x === 'number'){
if(typeof y === 'number'){
return goog.array.defaultCompare(x,y);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(x),cljs.core.str(" to "),cljs.core.str(y)].join('')));
}
} else {
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition1$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IComparable$)))?true:(((!x.cljs$lang$protocol_mask$partition1$))?cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x))){
return cljs.core._compare(x,y);
} else {
if(((typeof x === 'string') || (cljs.core.array_QMARK_(x)) || (x === true) || (x === false)) && ((cljs.core.type(x) === cljs.core.type(y)))){
return goog.array.defaultCompare(x,y);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(x),cljs.core.str(" to "),cljs.core.str(y)].join('')));
}

}
}
}
}
}
});
/**
 * Compare indexed collection.
 */
cljs.core.compare_indexed = (function cljs$core$compare_indexed(var_args){
var args22813 = [];
var len__7651__auto___22816 = arguments.length;
var i__7652__auto___22817 = (0);
while(true){
if((i__7652__auto___22817 < len__7651__auto___22816)){
args22813.push((arguments[i__7652__auto___22817]));

var G__22818 = (i__7652__auto___22817 + (1));
i__7652__auto___22817 = G__22818;
continue;
} else {
}
break;
}

var G__22815 = args22813.length;
switch (G__22815) {
case 2:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22813.length)].join('')));

}
});

cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = (function (xs,ys){
var xl = cljs.core.count(xs);
var yl = cljs.core.count(ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
if((xl === (0))){
return (0);
} else {
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));

}
}
}
});

cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = (function (xs,ys,len,n){
while(true){
var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));
if(((d === (0))) && (((n + (1)) < len))){
var G__22820 = xs;
var G__22821 = ys;
var G__22822 = len;
var G__22823 = (n + (1));
xs = G__22820;
ys = G__22821;
len = G__22822;
n = G__22823;
continue;
} else {
return d;
}
break;
}
});

cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4;

/**
 * Given a fn that might be boolean valued or a comparator,
 * return a fn that is a comparator.
 */
cljs.core.fn__GT_comparator = (function cljs$core$fn__GT_comparator(f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function (x,y){
var r = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(y,x) : f.call(null,y,x)))){
return (1);
} else {
return (0);
}
}
}
});
}
});
/**
 * Returns a sorted sequence of the items in coll. Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort = (function cljs$core$sort(var_args){
var args22824 = [];
var len__7651__auto___22829 = arguments.length;
var i__7652__auto___22830 = (0);
while(true){
if((i__7652__auto___22830 < len__7651__auto___22829)){
args22824.push((arguments[i__7652__auto___22830]));

var G__22831 = (i__7652__auto___22830 + (1));
i__7652__auto___22830 = G__22831;
continue;
} else {
}
break;
}

var G__22826 = args22824.length;
switch (G__22826) {
case 1:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22824.length)].join('')));

}
});

cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);
});

cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = (function (comp,coll){
if(cljs.core.seq(coll)){
var a = (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null,coll));
var G__22827_22833 = a;
var G__22828_22834 = cljs.core.fn__GT_comparator(comp);
goog.array.stableSort(G__22827_22833,G__22828_22834);

return cljs.core.seq(a);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.sort.cljs$lang$maxFixedArity = 2;

/**
 * Returns a sorted sequence of the items in coll, where the sort
 * order is determined by comparing (keyfn item).  Comp can be
 * boolean-valued comparison funcion, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort_by = (function cljs$core$sort_by(var_args){
var args22835 = [];
var len__7651__auto___22838 = arguments.length;
var i__7652__auto___22839 = (0);
while(true){
if((i__7652__auto___22839 < len__7651__auto___22838)){
args22835.push((arguments[i__7652__auto___22839]));

var G__22840 = (i__7652__auto___22839 + (1));
i__7652__auto___22839 = G__22840;
continue;
} else {
}
break;
}

var G__22837 = args22835.length;
switch (G__22837) {
case 2:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22835.length)].join('')));

}
});

cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);
});

cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = (function (keyfn,comp,coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (x,y){
return cljs.core.fn__GT_comparator(comp).call(null,(keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(x) : keyfn.call(null,x)),(keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(y) : keyfn.call(null,y)));
}),coll);
});

cljs.core.sort_by.cljs$lang$maxFixedArity = 3;

cljs.core.seq_reduce = (function cljs$core$seq_reduce(var_args){
var args22842 = [];
var len__7651__auto___22850 = arguments.length;
var i__7652__auto___22851 = (0);
while(true){
if((i__7652__auto___22851 < len__7651__auto___22850)){
args22842.push((arguments[i__7652__auto___22851]));

var G__22852 = (i__7652__auto___22851 + (1));
i__7652__auto___22851 = G__22852;
continue;
} else {
}
break;
}

var G__22844 = args22842.length;
switch (G__22844) {
case 2:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22842.length)].join('')));

}
});

cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var temp__4655__auto__ = cljs.core.seq(coll);
if(temp__4655__auto__){
var s = temp__4655__auto__;
var G__22845 = f;
var G__22846 = cljs.core.first(s);
var G__22847 = cljs.core.next(s);
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__22845,G__22846,G__22847) : cljs.core.reduce.call(null,G__22845,G__22846,G__22847));
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
});

cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq(coll);
while(true){
if(coll__$1){
var nval = (function (){var G__22848 = val__$1;
var G__22849 = cljs.core.first(coll__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__22848,G__22849) : f.call(null,G__22848,G__22849));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__22854 = nval;
var G__22855 = cljs.core.next(coll__$1);
val__$1 = G__22854;
coll__$1 = G__22855;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3;

/**
 * Return a random permutation of coll
 */
cljs.core.shuffle = (function cljs$core$shuffle(coll){
var a = (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null,coll));
goog.array.shuffle(a);

return (cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(a) : cljs.core.vec.call(null,a));
});
/**
 * f should be a function of 2 arguments. If val is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc. If coll contains no
 *   items, f must accept no arguments as well, and reduce returns the
 *   result of calling f with no arguments.  If coll has only 1 item, it
 *   is returned and f is not called.  If val is supplied, returns the
 *   result of applying f to val and the first item in coll, then
 *   applying f to that result and the 2nd item, etc. If coll contains no
 *   items, returns val and f is not called.
 */
cljs.core.reduce = (function cljs$core$reduce(var_args){
var args22856 = [];
var len__7651__auto___22861 = arguments.length;
var i__7652__auto___22862 = (0);
while(true){
if((i__7652__auto___22862 < len__7651__auto___22861)){
args22856.push((arguments[i__7652__auto___22862]));

var G__22863 = (i__7652__auto___22862 + (1));
i__7652__auto___22862 = G__22863;
continue;
} else {
}
break;
}

var G__22858 = args22856.length;
switch (G__22858) {
case 2:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22856.length)].join('')));

}
});

cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$)))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$2(null,f);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);

}
}
}
}
});

cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$)))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);

}
}
}
}
});

cljs.core.reduce.cljs$lang$maxFixedArity = 3;

/**
 * Reduces an associative collection. f should be a function of 3
 *   arguments. Returns the result of applying f to init, the first key
 *   and the first value in coll, then applying f to that result and the
 *   2nd key and value, etc. If coll contains no entries, returns init
 *   and f is not called. Note that reduce-kv is supported on vectors,
 *   where the keys will be the ordinals.
 */
cljs.core.reduce_kv = (function cljs$core$reduce_kv(f,init,coll){
if(!((coll == null))){
return cljs.core._kv_reduce(coll,f,init);
} else {
return init;
}
});
/**
 * Returns its argument.
 */
cljs.core.identity = (function cljs$core$identity(x){
return x;
});
/**
 * Takes a reducing function f of 2 args and returns a fn suitable for
 *   transduce by adding an arity-1 signature that calls cf (default -
 *   identity) on the result argument.
 */
cljs.core.completing = (function cljs$core$completing(var_args){
var args22865 = [];
var len__7651__auto___22868 = arguments.length;
var i__7652__auto___22869 = (0);
while(true){
if((i__7652__auto___22869 < len__7651__auto___22868)){
args22865.push((arguments[i__7652__auto___22869]));

var G__22870 = (i__7652__auto___22869 + (1));
i__7652__auto___22869 = G__22870;
continue;
} else {
}
break;
}

var G__22867 = args22865.length;
switch (G__22867) {
case 1:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22865.length)].join('')));

}
});

cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);
});

cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = (function (f,cf){
return (function() {
var G__22872 = null;
var G__22872__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
var G__22872__1 = (function (x){
return (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(x) : cf.call(null,x));
});
var G__22872__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
});
G__22872 = function(x,y){
switch(arguments.length){
case 0:
return G__22872__0.call(this);
case 1:
return G__22872__1.call(this,x);
case 2:
return G__22872__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22872.cljs$core$IFn$_invoke$arity$0 = G__22872__0;
G__22872.cljs$core$IFn$_invoke$arity$1 = G__22872__1;
G__22872.cljs$core$IFn$_invoke$arity$2 = G__22872__2;
return G__22872;
})()
});

cljs.core.completing.cljs$lang$maxFixedArity = 2;

/**
 * reduce with a transformation of f (xf). If init is not
 *   supplied, (f) will be called to produce it. f should be a reducing
 *   step function that accepts both 1 and 2 arguments, if it accepts
 *   only 2 you can add the arity-1 with 'completing'. Returns the result
 *   of applying (the transformed) xf to init and the first item in coll,
 *   then applying xf to that result and the 2nd item, etc. If coll
 *   contains no items, returns init and f is not called. Note that
 *   certain transforms may inject or skip items.
 */
cljs.core.transduce = (function cljs$core$transduce(var_args){
var args22873 = [];
var len__7651__auto___22876 = arguments.length;
var i__7652__auto___22877 = (0);
while(true){
if((i__7652__auto___22877 < len__7651__auto___22876)){
args22873.push((arguments[i__7652__auto___22877]));

var G__22878 = (i__7652__auto___22877 + (1));
i__7652__auto___22877 = G__22878;
continue;
} else {
}
break;
}

var G__22875 = args22873.length;
switch (G__22875) {
case 3:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22873.length)].join('')));

}
});

cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = (function (xform,f,coll){
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),coll);
});

cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = (function (xform,f,init,coll){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);
return (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(ret) : f__$1.call(null,ret));
});

cljs.core.transduce.cljs$lang$maxFixedArity = 4;

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core._PLUS_ = (function cljs$core$_PLUS_(var_args){
var args22880 = [];
var len__7651__auto___22886 = arguments.length;
var i__7652__auto___22887 = (0);
while(true){
if((i__7652__auto___22887 < len__7651__auto___22886)){
args22880.push((arguments[i__7652__auto___22887]));

var G__22888 = (i__7652__auto___22887 + (1));
i__7652__auto___22887 = G__22888;
continue;
} else {
}
break;
}

var G__22885 = args22880.length;
switch (G__22885) {
case 0:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args22880.slice((2)),(0),null));
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(x + y),more);
});

cljs.core._PLUS_.cljs$lang$applyTo = (function (seq22881){
var G__22882 = cljs.core.first(seq22881);
var seq22881__$1 = cljs.core.next(seq22881);
var G__22883 = cljs.core.first(seq22881__$1);
var seq22881__$2 = cljs.core.next(seq22881__$1);
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(G__22882,G__22883,seq22881__$2);
});

cljs.core._PLUS_.cljs$lang$maxFixedArity = (2);

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core._ = (function cljs$core$_(var_args){
var args22890 = [];
var len__7651__auto___22896 = arguments.length;
var i__7652__auto___22897 = (0);
while(true){
if((i__7652__auto___22897 < len__7651__auto___22896)){
args22890.push((arguments[i__7652__auto___22897]));

var G__22898 = (i__7652__auto___22897 + (1));
i__7652__auto___22897 = G__22898;
continue;
} else {
}
break;
}

var G__22895 = args22890.length;
switch (G__22895) {
case 1:
return cljs.core._.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args22890.slice((2)),(0),null));
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core._.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core._.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core._.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,(x - y),more);
});

cljs.core._.cljs$lang$applyTo = (function (seq22891){
var G__22892 = cljs.core.first(seq22891);
var seq22891__$1 = cljs.core.next(seq22891);
var G__22893 = cljs.core.first(seq22891__$1);
var seq22891__$2 = cljs.core.next(seq22891__$1);
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(G__22892,G__22893,seq22891__$2);
});

cljs.core._.cljs$lang$maxFixedArity = (2);

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core._STAR_ = (function cljs$core$_STAR_(var_args){
var args22900 = [];
var len__7651__auto___22906 = arguments.length;
var i__7652__auto___22907 = (0);
while(true){
if((i__7652__auto___22907 < len__7651__auto___22906)){
args22900.push((arguments[i__7652__auto___22907]));

var G__22908 = (i__7652__auto___22907 + (1));
i__7652__auto___22907 = G__22908;
continue;
} else {
}
break;
}

var G__22905 = args22900.length;
switch (G__22905) {
case 0:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args22900.slice((2)),(0),null));
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,(x * y),more);
});

cljs.core._STAR_.cljs$lang$applyTo = (function (seq22901){
var G__22902 = cljs.core.first(seq22901);
var seq22901__$1 = cljs.core.next(seq22901);
var G__22903 = cljs.core.first(seq22901__$1);
var seq22901__$2 = cljs.core.next(seq22901__$1);
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(G__22902,G__22903,seq22901__$2);
});

cljs.core._STAR_.cljs$lang$maxFixedArity = (2);

/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core._SLASH_ = (function cljs$core$_SLASH_(var_args){
var args22910 = [];
var len__7651__auto___22916 = arguments.length;
var i__7652__auto___22917 = (0);
while(true){
if((i__7652__auto___22917 < len__7651__auto___22916)){
args22910.push((arguments[i__7652__auto___22917]));

var G__22918 = (i__7652__auto___22917 + (1));
i__7652__auto___22917 = G__22918;
continue;
} else {
}
break;
}

var G__22915 = args22910.length;
switch (G__22915) {
case 1:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args22910.slice((2)),(0),null));
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(x / y),more);
});

cljs.core._SLASH_.cljs$lang$applyTo = (function (seq22911){
var G__22912 = cljs.core.first(seq22911);
var seq22911__$1 = cljs.core.next(seq22911);
var G__22913 = cljs.core.first(seq22911__$1);
var seq22911__$2 = cljs.core.next(seq22911__$1);
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(G__22912,G__22913,seq22911__$2);
});

cljs.core._SLASH_.cljs$lang$maxFixedArity = (2);

/**
 * Returns non-nil if nums are in monotonically increasing order,
 *   otherwise false.
 */
cljs.core._LT_ = (function cljs$core$_LT_(var_args){
var args22920 = [];
var len__7651__auto___22926 = arguments.length;
var i__7652__auto___22927 = (0);
while(true){
if((i__7652__auto___22927 < len__7651__auto___22926)){
args22920.push((arguments[i__7652__auto___22927]));

var G__22928 = (i__7652__auto___22927 + (1));
i__7652__auto___22927 = G__22928;
continue;
} else {
}
break;
}

var G__22925 = args22920.length;
switch (G__22925) {
case 1:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args22920.slice((2)),(0),null));
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x < y);
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x < y)){
if(cljs.core.next(more)){
var G__22930 = y;
var G__22931 = cljs.core.first(more);
var G__22932 = cljs.core.next(more);
x = G__22930;
y = G__22931;
more = G__22932;
continue;
} else {
return (y < cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._LT_.cljs$lang$applyTo = (function (seq22921){
var G__22922 = cljs.core.first(seq22921);
var seq22921__$1 = cljs.core.next(seq22921);
var G__22923 = cljs.core.first(seq22921__$1);
var seq22921__$2 = cljs.core.next(seq22921__$1);
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(G__22922,G__22923,seq22921__$2);
});

cljs.core._LT_.cljs$lang$maxFixedArity = (2);

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 *   otherwise false.
 */
cljs.core._LT__EQ_ = (function cljs$core$_LT__EQ_(var_args){
var args22933 = [];
var len__7651__auto___22939 = arguments.length;
var i__7652__auto___22940 = (0);
while(true){
if((i__7652__auto___22940 < len__7651__auto___22939)){
args22933.push((arguments[i__7652__auto___22940]));

var G__22941 = (i__7652__auto___22940 + (1));
i__7652__auto___22940 = G__22941;
continue;
} else {
}
break;
}

var G__22938 = args22933.length;
switch (G__22938) {
case 1:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args22933.slice((2)),(0),null));
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x <= y);
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next(more)){
var G__22943 = y;
var G__22944 = cljs.core.first(more);
var G__22945 = cljs.core.next(more);
x = G__22943;
y = G__22944;
more = G__22945;
continue;
} else {
return (y <= cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._LT__EQ_.cljs$lang$applyTo = (function (seq22934){
var G__22935 = cljs.core.first(seq22934);
var seq22934__$1 = cljs.core.next(seq22934);
var G__22936 = cljs.core.first(seq22934__$1);
var seq22934__$2 = cljs.core.next(seq22934__$1);
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__22935,G__22936,seq22934__$2);
});

cljs.core._LT__EQ_.cljs$lang$maxFixedArity = (2);

/**
 * Returns non-nil if nums are in monotonically decreasing order,
 *   otherwise false.
 */
cljs.core._GT_ = (function cljs$core$_GT_(var_args){
var args22946 = [];
var len__7651__auto___22952 = arguments.length;
var i__7652__auto___22953 = (0);
while(true){
if((i__7652__auto___22953 < len__7651__auto___22952)){
args22946.push((arguments[i__7652__auto___22953]));

var G__22954 = (i__7652__auto___22953 + (1));
i__7652__auto___22953 = G__22954;
continue;
} else {
}
break;
}

var G__22951 = args22946.length;
switch (G__22951) {
case 1:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args22946.slice((2)),(0),null));
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x > y);
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x > y)){
if(cljs.core.next(more)){
var G__22956 = y;
var G__22957 = cljs.core.first(more);
var G__22958 = cljs.core.next(more);
x = G__22956;
y = G__22957;
more = G__22958;
continue;
} else {
return (y > cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._GT_.cljs$lang$applyTo = (function (seq22947){
var G__22948 = cljs.core.first(seq22947);
var seq22947__$1 = cljs.core.next(seq22947);
var G__22949 = cljs.core.first(seq22947__$1);
var seq22947__$2 = cljs.core.next(seq22947__$1);
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(G__22948,G__22949,seq22947__$2);
});

cljs.core._GT_.cljs$lang$maxFixedArity = (2);

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 *   otherwise false.
 */
cljs.core._GT__EQ_ = (function cljs$core$_GT__EQ_(var_args){
var args22959 = [];
var len__7651__auto___22965 = arguments.length;
var i__7652__auto___22966 = (0);
while(true){
if((i__7652__auto___22966 < len__7651__auto___22965)){
args22959.push((arguments[i__7652__auto___22966]));

var G__22967 = (i__7652__auto___22966 + (1));
i__7652__auto___22966 = G__22967;
continue;
} else {
}
break;
}

var G__22964 = args22959.length;
switch (G__22964) {
case 1:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args22959.slice((2)),(0),null));
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x >= y);
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next(more)){
var G__22969 = y;
var G__22970 = cljs.core.first(more);
var G__22971 = cljs.core.next(more);
x = G__22969;
y = G__22970;
more = G__22971;
continue;
} else {
return (y >= cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._GT__EQ_.cljs$lang$applyTo = (function (seq22960){
var G__22961 = cljs.core.first(seq22960);
var seq22960__$1 = cljs.core.next(seq22960);
var G__22962 = cljs.core.first(seq22960__$1);
var seq22960__$2 = cljs.core.next(seq22960__$1);
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__22961,G__22962,seq22960__$2);
});

cljs.core._GT__EQ_.cljs$lang$maxFixedArity = (2);

/**
 * Returns a number one less than num.
 */
cljs.core.dec = (function cljs$core$dec(x){
return (x - (1));
});
/**
 * Returns the greatest of the nums.
 */
cljs.core.max = (function cljs$core$max(var_args){
var args22972 = [];
var len__7651__auto___22978 = arguments.length;
var i__7652__auto___22979 = (0);
while(true){
if((i__7652__auto___22979 < len__7651__auto___22978)){
args22972.push((arguments[i__7652__auto___22979]));

var G__22980 = (i__7652__auto___22979 + (1));
i__7652__auto___22979 = G__22980;
continue;
} else {
}
break;
}

var G__22977 = args22972.length;
switch (G__22977) {
case 1:
return cljs.core.max.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.max.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args22972.slice((2)),(0),null));
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.max.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.max.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__6874__auto__ = x;
var y__6875__auto__ = y;
return ((x__6874__auto__ > y__6875__auto__) ? x__6874__auto__ : y__6875__auto__);
});

cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(function (){var x__6874__auto__ = x;
var y__6875__auto__ = y;
return ((x__6874__auto__ > y__6875__auto__) ? x__6874__auto__ : y__6875__auto__);
})(),more);
});

cljs.core.max.cljs$lang$applyTo = (function (seq22973){
var G__22974 = cljs.core.first(seq22973);
var seq22973__$1 = cljs.core.next(seq22973);
var G__22975 = cljs.core.first(seq22973__$1);
var seq22973__$2 = cljs.core.next(seq22973__$1);
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(G__22974,G__22975,seq22973__$2);
});

cljs.core.max.cljs$lang$maxFixedArity = (2);

/**
 * Returns the least of the nums.
 */
cljs.core.min = (function cljs$core$min(var_args){
var args22982 = [];
var len__7651__auto___22988 = arguments.length;
var i__7652__auto___22989 = (0);
while(true){
if((i__7652__auto___22989 < len__7651__auto___22988)){
args22982.push((arguments[i__7652__auto___22989]));

var G__22990 = (i__7652__auto___22989 + (1));
i__7652__auto___22989 = G__22990;
continue;
} else {
}
break;
}

var G__22987 = args22982.length;
switch (G__22987) {
case 1:
return cljs.core.min.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.min.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args22982.slice((2)),(0),null));
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.min.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.min.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__6881__auto__ = x;
var y__6882__auto__ = y;
return ((x__6881__auto__ < y__6882__auto__) ? x__6881__auto__ : y__6882__auto__);
});

cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(function (){var x__6881__auto__ = x;
var y__6882__auto__ = y;
return ((x__6881__auto__ < y__6882__auto__) ? x__6881__auto__ : y__6882__auto__);
})(),more);
});

cljs.core.min.cljs$lang$applyTo = (function (seq22983){
var G__22984 = cljs.core.first(seq22983);
var seq22983__$1 = cljs.core.next(seq22983);
var G__22985 = cljs.core.first(seq22983__$1);
var seq22983__$2 = cljs.core.next(seq22983__$1);
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(G__22984,G__22985,seq22983__$2);
});

cljs.core.min.cljs$lang$maxFixedArity = (2);

cljs.core.byte$ = (function cljs$core$byte(x){
return x;
});
/**
 * Coerce to char
 */
cljs.core.char$ = (function cljs$core$char(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if((typeof x === 'string') && ((x.length === (1)))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function cljs$core$short(x){
return x;
});
cljs.core.float$ = (function cljs$core$float(x){
return x;
});
cljs.core.double$ = (function cljs$core$double(x){
return x;
});
cljs.core.unchecked_byte = (function cljs$core$unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function cljs$core$unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function cljs$core$unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function cljs$core$unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function cljs$core$unchecked_double(x){
return x;
});
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add = (function cljs$core$unchecked_add(var_args){
var args22992 = [];
var len__7651__auto___22998 = arguments.length;
var i__7652__auto___22999 = (0);
while(true){
if((i__7652__auto___22999 < len__7651__auto___22998)){
args22992.push((arguments[i__7652__auto___22999]));

var G__23000 = (i__7652__auto___22999 + (1));
i__7652__auto___22999 = G__23000;
continue;
} else {
}
break;
}

var G__22997 = args22992.length;
switch (G__22997) {
case 0:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args22992.slice((2)),(0),null));
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add,(x + y),more);
});

cljs.core.unchecked_add.cljs$lang$applyTo = (function (seq22993){
var G__22994 = cljs.core.first(seq22993);
var seq22993__$1 = cljs.core.next(seq22993);
var G__22995 = cljs.core.first(seq22993__$1);
var seq22993__$2 = cljs.core.next(seq22993__$1);
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(G__22994,G__22995,seq22993__$2);
});

cljs.core.unchecked_add.cljs$lang$maxFixedArity = (2);

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add_int = (function cljs$core$unchecked_add_int(var_args){
var args23002 = [];
var len__7651__auto___23008 = arguments.length;
var i__7652__auto___23009 = (0);
while(true){
if((i__7652__auto___23009 < len__7651__auto___23008)){
args23002.push((arguments[i__7652__auto___23009]));

var G__23010 = (i__7652__auto___23009 + (1));
i__7652__auto___23009 = G__23010;
continue;
} else {
}
break;
}

var G__23007 = args23002.length;
switch (G__23007) {
case 0:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23002.slice((2)),(0),null));
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int,(x + y),more);
});

cljs.core.unchecked_add_int.cljs$lang$applyTo = (function (seq23003){
var G__23004 = cljs.core.first(seq23003);
var seq23003__$1 = cljs.core.next(seq23003);
var G__23005 = cljs.core.first(seq23003__$1);
var seq23003__$2 = cljs.core.next(seq23003__$1);
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(G__23004,G__23005,seq23003__$2);
});

cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = (2);

/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec = (function cljs$core$unchecked_dec(x){
return (x - (1));
});
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec_int = (function cljs$core$unchecked_dec_int(x){
return (x - (1));
});
/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core.unchecked_divide_int = (function cljs$core$unchecked_divide_int(var_args){
var args23012 = [];
var len__7651__auto___23018 = arguments.length;
var i__7652__auto___23019 = (0);
while(true){
if((i__7652__auto___23019 < len__7651__auto___23018)){
args23012.push((arguments[i__7652__auto___23019]));

var G__23020 = (i__7652__auto___23019 + (1));
i__7652__auto___23019 = G__23020;
continue;
} else {
}
break;
}

var G__23017 = args23012.length;
switch (G__23017) {
case 1:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23012.slice((2)),(0),null));
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int,(x / y),more);
});

cljs.core.unchecked_divide_int.cljs$lang$applyTo = (function (seq23013){
var G__23014 = cljs.core.first(seq23013);
var seq23013__$1 = cljs.core.next(seq23013);
var G__23015 = cljs.core.first(seq23013__$1);
var seq23013__$2 = cljs.core.next(seq23013__$1);
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(G__23014,G__23015,seq23013__$2);
});

cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = (2);

cljs.core.unchecked_inc = (function cljs$core$unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function cljs$core$unchecked_inc_int(x){
return (x + (1));
});
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply = (function cljs$core$unchecked_multiply(var_args){
var args23022 = [];
var len__7651__auto___23028 = arguments.length;
var i__7652__auto___23029 = (0);
while(true){
if((i__7652__auto___23029 < len__7651__auto___23028)){
args23022.push((arguments[i__7652__auto___23029]));

var G__23030 = (i__7652__auto___23029 + (1));
i__7652__auto___23029 = G__23030;
continue;
} else {
}
break;
}

var G__23027 = args23022.length;
switch (G__23027) {
case 0:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23022.slice((2)),(0),null));
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply,(x * y),more);
});

cljs.core.unchecked_multiply.cljs$lang$applyTo = (function (seq23023){
var G__23024 = cljs.core.first(seq23023);
var seq23023__$1 = cljs.core.next(seq23023);
var G__23025 = cljs.core.first(seq23023__$1);
var seq23023__$2 = cljs.core.next(seq23023__$1);
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(G__23024,G__23025,seq23023__$2);
});

cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = (2);

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply_int = (function cljs$core$unchecked_multiply_int(var_args){
var args23032 = [];
var len__7651__auto___23038 = arguments.length;
var i__7652__auto___23039 = (0);
while(true){
if((i__7652__auto___23039 < len__7651__auto___23038)){
args23032.push((arguments[i__7652__auto___23039]));

var G__23040 = (i__7652__auto___23039 + (1));
i__7652__auto___23039 = G__23040;
continue;
} else {
}
break;
}

var G__23037 = args23032.length;
switch (G__23037) {
case 0:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23032.slice((2)),(0),null));
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int,(x * y),more);
});

cljs.core.unchecked_multiply_int.cljs$lang$applyTo = (function (seq23033){
var G__23034 = cljs.core.first(seq23033);
var seq23033__$1 = cljs.core.next(seq23033);
var G__23035 = cljs.core.first(seq23033__$1);
var seq23033__$2 = cljs.core.next(seq23033__$1);
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(G__23034,G__23035,seq23033__$2);
});

cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = (2);

cljs.core.unchecked_negate = (function cljs$core$unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function cljs$core$unchecked_negate_int(x){
return (- x);
});
cljs.core.unchecked_remainder_int = (function cljs$core$unchecked_remainder_int(x,n){
return (cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(x,n) : cljs.core.mod.call(null,x,n));
});
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract = (function cljs$core$unchecked_subtract(var_args){
var args23042 = [];
var len__7651__auto___23048 = arguments.length;
var i__7652__auto___23049 = (0);
while(true){
if((i__7652__auto___23049 < len__7651__auto___23048)){
args23042.push((arguments[i__7652__auto___23049]));

var G__23050 = (i__7652__auto___23049 + (1));
i__7652__auto___23049 = G__23050;
continue;
} else {
}
break;
}

var G__23047 = args23042.length;
switch (G__23047) {
case 1:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23042.slice((2)),(0),null));
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract,(x - y),more);
});

cljs.core.unchecked_subtract.cljs$lang$applyTo = (function (seq23043){
var G__23044 = cljs.core.first(seq23043);
var seq23043__$1 = cljs.core.next(seq23043);
var G__23045 = cljs.core.first(seq23043__$1);
var seq23043__$2 = cljs.core.next(seq23043__$1);
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(G__23044,G__23045,seq23043__$2);
});

cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = (2);

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract_int = (function cljs$core$unchecked_subtract_int(var_args){
var args23052 = [];
var len__7651__auto___23058 = arguments.length;
var i__7652__auto___23059 = (0);
while(true){
if((i__7652__auto___23059 < len__7651__auto___23058)){
args23052.push((arguments[i__7652__auto___23059]));

var G__23060 = (i__7652__auto___23059 + (1));
i__7652__auto___23059 = G__23060;
continue;
} else {
}
break;
}

var G__23057 = args23052.length;
switch (G__23057) {
case 1:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23052.slice((2)),(0),null));
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int,(x - y),more);
});

cljs.core.unchecked_subtract_int.cljs$lang$applyTo = (function (seq23053){
var G__23054 = cljs.core.first(seq23053);
var seq23053__$1 = cljs.core.next(seq23053);
var G__23055 = cljs.core.first(seq23053__$1);
var seq23053__$2 = cljs.core.next(seq23053__$1);
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(G__23054,G__23055,seq23053__$2);
});

cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = (2);

cljs.core.fix = (function cljs$core$fix(q){
if((q >= (0))){
return Math.floor(q);
} else {
return Math.ceil(q);
}
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.int$ = (function cljs$core$int(x){
return (x | (0));
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.unchecked_int = (function cljs$core$unchecked_int(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.long$ = (function cljs$core$long(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.unchecked_long = (function cljs$core$unchecked_long(x){
return cljs.core.fix(x);
});
cljs.core.booleans = (function cljs$core$booleans(x){
return x;
});
cljs.core.bytes = (function cljs$core$bytes(x){
return x;
});
cljs.core.chars = (function cljs$core$chars(x){
return x;
});
cljs.core.shorts = (function cljs$core$shorts(x){
return x;
});
cljs.core.ints = (function cljs$core$ints(x){
return x;
});
cljs.core.floats = (function cljs$core$floats(x){
return x;
});
cljs.core.doubles = (function cljs$core$doubles(x){
return x;
});
cljs.core.longs = (function cljs$core$longs(x){
return x;
});
/**
 * Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
 */
cljs.core.js_mod = (function cljs$core$js_mod(n,d){
return (n % d);
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
cljs.core.mod = (function cljs$core$mod(n,d){
return (((n % d) + d) % d);
});
/**
 * quot[ient] of dividing numerator by denominator.
 */
cljs.core.quot = (function cljs$core$quot(n,d){
var rem = (n % d);
return cljs.core.fix(((n - rem) / d));
});
/**
 * remainder of dividing numerator by denominator.
 */
cljs.core.rem = (function cljs$core$rem(n,d){
var q = cljs.core.quot(n,d);
return (n - (d * q));
});
/**
 * Bitwise exclusive or
 */
cljs.core.bit_xor = (function cljs$core$bit_xor(var_args){
var args23062 = [];
var len__7651__auto___23068 = arguments.length;
var i__7652__auto___23069 = (0);
while(true){
if((i__7652__auto___23069 < len__7651__auto___23068)){
args23062.push((arguments[i__7652__auto___23069]));

var G__23070 = (i__7652__auto___23069 + (1));
i__7652__auto___23069 = G__23070;
continue;
} else {
}
break;
}

var G__23067 = args23062.length;
switch (G__23067) {
case 2:
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23062.slice((2)),(0),null));
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x ^ y);
});

cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor,(x ^ y),more);
});

cljs.core.bit_xor.cljs$lang$applyTo = (function (seq23063){
var G__23064 = cljs.core.first(seq23063);
var seq23063__$1 = cljs.core.next(seq23063);
var G__23065 = cljs.core.first(seq23063__$1);
var seq23063__$2 = cljs.core.next(seq23063__$1);
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(G__23064,G__23065,seq23063__$2);
});

cljs.core.bit_xor.cljs$lang$maxFixedArity = (2);

/**
 * Bitwise and
 */
cljs.core.bit_and = (function cljs$core$bit_and(var_args){
var args23072 = [];
var len__7651__auto___23078 = arguments.length;
var i__7652__auto___23079 = (0);
while(true){
if((i__7652__auto___23079 < len__7651__auto___23078)){
args23072.push((arguments[i__7652__auto___23079]));

var G__23080 = (i__7652__auto___23079 + (1));
i__7652__auto___23079 = G__23080;
continue;
} else {
}
break;
}

var G__23077 = args23072.length;
switch (G__23077) {
case 2:
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23072.slice((2)),(0),null));
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & y);
});

cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and,(x & y),more);
});

cljs.core.bit_and.cljs$lang$applyTo = (function (seq23073){
var G__23074 = cljs.core.first(seq23073);
var seq23073__$1 = cljs.core.next(seq23073);
var G__23075 = cljs.core.first(seq23073__$1);
var seq23073__$2 = cljs.core.next(seq23073__$1);
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(G__23074,G__23075,seq23073__$2);
});

cljs.core.bit_and.cljs$lang$maxFixedArity = (2);

/**
 * Bitwise or
 */
cljs.core.bit_or = (function cljs$core$bit_or(var_args){
var args23082 = [];
var len__7651__auto___23088 = arguments.length;
var i__7652__auto___23089 = (0);
while(true){
if((i__7652__auto___23089 < len__7651__auto___23088)){
args23082.push((arguments[i__7652__auto___23089]));

var G__23090 = (i__7652__auto___23089 + (1));
i__7652__auto___23089 = G__23090;
continue;
} else {
}
break;
}

var G__23087 = args23082.length;
switch (G__23087) {
case 2:
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23082.slice((2)),(0),null));
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x | y);
});

cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or,(x | y),more);
});

cljs.core.bit_or.cljs$lang$applyTo = (function (seq23083){
var G__23084 = cljs.core.first(seq23083);
var seq23083__$1 = cljs.core.next(seq23083);
var G__23085 = cljs.core.first(seq23083__$1);
var seq23083__$2 = cljs.core.next(seq23083__$1);
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(G__23084,G__23085,seq23083__$2);
});

cljs.core.bit_or.cljs$lang$maxFixedArity = (2);

/**
 * Bitwise and with complement
 */
cljs.core.bit_and_not = (function cljs$core$bit_and_not(var_args){
var args23092 = [];
var len__7651__auto___23098 = arguments.length;
var i__7652__auto___23099 = (0);
while(true){
if((i__7652__auto___23099 < len__7651__auto___23098)){
args23092.push((arguments[i__7652__auto___23099]));

var G__23100 = (i__7652__auto___23099 + (1));
i__7652__auto___23099 = G__23100;
continue;
} else {
}
break;
}

var G__23097 = args23092.length;
switch (G__23097) {
case 2:
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23092.slice((2)),(0),null));
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & ~y);
});

cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not,(x & ~y),more);
});

cljs.core.bit_and_not.cljs$lang$applyTo = (function (seq23093){
var G__23094 = cljs.core.first(seq23093);
var seq23093__$1 = cljs.core.next(seq23093);
var G__23095 = cljs.core.first(seq23093__$1);
var seq23093__$2 = cljs.core.next(seq23093__$1);
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(G__23094,G__23095,seq23093__$2);
});

cljs.core.bit_and_not.cljs$lang$maxFixedArity = (2);

/**
 * Clear bit at index n
 */
cljs.core.bit_clear = (function cljs$core$bit_clear(x,n){
return (x & ~(1 << n));
});
/**
 * Flip bit at index n
 */
cljs.core.bit_flip = (function cljs$core$bit_flip(x,n){
return (x ^ (1 << n));
});
/**
 * Bitwise complement
 */
cljs.core.bit_not = (function cljs$core$bit_not(x){
return (~ x);
});
/**
 * Set bit at index n
 */
cljs.core.bit_set = (function cljs$core$bit_set(x,n){
return (x | (1 << n));
});
/**
 * Test bit at index n
 */
cljs.core.bit_test = (function cljs$core$bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
 * Bitwise shift left
 */
cljs.core.bit_shift_left = (function cljs$core$bit_shift_left(x,n){
return (x << n);
});
/**
 * Bitwise shift right
 */
cljs.core.bit_shift_right = (function cljs$core$bit_shift_right(x,n){
return (x >> n);
});
/**
 * DEPRECATED: Bitwise shift right with zero fill
 */
cljs.core.bit_shift_right_zero_fill = (function cljs$core$bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
 * Bitwise shift right with zero fill
 */
cljs.core.unsigned_bit_shift_right = (function cljs$core$unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
 * Counts the number of bits set in n
 */
cljs.core.bit_count = (function cljs$core$bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
 * Returns non-nil if nums all have the equivalent
 *   value, otherwise false. Behavior on non nums is
 *   undefined.
 */
cljs.core._EQ__EQ_ = (function cljs$core$_EQ__EQ_(var_args){
var args23102 = [];
var len__7651__auto___23108 = arguments.length;
var i__7652__auto___23109 = (0);
while(true){
if((i__7652__auto___23109 < len__7651__auto___23108)){
args23102.push((arguments[i__7652__auto___23109]));

var G__23110 = (i__7652__auto___23109 + (1));
i__7652__auto___23109 = G__23110;
continue;
} else {
}
break;
}

var G__23107 = args23102.length;
switch (G__23107) {
case 1:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23102.slice((2)),(0),null));
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return cljs.core._equiv(x,y);
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x === y)){
if(cljs.core.next(more)){
var G__23112 = y;
var G__23113 = cljs.core.first(more);
var G__23114 = cljs.core.next(more);
x = G__23112;
y = G__23113;
more = G__23114;
continue;
} else {
return (y === cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._EQ__EQ_.cljs$lang$applyTo = (function (seq23103){
var G__23104 = cljs.core.first(seq23103);
var seq23103__$1 = cljs.core.next(seq23103);
var G__23105 = cljs.core.first(seq23103__$1);
var seq23103__$2 = cljs.core.next(seq23103__$1);
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__23104,G__23105,seq23103__$2);
});

cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = (2);

/**
 * Returns true if num is greater than zero, else false
 */
cljs.core.pos_QMARK_ = (function cljs$core$pos_QMARK_(x){
return (x > (0));
});
/**
 * Returns true if num is zero, else false
 */
cljs.core.zero_QMARK_ = (function cljs$core$zero_QMARK_(x){
return (x === (0));
});
/**
 * Returns true if num is less than zero, else false
 */
cljs.core.neg_QMARK_ = (function cljs$core$neg_QMARK_(x){
return (x < (0));
});
/**
 * Returns the nth next of coll, (seq coll) when n is 0.
 */
cljs.core.nthnext = (function cljs$core$nthnext(coll,n){
var n__$1 = n;
var xs = cljs.core.seq(coll);
while(true){
if((xs) && ((n__$1 > (0)))){
var G__23115 = (n__$1 - (1));
var G__23116 = cljs.core.next(xs);
n__$1 = G__23115;
xs = G__23116;
continue;
} else {
return xs;
}
break;
}
});
/**
 * With no args, returns the empty string. With one arg x, returns
 *   x.toString().  (str nil) returns the empty string. With more than
 *   one arg, returns the concatenation of the str values of the args.
 */
cljs.core.str = (function cljs$core$str(var_args){
var args23117 = [];
var len__7651__auto___23122 = arguments.length;
var i__7652__auto___23123 = (0);
while(true){
if((i__7652__auto___23123 < len__7651__auto___23122)){
args23117.push((arguments[i__7652__auto___23123]));

var G__23124 = (i__7652__auto___23123 + (1));
i__7652__auto___23123 = G__23124;
continue;
} else {
}
break;
}

var G__23121 = args23117.length;
switch (G__23121) {
case 0:
return cljs.core.str.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23117.slice((1)),(0),null));
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7670__auto__);

}
});

cljs.core.str.cljs$core$IFn$_invoke$arity$0 = (function (){
return "";
});

cljs.core.str.cljs$core$IFn$_invoke$arity$1 = (function (x){
if((x == null)){
return "";
} else {
return [x].join("");
}
});

cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = (function (x,ys){
var sb = (new goog.string.StringBuffer([cljs.core.str(x)].join('')));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__23126 = sb.append([cljs.core.str(cljs.core.first(more))].join(''));
var G__23127 = cljs.core.next(more);
sb = G__23126;
more = G__23127;
continue;
} else {
return sb.toString();
}
break;
}
});

cljs.core.str.cljs$lang$applyTo = (function (seq23118){
var G__23119 = cljs.core.first(seq23118);
var seq23118__$1 = cljs.core.next(seq23118);
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(G__23119,seq23118__$1);
});

cljs.core.str.cljs$lang$maxFixedArity = (1);

/**
 * Returns the substring of s beginning at start inclusive, and ending
 *   at end (defaults to length of string), exclusive.
 */
cljs.core.subs = (function cljs$core$subs(var_args){
var args23128 = [];
var len__7651__auto___23131 = arguments.length;
var i__7652__auto___23132 = (0);
while(true){
if((i__7652__auto___23132 < len__7651__auto___23131)){
args23128.push((arguments[i__7652__auto___23132]));

var G__23133 = (i__7652__auto___23132 + (1));
i__7652__auto___23132 = G__23133;
continue;
} else {
}
break;
}

var G__23130 = args23128.length;
switch (G__23130) {
case 2:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23128.length)].join('')));

}
});

cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = (function (s,start){
return s.substring(start);
});

cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = (function (s,start,end){
return s.substring(start,end);
});

cljs.core.subs.cljs$lang$maxFixedArity = 3;


/**
 * Assumes x is sequential. Returns true if x equals y, otherwise
 *   returns false.
 */
cljs.core.equiv_sequential = (function cljs$core$equiv_sequential(x,y){
return cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?(((cljs.core.counted_QMARK_(x)) && (cljs.core.counted_QMARK_(y)) && (!((cljs.core.count(x) === cljs.core.count(y)))))?false:(function (){var xs = cljs.core.seq(x);
var ys = cljs.core.seq(y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){
var G__23135 = cljs.core.next(xs);
var G__23136 = cljs.core.next(ys);
xs = G__23135;
ys = G__23136;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function cljs$core$hash_coll(coll){
if(cljs.core.seq(coll)){
var res = cljs.core.hash(cljs.core.first(coll));
var s = cljs.core.next(coll);
while(true){
if((s == null)){
return res;
} else {
var G__23137 = cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));
var G__23138 = cljs.core.next(s);
res = G__23137;
s = G__23138;
continue;
}
break;
}
} else {
return (0);
}
});

cljs.core.hash_imap = (function cljs$core$hash_imap(m){
var h = (0);
var s = cljs.core.seq(m);
while(true){
if(s){
var e = cljs.core.first(s);
var G__23139 = ((h + (cljs.core.hash((cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null,e))) ^ cljs.core.hash((cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null,e))))) % (4503599627370496));
var G__23140 = cljs.core.next(s);
h = G__23139;
s = G__23140;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function cljs$core$hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq(s);
while(true){
if(s__$1){
var e = cljs.core.first(s__$1);
var G__23141 = ((h + cljs.core.hash(e)) % (4503599627370496));
var G__23142 = cljs.core.next(s__$1);
h = G__23141;
s__$1 = G__23142;
continue;
} else {
return h;
}
break;
}
});


/**
 * Takes a JavaScript object and a map of names to functions and
 *   attaches said functions as methods on the object.  Any references to
 *   JavaScript's implicit this (via the this-as macro) will resolve to the
 *   object that the function is attached.
 */
cljs.core.extend_object_BANG_ = (function cljs$core$extend_object_BANG_(obj,fn_map){
var seq__23153_23163 = cljs.core.seq(fn_map);
var chunk__23154_23164 = null;
var count__23155_23165 = (0);
var i__23156_23166 = (0);
while(true){
if((i__23156_23166 < count__23155_23165)){
var vec__23157_23167 = chunk__23154_23164.cljs$core$IIndexed$_nth$arity$2(null,i__23156_23166);
var key_name_23168 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23157_23167,(0),null);
var f_23169 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23157_23167,(1),null);
var str_name_23170 = (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_23168) : cljs.core.name.call(null,key_name_23168));
(obj[str_name_23170] = f_23169);

var G__23171 = seq__23153_23163;
var G__23172 = chunk__23154_23164;
var G__23173 = count__23155_23165;
var G__23174 = (i__23156_23166 + (1));
seq__23153_23163 = G__23171;
chunk__23154_23164 = G__23172;
count__23155_23165 = G__23173;
i__23156_23166 = G__23174;
continue;
} else {
var temp__4657__auto___23175 = cljs.core.seq(seq__23153_23163);
if(temp__4657__auto___23175){
var seq__23153_23176__$1 = temp__4657__auto___23175;
if(cljs.core.chunked_seq_QMARK_(seq__23153_23176__$1)){
var c__7357__auto___23177 = (cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(seq__23153_23176__$1) : cljs.core.chunk_first.call(null,seq__23153_23176__$1));
var G__23178 = (cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(seq__23153_23176__$1) : cljs.core.chunk_rest.call(null,seq__23153_23176__$1));
var G__23179 = c__7357__auto___23177;
var G__23180 = cljs.core.count(c__7357__auto___23177);
var G__23181 = (0);
seq__23153_23163 = G__23178;
chunk__23154_23164 = G__23179;
count__23155_23165 = G__23180;
i__23156_23166 = G__23181;
continue;
} else {
var vec__23160_23182 = cljs.core.first(seq__23153_23176__$1);
var key_name_23183 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23160_23182,(0),null);
var f_23184 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23160_23182,(1),null);
var str_name_23185 = (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_23183) : cljs.core.name.call(null,key_name_23183));
(obj[str_name_23185] = f_23184);

var G__23186 = cljs.core.next(seq__23153_23176__$1);
var G__23187 = null;
var G__23188 = (0);
var G__23189 = (0);
seq__23153_23163 = G__23186;
chunk__23154_23164 = G__23187;
count__23155_23165 = G__23188;
i__23156_23166 = G__23189;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.List.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.List.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.List.prototype.indexOf = (function() {
var G__23190 = null;
var G__23190__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__23190__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__23190 = function(x,start){
switch(arguments.length){
case 1:
return G__23190__1.call(this,x);
case 2:
return G__23190__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23190.cljs$core$IFn$_invoke$arity$1 = G__23190__1;
G__23190.cljs$core$IFn$_invoke$arity$2 = G__23190__2;
return G__23190;
})()
;

cljs.core.List.prototype.lastIndexOf = (function() {
var G__23191 = null;
var G__23191__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count);
});
var G__23191__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__23191 = function(x,start){
switch(arguments.length){
case 1:
return G__23191__1.call(this,x);
case 2:
return G__23191__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23191.cljs$core$IFn$_invoke$arity$1 = G__23191__1;
G__23191.cljs$core$IFn$_invoke$arity$2 = G__23191__2;
return G__23191;
})()
;

cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._rest(coll__$1);
});

cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(meta__$1,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
});

cljs.core.List.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$first,cljs.core.cst$sym$rest,cljs.core.cst$sym$count,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.List.cljs$lang$type = true;

cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";

cljs.core.List.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/List");
});

cljs.core.__GT_List = (function cljs$core$__GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

/**
 * Returns true if x implements IList
 */
cljs.core.list_QMARK_ = (function cljs$core$list_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (33554432))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IList$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
}
});
(cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.EmptyList.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.EmptyList.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.EmptyList.prototype.indexOf = (function() {
var G__23194 = null;
var G__23194__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__23194__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__23194 = function(x,start){
switch(arguments.length){
case 1:
return G__23194__1.call(this,x);
case 2:
return G__23194__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23194.cljs$core$IFn$_invoke$arity$1 = G__23194__1;
G__23194.cljs$core$IFn$_invoke$arity$2 = G__23194__2;
return G__23194;
})()
;

cljs.core.EmptyList.prototype.lastIndexOf = (function() {
var G__23195 = null;
var G__23195__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__23195__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__23195 = function(x,start){
switch(arguments.length){
case 1:
return G__23195__1.call(this,x);
case 2:
return G__23195__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23195.cljs$core$IFn$_invoke$arity$1 = G__23195__1;
G__23195.cljs$core$IFn$_invoke$arity$2 = G__23195__2;
return G__23195;
})()
;

cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
});

cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (0);
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
});

cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
});

cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((cljs.core.list_QMARK_(other)) || (cljs.core.sequential_QMARK_(other))){
return (cljs.core.seq(other) == null);
} else {
return false;
}
});

cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.EmptyList(meta__$1));
});

cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
});

cljs.core.EmptyList.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta], null);
});

cljs.core.EmptyList.cljs$lang$type = true;

cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";

cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/EmptyList");
});

cljs.core.__GT_EmptyList = (function cljs$core$__GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

cljs.core.List.EMPTY = (new cljs.core.EmptyList(null));
(cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
/**
 * Returns true if coll satisfies? IReversible.
 */
cljs.core.reversible_QMARK_ = (function cljs$core$reversible_QMARK_(coll){
if(!((coll == null))){
if(((coll.cljs$lang$protocol_mask$partition0$ & (134217728))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReversible$))){
return true;
} else {
if((!coll.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
}
});
/**
 * Returns, in constant time, a seq of the items in rev (which
 *   can be a vector or sorted-map), in reverse order. If rev is empty returns nil
 */
cljs.core.rseq = (function cljs$core$rseq(rev){
return cljs.core._rseq(rev);
});
/**
 * Returns a seq of the items in coll in reverse order. Not lazy.
 */
cljs.core.reverse = (function cljs$core$reverse(coll){
if(cljs.core.reversible_QMARK_(coll)){
return cljs.core.rseq(coll);
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
 * Creates a new list containing the items.
 */
cljs.core.list = (function cljs$core$list(var_args){
var args__7658__auto__ = [];
var len__7651__auto___23199 = arguments.length;
var i__7652__auto___23200 = (0);
while(true){
if((i__7652__auto___23200 < len__7651__auto___23199)){
args__7658__auto__.push((arguments[i__7652__auto___23200]));

var G__23201 = (i__7652__auto___23200 + (1));
i__7652__auto___23200 = G__23201;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var arr = ((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if(!((xs__$1 == null))){
arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));

var G__23202 = xs__$1.cljs$core$INext$_next$arity$1(null);
xs__$1 = G__23202;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__23203 = (i - (1));
var G__23204 = r.cljs$core$ICollection$_conj$arity$2(null,(arr[(i - (1))]));
i = G__23203;
r = G__23204;
continue;
} else {
return r;
}
break;
}
});

cljs.core.list.cljs$lang$maxFixedArity = (0);

cljs.core.list.cljs$lang$applyTo = (function (seq23198){
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq23198));
});


/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Cons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Cons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Cons.prototype.indexOf = (function() {
var G__23205 = null;
var G__23205__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__23205__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__23205 = function(x,start){
switch(arguments.length){
case 1:
return G__23205__1.call(this,x);
case 2:
return G__23205__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23205.cljs$core$IFn$_invoke$arity$1 = G__23205__1;
G__23205.cljs$core$IFn$_invoke$arity$2 = G__23205__2;
return G__23205;
})()
;

cljs.core.Cons.prototype.lastIndexOf = (function() {
var G__23206 = null;
var G__23206__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__23206__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__23206 = function(x,start){
switch(arguments.length){
case 1:
return G__23206__1.call(this,x);
case 2:
return G__23206__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23206.cljs$core$IFn$_invoke$arity$1 = G__23206__1;
G__23206.cljs$core$IFn$_invoke$arity$2 = G__23206__2;
return G__23206;
})()
;

cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq(self__.rest);
}
});

cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(meta__$1,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,null));
});

cljs.core.Cons.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$first,cljs.core.cst$sym$rest,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Cons.cljs$lang$type = true;

cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";

cljs.core.Cons.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/Cons");
});

cljs.core.__GT_Cons = (function cljs$core$__GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

(cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
/**
 * Returns a new seq where x is the first element and coll is the rest.
 */
cljs.core.cons = (function cljs$core$cons(x,coll){
if((function (){var or__6543__auto__ = (coll == null);
if(or__6543__auto__){
return or__6543__auto__;
} else {
if(!((coll == null))){
if(((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));
}
});
cljs.core.hash_keyword = (function cljs$core$hash_keyword(k){
return ((cljs.core.hash_symbol(k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function cljs$core$compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__6531__auto__ = cljs.core.not(a.ns);
if(and__6531__auto__){
return b.ns;
} else {
return and__6531__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__23217 = a.ns;
var G__23218 = b.ns;
return goog.array.defaultCompare(G__23217,G__23218);
})();
if(((0) === nsc)){
var G__23219 = a.name;
var G__23220 = b.name;
return goog.array.defaultCompare(G__23219,G__23220);
} else {
return nsc;
}
}
} else {
var G__23221 = a.name;
var G__23222 = b.name;
return goog.array.defaultCompare(G__23221,G__23222);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IPrintWithWriter}
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Keyword.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [cljs.core.str(":"),cljs.core.str(self__.fqn)].join('');
});

cljs.core.Keyword.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
});

cljs.core.Keyword.prototype.call = (function() {
var G__23224 = null;
var G__23224__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});
var G__23224__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});
G__23224 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__23224__2.call(this,self__,coll);
case 3:
return G__23224__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23224.cljs$core$IFn$_invoke$arity$2 = G__23224__2;
G__23224.cljs$core$IFn$_invoke$arity$3 = G__23224__3;
return G__23224;
})()
;

cljs.core.Keyword.prototype.apply = (function (self__,args23223){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args23223)));
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});

cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__6978__auto__ = self__._hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_keyword(this$__$1);
self__._hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,[cljs.core.str(":"),cljs.core.str(self__.fqn)].join(''));
});

cljs.core.Keyword.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns,cljs.core.cst$sym$name,cljs.core.cst$sym$fqn,cljs.core.with_meta(cljs.core.cst$sym$_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Keyword.cljs$lang$type = true;

cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";

cljs.core.Keyword.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/Keyword");
});

cljs.core.__GT_Keyword = (function cljs$core$__GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

/**
 * Return true if x is a Keyword
 */
cljs.core.keyword_QMARK_ = (function cljs$core$keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
/**
 * Efficient test to determine that two keywords are identical.
 */
cljs.core.keyword_identical_QMARK_ = (function cljs$core$keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if(((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
 * Efficient test to determine that two symbols are identical.
 */
cljs.core.symbol_identical_QMARK_ = (function cljs$core$symbol_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if(((x instanceof cljs.core.Symbol)) && ((y instanceof cljs.core.Symbol))){
return (x.str === y.str);
} else {
return false;
}
}
});
/**
 * Returns the namespace String of a symbol or keyword, or nil if not present.
 */
cljs.core.namespace = (function cljs$core$namespace(x){
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition1$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$INamed$)))?true:false):false)){
return x.cljs$core$INamed$_namespace$arity$1(null);
} else {
throw (new Error([cljs.core.str("Doesn't support namespace: "),cljs.core.str(x)].join('')));
}
});
/**
 * Return true if x is a symbol or keyword
 */
cljs.core.ident_QMARK_ = (function cljs$core$ident_QMARK_(x){
return ((x instanceof cljs.core.Keyword)) || ((x instanceof cljs.core.Symbol));
});
/**
 * Return true if x is a symbol or keyword without a namespace
 */
cljs.core.simple_ident_QMARK_ = (function cljs$core$simple_ident_QMARK_(x){
return (cljs.core.ident_QMARK_(x)) && ((cljs.core.namespace(x) == null));
});
/**
 * Return true if x is a symbol or keyword with a namespace
 */
cljs.core.qualified_ident_QMARK_ = (function cljs$core$qualified_ident_QMARK_(x){
var and__6531__auto__ = cljs.core.ident_QMARK_(x);
if(and__6531__auto__){
var and__6531__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__6531__auto____$1)){
return true;
} else {
return and__6531__auto____$1;
}
} else {
return and__6531__auto__;
}
});
/**
 * Return true if x is a symbol without a namespace
 */
cljs.core.simple_symbol_QMARK_ = (function cljs$core$simple_symbol_QMARK_(x){
return ((x instanceof cljs.core.Symbol)) && ((cljs.core.namespace(x) == null));
});
/**
 * Return true if x is a symbol with a namespace
 */
cljs.core.qualified_symbol_QMARK_ = (function cljs$core$qualified_symbol_QMARK_(x){
var and__6531__auto__ = (x instanceof cljs.core.Symbol);
if(and__6531__auto__){
var and__6531__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__6531__auto____$1)){
return true;
} else {
return and__6531__auto____$1;
}
} else {
return and__6531__auto__;
}
});
/**
 * Return true if x is a keyword without a namespace
 */
cljs.core.simple_keyword_QMARK_ = (function cljs$core$simple_keyword_QMARK_(x){
return ((x instanceof cljs.core.Keyword)) && ((cljs.core.namespace(x) == null));
});
/**
 * Return true if x is a keyword with a namespace
 */
cljs.core.qualified_keyword_QMARK_ = (function cljs$core$qualified_keyword_QMARK_(x){
var and__6531__auto__ = (x instanceof cljs.core.Keyword);
if(and__6531__auto__){
var and__6531__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__6531__auto____$1)){
return true;
} else {
return and__6531__auto____$1;
}
} else {
return and__6531__auto__;
}
});
/**
 * Returns a Keyword with the given namespace and name.  Do not use :
 *   in the keyword strings, it will be added automatically.
 */
cljs.core.keyword = (function cljs$core$keyword(var_args){
var args23227 = [];
var len__7651__auto___23230 = arguments.length;
var i__7652__auto___23231 = (0);
while(true){
if((i__7652__auto___23231 < len__7651__auto___23230)){
args23227.push((arguments[i__7652__auto___23231]));

var G__23232 = (i__7652__auto___23231 + (1));
i__7652__auto___23231 = G__23232;
continue;
} else {
}
break;
}

var G__23229 = args23227.length;
switch (G__23229) {
case 1:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23227.length)].join('')));

}
});

cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = (function (name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace(name),(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null,name)),name.str,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
});

cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
var ns__$1 = (((ns instanceof cljs.core.Keyword))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(ns) : cljs.core.name.call(null,ns)):(((ns instanceof cljs.core.Symbol))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(ns) : cljs.core.name.call(null,ns)):ns
));
var name__$1 = (((name instanceof cljs.core.Keyword))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null,name)):(((name instanceof cljs.core.Symbol))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null,name)):name
));
return (new cljs.core.Keyword(ns__$1,name__$1,[cljs.core.str((cljs.core.truth_(ns__$1)?[cljs.core.str(ns__$1),cljs.core.str("/")].join(''):null)),cljs.core.str(name__$1)].join(''),null));
});

cljs.core.keyword.cljs$lang$maxFixedArity = 2;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 1;
})
cljs.core.LazySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.LazySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.LazySeq.prototype.sval = (function (){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
self__.s = (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null));

self__.fn = null;

return self__.s;
}
});

cljs.core.LazySeq.prototype.indexOf = (function() {
var G__23234 = null;
var G__23234__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__23234__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__23234 = function(x,start){
switch(arguments.length){
case 1:
return G__23234__1.call(this,x);
case 2:
return G__23234__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23234.cljs$core$IFn$_invoke$arity$1 = G__23234__1;
G__23234.cljs$core$IFn$_invoke$arity$2 = G__23234__2;
return G__23234;
})()
;

cljs.core.LazySeq.prototype.lastIndexOf = (function() {
var G__23235 = null;
var G__23235__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__23235__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__23235 = function(x,start){
switch(arguments.length){
case 1:
return G__23235__1.call(this,x);
case 2:
return G__23235__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23235.cljs$core$IFn$_invoke$arity$1 = G__23235__1;
G__23235.cljs$core$IFn$_invoke$arity$2 = G__23235__2;
return G__23235;
})()
;

cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.next(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.LazySeq.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.not(self__.fn);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if(!((self__.s == null))){
return cljs.core.rest(self__.s);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__23236 = ls.sval();
ls = G__23236;
continue;
} else {
self__.s = ls;

return cljs.core.seq(self__.s);
}
break;
}
}
});

cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.LazySeq(meta__$1,self__.fn,self__.s,self__.__hash));
});

cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.LazySeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$fn,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.LazySeq.cljs$lang$type = true;

cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";

cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/LazySeq");
});

cljs.core.__GT_LazySeq = (function cljs$core$__GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

(cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ICounted}
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 2;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ChunkBuffer.prototype.add = (function (o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return self__.end = (self__.end + (1));
});

cljs.core.ChunkBuffer.prototype.chunk = (function (o){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
self__.buf = null;

return ret;
});

cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.end;
});

cljs.core.ChunkBuffer.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$buf,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$end,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ChunkBuffer.cljs$lang$type = true;

cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";

cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ChunkBuffer");
});

cljs.core.__GT_ChunkBuffer = (function cljs$core$__GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function cljs$core$chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.IChunk}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 524306;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if(((i >= (0))) && ((i < (self__.end - self__.off)))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
});

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
});

cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
});

cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);
});

cljs.core.ArrayChunk.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off,cljs.core.cst$sym$end], null);
});

cljs.core.ArrayChunk.cljs$lang$type = true;

cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";

cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ArrayChunk");
});

cljs.core.__GT_ArrayChunk = (function cljs$core$__GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function cljs$core$array_chunk(var_args){
var args23237 = [];
var len__7651__auto___23240 = arguments.length;
var i__7652__auto___23241 = (0);
while(true){
if((i__7652__auto___23241 < len__7651__auto___23240)){
args23237.push((arguments[i__7652__auto___23241]));

var G__23242 = (i__7652__auto___23241 + (1));
i__7652__auto___23241 = G__23242;
continue;
} else {
}
break;
}

var G__23239 = args23237.length;
switch (G__23239) {
case 1:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23237.length)].join('')));

}
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = (function (arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = (function (arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = (function (arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk.cljs$lang$maxFixedArity = 3;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedCons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedCons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedCons.prototype.indexOf = (function() {
var G__23244 = null;
var G__23244__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__23244__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__23244 = function(x,start){
switch(arguments.length){
case 1:
return G__23244__1.call(this,x);
case 2:
return G__23244__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23244.cljs$core$IFn$_invoke$arity$1 = G__23244__1;
G__23244.cljs$core$IFn$_invoke$arity$2 = G__23244__2;
return G__23244;
})()
;

cljs.core.ChunkedCons.prototype.lastIndexOf = (function() {
var G__23245 = null;
var G__23245__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__23245__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__23245 = function(x,start){
switch(arguments.length){
case 1:
return G__23245__1.call(this,x);
case 2:
return G__23245__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23245.cljs$core$IFn$_invoke$arity$1 = G__23245__1;
G__23245.cljs$core$IFn$_invoke$arity$2 = G__23245__2;
return G__23245;
})()
;

cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
var more__$1 = cljs.core._seq(self__.more);
if((more__$1 == null)){
return null;
} else {
return more__$1;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk,(0));
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,m,self__.__hash));
});

cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$chunk,cljs.core.cst$sym$more,cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ChunkedCons.cljs$lang$type = true;

cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";

cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ChunkedCons");
});

cljs.core.__GT_ChunkedCons = (function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

(cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
cljs.core.chunk_cons = (function cljs$core$chunk_cons(chunk,rest){
if((cljs.core._count(chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function cljs$core$chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function cljs$core$chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function cljs$core$chunk_first(s){
return cljs.core._chunked_first(s);
});
cljs.core.chunk_rest = (function cljs$core$chunk_rest(s){
return cljs.core._chunked_rest(s);
});
cljs.core.chunk_next = (function cljs$core$chunk_next(s){
if(((!((s == null)))?((((s.cljs$lang$protocol_mask$partition1$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$IChunkedNext$)))?true:false):false)){
return cljs.core._chunked_next(s);
} else {
return cljs.core.seq(cljs.core._chunked_rest(s));
}
});
/**
 * Naive impl of to-array as a start.
 */
cljs.core.to_array = (function cljs$core$to_array(s){
var ary = [];
var s__$1 = s;
while(true){
if(cljs.core.seq(s__$1)){
ary.push(cljs.core.first(s__$1));

var G__23248 = cljs.core.next(s__$1);
s__$1 = G__23248;
continue;
} else {
return ary;
}
break;
}
});
/**
 * Returns a (potentially-ragged) 2-dimensional array
 *   containing the contents of coll.
 */
cljs.core.to_array_2d = (function cljs$core$to_array_2d(coll){
var ret = (new Array(cljs.core.count(coll)));
var i_23249 = (0);
var xs_23250 = cljs.core.seq(coll);
while(true){
if(xs_23250){
(ret[i_23249] = cljs.core.to_array(cljs.core.first(xs_23250)));

var G__23251 = (i_23249 + (1));
var G__23252 = cljs.core.next(xs_23250);
i_23249 = G__23251;
xs_23250 = G__23252;
continue;
} else {
}
break;
}

return ret;
});
/**
 * Creates an array of ints. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.int_array = (function cljs$core$int_array(var_args){
var args23253 = [];
var len__7651__auto___23256 = arguments.length;
var i__7652__auto___23257 = (0);
while(true){
if((i__7652__auto___23257 < len__7651__auto___23256)){
args23253.push((arguments[i__7652__auto___23257]));

var G__23258 = (i__7652__auto___23257 + (1));
i__7652__auto___23257 = G__23258;
continue;
} else {
}
break;
}

var G__23255 = args23253.length;
switch (G__23255) {
case 1:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23253.length)].join('')));

}
});

cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__23260 = (i + (1));
var G__23261 = cljs.core.next(s__$1);
i = G__23260;
s__$1 = G__23261;
continue;
} else {
return a;
}
break;
}
} else {
var n__7461__auto___23262 = size;
var i_23263 = (0);
while(true){
if((i_23263 < n__7461__auto___23262)){
(a[i_23263] = init_val_or_seq);

var G__23264 = (i_23263 + (1));
i_23263 = G__23264;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.int_array.cljs$lang$maxFixedArity = 2;

/**
 * Creates an array of longs. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.long_array = (function cljs$core$long_array(var_args){
var args23265 = [];
var len__7651__auto___23268 = arguments.length;
var i__7652__auto___23269 = (0);
while(true){
if((i__7652__auto___23269 < len__7651__auto___23268)){
args23265.push((arguments[i__7652__auto___23269]));

var G__23270 = (i__7652__auto___23269 + (1));
i__7652__auto___23269 = G__23270;
continue;
} else {
}
break;
}

var G__23267 = args23265.length;
switch (G__23267) {
case 1:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23265.length)].join('')));

}
});

cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__23272 = (i + (1));
var G__23273 = cljs.core.next(s__$1);
i = G__23272;
s__$1 = G__23273;
continue;
} else {
return a;
}
break;
}
} else {
var n__7461__auto___23274 = size;
var i_23275 = (0);
while(true){
if((i_23275 < n__7461__auto___23274)){
(a[i_23275] = init_val_or_seq);

var G__23276 = (i_23275 + (1));
i_23275 = G__23276;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.long_array.cljs$lang$maxFixedArity = 2;

/**
 * Creates an array of doubles. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.double_array = (function cljs$core$double_array(var_args){
var args23277 = [];
var len__7651__auto___23280 = arguments.length;
var i__7652__auto___23281 = (0);
while(true){
if((i__7652__auto___23281 < len__7651__auto___23280)){
args23277.push((arguments[i__7652__auto___23281]));

var G__23282 = (i__7652__auto___23281 + (1));
i__7652__auto___23281 = G__23282;
continue;
} else {
}
break;
}

var G__23279 = args23277.length;
switch (G__23279) {
case 1:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23277.length)].join('')));

}
});

cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__23284 = (i + (1));
var G__23285 = cljs.core.next(s__$1);
i = G__23284;
s__$1 = G__23285;
continue;
} else {
return a;
}
break;
}
} else {
var n__7461__auto___23286 = size;
var i_23287 = (0);
while(true){
if((i_23287 < n__7461__auto___23286)){
(a[i_23287] = init_val_or_seq);

var G__23288 = (i_23287 + (1));
i_23287 = G__23288;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.double_array.cljs$lang$maxFixedArity = 2;

/**
 * Creates an array of objects. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.object_array = (function cljs$core$object_array(var_args){
var args23289 = [];
var len__7651__auto___23292 = arguments.length;
var i__7652__auto___23293 = (0);
while(true){
if((i__7652__auto___23293 < len__7651__auto___23292)){
args23289.push((arguments[i__7652__auto___23293]));

var G__23294 = (i__7652__auto___23293 + (1));
i__7652__auto___23293 = G__23294;
continue;
} else {
}
break;
}

var G__23291 = args23289.length;
switch (G__23291) {
case 1:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23289.length)].join('')));

}
});

cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__23296 = (i + (1));
var G__23297 = cljs.core.next(s__$1);
i = G__23296;
s__$1 = G__23297;
continue;
} else {
return a;
}
break;
}
} else {
var n__7461__auto___23298 = size;
var i_23299 = (0);
while(true){
if((i_23299 < n__7461__auto___23298)){
(a[i_23299] = init_val_or_seq);

var G__23300 = (i_23299 + (1));
i_23299 = G__23300;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.object_array.cljs$lang$maxFixedArity = 2;

/**
 * If coll is counted? returns its count, else will count at most the first n
 * elements of coll using its seq
 */
cljs.core.bounded_count = (function cljs$core$bounded_count(n,coll){
if(cljs.core.counted_QMARK_(coll)){
return cljs.core.count(coll);
} else {
var i = (0);
var s = cljs.core.seq(coll);
while(true){
if((!((s == null))) && ((i < n))){
var G__23301 = (i + (1));
var G__23302 = cljs.core.next(s);
i = G__23301;
s = G__23302;
continue;
} else {
return i;
}
break;
}
}
});
cljs.core.spread = (function cljs$core$spread(arglist){
if((arglist == null)){
return null;
} else {
if((cljs.core.next(arglist) == null)){
return cljs.core.seq(cljs.core.first(arglist));
} else {
return cljs.core.cons(cljs.core.first(arglist),(function (){var G__23304 = cljs.core.next(arglist);
return (cljs.core.spread.cljs$core$IFn$_invoke$arity$1 ? cljs.core.spread.cljs$core$IFn$_invoke$arity$1(G__23304) : cljs.core.spread.call(null,G__23304));
})());

}
}
});
/**
 * Returns a lazy seq representing the concatenation of the elements in the supplied colls.
 */
cljs.core.concat = (function cljs$core$concat(var_args){
var args23305 = [];
var len__7651__auto___23317 = arguments.length;
var i__7652__auto___23318 = (0);
while(true){
if((i__7652__auto___23318 < len__7651__auto___23317)){
args23305.push((arguments[i__7652__auto___23318]));

var G__23319 = (i__7652__auto___23318 + (1));
i__7652__auto___23318 = G__23319;
continue;
} else {
}
break;
}

var G__23310 = args23305.length;
switch (G__23310) {
case 0:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23305.slice((2)),(0),null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = (function (){
return (new cljs.core.LazySeq(null,(function (){
return null;
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return x;
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (new cljs.core.LazySeq(null,(function (){
var s = cljs.core.seq(x);
if(s){
if(cljs.core.chunked_seq_QMARK_(s)){
return cljs.core.chunk_cons(cljs.core.chunk_first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));
} else {
return cljs.core.cons(cljs.core.first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));
}
} else {
return y;
}
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,zs){
var cat = (function cljs$core$cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function (){
var xys__$1 = cljs.core.seq(xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_(xys__$1)){
return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cljs$core$cat(cljs.core.chunk_rest(xys__$1),zs__$1));
} else {
return cljs.core.cons(cljs.core.first(xys__$1),cljs$core$cat(cljs.core.rest(xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cljs$core$cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);
});

cljs.core.concat.cljs$lang$applyTo = (function (seq23306){
var G__23307 = cljs.core.first(seq23306);
var seq23306__$1 = cljs.core.next(seq23306);
var G__23308 = cljs.core.first(seq23306__$1);
var seq23306__$2 = cljs.core.next(seq23306__$1);
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(G__23307,G__23308,seq23306__$2);
});

cljs.core.concat.cljs$lang$maxFixedArity = (2);

/**
 * Creates a new list containing the items prepended to the rest, the
 *   last of which will be treated as a sequence.
 */
cljs.core.list_STAR_ = (function cljs$core$list_STAR_(var_args){
var args23321 = [];
var len__7651__auto___23329 = arguments.length;
var i__7652__auto___23330 = (0);
while(true){
if((i__7652__auto___23330 < len__7651__auto___23329)){
args23321.push((arguments[i__7652__auto___23330]));

var G__23331 = (i__7652__auto___23330 + (1));
i__7652__auto___23330 = G__23331;
continue;
} else {
}
break;
}

var G__23328 = args23321.length;
switch (G__23328) {
case 1:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23321.slice((4)),(0),null));
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7670__auto__);

}
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (args){
return cljs.core.seq(args);
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (a,args){
return cljs.core.cons(a,args);
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (a,b,args){
return cljs.core.cons(a,cljs.core.cons(b,args));
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,args){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,more){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));
});

cljs.core.list_STAR_.cljs$lang$applyTo = (function (seq23322){
var G__23323 = cljs.core.first(seq23322);
var seq23322__$1 = cljs.core.next(seq23322);
var G__23324 = cljs.core.first(seq23322__$1);
var seq23322__$2 = cljs.core.next(seq23322__$1);
var G__23325 = cljs.core.first(seq23322__$2);
var seq23322__$3 = cljs.core.next(seq23322__$2);
var G__23326 = cljs.core.first(seq23322__$3);
var seq23322__$4 = cljs.core.next(seq23322__$3);
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__23323,G__23324,G__23325,G__23326,seq23322__$4);
});

cljs.core.list_STAR_.cljs$lang$maxFixedArity = (4);

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core.transient$ = (function cljs$core$transient(coll){
return cljs.core._as_transient(coll);
});
/**
 * Returns a new, persistent version of the transient collection, in
 *   constant time. The transient collection cannot be used after this
 *   call, any such use will throw an exception.
 */
cljs.core.persistent_BANG_ = (function cljs$core$persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_(tcoll);
});
/**
 * Adds val to the transient collection, and return tcoll. The 'addition'
 *   may happen at different 'places' depending on the concrete type.
 */
cljs.core.conj_BANG_ = (function cljs$core$conj_BANG_(var_args){
var args23333 = [];
var len__7651__auto___23339 = arguments.length;
var i__7652__auto___23340 = (0);
while(true){
if((i__7652__auto___23340 < len__7651__auto___23339)){
args23333.push((arguments[i__7652__auto___23340]));

var G__23341 = (i__7652__auto___23340 + (1));
i__7652__auto___23340 = G__23341;
continue;
} else {
}
break;
}

var G__23338 = args23333.length;
switch (G__23338) {
case 0:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23333.slice((2)),(0),null));
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (tcoll){
return tcoll;
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._conj_BANG_(tcoll,val);
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__23343 = ntcoll;
var G__23344 = cljs.core.first(vals);
var G__23345 = cljs.core.next(vals);
tcoll = G__23343;
val = G__23344;
vals = G__23345;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.conj_BANG_.cljs$lang$applyTo = (function (seq23334){
var G__23335 = cljs.core.first(seq23334);
var seq23334__$1 = cljs.core.next(seq23334);
var G__23336 = cljs.core.first(seq23334__$1);
var seq23334__$2 = cljs.core.next(seq23334__$1);
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__23335,G__23336,seq23334__$2);
});

cljs.core.conj_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * When applied to a transient map, adds mapping of key(s) to
 *   val(s). When applied to a transient vector, sets the val at index.
 *   Note - index must be <= (count vector). Returns coll.
 */
cljs.core.assoc_BANG_ = (function cljs$core$assoc_BANG_(var_args){
var args23346 = [];
var len__7651__auto___23353 = arguments.length;
var i__7652__auto___23354 = (0);
while(true){
if((i__7652__auto___23354 < len__7651__auto___23353)){
args23346.push((arguments[i__7652__auto___23354]));

var G__23355 = (i__7652__auto___23354 + (1));
i__7652__auto___23354 = G__23355;
continue;
} else {
}
break;
}

var G__23352 = args23346.length;
switch (G__23352) {
case 3:
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23346.slice((3)),(0),null));
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7670__auto__);

}
});

cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (tcoll,key,val){
return cljs.core._assoc_BANG_(tcoll,key,val);
});

cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_(tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__23357 = ntcoll;
var G__23358 = cljs.core.first(kvs);
var G__23359 = cljs.core.second(kvs);
var G__23360 = cljs.core.nnext(kvs);
tcoll = G__23357;
key = G__23358;
val = G__23359;
kvs = G__23360;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.assoc_BANG_.cljs$lang$applyTo = (function (seq23347){
var G__23348 = cljs.core.first(seq23347);
var seq23347__$1 = cljs.core.next(seq23347);
var G__23349 = cljs.core.first(seq23347__$1);
var seq23347__$2 = cljs.core.next(seq23347__$1);
var G__23350 = cljs.core.first(seq23347__$2);
var seq23347__$3 = cljs.core.next(seq23347__$2);
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__23348,G__23349,G__23350,seq23347__$3);
});

cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = (3);

/**
 * Returns a transient map that doesn't contain a mapping for key(s).
 */
cljs.core.dissoc_BANG_ = (function cljs$core$dissoc_BANG_(var_args){
var args23361 = [];
var len__7651__auto___23367 = arguments.length;
var i__7652__auto___23368 = (0);
while(true){
if((i__7652__auto___23368 < len__7651__auto___23367)){
args23361.push((arguments[i__7652__auto___23368]));

var G__23369 = (i__7652__auto___23368 + (1));
i__7652__auto___23368 = G__23369;
continue;
} else {
}
break;
}

var G__23366 = args23361.length;
switch (G__23366) {
case 2:
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23361.slice((2)),(0),null));
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,key){
return cljs.core._dissoc_BANG_(tcoll,key);
});

cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_(tcoll,key);
if(cljs.core.truth_(ks)){
var G__23371 = ntcoll;
var G__23372 = cljs.core.first(ks);
var G__23373 = cljs.core.next(ks);
tcoll = G__23371;
key = G__23372;
ks = G__23373;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.dissoc_BANG_.cljs$lang$applyTo = (function (seq23362){
var G__23363 = cljs.core.first(seq23362);
var seq23362__$1 = cljs.core.next(seq23362);
var G__23364 = cljs.core.first(seq23362__$1);
var seq23362__$2 = cljs.core.next(seq23362__$1);
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__23363,G__23364,seq23362__$2);
});

cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Removes the last item from a transient vector. If
 *   the collection is empty, throws an exception. Returns tcoll
 */
cljs.core.pop_BANG_ = (function cljs$core$pop_BANG_(tcoll){
return cljs.core._pop_BANG_(tcoll);
});
/**
 * disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj_BANG_ = (function cljs$core$disj_BANG_(var_args){
var args23374 = [];
var len__7651__auto___23380 = arguments.length;
var i__7652__auto___23381 = (0);
while(true){
if((i__7652__auto___23381 < len__7651__auto___23380)){
args23374.push((arguments[i__7652__auto___23381]));

var G__23382 = (i__7652__auto___23381 + (1));
i__7652__auto___23381 = G__23382;
continue;
} else {
}
break;
}

var G__23379 = args23374.length;
switch (G__23379) {
case 2:
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23374.slice((2)),(0),null));
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._disjoin_BANG_(tcoll,val);
});

cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__23384 = ntcoll;
var G__23385 = cljs.core.first(vals);
var G__23386 = cljs.core.next(vals);
tcoll = G__23384;
val = G__23385;
vals = G__23386;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.disj_BANG_.cljs$lang$applyTo = (function (seq23375){
var G__23376 = cljs.core.first(seq23375);
var seq23375__$1 = cljs.core.next(seq23375);
var G__23377 = cljs.core.first(seq23375__$1);
var seq23375__$2 = cljs.core.next(seq23375__$1);
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__23376,G__23377,seq23375__$2);
});

cljs.core.disj_BANG_.cljs$lang$maxFixedArity = (2);


cljs.core.apply_to = (function cljs$core$apply_to(f,argc,args){
var args__$1 = cljs.core.seq(args);
if((argc === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var a7505 = cljs.core._first(args__$1);
var args__$2 = cljs.core._rest(args__$1);
if((argc === (1))){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a7505);
} else {
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(a7505) : f.call(null,a7505));
}
} else {
var b7506 = cljs.core._first(args__$2);
var args__$3 = cljs.core._rest(args__$2);
if((argc === (2))){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a7505,b7506);
} else {
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(a7505,b7506) : f.call(null,a7505,b7506));
}
} else {
var c7507 = cljs.core._first(args__$3);
var args__$4 = cljs.core._rest(args__$3);
if((argc === (3))){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a7505,b7506,c7507);
} else {
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(a7505,b7506,c7507) : f.call(null,a7505,b7506,c7507));
}
} else {
var d7508 = cljs.core._first(args__$4);
var args__$5 = cljs.core._rest(args__$4);
if((argc === (4))){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a7505,b7506,c7507,d7508);
} else {
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(a7505,b7506,c7507,d7508) : f.call(null,a7505,b7506,c7507,d7508));
}
} else {
var e7509 = cljs.core._first(args__$5);
var args__$6 = cljs.core._rest(args__$5);
if((argc === (5))){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a7505,b7506,c7507,d7508,e7509);
} else {
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(a7505,b7506,c7507,d7508,e7509) : f.call(null,a7505,b7506,c7507,d7508,e7509));
}
} else {
var f7510 = cljs.core._first(args__$6);
var args__$7 = cljs.core._rest(args__$6);
if((argc === (6))){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a7505,b7506,c7507,d7508,e7509,f7510);
} else {
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(a7505,b7506,c7507,d7508,e7509,f7510) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510));
}
} else {
var g7511 = cljs.core._first(args__$7);
var args__$8 = cljs.core._rest(args__$7);
if((argc === (7))){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a7505,b7506,c7507,d7508,e7509,f7510,g7511);
} else {
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(a7505,b7506,c7507,d7508,e7509,f7510,g7511) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511));
}
} else {
var h7512 = cljs.core._first(args__$8);
var args__$9 = cljs.core._rest(args__$8);
if((argc === (8))){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512);
} else {
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512));
}
} else {
var i7513 = cljs.core._first(args__$9);
var args__$10 = cljs.core._rest(args__$9);
if((argc === (9))){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513);
} else {
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513));
}
} else {
var j7514 = cljs.core._first(args__$10);
var args__$11 = cljs.core._rest(args__$10);
if((argc === (10))){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514);
} else {
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514));
}
} else {
var k7515 = cljs.core._first(args__$11);
var args__$12 = cljs.core._rest(args__$11);
if((argc === (11))){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515);
} else {
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515));
}
} else {
var l7516 = cljs.core._first(args__$12);
var args__$13 = cljs.core._rest(args__$12);
if((argc === (12))){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516);
} else {
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516));
}
} else {
var m7517 = cljs.core._first(args__$13);
var args__$14 = cljs.core._rest(args__$13);
if((argc === (13))){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517);
} else {
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517));
}
} else {
var n7518 = cljs.core._first(args__$14);
var args__$15 = cljs.core._rest(args__$14);
if((argc === (14))){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518);
} else {
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518));
}
} else {
var o7519 = cljs.core._first(args__$15);
var args__$16 = cljs.core._rest(args__$15);
if((argc === (15))){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519);
} else {
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519));
}
} else {
var p7520 = cljs.core._first(args__$16);
var args__$17 = cljs.core._rest(args__$16);
if((argc === (16))){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520);
} else {
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520));
}
} else {
var q7521 = cljs.core._first(args__$17);
var args__$18 = cljs.core._rest(args__$17);
if((argc === (17))){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521);
} else {
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521));
}
} else {
var r7522 = cljs.core._first(args__$18);
var args__$19 = cljs.core._rest(args__$18);
if((argc === (18))){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521,r7522);
} else {
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521,r7522) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521,r7522));
}
} else {
var s7523 = cljs.core._first(args__$19);
var args__$20 = cljs.core._rest(args__$19);
if((argc === (19))){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521,r7522,s7523);
} else {
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521,r7522,s7523) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521,r7522,s7523));
}
} else {
var t7524 = cljs.core._first(args__$20);
var args__$21 = cljs.core._rest(args__$20);
if((argc === (20))){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521,r7522,s7523,t7524);
} else {
return (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521,r7522,s7523,t7524) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521,r7522,s7523,t7524));
}
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
 * Applies fn f to the argument list formed by prepending intervening arguments to args.
 */
cljs.core.apply = (function cljs$core$apply(var_args){
var args23387 = [];
var len__7651__auto___23396 = arguments.length;
var i__7652__auto___23397 = (0);
while(true){
if((i__7652__auto___23397 < len__7651__auto___23396)){
args23387.push((arguments[i__7652__auto___23397]));

var G__23398 = (i__7652__auto___23397 + (1));
i__7652__auto___23397 = G__23398;
continue;
} else {
}
break;
}

var G__23395 = args23387.length;
switch (G__23395) {
case 2:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23387.slice((5)),(0),null));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__7670__auto__);

}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = (function (f,args){
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count((fixed_arity + (1)),args);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return f.apply(f,cljs.core.to_array(args));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = (function (f,x,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count((fixed_arity + (1)),arglist);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count((fixed_arity + (1)),arglist);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = (function (f,x,y,z,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count((fixed_arity + (1)),arglist);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = (function (f,a,b,c,d,args){
var arglist = cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(args)))));
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count((fixed_arity + (1)),arglist);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$lang$applyTo = (function (seq23388){
var G__23389 = cljs.core.first(seq23388);
var seq23388__$1 = cljs.core.next(seq23388);
var G__23390 = cljs.core.first(seq23388__$1);
var seq23388__$2 = cljs.core.next(seq23388__$1);
var G__23391 = cljs.core.first(seq23388__$2);
var seq23388__$3 = cljs.core.next(seq23388__$2);
var G__23392 = cljs.core.first(seq23388__$3);
var seq23388__$4 = cljs.core.next(seq23388__$3);
var G__23393 = cljs.core.first(seq23388__$4);
var seq23388__$5 = cljs.core.next(seq23388__$4);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(G__23389,G__23390,G__23391,G__23392,G__23393,seq23388__$5);
});

cljs.core.apply.cljs$lang$maxFixedArity = (5);

/**
 * Returns an object of the same type and value as obj, with
 *   (apply f (meta obj) args) as its metadata.
 */
cljs.core.vary_meta = (function cljs$core$vary_meta(var_args){
var args23400 = [];
var len__7651__auto___23425 = arguments.length;
var i__7652__auto___23426 = (0);
while(true){
if((i__7652__auto___23426 < len__7651__auto___23425)){
args23400.push((arguments[i__7652__auto___23426]));

var G__23427 = (i__7652__auto___23426 + (1));
i__7652__auto___23426 = G__23427;
continue;
} else {
}
break;
}

var G__23409 = args23400.length;
switch (G__23409) {
case 2:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23400.slice((6)),(0),null));
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__7670__auto__);

}
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = (function (obj,f){
return cljs.core.with_meta(obj,(function (){var G__23410 = cljs.core.meta(obj);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__23410) : f.call(null,G__23410));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = (function (obj,f,a){
return cljs.core.with_meta(obj,(function (){var G__23411 = cljs.core.meta(obj);
var G__23412 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__23411,G__23412) : f.call(null,G__23411,G__23412));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = (function (obj,f,a,b){
return cljs.core.with_meta(obj,(function (){var G__23413 = cljs.core.meta(obj);
var G__23414 = a;
var G__23415 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__23413,G__23414,G__23415) : f.call(null,G__23413,G__23414,G__23415));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = (function (obj,f,a,b,c){
return cljs.core.with_meta(obj,(function (){var G__23416 = cljs.core.meta(obj);
var G__23417 = a;
var G__23418 = b;
var G__23419 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__23416,G__23417,G__23418,G__23419) : f.call(null,G__23416,G__23417,G__23418,G__23419));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = (function (obj,f,a,b,c,d){
return cljs.core.with_meta(obj,(function (){var G__23420 = cljs.core.meta(obj);
var G__23421 = a;
var G__23422 = b;
var G__23423 = c;
var G__23424 = d;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__23420,G__23421,G__23422,G__23423,G__23424) : f.call(null,G__23420,G__23421,G__23422,G__23423,G__23424));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = (function (obj,f,a,b,c,d,args){
return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.array_seq([d,args], 0)));
});

cljs.core.vary_meta.cljs$lang$applyTo = (function (seq23401){
var G__23402 = cljs.core.first(seq23401);
var seq23401__$1 = cljs.core.next(seq23401);
var G__23403 = cljs.core.first(seq23401__$1);
var seq23401__$2 = cljs.core.next(seq23401__$1);
var G__23404 = cljs.core.first(seq23401__$2);
var seq23401__$3 = cljs.core.next(seq23401__$2);
var G__23405 = cljs.core.first(seq23401__$3);
var seq23401__$4 = cljs.core.next(seq23401__$3);
var G__23406 = cljs.core.first(seq23401__$4);
var seq23401__$5 = cljs.core.next(seq23401__$4);
var G__23407 = cljs.core.first(seq23401__$5);
var seq23401__$6 = cljs.core.next(seq23401__$5);
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(G__23402,G__23403,G__23404,G__23405,G__23406,G__23407,seq23401__$6);
});

cljs.core.vary_meta.cljs$lang$maxFixedArity = (6);

/**
 * Same as (not (= obj1 obj2))
 */
cljs.core.not_EQ_ = (function cljs$core$not_EQ_(var_args){
var args23429 = [];
var len__7651__auto___23435 = arguments.length;
var i__7652__auto___23436 = (0);
while(true){
if((i__7652__auto___23436 < len__7651__auto___23435)){
args23429.push((arguments[i__7652__auto___23436]));

var G__23437 = (i__7652__auto___23436 + (1));
i__7652__auto___23436 = G__23437;
continue;
} else {
}
break;
}

var G__23434 = args23429.length;
switch (G__23434) {
case 1:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23429.slice((2)),(0),null));
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return false;
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));
});

cljs.core.not_EQ_.cljs$lang$applyTo = (function (seq23430){
var G__23431 = cljs.core.first(seq23430);
var seq23430__$1 = cljs.core.next(seq23430);
var G__23432 = cljs.core.first(seq23430__$1);
var seq23430__$2 = cljs.core.next(seq23430__$1);
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(G__23431,G__23432,seq23430__$2);
});

cljs.core.not_EQ_.cljs$lang$maxFixedArity = (2);

/**
 * If coll is empty, returns nil, else coll
 */
cljs.core.not_empty = (function cljs$core$not_empty(coll){
if(cljs.core.seq(coll)){
return coll;
} else {
return null;
}
});
cljs.core.nil_iter = (function cljs$core$nil_iter(){
if(typeof cljs.core.t_cljs$core23442 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.t_cljs$core23442 = (function (meta23443){
this.meta23443 = meta23443;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.t_cljs$core23442.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23444,meta23443__$1){
var self__ = this;
var _23444__$1 = this;
return (new cljs.core.t_cljs$core23442(meta23443__$1));
});

cljs.core.t_cljs$core23442.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23444){
var self__ = this;
var _23444__$1 = this;
return self__.meta23443;
});

cljs.core.t_cljs$core23442.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return false;
});

cljs.core.t_cljs$core23442.prototype.next = (function (){
var self__ = this;
var _ = this;
return (new Error("No such element"));
});

cljs.core.t_cljs$core23442.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.t_cljs$core23442.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta23443], null);
});

cljs.core.t_cljs$core23442.cljs$lang$type = true;

cljs.core.t_cljs$core23442.cljs$lang$ctorStr = "cljs.core/t_cljs$core23442";

cljs.core.t_cljs$core23442.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/t_cljs$core23442");
});

cljs.core.__GT_t_cljs$core23442 = (function cljs$core$nil_iter_$___GT_t_cljs$core23442(meta23443){
return (new cljs.core.t_cljs$core23442(meta23443));
});

}

return (new cljs.core.t_cljs$core23442(cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
})
cljs.core.StringIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
});

cljs.core.StringIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.StringIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.StringIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.StringIter.cljs$lang$type = true;

cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";

cljs.core.StringIter.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/StringIter");
});

cljs.core.__GT_StringIter = (function cljs$core$__GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function cljs$core$string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.ArrayIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.ArrayIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.ArrayIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.ArrayIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayIter.cljs$lang$type = true;

cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";

cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ArrayIter");
});

cljs.core.__GT_ArrayIter = (function cljs$core$__GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function cljs$core$array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = ({});
cljs.core.START = ({});

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
})
cljs.core.SeqIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
self__._seq = cljs.core.START;

self__._next = cljs.core.seq(self__._next);
} else {
if((self__._seq === self__._next)){
self__._next = cljs.core.next(self__._seq);
} else {
}
}

return !((self__._next == null));
});

cljs.core.SeqIter.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(cljs.core.not(this$.hasNext())){
throw (new Error("No such element"));
} else {
self__._seq = self__._next;

return cljs.core.first(self__._next);
}
});

cljs.core.SeqIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.SeqIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$_seq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.SeqIter.cljs$lang$type = true;

cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";

cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/SeqIter");
});

cljs.core.__GT_SeqIter = (function cljs$core$__GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function cljs$core$seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function cljs$core$iter(coll){
if((coll == null)){
return cljs.core.nil_iter();
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter(coll);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_iter(coll);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core._iterator(coll);
} else {
if(cljs.core.seqable_QMARK_(coll)){
return cljs.core.seq_iter(coll);
} else {
throw (new Error([cljs.core.str("Cannot create iterator from "),cljs.core.str(coll)].join('')));

}
}
}
}
}
});
cljs.core.lazy_transformer = (function cljs$core$lazy_transformer(stepper){
return (new cljs.core.LazyTransformer(stepper,null,null,null));
});

/**
* @constructor
*/
cljs.core.Stepper = (function (xform,iter){
this.xform = xform;
this.iter = iter;
})
cljs.core.Stepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__6531__auto__ = !((lt.stepper == null));
if(and__6531__auto__){
return self__.iter.hasNext();
} else {
return and__6531__auto__;
}
})())){
if(cljs.core.reduced_QMARK_((function (){var G__23445 = lt;
var G__23446 = self__.iter.next();
return (self__.xform.cljs$core$IFn$_invoke$arity$2 ? self__.xform.cljs$core$IFn$_invoke$arity$2(G__23445,G__23446) : self__.xform.call(null,G__23445,G__23446));
})())){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(lt) : self__.xform.call(null,lt));
}
});

cljs.core.Stepper.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$iter], null);
});

cljs.core.Stepper.cljs$lang$type = true;

cljs.core.Stepper.cljs$lang$ctorStr = "cljs.core/Stepper";

cljs.core.Stepper.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/Stepper");
});

cljs.core.__GT_Stepper = (function cljs$core$__GT_Stepper(xform,iter){
return (new cljs.core.Stepper(xform,iter));
});

cljs.core.stepper = (function cljs$core$stepper(xform,iter){
var stepfn = (function() {
var cljs$core$stepper_$_stepfn = null;
var cljs$core$stepper_$_stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return result;
});
var cljs$core$stepper_$_stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
cljs$core$stepper_$_stepfn = function(result,input){
switch(arguments.length){
case 1:
return cljs$core$stepper_$_stepfn__1.call(this,result);
case 2:
return cljs$core$stepper_$_stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepper_$_stepfn__1;
cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepper_$_stepfn__2;
return cljs$core$stepper_$_stepfn;
})()
;
return (new cljs.core.Stepper((xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(stepfn) : xform.call(null,stepfn)),iter));
});

/**
* @constructor
*/
cljs.core.MultiStepper = (function (xform,iters,nexts){
this.xform = xform;
this.iters = iters;
this.nexts = nexts;
})
cljs.core.MultiStepper.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq(self__.iters);
while(true){
if(!((iters__$1 == null))){
var iter = cljs.core.first(iters__$1);
if(cljs.core.not(iter.hasNext())){
return false;
} else {
var G__23447 = cljs.core.next(iters__$1);
iters__$1 = G__23447;
continue;
}
} else {
return true;
}
break;
}
});

cljs.core.MultiStepper.prototype.next = (function (){
var self__ = this;
var _ = this;
var n__7461__auto___23448 = self__.iters.length;
var i_23449 = (0);
while(true){
if((i_23449 < n__7461__auto___23448)){
(self__.nexts[i_23449] = (self__.iters[i_23449]).next());

var G__23450 = (i_23449 + (1));
i_23449 = G__23450;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(self__.nexts,(0));
});

cljs.core.MultiStepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__6531__auto__ = !((lt.stepper == null));
if(and__6531__auto__){
return this$.hasNext();
} else {
return and__6531__auto__;
}
})())){
if(cljs.core.reduced_QMARK_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xform,cljs.core.cons(lt,this$.next())))){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(lt) : self__.xform.call(null,lt));
}
});

cljs.core.MultiStepper.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$iters,cljs.core.cst$sym$nexts], null);
});

cljs.core.MultiStepper.cljs$lang$type = true;

cljs.core.MultiStepper.cljs$lang$ctorStr = "cljs.core/MultiStepper";

cljs.core.MultiStepper.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/MultiStepper");
});

cljs.core.__GT_MultiStepper = (function cljs$core$__GT_MultiStepper(xform,iters,nexts){
return (new cljs.core.MultiStepper(xform,iters,nexts));
});

cljs.core.multi_stepper = (function cljs$core$multi_stepper(var_args){
var args23451 = [];
var len__7651__auto___23454 = arguments.length;
var i__7652__auto___23455 = (0);
while(true){
if((i__7652__auto___23455 < len__7651__auto___23454)){
args23451.push((arguments[i__7652__auto___23455]));

var G__23456 = (i__7652__auto___23455 + (1));
i__7652__auto___23455 = G__23456;
continue;
} else {
}
break;
}

var G__23453 = args23451.length;
switch (G__23453) {
case 2:
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23451.length)].join('')));

}
});

cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2 = (function (xform,iters){
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length)));
});

cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3 = (function (xform,iters,nexts){
var stepfn = (function() {
var cljs$core$stepfn = null;
var cljs$core$stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return lt;
});
var cljs$core$stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
cljs$core$stepfn = function(result,input){
switch(arguments.length){
case 1:
return cljs$core$stepfn__1.call(this,result);
case 2:
return cljs$core$stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepfn__1;
cljs$core$stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepfn__2;
return cljs$core$stepfn;
})()
;
return (new cljs.core.MultiStepper((xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(stepfn) : xform.call(null,stepfn)),iters,nexts));
});

cljs.core.multi_stepper.cljs$lang$maxFixedArity = 3;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.LazyTransformer = (function (stepper,first,rest,meta){
this.stepper = stepper;
this.first = first;
this.rest = rest;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 31850700;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.LazyTransformer.prototype.indexOf = (function() {
var G__23458 = null;
var G__23458__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__23458__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__23458 = function(x,start){
switch(arguments.length){
case 1:
return G__23458__1.call(this,x);
case 2:
return G__23458__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23458.cljs$core$IFn$_invoke$arity$1 = G__23458__1;
G__23458.cljs$core$IFn$_invoke$arity$2 = G__23458__2;
return G__23458;
})()
;

cljs.core.LazyTransformer.prototype.lastIndexOf = (function() {
var G__23459 = null;
var G__23459__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__23459__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__23459 = function(x,start){
switch(arguments.length){
case 1:
return G__23459__1.call(this,x);
case 2:
return G__23459__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23459.cljs$core$IFn$_invoke$arity$1 = G__23459__1;
G__23459.cljs$core$IFn$_invoke$arity$2 = G__23459__2;
return G__23459;
})()
;

cljs.core.LazyTransformer.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
});

cljs.core.LazyTransformer.prototype.cljs$core$INext$_next$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return cljs.core._seq(self__.rest);
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.hash_ordered_coll(this$__$1);
});

cljs.core.LazyTransformer.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
var s = cljs.core._seq(this$__$1);
if(!((s == null))){
return cljs.core.equiv_sequential(this$__$1,other);
} else {
return (cljs.core.sequential_QMARK_(other)) && ((cljs.core.seq(other) == null));
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return self__.first;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
self__.stepper.step(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return this$__$1;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,new_meta){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.LazyTransformer(self__.stepper,self__.first,self__.rest,new_meta));
});

cljs.core.LazyTransformer.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,cljs.core._seq(this$__$1));
});

cljs.core.LazyTransformer.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$stepper,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$first,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$rest,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$meta], null);
});

cljs.core.LazyTransformer.cljs$lang$type = true;

cljs.core.LazyTransformer.cljs$lang$ctorStr = "cljs.core/LazyTransformer";

cljs.core.LazyTransformer.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/LazyTransformer");
});

cljs.core.__GT_LazyTransformer = (function cljs$core$__GT_LazyTransformer(stepper,first,rest,meta){
return (new cljs.core.LazyTransformer(stepper,first,rest,meta));
});

(cljs.core.LazyTransformer.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
cljs.core.LazyTransformer.create = (function (xform,coll){
return (new cljs.core.LazyTransformer(cljs.core.stepper(xform,cljs.core.iter(coll)),null,null,null));
});
cljs.core.LazyTransformer.createMulti = (function (xform,colls){
var iters = [];
var seq__23460_23464 = cljs.core.seq(colls);
var chunk__23461_23465 = null;
var count__23462_23466 = (0);
var i__23463_23467 = (0);
while(true){
if((i__23463_23467 < count__23462_23466)){
var coll_23468 = chunk__23461_23465.cljs$core$IIndexed$_nth$arity$2(null,i__23463_23467);
iters.push(cljs.core.iter(coll_23468));

var G__23469 = seq__23460_23464;
var G__23470 = chunk__23461_23465;
var G__23471 = count__23462_23466;
var G__23472 = (i__23463_23467 + (1));
seq__23460_23464 = G__23469;
chunk__23461_23465 = G__23470;
count__23462_23466 = G__23471;
i__23463_23467 = G__23472;
continue;
} else {
var temp__4657__auto___23473 = cljs.core.seq(seq__23460_23464);
if(temp__4657__auto___23473){
var seq__23460_23474__$1 = temp__4657__auto___23473;
if(cljs.core.chunked_seq_QMARK_(seq__23460_23474__$1)){
var c__7357__auto___23475 = cljs.core.chunk_first(seq__23460_23474__$1);
var G__23476 = cljs.core.chunk_rest(seq__23460_23474__$1);
var G__23477 = c__7357__auto___23475;
var G__23478 = cljs.core.count(c__7357__auto___23475);
var G__23479 = (0);
seq__23460_23464 = G__23476;
chunk__23461_23465 = G__23477;
count__23462_23466 = G__23478;
i__23463_23467 = G__23479;
continue;
} else {
var coll_23480 = cljs.core.first(seq__23460_23474__$1);
iters.push(cljs.core.iter(coll_23480));

var G__23481 = cljs.core.next(seq__23460_23474__$1);
var G__23482 = null;
var G__23483 = (0);
var G__23484 = (0);
seq__23460_23464 = G__23481;
chunk__23461_23465 = G__23482;
count__23462_23466 = G__23483;
i__23463_23467 = G__23484;
continue;
}
} else {
}
}
break;
}

return (new cljs.core.LazyTransformer(cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length))),null,null,null));
});
/**
 * Coerces coll to a (possibly empty) sequence, if it is not already
 *   one. Will not force a lazy seq. (sequence nil) yields (), When a
 *   transducer is supplied, returns a lazy sequence of applications of
 *   the transform to the items in coll(s), i.e. to the set of first
 *   items of each coll, followed by the set of second
 *   items in each coll, until any one of the colls is exhausted.  Any
 *   remaining items in other colls are ignored. The transform should accept
 *   number-of-colls arguments
 */
cljs.core.sequence = (function cljs$core$sequence(var_args){
var args23485 = [];
var len__7651__auto___23491 = arguments.length;
var i__7652__auto___23492 = (0);
while(true){
if((i__7652__auto___23492 < len__7651__auto___23491)){
args23485.push((arguments[i__7652__auto___23492]));

var G__23493 = (i__7652__auto___23492 + (1));
i__7652__auto___23492 = G__23493;
continue;
} else {
}
break;
}

var G__23490 = args23485.length;
switch (G__23490) {
case 1:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23485.slice((2)),(0),null));
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = (function (coll){
if(cljs.core.seq_QMARK_(coll)){
return coll;
} else {
var or__6543__auto__ = cljs.core.seq(coll);
if(or__6543__auto__){
return or__6543__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = (function (xform,coll){
return cljs.core.LazyTransformer.create(xform,coll);
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = (function (xform,coll,colls){
return cljs.core.LazyTransformer.createMulti(xform,cljs.core.to_array(cljs.core.cons(coll,colls)));
});

cljs.core.sequence.cljs$lang$applyTo = (function (seq23486){
var G__23487 = cljs.core.first(seq23486);
var seq23486__$1 = cljs.core.next(seq23486);
var G__23488 = cljs.core.first(seq23486__$1);
var seq23486__$2 = cljs.core.next(seq23486__$1);
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(G__23487,G__23488,seq23486__$2);
});

cljs.core.sequence.cljs$lang$maxFixedArity = (2);

/**
 * Returns true if (pred x) is logical true for every x in coll, else
 *   false.
 */
cljs.core.every_QMARK_ = (function cljs$core$every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq(coll) == null)){
return true;
} else {
if(cljs.core.truth_((function (){var G__23496 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__23496) : pred.call(null,G__23496));
})())){
var G__23497 = pred;
var G__23498 = cljs.core.next(coll);
pred = G__23497;
coll = G__23498;
continue;
} else {
return false;

}
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for every x in
 *   coll, else true.
 */
cljs.core.not_every_QMARK_ = (function cljs$core$not_every_QMARK_(pred,coll){
return !(cljs.core.every_QMARK_(pred,coll));
});
/**
 * Returns the first logical true value of (pred x) for any x in coll,
 *   else nil.  One common idiom is to use a set as pred, for example
 *   this will return :fred if :fred is in the sequence, otherwise nil:
 *   (some #{:fred} coll)
 */
cljs.core.some = (function cljs$core$some(pred,coll){
while(true){
if(cljs.core.seq(coll)){
var or__6543__auto__ = (function (){var G__23502 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__23502) : pred.call(null,G__23502));
})();
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var G__23503 = pred;
var G__23504 = cljs.core.next(coll);
pred = G__23503;
coll = G__23504;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for any x in coll,
 *   else true.
 */
cljs.core.not_any_QMARK_ = (function cljs$core$not_any_QMARK_(pred,coll){
return cljs.core.not(cljs.core.some(pred,coll));
});
/**
 * Returns true if n is even, throws an exception if n is not an integer
 */
cljs.core.even_QMARK_ = (function cljs$core$even_QMARK_(n){
if(cljs.core.integer_QMARK_(n)){
return ((n & (1)) === (0));
} else {
throw (new Error([cljs.core.str("Argument must be an integer: "),cljs.core.str(n)].join('')));
}
});
/**
 * Returns true if n is odd, throws an exception if n is not an integer
 */
cljs.core.odd_QMARK_ = (function cljs$core$odd_QMARK_(n){
return !(cljs.core.even_QMARK_(n));
});
/**
 * Takes a fn f and returns a fn that takes the same arguments as f,
 *   has the same effects, if any, and returns the opposite truth value.
 */
cljs.core.complement = (function cljs$core$complement(f){
return (function() {
var G__23505 = null;
var G__23505__0 = (function (){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});
var G__23505__1 = (function (x){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)));
});
var G__23505__2 = (function (x,y){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)));
});
var G__23505__3 = (function() { 
var G__23506__delegate = function (x,y,zs){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));
};
var G__23506 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__23507__i = 0, G__23507__a = new Array(arguments.length -  2);
while (G__23507__i < G__23507__a.length) {G__23507__a[G__23507__i] = arguments[G__23507__i + 2]; ++G__23507__i;}
  zs = new cljs.core.IndexedSeq(G__23507__a,0);
} 
return G__23506__delegate.call(this,x,y,zs);};
G__23506.cljs$lang$maxFixedArity = 2;
G__23506.cljs$lang$applyTo = (function (arglist__23508){
var x = cljs.core.first(arglist__23508);
arglist__23508 = cljs.core.next(arglist__23508);
var y = cljs.core.first(arglist__23508);
var zs = cljs.core.rest(arglist__23508);
return G__23506__delegate(x,y,zs);
});
G__23506.cljs$core$IFn$_invoke$arity$variadic = G__23506__delegate;
return G__23506;
})()
;
G__23505 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return G__23505__0.call(this);
case 1:
return G__23505__1.call(this,x);
case 2:
return G__23505__2.call(this,x,y);
default:
var G__23509 = null;
if (arguments.length > 2) {
var G__23510__i = 0, G__23510__a = new Array(arguments.length -  2);
while (G__23510__i < G__23510__a.length) {G__23510__a[G__23510__i] = arguments[G__23510__i + 2]; ++G__23510__i;}
G__23509 = new cljs.core.IndexedSeq(G__23510__a,0);
}
return G__23505__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__23509);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23505.cljs$lang$maxFixedArity = 2;
G__23505.cljs$lang$applyTo = G__23505__3.cljs$lang$applyTo;
G__23505.cljs$core$IFn$_invoke$arity$0 = G__23505__0;
G__23505.cljs$core$IFn$_invoke$arity$1 = G__23505__1;
G__23505.cljs$core$IFn$_invoke$arity$2 = G__23505__2;
G__23505.cljs$core$IFn$_invoke$arity$variadic = G__23505__3.cljs$core$IFn$_invoke$arity$variadic;
return G__23505;
})()
});
/**
 * Returns a function that takes any number of arguments and returns x.
 */
cljs.core.constantly = (function cljs$core$constantly(x){
return (function() { 
var G__23511__delegate = function (args){
return x;
};
var G__23511 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__23512__i = 0, G__23512__a = new Array(arguments.length -  0);
while (G__23512__i < G__23512__a.length) {G__23512__a[G__23512__i] = arguments[G__23512__i + 0]; ++G__23512__i;}
  args = new cljs.core.IndexedSeq(G__23512__a,0);
} 
return G__23511__delegate.call(this,args);};
G__23511.cljs$lang$maxFixedArity = 0;
G__23511.cljs$lang$applyTo = (function (arglist__23513){
var args = cljs.core.seq(arglist__23513);
return G__23511__delegate(args);
});
G__23511.cljs$core$IFn$_invoke$arity$variadic = G__23511__delegate;
return G__23511;
})()
;
});
/**
 * Takes a set of functions and returns a fn that is the composition
 *   of those fns.  The returned fn takes a variable number of args,
 *   applies the rightmost of fns to the args, the next
 *   fn (right-to-left) to the result, etc.
 */
cljs.core.comp = (function cljs$core$comp(var_args){
var args23514 = [];
var len__7651__auto___23536 = arguments.length;
var i__7652__auto___23537 = (0);
while(true){
if((i__7652__auto___23537 < len__7651__auto___23536)){
args23514.push((arguments[i__7652__auto___23537]));

var G__23538 = (i__7652__auto___23537 + (1));
i__7652__auto___23537 = G__23538;
continue;
} else {
}
break;
}

var G__23520 = args23514.length;
switch (G__23520) {
case 0:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23514.slice((3)),(0),null));
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7670__auto__);

}
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.identity;
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = (function (f,g){
return (function() {
var G__23540 = null;
var G__23540__0 = (function (){
var G__23521 = (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__23521) : f.call(null,G__23521));
});
var G__23540__1 = (function (x){
var G__23522 = (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__23522) : f.call(null,G__23522));
});
var G__23540__2 = (function (x,y){
var G__23523 = (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__23523) : f.call(null,G__23523));
});
var G__23540__3 = (function (x,y,z){
var G__23524 = (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__23524) : f.call(null,G__23524));
});
var G__23540__4 = (function() { 
var G__23541__delegate = function (x,y,z,args){
var G__23525 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__23525) : f.call(null,G__23525));
};
var G__23541 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__23542__i = 0, G__23542__a = new Array(arguments.length -  3);
while (G__23542__i < G__23542__a.length) {G__23542__a[G__23542__i] = arguments[G__23542__i + 3]; ++G__23542__i;}
  args = new cljs.core.IndexedSeq(G__23542__a,0);
} 
return G__23541__delegate.call(this,x,y,z,args);};
G__23541.cljs$lang$maxFixedArity = 3;
G__23541.cljs$lang$applyTo = (function (arglist__23543){
var x = cljs.core.first(arglist__23543);
arglist__23543 = cljs.core.next(arglist__23543);
var y = cljs.core.first(arglist__23543);
arglist__23543 = cljs.core.next(arglist__23543);
var z = cljs.core.first(arglist__23543);
var args = cljs.core.rest(arglist__23543);
return G__23541__delegate(x,y,z,args);
});
G__23541.cljs$core$IFn$_invoke$arity$variadic = G__23541__delegate;
return G__23541;
})()
;
G__23540 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__23540__0.call(this);
case 1:
return G__23540__1.call(this,x);
case 2:
return G__23540__2.call(this,x,y);
case 3:
return G__23540__3.call(this,x,y,z);
default:
var G__23544 = null;
if (arguments.length > 3) {
var G__23545__i = 0, G__23545__a = new Array(arguments.length -  3);
while (G__23545__i < G__23545__a.length) {G__23545__a[G__23545__i] = arguments[G__23545__i + 3]; ++G__23545__i;}
G__23544 = new cljs.core.IndexedSeq(G__23545__a,0);
}
return G__23540__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__23544);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23540.cljs$lang$maxFixedArity = 3;
G__23540.cljs$lang$applyTo = G__23540__4.cljs$lang$applyTo;
G__23540.cljs$core$IFn$_invoke$arity$0 = G__23540__0;
G__23540.cljs$core$IFn$_invoke$arity$1 = G__23540__1;
G__23540.cljs$core$IFn$_invoke$arity$2 = G__23540__2;
G__23540.cljs$core$IFn$_invoke$arity$3 = G__23540__3;
G__23540.cljs$core$IFn$_invoke$arity$variadic = G__23540__4.cljs$core$IFn$_invoke$arity$variadic;
return G__23540;
})()
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = (function (f,g,h){
return (function() {
var G__23546 = null;
var G__23546__0 = (function (){
var G__23526 = (function (){var G__23527 = (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__23527) : g.call(null,G__23527));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__23526) : f.call(null,G__23526));
});
var G__23546__1 = (function (x){
var G__23528 = (function (){var G__23529 = (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null,x));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__23529) : g.call(null,G__23529));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__23528) : f.call(null,G__23528));
});
var G__23546__2 = (function (x,y){
var G__23530 = (function (){var G__23531 = (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x,y) : h.call(null,x,y));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__23531) : g.call(null,G__23531));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__23530) : f.call(null,G__23530));
});
var G__23546__3 = (function (x,y,z){
var G__23532 = (function (){var G__23533 = (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x,y,z) : h.call(null,x,y,z));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__23533) : g.call(null,G__23533));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__23532) : f.call(null,G__23532));
});
var G__23546__4 = (function() { 
var G__23547__delegate = function (x,y,z,args){
var G__23534 = (function (){var G__23535 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__23535) : g.call(null,G__23535));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__23534) : f.call(null,G__23534));
};
var G__23547 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__23548__i = 0, G__23548__a = new Array(arguments.length -  3);
while (G__23548__i < G__23548__a.length) {G__23548__a[G__23548__i] = arguments[G__23548__i + 3]; ++G__23548__i;}
  args = new cljs.core.IndexedSeq(G__23548__a,0);
} 
return G__23547__delegate.call(this,x,y,z,args);};
G__23547.cljs$lang$maxFixedArity = 3;
G__23547.cljs$lang$applyTo = (function (arglist__23549){
var x = cljs.core.first(arglist__23549);
arglist__23549 = cljs.core.next(arglist__23549);
var y = cljs.core.first(arglist__23549);
arglist__23549 = cljs.core.next(arglist__23549);
var z = cljs.core.first(arglist__23549);
var args = cljs.core.rest(arglist__23549);
return G__23547__delegate(x,y,z,args);
});
G__23547.cljs$core$IFn$_invoke$arity$variadic = G__23547__delegate;
return G__23547;
})()
;
G__23546 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__23546__0.call(this);
case 1:
return G__23546__1.call(this,x);
case 2:
return G__23546__2.call(this,x,y);
case 3:
return G__23546__3.call(this,x,y,z);
default:
var G__23550 = null;
if (arguments.length > 3) {
var G__23551__i = 0, G__23551__a = new Array(arguments.length -  3);
while (G__23551__i < G__23551__a.length) {G__23551__a[G__23551__i] = arguments[G__23551__i + 3]; ++G__23551__i;}
G__23550 = new cljs.core.IndexedSeq(G__23551__a,0);
}
return G__23546__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__23550);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23546.cljs$lang$maxFixedArity = 3;
G__23546.cljs$lang$applyTo = G__23546__4.cljs$lang$applyTo;
G__23546.cljs$core$IFn$_invoke$arity$0 = G__23546__0;
G__23546.cljs$core$IFn$_invoke$arity$1 = G__23546__1;
G__23546.cljs$core$IFn$_invoke$arity$2 = G__23546__2;
G__23546.cljs$core$IFn$_invoke$arity$3 = G__23546__3;
G__23546.cljs$core$IFn$_invoke$arity$variadic = G__23546__4.cljs$core$IFn$_invoke$arity$variadic;
return G__23546;
})()
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = (function (f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));
return ((function (fs__$1){
return (function() { 
var G__23552__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);
var fs__$2 = cljs.core.next(fs__$1);
while(true){
if(fs__$2){
var G__23553 = cljs.core.first(fs__$2).call(null,ret);
var G__23554 = cljs.core.next(fs__$2);
ret = G__23553;
fs__$2 = G__23554;
continue;
} else {
return ret;
}
break;
}
};
var G__23552 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__23555__i = 0, G__23555__a = new Array(arguments.length -  0);
while (G__23555__i < G__23555__a.length) {G__23555__a[G__23555__i] = arguments[G__23555__i + 0]; ++G__23555__i;}
  args = new cljs.core.IndexedSeq(G__23555__a,0);
} 
return G__23552__delegate.call(this,args);};
G__23552.cljs$lang$maxFixedArity = 0;
G__23552.cljs$lang$applyTo = (function (arglist__23556){
var args = cljs.core.seq(arglist__23556);
return G__23552__delegate(args);
});
G__23552.cljs$core$IFn$_invoke$arity$variadic = G__23552__delegate;
return G__23552;
})()
;
;})(fs__$1))
});

cljs.core.comp.cljs$lang$applyTo = (function (seq23515){
var G__23516 = cljs.core.first(seq23515);
var seq23515__$1 = cljs.core.next(seq23515);
var G__23517 = cljs.core.first(seq23515__$1);
var seq23515__$2 = cljs.core.next(seq23515__$1);
var G__23518 = cljs.core.first(seq23515__$2);
var seq23515__$3 = cljs.core.next(seq23515__$2);
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(G__23516,G__23517,G__23518,seq23515__$3);
});

cljs.core.comp.cljs$lang$maxFixedArity = (3);

/**
 * Takes a function f and fewer than the normal arguments to f, and
 *   returns a fn that takes a variable number of additional args. When
 *   called, the returned function calls f with args + additional args.
 */
cljs.core.partial = (function cljs$core$partial(var_args){
var args23557 = [];
var len__7651__auto___23565 = arguments.length;
var i__7652__auto___23566 = (0);
while(true){
if((i__7652__auto___23566 < len__7651__auto___23565)){
args23557.push((arguments[i__7652__auto___23566]));

var G__23567 = (i__7652__auto___23566 + (1));
i__7652__auto___23566 = G__23567;
continue;
} else {
}
break;
}

var G__23564 = args23557.length;
switch (G__23564) {
case 1:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23557.slice((4)),(0),null));
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7670__auto__);

}
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = (function (f,arg1){
return (function() {
var G__23569 = null;
var G__23569__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(arg1) : f.call(null,arg1));
});
var G__23569__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,x) : f.call(null,arg1,x));
});
var G__23569__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,x,y) : f.call(null,arg1,x,y));
});
var G__23569__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,x,y,z) : f.call(null,arg1,x,y,z));
});
var G__23569__4 = (function() { 
var G__23570__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.array_seq([args], 0));
};
var G__23570 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__23571__i = 0, G__23571__a = new Array(arguments.length -  3);
while (G__23571__i < G__23571__a.length) {G__23571__a[G__23571__i] = arguments[G__23571__i + 3]; ++G__23571__i;}
  args = new cljs.core.IndexedSeq(G__23571__a,0);
} 
return G__23570__delegate.call(this,x,y,z,args);};
G__23570.cljs$lang$maxFixedArity = 3;
G__23570.cljs$lang$applyTo = (function (arglist__23572){
var x = cljs.core.first(arglist__23572);
arglist__23572 = cljs.core.next(arglist__23572);
var y = cljs.core.first(arglist__23572);
arglist__23572 = cljs.core.next(arglist__23572);
var z = cljs.core.first(arglist__23572);
var args = cljs.core.rest(arglist__23572);
return G__23570__delegate(x,y,z,args);
});
G__23570.cljs$core$IFn$_invoke$arity$variadic = G__23570__delegate;
return G__23570;
})()
;
G__23569 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__23569__0.call(this);
case 1:
return G__23569__1.call(this,x);
case 2:
return G__23569__2.call(this,x,y);
case 3:
return G__23569__3.call(this,x,y,z);
default:
var G__23573 = null;
if (arguments.length > 3) {
var G__23574__i = 0, G__23574__a = new Array(arguments.length -  3);
while (G__23574__i < G__23574__a.length) {G__23574__a[G__23574__i] = arguments[G__23574__i + 3]; ++G__23574__i;}
G__23573 = new cljs.core.IndexedSeq(G__23574__a,0);
}
return G__23569__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__23573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23569.cljs$lang$maxFixedArity = 3;
G__23569.cljs$lang$applyTo = G__23569__4.cljs$lang$applyTo;
G__23569.cljs$core$IFn$_invoke$arity$0 = G__23569__0;
G__23569.cljs$core$IFn$_invoke$arity$1 = G__23569__1;
G__23569.cljs$core$IFn$_invoke$arity$2 = G__23569__2;
G__23569.cljs$core$IFn$_invoke$arity$3 = G__23569__3;
G__23569.cljs$core$IFn$_invoke$arity$variadic = G__23569__4.cljs$core$IFn$_invoke$arity$variadic;
return G__23569;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = (function (f,arg1,arg2){
return (function() {
var G__23575 = null;
var G__23575__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,arg2) : f.call(null,arg1,arg2));
});
var G__23575__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,x) : f.call(null,arg1,arg2,x));
});
var G__23575__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,x,y) : f.call(null,arg1,arg2,x,y));
});
var G__23575__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,x,y,z) : f.call(null,arg1,arg2,x,y,z));
});
var G__23575__4 = (function() { 
var G__23576__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.array_seq([z,args], 0));
};
var G__23576 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__23577__i = 0, G__23577__a = new Array(arguments.length -  3);
while (G__23577__i < G__23577__a.length) {G__23577__a[G__23577__i] = arguments[G__23577__i + 3]; ++G__23577__i;}
  args = new cljs.core.IndexedSeq(G__23577__a,0);
} 
return G__23576__delegate.call(this,x,y,z,args);};
G__23576.cljs$lang$maxFixedArity = 3;
G__23576.cljs$lang$applyTo = (function (arglist__23578){
var x = cljs.core.first(arglist__23578);
arglist__23578 = cljs.core.next(arglist__23578);
var y = cljs.core.first(arglist__23578);
arglist__23578 = cljs.core.next(arglist__23578);
var z = cljs.core.first(arglist__23578);
var args = cljs.core.rest(arglist__23578);
return G__23576__delegate(x,y,z,args);
});
G__23576.cljs$core$IFn$_invoke$arity$variadic = G__23576__delegate;
return G__23576;
})()
;
G__23575 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__23575__0.call(this);
case 1:
return G__23575__1.call(this,x);
case 2:
return G__23575__2.call(this,x,y);
case 3:
return G__23575__3.call(this,x,y,z);
default:
var G__23579 = null;
if (arguments.length > 3) {
var G__23580__i = 0, G__23580__a = new Array(arguments.length -  3);
while (G__23580__i < G__23580__a.length) {G__23580__a[G__23580__i] = arguments[G__23580__i + 3]; ++G__23580__i;}
G__23579 = new cljs.core.IndexedSeq(G__23580__a,0);
}
return G__23575__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__23579);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23575.cljs$lang$maxFixedArity = 3;
G__23575.cljs$lang$applyTo = G__23575__4.cljs$lang$applyTo;
G__23575.cljs$core$IFn$_invoke$arity$0 = G__23575__0;
G__23575.cljs$core$IFn$_invoke$arity$1 = G__23575__1;
G__23575.cljs$core$IFn$_invoke$arity$2 = G__23575__2;
G__23575.cljs$core$IFn$_invoke$arity$3 = G__23575__3;
G__23575.cljs$core$IFn$_invoke$arity$variadic = G__23575__4.cljs$core$IFn$_invoke$arity$variadic;
return G__23575;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = (function (f,arg1,arg2,arg3){
return (function() {
var G__23581 = null;
var G__23581__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,arg3) : f.call(null,arg1,arg2,arg3));
});
var G__23581__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,arg3,x) : f.call(null,arg1,arg2,arg3,x));
});
var G__23581__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,arg3,x,y) : f.call(null,arg1,arg2,arg3,x,y));
});
var G__23581__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(arg1,arg2,arg3,x,y,z) : f.call(null,arg1,arg2,arg3,x,y,z));
});
var G__23581__4 = (function() { 
var G__23582__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.array_seq([y,z,args], 0));
};
var G__23582 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__23583__i = 0, G__23583__a = new Array(arguments.length -  3);
while (G__23583__i < G__23583__a.length) {G__23583__a[G__23583__i] = arguments[G__23583__i + 3]; ++G__23583__i;}
  args = new cljs.core.IndexedSeq(G__23583__a,0);
} 
return G__23582__delegate.call(this,x,y,z,args);};
G__23582.cljs$lang$maxFixedArity = 3;
G__23582.cljs$lang$applyTo = (function (arglist__23584){
var x = cljs.core.first(arglist__23584);
arglist__23584 = cljs.core.next(arglist__23584);
var y = cljs.core.first(arglist__23584);
arglist__23584 = cljs.core.next(arglist__23584);
var z = cljs.core.first(arglist__23584);
var args = cljs.core.rest(arglist__23584);
return G__23582__delegate(x,y,z,args);
});
G__23582.cljs$core$IFn$_invoke$arity$variadic = G__23582__delegate;
return G__23582;
})()
;
G__23581 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__23581__0.call(this);
case 1:
return G__23581__1.call(this,x);
case 2:
return G__23581__2.call(this,x,y);
case 3:
return G__23581__3.call(this,x,y,z);
default:
var G__23585 = null;
if (arguments.length > 3) {
var G__23586__i = 0, G__23586__a = new Array(arguments.length -  3);
while (G__23586__i < G__23586__a.length) {G__23586__a[G__23586__i] = arguments[G__23586__i + 3]; ++G__23586__i;}
G__23585 = new cljs.core.IndexedSeq(G__23586__a,0);
}
return G__23581__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__23585);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23581.cljs$lang$maxFixedArity = 3;
G__23581.cljs$lang$applyTo = G__23581__4.cljs$lang$applyTo;
G__23581.cljs$core$IFn$_invoke$arity$0 = G__23581__0;
G__23581.cljs$core$IFn$_invoke$arity$1 = G__23581__1;
G__23581.cljs$core$IFn$_invoke$arity$2 = G__23581__2;
G__23581.cljs$core$IFn$_invoke$arity$3 = G__23581__3;
G__23581.cljs$core$IFn$_invoke$arity$variadic = G__23581__4.cljs$core$IFn$_invoke$arity$variadic;
return G__23581;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = (function (f,arg1,arg2,arg3,more){
return (function() { 
var G__23587__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));
};
var G__23587 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__23588__i = 0, G__23588__a = new Array(arguments.length -  0);
while (G__23588__i < G__23588__a.length) {G__23588__a[G__23588__i] = arguments[G__23588__i + 0]; ++G__23588__i;}
  args = new cljs.core.IndexedSeq(G__23588__a,0);
} 
return G__23587__delegate.call(this,args);};
G__23587.cljs$lang$maxFixedArity = 0;
G__23587.cljs$lang$applyTo = (function (arglist__23589){
var args = cljs.core.seq(arglist__23589);
return G__23587__delegate(args);
});
G__23587.cljs$core$IFn$_invoke$arity$variadic = G__23587__delegate;
return G__23587;
})()
;
});

cljs.core.partial.cljs$lang$applyTo = (function (seq23558){
var G__23559 = cljs.core.first(seq23558);
var seq23558__$1 = cljs.core.next(seq23558);
var G__23560 = cljs.core.first(seq23558__$1);
var seq23558__$2 = cljs.core.next(seq23558__$1);
var G__23561 = cljs.core.first(seq23558__$2);
var seq23558__$3 = cljs.core.next(seq23558__$2);
var G__23562 = cljs.core.first(seq23558__$3);
var seq23558__$4 = cljs.core.next(seq23558__$3);
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(G__23559,G__23560,G__23561,G__23562,seq23558__$4);
});

cljs.core.partial.cljs$lang$maxFixedArity = (4);

/**
 * Takes a function f, and returns a function that calls f, replacing
 *   a nil first argument to f with the supplied value x. Higher arity
 *   versions can replace arguments in the second and third
 *   positions (y, z). Note that the function f can take any number of
 *   arguments, not just the one(s) being nil-patched.
 */
cljs.core.fnil = (function cljs$core$fnil(var_args){
var args23590 = [];
var len__7651__auto___23609 = arguments.length;
var i__7652__auto___23610 = (0);
while(true){
if((i__7652__auto___23610 < len__7651__auto___23609)){
args23590.push((arguments[i__7652__auto___23610]));

var G__23611 = (i__7652__auto___23610 + (1));
i__7652__auto___23610 = G__23611;
continue;
} else {
}
break;
}

var G__23592 = args23590.length;
switch (G__23592) {
case 2:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23590.length)].join('')));

}
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = (function (f,x){
return (function() {
var G__23613 = null;
var G__23613__1 = (function (a){
var G__23593 = (((a == null))?x:a);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__23593) : f.call(null,G__23593));
});
var G__23613__2 = (function (a,b){
var G__23594 = (((a == null))?x:a);
var G__23595 = b;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__23594,G__23595) : f.call(null,G__23594,G__23595));
});
var G__23613__3 = (function (a,b,c){
var G__23596 = (((a == null))?x:a);
var G__23597 = b;
var G__23598 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__23596,G__23597,G__23598) : f.call(null,G__23596,G__23597,G__23598));
});
var G__23613__4 = (function() { 
var G__23614__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),b,c,ds);
};
var G__23614 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__23615__i = 0, G__23615__a = new Array(arguments.length -  3);
while (G__23615__i < G__23615__a.length) {G__23615__a[G__23615__i] = arguments[G__23615__i + 3]; ++G__23615__i;}
  ds = new cljs.core.IndexedSeq(G__23615__a,0);
} 
return G__23614__delegate.call(this,a,b,c,ds);};
G__23614.cljs$lang$maxFixedArity = 3;
G__23614.cljs$lang$applyTo = (function (arglist__23616){
var a = cljs.core.first(arglist__23616);
arglist__23616 = cljs.core.next(arglist__23616);
var b = cljs.core.first(arglist__23616);
arglist__23616 = cljs.core.next(arglist__23616);
var c = cljs.core.first(arglist__23616);
var ds = cljs.core.rest(arglist__23616);
return G__23614__delegate(a,b,c,ds);
});
G__23614.cljs$core$IFn$_invoke$arity$variadic = G__23614__delegate;
return G__23614;
})()
;
G__23613 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return G__23613__1.call(this,a);
case 2:
return G__23613__2.call(this,a,b);
case 3:
return G__23613__3.call(this,a,b,c);
default:
var G__23617 = null;
if (arguments.length > 3) {
var G__23618__i = 0, G__23618__a = new Array(arguments.length -  3);
while (G__23618__i < G__23618__a.length) {G__23618__a[G__23618__i] = arguments[G__23618__i + 3]; ++G__23618__i;}
G__23617 = new cljs.core.IndexedSeq(G__23618__a,0);
}
return G__23613__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__23617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23613.cljs$lang$maxFixedArity = 3;
G__23613.cljs$lang$applyTo = G__23613__4.cljs$lang$applyTo;
G__23613.cljs$core$IFn$_invoke$arity$1 = G__23613__1;
G__23613.cljs$core$IFn$_invoke$arity$2 = G__23613__2;
G__23613.cljs$core$IFn$_invoke$arity$3 = G__23613__3;
G__23613.cljs$core$IFn$_invoke$arity$variadic = G__23613__4.cljs$core$IFn$_invoke$arity$variadic;
return G__23613;
})()
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = (function (f,x,y){
return (function() {
var G__23619 = null;
var G__23619__2 = (function (a,b){
var G__23599 = (((a == null))?x:a);
var G__23600 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__23599,G__23600) : f.call(null,G__23599,G__23600));
});
var G__23619__3 = (function (a,b,c){
var G__23601 = (((a == null))?x:a);
var G__23602 = (((b == null))?y:b);
var G__23603 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__23601,G__23602,G__23603) : f.call(null,G__23601,G__23602,G__23603));
});
var G__23619__4 = (function() { 
var G__23620__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__23620 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__23621__i = 0, G__23621__a = new Array(arguments.length -  3);
while (G__23621__i < G__23621__a.length) {G__23621__a[G__23621__i] = arguments[G__23621__i + 3]; ++G__23621__i;}
  ds = new cljs.core.IndexedSeq(G__23621__a,0);
} 
return G__23620__delegate.call(this,a,b,c,ds);};
G__23620.cljs$lang$maxFixedArity = 3;
G__23620.cljs$lang$applyTo = (function (arglist__23622){
var a = cljs.core.first(arglist__23622);
arglist__23622 = cljs.core.next(arglist__23622);
var b = cljs.core.first(arglist__23622);
arglist__23622 = cljs.core.next(arglist__23622);
var c = cljs.core.first(arglist__23622);
var ds = cljs.core.rest(arglist__23622);
return G__23620__delegate(a,b,c,ds);
});
G__23620.cljs$core$IFn$_invoke$arity$variadic = G__23620__delegate;
return G__23620;
})()
;
G__23619 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__23619__2.call(this,a,b);
case 3:
return G__23619__3.call(this,a,b,c);
default:
var G__23623 = null;
if (arguments.length > 3) {
var G__23624__i = 0, G__23624__a = new Array(arguments.length -  3);
while (G__23624__i < G__23624__a.length) {G__23624__a[G__23624__i] = arguments[G__23624__i + 3]; ++G__23624__i;}
G__23623 = new cljs.core.IndexedSeq(G__23624__a,0);
}
return G__23619__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__23623);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23619.cljs$lang$maxFixedArity = 3;
G__23619.cljs$lang$applyTo = G__23619__4.cljs$lang$applyTo;
G__23619.cljs$core$IFn$_invoke$arity$2 = G__23619__2;
G__23619.cljs$core$IFn$_invoke$arity$3 = G__23619__3;
G__23619.cljs$core$IFn$_invoke$arity$variadic = G__23619__4.cljs$core$IFn$_invoke$arity$variadic;
return G__23619;
})()
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,z){
return (function() {
var G__23625 = null;
var G__23625__2 = (function (a,b){
var G__23604 = (((a == null))?x:a);
var G__23605 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__23604,G__23605) : f.call(null,G__23604,G__23605));
});
var G__23625__3 = (function (a,b,c){
var G__23606 = (((a == null))?x:a);
var G__23607 = (((b == null))?y:b);
var G__23608 = (((c == null))?z:c);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__23606,G__23607,G__23608) : f.call(null,G__23606,G__23607,G__23608));
});
var G__23625__4 = (function() { 
var G__23626__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__23626 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__23627__i = 0, G__23627__a = new Array(arguments.length -  3);
while (G__23627__i < G__23627__a.length) {G__23627__a[G__23627__i] = arguments[G__23627__i + 3]; ++G__23627__i;}
  ds = new cljs.core.IndexedSeq(G__23627__a,0);
} 
return G__23626__delegate.call(this,a,b,c,ds);};
G__23626.cljs$lang$maxFixedArity = 3;
G__23626.cljs$lang$applyTo = (function (arglist__23628){
var a = cljs.core.first(arglist__23628);
arglist__23628 = cljs.core.next(arglist__23628);
var b = cljs.core.first(arglist__23628);
arglist__23628 = cljs.core.next(arglist__23628);
var c = cljs.core.first(arglist__23628);
var ds = cljs.core.rest(arglist__23628);
return G__23626__delegate(a,b,c,ds);
});
G__23626.cljs$core$IFn$_invoke$arity$variadic = G__23626__delegate;
return G__23626;
})()
;
G__23625 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__23625__2.call(this,a,b);
case 3:
return G__23625__3.call(this,a,b,c);
default:
var G__23629 = null;
if (arguments.length > 3) {
var G__23630__i = 0, G__23630__a = new Array(arguments.length -  3);
while (G__23630__i < G__23630__a.length) {G__23630__a[G__23630__i] = arguments[G__23630__i + 3]; ++G__23630__i;}
G__23629 = new cljs.core.IndexedSeq(G__23630__a,0);
}
return G__23625__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__23629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23625.cljs$lang$maxFixedArity = 3;
G__23625.cljs$lang$applyTo = G__23625__4.cljs$lang$applyTo;
G__23625.cljs$core$IFn$_invoke$arity$2 = G__23625__2;
G__23625.cljs$core$IFn$_invoke$arity$3 = G__23625__3;
G__23625.cljs$core$IFn$_invoke$arity$variadic = G__23625__4.cljs$core$IFn$_invoke$arity$variadic;
return G__23625;
})()
});

cljs.core.fnil.cljs$lang$maxFixedArity = 4;

/**
 * Returns a lazy sequence consisting of the result of applying f to 0
 *   and the first item of coll, followed by applying f to 1 and the second
 *   item in coll, etc, until coll is exhausted. Thus function f should
 *   accept 2 arguments, index and item. Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.map_indexed = (function cljs$core$map_indexed(var_args){
var args23631 = [];
var len__7651__auto___23662 = arguments.length;
var i__7652__auto___23663 = (0);
while(true){
if((i__7652__auto___23663 < len__7651__auto___23662)){
args23631.push((arguments[i__7652__auto___23663]));

var G__23664 = (i__7652__auto___23663 + (1));
i__7652__auto___23663 = G__23664;
continue;
} else {
}
break;
}

var G__23633 = args23631.length;
switch (G__23633) {
case 1:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23631.length)].join('')));

}
});

cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var i = (cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1((-1)) : cljs.core.volatile_BANG_.call(null,(-1)));
return ((function (i){
return (function() {
var G__23666 = null;
var G__23666__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__23666__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__23666__2 = (function (result,input){
var G__23634 = result;
var G__23635 = (function (){var G__23636 = cljs.core._vreset_BANG_(i,(cljs.core._deref(i) + (1)));
var G__23637 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__23636,G__23637) : f.call(null,G__23636,G__23637));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__23634,G__23635) : rf.call(null,G__23634,G__23635));
});
G__23666 = function(result,input){
switch(arguments.length){
case 0:
return G__23666__0.call(this);
case 1:
return G__23666__1.call(this,result);
case 2:
return G__23666__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23666.cljs$core$IFn$_invoke$arity$0 = G__23666__0;
G__23666.cljs$core$IFn$_invoke$arity$1 = G__23666__1;
G__23666.cljs$core$IFn$_invoke$arity$2 = G__23666__2;
return G__23666;
})()
;})(i))
});
});

cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var mapi = (function cljs$core$mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll__$1);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__7461__auto___23667 = size;
var i_23668 = (0);
while(true){
if((i_23668 < n__7461__auto___23667)){
cljs.core.chunk_append(b,(function (){var G__23658 = (idx + i_23668);
var G__23659 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_23668);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__23658,G__23659) : f.call(null,G__23658,G__23659));
})());

var G__23669 = (i_23668 + (1));
i_23668 = G__23669;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$mapi((idx + size),cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__23660 = idx;
var G__23661 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__23660,G__23661) : f.call(null,G__23660,G__23661));
})(),cljs$core$mapi((idx + (1)),cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
return mapi((0),coll);
});

cljs.core.map_indexed.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence of the non-nil results of (f item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a transducer when no collection is provided.
 */
cljs.core.keep = (function cljs$core$keep(var_args){
var args23670 = [];
var len__7651__auto___23675 = arguments.length;
var i__7652__auto___23676 = (0);
while(true){
if((i__7652__auto___23676 < len__7651__auto___23675)){
args23670.push((arguments[i__7652__auto___23676]));

var G__23677 = (i__7652__auto___23676 + (1));
i__7652__auto___23676 = G__23677;
continue;
} else {
}
break;
}

var G__23672 = args23670.length;
switch (G__23672) {
case 1:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23670.length)].join('')));

}
});

cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__23679 = null;
var G__23679__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__23679__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__23679__2 = (function (result,input){
var v = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
G__23679 = function(result,input){
switch(arguments.length){
case 0:
return G__23679__0.call(this);
case 1:
return G__23679__1.call(this,result);
case 2:
return G__23679__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23679.cljs$core$IFn$_invoke$arity$0 = G__23679__0;
G__23679.cljs$core$IFn$_invoke$arity$1 = G__23679__1;
G__23679.cljs$core$IFn$_invoke$arity$2 = G__23679__2;
return G__23679;
})()
});
});

cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__7461__auto___23680 = size;
var i_23681 = (0);
while(true){
if((i_23681 < n__7461__auto___23680)){
var x_23682 = (function (){var G__23673 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_23681);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__23673) : f.call(null,G__23673));
})();
if((x_23682 == null)){
} else {
cljs.core.chunk_append(b,x_23682);
}

var G__23683 = (i_23681 + (1));
i_23681 = G__23683;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__23674 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__23674) : f.call(null,G__23674));
})();
if((x == null)){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});

cljs.core.keep.cljs$lang$maxFixedArity = 2;


/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {cljs.core.IAtom}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition1$ = 16386;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
})
cljs.core.Atom.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
});

cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__23684 = cljs.core.seq(self__.watches);
var chunk__23685 = null;
var count__23686 = (0);
var i__23687 = (0);
while(true){
if((i__23687 < count__23686)){
var vec__23688 = chunk__23685.cljs$core$IIndexed$_nth$arity$2(null,i__23687);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23688,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23688,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));

var G__23694 = seq__23684;
var G__23695 = chunk__23685;
var G__23696 = count__23686;
var G__23697 = (i__23687 + (1));
seq__23684 = G__23694;
chunk__23685 = G__23695;
count__23686 = G__23696;
i__23687 = G__23697;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__23684);
if(temp__4657__auto__){
var seq__23684__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__23684__$1)){
var c__7357__auto__ = cljs.core.chunk_first(seq__23684__$1);
var G__23698 = cljs.core.chunk_rest(seq__23684__$1);
var G__23699 = c__7357__auto__;
var G__23700 = cljs.core.count(c__7357__auto__);
var G__23701 = (0);
seq__23684 = G__23698;
chunk__23685 = G__23699;
count__23686 = G__23700;
i__23687 = G__23701;
continue;
} else {
var vec__23691 = cljs.core.first(seq__23684__$1);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23691,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23691,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));

var G__23702 = cljs.core.next(seq__23684__$1);
var G__23703 = null;
var G__23704 = (0);
var G__23705 = (0);
seq__23684 = G__23702;
chunk__23685 = G__23703;
count__23686 = G__23704;
i__23687 = G__23705;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f);

return this$__$1;
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key);
});

cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return goog.getUid(this$__$1);
});

cljs.core.Atom.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$state,cljs.core.cst$sym$meta,cljs.core.cst$sym$validator,cljs.core.cst$sym$watches], null);
});

cljs.core.Atom.cljs$lang$type = true;

cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";

cljs.core.Atom.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/Atom");
});

cljs.core.__GT_Atom = (function cljs$core$__GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
 * Creates and returns an Atom with an initial value of x and zero or
 *   more options (in any order):
 * 
 *   :meta metadata-map
 * 
 *   :validator validate-fn
 * 
 *   If metadata-map is supplied, it will be come the metadata on the
 *   atom. validate-fn must be nil or a side-effect-free fn of one
 *   argument, which will be passed the intended new state on any state
 *   change. If the new state is unacceptable, the validate-fn should
 *   return false or throw an Error.  If either of these error conditions
 *   occur, then the value of the atom will not change.
 */
cljs.core.atom = (function cljs$core$atom(var_args){
var args23706 = [];
var len__7651__auto___23714 = arguments.length;
var i__7652__auto___23715 = (0);
while(true){
if((i__7652__auto___23715 < len__7651__auto___23714)){
args23706.push((arguments[i__7652__auto___23715]));

var G__23716 = (i__7652__auto___23715 + (1));
i__7652__auto___23715 = G__23716;
continue;
} else {
}
break;
}

var G__23710 = args23706.length;
switch (G__23710) {
case 1:
return cljs.core.atom.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23706.slice((1)),(0),null));
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7670__auto__);

}
});

cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.Atom(x,null,null,null));
});

cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = (function (x,p__23711){
var map__23712 = p__23711;
var map__23712__$1 = ((((!((map__23712 == null)))?((((map__23712.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23712.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23712):map__23712);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23712__$1,cljs.core.cst$kw$meta);
var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23712__$1,cljs.core.cst$kw$validator);
return (new cljs.core.Atom(x,meta,validator,null));
});

cljs.core.atom.cljs$lang$applyTo = (function (seq23707){
var G__23708 = cljs.core.first(seq23707);
var seq23707__$1 = cljs.core.next(seq23707);
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(G__23708,seq23707__$1);
});

cljs.core.atom.cljs$lang$maxFixedArity = (1);

/**
 * Sets the value of atom to newval without regard for the
 *   current value. Returns new-value.
 */
cljs.core.reset_BANG_ = (function cljs$core$reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null,new_value)))){
} else {
throw (new Error("Validator rejected reference state"));
}
}

var old_value = a.state;
a.state = new_value;

if((a.watches == null)){
} else {
cljs.core._notify_watches(a,old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_(a,new_value);
}
});
/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.  Returns
 *   the value that was swapped in.
 */
cljs.core.swap_BANG_ = (function cljs$core$swap_BANG_(var_args){
var args23718 = [];
var len__7651__auto___23732 = arguments.length;
var i__7652__auto___23733 = (0);
while(true){
if((i__7652__auto___23733 < len__7651__auto___23732)){
args23718.push((arguments[i__7652__auto___23733]));

var G__23734 = (i__7652__auto___23733 + (1));
i__7652__auto___23733 = G__23734;
continue;
} else {
}
break;
}

var G__23725 = args23718.length;
switch (G__23725) {
case 2:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23718.slice((4)),(0),null));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7670__auto__);

}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__23726 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__23726) : f.call(null,G__23726));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__23727 = a.state;
var G__23728 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__23727,G__23728) : f.call(null,G__23727,G__23728));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__23729 = a.state;
var G__23730 = x;
var G__23731 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__23729,G__23730,G__23731) : f.call(null,G__23729,G__23730,G__23731));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more);
}
});

cljs.core.swap_BANG_.cljs$lang$applyTo = (function (seq23719){
var G__23720 = cljs.core.first(seq23719);
var seq23719__$1 = cljs.core.next(seq23719);
var G__23721 = cljs.core.first(seq23719__$1);
var seq23719__$2 = cljs.core.next(seq23719__$1);
var G__23722 = cljs.core.first(seq23719__$2);
var seq23719__$3 = cljs.core.next(seq23719__$2);
var G__23723 = cljs.core.first(seq23719__$3);
var seq23719__$4 = cljs.core.next(seq23719__$3);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__23720,G__23721,G__23722,G__23723,seq23719__$4);
});

cljs.core.swap_BANG_.cljs$lang$maxFixedArity = (4);

/**
 * Atomically sets the value of atom to newval if and only if the
 *   current value of the atom is equal to oldval. Returns true if
 *   set happened, else false.
 */
cljs.core.compare_and_set_BANG_ = (function cljs$core$compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null),oldval)){
cljs.core.reset_BANG_(a,newval);

return true;
} else {
return false;
}
});
/**
 * Sets the validator-fn for an atom. validator-fn must be nil or a
 *   side-effect-free fn of one argument, which will be passed the intended
 *   new state on any state change. If the new state is unacceptable, the
 *   validator-fn should return false or throw an Error. If the current state
 *   is not acceptable to the new validator, an Error will be thrown and the
 *   validator will not be changed.
 */
cljs.core.set_validator_BANG_ = (function cljs$core$set_validator_BANG_(iref,val){
return iref.validator = val;
});
/**
 * Gets the validator-fn for a var/ref/agent/atom.
 */
cljs.core.get_validator = (function cljs$core$get_validator(iref){
return iref.validator;
});

/**
* @constructor
 * @implements {cljs.core.IVolatile}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Volatile.prototype.cljs$core$IVolatile$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function (_,new_state){
var self__ = this;
var ___$1 = this;
return self__.state = new_state;
});

cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Volatile.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Volatile.cljs$lang$type = true;

cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";

cljs.core.Volatile.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/Volatile");
});

cljs.core.__GT_Volatile = (function cljs$core$__GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
 * Creates and returns a Volatile with an initial value of val.
 */
cljs.core.volatile_BANG_ = (function cljs$core$volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
 * Returns true if x is a volatile.
 */
cljs.core.volatile_QMARK_ = (function cljs$core$volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
 * Sets the value of volatile to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.vreset_BANG_ = (function cljs$core$vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_(vol,newval);
});
/**
 * Returns a lazy sequence of the non-nil results of (f index item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a stateful transducer when no collection is
 *   provided.
 */
cljs.core.keep_indexed = (function cljs$core$keep_indexed(var_args){
var args23736 = [];
var len__7651__auto___23767 = arguments.length;
var i__7652__auto___23768 = (0);
while(true){
if((i__7652__auto___23768 < len__7651__auto___23767)){
args23736.push((arguments[i__7652__auto___23768]));

var G__23769 = (i__7652__auto___23768 + (1));
i__7652__auto___23768 = G__23769;
continue;
} else {
}
break;
}

var G__23738 = args23736.length;
switch (G__23738) {
case 1:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23736.length)].join('')));

}
});

cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__23771 = null;
var G__23771__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__23771__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__23771__2 = (function (result,input){
var i = cljs.core._vreset_BANG_(ia,(cljs.core._deref(ia) + (1)));
var v = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(i,input) : f.call(null,i,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
G__23771 = function(result,input){
switch(arguments.length){
case 0:
return G__23771__0.call(this);
case 1:
return G__23771__1.call(this,result);
case 2:
return G__23771__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23771.cljs$core$IFn$_invoke$arity$0 = G__23771__0;
G__23771.cljs$core$IFn$_invoke$arity$1 = G__23771__1;
G__23771.cljs$core$IFn$_invoke$arity$2 = G__23771__2;
return G__23771;
})()
;})(ia))
});
});

cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var keepi = (function cljs$core$keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll__$1);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__7461__auto___23772 = size;
var i_23773 = (0);
while(true){
if((i_23773 < n__7461__auto___23772)){
var x_23774 = (function (){var G__23763 = (idx + i_23773);
var G__23764 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_23773);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__23763,G__23764) : f.call(null,G__23763,G__23764));
})();
if((x_23774 == null)){
} else {
cljs.core.chunk_append(b,x_23774);
}

var G__23775 = (i_23773 + (1));
i_23773 = G__23775;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$keepi((idx + size),cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__23765 = idx;
var G__23766 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__23765,G__23766) : f.call(null,G__23765,G__23766));
})();
if((x == null)){
return cljs$core$keepi((idx + (1)),cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs$core$keepi((idx + (1)),cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi((0),coll);
});

cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2;

/**
 * Takes a set of predicates and returns a function f that returns true if all of its
 *   composing predicates return a logical true value against all of its arguments, else it returns
 *   false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical false result against the original predicates.
 */
cljs.core.every_pred = (function cljs$core$every_pred(var_args){
var args23782 = [];
var len__7651__auto___23789 = arguments.length;
var i__7652__auto___23790 = (0);
while(true){
if((i__7652__auto___23790 < len__7651__auto___23789)){
args23782.push((arguments[i__7652__auto___23790]));

var G__23791 = (i__7652__auto___23790 + (1));
i__7652__auto___23790 = G__23791;
continue;
} else {
}
break;
}

var G__23788 = args23782.length;
switch (G__23788) {
case 1:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23782.slice((3)),(0),null));
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7670__auto__);

}
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$ep1 = null;
var cljs$core$ep1__0 = (function (){
return true;
});
var cljs$core$ep1__1 = (function (x){
return cljs.core.boolean$((p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x)));
});
var cljs$core$ep1__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__6531__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__6531__auto__)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
} else {
return and__6531__auto__;
}
})());
});
var cljs$core$ep1__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__6531__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__6531__auto__)){
var and__6531__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(and__6531__auto____$1)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
} else {
return and__6531__auto____$1;
}
} else {
return and__6531__auto__;
}
})());
});
var cljs$core$ep1__4 = (function() { 
var G__23793__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__6531__auto__ = cljs$core$ep1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__6531__auto__)){
return cljs.core.every_QMARK_(p,args);
} else {
return and__6531__auto__;
}
})());
};
var G__23793 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__23794__i = 0, G__23794__a = new Array(arguments.length -  3);
while (G__23794__i < G__23794__a.length) {G__23794__a[G__23794__i] = arguments[G__23794__i + 3]; ++G__23794__i;}
  args = new cljs.core.IndexedSeq(G__23794__a,0);
} 
return G__23793__delegate.call(this,x,y,z,args);};
G__23793.cljs$lang$maxFixedArity = 3;
G__23793.cljs$lang$applyTo = (function (arglist__23795){
var x = cljs.core.first(arglist__23795);
arglist__23795 = cljs.core.next(arglist__23795);
var y = cljs.core.first(arglist__23795);
arglist__23795 = cljs.core.next(arglist__23795);
var z = cljs.core.first(arglist__23795);
var args = cljs.core.rest(arglist__23795);
return G__23793__delegate(x,y,z,args);
});
G__23793.cljs$core$IFn$_invoke$arity$variadic = G__23793__delegate;
return G__23793;
})()
;
cljs$core$ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep1__0.call(this);
case 1:
return cljs$core$ep1__1.call(this,x);
case 2:
return cljs$core$ep1__2.call(this,x,y);
case 3:
return cljs$core$ep1__3.call(this,x,y,z);
default:
var G__23796 = null;
if (arguments.length > 3) {
var G__23797__i = 0, G__23797__a = new Array(arguments.length -  3);
while (G__23797__i < G__23797__a.length) {G__23797__a[G__23797__i] = arguments[G__23797__i + 3]; ++G__23797__i;}
G__23796 = new cljs.core.IndexedSeq(G__23797__a,0);
}
return cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__23796);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep1.cljs$lang$maxFixedArity = 3;
cljs$core$ep1.cljs$lang$applyTo = cljs$core$ep1__4.cljs$lang$applyTo;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep1__0;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep1__1;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep1__2;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep1__3;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep1;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$ep2 = null;
var cljs$core$ep2__0 = (function (){
return true;
});
var cljs$core$ep2__1 = (function (x){
return cljs.core.boolean$((function (){var and__6531__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__6531__auto__)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
} else {
return and__6531__auto__;
}
})());
});
var cljs$core$ep2__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__6531__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__6531__auto__)){
var and__6531__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__6531__auto____$1)){
var and__6531__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__6531__auto____$2)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
} else {
return and__6531__auto____$2;
}
} else {
return and__6531__auto____$1;
}
} else {
return and__6531__auto__;
}
})());
});
var cljs$core$ep2__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__6531__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__6531__auto__)){
var and__6531__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__6531__auto____$1)){
var and__6531__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__6531__auto____$2)){
var and__6531__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__6531__auto____$3)){
var and__6531__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__6531__auto____$4)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
} else {
return and__6531__auto____$4;
}
} else {
return and__6531__auto____$3;
}
} else {
return and__6531__auto____$2;
}
} else {
return and__6531__auto____$1;
}
} else {
return and__6531__auto__;
}
})());
});
var cljs$core$ep2__4 = (function() { 
var G__23798__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__6531__auto__ = cljs$core$ep2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__6531__auto__)){
return cljs.core.every_QMARK_(((function (and__6531__auto__){
return (function (p1__23776_SHARP_){
var and__6531__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__23776_SHARP_) : p1.call(null,p1__23776_SHARP_));
if(cljs.core.truth_(and__6531__auto____$1)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__23776_SHARP_) : p2.call(null,p1__23776_SHARP_));
} else {
return and__6531__auto____$1;
}
});})(and__6531__auto__))
,args);
} else {
return and__6531__auto__;
}
})());
};
var G__23798 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__23799__i = 0, G__23799__a = new Array(arguments.length -  3);
while (G__23799__i < G__23799__a.length) {G__23799__a[G__23799__i] = arguments[G__23799__i + 3]; ++G__23799__i;}
  args = new cljs.core.IndexedSeq(G__23799__a,0);
} 
return G__23798__delegate.call(this,x,y,z,args);};
G__23798.cljs$lang$maxFixedArity = 3;
G__23798.cljs$lang$applyTo = (function (arglist__23800){
var x = cljs.core.first(arglist__23800);
arglist__23800 = cljs.core.next(arglist__23800);
var y = cljs.core.first(arglist__23800);
arglist__23800 = cljs.core.next(arglist__23800);
var z = cljs.core.first(arglist__23800);
var args = cljs.core.rest(arglist__23800);
return G__23798__delegate(x,y,z,args);
});
G__23798.cljs$core$IFn$_invoke$arity$variadic = G__23798__delegate;
return G__23798;
})()
;
cljs$core$ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep2__0.call(this);
case 1:
return cljs$core$ep2__1.call(this,x);
case 2:
return cljs$core$ep2__2.call(this,x,y);
case 3:
return cljs$core$ep2__3.call(this,x,y,z);
default:
var G__23801 = null;
if (arguments.length > 3) {
var G__23802__i = 0, G__23802__a = new Array(arguments.length -  3);
while (G__23802__i < G__23802__a.length) {G__23802__a[G__23802__i] = arguments[G__23802__i + 3]; ++G__23802__i;}
G__23801 = new cljs.core.IndexedSeq(G__23802__a,0);
}
return cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__23801);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep2.cljs$lang$maxFixedArity = 3;
cljs$core$ep2.cljs$lang$applyTo = cljs$core$ep2__4.cljs$lang$applyTo;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep2__0;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep2__1;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep2__2;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep2__3;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep2;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$ep3 = null;
var cljs$core$ep3__0 = (function (){
return true;
});
var cljs$core$ep3__1 = (function (x){
return cljs.core.boolean$((function (){var and__6531__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__6531__auto__)){
var and__6531__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__6531__auto____$1)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
} else {
return and__6531__auto____$1;
}
} else {
return and__6531__auto__;
}
})());
});
var cljs$core$ep3__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__6531__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__6531__auto__)){
var and__6531__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__6531__auto____$1)){
var and__6531__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__6531__auto____$2)){
var and__6531__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__6531__auto____$3)){
var and__6531__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__6531__auto____$4)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
} else {
return and__6531__auto____$4;
}
} else {
return and__6531__auto____$3;
}
} else {
return and__6531__auto____$2;
}
} else {
return and__6531__auto____$1;
}
} else {
return and__6531__auto__;
}
})());
});
var cljs$core$ep3__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__6531__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__6531__auto__)){
var and__6531__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__6531__auto____$1)){
var and__6531__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__6531__auto____$2)){
var and__6531__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__6531__auto____$3)){
var and__6531__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__6531__auto____$4)){
var and__6531__auto____$5 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(and__6531__auto____$5)){
var and__6531__auto____$6 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__6531__auto____$6)){
var and__6531__auto____$7 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(and__6531__auto____$7)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
} else {
return and__6531__auto____$7;
}
} else {
return and__6531__auto____$6;
}
} else {
return and__6531__auto____$5;
}
} else {
return and__6531__auto____$4;
}
} else {
return and__6531__auto____$3;
}
} else {
return and__6531__auto____$2;
}
} else {
return and__6531__auto____$1;
}
} else {
return and__6531__auto__;
}
})());
});
var cljs$core$ep3__4 = (function() { 
var G__23803__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__6531__auto__ = cljs$core$ep3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__6531__auto__)){
return cljs.core.every_QMARK_(((function (and__6531__auto__){
return (function (p1__23777_SHARP_){
var and__6531__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__23777_SHARP_) : p1.call(null,p1__23777_SHARP_));
if(cljs.core.truth_(and__6531__auto____$1)){
var and__6531__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__23777_SHARP_) : p2.call(null,p1__23777_SHARP_));
if(cljs.core.truth_(and__6531__auto____$2)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__23777_SHARP_) : p3.call(null,p1__23777_SHARP_));
} else {
return and__6531__auto____$2;
}
} else {
return and__6531__auto____$1;
}
});})(and__6531__auto__))
,args);
} else {
return and__6531__auto__;
}
})());
};
var G__23803 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__23804__i = 0, G__23804__a = new Array(arguments.length -  3);
while (G__23804__i < G__23804__a.length) {G__23804__a[G__23804__i] = arguments[G__23804__i + 3]; ++G__23804__i;}
  args = new cljs.core.IndexedSeq(G__23804__a,0);
} 
return G__23803__delegate.call(this,x,y,z,args);};
G__23803.cljs$lang$maxFixedArity = 3;
G__23803.cljs$lang$applyTo = (function (arglist__23805){
var x = cljs.core.first(arglist__23805);
arglist__23805 = cljs.core.next(arglist__23805);
var y = cljs.core.first(arglist__23805);
arglist__23805 = cljs.core.next(arglist__23805);
var z = cljs.core.first(arglist__23805);
var args = cljs.core.rest(arglist__23805);
return G__23803__delegate(x,y,z,args);
});
G__23803.cljs$core$IFn$_invoke$arity$variadic = G__23803__delegate;
return G__23803;
})()
;
cljs$core$ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep3__0.call(this);
case 1:
return cljs$core$ep3__1.call(this,x);
case 2:
return cljs$core$ep3__2.call(this,x,y);
case 3:
return cljs$core$ep3__3.call(this,x,y,z);
default:
var G__23806 = null;
if (arguments.length > 3) {
var G__23807__i = 0, G__23807__a = new Array(arguments.length -  3);
while (G__23807__i < G__23807__a.length) {G__23807__a[G__23807__i] = arguments[G__23807__i + 3]; ++G__23807__i;}
G__23806 = new cljs.core.IndexedSeq(G__23807__a,0);
}
return cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__23806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep3.cljs$lang$maxFixedArity = 3;
cljs$core$ep3.cljs$lang$applyTo = cljs$core$ep3__4.cljs$lang$applyTo;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep3__0;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep3__1;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep3__2;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep3__3;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep3;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$epn = null;
var cljs$core$epn__0 = (function (){
return true;
});
var cljs$core$epn__1 = (function (x){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__23778_SHARP_){
return (p1__23778_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23778_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__23778_SHARP_.call(null,x));
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__2 = (function (x,y){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__23779_SHARP_){
var and__6531__auto__ = (p1__23779_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23779_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__23779_SHARP_.call(null,x));
if(cljs.core.truth_(and__6531__auto__)){
return (p1__23779_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23779_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__23779_SHARP_.call(null,y));
} else {
return and__6531__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__23780_SHARP_){
var and__6531__auto__ = (p1__23780_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23780_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__23780_SHARP_.call(null,x));
if(cljs.core.truth_(and__6531__auto__)){
var and__6531__auto____$1 = (p1__23780_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23780_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__23780_SHARP_.call(null,y));
if(cljs.core.truth_(and__6531__auto____$1)){
return (p1__23780_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23780_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__23780_SHARP_.call(null,z));
} else {
return and__6531__auto____$1;
}
} else {
return and__6531__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__4 = (function() { 
var G__23808__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__6531__auto__ = cljs$core$epn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__6531__auto__)){
return cljs.core.every_QMARK_(((function (and__6531__auto__,ps__$1){
return (function (p1__23781_SHARP_){
return cljs.core.every_QMARK_(p1__23781_SHARP_,args);
});})(and__6531__auto__,ps__$1))
,ps__$1);
} else {
return and__6531__auto__;
}
})());
};
var G__23808 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__23809__i = 0, G__23809__a = new Array(arguments.length -  3);
while (G__23809__i < G__23809__a.length) {G__23809__a[G__23809__i] = arguments[G__23809__i + 3]; ++G__23809__i;}
  args = new cljs.core.IndexedSeq(G__23809__a,0);
} 
return G__23808__delegate.call(this,x,y,z,args);};
G__23808.cljs$lang$maxFixedArity = 3;
G__23808.cljs$lang$applyTo = (function (arglist__23810){
var x = cljs.core.first(arglist__23810);
arglist__23810 = cljs.core.next(arglist__23810);
var y = cljs.core.first(arglist__23810);
arglist__23810 = cljs.core.next(arglist__23810);
var z = cljs.core.first(arglist__23810);
var args = cljs.core.rest(arglist__23810);
return G__23808__delegate(x,y,z,args);
});
G__23808.cljs$core$IFn$_invoke$arity$variadic = G__23808__delegate;
return G__23808;
})()
;
cljs$core$epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$epn__0.call(this);
case 1:
return cljs$core$epn__1.call(this,x);
case 2:
return cljs$core$epn__2.call(this,x,y);
case 3:
return cljs$core$epn__3.call(this,x,y,z);
default:
var G__23811 = null;
if (arguments.length > 3) {
var G__23812__i = 0, G__23812__a = new Array(arguments.length -  3);
while (G__23812__i < G__23812__a.length) {G__23812__a[G__23812__i] = arguments[G__23812__i + 3]; ++G__23812__i;}
G__23811 = new cljs.core.IndexedSeq(G__23812__a,0);
}
return cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__23811);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$epn.cljs$lang$maxFixedArity = 3;
cljs$core$epn.cljs$lang$applyTo = cljs$core$epn__4.cljs$lang$applyTo;
cljs$core$epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$epn__0;
cljs$core$epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$epn__1;
cljs$core$epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$epn__2;
cljs$core$epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$epn__3;
cljs$core$epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$epn;
})()
;})(ps__$1))
});

cljs.core.every_pred.cljs$lang$applyTo = (function (seq23783){
var G__23784 = cljs.core.first(seq23783);
var seq23783__$1 = cljs.core.next(seq23783);
var G__23785 = cljs.core.first(seq23783__$1);
var seq23783__$2 = cljs.core.next(seq23783__$1);
var G__23786 = cljs.core.first(seq23783__$2);
var seq23783__$3 = cljs.core.next(seq23783__$2);
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(G__23784,G__23785,G__23786,seq23783__$3);
});

cljs.core.every_pred.cljs$lang$maxFixedArity = (3);

/**
 * Takes a set of predicates and returns a function f that returns the first logical true value
 *   returned by one of its composing predicates against any of its arguments, else it returns
 *   logical false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical true result against the original predicates.
 */
cljs.core.some_fn = (function cljs$core$some_fn(var_args){
var args23819 = [];
var len__7651__auto___23826 = arguments.length;
var i__7652__auto___23827 = (0);
while(true){
if((i__7652__auto___23827 < len__7651__auto___23826)){
args23819.push((arguments[i__7652__auto___23827]));

var G__23828 = (i__7652__auto___23827 + (1));
i__7652__auto___23827 = G__23828;
continue;
} else {
}
break;
}

var G__23825 = args23819.length;
switch (G__23825) {
case 1:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23819.slice((3)),(0),null));
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7670__auto__);

}
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$sp1 = null;
var cljs$core$sp1__0 = (function (){
return null;
});
var cljs$core$sp1__1 = (function (x){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
});
var cljs$core$sp1__2 = (function (x,y){
var or__6543__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
}
});
var cljs$core$sp1__3 = (function (x,y,z){
var or__6543__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
}
}
});
var cljs$core$sp1__4 = (function() { 
var G__23830__delegate = function (x,y,z,args){
var or__6543__auto__ = cljs$core$sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.some(p,args);
}
};
var G__23830 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__23831__i = 0, G__23831__a = new Array(arguments.length -  3);
while (G__23831__i < G__23831__a.length) {G__23831__a[G__23831__i] = arguments[G__23831__i + 3]; ++G__23831__i;}
  args = new cljs.core.IndexedSeq(G__23831__a,0);
} 
return G__23830__delegate.call(this,x,y,z,args);};
G__23830.cljs$lang$maxFixedArity = 3;
G__23830.cljs$lang$applyTo = (function (arglist__23832){
var x = cljs.core.first(arglist__23832);
arglist__23832 = cljs.core.next(arglist__23832);
var y = cljs.core.first(arglist__23832);
arglist__23832 = cljs.core.next(arglist__23832);
var z = cljs.core.first(arglist__23832);
var args = cljs.core.rest(arglist__23832);
return G__23830__delegate(x,y,z,args);
});
G__23830.cljs$core$IFn$_invoke$arity$variadic = G__23830__delegate;
return G__23830;
})()
;
cljs$core$sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp1__0.call(this);
case 1:
return cljs$core$sp1__1.call(this,x);
case 2:
return cljs$core$sp1__2.call(this,x,y);
case 3:
return cljs$core$sp1__3.call(this,x,y,z);
default:
var G__23833 = null;
if (arguments.length > 3) {
var G__23834__i = 0, G__23834__a = new Array(arguments.length -  3);
while (G__23834__i < G__23834__a.length) {G__23834__a[G__23834__i] = arguments[G__23834__i + 3]; ++G__23834__i;}
G__23833 = new cljs.core.IndexedSeq(G__23834__a,0);
}
return cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__23833);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp1.cljs$lang$maxFixedArity = 3;
cljs$core$sp1.cljs$lang$applyTo = cljs$core$sp1__4.cljs$lang$applyTo;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp1__0;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp1__1;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp1__2;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp1__3;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp1;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$sp2 = null;
var cljs$core$sp2__0 = (function (){
return null;
});
var cljs$core$sp2__1 = (function (x){
var or__6543__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
}
});
var cljs$core$sp2__2 = (function (x,y){
var or__6543__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
var or__6543__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__6543__auto____$2)){
return or__6543__auto____$2;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
}
}
}
});
var cljs$core$sp2__3 = (function (x,y,z){
var or__6543__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
var or__6543__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__6543__auto____$2)){
return or__6543__auto____$2;
} else {
var or__6543__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__6543__auto____$3)){
return or__6543__auto____$3;
} else {
var or__6543__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__6543__auto____$4)){
return or__6543__auto____$4;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
}
}
}
}
}
});
var cljs$core$sp2__4 = (function() { 
var G__23835__delegate = function (x,y,z,args){
var or__6543__auto__ = cljs$core$sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.some(((function (or__6543__auto__){
return (function (p1__23813_SHARP_){
var or__6543__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__23813_SHARP_) : p1.call(null,p1__23813_SHARP_));
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__23813_SHARP_) : p2.call(null,p1__23813_SHARP_));
}
});})(or__6543__auto__))
,args);
}
};
var G__23835 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__23836__i = 0, G__23836__a = new Array(arguments.length -  3);
while (G__23836__i < G__23836__a.length) {G__23836__a[G__23836__i] = arguments[G__23836__i + 3]; ++G__23836__i;}
  args = new cljs.core.IndexedSeq(G__23836__a,0);
} 
return G__23835__delegate.call(this,x,y,z,args);};
G__23835.cljs$lang$maxFixedArity = 3;
G__23835.cljs$lang$applyTo = (function (arglist__23837){
var x = cljs.core.first(arglist__23837);
arglist__23837 = cljs.core.next(arglist__23837);
var y = cljs.core.first(arglist__23837);
arglist__23837 = cljs.core.next(arglist__23837);
var z = cljs.core.first(arglist__23837);
var args = cljs.core.rest(arglist__23837);
return G__23835__delegate(x,y,z,args);
});
G__23835.cljs$core$IFn$_invoke$arity$variadic = G__23835__delegate;
return G__23835;
})()
;
cljs$core$sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp2__0.call(this);
case 1:
return cljs$core$sp2__1.call(this,x);
case 2:
return cljs$core$sp2__2.call(this,x,y);
case 3:
return cljs$core$sp2__3.call(this,x,y,z);
default:
var G__23838 = null;
if (arguments.length > 3) {
var G__23839__i = 0, G__23839__a = new Array(arguments.length -  3);
while (G__23839__i < G__23839__a.length) {G__23839__a[G__23839__i] = arguments[G__23839__i + 3]; ++G__23839__i;}
G__23838 = new cljs.core.IndexedSeq(G__23839__a,0);
}
return cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__23838);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp2.cljs$lang$maxFixedArity = 3;
cljs$core$sp2.cljs$lang$applyTo = cljs$core$sp2__4.cljs$lang$applyTo;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp2__0;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp2__1;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp2__2;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp2__3;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp2;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$sp3 = null;
var cljs$core$sp3__0 = (function (){
return null;
});
var cljs$core$sp3__1 = (function (x){
var or__6543__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
}
}
});
var cljs$core$sp3__2 = (function (x,y){
var or__6543__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
var or__6543__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__6543__auto____$2)){
return or__6543__auto____$2;
} else {
var or__6543__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__6543__auto____$3)){
return or__6543__auto____$3;
} else {
var or__6543__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__6543__auto____$4)){
return or__6543__auto____$4;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
}
}
}
}
}
});
var cljs$core$sp3__3 = (function (x,y,z){
var or__6543__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
var or__6543__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__6543__auto____$2)){
return or__6543__auto____$2;
} else {
var or__6543__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__6543__auto____$3)){
return or__6543__auto____$3;
} else {
var or__6543__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__6543__auto____$4)){
return or__6543__auto____$4;
} else {
var or__6543__auto____$5 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(or__6543__auto____$5)){
return or__6543__auto____$5;
} else {
var or__6543__auto____$6 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__6543__auto____$6)){
return or__6543__auto____$6;
} else {
var or__6543__auto____$7 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(or__6543__auto____$7)){
return or__6543__auto____$7;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
}
}
}
}
}
}
}
}
});
var cljs$core$sp3__4 = (function() { 
var G__23840__delegate = function (x,y,z,args){
var or__6543__auto__ = cljs$core$sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.some(((function (or__6543__auto__){
return (function (p1__23814_SHARP_){
var or__6543__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__23814_SHARP_) : p1.call(null,p1__23814_SHARP_));
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
var or__6543__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__23814_SHARP_) : p2.call(null,p1__23814_SHARP_));
if(cljs.core.truth_(or__6543__auto____$2)){
return or__6543__auto____$2;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__23814_SHARP_) : p3.call(null,p1__23814_SHARP_));
}
}
});})(or__6543__auto__))
,args);
}
};
var G__23840 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__23841__i = 0, G__23841__a = new Array(arguments.length -  3);
while (G__23841__i < G__23841__a.length) {G__23841__a[G__23841__i] = arguments[G__23841__i + 3]; ++G__23841__i;}
  args = new cljs.core.IndexedSeq(G__23841__a,0);
} 
return G__23840__delegate.call(this,x,y,z,args);};
G__23840.cljs$lang$maxFixedArity = 3;
G__23840.cljs$lang$applyTo = (function (arglist__23842){
var x = cljs.core.first(arglist__23842);
arglist__23842 = cljs.core.next(arglist__23842);
var y = cljs.core.first(arglist__23842);
arglist__23842 = cljs.core.next(arglist__23842);
var z = cljs.core.first(arglist__23842);
var args = cljs.core.rest(arglist__23842);
return G__23840__delegate(x,y,z,args);
});
G__23840.cljs$core$IFn$_invoke$arity$variadic = G__23840__delegate;
return G__23840;
})()
;
cljs$core$sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp3__0.call(this);
case 1:
return cljs$core$sp3__1.call(this,x);
case 2:
return cljs$core$sp3__2.call(this,x,y);
case 3:
return cljs$core$sp3__3.call(this,x,y,z);
default:
var G__23843 = null;
if (arguments.length > 3) {
var G__23844__i = 0, G__23844__a = new Array(arguments.length -  3);
while (G__23844__i < G__23844__a.length) {G__23844__a[G__23844__i] = arguments[G__23844__i + 3]; ++G__23844__i;}
G__23843 = new cljs.core.IndexedSeq(G__23844__a,0);
}
return cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__23843);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp3.cljs$lang$maxFixedArity = 3;
cljs$core$sp3.cljs$lang$applyTo = cljs$core$sp3__4.cljs$lang$applyTo;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp3__0;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp3__1;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp3__2;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp3__3;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp3;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$spn = null;
var cljs$core$spn__0 = (function (){
return null;
});
var cljs$core$spn__1 = (function (x){
return cljs.core.some(((function (ps__$1){
return (function (p1__23815_SHARP_){
return (p1__23815_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23815_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__23815_SHARP_.call(null,x));
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__2 = (function (x,y){
return cljs.core.some(((function (ps__$1){
return (function (p1__23816_SHARP_){
var or__6543__auto__ = (p1__23816_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23816_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__23816_SHARP_.call(null,x));
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return (p1__23816_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23816_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__23816_SHARP_.call(null,y));
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__3 = (function (x,y,z){
return cljs.core.some(((function (ps__$1){
return (function (p1__23817_SHARP_){
var or__6543__auto__ = (p1__23817_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23817_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__23817_SHARP_.call(null,x));
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = (p1__23817_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23817_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__23817_SHARP_.call(null,y));
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
return (p1__23817_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23817_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__23817_SHARP_.call(null,z));
}
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__4 = (function() { 
var G__23845__delegate = function (x,y,z,args){
var or__6543__auto__ = cljs$core$spn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.some(((function (or__6543__auto__,ps__$1){
return (function (p1__23818_SHARP_){
return cljs.core.some(p1__23818_SHARP_,args);
});})(or__6543__auto__,ps__$1))
,ps__$1);
}
};
var G__23845 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__23846__i = 0, G__23846__a = new Array(arguments.length -  3);
while (G__23846__i < G__23846__a.length) {G__23846__a[G__23846__i] = arguments[G__23846__i + 3]; ++G__23846__i;}
  args = new cljs.core.IndexedSeq(G__23846__a,0);
} 
return G__23845__delegate.call(this,x,y,z,args);};
G__23845.cljs$lang$maxFixedArity = 3;
G__23845.cljs$lang$applyTo = (function (arglist__23847){
var x = cljs.core.first(arglist__23847);
arglist__23847 = cljs.core.next(arglist__23847);
var y = cljs.core.first(arglist__23847);
arglist__23847 = cljs.core.next(arglist__23847);
var z = cljs.core.first(arglist__23847);
var args = cljs.core.rest(arglist__23847);
return G__23845__delegate(x,y,z,args);
});
G__23845.cljs$core$IFn$_invoke$arity$variadic = G__23845__delegate;
return G__23845;
})()
;
cljs$core$spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$spn__0.call(this);
case 1:
return cljs$core$spn__1.call(this,x);
case 2:
return cljs$core$spn__2.call(this,x,y);
case 3:
return cljs$core$spn__3.call(this,x,y,z);
default:
var G__23848 = null;
if (arguments.length > 3) {
var G__23849__i = 0, G__23849__a = new Array(arguments.length -  3);
while (G__23849__i < G__23849__a.length) {G__23849__a[G__23849__i] = arguments[G__23849__i + 3]; ++G__23849__i;}
G__23848 = new cljs.core.IndexedSeq(G__23849__a,0);
}
return cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__23848);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$spn.cljs$lang$maxFixedArity = 3;
cljs$core$spn.cljs$lang$applyTo = cljs$core$spn__4.cljs$lang$applyTo;
cljs$core$spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$spn__0;
cljs$core$spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$spn__1;
cljs$core$spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$spn__2;
cljs$core$spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$spn__3;
cljs$core$spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$spn;
})()
;})(ps__$1))
});

cljs.core.some_fn.cljs$lang$applyTo = (function (seq23820){
var G__23821 = cljs.core.first(seq23820);
var seq23820__$1 = cljs.core.next(seq23820);
var G__23822 = cljs.core.first(seq23820__$1);
var seq23820__$2 = cljs.core.next(seq23820__$1);
var G__23823 = cljs.core.first(seq23820__$2);
var seq23820__$3 = cljs.core.next(seq23820__$2);
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(G__23821,G__23822,G__23823,seq23820__$3);
});

cljs.core.some_fn.cljs$lang$maxFixedArity = (3);

/**
 * Returns a lazy sequence consisting of the result of applying f to
 *   the set of first items of each coll, followed by applying f to the
 *   set of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments. Returns a transducer when
 *   no collection is provided.
 */
cljs.core.map = (function cljs$core$map(var_args){
var args23851 = [];
var len__7651__auto___23871 = arguments.length;
var i__7652__auto___23872 = (0);
while(true){
if((i__7652__auto___23872 < len__7651__auto___23871)){
args23851.push((arguments[i__7652__auto___23872]));

var G__23873 = (i__7652__auto___23872 + (1));
i__7652__auto___23872 = G__23873;
continue;
} else {
}
break;
}

var G__23858 = args23851.length;
switch (G__23858) {
case 1:
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.map.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23851.slice((4)),(0),null));
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7670__auto__);

}
});

cljs.core.map.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__23875 = null;
var G__23875__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__23875__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__23875__2 = (function (result,input){
var G__23859 = result;
var G__23860 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__23859,G__23860) : rf.call(null,G__23859,G__23860));
});
var G__23875__3 = (function() { 
var G__23876__delegate = function (result,input,inputs){
var G__23861 = result;
var G__23862 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__23861,G__23862) : rf.call(null,G__23861,G__23862));
};
var G__23876 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__23877__i = 0, G__23877__a = new Array(arguments.length -  2);
while (G__23877__i < G__23877__a.length) {G__23877__a[G__23877__i] = arguments[G__23877__i + 2]; ++G__23877__i;}
  inputs = new cljs.core.IndexedSeq(G__23877__a,0);
} 
return G__23876__delegate.call(this,result,input,inputs);};
G__23876.cljs$lang$maxFixedArity = 2;
G__23876.cljs$lang$applyTo = (function (arglist__23878){
var result = cljs.core.first(arglist__23878);
arglist__23878 = cljs.core.next(arglist__23878);
var input = cljs.core.first(arglist__23878);
var inputs = cljs.core.rest(arglist__23878);
return G__23876__delegate(result,input,inputs);
});
G__23876.cljs$core$IFn$_invoke$arity$variadic = G__23876__delegate;
return G__23876;
})()
;
G__23875 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return G__23875__0.call(this);
case 1:
return G__23875__1.call(this,result);
case 2:
return G__23875__2.call(this,result,input);
default:
var G__23879 = null;
if (arguments.length > 2) {
var G__23880__i = 0, G__23880__a = new Array(arguments.length -  2);
while (G__23880__i < G__23880__a.length) {G__23880__a[G__23880__i] = arguments[G__23880__i + 2]; ++G__23880__i;}
G__23879 = new cljs.core.IndexedSeq(G__23880__a,0);
}
return G__23875__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__23879);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23875.cljs$lang$maxFixedArity = 2;
G__23875.cljs$lang$applyTo = G__23875__3.cljs$lang$applyTo;
G__23875.cljs$core$IFn$_invoke$arity$0 = G__23875__0;
G__23875.cljs$core$IFn$_invoke$arity$1 = G__23875__1;
G__23875.cljs$core$IFn$_invoke$arity$2 = G__23875__2;
G__23875.cljs$core$IFn$_invoke$arity$variadic = G__23875__3.cljs$core$IFn$_invoke$arity$variadic;
return G__23875;
})()
});
});

cljs.core.map.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__7461__auto___23881 = size;
var i_23882 = (0);
while(true){
if((i_23882 < n__7461__auto___23881)){
cljs.core.chunk_append(b,(function (){var G__23863 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_23882);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__23863) : f.call(null,G__23863));
})());

var G__23883 = (i_23882 + (1));
i_23882 = G__23883;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__23864 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__23864) : f.call(null,G__23864));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons((function (){var G__23865 = cljs.core.first(s1);
var G__23866 = cljs.core.first(s2);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__23865,G__23866) : f.call(null,G__23865,G__23866));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
var s3 = cljs.core.seq(c3);
if((s1) && (s2) && (s3)){
return cljs.core.cons((function (){var G__23867 = cljs.core.first(s1);
var G__23868 = cljs.core.first(s2);
var G__23869 = cljs.core.first(s3);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__23867,G__23868,G__23869) : f.call(null,G__23867,G__23868,G__23869));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
var step = (function cljs$core$step(cs){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs$core$step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (step){
return (function (p1__23850_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,p1__23850_SHARP_);
});})(step))
,step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.array_seq([c2,c1], 0))));
});

cljs.core.map.cljs$lang$applyTo = (function (seq23852){
var G__23853 = cljs.core.first(seq23852);
var seq23852__$1 = cljs.core.next(seq23852);
var G__23854 = cljs.core.first(seq23852__$1);
var seq23852__$2 = cljs.core.next(seq23852__$1);
var G__23855 = cljs.core.first(seq23852__$2);
var seq23852__$3 = cljs.core.next(seq23852__$2);
var G__23856 = cljs.core.first(seq23852__$3);
var seq23852__$4 = cljs.core.next(seq23852__$3);
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(G__23853,G__23854,G__23855,G__23856,seq23852__$4);
});

cljs.core.map.cljs$lang$maxFixedArity = (4);

/**
 * Returns a lazy sequence of the first n items in coll, or all items if
 *   there are fewer than n.  Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.take = (function cljs$core$take(var_args){
var args23884 = [];
var len__7651__auto___23887 = arguments.length;
var i__7652__auto___23888 = (0);
while(true){
if((i__7652__auto___23888 < len__7651__auto___23887)){
args23884.push((arguments[i__7652__auto___23888]));

var G__23889 = (i__7652__auto___23888 + (1));
i__7652__auto___23888 = G__23889;
continue;
} else {
}
break;
}

var G__23886 = args23884.length;
switch (G__23886) {
case 1:
return cljs.core.take.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23884.length)].join('')));

}
});

cljs.core.take.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__23891 = null;
var G__23891__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__23891__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__23891__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
var nn = cljs.core._vreset_BANG_(na,(cljs.core._deref(na) - (1)));
var result__$1 = (((n__$1 > (0)))?(rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input)):result);
if(!((nn > (0)))){
return cljs.core.ensure_reduced(result__$1);
} else {
return result__$1;
}
});
G__23891 = function(result,input){
switch(arguments.length){
case 0:
return G__23891__0.call(this);
case 1:
return G__23891__1.call(this,result);
case 2:
return G__23891__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23891.cljs$core$IFn$_invoke$arity$0 = G__23891__0;
G__23891.cljs$core$IFn$_invoke$arity$1 = G__23891__1;
G__23891.cljs$core$IFn$_invoke$arity$2 = G__23891__2;
return G__23891;
})()
;})(na))
});
});

cljs.core.take.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (new cljs.core.LazySeq(null,(function (){
if((n > (0))){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take.cljs$core$IFn$_invoke$arity$2((n - (1)),cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.take.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence of all but the first n items in coll.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.drop = (function cljs$core$drop(var_args){
var args23892 = [];
var len__7651__auto___23895 = arguments.length;
var i__7652__auto___23896 = (0);
while(true){
if((i__7652__auto___23896 < len__7651__auto___23895)){
args23892.push((arguments[i__7652__auto___23896]));

var G__23897 = (i__7652__auto___23896 + (1));
i__7652__auto___23896 = G__23897;
continue;
} else {
}
break;
}

var G__23894 = args23892.length;
switch (G__23894) {
case 1:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23892.length)].join('')));

}
});

cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__23899 = null;
var G__23899__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__23899__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__23899__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
cljs.core._vreset_BANG_(na,(cljs.core._deref(na) - (1)));

if((n__$1 > (0))){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__23899 = function(result,input){
switch(arguments.length){
case 0:
return G__23899__0.call(this);
case 1:
return G__23899__1.call(this,result);
case 2:
return G__23899__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23899.cljs$core$IFn$_invoke$arity$0 = G__23899__0;
G__23899.cljs$core$IFn$_invoke$arity$1 = G__23899__1;
G__23899.cljs$core$IFn$_invoke$arity$2 = G__23899__2;
return G__23899;
})()
;})(na))
});
});

cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

var step = (function (n__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(((n__$1 > (0))) && (s)){
var G__23900 = (n__$1 - (1));
var G__23901 = cljs.core.rest(s);
n__$1 = G__23900;
coll__$1 = G__23901;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(n,coll);
});})(step))
,null,null));
});

cljs.core.drop.cljs$lang$maxFixedArity = 2;

/**
 * Return a lazy sequence of all but the last n (default 1) items in coll
 */
cljs.core.drop_last = (function cljs$core$drop_last(var_args){
var args23902 = [];
var len__7651__auto___23905 = arguments.length;
var i__7652__auto___23906 = (0);
while(true){
if((i__7652__auto___23906 < len__7651__auto___23905)){
args23902.push((arguments[i__7652__auto___23906]));

var G__23907 = (i__7652__auto___23906 + (1));
i__7652__auto___23906 = G__23907;
continue;
} else {
}
break;
}

var G__23904 = args23902.length;
switch (G__23904) {
case 1:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23902.length)].join('')));

}
});

cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((1),s);
});

cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = (function (n,s){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((function (x,_){
return x;
}),s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
});

cljs.core.drop_last.cljs$lang$maxFixedArity = 2;

/**
 * Returns a seq of the last n items in coll.  Depending on the type
 *   of coll may be no better than linear time.  For vectors, see also subvec.
 */
cljs.core.take_last = (function cljs$core$take_last(n,coll){
var s = cljs.core.seq(coll);
var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));
while(true){
if(lead){
var G__23909 = cljs.core.next(s);
var G__23910 = cljs.core.next(lead);
s = G__23909;
lead = G__23910;
continue;
} else {
return s;
}
break;
}
});
/**
 * Returns a lazy sequence of the items in coll starting from the
 *   first item for which (pred item) returns logical false.  Returns a
 *   stateful transducer when no collection is provided.
 */
cljs.core.drop_while = (function cljs$core$drop_while(var_args){
var args23911 = [];
var len__7651__auto___23916 = arguments.length;
var i__7652__auto___23917 = (0);
while(true){
if((i__7652__auto___23917 < len__7651__auto___23916)){
args23911.push((arguments[i__7652__auto___23917]));

var G__23918 = (i__7652__auto___23917 + (1));
i__7652__auto___23917 = G__23918;
continue;
} else {
}
break;
}

var G__23913 = args23911.length;
switch (G__23913) {
case 1:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23911.length)].join('')));

}
});

cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
var da = cljs.core.volatile_BANG_(true);
return ((function (da){
return (function() {
var G__23920 = null;
var G__23920__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__23920__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__23920__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref(da);
if(cljs.core.truth_((function (){var and__6531__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input));
} else {
return and__6531__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_(da,null);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__23920 = function(result,input){
switch(arguments.length){
case 0:
return G__23920__0.call(this);
case 1:
return G__23920__1.call(this,result);
case 2:
return G__23920__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23920.cljs$core$IFn$_invoke$arity$0 = G__23920__0;
G__23920.cljs$core$IFn$_invoke$arity$1 = G__23920__1;
G__23920.cljs$core$IFn$_invoke$arity$2 = G__23920__2;
return G__23920;
})()
;})(da))
});
});

cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
var step = (function (pred__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(cljs.core.truth_((function (){var and__6531__auto__ = s;
if(and__6531__auto__){
var G__23915 = cljs.core.first(s);
return (pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__23915) : pred__$1.call(null,G__23915));
} else {
return and__6531__auto__;
}
})())){
var G__23921 = pred__$1;
var G__23922 = cljs.core.rest(s);
pred__$1 = G__23921;
coll__$1 = G__23922;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(pred,coll);
});})(step))
,null,null));
});

cljs.core.drop_while.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy (infinite!) sequence of repetitions of the items in coll.
 */
cljs.core.cycle = (function cljs$core$cycle(coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(s,(cljs.core.cycle.cljs$core$IFn$_invoke$arity$1 ? cljs.core.cycle.cljs$core$IFn$_invoke$arity$1(s) : cljs.core.cycle.call(null,s)));
} else {
return null;
}
}),null,null));
});
/**
 * Returns a vector of [(take n coll) (drop n coll)]
 */
cljs.core.split_at = (function cljs$core$split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)], null);
});
/**
 * Returns a lazy (infinite!, or length n if supplied) sequence of xs.
 */
cljs.core.repeat = (function cljs$core$repeat(var_args){
var args23923 = [];
var len__7651__auto___23926 = arguments.length;
var i__7652__auto___23927 = (0);
while(true){
if((i__7652__auto___23927 < len__7651__auto___23926)){
args23923.push((arguments[i__7652__auto___23927]));

var G__23928 = (i__7652__auto___23927 + (1));
i__7652__auto___23927 = G__23928;
continue;
} else {
}
break;
}

var G__23925 = args23923.length;
switch (G__23925) {
case 1:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23923.length)].join('')));

}
});

cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(x,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
}),null,null));
});

cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = (function (n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});

cljs.core.repeat.cljs$lang$maxFixedArity = 2;

/**
 * DEPRECATED: Use 'repeat' instead.
 *   Returns a lazy seq of n xs.
 */
cljs.core.replicate = (function cljs$core$replicate(n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});
/**
 * Takes a function of no args, presumably with side effects, and
 *   returns an infinite (or length n if supplied) lazy sequence of calls
 *   to it
 */
cljs.core.repeatedly = (function cljs$core$repeatedly(var_args){
var args23930 = [];
var len__7651__auto___23933 = arguments.length;
var i__7652__auto___23934 = (0);
while(true){
if((i__7652__auto___23934 < len__7651__auto___23933)){
args23930.push((arguments[i__7652__auto___23934]));

var G__23935 = (i__7652__auto___23934 + (1));
i__7652__auto___23934 = G__23935;
continue;
} else {
}
break;
}

var G__23932 = args23930.length;
switch (G__23932) {
case 1:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23930.length)].join('')));

}
});

cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}),null,null));
});

cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = (function (n,f){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
});

cljs.core.repeatedly.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
 */
cljs.core.iterate = (function cljs$core$iterate(f,x){
return cljs.core.cons(x,(new cljs.core.LazySeq(null,(function (){
var G__23939 = f;
var G__23940 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x));
return (cljs.core.iterate.cljs$core$IFn$_invoke$arity$2 ? cljs.core.iterate.cljs$core$IFn$_invoke$arity$2(G__23939,G__23940) : cljs.core.iterate.call(null,G__23939,G__23940));
}),null,null)));
});
/**
 * Returns a lazy seq of the first item in each coll, then the second etc.
 */
cljs.core.interleave = (function cljs$core$interleave(var_args){
var args23941 = [];
var len__7651__auto___23947 = arguments.length;
var i__7652__auto___23948 = (0);
while(true){
if((i__7652__auto___23948 < len__7651__auto___23947)){
args23941.push((arguments[i__7652__auto___23948]));

var G__23949 = (i__7652__auto___23948 + (1));
i__7652__auto___23948 = G__23949;
continue;
} else {
}
break;
}

var G__23946 = args23941.length;
switch (G__23946) {
case 2:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23941.slice((2)),(0),null));
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
return null;
}
}),null,null));
});

cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = (function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.array_seq([c1], 0)));
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});

cljs.core.interleave.cljs$lang$applyTo = (function (seq23942){
var G__23943 = cljs.core.first(seq23942);
var seq23942__$1 = cljs.core.next(seq23942);
var G__23944 = cljs.core.first(seq23942__$1);
var seq23942__$2 = cljs.core.next(seq23942__$1);
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(G__23943,G__23944,seq23942__$2);
});

cljs.core.interleave.cljs$lang$maxFixedArity = (2);

/**
 * Returns a lazy seq of the elements of coll separated by sep.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.interpose = (function cljs$core$interpose(var_args){
var args23951 = [];
var len__7651__auto___23954 = arguments.length;
var i__7652__auto___23955 = (0);
while(true){
if((i__7652__auto___23955 < len__7651__auto___23954)){
args23951.push((arguments[i__7652__auto___23955]));

var G__23956 = (i__7652__auto___23955 + (1));
i__7652__auto___23955 = G__23956;
continue;
} else {
}
break;
}

var G__23953 = args23951.length;
switch (G__23953) {
case 1:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23951.length)].join('')));

}
});

cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = (function (sep){
return (function (rf){
var started = cljs.core.volatile_BANG_(false);
return ((function (started){
return (function() {
var G__23958 = null;
var G__23958__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__23958__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__23958__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref(started))){
var sepr = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,sep) : rf.call(null,result,sep));
if(cljs.core.reduced_QMARK_(sepr)){
return sepr;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(sepr,input) : rf.call(null,sepr,input));
}
} else {
cljs.core.vreset_BANG_(started,true);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__23958 = function(result,input){
switch(arguments.length){
case 0:
return G__23958__0.call(this);
case 1:
return G__23958__1.call(this,result);
case 2:
return G__23958__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23958.cljs$core$IFn$_invoke$arity$0 = G__23958__0;
G__23958.cljs$core$IFn$_invoke$arity$1 = G__23958__1;
G__23958.cljs$core$IFn$_invoke$arity$2 = G__23958__2;
return G__23958;
})()
;})(started))
});
});

cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = (function (sep,coll){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll));
});

cljs.core.interpose.cljs$lang$maxFixedArity = 2;

/**
 * Take a collection of collections, and return a lazy seq
 *   of items from the inner collection
 */
cljs.core.flatten1 = (function cljs$core$flatten1(colls){
var cat = (function cljs$core$flatten1_$_cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4655__auto__ = cljs.core.seq(coll);
if(temp__4655__auto__){
var coll__$1 = temp__4655__auto__;
return cljs.core.cons(cljs.core.first(coll__$1),cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1),colls__$1));
} else {
if(cljs.core.seq(colls__$1)){
return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(null,colls);
});
/**
 * Returns the result of applying concat to the result of applying map
 *   to f and colls.  Thus function f should return a collection. Returns
 *   a transducer when no collections are provided
 */
cljs.core.mapcat = (function cljs$core$mapcat(var_args){
var args23967 = [];
var len__7651__auto___23972 = arguments.length;
var i__7652__auto___23973 = (0);
while(true){
if((i__7652__auto___23973 < len__7651__auto___23972)){
args23967.push((arguments[i__7652__auto___23973]));

var G__23974 = (i__7652__auto___23973 + (1));
i__7652__auto___23973 = G__23974;
continue;
} else {
}
break;
}

var G__23971 = args23967.length;
switch (G__23971) {
case 1:
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args23967.slice((1)),(0),null));
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7670__auto__);

}
});

cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat);
});

cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = (function (f,colls){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls));
});

cljs.core.mapcat.cljs$lang$applyTo = (function (seq23968){
var G__23969 = cljs.core.first(seq23968);
var seq23968__$1 = cljs.core.next(seq23968);
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(G__23969,seq23968__$1);
});

cljs.core.mapcat.cljs$lang$maxFixedArity = (1);

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns true. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.filter = (function cljs$core$filter(var_args){
var args23976 = [];
var len__7651__auto___23980 = arguments.length;
var i__7652__auto___23981 = (0);
while(true){
if((i__7652__auto___23981 < len__7651__auto___23980)){
args23976.push((arguments[i__7652__auto___23981]));

var G__23982 = (i__7652__auto___23981 + (1));
i__7652__auto___23981 = G__23982;
continue;
} else {
}
break;
}

var G__23978 = args23976.length;
switch (G__23978) {
case 1:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23976.length)].join('')));

}
});

cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
return (function() {
var G__23984 = null;
var G__23984__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__23984__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__23984__2 = (function (result,input){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input)))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return result;
}
});
G__23984 = function(result,input){
switch(arguments.length){
case 0:
return G__23984__0.call(this);
case 1:
return G__23984__1.call(this,result);
case 2:
return G__23984__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23984.cljs$core$IFn$_invoke$arity$0 = G__23984__0;
G__23984.cljs$core$IFn$_invoke$arity$1 = G__23984__1;
G__23984.cljs$core$IFn$_invoke$arity$2 = G__23984__2;
return G__23984;
})()
});
});

cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__7461__auto___23985 = size;
var i_23986 = (0);
while(true){
if((i_23986 < n__7461__auto___23985)){
if(cljs.core.truth_((function (){var G__23979 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_23986);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__23979) : pred.call(null,G__23979));
})())){
cljs.core.chunk_append(b,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_23986));
} else {
}

var G__23987 = (i_23986 + (1));
i_23986 = G__23987;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)));
} else {
var f = cljs.core.first(s);
var r = cljs.core.rest(s);
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(f) : pred.call(null,f)))){
return cljs.core.cons(f,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r));
} else {
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r);
}
}
} else {
return null;
}
}),null,null));
});

cljs.core.filter.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns false. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.remove = (function cljs$core$remove(var_args){
var args23988 = [];
var len__7651__auto___23991 = arguments.length;
var i__7652__auto___23992 = (0);
while(true){
if((i__7652__auto___23992 < len__7651__auto___23991)){
args23988.push((arguments[i__7652__auto___23992]));

var G__23993 = (i__7652__auto___23992 + (1));
i__7652__auto___23992 = G__23993;
continue;
} else {
}
break;
}

var G__23990 = args23988.length;
switch (G__23990) {
case 1:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23988.length)].join('')));

}
});

cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
});

cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll);
});

cljs.core.remove.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
 *   branch? must be a fn of one arg that returns true if passed a node
 *   that can have children (but may not).  children must be a fn of one
 *   arg that returns a sequence of the children. Will only be called on
 *   nodes for which branch? returns true. Root is the root node of the
 *   tree.
 */
cljs.core.tree_seq = (function cljs$core$tree_seq(branch_QMARK_,children,root){
var walk = (function cljs$core$tree_seq_$_walk(node){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(node,(cljs.core.truth_((branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : branch_QMARK_.call(null,node)))?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk,cljs.core.array_seq([(children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(node) : children.call(null,node))], 0)):null));
}),null,null));
});
return walk(root);
});
/**
 * Takes any nested combination of sequential things (lists, vectors,
 *   etc.) and returns their contents as a single, flat sequence.
 *   (flatten nil) returns nil.
 */
cljs.core.flatten = (function cljs$core$flatten(x){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__23995_SHARP_){
return !(cljs.core.sequential_QMARK_(p1__23995_SHARP_));
}),cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
 * Returns a new coll consisting of to-coll with all of the items of
 *   from-coll conjoined. A transducer may be supplied.
 */
cljs.core.into = (function cljs$core$into(var_args){
var args23996 = [];
var len__7651__auto___24001 = arguments.length;
var i__7652__auto___24002 = (0);
while(true){
if((i__7652__auto___24002 < len__7651__auto___24001)){
args23996.push((arguments[i__7652__auto___24002]));

var G__24003 = (i__7652__auto___24002 + (1));
i__7652__auto___24002 = G__24003;
continue;
} else {
}
break;
}

var G__23998 = args23996.length;
switch (G__23998) {
case 0:
return cljs.core.into.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.into.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.into.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23996.length)].join('')));

}
});

cljs.core.into.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.into.cljs$core$IFn$_invoke$arity$1 = (function (to){
return to;
});

cljs.core.into.cljs$core$IFn$_invoke$arity$2 = (function (to,from){
if(!((to == null))){
if(((!((to == null)))?((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$)))?true:false):false)){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,from);
}
});

cljs.core.into.cljs$core$IFn$_invoke$arity$3 = (function (to,xform,from){
if(((!((to == null)))?((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$)))?true:false):false)){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from);
}
});

cljs.core.into.cljs$lang$maxFixedArity = 3;

/**
 * Returns a vector consisting of the result of applying f to the
 *   set of first items of each coll, followed by applying f to the set
 *   of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments.
 */
cljs.core.mapv = (function cljs$core$mapv(var_args){
var args24005 = [];
var len__7651__auto___24013 = arguments.length;
var i__7652__auto___24014 = (0);
while(true){
if((i__7652__auto___24014 < len__7651__auto___24013)){
args24005.push((arguments[i__7652__auto___24014]));

var G__24015 = (i__7652__auto___24014 + (1));
i__7652__auto___24014 = G__24015;
continue;
} else {
}
break;
}

var G__24012 = args24005.length;
switch (G__24012) {
case 2:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args24005.slice((4)),(0),null));
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7670__auto__);

}
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(o) : f.call(null,o)));
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2,c3));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2,c3,cljs.core.array_seq([colls], 0)));
});

cljs.core.mapv.cljs$lang$applyTo = (function (seq24006){
var G__24007 = cljs.core.first(seq24006);
var seq24006__$1 = cljs.core.next(seq24006);
var G__24008 = cljs.core.first(seq24006__$1);
var seq24006__$2 = cljs.core.next(seq24006__$1);
var G__24009 = cljs.core.first(seq24006__$2);
var seq24006__$3 = cljs.core.next(seq24006__$2);
var G__24010 = cljs.core.first(seq24006__$3);
var seq24006__$4 = cljs.core.next(seq24006__$3);
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(G__24007,G__24008,G__24009,G__24010,seq24006__$4);
});

cljs.core.mapv.cljs$lang$maxFixedArity = (4);

/**
 * Returns a vector of the items in coll for which
 *   (pred item) returns true. pred must be free of side-effects.
 */
cljs.core.filterv = (function cljs$core$filterv(pred,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(o) : pred.call(null,o)))){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);
} else {
return v;
}
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
/**
 * Returns a lazy sequence of lists of n items each, at offsets step
 *   apart. If step is not supplied, defaults to n, i.e. the partitions
 *   do not overlap. If a pad collection is supplied, use its elements as
 *   necessary to complete last partition up to n items. In case there are
 *   not enough padding elements, return a partition with less than n items.
 */
cljs.core.partition = (function cljs$core$partition(var_args){
var args24017 = [];
var len__7651__auto___24020 = arguments.length;
var i__7652__auto___24021 = (0);
while(true){
if((i__7652__auto___24021 < len__7651__auto___24020)){
args24017.push((arguments[i__7652__auto___24021]));

var G__24022 = (i__7652__auto___24021 + (1));
i__7652__auto___24021 = G__24022;
continue;
} else {
}
break;
}

var G__24019 = args24017.length;
switch (G__24019) {
case 2:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24017.length)].join('')));

}
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = (function (n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
var x__7380__auto__ = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad));
return cljs.core._conj(cljs.core.List.EMPTY,x__7380__auto__);
}
} else {
return null;
}
}),null,null));
});

cljs.core.partition.cljs$lang$maxFixedArity = 4;

/**
 * Returns the value in a nested associative structure,
 *   where ks is a sequence of keys. Returns nil if the key is not present,
 *   or the not-found value if supplied.
 */
cljs.core.get_in = (function cljs$core$get_in(var_args){
var args24024 = [];
var len__7651__auto___24027 = arguments.length;
var i__7652__auto___24028 = (0);
while(true){
if((i__7652__auto___24028 < len__7651__auto___24027)){
args24024.push((arguments[i__7652__auto___24028]));

var G__24029 = (i__7652__auto___24028 + (1));
i__7652__auto___24028 = G__24029;
continue;
} else {
}
break;
}

var G__24026 = args24024.length;
switch (G__24026) {
case 2:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24024.length)].join('')));

}
});

cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = (function (m,ks){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.get,m,ks);
});

cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = (function (m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if(!((ks__$1 == null))){
var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__24031 = sentinel;
var G__24032 = m__$2;
var G__24033 = cljs.core.next(ks__$1);
sentinel = G__24031;
m__$1 = G__24032;
ks__$1 = G__24033;
continue;
}
} else {
return m__$1;
}
break;
}
});

cljs.core.get_in.cljs$lang$maxFixedArity = 3;

/**
 * Associates a value in a nested associative structure, where ks is a
 *   sequence of keys and v is the new value and returns a new nested structure.
 *   If any levels do not exist, hash-maps will be created.
 */
cljs.core.assoc_in = (function cljs$core$assoc_in(m,p__24034,v){
var vec__24041 = p__24034;
var seq__24042 = cljs.core.seq(vec__24041);
var first__24043 = cljs.core.first(seq__24042);
var seq__24042__$1 = cljs.core.next(seq__24042);
var k = first__24043;
var ks = seq__24042__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__24044 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__24045 = ks;
var G__24046 = v;
return (cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3 ? cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3(G__24044,G__24045,G__24046) : cljs.core.assoc_in.call(null,G__24044,G__24045,G__24046));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
/**
 * 'Updates' a value in a nested associative structure, where ks is a
 *   sequence of keys and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   nested structure.  If any levels do not exist, hash-maps will be
 *   created.
 */
cljs.core.update_in = (function cljs$core$update_in(var_args){
var args24047 = [];
var len__7651__auto___24087 = arguments.length;
var i__7652__auto___24088 = (0);
while(true){
if((i__7652__auto___24088 < len__7651__auto___24087)){
args24047.push((arguments[i__7652__auto___24088]));

var G__24089 = (i__7652__auto___24088 + (1));
i__7652__auto___24088 = G__24089;
continue;
} else {
}
break;
}

var G__24056 = args24047.length;
switch (G__24056) {
case 3:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args24047.slice((6)),(0),null));
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__7670__auto__);

}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = (function (m,p__24057,f){
var vec__24058 = p__24057;
var seq__24059 = cljs.core.seq(vec__24058);
var first__24060 = cljs.core.first(seq__24059);
var seq__24059__$1 = cljs.core.next(seq__24059);
var k = first__24060;
var ks = seq__24059__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__24061 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__24061) : f.call(null,G__24061));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = (function (m,p__24062,f,a){
var vec__24063 = p__24062;
var seq__24064 = cljs.core.seq(vec__24063);
var first__24065 = cljs.core.first(seq__24064);
var seq__24064__$1 = cljs.core.next(seq__24064);
var k = first__24065;
var ks = seq__24064__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__24066 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__24067 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__24066,G__24067) : f.call(null,G__24066,G__24067));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = (function (m,p__24068,f,a,b){
var vec__24069 = p__24068;
var seq__24070 = cljs.core.seq(vec__24069);
var first__24071 = cljs.core.first(seq__24070);
var seq__24070__$1 = cljs.core.next(seq__24070);
var k = first__24071;
var ks = seq__24070__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__24072 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__24073 = a;
var G__24074 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__24072,G__24073,G__24074) : f.call(null,G__24072,G__24073,G__24074));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = (function (m,p__24075,f,a,b,c){
var vec__24076 = p__24075;
var seq__24077 = cljs.core.seq(vec__24076);
var first__24078 = cljs.core.first(seq__24077);
var seq__24077__$1 = cljs.core.next(seq__24077);
var k = first__24078;
var ks = seq__24077__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__24079 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__24080 = a;
var G__24081 = b;
var G__24082 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__24079,G__24080,G__24081,G__24082) : f.call(null,G__24079,G__24080,G__24081,G__24082));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,p__24083,f,a,b,c,args){
var vec__24084 = p__24083;
var seq__24085 = cljs.core.seq(vec__24084);
var first__24086 = cljs.core.first(seq__24085);
var seq__24085__$1 = cljs.core.next(seq__24085);
var k = first__24086;
var ks = seq__24085__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.array_seq([b,c,args], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.array_seq([args], 0)));
}
});

cljs.core.update_in.cljs$lang$applyTo = (function (seq24048){
var G__24049 = cljs.core.first(seq24048);
var seq24048__$1 = cljs.core.next(seq24048);
var G__24050 = cljs.core.first(seq24048__$1);
var seq24048__$2 = cljs.core.next(seq24048__$1);
var G__24051 = cljs.core.first(seq24048__$2);
var seq24048__$3 = cljs.core.next(seq24048__$2);
var G__24052 = cljs.core.first(seq24048__$3);
var seq24048__$4 = cljs.core.next(seq24048__$3);
var G__24053 = cljs.core.first(seq24048__$4);
var seq24048__$5 = cljs.core.next(seq24048__$4);
var G__24054 = cljs.core.first(seq24048__$5);
var seq24048__$6 = cljs.core.next(seq24048__$5);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(G__24049,G__24050,G__24051,G__24052,G__24053,G__24054,seq24048__$6);
});

cljs.core.update_in.cljs$lang$maxFixedArity = (6);

/**
 * 'Updates' a value in an associative structure, where k is a
 *   key and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   structure.  If the key does not exist, nil is passed as the old value.
 */
cljs.core.update = (function cljs$core$update(var_args){
var args24091 = [];
var len__7651__auto___24111 = arguments.length;
var i__7652__auto___24112 = (0);
while(true){
if((i__7652__auto___24112 < len__7651__auto___24111)){
args24091.push((arguments[i__7652__auto___24112]));

var G__24113 = (i__7652__auto___24112 + (1));
i__7652__auto___24112 = G__24113;
continue;
} else {
}
break;
}

var G__24100 = args24091.length;
switch (G__24100) {
case 3:
return cljs.core.update.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args24091.slice((6)),(0),null));
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__7670__auto__);

}
});

cljs.core.update.cljs$core$IFn$_invoke$arity$3 = (function (m,k,f){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__24101 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__24101) : f.call(null,G__24101));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$4 = (function (m,k,f,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__24102 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__24103 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__24102,G__24103) : f.call(null,G__24102,G__24103));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$5 = (function (m,k,f,x,y){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__24104 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__24105 = x;
var G__24106 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__24104,G__24105,G__24106) : f.call(null,G__24104,G__24105,G__24106));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$6 = (function (m,k,f,x,y,z){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__24107 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__24108 = x;
var G__24109 = y;
var G__24110 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__24107,G__24108,G__24109,G__24110) : f.call(null,G__24107,G__24108,G__24109,G__24110));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = (function (m,k,f,x,y,z,more){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.array_seq([more], 0)));
});

cljs.core.update.cljs$lang$applyTo = (function (seq24092){
var G__24093 = cljs.core.first(seq24092);
var seq24092__$1 = cljs.core.next(seq24092);
var G__24094 = cljs.core.first(seq24092__$1);
var seq24092__$2 = cljs.core.next(seq24092__$1);
var G__24095 = cljs.core.first(seq24092__$2);
var seq24092__$3 = cljs.core.next(seq24092__$2);
var G__24096 = cljs.core.first(seq24092__$3);
var seq24092__$4 = cljs.core.next(seq24092__$3);
var G__24097 = cljs.core.first(seq24092__$4);
var seq24092__$5 = cljs.core.next(seq24092__$4);
var G__24098 = cljs.core.first(seq24092__$5);
var seq24092__$6 = cljs.core.next(seq24092__$5);
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(G__24093,G__24094,G__24095,G__24096,G__24097,G__24098,seq24092__$6);
});

cljs.core.update.cljs$lang$maxFixedArity = (6);


/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
})

cljs.core.VectorNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.cst$sym$arr], null);
});

cljs.core.VectorNode.cljs$lang$type = true;

cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";

cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/VectorNode");
});

cljs.core.__GT_VectorNode = (function cljs$core$__GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function cljs$core$pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function cljs$core$pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function cljs$core$pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function cljs$core$pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr)));
});
cljs.core.tail_off = (function cljs$core$tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function cljs$core$new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node(edit);
var _ = cljs.core.pv_aset(r,(0),embed);
var G__24115 = (ll - (5));
var G__24116 = r;
ll = G__24115;
ret = G__24116;
continue;
}
break;
}
});
cljs.core.push_tail = (function cljs$core$push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node(parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset(ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget(parent,subidx);
if(!((child == null))){
var node_to_insert = (function (){var G__24121 = pv;
var G__24122 = (level - (5));
var G__24123 = child;
var G__24124 = tailnode;
return (cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4(G__24121,G__24122,G__24123,G__24124) : cljs.core.push_tail.call(null,G__24121,G__24122,G__24123,G__24124));
})();
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path(null,(level - (5)),tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function cljs$core$vector_index_out_of_bounds(i,cnt){
throw (new Error([cljs.core.str("No item "),cljs.core.str(i),cljs.core.str(" in vector of length "),cljs.core.str(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function cljs$core$first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__24125 = cljs.core.pv_aget(node,(0));
var G__24126 = (level - (5));
node = G__24125;
level = G__24126;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function cljs$core$unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off(pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__24127 = cljs.core.pv_aget(node,((i >>> level) & (31)));
var G__24128 = (level - (5));
node = G__24127;
level = G__24128;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function cljs$core$array_for(pv,i){
if((((0) <= i)) && ((i < pv.cnt))){
return cljs.core.unchecked_array_for(pv,i);
} else {
return cljs.core.vector_index_out_of_bounds(i,pv.cnt);
}
});
cljs.core.do_assoc = (function cljs$core$do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node(node);
if((level === (0))){
cljs.core.pv_aset(ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(function (){var G__24134 = pv;
var G__24135 = (level - (5));
var G__24136 = cljs.core.pv_aget(node,subidx);
var G__24137 = i;
var G__24138 = val;
return (cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5 ? cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5(G__24134,G__24135,G__24136,G__24137,G__24138) : cljs.core.do_assoc.call(null,G__24134,G__24135,G__24136,G__24137,G__24138));
})());

return ret;
}
});
cljs.core.pop_tail = (function cljs$core$pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__24142 = pv;
var G__24143 = (level - (5));
var G__24144 = cljs.core.pv_aget(node,subidx);
return (cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3(G__24142,G__24143,G__24144) : cljs.core.pop_tail.call(null,G__24142,G__24143,G__24144));
})();
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
})
cljs.core.RangedIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
});

cljs.core.RangedIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
self__.arr = cljs.core.unchecked_array_for(self__.v,self__.i);

self__.base = (self__.base + (32));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.RangedIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$base,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$v,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null);
});

cljs.core.RangedIterator.cljs$lang$type = true;

cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";

cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/RangedIterator");
});

cljs.core.__GT_RangedIterator = (function cljs$core$__GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function cljs$core$ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count(v)))?cljs.core.unchecked_array_for(v,i):null),v,start,end));
});







/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167668511;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentVector.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentVector.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentVector.prototype.indexOf = (function() {
var G__24155 = null;
var G__24155__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__24155__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24155 = function(x,start){
switch(arguments.length){
case 1:
return G__24155__1.call(this,x);
case 2:
return G__24155__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24155.cljs$core$IFn$_invoke$arity$1 = G__24155__1;
G__24155.cljs$core$IFn$_invoke$arity$2 = G__24155__2;
return G__24155;
})()
;

cljs.core.PersistentVector.prototype.lastIndexOf = (function() {
var G__24156 = null;
var G__24156__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__24156__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24156 = function(x,start){
switch(arguments.length){
case 1:
return G__24156__1.call(this,x);
case 2:
return G__24156__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24156.cljs$core$IFn$_invoke$arity$1 = G__24156__1;
G__24156.cljs$core$IFn$_invoke$arity$2 = G__24156__2;
return G__24156;
})()
;

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__24146 = init__$2;
var G__24147 = (j + i);
var G__24148 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__24146,G__24147,G__24148) : f.call(null,G__24146,G__24147,G__24148));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__24157 = (j + (1));
var G__24158 = init__$3;
j = G__24157;
init__$2 = G__24158;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__24159 = (i + len);
var G__24160 = init__$2;
i = G__24159;
init__$1 = G__24160;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return (cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(coll__$1) <= n)){
var new_tail = cljs.core.aclone(self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return cljs.core._conj(coll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds  [0,"),cljs.core.str(self__.cnt),cljs.core.str("]")].join('')));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator(this$__$1,(0),self__.cnt);
});

cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(0));
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(1));
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(self__.cnt - (1)));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off(coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for(coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail(coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget(new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count(other))){
var me_iter = cljs.core._iterator(coll__$1);
var you_iter = cljs.core._iterator(other);
while(true){
if(cljs.core.truth_(me_iter.hasNext())){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential(coll__$1,other);
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,(cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(self__.root) : cljs.core.tv_editable_root.call(null,self__.root)),(cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(self__.tail) : cljs.core.tv_editable_tail.call(null,self__.tail))));
});

cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(v__$1,f);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__24149 = init__$2;
var G__24150 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__24149,G__24150) : f.call(null,G__24149,G__24150));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__24161 = (j + (1));
var G__24162 = init__$3;
j = G__24161;
init__$2 = G__24162;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__24163 = (i + len);
var G__24164 = init__$2;
i = G__24163;
init__$1 = G__24164;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._assoc_n(coll__$1,k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
});

cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0),null));
} else {
var G__24151 = coll__$1;
var G__24152 = cljs.core.first_array_for_longvec(coll__$1);
var G__24153 = (0);
var G__24154 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__24151,G__24152,G__24153,G__24154) : cljs.core.chunked_seq.call(null,G__24151,G__24152,G__24153,G__24154));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentVector(meta__$1,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off(coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__7461__auto___24165 = len;
var i_24166 = (0);
while(true){
if((i_24166 < n__7461__auto___24165)){
(new_tail[i_24166] = (self__.tail[i_24166]));

var G__24167 = (i_24166 + (1));
i_24166 = G__24167;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node(null);
cljs.core.pv_aset(n_r,(0),self__.root);

cljs.core.pv_aset(n_r,(1),cljs.core.new_path(null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail(coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
});

cljs.core.PersistentVector.prototype.call = (function() {
var G__24168 = null;
var G__24168__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__24168__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__24168 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__24168__2.call(this,self__,k);
case 3:
return G__24168__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24168.cljs$core$IFn$_invoke$arity$2 = G__24168__2;
G__24168.cljs$core$IFn$_invoke$arity$3 = G__24168__3;
return G__24168;
})()
;

cljs.core.PersistentVector.prototype.apply = (function (self__,args24145){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args24145)));
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.PersistentVector.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$cnt,cljs.core.cst$sym$shift,cljs.core.cst$sym$root,cljs.core.cst$sym$tail,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentVector.cljs$lang$type = true;

cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";

cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentVector");
});

cljs.core.__GT_PersistentVector = (function cljs$core$__GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash));
cljs.core.PersistentVector.fromArray = (function (xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone(xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
while(true){
if((i < l)){
var G__24169 = (i + (1));
var G__24170 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,(xs__$1[i]));
i = G__24169;
out = G__24170;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
/**
 * Creates a new vector containing the contents of coll. JavaScript arrays
 *   will be aliased and should not be modified.
 */
cljs.core.vec = (function cljs$core$vec(coll){
if(cljs.core.array_QMARK_(coll)){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll));
}
});
/**
 * Creates a new vector containing the args.
 */
cljs.core.vector = (function cljs$core$vector(var_args){
var args__7658__auto__ = [];
var len__7651__auto___24172 = arguments.length;
var i__7652__auto___24173 = (0);
while(true){
if((i__7652__auto___24173 < len__7651__auto___24172)){
args__7658__auto__.push((arguments[i__7652__auto___24173]));

var G__24174 = (i__7652__auto___24173 + (1));
i__7652__auto___24173 = G__24174;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0)))){
return cljs.core.PersistentVector.fromArray(args.arr,true);
} else {
return cljs.core.vec(args);
}
});

cljs.core.vector.cljs$lang$maxFixedArity = (0);

cljs.core.vector.cljs$lang$applyTo = (function (seq24171){
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq24171));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedSeq.prototype.indexOf = (function() {
var G__24197 = null;
var G__24197__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__24197__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24197 = function(x,start){
switch(arguments.length){
case 1:
return G__24197__1.call(this,x);
case 2:
return G__24197__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24197.cljs$core$IFn$_invoke$arity$1 = G__24197__1;
G__24197.cljs$core$IFn$_invoke$arity$2 = G__24197__2;
return G__24197;
})()
;

cljs.core.ChunkedSeq.prototype.lastIndexOf = (function() {
var G__24198 = null;
var G__24198__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__24198__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24198 = function(x,start){
switch(arguments.length){
case 1:
return G__24198__1.call(this,x);
case 2:
return G__24198__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24198.cljs$core$IFn$_invoke$arity$1 = G__24198__1;
G__24198.cljs$core$IFn$_invoke$arity$2 = G__24198__2;
return G__24198;
})()
;

cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__24175 = self__.vec;
var G__24176 = self__.node;
var G__24177 = self__.i;
var G__24178 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__24175,G__24176,G__24177,G__24178) : cljs.core.chunked_seq.call(null,G__24175,G__24176,G__24177,G__24178));
})();
if((s == null)){
return null;
} else {
return s;
}
} else {
return cljs.core._chunked_next(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((function (){var G__24179 = self__.vec;
var G__24180 = (self__.i + self__.off);
var G__24181 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__24179,G__24180,G__24181) : cljs.core.subvec.call(null,G__24179,G__24180,G__24181));
})(),f);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((function (){var G__24182 = self__.vec;
var G__24183 = (self__.i + self__.off);
var G__24184 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__24182,G__24183,G__24184) : cljs.core.subvec.call(null,G__24182,G__24183,G__24184));
})(),f,start);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__24185 = self__.vec;
var G__24186 = self__.node;
var G__24187 = self__.i;
var G__24188 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__24185,G__24186,G__24187,G__24188) : cljs.core.chunked_seq.call(null,G__24185,G__24186,G__24187,G__24188));
})();
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return cljs.core._chunked_rest(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__24189 = self__.vec;
var G__24190 = cljs.core.unchecked_array_for(self__.vec,end);
var G__24191 = end;
var G__24192 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__24189,G__24190,G__24191,G__24192) : cljs.core.chunked_seq.call(null,G__24189,G__24190,G__24191,G__24192));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(self__.vec,self__.node,self__.i,self__.off,m) : cljs.core.chunked_seq.call(null,self__.vec,self__.node,self__.i,self__.off,m));
});

cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__24193 = self__.vec;
var G__24194 = cljs.core.unchecked_array_for(self__.vec,end);
var G__24195 = end;
var G__24196 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__24193,G__24194,G__24195,G__24196) : cljs.core.chunked_seq.call(null,G__24193,G__24194,G__24195,G__24196));
} else {
return null;
}
});

cljs.core.ChunkedSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vec,cljs.core.cst$sym$node,cljs.core.cst$sym$i,cljs.core.cst$sym$off,cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ChunkedSeq.cljs$lang$type = true;

cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";

cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ChunkedSeq");
});

cljs.core.__GT_ChunkedSeq = (function cljs$core$__GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

(cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
cljs.core.chunked_seq = (function cljs$core$chunked_seq(var_args){
var args24199 = [];
var len__7651__auto___24202 = arguments.length;
var i__7652__auto___24203 = (0);
while(true){
if((i__7652__auto___24203 < len__7651__auto___24202)){
args24199.push((arguments[i__7652__auto___24203]));

var G__24204 = (i__7652__auto___24203 + (1));
i__7652__auto___24203 = G__24204;
continue;
} else {
}
break;
}

var G__24201 = args24199.length;
switch (G__24201) {
case 3:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24199.length)].join('')));

}
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = (function (vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null));
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = (function (vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = (function (vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
});

cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5;


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Subvec.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Subvec.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Subvec.prototype.indexOf = (function() {
var G__24226 = null;
var G__24226__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__24226__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
G__24226 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__24226__1.call(this,x);
case 2:
return G__24226__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24226.cljs$core$IFn$_invoke$arity$1 = G__24226__1;
G__24226.cljs$core$IFn$_invoke$arity$2 = G__24226__2;
return G__24226;
})()
;

cljs.core.Subvec.prototype.lastIndexOf = (function() {
var G__24227 = null;
var G__24227__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__24227__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
G__24227 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__24227__1.call(this,x);
case 2:
return G__24227__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24227.cljs$core$IFn$_invoke$arity$1 = G__24227__1;
G__24227.cljs$core$IFn$_invoke$arity$2 = G__24227__2;
return G__24227;
})()
;

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var i = self__.start;
var j = (0);
var init__$1 = init;
while(true){
if((i < self__.end)){
var init__$2 = (function (){var G__24207 = init__$1;
var G__24208 = j;
var G__24209 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__24207,G__24208,G__24209) : f.call(null,G__24207,G__24208,G__24209));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__24228 = (i + (1));
var G__24229 = (j + (1));
var G__24230 = init__$2;
i = G__24228;
j = G__24229;
init__$1 = G__24230;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return cljs.core.vector_index_out_of_bounds(n,(self__.end - self__.start));
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.start + n));
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return not_found;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v,(self__.start + n),not_found);
}
});

cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
var G__24210 = self__.meta;
var G__24211 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val);
var G__24212 = self__.start;
var G__24213 = (function (){var x__6874__auto__ = self__.end;
var y__6875__auto__ = (v_pos + (1));
return ((x__6874__auto__ > y__6875__auto__) ? x__6874__auto__ : y__6875__auto__);
})();
var G__24214 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__24210,G__24211,G__24212,G__24213,G__24214) : cljs.core.build_subvec.call(null,G__24210,G__24211,G__24212,G__24213,G__24214));
});

cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
});

cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.end - (1)));
});

cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
var G__24215 = self__.meta;
var G__24216 = self__.v;
var G__24217 = self__.start;
var G__24218 = (self__.end - (1));
var G__24219 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__24215,G__24216,G__24217,G__24218,G__24219) : cljs.core.build_subvec.call(null,G__24215,G__24216,G__24217,G__24218,G__24219));
}
});

cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(!((self__.start === self__.end))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
});

cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start__$1){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,start__$1);
});

cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n(coll__$1,key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
});

cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = ((function (coll__$1){
return (function cljs$core$subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i),(new cljs.core.LazySeq(null,((function (coll__$1){
return (function (){
return cljs$core$subvec_seq((i + (1)));
});})(coll__$1))
,null,null)));
}
});})(coll__$1))
;
return subvec_seq(self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(meta__$1,self__.v,self__.start,self__.end,self__.__hash) : cljs.core.build_subvec.call(null,meta__$1,self__.v,self__.start,self__.end,self__.__hash));
});

cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__24221 = self__.meta;
var G__24222 = cljs.core._assoc_n(self__.v,self__.end,o);
var G__24223 = self__.start;
var G__24224 = (self__.end + (1));
var G__24225 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__24221,G__24222,G__24223,G__24224,G__24225) : cljs.core.build_subvec.call(null,G__24221,G__24222,G__24223,G__24224,G__24225));
});

cljs.core.Subvec.prototype.call = (function() {
var G__24231 = null;
var G__24231__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__24231__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__24231 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__24231__2.call(this,self__,k);
case 3:
return G__24231__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24231.cljs$core$IFn$_invoke$arity$2 = G__24231__2;
G__24231.cljs$core$IFn$_invoke$arity$3 = G__24231__3;
return G__24231;
})()
;

cljs.core.Subvec.prototype.apply = (function (self__,args24206){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args24206)));
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.Subvec.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$v,cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Subvec.cljs$lang$type = true;

cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";

cljs.core.Subvec.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/Subvec");
});

cljs.core.__GT_Subvec = (function cljs$core$__GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

(cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
cljs.core.build_subvec = (function cljs$core$build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__24232 = meta;
var G__24233 = v.v;
var G__24234 = (v.start + start);
var G__24235 = (v.start + end);
var G__24236 = __hash;
meta = G__24232;
v = G__24233;
start = G__24234;
end = G__24235;
__hash = G__24236;
continue;
} else {
var c = cljs.core.count(v);
if(((start < (0))) || ((end < (0))) || ((start > c)) || ((end > c))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
 * Returns a persistent vector of the items in vector from
 *   start (inclusive) to end (exclusive).  If end is not supplied,
 *   defaults to (count vector). This operation is O(1) and very fast, as
 *   the resulting vector shares structure with the original and no
 *   trimming is done.
 */
cljs.core.subvec = (function cljs$core$subvec(var_args){
var args24237 = [];
var len__7651__auto___24240 = arguments.length;
var i__7652__auto___24241 = (0);
while(true){
if((i__7652__auto___24241 < len__7651__auto___24240)){
args24237.push((arguments[i__7652__auto___24241]));

var G__24242 = (i__7652__auto___24241 + (1));
i__7652__auto___24241 = G__24242;
continue;
} else {
}
break;
}

var G__24239 = args24237.length;
switch (G__24239) {
case 2:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24237.length)].join('')));

}
});

cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = (function (v,start){
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v,start,cljs.core.count(v));
});

cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = (function (v,start,end){
return cljs.core.build_subvec(null,v,start,end,null);
});

cljs.core.subvec.cljs$lang$maxFixedArity = 3;

cljs.core.tv_ensure_editable = (function cljs$core$tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone(node.arr)));
}
});
cljs.core.tv_editable_root = (function cljs$core$tv_editable_root(node){
return (new cljs.core.VectorNode({},cljs.core.aclone(node.arr)));
});
cljs.core.tv_editable_tail = (function cljs$core$tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function cljs$core$tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable(tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget(ret,subidx);
if(!((child == null))){
var G__24252 = tv;
var G__24253 = (level - (5));
var G__24254 = child;
var G__24255 = tail_node;
return (cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4(G__24252,G__24253,G__24254,G__24255) : cljs.core.tv_push_tail.call(null,G__24252,G__24253,G__24254,G__24255));
} else {
return cljs.core.new_path(tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function cljs$core$tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__24259 = tv;
var G__24260 = (level - (5));
var G__24261 = cljs.core.pv_aget(node__$1,subidx);
return (cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3(G__24259,G__24260,G__24261) : cljs.core.tv_pop_tail.call(null,G__24259,G__24260,G__24261));
})();
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function cljs$core$unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off(tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__24262 = cljs.core.tv_ensure_editable(root.edit,cljs.core.pv_aget(node,((i >>> level) & (31))));
var G__24263 = (level - (5));
node = G__24262;
level = G__24263;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientVector}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition1$ = 88;
this.cljs$lang$protocol_mask$partition0$ = 275;
})
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off(tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

self__.tail = new_tail;

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path(self__.root.edit,self__.shift,tail_node));

self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array));

self__.shift = new_shift;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail(tcoll__$1,self__.shift,self__.root,tail_node);
self__.root = new_root;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
self__.root.edit = null;

var len = (self__.cnt - cljs.core.tail_off(tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy(self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n_BANG_(tcoll__$1,key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function (tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = ((function (tcoll__$1){
return (function cljs$core$go(level,node){
var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset(node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset(node__$1,subidx,cljs$core$go((level - (5)),cljs.core.pv_aget(node__$1,subidx)));

return node__$1;
}
});})(tcoll__$1))
.call(null,self__.shift,self__.root);
self__.root = new_root;

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return cljs.core._conj_BANG_(tcoll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds for TransientVector of length"),cljs.core.str(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
self__.cnt = (0);

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
self__.cnt = (self__.cnt - (1));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail(tcoll__$1,self__.shift,self__.root);
if(!((nr == null))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit,cljs.core.pv_aget(new_root,(0)));
self__.root = new_root__$1;

self__.shift = (self__.shift - (5));

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
} else {
self__.root = new_root;

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,n);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.call = (function() {
var G__24267 = null;
var G__24267__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__24267__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__24267 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__24267__2.call(this,self__,k);
case 3:
return G__24267__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24267.cljs$core$IFn$_invoke$arity$2 = G__24267__2;
G__24267.cljs$core$IFn$_invoke$arity$3 = G__24267__3;
return G__24267;
})()
;

cljs.core.TransientVector.prototype.apply = (function (self__,args24264){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args24264)));
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.TransientVector.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$cnt,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$shift,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$root,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$tail,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.TransientVector.cljs$lang$type = true;

cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";

cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/TransientVector");
});

cljs.core.__GT_TransientVector = (function cljs$core$__GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueIter = (function (fseq,riter){
this.fseq = fseq;
this.riter = riter;
})
cljs.core.PersistentQueueIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var or__6543__auto__ = (cljs.core.some_QMARK_(self__.fseq)) && (cljs.core.seq(self__.fseq));
if(or__6543__auto__){
return or__6543__auto__;
} else {
var and__6531__auto__ = cljs.core.some_QMARK_(self__.riter);
if(and__6531__auto__){
return self__.riter.hasNext();
} else {
return and__6531__auto__;
}
}
});

cljs.core.PersistentQueueIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if(cljs.core.some_QMARK_(self__.fseq)){
var ret = cljs.core.first(self__.fseq);
self__.fseq = cljs.core.next(self__.fseq);

return ret;
} else {
if((cljs.core.some_QMARK_(self__.riter)) && (self__.riter.hasNext())){
return self__.riter.next();
} else {
throw (new Error("No such element"));

}
}
});

cljs.core.PersistentQueueIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.PersistentQueueIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$fseq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$riter], null);
});

cljs.core.PersistentQueueIter.cljs$lang$type = true;

cljs.core.PersistentQueueIter.cljs$lang$ctorStr = "cljs.core/PersistentQueueIter";

cljs.core.PersistentQueueIter.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentQueueIter");
});

cljs.core.__GT_PersistentQueueIter = (function cljs$core$__GT_PersistentQueueIter(fseq,riter){
return (new cljs.core.PersistentQueueIter(fseq,riter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850572;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.PersistentQueueSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueueSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueueSeq.prototype.indexOf = (function() {
var G__24268 = null;
var G__24268__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__24268__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24268 = function(x,start){
switch(arguments.length){
case 1:
return G__24268__1.call(this,x);
case 2:
return G__24268__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24268.cljs$core$IFn$_invoke$arity$1 = G__24268__1;
G__24268.cljs$core$IFn$_invoke$arity$2 = G__24268__2;
return G__24268;
})()
;

cljs.core.PersistentQueueSeq.prototype.lastIndexOf = (function() {
var G__24269 = null;
var G__24269__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__24269__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24269 = function(x,start){
switch(arguments.length){
case 1:
return G__24269__1.call(this,x);
case 2:
return G__24269__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24269.cljs$core$IFn$_invoke$arity$1 = G__24269__1;
G__24269.cljs$core$IFn$_invoke$arity$2 = G__24269__2;
return G__24269;
})()
;

cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__4655__auto__ = cljs.core.next(self__.front);
if(temp__4655__auto__){
var f1 = temp__4655__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return cljs.core._empty(coll__$1);
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueSeq(meta__$1,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentQueueSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$front,cljs.core.cst$sym$rear,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentQueueSeq.cljs$lang$type = true;

cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";

cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentQueueSeq");
});

cljs.core.__GT_PersistentQueueSeq = (function cljs$core$__GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

(cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentQueue.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueue.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueue.prototype.indexOf = (function() {
var G__24270 = null;
var G__24270__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__24270__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24270 = function(x,start){
switch(arguments.length){
case 1:
return G__24270__1.call(this,x);
case 2:
return G__24270__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24270.cljs$core$IFn$_invoke$arity$1 = G__24270__1;
G__24270.cljs$core$IFn$_invoke$arity$2 = G__24270__2;
return G__24270;
})()
;

cljs.core.PersistentQueue.prototype.lastIndexOf = (function() {
var G__24271 = null;
var G__24271__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(self__.count.cljs$core$IFn$_invoke$arity$1 ? self__.count.cljs$core$IFn$_invoke$arity$1(coll) : self__.count.call(null,coll)));
});
var G__24271__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24271 = function(x,start){
switch(arguments.length){
case 1:
return G__24271__1.call(this,x);
case 2:
return G__24271__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24271.cljs$core$IFn$_invoke$arity$1 = G__24271__1;
G__24271.cljs$core$IFn$_invoke$arity$2 = G__24271__2;
return G__24271;
})()
;

cljs.core.PersistentQueue.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueIter(self__.front,cljs.core._iterator(self__.rear)));
});

cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__4655__auto__ = cljs.core.next(self__.front);
if(temp__4655__auto__){
var f1 = temp__4655__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq(self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentQueue.EMPTY,self__.meta);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest(cljs.core.seq(coll__$1));
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq(self__.rear);
if(cljs.core.truth_((function (){var or__6543__auto__ = self__.front;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq(rear__$1),null));
} else {
return null;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(meta__$1,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__6543__auto__ = self__.rear;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
});

cljs.core.PersistentQueue.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$count,cljs.core.cst$sym$front,cljs.core.cst$sym$rear,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentQueue.cljs$lang$type = true;

cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";

cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentQueue");
});

cljs.core.__GT_PersistentQueue = (function cljs$core$__GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash));
(cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition0$ = 2097152;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.NeverEquiv.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return false;
});

cljs.core.NeverEquiv.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.NeverEquiv.cljs$lang$type = true;

cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";

cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/NeverEquiv");
});

cljs.core.__GT_NeverEquiv = (function cljs$core$__GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
 * Assumes y is a map. Returns true if x equals y, otherwise returns
 *   false.
 */
cljs.core.equiv_map = (function cljs$core$equiv_map(x,y){
return cljs.core.boolean$(((cljs.core.map_QMARK_(y))?(((cljs.core.count(x) === cljs.core.count(y)))?cljs.core.every_QMARK_((function (xkv){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,cljs.core.first(xkv),cljs.core.never_equiv),cljs.core.second(xkv));
}),x):null):null));
});
cljs.core.scan_array = (function cljs$core$scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__24272 = (i + incr);
i = G__24272;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function cljs$core$obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash(a);
var b__$1 = cljs.core.hash(b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function cljs$core$obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta(m);
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__24273 = (i + (1));
var G__24274 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k__$1,(so[k__$1]));
i = G__24273;
out = G__24274;
continue;
} else {
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function cljs$core$obj_clone(obj,ks){
var new_obj = {};
var l = ks.length;
var i_24279 = (0);
while(true){
if((i_24279 < l)){
var k_24280 = (ks[i_24279]);
(new_obj[k_24280] = (obj[k_24280]));

var G__24281 = (i_24279 + (1));
i_24279 = G__24281;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
})
cljs.core.ObjMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ObjMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((goog.isString(k)) && (!((cljs.core.scan_array((1),k,self__.keys) == null)))){
return (self__.strobj[k]);
} else {
return not_found;
}
});

cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq(keys__$1)){
var k = cljs.core.first(keys__$1);
var init__$2 = (function (){var G__24284 = init__$1;
var G__24285 = k;
var G__24286 = (self__.strobj[k]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__24284,G__24285,G__24286) : f.call(null,G__24284,G__24285,G__24286));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__24287 = cljs.core.rest(keys__$1);
var G__24288 = init__$2;
keys__$1 = G__24287;
init__$1 = G__24288;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
});

cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1));
});

cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.ObjMap.EMPTY,self__.meta);
});

cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((goog.isString(k)) && (!((cljs.core.scan_array((1),k,self__.keys) == null)))){
var new_keys = cljs.core.aclone(self__.keys);
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array((1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(goog.isString(k)){
if(((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD))){
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
} else {
if(!((cljs.core.scan_array((1),k,self__.keys) == null))){
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
(new_strobj[k] = v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
var new_keys = cljs.core.aclone(self__.keys);
(new_strobj[k] = v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((goog.isString(k)) && (!((cljs.core.scan_array((1),k,self__.keys) == null)))){
return true;
} else {
return false;
}
});

cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (coll__$1){
return (function (p1__24282_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__24282_SHARP_,(self__.strobj[p1__24282_SHARP_])],null));
});})(coll__$1))
,self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
});

cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ObjMap(meta__$1,self__.keys,self__.strobj,self__.update_count,self__.__hash));
});

cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,coll__$1,entry);
}
});

cljs.core.ObjMap.prototype.call = (function() {
var G__24289 = null;
var G__24289__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__24289__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__24289 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__24289__2.call(this,self__,k);
case 3:
return G__24289__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24289.cljs$core$IFn$_invoke$arity$2 = G__24289__2;
G__24289.cljs$core$IFn$_invoke$arity$3 = G__24289__3;
return G__24289;
})()
;

cljs.core.ObjMap.prototype.apply = (function (self__,args24283){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args24283)));
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.ObjMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$keys,cljs.core.cst$sym$strobj,cljs.core.cst$sym$update_DASH_count,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ObjMap.cljs$lang$type = true;

cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";

cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ObjMap");
});

cljs.core.__GT_ObjMap = (function cljs$core$__GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],{},(0),cljs.core.empty_unordered_hash));
cljs.core.ObjMap.HASHMAP_THRESHOLD = (8);
cljs.core.ObjMap.fromObject = (function (ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
});

/**
* @constructor
*/
cljs.core.RecordIter = (function (i,record,base_count,fields,ext_map_iter){
this.i = i;
this.record = record;
this.base_count = base_count;
this.fields = fields;
this.ext_map_iter = ext_map_iter;
})
cljs.core.RecordIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var or__6543__auto__ = (self__.i < self__.base_count);
if(or__6543__auto__){
return or__6543__auto__;
} else {
return self__.ext_map_iter.hasNext();
}
});

cljs.core.RecordIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if((self__.i < self__.base_count)){
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.fields,self__.i);
self__.i = (self__.i + (1));

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.record,k)], null);
} else {
return self__.ext_map_iter.next();
}
});

cljs.core.RecordIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.RecordIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$record,cljs.core.cst$sym$base_DASH_count,cljs.core.cst$sym$fields,cljs.core.cst$sym$ext_DASH_map_DASH_iter], null);
});

cljs.core.RecordIter.cljs$lang$type = true;

cljs.core.RecordIter.cljs$lang$ctorStr = "cljs.core/RecordIter";

cljs.core.RecordIter.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/RecordIter");
});

cljs.core.__GT_RecordIter = (function cljs$core$__GT_RecordIter(i,record,base_count,fields,ext_map_iter){
return (new cljs.core.RecordIter(i,record,base_count,fields,ext_map_iter));
});


/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6EntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var vec__24292 = cljs.core.first(self__.s);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24292,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24292,(1),null);
self__.s = cljs.core.next(self__.s);

return ({"value": [k,v], "done": false});
} else {
return ({"value": null, "done": true});
}
});

cljs.core.ES6EntriesIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ES6EntriesIterator.cljs$lang$type = true;

cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";

cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ES6EntriesIterator");
});

cljs.core.__GT_ES6EntriesIterator = (function cljs$core$__GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function cljs$core$es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6SetEntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return ({"value": [x,x], "done": false});
} else {
return ({"value": null, "done": true});
}
});

cljs.core.ES6SetEntriesIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ES6SetEntriesIterator");
});

cljs.core.__GT_ES6SetEntriesIterator = (function cljs$core$__GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function cljs$core$es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll)));
});
cljs.core.array_index_of_nil_QMARK_ = (function cljs$core$array_index_of_nil_QMARK_(arr){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__24295 = (i + (2));
i = G__24295;
continue;

}
}
break;
}
});
cljs.core.array_index_of_keyword_QMARK_ = (function cljs$core$array_index_of_keyword_QMARK_(arr,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((((arr[i]) instanceof cljs.core.Keyword)) && ((kstr === (arr[i]).fqn))){
return i;
} else {
var G__24296 = (i + (2));
i = G__24296;
continue;

}
}
break;
}
});
cljs.core.array_index_of_symbol_QMARK_ = (function cljs$core$array_index_of_symbol_QMARK_(arr,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((((arr[i]) instanceof cljs.core.Symbol)) && ((kstr === (arr[i]).str))){
return i;
} else {
var G__24297 = (i + (2));
i = G__24297;
continue;

}
}
break;
}
});
cljs.core.array_index_of_identical_QMARK_ = (function cljs$core$array_index_of_identical_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__24298 = (i + (2));
i = G__24298;
continue;

}
}
break;
}
});
cljs.core.array_index_of_equiv_QMARK_ = (function cljs$core$array_index_of_equiv_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(arr[i]))){
return i;
} else {
var G__24299 = (i + (2));
i = G__24299;
continue;

}
}
break;
}
});
cljs.core.array_index_of = (function cljs$core$array_index_of(arr,k){
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_index_of_keyword_QMARK_(arr,k);
} else {
if((goog.isString(k)) || (typeof k === 'number')){
return cljs.core.array_index_of_identical_QMARK_(arr,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_index_of_symbol_QMARK_(arr,k);
} else {
if((k == null)){
return cljs.core.array_index_of_nil_QMARK_(arr);
} else {
return cljs.core.array_index_of_equiv_QMARK_(arr,k);

}
}
}
}
});
cljs.core.array_map_index_of = (function cljs$core$array_map_index_of(m,k){
return cljs.core.array_index_of(m.arr,k);
});
cljs.core.array_extend_kv = (function cljs$core$array_extend_kv(arr,k,v){
var l = arr.length;
var narr = (new Array((l + (2))));
var i_24300 = (0);
while(true){
if((i_24300 < l)){
(narr[i_24300] = (arr[i_24300]));

var G__24301 = (i_24300 + (1));
i_24300 = G__24301;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});
cljs.core.array_map_extend_kv = (function cljs$core$array_map_extend_kv(m,k,v){
return cljs.core.array_extend_kv(m.arr,k,v);
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.PersistentArrayMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMapSeq.prototype.indexOf = (function() {
var G__24302 = null;
var G__24302__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__24302__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24302 = function(x,start){
switch(arguments.length){
case 1:
return G__24302__1.call(this,x);
case 2:
return G__24302__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24302.cljs$core$IFn$_invoke$arity$1 = G__24302__1;
G__24302.cljs$core$IFn$_invoke$arity$2 = G__24302__2;
return G__24302;
})()
;

cljs.core.PersistentArrayMapSeq.prototype.lastIndexOf = (function() {
var G__24303 = null;
var G__24303__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__24303__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24303 = function(x,start){
switch(arguments.length){
case 1:
return G__24303__1.call(this,x);
case 2:
return G__24303__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24303.cljs$core$IFn$_invoke$arity$1 = G__24303__1;
G__24303.cljs$core$IFn$_invoke$arity$2 = G__24303__2;
return G__24303;
})()
;

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return null;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentArrayMapSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$_meta], null);
});

cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentArrayMapSeq");
});

cljs.core.__GT_PersistentArrayMapSeq = (function cljs$core$__GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

(cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
cljs.core.persistent_array_map_seq = (function cljs$core$persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});


/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
})
cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
});

cljs.core.PersistentArrayMapIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
self__.i = (self__.i + (2));

return ret;
});

cljs.core.PersistentArrayMapIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$cnt], null);
});

cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentArrayMapIterator");
});

cljs.core.__GT_PersistentArrayMapIterator = (function cljs$core$__GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentArrayMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null,coll)));
});

cljs.core.PersistentArrayMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentArrayMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null,coll)));
});

cljs.core.PersistentArrayMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentArrayMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__24305 = cljs.core.seq(coll);
var chunk__24306 = null;
var count__24307 = (0);
var i__24308 = (0);
while(true){
if((i__24308 < count__24307)){
var vec__24309 = chunk__24306.cljs$core$IIndexed$_nth$arity$2(null,i__24308);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24309,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24309,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__24322 = seq__24305;
var G__24323 = chunk__24306;
var G__24324 = count__24307;
var G__24325 = (i__24308 + (1));
seq__24305 = G__24322;
chunk__24306 = G__24323;
count__24307 = G__24324;
i__24308 = G__24325;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__24305);
if(temp__4657__auto__){
var seq__24305__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__24305__$1)){
var c__7357__auto__ = cljs.core.chunk_first(seq__24305__$1);
var G__24326 = cljs.core.chunk_rest(seq__24305__$1);
var G__24327 = c__7357__auto__;
var G__24328 = cljs.core.count(c__7357__auto__);
var G__24329 = (0);
seq__24305 = G__24326;
chunk__24306 = G__24327;
count__24307 = G__24328;
i__24308 = G__24329;
continue;
} else {
var vec__24312 = cljs.core.first(seq__24305__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24312,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24312,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__24330 = cljs.core.next(seq__24305__$1);
var G__24331 = null;
var G__24332 = (0);
var G__24333 = (0);
seq__24305 = G__24330;
chunk__24306 = G__24331;
count__24307 = G__24332;
i__24308 = G__24333;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var G__24315 = init__$1;
var G__24316 = (self__.arr[i]);
var G__24317 = (self__.arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__24315,G__24316,G__24317) : f.call(null,G__24315,G__24316,G__24317));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__24334 = (i + (2));
var G__24335 = init__$2;
i = G__24334;
init__$1 = G__24335;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if(((!((other == null)))?((((other.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === other.cljs$core$IMap$)))?true:false):false)){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null))){
var i = (0);
while(true){
if((i < alen)){
var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null,(self__.arr[i]),cljs.core.lookup_sentinel);
if(!((v === cljs.core.lookup_sentinel))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(i + (1))]),v)){
var G__24336 = (i + (2));
i = G__24336;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_map(coll__$1,other);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap({},self__.arr.length,cljs.core.aclone(self__.arr)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY,self__.meta);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return cljs.core._empty(coll__$1);
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(self__.arr[s]))){
var G__24337 = (s + (2));
var G__24338 = d;
s = G__24337;
d = G__24338;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__24339 = (s + (2));
var G__24340 = (d + (2));
s = G__24339;
d = G__24340;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv(coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__24321 = cljs.core.aclone(self__.arr);
(G__24321[(idx + (1))] = v);

return G__24321;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((cljs.core.array_map_index_of(coll__$1,k) === (-1)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq(self__.arr,(0),null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMap(meta__$1,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__24341 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__24342 = cljs.core.next(es);
ret = G__24341;
es = G__24342;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentArrayMap.prototype.call = (function() {
var G__24343 = null;
var G__24343__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__24343__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__24343 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__24343__2.call(this,self__,k);
case 3:
return G__24343__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24343.cljs$core$IFn$_invoke$arity$2 = G__24343__2;
G__24343.cljs$core$IFn$_invoke$arity$3 = G__24343__3;
return G__24343;
})()
;

cljs.core.PersistentArrayMap.prototype.apply = (function (self__,args24304){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args24304)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$cnt,cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentArrayMap.cljs$lang$type = true;

cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";

cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentArrayMap");
});

cljs.core.__GT_PersistentArrayMap = (function cljs$core$__GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash));
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8);
cljs.core.PersistentArrayMap.fromArray = (function (arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var arr__$2 = ((no_check)?arr__$1:(function (){var ret = [];
var i_24344 = (0);
while(true){
if((i_24344 < arr__$1.length)){
var k_24345 = (arr__$1[i_24344]);
var v_24346 = (arr__$1[(i_24344 + (1))]);
var idx_24347 = cljs.core.array_index_of(ret,k_24345);
if((idx_24347 === (-1))){
ret.push(k_24345);

ret.push(v_24346);
} else {
}

var G__24348 = (i_24344 + (2));
i_24344 = G__24348;
continue;
} else {
}
break;
}

return ret;
})());
var cnt = (arr__$2.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$2,null));
});
(cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition0$ = 258;
this.cljs$lang$protocol_mask$partition1$ = 56;
})
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
return cljs.core.quot(self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,k,null);
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMapEntry$)))?true:(((!o.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,o):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,o))){
return cljs.core._assoc_BANG_(tcoll__$1,(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.key.call(null,o)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.val.call(null,o)));
} else {
var es = cljs.core.seq(o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__4655__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4655__auto__)){
var e = temp__4655__auto__;
var G__24351 = cljs.core.next(es);
var G__24352 = cljs.core._assoc_BANG_(tcoll__$2,(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null,e)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null,e)));
es = G__24351;
tcoll__$2 = G__24352;
continue;
} else {
return tcoll__$2;
}
break;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
self__.editable_QMARK_ = false;

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot(self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
self__.len = (self__.len + (2));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(self__.len,self__.arr) : cljs.core.array__GT_transient_hash_map.call(null,self__.len,self__.arr)),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__24350_24353 = self__.arr;
G__24350_24353.pop();

G__24350_24353.pop();


self__.len = (self__.len - (2));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$editable_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$len,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$arr], null);
});

cljs.core.TransientArrayMap.cljs$lang$type = true;

cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";

cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/TransientArrayMap");
});

cljs.core.__GT_TransientArrayMap = (function cljs$core$__GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});


cljs.core.array__GT_transient_hash_map = (function cljs$core$array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__24354 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,(arr[i]),(arr[(i + (1))]));
var G__24355 = (i + (2));
out = G__24354;
i = G__24355;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
})

cljs.core.Box.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Box.cljs$lang$type = true;

cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";

cljs.core.Box.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/Box");
});

cljs.core.__GT_Box = (function cljs$core$__GT_Box(val){
return (new cljs.core.Box(val));
});






cljs.core.key_test = (function cljs$core$key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_(key,other)){
return true;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,other);

}
}
});
cljs.core.mask = (function cljs$core$mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function cljs$core$clone_and_set(var_args){
var args24356 = [];
var len__7651__auto___24361 = arguments.length;
var i__7652__auto___24362 = (0);
while(true){
if((i__7652__auto___24362 < len__7651__auto___24361)){
args24356.push((arguments[i__7652__auto___24362]));

var G__24363 = (i__7652__auto___24362 + (1));
i__7652__auto___24362 = G__24363;
continue;
} else {
}
break;
}

var G__24358 = args24356.length;
switch (G__24358) {
case 3:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24356.length)].join('')));

}
});

cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = (function (arr,i,a){
var G__24359 = cljs.core.aclone(arr);
(G__24359[i] = a);

return G__24359;
});

cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = (function (arr,i,a,j,b){
var G__24360 = cljs.core.aclone(arr);
(G__24360[i] = a);

(G__24360[j] = b);

return G__24360;
});

cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5;

cljs.core.remove_pair = (function cljs$core$remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy(arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy(arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function cljs$core$bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count((bitmap & (bit - (1))));
});
cljs.core.bitpos = (function cljs$core$bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function cljs$core$edit_and_set(var_args){
var args24365 = [];
var len__7651__auto___24368 = arguments.length;
var i__7652__auto___24369 = (0);
while(true){
if((i__7652__auto___24369 < len__7651__auto___24368)){
args24365.push((arguments[i__7652__auto___24369]));

var G__24370 = (i__7652__auto___24369 + (1));
i__7652__auto___24369 = G__24370;
continue;
} else {
}
break;
}

var G__24367 = args24365.length;
switch (G__24367) {
case 4:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24365.length)].join('')));

}
});

cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = (function (inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
});

cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = (function (inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
});

cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6;

cljs.core.inode_kv_reduce = (function cljs$core$inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if(!((k == null))){
var G__24375 = init__$1;
var G__24376 = k;
var G__24377 = (arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__24375,G__24376,G__24377) : f.call(null,G__24375,G__24376,G__24377));
} else {
var node = (arr[(i + (1))]);
if(!((node == null))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__24378 = (i + (2));
var G__24379 = init__$2;
i = G__24378;
init__$1 = G__24379;
continue;
}
} else {
return init__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.NodeIterator = (function (arr,i,next_entry,next_iter){
this.arr = arr;
this.i = i;
this.next_entry = next_entry;
this.next_iter = next_iter;
})
cljs.core.NodeIterator.prototype.advance = (function (){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((self__.i < len)){
var key = (self__.arr[self__.i]);
var node_or_val = (self__.arr[(self__.i + (1))]);
var found = ((cljs.core.some_QMARK_(key))?self__.next_entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key,node_or_val], null):((cljs.core.some_QMARK_(node_or_val))?(function (){var new_iter = cljs.core._iterator(node_or_val);
if(new_iter.hasNext()){
return self__.next_iter = new_iter;
} else {
return false;
}
})():false
));
self__.i = (self__.i + (2));

if(found){
return true;
} else {
continue;
}
} else {
return false;
}
break;
}
});

cljs.core.NodeIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
var or__6543__auto__ = cljs.core.some_QMARK_(self__.next_entry);
if(or__6543__auto__){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = cljs.core.some_QMARK_(self__.next_iter);
if(or__6543__auto____$1){
return or__6543__auto____$1;
} else {
return this$.advance();
}
}
});

cljs.core.NodeIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(cljs.core.some_QMARK_(self__.next_entry)){
var ret = self__.next_entry;
self__.next_entry = null;

return ret;
} else {
if(cljs.core.some_QMARK_(self__.next_iter)){
var ret = self__.next_iter.next();
if(self__.next_iter.hasNext()){
} else {
self__.next_iter = null;
}

return ret;
} else {
if(this$.advance()){
return this$.next();
} else {
throw (new Error("No such element"));

}
}
}
});

cljs.core.NodeIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.NodeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next_DASH_entry,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next_DASH_iter,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.NodeIterator.cljs$lang$type = true;

cljs.core.NodeIterator.cljs$lang$ctorStr = "cljs.core/NodeIterator";

cljs.core.NodeIterator.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/NodeIterator");
});

cljs.core.__GT_NodeIterator = (function cljs$core$__GT_NodeIterator(arr,i,next_entry,next_iter){
return (new cljs.core.NodeIterator(arr,i,next_entry,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
})
cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count(self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
(removed_leaf_QMARK_[(0)] = true);

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function (e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
editable.bitmap = (bit ^ editable.bitmap);

cljs.core.array_copy(earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
});

cljs.core.BitmapIndexedNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_inode_seq.call(null,self__.arr));
});

cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
added_leaf_QMARK_.val = true;

cljs.core.array_copy_downward(earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

editable.bitmap = (editable.bitmap | bit);

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_24393 = (0);
var j_24394 = (0);
while(true){
if((i_24393 < (32))){
if((((self__.bitmap >>> i_24393) & (1)) === (0))){
var G__24395 = (i_24393 + (1));
var G__24396 = j_24394;
i_24393 = G__24395;
j_24394 = G__24396;
continue;
} else {
(nodes[i_24393] = ((!(((self__.arr[j_24394]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash((self__.arr[j_24394])),(self__.arr[j_24394]),(self__.arr[(j_24394 + (1))]),added_leaf_QMARK_):(self__.arr[(j_24394 + (1))])));

var G__24397 = (i_24393 + (1));
var G__24398 = (j_24394 + (2));
i_24393 = G__24397;
j_24394 = G__24398;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

var editable = inode.ensure_editable(edit__$1);
editable.arr = new_arr;

editable.bitmap = (editable.bitmap | bit);

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
added_leaf_QMARK_.val = true;

return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__24380 = edit__$1;
var G__24381 = (shift + (5));
var G__24382 = key_or_nil;
var G__24383 = val_or_node;
var G__24384 = hash;
var G__24385 = key;
var G__24386 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__24380,G__24381,G__24382,G__24383,G__24384,G__24385,G__24386) : cljs.core.create_node.call(null,G__24380,G__24381,G__24382,G__24383,G__24384,G__24385,G__24386));
})());

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_24399 = (0);
var j_24400 = (0);
while(true){
if((i_24399 < (32))){
if((((self__.bitmap >>> i_24399) & (1)) === (0))){
var G__24401 = (i_24399 + (1));
var G__24402 = j_24400;
i_24399 = G__24401;
j_24400 = G__24402;
continue;
} else {
(nodes[i_24399] = ((!(((self__.arr[j_24400]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash((self__.arr[j_24400])),(self__.arr[j_24400]),(self__.arr[(j_24400 + (1))]),added_leaf_QMARK_):(self__.arr[(j_24400 + (1))])));

var G__24403 = (i_24399 + (1));
var G__24404 = (j_24400 + (2));
i_24399 = G__24403;
j_24400 = G__24404;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),val)));
}
} else {
added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__24387 = (shift + (5));
var G__24388 = key_or_nil;
var G__24389 = val_or_node;
var G__24390 = hash;
var G__24391 = key;
var G__24392 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__24387,G__24388,G__24389,G__24390,G__24391,G__24392) : cljs.core.create_node.call(null,G__24387,G__24388,G__24389,G__24390,G__24391,G__24392));
})())));

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_or_nil,val_or_node], null);
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
});

cljs.core.BitmapIndexedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.with_meta(cljs.core.cst$sym$bitmap,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.BitmapIndexedNode.cljs$lang$type = true;

cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode";

cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/BitmapIndexedNode");
});

cljs.core.__GT_BitmapIndexedNode = (function cljs$core$__GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[]));
cljs.core.pack_array_node = (function cljs$core$pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((!((i === idx))) && (!(((arr[i]) == null)))){
(new_arr[j] = (arr[i]));

var G__24405 = (i + (1));
var G__24406 = (j + (2));
var G__24407 = (bitmap | ((1) << i));
i = G__24405;
j = G__24406;
bitmap = G__24407;
continue;
} else {
var G__24408 = (i + (1));
var G__24409 = j;
var G__24410 = bitmap;
i = G__24408;
j = G__24409;
bitmap = G__24410;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNodeIterator = (function (arr,i,next_iter){
this.arr = arr;
this.i = i;
this.next_iter = next_iter;
})
cljs.core.ArrayNodeIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if(!((cljs.core.some_QMARK_(self__.next_iter)) && (self__.next_iter.hasNext()))){
if((self__.i < len)){
var node = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

if(cljs.core.some_QMARK_(node)){
self__.next_iter = cljs.core._iterator(node);
} else {
}

continue;
} else {
return false;
}
} else {
return true;
}
break;
}
});

cljs.core.ArrayNodeIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
return self__.next_iter.next();
} else {
throw (new Error("No such element"));
}
});

cljs.core.ArrayNodeIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.ArrayNodeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next_DASH_iter,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayNodeIterator.cljs$lang$type = true;

cljs.core.ArrayNodeIterator.cljs$lang$ctorStr = "cljs.core/ArrayNodeIterator";

cljs.core.ArrayNodeIterator.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ArrayNodeIterator");
});

cljs.core.__GT_ArrayNodeIterator = (function cljs$core$__GT_ArrayNodeIterator(arr,i,next_iter){
return (new cljs.core.ArrayNodeIterator(arr,i,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.ArrayNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone(self__.arr)));
}
});

cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
editable.cnt = (editable.cnt - (1));

return editable;
}
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);

}
}
}
});

cljs.core.ArrayNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_array_node_seq.call(null,self__.arr));
});

cljs.core.ArrayNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if(!((node == null))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__24411 = (i + (1));
var G__24412 = init__$2;
i = G__24411;
init__$1 = G__24412;
continue;
}
} else {
var G__24413 = (i + (1));
var G__24414 = init__$1;
i = G__24413;
init__$1 = G__24414;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ArrayNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
editable.cnt = (editable.cnt + (1));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
}
}
});

cljs.core.ArrayNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
}
});

cljs.core.ArrayNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));

}
}
} else {
return inode;
}
});

cljs.core.ArrayNode.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.ArrayNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeIterator(self__.arr,(0),null));
});

cljs.core.ArrayNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.with_meta(cljs.core.cst$sym$cnt,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayNode.cljs$lang$type = true;

cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode";

cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ArrayNode");
});

cljs.core.__GT_ArrayNode = (function cljs$core$__GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function cljs$core$hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test(key,(arr[i]))){
return i;
} else {
var G__24415 = (i + (2));
i = G__24415;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.HashCollisionNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
});

cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
(removed_leaf_QMARK_[(0)] = true);

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

editable.cnt = (editable.cnt - (1));

return editable;
}
}
});

cljs.core.HashCollisionNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_inode_seq.call(null,self__.arr));
});

cljs.core.HashCollisionNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.HashCollisionNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (self__.arr[(idx + (1))]);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
added_leaf_QMARK_.val = true;

editable.cnt = (editable.cnt + (1));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(idx + (1))]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function (e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
self__.arr = array;

self__.cnt = count;

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
});

cljs.core.HashCollisionNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[idx]),(self__.arr[(idx + (1))])], null);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair(self__.arr,cljs.core.quot(idx,(2)))));

}
}
});

cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
});

cljs.core.HashCollisionNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.with_meta(cljs.core.cst$sym$collision_DASH_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$cnt,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.HashCollisionNode.cljs$lang$type = true;

cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode";

cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/HashCollisionNode");
});

cljs.core.__GT_HashCollisionNode = (function cljs$core$__GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function cljs$core$create_node(var_args){
var args24416 = [];
var len__7651__auto___24419 = arguments.length;
var i__7652__auto___24420 = (0);
while(true){
if((i__7652__auto___24420 < len__7651__auto___24419)){
args24416.push((arguments[i__7652__auto___24420]));

var G__24421 = (i__7652__auto___24420 + (1));
i__7652__auto___24420 = G__24421;
continue;
} else {
}
break;
}

var G__24418 = args24416.length;
switch (G__24418) {
case 6:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24416.length)].join('')));

}
});

cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = (function (shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});

cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = (function (edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});

cljs.core.create_node.cljs$lang$maxFixedArity = 7;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.NodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.NodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NodeSeq.prototype.indexOf = (function() {
var G__24429 = null;
var G__24429__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__24429__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24429 = function(x,start){
switch(arguments.length){
case 1:
return G__24429__1.call(this,x);
case 2:
return G__24429__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24429.cljs$core$IFn$_invoke$arity$1 = G__24429__1;
G__24429.cljs$core$IFn$_invoke$arity$2 = G__24429__2;
return G__24429;
})()
;

cljs.core.NodeSeq.prototype.lastIndexOf = (function() {
var G__24430 = null;
var G__24430__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__24430__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24430 = function(x,start){
switch(arguments.length){
case 1:
return G__24430__1.call(this,x);
case 2:
return G__24430__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24430.cljs$core$IFn$_invoke$arity$1 = G__24430__1;
G__24430.cljs$core$IFn$_invoke$arity$2 = G__24430__2;
return G__24430;
})()
;

cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))])], null);
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var ret = (((self__.s == null))?(function (){var G__24423 = self__.nodes;
var G__24424 = (self__.i + (2));
var G__24425 = null;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__24423,G__24424,G__24425) : cljs.core.create_inode_seq.call(null,G__24423,G__24424,G__24425));
})():(function (){var G__24426 = self__.nodes;
var G__24427 = self__.i;
var G__24428 = cljs.core.next(self__.s);
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__24426,G__24427,G__24428) : cljs.core.create_inode_seq.call(null,G__24426,G__24427,G__24428));
})());
if(!((ret == null))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.NodeSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$nodes,cljs.core.cst$sym$i,cljs.core.cst$sym$s,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.NodeSeq.cljs$lang$type = true;

cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq";

cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/NodeSeq");
});

cljs.core.__GT_NodeSeq = (function cljs$core$__GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
cljs.core.create_inode_seq = (function cljs$core$create_inode_seq(var_args){
var args24431 = [];
var len__7651__auto___24434 = arguments.length;
var i__7652__auto___24435 = (0);
while(true){
if((i__7652__auto___24435 < len__7651__auto___24434)){
args24431.push((arguments[i__7652__auto___24435]));

var G__24436 = (i__7652__auto___24435 + (1));
i__7652__auto___24435 = G__24436;
continue;
} else {
}
break;
}

var G__24433 = args24431.length;
switch (G__24433) {
case 1:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24431.length)].join('')));

}
});

cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
});

cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if(!(((nodes[j]) == null))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__4655__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__4655__auto__)){
var node = temp__4655__auto__;
var temp__4655__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__4655__auto____$1)){
var node_seq = temp__4655__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__24438 = (j + (2));
j = G__24438;
continue;
}
} else {
var G__24439 = (j + (2));
j = G__24439;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
});

cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ArrayNodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ArrayNodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ArrayNodeSeq.prototype.indexOf = (function() {
var G__24444 = null;
var G__24444__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__24444__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24444 = function(x,start){
switch(arguments.length){
case 1:
return G__24444__1.call(this,x);
case 2:
return G__24444__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24444.cljs$core$IFn$_invoke$arity$1 = G__24444__1;
G__24444.cljs$core$IFn$_invoke$arity$2 = G__24444__2;
return G__24444;
})()
;

cljs.core.ArrayNodeSeq.prototype.lastIndexOf = (function() {
var G__24445 = null;
var G__24445__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__24445__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24445 = function(x,start){
switch(arguments.length){
case 1:
return G__24445__1.call(this,x);
case 2:
return G__24445__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24445.cljs$core$IFn$_invoke$arity$1 = G__24445__1;
G__24445.cljs$core$IFn$_invoke$arity$2 = G__24445__2;
return G__24445;
})()
;

cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.s);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var ret = (function (){var G__24440 = null;
var G__24441 = self__.nodes;
var G__24442 = self__.i;
var G__24443 = cljs.core.next(self__.s);
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(G__24440,G__24441,G__24442,G__24443) : cljs.core.create_array_node_seq.call(null,G__24440,G__24441,G__24442,G__24443));
})();
if(!((ret == null))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ArrayNodeSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$nodes,cljs.core.cst$sym$i,cljs.core.cst$sym$s,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayNodeSeq.cljs$lang$type = true;

cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq";

cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ArrayNodeSeq");
});

cljs.core.__GT_ArrayNodeSeq = (function cljs$core$__GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
cljs.core.create_array_node_seq = (function cljs$core$create_array_node_seq(var_args){
var args24446 = [];
var len__7651__auto___24449 = arguments.length;
var i__7652__auto___24450 = (0);
while(true){
if((i__7652__auto___24450 < len__7651__auto___24449)){
args24446.push((arguments[i__7652__auto___24450]));

var G__24451 = (i__7652__auto___24450 + (1));
i__7652__auto___24450 = G__24451;
continue;
} else {
}
break;
}

var G__24448 = args24446.length;
switch (G__24448) {
case 1:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24446.length)].join('')));

}
});

cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(null,nodes,(0),null);
});

cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 = (function (meta,nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__4655__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__4655__auto__)){
var nj = temp__4655__auto__;
var temp__4655__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__4655__auto____$1)){
var ns = temp__4655__auto____$1;
return (new cljs.core.ArrayNodeSeq(meta,nodes,(j + (1)),ns,null));
} else {
var G__24453 = (j + (1));
j = G__24453;
continue;
}
} else {
var G__24454 = (j + (1));
j = G__24454;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,null));
}
});

cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 4;


/**
* @constructor
*/
cljs.core.HashMapIter = (function (nil_val,root_iter,seen){
this.nil_val = nil_val;
this.root_iter = root_iter;
this.seen = seen;
})
cljs.core.HashMapIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (cljs.core.not(self__.seen)) || (self__.root_iter.hasNext());
});

cljs.core.HashMapIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!(self__.seen)){
self__.seen = true;

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,self__.nil_val], null);
} else {
return self__.root_iter.next();
}
});

cljs.core.HashMapIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.HashMapIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$nil_DASH_val,cljs.core.cst$sym$root_DASH_iter,cljs.core.with_meta(cljs.core.cst$sym$seen,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.HashMapIter.cljs$lang$type = true;

cljs.core.HashMapIter.cljs$lang$ctorStr = "cljs.core/HashMapIter";

cljs.core.HashMapIter.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/HashMapIter");
});

cljs.core.__GT_HashMapIter = (function cljs$core$__GT_HashMapIter(nil_val,root_iter,seen){
return (new cljs.core.HashMapIter(nil_val,root_iter,seen));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null,coll)));
});

cljs.core.PersistentHashMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null,coll)));
});

cljs.core.PersistentHashMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__24456 = cljs.core.seq(coll);
var chunk__24457 = null;
var count__24458 = (0);
var i__24459 = (0);
while(true){
if((i__24459 < count__24458)){
var vec__24460 = chunk__24457.cljs$core$IIndexed$_nth$arity$2(null,i__24459);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24460,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24460,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__24468 = seq__24456;
var G__24469 = chunk__24457;
var G__24470 = count__24458;
var G__24471 = (i__24459 + (1));
seq__24456 = G__24468;
chunk__24457 = G__24469;
count__24458 = G__24470;
i__24459 = G__24471;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__24456);
if(temp__4657__auto__){
var seq__24456__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__24456__$1)){
var c__7357__auto__ = cljs.core.chunk_first(seq__24456__$1);
var G__24472 = cljs.core.chunk_rest(seq__24456__$1);
var G__24473 = c__7357__auto__;
var G__24474 = cljs.core.count(c__7357__auto__);
var G__24475 = (0);
seq__24456 = G__24472;
chunk__24457 = G__24473;
count__24458 = G__24474;
i__24459 = G__24475;
continue;
} else {
var vec__24463 = cljs.core.first(seq__24456__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24463,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24463,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__24476 = cljs.core.next(seq__24456__$1);
var G__24477 = null;
var G__24478 = (0);
var G__24479 = (0);
seq__24456 = G__24476;
chunk__24457 = G__24477;
count__24458 = G__24478;
i__24459 = G__24479;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(init,null,self__.nil_val) : f.call(null,init,null,self__.nil_val)):init);
if(cljs.core.reduced_QMARK_(init__$1)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$1) : cljs.core.deref.call(null,init__$1));
} else {
if(!((self__.root == null))){
return self__.root.kv_reduce(f,init__$1);
} else {
return init__$1;

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var root_iter = ((self__.root)?cljs.core._iterator(self__.root):cljs.core.nil_iter());
if(self__.has_nil_QMARK_){
return (new cljs.core.HashMapIter(self__.nil_val,root_iter,false));
} else {
return root_iter;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap({},self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY,self__.meta);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash(k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if((self__.has_nil_QMARK_) && ((v === self__.nil_val))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return !((self__.root.inode_lookup((0),cljs.core.hash(k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel));

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = ((!((self__.root == null)))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,self__.nil_val], null),s);
} else {
return s;
}
} else {
return null;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashMap(meta__$1,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__24480 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__24481 = cljs.core.next(es);
ret = G__24480;
es = G__24481;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentHashMap.prototype.call = (function() {
var G__24482 = null;
var G__24482__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__24482__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__24482 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__24482__2.call(this,self__,k);
case 3:
return G__24482__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24482.cljs$core$IFn$_invoke$arity$2 = G__24482__2;
G__24482.cljs$core$IFn$_invoke$arity$3 = G__24482__3;
return G__24482;
})()
;

cljs.core.PersistentHashMap.prototype.apply = (function (self__,args24455){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args24455)));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$cnt,cljs.core.cst$sym$root,cljs.core.with_meta(cljs.core.cst$sym$has_DASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null)),cljs.core.cst$sym$nil_DASH_val,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentHashMap.cljs$lang$type = true;

cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap";

cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentHashMap");
});

cljs.core.__GT_PersistentHashMap = (function cljs$core$__GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashMap.fromArray = (function (arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__24483 = (i + (2));
var G__24484 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__24483;
ret = G__24484;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
});
cljs.core.PersistentHashMap.fromArrays = (function (ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__24485 = (i + (1));
var G__24486 = out.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(ks[i]),(vs[i]));
i = G__24485;
out = G__24486;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});
(cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition0$ = 258;
this.cljs$lang$protocol_mask$partition1$ = 56;
})
cljs.core.TransientHashMap.prototype.conj_BANG_ = (function (o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMapEntry$)))?true:(((!o.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,o):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,o))){
return tcoll.assoc_BANG_((cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.key.call(null,o)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.val.call(null,o)));
} else {
var es = cljs.core.seq(o);
var tcoll__$1 = tcoll;
while(true){
var temp__4655__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4655__auto__)){
var e = temp__4655__auto__;
var G__24488 = cljs.core.next(es);
var G__24489 = tcoll__$1.assoc_BANG_((cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null,e)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null,e)));
es = G__24488;
tcoll__$1 = G__24489;
continue;
} else {
return tcoll__$1;
}
break;
}
}
} else {
throw (new Error("conj! after persistent"));
}
});

cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function (k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
self__.nil_val = v;
}

if(self__.has_nil_QMARK_){
} else {
self__.count = (self__.count + (1));

self__.has_nil_QMARK_ = true;
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(added_leaf_QMARK_.val){
self__.count = (self__.count + (1));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.without_BANG_ = (function (k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
self__.has_nil_QMARK_ = false;

self__.nil_val = null;

self__.count = (self__.count - (1));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash(k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(cljs.core.truth_((removed_leaf_QMARK_[(0)]))){
self__.count = (self__.count - (1));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function (){
var self__ = this;
var tcoll = this;
if(self__.edit){
self__.edit = null;

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
});

cljs.core.TransientHashMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$edit,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$root,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$count,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$has_DASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$nil_DASH_val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.TransientHashMap.cljs$lang$type = true;

cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap";

cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/TransientHashMap");
});

cljs.core.__GT_TransientHashMap = (function cljs$core$__GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function cljs$core$tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if(!((t == null))){
var G__24490 = ((ascending_QMARK_)?t.left:t.right);
var G__24491 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,t);
t = G__24490;
stack__$1 = G__24491;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374862;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.PersistentTreeMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMapSeq.prototype.indexOf = (function() {
var G__24492 = null;
var G__24492__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__24492__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24492 = function(x,start){
switch(arguments.length){
case 1:
return G__24492__1.call(this,x);
case 2:
return G__24492__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24492.cljs$core$IFn$_invoke$arity$1 = G__24492__1;
G__24492.cljs$core$IFn$_invoke$arity$2 = G__24492__2;
return G__24492;
})()
;

cljs.core.PersistentTreeMapSeq.prototype.lastIndexOf = (function() {
var G__24493 = null;
var G__24493__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__24493__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24493 = function(x,start){
switch(arguments.length){
case 1:
return G__24493__1.call(this,x);
case 2:
return G__24493__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24493.cljs$core$IFn$_invoke$arity$1 = G__24493__1;
G__24493.cljs$core$IFn$_invoke$arity$2 = G__24493__2;
return G__24493;
})()
;

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count(cljs.core.next(coll__$1)) + (1));
} else {
return self__.cnt;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek(self__.stack);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if(!((next_stack == null))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMapSeq(meta__$1,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentTreeMapSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$stack,cljs.core.with_meta(cljs.core.cst$sym$ascending_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null)),cljs.core.cst$sym$cnt,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq";

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentTreeMapSeq");
});

cljs.core.__GT_PersistentTreeMapSeq = (function cljs$core$__GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

(cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
cljs.core.create_tree_map_seq = (function cljs$core$create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push(tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});

cljs.core.balance_left = (function cljs$core$balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function cljs$core$balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function cljs$core$balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right(key,val,del,right.redden());
} else {
if(((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right(right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function cljs$core$balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left(key,val,left.redden(),del);
} else {
if(((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left(left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function cljs$core$tree_map_kv_reduce(node,f,init){
var init__$1 = ((!((node.left == null)))?(function (){var G__24503 = node.left;
var G__24504 = f;
var G__24505 = init;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__24503,G__24504,G__24505) : cljs.core.tree_map_kv_reduce.call(null,G__24503,G__24504,G__24505));
})():init);
if(cljs.core.reduced_QMARK_(init__$1)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$1) : cljs.core.deref.call(null,init__$1));
} else {
var init__$2 = (function (){var G__24506 = init__$1;
var G__24507 = node.key;
var G__24508 = node.val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__24506,G__24507,G__24508) : f.call(null,G__24506,G__24507,G__24508));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var init__$3 = ((!((node.right == null)))?(function (){var G__24509 = node.right;
var G__24510 = f;
var G__24511 = init__$2;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__24509,G__24510,G__24511) : cljs.core.tree_map_kv_reduce.call(null,G__24509,G__24510,G__24511));
})():init__$2);
if(cljs.core.reduced_QMARK_(init__$3)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$3) : cljs.core.deref.call(null,init__$3));
} else {
return init__$3;
}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.BlackNode.prototype.lastIndexOf = (function() {
var G__24513 = null;
var G__24513__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__24513__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24513 = function(x,start){
switch(arguments.length){
case 1:
return G__24513__1.call(this,x);
case 2:
return G__24513__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24513.cljs$core$IFn$_invoke$arity$1 = G__24513__1;
G__24513.cljs$core$IFn$_invoke$arity$2 = G__24513__2;
return G__24513;
})()
;

cljs.core.BlackNode.prototype.indexOf = (function() {
var G__24514 = null;
var G__24514__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__24514__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24514 = function(x,start){
switch(arguments.length){
case 1:
return G__24514__1.call(this,x);
case 2:
return G__24514__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24514.cljs$core$IFn$_invoke$arity$1 = G__24514__1;
G__24514.cljs$core$IFn$_invoke$arity$2 = G__24514__2;
return G__24514;
})()
;

cljs.core.BlackNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
});

cljs.core.BlackNode.prototype.redden = (function (){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.BlackNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return node;
});

cljs.core.BlackNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
});

cljs.core.BlackNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.BlackNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
});

cljs.core.BlackNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
});

cljs.core.BlackNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del(self__.key,self__.val,del,self__.right);
});

cljs.core.BlackNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.BlackNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del(self__.key,self__.val,self__.left,del);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
var x__7380__auto__ = self__.key;
return cljs.core._conj((function (){var x__7380__auto____$1 = self__.val;
return cljs.core._conj(cljs.core.List.EMPTY,x__7380__auto____$1);
})(),x__7380__auto__);
});

cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.BlackNode.prototype.call = (function() {
var G__24515 = null;
var G__24515__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__24515__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__24515 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__24515__2.call(this,self__,k);
case 3:
return G__24515__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24515.cljs$core$IFn$_invoke$arity$2 = G__24515__2;
G__24515.cljs$core$IFn$_invoke$arity$3 = G__24515__3;
return G__24515;
})()
;

cljs.core.BlackNode.prototype.apply = (function (self__,args24512){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args24512)));
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.BlackNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$val,cljs.core.cst$sym$left,cljs.core.cst$sym$right,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.BlackNode.cljs$lang$type = true;

cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode";

cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/BlackNode");
});

cljs.core.__GT_BlackNode = (function cljs$core$__GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

(cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.RedNode.prototype.lastIndexOf = (function() {
var G__24517 = null;
var G__24517__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__24517__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24517 = function(x,start){
switch(arguments.length){
case 1:
return G__24517__1.call(this,x);
case 2:
return G__24517__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24517.cljs$core$IFn$_invoke$arity$1 = G__24517__1;
G__24517.cljs$core$IFn$_invoke$arity$2 = G__24517__2;
return G__24517;
})()
;

cljs.core.RedNode.prototype.indexOf = (function() {
var G__24518 = null;
var G__24518__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__24518__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24518 = function(x,start){
switch(arguments.length){
case 1:
return G__24518__1.call(this,x);
case 2:
return G__24518__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24518.cljs$core$IFn$_invoke$arity$1 = G__24518__1;
G__24518.cljs$core$IFn$_invoke$arity$2 = G__24518__2;
return G__24518;
})()
;

cljs.core.RedNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
});

cljs.core.RedNode.prototype.redden = (function (){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
});

cljs.core.RedNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.RedNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
});

cljs.core.RedNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.RedNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
});

cljs.core.RedNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
});

cljs.core.RedNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
});

cljs.core.RedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.RedNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
var x__7380__auto__ = self__.key;
return cljs.core._conj((function (){var x__7380__auto____$1 = self__.val;
return cljs.core._conj(cljs.core.List.EMPTY,x__7380__auto____$1);
})(),x__7380__auto__);
});

cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.RedNode.prototype.call = (function() {
var G__24519 = null;
var G__24519__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__24519__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__24519 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__24519__2.call(this,self__,k);
case 3:
return G__24519__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24519.cljs$core$IFn$_invoke$arity$2 = G__24519__2;
G__24519.cljs$core$IFn$_invoke$arity$3 = G__24519__3;
return G__24519;
})()
;

cljs.core.RedNode.prototype.apply = (function (self__,args24516){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args24516)));
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.RedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$val,cljs.core.cst$sym$left,cljs.core.cst$sym$right,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.RedNode.cljs$lang$type = true;

cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode";

cljs.core.RedNode.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/RedNode");
});

cljs.core.__GT_RedNode = (function cljs$core$__GT_RedNode(key,val,left,right,__hash){
return (new cljs.core.RedNode(key,val,left,right,__hash));
});

(cljs.core.RedNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
cljs.core.tree_map_add = (function cljs$core$tree_map_add(comp,tree,k,v,found){
if((tree == null)){
return (new cljs.core.RedNode(k,v,null,null,null));
} else {
var c = (function (){var G__24532 = k;
var G__24533 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__24532,G__24533) : comp.call(null,G__24532,G__24533));
})();
if((c === (0))){
(found[(0)] = tree);

return null;
} else {
if((c < (0))){
var ins = (function (){var G__24534 = comp;
var G__24535 = tree.left;
var G__24536 = k;
var G__24537 = v;
var G__24538 = found;
return (cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5 ? cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5(G__24534,G__24535,G__24536,G__24537,G__24538) : cljs.core.tree_map_add.call(null,G__24534,G__24535,G__24536,G__24537,G__24538));
})();
if(!((ins == null))){
return tree.add_left(ins);
} else {
return null;
}
} else {
var ins = (function (){var G__24539 = comp;
var G__24540 = tree.right;
var G__24541 = k;
var G__24542 = v;
var G__24543 = found;
return (cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5 ? cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5(G__24539,G__24540,G__24541,G__24542,G__24543) : cljs.core.tree_map_add.call(null,G__24539,G__24540,G__24541,G__24542,G__24543));
})();
if(!((ins == null))){
return tree.add_right(ins);
} else {
return null;
}

}
}
}
});
cljs.core.tree_map_append = (function cljs$core$tree_map_append(left,right){
if((left == null)){
return right;
} else {
if((right == null)){
return left;
} else {
if((left instanceof cljs.core.RedNode)){
if((right instanceof cljs.core.RedNode)){
var app = (function (){var G__24552 = left.right;
var G__24553 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__24552,G__24553) : cljs.core.tree_map_append.call(null,G__24552,G__24553));
})();
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.RedNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.RedNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(new cljs.core.RedNode(right.key,right.val,app,right.right,null)),null));
}
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(function (){var G__24554 = left.right;
var G__24555 = right;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__24554,G__24555) : cljs.core.tree_map_append.call(null,G__24554,G__24555));
})(),null));
}
} else {
if((right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(right.key,right.val,(function (){var G__24556 = left;
var G__24557 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__24556,G__24557) : cljs.core.tree_map_append.call(null,G__24556,G__24557));
})(),right.right,null));
} else {
var app = (function (){var G__24558 = left.right;
var G__24559 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__24558,G__24559) : cljs.core.tree_map_append.call(null,G__24558,G__24559));
})();
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.BlackNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.BlackNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return cljs.core.balance_left_del(left.key,left.val,left.left,(new cljs.core.BlackNode(right.key,right.val,app,right.right,null)));
}

}
}
}
}
});
cljs.core.tree_map_remove = (function cljs$core$tree_map_remove(comp,tree,k,found){
if(!((tree == null))){
var c = (function (){var G__24570 = k;
var G__24571 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__24570,G__24571) : comp.call(null,G__24570,G__24571));
})();
if((c === (0))){
(found[(0)] = tree);

return cljs.core.tree_map_append(tree.left,tree.right);
} else {
if((c < (0))){
var del = (function (){var G__24572 = comp;
var G__24573 = tree.left;
var G__24574 = k;
var G__24575 = found;
return (cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4(G__24572,G__24573,G__24574,G__24575) : cljs.core.tree_map_remove.call(null,G__24572,G__24573,G__24574,G__24575));
})();
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left_del(tree.key,tree.val,del,tree.right);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,del,tree.right,null));
}
} else {
return null;
}
} else {
var del = (function (){var G__24576 = comp;
var G__24577 = tree.right;
var G__24578 = k;
var G__24579 = found;
return (cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4(G__24576,G__24577,G__24578,G__24579) : cljs.core.tree_map_remove.call(null,G__24576,G__24577,G__24578,G__24579));
})();
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right_del(tree.key,tree.val,tree.left,del);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,tree.left,del,null));
}
} else {
return null;
}

}
}
} else {
return null;
}
});
cljs.core.tree_map_replace = (function cljs$core$tree_map_replace(comp,tree,k,v){
var tk = tree.key;
var c = (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(k,tk) : comp.call(null,k,tk));
if((c === (0))){
return tree.replace(tk,v,tree.left,tree.right);
} else {
if((c < (0))){
return tree.replace(tk,tree.val,(function (){var G__24588 = comp;
var G__24589 = tree.left;
var G__24590 = k;
var G__24591 = v;
return (cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4(G__24588,G__24589,G__24590,G__24591) : cljs.core.tree_map_replace.call(null,G__24588,G__24589,G__24590,G__24591));
})(),tree.right);
} else {
return tree.replace(tk,tree.val,tree.left,(function (){var G__24592 = comp;
var G__24593 = tree.right;
var G__24594 = k;
var G__24595 = v;
return (cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4(G__24592,G__24593,G__24594,G__24595) : cljs.core.tree_map_replace.call(null,G__24592,G__24593,G__24594,G__24595));
})());

}
}
});

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentTreeMap = (function (comp,tree,cnt,meta,__hash){
this.comp = comp;
this.tree = tree;
this.cnt = cnt;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 418776847;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__24597 = cljs.core.seq(coll);
var chunk__24598 = null;
var count__24599 = (0);
var i__24600 = (0);
while(true){
if((i__24600 < count__24599)){
var vec__24601 = chunk__24598.cljs$core$IIndexed$_nth$arity$2(null,i__24600);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24601,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24601,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__24611 = seq__24597;
var G__24612 = chunk__24598;
var G__24613 = count__24599;
var G__24614 = (i__24600 + (1));
seq__24597 = G__24611;
chunk__24598 = G__24612;
count__24599 = G__24613;
i__24600 = G__24614;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__24597);
if(temp__4657__auto__){
var seq__24597__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__24597__$1)){
var c__7357__auto__ = cljs.core.chunk_first(seq__24597__$1);
var G__24615 = cljs.core.chunk_rest(seq__24597__$1);
var G__24616 = c__7357__auto__;
var G__24617 = cljs.core.count(c__7357__auto__);
var G__24618 = (0);
seq__24597 = G__24615;
chunk__24598 = G__24616;
count__24599 = G__24617;
i__24600 = G__24618;
continue;
} else {
var vec__24604 = cljs.core.first(seq__24597__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24604,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24604,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__24619 = cljs.core.next(seq__24597__$1);
var G__24620 = null;
var G__24621 = (0);
var G__24622 = (0);
seq__24597 = G__24619;
chunk__24598 = G__24620;
count__24599 = G__24621;
i__24600 = G__24622;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null,coll)));
});

cljs.core.PersistentTreeMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null,coll)));
});

cljs.core.PersistentTreeMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMap.prototype.entry_at = (function (k){
var self__ = this;
var coll = this;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__24607 = k;
var G__24608 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__24607,G__24608) : self__.comp.call(null,G__24607,G__24608));
})();
if((c === (0))){
return t;
} else {
if((c < (0))){
var G__24623 = t.left;
t = G__24623;
continue;
} else {
var G__24624 = t.right;
t = G__24624;
continue;

}
}
} else {
return null;
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var n = coll__$1.entry_at(k);
if(!((n == null))){
return n.val;
} else {
return not_found;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if(!((self__.tree == null))){
return cljs.core.tree_map_kv_reduce(self__.tree,f,init);
} else {
return init;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,self__.meta,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,false,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,(0)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_remove(self__.comp,self__.tree,k,found);
if((t == null)){
if((cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0)) == null)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt - (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_add(self__.comp,self__.tree,k,v,found);
if((t == null)){
var found_node = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,found_node.val)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,cljs.core.tree_map_replace(self__.comp,self__.tree,k,v),self__.cnt,self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt + (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((coll__$1.entry_at(k) == null));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,true,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,meta__$1,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__24625 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__24626 = cljs.core.next(es);
ret = G__24625;
es = G__24626;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentTreeMap.prototype.call = (function() {
var G__24627 = null;
var G__24627__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__24627__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__24627 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__24627__2.call(this,self__,k);
case 3:
return G__24627__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24627.cljs$core$IFn$_invoke$arity$2 = G__24627__2;
G__24627.cljs$core$IFn$_invoke$arity$3 = G__24627__3;
return G__24627;
})()
;

cljs.core.PersistentTreeMap.prototype.apply = (function (self__,args24596){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args24596)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,ascending_QMARK_,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var stack = null;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__24609 = k;
var G__24610 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__24609,G__24610) : self__.comp.call(null,G__24609,G__24610));
})();
if((c === (0))){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t),ascending_QMARK_,(-1),null));
} else {
if(cljs.core.truth_(ascending_QMARK_)){
if((c < (0))){
var G__24628 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__24629 = t.left;
stack = G__24628;
t = G__24629;
continue;
} else {
var G__24630 = stack;
var G__24631 = t.right;
stack = G__24630;
t = G__24631;
continue;
}
} else {
if((c > (0))){
var G__24632 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__24633 = t.right;
stack = G__24632;
t = G__24633;
continue;
} else {
var G__24634 = stack;
var G__24635 = t.left;
stack = G__24634;
t = G__24635;
continue;
}

}
}
} else {
if((stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,stack,ascending_QMARK_,(-1),null));
}
}
break;
}
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(entry) : cljs.core.key.call(null,entry));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.comp;
});

cljs.core.PersistentTreeMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$tree,cljs.core.cst$sym$cnt,cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentTreeMap.cljs$lang$type = true;

cljs.core.PersistentTreeMap.cljs$lang$ctorStr = "cljs.core/PersistentTreeMap";

cljs.core.PersistentTreeMap.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentTreeMap");
});

cljs.core.__GT_PersistentTreeMap = (function cljs$core$__GT_PersistentTreeMap(comp,tree,cnt,meta,__hash){
return (new cljs.core.PersistentTreeMap(comp,tree,cnt,meta,__hash));
});

cljs.core.PersistentTreeMap.EMPTY = (new cljs.core.PersistentTreeMap(cljs.core.compare,null,(0),null,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
/**
 * keyval => key val
 *   Returns a new hash map with supplied mappings.
 */
cljs.core.hash_map = (function cljs$core$hash_map(var_args){
var args__7658__auto__ = [];
var len__7651__auto___24637 = arguments.length;
var i__7652__auto___24638 = (0);
while(true){
if((i__7652__auto___24638 < len__7651__auto___24637)){
args__7658__auto__.push((arguments[i__7652__auto___24638]));

var G__24639 = (i__7652__auto___24638 + (1));
i__7652__auto___24638 = G__24639;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if(in$){
var G__24640 = cljs.core.nnext(in$);
var G__24641 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__24640;
out = G__24641;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});

cljs.core.hash_map.cljs$lang$maxFixedArity = (0);

cljs.core.hash_map.cljs$lang$applyTo = (function (seq24636){
return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq24636));
});

/**
 * keyval => key val
 *   Returns a new array map with supplied mappings.
 */
cljs.core.array_map = (function cljs$core$array_map(var_args){
var args__7658__auto__ = [];
var len__7651__auto___24643 = arguments.length;
var i__7652__auto___24644 = (0);
while(true){
if((i__7652__auto___24644 < len__7651__auto___24643)){
args__7658__auto__.push((arguments[i__7652__auto___24644]));

var G__24645 = (i__7652__auto___24644 + (1));
i__7652__auto___24644 = G__24645;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var arr = ((((keyvals instanceof cljs.core.IndexedSeq)) && ((keyvals.i === (0))))?keyvals.arr:cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(keyvals));
return cljs.core.PersistentArrayMap.fromArray(arr,true,false);
});

cljs.core.array_map.cljs$lang$maxFixedArity = (0);

cljs.core.array_map.cljs$lang$applyTo = (function (seq24642){
return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq24642));
});

/**
 * keyval => key val
 *   Returns a new object map with supplied mappings.
 */
cljs.core.obj_map = (function cljs$core$obj_map(var_args){
var args__7658__auto__ = [];
var len__7651__auto___24649 = arguments.length;
var i__7652__auto___24650 = (0);
while(true){
if((i__7652__auto___24650 < len__7651__auto___24649)){
args__7658__auto__.push((arguments[i__7652__auto___24650]));

var G__24651 = (i__7652__auto___24650 + (1));
i__7652__auto___24650 = G__24651;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var ks = [];
var obj = {};
var kvs = cljs.core.seq(keyvals);
while(true){
if(kvs){
ks.push(cljs.core.first(kvs));

(obj[cljs.core.first(kvs)] = cljs.core.second(kvs));

var G__24652 = cljs.core.nnext(kvs);
kvs = G__24652;
continue;
} else {
return cljs.core.ObjMap.fromObject(ks,obj);
}
break;
}
});

cljs.core.obj_map.cljs$lang$maxFixedArity = (0);

cljs.core.obj_map.cljs$lang$applyTo = (function (seq24646){
return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq24646));
});

/**
 * keyval => key val
 *   Returns a new sorted map with supplied mappings.
 */
cljs.core.sorted_map = (function cljs$core$sorted_map(var_args){
var args__7658__auto__ = [];
var len__7651__auto___24654 = arguments.length;
var i__7652__auto___24655 = (0);
while(true){
if((i__7652__auto___24655 < len__7651__auto___24654)){
args__7658__auto__.push((arguments[i__7652__auto___24655]));

var G__24656 = (i__7652__auto___24655 + (1));
i__7652__auto___24655 = G__24656;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.PersistentTreeMap.EMPTY;
while(true){
if(in$){
var G__24657 = cljs.core.nnext(in$);
var G__24658 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__24657;
out = G__24658;
continue;
} else {
return out;
}
break;
}
});

cljs.core.sorted_map.cljs$lang$maxFixedArity = (0);

cljs.core.sorted_map.cljs$lang$applyTo = (function (seq24653){
return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq24653));
});

/**
 * keyval => key val
 *   Returns a new sorted map with supplied mappings, using the supplied comparator.
 */
cljs.core.sorted_map_by = (function cljs$core$sorted_map_by(var_args){
var args__7658__auto__ = [];
var len__7651__auto___24661 = arguments.length;
var i__7652__auto___24662 = (0);
while(true){
if((i__7652__auto___24662 < len__7651__auto___24661)){
args__7658__auto__.push((arguments[i__7652__auto___24662]));

var G__24663 = (i__7652__auto___24662 + (1));
i__7652__auto___24662 = G__24663;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = (new cljs.core.PersistentTreeMap(cljs.core.fn__GT_comparator(comparator),null,(0),null,(0)));
while(true){
if(in$){
var G__24664 = cljs.core.nnext(in$);
var G__24665 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__24664;
out = G__24665;
continue;
} else {
return out;
}
break;
}
});

cljs.core.sorted_map_by.cljs$lang$maxFixedArity = (1);

cljs.core.sorted_map_by.cljs$lang$applyTo = (function (seq24659){
var G__24660 = cljs.core.first(seq24659);
var seq24659__$1 = cljs.core.next(seq24659);
return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(G__24660,seq24659__$1);
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.KeySeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.KeySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.KeySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.KeySeq.prototype.indexOf = (function() {
var G__24668 = null;
var G__24668__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__24668__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24668 = function(x,start){
switch(arguments.length){
case 1:
return G__24668__1.call(this,x);
case 2:
return G__24668__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24668.cljs$core$IFn$_invoke$arity$1 = G__24668__1;
G__24668.cljs$core$IFn$_invoke$arity$2 = G__24668__2;
return G__24668;
})()
;

cljs.core.KeySeq.prototype.lastIndexOf = (function() {
var G__24669 = null;
var G__24669__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__24669__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24669 = function(x,start){
switch(arguments.length){
case 1:
return G__24669__1.call(this,x);
case 2:
return G__24669__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24669.cljs$core$IFn$_invoke$arity$1 = G__24669__1;
G__24669.cljs$core$IFn$_invoke$arity$2 = G__24669__2;
return G__24669;
})()
;

cljs.core.KeySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.KeySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = ((((!((self__.mseq == null)))?((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$)))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.KeySeq(nseq,self__._meta));
}
});

cljs.core.KeySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.KeySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_key$arity$1(null);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = ((((!((self__.mseq == null)))?((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$)))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.KeySeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.KeySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.KeySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.KeySeq(self__.mseq,new_meta));
});

cljs.core.KeySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.KeySeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mseq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null)),cljs.core.cst$sym$_meta], null);
});

cljs.core.KeySeq.cljs$lang$type = true;

cljs.core.KeySeq.cljs$lang$ctorStr = "cljs.core/KeySeq";

cljs.core.KeySeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/KeySeq");
});

cljs.core.__GT_KeySeq = (function cljs$core$__GT_KeySeq(mseq,_meta){
return (new cljs.core.KeySeq(mseq,_meta));
});

(cljs.core.KeySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
/**
 * Returns a sequence of the map's keys.
 */
cljs.core.keys = (function cljs$core$keys(hash_map){
var temp__4657__auto__ = cljs.core.seq(hash_map);
if(temp__4657__auto__){
var mseq = temp__4657__auto__;
return (new cljs.core.KeySeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core.key = (function cljs$core$key(map_entry){
return cljs.core._key(map_entry);
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ValSeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ValSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ValSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ValSeq.prototype.indexOf = (function() {
var G__24672 = null;
var G__24672__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__24672__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24672 = function(x,start){
switch(arguments.length){
case 1:
return G__24672__1.call(this,x);
case 2:
return G__24672__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24672.cljs$core$IFn$_invoke$arity$1 = G__24672__1;
G__24672.cljs$core$IFn$_invoke$arity$2 = G__24672__2;
return G__24672;
})()
;

cljs.core.ValSeq.prototype.lastIndexOf = (function() {
var G__24673 = null;
var G__24673__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__24673__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__24673 = function(x,start){
switch(arguments.length){
case 1:
return G__24673__1.call(this,x);
case 2:
return G__24673__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24673.cljs$core$IFn$_invoke$arity$1 = G__24673__1;
G__24673.cljs$core$IFn$_invoke$arity$2 = G__24673__2;
return G__24673;
})()
;

cljs.core.ValSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.ValSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = ((((!((self__.mseq == null)))?((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$)))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.ValSeq(nseq,self__._meta));
}
});

cljs.core.ValSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ValSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_val$arity$1(null);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = ((((!((self__.mseq == null)))?((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$)))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.ValSeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ValSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ValSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ValSeq(self__.mseq,new_meta));
});

cljs.core.ValSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ValSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mseq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null)),cljs.core.cst$sym$_meta], null);
});

cljs.core.ValSeq.cljs$lang$type = true;

cljs.core.ValSeq.cljs$lang$ctorStr = "cljs.core/ValSeq";

cljs.core.ValSeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ValSeq");
});

cljs.core.__GT_ValSeq = (function cljs$core$__GT_ValSeq(mseq,_meta){
return (new cljs.core.ValSeq(mseq,_meta));
});

(cljs.core.ValSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
/**
 * Returns a sequence of the map's values.
 */
cljs.core.vals = (function cljs$core$vals(hash_map){
var temp__4657__auto__ = cljs.core.seq(hash_map);
if(temp__4657__auto__){
var mseq = temp__4657__auto__;
return (new cljs.core.ValSeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the value in the map entry.
 */
cljs.core.val = (function cljs$core$val(map_entry){
return cljs.core._val(map_entry);
});
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 *   the first.  If a key occurs in more than one map, the mapping from
 *   the latter (left-to-right) will be the mapping in the result.
 */
cljs.core.merge = (function cljs$core$merge(var_args){
var args__7658__auto__ = [];
var len__7651__auto___24677 = arguments.length;
var i__7652__auto___24678 = (0);
while(true){
if((i__7652__auto___24678 < len__7651__auto___24677)){
args__7658__auto__.push((arguments[i__7652__auto___24678]));

var G__24679 = (i__7652__auto___24678 + (1));
i__7652__auto___24678 = G__24679;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic = (function (maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__24674_SHARP_,p2__24675_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__6543__auto__ = p1__24674_SHARP_;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),p2__24675_SHARP_);
}),maps);
} else {
return null;
}
});

cljs.core.merge.cljs$lang$maxFixedArity = (0);

cljs.core.merge.cljs$lang$applyTo = (function (seq24676){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq24676));
});

/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 *   the first.  If a key occurs in more than one map, the mapping(s)
 *   from the latter (left-to-right) will be combined with the mapping in
 *   the result by calling (f val-in-result val-in-latter).
 */
cljs.core.merge_with = (function cljs$core$merge_with(var_args){
var args__7658__auto__ = [];
var len__7651__auto___24684 = arguments.length;
var i__7652__auto___24685 = (0);
while(true){
if((i__7652__auto___24685 < len__7651__auto___24684)){
args__7658__auto__.push((arguments[i__7652__auto___24685]));

var G__24686 = (i__7652__auto___24685 + (1));
i__7652__auto___24685 = G__24686;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic = (function (f,maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.first(e);
var v = cljs.core.second(e);
if(cljs.core.contains_QMARK_(m,k)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__24682 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__24683 = v;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__24682,G__24683) : f.call(null,G__24682,G__24683));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
var merge2 = ((function (merge_entry){
return (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry,(function (){var or__6543__auto__ = m1;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq(m2));
});})(merge_entry))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2,maps);
} else {
return null;
}
});

cljs.core.merge_with.cljs$lang$maxFixedArity = (1);

cljs.core.merge_with.cljs$lang$applyTo = (function (seq24680){
var G__24681 = cljs.core.first(seq24680);
var seq24680__$1 = cljs.core.next(seq24680);
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(G__24681,seq24680__$1);
});

/**
 * Returns a map containing only those entries in map whose key is in keys
 */
cljs.core.select_keys = (function cljs$core$select_keys(map,keyseq){
var ret = cljs.core.PersistentArrayMap.EMPTY;
var keys = cljs.core.seq(keyseq);
while(true){
if(keys){
var key = cljs.core.first(keys);
var entry = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map,key,cljs.core.cst$kw$cljs$core_SLASH_not_DASH_found);
var G__24687 = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(entry,cljs.core.cst$kw$cljs$core_SLASH_not_DASH_found))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,key,entry):ret);
var G__24688 = cljs.core.next(keys);
ret = G__24687;
keys = G__24688;
continue;
} else {
return cljs.core.with_meta(ret,cljs.core.meta(map));
}
break;
}
});

/**
* @constructor
*/
cljs.core.HashSetIter = (function (iter){
this.iter = iter;
})
cljs.core.HashSetIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return self__.iter.hasNext();
});

cljs.core.HashSetIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if(self__.iter.hasNext()){
return (self__.iter.next().tail[(0)]);
} else {
throw (new Error("No such element"));
}
});

cljs.core.HashSetIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.HashSetIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iter], null);
});

cljs.core.HashSetIter.cljs$lang$type = true;

cljs.core.HashSetIter.cljs$lang$ctorStr = "cljs.core/HashSetIter";

cljs.core.HashSetIter.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/HashSetIter");
});

cljs.core.__GT_HashSetIter = (function cljs$core$__GT_HashSetIter(iter){
return (new cljs.core.HashSetIter(iter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.ISet}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashSet = (function (meta,hash_map,__hash){
this.meta = meta;
this.hash_map = hash_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 15077647;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__24691 = cljs.core.seq(coll);
var chunk__24692 = null;
var count__24693 = (0);
var i__24694 = (0);
while(true){
if((i__24694 < count__24693)){
var vec__24695 = chunk__24692.cljs$core$IIndexed$_nth$arity$2(null,i__24694);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24695,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24695,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__24701 = seq__24691;
var G__24702 = chunk__24692;
var G__24703 = count__24693;
var G__24704 = (i__24694 + (1));
seq__24691 = G__24701;
chunk__24692 = G__24702;
count__24693 = G__24703;
i__24694 = G__24704;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__24691);
if(temp__4657__auto__){
var seq__24691__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__24691__$1)){
var c__7357__auto__ = cljs.core.chunk_first(seq__24691__$1);
var G__24705 = cljs.core.chunk_rest(seq__24691__$1);
var G__24706 = c__7357__auto__;
var G__24707 = cljs.core.count(c__7357__auto__);
var G__24708 = (0);
seq__24691 = G__24705;
chunk__24692 = G__24706;
count__24693 = G__24707;
i__24694 = G__24708;
continue;
} else {
var vec__24698 = cljs.core.first(seq__24691__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24698,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24698,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__24709 = cljs.core.next(seq__24691__$1);
var G__24710 = null;
var G__24711 = (0);
var G__24712 = (0);
seq__24691 = G__24709;
chunk__24692 = G__24710;
count__24693 = G__24711;
i__24694 = G__24712;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
if(cljs.core._contains_key_QMARK_(self__.hash_map,v)){
return v;
} else {
return not_found;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentHashSet.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.HashSetIter(cljs.core._iterator(self__.hash_map)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._count(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__24689_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__24689_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashSet(cljs.core._as_transient(self__.hash_map)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentHashSet.EMPTY,self__.meta);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core._dissoc(self__.hash_map,v),null));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(meta__$1,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.hash_map,o,null),null));
});

cljs.core.PersistentHashSet.prototype.call = (function() {
var G__24713 = null;
var G__24713__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__24713__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__24713 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__24713__2.call(this,self__,k);
case 3:
return G__24713__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24713.cljs$core$IFn$_invoke$arity$2 = G__24713__2;
G__24713.cljs$core$IFn$_invoke$arity$3 = G__24713__3;
return G__24713;
})()
;

cljs.core.PersistentHashSet.prototype.apply = (function (self__,args24690){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args24690)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$hash_DASH_map,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentHashSet.cljs$lang$type = true;

cljs.core.PersistentHashSet.cljs$lang$ctorStr = "cljs.core/PersistentHashSet";

cljs.core.PersistentHashSet.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentHashSet");
});

cljs.core.__GT_PersistentHashSet = (function cljs$core$__GT_PersistentHashSet(meta,hash_map,__hash){
return (new cljs.core.PersistentHashSet(meta,hash_map,__hash));
});

cljs.core.PersistentHashSet.EMPTY = (new cljs.core.PersistentHashSet(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashSet.fromArray = (function (items,no_clone){
var len = items.length;
if((len <= cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr = ((no_clone)?items:cljs.core.aclone(items));
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__24714 = (i + (1));
var G__24715 = cljs.core._assoc_BANG_(out,(items[i]),null);
i = G__24714;
out = G__24715;
continue;
} else {
return (new cljs.core.PersistentHashSet(null,cljs.core._persistent_BANG_(out),null));
}
break;
}
} else {
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < len)){
var G__24716 = (i + (1));
var G__24717 = cljs.core._conj_BANG_(out,(items[i]));
i = G__24716;
out = G__24717;
continue;
} else {
return cljs.core._persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentHashSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ITransientSet}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientHashSet = (function (transient_map){
this.transient_map = transient_map;
this.cljs$lang$protocol_mask$partition1$ = 136;
this.cljs$lang$protocol_mask$partition0$ = 259;
})
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(self__.transient_map,o,null);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return (new cljs.core.PersistentHashSet(null,cljs.core.persistent_BANG_(self__.transient_map),null));
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(self__.transient_map,v);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return cljs.core.count(self__.transient_map);
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,v,null);
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,v,not_found){
var self__ = this;
var tcoll__$1 = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return v;
}
});

cljs.core.TransientHashSet.prototype.call = (function() {
var G__24719 = null;
var G__24719__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});
var G__24719__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});
G__24719 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__24719__2.call(this,self__,k);
case 3:
return G__24719__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24719.cljs$core$IFn$_invoke$arity$2 = G__24719__2;
G__24719.cljs$core$IFn$_invoke$arity$3 = G__24719__3;
return G__24719;
})()
;

cljs.core.TransientHashSet.prototype.apply = (function (self__,args24718){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args24718)));
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});

cljs.core.TransientHashSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$transient_DASH_map,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.TransientHashSet.cljs$lang$type = true;

cljs.core.TransientHashSet.cljs$lang$ctorStr = "cljs.core/TransientHashSet";

cljs.core.TransientHashSet.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/TransientHashSet");
});

cljs.core.__GT_TransientHashSet = (function cljs$core$__GT_TransientHashSet(transient_map){
return (new cljs.core.TransientHashSet(transient_map));
});


/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ISet}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentTreeSet = (function (meta,tree_map,__hash){
this.meta = meta;
this.tree_map = tree_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 417730831;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__24722 = cljs.core.seq(coll);
var chunk__24723 = null;
var count__24724 = (0);
var i__24725 = (0);
while(true){
if((i__24725 < count__24724)){
var vec__24726 = chunk__24723.cljs$core$IIndexed$_nth$arity$2(null,i__24725);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24726,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24726,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__24732 = seq__24722;
var G__24733 = chunk__24723;
var G__24734 = count__24724;
var G__24735 = (i__24725 + (1));
seq__24722 = G__24732;
chunk__24723 = G__24733;
count__24724 = G__24734;
i__24725 = G__24735;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__24722);
if(temp__4657__auto__){
var seq__24722__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__24722__$1)){
var c__7357__auto__ = cljs.core.chunk_first(seq__24722__$1);
var G__24736 = cljs.core.chunk_rest(seq__24722__$1);
var G__24737 = c__7357__auto__;
var G__24738 = cljs.core.count(c__7357__auto__);
var G__24739 = (0);
seq__24722 = G__24736;
chunk__24723 = G__24737;
count__24724 = G__24738;
i__24725 = G__24739;
continue;
} else {
var vec__24729 = cljs.core.first(seq__24722__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24729,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24729,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__24740 = cljs.core.next(seq__24722__$1);
var G__24741 = null;
var G__24742 = (0);
var G__24743 = (0);
seq__24722 = G__24740;
chunk__24723 = G__24741;
count__24724 = G__24742;
i__24725 = G__24743;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
var n = self__.tree_map.entry_at(v);
if(!((n == null))){
return n.key;
} else {
return not_found;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.count(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.count(self__.tree_map) > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core.rseq(self__.tree_map));
} else {
return null;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__24720_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__24720_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core._empty(self__.tree_map),(0)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.tree_map,v),null));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(meta__$1,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.tree_map,o,null),null));
});

cljs.core.PersistentTreeSet.prototype.call = (function() {
var G__24744 = null;
var G__24744__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__24744__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__24744 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__24744__2.call(this,self__,k);
case 3:
return G__24744__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24744.cljs$core$IFn$_invoke$arity$2 = G__24744__2;
G__24744.cljs$core$IFn$_invoke$arity$3 = G__24744__3;
return G__24744;
})()
;

cljs.core.PersistentTreeSet.prototype.apply = (function (self__,args24721){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args24721)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq(self__.tree_map,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq_from(self__.tree_map,k,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return entry;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._comparator(self__.tree_map);
});

cljs.core.PersistentTreeSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$tree_DASH_map,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentTreeSet.cljs$lang$type = true;

cljs.core.PersistentTreeSet.cljs$lang$ctorStr = "cljs.core/PersistentTreeSet";

cljs.core.PersistentTreeSet.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentTreeSet");
});

cljs.core.__GT_PersistentTreeSet = (function cljs$core$__GT_PersistentTreeSet(meta,tree_map,__hash){
return (new cljs.core.PersistentTreeSet(meta,tree_map,__hash));
});

cljs.core.PersistentTreeSet.EMPTY = (new cljs.core.PersistentTreeSet(null,cljs.core.PersistentTreeMap.EMPTY,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
cljs.core.set_from_indexed_seq = (function cljs$core$set_from_indexed_seq(iseq){
var arr = iseq.arr;
var ret = (function (){var a__7455__auto__ = arr;
var i = (0);
var res = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < a__7455__auto__.length)){
var G__24745 = (i + (1));
var G__24746 = res.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,(arr[i]));
i = G__24745;
res = G__24746;
continue;
} else {
return res;
}
break;
}
})();
return ret.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
});
/**
 * Returns a set of the distinct elements of coll.
 */
cljs.core.set = (function cljs$core$set(coll){
var in$ = cljs.core.seq(coll);
if((in$ == null)){
return cljs.core.PersistentHashSet.EMPTY;
} else {
if(((in$ instanceof cljs.core.IndexedSeq)) && ((in$.i === (0)))){
return cljs.core.set_from_indexed_seq(in$);
} else {
var in$__$1 = in$;
var out = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if(!((in$__$1 == null))){
var G__24747 = cljs.core.next(in$__$1);
var G__24748 = out.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,in$__$1.cljs$core$ISeq$_first$arity$1(null));
in$__$1 = G__24747;
out = G__24748;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}

}
}
});
/**
 * Returns a new hash set with supplied keys.  Any equal keys are
 *   handled as if by repeated uses of conj.
 */
cljs.core.hash_set = (function cljs$core$hash_set(var_args){
var args24749 = [];
var len__7651__auto___24753 = arguments.length;
var i__7652__auto___24754 = (0);
while(true){
if((i__7652__auto___24754 < len__7651__auto___24753)){
args24749.push((arguments[i__7652__auto___24754]));

var G__24755 = (i__7652__auto___24754 + (1));
i__7652__auto___24754 = G__24755;
continue;
} else {
}
break;
}

var G__24752 = args24749.length;
switch (G__24752) {
case 0:
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args24749.slice((0)),(0),null));
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__7670__auto__);

}
});

cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentHashSet.EMPTY;
});

cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (keys){
return cljs.core.set(keys);
});

cljs.core.hash_set.cljs$lang$applyTo = (function (seq24750){
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq24750));
});

cljs.core.hash_set.cljs$lang$maxFixedArity = (0);

/**
 * Returns a new sorted set with supplied keys.
 */
cljs.core.sorted_set = (function cljs$core$sorted_set(var_args){
var args__7658__auto__ = [];
var len__7651__auto___24758 = arguments.length;
var i__7652__auto___24759 = (0);
while(true){
if((i__7652__auto___24759 < len__7651__auto___24758)){
args__7658__auto__.push((arguments[i__7652__auto___24759]));

var G__24760 = (i__7652__auto___24759 + (1));
i__7652__auto___24759 = G__24760;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic = (function (keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,cljs.core.PersistentTreeSet.EMPTY,keys);
});

cljs.core.sorted_set.cljs$lang$maxFixedArity = (0);

cljs.core.sorted_set.cljs$lang$applyTo = (function (seq24757){
return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq24757));
});

/**
 * Returns a new sorted set with supplied keys, using the supplied comparator.
 */
cljs.core.sorted_set_by = (function cljs$core$sorted_set_by(var_args){
var args__7658__auto__ = [];
var len__7651__auto___24763 = arguments.length;
var i__7652__auto___24764 = (0);
while(true){
if((i__7652__auto___24764 < len__7651__auto___24763)){
args__7658__auto__.push((arguments[i__7652__auto___24764]));

var G__24765 = (i__7652__auto___24764 + (1));
i__7652__auto___24764 = G__24765;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,(new cljs.core.PersistentTreeSet(null,cljs.core.sorted_map_by(comparator),(0))),keys);
});

cljs.core.sorted_set_by.cljs$lang$maxFixedArity = (1);

cljs.core.sorted_set_by.cljs$lang$applyTo = (function (seq24761){
var G__24762 = cljs.core.first(seq24761);
var seq24761__$1 = cljs.core.next(seq24761);
return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(G__24762,seq24761__$1);
});

/**
 * Given a map of replacement pairs and a vector/collection, returns a
 *   vector/seq with any elements = a key in smap replaced with the
 *   corresponding val in smap.  Returns a transducer when no collection
 *   is provided.
 */
cljs.core.replace = (function cljs$core$replace(var_args){
var args24768 = [];
var len__7651__auto___24771 = arguments.length;
var i__7652__auto___24772 = (0);
while(true){
if((i__7652__auto___24772 < len__7651__auto___24771)){
args24768.push((arguments[i__7652__auto___24772]));

var G__24773 = (i__7652__auto___24772 + (1));
i__7652__auto___24772 = G__24773;
continue;
} else {
}
break;
}

var G__24770 = args24768.length;
switch (G__24770) {
case 1:
return cljs.core.replace.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.replace.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24768.length)].join('')));

}
});

cljs.core.replace.cljs$core$IFn$_invoke$arity$1 = (function (smap){
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__24766_SHARP_){
var temp__4655__auto__ = cljs.core.find(smap,p1__24766_SHARP_);
if(cljs.core.truth_(temp__4655__auto__)){
var e = temp__4655__auto__;
return cljs.core.val(e);
} else {
return p1__24766_SHARP_;
}
}));
});

cljs.core.replace.cljs$core$IFn$_invoke$arity$2 = (function (smap,coll){
if(cljs.core.vector_QMARK_(coll)){
var n = cljs.core.count(coll);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (n){
return (function (v,i){
var temp__4655__auto__ = cljs.core.find(smap,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(v,i));
if(cljs.core.truth_(temp__4655__auto__)){
var e = temp__4655__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,i,cljs.core.second(e));
} else {
return v;
}
});})(n))
,coll,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.iterate(cljs.core.inc,(0))));
} else {
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24767_SHARP_){
var temp__4655__auto__ = cljs.core.find(smap,p1__24767_SHARP_);
if(cljs.core.truth_(temp__4655__auto__)){
var e = temp__4655__auto__;
return cljs.core.second(e);
} else {
return p1__24767_SHARP_;
}
}),coll);
}
});

cljs.core.replace.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence of the elements of coll with duplicates removed.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.distinct = (function cljs$core$distinct(var_args){
var args24775 = [];
var len__7651__auto___24788 = arguments.length;
var i__7652__auto___24789 = (0);
while(true){
if((i__7652__auto___24789 < len__7651__auto___24788)){
args24775.push((arguments[i__7652__auto___24789]));

var G__24790 = (i__7652__auto___24789 + (1));
i__7652__auto___24789 = G__24790;
continue;
} else {
}
break;
}

var G__24777 = args24775.length;
switch (G__24777) {
case 0:
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24775.length)].join('')));

}
});

cljs.core.distinct.cljs$core$IFn$_invoke$arity$0 = (function (){
return (function (rf){
var seen = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
return ((function (seen){
return (function() {
var G__24792 = null;
var G__24792__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__24792__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__24792__2 = (function (result,input){
if(cljs.core.contains_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(seen) : cljs.core.deref.call(null,seen)),input)){
return result;
} else {
cljs.core._vreset_BANG_(seen,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core._deref(seen),input));

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__24792 = function(result,input){
switch(arguments.length){
case 0:
return G__24792__0.call(this);
case 1:
return G__24792__1.call(this,result);
case 2:
return G__24792__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24792.cljs$core$IFn$_invoke$arity$0 = G__24792__0;
G__24792.cljs$core$IFn$_invoke$arity$1 = G__24792__1;
G__24792.cljs$core$IFn$_invoke$arity$2 = G__24792__2;
return G__24792;
})()
;})(seen))
});
});

cljs.core.distinct.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var step = (function cljs$core$step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
return (function (p__24784,seen__$1){
while(true){
var vec__24785 = p__24784;
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24785,(0),null);
var xs__$1 = vec__24785;
var temp__4657__auto__ = cljs.core.seq(xs__$1);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.contains_QMARK_(seen__$1,f)){
var G__24793 = cljs.core.rest(s);
var G__24794 = seen__$1;
p__24784 = G__24793;
seen__$1 = G__24794;
continue;
} else {
return cljs.core.cons(f,cljs$core$step(cljs.core.rest(s),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1,f)));
}
} else {
return null;
}
break;
}
}).call(null,xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
});

cljs.core.distinct.cljs$lang$maxFixedArity = 1;

/**
 * Return a seq of all but the last item in coll, in linear time
 */
cljs.core.butlast = (function cljs$core$butlast(s){
var ret = cljs.core.PersistentVector.EMPTY;
var s__$1 = s;
while(true){
if(cljs.core.next(s__$1)){
var G__24795 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,cljs.core.first(s__$1));
var G__24796 = cljs.core.next(s__$1);
ret = G__24795;
s__$1 = G__24796;
continue;
} else {
return cljs.core.seq(ret);
}
break;
}
});
/**
 * Returns the name String of a string, symbol or keyword.
 */
cljs.core.name = (function cljs$core$name(x){
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition1$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$INamed$)))?true:false):false)){
return x.cljs$core$INamed$_name$arity$1(null);
} else {
if(typeof x === 'string'){
return x;
} else {
throw (new Error([cljs.core.str("Doesn't support name: "),cljs.core.str(x)].join('')));
}
}
});
/**
 * Returns a map with the keys mapped to the corresponding vals.
 */
cljs.core.zipmap = (function cljs$core$zipmap(keys,vals){
var map = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var ks = cljs.core.seq(keys);
var vs = cljs.core.seq(vals);
while(true){
if((ks) && (vs)){
var G__24799 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(map,cljs.core.first(ks),cljs.core.first(vs));
var G__24800 = cljs.core.next(ks);
var G__24801 = cljs.core.next(vs);
map = G__24799;
ks = G__24800;
vs = G__24801;
continue;
} else {
return cljs.core.persistent_BANG_(map);
}
break;
}
});
/**
 * Returns the x for which (k x), a number, is greatest.
 */
cljs.core.max_key = (function cljs$core$max_key(var_args){
var args24804 = [];
var len__7651__auto___24811 = arguments.length;
var i__7652__auto___24812 = (0);
while(true){
if((i__7652__auto___24812 < len__7651__auto___24811)){
args24804.push((arguments[i__7652__auto___24812]));

var G__24813 = (i__7652__auto___24812 + (1));
i__7652__auto___24812 = G__24813;
continue;
} else {
}
break;
}

var G__24810 = args24804.length;
switch (G__24810) {
case 2:
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args24804.slice((3)),(0),null));
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7670__auto__);

}
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$2 = (function (k,x){
return x;
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$3 = (function (k,x,y){
if(((k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(x) : k.call(null,x)) > (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(y) : k.call(null,y)))){
return x;
} else {
return y;
}
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic = (function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__24802_SHARP_,p2__24803_SHARP_){
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k,p1__24802_SHARP_,p2__24803_SHARP_);
}),cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
});

cljs.core.max_key.cljs$lang$applyTo = (function (seq24805){
var G__24806 = cljs.core.first(seq24805);
var seq24805__$1 = cljs.core.next(seq24805);
var G__24807 = cljs.core.first(seq24805__$1);
var seq24805__$2 = cljs.core.next(seq24805__$1);
var G__24808 = cljs.core.first(seq24805__$2);
var seq24805__$3 = cljs.core.next(seq24805__$2);
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic(G__24806,G__24807,G__24808,seq24805__$3);
});

cljs.core.max_key.cljs$lang$maxFixedArity = (3);

/**
 * Returns the x for which (k x), a number, is least.
 */
cljs.core.min_key = (function cljs$core$min_key(var_args){
var args24817 = [];
var len__7651__auto___24824 = arguments.length;
var i__7652__auto___24825 = (0);
while(true){
if((i__7652__auto___24825 < len__7651__auto___24824)){
args24817.push((arguments[i__7652__auto___24825]));

var G__24826 = (i__7652__auto___24825 + (1));
i__7652__auto___24825 = G__24826;
continue;
} else {
}
break;
}

var G__24823 = args24817.length;
switch (G__24823) {
case 2:
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args24817.slice((3)),(0),null));
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7670__auto__);

}
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$2 = (function (k,x){
return x;
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$3 = (function (k,x,y){
if(((k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(x) : k.call(null,x)) < (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(y) : k.call(null,y)))){
return x;
} else {
return y;
}
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic = (function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__24815_SHARP_,p2__24816_SHARP_){
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k,p1__24815_SHARP_,p2__24816_SHARP_);
}),cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
});

cljs.core.min_key.cljs$lang$applyTo = (function (seq24818){
var G__24819 = cljs.core.first(seq24818);
var seq24818__$1 = cljs.core.next(seq24818);
var G__24820 = cljs.core.first(seq24818__$1);
var seq24818__$2 = cljs.core.next(seq24818__$1);
var G__24821 = cljs.core.first(seq24818__$2);
var seq24818__$3 = cljs.core.next(seq24818__$2);
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic(G__24819,G__24820,G__24821,seq24818__$3);
});

cljs.core.min_key.cljs$lang$maxFixedArity = (3);


/**
* @constructor
*/
cljs.core.ArrayList = (function (arr){
this.arr = arr;
})
cljs.core.ArrayList.prototype.add = (function (x){
var self__ = this;
var _ = this;
return self__.arr.push(x);
});

cljs.core.ArrayList.prototype.size = (function (){
var self__ = this;
var _ = this;
return self__.arr.length;
});

cljs.core.ArrayList.prototype.clear = (function (){
var self__ = this;
var _ = this;
return self__.arr = [];
});

cljs.core.ArrayList.prototype.isEmpty = (function (){
var self__ = this;
var _ = this;
return (self__.arr.length === (0));
});

cljs.core.ArrayList.prototype.toArray = (function (){
var self__ = this;
var _ = this;
return self__.arr;
});

cljs.core.ArrayList.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayList.cljs$lang$type = true;

cljs.core.ArrayList.cljs$lang$ctorStr = "cljs.core/ArrayList";

cljs.core.ArrayList.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ArrayList");
});

cljs.core.__GT_ArrayList = (function cljs$core$__GT_ArrayList(arr){
return (new cljs.core.ArrayList(arr));
});

cljs.core.array_list = (function cljs$core$array_list(){
return (new cljs.core.ArrayList([]));
});
/**
 * Returns a lazy sequence of lists like partition, but may include
 *   partitions with fewer than n items at the end.  Returns a stateful
 *   transducer when no collection is provided.
 */
cljs.core.partition_all = (function cljs$core$partition_all(var_args){
var args24828 = [];
var len__7651__auto___24831 = arguments.length;
var i__7652__auto___24832 = (0);
while(true){
if((i__7652__auto___24832 < len__7651__auto___24831)){
args24828.push((arguments[i__7652__auto___24832]));

var G__24833 = (i__7652__auto___24832 + (1));
i__7652__auto___24832 = G__24833;
continue;
} else {
}
break;
}

var G__24830 = args24828.length;
switch (G__24830) {
case 1:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24828.length)].join('')));

}
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1 = (function (n){
return (function (rf){
var a = cljs.core.array_list();
return ((function (a){
return (function() {
var G__24835 = null;
var G__24835__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__24835__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v)));
})());
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result__$1) : rf.call(null,result__$1));
});
var G__24835__2 = (function (result,input){
a.add(input);

if((n === a.size())){
var v = cljs.core.vec(a.toArray());
a.clear();

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
} else {
return result;
}
});
G__24835 = function(result,input){
switch(arguments.length){
case 0:
return G__24835__0.call(this);
case 1:
return G__24835__1.call(this,result);
case 2:
return G__24835__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24835.cljs$core$IFn$_invoke$arity$0 = G__24835__0;
G__24835.cljs$core$IFn$_invoke$arity$1 = G__24835__1;
G__24835.cljs$core$IFn$_invoke$arity$2 = G__24835__2;
return G__24835;
})()
;})(a))
});
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
return cljs.core.cons(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s),cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
}),null,null));
});

cljs.core.partition_all.cljs$lang$maxFixedArity = 3;

/**
 * Returns a lazy sequence of successive items from coll while
 *   (pred item) returns true. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.take_while = (function cljs$core$take_while(var_args){
var args24836 = [];
var len__7651__auto___24840 = arguments.length;
var i__7652__auto___24841 = (0);
while(true){
if((i__7652__auto___24841 < len__7651__auto___24840)){
args24836.push((arguments[i__7652__auto___24841]));

var G__24842 = (i__7652__auto___24841 + (1));
i__7652__auto___24841 = G__24842;
continue;
} else {
}
break;
}

var G__24838 = args24836.length;
switch (G__24838) {
case 1:
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24836.length)].join('')));

}
});

cljs.core.take_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
return (function() {
var G__24844 = null;
var G__24844__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__24844__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__24844__2 = (function (result,input){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input)))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return cljs.core.reduced(result);
}
});
G__24844 = function(result,input){
switch(arguments.length){
case 0:
return G__24844__0.call(this);
case 1:
return G__24844__1.call(this,result);
case 2:
return G__24844__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24844.cljs$core$IFn$_invoke$arity$0 = G__24844__0;
G__24844.cljs$core$IFn$_invoke$arity$1 = G__24844__1;
G__24844.cljs$core$IFn$_invoke$arity$2 = G__24844__2;
return G__24844;
})()
});
});

cljs.core.take_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.truth_((function (){var G__24839 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__24839) : pred.call(null,G__24839));
})())){
return cljs.core.cons(cljs.core.first(s),cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.take_while.cljs$lang$maxFixedArity = 2;

cljs.core.mk_bound_fn = (function cljs$core$mk_bound_fn(sc,test,key){
return (function (e){
var comp = cljs.core._comparator(sc);
var G__24849 = (function (){var G__24851 = cljs.core._entry_key(sc,e);
var G__24852 = key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__24851,G__24852) : comp.call(null,G__24851,G__24852));
})();
var G__24850 = (0);
return (test.cljs$core$IFn$_invoke$arity$2 ? test.cljs$core$IFn$_invoke$arity$2(G__24849,G__24850) : test.call(null,G__24849,G__24850));
});
});
/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 *   >=. Returns a seq of those entries with keys ek for
 *   which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.subseq = (function cljs$core$subseq(var_args){
var args24853 = [];
var len__7651__auto___24862 = arguments.length;
var i__7652__auto___24863 = (0);
while(true){
if((i__7652__auto___24863 < len__7651__auto___24862)){
args24853.push((arguments[i__7652__auto___24863]));

var G__24864 = (i__7652__auto___24863 + (1));
i__7652__auto___24863 = G__24864;
continue;
} else {
}
break;
}

var G__24855 = args24853.length;
switch (G__24855) {
case 3:
return cljs.core.subseq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.subseq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24853.length)].join('')));

}
});

cljs.core.subseq.cljs$core$IFn$_invoke$arity$3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._GT_,cljs.core._GT__EQ_], true).call(null,test))){
var temp__4657__auto__ = cljs.core._sorted_seq_from(sc,key,true);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__24856 = temp__4657__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24856,(0),null);
var s = vec__24856;
if(cljs.core.truth_((include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(e) : include.call(null,e)))){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,true));
}
});

cljs.core.subseq.cljs$core$IFn$_invoke$arity$5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4657__auto__ = cljs.core._sorted_seq_from(sc,start_key,true);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__24859 = temp__4657__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24859,(0),null);
var s = vec__24859;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,end_test,end_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,start_test,start_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});

cljs.core.subseq.cljs$lang$maxFixedArity = 5;

/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 *   >=. Returns a reverse seq of those entries with keys ek for
 *   which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.rsubseq = (function cljs$core$rsubseq(var_args){
var args24866 = [];
var len__7651__auto___24875 = arguments.length;
var i__7652__auto___24876 = (0);
while(true){
if((i__7652__auto___24876 < len__7651__auto___24875)){
args24866.push((arguments[i__7652__auto___24876]));

var G__24877 = (i__7652__auto___24876 + (1));
i__7652__auto___24876 = G__24877;
continue;
} else {
}
break;
}

var G__24868 = args24866.length;
switch (G__24868) {
case 3:
return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24866.length)].join('')));

}
});

cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._LT_,cljs.core._LT__EQ_], true).call(null,test))){
var temp__4657__auto__ = cljs.core._sorted_seq_from(sc,key,false);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__24869 = temp__4657__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24869,(0),null);
var s = vec__24869;
if(cljs.core.truth_((include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(e) : include.call(null,e)))){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,false));
}
});

cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4657__auto__ = cljs.core._sorted_seq_from(sc,end_key,false);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__24872 = temp__4657__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24872,(0),null);
var s = vec__24872;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,start_test,start_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,end_test,end_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});

cljs.core.rsubseq.cljs$lang$maxFixedArity = 5;


/**
* @constructor
*/
cljs.core.RangeIterator = (function (i,end,step){
this.i = i;
this.end = end;
this.step = step;
})
cljs.core.RangeIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__.step > (0))){
return (self__.i < self__.end);
} else {
return (self__.i > self__.end);
}
});

cljs.core.RangeIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.i;
self__.i = (self__.i + self__.step);

return ret;
});

cljs.core.RangeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$end,cljs.core.cst$sym$step], null);
});

cljs.core.RangeIterator.cljs$lang$type = true;

cljs.core.RangeIterator.cljs$lang$ctorStr = "cljs.core/RangeIterator";

cljs.core.RangeIterator.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/RangeIterator");
});

cljs.core.__GT_RangeIterator = (function cljs$core$__GT_RangeIterator(i,end,step){
return (new cljs.core.RangeIterator(i,end,step));
});


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Range = (function (meta,start,end,step,__hash){
this.meta = meta;
this.start = start;
this.end = end;
this.step = step;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375006;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Range.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Range.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Range.prototype.indexOf = (function() {
var G__24880 = null;
var G__24880__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__24880__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
G__24880 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__24880__1.call(this,x);
case 2:
return G__24880__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24880.cljs$core$IFn$_invoke$arity$1 = G__24880__1;
G__24880.cljs$core$IFn$_invoke$arity$2 = G__24880__2;
return G__24880;
})()
;

cljs.core.Range.prototype.lastIndexOf = (function() {
var G__24881 = null;
var G__24881__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__24881__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
G__24881 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__24881__1.call(this,x);
case 2:
return G__24881__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24881.cljs$core$IFn$_invoke$arity$1 = G__24881__1;
G__24881.cljs$core$IFn$_invoke$arity$2 = G__24881__2;
return G__24881;
})()
;

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (rng,n){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
throw (new Error("Index out of bounds"));
}
}
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (rng,n,not_found){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
return not_found;
}
}
});

cljs.core.Range.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Range.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RangeIterator(self__.start,self__.end,self__.step));
});

cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return self__.meta;
});

cljs.core.Range.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Range(self__.meta,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$INext$_next$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if(((self__.start + self__.step) < self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
} else {
if(((self__.start + self__.step) > self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
}
});

cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(cljs.core.not(cljs.core._seq(rng__$1))){
return (0);
} else {
var G__24879 = ((self__.end - self__.start) / self__.step);
return Math.ceil(G__24879);
}
});

cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(rng__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (rng,other){
var self__ = this;
var rng__$1 = this;
return cljs.core.equiv_sequential(rng__$1,other);
});

cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (rng,f){
var self__ = this;
var rng__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(rng__$1,f);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (rng,f,init){
var self__ = this;
var rng__$1 = this;
var i = self__.start;
var ret = init;
while(true){
if((((self__.step > (0)))?(i < self__.end):(i > self__.end))){
var ret__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,i) : f.call(null,ret,i));
if(cljs.core.reduced_QMARK_(ret__$1)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret__$1) : cljs.core.deref.call(null,ret__$1));
} else {
var G__24882 = (i + self__.step);
var G__24883 = ret__$1;
i = G__24882;
ret = G__24883;
continue;
}
} else {
return ret;
}
break;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((cljs.core._seq(rng__$1) == null)){
return null;
} else {
return self__.start;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(!((cljs.core._seq(rng__$1) == null))){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if((self__.start < self__.end)){
return rng__$1;
} else {
return null;
}
} else {
if((self__.step < (0))){
if((self__.start > self__.end)){
return rng__$1;
} else {
return null;
}
} else {
if((self__.start === self__.end)){
return null;
} else {
return rng__$1;
}

}
}
});

cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (rng,meta__$1){
var self__ = this;
var rng__$1 = this;
return (new cljs.core.Range(meta__$1,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = (function (rng,o){
var self__ = this;
var rng__$1 = this;
return cljs.core.cons(o,rng__$1);
});

cljs.core.Range.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.cst$sym$step,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Range.cljs$lang$type = true;

cljs.core.Range.cljs$lang$ctorStr = "cljs.core/Range";

cljs.core.Range.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/Range");
});

cljs.core.__GT_Range = (function cljs$core$__GT_Range(meta,start,end,step,__hash){
return (new cljs.core.Range(meta,start,end,step,__hash));
});

(cljs.core.Range.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
/**
 * Returns a lazy seq of nums from start (inclusive) to end
 * (exclusive), by step, where start defaults to 0, step to 1,
 * and end to infinity.
 */
cljs.core.range = (function cljs$core$range(var_args){
var args24884 = [];
var len__7651__auto___24887 = arguments.length;
var i__7652__auto___24888 = (0);
while(true){
if((i__7652__auto___24888 < len__7651__auto___24887)){
args24884.push((arguments[i__7652__auto___24888]));

var G__24889 = (i__7652__auto___24888 + (1));
i__7652__auto___24888 = G__24889;
continue;
} else {
}
break;
}

var G__24886 = args24884.length;
switch (G__24886) {
case 0:
return cljs.core.range.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.range.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24884.length)].join('')));

}
});

cljs.core.range.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((0),Number.MAX_VALUE,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$1 = (function (end){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((0),end,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$2 = (function (start,end){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3(start,end,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$3 = (function (start,end,step){
return (new cljs.core.Range(null,start,end,step,null));
});

cljs.core.range.cljs$lang$maxFixedArity = 3;

/**
 * Returns a lazy seq of every nth item in coll.  Returns a stateful
 *   transducer when no collection is provided.
 */
cljs.core.take_nth = (function cljs$core$take_nth(var_args){
var args24891 = [];
var len__7651__auto___24894 = arguments.length;
var i__7652__auto___24895 = (0);
while(true){
if((i__7652__auto___24895 < len__7651__auto___24894)){
args24891.push((arguments[i__7652__auto___24895]));

var G__24896 = (i__7652__auto___24895 + (1));
i__7652__auto___24895 = G__24896;
continue;
} else {
}
break;
}

var G__24893 = args24891.length;
switch (G__24893) {
case 1:
return cljs.core.take_nth.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24891.length)].join('')));

}
});

cljs.core.take_nth.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__24898 = null;
var G__24898__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__24898__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__24898__2 = (function (result,input){
var i = cljs.core._vreset_BANG_(ia,(cljs.core._deref(ia) + (1)));
if((cljs.core.rem(i,n) === (0))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return result;
}
});
G__24898 = function(result,input){
switch(arguments.length){
case 0:
return G__24898__0.call(this);
case 1:
return G__24898__1.call(this,result);
case 2:
return G__24898__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24898.cljs$core$IFn$_invoke$arity$0 = G__24898__0;
G__24898.cljs$core$IFn$_invoke$arity$1 = G__24898__1;
G__24898.cljs$core$IFn$_invoke$arity$2 = G__24898__2;
return G__24898;
})()
;})(ia))
});
});

cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2(n,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s)));
} else {
return null;
}
}),null,null));
});

cljs.core.take_nth.cljs$lang$maxFixedArity = 2;

/**
 * Returns a vector of [(take-while pred coll) (drop-while pred coll)]
 */
cljs.core.split_with = (function cljs$core$split_with(pred,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred,coll),cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(pred,coll)], null);
});
/**
 * Applies f to each value in coll, splitting it each time f returns a
 * new value.  Returns a lazy seq of partitions.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.partition_by = (function cljs$core$partition_by(var_args){
var args24900 = [];
var len__7651__auto___24903 = arguments.length;
var i__7652__auto___24904 = (0);
while(true){
if((i__7652__auto___24904 < len__7651__auto___24903)){
args24900.push((arguments[i__7652__auto___24904]));

var G__24905 = (i__7652__auto___24904 + (1));
i__7652__auto___24904 = G__24905;
continue;
} else {
}
break;
}

var G__24902 = args24900.length;
switch (G__24902) {
case 1:
return cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24900.length)].join('')));

}
});

cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var a = cljs.core.array_list();
var pa = cljs.core.volatile_BANG_(cljs.core.cst$kw$cljs$core_SLASH_none);
return ((function (a,pa){
return (function() {
var G__24907 = null;
var G__24907__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__24907__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v)));
})());
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result__$1) : rf.call(null,result__$1));
});
var G__24907__2 = (function (result,input){
var pval = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(pa) : cljs.core.deref.call(null,pa));
var val = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
cljs.core.vreset_BANG_(pa,val);

if((cljs.core.keyword_identical_QMARK_(pval,cljs.core.cst$kw$cljs$core_SLASH_none)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,pval))){
a.add(input);

return result;
} else {
var v = cljs.core.vec(a.toArray());
a.clear();

var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
if(cljs.core.reduced_QMARK_(ret)){
} else {
a.add(input);
}

return ret;
}
});
G__24907 = function(result,input){
switch(arguments.length){
case 0:
return G__24907__0.call(this);
case 1:
return G__24907__1.call(this,result);
case 2:
return G__24907__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24907.cljs$core$IFn$_invoke$arity$0 = G__24907__0;
G__24907.cljs$core$IFn$_invoke$arity$1 = G__24907__1;
G__24907.cljs$core$IFn$_invoke$arity$2 = G__24907__2;
return G__24907;
})()
;})(a,pa))
});
});

cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
var fst = cljs.core.first(s);
var fv = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(fst) : f.call(null,fst));
var run = cljs.core.cons(fst,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (fst,fv,s,temp__4657__auto__){
return (function (p1__24899_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fv,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(p1__24899_SHARP_) : f.call(null,p1__24899_SHARP_)));
});})(fst,fv,s,temp__4657__auto__))
,cljs.core.next(s)));
return cljs.core.cons(run,cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(cljs.core.count(run),s))));
} else {
return null;
}
}),null,null));
});

cljs.core.partition_by.cljs$lang$maxFixedArity = 2;

/**
 * Returns a map from distinct items in coll to the number of times
 *   they appear.
 */
cljs.core.frequencies = (function cljs$core$frequencies(coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (counts,x){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(counts,x,(cljs.core.get.cljs$core$IFn$_invoke$arity$3(counts,x,(0)) + (1)));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Returns a lazy seq of the intermediate values of the reduction (as
 *   per reduce) of coll by f, starting with init.
 */
cljs.core.reductions = (function cljs$core$reductions(var_args){
var args24908 = [];
var len__7651__auto___24913 = arguments.length;
var i__7652__auto___24914 = (0);
while(true){
if((i__7652__auto___24914 < len__7651__auto___24913)){
args24908.push((arguments[i__7652__auto___24914]));

var G__24915 = (i__7652__auto___24914 + (1));
i__7652__auto___24914 = G__24915;
continue;
} else {
}
break;
}

var G__24910 = args24908.length;
switch (G__24910) {
case 2:
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24908.length)].join('')));

}
});

cljs.core.reductions.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4655__auto__ = cljs.core.seq(coll);
if(temp__4655__auto__){
var s = temp__4655__auto__;
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3(f,cljs.core.first(s),cljs.core.rest(s));
} else {
var x__7380__auto__ = (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
return cljs.core._conj(cljs.core.List.EMPTY,x__7380__auto__);
}
}),null,null));
});

cljs.core.reductions.cljs$core$IFn$_invoke$arity$3 = (function (f,init,coll){
if(cljs.core.reduced_QMARK_(init)){
var x__7380__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init) : cljs.core.deref.call(null,init));
return cljs.core._conj(cljs.core.List.EMPTY,x__7380__auto__);
} else {
return cljs.core.cons(init,(new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3(f,(function (){var G__24911 = init;
var G__24912 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__24911,G__24912) : f.call(null,G__24911,G__24912));
})(),cljs.core.rest(s));
} else {
return null;
}
}),null,null)));
}
});

cljs.core.reductions.cljs$lang$maxFixedArity = 3;

/**
 * Takes a set of functions and returns a fn that is the juxtaposition
 *   of those fns.  The returned fn takes a variable number of args, and
 *   returns a vector containing the result of applying each fn to the
 *   args (left-to-right).
 *   ((juxt a b c) x) => [(a x) (b x) (c x)]
 */
cljs.core.juxt = (function cljs$core$juxt(var_args){
var args24927 = [];
var len__7651__auto___24934 = arguments.length;
var i__7652__auto___24935 = (0);
while(true){
if((i__7652__auto___24935 < len__7651__auto___24934)){
args24927.push((arguments[i__7652__auto___24935]));

var G__24936 = (i__7652__auto___24935 + (1));
i__7652__auto___24935 = G__24936;
continue;
} else {
}
break;
}

var G__24933 = args24927.length;
switch (G__24933) {
case 1:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args24927.slice((3)),(0),null));
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7670__auto__);

}
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function() {
var G__24938 = null;
var G__24938__0 = (function (){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null))],null));
});
var G__24938__1 = (function (x){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x))],null));
});
var G__24938__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y))],null));
});
var G__24938__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(x,y,z) : f.call(null,x,y,z))],null));
});
var G__24938__4 = (function() { 
var G__24939__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args)],null));
};
var G__24939 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__24940__i = 0, G__24940__a = new Array(arguments.length -  3);
while (G__24940__i < G__24940__a.length) {G__24940__a[G__24940__i] = arguments[G__24940__i + 3]; ++G__24940__i;}
  args = new cljs.core.IndexedSeq(G__24940__a,0);
} 
return G__24939__delegate.call(this,x,y,z,args);};
G__24939.cljs$lang$maxFixedArity = 3;
G__24939.cljs$lang$applyTo = (function (arglist__24941){
var x = cljs.core.first(arglist__24941);
arglist__24941 = cljs.core.next(arglist__24941);
var y = cljs.core.first(arglist__24941);
arglist__24941 = cljs.core.next(arglist__24941);
var z = cljs.core.first(arglist__24941);
var args = cljs.core.rest(arglist__24941);
return G__24939__delegate(x,y,z,args);
});
G__24939.cljs$core$IFn$_invoke$arity$variadic = G__24939__delegate;
return G__24939;
})()
;
G__24938 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__24938__0.call(this);
case 1:
return G__24938__1.call(this,x);
case 2:
return G__24938__2.call(this,x,y);
case 3:
return G__24938__3.call(this,x,y,z);
default:
var G__24942 = null;
if (arguments.length > 3) {
var G__24943__i = 0, G__24943__a = new Array(arguments.length -  3);
while (G__24943__i < G__24943__a.length) {G__24943__a[G__24943__i] = arguments[G__24943__i + 3]; ++G__24943__i;}
G__24942 = new cljs.core.IndexedSeq(G__24943__a,0);
}
return G__24938__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__24942);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24938.cljs$lang$maxFixedArity = 3;
G__24938.cljs$lang$applyTo = G__24938__4.cljs$lang$applyTo;
G__24938.cljs$core$IFn$_invoke$arity$0 = G__24938__0;
G__24938.cljs$core$IFn$_invoke$arity$1 = G__24938__1;
G__24938.cljs$core$IFn$_invoke$arity$2 = G__24938__2;
G__24938.cljs$core$IFn$_invoke$arity$3 = G__24938__3;
G__24938.cljs$core$IFn$_invoke$arity$variadic = G__24938__4.cljs$core$IFn$_invoke$arity$variadic;
return G__24938;
})()
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$2 = (function (f,g){
return (function() {
var G__24944 = null;
var G__24944__0 = (function (){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),(g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null))],null));
});
var G__24944__1 = (function (x){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)),(g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x))],null));
});
var G__24944__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)),(g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y))],null));
});
var G__24944__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(x,y,z) : f.call(null,x,y,z)),(g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z))],null));
});
var G__24944__4 = (function() { 
var G__24945__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args)],null));
};
var G__24945 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__24946__i = 0, G__24946__a = new Array(arguments.length -  3);
while (G__24946__i < G__24946__a.length) {G__24946__a[G__24946__i] = arguments[G__24946__i + 3]; ++G__24946__i;}
  args = new cljs.core.IndexedSeq(G__24946__a,0);
} 
return G__24945__delegate.call(this,x,y,z,args);};
G__24945.cljs$lang$maxFixedArity = 3;
G__24945.cljs$lang$applyTo = (function (arglist__24947){
var x = cljs.core.first(arglist__24947);
arglist__24947 = cljs.core.next(arglist__24947);
var y = cljs.core.first(arglist__24947);
arglist__24947 = cljs.core.next(arglist__24947);
var z = cljs.core.first(arglist__24947);
var args = cljs.core.rest(arglist__24947);
return G__24945__delegate(x,y,z,args);
});
G__24945.cljs$core$IFn$_invoke$arity$variadic = G__24945__delegate;
return G__24945;
})()
;
G__24944 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__24944__0.call(this);
case 1:
return G__24944__1.call(this,x);
case 2:
return G__24944__2.call(this,x,y);
case 3:
return G__24944__3.call(this,x,y,z);
default:
var G__24948 = null;
if (arguments.length > 3) {
var G__24949__i = 0, G__24949__a = new Array(arguments.length -  3);
while (G__24949__i < G__24949__a.length) {G__24949__a[G__24949__i] = arguments[G__24949__i + 3]; ++G__24949__i;}
G__24948 = new cljs.core.IndexedSeq(G__24949__a,0);
}
return G__24944__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__24948);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24944.cljs$lang$maxFixedArity = 3;
G__24944.cljs$lang$applyTo = G__24944__4.cljs$lang$applyTo;
G__24944.cljs$core$IFn$_invoke$arity$0 = G__24944__0;
G__24944.cljs$core$IFn$_invoke$arity$1 = G__24944__1;
G__24944.cljs$core$IFn$_invoke$arity$2 = G__24944__2;
G__24944.cljs$core$IFn$_invoke$arity$3 = G__24944__3;
G__24944.cljs$core$IFn$_invoke$arity$variadic = G__24944__4.cljs$core$IFn$_invoke$arity$variadic;
return G__24944;
})()
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$3 = (function (f,g,h){
return (function() {
var G__24950 = null;
var G__24950__0 = (function (){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),(g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null)),(h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null))],null));
});
var G__24950__1 = (function (x){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)),(g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x)),(h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null,x))],null));
});
var G__24950__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)),(g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y)),(h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x,y) : h.call(null,x,y))],null));
});
var G__24950__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(x,y,z) : f.call(null,x,y,z)),(g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z)),(h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x,y,z) : h.call(null,x,y,z))],null));
});
var G__24950__4 = (function() { 
var G__24951__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args)],null));
};
var G__24951 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__24952__i = 0, G__24952__a = new Array(arguments.length -  3);
while (G__24952__i < G__24952__a.length) {G__24952__a[G__24952__i] = arguments[G__24952__i + 3]; ++G__24952__i;}
  args = new cljs.core.IndexedSeq(G__24952__a,0);
} 
return G__24951__delegate.call(this,x,y,z,args);};
G__24951.cljs$lang$maxFixedArity = 3;
G__24951.cljs$lang$applyTo = (function (arglist__24953){
var x = cljs.core.first(arglist__24953);
arglist__24953 = cljs.core.next(arglist__24953);
var y = cljs.core.first(arglist__24953);
arglist__24953 = cljs.core.next(arglist__24953);
var z = cljs.core.first(arglist__24953);
var args = cljs.core.rest(arglist__24953);
return G__24951__delegate(x,y,z,args);
});
G__24951.cljs$core$IFn$_invoke$arity$variadic = G__24951__delegate;
return G__24951;
})()
;
G__24950 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__24950__0.call(this);
case 1:
return G__24950__1.call(this,x);
case 2:
return G__24950__2.call(this,x,y);
case 3:
return G__24950__3.call(this,x,y,z);
default:
var G__24954 = null;
if (arguments.length > 3) {
var G__24955__i = 0, G__24955__a = new Array(arguments.length -  3);
while (G__24955__i < G__24955__a.length) {G__24955__a[G__24955__i] = arguments[G__24955__i + 3]; ++G__24955__i;}
G__24954 = new cljs.core.IndexedSeq(G__24955__a,0);
}
return G__24950__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__24954);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24950.cljs$lang$maxFixedArity = 3;
G__24950.cljs$lang$applyTo = G__24950__4.cljs$lang$applyTo;
G__24950.cljs$core$IFn$_invoke$arity$0 = G__24950__0;
G__24950.cljs$core$IFn$_invoke$arity$1 = G__24950__1;
G__24950.cljs$core$IFn$_invoke$arity$2 = G__24950__2;
G__24950.cljs$core$IFn$_invoke$arity$3 = G__24950__3;
G__24950.cljs$core$IFn$_invoke$arity$variadic = G__24950__4.cljs$core$IFn$_invoke$arity$variadic;
return G__24950;
})()
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic = (function (f,g,h,fs){
var fs__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f,g,h,fs);
return ((function (fs__$1){
return (function() {
var G__24956 = null;
var G__24956__0 = (function (){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__24917_SHARP_,p2__24918_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__24917_SHARP_,(p2__24918_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p2__24918_SHARP_.cljs$core$IFn$_invoke$arity$0() : p2__24918_SHARP_.call(null)));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__24956__1 = (function (x){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__24919_SHARP_,p2__24920_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__24919_SHARP_,(p2__24920_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p2__24920_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p2__24920_SHARP_.call(null,x)));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__24956__2 = (function (x,y){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__24921_SHARP_,p2__24922_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__24921_SHARP_,(p2__24922_SHARP_.cljs$core$IFn$_invoke$arity$2 ? p2__24922_SHARP_.cljs$core$IFn$_invoke$arity$2(x,y) : p2__24922_SHARP_.call(null,x,y)));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__24956__3 = (function (x,y,z){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__24923_SHARP_,p2__24924_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__24923_SHARP_,(p2__24924_SHARP_.cljs$core$IFn$_invoke$arity$3 ? p2__24924_SHARP_.cljs$core$IFn$_invoke$arity$3(x,y,z) : p2__24924_SHARP_.call(null,x,y,z)));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__24956__4 = (function() { 
var G__24957__delegate = function (x,y,z,args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__24925_SHARP_,p2__24926_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__24925_SHARP_,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(p2__24926_SHARP_,x,y,z,args));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
};
var G__24957 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__24958__i = 0, G__24958__a = new Array(arguments.length -  3);
while (G__24958__i < G__24958__a.length) {G__24958__a[G__24958__i] = arguments[G__24958__i + 3]; ++G__24958__i;}
  args = new cljs.core.IndexedSeq(G__24958__a,0);
} 
return G__24957__delegate.call(this,x,y,z,args);};
G__24957.cljs$lang$maxFixedArity = 3;
G__24957.cljs$lang$applyTo = (function (arglist__24959){
var x = cljs.core.first(arglist__24959);
arglist__24959 = cljs.core.next(arglist__24959);
var y = cljs.core.first(arglist__24959);
arglist__24959 = cljs.core.next(arglist__24959);
var z = cljs.core.first(arglist__24959);
var args = cljs.core.rest(arglist__24959);
return G__24957__delegate(x,y,z,args);
});
G__24957.cljs$core$IFn$_invoke$arity$variadic = G__24957__delegate;
return G__24957;
})()
;
G__24956 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__24956__0.call(this);
case 1:
return G__24956__1.call(this,x);
case 2:
return G__24956__2.call(this,x,y);
case 3:
return G__24956__3.call(this,x,y,z);
default:
var G__24960 = null;
if (arguments.length > 3) {
var G__24961__i = 0, G__24961__a = new Array(arguments.length -  3);
while (G__24961__i < G__24961__a.length) {G__24961__a[G__24961__i] = arguments[G__24961__i + 3]; ++G__24961__i;}
G__24960 = new cljs.core.IndexedSeq(G__24961__a,0);
}
return G__24956__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__24960);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24956.cljs$lang$maxFixedArity = 3;
G__24956.cljs$lang$applyTo = G__24956__4.cljs$lang$applyTo;
G__24956.cljs$core$IFn$_invoke$arity$0 = G__24956__0;
G__24956.cljs$core$IFn$_invoke$arity$1 = G__24956__1;
G__24956.cljs$core$IFn$_invoke$arity$2 = G__24956__2;
G__24956.cljs$core$IFn$_invoke$arity$3 = G__24956__3;
G__24956.cljs$core$IFn$_invoke$arity$variadic = G__24956__4.cljs$core$IFn$_invoke$arity$variadic;
return G__24956;
})()
;})(fs__$1))
});

cljs.core.juxt.cljs$lang$applyTo = (function (seq24928){
var G__24929 = cljs.core.first(seq24928);
var seq24928__$1 = cljs.core.next(seq24928);
var G__24930 = cljs.core.first(seq24928__$1);
var seq24928__$2 = cljs.core.next(seq24928__$1);
var G__24931 = cljs.core.first(seq24928__$2);
var seq24928__$3 = cljs.core.next(seq24928__$2);
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic(G__24929,G__24930,G__24931,seq24928__$3);
});

cljs.core.juxt.cljs$lang$maxFixedArity = (3);

/**
 * When lazy sequences are produced via functions that have side
 *   effects, any effects other than those needed to produce the first
 *   element in the seq do not occur until the seq is consumed. dorun can
 *   be used to force any effects. Walks through the successive nexts of
 *   the seq, does not retain the head and returns nil.
 */
cljs.core.dorun = (function cljs$core$dorun(var_args){
var args24962 = [];
var len__7651__auto___24965 = arguments.length;
var i__7652__auto___24966 = (0);
while(true){
if((i__7652__auto___24966 < len__7651__auto___24965)){
args24962.push((arguments[i__7652__auto___24966]));

var G__24967 = (i__7652__auto___24966 + (1));
i__7652__auto___24966 = G__24967;
continue;
} else {
}
break;
}

var G__24964 = args24962.length;
switch (G__24964) {
case 1:
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24962.length)].join('')));

}
});

cljs.core.dorun.cljs$core$IFn$_invoke$arity$1 = (function (coll){
while(true){
if(cljs.core.seq(coll)){
var G__24969 = cljs.core.next(coll);
coll = G__24969;
continue;
} else {
return null;
}
break;
}
});

cljs.core.dorun.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
while(true){
if((cljs.core.seq(coll)) && ((n > (0)))){
var G__24970 = (n - (1));
var G__24971 = cljs.core.next(coll);
n = G__24970;
coll = G__24971;
continue;
} else {
return null;
}
break;
}
});

cljs.core.dorun.cljs$lang$maxFixedArity = 2;

/**
 * When lazy sequences are produced via functions that have side
 *   effects, any effects other than those needed to produce the first
 *   element in the seq do not occur until the seq is consumed. doall can
 *   be used to force any effects. Walks through the successive nexts of
 *   the seq, retains the head and returns it, thus causing the entire
 *   seq to reside in memory at one time.
 */
cljs.core.doall = (function cljs$core$doall(var_args){
var args24972 = [];
var len__7651__auto___24975 = arguments.length;
var i__7652__auto___24976 = (0);
while(true){
if((i__7652__auto___24976 < len__7651__auto___24975)){
args24972.push((arguments[i__7652__auto___24976]));

var G__24977 = (i__7652__auto___24976 + (1));
i__7652__auto___24976 = G__24977;
continue;
} else {
}
break;
}

var G__24974 = args24972.length;
switch (G__24974) {
case 1:
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.doall.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24972.length)].join('')));

}
});

cljs.core.doall.cljs$core$IFn$_invoke$arity$1 = (function (coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(coll);

return coll;
});

cljs.core.doall.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$2(n,coll);

return coll;
});

cljs.core.doall.cljs$lang$maxFixedArity = 2;

/**
 * Returns true if x is a JavaScript RegExp instance.
 */
cljs.core.regexp_QMARK_ = (function cljs$core$regexp_QMARK_(x){
return (x instanceof RegExp);
});
/**
 * Returns the result of (re-find re s) if re fully matches s.
 */
cljs.core.re_matches = (function cljs$core$re_matches(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(matches),s)){
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
} else {
return null;
}
} else {
throw (new TypeError("re-matches must match against a string."));
}
});
/**
 * Returns the first regex match, if any, of s to re, using
 *   re.exec(s). Returns a vector, containing first the matching
 *   substring, then any capturing groups if the regular expression contains
 *   capturing groups.
 */
cljs.core.re_find = (function cljs$core$re_find(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if((matches == null)){
return null;
} else {
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
}
} else {
throw (new TypeError("re-find must match against a string."));
}
});
/**
 * Returns a lazy sequence of successive matches of re in s.
 */
cljs.core.re_seq = (function cljs$core$re_seq(re,s){
var match_data = cljs.core.re_find(re,s);
var match_idx = s.search(re);
var match_str = ((cljs.core.coll_QMARK_(match_data))?cljs.core.first(match_data):match_data);
var post_match = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,(match_idx + cljs.core.count(match_str)));
if(cljs.core.truth_(match_data)){
return (new cljs.core.LazySeq(null,((function (match_data,match_idx,match_str,post_match){
return (function (){
return cljs.core.cons(match_data,((cljs.core.seq(post_match))?(cljs.core.re_seq.cljs$core$IFn$_invoke$arity$2 ? cljs.core.re_seq.cljs$core$IFn$_invoke$arity$2(re,post_match) : cljs.core.re_seq.call(null,re,post_match)):null));
});})(match_data,match_idx,match_str,post_match))
,null,null));
} else {
return null;
}
});
/**
 * Returns an instance of RegExp which has compiled the provided string.
 */
cljs.core.re_pattern = (function cljs$core$re_pattern(s){
if((s instanceof RegExp)){
return s;
} else {
var vec__24982 = cljs.core.re_find(/^\(\?([idmsux]*)\)/,s);
var prefix = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24982,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24982,(1),null);
var pattern = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,cljs.core.count(prefix));
return (new RegExp(pattern,(function (){var or__6543__auto__ = flags;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return "";
}
})()));
}
});
cljs.core.pr_sequential_writer = (function cljs$core$pr_sequential_writer(writer,print_one,begin,sep,end,opts,coll){
var _STAR_print_level_STAR_24992 = cljs.core._STAR_print_level_STAR_;
cljs.core._STAR_print_level_STAR_ = (((cljs.core._STAR_print_level_STAR_ == null))?null:(cljs.core._STAR_print_level_STAR_ - (1)));

try{if((!((cljs.core._STAR_print_level_STAR_ == null))) && ((cljs.core._STAR_print_level_STAR_ < (0)))){
return cljs.core._write(writer,"#");
} else {
cljs.core._write(writer,begin);

if((cljs.core.cst$kw$print_DASH_length.cljs$core$IFn$_invoke$arity$1(opts) === (0))){
if(cljs.core.seq(coll)){
cljs.core._write(writer,(function (){var or__6543__auto__ = cljs.core.cst$kw$more_DASH_marker.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return "...";
}
})());
} else {
}
} else {
if(cljs.core.seq(coll)){
var G__24993_24999 = cljs.core.first(coll);
var G__24994_25000 = writer;
var G__24995_25001 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__24993_24999,G__24994_25000,G__24995_25001) : print_one.call(null,G__24993_24999,G__24994_25000,G__24995_25001));
} else {
}

var coll_25002__$1 = cljs.core.next(coll);
var n_25003 = (cljs.core.cst$kw$print_DASH_length.cljs$core$IFn$_invoke$arity$1(opts) - (1));
while(true){
if((coll_25002__$1) && (((n_25003 == null)) || (!((n_25003 === (0)))))){
cljs.core._write(writer,sep);

var G__24996_25004 = cljs.core.first(coll_25002__$1);
var G__24997_25005 = writer;
var G__24998_25006 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__24996_25004,G__24997_25005,G__24998_25006) : print_one.call(null,G__24996_25004,G__24997_25005,G__24998_25006));

var G__25007 = cljs.core.next(coll_25002__$1);
var G__25008 = (n_25003 - (1));
coll_25002__$1 = G__25007;
n_25003 = G__25008;
continue;
} else {
if((cljs.core.seq(coll_25002__$1)) && ((n_25003 === (0)))){
cljs.core._write(writer,sep);

cljs.core._write(writer,(function (){var or__6543__auto__ = cljs.core.cst$kw$more_DASH_marker.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return "...";
}
})());
} else {
}
}
break;
}
}

return cljs.core._write(writer,end);
}
}finally {cljs.core._STAR_print_level_STAR_ = _STAR_print_level_STAR_24992;
}});
cljs.core.write_all = (function cljs$core$write_all(var_args){
var args__7658__auto__ = [];
var len__7651__auto___25015 = arguments.length;
var i__7652__auto___25016 = (0);
while(true){
if((i__7652__auto___25016 < len__7651__auto___25015)){
args__7658__auto__.push((arguments[i__7652__auto___25016]));

var G__25017 = (i__7652__auto___25016 + (1));
i__7652__auto___25016 = G__25017;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic = (function (writer,ss){
var seq__25011 = cljs.core.seq(ss);
var chunk__25012 = null;
var count__25013 = (0);
var i__25014 = (0);
while(true){
if((i__25014 < count__25013)){
var s = chunk__25012.cljs$core$IIndexed$_nth$arity$2(null,i__25014);
cljs.core._write(writer,s);

var G__25018 = seq__25011;
var G__25019 = chunk__25012;
var G__25020 = count__25013;
var G__25021 = (i__25014 + (1));
seq__25011 = G__25018;
chunk__25012 = G__25019;
count__25013 = G__25020;
i__25014 = G__25021;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__25011);
if(temp__4657__auto__){
v