// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('chimera.js_interop');
goog.require('cljs.core');
goog.require('cognitect.transit');
goog.require('goog.string');
/**
 * Convert json string to cljs object using transit.
 * Fast, but doesn't preserve keywords.
 */
chimera.js_interop.json__GT_cljs = (function chimera$js_interop$json__GT_cljs(s){
return cognitect.transit.read(cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$json),s);
});
/**
 * Convert json to js using JSON.parse.
 * If error occurs, return the string unmodified.
 */
chimera.js_interop.str__GT_json = (function chimera$js_interop$str__GT_json(string){
try{return JSON.parse(string);
}catch (e39998){if((e39998 instanceof Error)){
var _ = e39998;
return string;
} else {
throw e39998;

}
}});
/**
 * Convert json string to cljs via js.
 * Slow method, but preserves keywords, and appropriate for small json.
 */
chimera.js_interop.json__GT_js__GT_cljs = (function chimera$js_interop$json__GT_js__GT_cljs(s){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(chimera.js_interop.str__GT_json(s),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Formats a string using goog.string.format, so we can use format in cljx.
 */
chimera.js_interop.format = (function chimera$js_interop$format(var_args){
var args__7658__auto__ = [];
var len__7651__auto___40001 = arguments.length;
var i__7652__auto___40002 = (0);
while(true){
if((i__7652__auto___40002 < len__7651__auto___40001)){
args__7658__auto__.push((arguments[i__7652__auto___40002]));

var G__40003 = (i__7652__auto___40002 + (1));
i__7652__auto___40002 = G__40003;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(goog.string.format,fmt,args);
});

chimera.js_interop.format.cljs$lang$maxFixedArity = (1);

chimera.js_interop.format.cljs$lang$applyTo = (function (seq39999){
var G__40000 = cljs.core.first(seq39999);
var seq39999__$1 = cljs.core.next(seq39999);
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic(G__40000,seq39999__$1);
});

/**
 * Create a safe (escaped) js regex out of a string.
 * By default, creates regex with ignore case option.
 */
chimera.js_interop.safe_regex = (function chimera$js_interop$safe_regex(var_args){
var args__7658__auto__ = [];
var len__7651__auto___40009 = arguments.length;
var i__7652__auto___40010 = (0);
while(true){
if((i__7652__auto___40010 < len__7651__auto___40009)){
args__7658__auto__.push((arguments[i__7652__auto___40010]));

var G__40011 = (i__7652__auto___40010 + (1));
i__7652__auto___40010 = G__40011;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic = (function (query_string,p__40006){
var map__40007 = p__40006;
var map__40007__$1 = ((((!((map__40007 == null)))?((((map__40007.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40007.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40007):map__40007);
var ignore_case_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__40007__$1,cljs.core.cst$kw$ignore_DASH_case_QMARK_,true);
return cljs.core.re_pattern([cljs.core.str((cljs.core.truth_(ignore_case_QMARK_)?"(?i)":null)),cljs.core.str(goog.string.regExpEscape(query_string))].join(''));
});

chimera.js_interop.safe_regex.cljs$lang$maxFixedArity = (1);

chimera.js_interop.safe_regex.cljs$lang$applyTo = (function (seq40004){
var G__40005 = cljs.core.first(seq40004);
var seq40004__$1 = cljs.core.next(seq40004);
return chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic(G__40005,seq40004__$1);
});

