// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('chimera.js_interop');
goog.require('cljs.core');
goog.require('cognitect.transit');
goog.require('goog.string');
/**
 * Convert json string to cljs object using transit.
 * Fast, but doesn't preserve keywords.
 */
chimera.js_interop.json__GT_cljs = (function chimera$js_interop$json__GT_cljs(s){
return cognitect.transit.read(cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$json),s);
});
/**
 * Convert json to js using JSON.parse.
 * If error occurs, return the string unmodified.
 */
chimera.js_interop.str__GT_json = (function chimera$js_interop$str__GT_json(string){
try{return JSON.parse(string);
}catch (e22143){if((e22143 instanceof Error)){
var _ = e22143;
return string;
} else {
throw e22143;

}
}});
/**
 * Convert json string to cljs via js.
 * Slow method, but preserves keywords, and appropriate for small json.
 */
chimera.js_interop.json__GT_js__GT_cljs = (function chimera$js_interop$json__GT_js__GT_cljs(s){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(chimera.js_interop.str__GT_json(s),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Formats a string using goog.string.format, so we can use format in cljx.
 */
chimera.js_interop.format = (function chimera$js_interop$format(var_args){
var args__7488__auto__ = [];
var len__7481__auto___22146 = arguments.length;
var i__7482__auto___22147 = (0);
while(true){
if((i__7482__auto___22147 < len__7481__auto___22146)){
args__7488__auto__.push((arguments[i__7482__auto___22147]));

var G__22148 = (i__7482__auto___22147 + (1));
i__7482__auto___22147 = G__22148;
continue;
} else {
}
break;
}

var argseq__7489__auto__ = ((((1) < args__7488__auto__.length))?(new cljs.core.IndexedSeq(args__7488__auto__.slice((1)),(0),null)):null);
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7489__auto__);
});

chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(goog.string.format,fmt,args);
});

chimera.js_interop.format.cljs$lang$maxFixedArity = (1);

chimera.js_interop.format.cljs$lang$applyTo = (function (seq22144){
var G__22145 = cljs.core.first(seq22144);
var seq22144__$1 = cljs.core.next(seq22144);
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic(G__22145,seq22144__$1);
});

/**
 * Create a safe (escaped) js regex out of a string.
 * By default, creates regex with ignore case option.
 */
chimera.js_interop.safe_regex = (function chimera$js_interop$safe_regex(var_args){
var args__7488__auto__ = [];
var len__7481__auto___22154 = arguments.length;
var i__7482__auto___22155 = (0);
while(true){
if((i__7482__auto___22155 < len__7481__auto___22154)){
args__7488__auto__.push((arguments[i__7482__auto___22155]));

var G__22156 = (i__7482__auto___22155 + (1));
i__7482__auto___22155 = G__22156;
continue;
} else {
}
break;
}

var argseq__7489__auto__ = ((((1) < args__7488__auto__.length))?(new cljs.core.IndexedSeq(args__7488__auto__.slice((1)),(0),null)):null);
return chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7489__auto__);
});

chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic = (function (query_string,p__22151){
var map__22152 = p__22151;
var map__22152__$1 = ((((!((map__22152 == null)))?((((map__22152.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22152.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22152):map__22152);
var ignore_case_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__22152__$1,cljs.core.cst$kw$ignore_DASH_case_QMARK_,true);
return cljs.core.re_pattern([cljs.core.str((cljs.core.truth_(ignore_case_QMARK_)?"(?i)":null)),cljs.core.str(goog.string.regExpEscape(query_string))].join(''));
});

chimera.js_interop.safe_regex.cljs$lang$maxFixedArity = (1);

chimera.js_interop.safe_regex.cljs$lang$applyTo = (function (seq22149){
var G__22150 = cljs.core.first(seq22149);
var seq22149__$1 = cljs.core.next(seq22149);
return chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic(G__22150,seq22149__$1);
});

