// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('taoensso.tempura.impl');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('taoensso.encore');
taoensso.tempura.impl.str__GT__QMARK_arg_idx = (function taoensso$tempura$impl$str__GT__QMARK_arg_idx(s){
var G__50980 = s;
switch (G__50980) {
case "%0":
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("`%0` is invalid, starts at `%1`",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$s,s], null));

break;
case "%1":
return (0);

break;
case "%2":
return (1);

break;
case "%3":
return (2);

break;
case "%4":
return (3);

break;
case "%5":
return (4);

break;
case "%6":
return (5);

break;
case "%7":
return (6);

break;
case "%8":
return (7);

break;
case "%9":
return (8);

break;
default:
return null;

}
});
taoensso.tempura.impl.re_clojure_arg = /%\d/;
/**
 * Checks string for simple Clojure-style (%d) args and returns a vector of
 *   string parts and int arg indexes for later joining.
 */
taoensso.tempura.impl.str__GT_split_args = (function taoensso$tempura$impl$str__GT_split_args(s){
if(typeof s === 'string'){
} else {
taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.tempura.impl",25,"(string? s)",s,null,null);
}

if(cljs.core.not((function (){var and__6531__auto__ = taoensso.encore.str_contains_QMARK_(s,"%");
if(and__6531__auto__){
return cljs.core.re_find(taoensso.tempura.impl.re_clojure_arg,s);
} else {
return and__6531__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [s], null);
} else {
var uuid_esc = taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0();
var s__$1 = taoensso.encore.str_replace(s,"`%",uuid_esc);
var _QMARK_arg_seq = cljs.core.re_seq(taoensso.tempura.impl.re_clojure_arg,s__$1);
if(cljs.core.empty_QMARK_(_QMARK_arg_seq)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.encore.str_replace(s__$1,uuid_esc,"%")], null);
} else {
var arg_idxs = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(taoensso.tempura.impl.str__GT__QMARK_arg_idx,_QMARK_arg_seq);
var splits = clojure.string.split.cljs$core$IFn$_invoke$arity$2(s__$1,taoensso.tempura.impl.re_clojure_arg);
var splits__$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (arg_idxs,splits,uuid_esc,s__$1,_QMARK_arg_seq){
return (function (s__$2){
return taoensso.encore.str_replace(s__$2,uuid_esc,"%");
});})(arg_idxs,splits,uuid_esc,s__$1,_QMARK_arg_seq))
,splits);
var _ = (function (){var z = (function (){try{return ((function (arg_idxs,splits,splits__$1,uuid_esc,s__$1,_QMARK_arg_seq){
return (function (arg_idxs_count,splits_count){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(arg_idxs_count,(splits_count - (1)));
});
;})(arg_idxs,splits,splits__$1,uuid_esc,s__$1,_QMARK_arg_seq))
}catch (e50984){if((e50984 instanceof Error)){
var e = e50984;
return (new taoensso.truss.impl.WrappedError(e));
} else {
throw e50984;

}
}})();
var e = (function (){try{if((z instanceof taoensso.truss.impl.WrappedError)){
return z;
} else {
if(taoensso.truss.impl.some_QMARK_(z)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}
}catch (e50985){if((e50985 instanceof Error)){
var e = e50985;
return e;
} else {
throw e50985;

}
}})();
if((e == null)){
return z;
} else {
return taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.tempura.impl",37,"(taoensso.truss.impl/some? (fn [arg-idxs-count splits-count] (= arg-idxs-count (- splits-count 1))))",z,e,null);
}
})();
return taoensso.encore.vinterleave_all(splits__$1,arg_idxs);
}
}
});
/**
 * Returns a (fn [args-vector]) which replaces simple Clojure-style (%n) args
 *   in string with `(str (?argval-fn <corresponding-vector-arg>))`.
 *   Optimized for fn runtime, not fn creation.
 */
taoensso.tempura.impl.str__GT_vargs_fn = (function taoensso$tempura$impl$str__GT_vargs_fn(var_args){
var args50986 = [];
var len__7651__auto___50994 = arguments.length;
var i__7652__auto___50995 = (0);
while(true){
if((i__7652__auto___50995 < len__7651__auto___50994)){
args50986.push((arguments[i__7652__auto___50995]));

var G__50996 = (i__7652__auto___50995 + (1));
i__7652__auto___50995 = G__50996;
continue;
} else {
}
break;
}

var G__50988 = args50986.length;
switch (G__50988) {
case 1:
return taoensso.tempura.impl.str__GT_vargs_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.tempura.impl.str__GT_vargs_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args50986.length)].join('')));

}
});

taoensso.tempura.impl.str__GT_vargs_fn.cljs$core$IFn$_invoke$arity$1 = (function (s){
return taoensso.tempura.impl.str__GT_vargs_fn.cljs$core$IFn$_invoke$arity$2(s,null);
});

taoensso.tempura.impl.str__GT_vargs_fn.cljs$core$IFn$_invoke$arity$2 = (function (s,argval_fn){
var e_50998 = (function (){try{if(taoensso.encore.nblank_QMARK_(s)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e50989){if((e50989 instanceof Error)){
var e = e50989;
return e;
} else {
throw e50989;

}
}})();
if((e_50998 == null)){
} else {
taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.tempura.impl",49,"(enc/nblank? s)",s,e_50998,null);
}

var parts = taoensso.tempura.impl.str__GT_split_args(s);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(parts),(1))){
var vec__50990 = parts;
var s1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50990,(0),null);
return ((function (vec__50990,s1,parts){
return (function (vargs){
return s1;
});
;})(vec__50990,s1,parts))
} else {
var argval_fn__$1 = (function (){var or__6543__auto__ = argval_fn;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return taoensso.encore.undefined__GT_nil;
}
})();
return ((function (argval_fn__$1,parts){
return (function (vargs){
var sb = taoensso.encore.str_builder.cljs$core$IFn$_invoke$arity$0();
cljs.core.run_BANG_(((function (sb,argval_fn__$1,parts){
return (function (p){
if(typeof p === 'string'){
return taoensso.encore.sb_append.cljs$core$IFn$_invoke$arity$2(sb,p);
} else {
return taoensso.encore.sb_append.cljs$core$IFn$_invoke$arity$2(sb,[cljs.core.str((function (){var G__50993 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vargs,p);
return (argval_fn__$1.cljs$core$IFn$_invoke$arity$1 ? argval_fn__$1.cljs$core$IFn$_invoke$arity$1(G__50993) : argval_fn__$1.call(null,G__50993));
})())].join(''));
}
});})(sb,argval_fn__$1,parts))
,parts);

return [cljs.core.str(sb)].join('');
});
;})(argval_fn__$1,parts))
}
});

taoensso.tempura.impl.str__GT_vargs_fn.cljs$lang$maxFixedArity = 2;

taoensso.tempura.impl.mapv_nested = (function taoensso$tempura$impl$mapv_nested(f,v){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function taoensso$tempura$impl$mapv_nested_$_f1(in$){
if(cljs.core.vector_QMARK_(in$)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(taoensso$tempura$impl$mapv_nested_$_f1,in$);
} else {
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(in$) : f.call(null,in$));
}
}),v);
});
taoensso.tempura.impl.reducev_nested = (function taoensso$tempura$impl$reducev_nested(rf,v){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function taoensso$tempura$impl$reducev_nested_$_rf1(acc,in$){
if(cljs.core.vector_QMARK_(in$)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(taoensso$tempura$impl$reducev_nested_$_rf1,cljs.core.PersistentVector.EMPTY,in$));
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(acc,in$) : rf.call(null,acc,in$));
}
}),cljs.core.PersistentVector.EMPTY,v);
});
taoensso.tempura.impl.node_paths = (function taoensso$tempura$impl$node_paths(var_args){
var args51000 = [];
var len__7651__auto___51003 = arguments.length;
var i__7652__auto___51004 = (0);
while(true){
if((i__7652__auto___51004 < len__7651__auto___51003)){
args51000.push((arguments[i__7652__auto___51004]));

var G__51005 = (i__7652__auto___51004 + (1));
i__7652__auto___51004 = G__51005;
continue;
} else {
}
break;
}

var G__51002 = args51000.length;
switch (G__51002) {
case 1:
return taoensso.tempura.impl.node_paths.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.tempura.impl.node_paths.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return taoensso.tempura.impl.node_paths.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args51000.length)].join('')));

}
});

taoensso.tempura.impl.node_paths.cljs$core$IFn$_invoke$arity$1 = (function (m){
return taoensso.tempura.impl.node_paths.cljs$core$IFn$_invoke$arity$3(cljs.core.associative_QMARK_,m,null);
});

taoensso.tempura.impl.node_paths.cljs$core$IFn$_invoke$arity$2 = (function (node_pred,m){
return taoensso.tempura.impl.node_paths.cljs$core$IFn$_invoke$arity$3(node_pred,m,null);
});

taoensso.tempura.impl.node_paths.cljs$core$IFn$_invoke$arity$3 = (function (node_pred,m,basis){
var basis__$1 = (function (){var or__6543__auto__ = basis;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})();
return cljs.core.reduce_kv(((function (basis__$1){
return (function (acc,k,v){
if(cljs.core.not((node_pred.cljs$core$IFn$_invoke$arity$1 ? node_pred.cljs$core$IFn$_invoke$arity$1(v) : node_pred.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(basis__$1,k,cljs.core.array_seq([v], 0)));
} else {
var paths_from_basis = taoensso.tempura.impl.node_paths.cljs$core$IFn$_invoke$arity$3(node_pred,v,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(basis__$1,k));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,paths_from_basis);
}
});})(basis__$1))
,cljs.core.PersistentVector.EMPTY,m);
});

taoensso.tempura.impl.node_paths.cljs$lang$maxFixedArity = 3;

/**
 * Returns a (fn [args-vector]) which replaces simple Clojure-style (%n) arg
 *   elements with `(?argval-fn <corresponding-vector-arg>)`.
 *   Optimized for fn runtime, not fn creation.
 */
taoensso.tempura.impl.vec__GT_vargs_fn = (function taoensso$tempura$impl$vec__GT_vargs_fn(var_args){
var args51007 = [];
var len__7651__auto___51012 = arguments.length;
var i__7652__auto___51013 = (0);
while(true){
if((i__7652__auto___51013 < len__7651__auto___51012)){
args51007.push((arguments[i__7652__auto___51013]));

var G__51014 = (i__7652__auto___51013 + (1));
i__7652__auto___51013 = G__51014;
continue;
} else {
}
break;
}

var G__51009 = args51007.length;
switch (G__51009) {
case 1:
return taoensso.tempura.impl.vec__GT_vargs_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.tempura.impl.vec__GT_vargs_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args51007.length)].join('')));

}
});

taoensso.tempura.impl.vec__GT_vargs_fn.cljs$core$IFn$_invoke$arity$1 = (function (v){
return taoensso.tempura.impl.vec__GT_vargs_fn.cljs$core$IFn$_invoke$arity$2(v,null);
});

taoensso.tempura.impl.vec__GT_vargs_fn.cljs$core$IFn$_invoke$arity$2 = (function (v,argval_fn){
if(cljs.core.vector_QMARK_(v)){
} else {
taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.tempura.impl",132,"(vector? v)",v,null,null);
}

var node_paths = taoensso.tempura.impl.node_paths.cljs$core$IFn$_invoke$arity$1(v);
var idxs__GT_arg_idxs = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (node_paths){
return (function (acc,in$){
var el = cljs.core.peek(in$);
if(!((el instanceof cljs.core.Symbol))){
return acc;
} else {
var temp__4655__auto__ = taoensso.tempura.impl.str__GT__QMARK_arg_idx(cljs.core.name(el));
if(cljs.core.truth_(temp__4655__auto__)){
var idx = temp__4655__auto__;
return cljs.core.assoc_in(acc,cljs.core.pop(in$),idx);
} else {
return acc;
}
}
});})(node_paths))
,cljs.core.PersistentArrayMap.EMPTY,node_paths);
if(cljs.core.empty_QMARK_(idxs__GT_arg_idxs)){
return ((function (node_paths,idxs__GT_arg_idxs){
return (function (vargs){
return v;
});
;})(node_paths,idxs__GT_arg_idxs))
} else {
var argval_fn__$1 = (function (){var or__6543__auto__ = argval_fn;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.identity;
}
})();
return ((function (argval_fn__$1,node_paths,idxs__GT_arg_idxs){
return (function (vargs){
return cljs.core.reduce_kv(((function (argval_fn__$1,node_paths,idxs__GT_arg_idxs){
return (function taoensso$tempura$impl$rf1(acc,k,v__$1){
if(cljs.core.map_QMARK_(v__$1)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,cljs.core.reduce_kv(taoensso$tempura$impl$rf1,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,k),v__$1));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,(function (){var G__51011 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vargs,v__$1);
return (argval_fn__$1.cljs$core$IFn$_invoke$arity$1 ? argval_fn__$1.cljs$core$IFn$_invoke$arity$1(G__51011) : argval_fn__$1.call(null,G__51011));
})());
}
});})(argval_fn__$1,node_paths,idxs__GT_arg_idxs))
,v,idxs__GT_arg_idxs);
});
;})(argval_fn__$1,node_paths,idxs__GT_arg_idxs))
}
});

taoensso.tempura.impl.vec__GT_vargs_fn.cljs$lang$maxFixedArity = 2;

taoensso.tempura.impl.vec_explode_args_in_strs = (function taoensso$tempura$impl$vec_explode_args_in_strs(v){
if(cljs.core.vector_QMARK_(v)){
} else {
taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.tempura.impl",174,"(vector? v)",v,null,null);
}

return taoensso.tempura.impl.reducev_nested((function (acc,in$){
if(!(typeof in$ === 'string')){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,in$);
} else {
var parts = taoensso.tempura.impl.str__GT_split_args(in$);
var parts__$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (parts){
return (function (p){
if(typeof p === 'string'){
return p;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str("%"),cljs.core.str((p + (1)))].join(''));
}
});})(parts))
,parts);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,parts__$1);
}
}),v);
});
taoensso.tempura.impl.str__GT_split_styles = (function taoensso$tempura$impl$str__GT_split_styles(s){
if(typeof s === 'string'){
} else {
taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.tempura.impl",192,"(string? s)",s,null,null);
}

var matches_ = cljs.core.volatile_BANG_(cljs.core.PersistentArrayMap.EMPTY);
var replace_matches = ((function (matches_){
return (function (s__$1,regex,tag){
return taoensso.encore.str_replace(s__$1,regex,((function (matches_){
return (function (p__51022){
var vec__51023 = p__51022;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51023,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51023,(1),null);
var content = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51023,(2),null);
var uuid = taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0();
cljs.core._vreset_BANG_(matches_,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core._deref(matches_),uuid,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag,content], null)));

return uuid;
});})(matches_))
);
});})(matches_))
;
var uuid_esc_STAR_ = taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0();
var uuid_esc_ = taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0();
var uuid_esc_tilde = taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0();
var s__$1 = taoensso.encore.str_replace(s,"`*",uuid_esc_STAR_);
var s__$2 = taoensso.encore.str_replace(s__$1,"`_",uuid_esc_);
var s__$3 = taoensso.encore.str_replace(s__$2,"`~",uuid_esc_tilde);
var s__$4 = replace_matches(s__$3,/(\*\*)([^\*\r\n]+)\1/,cljs.core.cst$kw$strong);
var s__$5 = replace_matches(s__$4,/(__)([^_\r\n]+)\1/,cljs.core.cst$kw$b);
var s__$6 = replace_matches(s__$5,/(\*)([^\*\r\n]+)\1/,cljs.core.cst$kw$em);
var s__$7 = replace_matches(s__$6,/(_)([^_\r\n]+)\1/,cljs.core.cst$kw$i);
var s__$8 = replace_matches(s__$7,/(~~)([^~\r\n]+)\1/,cljs.core.cst$kw$s);
var s__$9 = taoensso.encore.str_replace(s__$8,uuid_esc_STAR_,"*");
var s__$10 = taoensso.encore.str_replace(s__$9,uuid_esc_,"_");
var s__$11 = taoensso.encore.str_replace(s__$10,uuid_esc_tilde,"~");
var matches = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(matches_) : cljs.core.deref.call(null,matches_));
if(cljs.core.empty_QMARK_(matches)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [s__$11], null);
} else {
var ordered_match_ks = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(((function (matches_,replace_matches,uuid_esc_STAR_,uuid_esc_,uuid_esc_tilde,s__$1,s__$2,s__$3,s__$4,s__$5,s__$6,s__$7,s__$8,s__$9,s__$10,s__$11,matches){
return (function (p1__51016_SHARP_){
return taoensso.encore.str__QMARK_index.cljs$core$IFn$_invoke$arity$2(s__$11,p1__51016_SHARP_);
});})(matches_,replace_matches,uuid_esc_STAR_,uuid_esc_,uuid_esc_tilde,s__$1,s__$2,s__$3,s__$4,s__$5,s__$6,s__$7,s__$8,s__$9,s__$10,s__$11,matches))
,cljs.core.keys(matches));
var ordered_match_vs = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (ordered_match_ks,matches_,replace_matches,uuid_esc_STAR_,uuid_esc_,uuid_esc_tilde,s__$1,s__$2,s__$3,s__$4,s__$5,s__$6,s__$7,s__$8,s__$9,s__$10,s__$11,matches){
return (function (p1__51017_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(matches,p1__51017_SHARP_);
});})(ordered_match_ks,matches_,replace_matches,uuid_esc_STAR_,uuid_esc_,uuid_esc_tilde,s__$1,s__$2,s__$3,s__$4,s__$5,s__$6,s__$7,s__$8,s__$9,s__$10,s__$11,matches))
,ordered_match_ks);
var splits = clojure.string.split.cljs$core$IFn$_invoke$arity$2(s__$11,cljs.core.re_pattern(clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",ordered_match_ks)));
return taoensso.encore.vinterleave_all(splits,ordered_match_vs);
}
});
/**
 * ["foo"] -> [:span "foo"] as a convenience.
 */
taoensso.tempura.impl.vec__GT_vtag = (function taoensso$tempura$impl$vec__GT_vtag(v){
if(cljs.core.vector_QMARK_(v)){
} else {
taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.tempura.impl",241,"(vector? v)",v,null,null);
}

var vec__51029 = v;
var v1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51029,(0),null);
if(!((v1 instanceof cljs.core.Keyword))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span], null),v);
} else {
return v;
}
});
taoensso.tempura.impl.vec_explode_styles_in_strs = (function taoensso$tempura$impl$vec_explode_styles_in_strs(var_args){
var args51032 = [];
var len__7651__auto___51035 = arguments.length;
var i__7652__auto___51036 = (0);
while(true){
if((i__7652__auto___51036 < len__7651__auto___51035)){
args51032.push((arguments[i__7652__auto___51036]));

var G__51037 = (i__7652__auto___51036 + (1));
i__7652__auto___51036 = G__51037;
continue;
} else {
}
break;
}

var G__51034 = args51032.length;
switch (G__51034) {
case 1:
return taoensso.tempura.impl.vec_explode_styles_in_strs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.tempura.impl.vec_explode_styles_in_strs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args51032.length)].join('')));

}
});

taoensso.tempura.impl.vec_explode_styles_in_strs.cljs$core$IFn$_invoke$arity$1 = (function (v){
return taoensso.tempura.impl.vec_explode_styles_in_strs.cljs$core$IFn$_invoke$arity$2(v,taoensso.tempura.impl.str__GT_split_styles);
});

taoensso.tempura.impl.vec_explode_styles_in_strs.cljs$core$IFn$_invoke$arity$2 = (function (v,str_splitter){
if(cljs.core.vector_QMARK_(v)){
} else {
taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.tempura.impl",255,"(vector? v)",v,null,null);
}

return taoensso.tempura.impl.reducev_nested((function (acc,in$){
if(!(typeof in$ === 'string')){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,in$);
} else {
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,(str_splitter.cljs$core$IFn$_invoke$arity$1 ? str_splitter.cljs$core$IFn$_invoke$arity$1(in$) : str_splitter.call(null,in$)));
}
}),v);
});

taoensso.tempura.impl.vec_explode_styles_in_strs.cljs$lang$maxFixedArity = 2;

taoensso.tempura.impl.escape_html = (function taoensso$tempura$impl$escape_html(s){
return taoensso.encore.str_replace(taoensso.encore.str_replace(taoensso.encore.str_replace(taoensso.encore.str_replace(s,"&","&amp;"),"<","&lt;"),">","&gt;"),"\"","&quot;");
});
taoensso.tempura.impl.vec_escape_html_in_strs = (function taoensso$tempura$impl$vec_escape_html_in_strs(v){
if(cljs.core.vector_QMARK_(v)){
} else {
taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.tempura.impl",280,"(vector? v)",v,null,null);
}

return taoensso.tempura.impl.mapv_nested((function (x){
if(typeof x === 'string'){
return taoensso.tempura.impl.escape_html(x);
} else {
return x;
}
}),v);
});
taoensso.tempura.impl.expand_locales = (function (){var expand_locale = taoensso.encore.memoize_((function (locale){
var parts = clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name(locale),/[_-]/);
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (parts){
return (function (p1__51039_SHARP_){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2("-",p1__51039_SHARP_));
});})(parts))
,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.iterate(cljs.core.butlast,parts)));
}));
var expand_locales_STAR_ = ((function (expand_locale){
return (function (locales){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(locales),(1))){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__51040 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(locales,(0));
return (expand_locale.cljs$core$IFn$_invoke$arity$1 ? expand_locale.cljs$core$IFn$_invoke$arity$1(G__51040) : expand_locale.call(null,G__51040));
})()], null);
} else {
var vec__51041 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (expand_locale){
return (function (p__51044,in$){
var vec__51045 = p__51044;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51045,(0),null);
var seen = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51045,(1),null);
var lvars = (expand_locale.cljs$core$IFn$_invoke$arity$1 ? expand_locale.cljs$core$IFn$_invoke$arity$1(in$) : expand_locale.call(null,in$));
var lbase = cljs.core.peek(lvars);
if(cljs.core.truth_((seen.cljs$core$IFn$_invoke$arity$1 ? seen.cljs$core$IFn$_invoke$arity$1(lbase) : seen.call(null,lbase)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,seen], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,lvars),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen,lbase)], null);
}
});})(expand_locale))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),locales);
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51041,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51041,(1),null);
return acc;
}
});})(expand_locale))
;
var expand_locales_STAR__cached = taoensso.encore.memoize_(expand_locales_STAR_);
return ((function (expand_locale,expand_locales_STAR_,expand_locales_STAR__cached){
return (function (cache_QMARK_,locales){
if(cljs.core.truth_(cache_QMARK_)){
return (expand_locales_STAR__cached.cljs$core$IFn$_invoke$arity$1 ? expand_locales_STAR__cached.cljs$core$IFn$_invoke$arity$1(locales) : expand_locales_STAR__cached.call(null,locales));
} else {
return expand_locales_STAR_(locales);
}
});
;})(expand_locale,expand_locales_STAR_,expand_locales_STAR__cached))
})();
taoensso.tempura.impl.compile_dictionary = (function (){var load_resource = (function (rname){
return null;
});
var preprocess = ((function (load_resource){
return (function (dict){
return cljs.core.reduce_kv(((function (load_resource){
return (function taoensso$tempura$impl$rf1(acc,k,v){
if((v instanceof cljs.core.Keyword)){
var path = taoensso.encore.explode_keyword(v);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dict,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword,path)));
} else {
if(cljs.core.map_QMARK_(v)){
var temp__4655__auto__ = cljs.core.cst$kw$__load_DASH_resource.cljs$core$IFn$_invoke$arity$1(v);
if(cljs.core.truth_(temp__4655__auto__)){
var io_res = temp__4655__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,load_resource(io_res));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,cljs.core.reduce_kv(taoensso$tempura$impl$rf1,cljs.core.PersistentArrayMap.EMPTY,v));
}
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v);

}
}
});})(load_resource))
,cljs.core.PersistentArrayMap.EMPTY,dict);
});})(load_resource))
;
var optimize = taoensso.encore.memoize_(((function (load_resource,preprocess){
return (function (dict){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (load_resource,preprocess){
return (function (acc,in$){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,taoensso.encore.merge_keywords.cljs$core$IFn$_invoke$arity$1(cljs.core.pop(in$)),cljs.core.peek(in$));
});})(load_resource,preprocess))
,cljs.core.PersistentArrayMap.EMPTY,taoensso.tempura.impl.node_paths.cljs$core$IFn$_invoke$arity$2(cljs.core.map_QMARK_,dict));
});})(load_resource,preprocess))
);
var compile_dictionary_STAR_ = taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$2((1000),((function (load_resource,preprocess,optimize){
return (function (dict){
var G__51048 = preprocess(preprocess(dict));
return (optimize.cljs$core$IFn$_invoke$arity$1 ? optimize.cljs$core$IFn$_invoke$arity$1(G__51048) : optimize.call(null,G__51048));
});})(load_resource,preprocess,optimize))
);
var compile_dictionary_STAR__cached = taoensso.encore.memoize_(compile_dictionary_STAR_);
return ((function (load_resource,preprocess,optimize,compile_dictionary_STAR_,compile_dictionary_STAR__cached){
return (function (cache_QMARK_,dict){
if(cljs.core.truth_(cache_QMARK_)){
return (compile_dictionary_STAR__cached.cljs$core$IFn$_invoke$arity$1 ? compile_dictionary_STAR__cached.cljs$core$IFn$_invoke$arity$1(dict) : compile_dictionary_STAR__cached.call(null,dict));
} else {
return (compile_dictionary_STAR_.cljs$core$IFn$_invoke$arity$1 ? compile_dictionary_STAR_.cljs$core$IFn$_invoke$arity$1(dict) : compile_dictionary_STAR_.call(null,dict));
}
});
;})(load_resource,preprocess,optimize,compile_dictionary_STAR_,compile_dictionary_STAR__cached))
})();
taoensso.tempura.impl.vargs = (function taoensso$tempura$impl$vargs(x){
if(cljs.core.map_QMARK_(x)){
var max_idx = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__51049_SHARP_,p2__51050_SHARP_){
var n1__18370__auto__ = p1__51049_SHARP_;
var n2__18371__auto__ = p2__51050_SHARP_;
if((n1__18370__auto__ < n2__18371__auto__)){
return n2__18371__auto__;
} else {
return n1__18370__auto__;
}
}),(0),cljs.core.keys(x));
if((cljs.core.get.cljs$core$IFn$_invoke$arity$2(x,(0)) == null)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("All arg map keys must be +ive non-zero ints"),cljs.core.str("\n"),cljs.core.str("(nil? (get x 0))")].join('')));
}

return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (max_idx){
return (function (idx){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(x,idx);
});})(max_idx))
,cljs.core.range.cljs$core$IFn$_invoke$arity$2((1),(max_idx + (1))));
} else {
if(cljs.core.vector_QMARK_(x)){
return x;
} else {
return taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.tempura.impl",410,"(vector? x)",x,null,null);
}
}
});
