// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('chimera.i18n');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('taoensso.tempura');
chimera.i18n.generate_filename = (function chimera$i18n$generate_filename(language_code,styling_theme){
return [cljs.core.str("translations/"),cljs.core.str(cljs.core.name(styling_theme)),cljs.core.str("/"),cljs.core.str(cljs.core.name(language_code)),cljs.core.str(".clj")].join('');
});
/**
 * Generate a map with languagecodes as keys, file names as values
 */
chimera.i18n.dictionary = (function chimera$i18n$dictionary(languages){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__51104){
var map__51105 = p__51104;
var map__51105__$1 = ((((!((map__51105 == null)))?((((map__51105.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51105.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__51105):map__51105);
var iso_code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51105__$1,cljs.core.cst$kw$iso_DASH_code);
var styling_theme = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51105__$1,cljs.core.cst$kw$styling_DASH_theme);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,iso_code,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$__load_DASH_resource,chimera.i18n.generate_filename(iso_code,styling_theme)], null));
}),cljs.core.PersistentArrayMap.EMPTY,languages);
});
chimera.i18n.merge_keywords = (function chimera$i18n$merge_keywords(keywords){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword,cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__51107_SHARP_){
var G__51109 = p1__51107_SHARP_;
var G__51109__$1 = (((G__51109 == null))?null:[cljs.core.str(G__51109)].join(''));
if((G__51109__$1 == null)){
return null;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(G__51109__$1,(1));
}
}),keywords));
});
/**
 * Call the library translation function. If the final argument is a vector
 * assume it is a resource-arg and the rest make up a keyword resource ID,
 * otherwise assume all args make up a keyword resource ID.
 */
chimera.i18n.tr = (function chimera$i18n$tr(opts,language_codes,args){
var last_arg = cljs.core.last(args);
var has_args_QMARK_ = cljs.core.vector_QMARK_(last_arg);
var resource_ids = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [chimera.i18n.merge_keywords(((has_args_QMARK_)?cljs.core.butlast(args):args))], null);
return taoensso.tempura.tr.cljs$core$IFn$_invoke$arity$4(opts,language_codes,resource_ids,((has_args_QMARK_)?last_arg:null));
});
