// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core');
goog.require('goog.math.Long');
goog.require('goog.math.Integer');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.array');
goog.require('goog.string.StringBuffer');
cljs.core._STAR_clojurescript_version_STAR_ = "1.9.293";
cljs.core._STAR_unchecked_if_STAR_ = false;
if(typeof cljs.core.PROTOCOL_SENTINEL !== 'undefined'){
} else {
cljs.core.PROTOCOL_SENTINEL = ({});
}

/** @define {string} */
goog.define("cljs.core._STAR_target_STAR_","default");
/**
 * Var bound to the current namespace. Only used for bootstrapping.
 * @type {*}
 */
cljs.core._STAR_ns_STAR_ = null;
/**
 * @type {*}
 */
cljs.core._STAR_out_STAR_ = null;
cljs.core._STAR_assert_STAR_ = true;
if(typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined'){
} else {
/**
 * Each runtime environment provides a different way to print output.
 *   Whatever function *print-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_fn_STAR_ = (function cljs$core$_STAR_print_fn_STAR_(_){
throw (new Error("No *print-fn* fn set for evaluation environment"));
});
}
if(typeof cljs.core._STAR_print_err_fn_STAR_ !== 'undefined'){
} else {
/**
 * Each runtime environment provides a different way to print error output.
 *   Whatever function *print-err-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_err_fn_STAR_ = (function cljs$core$_STAR_print_err_fn_STAR_(_){
throw (new Error("No *print-err-fn* fn set for evaluation environment"));
});
}
/**
 * Set *print-fn* to f.
 */
cljs.core.set_print_fn_BANG_ = (function cljs$core$set_print_fn_BANG_(f){
return cljs.core._STAR_print_fn_STAR_ = f;
});
/**
 * Set *print-err-fn* to f.
 */
cljs.core.set_print_err_fn_BANG_ = (function cljs$core$set_print_err_fn_BANG_(f){
return cljs.core._STAR_print_err_fn_STAR_ = f;
});
/**
 * When set to true, output will be flushed whenever a newline is printed.
 * 
 *   Defaults to true.
 */
cljs.core._STAR_flush_on_newline_STAR_ = true;
/**
 * When set to logical false will drop newlines from printing calls.
 *   This is to work around the implicit newlines emitted by standard JavaScript
 *   console objects.
 */
cljs.core._STAR_print_newline_STAR_ = true;
/**
 * When set to logical false, strings and characters will be printed with
 *   non-alphanumeric characters converted to the appropriate escape sequences.
 * 
 *   Defaults to true
 */
cljs.core._STAR_print_readably_STAR_ = true;
/**
 * If set to logical true, when printing an object, its metadata will also
 *   be printed in a form that can be read back by the reader.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_meta_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 *   their type when read in later.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_dup_STAR_ = false;
/**
 * *print-length* controls how many items of each collection the
 *   printer will print. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   number of items of each collection to print. If a collection contains
 *   more items, the printer will print items up to the limit followed by
 *   '...' to represent the remaining items. The root binding is nil
 *   indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_length_STAR_ = null;
/**
 * *print-level* controls how many levels deep the printer will
 *   print nested objects. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   level to print. Each argument to print is at level 0; if an argument is a
 *   collection, its items are at level 1; and so on. If an object is a
 *   collection and is at a level greater than or equal to the value bound to
 *   *print-level*, the printer prints '#' to represent it. The root binding
 *   is nil indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_level_STAR_ = null;
if(typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined'){
} else {
/**
 * @type {*}
 */
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function cljs$core$pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$flush_DASH_on_DASH_newline,cljs.core._STAR_flush_on_newline_STAR_,cljs.core.cst$kw$readably,cljs.core._STAR_print_readably_STAR_,cljs.core.cst$kw$meta,cljs.core._STAR_print_meta_STAR_,cljs.core.cst$kw$dup,cljs.core._STAR_print_dup_STAR_,cljs.core.cst$kw$print_DASH_length,cljs.core._STAR_print_length_STAR_], null);
});
/**
 * Set *print-fn* to console.log
 */
cljs.core.enable_console_print_BANG_ = (function cljs$core$enable_console_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core._STAR_print_fn_STAR_ = (function() { 
var G__41895__delegate = function (args){
return console.log.apply(console,(cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args) : cljs.core.into_array.call(null,args)));
};
var G__41895 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__41896__i = 0, G__41896__a = new Array(arguments.length -  0);
while (G__41896__i < G__41896__a.length) {G__41896__a[G__41896__i] = arguments[G__41896__i + 0]; ++G__41896__i;}
  args = new cljs.core.IndexedSeq(G__41896__a,0);
} 
return G__41895__delegate.call(this,args);};
G__41895.cljs$lang$maxFixedArity = 0;
G__41895.cljs$lang$applyTo = (function (arglist__41897){
var args = cljs.core.seq(arglist__41897);
return G__41895__delegate(args);
});
G__41895.cljs$core$IFn$_invoke$arity$variadic = G__41895__delegate;
return G__41895;
})()
;

cljs.core._STAR_print_err_fn_STAR_ = (function() { 
var G__41898__delegate = function (args){
return console.error.apply(console,(cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args) : cljs.core.into_array.call(null,args)));
};
var G__41898 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__41899__i = 0, G__41899__a = new Array(arguments.length -  0);
while (G__41899__i < G__41899__a.length) {G__41899__a[G__41899__i] = arguments[G__41899__i + 0]; ++G__41899__i;}
  args = new cljs.core.IndexedSeq(G__41899__a,0);
} 
return G__41898__delegate.call(this,args);};
G__41898.cljs$lang$maxFixedArity = 0;
G__41898.cljs$lang$applyTo = (function (arglist__41900){
var args = cljs.core.seq(arglist__41900);
return G__41898__delegate(args);
});
G__41898.cljs$core$IFn$_invoke$arity$variadic = G__41898__delegate;
return G__41898;
})()
;

return null;
});
/**
 * Internal - do not use!
 */
cljs.core.truth_ = (function cljs$core$truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;

/**
 * Tests if 2 arguments are the same object
 */
cljs.core.identical_QMARK_ = (function cljs$core$identical_QMARK_(x,y){
return (x === y);
});
/**
 * Returns true if x is nil, false otherwise.
 */
cljs.core.nil_QMARK_ = (function cljs$core$nil_QMARK_(x){
return (x == null);
});
/**
 * Returns true if x is a JavaScript array.
 */
cljs.core.array_QMARK_ = (function cljs$core$array_QMARK_(x){
if((cljs.core._STAR_target_STAR_ === "nodejs")){
return Array.isArray(x);
} else {
return (x instanceof Array);
}
});
/**
 * Returns true if x is a JavaScript number.
 */
cljs.core.number_QMARK_ = (function cljs$core$number_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true if x is logical false, false otherwise.
 */
cljs.core.not = (function cljs$core$not(x){
if((x == null)){
return true;
} else {
if(x === false){
return true;
} else {
return false;

}
}
});
/**
 * Returns true if x is not nil, false otherwise.
 */
cljs.core.some_QMARK_ = (function cljs$core$some_QMARK_(x){
return !((x == null));
});
/**
 * Returns true if x's constructor is Object
 */
cljs.core.object_QMARK_ = (function cljs$core$object_QMARK_(x){
if(!((x == null))){
return (x.constructor === Object);
} else {
return false;
}
});
/**
 * Returns true if x is a JavaScript string.
 */
cljs.core.string_QMARK_ = (function cljs$core$string_QMARK_(x){
return goog.isString(x);
});
/**
 * Returns true if x is a JavaScript string of length one.
 */
cljs.core.char_QMARK_ = (function cljs$core$char_QMARK_(x){
return (typeof x === 'string') && (((1) === x.length));
});
/**
 * Returns true if given any argument.
 */
cljs.core.any_QMARK_ = (function cljs$core$any_QMARK_(x){
return true;
});
/**
 * Internal - do not use!
 */
cljs.core.native_satisfies_QMARK_ = (function cljs$core$native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[goog.typeOf(x__$1)])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function cljs$core$is_proto_(x){
return (x.constructor.prototype === x);
});
/**
 * When compiled for a command-line target, whatever function
 *   *main-cli-fn* is set to will be called with the command-line
 *   argv as arguments
 */
cljs.core._STAR_main_cli_fn_STAR_ = null;
/**
 * Return x's constructor.
 */
cljs.core.type = (function cljs$core$type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function cljs$core$missing_protocol(proto,obj){
var ty = cljs.core.type(obj);
var ty__$1 = (cljs.core.truth_((function (){var and__6531__auto__ = ty;
if(cljs.core.truth_(and__6531__auto__)){
return ty.cljs$lang$type;
} else {
return and__6531__auto__;
}
})())?ty.cljs$lang$ctorStr:goog.typeOf(obj));
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function cljs$core$type__GT_str(ty){
var temp__4655__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__4655__auto__)){
var s = temp__4655__auto__;
return s;
} else {
return [cljs.core.str(ty)].join('');
}
});
cljs.core.load_file = (function cljs$core$load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.nodeGlobalRequire(file);
}
});
if((typeof Symbol !== 'undefined') && ((goog.typeOf(Symbol) === "function"))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
/**
 * @enum {string}
 */
cljs.core.CHAR_MAP = ({"]": "_RBRACK_", "'": "_SINGLEQUOTE_", "=": "_EQ_", "\"": "_DOUBLEQUOTE_", "!": "_BANG_", "*": "_STAR_", "%": "_PERCENT_", "|": "_BAR_", "~": "_TILDE_", "/": "_SLASH_", "\\": "_BSLASH_", "-": "_", "?": "_QMARK_", "&": "_AMPERSAND_", ":": "_COLON_", "<": "_LT_", "{": "_LBRACE_", "}": "_RBRACE_", "[": "_LBRACK_", "#": "_SHARP_", "^": "_CARET_", "+": "_PLUS_", "@": "_CIRCA_", ">": "_GT_"});
/**
 * @enum {string}
 */
cljs.core.DEMUNGE_MAP = ({"_RBRACE_": "}", "_COLON_": ":", "_BANG_": "!", "_QMARK_": "?", "_BSLASH_": "\\\\", "_SLASH_": "/", "_PERCENT_": "%", "_PLUS_": "+", "_SHARP_": "#", "_LBRACE_": "{", "_BAR_": "|", "_LBRACK_": "[", "_EQ_": "=", "_": "-", "_TILDE_": "~", "_RBRACK_": "]", "_GT_": ">", "_SINGLEQUOTE_": "'", "_CIRCA_": "@", "_AMPERSAND_": "&", "_DOUBLEQUOTE_": "\\\"", "_CARET_": "^", "_LT_": "<", "_STAR_": "*"});
cljs.core.DEMUNGE_PATTERN = null;
/**
 * Returns highest resolution time offered by host in milliseconds.
 */
cljs.core.system_time = (function cljs$core$system_time(){
if((typeof performance !== 'undefined') && (!((performance.now == null)))){
return performance.now();
} else {
if((typeof process !== 'undefined') && (!((process.hrtime == null)))){
var t = process.hrtime();
return ((((t[(0)]) * 1.0E9) + (t[(1)])) / 1000000.0);
} else {
return (new Date()).getTime();

}
}
});
/**
 * Construct a JavaScript array of the specified dimensions. Accepts ignored
 *   type argument for compatibility with Clojure. Note that there is no efficient
 *   way to allocate multi-dimensional arrays in JavaScript; as such, this function
 *   will run in polynomial time when called with 3 or more arguments.
 */
cljs.core.make_array = (function cljs$core$make_array(var_args){
var args41901 = [];
var len__7651__auto___41907 = arguments.length;
var i__7652__auto___41908 = (0);
while(true){
if((i__7652__auto___41908 < len__7651__auto___41907)){
args41901.push((arguments[i__7652__auto___41908]));

var G__41909 = (i__7652__auto___41908 + (1));
i__7652__auto___41908 = G__41909;
continue;
} else {
}
break;
}

var G__41906 = args41901.length;
switch (G__41906) {
case 1:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args41901.slice((2)),(0),null));
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = (function (size){
return (new Array(size));
});

cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = (function (type,size){
return (new Array(size));
});

cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic = (function (type,size,more_sizes){
var dims = more_sizes;
var dimarray = (new Array(size));
var n__7461__auto___41911 = dimarray.length;
var i_41912 = (0);
while(true){
if((i_41912 < n__7461__auto___41911)){
(dimarray[i_41912] = (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.make_array,null,dims) : cljs.core.apply.call(null,cljs.core.make_array,null,dims)));

var G__41913 = (i_41912 + (1));
i_41912 = G__41913;
continue;
} else {
}
break;
}

return dimarray;
});

cljs.core.make_array.cljs$lang$applyTo = (function (seq41902){
var G__41903 = cljs.core.first(seq41902);
var seq41902__$1 = cljs.core.next(seq41902);
var G__41904 = cljs.core.first(seq41902__$1);
var seq41902__$2 = cljs.core.next(seq41902__$1);
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic(G__41903,G__41904,seq41902__$2);
});

cljs.core.make_array.cljs$lang$maxFixedArity = (2);

/**
 * Returns a javascript array, cloned from the passed in array
 */
cljs.core.aclone = (function cljs$core$aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__7461__auto___41914 = len;
var i_41915 = (0);
while(true){
if((i_41915 < n__7461__auto___41914)){
(new_arr[i_41915] = (arr[i_41915]));

var G__41916 = (i_41915 + (1));
i_41915 = G__41916;
continue;
} else {
}
break;
}

return new_arr;
});
/**
 * Creates a new javascript array.
 * @param {...*} var_args
 */
cljs.core.array = (function cljs$core$array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__41917 = (i + (1));
i = G__41917;
continue;
} else {
return a;
}
break;
}
});
/**
 * Returns the value at the index.
 */
cljs.core.aget = (function cljs$core$aget(var_args){
var args41918 = [];
var len__7651__auto___41927 = arguments.length;
var i__7652__auto___41928 = (0);
while(true){
if((i__7652__auto___41928 < len__7651__auto___41927)){
args41918.push((arguments[i__7652__auto___41928]));

var G__41929 = (i__7652__auto___41928 + (1));
i__7652__auto___41928 = G__41929;
continue;
} else {
}
break;
}

var G__41923 = args41918.length;
switch (G__41923) {
case 2:
return cljs.core.aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args41918.slice((2)),(0),null));
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = (function (array,i){
return (array[i]);
});

cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = (function (array,i,idxs){
var G__41924 = cljs.core.aget;
var G__41925 = (array[i]);
var G__41926 = idxs;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__41924,G__41925,G__41926) : cljs.core.apply.call(null,G__41924,G__41925,G__41926));
});

cljs.core.aget.cljs$lang$applyTo = (function (seq41919){
var G__41920 = cljs.core.first(seq41919);
var seq41919__$1 = cljs.core.next(seq41919);
var G__41921 = cljs.core.first(seq41919__$1);
var seq41919__$2 = cljs.core.next(seq41919__$1);
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(G__41920,G__41921,seq41919__$2);
});

cljs.core.aget.cljs$lang$maxFixedArity = (2);

/**
 * Sets the value at the index.
 */
cljs.core.aset = (function cljs$core$aset(var_args){
var args41931 = [];
var len__7651__auto___41942 = arguments.length;
var i__7652__auto___41943 = (0);
while(true){
if((i__7652__auto___41943 < len__7651__auto___41942)){
args41931.push((arguments[i__7652__auto___41943]));

var G__41944 = (i__7652__auto___41943 + (1));
i__7652__auto___41943 = G__41944;
continue;
} else {
}
break;
}

var G__41937 = args41931.length;
switch (G__41937) {
case 3:
return cljs.core.aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args41931.slice((3)),(0),null));
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7670__auto__);

}
});

cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = (function (array,i,val){
return (array[i] = val);
});

cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idx2,idxv){
var G__41938 = cljs.core.aset;
var G__41939 = (array[idx]);
var G__41940 = idx2;
var G__41941 = idxv;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__41938,G__41939,G__41940,G__41941) : cljs.core.apply.call(null,G__41938,G__41939,G__41940,G__41941));
});

cljs.core.aset.cljs$lang$applyTo = (function (seq41932){
var G__41933 = cljs.core.first(seq41932);
var seq41932__$1 = cljs.core.next(seq41932);
var G__41934 = cljs.core.first(seq41932__$1);
var seq41932__$2 = cljs.core.next(seq41932__$1);
var G__41935 = cljs.core.first(seq41932__$2);
var seq41932__$3 = cljs.core.next(seq41932__$2);
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(G__41933,G__41934,G__41935,seq41932__$3);
});

cljs.core.aset.cljs$lang$maxFixedArity = (3);

/**
 * Returns the length of the array. Works on arrays of all types.
 */
cljs.core.alength = (function cljs$core$alength(array){
return array.length;
});
/**
 * Returns an array with components set to the values in aseq. Optional type
 *   argument accepted for compatibility with Clojure.
 */
cljs.core.into_array = (function cljs$core$into_array(var_args){
var args41946 = [];
var len__7651__auto___41952 = arguments.length;
var i__7652__auto___41953 = (0);
while(true){
if((i__7652__auto___41953 < len__7651__auto___41952)){
args41946.push((arguments[i__7652__auto___41953]));

var G__41954 = (i__7652__auto___41953 + (1));
i__7652__auto___41953 = G__41954;
continue;
} else {
}
break;
}

var G__41948 = args41946.length;
switch (G__41948) {
case 1:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41946.length)].join('')));

}
});

cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = (function (aseq){
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);
});

cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = (function (type,aseq){
var G__41949 = (function (a,x){
a.push(x);

return a;
});
var G__41950 = [];
var G__41951 = aseq;
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__41949,G__41950,G__41951) : cljs.core.reduce.call(null,G__41949,G__41950,G__41951));
});

cljs.core.into_array.cljs$lang$maxFixedArity = 2;

/**
 * Invoke JavaScript object method via string. Needed when the
 *   string is not a valid unquoted property name.
 */
cljs.core.js_invoke = (function cljs$core$js_invoke(var_args){
var args__7658__auto__ = [];
var len__7651__auto___41959 = arguments.length;
var i__7652__auto___41960 = (0);
while(true){
if((i__7652__auto___41960 < len__7651__auto___41959)){
args__7658__auto__.push((arguments[i__7652__auto___41960]));

var G__41961 = (i__7652__auto___41960 + (1));
i__7652__auto___41960 = G__41961;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = (function (obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
});

cljs.core.js_invoke.cljs$lang$maxFixedArity = (2);

cljs.core.js_invoke.cljs$lang$applyTo = (function (seq41956){
var G__41957 = cljs.core.first(seq41956);
var seq41956__$1 = cljs.core.next(seq41956);
var G__41958 = cljs.core.first(seq41956__$1);
var seq41956__$2 = cljs.core.next(seq41956__$1);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(G__41957,G__41958,seq41956__$2);
});


/**
 * Marker protocol
 * @interface
 */
cljs.core.Fn = function(){};


/**
 * Protocol for adding the ability to invoke an object as a function.
 *   For example, a vector can also be used to look up a value:
 *   ([1 2 3 4] 1) => 2
 * @interface
 */
cljs.core.IFn = function(){};

cljs.core._invoke = (function cljs$core$_invoke(var_args){
var args41962 = [];
var len__7651__auto___41965 = arguments.length;
var i__7652__auto___41966 = (0);
while(true){
if((i__7652__auto___41966 < len__7651__auto___41965)){
args41962.push((arguments[i__7652__auto___41966]));

var G__41967 = (i__7652__auto___41966 + (1));
i__7652__auto___41966 = G__41967;
continue;
} else {
}
break;
}

var G__41964 = args41962.length;
switch (G__41964) {
case 1:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
case 9:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
case 11:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));

break;
case 12:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));

break;
case 13:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));

break;
case 14:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));

break;
case 15:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));

break;
case 16:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));

break;
case 17:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));

break;
case 18:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));

break;
case 19:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));

break;
case 20:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));

break;
case 21:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));

break;
case 22:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41962.length)].join('')));

}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = (function (this$){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$1 == null)))){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7207__auto__.call(null,this$));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7207__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = (function (this$,a){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$2 == null)))){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__7207__auto__.call(null,this$,a));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,a) : m__7207__auto____$1.call(null,this$,a));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = (function (this$,a,b){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$3 == null)))){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__7207__auto__.call(null,this$,a,b));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__7207__auto____$1.call(null,this$,a,b));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = (function (this$,a,b,c){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$4 == null)))){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__7207__auto__.call(null,this$,a,b,c));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__7207__auto____$1.call(null,this$,a,b,c));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = (function (this$,a,b,c,d){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$5 == null)))){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$5 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__7207__auto__.call(null,this$,a,b,c,d));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$5 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__7207__auto____$1.call(null,this$,a,b,c,d));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = (function (this$,a,b,c,d,e){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$6 == null)))){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$6 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__7207__auto__.call(null,this$,a,b,c,d,e));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$6 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__7207__auto____$1.call(null,this$,a,b,c,d,e));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = (function (this$,a,b,c,d,e,f){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$7 == null)))){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$7 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__7207__auto__.call(null,this$,a,b,c,d,e,f));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$7 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = (function (this$,a,b,c,d,e,f,g){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$8 == null)))){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$8 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$8 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = (function (this$,a,b,c,d,e,f,g,h){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$9 == null)))){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$9 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$9 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = (function (this$,a,b,c,d,e,f,g,h,i){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$10 == null)))){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$10 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$10 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$11 == null)))){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$11 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$11 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$12 == null)))){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$12 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$12 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$13 == null)))){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$13 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$13 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$14 == null)))){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$14 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$14 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$15 == null)))){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$15 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$15 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$16 == null)))){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$16 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$16 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$17 == null)))){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$17 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$17 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$18 == null)))){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$18 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$18 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$19 == null)))){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$19 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$19 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$20 == null)))){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$20 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$20 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$21 == null)))){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$21 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$21 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$22 == null)))){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._invoke[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$22 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__7207__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
var m__7207__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$22 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__7207__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$lang$maxFixedArity = 22;



/**
 * Protocol for cloning a value.
 * @interface
 */
cljs.core.ICloneable = function(){};

/**
 * Creates a clone of value.
 */
cljs.core._clone = (function cljs$core$_clone(value){
if((!((value == null))) && (!((value.cljs$core$ICloneable$_clone$arity$1 == null)))){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
var x__7206__auto__ = (((value == null))?null:value);
var m__7207__auto__ = (cljs.core._clone[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__7207__auto__.call(null,value));
} else {
var m__7207__auto____$1 = (cljs.core._clone["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(value) : m__7207__auto____$1.call(null,value));
} else {
throw cljs.core.missing_protocol("ICloneable.-clone",value);
}
}
}
});


/**
 * Protocol for adding the ability to count a collection in constant time.
 * @interface
 */
cljs.core.ICounted = function(){};

/**
 * Calculates the count of coll in constant time. Used by cljs.core/count.
 */
cljs.core._count = (function cljs$core$_count(coll){
if((!((coll == null))) && (!((coll.cljs$core$ICounted$_count$arity$1 == null)))){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._count[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._count["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("ICounted.-count",coll);
}
}
}
});


/**
 * Protocol for creating an empty collection.
 * @interface
 */
cljs.core.IEmptyableCollection = function(){};

/**
 * Returns an empty collection of the same category as coll. Used
 *   by cljs.core/empty.
 */
cljs.core._empty = (function cljs$core$_empty(coll){
if((!((coll == null))) && (!((coll.cljs$core$IEmptyableCollection$_empty$arity$1 == null)))){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._empty[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._empty["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);
}
}
}
});


/**
 * Protocol for adding to a collection.
 * @interface
 */
cljs.core.ICollection = function(){};

/**
 * Returns a new collection of coll with o added to it. The new item
 *   should be added to the most efficient place, e.g.
 *   (conj [1 2 3 4] 5) => [1 2 3 4 5]
 *   (conj '(2 3 4 5) 1) => '(1 2 3 4 5)
 */
cljs.core._conj = (function cljs$core$_conj(coll,o){
if((!((coll == null))) && (!((coll.cljs$core$ICollection$_conj$arity$2 == null)))){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._conj[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__7207__auto__.call(null,coll,o));
} else {
var m__7207__auto____$1 = (cljs.core._conj["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,o) : m__7207__auto____$1.call(null,coll,o));
} else {
throw cljs.core.missing_protocol("ICollection.-conj",coll);
}
}
}
});


/**
 * Protocol for collections to provide indexed-based access to their items.
 * @interface
 */
cljs.core.IIndexed = function(){};

/**
 * Returns the value at the index n in the collection coll.
 *   Returns not-found if index n is out of bounds and not-found is supplied.
 */
cljs.core._nth = (function cljs$core$_nth(var_args){
var args41969 = [];
var len__7651__auto___41972 = arguments.length;
var i__7652__auto___41973 = (0);
while(true){
if((i__7652__auto___41973 < len__7651__auto___41972)){
args41969.push((arguments[i__7652__auto___41973]));

var G__41974 = (i__7652__auto___41973 + (1));
i__7652__auto___41973 = G__41974;
continue;
} else {
}
break;
}

var G__41971 = args41969.length;
switch (G__41971) {
case 2:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41969.length)].join('')));

}
});

cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if((!((coll == null))) && (!((coll.cljs$core$IIndexed$_nth$arity$2 == null)))){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._nth[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__7207__auto__.call(null,coll,n));
} else {
var m__7207__auto____$1 = (cljs.core._nth["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,n) : m__7207__auto____$1.call(null,coll,n));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
}
});

cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if((!((coll == null))) && (!((coll.cljs$core$IIndexed$_nth$arity$3 == null)))){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._nth[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__7207__auto__.call(null,coll,n,not_found));
} else {
var m__7207__auto____$1 = (cljs.core._nth["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__7207__auto____$1.call(null,coll,n,not_found));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
}
});

cljs.core._nth.cljs$lang$maxFixedArity = 3;



/**
 * Marker protocol indicating an array sequence.
 * @interface
 */
cljs.core.ASeq = function(){};


/**
 * Protocol for collections to provide access to their items as sequences.
 * @interface
 */
cljs.core.ISeq = function(){};

/**
 * Returns the first item in the collection coll. Used by cljs.core/first.
 */
cljs.core._first = (function cljs$core$_first(coll){
if((!((coll == null))) && (!((coll.cljs$core$ISeq$_first$arity$1 == null)))){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._first[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._first["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-first",coll);
}
}
}
});

/**
 * Returns a new collection of coll without the first item. It should
 *   always return a seq, e.g.
 *   (rest []) => ()
 *   (rest nil) => ()
 */
cljs.core._rest = (function cljs$core$_rest(coll){
if((!((coll == null))) && (!((coll.cljs$core$ISeq$_rest$arity$1 == null)))){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._rest[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._rest["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-rest",coll);
}
}
}
});


/**
 * Protocol for accessing the next items of a collection.
 * @interface
 */
cljs.core.INext = function(){};

/**
 * Returns a new collection of coll without the first item. In contrast to
 *   rest, it should return nil if there are no more items, e.g.
 *   (next []) => nil
 *   (next nil) => nil
 */
cljs.core._next = (function cljs$core$_next(coll){
if((!((coll == null))) && (!((coll.cljs$core$INext$_next$arity$1 == null)))){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._next[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._next["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("INext.-next",coll);
}
}
}
});


/**
 * Protocol for looking up a value in a data structure.
 * @interface
 */
cljs.core.ILookup = function(){};

/**
 * Use k to look up a value in o. If not-found is supplied and k is not
 *   a valid value that can be used for look up, not-found is returned.
 */
cljs.core._lookup = (function cljs$core$_lookup(var_args){
var args41976 = [];
var len__7651__auto___41979 = arguments.length;
var i__7652__auto___41980 = (0);
while(true){
if((i__7652__auto___41980 < len__7651__auto___41979)){
args41976.push((arguments[i__7652__auto___41980]));

var G__41981 = (i__7652__auto___41980 + (1));
i__7652__auto___41980 = G__41981;
continue;
} else {
}
break;
}

var G__41978 = args41976.length;
switch (G__41978) {
case 2:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41976.length)].join('')));

}
});

cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((!((o == null))) && (!((o.cljs$core$ILookup$_lookup$arity$2 == null)))){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._lookup[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__7207__auto__.call(null,o,k));
} else {
var m__7207__auto____$1 = (cljs.core._lookup["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(o,k) : m__7207__auto____$1.call(null,o,k));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
}
});

cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if((!((o == null))) && (!((o.cljs$core$ILookup$_lookup$arity$3 == null)))){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._lookup[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__7207__auto__.call(null,o,k,not_found));
} else {
var m__7207__auto____$1 = (cljs.core._lookup["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__7207__auto____$1.call(null,o,k,not_found));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
}
});

cljs.core._lookup.cljs$lang$maxFixedArity = 3;



/**
 * Protocol for adding associativity to collections.
 * @interface
 */
cljs.core.IAssociative = function(){};

/**
 * Returns true if k is a key in coll.
 */
cljs.core._contains_key_QMARK_ = (function cljs$core$_contains_key_QMARK_(coll,k){
if((!((coll == null))) && (!((coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 == null)))){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._contains_key_QMARK_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__7207__auto__.call(null,coll,k));
} else {
var m__7207__auto____$1 = (cljs.core._contains_key_QMARK_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,k) : m__7207__auto____$1.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);
}
}
}
});

/**
 * Returns a new collection of coll with a mapping from key k to
 *   value v added to it.
 */
cljs.core._assoc = (function cljs$core$_assoc(coll,k,v){
if((!((coll == null))) && (!((coll.cljs$core$IAssociative$_assoc$arity$3 == null)))){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._assoc[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__7207__auto__.call(null,coll,k,v));
} else {
var m__7207__auto____$1 = (cljs.core._assoc["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__7207__auto____$1.call(null,coll,k,v));
} else {
throw cljs.core.missing_protocol("IAssociative.-assoc",coll);
}
}
}
});


/**
 * Protocol for adding mapping functionality to collections.
 * @interface
 */
cljs.core.IMap = function(){};

/**
 * Returns a new collection of coll without the mapping for key k.
 */
cljs.core._dissoc = (function cljs$core$_dissoc(coll,k){
if((!((coll == null))) && (!((coll.cljs$core$IMap$_dissoc$arity$2 == null)))){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._dissoc[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__7207__auto__.call(null,coll,k));
} else {
var m__7207__auto____$1 = (cljs.core._dissoc["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,k) : m__7207__auto____$1.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IMap.-dissoc",coll);
}
}
}
});


/**
 * Protocol for examining a map entry.
 * @interface
 */
cljs.core.IMapEntry = function(){};

/**
 * Returns the key of the map entry.
 */
cljs.core._key = (function cljs$core$_key(coll){
if((!((coll == null))) && (!((coll.cljs$core$IMapEntry$_key$arity$1 == null)))){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._key[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._key["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-key",coll);
}
}
}
});

/**
 * Returns the value of the map entry.
 */
cljs.core._val = (function cljs$core$_val(coll){
if((!((coll == null))) && (!((coll.cljs$core$IMapEntry$_val$arity$1 == null)))){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._val[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._val["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-val",coll);
}
}
}
});


/**
 * Protocol for adding set functionality to a collection.
 * @interface
 */
cljs.core.ISet = function(){};

/**
 * Returns a new collection of coll that does not contain v.
 */
cljs.core._disjoin = (function cljs$core$_disjoin(coll,v){
if((!((coll == null))) && (!((coll.cljs$core$ISet$_disjoin$arity$2 == null)))){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._disjoin[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__7207__auto__.call(null,coll,v));
} else {
var m__7207__auto____$1 = (cljs.core._disjoin["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,v) : m__7207__auto____$1.call(null,coll,v));
} else {
throw cljs.core.missing_protocol("ISet.-disjoin",coll);
}
}
}
});


/**
 * Protocol for collections to provide access to their items as stacks. The top
 *   of the stack should be accessed in the most efficient way for the different
 *   data structures.
 * @interface
 */
cljs.core.IStack = function(){};

/**
 * Returns the item from the top of the stack. Is used by cljs.core/peek.
 */
cljs.core._peek = (function cljs$core$_peek(coll){
if((!((coll == null))) && (!((coll.cljs$core$IStack$_peek$arity$1 == null)))){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._peek[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._peek["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-peek",coll);
}
}
}
});

/**
 * Returns a new stack without the item on top of the stack. Is used
 *   by cljs.core/pop.
 */
cljs.core._pop = (function cljs$core$_pop(coll){
if((!((coll == null))) && (!((coll.cljs$core$IStack$_pop$arity$1 == null)))){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._pop[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._pop["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-pop",coll);
}
}
}
});


/**
 * Protocol for adding vector functionality to collections.
 * @interface
 */
cljs.core.IVector = function(){};

/**
 * Returns a new vector with value val added at position n.
 */
cljs.core._assoc_n = (function cljs$core$_assoc_n(coll,n,val){
if((!((coll == null))) && (!((coll.cljs$core$IVector$_assoc_n$arity$3 == null)))){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._assoc_n[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__7207__auto__.call(null,coll,n,val));
} else {
var m__7207__auto____$1 = (cljs.core._assoc_n["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__7207__auto____$1.call(null,coll,n,val));
} else {
throw cljs.core.missing_protocol("IVector.-assoc-n",coll);
}
}
}
});


/**
 * Protocol for adding dereference functionality to a reference.
 * @interface
 */
cljs.core.IDeref = function(){};

/**
 * Returns the value of the reference o.
 */
cljs.core._deref = (function cljs$core$_deref(o){
if((!((o == null))) && (!((o.cljs$core$IDeref$_deref$arity$1 == null)))){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._deref[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__7207__auto__.call(null,o));
} else {
var m__7207__auto____$1 = (cljs.core._deref["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__7207__auto____$1.call(null,o));
} else {
throw cljs.core.missing_protocol("IDeref.-deref",o);
}
}
}
});


/**
 * @interface
 */
cljs.core.IDerefWithTimeout = function(){};

cljs.core._deref_with_timeout = (function cljs$core$_deref_with_timeout(o,msec,timeout_val){
if((!((o == null))) && (!((o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3 == null)))){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._deref_with_timeout[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__7207__auto__.call(null,o,msec,timeout_val));
} else {
var m__7207__auto____$1 = (cljs.core._deref_with_timeout["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__7207__auto____$1.call(null,o,msec,timeout_val));
} else {
throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);
}
}
}
});


/**
 * Protocol for accessing the metadata of an object.
 * @interface
 */
cljs.core.IMeta = function(){};

/**
 * Returns the metadata of object o.
 */
cljs.core._meta = (function cljs$core$_meta(o){
if((!((o == null))) && (!((o.cljs$core$IMeta$_meta$arity$1 == null)))){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._meta[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__7207__auto__.call(null,o));
} else {
var m__7207__auto____$1 = (cljs.core._meta["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__7207__auto____$1.call(null,o));
} else {
throw cljs.core.missing_protocol("IMeta.-meta",o);
}
}
}
});


/**
 * Protocol for adding metadata to an object.
 * @interface
 */
cljs.core.IWithMeta = function(){};

/**
 * Returns a new object with value of o and metadata meta added to it.
 */
cljs.core._with_meta = (function cljs$core$_with_meta(o,meta){
if((!((o == null))) && (!((o.cljs$core$IWithMeta$_with_meta$arity$2 == null)))){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._with_meta[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__7207__auto__.call(null,o,meta));
} else {
var m__7207__auto____$1 = (cljs.core._with_meta["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(o,meta) : m__7207__auto____$1.call(null,o,meta));
} else {
throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);
}
}
}
});


/**
 * Protocol for seq types that can reduce themselves.
 *   Called by cljs.core/reduce.
 * @interface
 */
cljs.core.IReduce = function(){};

/**
 * f should be a function of 2 arguments. If start is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc.
 */
cljs.core._reduce = (function cljs$core$_reduce(var_args){
var args41983 = [];
var len__7651__auto___41986 = arguments.length;
var i__7652__auto___41987 = (0);
while(true){
if((i__7652__auto___41987 < len__7651__auto___41986)){
args41983.push((arguments[i__7652__auto___41987]));

var G__41988 = (i__7652__auto___41987 + (1));
i__7652__auto___41987 = G__41988;
continue;
} else {
}
break;
}

var G__41985 = args41983.length;
switch (G__41985) {
case 2:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41983.length)].join('')));

}
});

cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = (function (coll,f){
if((!((coll == null))) && (!((coll.cljs$core$IReduce$_reduce$arity$2 == null)))){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._reduce[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__7207__auto__.call(null,coll,f));
} else {
var m__7207__auto____$1 = (cljs.core._reduce["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,f) : m__7207__auto____$1.call(null,coll,f));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
}
});

cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = (function (coll,f,start){
if((!((coll == null))) && (!((coll.cljs$core$IReduce$_reduce$arity$3 == null)))){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._reduce[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__7207__auto__.call(null,coll,f,start));
} else {
var m__7207__auto____$1 = (cljs.core._reduce["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__7207__auto____$1.call(null,coll,f,start));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
}
});

cljs.core._reduce.cljs$lang$maxFixedArity = 3;



/**
 * Protocol for associative types that can reduce themselves
 *   via a function of key and val. Called by cljs.core/reduce-kv.
 * @interface
 */
cljs.core.IKVReduce = function(){};

/**
 * Reduces an associative collection and returns the result. f should be
 *   a function that takes three arguments.
 */
cljs.core._kv_reduce = (function cljs$core$_kv_reduce(coll,f,init){
if((!((coll == null))) && (!((coll.cljs$core$IKVReduce$_kv_reduce$arity$3 == null)))){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._kv_reduce[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__7207__auto__.call(null,coll,f,init));
} else {
var m__7207__auto____$1 = (cljs.core._kv_reduce["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__7207__auto____$1.call(null,coll,f,init));
} else {
throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);
}
}
}
});


/**
 * Protocol for adding value comparison functionality to a type.
 * @interface
 */
cljs.core.IEquiv = function(){};

/**
 * Returns true if o and other are equal, false otherwise.
 */
cljs.core._equiv = (function cljs$core$_equiv(o,other){
if((!((o == null))) && (!((o.cljs$core$IEquiv$_equiv$arity$2 == null)))){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._equiv[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__7207__auto__.call(null,o,other));
} else {
var m__7207__auto____$1 = (cljs.core._equiv["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(o,other) : m__7207__auto____$1.call(null,o,other));
} else {
throw cljs.core.missing_protocol("IEquiv.-equiv",o);
}
}
}
});


/**
 * Protocol for adding hashing functionality to a type.
 * @interface
 */
cljs.core.IHash = function(){};

/**
 * Returns the hash code of o.
 */
cljs.core._hash = (function cljs$core$_hash(o){
if((!((o == null))) && (!((o.cljs$core$IHash$_hash$arity$1 == null)))){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._hash[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__7207__auto__.call(null,o));
} else {
var m__7207__auto____$1 = (cljs.core._hash["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__7207__auto____$1.call(null,o));
} else {
throw cljs.core.missing_protocol("IHash.-hash",o);
}
}
}
});


/**
 * Protocol for adding the ability to a type to be transformed into a sequence.
 * @interface
 */
cljs.core.ISeqable = function(){};

/**
 * Returns a seq of o, or nil if o is empty.
 */
cljs.core._seq = (function cljs$core$_seq(o){
if((!((o == null))) && (!((o.cljs$core$ISeqable$_seq$arity$1 == null)))){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._seq[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__7207__auto__.call(null,o));
} else {
var m__7207__auto____$1 = (cljs.core._seq["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__7207__auto____$1.call(null,o));
} else {
throw cljs.core.missing_protocol("ISeqable.-seq",o);
}
}
}
});


/**
 * Marker interface indicating a persistent collection of sequential items
 * @interface
 */
cljs.core.ISequential = function(){};


/**
 * Marker interface indicating a persistent list
 * @interface
 */
cljs.core.IList = function(){};


/**
 * Marker interface indicating a record object
 * @interface
 */
cljs.core.IRecord = function(){};


/**
 * Protocol for reversing a seq.
 * @interface
 */
cljs.core.IReversible = function(){};

/**
 * Returns a seq of the items in coll in reversed order.
 */
cljs.core._rseq = (function cljs$core$_rseq(coll){
if((!((coll == null))) && (!((coll.cljs$core$IReversible$_rseq$arity$1 == null)))){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._rseq[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._rseq["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IReversible.-rseq",coll);
}
}
}
});


/**
 * Protocol for a collection which can represent their items
 *   in a sorted manner. 
 * @interface
 */
cljs.core.ISorted = function(){};

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 */
cljs.core._sorted_seq = (function cljs$core$_sorted_seq(coll,ascending_QMARK_){
if((!((coll == null))) && (!((coll.cljs$core$ISorted$_sorted_seq$arity$2 == null)))){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._sorted_seq[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__7207__auto__.call(null,coll,ascending_QMARK_));
} else {
var m__7207__auto____$1 = (cljs.core._sorted_seq["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__7207__auto____$1.call(null,coll,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);
}
}
}
});

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 *   If ascending is true, the result should contain all items which are > or >=
 *   than k. If ascending is false, the result should contain all items which
 *   are < or <= than k, e.g.
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)
 */
cljs.core._sorted_seq_from = (function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){
if((!((coll == null))) && (!((coll.cljs$core$ISorted$_sorted_seq_from$arity$3 == null)))){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._sorted_seq_from[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__7207__auto__.call(null,coll,k,ascending_QMARK_));
} else {
var m__7207__auto____$1 = (cljs.core._sorted_seq_from["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__7207__auto____$1.call(null,coll,k,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);
}
}
}
});

/**
 * Returns the key for entry.
 */
cljs.core._entry_key = (function cljs$core$_entry_key(coll,entry){
if((!((coll == null))) && (!((coll.cljs$core$ISorted$_entry_key$arity$2 == null)))){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._entry_key[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__7207__auto__.call(null,coll,entry));
} else {
var m__7207__auto____$1 = (cljs.core._entry_key["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__7207__auto____$1.call(null,coll,entry));
} else {
throw cljs.core.missing_protocol("ISorted.-entry-key",coll);
}
}
}
});

/**
 * Returns the comparator for coll.
 */
cljs.core._comparator = (function cljs$core$_comparator(coll){
if((!((coll == null))) && (!((coll.cljs$core$ISorted$_comparator$arity$1 == null)))){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._comparator[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._comparator["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISorted.-comparator",coll);
}
}
}
});


/**
 * Protocol for writing. Currently only implemented by StringBufferWriter.
 * @interface
 */
cljs.core.IWriter = function(){};

/**
 * Writes s with writer and returns the result.
 */
cljs.core._write = (function cljs$core$_write(writer,s){
if((!((writer == null))) && (!((writer.cljs$core$IWriter$_write$arity$2 == null)))){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
var x__7206__auto__ = (((writer == null))?null:writer);
var m__7207__auto__ = (cljs.core._write[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__7207__auto__.call(null,writer,s));
} else {
var m__7207__auto____$1 = (cljs.core._write["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(writer,s) : m__7207__auto____$1.call(null,writer,s));
} else {
throw cljs.core.missing_protocol("IWriter.-write",writer);
}
}
}
});

/**
 * Flush writer.
 */
cljs.core._flush = (function cljs$core$_flush(writer){
if((!((writer == null))) && (!((writer.cljs$core$IWriter$_flush$arity$1 == null)))){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
var x__7206__auto__ = (((writer == null))?null:writer);
var m__7207__auto__ = (cljs.core._flush[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__7207__auto__.call(null,writer));
} else {
var m__7207__auto____$1 = (cljs.core._flush["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(writer) : m__7207__auto____$1.call(null,writer));
} else {
throw cljs.core.missing_protocol("IWriter.-flush",writer);
}
}
}
});


/**
 * The old IPrintable protocol's implementation consisted of building a giant
 * list of strings to concatenate.  This involved lots of concat calls,
 * intermediate vectors, and lazy-seqs, and was very slow in some older JS
 * engines.  IPrintWithWriter implements printing via the IWriter protocol, so it
 * be implemented efficiently in terms of e.g. a StringBuffer append.
 * @interface
 */
cljs.core.IPrintWithWriter = function(){};

cljs.core._pr_writer = (function cljs$core$_pr_writer(o,writer,opts){
if((!((o == null))) && (!((o.cljs$core$IPrintWithWriter$_pr_writer$arity$3 == null)))){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._pr_writer[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__7207__auto__.call(null,o,writer,opts));
} else {
var m__7207__auto____$1 = (cljs.core._pr_writer["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__7207__auto____$1.call(null,o,writer,opts));
} else {
throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);
}
}
}
});


/**
 * Protocol for types which can have a deferred realization. Currently only
 *   implemented by Delay and LazySeq.
 * @interface
 */
cljs.core.IPending = function(){};

/**
 * Returns true if a value for x has been produced, false otherwise.
 */
cljs.core._realized_QMARK_ = (function cljs$core$_realized_QMARK_(x){
if((!((x == null))) && (!((x.cljs$core$IPending$_realized_QMARK_$arity$1 == null)))){
return x.cljs$core$IPending$_realized_QMARK_$arity$1(x);
} else {
var x__7206__auto__ = (((x == null))?null:x);
var m__7207__auto__ = (cljs.core._realized_QMARK_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__7207__auto__.call(null,x));
} else {
var m__7207__auto____$1 = (cljs.core._realized_QMARK_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__7207__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("IPending.-realized?",x);
}
}
}
});


/**
 * Protocol for types that can be watched. Currently only implemented by Atom.
 * @interface
 */
cljs.core.IWatchable = function(){};

/**
 * Calls all watchers with this, oldval and newval.
 */
cljs.core._notify_watches = (function cljs$core$_notify_watches(this$,oldval,newval){
if((!((this$ == null))) && (!((this$.cljs$core$IWatchable$_notify_watches$arity$3 == null)))){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._notify_watches[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__7207__auto__.call(null,this$,oldval,newval));
} else {
var m__7207__auto____$1 = (cljs.core._notify_watches["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__7207__auto____$1.call(null,this$,oldval,newval));
} else {
throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);
}
}
}
});

/**
 * Adds a watcher function f to this. Keys must be unique per reference,
 *   and can be used to remove the watch with -remove-watch.
 */
cljs.core._add_watch = (function cljs$core$_add_watch(this$,key,f){
if((!((this$ == null))) && (!((this$.cljs$core$IWatchable$_add_watch$arity$3 == null)))){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._add_watch[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__7207__auto__.call(null,this$,key,f));
} else {
var m__7207__auto____$1 = (cljs.core._add_watch["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__7207__auto____$1.call(null,this$,key,f));
} else {
throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);
}
}
}
});

/**
 * Removes watcher that corresponds to key from this.
 */
cljs.core._remove_watch = (function cljs$core$_remove_watch(this$,key){
if((!((this$ == null))) && (!((this$.cljs$core$IWatchable$_remove_watch$arity$2 == null)))){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
var x__7206__auto__ = (((this$ == null))?null:this$);
var m__7207__auto__ = (cljs.core._remove_watch[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__7207__auto__.call(null,this$,key));
} else {
var m__7207__auto____$1 = (cljs.core._remove_watch["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,key) : m__7207__auto____$1.call(null,this$,key));
} else {
throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);
}
}
}
});


/**
 * Protocol for collections which can transformed to transients.
 * @interface
 */
cljs.core.IEditableCollection = function(){};

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core._as_transient = (function cljs$core$_as_transient(coll){
if((!((coll == null))) && (!((coll.cljs$core$IEditableCollection$_as_transient$arity$1 == null)))){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._as_transient[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._as_transient["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);
}
}
}
});


/**
 * Protocol for adding basic functionality to transient collections.
 * @interface
 */
cljs.core.ITransientCollection = function(){};

/**
 * Adds value val to tcoll and returns tcoll.
 */
cljs.core._conj_BANG_ = (function cljs$core$_conj_BANG_(tcoll,val){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2 == null)))){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
var x__7206__auto__ = (((tcoll == null))?null:tcoll);
var m__7207__auto__ = (cljs.core._conj_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__7207__auto__.call(null,tcoll,val));
} else {
var m__7207__auto____$1 = (cljs.core._conj_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__7207__auto____$1.call(null,tcoll,val));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);
}
}
}
});

/**
 * Creates a persistent data structure from tcoll and returns it.
 */
cljs.core._persistent_BANG_ = (function cljs$core$_persistent_BANG_(tcoll){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 == null)))){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
var x__7206__auto__ = (((tcoll == null))?null:tcoll);
var m__7207__auto__ = (cljs.core._persistent_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__7207__auto__.call(null,tcoll));
} else {
var m__7207__auto____$1 = (cljs.core._persistent_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll) : m__7207__auto____$1.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);
}
}
}
});


/**
 * Protocol for adding associativity to transient collections.
 * @interface
 */
cljs.core.ITransientAssociative = function(){};

/**
 * Returns a new transient collection of tcoll with a mapping from key to
 *   val added to it.
 */
cljs.core._assoc_BANG_ = (function cljs$core$_assoc_BANG_(tcoll,key,val){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 == null)))){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
var x__7206__auto__ = (((tcoll == null))?null:tcoll);
var m__7207__auto__ = (cljs.core._assoc_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__7207__auto__.call(null,tcoll,key,val));
} else {
var m__7207__auto____$1 = (cljs.core._assoc_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__7207__auto____$1.call(null,tcoll,key,val));
} else {
throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);
}
}
}
});


/**
 * Protocol for adding mapping functionality to transient collections.
 * @interface
 */
cljs.core.ITransientMap = function(){};

/**
 * Returns a new transient collection of tcoll without the mapping for key.
 */
cljs.core._dissoc_BANG_ = (function cljs$core$_dissoc_BANG_(tcoll,key){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 == null)))){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
var x__7206__auto__ = (((tcoll == null))?null:tcoll);
var m__7207__auto__ = (cljs.core._dissoc_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__7207__auto__.call(null,tcoll,key));
} else {
var m__7207__auto____$1 = (cljs.core._dissoc_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__7207__auto____$1.call(null,tcoll,key));
} else {
throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);
}
}
}
});


/**
 * Protocol for adding vector functionality to transient collections.
 * @interface
 */
cljs.core.ITransientVector = function(){};

/**
 * Returns tcoll with value val added at position n.
 */
cljs.core._assoc_n_BANG_ = (function cljs$core$_assoc_n_BANG_(tcoll,n,val){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 == null)))){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
var x__7206__auto__ = (((tcoll == null))?null:tcoll);
var m__7207__auto__ = (cljs.core._assoc_n_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__7207__auto__.call(null,tcoll,n,val));
} else {
var m__7207__auto____$1 = (cljs.core._assoc_n_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__7207__auto____$1.call(null,tcoll,n,val));
} else {
throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);
}
}
}
});

/**
 * Returns tcoll with the last item removed from it.
 */
cljs.core._pop_BANG_ = (function cljs$core$_pop_BANG_(tcoll){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1 == null)))){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
var x__7206__auto__ = (((tcoll == null))?null:tcoll);
var m__7207__auto__ = (cljs.core._pop_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__7207__auto__.call(null,tcoll));
} else {
var m__7207__auto____$1 = (cljs.core._pop_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll) : m__7207__auto____$1.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);
}
}
}
});


/**
 * Protocol for adding set functionality to a transient collection.
 * @interface
 */
cljs.core.ITransientSet = function(){};

/**
 * Returns tcoll without v.
 */
cljs.core._disjoin_BANG_ = (function cljs$core$_disjoin_BANG_(tcoll,v){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 == null)))){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
var x__7206__auto__ = (((tcoll == null))?null:tcoll);
var m__7207__auto__ = (cljs.core._disjoin_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__7207__auto__.call(null,tcoll,v));
} else {
var m__7207__auto____$1 = (cljs.core._disjoin_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__7207__auto____$1.call(null,tcoll,v));
} else {
throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);
}
}
}
});


/**
 * Protocol for values that can be compared.
 * @interface
 */
cljs.core.IComparable = function(){};

/**
 * Returns a negative number, zero, or a positive number when x is logically
 *   'less than', 'equal to', or 'greater than' y.
 */
cljs.core._compare = (function cljs$core$_compare(x,y){
if((!((x == null))) && (!((x.cljs$core$IComparable$_compare$arity$2 == null)))){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
var x__7206__auto__ = (((x == null))?null:x);
var m__7207__auto__ = (cljs.core._compare[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__7207__auto__.call(null,x,y));
} else {
var m__7207__auto____$1 = (cljs.core._compare["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(x,y) : m__7207__auto____$1.call(null,x,y));
} else {
throw cljs.core.missing_protocol("IComparable.-compare",x);
}
}
}
});


/**
 * Protocol for accessing the items of a chunk.
 * @interface
 */
cljs.core.IChunk = function(){};

/**
 * Return a new chunk of coll with the first item removed.
 */
cljs.core._drop_first = (function cljs$core$_drop_first(coll){
if((!((coll == null))) && (!((coll.cljs$core$IChunk$_drop_first$arity$1 == null)))){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._drop_first[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._drop_first["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunk.-drop-first",coll);
}
}
}
});


/**
 * Protocol for accessing a collection as sequential chunks.
 * @interface
 */
cljs.core.IChunkedSeq = function(){};

/**
 * Returns the first chunk in coll.
 */
cljs.core._chunked_first = (function cljs$core$_chunked_first(coll){
if((!((coll == null))) && (!((coll.cljs$core$IChunkedSeq$_chunked_first$arity$1 == null)))){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._chunked_first[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._chunked_first["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);
}
}
}
});

/**
 * Return a new collection of coll with the first chunk removed.
 */
cljs.core._chunked_rest = (function cljs$core$_chunked_rest(coll){
if((!((coll == null))) && (!((coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1 == null)))){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._chunked_rest[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._chunked_rest["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);
}
}
}
});


/**
 * Protocol for accessing the chunks of a collection.
 * @interface
 */
cljs.core.IChunkedNext = function(){};

/**
 * Returns a new collection of coll without the first chunk.
 */
cljs.core._chunked_next = (function cljs$core$_chunked_next(coll){
if((!((coll == null))) && (!((coll.cljs$core$IChunkedNext$_chunked_next$arity$1 == null)))){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._chunked_next[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._chunked_next["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);
}
}
}
});


/**
 * Protocol for adding a name.
 * @interface
 */
cljs.core.INamed = function(){};

/**
 * Returns the name String of x.
 */
cljs.core._name = (function cljs$core$_name(x){
if((!((x == null))) && (!((x.cljs$core$INamed$_name$arity$1 == null)))){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
var x__7206__auto__ = (((x == null))?null:x);
var m__7207__auto__ = (cljs.core._name[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__7207__auto__.call(null,x));
} else {
var m__7207__auto____$1 = (cljs.core._name["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__7207__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-name",x);
}
}
}
});

/**
 * Returns the namespace String of x.
 */
cljs.core._namespace = (function cljs$core$_namespace(x){
if((!((x == null))) && (!((x.cljs$core$INamed$_namespace$arity$1 == null)))){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
var x__7206__auto__ = (((x == null))?null:x);
var m__7207__auto__ = (cljs.core._namespace[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__7207__auto__.call(null,x));
} else {
var m__7207__auto____$1 = (cljs.core._namespace["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__7207__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-namespace",x);
}
}
}
});


/**
 * Marker protocol indicating an atom.
 * @interface
 */
cljs.core.IAtom = function(){};


/**
 * Protocol for adding resetting functionality.
 * @interface
 */
cljs.core.IReset = function(){};

/**
 * Sets the value of o to new-value.
 */
cljs.core._reset_BANG_ = (function cljs$core$_reset_BANG_(o,new_value){
if((!((o == null))) && (!((o.cljs$core$IReset$_reset_BANG_$arity$2 == null)))){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._reset_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__7207__auto__.call(null,o,new_value));
} else {
var m__7207__auto____$1 = (cljs.core._reset_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__7207__auto____$1.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IReset.-reset!",o);
}
}
}
});


/**
 * Protocol for adding swapping functionality.
 * @interface
 */
cljs.core.ISwap = function(){};

/**
 * Swaps the value of o to be (apply f current-value-of-atom args).
 */
cljs.core._swap_BANG_ = (function cljs$core$_swap_BANG_(var_args){
var args41990 = [];
var len__7651__auto___41993 = arguments.length;
var i__7652__auto___41994 = (0);
while(true){
if((i__7652__auto___41994 < len__7651__auto___41993)){
args41990.push((arguments[i__7652__auto___41994]));

var G__41995 = (i__7652__auto___41994 + (1));
i__7652__auto___41994 = G__41995;
continue;
} else {
}
break;
}

var G__41992 = args41990.length;
switch (G__41992) {
case 2:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41990.length)].join('')));

}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (o,f){
if((!((o == null))) && (!((o.cljs$core$ISwap$_swap_BANG_$arity$2 == null)))){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__7207__auto__.call(null,o,f));
} else {
var m__7207__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(o,f) : m__7207__auto____$1.call(null,o,f));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (o,f,a){
if((!((o == null))) && (!((o.cljs$core$ISwap$_swap_BANG_$arity$3 == null)))){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__7207__auto__.call(null,o,f,a));
} else {
var m__7207__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__7207__auto____$1.call(null,o,f,a));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (o,f,a,b){
if((!((o == null))) && (!((o.cljs$core$ISwap$_swap_BANG_$arity$4 == null)))){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__7207__auto__.call(null,o,f,a,b));
} else {
var m__7207__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__7207__auto____$1.call(null,o,f,a,b));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (o,f,a,b,xs){
if((!((o == null))) && (!((o.cljs$core$ISwap$_swap_BANG_$arity$5 == null)))){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$5 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__7207__auto__.call(null,o,f,a,b,xs));
} else {
var m__7207__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$5 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__7207__auto____$1.call(null,o,f,a,b,xs));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5;



/**
 * Protocol for adding volatile functionality.
 * @interface
 */
cljs.core.IVolatile = function(){};

/**
 * Sets the value of volatile o to new-value without regard for the
 *   current value. Returns new-value.
 */
cljs.core._vreset_BANG_ = (function cljs$core$_vreset_BANG_(o,new_value){
if((!((o == null))) && (!((o.cljs$core$IVolatile$_vreset_BANG_$arity$2 == null)))){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
var x__7206__auto__ = (((o == null))?null:o);
var m__7207__auto__ = (cljs.core._vreset_BANG_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__7207__auto__.call(null,o,new_value));
} else {
var m__7207__auto____$1 = (cljs.core._vreset_BANG_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__7207__auto____$1.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IVolatile.-vreset!",o);
}
}
}
});


/**
 * Protocol for iterating over a collection.
 * @interface
 */
cljs.core.IIterable = function(){};

/**
 * Returns an iterator for coll.
 */
cljs.core._iterator = (function cljs$core$_iterator(coll){
if((!((coll == null))) && (!((coll.cljs$core$IIterable$_iterator$arity$1 == null)))){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
var x__7206__auto__ = (((coll == null))?null:coll);
var m__7207__auto__ = (cljs.core._iterator[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto__.call(null,coll));
} else {
var m__7207__auto____$1 = (cljs.core._iterator["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7207__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IIterable.-iterator",coll);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IWriter}
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
});

cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
});

cljs.core.StringBufferWriter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sb], null);
});

cljs.core.StringBufferWriter.cljs$lang$type = true;

cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";

cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/StringBufferWriter");
});

cljs.core.__GT_StringBufferWriter = (function cljs$core$__GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
 * Support so that collections can implement toString without
 * loading all the printing machinery.
 */
cljs.core.pr_str_STAR_ = (function cljs$core$pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());

writer.cljs$core$IWriter$_flush$arity$1(null);

return [cljs.core.str(sb)].join('');
});
cljs.core.int_rotate_left = (function cljs$core$int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((typeof Math.imul !== 'undefined') && (!((Math.imul((4294967295),(5)) === (0))))){
cljs.core.imul = (function cljs$core$imul(a,b){
return Math.imul(a,b);
});
} else {
cljs.core.imul = (function cljs$core$imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = ((3432918353) | (0));
cljs.core.m3_C2 = ((461845907) | (0));
cljs.core.m3_mix_K1 = (function cljs$core$m3_mix_K1(k1){
return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul((k1 | (0)),cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function cljs$core$m3_mix_H1(h1,k1){
return ((cljs.core.imul(cljs.core.int_rotate_left(((h1 | (0)) ^ (k1 | (0))),(13)),(5)) + ((3864292196) | (0))) | (0));
});
cljs.core.m3_fmix = (function cljs$core$m3_fmix(h1,len){
var h1__$1 = (h1 | (0));
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul(h1__$3,((2246822507) | (0)));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul(h1__$5,((3266489909) | (0)));
return (h1__$6 ^ (h1__$6 >>> (16)));
});
cljs.core.m3_hash_int = (function cljs$core$m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1(in$);
var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);
return cljs.core.m3_fmix(h1,(4));
}
});
cljs.core.m3_hash_unencoded_chars = (function cljs$core$m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__41997 = (i + (2));
var G__41998 = cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__41997;
h1 = G__41998;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));
});



cljs.core.string_hash_cache = {};
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function cljs$core$hash_string_STAR_(s){
if(!((s == null))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__42001 = (i + (1));
var G__42002 = (cljs.core.imul((31),hash) + s.charCodeAt(i));
i = G__42001;
hash = G__42002;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function cljs$core$add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_(k);
(cljs.core.string_hash_cache[k] = h);

cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1));

return h;
});
cljs.core.hash_string = (function cljs$core$hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
cljs.core.string_hash_cache = {};

cljs.core.string_hash_cache_count = (0);
} else {
}

if((k == null)){
return (0);
} else {
var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache(k);
}
}
});
/**
 * Returns the hash code of its argument. Note this is the hash code
 * consistent with =.
 */
cljs.core.hash = (function cljs$core$hash(o){
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (4194304))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IHash$)))?true:false):false)){
return o.cljs$core$IHash$_hash$arity$1(null);
} else {
if(typeof o === 'number'){
if(cljs.core.truth_(isFinite(o))){
return (Math.floor(o) % (2147483647));
} else {
var G__42010 = o;
switch (G__42010) {
case Infinity:
return (2146435072);

break;
case -Infinity:
return (-1048576);

break;
default:
return (2146959360);

}
}
} else {
if(o === true){
return (1231);
} else {
if(o === false){
return (1237);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int(cljs.core.hash_string(o));
} else {
if((o instanceof Date)){
return o.valueOf();
} else {
if((o == null)){
return (0);
} else {
return cljs.core._hash(o);

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function cljs$core$hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
/**
 * Evaluates x and tests if it is an instance of the type
 *   c. Returns true or false
 */
cljs.core.instance_QMARK_ = (function cljs$core$instance_QMARK_(c,x){
return (x instanceof c);
});
/**
 * Return true if x is a Symbol
 */
cljs.core.symbol_QMARK_ = (function cljs$core$symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function cljs$core$hash_symbol(sym){
return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));
});
cljs.core.compare_symbols = (function cljs$core$compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__6531__auto__ = cljs.core.not(a.ns);
if(and__6531__auto__){
return b.ns;
} else {
return and__6531__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__42018 = a.ns;
var G__42019 = b.ns;
return goog.array.defaultCompare(G__42018,G__42019);
})();
if(((0) === nsc)){
var G__42020 = a.name;
var G__42021 = b.name;
return goog.array.defaultCompare(G__42020,G__42021);
} else {
return nsc;
}
}
} else {
var G__42022 = a.name;
var G__42023 = b.name;
return goog.array.defaultCompare(G__42022,G__42023);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Symbol.prototype.toString = (function (){
var self__ = this;
var _ = this;
return self__.str;
});

cljs.core.Symbol.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
});

cljs.core.Symbol.prototype.call = (function() {
var G__42025 = null;
var G__42025__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$2 ? cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym) : cljs.core.get.call(null,coll,sym));
});
var G__42025__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$3 ? cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found) : cljs.core.get.call(null,coll,sym,not_found));
});
G__42025 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__42025__2.call(this,self__,coll);
case 3:
return G__42025__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42025.cljs$core$IFn$_invoke$arity$2 = G__42025__2;
G__42025.cljs$core$IFn$_invoke$arity$3 = G__42025__3;
return G__42025;
})()
;

cljs.core.Symbol.prototype.apply = (function (self__,args42024){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args42024)));
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var sym = this;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$2 ? cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym) : cljs.core.get.call(null,coll,sym));
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var sym = this;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$3 ? cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found) : cljs.core.get.call(null,coll,sym,not_found));
});

cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
});

cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function (sym){
var self__ = this;
var sym__$1 = this;
var h__6978__auto__ = self__._hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_symbol(sym__$1);
self__._hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,self__.str);
});

cljs.core.Symbol.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns,cljs.core.cst$sym$name,cljs.core.cst$sym$str,cljs.core.with_meta(cljs.core.cst$sym$_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$_meta], null);
});

cljs.core.Symbol.cljs$lang$type = true;

cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";

cljs.core.Symbol.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/Symbol");
});

cljs.core.__GT_Symbol = (function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

/**
 * Returns a Symbol with the given namespace and name.
 */
cljs.core.symbol = (function cljs$core$symbol(var_args){
var args42026 = [];
var len__7651__auto___42029 = arguments.length;
var i__7652__auto___42030 = (0);
while(true){
if((i__7652__auto___42030 < len__7651__auto___42029)){
args42026.push((arguments[i__7652__auto___42030]));

var G__42031 = (i__7652__auto___42030 + (1));
i__7652__auto___42030 = G__42031;
continue;
} else {
}
break;
}

var G__42028 = args42026.length;
switch (G__42028) {
case 1:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42026.length)].join('')));

}
});

cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = (function (name){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
var idx = name.indexOf("/");
if((idx < (1))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null,name);
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(name.substring((0),idx),name.substring((idx + (1)),name.length));
}
}
});

cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
var sym_str = ((!((ns == null)))?[cljs.core.str(ns),cljs.core.str("/"),cljs.core.str(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
});

cljs.core.symbol.cljs$lang$maxFixedArity = 2;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IDeref}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 6717441;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Var.prototype.isMacro = (function (){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).cljs$lang$macro;
});

cljs.core.Var.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [cljs.core.str("#'"),cljs.core.str(self__.sym)].join('');
});

cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
});

cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Var.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Var(self__.val,self__.sym,new_meta));
});

cljs.core.Var.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
if((other instanceof cljs.core.Var)){
var G__42034 = this$__$1.sym;
var G__42035 = other.sym;
return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(G__42034,G__42035) : cljs.core._EQ_.call(null,G__42034,G__42035));
} else {
return false;
}
});

cljs.core.Var.prototype.cljs$core$IHash$_hash$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.hash_symbol(self__.sym);
});

cljs.core.Var.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Var.prototype.call = (function() {
var G__42080 = null;
var G__42080__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null);
});
var G__42080__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a);
});
var G__42080__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b);
});
var G__42080__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c);
});
var G__42080__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d);
});
var G__42080__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e);
});
var G__42080__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f);
});
var G__42080__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g);
});
var G__42080__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h);
});
var G__42080__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i);
});
var G__42080__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j);
});
var G__42080__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k);
});
var G__42080__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});
var G__42080__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});
var G__42080__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});
var G__42080__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});
var G__42080__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});
var G__42080__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});
var G__42080__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});
var G__42080__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});
var G__42080__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});
var G__42080__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__42036 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
var G__42037 = a;
var G__42038 = b;
var G__42039 = c;
var G__42040 = d;
var G__42041 = e;
var G__42042 = f;
var G__42043 = g;
var G__42044 = h;
var G__42045 = i;
var G__42046 = j;
var G__42047 = k;
var G__42048 = l;
var G__42049 = m;
var G__42050 = n;
var G__42051 = o;
var G__42052 = p;
var G__42053 = q;
var G__42054 = r;
var G__42055 = s;
var G__42056 = t;
var G__42057 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__42036,G__42037,G__42038,G__42039,G__42040,G__42041,G__42042,G__42043,G__42044,G__42045,G__42046,G__42047,G__42048,G__42049,G__42050,G__42051,G__42052,G__42053,G__42054,G__42055,G__42056,G__42057) : cljs.core.apply.call(null,G__42036,G__42037,G__42038,G__42039,G__42040,G__42041,G__42042,G__42043,G__42044,G__42045,G__42046,G__42047,G__42048,G__42049,G__42050,G__42051,G__42052,G__42053,G__42054,G__42055,G__42056,G__42057));
});
G__42080 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__42080__1.call(this,self__);
case 2:
return G__42080__2.call(this,self__,a);
case 3:
return G__42080__3.call(this,self__,a,b);
case 4:
return G__42080__4.call(this,self__,a,b,c);
case 5:
return G__42080__5.call(this,self__,a,b,c,d);
case 6:
return G__42080__6.call(this,self__,a,b,c,d,e);
case 7:
return G__42080__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__42080__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__42080__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__42080__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__42080__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__42080__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__42080__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__42080__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__42080__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__42080__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__42080__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__42080__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__42080__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__42080__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__42080__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__42080__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42080.cljs$core$IFn$_invoke$arity$1 = G__42080__1;
G__42080.cljs$core$IFn$_invoke$arity$2 = G__42080__2;
G__42080.cljs$core$IFn$_invoke$arity$3 = G__42080__3;
G__42080.cljs$core$IFn$_invoke$arity$4 = G__42080__4;
G__42080.cljs$core$IFn$_invoke$arity$5 = G__42080__5;
G__42080.cljs$core$IFn$_invoke$arity$6 = G__42080__6;
G__42080.cljs$core$IFn$_invoke$arity$7 = G__42080__7;
G__42080.cljs$core$IFn$_invoke$arity$8 = G__42080__8;
G__42080.cljs$core$IFn$_invoke$arity$9 = G__42080__9;
G__42080.cljs$core$IFn$_invoke$arity$10 = G__42080__10;
G__42080.cljs$core$IFn$_invoke$arity$11 = G__42080__11;
G__42080.cljs$core$IFn$_invoke$arity$12 = G__42080__12;
G__42080.cljs$core$IFn$_invoke$arity$13 = G__42080__13;
G__42080.cljs$core$IFn$_invoke$arity$14 = G__42080__14;
G__42080.cljs$core$IFn$_invoke$arity$15 = G__42080__15;
G__42080.cljs$core$IFn$_invoke$arity$16 = G__42080__16;
G__42080.cljs$core$IFn$_invoke$arity$17 = G__42080__17;
G__42080.cljs$core$IFn$_invoke$arity$18 = G__42080__18;
G__42080.cljs$core$IFn$_invoke$arity$19 = G__42080__19;
G__42080.cljs$core$IFn$_invoke$arity$20 = G__42080__20;
G__42080.cljs$core$IFn$_invoke$arity$21 = G__42080__21;
G__42080.cljs$core$IFn$_invoke$arity$22 = G__42080__22;
return G__42080;
})()
;

cljs.core.Var.prototype.apply = (function (self__,args42033){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args42033)));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__42058 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
var G__42059 = a;
var G__42060 = b;
var G__42061 = c;
var G__42062 = d;
var G__42063 = e;
var G__42064 = f;
var G__42065 = g;
var G__42066 = h;
var G__42067 = i;
var G__42068 = j;
var G__42069 = k;
var G__42070 = l;
var G__42071 = m;
var G__42072 = n;
var G__42073 = o;
var G__42074 = p;
var G__42075 = q;
var G__42076 = r;
var G__42077 = s;
var G__42078 = t;
var G__42079 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__42058,G__42059,G__42060,G__42061,G__42062,G__42063,G__42064,G__42065,G__42066,G__42067,G__42068,G__42069,G__42070,G__42071,G__42072,G__42073,G__42074,G__42075,G__42076,G__42077,G__42078,G__42079) : cljs.core.apply.call(null,G__42058,G__42059,G__42060,G__42061,G__42062,G__42063,G__42064,G__42065,G__42066,G__42067,G__42068,G__42069,G__42070,G__42071,G__42072,G__42073,G__42074,G__42075,G__42076,G__42077,G__42078,G__42079));
});

cljs.core.Var.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$val,cljs.core.cst$sym$sym,cljs.core.cst$sym$_meta], null);
});

cljs.core.Var.cljs$lang$type = true;

cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";

cljs.core.Var.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/Var");
});

cljs.core.__GT_Var = (function cljs$core$__GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});

/**
 * Returns true if v is of type cljs.core.Var
 */
cljs.core.var_QMARK_ = (function cljs$core$var_QMARK_(v){
return (v instanceof cljs.core.Var);
});


/**
 * Return true if x implements IIterable protocol.
 */
cljs.core.iterable_QMARK_ = (function cljs$core$iterable_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIterable$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
}
});
/**
 * Clone the supplied value which must implement ICloneable.
 */
cljs.core.clone = (function cljs$core$clone(value){
return cljs.core._clone(value);
});
/**
 * Return true if x implements ICloneable protocol.
 */
cljs.core.cloneable_QMARK_ = (function cljs$core$cloneable_QMARK_(value){
if(!((value == null))){
if(((value.cljs$lang$protocol_mask$partition1$ & (8192))) || ((cljs.core.PROTOCOL_SENTINEL === value.cljs$core$ICloneable$))){
return true;
} else {
if((!value.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
}
});
/**
 * Returns a seq on the collection. If the collection is
 *   empty, returns nil.  (seq nil) returns nil. seq also works on
 *   Strings.
 */
cljs.core.seq = (function cljs$core$seq(coll){
if((coll == null)){
return null;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$)))?true:false):false)){
return coll.cljs$core$ISeqable$_seq$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){
return cljs.core._seq(coll);
} else {
throw (new Error([cljs.core.str(coll),cljs.core.str(" is not ISeqable")].join('')));

}
}
}
}
}
});
/**
 * Returns the first item in the collection. Calls seq on its
 *   argument. If coll is nil, returns nil.
 */
cljs.core.first = (function cljs$core$first(coll){
if((coll == null)){
return null;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$)))?true:false):false)){
return coll.cljs$core$ISeq$_first$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if((s == null)){
return null;
} else {
return cljs.core._first(s);
}
}
}
});
/**
 * Returns a possibly empty seq of the items after the first. Calls seq on its
 *   argument.
 */
cljs.core.rest = (function cljs$core$rest(coll){
if(!((coll == null))){
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$)))?true:false):false)){
return coll.cljs$core$ISeq$_rest$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if(s){
return cljs.core._rest(s);
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a seq of the items after the first. Calls seq on its
 *   argument.  If there are no more items, returns nil
 */
cljs.core.next = (function cljs$core$next(coll){
if((coll == null)){
return null;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$)))?true:false):false)){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
}
});
/**
 * Equality. Returns true if x equals y, false if not. Compares
 *   numbers and collections in a type-independent manner.  Clojure's immutable data
 *   structures define -equiv (and thus =) as a value, not an identity,
 *   comparison.
 */
cljs.core._EQ_ = (function cljs$core$_EQ_(var_args){
var args42093 = [];
var len__7651__auto___42099 = arguments.length;
var i__7652__auto___42100 = (0);
while(true){
if((i__7652__auto___42100 < len__7651__auto___42099)){
args42093.push((arguments[i__7652__auto___42100]));

var G__42101 = (i__7652__auto___42100 + (1));
i__7652__auto___42100 = G__42101;
continue;
} else {
}
break;
}

var G__42098 = args42093.length;
switch (G__42098) {
case 1:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42093.slice((2)),(0),null));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
if((x == null)){
return (y == null);
} else {
return ((x === y)) || (cljs.core._equiv(x,y));
}
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__42103 = y;
var G__42104 = cljs.core.first(more);
var G__42105 = cljs.core.next(more);
x = G__42103;
y = G__42104;
more = G__42105;
continue;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._EQ_.cljs$lang$applyTo = (function (seq42094){
var G__42095 = cljs.core.first(seq42094);
var seq42094__$1 = cljs.core.next(seq42094);
var G__42096 = cljs.core.first(seq42094__$1);
var seq42094__$2 = cljs.core.next(seq42094__$1);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(G__42095,G__42096,seq42094__$2);
});

cljs.core._EQ_.cljs$lang$maxFixedArity = (2);


/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
})
cljs.core.ES6Iterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return ({"value": x, "done": false});
} else {
return ({"value": null, "done": true});
}
});

cljs.core.ES6Iterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ES6Iterator.cljs$lang$type = true;

cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";

cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ES6Iterator");
});

cljs.core.__GT_ES6Iterator = (function cljs$core$__GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

/**
 * EXPERIMENTAL: Return a ES2015 compatible iterator for coll.
 */
cljs.core.es6_iterator = (function cljs$core$es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq(coll)));
});

/**
* @constructor
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.value;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
self__._rest = (cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(self__.iter) : cljs.core.es6_iterator_seq.call(null,self__.iter));
} else {
}

return self__._rest;
});

cljs.core.ES6IteratorSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value,cljs.core.cst$sym$iter,cljs.core.with_meta(cljs.core.cst$sym$_rest,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ES6IteratorSeq.cljs$lang$type = true;

cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";

cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ES6IteratorSeq");
});

cljs.core.__GT_ES6IteratorSeq = (function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

/**
 * EXPERIMENTAL: Given an ES2015 compatible iterator return a seq.
 */
cljs.core.es6_iterator_seq = (function cljs$core$es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return cljs.core.List.EMPTY;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
 * Mix final collection hash for ordered or unordered collections.
 * hash-basis is the combined collection hash, count is the number
 * of elements included in the basis. Note this is the hash code
 * consistent with =, different from .hashCode.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.mix_collection_hash = (function cljs$core$mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1(hash_basis);
var h1__$1 = cljs.core.m3_mix_H1(h1,k1);
return cljs.core.m3_fmix(h1__$1,count);
});
/**
 * Returns the hash code, consistent with =, for an external ordered
 * collection implementing Iterable.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_ordered_coll = (function cljs$core$hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__42106 = (n + (1));
var G__42107 = ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__42108 = cljs.core.next(coll__$1);
n = G__42106;
hash_code = G__42107;
coll__$1 = G__42108;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash((1),(0));
/**
 * Returns the hash code, consistent with =, for an external unordered
 * collection implementing Iterable. For maps, the iterator should
 * return map entries whose hash is computed as
 *   (hash-ordered-coll [k v]).
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_unordered_coll = (function cljs$core$hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__42109 = (n + (1));
var G__42110 = ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__42111 = cljs.core.next(coll__$1);
n = G__42109;
hash_code = G__42110;
coll__$1 = G__42111;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash((0),(0));


(cljs.core.ICounted["null"] = true);

(cljs.core._count["null"] = (function (_){
return (0);
}));
Date.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL;

Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var o__$1 = this;
return ((other instanceof Date)) && ((o__$1.valueOf() === other.valueOf()));
});

Date.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL;

Date.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof Date)){
var G__42112 = this$__$1.valueOf();
var G__42113 = other.valueOf();
return goog.array.defaultCompare(G__42112,G__42113);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});

/**
 * @interface
 */
cljs.core.Inst = function(){};

cljs.core.inst_ms_STAR_ = (function cljs$core$inst_ms_STAR_(inst){
if((!((inst == null))) && (!((inst.cljs$core$Inst$inst_ms_STAR_$arity$1 == null)))){
return inst.cljs$core$Inst$inst_ms_STAR_$arity$1(inst);
} else {
var x__7206__auto__ = (((inst == null))?null:inst);
var m__7207__auto__ = (cljs.core.inst_ms_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__7207__auto__.call(null,inst));
} else {
var m__7207__auto____$1 = (cljs.core.inst_ms_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(inst) : m__7207__auto____$1.call(null,inst));
} else {
throw cljs.core.missing_protocol("Inst.inst-ms*",inst);
}
}
}
});

Date.prototype.cljs$core$Inst$ = cljs.core.PROTOCOL_SENTINEL;

Date.prototype.cljs$core$Inst$inst_ms_STAR_$arity$1 = (function (inst){
var inst__$1 = this;
return inst__$1.getTime();
});
/**
 * Return the number of milliseconds since January 1, 1970, 00:00:00 GMT
 */
cljs.core.inst_ms = (function cljs$core$inst_ms(inst){
return cljs.core.inst_ms_STAR_(inst);
});
/**
 * Return true if x satisfies Inst
 */
cljs.core.inst_QMARK_ = (function cljs$core$inst_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$Inst$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
}
});
(cljs.core.IEquiv["number"] = true);

(cljs.core._equiv["number"] = (function (x,o){
return (x === o);
}));
(cljs.core.Fn["function"] = true);

(cljs.core.IMeta["function"] = true);

(cljs.core._meta["function"] = (function (_){
return null;
}));
(cljs.core.IHash["_"] = true);

(cljs.core._hash["_"] = (function (o){
return goog.getUid(o);
}));
/**
 * Returns a number one greater than num.
 */
cljs.core.inc = (function cljs$core$inc(x){
return (x + (1));
});

/**
* @constructor
 * @implements {cljs.core.IDeref}
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function (o){
var self__ = this;
var o__$1 = this;
return self__.val;
});

cljs.core.Reduced.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$val], null);
});

cljs.core.Reduced.cljs$lang$type = true;

cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";

cljs.core.Reduced.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/Reduced");
});

cljs.core.__GT_Reduced = (function cljs$core$__GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
 * Wraps x in a way such that a reduce will terminate with the value x
 */
cljs.core.reduced = (function cljs$core$reduced(x){
return (new cljs.core.Reduced(x));
});
/**
 * Returns true if x is the result of a call to reduced
 */
cljs.core.reduced_QMARK_ = (function cljs$core$reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
 * If x is already reduced?, returns it, else returns (reduced x)
 */
cljs.core.ensure_reduced = (function cljs$core$ensure_reduced(x){
if(cljs.core.reduced_QMARK_(x)){
return x;
} else {
return cljs.core.reduced(x);
}
});
/**
 * If x is reduced?, returns (deref x), else returns x
 */
cljs.core.unreduced = (function cljs$core$unreduced(x){
if(cljs.core.reduced_QMARK_(x)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(x) : cljs.core.deref.call(null,x));
} else {
return x;
}
});
/**
 * Also reader macro: @var/@atom/@delay. Returns the
 * most-recently-committed value of ref. When applied to a var
 * or atom, returns its current state. When applied to a delay, forces
 * it if not already forced. See also - realized?.
 */
cljs.core.deref = (function cljs$core$deref(o){
return cljs.core._deref(o);
});
/**
 * Accepts any collection which satisfies the ICount and IIndexed protocols and
 * reduces them without incurring seq initialization
 */
cljs.core.ci_reduce = (function cljs$core$ci_reduce(var_args){
var args42116 = [];
var len__7651__auto___42125 = arguments.length;
var i__7652__auto___42126 = (0);
while(true){
if((i__7652__auto___42126 < len__7651__auto___42125)){
args42116.push((arguments[i__7652__auto___42126]));

var G__42127 = (i__7652__auto___42126 + (1));
i__7652__auto___42126 = G__42127;
continue;
} else {
}
break;
}

var G__42118 = args42116.length;
switch (G__42118) {
case 2:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42116.length)].join('')));

}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = (function (cicoll,f){
var cnt = cljs.core._count(cicoll);
if((cnt === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,(0));
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__42119 = val;
var G__42120 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__42119,G__42120) : f.call(null,G__42119,G__42120));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__42129 = nval;
var G__42130 = (n + (1));
val = G__42129;
n = G__42130;
continue;
}
} else {
return val;
}
break;
}
}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = (function (cicoll,f,val){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__42121 = val__$1;
var G__42122 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__42121,G__42122) : f.call(null,G__42121,G__42122));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__42131 = nval;
var G__42132 = (n + (1));
val__$1 = G__42131;
n = G__42132;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4 = (function (cicoll,f,val,idx){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__42123 = val__$1;
var G__42124 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__42123,G__42124) : f.call(null,G__42123,G__42124));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__42133 = nval;
var G__42134 = (n + (1));
val__$1 = G__42133;
n = G__42134;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.ci_reduce.cljs$lang$maxFixedArity = 4;

cljs.core.array_reduce = (function cljs$core$array_reduce(var_args){
var args42135 = [];
var len__7651__auto___42144 = arguments.length;
var i__7652__auto___42145 = (0);
while(true){
if((i__7652__auto___42145 < len__7651__auto___42144)){
args42135.push((arguments[i__7652__auto___42145]));

var G__42146 = (i__7652__auto___42145 + (1));
i__7652__auto___42145 = G__42146;
continue;
} else {
}
break;
}

var G__42137 = args42135.length;
switch (G__42137) {
case 2:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42135.length)].join('')));

}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = (function (arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__42138 = val;
var G__42139 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__42138,G__42139) : f.call(null,G__42138,G__42139));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__42148 = nval;
var G__42149 = (n + (1));
val = G__42148;
n = G__42149;
continue;
}
} else {
return val;
}
break;
}
}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = (function (arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__42140 = val__$1;
var G__42141 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__42140,G__42141) : f.call(null,G__42140,G__42141));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__42150 = nval;
var G__42151 = (n + (1));
val__$1 = G__42150;
n = G__42151;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = (function (arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__42142 = val__$1;
var G__42143 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__42142,G__42143) : f.call(null,G__42142,G__42143));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__42152 = nval;
var G__42153 = (n + (1));
val__$1 = G__42152;
n = G__42153;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.array_reduce.cljs$lang$maxFixedArity = 4;







/**
 * Returns true if coll implements count in constant time
 */
cljs.core.counted_QMARK_ = (function cljs$core$counted_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICounted$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
}
});
/**
 * Returns true if coll implements nth in constant time
 */
cljs.core.indexed_QMARK_ = (function cljs$core$indexed_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIndexed$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
}
});
cljs.core._indexOf = (function cljs$core$_indexOf(var_args){
var args42158 = [];
var len__7651__auto___42161 = arguments.length;
var i__7652__auto___42162 = (0);
while(true){
if((i__7652__auto___42162 < len__7651__auto___42161)){
args42158.push((arguments[i__7652__auto___42162]));

var G__42163 = (i__7652__auto___42162 + (1));
i__7652__auto___42162 = G__42163;
continue;
} else {
}
break;
}

var G__42160 = args42158.length;
switch (G__42160) {
case 2:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42158.length)].join('')));

}
});

cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});

cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3 = (function (coll,x,start){
var len = (cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll));
if((start >= len)){
return (-1);
} else {
var idx = (((start > (0)))?start:(((start < (0)))?(function (){var x__6874__auto__ = (0);
var y__6875__auto__ = (start + len);
return ((x__6874__auto__ > y__6875__auto__) ? x__6874__auto__ : y__6875__auto__);
})():start
));
while(true){
if((idx < len)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((cljs.core.nth.cljs$core$IFn$_invoke$arity$2 ? cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx) : cljs.core.nth.call(null,coll,idx)),x)){
return idx;
} else {
var G__42165 = (idx + (1));
idx = G__42165;
continue;
}
} else {
return (-1);
}
break;
}
}
});

cljs.core._indexOf.cljs$lang$maxFixedArity = 3;

cljs.core._lastIndexOf = (function cljs$core$_lastIndexOf(var_args){
var args42166 = [];
var len__7651__auto___42169 = arguments.length;
var i__7652__auto___42170 = (0);
while(true){
if((i__7652__auto___42170 < len__7651__auto___42169)){
args42166.push((arguments[i__7652__auto___42170]));

var G__42171 = (i__7652__auto___42170 + (1));
i__7652__auto___42170 = G__42171;
continue;
} else {
}
break;
}

var G__42168 = args42166.length;
switch (G__42168) {
case 2:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42166.length)].join('')));

}
});

cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll)));
});

cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3 = (function (coll,x,start){
var len = (cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll));
if((len === (0))){
return (-1);
} else {
var idx = (((start > (0)))?(function (){var x__6881__auto__ = (len - (1));
var y__6882__auto__ = start;
return ((x__6881__auto__ < y__6882__auto__) ? x__6881__auto__ : y__6882__auto__);
})():(((start < (0)))?(len + start):start
));
while(true){
if((idx >= (0))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((cljs.core.nth.cljs$core$IFn$_invoke$arity$2 ? cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx) : cljs.core.nth.call(null,coll,idx)),x)){
return idx;
} else {
var G__42173 = (idx - (1));
idx = G__42173;
continue;
}
} else {
return (-1);
}
break;
}
}
});

cljs.core._lastIndexOf.cljs$lang$maxFixedArity = 3;


/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.IndexedSeqIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.IndexedSeqIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.IndexedSeqIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.IndexedSeqIterator.cljs$lang$type = true;

cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";

cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/IndexedSeqIterator");
});

cljs.core.__GT_IndexedSeqIterator = (function cljs$core$__GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.IndexedSeq = (function (arr,i,meta){
this.arr = arr;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 166592766;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.IndexedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.IndexedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.IndexedSeq.prototype.indexOf = (function() {
var G__42174 = null;
var G__42174__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__42174__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__42174 = function(x,start){
switch(arguments.length){
case 1:
return G__42174__1.call(this,x);
case 2:
return G__42174__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42174.cljs$core$IFn$_invoke$arity$1 = G__42174__1;
G__42174.cljs$core$IFn$_invoke$arity$2 = G__42174__2;
return G__42174;
})()
;

cljs.core.IndexedSeq.prototype.lastIndexOf = (function() {
var G__42175 = null;
var G__42175__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll)));
});
var G__42175__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__42175 = function(x,start){
switch(arguments.length){
case 1:
return G__42175__1.call(this,x);
case 2:
return G__42175__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42175.cljs$core$IFn$_invoke$arity$1 = G__42175__1;
G__42175.cljs$core$IFn$_invoke$arity$2 = G__42175__2;
return G__42175;
})()
;

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return not_found;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i,self__.meta));
});

cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var x__6874__auto__ = (0);
var y__6875__auto__ = (self__.arr.length - self__.i);
return ((x__6874__auto__ > y__6875__auto__) ? x__6874__auto__ : y__6875__auto__);
});

cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var c = cljs.core._count(coll__$1);
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1,other) : cljs.core.equiv_sequential.call(null,coll__$1,other));
});

cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.i < self__.arr.length)){
return this$__$1;
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i,new_meta));
});

cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o,coll__$1) : cljs.core.cons.call(null,o,coll__$1));
});

cljs.core.IndexedSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$meta], null);
});

cljs.core.IndexedSeq.cljs$lang$type = true;

cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";

cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/IndexedSeq");
});

cljs.core.__GT_IndexedSeq = (function cljs$core$__GT_IndexedSeq(arr,i,meta){
return (new cljs.core.IndexedSeq(arr,i,meta));
});

(cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
/**
 * Create seq from a primitive JavaScript Array-like.
 */
cljs.core.prim_seq = (function cljs$core$prim_seq(var_args){
var args42176 = [];
var len__7651__auto___42179 = arguments.length;
var i__7652__auto___42180 = (0);
while(true){
if((i__7652__auto___42180 < len__7651__auto___42179)){
args42176.push((arguments[i__7652__auto___42180]));

var G__42181 = (i__7652__auto___42180 + (1));
i__7652__auto___42180 = G__42181;
continue;
} else {
}
break;
}

var G__42178 = args42176.length;
switch (G__42178) {
case 1:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42176.length)].join('')));

}
});

cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = (function (prim){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));
});

cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = (function (prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i,null));
} else {
return null;
}
});

cljs.core.prim_seq.cljs$lang$maxFixedArity = 2;

/**
 * Create a seq from a JavaScript array.
 */
cljs.core.array_seq = (function cljs$core$array_seq(var_args){
var args42183 = [];
var len__7651__auto___42186 = arguments.length;
var i__7652__auto___42187 = (0);
while(true){
if((i__7652__auto___42187 < len__7651__auto___42186)){
args42183.push((arguments[i__7652__auto___42187]));

var G__42188 = (i__7652__auto___42187 + (1));
i__7652__auto___42187 = G__42188;
continue;
} else {
}
break;
}

var G__42185 = args42183.length;
switch (G__42185) {
case 1:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42183.length)].join('')));

}
});

cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = (function (array){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));
});

cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = (function (array,i){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);
});

cljs.core.array_seq.cljs$lang$maxFixedArity = 2;



/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.RSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.RSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.RSeq.prototype.indexOf = (function() {
var G__42192 = null;
var G__42192__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__42192__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__42192 = function(x,start){
switch(arguments.length){
case 1:
return G__42192__1.call(this,x);
case 2:
return G__42192__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42192.cljs$core$IFn$_invoke$arity$1 = G__42192__1;
G__42192.cljs$core$IFn$_invoke$arity$2 = G__42192__2;
return G__42192;
})()
;

cljs.core.RSeq.prototype.lastIndexOf = (function() {
var G__42193 = null;
var G__42193__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll)));
});
var G__42193__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__42193 = function(x,start){
switch(arguments.length){
case 1:
return G__42193__1.call(this,x);
case 2:
return G__42193__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42193.cljs$core$IFn$_invoke$arity$1 = G__42193__1;
G__42193.cljs$core$IFn$_invoke$arity$2 = G__42193__2;
return G__42193;
})()
;

cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
});

cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
});

cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
});

cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1,other) : cljs.core.equiv_sequential.call(null,coll__$1,other));
});

cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__42190 = cljs.core.List.EMPTY;
var G__42191 = self__.meta;
return (cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2(G__42190,G__42191) : cljs.core.with_meta.call(null,G__42190,G__42191));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (col,f){
var self__ = this;
var col__$1 = this;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,col__$1) : cljs.core.seq_reduce.call(null,f,col__$1));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (col,f,start){
var self__ = this;
var col__$1 = this;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,col__$1) : cljs.core.seq_reduce.call(null,f,start,col__$1));
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci,self__.i);
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
});

cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o,coll__$1) : cljs.core.cons.call(null,o,coll__$1));
});

cljs.core.RSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ci,cljs.core.cst$sym$i,cljs.core.cst$sym$meta], null);
});

cljs.core.RSeq.cljs$lang$type = true;

cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";

cljs.core.RSeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/RSeq");
});

cljs.core.__GT_RSeq = (function cljs$core$__GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

(cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
/**
 * Same as (first (next x))
 */
cljs.core.second = (function cljs$core$second(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (first (first x))
 */
cljs.core.ffirst = (function cljs$core$ffirst(coll){
return cljs.core.first(cljs.core.first(coll));
});
/**
 * Same as (next (first x))
 */
cljs.core.nfirst = (function cljs$core$nfirst(coll){
return cljs.core.next(cljs.core.first(coll));
});
/**
 * Same as (first (next x))
 */
cljs.core.fnext = (function cljs$core$fnext(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (next (next x))
 */
cljs.core.nnext = (function cljs$core$nnext(coll){
return cljs.core.next(cljs.core.next(coll));
});
/**
 * Return the last item in coll, in linear time
 */
cljs.core.last = (function cljs$core$last(s){
while(true){
var sn = cljs.core.next(s);
if(!((sn == null))){
var G__42194 = sn;
s = G__42194;
continue;
} else {
return cljs.core.first(s);
}
break;
}
});
(cljs.core.IEquiv["_"] = true);

(cljs.core._equiv["_"] = (function (x,o){
return (x === o);
}));
/**
 * conj[oin]. Returns a new collection with the xs
 *   'added'. (conj nil item) returns (item).  The 'addition' may
 *   happen at different 'places' depending on the concrete type.
 */
cljs.core.conj = (function cljs$core$conj(var_args){
var args42195 = [];
var len__7651__auto___42201 = arguments.length;
var i__7652__auto___42202 = (0);
while(true){
if((i__7652__auto___42202 < len__7651__auto___42201)){
args42195.push((arguments[i__7652__auto___42202]));

var G__42203 = (i__7652__auto___42202 + (1));
i__7652__auto___42202 = G__42203;
continue;
} else {
}
break;
}

var G__42200 = args42195.length;
switch (G__42200) {
case 0:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42195.slice((2)),(0),null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
if(!((coll == null))){
return cljs.core._conj(coll,x);
} else {
var x__7380__auto__ = x;
return cljs.core._conj(cljs.core.List.EMPTY,x__7380__auto__);
}
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__42205 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
var G__42206 = cljs.core.first(xs);
var G__42207 = cljs.core.next(xs);
coll = G__42205;
x = G__42206;
xs = G__42207;
continue;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
break;
}
});

cljs.core.conj.cljs$lang$applyTo = (function (seq42196){
var G__42197 = cljs.core.first(seq42196);
var seq42196__$1 = cljs.core.next(seq42196);
var G__42198 = cljs.core.first(seq42196__$1);
var seq42196__$2 = cljs.core.next(seq42196__$1);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(G__42197,G__42198,seq42196__$2);
});

cljs.core.conj.cljs$lang$maxFixedArity = (2);

/**
 * Returns an empty collection of the same category as coll, or nil
 */
cljs.core.empty = (function cljs$core$empty(coll){
if((coll == null)){
return null;
} else {
return cljs.core._empty(coll);
}
});
cljs.core.accumulating_seq_count = (function cljs$core$accumulating_seq_count(coll){
var s = cljs.core.seq(coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_(s)){
return (acc + cljs.core._count(s));
} else {
var G__42208 = cljs.core.next(s);
var G__42209 = (acc + (1));
s = G__42208;
acc = G__42209;
continue;
}
break;
}
});
/**
 * Returns the number of items in the collection. (count nil) returns
 *   0.  Also works on strings, arrays, and Maps
 */
cljs.core.count = (function cljs$core$count(coll){
if(!((coll == null))){
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ICounted$)))?true:false):false)){
return coll.cljs$core$ICounted$_count$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$)))?true:false):false)){
return cljs.core.accumulating_seq_count(coll);
} else {
return cljs.core._count(coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function cljs$core$linear_traversal_nth(var_args){
var args42214 = [];
var len__7651__auto___42217 = arguments.length;
var i__7652__auto___42218 = (0);
while(true){
if((i__7652__auto___42218 < len__7651__auto___42217)){
args42214.push((arguments[i__7652__auto___42218]));

var G__42219 = (i__7652__auto___42218 + (1));
i__7652__auto___42218 = G__42219;
continue;
} else {
}
break;
}

var G__42216 = args42214.length;
switch (G__42216) {
case 2:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42214.length)].join('')));

}
});

cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.seq(coll)){
var G__42221 = cljs.core.next(coll);
var G__42222 = (n - (1));
coll = G__42221;
n = G__42222;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
});

cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.seq(coll)){
var G__42223 = cljs.core.next(coll);
var G__42224 = (n - (1));
var G__42225 = not_found;
coll = G__42223;
n = G__42224;
not_found = G__42225;
continue;
} else {
return not_found;

}
}
}
}
break;
}
});

cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3;

/**
 * Returns the value at the index. get returns nil if index out of
 *   bounds, nth throws an exception unless not-found is supplied.  nth
 *   also works for strings, arrays, regex Matchers and Lists, and,
 *   in O(n) time, for sequences.
 */
cljs.core.nth = (function cljs$core$nth(var_args){
var args42226 = [];
var len__7651__auto___42233 = arguments.length;
var i__7652__auto___42234 = (0);
while(true){
if((i__7652__auto___42234 < len__7651__auto___42233)){
args42226.push((arguments[i__7652__auto___42234]));

var G__42235 = (i__7652__auto___42234 + (1));
i__7652__auto___42234 = G__42235;
continue;
} else {
}
break;
}

var G__42228 = args42226.length;
switch (G__42228) {
case 2:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42226.length)].join('')));

}
});

cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if(!(typeof n === 'number')){
throw (new Error("Index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$)))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((n >= (0))) && ((n < coll.length))){
return (coll[n]);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(typeof coll === 'string'){
if(((n >= (0))) && ((n < coll.length))){
return coll.charAt(n);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$)))?true:false):false)){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});

cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if(!(typeof n === 'number')){
throw (new Error("Index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$)))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((n >= (0))) && ((n < coll.length))){
return (coll[n]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if(((n >= (0))) && ((n < coll.length))){
return coll.charAt(n);
} else {
return not_found;
}
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$)))?true:false):false)){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});

cljs.core.nth.cljs$lang$maxFixedArity = 3;

/**
 * Returns the nth rest of coll, coll when n is 0.
 */
cljs.core.nthrest = (function cljs$core$nthrest(coll,n){
var n__$1 = n;
var xs = coll;
while(true){
if(((n__$1 > (0))) && (cljs.core.seq(xs))){
var G__42237 = (n__$1 - (1));
var G__42238 = cljs.core.rest(xs);
n__$1 = G__42237;
xs = G__42238;
continue;
} else {
return xs;
}
break;
}
});
/**
 * Returns the value mapped to key, not-found or nil if key not present.
 */
cljs.core.get = (function cljs$core$get(var_args){
var args42239 = [];
var len__7651__auto___42244 = arguments.length;
var i__7652__auto___42245 = (0);
while(true){
if((i__7652__auto___42245 < len__7651__auto___42244)){
args42239.push((arguments[i__7652__auto___42245]));

var G__42246 = (i__7652__auto___42245 + (1));
i__7652__auto___42245 = G__42246;
continue;
} else {
}
break;
}

var G__42241 = args42239.length;
switch (G__42241) {
case 2:
return cljs.core.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42239.length)].join('')));

}
});

cljs.core.get.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((o == null)){
return null;
} else {
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$)))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$2(null,k);
} else {
if(cljs.core.array_QMARK_(o)){
if((k < o.length)){
return (o[(k | (0))]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((cljs.core.some_QMARK_(k)) && ((k < o.length))){
return (o[(k | (0))]);
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);
} else {
return null;

}
}
}
}
}
});

cljs.core.get.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if(!((o == null))){
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$)))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
} else {
if(cljs.core.array_QMARK_(o)){
if((k < o.length)){
return (o[(k | (0))]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[(k | (0))]);
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
});

cljs.core.get.cljs$lang$maxFixedArity = 3;

/**
 * assoc[iate]. When applied to a map, returns a new map of the
 * same (hashed/sorted) type, that contains the mapping of key(s) to
 * val(s). When applied to a vector, returns a new vector that
 * contains val at index.
 */
cljs.core.assoc = (function cljs$core$assoc(var_args){
var args42248 = [];
var len__7651__auto___42255 = arguments.length;
var i__7652__auto___42256 = (0);
while(true){
if((i__7652__auto___42256 < len__7651__auto___42255)){
args42248.push((arguments[i__7652__auto___42256]));

var G__42257 = (i__7652__auto___42256 + (1));
i__7652__auto___42256 = G__42257;
continue;
} else {
}
break;
}

var G__42254 = args42248.length;
switch (G__42254) {
case 3:
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42248.slice((3)),(0),null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7670__auto__);

}
});

cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = (function (coll,k,v){
if(!((coll == null))){
return cljs.core._assoc(coll,k,v);
} else {
return cljs.core.PersistentHashMap.fromArrays([k],[v]);
}
});

cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,v,kvs){
while(true){
var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);
if(cljs.core.truth_(kvs)){
var G__42259 = ret;
var G__42260 = cljs.core.first(kvs);
var G__42261 = cljs.core.second(kvs);
var G__42262 = cljs.core.nnext(kvs);
coll = G__42259;
k = G__42260;
v = G__42261;
kvs = G__42262;
continue;
} else {
return ret;
}
break;
}
});

cljs.core.assoc.cljs$lang$applyTo = (function (seq42249){
var G__42250 = cljs.core.first(seq42249);
var seq42249__$1 = cljs.core.next(seq42249);
var G__42251 = cljs.core.first(seq42249__$1);
var seq42249__$2 = cljs.core.next(seq42249__$1);
var G__42252 = cljs.core.first(seq42249__$2);
var seq42249__$3 = cljs.core.next(seq42249__$2);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__42250,G__42251,G__42252,seq42249__$3);
});

cljs.core.assoc.cljs$lang$maxFixedArity = (3);

/**
 * dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
 *   that does not contain a mapping for key(s).
 */
cljs.core.dissoc = (function cljs$core$dissoc(var_args){
var args42263 = [];
var len__7651__auto___42269 = arguments.length;
var i__7652__auto___42270 = (0);
while(true){
if((i__7652__auto___42270 < len__7651__auto___42269)){
args42263.push((arguments[i__7652__auto___42270]));

var G__42271 = (i__7652__auto___42270 + (1));
i__7652__auto___42270 = G__42271;
continue;
} else {
}
break;
}

var G__42268 = args42263.length;
switch (G__42268) {
case 1:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42263.slice((2)),(0),null));
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc(coll,k);
}
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__42273 = ret;
var G__42274 = cljs.core.first(ks);
var G__42275 = cljs.core.next(ks);
coll = G__42273;
k = G__42274;
ks = G__42275;
continue;
} else {
return ret;
}
}
break;
}
});

cljs.core.dissoc.cljs$lang$applyTo = (function (seq42264){
var G__42265 = cljs.core.first(seq42264);
var seq42264__$1 = cljs.core.next(seq42264);
var G__42266 = cljs.core.first(seq42264__$1);
var seq42264__$2 = cljs.core.next(seq42264__$1);
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__42265,G__42266,seq42264__$2);
});

cljs.core.dissoc.cljs$lang$maxFixedArity = (2);

/**
 * Return true if f is a JavaScript function or satisfies the Fn protocol.
 */
cljs.core.fn_QMARK_ = (function cljs$core$fn_QMARK_(f){
var or__6543__auto__ = goog.isFunction(f);
if(or__6543__auto__){
return or__6543__auto__;
} else {
if(!((f == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$Fn$))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
}
}
});

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 393217;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
});

cljs.core.MetaFn.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.MetaFn.prototype.call = (function() {
var G__42281 = null;
var G__42281__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});
var G__42281__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
});
var G__42281__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
});
var G__42281__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
});
var G__42281__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
});
var G__42281__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
});
var G__42281__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
});
var G__42281__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
});
var G__42281__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
});
var G__42281__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
});
var G__42281__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
});
var G__42281__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
});
var G__42281__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});
var G__42281__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});
var G__42281__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});
var G__42281__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});
var G__42281__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});
var G__42281__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});
var G__42281__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});
var G__42281__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});
var G__42281__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});
var G__42281__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : cljs.core.apply.call(null,self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
});
G__42281 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__42281__1.call(this,self__);
case 2:
return G__42281__2.call(this,self__,a);
case 3:
return G__42281__3.call(this,self__,a,b);
case 4:
return G__42281__4.call(this,self__,a,b,c);
case 5:
return G__42281__5.call(this,self__,a,b,c,d);
case 6:
return G__42281__6.call(this,self__,a,b,c,d,e);
case 7:
return G__42281__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__42281__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__42281__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__42281__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__42281__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__42281__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__42281__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__42281__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__42281__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__42281__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__42281__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__42281__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__42281__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__42281__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__42281__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__42281__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42281.cljs$core$IFn$_invoke$arity$1 = G__42281__1;
G__42281.cljs$core$IFn$_invoke$arity$2 = G__42281__2;
G__42281.cljs$core$IFn$_invoke$arity$3 = G__42281__3;
G__42281.cljs$core$IFn$_invoke$arity$4 = G__42281__4;
G__42281.cljs$core$IFn$_invoke$arity$5 = G__42281__5;
G__42281.cljs$core$IFn$_invoke$arity$6 = G__42281__6;
G__42281.cljs$core$IFn$_invoke$arity$7 = G__42281__7;
G__42281.cljs$core$IFn$_invoke$arity$8 = G__42281__8;
G__42281.cljs$core$IFn$_invoke$arity$9 = G__42281__9;
G__42281.cljs$core$IFn$_invoke$arity$10 = G__42281__10;
G__42281.cljs$core$IFn$_invoke$arity$11 = G__42281__11;
G__42281.cljs$core$IFn$_invoke$arity$12 = G__42281__12;
G__42281.cljs$core$IFn$_invoke$arity$13 = G__42281__13;
G__42281.cljs$core$IFn$_invoke$arity$14 = G__42281__14;
G__42281.cljs$core$IFn$_invoke$arity$15 = G__42281__15;
G__42281.cljs$core$IFn$_invoke$arity$16 = G__42281__16;
G__42281.cljs$core$IFn$_invoke$arity$17 = G__42281__17;
G__42281.cljs$core$IFn$_invoke$arity$18 = G__42281__18;
G__42281.cljs$core$IFn$_invoke$arity$19 = G__42281__19;
G__42281.cljs$core$IFn$_invoke$arity$20 = G__42281__20;
G__42281.cljs$core$IFn$_invoke$arity$21 = G__42281__21;
G__42281.cljs$core$IFn$_invoke$arity$22 = G__42281__22;
return G__42281;
})()
;

cljs.core.MetaFn.prototype.apply = (function (self__,args42280){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args42280)));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : cljs.core.apply.call(null,self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
});

cljs.core.MetaFn.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$afn,cljs.core.cst$sym$meta], null);
});

cljs.core.MetaFn.cljs$lang$type = true;

cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";

cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/MetaFn");
});

cljs.core.__GT_MetaFn = (function cljs$core$__GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
 * Returns an object of the same type and value as obj, with
 *   map m as its metadata.
 */
cljs.core.with_meta = (function cljs$core$with_meta(o,meta){
if(goog.isFunction(o)){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta(o,meta);
}
}
});
/**
 * Returns the metadata of obj, returns nil if there is no metadata.
 */
cljs.core.meta = (function cljs$core$meta(o){
if((function (){var and__6531__auto__ = !((o == null));
if(and__6531__auto__){
if(!((o == null))){
if(((o.cljs$lang$protocol_mask$partition0$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMeta$))){
return true;
} else {
if((!o.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
}
} else {
return and__6531__auto__;
}
})()){
return cljs.core._meta(o);
} else {
return null;
}
});
/**
 * For a list or queue, same as first, for a vector, same as, but much
 *   more efficient than, last. If the collection is empty, returns nil.
 */
cljs.core.peek = (function cljs$core$peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek(coll);
}
});
/**
 * For a list or queue, returns a new list/queue without the first
 *   item, for a vector, returns a new vector without the last item.
 *   Note - not the same as next/butlast.
 */
cljs.core.pop = (function cljs$core$pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop(coll);
}
});
/**
 * disj[oin]. Returns a new set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj = (function cljs$core$disj(var_args){
var args42286 = [];
var len__7651__auto___42292 = arguments.length;
var i__7652__auto___42293 = (0);
while(true){
if((i__7652__auto___42293 < len__7651__auto___42292)){
args42286.push((arguments[i__7652__auto___42293]));

var G__42294 = (i__7652__auto___42293 + (1));
i__7652__auto___42293 = G__42294;
continue;
} else {
}
break;
}

var G__42291 = args42286.length;
switch (G__42291) {
case 1:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42286.slice((2)),(0),null));
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin(coll,k);
}
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__42296 = ret;
var G__42297 = cljs.core.first(ks);
var G__42298 = cljs.core.next(ks);
coll = G__42296;
k = G__42297;
ks = G__42298;
continue;
} else {
return ret;
}
}
break;
}
});

cljs.core.disj.cljs$lang$applyTo = (function (seq42287){
var G__42288 = cljs.core.first(seq42287);
var seq42287__$1 = cljs.core.next(seq42287);
var G__42289 = cljs.core.first(seq42287__$1);
var seq42287__$2 = cljs.core.next(seq42287__$1);
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(G__42288,G__42289,seq42287__$2);
});

cljs.core.disj.cljs$lang$maxFixedArity = (2);

/**
 * Returns true if coll has no items - same as (not (seq coll)).
 *   Please use the idiom (seq x) rather than (not (empty? x))
 */
cljs.core.empty_QMARK_ = (function cljs$core$empty_QMARK_(coll){
return ((coll == null)) || (cljs.core.not(cljs.core.seq(coll)));
});
/**
 * Returns true if x satisfies ICollection
 */
cljs.core.coll_QMARK_ = (function cljs$core$coll_QMARK_(x){
if((x == null)){
return false;
} else {
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (8))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICollection$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
}
}
});
/**
 * Returns true if x satisfies ISet
 */
cljs.core.set_QMARK_ = (function cljs$core$set_QMARK_(x){
if((x == null)){
return false;
} else {
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
}
}
});
/**
 * Returns true if coll implements Associative
 */
cljs.core.associative_QMARK_ = (function cljs$core$associative_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IAssociative$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
}
});
/**
 * Returns true if coll satisfies ISequential
 */
cljs.core.sequential_QMARK_ = (function cljs$core$sequential_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
}
});
/**
 * Returns true if coll satisfies ISorted
 */
cljs.core.sorted_QMARK_ = (function cljs$core$sorted_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (268435456))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISorted$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
}
});
/**
 * Returns true if coll satisfies IReduce
 */
cljs.core.reduceable_QMARK_ = (function cljs$core$reduceable_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IReduce$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
}
});
/**
 * Return true if x satisfies IMap
 */
cljs.core.map_QMARK_ = (function cljs$core$map_QMARK_(x){
if((x == null)){
return false;
} else {
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
}
}
});
/**
 * Return true if x satisfies IRecord
 */
cljs.core.record_QMARK_ = (function cljs$core$record_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (67108864))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IRecord$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
}
});
/**
 * Return true if x satisfies IVector
 */
cljs.core.vector_QMARK_ = (function cljs$core$vector_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (16384))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IVector$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
}
});

/**
 * Return true if x is satisfies IChunkedSeq.
 */
cljs.core.chunked_seq_QMARK_ = (function cljs$core$chunked_seq_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition1$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IChunkedSeq$))){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Create JavaSript object from an even number arguments representing
 *   interleaved keys and values.
 */
cljs.core.js_obj = (function cljs$core$js_obj(var_args){
var args42319 = [];
var len__7651__auto___42325 = arguments.length;
var i__7652__auto___42326 = (0);
while(true){
if((i__7652__auto___42326 < len__7651__auto___42325)){
args42319.push((arguments[i__7652__auto___42326]));

var G__42327 = (i__7652__auto___42326 + (1));
i__7652__auto___42326 = G__42327;
continue;
} else {
}
break;
}

var G__42322 = args42319.length;
switch (G__42322) {
case 0:
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42319.slice((0)),(0),null));
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__7670__auto__);

}
});

cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = (function (){
return {};
});

cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(goog.object.create,keyvals) : cljs.core.apply.call(null,goog.object.create,keyvals));
});

cljs.core.js_obj.cljs$lang$applyTo = (function (seq42320){
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42320));
});

cljs.core.js_obj.cljs$lang$maxFixedArity = (0);

/**
 * Return the JavaScript keys for an object.
 */
cljs.core.js_keys = (function cljs$core$js_keys(obj){
var keys = [];
var G__42331_42333 = obj;
var G__42332_42334 = ((function (G__42331_42333,keys){
return (function (val,key,obj__$1){
return keys.push(key);
});})(G__42331_42333,keys))
;
goog.object.forEach(G__42331_42333,G__42332_42334);

return keys;
});
/**
 * Delete a property from a JavaScript object.
 */
cljs.core.js_delete = (function cljs$core$js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function cljs$core$array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__42335 = (i__$1 + (1));
var G__42336 = (j__$1 + (1));
var G__42337 = (len__$1 - (1));
i__$1 = G__42335;
j__$1 = G__42336;
len__$1 = G__42337;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function cljs$core$array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__42338 = (i__$1 - (1));
var G__42339 = (j__$1 - (1));
var G__42340 = (len__$1 - (1));
i__$1 = G__42338;
j__$1 = G__42339;
len__$1 = G__42340;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = {};
/**
 * Returns true if x is the value false, false otherwise.
 */
cljs.core.false_QMARK_ = (function cljs$core$false_QMARK_(x){
return x === false;
});
/**
 * Returns true if x is the value true, false otherwise.
 */
cljs.core.true_QMARK_ = (function cljs$core$true_QMARK_(x){
return x === true;
});
/**
 * Return true if x is a Boolean
 */
cljs.core.boolean_QMARK_ = (function cljs$core$boolean_QMARK_(x){
return (x === true) || (x === false);
});
/**
 * Returns true if x identical to the JavaScript undefined value.
 */
cljs.core.undefined_QMARK_ = (function cljs$core$undefined_QMARK_(x){
return (void 0 === x);
});
/**
 * Return true if s satisfies ISeq
 */
cljs.core.seq_QMARK_ = (function cljs$core$seq_QMARK_(s){
if((s == null)){
return false;
} else {
if(!((s == null))){
if(((s.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeq$))){
return true;
} else {
if((!s.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
}
}
});
/**
 * Return true if s satisfies ISeqable
 */
cljs.core.seqable_QMARK_ = (function cljs$core$seqable_QMARK_(s){
if(!((s == null))){
if(((s.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeqable$))){
return true;
} else {
if((!s.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s);
}
});
/**
 * Coerce to boolean
 */
cljs.core.boolean$ = (function cljs$core$boolean(x){
if((x == null)){
return false;
} else {
if(x === false){
return false;
} else {
return true;

}
}
});
/**
 * Returns true if f returns true for fn? or satisfies IFn.
 */
cljs.core.ifn_QMARK_ = (function cljs$core$ifn_QMARK_(f){
var or__6543__auto__ = cljs.core.fn_QMARK_(f);
if(or__6543__auto__){
return or__6543__auto__;
} else {
if(!((f == null))){
if(((f.cljs$lang$protocol_mask$partition0$ & (1))) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$IFn$))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
}
}
});
/**
 * Returns true if n is a JavaScript number with no decimal part.
 */
cljs.core.integer_QMARK_ = (function cljs$core$integer_QMARK_(n){
return (typeof n === 'number') && (!(isNaN(n))) && (!((n === Infinity))) && ((parseFloat(n) === parseInt(n,(10))));
});
/**
 * Return true if x satisfies integer? or is an instance of goog.math.Integer
 * or goog.math.Long.
 */
cljs.core.int_QMARK_ = (function cljs$core$int_QMARK_(x){
return (cljs.core.integer_QMARK_(x)) || ((x instanceof goog.math.Integer)) || ((x instanceof goog.math.Long));
});
/**
 * Return true if x satisfies int? and is positive.
 */
cljs.core.pos_int_QMARK_ = (function cljs$core$pos_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x > (0));
} else {
if((x instanceof goog.math.Integer)){
return (cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero()));
} else {
if((x instanceof goog.math.Long)){
return (cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero()));
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is positive.
 */
cljs.core.neg_int_QMARK_ = (function cljs$core$neg_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x < (0));
} else {
if((x instanceof goog.math.Integer)){
return x.isNegative();
} else {
if((x instanceof goog.math.Long)){
return x.isNegative();
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is a natural integer value.
 */
cljs.core.nat_int_QMARK_ = (function cljs$core$nat_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (!((x < (0)))) || ((x === (0)));
} else {
if((x instanceof goog.math.Integer)){
var or__6543__auto__ = cljs.core.not(x.isNegative());
if(or__6543__auto__){
return or__6543__auto__;
} else {
return x.isZero();
}
} else {
if((x instanceof goog.math.Long)){
var or__6543__auto__ = cljs.core.not(x.isNegative());
if(or__6543__auto__){
return or__6543__auto__;
} else {
return x.isZero();
}
} else {
return false;

}
}
}
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.float_QMARK_ = (function cljs$core$float_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.double_QMARK_ = (function cljs$core$double_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for Infinity and -Infinity values.
 */
cljs.core.infinite_QMARK_ = (function cljs$core$infinite_QMARK_(x){
return ((x === Number.POSITIVE_INFINITY)) || ((x === Number.NEGATIVE_INFINITY));
});
/**
 * Returns true if key is present in the given collection, otherwise
 *   returns false.  Note that for numerically indexed collections like
 *   vectors and arrays, this tests if the numeric key is within the
 *   range of indexes. 'contains?' operates constant or logarithmic time;
 *   it will not perform a linear search for a value.  See also 'some'.
 */
cljs.core.contains_QMARK_ = (function cljs$core$contains_QMARK_(coll,v){
if((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core.find = (function cljs$core$find(coll,k){
if((!((coll == null))) && (cljs.core.associative_QMARK_(coll)) && (cljs.core.contains_QMARK_(coll,k))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k)], null);
} else {
return null;
}
});
/**
 * Returns true if no two of the arguments are =
 */
cljs.core.distinct_QMARK_ = (function cljs$core$distinct_QMARK_(var_args){
var args42351 = [];
var len__7651__auto___42357 = arguments.length;
var i__7652__auto___42358 = (0);
while(true){
if((i__7652__auto___42358 < len__7651__auto___42357)){
args42351.push((arguments[i__7652__auto___42358]));

var G__42359 = (i__7652__auto___42358 + (1));
i__7652__auto___42358 = G__42359;
continue;
} else {
}
break;
}

var G__42356 = args42351.length;
switch (G__42356) {
case 1:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42351.slice((2)),(0),null));
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
if(!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y))){
var s = cljs.core.PersistentHashSet.fromArray([x,y], true);
var xs = more;
while(true){
var x__$1 = cljs.core.first(xs);
var etc = cljs.core.next(xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_(s,x__$1)){
return false;
} else {
var G__42361 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);
var G__42362 = etc;
s = G__42361;
xs = G__42362;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
});

cljs.core.distinct_QMARK_.cljs$lang$applyTo = (function (seq42352){
var G__42353 = cljs.core.first(seq42352);
var seq42352__$1 = cljs.core.next(seq42352);
var G__42354 = cljs.core.first(seq42352__$1);
var seq42352__$2 = cljs.core.next(seq42352__$1);
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__42353,G__42354,seq42352__$2);
});

cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = (2);

/**
 * Comparator. Returns a negative number, zero, or a positive number
 *   when x is logically 'less than', 'equal to', or 'greater than'
 *   y. Uses IComparable if available and google.array.defaultCompare for objects
 *  of the same type and special-cases nil to be less than any other object.
 */
cljs.core.compare = (function cljs$core$compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if(typeof x === 'number'){
if(typeof y === 'number'){
return goog.array.defaultCompare(x,y);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(x),cljs.core.str(" to "),cljs.core.str(y)].join('')));
}
} else {
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition1$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IComparable$)))?true:(((!x.cljs$lang$protocol_mask$partition1$))?cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x))){
return cljs.core._compare(x,y);
} else {
if(((typeof x === 'string') || (cljs.core.array_QMARK_(x)) || (x === true) || (x === false)) && ((cljs.core.type(x) === cljs.core.type(y)))){
return goog.array.defaultCompare(x,y);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(x),cljs.core.str(" to "),cljs.core.str(y)].join('')));
}

}
}
}
}
}
});
/**
 * Compare indexed collection.
 */
cljs.core.compare_indexed = (function cljs$core$compare_indexed(var_args){
var args42365 = [];
var len__7651__auto___42368 = arguments.length;
var i__7652__auto___42369 = (0);
while(true){
if((i__7652__auto___42369 < len__7651__auto___42368)){
args42365.push((arguments[i__7652__auto___42369]));

var G__42370 = (i__7652__auto___42369 + (1));
i__7652__auto___42369 = G__42370;
continue;
} else {
}
break;
}

var G__42367 = args42365.length;
switch (G__42367) {
case 2:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42365.length)].join('')));

}
});

cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = (function (xs,ys){
var xl = cljs.core.count(xs);
var yl = cljs.core.count(ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
if((xl === (0))){
return (0);
} else {
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));

}
}
}
});

cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = (function (xs,ys,len,n){
while(true){
var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));
if(((d === (0))) && (((n + (1)) < len))){
var G__42372 = xs;
var G__42373 = ys;
var G__42374 = len;
var G__42375 = (n + (1));
xs = G__42372;
ys = G__42373;
len = G__42374;
n = G__42375;
continue;
} else {
return d;
}
break;
}
});

cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4;

/**
 * Given a fn that might be boolean valued or a comparator,
 * return a fn that is a comparator.
 */
cljs.core.fn__GT_comparator = (function cljs$core$fn__GT_comparator(f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function (x,y){
var r = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(y,x) : f.call(null,y,x)))){
return (1);
} else {
return (0);
}
}
}
});
}
});
/**
 * Returns a sorted sequence of the items in coll. Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort = (function cljs$core$sort(var_args){
var args42376 = [];
var len__7651__auto___42381 = arguments.length;
var i__7652__auto___42382 = (0);
while(true){
if((i__7652__auto___42382 < len__7651__auto___42381)){
args42376.push((arguments[i__7652__auto___42382]));

var G__42383 = (i__7652__auto___42382 + (1));
i__7652__auto___42382 = G__42383;
continue;
} else {
}
break;
}

var G__42378 = args42376.length;
switch (G__42378) {
case 1:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42376.length)].join('')));

}
});

cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);
});

cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = (function (comp,coll){
if(cljs.core.seq(coll)){
var a = (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null,coll));
var G__42379_42385 = a;
var G__42380_42386 = cljs.core.fn__GT_comparator(comp);
goog.array.stableSort(G__42379_42385,G__42380_42386);

return cljs.core.seq(a);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.sort.cljs$lang$maxFixedArity = 2;

/**
 * Returns a sorted sequence of the items in coll, where the sort
 * order is determined by comparing (keyfn item).  Comp can be
 * boolean-valued comparison funcion, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort_by = (function cljs$core$sort_by(var_args){
var args42387 = [];
var len__7651__auto___42390 = arguments.length;
var i__7652__auto___42391 = (0);
while(true){
if((i__7652__auto___42391 < len__7651__auto___42390)){
args42387.push((arguments[i__7652__auto___42391]));

var G__42392 = (i__7652__auto___42391 + (1));
i__7652__auto___42391 = G__42392;
continue;
} else {
}
break;
}

var G__42389 = args42387.length;
switch (G__42389) {
case 2:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42387.length)].join('')));

}
});

cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);
});

cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = (function (keyfn,comp,coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (x,y){
return cljs.core.fn__GT_comparator(comp).call(null,(keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(x) : keyfn.call(null,x)),(keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(y) : keyfn.call(null,y)));
}),coll);
});

cljs.core.sort_by.cljs$lang$maxFixedArity = 3;

cljs.core.seq_reduce = (function cljs$core$seq_reduce(var_args){
var args42394 = [];
var len__7651__auto___42402 = arguments.length;
var i__7652__auto___42403 = (0);
while(true){
if((i__7652__auto___42403 < len__7651__auto___42402)){
args42394.push((arguments[i__7652__auto___42403]));

var G__42404 = (i__7652__auto___42403 + (1));
i__7652__auto___42403 = G__42404;
continue;
} else {
}
break;
}

var G__42396 = args42394.length;
switch (G__42396) {
case 2:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42394.length)].join('')));

}
});

cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var temp__4655__auto__ = cljs.core.seq(coll);
if(temp__4655__auto__){
var s = temp__4655__auto__;
var G__42397 = f;
var G__42398 = cljs.core.first(s);
var G__42399 = cljs.core.next(s);
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__42397,G__42398,G__42399) : cljs.core.reduce.call(null,G__42397,G__42398,G__42399));
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
});

cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq(coll);
while(true){
if(coll__$1){
var nval = (function (){var G__42400 = val__$1;
var G__42401 = cljs.core.first(coll__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__42400,G__42401) : f.call(null,G__42400,G__42401));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__42406 = nval;
var G__42407 = cljs.core.next(coll__$1);
val__$1 = G__42406;
coll__$1 = G__42407;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3;

/**
 * Return a random permutation of coll
 */
cljs.core.shuffle = (function cljs$core$shuffle(coll){
var a = (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null,coll));
goog.array.shuffle(a);

return (cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(a) : cljs.core.vec.call(null,a));
});
/**
 * f should be a function of 2 arguments. If val is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc. If coll contains no
 *   items, f must accept no arguments as well, and reduce returns the
 *   result of calling f with no arguments.  If coll has only 1 item, it
 *   is returned and f is not called.  If val is supplied, returns the
 *   result of applying f to val and the first item in coll, then
 *   applying f to that result and the 2nd item, etc. If coll contains no
 *   items, returns val and f is not called.
 */
cljs.core.reduce = (function cljs$core$reduce(var_args){
var args42408 = [];
var len__7651__auto___42413 = arguments.length;
var i__7652__auto___42414 = (0);
while(true){
if((i__7652__auto___42414 < len__7651__auto___42413)){
args42408.push((arguments[i__7652__auto___42414]));

var G__42415 = (i__7652__auto___42414 + (1));
i__7652__auto___42414 = G__42415;
continue;
} else {
}
break;
}

var G__42410 = args42408.length;
switch (G__42410) {
case 2:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42408.length)].join('')));

}
});

cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$)))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$2(null,f);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);

}
}
}
}
});

cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$)))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);

}
}
}
}
});

cljs.core.reduce.cljs$lang$maxFixedArity = 3;

/**
 * Reduces an associative collection. f should be a function of 3
 *   arguments. Returns the result of applying f to init, the first key
 *   and the first value in coll, then applying f to that result and the
 *   2nd key and value, etc. If coll contains no entries, returns init
 *   and f is not called. Note that reduce-kv is supported on vectors,
 *   where the keys will be the ordinals.
 */
cljs.core.reduce_kv = (function cljs$core$reduce_kv(f,init,coll){
if(!((coll == null))){
return cljs.core._kv_reduce(coll,f,init);
} else {
return init;
}
});
/**
 * Returns its argument.
 */
cljs.core.identity = (function cljs$core$identity(x){
return x;
});
/**
 * Takes a reducing function f of 2 args and returns a fn suitable for
 *   transduce by adding an arity-1 signature that calls cf (default -
 *   identity) on the result argument.
 */
cljs.core.completing = (function cljs$core$completing(var_args){
var args42417 = [];
var len__7651__auto___42420 = arguments.length;
var i__7652__auto___42421 = (0);
while(true){
if((i__7652__auto___42421 < len__7651__auto___42420)){
args42417.push((arguments[i__7652__auto___42421]));

var G__42422 = (i__7652__auto___42421 + (1));
i__7652__auto___42421 = G__42422;
continue;
} else {
}
break;
}

var G__42419 = args42417.length;
switch (G__42419) {
case 1:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42417.length)].join('')));

}
});

cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);
});

cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = (function (f,cf){
return (function() {
var G__42424 = null;
var G__42424__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
var G__42424__1 = (function (x){
return (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(x) : cf.call(null,x));
});
var G__42424__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
});
G__42424 = function(x,y){
switch(arguments.length){
case 0:
return G__42424__0.call(this);
case 1:
return G__42424__1.call(this,x);
case 2:
return G__42424__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42424.cljs$core$IFn$_invoke$arity$0 = G__42424__0;
G__42424.cljs$core$IFn$_invoke$arity$1 = G__42424__1;
G__42424.cljs$core$IFn$_invoke$arity$2 = G__42424__2;
return G__42424;
})()
});

cljs.core.completing.cljs$lang$maxFixedArity = 2;

/**
 * reduce with a transformation of f (xf). If init is not
 *   supplied, (f) will be called to produce it. f should be a reducing
 *   step function that accepts both 1 and 2 arguments, if it accepts
 *   only 2 you can add the arity-1 with 'completing'. Returns the result
 *   of applying (the transformed) xf to init and the first item in coll,
 *   then applying xf to that result and the 2nd item, etc. If coll
 *   contains no items, returns init and f is not called. Note that
 *   certain transforms may inject or skip items.
 */
cljs.core.transduce = (function cljs$core$transduce(var_args){
var args42425 = [];
var len__7651__auto___42428 = arguments.length;
var i__7652__auto___42429 = (0);
while(true){
if((i__7652__auto___42429 < len__7651__auto___42428)){
args42425.push((arguments[i__7652__auto___42429]));

var G__42430 = (i__7652__auto___42429 + (1));
i__7652__auto___42429 = G__42430;
continue;
} else {
}
break;
}

var G__42427 = args42425.length;
switch (G__42427) {
case 3:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42425.length)].join('')));

}
});

cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = (function (xform,f,coll){
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),coll);
});

cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = (function (xform,f,init,coll){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);
return (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(ret) : f__$1.call(null,ret));
});

cljs.core.transduce.cljs$lang$maxFixedArity = 4;

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core._PLUS_ = (function cljs$core$_PLUS_(var_args){
var args42432 = [];
var len__7651__auto___42438 = arguments.length;
var i__7652__auto___42439 = (0);
while(true){
if((i__7652__auto___42439 < len__7651__auto___42438)){
args42432.push((arguments[i__7652__auto___42439]));

var G__42440 = (i__7652__auto___42439 + (1));
i__7652__auto___42439 = G__42440;
continue;
} else {
}
break;
}

var G__42437 = args42432.length;
switch (G__42437) {
case 0:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42432.slice((2)),(0),null));
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(x + y),more);
});

cljs.core._PLUS_.cljs$lang$applyTo = (function (seq42433){
var G__42434 = cljs.core.first(seq42433);
var seq42433__$1 = cljs.core.next(seq42433);
var G__42435 = cljs.core.first(seq42433__$1);
var seq42433__$2 = cljs.core.next(seq42433__$1);
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(G__42434,G__42435,seq42433__$2);
});

cljs.core._PLUS_.cljs$lang$maxFixedArity = (2);

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core._ = (function cljs$core$_(var_args){
var args42442 = [];
var len__7651__auto___42448 = arguments.length;
var i__7652__auto___42449 = (0);
while(true){
if((i__7652__auto___42449 < len__7651__auto___42448)){
args42442.push((arguments[i__7652__auto___42449]));

var G__42450 = (i__7652__auto___42449 + (1));
i__7652__auto___42449 = G__42450;
continue;
} else {
}
break;
}

var G__42447 = args42442.length;
switch (G__42447) {
case 1:
return cljs.core._.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42442.slice((2)),(0),null));
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core._.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core._.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core._.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,(x - y),more);
});

cljs.core._.cljs$lang$applyTo = (function (seq42443){
var G__42444 = cljs.core.first(seq42443);
var seq42443__$1 = cljs.core.next(seq42443);
var G__42445 = cljs.core.first(seq42443__$1);
var seq42443__$2 = cljs.core.next(seq42443__$1);
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(G__42444,G__42445,seq42443__$2);
});

cljs.core._.cljs$lang$maxFixedArity = (2);

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core._STAR_ = (function cljs$core$_STAR_(var_args){
var args42452 = [];
var len__7651__auto___42458 = arguments.length;
var i__7652__auto___42459 = (0);
while(true){
if((i__7652__auto___42459 < len__7651__auto___42458)){
args42452.push((arguments[i__7652__auto___42459]));

var G__42460 = (i__7652__auto___42459 + (1));
i__7652__auto___42459 = G__42460;
continue;
} else {
}
break;
}

var G__42457 = args42452.length;
switch (G__42457) {
case 0:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42452.slice((2)),(0),null));
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,(x * y),more);
});

cljs.core._STAR_.cljs$lang$applyTo = (function (seq42453){
var G__42454 = cljs.core.first(seq42453);
var seq42453__$1 = cljs.core.next(seq42453);
var G__42455 = cljs.core.first(seq42453__$1);
var seq42453__$2 = cljs.core.next(seq42453__$1);
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(G__42454,G__42455,seq42453__$2);
});

cljs.core._STAR_.cljs$lang$maxFixedArity = (2);

/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core._SLASH_ = (function cljs$core$_SLASH_(var_args){
var args42462 = [];
var len__7651__auto___42468 = arguments.length;
var i__7652__auto___42469 = (0);
while(true){
if((i__7652__auto___42469 < len__7651__auto___42468)){
args42462.push((arguments[i__7652__auto___42469]));

var G__42470 = (i__7652__auto___42469 + (1));
i__7652__auto___42469 = G__42470;
continue;
} else {
}
break;
}

var G__42467 = args42462.length;
switch (G__42467) {
case 1:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42462.slice((2)),(0),null));
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(x / y),more);
});

cljs.core._SLASH_.cljs$lang$applyTo = (function (seq42463){
var G__42464 = cljs.core.first(seq42463);
var seq42463__$1 = cljs.core.next(seq42463);
var G__42465 = cljs.core.first(seq42463__$1);
var seq42463__$2 = cljs.core.next(seq42463__$1);
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(G__42464,G__42465,seq42463__$2);
});

cljs.core._SLASH_.cljs$lang$maxFixedArity = (2);

/**
 * Returns non-nil if nums are in monotonically increasing order,
 *   otherwise false.
 */
cljs.core._LT_ = (function cljs$core$_LT_(var_args){
var args42472 = [];
var len__7651__auto___42478 = arguments.length;
var i__7652__auto___42479 = (0);
while(true){
if((i__7652__auto___42479 < len__7651__auto___42478)){
args42472.push((arguments[i__7652__auto___42479]));

var G__42480 = (i__7652__auto___42479 + (1));
i__7652__auto___42479 = G__42480;
continue;
} else {
}
break;
}

var G__42477 = args42472.length;
switch (G__42477) {
case 1:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42472.slice((2)),(0),null));
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x < y);
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x < y)){
if(cljs.core.next(more)){
var G__42482 = y;
var G__42483 = cljs.core.first(more);
var G__42484 = cljs.core.next(more);
x = G__42482;
y = G__42483;
more = G__42484;
continue;
} else {
return (y < cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._LT_.cljs$lang$applyTo = (function (seq42473){
var G__42474 = cljs.core.first(seq42473);
var seq42473__$1 = cljs.core.next(seq42473);
var G__42475 = cljs.core.first(seq42473__$1);
var seq42473__$2 = cljs.core.next(seq42473__$1);
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(G__42474,G__42475,seq42473__$2);
});

cljs.core._LT_.cljs$lang$maxFixedArity = (2);

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 *   otherwise false.
 */
cljs.core._LT__EQ_ = (function cljs$core$_LT__EQ_(var_args){
var args42485 = [];
var len__7651__auto___42491 = arguments.length;
var i__7652__auto___42492 = (0);
while(true){
if((i__7652__auto___42492 < len__7651__auto___42491)){
args42485.push((arguments[i__7652__auto___42492]));

var G__42493 = (i__7652__auto___42492 + (1));
i__7652__auto___42492 = G__42493;
continue;
} else {
}
break;
}

var G__42490 = args42485.length;
switch (G__42490) {
case 1:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42485.slice((2)),(0),null));
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x <= y);
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next(more)){
var G__42495 = y;
var G__42496 = cljs.core.first(more);
var G__42497 = cljs.core.next(more);
x = G__42495;
y = G__42496;
more = G__42497;
continue;
} else {
return (y <= cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._LT__EQ_.cljs$lang$applyTo = (function (seq42486){
var G__42487 = cljs.core.first(seq42486);
var seq42486__$1 = cljs.core.next(seq42486);
var G__42488 = cljs.core.first(seq42486__$1);
var seq42486__$2 = cljs.core.next(seq42486__$1);
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__42487,G__42488,seq42486__$2);
});

cljs.core._LT__EQ_.cljs$lang$maxFixedArity = (2);

/**
 * Returns non-nil if nums are in monotonically decreasing order,
 *   otherwise false.
 */
cljs.core._GT_ = (function cljs$core$_GT_(var_args){
var args42498 = [];
var len__7651__auto___42504 = arguments.length;
var i__7652__auto___42505 = (0);
while(true){
if((i__7652__auto___42505 < len__7651__auto___42504)){
args42498.push((arguments[i__7652__auto___42505]));

var G__42506 = (i__7652__auto___42505 + (1));
i__7652__auto___42505 = G__42506;
continue;
} else {
}
break;
}

var G__42503 = args42498.length;
switch (G__42503) {
case 1:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42498.slice((2)),(0),null));
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x > y);
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x > y)){
if(cljs.core.next(more)){
var G__42508 = y;
var G__42509 = cljs.core.first(more);
var G__42510 = cljs.core.next(more);
x = G__42508;
y = G__42509;
more = G__42510;
continue;
} else {
return (y > cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._GT_.cljs$lang$applyTo = (function (seq42499){
var G__42500 = cljs.core.first(seq42499);
var seq42499__$1 = cljs.core.next(seq42499);
var G__42501 = cljs.core.first(seq42499__$1);
var seq42499__$2 = cljs.core.next(seq42499__$1);
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(G__42500,G__42501,seq42499__$2);
});

cljs.core._GT_.cljs$lang$maxFixedArity = (2);

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 *   otherwise false.
 */
cljs.core._GT__EQ_ = (function cljs$core$_GT__EQ_(var_args){
var args42511 = [];
var len__7651__auto___42517 = arguments.length;
var i__7652__auto___42518 = (0);
while(true){
if((i__7652__auto___42518 < len__7651__auto___42517)){
args42511.push((arguments[i__7652__auto___42518]));

var G__42519 = (i__7652__auto___42518 + (1));
i__7652__auto___42518 = G__42519;
continue;
} else {
}
break;
}

var G__42516 = args42511.length;
switch (G__42516) {
case 1:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42511.slice((2)),(0),null));
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x >= y);
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next(more)){
var G__42521 = y;
var G__42522 = cljs.core.first(more);
var G__42523 = cljs.core.next(more);
x = G__42521;
y = G__42522;
more = G__42523;
continue;
} else {
return (y >= cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._GT__EQ_.cljs$lang$applyTo = (function (seq42512){
var G__42513 = cljs.core.first(seq42512);
var seq42512__$1 = cljs.core.next(seq42512);
var G__42514 = cljs.core.first(seq42512__$1);
var seq42512__$2 = cljs.core.next(seq42512__$1);
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__42513,G__42514,seq42512__$2);
});

cljs.core._GT__EQ_.cljs$lang$maxFixedArity = (2);

/**
 * Returns a number one less than num.
 */
cljs.core.dec = (function cljs$core$dec(x){
return (x - (1));
});
/**
 * Returns the greatest of the nums.
 */
cljs.core.max = (function cljs$core$max(var_args){
var args42524 = [];
var len__7651__auto___42530 = arguments.length;
var i__7652__auto___42531 = (0);
while(true){
if((i__7652__auto___42531 < len__7651__auto___42530)){
args42524.push((arguments[i__7652__auto___42531]));

var G__42532 = (i__7652__auto___42531 + (1));
i__7652__auto___42531 = G__42532;
continue;
} else {
}
break;
}

var G__42529 = args42524.length;
switch (G__42529) {
case 1:
return cljs.core.max.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.max.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42524.slice((2)),(0),null));
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.max.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.max.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__6874__auto__ = x;
var y__6875__auto__ = y;
return ((x__6874__auto__ > y__6875__auto__) ? x__6874__auto__ : y__6875__auto__);
});

cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(function (){var x__6874__auto__ = x;
var y__6875__auto__ = y;
return ((x__6874__auto__ > y__6875__auto__) ? x__6874__auto__ : y__6875__auto__);
})(),more);
});

cljs.core.max.cljs$lang$applyTo = (function (seq42525){
var G__42526 = cljs.core.first(seq42525);
var seq42525__$1 = cljs.core.next(seq42525);
var G__42527 = cljs.core.first(seq42525__$1);
var seq42525__$2 = cljs.core.next(seq42525__$1);
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(G__42526,G__42527,seq42525__$2);
});

cljs.core.max.cljs$lang$maxFixedArity = (2);

/**
 * Returns the least of the nums.
 */
cljs.core.min = (function cljs$core$min(var_args){
var args42534 = [];
var len__7651__auto___42540 = arguments.length;
var i__7652__auto___42541 = (0);
while(true){
if((i__7652__auto___42541 < len__7651__auto___42540)){
args42534.push((arguments[i__7652__auto___42541]));

var G__42542 = (i__7652__auto___42541 + (1));
i__7652__auto___42541 = G__42542;
continue;
} else {
}
break;
}

var G__42539 = args42534.length;
switch (G__42539) {
case 1:
return cljs.core.min.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.min.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42534.slice((2)),(0),null));
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.min.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.min.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__6881__auto__ = x;
var y__6882__auto__ = y;
return ((x__6881__auto__ < y__6882__auto__) ? x__6881__auto__ : y__6882__auto__);
});

cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(function (){var x__6881__auto__ = x;
var y__6882__auto__ = y;
return ((x__6881__auto__ < y__6882__auto__) ? x__6881__auto__ : y__6882__auto__);
})(),more);
});

cljs.core.min.cljs$lang$applyTo = (function (seq42535){
var G__42536 = cljs.core.first(seq42535);
var seq42535__$1 = cljs.core.next(seq42535);
var G__42537 = cljs.core.first(seq42535__$1);
var seq42535__$2 = cljs.core.next(seq42535__$1);
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(G__42536,G__42537,seq42535__$2);
});

cljs.core.min.cljs$lang$maxFixedArity = (2);

cljs.core.byte$ = (function cljs$core$byte(x){
return x;
});
/**
 * Coerce to char
 */
cljs.core.char$ = (function cljs$core$char(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if((typeof x === 'string') && ((x.length === (1)))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function cljs$core$short(x){
return x;
});
cljs.core.float$ = (function cljs$core$float(x){
return x;
});
cljs.core.double$ = (function cljs$core$double(x){
return x;
});
cljs.core.unchecked_byte = (function cljs$core$unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function cljs$core$unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function cljs$core$unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function cljs$core$unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function cljs$core$unchecked_double(x){
return x;
});
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add = (function cljs$core$unchecked_add(var_args){
var args42544 = [];
var len__7651__auto___42550 = arguments.length;
var i__7652__auto___42551 = (0);
while(true){
if((i__7652__auto___42551 < len__7651__auto___42550)){
args42544.push((arguments[i__7652__auto___42551]));

var G__42552 = (i__7652__auto___42551 + (1));
i__7652__auto___42551 = G__42552;
continue;
} else {
}
break;
}

var G__42549 = args42544.length;
switch (G__42549) {
case 0:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42544.slice((2)),(0),null));
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add,(x + y),more);
});

cljs.core.unchecked_add.cljs$lang$applyTo = (function (seq42545){
var G__42546 = cljs.core.first(seq42545);
var seq42545__$1 = cljs.core.next(seq42545);
var G__42547 = cljs.core.first(seq42545__$1);
var seq42545__$2 = cljs.core.next(seq42545__$1);
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(G__42546,G__42547,seq42545__$2);
});

cljs.core.unchecked_add.cljs$lang$maxFixedArity = (2);

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add_int = (function cljs$core$unchecked_add_int(var_args){
var args42554 = [];
var len__7651__auto___42560 = arguments.length;
var i__7652__auto___42561 = (0);
while(true){
if((i__7652__auto___42561 < len__7651__auto___42560)){
args42554.push((arguments[i__7652__auto___42561]));

var G__42562 = (i__7652__auto___42561 + (1));
i__7652__auto___42561 = G__42562;
continue;
} else {
}
break;
}

var G__42559 = args42554.length;
switch (G__42559) {
case 0:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42554.slice((2)),(0),null));
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int,(x + y),more);
});

cljs.core.unchecked_add_int.cljs$lang$applyTo = (function (seq42555){
var G__42556 = cljs.core.first(seq42555);
var seq42555__$1 = cljs.core.next(seq42555);
var G__42557 = cljs.core.first(seq42555__$1);
var seq42555__$2 = cljs.core.next(seq42555__$1);
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(G__42556,G__42557,seq42555__$2);
});

cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = (2);

/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec = (function cljs$core$unchecked_dec(x){
return (x - (1));
});
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec_int = (function cljs$core$unchecked_dec_int(x){
return (x - (1));
});
/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core.unchecked_divide_int = (function cljs$core$unchecked_divide_int(var_args){
var args42564 = [];
var len__7651__auto___42570 = arguments.length;
var i__7652__auto___42571 = (0);
while(true){
if((i__7652__auto___42571 < len__7651__auto___42570)){
args42564.push((arguments[i__7652__auto___42571]));

var G__42572 = (i__7652__auto___42571 + (1));
i__7652__auto___42571 = G__42572;
continue;
} else {
}
break;
}

var G__42569 = args42564.length;
switch (G__42569) {
case 1:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42564.slice((2)),(0),null));
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int,(x / y),more);
});

cljs.core.unchecked_divide_int.cljs$lang$applyTo = (function (seq42565){
var G__42566 = cljs.core.first(seq42565);
var seq42565__$1 = cljs.core.next(seq42565);
var G__42567 = cljs.core.first(seq42565__$1);
var seq42565__$2 = cljs.core.next(seq42565__$1);
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(G__42566,G__42567,seq42565__$2);
});

cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = (2);

cljs.core.unchecked_inc = (function cljs$core$unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function cljs$core$unchecked_inc_int(x){
return (x + (1));
});
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply = (function cljs$core$unchecked_multiply(var_args){
var args42574 = [];
var len__7651__auto___42580 = arguments.length;
var i__7652__auto___42581 = (0);
while(true){
if((i__7652__auto___42581 < len__7651__auto___42580)){
args42574.push((arguments[i__7652__auto___42581]));

var G__42582 = (i__7652__auto___42581 + (1));
i__7652__auto___42581 = G__42582;
continue;
} else {
}
break;
}

var G__42579 = args42574.length;
switch (G__42579) {
case 0:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42574.slice((2)),(0),null));
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply,(x * y),more);
});

cljs.core.unchecked_multiply.cljs$lang$applyTo = (function (seq42575){
var G__42576 = cljs.core.first(seq42575);
var seq42575__$1 = cljs.core.next(seq42575);
var G__42577 = cljs.core.first(seq42575__$1);
var seq42575__$2 = cljs.core.next(seq42575__$1);
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(G__42576,G__42577,seq42575__$2);
});

cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = (2);

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply_int = (function cljs$core$unchecked_multiply_int(var_args){
var args42584 = [];
var len__7651__auto___42590 = arguments.length;
var i__7652__auto___42591 = (0);
while(true){
if((i__7652__auto___42591 < len__7651__auto___42590)){
args42584.push((arguments[i__7652__auto___42591]));

var G__42592 = (i__7652__auto___42591 + (1));
i__7652__auto___42591 = G__42592;
continue;
} else {
}
break;
}

var G__42589 = args42584.length;
switch (G__42589) {
case 0:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42584.slice((2)),(0),null));
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int,(x * y),more);
});

cljs.core.unchecked_multiply_int.cljs$lang$applyTo = (function (seq42585){
var G__42586 = cljs.core.first(seq42585);
var seq42585__$1 = cljs.core.next(seq42585);
var G__42587 = cljs.core.first(seq42585__$1);
var seq42585__$2 = cljs.core.next(seq42585__$1);
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(G__42586,G__42587,seq42585__$2);
});

cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = (2);

cljs.core.unchecked_negate = (function cljs$core$unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function cljs$core$unchecked_negate_int(x){
return (- x);
});
cljs.core.unchecked_remainder_int = (function cljs$core$unchecked_remainder_int(x,n){
return (cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(x,n) : cljs.core.mod.call(null,x,n));
});
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract = (function cljs$core$unchecked_subtract(var_args){
var args42594 = [];
var len__7651__auto___42600 = arguments.length;
var i__7652__auto___42601 = (0);
while(true){
if((i__7652__auto___42601 < len__7651__auto___42600)){
args42594.push((arguments[i__7652__auto___42601]));

var G__42602 = (i__7652__auto___42601 + (1));
i__7652__auto___42601 = G__42602;
continue;
} else {
}
break;
}

var G__42599 = args42594.length;
switch (G__42599) {
case 1:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42594.slice((2)),(0),null));
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract,(x - y),more);
});

cljs.core.unchecked_subtract.cljs$lang$applyTo = (function (seq42595){
var G__42596 = cljs.core.first(seq42595);
var seq42595__$1 = cljs.core.next(seq42595);
var G__42597 = cljs.core.first(seq42595__$1);
var seq42595__$2 = cljs.core.next(seq42595__$1);
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(G__42596,G__42597,seq42595__$2);
});

cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = (2);

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract_int = (function cljs$core$unchecked_subtract_int(var_args){
var args42604 = [];
var len__7651__auto___42610 = arguments.length;
var i__7652__auto___42611 = (0);
while(true){
if((i__7652__auto___42611 < len__7651__auto___42610)){
args42604.push((arguments[i__7652__auto___42611]));

var G__42612 = (i__7652__auto___42611 + (1));
i__7652__auto___42611 = G__42612;
continue;
} else {
}
break;
}

var G__42609 = args42604.length;
switch (G__42609) {
case 1:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42604.slice((2)),(0),null));
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int,(x - y),more);
});

cljs.core.unchecked_subtract_int.cljs$lang$applyTo = (function (seq42605){
var G__42606 = cljs.core.first(seq42605);
var seq42605__$1 = cljs.core.next(seq42605);
var G__42607 = cljs.core.first(seq42605__$1);
var seq42605__$2 = cljs.core.next(seq42605__$1);
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(G__42606,G__42607,seq42605__$2);
});

cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = (2);

cljs.core.fix = (function cljs$core$fix(q){
if((q >= (0))){
return Math.floor(q);
} else {
return Math.ceil(q);
}
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.int$ = (function cljs$core$int(x){
return (x | (0));
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.unchecked_int = (function cljs$core$unchecked_int(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.long$ = (function cljs$core$long(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.unchecked_long = (function cljs$core$unchecked_long(x){
return cljs.core.fix(x);
});
cljs.core.booleans = (function cljs$core$booleans(x){
return x;
});
cljs.core.bytes = (function cljs$core$bytes(x){
return x;
});
cljs.core.chars = (function cljs$core$chars(x){
return x;
});
cljs.core.shorts = (function cljs$core$shorts(x){
return x;
});
cljs.core.ints = (function cljs$core$ints(x){
return x;
});
cljs.core.floats = (function cljs$core$floats(x){
return x;
});
cljs.core.doubles = (function cljs$core$doubles(x){
return x;
});
cljs.core.longs = (function cljs$core$longs(x){
return x;
});
/**
 * Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
 */
cljs.core.js_mod = (function cljs$core$js_mod(n,d){
return (n % d);
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
cljs.core.mod = (function cljs$core$mod(n,d){
return (((n % d) + d) % d);
});
/**
 * quot[ient] of dividing numerator by denominator.
 */
cljs.core.quot = (function cljs$core$quot(n,d){
var rem = (n % d);
return cljs.core.fix(((n - rem) / d));
});
/**
 * remainder of dividing numerator by denominator.
 */
cljs.core.rem = (function cljs$core$rem(n,d){
var q = cljs.core.quot(n,d);
return (n - (d * q));
});
/**
 * Bitwise exclusive or
 */
cljs.core.bit_xor = (function cljs$core$bit_xor(var_args){
var args42614 = [];
var len__7651__auto___42620 = arguments.length;
var i__7652__auto___42621 = (0);
while(true){
if((i__7652__auto___42621 < len__7651__auto___42620)){
args42614.push((arguments[i__7652__auto___42621]));

var G__42622 = (i__7652__auto___42621 + (1));
i__7652__auto___42621 = G__42622;
continue;
} else {
}
break;
}

var G__42619 = args42614.length;
switch (G__42619) {
case 2:
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42614.slice((2)),(0),null));
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x ^ y);
});

cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor,(x ^ y),more);
});

cljs.core.bit_xor.cljs$lang$applyTo = (function (seq42615){
var G__42616 = cljs.core.first(seq42615);
var seq42615__$1 = cljs.core.next(seq42615);
var G__42617 = cljs.core.first(seq42615__$1);
var seq42615__$2 = cljs.core.next(seq42615__$1);
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(G__42616,G__42617,seq42615__$2);
});

cljs.core.bit_xor.cljs$lang$maxFixedArity = (2);

/**
 * Bitwise and
 */
cljs.core.bit_and = (function cljs$core$bit_and(var_args){
var args42624 = [];
var len__7651__auto___42630 = arguments.length;
var i__7652__auto___42631 = (0);
while(true){
if((i__7652__auto___42631 < len__7651__auto___42630)){
args42624.push((arguments[i__7652__auto___42631]));

var G__42632 = (i__7652__auto___42631 + (1));
i__7652__auto___42631 = G__42632;
continue;
} else {
}
break;
}

var G__42629 = args42624.length;
switch (G__42629) {
case 2:
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42624.slice((2)),(0),null));
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & y);
});

cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and,(x & y),more);
});

cljs.core.bit_and.cljs$lang$applyTo = (function (seq42625){
var G__42626 = cljs.core.first(seq42625);
var seq42625__$1 = cljs.core.next(seq42625);
var G__42627 = cljs.core.first(seq42625__$1);
var seq42625__$2 = cljs.core.next(seq42625__$1);
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(G__42626,G__42627,seq42625__$2);
});

cljs.core.bit_and.cljs$lang$maxFixedArity = (2);

/**
 * Bitwise or
 */
cljs.core.bit_or = (function cljs$core$bit_or(var_args){
var args42634 = [];
var len__7651__auto___42640 = arguments.length;
var i__7652__auto___42641 = (0);
while(true){
if((i__7652__auto___42641 < len__7651__auto___42640)){
args42634.push((arguments[i__7652__auto___42641]));

var G__42642 = (i__7652__auto___42641 + (1));
i__7652__auto___42641 = G__42642;
continue;
} else {
}
break;
}

var G__42639 = args42634.length;
switch (G__42639) {
case 2:
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42634.slice((2)),(0),null));
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x | y);
});

cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or,(x | y),more);
});

cljs.core.bit_or.cljs$lang$applyTo = (function (seq42635){
var G__42636 = cljs.core.first(seq42635);
var seq42635__$1 = cljs.core.next(seq42635);
var G__42637 = cljs.core.first(seq42635__$1);
var seq42635__$2 = cljs.core.next(seq42635__$1);
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(G__42636,G__42637,seq42635__$2);
});

cljs.core.bit_or.cljs$lang$maxFixedArity = (2);

/**
 * Bitwise and with complement
 */
cljs.core.bit_and_not = (function cljs$core$bit_and_not(var_args){
var args42644 = [];
var len__7651__auto___42650 = arguments.length;
var i__7652__auto___42651 = (0);
while(true){
if((i__7652__auto___42651 < len__7651__auto___42650)){
args42644.push((arguments[i__7652__auto___42651]));

var G__42652 = (i__7652__auto___42651 + (1));
i__7652__auto___42651 = G__42652;
continue;
} else {
}
break;
}

var G__42649 = args42644.length;
switch (G__42649) {
case 2:
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42644.slice((2)),(0),null));
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & ~y);
});

cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not,(x & ~y),more);
});

cljs.core.bit_and_not.cljs$lang$applyTo = (function (seq42645){
var G__42646 = cljs.core.first(seq42645);
var seq42645__$1 = cljs.core.next(seq42645);
var G__42647 = cljs.core.first(seq42645__$1);
var seq42645__$2 = cljs.core.next(seq42645__$1);
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(G__42646,G__42647,seq42645__$2);
});

cljs.core.bit_and_not.cljs$lang$maxFixedArity = (2);

/**
 * Clear bit at index n
 */
cljs.core.bit_clear = (function cljs$core$bit_clear(x,n){
return (x & ~(1 << n));
});
/**
 * Flip bit at index n
 */
cljs.core.bit_flip = (function cljs$core$bit_flip(x,n){
return (x ^ (1 << n));
});
/**
 * Bitwise complement
 */
cljs.core.bit_not = (function cljs$core$bit_not(x){
return (~ x);
});
/**
 * Set bit at index n
 */
cljs.core.bit_set = (function cljs$core$bit_set(x,n){
return (x | (1 << n));
});
/**
 * Test bit at index n
 */
cljs.core.bit_test = (function cljs$core$bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
 * Bitwise shift left
 */
cljs.core.bit_shift_left = (function cljs$core$bit_shift_left(x,n){
return (x << n);
});
/**
 * Bitwise shift right
 */
cljs.core.bit_shift_right = (function cljs$core$bit_shift_right(x,n){
return (x >> n);
});
/**
 * DEPRECATED: Bitwise shift right with zero fill
 */
cljs.core.bit_shift_right_zero_fill = (function cljs$core$bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
 * Bitwise shift right with zero fill
 */
cljs.core.unsigned_bit_shift_right = (function cljs$core$unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
 * Counts the number of bits set in n
 */
cljs.core.bit_count = (function cljs$core$bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
 * Returns non-nil if nums all have the equivalent
 *   value, otherwise false. Behavior on non nums is
 *   undefined.
 */
cljs.core._EQ__EQ_ = (function cljs$core$_EQ__EQ_(var_args){
var args42654 = [];
var len__7651__auto___42660 = arguments.length;
var i__7652__auto___42661 = (0);
while(true){
if((i__7652__auto___42661 < len__7651__auto___42660)){
args42654.push((arguments[i__7652__auto___42661]));

var G__42662 = (i__7652__auto___42661 + (1));
i__7652__auto___42661 = G__42662;
continue;
} else {
}
break;
}

var G__42659 = args42654.length;
switch (G__42659) {
case 1:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42654.slice((2)),(0),null));
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return cljs.core._equiv(x,y);
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x === y)){
if(cljs.core.next(more)){
var G__42664 = y;
var G__42665 = cljs.core.first(more);
var G__42666 = cljs.core.next(more);
x = G__42664;
y = G__42665;
more = G__42666;
continue;
} else {
return (y === cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._EQ__EQ_.cljs$lang$applyTo = (function (seq42655){
var G__42656 = cljs.core.first(seq42655);
var seq42655__$1 = cljs.core.next(seq42655);
var G__42657 = cljs.core.first(seq42655__$1);
var seq42655__$2 = cljs.core.next(seq42655__$1);
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__42656,G__42657,seq42655__$2);
});

cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = (2);

/**
 * Returns true if num is greater than zero, else false
 */
cljs.core.pos_QMARK_ = (function cljs$core$pos_QMARK_(x){
return (x > (0));
});
/**
 * Returns true if num is zero, else false
 */
cljs.core.zero_QMARK_ = (function cljs$core$zero_QMARK_(x){
return (x === (0));
});
/**
 * Returns true if num is less than zero, else false
 */
cljs.core.neg_QMARK_ = (function cljs$core$neg_QMARK_(x){
return (x < (0));
});
/**
 * Returns the nth next of coll, (seq coll) when n is 0.
 */
cljs.core.nthnext = (function cljs$core$nthnext(coll,n){
var n__$1 = n;
var xs = cljs.core.seq(coll);
while(true){
if((xs) && ((n__$1 > (0)))){
var G__42667 = (n__$1 - (1));
var G__42668 = cljs.core.next(xs);
n__$1 = G__42667;
xs = G__42668;
continue;
} else {
return xs;
}
break;
}
});
/**
 * With no args, returns the empty string. With one arg x, returns
 *   x.toString().  (str nil) returns the empty string. With more than
 *   one arg, returns the concatenation of the str values of the args.
 */
cljs.core.str = (function cljs$core$str(var_args){
var args42669 = [];
var len__7651__auto___42674 = arguments.length;
var i__7652__auto___42675 = (0);
while(true){
if((i__7652__auto___42675 < len__7651__auto___42674)){
args42669.push((arguments[i__7652__auto___42675]));

var G__42676 = (i__7652__auto___42675 + (1));
i__7652__auto___42675 = G__42676;
continue;
} else {
}
break;
}

var G__42673 = args42669.length;
switch (G__42673) {
case 0:
return cljs.core.str.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42669.slice((1)),(0),null));
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7670__auto__);

}
});

cljs.core.str.cljs$core$IFn$_invoke$arity$0 = (function (){
return "";
});

cljs.core.str.cljs$core$IFn$_invoke$arity$1 = (function (x){
if((x == null)){
return "";
} else {
return [x].join("");
}
});

cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = (function (x,ys){
var sb = (new goog.string.StringBuffer([cljs.core.str(x)].join('')));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__42678 = sb.append([cljs.core.str(cljs.core.first(more))].join(''));
var G__42679 = cljs.core.next(more);
sb = G__42678;
more = G__42679;
continue;
} else {
return sb.toString();
}
break;
}
});

cljs.core.str.cljs$lang$applyTo = (function (seq42670){
var G__42671 = cljs.core.first(seq42670);
var seq42670__$1 = cljs.core.next(seq42670);
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(G__42671,seq42670__$1);
});

cljs.core.str.cljs$lang$maxFixedArity = (1);

/**
 * Returns the substring of s beginning at start inclusive, and ending
 *   at end (defaults to length of string), exclusive.
 */
cljs.core.subs = (function cljs$core$subs(var_args){
var args42680 = [];
var len__7651__auto___42683 = arguments.length;
var i__7652__auto___42684 = (0);
while(true){
if((i__7652__auto___42684 < len__7651__auto___42683)){
args42680.push((arguments[i__7652__auto___42684]));

var G__42685 = (i__7652__auto___42684 + (1));
i__7652__auto___42684 = G__42685;
continue;
} else {
}
break;
}

var G__42682 = args42680.length;
switch (G__42682) {
case 2:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42680.length)].join('')));

}
});

cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = (function (s,start){
return s.substring(start);
});

cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = (function (s,start,end){
return s.substring(start,end);
});

cljs.core.subs.cljs$lang$maxFixedArity = 3;


/**
 * Assumes x is sequential. Returns true if x equals y, otherwise
 *   returns false.
 */
cljs.core.equiv_sequential = (function cljs$core$equiv_sequential(x,y){
return cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?(((cljs.core.counted_QMARK_(x)) && (cljs.core.counted_QMARK_(y)) && (!((cljs.core.count(x) === cljs.core.count(y)))))?false:(function (){var xs = cljs.core.seq(x);
var ys = cljs.core.seq(y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){
var G__42687 = cljs.core.next(xs);
var G__42688 = cljs.core.next(ys);
xs = G__42687;
ys = G__42688;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function cljs$core$hash_coll(coll){
if(cljs.core.seq(coll)){
var res = cljs.core.hash(cljs.core.first(coll));
var s = cljs.core.next(coll);
while(true){
if((s == null)){
return res;
} else {
var G__42689 = cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));
var G__42690 = cljs.core.next(s);
res = G__42689;
s = G__42690;
continue;
}
break;
}
} else {
return (0);
}
});

cljs.core.hash_imap = (function cljs$core$hash_imap(m){
var h = (0);
var s = cljs.core.seq(m);
while(true){
if(s){
var e = cljs.core.first(s);
var G__42691 = ((h + (cljs.core.hash((cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null,e))) ^ cljs.core.hash((cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null,e))))) % (4503599627370496));
var G__42692 = cljs.core.next(s);
h = G__42691;
s = G__42692;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function cljs$core$hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq(s);
while(true){
if(s__$1){
var e = cljs.core.first(s__$1);
var G__42693 = ((h + cljs.core.hash(e)) % (4503599627370496));
var G__42694 = cljs.core.next(s__$1);
h = G__42693;
s__$1 = G__42694;
continue;
} else {
return h;
}
break;
}
});


/**
 * Takes a JavaScript object and a map of names to functions and
 *   attaches said functions as methods on the object.  Any references to
 *   JavaScript's implicit this (via the this-as macro) will resolve to the
 *   object that the function is attached.
 */
cljs.core.extend_object_BANG_ = (function cljs$core$extend_object_BANG_(obj,fn_map){
var seq__42705_42715 = cljs.core.seq(fn_map);
var chunk__42706_42716 = null;
var count__42707_42717 = (0);
var i__42708_42718 = (0);
while(true){
if((i__42708_42718 < count__42707_42717)){
var vec__42709_42719 = chunk__42706_42716.cljs$core$IIndexed$_nth$arity$2(null,i__42708_42718);
var key_name_42720 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42709_42719,(0),null);
var f_42721 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42709_42719,(1),null);
var str_name_42722 = (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_42720) : cljs.core.name.call(null,key_name_42720));
(obj[str_name_42722] = f_42721);

var G__42723 = seq__42705_42715;
var G__42724 = chunk__42706_42716;
var G__42725 = count__42707_42717;
var G__42726 = (i__42708_42718 + (1));
seq__42705_42715 = G__42723;
chunk__42706_42716 = G__42724;
count__42707_42717 = G__42725;
i__42708_42718 = G__42726;
continue;
} else {
var temp__4657__auto___42727 = cljs.core.seq(seq__42705_42715);
if(temp__4657__auto___42727){
var seq__42705_42728__$1 = temp__4657__auto___42727;
if(cljs.core.chunked_seq_QMARK_(seq__42705_42728__$1)){
var c__7357__auto___42729 = (cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(seq__42705_42728__$1) : cljs.core.chunk_first.call(null,seq__42705_42728__$1));
var G__42730 = (cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(seq__42705_42728__$1) : cljs.core.chunk_rest.call(null,seq__42705_42728__$1));
var G__42731 = c__7357__auto___42729;
var G__42732 = cljs.core.count(c__7357__auto___42729);
var G__42733 = (0);
seq__42705_42715 = G__42730;
chunk__42706_42716 = G__42731;
count__42707_42717 = G__42732;
i__42708_42718 = G__42733;
continue;
} else {
var vec__42712_42734 = cljs.core.first(seq__42705_42728__$1);
var key_name_42735 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42712_42734,(0),null);
var f_42736 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42712_42734,(1),null);
var str_name_42737 = (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_42735) : cljs.core.name.call(null,key_name_42735));
(obj[str_name_42737] = f_42736);

var G__42738 = cljs.core.next(seq__42705_42728__$1);
var G__42739 = null;
var G__42740 = (0);
var G__42741 = (0);
seq__42705_42715 = G__42738;
chunk__42706_42716 = G__42739;
count__42707_42717 = G__42740;
i__42708_42718 = G__42741;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.List.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.List.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.List.prototype.indexOf = (function() {
var G__42742 = null;
var G__42742__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__42742__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__42742 = function(x,start){
switch(arguments.length){
case 1:
return G__42742__1.call(this,x);
case 2:
return G__42742__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42742.cljs$core$IFn$_invoke$arity$1 = G__42742__1;
G__42742.cljs$core$IFn$_invoke$arity$2 = G__42742__2;
return G__42742;
})()
;

cljs.core.List.prototype.lastIndexOf = (function() {
var G__42743 = null;
var G__42743__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count);
});
var G__42743__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__42743 = function(x,start){
switch(arguments.length){
case 1:
return G__42743__1.call(this,x);
case 2:
return G__42743__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42743.cljs$core$IFn$_invoke$arity$1 = G__42743__1;
G__42743.cljs$core$IFn$_invoke$arity$2 = G__42743__2;
return G__42743;
})()
;

cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._rest(coll__$1);
});

cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(meta__$1,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
});

cljs.core.List.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$first,cljs.core.cst$sym$rest,cljs.core.cst$sym$count,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.List.cljs$lang$type = true;

cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";

cljs.core.List.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/List");
});

cljs.core.__GT_List = (function cljs$core$__GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

/**
 * Returns true if x implements IList
 */
cljs.core.list_QMARK_ = (function cljs$core$list_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (33554432))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IList$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
}
});
(cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.EmptyList.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.EmptyList.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.EmptyList.prototype.indexOf = (function() {
var G__42746 = null;
var G__42746__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__42746__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__42746 = function(x,start){
switch(arguments.length){
case 1:
return G__42746__1.call(this,x);
case 2:
return G__42746__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42746.cljs$core$IFn$_invoke$arity$1 = G__42746__1;
G__42746.cljs$core$IFn$_invoke$arity$2 = G__42746__2;
return G__42746;
})()
;

cljs.core.EmptyList.prototype.lastIndexOf = (function() {
var G__42747 = null;
var G__42747__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__42747__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__42747 = function(x,start){
switch(arguments.length){
case 1:
return G__42747__1.call(this,x);
case 2:
return G__42747__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42747.cljs$core$IFn$_invoke$arity$1 = G__42747__1;
G__42747.cljs$core$IFn$_invoke$arity$2 = G__42747__2;
return G__42747;
})()
;

cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
});

cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (0);
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
});

cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
});

cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((cljs.core.list_QMARK_(other)) || (cljs.core.sequential_QMARK_(other))){
return (cljs.core.seq(other) == null);
} else {
return false;
}
});

cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.EmptyList(meta__$1));
});

cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
});

cljs.core.EmptyList.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta], null);
});

cljs.core.EmptyList.cljs$lang$type = true;

cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";

cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/EmptyList");
});

cljs.core.__GT_EmptyList = (function cljs$core$__GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

cljs.core.List.EMPTY = (new cljs.core.EmptyList(null));
(cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
/**
 * Returns true if coll satisfies? IReversible.
 */
cljs.core.reversible_QMARK_ = (function cljs$core$reversible_QMARK_(coll){
if(!((coll == null))){
if(((coll.cljs$lang$protocol_mask$partition0$ & (134217728))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReversible$))){
return true;
} else {
if((!coll.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
}
});
/**
 * Returns, in constant time, a seq of the items in rev (which
 *   can be a vector or sorted-map), in reverse order. If rev is empty returns nil
 */
cljs.core.rseq = (function cljs$core$rseq(rev){
return cljs.core._rseq(rev);
});
/**
 * Returns a seq of the items in coll in reverse order. Not lazy.
 */
cljs.core.reverse = (function cljs$core$reverse(coll){
if(cljs.core.reversible_QMARK_(coll)){
return cljs.core.rseq(coll);
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
 * Creates a new list containing the items.
 */
cljs.core.list = (function cljs$core$list(var_args){
var args__7658__auto__ = [];
var len__7651__auto___42751 = arguments.length;
var i__7652__auto___42752 = (0);
while(true){
if((i__7652__auto___42752 < len__7651__auto___42751)){
args__7658__auto__.push((arguments[i__7652__auto___42752]));

var G__42753 = (i__7652__auto___42752 + (1));
i__7652__auto___42752 = G__42753;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var arr = ((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if(!((xs__$1 == null))){
arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));

var G__42754 = xs__$1.cljs$core$INext$_next$arity$1(null);
xs__$1 = G__42754;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__42755 = (i - (1));
var G__42756 = r.cljs$core$ICollection$_conj$arity$2(null,(arr[(i - (1))]));
i = G__42755;
r = G__42756;
continue;
} else {
return r;
}
break;
}
});

cljs.core.list.cljs$lang$maxFixedArity = (0);

cljs.core.list.cljs$lang$applyTo = (function (seq42750){
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42750));
});


/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Cons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Cons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Cons.prototype.indexOf = (function() {
var G__42757 = null;
var G__42757__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__42757__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__42757 = function(x,start){
switch(arguments.length){
case 1:
return G__42757__1.call(this,x);
case 2:
return G__42757__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42757.cljs$core$IFn$_invoke$arity$1 = G__42757__1;
G__42757.cljs$core$IFn$_invoke$arity$2 = G__42757__2;
return G__42757;
})()
;

cljs.core.Cons.prototype.lastIndexOf = (function() {
var G__42758 = null;
var G__42758__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__42758__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__42758 = function(x,start){
switch(arguments.length){
case 1:
return G__42758__1.call(this,x);
case 2:
return G__42758__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42758.cljs$core$IFn$_invoke$arity$1 = G__42758__1;
G__42758.cljs$core$IFn$_invoke$arity$2 = G__42758__2;
return G__42758;
})()
;

cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq(self__.rest);
}
});

cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(meta__$1,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,null));
});

cljs.core.Cons.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$first,cljs.core.cst$sym$rest,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Cons.cljs$lang$type = true;

cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";

cljs.core.Cons.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/Cons");
});

cljs.core.__GT_Cons = (function cljs$core$__GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

(cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
/**
 * Returns a new seq where x is the first element and coll is the rest.
 */
cljs.core.cons = (function cljs$core$cons(x,coll){
if((function (){var or__6543__auto__ = (coll == null);
if(or__6543__auto__){
return or__6543__auto__;
} else {
if(!((coll == null))){
if(((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));
}
});
cljs.core.hash_keyword = (function cljs$core$hash_keyword(k){
return ((cljs.core.hash_symbol(k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function cljs$core$compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__6531__auto__ = cljs.core.not(a.ns);
if(and__6531__auto__){
return b.ns;
} else {
return and__6531__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__42769 = a.ns;
var G__42770 = b.ns;
return goog.array.defaultCompare(G__42769,G__42770);
})();
if(((0) === nsc)){
var G__42771 = a.name;
var G__42772 = b.name;
return goog.array.defaultCompare(G__42771,G__42772);
} else {
return nsc;
}
}
} else {
var G__42773 = a.name;
var G__42774 = b.name;
return goog.array.defaultCompare(G__42773,G__42774);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IPrintWithWriter}
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Keyword.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [cljs.core.str(":"),cljs.core.str(self__.fqn)].join('');
});

cljs.core.Keyword.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
});

cljs.core.Keyword.prototype.call = (function() {
var G__42776 = null;
var G__42776__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});
var G__42776__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});
G__42776 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__42776__2.call(this,self__,coll);
case 3:
return G__42776__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42776.cljs$core$IFn$_invoke$arity$2 = G__42776__2;
G__42776.cljs$core$IFn$_invoke$arity$3 = G__42776__3;
return G__42776;
})()
;

cljs.core.Keyword.prototype.apply = (function (self__,args42775){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args42775)));
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});

cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__6978__auto__ = self__._hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_keyword(this$__$1);
self__._hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,[cljs.core.str(":"),cljs.core.str(self__.fqn)].join(''));
});

cljs.core.Keyword.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns,cljs.core.cst$sym$name,cljs.core.cst$sym$fqn,cljs.core.with_meta(cljs.core.cst$sym$_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Keyword.cljs$lang$type = true;

cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";

cljs.core.Keyword.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/Keyword");
});

cljs.core.__GT_Keyword = (function cljs$core$__GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

/**
 * Return true if x is a Keyword
 */
cljs.core.keyword_QMARK_ = (function cljs$core$keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
/**
 * Efficient test to determine that two keywords are identical.
 */
cljs.core.keyword_identical_QMARK_ = (function cljs$core$keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if(((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
 * Efficient test to determine that two symbols are identical.
 */
cljs.core.symbol_identical_QMARK_ = (function cljs$core$symbol_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if(((x instanceof cljs.core.Symbol)) && ((y instanceof cljs.core.Symbol))){
return (x.str === y.str);
} else {
return false;
}
}
});
/**
 * Returns the namespace String of a symbol or keyword, or nil if not present.
 */
cljs.core.namespace = (function cljs$core$namespace(x){
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition1$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$INamed$)))?true:false):false)){
return x.cljs$core$INamed$_namespace$arity$1(null);
} else {
throw (new Error([cljs.core.str("Doesn't support namespace: "),cljs.core.str(x)].join('')));
}
});
/**
 * Return true if x is a symbol or keyword
 */
cljs.core.ident_QMARK_ = (function cljs$core$ident_QMARK_(x){
return ((x instanceof cljs.core.Keyword)) || ((x instanceof cljs.core.Symbol));
});
/**
 * Return true if x is a symbol or keyword without a namespace
 */
cljs.core.simple_ident_QMARK_ = (function cljs$core$simple_ident_QMARK_(x){
return (cljs.core.ident_QMARK_(x)) && ((cljs.core.namespace(x) == null));
});
/**
 * Return true if x is a symbol or keyword with a namespace
 */
cljs.core.qualified_ident_QMARK_ = (function cljs$core$qualified_ident_QMARK_(x){
var and__6531__auto__ = cljs.core.ident_QMARK_(x);
if(and__6531__auto__){
var and__6531__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__6531__auto____$1)){
return true;
} else {
return and__6531__auto____$1;
}
} else {
return and__6531__auto__;
}
});
/**
 * Return true if x is a symbol without a namespace
 */
cljs.core.simple_symbol_QMARK_ = (function cljs$core$simple_symbol_QMARK_(x){
return ((x instanceof cljs.core.Symbol)) && ((cljs.core.namespace(x) == null));
});
/**
 * Return true if x is a symbol with a namespace
 */
cljs.core.qualified_symbol_QMARK_ = (function cljs$core$qualified_symbol_QMARK_(x){
var and__6531__auto__ = (x instanceof cljs.core.Symbol);
if(and__6531__auto__){
var and__6531__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__6531__auto____$1)){
return true;
} else {
return and__6531__auto____$1;
}
} else {
return and__6531__auto__;
}
});
/**
 * Return true if x is a keyword without a namespace
 */
cljs.core.simple_keyword_QMARK_ = (function cljs$core$simple_keyword_QMARK_(x){
return ((x instanceof cljs.core.Keyword)) && ((cljs.core.namespace(x) == null));
});
/**
 * Return true if x is a keyword with a namespace
 */
cljs.core.qualified_keyword_QMARK_ = (function cljs$core$qualified_keyword_QMARK_(x){
var and__6531__auto__ = (x instanceof cljs.core.Keyword);
if(and__6531__auto__){
var and__6531__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__6531__auto____$1)){
return true;
} else {
return and__6531__auto____$1;
}
} else {
return and__6531__auto__;
}
});
/**
 * Returns a Keyword with the given namespace and name.  Do not use :
 *   in the keyword strings, it will be added automatically.
 */
cljs.core.keyword = (function cljs$core$keyword(var_args){
var args42779 = [];
var len__7651__auto___42782 = arguments.length;
var i__7652__auto___42783 = (0);
while(true){
if((i__7652__auto___42783 < len__7651__auto___42782)){
args42779.push((arguments[i__7652__auto___42783]));

var G__42784 = (i__7652__auto___42783 + (1));
i__7652__auto___42783 = G__42784;
continue;
} else {
}
break;
}

var G__42781 = args42779.length;
switch (G__42781) {
case 1:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42779.length)].join('')));

}
});

cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = (function (name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace(name),(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null,name)),name.str,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
});

cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
var ns__$1 = (((ns instanceof cljs.core.Keyword))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(ns) : cljs.core.name.call(null,ns)):(((ns instanceof cljs.core.Symbol))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(ns) : cljs.core.name.call(null,ns)):ns
));
var name__$1 = (((name instanceof cljs.core.Keyword))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null,name)):(((name instanceof cljs.core.Symbol))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null,name)):name
));
return (new cljs.core.Keyword(ns__$1,name__$1,[cljs.core.str((cljs.core.truth_(ns__$1)?[cljs.core.str(ns__$1),cljs.core.str("/")].join(''):null)),cljs.core.str(name__$1)].join(''),null));
});

cljs.core.keyword.cljs$lang$maxFixedArity = 2;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 1;
})
cljs.core.LazySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.LazySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.LazySeq.prototype.sval = (function (){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
self__.s = (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null));

self__.fn = null;

return self__.s;
}
});

cljs.core.LazySeq.prototype.indexOf = (function() {
var G__42786 = null;
var G__42786__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__42786__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__42786 = function(x,start){
switch(arguments.length){
case 1:
return G__42786__1.call(this,x);
case 2:
return G__42786__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42786.cljs$core$IFn$_invoke$arity$1 = G__42786__1;
G__42786.cljs$core$IFn$_invoke$arity$2 = G__42786__2;
return G__42786;
})()
;

cljs.core.LazySeq.prototype.lastIndexOf = (function() {
var G__42787 = null;
var G__42787__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__42787__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__42787 = function(x,start){
switch(arguments.length){
case 1:
return G__42787__1.call(this,x);
case 2:
return G__42787__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42787.cljs$core$IFn$_invoke$arity$1 = G__42787__1;
G__42787.cljs$core$IFn$_invoke$arity$2 = G__42787__2;
return G__42787;
})()
;

cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.next(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.LazySeq.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.not(self__.fn);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if(!((self__.s == null))){
return cljs.core.rest(self__.s);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__42788 = ls.sval();
ls = G__42788;
continue;
} else {
self__.s = ls;

return cljs.core.seq(self__.s);
}
break;
}
}
});

cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.LazySeq(meta__$1,self__.fn,self__.s,self__.__hash));
});

cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.LazySeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$fn,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.LazySeq.cljs$lang$type = true;

cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";

cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/LazySeq");
});

cljs.core.__GT_LazySeq = (function cljs$core$__GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

(cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ICounted}
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 2;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ChunkBuffer.prototype.add = (function (o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return self__.end = (self__.end + (1));
});

cljs.core.ChunkBuffer.prototype.chunk = (function (o){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
self__.buf = null;

return ret;
});

cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.end;
});

cljs.core.ChunkBuffer.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$buf,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$end,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ChunkBuffer.cljs$lang$type = true;

cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";

cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ChunkBuffer");
});

cljs.core.__GT_ChunkBuffer = (function cljs$core$__GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function cljs$core$chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.IChunk}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 524306;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if(((i >= (0))) && ((i < (self__.end - self__.off)))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
});

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
});

cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
});

cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);
});

cljs.core.ArrayChunk.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off,cljs.core.cst$sym$end], null);
});

cljs.core.ArrayChunk.cljs$lang$type = true;

cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";

cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ArrayChunk");
});

cljs.core.__GT_ArrayChunk = (function cljs$core$__GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function cljs$core$array_chunk(var_args){
var args42789 = [];
var len__7651__auto___42792 = arguments.length;
var i__7652__auto___42793 = (0);
while(true){
if((i__7652__auto___42793 < len__7651__auto___42792)){
args42789.push((arguments[i__7652__auto___42793]));

var G__42794 = (i__7652__auto___42793 + (1));
i__7652__auto___42793 = G__42794;
continue;
} else {
}
break;
}

var G__42791 = args42789.length;
switch (G__42791) {
case 1:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42789.length)].join('')));

}
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = (function (arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = (function (arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = (function (arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk.cljs$lang$maxFixedArity = 3;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedCons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedCons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedCons.prototype.indexOf = (function() {
var G__42796 = null;
var G__42796__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__42796__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__42796 = function(x,start){
switch(arguments.length){
case 1:
return G__42796__1.call(this,x);
case 2:
return G__42796__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42796.cljs$core$IFn$_invoke$arity$1 = G__42796__1;
G__42796.cljs$core$IFn$_invoke$arity$2 = G__42796__2;
return G__42796;
})()
;

cljs.core.ChunkedCons.prototype.lastIndexOf = (function() {
var G__42797 = null;
var G__42797__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__42797__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__42797 = function(x,start){
switch(arguments.length){
case 1:
return G__42797__1.call(this,x);
case 2:
return G__42797__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42797.cljs$core$IFn$_invoke$arity$1 = G__42797__1;
G__42797.cljs$core$IFn$_invoke$arity$2 = G__42797__2;
return G__42797;
})()
;

cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
var more__$1 = cljs.core._seq(self__.more);
if((more__$1 == null)){
return null;
} else {
return more__$1;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk,(0));
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,m,self__.__hash));
});

cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$chunk,cljs.core.cst$sym$more,cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ChunkedCons.cljs$lang$type = true;

cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";

cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ChunkedCons");
});

cljs.core.__GT_ChunkedCons = (function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

(cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
cljs.core.chunk_cons = (function cljs$core$chunk_cons(chunk,rest){
if((cljs.core._count(chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function cljs$core$chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function cljs$core$chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function cljs$core$chunk_first(s){
return cljs.core._chunked_first(s);
});
cljs.core.chunk_rest = (function cljs$core$chunk_rest(s){
return cljs.core._chunked_rest(s);
});
cljs.core.chunk_next = (function cljs$core$chunk_next(s){
if(((!((s == null)))?((((s.cljs$lang$protocol_mask$partition1$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$IChunkedNext$)))?true:false):false)){
return cljs.core._chunked_next(s);
} else {
return cljs.core.seq(cljs.core._chunked_rest(s));
}
});
/**
 * Naive impl of to-array as a start.
 */
cljs.core.to_array = (function cljs$core$to_array(s){
var ary = [];
var s__$1 = s;
while(true){
if(cljs.core.seq(s__$1)){
ary.push(cljs.core.first(s__$1));

var G__42800 = cljs.core.next(s__$1);
s__$1 = G__42800;
continue;
} else {
return ary;
}
break;
}
});
/**
 * Returns a (potentially-ragged) 2-dimensional array
 *   containing the contents of coll.
 */
cljs.core.to_array_2d = (function cljs$core$to_array_2d(coll){
var ret = (new Array(cljs.core.count(coll)));
var i_42801 = (0);
var xs_42802 = cljs.core.seq(coll);
while(true){
if(xs_42802){
(ret[i_42801] = cljs.core.to_array(cljs.core.first(xs_42802)));

var G__42803 = (i_42801 + (1));
var G__42804 = cljs.core.next(xs_42802);
i_42801 = G__42803;
xs_42802 = G__42804;
continue;
} else {
}
break;
}

return ret;
});
/**
 * Creates an array of ints. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.int_array = (function cljs$core$int_array(var_args){
var args42805 = [];
var len__7651__auto___42808 = arguments.length;
var i__7652__auto___42809 = (0);
while(true){
if((i__7652__auto___42809 < len__7651__auto___42808)){
args42805.push((arguments[i__7652__auto___42809]));

var G__42810 = (i__7652__auto___42809 + (1));
i__7652__auto___42809 = G__42810;
continue;
} else {
}
break;
}

var G__42807 = args42805.length;
switch (G__42807) {
case 1:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42805.length)].join('')));

}
});

cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__42812 = (i + (1));
var G__42813 = cljs.core.next(s__$1);
i = G__42812;
s__$1 = G__42813;
continue;
} else {
return a;
}
break;
}
} else {
var n__7461__auto___42814 = size;
var i_42815 = (0);
while(true){
if((i_42815 < n__7461__auto___42814)){
(a[i_42815] = init_val_or_seq);

var G__42816 = (i_42815 + (1));
i_42815 = G__42816;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.int_array.cljs$lang$maxFixedArity = 2;

/**
 * Creates an array of longs. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.long_array = (function cljs$core$long_array(var_args){
var args42817 = [];
var len__7651__auto___42820 = arguments.length;
var i__7652__auto___42821 = (0);
while(true){
if((i__7652__auto___42821 < len__7651__auto___42820)){
args42817.push((arguments[i__7652__auto___42821]));

var G__42822 = (i__7652__auto___42821 + (1));
i__7652__auto___42821 = G__42822;
continue;
} else {
}
break;
}

var G__42819 = args42817.length;
switch (G__42819) {
case 1:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42817.length)].join('')));

}
});

cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__42824 = (i + (1));
var G__42825 = cljs.core.next(s__$1);
i = G__42824;
s__$1 = G__42825;
continue;
} else {
return a;
}
break;
}
} else {
var n__7461__auto___42826 = size;
var i_42827 = (0);
while(true){
if((i_42827 < n__7461__auto___42826)){
(a[i_42827] = init_val_or_seq);

var G__42828 = (i_42827 + (1));
i_42827 = G__42828;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.long_array.cljs$lang$maxFixedArity = 2;

/**
 * Creates an array of doubles. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.double_array = (function cljs$core$double_array(var_args){
var args42829 = [];
var len__7651__auto___42832 = arguments.length;
var i__7652__auto___42833 = (0);
while(true){
if((i__7652__auto___42833 < len__7651__auto___42832)){
args42829.push((arguments[i__7652__auto___42833]));

var G__42834 = (i__7652__auto___42833 + (1));
i__7652__auto___42833 = G__42834;
continue;
} else {
}
break;
}

var G__42831 = args42829.length;
switch (G__42831) {
case 1:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42829.length)].join('')));

}
});

cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__42836 = (i + (1));
var G__42837 = cljs.core.next(s__$1);
i = G__42836;
s__$1 = G__42837;
continue;
} else {
return a;
}
break;
}
} else {
var n__7461__auto___42838 = size;
var i_42839 = (0);
while(true){
if((i_42839 < n__7461__auto___42838)){
(a[i_42839] = init_val_or_seq);

var G__42840 = (i_42839 + (1));
i_42839 = G__42840;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.double_array.cljs$lang$maxFixedArity = 2;

/**
 * Creates an array of objects. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.object_array = (function cljs$core$object_array(var_args){
var args42841 = [];
var len__7651__auto___42844 = arguments.length;
var i__7652__auto___42845 = (0);
while(true){
if((i__7652__auto___42845 < len__7651__auto___42844)){
args42841.push((arguments[i__7652__auto___42845]));

var G__42846 = (i__7652__auto___42845 + (1));
i__7652__auto___42845 = G__42846;
continue;
} else {
}
break;
}

var G__42843 = args42841.length;
switch (G__42843) {
case 1:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42841.length)].join('')));

}
});

cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__42848 = (i + (1));
var G__42849 = cljs.core.next(s__$1);
i = G__42848;
s__$1 = G__42849;
continue;
} else {
return a;
}
break;
}
} else {
var n__7461__auto___42850 = size;
var i_42851 = (0);
while(true){
if((i_42851 < n__7461__auto___42850)){
(a[i_42851] = init_val_or_seq);

var G__42852 = (i_42851 + (1));
i_42851 = G__42852;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.object_array.cljs$lang$maxFixedArity = 2;

/**
 * If coll is counted? returns its count, else will count at most the first n
 * elements of coll using its seq
 */
cljs.core.bounded_count = (function cljs$core$bounded_count(n,coll){
if(cljs.core.counted_QMARK_(coll)){
return cljs.core.count(coll);
} else {
var i = (0);
var s = cljs.core.seq(coll);
while(true){
if((!((s == null))) && ((i < n))){
var G__42853 = (i + (1));
var G__42854 = cljs.core.next(s);
i = G__42853;
s = G__42854;
continue;
} else {
return i;
}
break;
}
}
});
cljs.core.spread = (function cljs$core$spread(arglist){
if((arglist == null)){
return null;
} else {
if((cljs.core.next(arglist) == null)){
return cljs.core.seq(cljs.core.first(arglist));
} else {
return cljs.core.cons(cljs.core.first(arglist),(function (){var G__42856 = cljs.core.next(arglist);
return (cljs.core.spread.cljs$core$IFn$_invoke$arity$1 ? cljs.core.spread.cljs$core$IFn$_invoke$arity$1(G__42856) : cljs.core.spread.call(null,G__42856));
})());

}
}
});
/**
 * Returns a lazy seq representing the concatenation of the elements in the supplied colls.
 */
cljs.core.concat = (function cljs$core$concat(var_args){
var args42857 = [];
var len__7651__auto___42869 = arguments.length;
var i__7652__auto___42870 = (0);
while(true){
if((i__7652__auto___42870 < len__7651__auto___42869)){
args42857.push((arguments[i__7652__auto___42870]));

var G__42871 = (i__7652__auto___42870 + (1));
i__7652__auto___42870 = G__42871;
continue;
} else {
}
break;
}

var G__42862 = args42857.length;
switch (G__42862) {
case 0:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42857.slice((2)),(0),null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = (function (){
return (new cljs.core.LazySeq(null,(function (){
return null;
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return x;
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (new cljs.core.LazySeq(null,(function (){
var s = cljs.core.seq(x);
if(s){
if(cljs.core.chunked_seq_QMARK_(s)){
return cljs.core.chunk_cons(cljs.core.chunk_first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));
} else {
return cljs.core.cons(cljs.core.first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));
}
} else {
return y;
}
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,zs){
var cat = (function cljs$core$cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function (){
var xys__$1 = cljs.core.seq(xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_(xys__$1)){
return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cljs$core$cat(cljs.core.chunk_rest(xys__$1),zs__$1));
} else {
return cljs.core.cons(cljs.core.first(xys__$1),cljs$core$cat(cljs.core.rest(xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cljs$core$cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);
});

cljs.core.concat.cljs$lang$applyTo = (function (seq42858){
var G__42859 = cljs.core.first(seq42858);
var seq42858__$1 = cljs.core.next(seq42858);
var G__42860 = cljs.core.first(seq42858__$1);
var seq42858__$2 = cljs.core.next(seq42858__$1);
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(G__42859,G__42860,seq42858__$2);
});

cljs.core.concat.cljs$lang$maxFixedArity = (2);

/**
 * Creates a new list containing the items prepended to the rest, the
 *   last of which will be treated as a sequence.
 */
cljs.core.list_STAR_ = (function cljs$core$list_STAR_(var_args){
var args42873 = [];
var len__7651__auto___42881 = arguments.length;
var i__7652__auto___42882 = (0);
while(true){
if((i__7652__auto___42882 < len__7651__auto___42881)){
args42873.push((arguments[i__7652__auto___42882]));

var G__42883 = (i__7652__auto___42882 + (1));
i__7652__auto___42882 = G__42883;
continue;
} else {
}
break;
}

var G__42880 = args42873.length;
switch (G__42880) {
case 1:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42873.slice((4)),(0),null));
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7670__auto__);

}
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (args){
return cljs.core.seq(args);
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (a,args){
return cljs.core.cons(a,args);
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (a,b,args){
return cljs.core.cons(a,cljs.core.cons(b,args));
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,args){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,more){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));
});

cljs.core.list_STAR_.cljs$lang$applyTo = (function (seq42874){
var G__42875 = cljs.core.first(seq42874);
var seq42874__$1 = cljs.core.next(seq42874);
var G__42876 = cljs.core.first(seq42874__$1);
var seq42874__$2 = cljs.core.next(seq42874__$1);
var G__42877 = cljs.core.first(seq42874__$2);
var seq42874__$3 = cljs.core.next(seq42874__$2);
var G__42878 = cljs.core.first(seq42874__$3);
var seq42874__$4 = cljs.core.next(seq42874__$3);
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__42875,G__42876,G__42877,G__42878,seq42874__$4);
});

cljs.core.list_STAR_.cljs$lang$maxFixedArity = (4);

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core.transient$ = (function cljs$core$transient(coll){
return cljs.core._as_transient(coll);
});
/**
 * Returns a new, persistent version of the transient collection, in
 *   constant time. The transient collection cannot be used after this
 *   call, any such use will throw an exception.
 */
cljs.core.persistent_BANG_ = (function cljs$core$persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_(tcoll);
});
/**
 * Adds val to the transient collection, and return tcoll. The 'addition'
 *   may happen at different 'places' depending on the concrete type.
 */
cljs.core.conj_BANG_ = (function cljs$core$conj_BANG_(var_args){
var args42885 = [];
var len__7651__auto___42891 = arguments.length;
var i__7652__auto___42892 = (0);
while(true){
if((i__7652__auto___42892 < len__7651__auto___42891)){
args42885.push((arguments[i__7652__auto___42892]));

var G__42893 = (i__7652__auto___42892 + (1));
i__7652__auto___42892 = G__42893;
continue;
} else {
}
break;
}

var G__42890 = args42885.length;
switch (G__42890) {
case 0:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42885.slice((2)),(0),null));
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (tcoll){
return tcoll;
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._conj_BANG_(tcoll,val);
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__42895 = ntcoll;
var G__42896 = cljs.core.first(vals);
var G__42897 = cljs.core.next(vals);
tcoll = G__42895;
val = G__42896;
vals = G__42897;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.conj_BANG_.cljs$lang$applyTo = (function (seq42886){
var G__42887 = cljs.core.first(seq42886);
var seq42886__$1 = cljs.core.next(seq42886);
var G__42888 = cljs.core.first(seq42886__$1);
var seq42886__$2 = cljs.core.next(seq42886__$1);
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__42887,G__42888,seq42886__$2);
});

cljs.core.conj_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * When applied to a transient map, adds mapping of key(s) to
 *   val(s). When applied to a transient vector, sets the val at index.
 *   Note - index must be <= (count vector). Returns coll.
 */
cljs.core.assoc_BANG_ = (function cljs$core$assoc_BANG_(var_args){
var args42898 = [];
var len__7651__auto___42905 = arguments.length;
var i__7652__auto___42906 = (0);
while(true){
if((i__7652__auto___42906 < len__7651__auto___42905)){
args42898.push((arguments[i__7652__auto___42906]));

var G__42907 = (i__7652__auto___42906 + (1));
i__7652__auto___42906 = G__42907;
continue;
} else {
}
break;
}

var G__42904 = args42898.length;
switch (G__42904) {
case 3:
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42898.slice((3)),(0),null));
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7670__auto__);

}
});

cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (tcoll,key,val){
return cljs.core._assoc_BANG_(tcoll,key,val);
});

cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_(tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__42909 = ntcoll;
var G__42910 = cljs.core.first(kvs);
var G__42911 = cljs.core.second(kvs);
var G__42912 = cljs.core.nnext(kvs);
tcoll = G__42909;
key = G__42910;
val = G__42911;
kvs = G__42912;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.assoc_BANG_.cljs$lang$applyTo = (function (seq42899){
var G__42900 = cljs.core.first(seq42899);
var seq42899__$1 = cljs.core.next(seq42899);
var G__42901 = cljs.core.first(seq42899__$1);
var seq42899__$2 = cljs.core.next(seq42899__$1);
var G__42902 = cljs.core.first(seq42899__$2);
var seq42899__$3 = cljs.core.next(seq42899__$2);
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__42900,G__42901,G__42902,seq42899__$3);
});

cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = (3);

/**
 * Returns a transient map that doesn't contain a mapping for key(s).
 */
cljs.core.dissoc_BANG_ = (function cljs$core$dissoc_BANG_(var_args){
var args42913 = [];
var len__7651__auto___42919 = arguments.length;
var i__7652__auto___42920 = (0);
while(true){
if((i__7652__auto___42920 < len__7651__auto___42919)){
args42913.push((arguments[i__7652__auto___42920]));

var G__42921 = (i__7652__auto___42920 + (1));
i__7652__auto___42920 = G__42921;
continue;
} else {
}
break;
}

var G__42918 = args42913.length;
switch (G__42918) {
case 2:
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42913.slice((2)),(0),null));
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,key){
return cljs.core._dissoc_BANG_(tcoll,key);
});

cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_(tcoll,key);
if(cljs.core.truth_(ks)){
var G__42923 = ntcoll;
var G__42924 = cljs.core.first(ks);
var G__42925 = cljs.core.next(ks);
tcoll = G__42923;
key = G__42924;
ks = G__42925;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.dissoc_BANG_.cljs$lang$applyTo = (function (seq42914){
var G__42915 = cljs.core.first(seq42914);
var seq42914__$1 = cljs.core.next(seq42914);
var G__42916 = cljs.core.first(seq42914__$1);
var seq42914__$2 = cljs.core.next(seq42914__$1);
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__42915,G__42916,seq42914__$2);
});

cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Removes the last item from a transient vector. If
 *   the collection is empty, throws an exception. Returns tcoll
 */
cljs.core.pop_BANG_ = (function cljs$core$pop_BANG_(tcoll){
return cljs.core._pop_BANG_(tcoll);
});
/**
 * disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj_BANG_ = (function cljs$core$disj_BANG_(var_args){
var args42926 = [];
var len__7651__auto___42932 = arguments.length;
var i__7652__auto___42933 = (0);
while(true){
if((i__7652__auto___42933 < len__7651__auto___42932)){
args42926.push((arguments[i__7652__auto___42933]));

var G__42934 = (i__7652__auto___42933 + (1));
i__7652__auto___42933 = G__42934;
continue;
} else {
}
break;
}

var G__42931 = args42926.length;
switch (G__42931) {
case 2:
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42926.slice((2)),(0),null));
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._disjoin_BANG_(tcoll,val);
});

cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__42936 = ntcoll;
var G__42937 = cljs.core.first(vals);
var G__42938 = cljs.core.next(vals);
tcoll = G__42936;
val = G__42937;
vals = G__42938;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.disj_BANG_.cljs$lang$applyTo = (function (seq42927){
var G__42928 = cljs.core.first(seq42927);
var seq42927__$1 = cljs.core.next(seq42927);
var G__42929 = cljs.core.first(seq42927__$1);
var seq42927__$2 = cljs.core.next(seq42927__$1);
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__42928,G__42929,seq42927__$2);
});

cljs.core.disj_BANG_.cljs$lang$maxFixedArity = (2);


cljs.core.apply_to = (function cljs$core$apply_to(f,argc,args){
var args__$1 = cljs.core.seq(args);
if((argc === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var a7505 = cljs.core._first(args__$1);
var args__$2 = cljs.core._rest(args__$1);
if((argc === (1))){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a7505);
} else {
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(a7505) : f.call(null,a7505));
}
} else {
var b7506 = cljs.core._first(args__$2);
var args__$3 = cljs.core._rest(args__$2);
if((argc === (2))){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a7505,b7506);
} else {
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(a7505,b7506) : f.call(null,a7505,b7506));
}
} else {
var c7507 = cljs.core._first(args__$3);
var args__$4 = cljs.core._rest(args__$3);
if((argc === (3))){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a7505,b7506,c7507);
} else {
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(a7505,b7506,c7507) : f.call(null,a7505,b7506,c7507));
}
} else {
var d7508 = cljs.core._first(args__$4);
var args__$5 = cljs.core._rest(args__$4);
if((argc === (4))){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a7505,b7506,c7507,d7508);
} else {
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(a7505,b7506,c7507,d7508) : f.call(null,a7505,b7506,c7507,d7508));
}
} else {
var e7509 = cljs.core._first(args__$5);
var args__$6 = cljs.core._rest(args__$5);
if((argc === (5))){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a7505,b7506,c7507,d7508,e7509);
} else {
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(a7505,b7506,c7507,d7508,e7509) : f.call(null,a7505,b7506,c7507,d7508,e7509));
}
} else {
var f7510 = cljs.core._first(args__$6);
var args__$7 = cljs.core._rest(args__$6);
if((argc === (6))){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a7505,b7506,c7507,d7508,e7509,f7510);
} else {
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(a7505,b7506,c7507,d7508,e7509,f7510) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510));
}
} else {
var g7511 = cljs.core._first(args__$7);
var args__$8 = cljs.core._rest(args__$7);
if((argc === (7))){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a7505,b7506,c7507,d7508,e7509,f7510,g7511);
} else {
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(a7505,b7506,c7507,d7508,e7509,f7510,g7511) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511));
}
} else {
var h7512 = cljs.core._first(args__$8);
var args__$9 = cljs.core._rest(args__$8);
if((argc === (8))){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512);
} else {
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512));
}
} else {
var i7513 = cljs.core._first(args__$9);
var args__$10 = cljs.core._rest(args__$9);
if((argc === (9))){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513);
} else {
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513));
}
} else {
var j7514 = cljs.core._first(args__$10);
var args__$11 = cljs.core._rest(args__$10);
if((argc === (10))){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514);
} else {
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514));
}
} else {
var k7515 = cljs.core._first(args__$11);
var args__$12 = cljs.core._rest(args__$11);
if((argc === (11))){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515);
} else {
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515));
}
} else {
var l7516 = cljs.core._first(args__$12);
var args__$13 = cljs.core._rest(args__$12);
if((argc === (12))){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516);
} else {
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516));
}
} else {
var m7517 = cljs.core._first(args__$13);
var args__$14 = cljs.core._rest(args__$13);
if((argc === (13))){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517);
} else {
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517));
}
} else {
var n7518 = cljs.core._first(args__$14);
var args__$15 = cljs.core._rest(args__$14);
if((argc === (14))){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518);
} else {
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518));
}
} else {
var o7519 = cljs.core._first(args__$15);
var args__$16 = cljs.core._rest(args__$15);
if((argc === (15))){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519);
} else {
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519));
}
} else {
var p7520 = cljs.core._first(args__$16);
var args__$17 = cljs.core._rest(args__$16);
if((argc === (16))){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520);
} else {
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520));
}
} else {
var q7521 = cljs.core._first(args__$17);
var args__$18 = cljs.core._rest(args__$17);
if((argc === (17))){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521);
} else {
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521));
}
} else {
var r7522 = cljs.core._first(args__$18);
var args__$19 = cljs.core._rest(args__$18);
if((argc === (18))){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521,r7522);
} else {
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521,r7522) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521,r7522));
}
} else {
var s7523 = cljs.core._first(args__$19);
var args__$20 = cljs.core._rest(args__$19);
if((argc === (19))){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521,r7522,s7523);
} else {
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521,r7522,s7523) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521,r7522,s7523));
}
} else {
var t7524 = cljs.core._first(args__$20);
var args__$21 = cljs.core._rest(args__$20);
if((argc === (20))){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521,r7522,s7523,t7524);
} else {
return (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521,r7522,s7523,t7524) : f.call(null,a7505,b7506,c7507,d7508,e7509,f7510,g7511,h7512,i7513,j7514,k7515,l7516,m7517,n7518,o7519,p7520,q7521,r7522,s7523,t7524));
}
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
 * Applies fn f to the argument list formed by prepending intervening arguments to args.
 */
cljs.core.apply = (function cljs$core$apply(var_args){
var args42939 = [];
var len__7651__auto___42948 = arguments.length;
var i__7652__auto___42949 = (0);
while(true){
if((i__7652__auto___42949 < len__7651__auto___42948)){
args42939.push((arguments[i__7652__auto___42949]));

var G__42950 = (i__7652__auto___42949 + (1));
i__7652__auto___42949 = G__42950;
continue;
} else {
}
break;
}

var G__42947 = args42939.length;
switch (G__42947) {
case 2:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42939.slice((5)),(0),null));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__7670__auto__);

}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = (function (f,args){
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count((fixed_arity + (1)),args);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return f.apply(f,cljs.core.to_array(args));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = (function (f,x,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count((fixed_arity + (1)),arglist);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count((fixed_arity + (1)),arglist);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = (function (f,x,y,z,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count((fixed_arity + (1)),arglist);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = (function (f,a,b,c,d,args){
var arglist = cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(args)))));
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count((fixed_arity + (1)),arglist);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$lang$applyTo = (function (seq42940){
var G__42941 = cljs.core.first(seq42940);
var seq42940__$1 = cljs.core.next(seq42940);
var G__42942 = cljs.core.first(seq42940__$1);
var seq42940__$2 = cljs.core.next(seq42940__$1);
var G__42943 = cljs.core.first(seq42940__$2);
var seq42940__$3 = cljs.core.next(seq42940__$2);
var G__42944 = cljs.core.first(seq42940__$3);
var seq42940__$4 = cljs.core.next(seq42940__$3);
var G__42945 = cljs.core.first(seq42940__$4);
var seq42940__$5 = cljs.core.next(seq42940__$4);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(G__42941,G__42942,G__42943,G__42944,G__42945,seq42940__$5);
});

cljs.core.apply.cljs$lang$maxFixedArity = (5);

/**
 * Returns an object of the same type and value as obj, with
 *   (apply f (meta obj) args) as its metadata.
 */
cljs.core.vary_meta = (function cljs$core$vary_meta(var_args){
var args42952 = [];
var len__7651__auto___42977 = arguments.length;
var i__7652__auto___42978 = (0);
while(true){
if((i__7652__auto___42978 < len__7651__auto___42977)){
args42952.push((arguments[i__7652__auto___42978]));

var G__42979 = (i__7652__auto___42978 + (1));
i__7652__auto___42978 = G__42979;
continue;
} else {
}
break;
}

var G__42961 = args42952.length;
switch (G__42961) {
case 2:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42952.slice((6)),(0),null));
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__7670__auto__);

}
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = (function (obj,f){
return cljs.core.with_meta(obj,(function (){var G__42962 = cljs.core.meta(obj);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__42962) : f.call(null,G__42962));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = (function (obj,f,a){
return cljs.core.with_meta(obj,(function (){var G__42963 = cljs.core.meta(obj);
var G__42964 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__42963,G__42964) : f.call(null,G__42963,G__42964));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = (function (obj,f,a,b){
return cljs.core.with_meta(obj,(function (){var G__42965 = cljs.core.meta(obj);
var G__42966 = a;
var G__42967 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__42965,G__42966,G__42967) : f.call(null,G__42965,G__42966,G__42967));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = (function (obj,f,a,b,c){
return cljs.core.with_meta(obj,(function (){var G__42968 = cljs.core.meta(obj);
var G__42969 = a;
var G__42970 = b;
var G__42971 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__42968,G__42969,G__42970,G__42971) : f.call(null,G__42968,G__42969,G__42970,G__42971));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = (function (obj,f,a,b,c,d){
return cljs.core.with_meta(obj,(function (){var G__42972 = cljs.core.meta(obj);
var G__42973 = a;
var G__42974 = b;
var G__42975 = c;
var G__42976 = d;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__42972,G__42973,G__42974,G__42975,G__42976) : f.call(null,G__42972,G__42973,G__42974,G__42975,G__42976));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = (function (obj,f,a,b,c,d,args){
return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.array_seq([d,args], 0)));
});

cljs.core.vary_meta.cljs$lang$applyTo = (function (seq42953){
var G__42954 = cljs.core.first(seq42953);
var seq42953__$1 = cljs.core.next(seq42953);
var G__42955 = cljs.core.first(seq42953__$1);
var seq42953__$2 = cljs.core.next(seq42953__$1);
var G__42956 = cljs.core.first(seq42953__$2);
var seq42953__$3 = cljs.core.next(seq42953__$2);
var G__42957 = cljs.core.first(seq42953__$3);
var seq42953__$4 = cljs.core.next(seq42953__$3);
var G__42958 = cljs.core.first(seq42953__$4);
var seq42953__$5 = cljs.core.next(seq42953__$4);
var G__42959 = cljs.core.first(seq42953__$5);
var seq42953__$6 = cljs.core.next(seq42953__$5);
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(G__42954,G__42955,G__42956,G__42957,G__42958,G__42959,seq42953__$6);
});

cljs.core.vary_meta.cljs$lang$maxFixedArity = (6);

/**
 * Same as (not (= obj1 obj2))
 */
cljs.core.not_EQ_ = (function cljs$core$not_EQ_(var_args){
var args42981 = [];
var len__7651__auto___42987 = arguments.length;
var i__7652__auto___42988 = (0);
while(true){
if((i__7652__auto___42988 < len__7651__auto___42987)){
args42981.push((arguments[i__7652__auto___42988]));

var G__42989 = (i__7652__auto___42988 + (1));
i__7652__auto___42988 = G__42989;
continue;
} else {
}
break;
}

var G__42986 = args42981.length;
switch (G__42986) {
case 1:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args42981.slice((2)),(0),null));
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return false;
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));
});

cljs.core.not_EQ_.cljs$lang$applyTo = (function (seq42982){
var G__42983 = cljs.core.first(seq42982);
var seq42982__$1 = cljs.core.next(seq42982);
var G__42984 = cljs.core.first(seq42982__$1);
var seq42982__$2 = cljs.core.next(seq42982__$1);
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(G__42983,G__42984,seq42982__$2);
});

cljs.core.not_EQ_.cljs$lang$maxFixedArity = (2);

/**
 * If coll is empty, returns nil, else coll
 */
cljs.core.not_empty = (function cljs$core$not_empty(coll){
if(cljs.core.seq(coll)){
return coll;
} else {
return null;
}
});
cljs.core.nil_iter = (function cljs$core$nil_iter(){
if(typeof cljs.core.t_cljs$core42994 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.t_cljs$core42994 = (function (meta42995){
this.meta42995 = meta42995;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.t_cljs$core42994.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42996,meta42995__$1){
var self__ = this;
var _42996__$1 = this;
return (new cljs.core.t_cljs$core42994(meta42995__$1));
});

cljs.core.t_cljs$core42994.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42996){
var self__ = this;
var _42996__$1 = this;
return self__.meta42995;
});

cljs.core.t_cljs$core42994.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return false;
});

cljs.core.t_cljs$core42994.prototype.next = (function (){
var self__ = this;
var _ = this;
return (new Error("No such element"));
});

cljs.core.t_cljs$core42994.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.t_cljs$core42994.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta42995], null);
});

cljs.core.t_cljs$core42994.cljs$lang$type = true;

cljs.core.t_cljs$core42994.cljs$lang$ctorStr = "cljs.core/t_cljs$core42994";

cljs.core.t_cljs$core42994.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/t_cljs$core42994");
});

cljs.core.__GT_t_cljs$core42994 = (function cljs$core$nil_iter_$___GT_t_cljs$core42994(meta42995){
return (new cljs.core.t_cljs$core42994(meta42995));
});

}

return (new cljs.core.t_cljs$core42994(cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
})
cljs.core.StringIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
});

cljs.core.StringIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.StringIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.StringIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.StringIter.cljs$lang$type = true;

cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";

cljs.core.StringIter.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/StringIter");
});

cljs.core.__GT_StringIter = (function cljs$core$__GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function cljs$core$string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.ArrayIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.ArrayIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.ArrayIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.ArrayIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayIter.cljs$lang$type = true;

cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";

cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ArrayIter");
});

cljs.core.__GT_ArrayIter = (function cljs$core$__GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function cljs$core$array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = ({});
cljs.core.START = ({});

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
})
cljs.core.SeqIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
self__._seq = cljs.core.START;

self__._next = cljs.core.seq(self__._next);
} else {
if((self__._seq === self__._next)){
self__._next = cljs.core.next(self__._seq);
} else {
}
}

return !((self__._next == null));
});

cljs.core.SeqIter.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(cljs.core.not(this$.hasNext())){
throw (new Error("No such element"));
} else {
self__._seq = self__._next;

return cljs.core.first(self__._next);
}
});

cljs.core.SeqIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.SeqIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$_seq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.SeqIter.cljs$lang$type = true;

cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";

cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/SeqIter");
});

cljs.core.__GT_SeqIter = (function cljs$core$__GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function cljs$core$seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function cljs$core$iter(coll){
if((coll == null)){
return cljs.core.nil_iter();
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter(coll);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_iter(coll);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core._iterator(coll);
} else {
if(cljs.core.seqable_QMARK_(coll)){
return cljs.core.seq_iter(coll);
} else {
throw (new Error([cljs.core.str("Cannot create iterator from "),cljs.core.str(coll)].join('')));

}
}
}
}
}
});
cljs.core.lazy_transformer = (function cljs$core$lazy_transformer(stepper){
return (new cljs.core.LazyTransformer(stepper,null,null,null));
});

/**
* @constructor
*/
cljs.core.Stepper = (function (xform,iter){
this.xform = xform;
this.iter = iter;
})
cljs.core.Stepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__6531__auto__ = !((lt.stepper == null));
if(and__6531__auto__){
return self__.iter.hasNext();
} else {
return and__6531__auto__;
}
})())){
if(cljs.core.reduced_QMARK_((function (){var G__42997 = lt;
var G__42998 = self__.iter.next();
return (self__.xform.cljs$core$IFn$_invoke$arity$2 ? self__.xform.cljs$core$IFn$_invoke$arity$2(G__42997,G__42998) : self__.xform.call(null,G__42997,G__42998));
})())){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(lt) : self__.xform.call(null,lt));
}
});

cljs.core.Stepper.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$iter], null);
});

cljs.core.Stepper.cljs$lang$type = true;

cljs.core.Stepper.cljs$lang$ctorStr = "cljs.core/Stepper";

cljs.core.Stepper.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/Stepper");
});

cljs.core.__GT_Stepper = (function cljs$core$__GT_Stepper(xform,iter){
return (new cljs.core.Stepper(xform,iter));
});

cljs.core.stepper = (function cljs$core$stepper(xform,iter){
var stepfn = (function() {
var cljs$core$stepper_$_stepfn = null;
var cljs$core$stepper_$_stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return result;
});
var cljs$core$stepper_$_stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
cljs$core$stepper_$_stepfn = function(result,input){
switch(arguments.length){
case 1:
return cljs$core$stepper_$_stepfn__1.call(this,result);
case 2:
return cljs$core$stepper_$_stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepper_$_stepfn__1;
cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepper_$_stepfn__2;
return cljs$core$stepper_$_stepfn;
})()
;
return (new cljs.core.Stepper((xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(stepfn) : xform.call(null,stepfn)),iter));
});

/**
* @constructor
*/
cljs.core.MultiStepper = (function (xform,iters,nexts){
this.xform = xform;
this.iters = iters;
this.nexts = nexts;
})
cljs.core.MultiStepper.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq(self__.iters);
while(true){
if(!((iters__$1 == null))){
var iter = cljs.core.first(iters__$1);
if(cljs.core.not(iter.hasNext())){
return false;
} else {
var G__42999 = cljs.core.next(iters__$1);
iters__$1 = G__42999;
continue;
}
} else {
return true;
}
break;
}
});

cljs.core.MultiStepper.prototype.next = (function (){
var self__ = this;
var _ = this;
var n__7461__auto___43000 = self__.iters.length;
var i_43001 = (0);
while(true){
if((i_43001 < n__7461__auto___43000)){
(self__.nexts[i_43001] = (self__.iters[i_43001]).next());

var G__43002 = (i_43001 + (1));
i_43001 = G__43002;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(self__.nexts,(0));
});

cljs.core.MultiStepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__6531__auto__ = !((lt.stepper == null));
if(and__6531__auto__){
return this$.hasNext();
} else {
return and__6531__auto__;
}
})())){
if(cljs.core.reduced_QMARK_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xform,cljs.core.cons(lt,this$.next())))){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(lt) : self__.xform.call(null,lt));
}
});

cljs.core.MultiStepper.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$iters,cljs.core.cst$sym$nexts], null);
});

cljs.core.MultiStepper.cljs$lang$type = true;

cljs.core.MultiStepper.cljs$lang$ctorStr = "cljs.core/MultiStepper";

cljs.core.MultiStepper.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/MultiStepper");
});

cljs.core.__GT_MultiStepper = (function cljs$core$__GT_MultiStepper(xform,iters,nexts){
return (new cljs.core.MultiStepper(xform,iters,nexts));
});

cljs.core.multi_stepper = (function cljs$core$multi_stepper(var_args){
var args43003 = [];
var len__7651__auto___43006 = arguments.length;
var i__7652__auto___43007 = (0);
while(true){
if((i__7652__auto___43007 < len__7651__auto___43006)){
args43003.push((arguments[i__7652__auto___43007]));

var G__43008 = (i__7652__auto___43007 + (1));
i__7652__auto___43007 = G__43008;
continue;
} else {
}
break;
}

var G__43005 = args43003.length;
switch (G__43005) {
case 2:
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43003.length)].join('')));

}
});

cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2 = (function (xform,iters){
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length)));
});

cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3 = (function (xform,iters,nexts){
var stepfn = (function() {
var cljs$core$stepfn = null;
var cljs$core$stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return lt;
});
var cljs$core$stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
cljs$core$stepfn = function(result,input){
switch(arguments.length){
case 1:
return cljs$core$stepfn__1.call(this,result);
case 2:
return cljs$core$stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepfn__1;
cljs$core$stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepfn__2;
return cljs$core$stepfn;
})()
;
return (new cljs.core.MultiStepper((xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(stepfn) : xform.call(null,stepfn)),iters,nexts));
});

cljs.core.multi_stepper.cljs$lang$maxFixedArity = 3;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.LazyTransformer = (function (stepper,first,rest,meta){
this.stepper = stepper;
this.first = first;
this.rest = rest;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 31850700;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.LazyTransformer.prototype.indexOf = (function() {
var G__43010 = null;
var G__43010__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__43010__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__43010 = function(x,start){
switch(arguments.length){
case 1:
return G__43010__1.call(this,x);
case 2:
return G__43010__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43010.cljs$core$IFn$_invoke$arity$1 = G__43010__1;
G__43010.cljs$core$IFn$_invoke$arity$2 = G__43010__2;
return G__43010;
})()
;

cljs.core.LazyTransformer.prototype.lastIndexOf = (function() {
var G__43011 = null;
var G__43011__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__43011__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__43011 = function(x,start){
switch(arguments.length){
case 1:
return G__43011__1.call(this,x);
case 2:
return G__43011__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43011.cljs$core$IFn$_invoke$arity$1 = G__43011__1;
G__43011.cljs$core$IFn$_invoke$arity$2 = G__43011__2;
return G__43011;
})()
;

cljs.core.LazyTransformer.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
});

cljs.core.LazyTransformer.prototype.cljs$core$INext$_next$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return cljs.core._seq(self__.rest);
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.hash_ordered_coll(this$__$1);
});

cljs.core.LazyTransformer.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
var s = cljs.core._seq(this$__$1);
if(!((s == null))){
return cljs.core.equiv_sequential(this$__$1,other);
} else {
return (cljs.core.sequential_QMARK_(other)) && ((cljs.core.seq(other) == null));
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return self__.first;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
self__.stepper.step(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return this$__$1;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,new_meta){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.LazyTransformer(self__.stepper,self__.first,self__.rest,new_meta));
});

cljs.core.LazyTransformer.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,cljs.core._seq(this$__$1));
});

cljs.core.LazyTransformer.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$stepper,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$first,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$rest,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$meta], null);
});

cljs.core.LazyTransformer.cljs$lang$type = true;

cljs.core.LazyTransformer.cljs$lang$ctorStr = "cljs.core/LazyTransformer";

cljs.core.LazyTransformer.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/LazyTransformer");
});

cljs.core.__GT_LazyTransformer = (function cljs$core$__GT_LazyTransformer(stepper,first,rest,meta){
return (new cljs.core.LazyTransformer(stepper,first,rest,meta));
});

(cljs.core.LazyTransformer.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
cljs.core.LazyTransformer.create = (function (xform,coll){
return (new cljs.core.LazyTransformer(cljs.core.stepper(xform,cljs.core.iter(coll)),null,null,null));
});
cljs.core.LazyTransformer.createMulti = (function (xform,colls){
var iters = [];
var seq__43012_43016 = cljs.core.seq(colls);
var chunk__43013_43017 = null;
var count__43014_43018 = (0);
var i__43015_43019 = (0);
while(true){
if((i__43015_43019 < count__43014_43018)){
var coll_43020 = chunk__43013_43017.cljs$core$IIndexed$_nth$arity$2(null,i__43015_43019);
iters.push(cljs.core.iter(coll_43020));

var G__43021 = seq__43012_43016;
var G__43022 = chunk__43013_43017;
var G__43023 = count__43014_43018;
var G__43024 = (i__43015_43019 + (1));
seq__43012_43016 = G__43021;
chunk__43013_43017 = G__43022;
count__43014_43018 = G__43023;
i__43015_43019 = G__43024;
continue;
} else {
var temp__4657__auto___43025 = cljs.core.seq(seq__43012_43016);
if(temp__4657__auto___43025){
var seq__43012_43026__$1 = temp__4657__auto___43025;
if(cljs.core.chunked_seq_QMARK_(seq__43012_43026__$1)){
var c__7357__auto___43027 = cljs.core.chunk_first(seq__43012_43026__$1);
var G__43028 = cljs.core.chunk_rest(seq__43012_43026__$1);
var G__43029 = c__7357__auto___43027;
var G__43030 = cljs.core.count(c__7357__auto___43027);
var G__43031 = (0);
seq__43012_43016 = G__43028;
chunk__43013_43017 = G__43029;
count__43014_43018 = G__43030;
i__43015_43019 = G__43031;
continue;
} else {
var coll_43032 = cljs.core.first(seq__43012_43026__$1);
iters.push(cljs.core.iter(coll_43032));

var G__43033 = cljs.core.next(seq__43012_43026__$1);
var G__43034 = null;
var G__43035 = (0);
var G__43036 = (0);
seq__43012_43016 = G__43033;
chunk__43013_43017 = G__43034;
count__43014_43018 = G__43035;
i__43015_43019 = G__43036;
continue;
}
} else {
}
}
break;
}

return (new cljs.core.LazyTransformer(cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length))),null,null,null));
});
/**
 * Coerces coll to a (possibly empty) sequence, if it is not already
 *   one. Will not force a lazy seq. (sequence nil) yields (), When a
 *   transducer is supplied, returns a lazy sequence of applications of
 *   the transform to the items in coll(s), i.e. to the set of first
 *   items of each coll, followed by the set of second
 *   items in each coll, until any one of the colls is exhausted.  Any
 *   remaining items in other colls are ignored. The transform should accept
 *   number-of-colls arguments
 */
cljs.core.sequence = (function cljs$core$sequence(var_args){
var args43037 = [];
var len__7651__auto___43043 = arguments.length;
var i__7652__auto___43044 = (0);
while(true){
if((i__7652__auto___43044 < len__7651__auto___43043)){
args43037.push((arguments[i__7652__auto___43044]));

var G__43045 = (i__7652__auto___43044 + (1));
i__7652__auto___43044 = G__43045;
continue;
} else {
}
break;
}

var G__43042 = args43037.length;
switch (G__43042) {
case 1:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args43037.slice((2)),(0),null));
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = (function (coll){
if(cljs.core.seq_QMARK_(coll)){
return coll;
} else {
var or__6543__auto__ = cljs.core.seq(coll);
if(or__6543__auto__){
return or__6543__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = (function (xform,coll){
return cljs.core.LazyTransformer.create(xform,coll);
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = (function (xform,coll,colls){
return cljs.core.LazyTransformer.createMulti(xform,cljs.core.to_array(cljs.core.cons(coll,colls)));
});

cljs.core.sequence.cljs$lang$applyTo = (function (seq43038){
var G__43039 = cljs.core.first(seq43038);
var seq43038__$1 = cljs.core.next(seq43038);
var G__43040 = cljs.core.first(seq43038__$1);
var seq43038__$2 = cljs.core.next(seq43038__$1);
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(G__43039,G__43040,seq43038__$2);
});

cljs.core.sequence.cljs$lang$maxFixedArity = (2);

/**
 * Returns true if (pred x) is logical true for every x in coll, else
 *   false.
 */
cljs.core.every_QMARK_ = (function cljs$core$every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq(coll) == null)){
return true;
} else {
if(cljs.core.truth_((function (){var G__43048 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__43048) : pred.call(null,G__43048));
})())){
var G__43049 = pred;
var G__43050 = cljs.core.next(coll);
pred = G__43049;
coll = G__43050;
continue;
} else {
return false;

}
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for every x in
 *   coll, else true.
 */
cljs.core.not_every_QMARK_ = (function cljs$core$not_every_QMARK_(pred,coll){
return !(cljs.core.every_QMARK_(pred,coll));
});
/**
 * Returns the first logical true value of (pred x) for any x in coll,
 *   else nil.  One common idiom is to use a set as pred, for example
 *   this will return :fred if :fred is in the sequence, otherwise nil:
 *   (some #{:fred} coll)
 */
cljs.core.some = (function cljs$core$some(pred,coll){
while(true){
if(cljs.core.seq(coll)){
var or__6543__auto__ = (function (){var G__43054 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__43054) : pred.call(null,G__43054));
})();
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var G__43055 = pred;
var G__43056 = cljs.core.next(coll);
pred = G__43055;
coll = G__43056;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for any x in coll,
 *   else true.
 */
cljs.core.not_any_QMARK_ = (function cljs$core$not_any_QMARK_(pred,coll){
return cljs.core.not(cljs.core.some(pred,coll));
});
/**
 * Returns true if n is even, throws an exception if n is not an integer
 */
cljs.core.even_QMARK_ = (function cljs$core$even_QMARK_(n){
if(cljs.core.integer_QMARK_(n)){
return ((n & (1)) === (0));
} else {
throw (new Error([cljs.core.str("Argument must be an integer: "),cljs.core.str(n)].join('')));
}
});
/**
 * Returns true if n is odd, throws an exception if n is not an integer
 */
cljs.core.odd_QMARK_ = (function cljs$core$odd_QMARK_(n){
return !(cljs.core.even_QMARK_(n));
});
/**
 * Takes a fn f and returns a fn that takes the same arguments as f,
 *   has the same effects, if any, and returns the opposite truth value.
 */
cljs.core.complement = (function cljs$core$complement(f){
return (function() {
var G__43057 = null;
var G__43057__0 = (function (){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});
var G__43057__1 = (function (x){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)));
});
var G__43057__2 = (function (x,y){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)));
});
var G__43057__3 = (function() { 
var G__43058__delegate = function (x,y,zs){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));
};
var G__43058 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__43059__i = 0, G__43059__a = new Array(arguments.length -  2);
while (G__43059__i < G__43059__a.length) {G__43059__a[G__43059__i] = arguments[G__43059__i + 2]; ++G__43059__i;}
  zs = new cljs.core.IndexedSeq(G__43059__a,0);
} 
return G__43058__delegate.call(this,x,y,zs);};
G__43058.cljs$lang$maxFixedArity = 2;
G__43058.cljs$lang$applyTo = (function (arglist__43060){
var x = cljs.core.first(arglist__43060);
arglist__43060 = cljs.core.next(arglist__43060);
var y = cljs.core.first(arglist__43060);
var zs = cljs.core.rest(arglist__43060);
return G__43058__delegate(x,y,zs);
});
G__43058.cljs$core$IFn$_invoke$arity$variadic = G__43058__delegate;
return G__43058;
})()
;
G__43057 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return G__43057__0.call(this);
case 1:
return G__43057__1.call(this,x);
case 2:
return G__43057__2.call(this,x,y);
default:
var G__43061 = null;
if (arguments.length > 2) {
var G__43062__i = 0, G__43062__a = new Array(arguments.length -  2);
while (G__43062__i < G__43062__a.length) {G__43062__a[G__43062__i] = arguments[G__43062__i + 2]; ++G__43062__i;}
G__43061 = new cljs.core.IndexedSeq(G__43062__a,0);
}
return G__43057__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__43061);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43057.cljs$lang$maxFixedArity = 2;
G__43057.cljs$lang$applyTo = G__43057__3.cljs$lang$applyTo;
G__43057.cljs$core$IFn$_invoke$arity$0 = G__43057__0;
G__43057.cljs$core$IFn$_invoke$arity$1 = G__43057__1;
G__43057.cljs$core$IFn$_invoke$arity$2 = G__43057__2;
G__43057.cljs$core$IFn$_invoke$arity$variadic = G__43057__3.cljs$core$IFn$_invoke$arity$variadic;
return G__43057;
})()
});
/**
 * Returns a function that takes any number of arguments and returns x.
 */
cljs.core.constantly = (function cljs$core$constantly(x){
return (function() { 
var G__43063__delegate = function (args){
return x;
};
var G__43063 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__43064__i = 0, G__43064__a = new Array(arguments.length -  0);
while (G__43064__i < G__43064__a.length) {G__43064__a[G__43064__i] = arguments[G__43064__i + 0]; ++G__43064__i;}
  args = new cljs.core.IndexedSeq(G__43064__a,0);
} 
return G__43063__delegate.call(this,args);};
G__43063.cljs$lang$maxFixedArity = 0;
G__43063.cljs$lang$applyTo = (function (arglist__43065){
var args = cljs.core.seq(arglist__43065);
return G__43063__delegate(args);
});
G__43063.cljs$core$IFn$_invoke$arity$variadic = G__43063__delegate;
return G__43063;
})()
;
});
/**
 * Takes a set of functions and returns a fn that is the composition
 *   of those fns.  The returned fn takes a variable number of args,
 *   applies the rightmost of fns to the args, the next
 *   fn (right-to-left) to the result, etc.
 */
cljs.core.comp = (function cljs$core$comp(var_args){
var args43066 = [];
var len__7651__auto___43088 = arguments.length;
var i__7652__auto___43089 = (0);
while(true){
if((i__7652__auto___43089 < len__7651__auto___43088)){
args43066.push((arguments[i__7652__auto___43089]));

var G__43090 = (i__7652__auto___43089 + (1));
i__7652__auto___43089 = G__43090;
continue;
} else {
}
break;
}

var G__43072 = args43066.length;
switch (G__43072) {
case 0:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args43066.slice((3)),(0),null));
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7670__auto__);

}
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.identity;
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = (function (f,g){
return (function() {
var G__43092 = null;
var G__43092__0 = (function (){
var G__43073 = (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__43073) : f.call(null,G__43073));
});
var G__43092__1 = (function (x){
var G__43074 = (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__43074) : f.call(null,G__43074));
});
var G__43092__2 = (function (x,y){
var G__43075 = (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__43075) : f.call(null,G__43075));
});
var G__43092__3 = (function (x,y,z){
var G__43076 = (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__43076) : f.call(null,G__43076));
});
var G__43092__4 = (function() { 
var G__43093__delegate = function (x,y,z,args){
var G__43077 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__43077) : f.call(null,G__43077));
};
var G__43093 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__43094__i = 0, G__43094__a = new Array(arguments.length -  3);
while (G__43094__i < G__43094__a.length) {G__43094__a[G__43094__i] = arguments[G__43094__i + 3]; ++G__43094__i;}
  args = new cljs.core.IndexedSeq(G__43094__a,0);
} 
return G__43093__delegate.call(this,x,y,z,args);};
G__43093.cljs$lang$maxFixedArity = 3;
G__43093.cljs$lang$applyTo = (function (arglist__43095){
var x = cljs.core.first(arglist__43095);
arglist__43095 = cljs.core.next(arglist__43095);
var y = cljs.core.first(arglist__43095);
arglist__43095 = cljs.core.next(arglist__43095);
var z = cljs.core.first(arglist__43095);
var args = cljs.core.rest(arglist__43095);
return G__43093__delegate(x,y,z,args);
});
G__43093.cljs$core$IFn$_invoke$arity$variadic = G__43093__delegate;
return G__43093;
})()
;
G__43092 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__43092__0.call(this);
case 1:
return G__43092__1.call(this,x);
case 2:
return G__43092__2.call(this,x,y);
case 3:
return G__43092__3.call(this,x,y,z);
default:
var G__43096 = null;
if (arguments.length > 3) {
var G__43097__i = 0, G__43097__a = new Array(arguments.length -  3);
while (G__43097__i < G__43097__a.length) {G__43097__a[G__43097__i] = arguments[G__43097__i + 3]; ++G__43097__i;}
G__43096 = new cljs.core.IndexedSeq(G__43097__a,0);
}
return G__43092__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__43096);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43092.cljs$lang$maxFixedArity = 3;
G__43092.cljs$lang$applyTo = G__43092__4.cljs$lang$applyTo;
G__43092.cljs$core$IFn$_invoke$arity$0 = G__43092__0;
G__43092.cljs$core$IFn$_invoke$arity$1 = G__43092__1;
G__43092.cljs$core$IFn$_invoke$arity$2 = G__43092__2;
G__43092.cljs$core$IFn$_invoke$arity$3 = G__43092__3;
G__43092.cljs$core$IFn$_invoke$arity$variadic = G__43092__4.cljs$core$IFn$_invoke$arity$variadic;
return G__43092;
})()
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = (function (f,g,h){
return (function() {
var G__43098 = null;
var G__43098__0 = (function (){
var G__43078 = (function (){var G__43079 = (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__43079) : g.call(null,G__43079));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__43078) : f.call(null,G__43078));
});
var G__43098__1 = (function (x){
var G__43080 = (function (){var G__43081 = (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null,x));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__43081) : g.call(null,G__43081));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__43080) : f.call(null,G__43080));
});
var G__43098__2 = (function (x,y){
var G__43082 = (function (){var G__43083 = (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x,y) : h.call(null,x,y));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__43083) : g.call(null,G__43083));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__43082) : f.call(null,G__43082));
});
var G__43098__3 = (function (x,y,z){
var G__43084 = (function (){var G__43085 = (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x,y,z) : h.call(null,x,y,z));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__43085) : g.call(null,G__43085));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__43084) : f.call(null,G__43084));
});
var G__43098__4 = (function() { 
var G__43099__delegate = function (x,y,z,args){
var G__43086 = (function (){var G__43087 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__43087) : g.call(null,G__43087));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__43086) : f.call(null,G__43086));
};
var G__43099 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__43100__i = 0, G__43100__a = new Array(arguments.length -  3);
while (G__43100__i < G__43100__a.length) {G__43100__a[G__43100__i] = arguments[G__43100__i + 3]; ++G__43100__i;}
  args = new cljs.core.IndexedSeq(G__43100__a,0);
} 
return G__43099__delegate.call(this,x,y,z,args);};
G__43099.cljs$lang$maxFixedArity = 3;
G__43099.cljs$lang$applyTo = (function (arglist__43101){
var x = cljs.core.first(arglist__43101);
arglist__43101 = cljs.core.next(arglist__43101);
var y = cljs.core.first(arglist__43101);
arglist__43101 = cljs.core.next(arglist__43101);
var z = cljs.core.first(arglist__43101);
var args = cljs.core.rest(arglist__43101);
return G__43099__delegate(x,y,z,args);
});
G__43099.cljs$core$IFn$_invoke$arity$variadic = G__43099__delegate;
return G__43099;
})()
;
G__43098 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__43098__0.call(this);
case 1:
return G__43098__1.call(this,x);
case 2:
return G__43098__2.call(this,x,y);
case 3:
return G__43098__3.call(this,x,y,z);
default:
var G__43102 = null;
if (arguments.length > 3) {
var G__43103__i = 0, G__43103__a = new Array(arguments.length -  3);
while (G__43103__i < G__43103__a.length) {G__43103__a[G__43103__i] = arguments[G__43103__i + 3]; ++G__43103__i;}
G__43102 = new cljs.core.IndexedSeq(G__43103__a,0);
}
return G__43098__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__43102);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43098.cljs$lang$maxFixedArity = 3;
G__43098.cljs$lang$applyTo = G__43098__4.cljs$lang$applyTo;
G__43098.cljs$core$IFn$_invoke$arity$0 = G__43098__0;
G__43098.cljs$core$IFn$_invoke$arity$1 = G__43098__1;
G__43098.cljs$core$IFn$_invoke$arity$2 = G__43098__2;
G__43098.cljs$core$IFn$_invoke$arity$3 = G__43098__3;
G__43098.cljs$core$IFn$_invoke$arity$variadic = G__43098__4.cljs$core$IFn$_invoke$arity$variadic;
return G__43098;
})()
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = (function (f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));
return ((function (fs__$1){
return (function() { 
var G__43104__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);
var fs__$2 = cljs.core.next(fs__$1);
while(true){
if(fs__$2){
var G__43105 = cljs.core.first(fs__$2).call(null,ret);
var G__43106 = cljs.core.next(fs__$2);
ret = G__43105;
fs__$2 = G__43106;
continue;
} else {
return ret;
}
break;
}
};
var G__43104 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__43107__i = 0, G__43107__a = new Array(arguments.length -  0);
while (G__43107__i < G__43107__a.length) {G__43107__a[G__43107__i] = arguments[G__43107__i + 0]; ++G__43107__i;}
  args = new cljs.core.IndexedSeq(G__43107__a,0);
} 
return G__43104__delegate.call(this,args);};
G__43104.cljs$lang$maxFixedArity = 0;
G__43104.cljs$lang$applyTo = (function (arglist__43108){
var args = cljs.core.seq(arglist__43108);
return G__43104__delegate(args);
});
G__43104.cljs$core$IFn$_invoke$arity$variadic = G__43104__delegate;
return G__43104;
})()
;
;})(fs__$1))
});

cljs.core.comp.cljs$lang$applyTo = (function (seq43067){
var G__43068 = cljs.core.first(seq43067);
var seq43067__$1 = cljs.core.next(seq43067);
var G__43069 = cljs.core.first(seq43067__$1);
var seq43067__$2 = cljs.core.next(seq43067__$1);
var G__43070 = cljs.core.first(seq43067__$2);
var seq43067__$3 = cljs.core.next(seq43067__$2);
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(G__43068,G__43069,G__43070,seq43067__$3);
});

cljs.core.comp.cljs$lang$maxFixedArity = (3);

/**
 * Takes a function f and fewer than the normal arguments to f, and
 *   returns a fn that takes a variable number of additional args. When
 *   called, the returned function calls f with args + additional args.
 */
cljs.core.partial = (function cljs$core$partial(var_args){
var args43109 = [];
var len__7651__auto___43117 = arguments.length;
var i__7652__auto___43118 = (0);
while(true){
if((i__7652__auto___43118 < len__7651__auto___43117)){
args43109.push((arguments[i__7652__auto___43118]));

var G__43119 = (i__7652__auto___43118 + (1));
i__7652__auto___43118 = G__43119;
continue;
} else {
}
break;
}

var G__43116 = args43109.length;
switch (G__43116) {
case 1:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args43109.slice((4)),(0),null));
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7670__auto__);

}
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = (function (f,arg1){
return (function() {
var G__43121 = null;
var G__43121__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(arg1) : f.call(null,arg1));
});
var G__43121__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,x) : f.call(null,arg1,x));
});
var G__43121__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,x,y) : f.call(null,arg1,x,y));
});
var G__43121__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,x,y,z) : f.call(null,arg1,x,y,z));
});
var G__43121__4 = (function() { 
var G__43122__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.array_seq([args], 0));
};
var G__43122 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__43123__i = 0, G__43123__a = new Array(arguments.length -  3);
while (G__43123__i < G__43123__a.length) {G__43123__a[G__43123__i] = arguments[G__43123__i + 3]; ++G__43123__i;}
  args = new cljs.core.IndexedSeq(G__43123__a,0);
} 
return G__43122__delegate.call(this,x,y,z,args);};
G__43122.cljs$lang$maxFixedArity = 3;
G__43122.cljs$lang$applyTo = (function (arglist__43124){
var x = cljs.core.first(arglist__43124);
arglist__43124 = cljs.core.next(arglist__43124);
var y = cljs.core.first(arglist__43124);
arglist__43124 = cljs.core.next(arglist__43124);
var z = cljs.core.first(arglist__43124);
var args = cljs.core.rest(arglist__43124);
return G__43122__delegate(x,y,z,args);
});
G__43122.cljs$core$IFn$_invoke$arity$variadic = G__43122__delegate;
return G__43122;
})()
;
G__43121 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__43121__0.call(this);
case 1:
return G__43121__1.call(this,x);
case 2:
return G__43121__2.call(this,x,y);
case 3:
return G__43121__3.call(this,x,y,z);
default:
var G__43125 = null;
if (arguments.length > 3) {
var G__43126__i = 0, G__43126__a = new Array(arguments.length -  3);
while (G__43126__i < G__43126__a.length) {G__43126__a[G__43126__i] = arguments[G__43126__i + 3]; ++G__43126__i;}
G__43125 = new cljs.core.IndexedSeq(G__43126__a,0);
}
return G__43121__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__43125);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43121.cljs$lang$maxFixedArity = 3;
G__43121.cljs$lang$applyTo = G__43121__4.cljs$lang$applyTo;
G__43121.cljs$core$IFn$_invoke$arity$0 = G__43121__0;
G__43121.cljs$core$IFn$_invoke$arity$1 = G__43121__1;
G__43121.cljs$core$IFn$_invoke$arity$2 = G__43121__2;
G__43121.cljs$core$IFn$_invoke$arity$3 = G__43121__3;
G__43121.cljs$core$IFn$_invoke$arity$variadic = G__43121__4.cljs$core$IFn$_invoke$arity$variadic;
return G__43121;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = (function (f,arg1,arg2){
return (function() {
var G__43127 = null;
var G__43127__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,arg2) : f.call(null,arg1,arg2));
});
var G__43127__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,x) : f.call(null,arg1,arg2,x));
});
var G__43127__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,x,y) : f.call(null,arg1,arg2,x,y));
});
var G__43127__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,x,y,z) : f.call(null,arg1,arg2,x,y,z));
});
var G__43127__4 = (function() { 
var G__43128__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.array_seq([z,args], 0));
};
var G__43128 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__43129__i = 0, G__43129__a = new Array(arguments.length -  3);
while (G__43129__i < G__43129__a.length) {G__43129__a[G__43129__i] = arguments[G__43129__i + 3]; ++G__43129__i;}
  args = new cljs.core.IndexedSeq(G__43129__a,0);
} 
return G__43128__delegate.call(this,x,y,z,args);};
G__43128.cljs$lang$maxFixedArity = 3;
G__43128.cljs$lang$applyTo = (function (arglist__43130){
var x = cljs.core.first(arglist__43130);
arglist__43130 = cljs.core.next(arglist__43130);
var y = cljs.core.first(arglist__43130);
arglist__43130 = cljs.core.next(arglist__43130);
var z = cljs.core.first(arglist__43130);
var args = cljs.core.rest(arglist__43130);
return G__43128__delegate(x,y,z,args);
});
G__43128.cljs$core$IFn$_invoke$arity$variadic = G__43128__delegate;
return G__43128;
})()
;
G__43127 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__43127__0.call(this);
case 1:
return G__43127__1.call(this,x);
case 2:
return G__43127__2.call(this,x,y);
case 3:
return G__43127__3.call(this,x,y,z);
default:
var G__43131 = null;
if (arguments.length > 3) {
var G__43132__i = 0, G__43132__a = new Array(arguments.length -  3);
while (G__43132__i < G__43132__a.length) {G__43132__a[G__43132__i] = arguments[G__43132__i + 3]; ++G__43132__i;}
G__43131 = new cljs.core.IndexedSeq(G__43132__a,0);
}
return G__43127__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__43131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43127.cljs$lang$maxFixedArity = 3;
G__43127.cljs$lang$applyTo = G__43127__4.cljs$lang$applyTo;
G__43127.cljs$core$IFn$_invoke$arity$0 = G__43127__0;
G__43127.cljs$core$IFn$_invoke$arity$1 = G__43127__1;
G__43127.cljs$core$IFn$_invoke$arity$2 = G__43127__2;
G__43127.cljs$core$IFn$_invoke$arity$3 = G__43127__3;
G__43127.cljs$core$IFn$_invoke$arity$variadic = G__43127__4.cljs$core$IFn$_invoke$arity$variadic;
return G__43127;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = (function (f,arg1,arg2,arg3){
return (function() {
var G__43133 = null;
var G__43133__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,arg3) : f.call(null,arg1,arg2,arg3));
});
var G__43133__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,arg3,x) : f.call(null,arg1,arg2,arg3,x));
});
var G__43133__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,arg3,x,y) : f.call(null,arg1,arg2,arg3,x,y));
});
var G__43133__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(arg1,arg2,arg3,x,y,z) : f.call(null,arg1,arg2,arg3,x,y,z));
});
var G__43133__4 = (function() { 
var G__43134__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.array_seq([y,z,args], 0));
};
var G__43134 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__43135__i = 0, G__43135__a = new Array(arguments.length -  3);
while (G__43135__i < G__43135__a.length) {G__43135__a[G__43135__i] = arguments[G__43135__i + 3]; ++G__43135__i;}
  args = new cljs.core.IndexedSeq(G__43135__a,0);
} 
return G__43134__delegate.call(this,x,y,z,args);};
G__43134.cljs$lang$maxFixedArity = 3;
G__43134.cljs$lang$applyTo = (function (arglist__43136){
var x = cljs.core.first(arglist__43136);
arglist__43136 = cljs.core.next(arglist__43136);
var y = cljs.core.first(arglist__43136);
arglist__43136 = cljs.core.next(arglist__43136);
var z = cljs.core.first(arglist__43136);
var args = cljs.core.rest(arglist__43136);
return G__43134__delegate(x,y,z,args);
});
G__43134.cljs$core$IFn$_invoke$arity$variadic = G__43134__delegate;
return G__43134;
})()
;
G__43133 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__43133__0.call(this);
case 1:
return G__43133__1.call(this,x);
case 2:
return G__43133__2.call(this,x,y);
case 3:
return G__43133__3.call(this,x,y,z);
default:
var G__43137 = null;
if (arguments.length > 3) {
var G__43138__i = 0, G__43138__a = new Array(arguments.length -  3);
while (G__43138__i < G__43138__a.length) {G__43138__a[G__43138__i] = arguments[G__43138__i + 3]; ++G__43138__i;}
G__43137 = new cljs.core.IndexedSeq(G__43138__a,0);
}
return G__43133__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__43137);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43133.cljs$lang$maxFixedArity = 3;
G__43133.cljs$lang$applyTo = G__43133__4.cljs$lang$applyTo;
G__43133.cljs$core$IFn$_invoke$arity$0 = G__43133__0;
G__43133.cljs$core$IFn$_invoke$arity$1 = G__43133__1;
G__43133.cljs$core$IFn$_invoke$arity$2 = G__43133__2;
G__43133.cljs$core$IFn$_invoke$arity$3 = G__43133__3;
G__43133.cljs$core$IFn$_invoke$arity$variadic = G__43133__4.cljs$core$IFn$_invoke$arity$variadic;
return G__43133;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = (function (f,arg1,arg2,arg3,more){
return (function() { 
var G__43139__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));
};
var G__43139 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__43140__i = 0, G__43140__a = new Array(arguments.length -  0);
while (G__43140__i < G__43140__a.length) {G__43140__a[G__43140__i] = arguments[G__43140__i + 0]; ++G__43140__i;}
  args = new cljs.core.IndexedSeq(G__43140__a,0);
} 
return G__43139__delegate.call(this,args);};
G__43139.cljs$lang$maxFixedArity = 0;
G__43139.cljs$lang$applyTo = (function (arglist__43141){
var args = cljs.core.seq(arglist__43141);
return G__43139__delegate(args);
});
G__43139.cljs$core$IFn$_invoke$arity$variadic = G__43139__delegate;
return G__43139;
})()
;
});

cljs.core.partial.cljs$lang$applyTo = (function (seq43110){
var G__43111 = cljs.core.first(seq43110);
var seq43110__$1 = cljs.core.next(seq43110);
var G__43112 = cljs.core.first(seq43110__$1);
var seq43110__$2 = cljs.core.next(seq43110__$1);
var G__43113 = cljs.core.first(seq43110__$2);
var seq43110__$3 = cljs.core.next(seq43110__$2);
var G__43114 = cljs.core.first(seq43110__$3);
var seq43110__$4 = cljs.core.next(seq43110__$3);
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(G__43111,G__43112,G__43113,G__43114,seq43110__$4);
});

cljs.core.partial.cljs$lang$maxFixedArity = (4);

/**
 * Takes a function f, and returns a function that calls f, replacing
 *   a nil first argument to f with the supplied value x. Higher arity
 *   versions can replace arguments in the second and third
 *   positions (y, z). Note that the function f can take any number of
 *   arguments, not just the one(s) being nil-patched.
 */
cljs.core.fnil = (function cljs$core$fnil(var_args){
var args43142 = [];
var len__7651__auto___43161 = arguments.length;
var i__7652__auto___43162 = (0);
while(true){
if((i__7652__auto___43162 < len__7651__auto___43161)){
args43142.push((arguments[i__7652__auto___43162]));

var G__43163 = (i__7652__auto___43162 + (1));
i__7652__auto___43162 = G__43163;
continue;
} else {
}
break;
}

var G__43144 = args43142.length;
switch (G__43144) {
case 2:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43142.length)].join('')));

}
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = (function (f,x){
return (function() {
var G__43165 = null;
var G__43165__1 = (function (a){
var G__43145 = (((a == null))?x:a);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__43145) : f.call(null,G__43145));
});
var G__43165__2 = (function (a,b){
var G__43146 = (((a == null))?x:a);
var G__43147 = b;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__43146,G__43147) : f.call(null,G__43146,G__43147));
});
var G__43165__3 = (function (a,b,c){
var G__43148 = (((a == null))?x:a);
var G__43149 = b;
var G__43150 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__43148,G__43149,G__43150) : f.call(null,G__43148,G__43149,G__43150));
});
var G__43165__4 = (function() { 
var G__43166__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),b,c,ds);
};
var G__43166 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__43167__i = 0, G__43167__a = new Array(arguments.length -  3);
while (G__43167__i < G__43167__a.length) {G__43167__a[G__43167__i] = arguments[G__43167__i + 3]; ++G__43167__i;}
  ds = new cljs.core.IndexedSeq(G__43167__a,0);
} 
return G__43166__delegate.call(this,a,b,c,ds);};
G__43166.cljs$lang$maxFixedArity = 3;
G__43166.cljs$lang$applyTo = (function (arglist__43168){
var a = cljs.core.first(arglist__43168);
arglist__43168 = cljs.core.next(arglist__43168);
var b = cljs.core.first(arglist__43168);
arglist__43168 = cljs.core.next(arglist__43168);
var c = cljs.core.first(arglist__43168);
var ds = cljs.core.rest(arglist__43168);
return G__43166__delegate(a,b,c,ds);
});
G__43166.cljs$core$IFn$_invoke$arity$variadic = G__43166__delegate;
return G__43166;
})()
;
G__43165 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return G__43165__1.call(this,a);
case 2:
return G__43165__2.call(this,a,b);
case 3:
return G__43165__3.call(this,a,b,c);
default:
var G__43169 = null;
if (arguments.length > 3) {
var G__43170__i = 0, G__43170__a = new Array(arguments.length -  3);
while (G__43170__i < G__43170__a.length) {G__43170__a[G__43170__i] = arguments[G__43170__i + 3]; ++G__43170__i;}
G__43169 = new cljs.core.IndexedSeq(G__43170__a,0);
}
return G__43165__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__43169);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43165.cljs$lang$maxFixedArity = 3;
G__43165.cljs$lang$applyTo = G__43165__4.cljs$lang$applyTo;
G__43165.cljs$core$IFn$_invoke$arity$1 = G__43165__1;
G__43165.cljs$core$IFn$_invoke$arity$2 = G__43165__2;
G__43165.cljs$core$IFn$_invoke$arity$3 = G__43165__3;
G__43165.cljs$core$IFn$_invoke$arity$variadic = G__43165__4.cljs$core$IFn$_invoke$arity$variadic;
return G__43165;
})()
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = (function (f,x,y){
return (function() {
var G__43171 = null;
var G__43171__2 = (function (a,b){
var G__43151 = (((a == null))?x:a);
var G__43152 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__43151,G__43152) : f.call(null,G__43151,G__43152));
});
var G__43171__3 = (function (a,b,c){
var G__43153 = (((a == null))?x:a);
var G__43154 = (((b == null))?y:b);
var G__43155 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__43153,G__43154,G__43155) : f.call(null,G__43153,G__43154,G__43155));
});
var G__43171__4 = (function() { 
var G__43172__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__43172 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__43173__i = 0, G__43173__a = new Array(arguments.length -  3);
while (G__43173__i < G__43173__a.length) {G__43173__a[G__43173__i] = arguments[G__43173__i + 3]; ++G__43173__i;}
  ds = new cljs.core.IndexedSeq(G__43173__a,0);
} 
return G__43172__delegate.call(this,a,b,c,ds);};
G__43172.cljs$lang$maxFixedArity = 3;
G__43172.cljs$lang$applyTo = (function (arglist__43174){
var a = cljs.core.first(arglist__43174);
arglist__43174 = cljs.core.next(arglist__43174);
var b = cljs.core.first(arglist__43174);
arglist__43174 = cljs.core.next(arglist__43174);
var c = cljs.core.first(arglist__43174);
var ds = cljs.core.rest(arglist__43174);
return G__43172__delegate(a,b,c,ds);
});
G__43172.cljs$core$IFn$_invoke$arity$variadic = G__43172__delegate;
return G__43172;
})()
;
G__43171 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__43171__2.call(this,a,b);
case 3:
return G__43171__3.call(this,a,b,c);
default:
var G__43175 = null;
if (arguments.length > 3) {
var G__43176__i = 0, G__43176__a = new Array(arguments.length -  3);
while (G__43176__i < G__43176__a.length) {G__43176__a[G__43176__i] = arguments[G__43176__i + 3]; ++G__43176__i;}
G__43175 = new cljs.core.IndexedSeq(G__43176__a,0);
}
return G__43171__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__43175);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43171.cljs$lang$maxFixedArity = 3;
G__43171.cljs$lang$applyTo = G__43171__4.cljs$lang$applyTo;
G__43171.cljs$core$IFn$_invoke$arity$2 = G__43171__2;
G__43171.cljs$core$IFn$_invoke$arity$3 = G__43171__3;
G__43171.cljs$core$IFn$_invoke$arity$variadic = G__43171__4.cljs$core$IFn$_invoke$arity$variadic;
return G__43171;
})()
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,z){
return (function() {
var G__43177 = null;
var G__43177__2 = (function (a,b){
var G__43156 = (((a == null))?x:a);
var G__43157 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__43156,G__43157) : f.call(null,G__43156,G__43157));
});
var G__43177__3 = (function (a,b,c){
var G__43158 = (((a == null))?x:a);
var G__43159 = (((b == null))?y:b);
var G__43160 = (((c == null))?z:c);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__43158,G__43159,G__43160) : f.call(null,G__43158,G__43159,G__43160));
});
var G__43177__4 = (function() { 
var G__43178__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__43178 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__43179__i = 0, G__43179__a = new Array(arguments.length -  3);
while (G__43179__i < G__43179__a.length) {G__43179__a[G__43179__i] = arguments[G__43179__i + 3]; ++G__43179__i;}
  ds = new cljs.core.IndexedSeq(G__43179__a,0);
} 
return G__43178__delegate.call(this,a,b,c,ds);};
G__43178.cljs$lang$maxFixedArity = 3;
G__43178.cljs$lang$applyTo = (function (arglist__43180){
var a = cljs.core.first(arglist__43180);
arglist__43180 = cljs.core.next(arglist__43180);
var b = cljs.core.first(arglist__43180);
arglist__43180 = cljs.core.next(arglist__43180);
var c = cljs.core.first(arglist__43180);
var ds = cljs.core.rest(arglist__43180);
return G__43178__delegate(a,b,c,ds);
});
G__43178.cljs$core$IFn$_invoke$arity$variadic = G__43178__delegate;
return G__43178;
})()
;
G__43177 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__43177__2.call(this,a,b);
case 3:
return G__43177__3.call(this,a,b,c);
default:
var G__43181 = null;
if (arguments.length > 3) {
var G__43182__i = 0, G__43182__a = new Array(arguments.length -  3);
while (G__43182__i < G__43182__a.length) {G__43182__a[G__43182__i] = arguments[G__43182__i + 3]; ++G__43182__i;}
G__43181 = new cljs.core.IndexedSeq(G__43182__a,0);
}
return G__43177__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__43181);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43177.cljs$lang$maxFixedArity = 3;
G__43177.cljs$lang$applyTo = G__43177__4.cljs$lang$applyTo;
G__43177.cljs$core$IFn$_invoke$arity$2 = G__43177__2;
G__43177.cljs$core$IFn$_invoke$arity$3 = G__43177__3;
G__43177.cljs$core$IFn$_invoke$arity$variadic = G__43177__4.cljs$core$IFn$_invoke$arity$variadic;
return G__43177;
})()
});

cljs.core.fnil.cljs$lang$maxFixedArity = 4;

/**
 * Returns a lazy sequence consisting of the result of applying f to 0
 *   and the first item of coll, followed by applying f to 1 and the second
 *   item in coll, etc, until coll is exhausted. Thus function f should
 *   accept 2 arguments, index and item. Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.map_indexed = (function cljs$core$map_indexed(var_args){
var args43183 = [];
var len__7651__auto___43214 = arguments.length;
var i__7652__auto___43215 = (0);
while(true){
if((i__7652__auto___43215 < len__7651__auto___43214)){
args43183.push((arguments[i__7652__auto___43215]));

var G__43216 = (i__7652__auto___43215 + (1));
i__7652__auto___43215 = G__43216;
continue;
} else {
}
break;
}

var G__43185 = args43183.length;
switch (G__43185) {
case 1:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43183.length)].join('')));

}
});

cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var i = (cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1((-1)) : cljs.core.volatile_BANG_.call(null,(-1)));
return ((function (i){
return (function() {
var G__43218 = null;
var G__43218__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__43218__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__43218__2 = (function (result,input){
var G__43186 = result;
var G__43187 = (function (){var G__43188 = cljs.core._vreset_BANG_(i,(cljs.core._deref(i) + (1)));
var G__43189 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__43188,G__43189) : f.call(null,G__43188,G__43189));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__43186,G__43187) : rf.call(null,G__43186,G__43187));
});
G__43218 = function(result,input){
switch(arguments.length){
case 0:
return G__43218__0.call(this);
case 1:
return G__43218__1.call(this,result);
case 2:
return G__43218__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43218.cljs$core$IFn$_invoke$arity$0 = G__43218__0;
G__43218.cljs$core$IFn$_invoke$arity$1 = G__43218__1;
G__43218.cljs$core$IFn$_invoke$arity$2 = G__43218__2;
return G__43218;
})()
;})(i))
});
});

cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var mapi = (function cljs$core$mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll__$1);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__7461__auto___43219 = size;
var i_43220 = (0);
while(true){
if((i_43220 < n__7461__auto___43219)){
cljs.core.chunk_append(b,(function (){var G__43210 = (idx + i_43220);
var G__43211 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_43220);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__43210,G__43211) : f.call(null,G__43210,G__43211));
})());

var G__43221 = (i_43220 + (1));
i_43220 = G__43221;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$mapi((idx + size),cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__43212 = idx;
var G__43213 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__43212,G__43213) : f.call(null,G__43212,G__43213));
})(),cljs$core$mapi((idx + (1)),cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
return mapi((0),coll);
});

cljs.core.map_indexed.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence of the non-nil results of (f item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a transducer when no collection is provided.
 */
cljs.core.keep = (function cljs$core$keep(var_args){
var args43222 = [];
var len__7651__auto___43227 = arguments.length;
var i__7652__auto___43228 = (0);
while(true){
if((i__7652__auto___43228 < len__7651__auto___43227)){
args43222.push((arguments[i__7652__auto___43228]));

var G__43229 = (i__7652__auto___43228 + (1));
i__7652__auto___43228 = G__43229;
continue;
} else {
}
break;
}

var G__43224 = args43222.length;
switch (G__43224) {
case 1:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43222.length)].join('')));

}
});

cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__43231 = null;
var G__43231__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__43231__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__43231__2 = (function (result,input){
var v = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
G__43231 = function(result,input){
switch(arguments.length){
case 0:
return G__43231__0.call(this);
case 1:
return G__43231__1.call(this,result);
case 2:
return G__43231__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43231.cljs$core$IFn$_invoke$arity$0 = G__43231__0;
G__43231.cljs$core$IFn$_invoke$arity$1 = G__43231__1;
G__43231.cljs$core$IFn$_invoke$arity$2 = G__43231__2;
return G__43231;
})()
});
});

cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__7461__auto___43232 = size;
var i_43233 = (0);
while(true){
if((i_43233 < n__7461__auto___43232)){
var x_43234 = (function (){var G__43225 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_43233);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__43225) : f.call(null,G__43225));
})();
if((x_43234 == null)){
} else {
cljs.core.chunk_append(b,x_43234);
}

var G__43235 = (i_43233 + (1));
i_43233 = G__43235;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__43226 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__43226) : f.call(null,G__43226));
})();
if((x == null)){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});

cljs.core.keep.cljs$lang$maxFixedArity = 2;


/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {cljs.core.IAtom}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition1$ = 16386;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
})
cljs.core.Atom.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
});

cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__43236 = cljs.core.seq(self__.watches);
var chunk__43237 = null;
var count__43238 = (0);
var i__43239 = (0);
while(true){
if((i__43239 < count__43238)){
var vec__43240 = chunk__43237.cljs$core$IIndexed$_nth$arity$2(null,i__43239);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43240,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43240,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));

var G__43246 = seq__43236;
var G__43247 = chunk__43237;
var G__43248 = count__43238;
var G__43249 = (i__43239 + (1));
seq__43236 = G__43246;
chunk__43237 = G__43247;
count__43238 = G__43248;
i__43239 = G__43249;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__43236);
if(temp__4657__auto__){
var seq__43236__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__43236__$1)){
var c__7357__auto__ = cljs.core.chunk_first(seq__43236__$1);
var G__43250 = cljs.core.chunk_rest(seq__43236__$1);
var G__43251 = c__7357__auto__;
var G__43252 = cljs.core.count(c__7357__auto__);
var G__43253 = (0);
seq__43236 = G__43250;
chunk__43237 = G__43251;
count__43238 = G__43252;
i__43239 = G__43253;
continue;
} else {
var vec__43243 = cljs.core.first(seq__43236__$1);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43243,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43243,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));

var G__43254 = cljs.core.next(seq__43236__$1);
var G__43255 = null;
var G__43256 = (0);
var G__43257 = (0);
seq__43236 = G__43254;
chunk__43237 = G__43255;
count__43238 = G__43256;
i__43239 = G__43257;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f);

return this$__$1;
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key);
});

cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return goog.getUid(this$__$1);
});

cljs.core.Atom.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$state,cljs.core.cst$sym$meta,cljs.core.cst$sym$validator,cljs.core.cst$sym$watches], null);
});

cljs.core.Atom.cljs$lang$type = true;

cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";

cljs.core.Atom.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/Atom");
});

cljs.core.__GT_Atom = (function cljs$core$__GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
 * Creates and returns an Atom with an initial value of x and zero or
 *   more options (in any order):
 * 
 *   :meta metadata-map
 * 
 *   :validator validate-fn
 * 
 *   If metadata-map is supplied, it will be come the metadata on the
 *   atom. validate-fn must be nil or a side-effect-free fn of one
 *   argument, which will be passed the intended new state on any state
 *   change. If the new state is unacceptable, the validate-fn should
 *   return false or throw an Error.  If either of these error conditions
 *   occur, then the value of the atom will not change.
 */
cljs.core.atom = (function cljs$core$atom(var_args){
var args43258 = [];
var len__7651__auto___43266 = arguments.length;
var i__7652__auto___43267 = (0);
while(true){
if((i__7652__auto___43267 < len__7651__auto___43266)){
args43258.push((arguments[i__7652__auto___43267]));

var G__43268 = (i__7652__auto___43267 + (1));
i__7652__auto___43267 = G__43268;
continue;
} else {
}
break;
}

var G__43262 = args43258.length;
switch (G__43262) {
case 1:
return cljs.core.atom.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args43258.slice((1)),(0),null));
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7670__auto__);

}
});

cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.Atom(x,null,null,null));
});

cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = (function (x,p__43263){
var map__43264 = p__43263;
var map__43264__$1 = ((((!((map__43264 == null)))?((((map__43264.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43264.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43264):map__43264);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43264__$1,cljs.core.cst$kw$meta);
var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43264__$1,cljs.core.cst$kw$validator);
return (new cljs.core.Atom(x,meta,validator,null));
});

cljs.core.atom.cljs$lang$applyTo = (function (seq43259){
var G__43260 = cljs.core.first(seq43259);
var seq43259__$1 = cljs.core.next(seq43259);
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(G__43260,seq43259__$1);
});

cljs.core.atom.cljs$lang$maxFixedArity = (1);

/**
 * Sets the value of atom to newval without regard for the
 *   current value. Returns new-value.
 */
cljs.core.reset_BANG_ = (function cljs$core$reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null,new_value)))){
} else {
throw (new Error("Validator rejected reference state"));
}
}

var old_value = a.state;
a.state = new_value;

if((a.watches == null)){
} else {
cljs.core._notify_watches(a,old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_(a,new_value);
}
});
/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.  Returns
 *   the value that was swapped in.
 */
cljs.core.swap_BANG_ = (function cljs$core$swap_BANG_(var_args){
var args43270 = [];
var len__7651__auto___43284 = arguments.length;
var i__7652__auto___43285 = (0);
while(true){
if((i__7652__auto___43285 < len__7651__auto___43284)){
args43270.push((arguments[i__7652__auto___43285]));

var G__43286 = (i__7652__auto___43285 + (1));
i__7652__auto___43285 = G__43286;
continue;
} else {
}
break;
}

var G__43277 = args43270.length;
switch (G__43277) {
case 2:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args43270.slice((4)),(0),null));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7670__auto__);

}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__43278 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__43278) : f.call(null,G__43278));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__43279 = a.state;
var G__43280 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__43279,G__43280) : f.call(null,G__43279,G__43280));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__43281 = a.state;
var G__43282 = x;
var G__43283 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__43281,G__43282,G__43283) : f.call(null,G__43281,G__43282,G__43283));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more);
}
});

cljs.core.swap_BANG_.cljs$lang$applyTo = (function (seq43271){
var G__43272 = cljs.core.first(seq43271);
var seq43271__$1 = cljs.core.next(seq43271);
var G__43273 = cljs.core.first(seq43271__$1);
var seq43271__$2 = cljs.core.next(seq43271__$1);
var G__43274 = cljs.core.first(seq43271__$2);
var seq43271__$3 = cljs.core.next(seq43271__$2);
var G__43275 = cljs.core.first(seq43271__$3);
var seq43271__$4 = cljs.core.next(seq43271__$3);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__43272,G__43273,G__43274,G__43275,seq43271__$4);
});

cljs.core.swap_BANG_.cljs$lang$maxFixedArity = (4);

/**
 * Atomically sets the value of atom to newval if and only if the
 *   current value of the atom is equal to oldval. Returns true if
 *   set happened, else false.
 */
cljs.core.compare_and_set_BANG_ = (function cljs$core$compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null),oldval)){
cljs.core.reset_BANG_(a,newval);

return true;
} else {
return false;
}
});
/**
 * Sets the validator-fn for an atom. validator-fn must be nil or a
 *   side-effect-free fn of one argument, which will be passed the intended
 *   new state on any state change. If the new state is unacceptable, the
 *   validator-fn should return false or throw an Error. If the current state
 *   is not acceptable to the new validator, an Error will be thrown and the
 *   validator will not be changed.
 */
cljs.core.set_validator_BANG_ = (function cljs$core$set_validator_BANG_(iref,val){
return iref.validator = val;
});
/**
 * Gets the validator-fn for a var/ref/agent/atom.
 */
cljs.core.get_validator = (function cljs$core$get_validator(iref){
return iref.validator;
});

/**
* @constructor
 * @implements {cljs.core.IVolatile}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Volatile.prototype.cljs$core$IVolatile$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function (_,new_state){
var self__ = this;
var ___$1 = this;
return self__.state = new_state;
});

cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Volatile.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Volatile.cljs$lang$type = true;

cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";

cljs.core.Volatile.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/Volatile");
});

cljs.core.__GT_Volatile = (function cljs$core$__GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
 * Creates and returns a Volatile with an initial value of val.
 */
cljs.core.volatile_BANG_ = (function cljs$core$volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
 * Returns true if x is a volatile.
 */
cljs.core.volatile_QMARK_ = (function cljs$core$volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
 * Sets the value of volatile to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.vreset_BANG_ = (function cljs$core$vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_(vol,newval);
});
/**
 * Returns a lazy sequence of the non-nil results of (f index item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a stateful transducer when no collection is
 *   provided.
 */
cljs.core.keep_indexed = (function cljs$core$keep_indexed(var_args){
var args43288 = [];
var len__7651__auto___43319 = arguments.length;
var i__7652__auto___43320 = (0);
while(true){
if((i__7652__auto___43320 < len__7651__auto___43319)){
args43288.push((arguments[i__7652__auto___43320]));

var G__43321 = (i__7652__auto___43320 + (1));
i__7652__auto___43320 = G__43321;
continue;
} else {
}
break;
}

var G__43290 = args43288.length;
switch (G__43290) {
case 1:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43288.length)].join('')));

}
});

cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__43323 = null;
var G__43323__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__43323__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__43323__2 = (function (result,input){
var i = cljs.core._vreset_BANG_(ia,(cljs.core._deref(ia) + (1)));
var v = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(i,input) : f.call(null,i,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
G__43323 = function(result,input){
switch(arguments.length){
case 0:
return G__43323__0.call(this);
case 1:
return G__43323__1.call(this,result);
case 2:
return G__43323__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43323.cljs$core$IFn$_invoke$arity$0 = G__43323__0;
G__43323.cljs$core$IFn$_invoke$arity$1 = G__43323__1;
G__43323.cljs$core$IFn$_invoke$arity$2 = G__43323__2;
return G__43323;
})()
;})(ia))
});
});

cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var keepi = (function cljs$core$keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll__$1);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__7461__auto___43324 = size;
var i_43325 = (0);
while(true){
if((i_43325 < n__7461__auto___43324)){
var x_43326 = (function (){var G__43315 = (idx + i_43325);
var G__43316 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_43325);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__43315,G__43316) : f.call(null,G__43315,G__43316));
})();
if((x_43326 == null)){
} else {
cljs.core.chunk_append(b,x_43326);
}

var G__43327 = (i_43325 + (1));
i_43325 = G__43327;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$keepi((idx + size),cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__43317 = idx;
var G__43318 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__43317,G__43318) : f.call(null,G__43317,G__43318));
})();
if((x == null)){
return cljs$core$keepi((idx + (1)),cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs$core$keepi((idx + (1)),cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi((0),coll);
});

cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2;

/**
 * Takes a set of predicates and returns a function f that returns true if all of its
 *   composing predicates return a logical true value against all of its arguments, else it returns
 *   false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical false result against the original predicates.
 */
cljs.core.every_pred = (function cljs$core$every_pred(var_args){
var args43334 = [];
var len__7651__auto___43341 = arguments.length;
var i__7652__auto___43342 = (0);
while(true){
if((i__7652__auto___43342 < len__7651__auto___43341)){
args43334.push((arguments[i__7652__auto___43342]));

var G__43343 = (i__7652__auto___43342 + (1));
i__7652__auto___43342 = G__43343;
continue;
} else {
}
break;
}

var G__43340 = args43334.length;
switch (G__43340) {
case 1:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args43334.slice((3)),(0),null));
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7670__auto__);

}
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$ep1 = null;
var cljs$core$ep1__0 = (function (){
return true;
});
var cljs$core$ep1__1 = (function (x){
return cljs.core.boolean$((p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x)));
});
var cljs$core$ep1__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__6531__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__6531__auto__)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
} else {
return and__6531__auto__;
}
})());
});
var cljs$core$ep1__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__6531__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__6531__auto__)){
var and__6531__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(and__6531__auto____$1)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
} else {
return and__6531__auto____$1;
}
} else {
return and__6531__auto__;
}
})());
});
var cljs$core$ep1__4 = (function() { 
var G__43345__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__6531__auto__ = cljs$core$ep1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__6531__auto__)){
return cljs.core.every_QMARK_(p,args);
} else {
return and__6531__auto__;
}
})());
};
var G__43345 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__43346__i = 0, G__43346__a = new Array(arguments.length -  3);
while (G__43346__i < G__43346__a.length) {G__43346__a[G__43346__i] = arguments[G__43346__i + 3]; ++G__43346__i;}
  args = new cljs.core.IndexedSeq(G__43346__a,0);
} 
return G__43345__delegate.call(this,x,y,z,args);};
G__43345.cljs$lang$maxFixedArity = 3;
G__43345.cljs$lang$applyTo = (function (arglist__43347){
var x = cljs.core.first(arglist__43347);
arglist__43347 = cljs.core.next(arglist__43347);
var y = cljs.core.first(arglist__43347);
arglist__43347 = cljs.core.next(arglist__43347);
var z = cljs.core.first(arglist__43347);
var args = cljs.core.rest(arglist__43347);
return G__43345__delegate(x,y,z,args);
});
G__43345.cljs$core$IFn$_invoke$arity$variadic = G__43345__delegate;
return G__43345;
})()
;
cljs$core$ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep1__0.call(this);
case 1:
return cljs$core$ep1__1.call(this,x);
case 2:
return cljs$core$ep1__2.call(this,x,y);
case 3:
return cljs$core$ep1__3.call(this,x,y,z);
default:
var G__43348 = null;
if (arguments.length > 3) {
var G__43349__i = 0, G__43349__a = new Array(arguments.length -  3);
while (G__43349__i < G__43349__a.length) {G__43349__a[G__43349__i] = arguments[G__43349__i + 3]; ++G__43349__i;}
G__43348 = new cljs.core.IndexedSeq(G__43349__a,0);
}
return cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__43348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep1.cljs$lang$maxFixedArity = 3;
cljs$core$ep1.cljs$lang$applyTo = cljs$core$ep1__4.cljs$lang$applyTo;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep1__0;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep1__1;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep1__2;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep1__3;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep1;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$ep2 = null;
var cljs$core$ep2__0 = (function (){
return true;
});
var cljs$core$ep2__1 = (function (x){
return cljs.core.boolean$((function (){var and__6531__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__6531__auto__)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
} else {
return and__6531__auto__;
}
})());
});
var cljs$core$ep2__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__6531__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__6531__auto__)){
var and__6531__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__6531__auto____$1)){
var and__6531__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__6531__auto____$2)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
} else {
return and__6531__auto____$2;
}
} else {
return and__6531__auto____$1;
}
} else {
return and__6531__auto__;
}
})());
});
var cljs$core$ep2__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__6531__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__6531__auto__)){
var and__6531__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__6531__auto____$1)){
var and__6531__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__6531__auto____$2)){
var and__6531__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__6531__auto____$3)){
var and__6531__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__6531__auto____$4)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
} else {
return and__6531__auto____$4;
}
} else {
return and__6531__auto____$3;
}
} else {
return and__6531__auto____$2;
}
} else {
return and__6531__auto____$1;
}
} else {
return and__6531__auto__;
}
})());
});
var cljs$core$ep2__4 = (function() { 
var G__43350__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__6531__auto__ = cljs$core$ep2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__6531__auto__)){
return cljs.core.every_QMARK_(((function (and__6531__auto__){
return (function (p1__43328_SHARP_){
var and__6531__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__43328_SHARP_) : p1.call(null,p1__43328_SHARP_));
if(cljs.core.truth_(and__6531__auto____$1)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__43328_SHARP_) : p2.call(null,p1__43328_SHARP_));
} else {
return and__6531__auto____$1;
}
});})(and__6531__auto__))
,args);
} else {
return and__6531__auto__;
}
})());
};
var G__43350 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__43351__i = 0, G__43351__a = new Array(arguments.length -  3);
while (G__43351__i < G__43351__a.length) {G__43351__a[G__43351__i] = arguments[G__43351__i + 3]; ++G__43351__i;}
  args = new cljs.core.IndexedSeq(G__43351__a,0);
} 
return G__43350__delegate.call(this,x,y,z,args);};
G__43350.cljs$lang$maxFixedArity = 3;
G__43350.cljs$lang$applyTo = (function (arglist__43352){
var x = cljs.core.first(arglist__43352);
arglist__43352 = cljs.core.next(arglist__43352);
var y = cljs.core.first(arglist__43352);
arglist__43352 = cljs.core.next(arglist__43352);
var z = cljs.core.first(arglist__43352);
var args = cljs.core.rest(arglist__43352);
return G__43350__delegate(x,y,z,args);
});
G__43350.cljs$core$IFn$_invoke$arity$variadic = G__43350__delegate;
return G__43350;
})()
;
cljs$core$ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep2__0.call(this);
case 1:
return cljs$core$ep2__1.call(this,x);
case 2:
return cljs$core$ep2__2.call(this,x,y);
case 3:
return cljs$core$ep2__3.call(this,x,y,z);
default:
var G__43353 = null;
if (arguments.length > 3) {
var G__43354__i = 0, G__43354__a = new Array(arguments.length -  3);
while (G__43354__i < G__43354__a.length) {G__43354__a[G__43354__i] = arguments[G__43354__i + 3]; ++G__43354__i;}
G__43353 = new cljs.core.IndexedSeq(G__43354__a,0);
}
return cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__43353);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep2.cljs$lang$maxFixedArity = 3;
cljs$core$ep2.cljs$lang$applyTo = cljs$core$ep2__4.cljs$lang$applyTo;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep2__0;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep2__1;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep2__2;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep2__3;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep2;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$ep3 = null;
var cljs$core$ep3__0 = (function (){
return true;
});
var cljs$core$ep3__1 = (function (x){
return cljs.core.boolean$((function (){var and__6531__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__6531__auto__)){
var and__6531__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__6531__auto____$1)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
} else {
return and__6531__auto____$1;
}
} else {
return and__6531__auto__;
}
})());
});
var cljs$core$ep3__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__6531__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__6531__auto__)){
var and__6531__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__6531__auto____$1)){
var and__6531__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__6531__auto____$2)){
var and__6531__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__6531__auto____$3)){
var and__6531__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__6531__auto____$4)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
} else {
return and__6531__auto____$4;
}
} else {
return and__6531__auto____$3;
}
} else {
return and__6531__auto____$2;
}
} else {
return and__6531__auto____$1;
}
} else {
return and__6531__auto__;
}
})());
});
var cljs$core$ep3__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__6531__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__6531__auto__)){
var and__6531__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__6531__auto____$1)){
var and__6531__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__6531__auto____$2)){
var and__6531__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__6531__auto____$3)){
var and__6531__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__6531__auto____$4)){
var and__6531__auto____$5 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(and__6531__auto____$5)){
var and__6531__auto____$6 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__6531__auto____$6)){
var and__6531__auto____$7 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(and__6531__auto____$7)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
} else {
return and__6531__auto____$7;
}
} else {
return and__6531__auto____$6;
}
} else {
return and__6531__auto____$5;
}
} else {
return and__6531__auto____$4;
}
} else {
return and__6531__auto____$3;
}
} else {
return and__6531__auto____$2;
}
} else {
return and__6531__auto____$1;
}
} else {
return and__6531__auto__;
}
})());
});
var cljs$core$ep3__4 = (function() { 
var G__43355__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__6531__auto__ = cljs$core$ep3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__6531__auto__)){
return cljs.core.every_QMARK_(((function (and__6531__auto__){
return (function (p1__43329_SHARP_){
var and__6531__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__43329_SHARP_) : p1.call(null,p1__43329_SHARP_));
if(cljs.core.truth_(and__6531__auto____$1)){
var and__6531__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__43329_SHARP_) : p2.call(null,p1__43329_SHARP_));
if(cljs.core.truth_(and__6531__auto____$2)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__43329_SHARP_) : p3.call(null,p1__43329_SHARP_));
} else {
return and__6531__auto____$2;
}
} else {
return and__6531__auto____$1;
}
});})(and__6531__auto__))
,args);
} else {
return and__6531__auto__;
}
})());
};
var G__43355 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__43356__i = 0, G__43356__a = new Array(arguments.length -  3);
while (G__43356__i < G__43356__a.length) {G__43356__a[G__43356__i] = arguments[G__43356__i + 3]; ++G__43356__i;}
  args = new cljs.core.IndexedSeq(G__43356__a,0);
} 
return G__43355__delegate.call(this,x,y,z,args);};
G__43355.cljs$lang$maxFixedArity = 3;
G__43355.cljs$lang$applyTo = (function (arglist__43357){
var x = cljs.core.first(arglist__43357);
arglist__43357 = cljs.core.next(arglist__43357);
var y = cljs.core.first(arglist__43357);
arglist__43357 = cljs.core.next(arglist__43357);
var z = cljs.core.first(arglist__43357);
var args = cljs.core.rest(arglist__43357);
return G__43355__delegate(x,y,z,args);
});
G__43355.cljs$core$IFn$_invoke$arity$variadic = G__43355__delegate;
return G__43355;
})()
;
cljs$core$ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep3__0.call(this);
case 1:
return cljs$core$ep3__1.call(this,x);
case 2:
return cljs$core$ep3__2.call(this,x,y);
case 3:
return cljs$core$ep3__3.call(this,x,y,z);
default:
var G__43358 = null;
if (arguments.length > 3) {
var G__43359__i = 0, G__43359__a = new Array(arguments.length -  3);
while (G__43359__i < G__43359__a.length) {G__43359__a[G__43359__i] = arguments[G__43359__i + 3]; ++G__43359__i;}
G__43358 = new cljs.core.IndexedSeq(G__43359__a,0);
}
return cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__43358);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep3.cljs$lang$maxFixedArity = 3;
cljs$core$ep3.cljs$lang$applyTo = cljs$core$ep3__4.cljs$lang$applyTo;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep3__0;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep3__1;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep3__2;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep3__3;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep3;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$epn = null;
var cljs$core$epn__0 = (function (){
return true;
});
var cljs$core$epn__1 = (function (x){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__43330_SHARP_){
return (p1__43330_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__43330_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__43330_SHARP_.call(null,x));
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__2 = (function (x,y){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__43331_SHARP_){
var and__6531__auto__ = (p1__43331_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__43331_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__43331_SHARP_.call(null,x));
if(cljs.core.truth_(and__6531__auto__)){
return (p1__43331_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__43331_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__43331_SHARP_.call(null,y));
} else {
return and__6531__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__43332_SHARP_){
var and__6531__auto__ = (p1__43332_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__43332_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__43332_SHARP_.call(null,x));
if(cljs.core.truth_(and__6531__auto__)){
var and__6531__auto____$1 = (p1__43332_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__43332_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__43332_SHARP_.call(null,y));
if(cljs.core.truth_(and__6531__auto____$1)){
return (p1__43332_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__43332_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__43332_SHARP_.call(null,z));
} else {
return and__6531__auto____$1;
}
} else {
return and__6531__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__4 = (function() { 
var G__43360__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__6531__auto__ = cljs$core$epn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__6531__auto__)){
return cljs.core.every_QMARK_(((function (and__6531__auto__,ps__$1){
return (function (p1__43333_SHARP_){
return cljs.core.every_QMARK_(p1__43333_SHARP_,args);
});})(and__6531__auto__,ps__$1))
,ps__$1);
} else {
return and__6531__auto__;
}
})());
};
var G__43360 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__43361__i = 0, G__43361__a = new Array(arguments.length -  3);
while (G__43361__i < G__43361__a.length) {G__43361__a[G__43361__i] = arguments[G__43361__i + 3]; ++G__43361__i;}
  args = new cljs.core.IndexedSeq(G__43361__a,0);
} 
return G__43360__delegate.call(this,x,y,z,args);};
G__43360.cljs$lang$maxFixedArity = 3;
G__43360.cljs$lang$applyTo = (function (arglist__43362){
var x = cljs.core.first(arglist__43362);
arglist__43362 = cljs.core.next(arglist__43362);
var y = cljs.core.first(arglist__43362);
arglist__43362 = cljs.core.next(arglist__43362);
var z = cljs.core.first(arglist__43362);
var args = cljs.core.rest(arglist__43362);
return G__43360__delegate(x,y,z,args);
});
G__43360.cljs$core$IFn$_invoke$arity$variadic = G__43360__delegate;
return G__43360;
})()
;
cljs$core$epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$epn__0.call(this);
case 1:
return cljs$core$epn__1.call(this,x);
case 2:
return cljs$core$epn__2.call(this,x,y);
case 3:
return cljs$core$epn__3.call(this,x,y,z);
default:
var G__43363 = null;
if (arguments.length > 3) {
var G__43364__i = 0, G__43364__a = new Array(arguments.length -  3);
while (G__43364__i < G__43364__a.length) {G__43364__a[G__43364__i] = arguments[G__43364__i + 3]; ++G__43364__i;}
G__43363 = new cljs.core.IndexedSeq(G__43364__a,0);
}
return cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__43363);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$epn.cljs$lang$maxFixedArity = 3;
cljs$core$epn.cljs$lang$applyTo = cljs$core$epn__4.cljs$lang$applyTo;
cljs$core$epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$epn__0;
cljs$core$epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$epn__1;
cljs$core$epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$epn__2;
cljs$core$epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$epn__3;
cljs$core$epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$epn;
})()
;})(ps__$1))
});

cljs.core.every_pred.cljs$lang$applyTo = (function (seq43335){
var G__43336 = cljs.core.first(seq43335);
var seq43335__$1 = cljs.core.next(seq43335);
var G__43337 = cljs.core.first(seq43335__$1);
var seq43335__$2 = cljs.core.next(seq43335__$1);
var G__43338 = cljs.core.first(seq43335__$2);
var seq43335__$3 = cljs.core.next(seq43335__$2);
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(G__43336,G__43337,G__43338,seq43335__$3);
});

cljs.core.every_pred.cljs$lang$maxFixedArity = (3);

/**
 * Takes a set of predicates and returns a function f that returns the first logical true value
 *   returned by one of its composing predicates against any of its arguments, else it returns
 *   logical false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical true result against the original predicates.
 */
cljs.core.some_fn = (function cljs$core$some_fn(var_args){
var args43371 = [];
var len__7651__auto___43378 = arguments.length;
var i__7652__auto___43379 = (0);
while(true){
if((i__7652__auto___43379 < len__7651__auto___43378)){
args43371.push((arguments[i__7652__auto___43379]));

var G__43380 = (i__7652__auto___43379 + (1));
i__7652__auto___43379 = G__43380;
continue;
} else {
}
break;
}

var G__43377 = args43371.length;
switch (G__43377) {
case 1:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args43371.slice((3)),(0),null));
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7670__auto__);

}
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$sp1 = null;
var cljs$core$sp1__0 = (function (){
return null;
});
var cljs$core$sp1__1 = (function (x){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
});
var cljs$core$sp1__2 = (function (x,y){
var or__6543__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
}
});
var cljs$core$sp1__3 = (function (x,y,z){
var or__6543__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
}
}
});
var cljs$core$sp1__4 = (function() { 
var G__43382__delegate = function (x,y,z,args){
var or__6543__auto__ = cljs$core$sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.some(p,args);
}
};
var G__43382 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__43383__i = 0, G__43383__a = new Array(arguments.length -  3);
while (G__43383__i < G__43383__a.length) {G__43383__a[G__43383__i] = arguments[G__43383__i + 3]; ++G__43383__i;}
  args = new cljs.core.IndexedSeq(G__43383__a,0);
} 
return G__43382__delegate.call(this,x,y,z,args);};
G__43382.cljs$lang$maxFixedArity = 3;
G__43382.cljs$lang$applyTo = (function (arglist__43384){
var x = cljs.core.first(arglist__43384);
arglist__43384 = cljs.core.next(arglist__43384);
var y = cljs.core.first(arglist__43384);
arglist__43384 = cljs.core.next(arglist__43384);
var z = cljs.core.first(arglist__43384);
var args = cljs.core.rest(arglist__43384);
return G__43382__delegate(x,y,z,args);
});
G__43382.cljs$core$IFn$_invoke$arity$variadic = G__43382__delegate;
return G__43382;
})()
;
cljs$core$sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp1__0.call(this);
case 1:
return cljs$core$sp1__1.call(this,x);
case 2:
return cljs$core$sp1__2.call(this,x,y);
case 3:
return cljs$core$sp1__3.call(this,x,y,z);
default:
var G__43385 = null;
if (arguments.length > 3) {
var G__43386__i = 0, G__43386__a = new Array(arguments.length -  3);
while (G__43386__i < G__43386__a.length) {G__43386__a[G__43386__i] = arguments[G__43386__i + 3]; ++G__43386__i;}
G__43385 = new cljs.core.IndexedSeq(G__43386__a,0);
}
return cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__43385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp1.cljs$lang$maxFixedArity = 3;
cljs$core$sp1.cljs$lang$applyTo = cljs$core$sp1__4.cljs$lang$applyTo;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp1__0;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp1__1;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp1__2;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp1__3;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp1;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$sp2 = null;
var cljs$core$sp2__0 = (function (){
return null;
});
var cljs$core$sp2__1 = (function (x){
var or__6543__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
}
});
var cljs$core$sp2__2 = (function (x,y){
var or__6543__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
var or__6543__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__6543__auto____$2)){
return or__6543__auto____$2;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
}
}
}
});
var cljs$core$sp2__3 = (function (x,y,z){
var or__6543__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
var or__6543__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__6543__auto____$2)){
return or__6543__auto____$2;
} else {
var or__6543__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__6543__auto____$3)){
return or__6543__auto____$3;
} else {
var or__6543__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__6543__auto____$4)){
return or__6543__auto____$4;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
}
}
}
}
}
});
var cljs$core$sp2__4 = (function() { 
var G__43387__delegate = function (x,y,z,args){
var or__6543__auto__ = cljs$core$sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.some(((function (or__6543__auto__){
return (function (p1__43365_SHARP_){
var or__6543__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__43365_SHARP_) : p1.call(null,p1__43365_SHARP_));
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__43365_SHARP_) : p2.call(null,p1__43365_SHARP_));
}
});})(or__6543__auto__))
,args);
}
};
var G__43387 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__43388__i = 0, G__43388__a = new Array(arguments.length -  3);
while (G__43388__i < G__43388__a.length) {G__43388__a[G__43388__i] = arguments[G__43388__i + 3]; ++G__43388__i;}
  args = new cljs.core.IndexedSeq(G__43388__a,0);
} 
return G__43387__delegate.call(this,x,y,z,args);};
G__43387.cljs$lang$maxFixedArity = 3;
G__43387.cljs$lang$applyTo = (function (arglist__43389){
var x = cljs.core.first(arglist__43389);
arglist__43389 = cljs.core.next(arglist__43389);
var y = cljs.core.first(arglist__43389);
arglist__43389 = cljs.core.next(arglist__43389);
var z = cljs.core.first(arglist__43389);
var args = cljs.core.rest(arglist__43389);
return G__43387__delegate(x,y,z,args);
});
G__43387.cljs$core$IFn$_invoke$arity$variadic = G__43387__delegate;
return G__43387;
})()
;
cljs$core$sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp2__0.call(this);
case 1:
return cljs$core$sp2__1.call(this,x);
case 2:
return cljs$core$sp2__2.call(this,x,y);
case 3:
return cljs$core$sp2__3.call(this,x,y,z);
default:
var G__43390 = null;
if (arguments.length > 3) {
var G__43391__i = 0, G__43391__a = new Array(arguments.length -  3);
while (G__43391__i < G__43391__a.length) {G__43391__a[G__43391__i] = arguments[G__43391__i + 3]; ++G__43391__i;}
G__43390 = new cljs.core.IndexedSeq(G__43391__a,0);
}
return cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__43390);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp2.cljs$lang$maxFixedArity = 3;
cljs$core$sp2.cljs$lang$applyTo = cljs$core$sp2__4.cljs$lang$applyTo;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp2__0;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp2__1;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp2__2;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp2__3;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp2;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$sp3 = null;
var cljs$core$sp3__0 = (function (){
return null;
});
var cljs$core$sp3__1 = (function (x){
var or__6543__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
}
}
});
var cljs$core$sp3__2 = (function (x,y){
var or__6543__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
var or__6543__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__6543__auto____$2)){
return or__6543__auto____$2;
} else {
var or__6543__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__6543__auto____$3)){
return or__6543__auto____$3;
} else {
var or__6543__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__6543__auto____$4)){
return or__6543__auto____$4;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
}
}
}
}
}
});
var cljs$core$sp3__3 = (function (x,y,z){
var or__6543__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
var or__6543__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__6543__auto____$2)){
return or__6543__auto____$2;
} else {
var or__6543__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__6543__auto____$3)){
return or__6543__auto____$3;
} else {
var or__6543__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__6543__auto____$4)){
return or__6543__auto____$4;
} else {
var or__6543__auto____$5 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(or__6543__auto____$5)){
return or__6543__auto____$5;
} else {
var or__6543__auto____$6 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__6543__auto____$6)){
return or__6543__auto____$6;
} else {
var or__6543__auto____$7 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(or__6543__auto____$7)){
return or__6543__auto____$7;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
}
}
}
}
}
}
}
}
});
var cljs$core$sp3__4 = (function() { 
var G__43392__delegate = function (x,y,z,args){
var or__6543__auto__ = cljs$core$sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.some(((function (or__6543__auto__){
return (function (p1__43366_SHARP_){
var or__6543__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__43366_SHARP_) : p1.call(null,p1__43366_SHARP_));
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
var or__6543__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__43366_SHARP_) : p2.call(null,p1__43366_SHARP_));
if(cljs.core.truth_(or__6543__auto____$2)){
return or__6543__auto____$2;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__43366_SHARP_) : p3.call(null,p1__43366_SHARP_));
}
}
});})(or__6543__auto__))
,args);
}
};
var G__43392 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__43393__i = 0, G__43393__a = new Array(arguments.length -  3);
while (G__43393__i < G__43393__a.length) {G__43393__a[G__43393__i] = arguments[G__43393__i + 3]; ++G__43393__i;}
  args = new cljs.core.IndexedSeq(G__43393__a,0);
} 
return G__43392__delegate.call(this,x,y,z,args);};
G__43392.cljs$lang$maxFixedArity = 3;
G__43392.cljs$lang$applyTo = (function (arglist__43394){
var x = cljs.core.first(arglist__43394);
arglist__43394 = cljs.core.next(arglist__43394);
var y = cljs.core.first(arglist__43394);
arglist__43394 = cljs.core.next(arglist__43394);
var z = cljs.core.first(arglist__43394);
var args = cljs.core.rest(arglist__43394);
return G__43392__delegate(x,y,z,args);
});
G__43392.cljs$core$IFn$_invoke$arity$variadic = G__43392__delegate;
return G__43392;
})()
;
cljs$core$sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp3__0.call(this);
case 1:
return cljs$core$sp3__1.call(this,x);
case 2:
return cljs$core$sp3__2.call(this,x,y);
case 3:
return cljs$core$sp3__3.call(this,x,y,z);
default:
var G__43395 = null;
if (arguments.length > 3) {
var G__43396__i = 0, G__43396__a = new Array(arguments.length -  3);
while (G__43396__i < G__43396__a.length) {G__43396__a[G__43396__i] = arguments[G__43396__i + 3]; ++G__43396__i;}
G__43395 = new cljs.core.IndexedSeq(G__43396__a,0);
}
return cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__43395);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp3.cljs$lang$maxFixedArity = 3;
cljs$core$sp3.cljs$lang$applyTo = cljs$core$sp3__4.cljs$lang$applyTo;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp3__0;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp3__1;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp3__2;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp3__3;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp3;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$spn = null;
var cljs$core$spn__0 = (function (){
return null;
});
var cljs$core$spn__1 = (function (x){
return cljs.core.some(((function (ps__$1){
return (function (p1__43367_SHARP_){
return (p1__43367_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__43367_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__43367_SHARP_.call(null,x));
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__2 = (function (x,y){
return cljs.core.some(((function (ps__$1){
return (function (p1__43368_SHARP_){
var or__6543__auto__ = (p1__43368_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__43368_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__43368_SHARP_.call(null,x));
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return (p1__43368_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__43368_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__43368_SHARP_.call(null,y));
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__3 = (function (x,y,z){
return cljs.core.some(((function (ps__$1){
return (function (p1__43369_SHARP_){
var or__6543__auto__ = (p1__43369_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__43369_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__43369_SHARP_.call(null,x));
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = (p1__43369_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__43369_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__43369_SHARP_.call(null,y));
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
return (p1__43369_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__43369_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__43369_SHARP_.call(null,z));
}
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__4 = (function() { 
var G__43397__delegate = function (x,y,z,args){
var or__6543__auto__ = cljs$core$spn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.some(((function (or__6543__auto__,ps__$1){
return (function (p1__43370_SHARP_){
return cljs.core.some(p1__43370_SHARP_,args);
});})(or__6543__auto__,ps__$1))
,ps__$1);
}
};
var G__43397 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__43398__i = 0, G__43398__a = new Array(arguments.length -  3);
while (G__43398__i < G__43398__a.length) {G__43398__a[G__43398__i] = arguments[G__43398__i + 3]; ++G__43398__i;}
  args = new cljs.core.IndexedSeq(G__43398__a,0);
} 
return G__43397__delegate.call(this,x,y,z,args);};
G__43397.cljs$lang$maxFixedArity = 3;
G__43397.cljs$lang$applyTo = (function (arglist__43399){
var x = cljs.core.first(arglist__43399);
arglist__43399 = cljs.core.next(arglist__43399);
var y = cljs.core.first(arglist__43399);
arglist__43399 = cljs.core.next(arglist__43399);
var z = cljs.core.first(arglist__43399);
var args = cljs.core.rest(arglist__43399);
return G__43397__delegate(x,y,z,args);
});
G__43397.cljs$core$IFn$_invoke$arity$variadic = G__43397__delegate;
return G__43397;
})()
;
cljs$core$spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$spn__0.call(this);
case 1:
return cljs$core$spn__1.call(this,x);
case 2:
return cljs$core$spn__2.call(this,x,y);
case 3:
return cljs$core$spn__3.call(this,x,y,z);
default:
var G__43400 = null;
if (arguments.length > 3) {
var G__43401__i = 0, G__43401__a = new Array(arguments.length -  3);
while (G__43401__i < G__43401__a.length) {G__43401__a[G__43401__i] = arguments[G__43401__i + 3]; ++G__43401__i;}
G__43400 = new cljs.core.IndexedSeq(G__43401__a,0);
}
return cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__43400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$spn.cljs$lang$maxFixedArity = 3;
cljs$core$spn.cljs$lang$applyTo = cljs$core$spn__4.cljs$lang$applyTo;
cljs$core$spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$spn__0;
cljs$core$spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$spn__1;
cljs$core$spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$spn__2;
cljs$core$spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$spn__3;
cljs$core$spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$spn;
})()
;})(ps__$1))
});

cljs.core.some_fn.cljs$lang$applyTo = (function (seq43372){
var G__43373 = cljs.core.first(seq43372);
var seq43372__$1 = cljs.core.next(seq43372);
var G__43374 = cljs.core.first(seq43372__$1);
var seq43372__$2 = cljs.core.next(seq43372__$1);
var G__43375 = cljs.core.first(seq43372__$2);
var seq43372__$3 = cljs.core.next(seq43372__$2);
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(G__43373,G__43374,G__43375,seq43372__$3);
});

cljs.core.some_fn.cljs$lang$maxFixedArity = (3);

/**
 * Returns a lazy sequence consisting of the result of applying f to
 *   the set of first items of each coll, followed by applying f to the
 *   set of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments. Returns a transducer when
 *   no collection is provided.
 */
cljs.core.map = (function cljs$core$map(var_args){
var args43403 = [];
var len__7651__auto___43423 = arguments.length;
var i__7652__auto___43424 = (0);
while(true){
if((i__7652__auto___43424 < len__7651__auto___43423)){
args43403.push((arguments[i__7652__auto___43424]));

var G__43425 = (i__7652__auto___43424 + (1));
i__7652__auto___43424 = G__43425;
continue;
} else {
}
break;
}

var G__43410 = args43403.length;
switch (G__43410) {
case 1:
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.map.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args43403.slice((4)),(0),null));
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7670__auto__);

}
});

cljs.core.map.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__43427 = null;
var G__43427__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__43427__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__43427__2 = (function (result,input){
var G__43411 = result;
var G__43412 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__43411,G__43412) : rf.call(null,G__43411,G__43412));
});
var G__43427__3 = (function() { 
var G__43428__delegate = function (result,input,inputs){
var G__43413 = result;
var G__43414 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__43413,G__43414) : rf.call(null,G__43413,G__43414));
};
var G__43428 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__43429__i = 0, G__43429__a = new Array(arguments.length -  2);
while (G__43429__i < G__43429__a.length) {G__43429__a[G__43429__i] = arguments[G__43429__i + 2]; ++G__43429__i;}
  inputs = new cljs.core.IndexedSeq(G__43429__a,0);
} 
return G__43428__delegate.call(this,result,input,inputs);};
G__43428.cljs$lang$maxFixedArity = 2;
G__43428.cljs$lang$applyTo = (function (arglist__43430){
var result = cljs.core.first(arglist__43430);
arglist__43430 = cljs.core.next(arglist__43430);
var input = cljs.core.first(arglist__43430);
var inputs = cljs.core.rest(arglist__43430);
return G__43428__delegate(result,input,inputs);
});
G__43428.cljs$core$IFn$_invoke$arity$variadic = G__43428__delegate;
return G__43428;
})()
;
G__43427 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return G__43427__0.call(this);
case 1:
return G__43427__1.call(this,result);
case 2:
return G__43427__2.call(this,result,input);
default:
var G__43431 = null;
if (arguments.length > 2) {
var G__43432__i = 0, G__43432__a = new Array(arguments.length -  2);
while (G__43432__i < G__43432__a.length) {G__43432__a[G__43432__i] = arguments[G__43432__i + 2]; ++G__43432__i;}
G__43431 = new cljs.core.IndexedSeq(G__43432__a,0);
}
return G__43427__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__43431);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43427.cljs$lang$maxFixedArity = 2;
G__43427.cljs$lang$applyTo = G__43427__3.cljs$lang$applyTo;
G__43427.cljs$core$IFn$_invoke$arity$0 = G__43427__0;
G__43427.cljs$core$IFn$_invoke$arity$1 = G__43427__1;
G__43427.cljs$core$IFn$_invoke$arity$2 = G__43427__2;
G__43427.cljs$core$IFn$_invoke$arity$variadic = G__43427__3.cljs$core$IFn$_invoke$arity$variadic;
return G__43427;
})()
});
});

cljs.core.map.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__7461__auto___43433 = size;
var i_43434 = (0);
while(true){
if((i_43434 < n__7461__auto___43433)){
cljs.core.chunk_append(b,(function (){var G__43415 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_43434);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__43415) : f.call(null,G__43415));
})());

var G__43435 = (i_43434 + (1));
i_43434 = G__43435;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__43416 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__43416) : f.call(null,G__43416));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons((function (){var G__43417 = cljs.core.first(s1);
var G__43418 = cljs.core.first(s2);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__43417,G__43418) : f.call(null,G__43417,G__43418));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
var s3 = cljs.core.seq(c3);
if((s1) && (s2) && (s3)){
return cljs.core.cons((function (){var G__43419 = cljs.core.first(s1);
var G__43420 = cljs.core.first(s2);
var G__43421 = cljs.core.first(s3);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__43419,G__43420,G__43421) : f.call(null,G__43419,G__43420,G__43421));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
var step = (function cljs$core$step(cs){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs$core$step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (step){
return (function (p1__43402_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,p1__43402_SHARP_);
});})(step))
,step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.array_seq([c2,c1], 0))));
});

cljs.core.map.cljs$lang$applyTo = (function (seq43404){
var G__43405 = cljs.core.first(seq43404);
var seq43404__$1 = cljs.core.next(seq43404);
var G__43406 = cljs.core.first(seq43404__$1);
var seq43404__$2 = cljs.core.next(seq43404__$1);
var G__43407 = cljs.core.first(seq43404__$2);
var seq43404__$3 = cljs.core.next(seq43404__$2);
var G__43408 = cljs.core.first(seq43404__$3);
var seq43404__$4 = cljs.core.next(seq43404__$3);
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(G__43405,G__43406,G__43407,G__43408,seq43404__$4);
});

cljs.core.map.cljs$lang$maxFixedArity = (4);

/**
 * Returns a lazy sequence of the first n items in coll, or all items if
 *   there are fewer than n.  Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.take = (function cljs$core$take(var_args){
var args43436 = [];
var len__7651__auto___43439 = arguments.length;
var i__7652__auto___43440 = (0);
while(true){
if((i__7652__auto___43440 < len__7651__auto___43439)){
args43436.push((arguments[i__7652__auto___43440]));

var G__43441 = (i__7652__auto___43440 + (1));
i__7652__auto___43440 = G__43441;
continue;
} else {
}
break;
}

var G__43438 = args43436.length;
switch (G__43438) {
case 1:
return cljs.core.take.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43436.length)].join('')));

}
});

cljs.core.take.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__43443 = null;
var G__43443__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__43443__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__43443__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
var nn = cljs.core._vreset_BANG_(na,(cljs.core._deref(na) - (1)));
var result__$1 = (((n__$1 > (0)))?(rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input)):result);
if(!((nn > (0)))){
return cljs.core.ensure_reduced(result__$1);
} else {
return result__$1;
}
});
G__43443 = function(result,input){
switch(arguments.length){
case 0:
return G__43443__0.call(this);
case 1:
return G__43443__1.call(this,result);
case 2:
return G__43443__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43443.cljs$core$IFn$_invoke$arity$0 = G__43443__0;
G__43443.cljs$core$IFn$_invoke$arity$1 = G__43443__1;
G__43443.cljs$core$IFn$_invoke$arity$2 = G__43443__2;
return G__43443;
})()
;})(na))
});
});

cljs.core.take.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (new cljs.core.LazySeq(null,(function (){
if((n > (0))){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take.cljs$core$IFn$_invoke$arity$2((n - (1)),cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.take.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence of all but the first n items in coll.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.drop = (function cljs$core$drop(var_args){
var args43444 = [];
var len__7651__auto___43447 = arguments.length;
var i__7652__auto___43448 = (0);
while(true){
if((i__7652__auto___43448 < len__7651__auto___43447)){
args43444.push((arguments[i__7652__auto___43448]));

var G__43449 = (i__7652__auto___43448 + (1));
i__7652__auto___43448 = G__43449;
continue;
} else {
}
break;
}

var G__43446 = args43444.length;
switch (G__43446) {
case 1:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43444.length)].join('')));

}
});

cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__43451 = null;
var G__43451__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__43451__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__43451__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
cljs.core._vreset_BANG_(na,(cljs.core._deref(na) - (1)));

if((n__$1 > (0))){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__43451 = function(result,input){
switch(arguments.length){
case 0:
return G__43451__0.call(this);
case 1:
return G__43451__1.call(this,result);
case 2:
return G__43451__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43451.cljs$core$IFn$_invoke$arity$0 = G__43451__0;
G__43451.cljs$core$IFn$_invoke$arity$1 = G__43451__1;
G__43451.cljs$core$IFn$_invoke$arity$2 = G__43451__2;
return G__43451;
})()
;})(na))
});
});

cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

var step = (function (n__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(((n__$1 > (0))) && (s)){
var G__43452 = (n__$1 - (1));
var G__43453 = cljs.core.rest(s);
n__$1 = G__43452;
coll__$1 = G__43453;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(n,coll);
});})(step))
,null,null));
});

cljs.core.drop.cljs$lang$maxFixedArity = 2;

/**
 * Return a lazy sequence of all but the last n (default 1) items in coll
 */
cljs.core.drop_last = (function cljs$core$drop_last(var_args){
var args43454 = [];
var len__7651__auto___43457 = arguments.length;
var i__7652__auto___43458 = (0);
while(true){
if((i__7652__auto___43458 < len__7651__auto___43457)){
args43454.push((arguments[i__7652__auto___43458]));

var G__43459 = (i__7652__auto___43458 + (1));
i__7652__auto___43458 = G__43459;
continue;
} else {
}
break;
}

var G__43456 = args43454.length;
switch (G__43456) {
case 1:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43454.length)].join('')));

}
});

cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((1),s);
});

cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = (function (n,s){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((function (x,_){
return x;
}),s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
});

cljs.core.drop_last.cljs$lang$maxFixedArity = 2;

/**
 * Returns a seq of the last n items in coll.  Depending on the type
 *   of coll may be no better than linear time.  For vectors, see also subvec.
 */
cljs.core.take_last = (function cljs$core$take_last(n,coll){
var s = cljs.core.seq(coll);
var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));
while(true){
if(lead){
var G__43461 = cljs.core.next(s);
var G__43462 = cljs.core.next(lead);
s = G__43461;
lead = G__43462;
continue;
} else {
return s;
}
break;
}
});
/**
 * Returns a lazy sequence of the items in coll starting from the
 *   first item for which (pred item) returns logical false.  Returns a
 *   stateful transducer when no collection is provided.
 */
cljs.core.drop_while = (function cljs$core$drop_while(var_args){
var args43463 = [];
var len__7651__auto___43468 = arguments.length;
var i__7652__auto___43469 = (0);
while(true){
if((i__7652__auto___43469 < len__7651__auto___43468)){
args43463.push((arguments[i__7652__auto___43469]));

var G__43470 = (i__7652__auto___43469 + (1));
i__7652__auto___43469 = G__43470;
continue;
} else {
}
break;
}

var G__43465 = args43463.length;
switch (G__43465) {
case 1:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43463.length)].join('')));

}
});

cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
var da = cljs.core.volatile_BANG_(true);
return ((function (da){
return (function() {
var G__43472 = null;
var G__43472__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__43472__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__43472__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref(da);
if(cljs.core.truth_((function (){var and__6531__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input));
} else {
return and__6531__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_(da,null);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__43472 = function(result,input){
switch(arguments.length){
case 0:
return G__43472__0.call(this);
case 1:
return G__43472__1.call(this,result);
case 2:
return G__43472__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43472.cljs$core$IFn$_invoke$arity$0 = G__43472__0;
G__43472.cljs$core$IFn$_invoke$arity$1 = G__43472__1;
G__43472.cljs$core$IFn$_invoke$arity$2 = G__43472__2;
return G__43472;
})()
;})(da))
});
});

cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
var step = (function (pred__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(cljs.core.truth_((function (){var and__6531__auto__ = s;
if(and__6531__auto__){
var G__43467 = cljs.core.first(s);
return (pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__43467) : pred__$1.call(null,G__43467));
} else {
return and__6531__auto__;
}
})())){
var G__43473 = pred__$1;
var G__43474 = cljs.core.rest(s);
pred__$1 = G__43473;
coll__$1 = G__43474;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(pred,coll);
});})(step))
,null,null));
});

cljs.core.drop_while.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy (infinite!) sequence of repetitions of the items in coll.
 */
cljs.core.cycle = (function cljs$core$cycle(coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(s,(cljs.core.cycle.cljs$core$IFn$_invoke$arity$1 ? cljs.core.cycle.cljs$core$IFn$_invoke$arity$1(s) : cljs.core.cycle.call(null,s)));
} else {
return null;
}
}),null,null));
});
/**
 * Returns a vector of [(take n coll) (drop n coll)]
 */
cljs.core.split_at = (function cljs$core$split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)], null);
});
/**
 * Returns a lazy (infinite!, or length n if supplied) sequence of xs.
 */
cljs.core.repeat = (function cljs$core$repeat(var_args){
var args43475 = [];
var len__7651__auto___43478 = arguments.length;
var i__7652__auto___43479 = (0);
while(true){
if((i__7652__auto___43479 < len__7651__auto___43478)){
args43475.push((arguments[i__7652__auto___43479]));

var G__43480 = (i__7652__auto___43479 + (1));
i__7652__auto___43479 = G__43480;
continue;
} else {
}
break;
}

var G__43477 = args43475.length;
switch (G__43477) {
case 1:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43475.length)].join('')));

}
});

cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(x,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
}),null,null));
});

cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = (function (n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});

cljs.core.repeat.cljs$lang$maxFixedArity = 2;

/**
 * DEPRECATED: Use 'repeat' instead.
 *   Returns a lazy seq of n xs.
 */
cljs.core.replicate = (function cljs$core$replicate(n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});
/**
 * Takes a function of no args, presumably with side effects, and
 *   returns an infinite (or length n if supplied) lazy sequence of calls
 *   to it
 */
cljs.core.repeatedly = (function cljs$core$repeatedly(var_args){
var args43482 = [];
var len__7651__auto___43485 = arguments.length;
var i__7652__auto___43486 = (0);
while(true){
if((i__7652__auto___43486 < len__7651__auto___43485)){
args43482.push((arguments[i__7652__auto___43486]));

var G__43487 = (i__7652__auto___43486 + (1));
i__7652__auto___43486 = G__43487;
continue;
} else {
}
break;
}

var G__43484 = args43482.length;
switch (G__43484) {
case 1:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43482.length)].join('')));

}
});

cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}),null,null));
});

cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = (function (n,f){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
});

cljs.core.repeatedly.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
 */
cljs.core.iterate = (function cljs$core$iterate(f,x){
return cljs.core.cons(x,(new cljs.core.LazySeq(null,(function (){
var G__43491 = f;
var G__43492 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x));
return (cljs.core.iterate.cljs$core$IFn$_invoke$arity$2 ? cljs.core.iterate.cljs$core$IFn$_invoke$arity$2(G__43491,G__43492) : cljs.core.iterate.call(null,G__43491,G__43492));
}),null,null)));
});
/**
 * Returns a lazy seq of the first item in each coll, then the second etc.
 */
cljs.core.interleave = (function cljs$core$interleave(var_args){
var args43493 = [];
var len__7651__auto___43499 = arguments.length;
var i__7652__auto___43500 = (0);
while(true){
if((i__7652__auto___43500 < len__7651__auto___43499)){
args43493.push((arguments[i__7652__auto___43500]));

var G__43501 = (i__7652__auto___43500 + (1));
i__7652__auto___43500 = G__43501;
continue;
} else {
}
break;
}

var G__43498 = args43493.length;
switch (G__43498) {
case 2:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args43493.slice((2)),(0),null));
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7670__auto__);

}
});

cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
return null;
}
}),null,null));
});

cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = (function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.array_seq([c1], 0)));
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});

cljs.core.interleave.cljs$lang$applyTo = (function (seq43494){
var G__43495 = cljs.core.first(seq43494);
var seq43494__$1 = cljs.core.next(seq43494);
var G__43496 = cljs.core.first(seq43494__$1);
var seq43494__$2 = cljs.core.next(seq43494__$1);
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(G__43495,G__43496,seq43494__$2);
});

cljs.core.interleave.cljs$lang$maxFixedArity = (2);

/**
 * Returns a lazy seq of the elements of coll separated by sep.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.interpose = (function cljs$core$interpose(var_args){
var args43503 = [];
var len__7651__auto___43506 = arguments.length;
var i__7652__auto___43507 = (0);
while(true){
if((i__7652__auto___43507 < len__7651__auto___43506)){
args43503.push((arguments[i__7652__auto___43507]));

var G__43508 = (i__7652__auto___43507 + (1));
i__7652__auto___43507 = G__43508;
continue;
} else {
}
break;
}

var G__43505 = args43503.length;
switch (G__43505) {
case 1:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43503.length)].join('')));

}
});

cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = (function (sep){
return (function (rf){
var started = cljs.core.volatile_BANG_(false);
return ((function (started){
return (function() {
var G__43510 = null;
var G__43510__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__43510__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__43510__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref(started))){
var sepr = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,sep) : rf.call(null,result,sep));
if(cljs.core.reduced_QMARK_(sepr)){
return sepr;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(sepr,input) : rf.call(null,sepr,input));
}
} else {
cljs.core.vreset_BANG_(started,true);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__43510 = function(result,input){
switch(arguments.length){
case 0:
return G__43510__0.call(this);
case 1:
return G__43510__1.call(this,result);
case 2:
return G__43510__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43510.cljs$core$IFn$_invoke$arity$0 = G__43510__0;
G__43510.cljs$core$IFn$_invoke$arity$1 = G__43510__1;
G__43510.cljs$core$IFn$_invoke$arity$2 = G__43510__2;
return G__43510;
})()
;})(started))
});
});

cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = (function (sep,coll){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll));
});

cljs.core.interpose.cljs$lang$maxFixedArity = 2;

/**
 * Take a collection of collections, and return a lazy seq
 *   of items from the inner collection
 */
cljs.core.flatten1 = (function cljs$core$flatten1(colls){
var cat = (function cljs$core$flatten1_$_cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4655__auto__ = cljs.core.seq(coll);
if(temp__4655__auto__){
var coll__$1 = temp__4655__auto__;
return cljs.core.cons(cljs.core.first(coll__$1),cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1),colls__$1));
} else {
if(cljs.core.seq(colls__$1)){
return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(null,colls);
});
/**
 * Returns the result of applying concat to the result of applying map
 *   to f and colls.  Thus function f should return a collection. Returns
 *   a transducer when no collections are provided
 */
cljs.core.mapcat = (function cljs$core$mapcat(var_args){
var args43519 = [];
var len__7651__auto___43524 = arguments.length;
var i__7652__auto___43525 = (0);
while(true){
if((i__7652__auto___43525 < len__7651__auto___43524)){
args43519.push((arguments[i__7652__auto___43525]));

var G__43526 = (i__7652__auto___43525 + (1));
i__7652__auto___43525 = G__43526;
continue;
} else {
}
break;
}

var G__43523 = args43519.length;
switch (G__43523) {
case 1:
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args43519.slice((1)),(0),null));
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7670__auto__);

}
});

cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat);
});

cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = (function (f,colls){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls));
});

cljs.core.mapcat.cljs$lang$applyTo = (function (seq43520){
var G__43521 = cljs.core.first(seq43520);
var seq43520__$1 = cljs.core.next(seq43520);
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(G__43521,seq43520__$1);
});

cljs.core.mapcat.cljs$lang$maxFixedArity = (1);

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns true. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.filter = (function cljs$core$filter(var_args){
var args43528 = [];
var len__7651__auto___43532 = arguments.length;
var i__7652__auto___43533 = (0);
while(true){
if((i__7652__auto___43533 < len__7651__auto___43532)){
args43528.push((arguments[i__7652__auto___43533]));

var G__43534 = (i__7652__auto___43533 + (1));
i__7652__auto___43533 = G__43534;
continue;
} else {
}
break;
}

var G__43530 = args43528.length;
switch (G__43530) {
case 1:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43528.length)].join('')));

}
});

cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
return (function() {
var G__43536 = null;
var G__43536__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__43536__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__43536__2 = (function (result,input){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input)))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return result;
}
});
G__43536 = function(result,input){
switch(arguments.length){
case 0:
return G__43536__0.call(this);
case 1:
return G__43536__1.call(this,result);
case 2:
return G__43536__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43536.cljs$core$IFn$_invoke$arity$0 = G__43536__0;
G__43536.cljs$core$IFn$_invoke$arity$1 = G__43536__1;
G__43536.cljs$core$IFn$_invoke$arity$2 = G__43536__2;
return G__43536;
})()
});
});

cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__7461__auto___43537 = size;
var i_43538 = (0);
while(true){
if((i_43538 < n__7461__auto___43537)){
if(cljs.core.truth_((function (){var G__43531 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_43538);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__43531) : pred.call(null,G__43531));
})())){
cljs.core.chunk_append(b,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_43538));
} else {
}

var G__43539 = (i_43538 + (1));
i_43538 = G__43539;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)));
} else {
var f = cljs.core.first(s);
var r = cljs.core.rest(s);
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(f) : pred.call(null,f)))){
return cljs.core.cons(f,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r));
} else {
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r);
}
}
} else {
return null;
}
}),null,null));
});

cljs.core.filter.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns false. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.remove = (function cljs$core$remove(var_args){
var args43540 = [];
var len__7651__auto___43543 = arguments.length;
var i__7652__auto___43544 = (0);
while(true){
if((i__7652__auto___43544 < len__7651__auto___43543)){
args43540.push((arguments[i__7652__auto___43544]));

var G__43545 = (i__7652__auto___43544 + (1));
i__7652__auto___43544 = G__43545;
continue;
} else {
}
break;
}

var G__43542 = args43540.length;
switch (G__43542) {
case 1:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43540.length)].join('')));

}
});

cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
});

cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll);
});

cljs.core.remove.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
 *   branch? must be a fn of one arg that returns true if passed a node
 *   that can have children (but may not).  children must be a fn of one
 *   arg that returns a sequence of the children. Will only be called on
 *   nodes for which branch? returns true. Root is the root node of the
 *   tree.
 */
cljs.core.tree_seq = (function cljs$core$tree_seq(branch_QMARK_,children,root){
var walk = (function cljs$core$tree_seq_$_walk(node){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(node,(cljs.core.truth_((branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : branch_QMARK_.call(null,node)))?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk,cljs.core.array_seq([(children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(node) : children.call(null,node))], 0)):null));
}),null,null));
});
return walk(root);
});
/**
 * Takes any nested combination of sequential things (lists, vectors,
 *   etc.) and returns their contents as a single, flat sequence.
 *   (flatten nil) returns nil.
 */
cljs.core.flatten = (function cljs$core$flatten(x){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__43547_SHARP_){
return !(cljs.core.sequential_QMARK_(p1__43547_SHARP_));
}),cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
 * Returns a new coll consisting of to-coll with all of the items of
 *   from-coll conjoined. A transducer may be supplied.
 */
cljs.core.into = (function cljs$core$into(var_args){
var args43548 = [];
var len__7651__auto___43553 = arguments.length;
var i__7652__auto___43554 = (0);
while(true){
if((i__7652__auto___43554 < len__7651__auto___43553)){
args43548.push((arguments[i__7652__auto___43554]));

var G__43555 = (i__7652__auto___43554 + (1));
i__7652__auto___43554 = G__43555;
continue;
} else {
}
break;
}

var G__43550 = args43548.length;
switch (G__43550) {
case 0:
return cljs.core.into.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.into.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.into.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43548.length)].join('')));

}
});

cljs.core.into.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.into.cljs$core$IFn$_invoke$arity$1 = (function (to){
return to;
});

cljs.core.into.cljs$core$IFn$_invoke$arity$2 = (function (to,from){
if(!((to == null))){
if(((!((to == null)))?((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$)))?true:false):false)){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,from);
}
});

cljs.core.into.cljs$core$IFn$_invoke$arity$3 = (function (to,xform,from){
if(((!((to == null)))?((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$)))?true:false):false)){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from);
}
});

cljs.core.into.cljs$lang$maxFixedArity = 3;

/**
 * Returns a vector consisting of the result of applying f to the
 *   set of first items of each coll, followed by applying f to the set
 *   of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments.
 */
cljs.core.mapv = (function cljs$core$mapv(var_args){
var args43557 = [];
var len__7651__auto___43565 = arguments.length;
var i__7652__auto___43566 = (0);
while(true){
if((i__7652__auto___43566 < len__7651__auto___43565)){
args43557.push((arguments[i__7652__auto___43566]));

var G__43567 = (i__7652__auto___43566 + (1));
i__7652__auto___43566 = G__43567;
continue;
} else {
}
break;
}

var G__43564 = args43557.length;
switch (G__43564) {
case 2:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args43557.slice((4)),(0),null));
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7670__auto__);

}
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(o) : f.call(null,o)));
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2,c3));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2,c3,cljs.core.array_seq([colls], 0)));
});

cljs.core.mapv.cljs$lang$applyTo = (function (seq43558){
var G__43559 = cljs.core.first(seq43558);
var seq43558__$1 = cljs.core.next(seq43558);
var G__43560 = cljs.core.first(seq43558__$1);
var seq43558__$2 = cljs.core.next(seq43558__$1);
var G__43561 = cljs.core.first(seq43558__$2);
var seq43558__$3 = cljs.core.next(seq43558__$2);
var G__43562 = cljs.core.first(seq43558__$3);
var seq43558__$4 = cljs.core.next(seq43558__$3);
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(G__43559,G__43560,G__43561,G__43562,seq43558__$4);
});

cljs.core.mapv.cljs$lang$maxFixedArity = (4);

/**
 * Returns a vector of the items in coll for which
 *   (pred item) returns true. pred must be free of side-effects.
 */
cljs.core.filterv = (function cljs$core$filterv(pred,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(o) : pred.call(null,o)))){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);
} else {
return v;
}
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
/**
 * Returns a lazy sequence of lists of n items each, at offsets step
 *   apart. If step is not supplied, defaults to n, i.e. the partitions
 *   do not overlap. If a pad collection is supplied, use its elements as
 *   necessary to complete last partition up to n items. In case there are
 *   not enough padding elements, return a partition with less than n items.
 */
cljs.core.partition = (function cljs$core$partition(var_args){
var args43569 = [];
var len__7651__auto___43572 = arguments.length;
var i__7652__auto___43573 = (0);
while(true){
if((i__7652__auto___43573 < len__7651__auto___43572)){
args43569.push((arguments[i__7652__auto___43573]));

var G__43574 = (i__7652__auto___43573 + (1));
i__7652__auto___43573 = G__43574;
continue;
} else {
}
break;
}

var G__43571 = args43569.length;
switch (G__43571) {
case 2:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43569.length)].join('')));

}
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = (function (n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
var x__7380__auto__ = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad));
return cljs.core._conj(cljs.core.List.EMPTY,x__7380__auto__);
}
} else {
return null;
}
}),null,null));
});

cljs.core.partition.cljs$lang$maxFixedArity = 4;

/**
 * Returns the value in a nested associative structure,
 *   where ks is a sequence of keys. Returns nil if the key is not present,
 *   or the not-found value if supplied.
 */
cljs.core.get_in = (function cljs$core$get_in(var_args){
var args43576 = [];
var len__7651__auto___43579 = arguments.length;
var i__7652__auto___43580 = (0);
while(true){
if((i__7652__auto___43580 < len__7651__auto___43579)){
args43576.push((arguments[i__7652__auto___43580]));

var G__43581 = (i__7652__auto___43580 + (1));
i__7652__auto___43580 = G__43581;
continue;
} else {
}
break;
}

var G__43578 = args43576.length;
switch (G__43578) {
case 2:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43576.length)].join('')));

}
});

cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = (function (m,ks){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.get,m,ks);
});

cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = (function (m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if(!((ks__$1 == null))){
var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__43583 = sentinel;
var G__43584 = m__$2;
var G__43585 = cljs.core.next(ks__$1);
sentinel = G__43583;
m__$1 = G__43584;
ks__$1 = G__43585;
continue;
}
} else {
return m__$1;
}
break;
}
});

cljs.core.get_in.cljs$lang$maxFixedArity = 3;

/**
 * Associates a value in a nested associative structure, where ks is a
 *   sequence of keys and v is the new value and returns a new nested structure.
 *   If any levels do not exist, hash-maps will be created.
 */
cljs.core.assoc_in = (function cljs$core$assoc_in(m,p__43586,v){
var vec__43593 = p__43586;
var seq__43594 = cljs.core.seq(vec__43593);
var first__43595 = cljs.core.first(seq__43594);
var seq__43594__$1 = cljs.core.next(seq__43594);
var k = first__43595;
var ks = seq__43594__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__43596 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__43597 = ks;
var G__43598 = v;
return (cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3 ? cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3(G__43596,G__43597,G__43598) : cljs.core.assoc_in.call(null,G__43596,G__43597,G__43598));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
/**
 * 'Updates' a value in a nested associative structure, where ks is a
 *   sequence of keys and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   nested structure.  If any levels do not exist, hash-maps will be
 *   created.
 */
cljs.core.update_in = (function cljs$core$update_in(var_args){
var args43599 = [];
var len__7651__auto___43639 = arguments.length;
var i__7652__auto___43640 = (0);
while(true){
if((i__7652__auto___43640 < len__7651__auto___43639)){
args43599.push((arguments[i__7652__auto___43640]));

var G__43641 = (i__7652__auto___43640 + (1));
i__7652__auto___43640 = G__43641;
continue;
} else {
}
break;
}

var G__43608 = args43599.length;
switch (G__43608) {
case 3:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args43599.slice((6)),(0),null));
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__7670__auto__);

}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = (function (m,p__43609,f){
var vec__43610 = p__43609;
var seq__43611 = cljs.core.seq(vec__43610);
var first__43612 = cljs.core.first(seq__43611);
var seq__43611__$1 = cljs.core.next(seq__43611);
var k = first__43612;
var ks = seq__43611__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__43613 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__43613) : f.call(null,G__43613));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = (function (m,p__43614,f,a){
var vec__43615 = p__43614;
var seq__43616 = cljs.core.seq(vec__43615);
var first__43617 = cljs.core.first(seq__43616);
var seq__43616__$1 = cljs.core.next(seq__43616);
var k = first__43617;
var ks = seq__43616__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__43618 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__43619 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__43618,G__43619) : f.call(null,G__43618,G__43619));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = (function (m,p__43620,f,a,b){
var vec__43621 = p__43620;
var seq__43622 = cljs.core.seq(vec__43621);
var first__43623 = cljs.core.first(seq__43622);
var seq__43622__$1 = cljs.core.next(seq__43622);
var k = first__43623;
var ks = seq__43622__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__43624 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__43625 = a;
var G__43626 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__43624,G__43625,G__43626) : f.call(null,G__43624,G__43625,G__43626));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = (function (m,p__43627,f,a,b,c){
var vec__43628 = p__43627;
var seq__43629 = cljs.core.seq(vec__43628);
var first__43630 = cljs.core.first(seq__43629);
var seq__43629__$1 = cljs.core.next(seq__43629);
var k = first__43630;
var ks = seq__43629__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__43631 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__43632 = a;
var G__43633 = b;
var G__43634 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__43631,G__43632,G__43633,G__43634) : f.call(null,G__43631,G__43632,G__43633,G__43634));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,p__43635,f,a,b,c,args){
var vec__43636 = p__43635;
var seq__43637 = cljs.core.seq(vec__43636);
var first__43638 = cljs.core.first(seq__43637);
var seq__43637__$1 = cljs.core.next(seq__43637);
var k = first__43638;
var ks = seq__43637__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.array_seq([b,c,args], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.array_seq([args], 0)));
}
});

cljs.core.update_in.cljs$lang$applyTo = (function (seq43600){
var G__43601 = cljs.core.first(seq43600);
var seq43600__$1 = cljs.core.next(seq43600);
var G__43602 = cljs.core.first(seq43600__$1);
var seq43600__$2 = cljs.core.next(seq43600__$1);
var G__43603 = cljs.core.first(seq43600__$2);
var seq43600__$3 = cljs.core.next(seq43600__$2);
var G__43604 = cljs.core.first(seq43600__$3);
var seq43600__$4 = cljs.core.next(seq43600__$3);
var G__43605 = cljs.core.first(seq43600__$4);
var seq43600__$5 = cljs.core.next(seq43600__$4);
var G__43606 = cljs.core.first(seq43600__$5);
var seq43600__$6 = cljs.core.next(seq43600__$5);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(G__43601,G__43602,G__43603,G__43604,G__43605,G__43606,seq43600__$6);
});

cljs.core.update_in.cljs$lang$maxFixedArity = (6);

/**
 * 'Updates' a value in an associative structure, where k is a
 *   key and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   structure.  If the key does not exist, nil is passed as the old value.
 */
cljs.core.update = (function cljs$core$update(var_args){
var args43643 = [];
var len__7651__auto___43663 = arguments.length;
var i__7652__auto___43664 = (0);
while(true){
if((i__7652__auto___43664 < len__7651__auto___43663)){
args43643.push((arguments[i__7652__auto___43664]));

var G__43665 = (i__7652__auto___43664 + (1));
i__7652__auto___43664 = G__43665;
continue;
} else {
}
break;
}

var G__43652 = args43643.length;
switch (G__43652) {
case 3:
return cljs.core.update.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args43643.slice((6)),(0),null));
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__7670__auto__);

}
});

cljs.core.update.cljs$core$IFn$_invoke$arity$3 = (function (m,k,f){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__43653 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__43653) : f.call(null,G__43653));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$4 = (function (m,k,f,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__43654 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__43655 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__43654,G__43655) : f.call(null,G__43654,G__43655));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$5 = (function (m,k,f,x,y){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__43656 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__43657 = x;
var G__43658 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__43656,G__43657,G__43658) : f.call(null,G__43656,G__43657,G__43658));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$6 = (function (m,k,f,x,y,z){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__43659 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__43660 = x;
var G__43661 = y;
var G__43662 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__43659,G__43660,G__43661,G__43662) : f.call(null,G__43659,G__43660,G__43661,G__43662));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = (function (m,k,f,x,y,z,more){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.array_seq([more], 0)));
});

cljs.core.update.cljs$lang$applyTo = (function (seq43644){
var G__43645 = cljs.core.first(seq43644);
var seq43644__$1 = cljs.core.next(seq43644);
var G__43646 = cljs.core.first(seq43644__$1);
var seq43644__$2 = cljs.core.next(seq43644__$1);
var G__43647 = cljs.core.first(seq43644__$2);
var seq43644__$3 = cljs.core.next(seq43644__$2);
var G__43648 = cljs.core.first(seq43644__$3);
var seq43644__$4 = cljs.core.next(seq43644__$3);
var G__43649 = cljs.core.first(seq43644__$4);
var seq43644__$5 = cljs.core.next(seq43644__$4);
var G__43650 = cljs.core.first(seq43644__$5);
var seq43644__$6 = cljs.core.next(seq43644__$5);
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(G__43645,G__43646,G__43647,G__43648,G__43649,G__43650,seq43644__$6);
});

cljs.core.update.cljs$lang$maxFixedArity = (6);


/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
})

cljs.core.VectorNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.cst$sym$arr], null);
});

cljs.core.VectorNode.cljs$lang$type = true;

cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";

cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/VectorNode");
});

cljs.core.__GT_VectorNode = (function cljs$core$__GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function cljs$core$pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function cljs$core$pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function cljs$core$pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function cljs$core$pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr)));
});
cljs.core.tail_off = (function cljs$core$tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function cljs$core$new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node(edit);
var _ = cljs.core.pv_aset(r,(0),embed);
var G__43667 = (ll - (5));
var G__43668 = r;
ll = G__43667;
ret = G__43668;
continue;
}
break;
}
});
cljs.core.push_tail = (function cljs$core$push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node(parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset(ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget(parent,subidx);
if(!((child == null))){
var node_to_insert = (function (){var G__43673 = pv;
var G__43674 = (level - (5));
var G__43675 = child;
var G__43676 = tailnode;
return (cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4(G__43673,G__43674,G__43675,G__43676) : cljs.core.push_tail.call(null,G__43673,G__43674,G__43675,G__43676));
})();
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path(null,(level - (5)),tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function cljs$core$vector_index_out_of_bounds(i,cnt){
throw (new Error([cljs.core.str("No item "),cljs.core.str(i),cljs.core.str(" in vector of length "),cljs.core.str(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function cljs$core$first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__43677 = cljs.core.pv_aget(node,(0));
var G__43678 = (level - (5));
node = G__43677;
level = G__43678;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function cljs$core$unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off(pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__43679 = cljs.core.pv_aget(node,((i >>> level) & (31)));
var G__43680 = (level - (5));
node = G__43679;
level = G__43680;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function cljs$core$array_for(pv,i){
if((((0) <= i)) && ((i < pv.cnt))){
return cljs.core.unchecked_array_for(pv,i);
} else {
return cljs.core.vector_index_out_of_bounds(i,pv.cnt);
}
});
cljs.core.do_assoc = (function cljs$core$do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node(node);
if((level === (0))){
cljs.core.pv_aset(ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(function (){var G__43686 = pv;
var G__43687 = (level - (5));
var G__43688 = cljs.core.pv_aget(node,subidx);
var G__43689 = i;
var G__43690 = val;
return (cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5 ? cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5(G__43686,G__43687,G__43688,G__43689,G__43690) : cljs.core.do_assoc.call(null,G__43686,G__43687,G__43688,G__43689,G__43690));
})());

return ret;
}
});
cljs.core.pop_tail = (function cljs$core$pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__43694 = pv;
var G__43695 = (level - (5));
var G__43696 = cljs.core.pv_aget(node,subidx);
return (cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3(G__43694,G__43695,G__43696) : cljs.core.pop_tail.call(null,G__43694,G__43695,G__43696));
})();
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
})
cljs.core.RangedIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
});

cljs.core.RangedIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
self__.arr = cljs.core.unchecked_array_for(self__.v,self__.i);

self__.base = (self__.base + (32));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.RangedIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$base,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$v,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null);
});

cljs.core.RangedIterator.cljs$lang$type = true;

cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";

cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/RangedIterator");
});

cljs.core.__GT_RangedIterator = (function cljs$core$__GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function cljs$core$ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count(v)))?cljs.core.unchecked_array_for(v,i):null),v,start,end));
});







/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167668511;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentVector.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentVector.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentVector.prototype.indexOf = (function() {
var G__43707 = null;
var G__43707__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__43707__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__43707 = function(x,start){
switch(arguments.length){
case 1:
return G__43707__1.call(this,x);
case 2:
return G__43707__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43707.cljs$core$IFn$_invoke$arity$1 = G__43707__1;
G__43707.cljs$core$IFn$_invoke$arity$2 = G__43707__2;
return G__43707;
})()
;

cljs.core.PersistentVector.prototype.lastIndexOf = (function() {
var G__43708 = null;
var G__43708__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__43708__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__43708 = function(x,start){
switch(arguments.length){
case 1:
return G__43708__1.call(this,x);
case 2:
return G__43708__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43708.cljs$core$IFn$_invoke$arity$1 = G__43708__1;
G__43708.cljs$core$IFn$_invoke$arity$2 = G__43708__2;
return G__43708;
})()
;

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__43698 = init__$2;
var G__43699 = (j + i);
var G__43700 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__43698,G__43699,G__43700) : f.call(null,G__43698,G__43699,G__43700));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__43709 = (j + (1));
var G__43710 = init__$3;
j = G__43709;
init__$2 = G__43710;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__43711 = (i + len);
var G__43712 = init__$2;
i = G__43711;
init__$1 = G__43712;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return (cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(coll__$1) <= n)){
var new_tail = cljs.core.aclone(self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return cljs.core._conj(coll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds  [0,"),cljs.core.str(self__.cnt),cljs.core.str("]")].join('')));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator(this$__$1,(0),self__.cnt);
});

cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(0));
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(1));
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(self__.cnt - (1)));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off(coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for(coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail(coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget(new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count(other))){
var me_iter = cljs.core._iterator(coll__$1);
var you_iter = cljs.core._iterator(other);
while(true){
if(cljs.core.truth_(me_iter.hasNext())){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential(coll__$1,other);
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,(cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(self__.root) : cljs.core.tv_editable_root.call(null,self__.root)),(cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(self__.tail) : cljs.core.tv_editable_tail.call(null,self__.tail))));
});

cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(v__$1,f);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__43701 = init__$2;
var G__43702 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__43701,G__43702) : f.call(null,G__43701,G__43702));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__43713 = (j + (1));
var G__43714 = init__$3;
j = G__43713;
init__$2 = G__43714;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__43715 = (i + len);
var G__43716 = init__$2;
i = G__43715;
init__$1 = G__43716;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._assoc_n(coll__$1,k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
});

cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0),null));
} else {
var G__43703 = coll__$1;
var G__43704 = cljs.core.first_array_for_longvec(coll__$1);
var G__43705 = (0);
var G__43706 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__43703,G__43704,G__43705,G__43706) : cljs.core.chunked_seq.call(null,G__43703,G__43704,G__43705,G__43706));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentVector(meta__$1,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off(coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__7461__auto___43717 = len;
var i_43718 = (0);
while(true){
if((i_43718 < n__7461__auto___43717)){
(new_tail[i_43718] = (self__.tail[i_43718]));

var G__43719 = (i_43718 + (1));
i_43718 = G__43719;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node(null);
cljs.core.pv_aset(n_r,(0),self__.root);

cljs.core.pv_aset(n_r,(1),cljs.core.new_path(null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail(coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
});

cljs.core.PersistentVector.prototype.call = (function() {
var G__43720 = null;
var G__43720__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__43720__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__43720 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__43720__2.call(this,self__,k);
case 3:
return G__43720__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43720.cljs$core$IFn$_invoke$arity$2 = G__43720__2;
G__43720.cljs$core$IFn$_invoke$arity$3 = G__43720__3;
return G__43720;
})()
;

cljs.core.PersistentVector.prototype.apply = (function (self__,args43697){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args43697)));
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.PersistentVector.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$cnt,cljs.core.cst$sym$shift,cljs.core.cst$sym$root,cljs.core.cst$sym$tail,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentVector.cljs$lang$type = true;

cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";

cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentVector");
});

cljs.core.__GT_PersistentVector = (function cljs$core$__GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash));
cljs.core.PersistentVector.fromArray = (function (xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone(xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
while(true){
if((i < l)){
var G__43721 = (i + (1));
var G__43722 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,(xs__$1[i]));
i = G__43721;
out = G__43722;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
/**
 * Creates a new vector containing the contents of coll. JavaScript arrays
 *   will be aliased and should not be modified.
 */
cljs.core.vec = (function cljs$core$vec(coll){
if(cljs.core.array_QMARK_(coll)){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll));
}
});
/**
 * Creates a new vector containing the args.
 */
cljs.core.vector = (function cljs$core$vector(var_args){
var args__7658__auto__ = [];
var len__7651__auto___43724 = arguments.length;
var i__7652__auto___43725 = (0);
while(true){
if((i__7652__auto___43725 < len__7651__auto___43724)){
args__7658__auto__.push((arguments[i__7652__auto___43725]));

var G__43726 = (i__7652__auto___43725 + (1));
i__7652__auto___43725 = G__43726;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0)))){
return cljs.core.PersistentVector.fromArray(args.arr,true);
} else {
return cljs.core.vec(args);
}
});

cljs.core.vector.cljs$lang$maxFixedArity = (0);

cljs.core.vector.cljs$lang$applyTo = (function (seq43723){
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43723));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedSeq.prototype.indexOf = (function() {
var G__43749 = null;
var G__43749__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__43749__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__43749 = function(x,start){
switch(arguments.length){
case 1:
return G__43749__1.call(this,x);
case 2:
return G__43749__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43749.cljs$core$IFn$_invoke$arity$1 = G__43749__1;
G__43749.cljs$core$IFn$_invoke$arity$2 = G__43749__2;
return G__43749;
})()
;

cljs.core.ChunkedSeq.prototype.lastIndexOf = (function() {
var G__43750 = null;
var G__43750__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__43750__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__43750 = function(x,start){
switch(arguments.length){
case 1:
return G__43750__1.call(this,x);
case 2:
return G__43750__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43750.cljs$core$IFn$_invoke$arity$1 = G__43750__1;
G__43750.cljs$core$IFn$_invoke$arity$2 = G__43750__2;
return G__43750;
})()
;

cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__43727 = self__.vec;
var G__43728 = self__.node;
var G__43729 = self__.i;
var G__43730 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__43727,G__43728,G__43729,G__43730) : cljs.core.chunked_seq.call(null,G__43727,G__43728,G__43729,G__43730));
})();
if((s == null)){
return null;
} else {
return s;
}
} else {
return cljs.core._chunked_next(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((function (){var G__43731 = self__.vec;
var G__43732 = (self__.i + self__.off);
var G__43733 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__43731,G__43732,G__43733) : cljs.core.subvec.call(null,G__43731,G__43732,G__43733));
})(),f);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((function (){var G__43734 = self__.vec;
var G__43735 = (self__.i + self__.off);
var G__43736 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__43734,G__43735,G__43736) : cljs.core.subvec.call(null,G__43734,G__43735,G__43736));
})(),f,start);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__43737 = self__.vec;
var G__43738 = self__.node;
var G__43739 = self__.i;
var G__43740 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__43737,G__43738,G__43739,G__43740) : cljs.core.chunked_seq.call(null,G__43737,G__43738,G__43739,G__43740));
})();
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return cljs.core._chunked_rest(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__43741 = self__.vec;
var G__43742 = cljs.core.unchecked_array_for(self__.vec,end);
var G__43743 = end;
var G__43744 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__43741,G__43742,G__43743,G__43744) : cljs.core.chunked_seq.call(null,G__43741,G__43742,G__43743,G__43744));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(self__.vec,self__.node,self__.i,self__.off,m) : cljs.core.chunked_seq.call(null,self__.vec,self__.node,self__.i,self__.off,m));
});

cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__43745 = self__.vec;
var G__43746 = cljs.core.unchecked_array_for(self__.vec,end);
var G__43747 = end;
var G__43748 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__43745,G__43746,G__43747,G__43748) : cljs.core.chunked_seq.call(null,G__43745,G__43746,G__43747,G__43748));
} else {
return null;
}
});

cljs.core.ChunkedSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vec,cljs.core.cst$sym$node,cljs.core.cst$sym$i,cljs.core.cst$sym$off,cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ChunkedSeq.cljs$lang$type = true;

cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";

cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ChunkedSeq");
});

cljs.core.__GT_ChunkedSeq = (function cljs$core$__GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

(cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
cljs.core.chunked_seq = (function cljs$core$chunked_seq(var_args){
var args43751 = [];
var len__7651__auto___43754 = arguments.length;
var i__7652__auto___43755 = (0);
while(true){
if((i__7652__auto___43755 < len__7651__auto___43754)){
args43751.push((arguments[i__7652__auto___43755]));

var G__43756 = (i__7652__auto___43755 + (1));
i__7652__auto___43755 = G__43756;
continue;
} else {
}
break;
}

var G__43753 = args43751.length;
switch (G__43753) {
case 3:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43751.length)].join('')));

}
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = (function (vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null));
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = (function (vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = (function (vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
});

cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5;


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Subvec.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Subvec.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Subvec.prototype.indexOf = (function() {
var G__43778 = null;
var G__43778__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__43778__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
G__43778 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__43778__1.call(this,x);
case 2:
return G__43778__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43778.cljs$core$IFn$_invoke$arity$1 = G__43778__1;
G__43778.cljs$core$IFn$_invoke$arity$2 = G__43778__2;
return G__43778;
})()
;

cljs.core.Subvec.prototype.lastIndexOf = (function() {
var G__43779 = null;
var G__43779__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__43779__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
G__43779 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__43779__1.call(this,x);
case 2:
return G__43779__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43779.cljs$core$IFn$_invoke$arity$1 = G__43779__1;
G__43779.cljs$core$IFn$_invoke$arity$2 = G__43779__2;
return G__43779;
})()
;

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var i = self__.start;
var j = (0);
var init__$1 = init;
while(true){
if((i < self__.end)){
var init__$2 = (function (){var G__43759 = init__$1;
var G__43760 = j;
var G__43761 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__43759,G__43760,G__43761) : f.call(null,G__43759,G__43760,G__43761));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__43780 = (i + (1));
var G__43781 = (j + (1));
var G__43782 = init__$2;
i = G__43780;
j = G__43781;
init__$1 = G__43782;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return cljs.core.vector_index_out_of_bounds(n,(self__.end - self__.start));
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.start + n));
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return not_found;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v,(self__.start + n),not_found);
}
});

cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
var G__43762 = self__.meta;
var G__43763 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val);
var G__43764 = self__.start;
var G__43765 = (function (){var x__6874__auto__ = self__.end;
var y__6875__auto__ = (v_pos + (1));
return ((x__6874__auto__ > y__6875__auto__) ? x__6874__auto__ : y__6875__auto__);
})();
var G__43766 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__43762,G__43763,G__43764,G__43765,G__43766) : cljs.core.build_subvec.call(null,G__43762,G__43763,G__43764,G__43765,G__43766));
});

cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
});

cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.end - (1)));
});

cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
var G__43767 = self__.meta;
var G__43768 = self__.v;
var G__43769 = self__.start;
var G__43770 = (self__.end - (1));
var G__43771 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__43767,G__43768,G__43769,G__43770,G__43771) : cljs.core.build_subvec.call(null,G__43767,G__43768,G__43769,G__43770,G__43771));
}
});

cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(!((self__.start === self__.end))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
});

cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start__$1){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,start__$1);
});

cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n(coll__$1,key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
});

cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = ((function (coll__$1){
return (function cljs$core$subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i),(new cljs.core.LazySeq(null,((function (coll__$1){
return (function (){
return cljs$core$subvec_seq((i + (1)));
});})(coll__$1))
,null,null)));
}
});})(coll__$1))
;
return subvec_seq(self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(meta__$1,self__.v,self__.start,self__.end,self__.__hash) : cljs.core.build_subvec.call(null,meta__$1,self__.v,self__.start,self__.end,self__.__hash));
});

cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__43773 = self__.meta;
var G__43774 = cljs.core._assoc_n(self__.v,self__.end,o);
var G__43775 = self__.start;
var G__43776 = (self__.end + (1));
var G__43777 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__43773,G__43774,G__43775,G__43776,G__43777) : cljs.core.build_subvec.call(null,G__43773,G__43774,G__43775,G__43776,G__43777));
});

cljs.core.Subvec.prototype.call = (function() {
var G__43783 = null;
var G__43783__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__43783__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__43783 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__43783__2.call(this,self__,k);
case 3:
return G__43783__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43783.cljs$core$IFn$_invoke$arity$2 = G__43783__2;
G__43783.cljs$core$IFn$_invoke$arity$3 = G__43783__3;
return G__43783;
})()
;

cljs.core.Subvec.prototype.apply = (function (self__,args43758){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args43758)));
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.Subvec.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$v,cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Subvec.cljs$lang$type = true;

cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";

cljs.core.Subvec.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/Subvec");
});

cljs.core.__GT_Subvec = (function cljs$core$__GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

(cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
cljs.core.build_subvec = (function cljs$core$build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__43784 = meta;
var G__43785 = v.v;
var G__43786 = (v.start + start);
var G__43787 = (v.start + end);
var G__43788 = __hash;
meta = G__43784;
v = G__43785;
start = G__43786;
end = G__43787;
__hash = G__43788;
continue;
} else {
var c = cljs.core.count(v);
if(((start < (0))) || ((end < (0))) || ((start > c)) || ((end > c))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
 * Returns a persistent vector of the items in vector from
 *   start (inclusive) to end (exclusive).  If end is not supplied,
 *   defaults to (count vector). This operation is O(1) and very fast, as
 *   the resulting vector shares structure with the original and no
 *   trimming is done.
 */
cljs.core.subvec = (function cljs$core$subvec(var_args){
var args43789 = [];
var len__7651__auto___43792 = arguments.length;
var i__7652__auto___43793 = (0);
while(true){
if((i__7652__auto___43793 < len__7651__auto___43792)){
args43789.push((arguments[i__7652__auto___43793]));

var G__43794 = (i__7652__auto___43793 + (1));
i__7652__auto___43793 = G__43794;
continue;
} else {
}
break;
}

var G__43791 = args43789.length;
switch (G__43791) {
case 2:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43789.length)].join('')));

}
});

cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = (function (v,start){
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v,start,cljs.core.count(v));
});

cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = (function (v,start,end){
return cljs.core.build_subvec(null,v,start,end,null);
});

cljs.core.subvec.cljs$lang$maxFixedArity = 3;

cljs.core.tv_ensure_editable = (function cljs$core$tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone(node.arr)));
}
});
cljs.core.tv_editable_root = (function cljs$core$tv_editable_root(node){
return (new cljs.core.VectorNode({},cljs.core.aclone(node.arr)));
});
cljs.core.tv_editable_tail = (function cljs$core$tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function cljs$core$tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable(tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget(ret,subidx);
if(!((child == null))){
var G__43804 = tv;
var G__43805 = (level - (5));
var G__43806 = child;
var G__43807 = tail_node;
return (cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4(G__43804,G__43805,G__43806,G__43807) : cljs.core.tv_push_tail.call(null,G__43804,G__43805,G__43806,G__43807));
} else {
return cljs.core.new_path(tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function cljs$core$tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__43811 = tv;
var G__43812 = (level - (5));
var G__43813 = cljs.core.pv_aget(node__$1,subidx);
return (cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3(G__43811,G__43812,G__43813) : cljs.core.tv_pop_tail.call(null,G__43811,G__43812,G__43813));
})();
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function cljs$core$unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off(tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__43814 = cljs.core.tv_ensure_editable(root.edit,cljs.core.pv_aget(node,((i >>> level) & (31))));
var G__43815 = (level - (5));
node = G__43814;
level = G__43815;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientVector}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition1$ = 88;
this.cljs$lang$protocol_mask$partition0$ = 275;
})
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off(tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

self__.tail = new_tail;

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path(self__.root.edit,self__.shift,tail_node));

self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array));

self__.shift = new_shift;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail(tcoll__$1,self__.shift,self__.root,tail_node);
self__.root = new_root;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
self__.root.edit = null;

var len = (self__.cnt - cljs.core.tail_off(tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy(self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n_BANG_(tcoll__$1,key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function (tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = ((function (tcoll__$1){
return (function cljs$core$go(level,node){
var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset(node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset(node__$1,subidx,cljs$core$go((level - (5)),cljs.core.pv_aget(node__$1,subidx)));

return node__$1;
}
});})(tcoll__$1))
.call(null,self__.shift,self__.root);
self__.root = new_root;

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return cljs.core._conj_BANG_(tcoll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds for TransientVector of length"),cljs.core.str(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
self__.cnt = (0);

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
self__.cnt = (self__.cnt - (1));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail(tcoll__$1,self__.shift,self__.root);
if(!((nr == null))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit,cljs.core.pv_aget(new_root,(0)));
self__.root = new_root__$1;

self__.shift = (self__.shift - (5));

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
} else {
self__.root = new_root;

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,n);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.call = (function() {
var G__43819 = null;
var G__43819__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__43819__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__43819 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__43819__2.call(this,self__,k);
case 3:
return G__43819__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43819.cljs$core$IFn$_invoke$arity$2 = G__43819__2;
G__43819.cljs$core$IFn$_invoke$arity$3 = G__43819__3;
return G__43819;
})()
;

cljs.core.TransientVector.prototype.apply = (function (self__,args43816){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args43816)));
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.TransientVector.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$cnt,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$shift,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$root,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$tail,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.TransientVector.cljs$lang$type = true;

cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";

cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/TransientVector");
});

cljs.core.__GT_TransientVector = (function cljs$core$__GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueIter = (function (fseq,riter){
this.fseq = fseq;
this.riter = riter;
})
cljs.core.PersistentQueueIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var or__6543__auto__ = (cljs.core.some_QMARK_(self__.fseq)) && (cljs.core.seq(self__.fseq));
if(or__6543__auto__){
return or__6543__auto__;
} else {
var and__6531__auto__ = cljs.core.some_QMARK_(self__.riter);
if(and__6531__auto__){
return self__.riter.hasNext();
} else {
return and__6531__auto__;
}
}
});

cljs.core.PersistentQueueIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if(cljs.core.some_QMARK_(self__.fseq)){
var ret = cljs.core.first(self__.fseq);
self__.fseq = cljs.core.next(self__.fseq);

return ret;
} else {
if((cljs.core.some_QMARK_(self__.riter)) && (self__.riter.hasNext())){
return self__.riter.next();
} else {
throw (new Error("No such element"));

}
}
});

cljs.core.PersistentQueueIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.PersistentQueueIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$fseq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$riter], null);
});

cljs.core.PersistentQueueIter.cljs$lang$type = true;

cljs.core.PersistentQueueIter.cljs$lang$ctorStr = "cljs.core/PersistentQueueIter";

cljs.core.PersistentQueueIter.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentQueueIter");
});

cljs.core.__GT_PersistentQueueIter = (function cljs$core$__GT_PersistentQueueIter(fseq,riter){
return (new cljs.core.PersistentQueueIter(fseq,riter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850572;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.PersistentQueueSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueueSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueueSeq.prototype.indexOf = (function() {
var G__43820 = null;
var G__43820__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__43820__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__43820 = function(x,start){
switch(arguments.length){
case 1:
return G__43820__1.call(this,x);
case 2:
return G__43820__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43820.cljs$core$IFn$_invoke$arity$1 = G__43820__1;
G__43820.cljs$core$IFn$_invoke$arity$2 = G__43820__2;
return G__43820;
})()
;

cljs.core.PersistentQueueSeq.prototype.lastIndexOf = (function() {
var G__43821 = null;
var G__43821__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__43821__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__43821 = function(x,start){
switch(arguments.length){
case 1:
return G__43821__1.call(this,x);
case 2:
return G__43821__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43821.cljs$core$IFn$_invoke$arity$1 = G__43821__1;
G__43821.cljs$core$IFn$_invoke$arity$2 = G__43821__2;
return G__43821;
})()
;

cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__4655__auto__ = cljs.core.next(self__.front);
if(temp__4655__auto__){
var f1 = temp__4655__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return cljs.core._empty(coll__$1);
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueSeq(meta__$1,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentQueueSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$front,cljs.core.cst$sym$rear,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentQueueSeq.cljs$lang$type = true;

cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";

cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentQueueSeq");
});

cljs.core.__GT_PersistentQueueSeq = (function cljs$core$__GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

(cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentQueue.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueue.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueue.prototype.indexOf = (function() {
var G__43822 = null;
var G__43822__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__43822__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__43822 = function(x,start){
switch(arguments.length){
case 1:
return G__43822__1.call(this,x);
case 2:
return G__43822__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43822.cljs$core$IFn$_invoke$arity$1 = G__43822__1;
G__43822.cljs$core$IFn$_invoke$arity$2 = G__43822__2;
return G__43822;
})()
;

cljs.core.PersistentQueue.prototype.lastIndexOf = (function() {
var G__43823 = null;
var G__43823__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(self__.count.cljs$core$IFn$_invoke$arity$1 ? self__.count.cljs$core$IFn$_invoke$arity$1(coll) : self__.count.call(null,coll)));
});
var G__43823__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__43823 = function(x,start){
switch(arguments.length){
case 1:
return G__43823__1.call(this,x);
case 2:
return G__43823__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43823.cljs$core$IFn$_invoke$arity$1 = G__43823__1;
G__43823.cljs$core$IFn$_invoke$arity$2 = G__43823__2;
return G__43823;
})()
;

cljs.core.PersistentQueue.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueIter(self__.front,cljs.core._iterator(self__.rear)));
});

cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__4655__auto__ = cljs.core.next(self__.front);
if(temp__4655__auto__){
var f1 = temp__4655__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq(self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentQueue.EMPTY,self__.meta);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest(cljs.core.seq(coll__$1));
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq(self__.rear);
if(cljs.core.truth_((function (){var or__6543__auto__ = self__.front;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq(rear__$1),null));
} else {
return null;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(meta__$1,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__6543__auto__ = self__.rear;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
});

cljs.core.PersistentQueue.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$count,cljs.core.cst$sym$front,cljs.core.cst$sym$rear,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentQueue.cljs$lang$type = true;

cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";

cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentQueue");
});

cljs.core.__GT_PersistentQueue = (function cljs$core$__GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash));
(cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition0$ = 2097152;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.NeverEquiv.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return false;
});

cljs.core.NeverEquiv.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.NeverEquiv.cljs$lang$type = true;

cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";

cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/NeverEquiv");
});

cljs.core.__GT_NeverEquiv = (function cljs$core$__GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
 * Assumes y is a map. Returns true if x equals y, otherwise returns
 *   false.
 */
cljs.core.equiv_map = (function cljs$core$equiv_map(x,y){
return cljs.core.boolean$(((cljs.core.map_QMARK_(y))?(((cljs.core.count(x) === cljs.core.count(y)))?cljs.core.every_QMARK_((function (xkv){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,cljs.core.first(xkv),cljs.core.never_equiv),cljs.core.second(xkv));
}),x):null):null));
});
cljs.core.scan_array = (function cljs$core$scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__43824 = (i + incr);
i = G__43824;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function cljs$core$obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash(a);
var b__$1 = cljs.core.hash(b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function cljs$core$obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta(m);
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__43825 = (i + (1));
var G__43826 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k__$1,(so[k__$1]));
i = G__43825;
out = G__43826;
continue;
} else {
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function cljs$core$obj_clone(obj,ks){
var new_obj = {};
var l = ks.length;
var i_43831 = (0);
while(true){
if((i_43831 < l)){
var k_43832 = (ks[i_43831]);
(new_obj[k_43832] = (obj[k_43832]));

var G__43833 = (i_43831 + (1));
i_43831 = G__43833;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
})
cljs.core.ObjMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ObjMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((goog.isString(k)) && (!((cljs.core.scan_array((1),k,self__.keys) == null)))){
return (self__.strobj[k]);
} else {
return not_found;
}
});

cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq(keys__$1)){
var k = cljs.core.first(keys__$1);
var init__$2 = (function (){var G__43836 = init__$1;
var G__43837 = k;
var G__43838 = (self__.strobj[k]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__43836,G__43837,G__43838) : f.call(null,G__43836,G__43837,G__43838));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__43839 = cljs.core.rest(keys__$1);
var G__43840 = init__$2;
keys__$1 = G__43839;
init__$1 = G__43840;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
});

cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1));
});

cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.ObjMap.EMPTY,self__.meta);
});

cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((goog.isString(k)) && (!((cljs.core.scan_array((1),k,self__.keys) == null)))){
var new_keys = cljs.core.aclone(self__.keys);
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array((1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(goog.isString(k)){
if(((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD))){
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
} else {
if(!((cljs.core.scan_array((1),k,self__.keys) == null))){
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
(new_strobj[k] = v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
var new_keys = cljs.core.aclone(self__.keys);
(new_strobj[k] = v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((goog.isString(k)) && (!((cljs.core.scan_array((1),k,self__.keys) == null)))){
return true;
} else {
return false;
}
});

cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (coll__$1){
return (function (p1__43834_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__43834_SHARP_,(self__.strobj[p1__43834_SHARP_])],null));
});})(coll__$1))
,self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
});

cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ObjMap(meta__$1,self__.keys,self__.strobj,self__.update_count,self__.__hash));
});

cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,coll__$1,entry);
}
});

cljs.core.ObjMap.prototype.call = (function() {
var G__43841 = null;
var G__43841__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__43841__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__43841 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__43841__2.call(this,self__,k);
case 3:
return G__43841__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43841.cljs$core$IFn$_invoke$arity$2 = G__43841__2;
G__43841.cljs$core$IFn$_invoke$arity$3 = G__43841__3;
return G__43841;
})()
;

cljs.core.ObjMap.prototype.apply = (function (self__,args43835){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args43835)));
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.ObjMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$keys,cljs.core.cst$sym$strobj,cljs.core.cst$sym$update_DASH_count,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ObjMap.cljs$lang$type = true;

cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";

cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ObjMap");
});

cljs.core.__GT_ObjMap = (function cljs$core$__GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],{},(0),cljs.core.empty_unordered_hash));
cljs.core.ObjMap.HASHMAP_THRESHOLD = (8);
cljs.core.ObjMap.fromObject = (function (ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
});

/**
* @constructor
*/
cljs.core.RecordIter = (function (i,record,base_count,fields,ext_map_iter){
this.i = i;
this.record = record;
this.base_count = base_count;
this.fields = fields;
this.ext_map_iter = ext_map_iter;
})
cljs.core.RecordIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var or__6543__auto__ = (self__.i < self__.base_count);
if(or__6543__auto__){
return or__6543__auto__;
} else {
return self__.ext_map_iter.hasNext();
}
});

cljs.core.RecordIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if((self__.i < self__.base_count)){
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.fields,self__.i);
self__.i = (self__.i + (1));

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.record,k)], null);
} else {
return self__.ext_map_iter.next();
}
});

cljs.core.RecordIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.RecordIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$record,cljs.core.cst$sym$base_DASH_count,cljs.core.cst$sym$fields,cljs.core.cst$sym$ext_DASH_map_DASH_iter], null);
});

cljs.core.RecordIter.cljs$lang$type = true;

cljs.core.RecordIter.cljs$lang$ctorStr = "cljs.core/RecordIter";

cljs.core.RecordIter.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/RecordIter");
});

cljs.core.__GT_RecordIter = (function cljs$core$__GT_RecordIter(i,record,base_count,fields,ext_map_iter){
return (new cljs.core.RecordIter(i,record,base_count,fields,ext_map_iter));
});


/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6EntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var vec__43844 = cljs.core.first(self__.s);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43844,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43844,(1),null);
self__.s = cljs.core.next(self__.s);

return ({"value": [k,v], "done": false});
} else {
return ({"value": null, "done": true});
}
});

cljs.core.ES6EntriesIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ES6EntriesIterator.cljs$lang$type = true;

cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";

cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ES6EntriesIterator");
});

cljs.core.__GT_ES6EntriesIterator = (function cljs$core$__GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function cljs$core$es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6SetEntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return ({"value": [x,x], "done": false});
} else {
return ({"value": null, "done": true});
}
});

cljs.core.ES6SetEntriesIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ES6SetEntriesIterator");
});

cljs.core.__GT_ES6SetEntriesIterator = (function cljs$core$__GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function cljs$core$es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll)));
});
cljs.core.array_index_of_nil_QMARK_ = (function cljs$core$array_index_of_nil_QMARK_(arr){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__43847 = (i + (2));
i = G__43847;
continue;

}
}
break;
}
});
cljs.core.array_index_of_keyword_QMARK_ = (function cljs$core$array_index_of_keyword_QMARK_(arr,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((((arr[i]) instanceof cljs.core.Keyword)) && ((kstr === (arr[i]).fqn))){
return i;
} else {
var G__43848 = (i + (2));
i = G__43848;
continue;

}
}
break;
}
});
cljs.core.array_index_of_symbol_QMARK_ = (function cljs$core$array_index_of_symbol_QMARK_(arr,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((((arr[i]) instanceof cljs.core.Symbol)) && ((kstr === (arr[i]).str))){
return i;
} else {
var G__43849 = (i + (2));
i = G__43849;
continue;

}
}
break;
}
});
cljs.core.array_index_of_identical_QMARK_ = (function cljs$core$array_index_of_identical_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__43850 = (i + (2));
i = G__43850;
continue;

}
}
break;
}
});
cljs.core.array_index_of_equiv_QMARK_ = (function cljs$core$array_index_of_equiv_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(arr[i]))){
return i;
} else {
var G__43851 = (i + (2));
i = G__43851;
continue;

}
}
break;
}
});
cljs.core.array_index_of = (function cljs$core$array_index_of(arr,k){
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_index_of_keyword_QMARK_(arr,k);
} else {
if((goog.isString(k)) || (typeof k === 'number')){
return cljs.core.array_index_of_identical_QMARK_(arr,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_index_of_symbol_QMARK_(arr,k);
} else {
if((k == null)){
return cljs.core.array_index_of_nil_QMARK_(arr);
} else {
return cljs.core.array_index_of_equiv_QMARK_(arr,k);

}
}
}
}
});
cljs.core.array_map_index_of = (function cljs$core$array_map_index_of(m,k){
return cljs.core.array_index_of(m.arr,k);
});
cljs.core.array_extend_kv = (function cljs$core$array_extend_kv(arr,k,v){
var l = arr.length;
var narr = (new Array((l + (2))));
var i_43852 = (0);
while(true){
if((i_43852 < l)){
(narr[i_43852] = (arr[i_43852]));

var G__43853 = (i_43852 + (1));
i_43852 = G__43853;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});
cljs.core.array_map_extend_kv = (function cljs$core$array_map_extend_kv(m,k,v){
return cljs.core.array_extend_kv(m.arr,k,v);
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.PersistentArrayMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMapSeq.prototype.indexOf = (function() {
var G__43854 = null;
var G__43854__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__43854__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__43854 = function(x,start){
switch(arguments.length){
case 1:
return G__43854__1.call(this,x);
case 2:
return G__43854__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43854.cljs$core$IFn$_invoke$arity$1 = G__43854__1;
G__43854.cljs$core$IFn$_invoke$arity$2 = G__43854__2;
return G__43854;
})()
;

cljs.core.PersistentArrayMapSeq.prototype.lastIndexOf = (function() {
var G__43855 = null;
var G__43855__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__43855__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__43855 = function(x,start){
switch(arguments.length){
case 1:
return G__43855__1.call(this,x);
case 2:
return G__43855__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43855.cljs$core$IFn$_invoke$arity$1 = G__43855__1;
G__43855.cljs$core$IFn$_invoke$arity$2 = G__43855__2;
return G__43855;
})()
;

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return null;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentArrayMapSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$_meta], null);
});

cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentArrayMapSeq");
});

cljs.core.__GT_PersistentArrayMapSeq = (function cljs$core$__GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

(cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
cljs.core.persistent_array_map_seq = (function cljs$core$persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});


/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
})
cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
});

cljs.core.PersistentArrayMapIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
self__.i = (self__.i + (2));

return ret;
});

cljs.core.PersistentArrayMapIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$cnt], null);
});

cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentArrayMapIterator");
});

cljs.core.__GT_PersistentArrayMapIterator = (function cljs$core$__GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentArrayMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null,coll)));
});

cljs.core.PersistentArrayMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentArrayMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null,coll)));
});

cljs.core.PersistentArrayMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentArrayMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__43857 = cljs.core.seq(coll);
var chunk__43858 = null;
var count__43859 = (0);
var i__43860 = (0);
while(true){
if((i__43860 < count__43859)){
var vec__43861 = chunk__43858.cljs$core$IIndexed$_nth$arity$2(null,i__43860);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43861,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43861,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__43874 = seq__43857;
var G__43875 = chunk__43858;
var G__43876 = count__43859;
var G__43877 = (i__43860 + (1));
seq__43857 = G__43874;
chunk__43858 = G__43875;
count__43859 = G__43876;
i__43860 = G__43877;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__43857);
if(temp__4657__auto__){
var seq__43857__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__43857__$1)){
var c__7357__auto__ = cljs.core.chunk_first(seq__43857__$1);
var G__43878 = cljs.core.chunk_rest(seq__43857__$1);
var G__43879 = c__7357__auto__;
var G__43880 = cljs.core.count(c__7357__auto__);
var G__43881 = (0);
seq__43857 = G__43878;
chunk__43858 = G__43879;
count__43859 = G__43880;
i__43860 = G__43881;
continue;
} else {
var vec__43864 = cljs.core.first(seq__43857__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43864,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43864,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__43882 = cljs.core.next(seq__43857__$1);
var G__43883 = null;
var G__43884 = (0);
var G__43885 = (0);
seq__43857 = G__43882;
chunk__43858 = G__43883;
count__43859 = G__43884;
i__43860 = G__43885;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var G__43867 = init__$1;
var G__43868 = (self__.arr[i]);
var G__43869 = (self__.arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__43867,G__43868,G__43869) : f.call(null,G__43867,G__43868,G__43869));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__43886 = (i + (2));
var G__43887 = init__$2;
i = G__43886;
init__$1 = G__43887;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if(((!((other == null)))?((((other.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === other.cljs$core$IMap$)))?true:false):false)){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null))){
var i = (0);
while(true){
if((i < alen)){
var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null,(self__.arr[i]),cljs.core.lookup_sentinel);
if(!((v === cljs.core.lookup_sentinel))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(i + (1))]),v)){
var G__43888 = (i + (2));
i = G__43888;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_map(coll__$1,other);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap({},self__.arr.length,cljs.core.aclone(self__.arr)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY,self__.meta);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return cljs.core._empty(coll__$1);
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(self__.arr[s]))){
var G__43889 = (s + (2));
var G__43890 = d;
s = G__43889;
d = G__43890;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__43891 = (s + (2));
var G__43892 = (d + (2));
s = G__43891;
d = G__43892;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv(coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__43873 = cljs.core.aclone(self__.arr);
(G__43873[(idx + (1))] = v);

return G__43873;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((cljs.core.array_map_index_of(coll__$1,k) === (-1)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq(self__.arr,(0),null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMap(meta__$1,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__43893 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__43894 = cljs.core.next(es);
ret = G__43893;
es = G__43894;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentArrayMap.prototype.call = (function() {
var G__43895 = null;
var G__43895__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__43895__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__43895 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__43895__2.call(this,self__,k);
case 3:
return G__43895__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43895.cljs$core$IFn$_invoke$arity$2 = G__43895__2;
G__43895.cljs$core$IFn$_invoke$arity$3 = G__43895__3;
return G__43895;
})()
;

cljs.core.PersistentArrayMap.prototype.apply = (function (self__,args43856){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args43856)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$cnt,cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentArrayMap.cljs$lang$type = true;

cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";

cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentArrayMap");
});

cljs.core.__GT_PersistentArrayMap = (function cljs$core$__GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash));
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8);
cljs.core.PersistentArrayMap.fromArray = (function (arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var arr__$2 = ((no_check)?arr__$1:(function (){var ret = [];
var i_43896 = (0);
while(true){
if((i_43896 < arr__$1.length)){
var k_43897 = (arr__$1[i_43896]);
var v_43898 = (arr__$1[(i_43896 + (1))]);
var idx_43899 = cljs.core.array_index_of(ret,k_43897);
if((idx_43899 === (-1))){
ret.push(k_43897);

ret.push(v_43898);
} else {
}

var G__43900 = (i_43896 + (2));
i_43896 = G__43900;
continue;
} else {
}
break;
}

return ret;
})());
var cnt = (arr__$2.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$2,null));
});
(cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition0$ = 258;
this.cljs$lang$protocol_mask$partition1$ = 56;
})
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
return cljs.core.quot(self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,k,null);
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMapEntry$)))?true:(((!o.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,o):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,o))){
return cljs.core._assoc_BANG_(tcoll__$1,(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.key.call(null,o)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.val.call(null,o)));
} else {
var es = cljs.core.seq(o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__4655__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4655__auto__)){
var e = temp__4655__auto__;
var G__43903 = cljs.core.next(es);
var G__43904 = cljs.core._assoc_BANG_(tcoll__$2,(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null,e)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null,e)));
es = G__43903;
tcoll__$2 = G__43904;
continue;
} else {
return tcoll__$2;
}
break;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
self__.editable_QMARK_ = false;

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot(self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
self__.len = (self__.len + (2));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(self__.len,self__.arr) : cljs.core.array__GT_transient_hash_map.call(null,self__.len,self__.arr)),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__43902_43905 = self__.arr;
G__43902_43905.pop();

G__43902_43905.pop();


self__.len = (self__.len - (2));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$editable_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$len,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$arr], null);
});

cljs.core.TransientArrayMap.cljs$lang$type = true;

cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";

cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/TransientArrayMap");
});

cljs.core.__GT_TransientArrayMap = (function cljs$core$__GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});


cljs.core.array__GT_transient_hash_map = (function cljs$core$array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__43906 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,(arr[i]),(arr[(i + (1))]));
var G__43907 = (i + (2));
out = G__43906;
i = G__43907;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
})

cljs.core.Box.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Box.cljs$lang$type = true;

cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";

cljs.core.Box.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/Box");
});

cljs.core.__GT_Box = (function cljs$core$__GT_Box(val){
return (new cljs.core.Box(val));
});






cljs.core.key_test = (function cljs$core$key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_(key,other)){
return true;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,other);

}
}
});
cljs.core.mask = (function cljs$core$mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function cljs$core$clone_and_set(var_args){
var args43908 = [];
var len__7651__auto___43913 = arguments.length;
var i__7652__auto___43914 = (0);
while(true){
if((i__7652__auto___43914 < len__7651__auto___43913)){
args43908.push((arguments[i__7652__auto___43914]));

var G__43915 = (i__7652__auto___43914 + (1));
i__7652__auto___43914 = G__43915;
continue;
} else {
}
break;
}

var G__43910 = args43908.length;
switch (G__43910) {
case 3:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43908.length)].join('')));

}
});

cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = (function (arr,i,a){
var G__43911 = cljs.core.aclone(arr);
(G__43911[i] = a);

return G__43911;
});

cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = (function (arr,i,a,j,b){
var G__43912 = cljs.core.aclone(arr);
(G__43912[i] = a);

(G__43912[j] = b);

return G__43912;
});

cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5;

cljs.core.remove_pair = (function cljs$core$remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy(arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy(arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function cljs$core$bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count((bitmap & (bit - (1))));
});
cljs.core.bitpos = (function cljs$core$bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function cljs$core$edit_and_set(var_args){
var args43917 = [];
var len__7651__auto___43920 = arguments.length;
var i__7652__auto___43921 = (0);
while(true){
if((i__7652__auto___43921 < len__7651__auto___43920)){
args43917.push((arguments[i__7652__auto___43921]));

var G__43922 = (i__7652__auto___43921 + (1));
i__7652__auto___43921 = G__43922;
continue;
} else {
}
break;
}

var G__43919 = args43917.length;
switch (G__43919) {
case 4:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43917.length)].join('')));

}
});

cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = (function (inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
});

cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = (function (inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
});

cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6;

cljs.core.inode_kv_reduce = (function cljs$core$inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if(!((k == null))){
var G__43927 = init__$1;
var G__43928 = k;
var G__43929 = (arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__43927,G__43928,G__43929) : f.call(null,G__43927,G__43928,G__43929));
} else {
var node = (arr[(i + (1))]);
if(!((node == null))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__43930 = (i + (2));
var G__43931 = init__$2;
i = G__43930;
init__$1 = G__43931;
continue;
}
} else {
return init__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.NodeIterator = (function (arr,i,next_entry,next_iter){
this.arr = arr;
this.i = i;
this.next_entry = next_entry;
this.next_iter = next_iter;
})
cljs.core.NodeIterator.prototype.advance = (function (){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((self__.i < len)){
var key = (self__.arr[self__.i]);
var node_or_val = (self__.arr[(self__.i + (1))]);
var found = ((cljs.core.some_QMARK_(key))?self__.next_entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key,node_or_val], null):((cljs.core.some_QMARK_(node_or_val))?(function (){var new_iter = cljs.core._iterator(node_or_val);
if(new_iter.hasNext()){
return self__.next_iter = new_iter;
} else {
return false;
}
})():false
));
self__.i = (self__.i + (2));

if(found){
return true;
} else {
continue;
}
} else {
return false;
}
break;
}
});

cljs.core.NodeIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
var or__6543__auto__ = cljs.core.some_QMARK_(self__.next_entry);
if(or__6543__auto__){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = cljs.core.some_QMARK_(self__.next_iter);
if(or__6543__auto____$1){
return or__6543__auto____$1;
} else {
return this$.advance();
}
}
});

cljs.core.NodeIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(cljs.core.some_QMARK_(self__.next_entry)){
var ret = self__.next_entry;
self__.next_entry = null;

return ret;
} else {
if(cljs.core.some_QMARK_(self__.next_iter)){
var ret = self__.next_iter.next();
if(self__.next_iter.hasNext()){
} else {
self__.next_iter = null;
}

return ret;
} else {
if(this$.advance()){
return this$.next();
} else {
throw (new Error("No such element"));

}
}
}
});

cljs.core.NodeIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.NodeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next_DASH_entry,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next_DASH_iter,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.NodeIterator.cljs$lang$type = true;

cljs.core.NodeIterator.cljs$lang$ctorStr = "cljs.core/NodeIterator";

cljs.core.NodeIterator.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/NodeIterator");
});

cljs.core.__GT_NodeIterator = (function cljs$core$__GT_NodeIterator(arr,i,next_entry,next_iter){
return (new cljs.core.NodeIterator(arr,i,next_entry,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
})
cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count(self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
(removed_leaf_QMARK_[(0)] = true);

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function (e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
editable.bitmap = (bit ^ editable.bitmap);

cljs.core.array_copy(earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
});

cljs.core.BitmapIndexedNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_inode_seq.call(null,self__.arr));
});

cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
added_leaf_QMARK_.val = true;

cljs.core.array_copy_downward(earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

editable.bitmap = (editable.bitmap | bit);

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_43945 = (0);
var j_43946 = (0);
while(true){
if((i_43945 < (32))){
if((((self__.bitmap >>> i_43945) & (1)) === (0))){
var G__43947 = (i_43945 + (1));
var G__43948 = j_43946;
i_43945 = G__43947;
j_43946 = G__43948;
continue;
} else {
(nodes[i_43945] = ((!(((self__.arr[j_43946]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash((self__.arr[j_43946])),(self__.arr[j_43946]),(self__.arr[(j_43946 + (1))]),added_leaf_QMARK_):(self__.arr[(j_43946 + (1))])));

var G__43949 = (i_43945 + (1));
var G__43950 = (j_43946 + (2));
i_43945 = G__43949;
j_43946 = G__43950;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

var editable = inode.ensure_editable(edit__$1);
editable.arr = new_arr;

editable.bitmap = (editable.bitmap | bit);

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
added_leaf_QMARK_.val = true;

return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__43932 = edit__$1;
var G__43933 = (shift + (5));
var G__43934 = key_or_nil;
var G__43935 = val_or_node;
var G__43936 = hash;
var G__43937 = key;
var G__43938 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__43932,G__43933,G__43934,G__43935,G__43936,G__43937,G__43938) : cljs.core.create_node.call(null,G__43932,G__43933,G__43934,G__43935,G__43936,G__43937,G__43938));
})());

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_43951 = (0);
var j_43952 = (0);
while(true){
if((i_43951 < (32))){
if((((self__.bitmap >>> i_43951) & (1)) === (0))){
var G__43953 = (i_43951 + (1));
var G__43954 = j_43952;
i_43951 = G__43953;
j_43952 = G__43954;
continue;
} else {
(nodes[i_43951] = ((!(((self__.arr[j_43952]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash((self__.arr[j_43952])),(self__.arr[j_43952]),(self__.arr[(j_43952 + (1))]),added_leaf_QMARK_):(self__.arr[(j_43952 + (1))])));

var G__43955 = (i_43951 + (1));
var G__43956 = (j_43952 + (2));
i_43951 = G__43955;
j_43952 = G__43956;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),val)));
}
} else {
added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__43939 = (shift + (5));
var G__43940 = key_or_nil;
var G__43941 = val_or_node;
var G__43942 = hash;
var G__43943 = key;
var G__43944 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__43939,G__43940,G__43941,G__43942,G__43943,G__43944) : cljs.core.create_node.call(null,G__43939,G__43940,G__43941,G__43942,G__43943,G__43944));
})())));

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_or_nil,val_or_node], null);
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
});

cljs.core.BitmapIndexedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.with_meta(cljs.core.cst$sym$bitmap,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.BitmapIndexedNode.cljs$lang$type = true;

cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode";

cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/BitmapIndexedNode");
});

cljs.core.__GT_BitmapIndexedNode = (function cljs$core$__GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[]));
cljs.core.pack_array_node = (function cljs$core$pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((!((i === idx))) && (!(((arr[i]) == null)))){
(new_arr[j] = (arr[i]));

var G__43957 = (i + (1));
var G__43958 = (j + (2));
var G__43959 = (bitmap | ((1) << i));
i = G__43957;
j = G__43958;
bitmap = G__43959;
continue;
} else {
var G__43960 = (i + (1));
var G__43961 = j;
var G__43962 = bitmap;
i = G__43960;
j = G__43961;
bitmap = G__43962;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNodeIterator = (function (arr,i,next_iter){
this.arr = arr;
this.i = i;
this.next_iter = next_iter;
})
cljs.core.ArrayNodeIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if(!((cljs.core.some_QMARK_(self__.next_iter)) && (self__.next_iter.hasNext()))){
if((self__.i < len)){
var node = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

if(cljs.core.some_QMARK_(node)){
self__.next_iter = cljs.core._iterator(node);
} else {
}

continue;
} else {
return false;
}
} else {
return true;
}
break;
}
});

cljs.core.ArrayNodeIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
return self__.next_iter.next();
} else {
throw (new Error("No such element"));
}
});

cljs.core.ArrayNodeIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.ArrayNodeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next_DASH_iter,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayNodeIterator.cljs$lang$type = true;

cljs.core.ArrayNodeIterator.cljs$lang$ctorStr = "cljs.core/ArrayNodeIterator";

cljs.core.ArrayNodeIterator.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ArrayNodeIterator");
});

cljs.core.__GT_ArrayNodeIterator = (function cljs$core$__GT_ArrayNodeIterator(arr,i,next_iter){
return (new cljs.core.ArrayNodeIterator(arr,i,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.ArrayNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone(self__.arr)));
}
});

cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
editable.cnt = (editable.cnt - (1));

return editable;
}
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);

}
}
}
});

cljs.core.ArrayNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_array_node_seq.call(null,self__.arr));
});

cljs.core.ArrayNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if(!((node == null))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__43963 = (i + (1));
var G__43964 = init__$2;
i = G__43963;
init__$1 = G__43964;
continue;
}
} else {
var G__43965 = (i + (1));
var G__43966 = init__$1;
i = G__43965;
init__$1 = G__43966;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ArrayNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
editable.cnt = (editable.cnt + (1));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
}
}
});

cljs.core.ArrayNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
}
});

cljs.core.ArrayNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));

}
}
} else {
return inode;
}
});

cljs.core.ArrayNode.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.ArrayNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeIterator(self__.arr,(0),null));
});

cljs.core.ArrayNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.with_meta(cljs.core.cst$sym$cnt,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayNode.cljs$lang$type = true;

cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode";

cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ArrayNode");
});

cljs.core.__GT_ArrayNode = (function cljs$core$__GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function cljs$core$hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test(key,(arr[i]))){
return i;
} else {
var G__43967 = (i + (2));
i = G__43967;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.HashCollisionNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
});

cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
(removed_leaf_QMARK_[(0)] = true);

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

editable.cnt = (editable.cnt - (1));

return editable;
}
}
});

cljs.core.HashCollisionNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_inode_seq.call(null,self__.arr));
});

cljs.core.HashCollisionNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.HashCollisionNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (self__.arr[(idx + (1))]);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
added_leaf_QMARK_.val = true;

editable.cnt = (editable.cnt + (1));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(idx + (1))]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function (e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
self__.arr = array;

self__.cnt = count;

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
});

cljs.core.HashCollisionNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[idx]),(self__.arr[(idx + (1))])], null);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair(self__.arr,cljs.core.quot(idx,(2)))));

}
}
});

cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
});

cljs.core.HashCollisionNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.with_meta(cljs.core.cst$sym$collision_DASH_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$cnt,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.HashCollisionNode.cljs$lang$type = true;

cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode";

cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/HashCollisionNode");
});

cljs.core.__GT_HashCollisionNode = (function cljs$core$__GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function cljs$core$create_node(var_args){
var args43968 = [];
var len__7651__auto___43971 = arguments.length;
var i__7652__auto___43972 = (0);
while(true){
if((i__7652__auto___43972 < len__7651__auto___43971)){
args43968.push((arguments[i__7652__auto___43972]));

var G__43973 = (i__7652__auto___43972 + (1));
i__7652__auto___43972 = G__43973;
continue;
} else {
}
break;
}

var G__43970 = args43968.length;
switch (G__43970) {
case 6:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43968.length)].join('')));

}
});

cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = (function (shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});

cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = (function (edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});

cljs.core.create_node.cljs$lang$maxFixedArity = 7;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.NodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.NodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NodeSeq.prototype.indexOf = (function() {
var G__43981 = null;
var G__43981__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__43981__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__43981 = function(x,start){
switch(arguments.length){
case 1:
return G__43981__1.call(this,x);
case 2:
return G__43981__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43981.cljs$core$IFn$_invoke$arity$1 = G__43981__1;
G__43981.cljs$core$IFn$_invoke$arity$2 = G__43981__2;
return G__43981;
})()
;

cljs.core.NodeSeq.prototype.lastIndexOf = (function() {
var G__43982 = null;
var G__43982__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__43982__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__43982 = function(x,start){
switch(arguments.length){
case 1:
return G__43982__1.call(this,x);
case 2:
return G__43982__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43982.cljs$core$IFn$_invoke$arity$1 = G__43982__1;
G__43982.cljs$core$IFn$_invoke$arity$2 = G__43982__2;
return G__43982;
})()
;

cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))])], null);
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var ret = (((self__.s == null))?(function (){var G__43975 = self__.nodes;
var G__43976 = (self__.i + (2));
var G__43977 = null;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__43975,G__43976,G__43977) : cljs.core.create_inode_seq.call(null,G__43975,G__43976,G__43977));
})():(function (){var G__43978 = self__.nodes;
var G__43979 = self__.i;
var G__43980 = cljs.core.next(self__.s);
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__43978,G__43979,G__43980) : cljs.core.create_inode_seq.call(null,G__43978,G__43979,G__43980));
})());
if(!((ret == null))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.NodeSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$nodes,cljs.core.cst$sym$i,cljs.core.cst$sym$s,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.NodeSeq.cljs$lang$type = true;

cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq";

cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/NodeSeq");
});

cljs.core.__GT_NodeSeq = (function cljs$core$__GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
cljs.core.create_inode_seq = (function cljs$core$create_inode_seq(var_args){
var args43983 = [];
var len__7651__auto___43986 = arguments.length;
var i__7652__auto___43987 = (0);
while(true){
if((i__7652__auto___43987 < len__7651__auto___43986)){
args43983.push((arguments[i__7652__auto___43987]));

var G__43988 = (i__7652__auto___43987 + (1));
i__7652__auto___43987 = G__43988;
continue;
} else {
}
break;
}

var G__43985 = args43983.length;
switch (G__43985) {
case 1:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43983.length)].join('')));

}
});

cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
});

cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if(!(((nodes[j]) == null))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__4655__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__4655__auto__)){
var node = temp__4655__auto__;
var temp__4655__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__4655__auto____$1)){
var node_seq = temp__4655__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__43990 = (j + (2));
j = G__43990;
continue;
}
} else {
var G__43991 = (j + (2));
j = G__43991;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
});

cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ArrayNodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ArrayNodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ArrayNodeSeq.prototype.indexOf = (function() {
var G__43996 = null;
var G__43996__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__43996__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__43996 = function(x,start){
switch(arguments.length){
case 1:
return G__43996__1.call(this,x);
case 2:
return G__43996__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43996.cljs$core$IFn$_invoke$arity$1 = G__43996__1;
G__43996.cljs$core$IFn$_invoke$arity$2 = G__43996__2;
return G__43996;
})()
;

cljs.core.ArrayNodeSeq.prototype.lastIndexOf = (function() {
var G__43997 = null;
var G__43997__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__43997__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__43997 = function(x,start){
switch(arguments.length){
case 1:
return G__43997__1.call(this,x);
case 2:
return G__43997__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43997.cljs$core$IFn$_invoke$arity$1 = G__43997__1;
G__43997.cljs$core$IFn$_invoke$arity$2 = G__43997__2;
return G__43997;
})()
;

cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.s);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var ret = (function (){var G__43992 = null;
var G__43993 = self__.nodes;
var G__43994 = self__.i;
var G__43995 = cljs.core.next(self__.s);
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(G__43992,G__43993,G__43994,G__43995) : cljs.core.create_array_node_seq.call(null,G__43992,G__43993,G__43994,G__43995));
})();
if(!((ret == null))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ArrayNodeSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$nodes,cljs.core.cst$sym$i,cljs.core.cst$sym$s,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayNodeSeq.cljs$lang$type = true;

cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq";

cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ArrayNodeSeq");
});

cljs.core.__GT_ArrayNodeSeq = (function cljs$core$__GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
cljs.core.create_array_node_seq = (function cljs$core$create_array_node_seq(var_args){
var args43998 = [];
var len__7651__auto___44001 = arguments.length;
var i__7652__auto___44002 = (0);
while(true){
if((i__7652__auto___44002 < len__7651__auto___44001)){
args43998.push((arguments[i__7652__auto___44002]));

var G__44003 = (i__7652__auto___44002 + (1));
i__7652__auto___44002 = G__44003;
continue;
} else {
}
break;
}

var G__44000 = args43998.length;
switch (G__44000) {
case 1:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args43998.length)].join('')));

}
});

cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(null,nodes,(0),null);
});

cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 = (function (meta,nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__4655__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__4655__auto__)){
var nj = temp__4655__auto__;
var temp__4655__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__4655__auto____$1)){
var ns = temp__4655__auto____$1;
return (new cljs.core.ArrayNodeSeq(meta,nodes,(j + (1)),ns,null));
} else {
var G__44005 = (j + (1));
j = G__44005;
continue;
}
} else {
var G__44006 = (j + (1));
j = G__44006;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,null));
}
});

cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 4;


/**
* @constructor
*/
cljs.core.HashMapIter = (function (nil_val,root_iter,seen){
this.nil_val = nil_val;
this.root_iter = root_iter;
this.seen = seen;
})
cljs.core.HashMapIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (cljs.core.not(self__.seen)) || (self__.root_iter.hasNext());
});

cljs.core.HashMapIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!(self__.seen)){
self__.seen = true;

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,self__.nil_val], null);
} else {
return self__.root_iter.next();
}
});

cljs.core.HashMapIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.HashMapIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$nil_DASH_val,cljs.core.cst$sym$root_DASH_iter,cljs.core.with_meta(cljs.core.cst$sym$seen,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.HashMapIter.cljs$lang$type = true;

cljs.core.HashMapIter.cljs$lang$ctorStr = "cljs.core/HashMapIter";

cljs.core.HashMapIter.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/HashMapIter");
});

cljs.core.__GT_HashMapIter = (function cljs$core$__GT_HashMapIter(nil_val,root_iter,seen){
return (new cljs.core.HashMapIter(nil_val,root_iter,seen));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null,coll)));
});

cljs.core.PersistentHashMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null,coll)));
});

cljs.core.PersistentHashMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__44008 = cljs.core.seq(coll);
var chunk__44009 = null;
var count__44010 = (0);
var i__44011 = (0);
while(true){
if((i__44011 < count__44010)){
var vec__44012 = chunk__44009.cljs$core$IIndexed$_nth$arity$2(null,i__44011);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44012,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44012,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__44020 = seq__44008;
var G__44021 = chunk__44009;
var G__44022 = count__44010;
var G__44023 = (i__44011 + (1));
seq__44008 = G__44020;
chunk__44009 = G__44021;
count__44010 = G__44022;
i__44011 = G__44023;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__44008);
if(temp__4657__auto__){
var seq__44008__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__44008__$1)){
var c__7357__auto__ = cljs.core.chunk_first(seq__44008__$1);
var G__44024 = cljs.core.chunk_rest(seq__44008__$1);
var G__44025 = c__7357__auto__;
var G__44026 = cljs.core.count(c__7357__auto__);
var G__44027 = (0);
seq__44008 = G__44024;
chunk__44009 = G__44025;
count__44010 = G__44026;
i__44011 = G__44027;
continue;
} else {
var vec__44015 = cljs.core.first(seq__44008__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44015,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44015,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__44028 = cljs.core.next(seq__44008__$1);
var G__44029 = null;
var G__44030 = (0);
var G__44031 = (0);
seq__44008 = G__44028;
chunk__44009 = G__44029;
count__44010 = G__44030;
i__44011 = G__44031;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(init,null,self__.nil_val) : f.call(null,init,null,self__.nil_val)):init);
if(cljs.core.reduced_QMARK_(init__$1)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$1) : cljs.core.deref.call(null,init__$1));
} else {
if(!((self__.root == null))){
return self__.root.kv_reduce(f,init__$1);
} else {
return init__$1;

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var root_iter = ((self__.root)?cljs.core._iterator(self__.root):cljs.core.nil_iter());
if(self__.has_nil_QMARK_){
return (new cljs.core.HashMapIter(self__.nil_val,root_iter,false));
} else {
return root_iter;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap({},self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY,self__.meta);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash(k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if((self__.has_nil_QMARK_) && ((v === self__.nil_val))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return !((self__.root.inode_lookup((0),cljs.core.hash(k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel));

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = ((!((self__.root == null)))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,self__.nil_val], null),s);
} else {
return s;
}
} else {
return null;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashMap(meta__$1,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__44032 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__44033 = cljs.core.next(es);
ret = G__44032;
es = G__44033;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentHashMap.prototype.call = (function() {
var G__44034 = null;
var G__44034__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__44034__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__44034 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__44034__2.call(this,self__,k);
case 3:
return G__44034__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44034.cljs$core$IFn$_invoke$arity$2 = G__44034__2;
G__44034.cljs$core$IFn$_invoke$arity$3 = G__44034__3;
return G__44034;
})()
;

cljs.core.PersistentHashMap.prototype.apply = (function (self__,args44007){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args44007)));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$cnt,cljs.core.cst$sym$root,cljs.core.with_meta(cljs.core.cst$sym$has_DASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null)),cljs.core.cst$sym$nil_DASH_val,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentHashMap.cljs$lang$type = true;

cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap";

cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentHashMap");
});

cljs.core.__GT_PersistentHashMap = (function cljs$core$__GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashMap.fromArray = (function (arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__44035 = (i + (2));
var G__44036 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__44035;
ret = G__44036;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
});
cljs.core.PersistentHashMap.fromArrays = (function (ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__44037 = (i + (1));
var G__44038 = out.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(ks[i]),(vs[i]));
i = G__44037;
out = G__44038;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});
(cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition0$ = 258;
this.cljs$lang$protocol_mask$partition1$ = 56;
})
cljs.core.TransientHashMap.prototype.conj_BANG_ = (function (o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMapEntry$)))?true:(((!o.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,o):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,o))){
return tcoll.assoc_BANG_((cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.key.call(null,o)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.val.call(null,o)));
} else {
var es = cljs.core.seq(o);
var tcoll__$1 = tcoll;
while(true){
var temp__4655__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4655__auto__)){
var e = temp__4655__auto__;
var G__44040 = cljs.core.next(es);
var G__44041 = tcoll__$1.assoc_BANG_((cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null,e)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null,e)));
es = G__44040;
tcoll__$1 = G__44041;
continue;
} else {
return tcoll__$1;
}
break;
}
}
} else {
throw (new Error("conj! after persistent"));
}
});

cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function (k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
self__.nil_val = v;
}

if(self__.has_nil_QMARK_){
} else {
self__.count = (self__.count + (1));

self__.has_nil_QMARK_ = true;
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(added_leaf_QMARK_.val){
self__.count = (self__.count + (1));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.without_BANG_ = (function (k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
self__.has_nil_QMARK_ = false;

self__.nil_val = null;

self__.count = (self__.count - (1));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash(k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(cljs.core.truth_((removed_leaf_QMARK_[(0)]))){
self__.count = (self__.count - (1));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function (){
var self__ = this;
var tcoll = this;
if(self__.edit){
self__.edit = null;

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
});

cljs.core.TransientHashMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$edit,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$root,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$count,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$has_DASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$nil_DASH_val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.TransientHashMap.cljs$lang$type = true;

cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap";

cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/TransientHashMap");
});

cljs.core.__GT_TransientHashMap = (function cljs$core$__GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function cljs$core$tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if(!((t == null))){
var G__44042 = ((ascending_QMARK_)?t.left:t.right);
var G__44043 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,t);
t = G__44042;
stack__$1 = G__44043;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374862;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.PersistentTreeMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMapSeq.prototype.indexOf = (function() {
var G__44044 = null;
var G__44044__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__44044__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__44044 = function(x,start){
switch(arguments.length){
case 1:
return G__44044__1.call(this,x);
case 2:
return G__44044__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44044.cljs$core$IFn$_invoke$arity$1 = G__44044__1;
G__44044.cljs$core$IFn$_invoke$arity$2 = G__44044__2;
return G__44044;
})()
;

cljs.core.PersistentTreeMapSeq.prototype.lastIndexOf = (function() {
var G__44045 = null;
var G__44045__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__44045__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__44045 = function(x,start){
switch(arguments.length){
case 1:
return G__44045__1.call(this,x);
case 2:
return G__44045__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44045.cljs$core$IFn$_invoke$arity$1 = G__44045__1;
G__44045.cljs$core$IFn$_invoke$arity$2 = G__44045__2;
return G__44045;
})()
;

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count(cljs.core.next(coll__$1)) + (1));
} else {
return self__.cnt;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek(self__.stack);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if(!((next_stack == null))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMapSeq(meta__$1,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentTreeMapSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$stack,cljs.core.with_meta(cljs.core.cst$sym$ascending_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null)),cljs.core.cst$sym$cnt,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq";

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentTreeMapSeq");
});

cljs.core.__GT_PersistentTreeMapSeq = (function cljs$core$__GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

(cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
cljs.core.create_tree_map_seq = (function cljs$core$create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push(tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});

cljs.core.balance_left = (function cljs$core$balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function cljs$core$balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function cljs$core$balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right(key,val,del,right.redden());
} else {
if(((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right(right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function cljs$core$balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left(key,val,left.redden(),del);
} else {
if(((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left(left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function cljs$core$tree_map_kv_reduce(node,f,init){
var init__$1 = ((!((node.left == null)))?(function (){var G__44055 = node.left;
var G__44056 = f;
var G__44057 = init;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__44055,G__44056,G__44057) : cljs.core.tree_map_kv_reduce.call(null,G__44055,G__44056,G__44057));
})():init);
if(cljs.core.reduced_QMARK_(init__$1)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$1) : cljs.core.deref.call(null,init__$1));
} else {
var init__$2 = (function (){var G__44058 = init__$1;
var G__44059 = node.key;
var G__44060 = node.val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__44058,G__44059,G__44060) : f.call(null,G__44058,G__44059,G__44060));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var init__$3 = ((!((node.right == null)))?(function (){var G__44061 = node.right;
var G__44062 = f;
var G__44063 = init__$2;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__44061,G__44062,G__44063) : cljs.core.tree_map_kv_reduce.call(null,G__44061,G__44062,G__44063));
})():init__$2);
if(cljs.core.reduced_QMARK_(init__$3)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$3) : cljs.core.deref.call(null,init__$3));
} else {
return init__$3;
}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.BlackNode.prototype.lastIndexOf = (function() {
var G__44065 = null;
var G__44065__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__44065__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__44065 = function(x,start){
switch(arguments.length){
case 1:
return G__44065__1.call(this,x);
case 2:
return G__44065__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44065.cljs$core$IFn$_invoke$arity$1 = G__44065__1;
G__44065.cljs$core$IFn$_invoke$arity$2 = G__44065__2;
return G__44065;
})()
;

cljs.core.BlackNode.prototype.indexOf = (function() {
var G__44066 = null;
var G__44066__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__44066__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__44066 = function(x,start){
switch(arguments.length){
case 1:
return G__44066__1.call(this,x);
case 2:
return G__44066__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44066.cljs$core$IFn$_invoke$arity$1 = G__44066__1;
G__44066.cljs$core$IFn$_invoke$arity$2 = G__44066__2;
return G__44066;
})()
;

cljs.core.BlackNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
});

cljs.core.BlackNode.prototype.redden = (function (){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.BlackNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return node;
});

cljs.core.BlackNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
});

cljs.core.BlackNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.BlackNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
});

cljs.core.BlackNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
});

cljs.core.BlackNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del(self__.key,self__.val,del,self__.right);
});

cljs.core.BlackNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.BlackNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del(self__.key,self__.val,self__.left,del);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
var x__7380__auto__ = self__.key;
return cljs.core._conj((function (){var x__7380__auto____$1 = self__.val;
return cljs.core._conj(cljs.core.List.EMPTY,x__7380__auto____$1);
})(),x__7380__auto__);
});

cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.BlackNode.prototype.call = (function() {
var G__44067 = null;
var G__44067__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__44067__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__44067 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__44067__2.call(this,self__,k);
case 3:
return G__44067__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44067.cljs$core$IFn$_invoke$arity$2 = G__44067__2;
G__44067.cljs$core$IFn$_invoke$arity$3 = G__44067__3;
return G__44067;
})()
;

cljs.core.BlackNode.prototype.apply = (function (self__,args44064){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args44064)));
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.BlackNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$val,cljs.core.cst$sym$left,cljs.core.cst$sym$right,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.BlackNode.cljs$lang$type = true;

cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode";

cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/BlackNode");
});

cljs.core.__GT_BlackNode = (function cljs$core$__GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

(cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.RedNode.prototype.lastIndexOf = (function() {
var G__44069 = null;
var G__44069__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__44069__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__44069 = function(x,start){
switch(arguments.length){
case 1:
return G__44069__1.call(this,x);
case 2:
return G__44069__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44069.cljs$core$IFn$_invoke$arity$1 = G__44069__1;
G__44069.cljs$core$IFn$_invoke$arity$2 = G__44069__2;
return G__44069;
})()
;

cljs.core.RedNode.prototype.indexOf = (function() {
var G__44070 = null;
var G__44070__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__44070__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__44070 = function(x,start){
switch(arguments.length){
case 1:
return G__44070__1.call(this,x);
case 2:
return G__44070__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44070.cljs$core$IFn$_invoke$arity$1 = G__44070__1;
G__44070.cljs$core$IFn$_invoke$arity$2 = G__44070__2;
return G__44070;
})()
;

cljs.core.RedNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
});

cljs.core.RedNode.prototype.redden = (function (){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
});

cljs.core.RedNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.RedNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
});

cljs.core.RedNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.RedNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
});

cljs.core.RedNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
});

cljs.core.RedNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
});

cljs.core.RedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.RedNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
var x__7380__auto__ = self__.key;
return cljs.core._conj((function (){var x__7380__auto____$1 = self__.val;
return cljs.core._conj(cljs.core.List.EMPTY,x__7380__auto____$1);
})(),x__7380__auto__);
});

cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.RedNode.prototype.call = (function() {
var G__44071 = null;
var G__44071__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__44071__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__44071 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__44071__2.call(this,self__,k);
case 3:
return G__44071__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44071.cljs$core$IFn$_invoke$arity$2 = G__44071__2;
G__44071.cljs$core$IFn$_invoke$arity$3 = G__44071__3;
return G__44071;
})()
;

cljs.core.RedNode.prototype.apply = (function (self__,args44068){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args44068)));
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.RedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$val,cljs.core.cst$sym$left,cljs.core.cst$sym$right,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.RedNode.cljs$lang$type = true;

cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode";

cljs.core.RedNode.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/RedNode");
});

cljs.core.__GT_RedNode = (function cljs$core$__GT_RedNode(key,val,left,right,__hash){
return (new cljs.core.RedNode(key,val,left,right,__hash));
});

(cljs.core.RedNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
cljs.core.tree_map_add = (function cljs$core$tree_map_add(comp,tree,k,v,found){
if((tree == null)){
return (new cljs.core.RedNode(k,v,null,null,null));
} else {
var c = (function (){var G__44084 = k;
var G__44085 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__44084,G__44085) : comp.call(null,G__44084,G__44085));
})();
if((c === (0))){
(found[(0)] = tree);

return null;
} else {
if((c < (0))){
var ins = (function (){var G__44086 = comp;
var G__44087 = tree.left;
var G__44088 = k;
var G__44089 = v;
var G__44090 = found;
return (cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5 ? cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5(G__44086,G__44087,G__44088,G__44089,G__44090) : cljs.core.tree_map_add.call(null,G__44086,G__44087,G__44088,G__44089,G__44090));
})();
if(!((ins == null))){
return tree.add_left(ins);
} else {
return null;
}
} else {
var ins = (function (){var G__44091 = comp;
var G__44092 = tree.right;
var G__44093 = k;
var G__44094 = v;
var G__44095 = found;
return (cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5 ? cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5(G__44091,G__44092,G__44093,G__44094,G__44095) : cljs.core.tree_map_add.call(null,G__44091,G__44092,G__44093,G__44094,G__44095));
})();
if(!((ins == null))){
return tree.add_right(ins);
} else {
return null;
}

}
}
}
});
cljs.core.tree_map_append = (function cljs$core$tree_map_append(left,right){
if((left == null)){
return right;
} else {
if((right == null)){
return left;
} else {
if((left instanceof cljs.core.RedNode)){
if((right instanceof cljs.core.RedNode)){
var app = (function (){var G__44104 = left.right;
var G__44105 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__44104,G__44105) : cljs.core.tree_map_append.call(null,G__44104,G__44105));
})();
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.RedNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.RedNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(new cljs.core.RedNode(right.key,right.val,app,right.right,null)),null));
}
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(function (){var G__44106 = left.right;
var G__44107 = right;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__44106,G__44107) : cljs.core.tree_map_append.call(null,G__44106,G__44107));
})(),null));
}
} else {
if((right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(right.key,right.val,(function (){var G__44108 = left;
var G__44109 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__44108,G__44109) : cljs.core.tree_map_append.call(null,G__44108,G__44109));
})(),right.right,null));
} else {
var app = (function (){var G__44110 = left.right;
var G__44111 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__44110,G__44111) : cljs.core.tree_map_append.call(null,G__44110,G__44111));
})();
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.BlackNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.BlackNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return cljs.core.balance_left_del(left.key,left.val,left.left,(new cljs.core.BlackNode(right.key,right.val,app,right.right,null)));
}

}
}
}
}
});
cljs.core.tree_map_remove = (function cljs$core$tree_map_remove(comp,tree,k,found){
if(!((tree == null))){
var c = (function (){var G__44122 = k;
var G__44123 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__44122,G__44123) : comp.call(null,G__44122,G__44123));
})();
if((c === (0))){
(found[(0)] = tree);

return cljs.core.tree_map_append(tree.left,tree.right);
} else {
if((c < (0))){
var del = (function (){var G__44124 = comp;
var G__44125 = tree.left;
var G__44126 = k;
var G__44127 = found;
return (cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4(G__44124,G__44125,G__44126,G__44127) : cljs.core.tree_map_remove.call(null,G__44124,G__44125,G__44126,G__44127));
})();
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left_del(tree.key,tree.val,del,tree.right);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,del,tree.right,null));
}
} else {
return null;
}
} else {
var del = (function (){var G__44128 = comp;
var G__44129 = tree.right;
var G__44130 = k;
var G__44131 = found;
return (cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4(G__44128,G__44129,G__44130,G__44131) : cljs.core.tree_map_remove.call(null,G__44128,G__44129,G__44130,G__44131));
})();
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right_del(tree.key,tree.val,tree.left,del);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,tree.left,del,null));
}
} else {
return null;
}

}
}
} else {
return null;
}
});
cljs.core.tree_map_replace = (function cljs$core$tree_map_replace(comp,tree,k,v){
var tk = tree.key;
var c = (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(k,tk) : comp.call(null,k,tk));
if((c === (0))){
return tree.replace(tk,v,tree.left,tree.right);
} else {
if((c < (0))){
return tree.replace(tk,tree.val,(function (){var G__44140 = comp;
var G__44141 = tree.left;
var G__44142 = k;
var G__44143 = v;
return (cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4(G__44140,G__44141,G__44142,G__44143) : cljs.core.tree_map_replace.call(null,G__44140,G__44141,G__44142,G__44143));
})(),tree.right);
} else {
return tree.replace(tk,tree.val,tree.left,(function (){var G__44144 = comp;
var G__44145 = tree.right;
var G__44146 = k;
var G__44147 = v;
return (cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4(G__44144,G__44145,G__44146,G__44147) : cljs.core.tree_map_replace.call(null,G__44144,G__44145,G__44146,G__44147));
})());

}
}
});

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentTreeMap = (function (comp,tree,cnt,meta,__hash){
this.comp = comp;
this.tree = tree;
this.cnt = cnt;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 418776847;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__44149 = cljs.core.seq(coll);
var chunk__44150 = null;
var count__44151 = (0);
var i__44152 = (0);
while(true){
if((i__44152 < count__44151)){
var vec__44153 = chunk__44150.cljs$core$IIndexed$_nth$arity$2(null,i__44152);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44153,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44153,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__44163 = seq__44149;
var G__44164 = chunk__44150;
var G__44165 = count__44151;
var G__44166 = (i__44152 + (1));
seq__44149 = G__44163;
chunk__44150 = G__44164;
count__44151 = G__44165;
i__44152 = G__44166;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__44149);
if(temp__4657__auto__){
var seq__44149__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__44149__$1)){
var c__7357__auto__ = cljs.core.chunk_first(seq__44149__$1);
var G__44167 = cljs.core.chunk_rest(seq__44149__$1);
var G__44168 = c__7357__auto__;
var G__44169 = cljs.core.count(c__7357__auto__);
var G__44170 = (0);
seq__44149 = G__44167;
chunk__44150 = G__44168;
count__44151 = G__44169;
i__44152 = G__44170;
continue;
} else {
var vec__44156 = cljs.core.first(seq__44149__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44156,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44156,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__44171 = cljs.core.next(seq__44149__$1);
var G__44172 = null;
var G__44173 = (0);
var G__44174 = (0);
seq__44149 = G__44171;
chunk__44150 = G__44172;
count__44151 = G__44173;
i__44152 = G__44174;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null,coll)));
});

cljs.core.PersistentTreeMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null,coll)));
});

cljs.core.PersistentTreeMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMap.prototype.entry_at = (function (k){
var self__ = this;
var coll = this;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__44159 = k;
var G__44160 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__44159,G__44160) : self__.comp.call(null,G__44159,G__44160));
})();
if((c === (0))){
return t;
} else {
if((c < (0))){
var G__44175 = t.left;
t = G__44175;
continue;
} else {
var G__44176 = t.right;
t = G__44176;
continue;

}
}
} else {
return null;
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var n = coll__$1.entry_at(k);
if(!((n == null))){
return n.val;
} else {
return not_found;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if(!((self__.tree == null))){
return cljs.core.tree_map_kv_reduce(self__.tree,f,init);
} else {
return init;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,self__.meta,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,false,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,(0)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_remove(self__.comp,self__.tree,k,found);
if((t == null)){
if((cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0)) == null)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt - (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_add(self__.comp,self__.tree,k,v,found);
if((t == null)){
var found_node = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,found_node.val)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,cljs.core.tree_map_replace(self__.comp,self__.tree,k,v),self__.cnt,self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt + (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((coll__$1.entry_at(k) == null));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,true,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,meta__$1,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__44177 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__44178 = cljs.core.next(es);
ret = G__44177;
es = G__44178;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentTreeMap.prototype.call = (function() {
var G__44179 = null;
var G__44179__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__44179__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__44179 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__44179__2.call(this,self__,k);
case 3:
return G__44179__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44179.cljs$core$IFn$_invoke$arity$2 = G__44179__2;
G__44179.cljs$core$IFn$_invoke$arity$3 = G__44179__3;
return G__44179;
})()
;

cljs.core.PersistentTreeMap.prototype.apply = (function (self__,args44148){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args44148)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,ascending_QMARK_,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var stack = null;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__44161 = k;
var G__44162 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__44161,G__44162) : self__.comp.call(null,G__44161,G__44162));
})();
if((c === (0))){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t),ascending_QMARK_,(-1),null));
} else {
if(cljs.core.truth_(ascending_QMARK_)){
if((c < (0))){
var G__44180 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__44181 = t.left;
stack = G__44180;
t = G__44181;
continue;
} else {
var G__44182 = stack;
var G__44183 = t.right;
stack = G__44182;
t = G__44183;
continue;
}
} else {
if((c > (0))){
var G__44184 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__44185 = t.right;
stack = G__44184;
t = G__44185;
continue;
} else {
var G__44186 = stack;
var G__44187 = t.left;
stack = G__44186;
t = G__44187;
continue;
}

}
}
} else {
if((stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,stack,ascending_QMARK_,(-1),null));
}
}
break;
}
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(entry) : cljs.core.key.call(null,entry));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.comp;
});

cljs.core.PersistentTreeMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$tree,cljs.core.cst$sym$cnt,cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentTreeMap.cljs$lang$type = true;

cljs.core.PersistentTreeMap.cljs$lang$ctorStr = "cljs.core/PersistentTreeMap";

cljs.core.PersistentTreeMap.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentTreeMap");
});

cljs.core.__GT_PersistentTreeMap = (function cljs$core$__GT_PersistentTreeMap(comp,tree,cnt,meta,__hash){
return (new cljs.core.PersistentTreeMap(comp,tree,cnt,meta,__hash));
});

cljs.core.PersistentTreeMap.EMPTY = (new cljs.core.PersistentTreeMap(cljs.core.compare,null,(0),null,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
/**
 * keyval => key val
 *   Returns a new hash map with supplied mappings.
 */
cljs.core.hash_map = (function cljs$core$hash_map(var_args){
var args__7658__auto__ = [];
var len__7651__auto___44189 = arguments.length;
var i__7652__auto___44190 = (0);
while(true){
if((i__7652__auto___44190 < len__7651__auto___44189)){
args__7658__auto__.push((arguments[i__7652__auto___44190]));

var G__44191 = (i__7652__auto___44190 + (1));
i__7652__auto___44190 = G__44191;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if(in$){
var G__44192 = cljs.core.nnext(in$);
var G__44193 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__44192;
out = G__44193;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});

cljs.core.hash_map.cljs$lang$maxFixedArity = (0);

cljs.core.hash_map.cljs$lang$applyTo = (function (seq44188){
return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44188));
});

/**
 * keyval => key val
 *   Returns a new array map with supplied mappings.
 */
cljs.core.array_map = (function cljs$core$array_map(var_args){
var args__7658__auto__ = [];
var len__7651__auto___44195 = arguments.length;
var i__7652__auto___44196 = (0);
while(true){
if((i__7652__auto___44196 < len__7651__auto___44195)){
args__7658__auto__.push((arguments[i__7652__auto___44196]));

var G__44197 = (i__7652__auto___44196 + (1));
i__7652__auto___44196 = G__44197;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var arr = ((((keyvals instanceof cljs.core.IndexedSeq)) && ((keyvals.i === (0))))?keyvals.arr:cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(keyvals));
return cljs.core.PersistentArrayMap.fromArray(arr,true,false);
});

cljs.core.array_map.cljs$lang$maxFixedArity = (0);

cljs.core.array_map.cljs$lang$applyTo = (function (seq44194){
return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44194));
});

/**
 * keyval => key val
 *   Returns a new object map with supplied mappings.
 */
cljs.core.obj_map = (function cljs$core$obj_map(var_args){
var args__7658__auto__ = [];
var len__7651__auto___44201 = arguments.length;
var i__7652__auto___44202 = (0);
while(true){
if((i__7652__auto___44202 < len__7651__auto___44201)){
args__7658__auto__.push((arguments[i__7652__auto___44202]));

var G__44203 = (i__7652__auto___44202 + (1));
i__7652__auto___44202 = G__44203;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var ks = [];
var obj = {};
var kvs = cljs.core.seq(keyvals);
while(true){
if(kvs){
ks.push(cljs.core.first(kvs));

(obj[cljs.core.first(kvs)] = cljs.core.second(kvs));

var G__44204 = cljs.core.nnext(kvs);
kvs = G__44204;
continue;
} else {
return cljs.core.ObjMap.fromObject(ks,obj);
}
break;
}
});

cljs.core.obj_map.cljs$lang$maxFixedArity = (0);

cljs.core.obj_map.cljs$lang$applyTo = (function (seq44198){
return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44198));
});

/**
 * keyval => key val
 *   Returns a new sorted map with supplied mappings.
 */
cljs.core.sorted_map = (function cljs$core$sorted_map(var_args){
var args__7658__auto__ = [];
var len__7651__auto___44206 = arguments.length;
var i__7652__auto___44207 = (0);
while(true){
if((i__7652__auto___44207 < len__7651__auto___44206)){
args__7658__auto__.push((arguments[i__7652__auto___44207]));

var G__44208 = (i__7652__auto___44207 + (1));
i__7652__auto___44207 = G__44208;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.PersistentTreeMap.EMPTY;
while(true){
if(in$){
var G__44209 = cljs.core.nnext(in$);
var G__44210 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__44209;
out = G__44210;
continue;
} else {
return out;
}
break;
}
});

cljs.core.sorted_map.cljs$lang$maxFixedArity = (0);

cljs.core.sorted_map.cljs$lang$applyTo = (function (seq44205){
return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44205));
});

/**
 * keyval => key val
 *   Returns a new sorted map with supplied mappings, using the supplied comparator.
 */
cljs.core.sorted_map_by = (function cljs$core$sorted_map_by(var_args){
var args__7658__auto__ = [];
var len__7651__auto___44213 = arguments.length;
var i__7652__auto___44214 = (0);
while(true){
if((i__7652__auto___44214 < len__7651__auto___44213)){
args__7658__auto__.push((arguments[i__7652__auto___44214]));

var G__44215 = (i__7652__auto___44214 + (1));
i__7652__auto___44214 = G__44215;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = (new cljs.core.PersistentTreeMap(cljs.core.fn__GT_comparator(comparator),null,(0),null,(0)));
while(true){
if(in$){
var G__44216 = cljs.core.nnext(in$);
var G__44217 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__44216;
out = G__44217;
continue;
} else {
return out;
}
break;
}
});

cljs.core.sorted_map_by.cljs$lang$maxFixedArity = (1);

cljs.core.sorted_map_by.cljs$lang$applyTo = (function (seq44211){
var G__44212 = cljs.core.first(seq44211);
var seq44211__$1 = cljs.core.next(seq44211);
return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(G__44212,seq44211__$1);
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.KeySeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.KeySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.KeySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.KeySeq.prototype.indexOf = (function() {
var G__44220 = null;
var G__44220__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__44220__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__44220 = function(x,start){
switch(arguments.length){
case 1:
return G__44220__1.call(this,x);
case 2:
return G__44220__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44220.cljs$core$IFn$_invoke$arity$1 = G__44220__1;
G__44220.cljs$core$IFn$_invoke$arity$2 = G__44220__2;
return G__44220;
})()
;

cljs.core.KeySeq.prototype.lastIndexOf = (function() {
var G__44221 = null;
var G__44221__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__44221__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__44221 = function(x,start){
switch(arguments.length){
case 1:
return G__44221__1.call(this,x);
case 2:
return G__44221__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44221.cljs$core$IFn$_invoke$arity$1 = G__44221__1;
G__44221.cljs$core$IFn$_invoke$arity$2 = G__44221__2;
return G__44221;
})()
;

cljs.core.KeySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.KeySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = ((((!((self__.mseq == null)))?((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$)))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.KeySeq(nseq,self__._meta));
}
});

cljs.core.KeySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.KeySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_key$arity$1(null);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = ((((!((self__.mseq == null)))?((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$)))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.KeySeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.KeySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.KeySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.KeySeq(self__.mseq,new_meta));
});

cljs.core.KeySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.KeySeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mseq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null)),cljs.core.cst$sym$_meta], null);
});

cljs.core.KeySeq.cljs$lang$type = true;

cljs.core.KeySeq.cljs$lang$ctorStr = "cljs.core/KeySeq";

cljs.core.KeySeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/KeySeq");
});

cljs.core.__GT_KeySeq = (function cljs$core$__GT_KeySeq(mseq,_meta){
return (new cljs.core.KeySeq(mseq,_meta));
});

(cljs.core.KeySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
/**
 * Returns a sequence of the map's keys.
 */
cljs.core.keys = (function cljs$core$keys(hash_map){
var temp__4657__auto__ = cljs.core.seq(hash_map);
if(temp__4657__auto__){
var mseq = temp__4657__auto__;
return (new cljs.core.KeySeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core.key = (function cljs$core$key(map_entry){
return cljs.core._key(map_entry);
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ValSeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ValSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ValSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ValSeq.prototype.indexOf = (function() {
var G__44224 = null;
var G__44224__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__44224__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__44224 = function(x,start){
switch(arguments.length){
case 1:
return G__44224__1.call(this,x);
case 2:
return G__44224__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44224.cljs$core$IFn$_invoke$arity$1 = G__44224__1;
G__44224.cljs$core$IFn$_invoke$arity$2 = G__44224__2;
return G__44224;
})()
;

cljs.core.ValSeq.prototype.lastIndexOf = (function() {
var G__44225 = null;
var G__44225__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__44225__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__44225 = function(x,start){
switch(arguments.length){
case 1:
return G__44225__1.call(this,x);
case 2:
return G__44225__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44225.cljs$core$IFn$_invoke$arity$1 = G__44225__1;
G__44225.cljs$core$IFn$_invoke$arity$2 = G__44225__2;
return G__44225;
})()
;

cljs.core.ValSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.ValSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = ((((!((self__.mseq == null)))?((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$)))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.ValSeq(nseq,self__._meta));
}
});

cljs.core.ValSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ValSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_val$arity$1(null);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = ((((!((self__.mseq == null)))?((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$)))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.ValSeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ValSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ValSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ValSeq(self__.mseq,new_meta));
});

cljs.core.ValSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ValSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mseq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null)),cljs.core.cst$sym$_meta], null);
});

cljs.core.ValSeq.cljs$lang$type = true;

cljs.core.ValSeq.cljs$lang$ctorStr = "cljs.core/ValSeq";

cljs.core.ValSeq.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ValSeq");
});

cljs.core.__GT_ValSeq = (function cljs$core$__GT_ValSeq(mseq,_meta){
return (new cljs.core.ValSeq(mseq,_meta));
});

(cljs.core.ValSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
/**
 * Returns a sequence of the map's values.
 */
cljs.core.vals = (function cljs$core$vals(hash_map){
var temp__4657__auto__ = cljs.core.seq(hash_map);
if(temp__4657__auto__){
var mseq = temp__4657__auto__;
return (new cljs.core.ValSeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the value in the map entry.
 */
cljs.core.val = (function cljs$core$val(map_entry){
return cljs.core._val(map_entry);
});
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 *   the first.  If a key occurs in more than one map, the mapping from
 *   the latter (left-to-right) will be the mapping in the result.
 */
cljs.core.merge = (function cljs$core$merge(var_args){
var args__7658__auto__ = [];
var len__7651__auto___44229 = arguments.length;
var i__7652__auto___44230 = (0);
while(true){
if((i__7652__auto___44230 < len__7651__auto___44229)){
args__7658__auto__.push((arguments[i__7652__auto___44230]));

var G__44231 = (i__7652__auto___44230 + (1));
i__7652__auto___44230 = G__44231;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic = (function (maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__44226_SHARP_,p2__44227_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__6543__auto__ = p1__44226_SHARP_;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),p2__44227_SHARP_);
}),maps);
} else {
return null;
}
});

cljs.core.merge.cljs$lang$maxFixedArity = (0);

cljs.core.merge.cljs$lang$applyTo = (function (seq44228){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44228));
});

/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 *   the first.  If a key occurs in more than one map, the mapping(s)
 *   from the latter (left-to-right) will be combined with the mapping in
 *   the result by calling (f val-in-result val-in-latter).
 */
cljs.core.merge_with = (function cljs$core$merge_with(var_args){
var args__7658__auto__ = [];
var len__7651__auto___44236 = arguments.length;
var i__7652__auto___44237 = (0);
while(true){
if((i__7652__auto___44237 < len__7651__auto___44236)){
args__7658__auto__.push((arguments[i__7652__auto___44237]));

var G__44238 = (i__7652__auto___44237 + (1));
i__7652__auto___44237 = G__44238;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic = (function (f,maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.first(e);
var v = cljs.core.second(e);
if(cljs.core.contains_QMARK_(m,k)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__44234 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__44235 = v;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__44234,G__44235) : f.call(null,G__44234,G__44235));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
var merge2 = ((function (merge_entry){
return (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry,(function (){var or__6543__auto__ = m1;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq(m2));
});})(merge_entry))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2,maps);
} else {
return null;
}
});

cljs.core.merge_with.cljs$lang$maxFixedArity = (1);

cljs.core.merge_with.cljs$lang$applyTo = (function (seq44232){
var G__44233 = cljs.core.first(seq44232);
var seq44232__$1 = cljs.core.next(seq44232);
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(G__44233,seq44232__$1);
});

/**
 * Returns a map containing only those entries in map whose key is in keys
 */
cljs.core.select_keys = (function cljs$core$select_keys(map,keyseq){
var ret = cljs.core.PersistentArrayMap.EMPTY;
var keys = cljs.core.seq(keyseq);
while(true){
if(keys){
var key = cljs.core.first(keys);
var entry = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map,key,cljs.core.cst$kw$cljs$core_SLASH_not_DASH_found);
var G__44239 = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(entry,cljs.core.cst$kw$cljs$core_SLASH_not_DASH_found))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,key,entry):ret);
var G__44240 = cljs.core.next(keys);
ret = G__44239;
keys = G__44240;
continue;
} else {
return cljs.core.with_meta(ret,cljs.core.meta(map));
}
break;
}
});

/**
* @constructor
*/
cljs.core.HashSetIter = (function (iter){
this.iter = iter;
})
cljs.core.HashSetIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return self__.iter.hasNext();
});

cljs.core.HashSetIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if(self__.iter.hasNext()){
return (self__.iter.next().tail[(0)]);
} else {
throw (new Error("No such element"));
}
});

cljs.core.HashSetIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.HashSetIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iter], null);
});

cljs.core.HashSetIter.cljs$lang$type = true;

cljs.core.HashSetIter.cljs$lang$ctorStr = "cljs.core/HashSetIter";

cljs.core.HashSetIter.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/HashSetIter");
});

cljs.core.__GT_HashSetIter = (function cljs$core$__GT_HashSetIter(iter){
return (new cljs.core.HashSetIter(iter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.ISet}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashSet = (function (meta,hash_map,__hash){
this.meta = meta;
this.hash_map = hash_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 15077647;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__44243 = cljs.core.seq(coll);
var chunk__44244 = null;
var count__44245 = (0);
var i__44246 = (0);
while(true){
if((i__44246 < count__44245)){
var vec__44247 = chunk__44244.cljs$core$IIndexed$_nth$arity$2(null,i__44246);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44247,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44247,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__44253 = seq__44243;
var G__44254 = chunk__44244;
var G__44255 = count__44245;
var G__44256 = (i__44246 + (1));
seq__44243 = G__44253;
chunk__44244 = G__44254;
count__44245 = G__44255;
i__44246 = G__44256;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__44243);
if(temp__4657__auto__){
var seq__44243__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__44243__$1)){
var c__7357__auto__ = cljs.core.chunk_first(seq__44243__$1);
var G__44257 = cljs.core.chunk_rest(seq__44243__$1);
var G__44258 = c__7357__auto__;
var G__44259 = cljs.core.count(c__7357__auto__);
var G__44260 = (0);
seq__44243 = G__44257;
chunk__44244 = G__44258;
count__44245 = G__44259;
i__44246 = G__44260;
continue;
} else {
var vec__44250 = cljs.core.first(seq__44243__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44250,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44250,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__44261 = cljs.core.next(seq__44243__$1);
var G__44262 = null;
var G__44263 = (0);
var G__44264 = (0);
seq__44243 = G__44261;
chunk__44244 = G__44262;
count__44245 = G__44263;
i__44246 = G__44264;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
if(cljs.core._contains_key_QMARK_(self__.hash_map,v)){
return v;
} else {
return not_found;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentHashSet.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.HashSetIter(cljs.core._iterator(self__.hash_map)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._count(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__44241_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__44241_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashSet(cljs.core._as_transient(self__.hash_map)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentHashSet.EMPTY,self__.meta);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core._dissoc(self__.hash_map,v),null));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(meta__$1,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.hash_map,o,null),null));
});

cljs.core.PersistentHashSet.prototype.call = (function() {
var G__44265 = null;
var G__44265__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__44265__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__44265 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__44265__2.call(this,self__,k);
case 3:
return G__44265__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44265.cljs$core$IFn$_invoke$arity$2 = G__44265__2;
G__44265.cljs$core$IFn$_invoke$arity$3 = G__44265__3;
return G__44265;
})()
;

cljs.core.PersistentHashSet.prototype.apply = (function (self__,args44242){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args44242)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$hash_DASH_map,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentHashSet.cljs$lang$type = true;

cljs.core.PersistentHashSet.cljs$lang$ctorStr = "cljs.core/PersistentHashSet";

cljs.core.PersistentHashSet.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentHashSet");
});

cljs.core.__GT_PersistentHashSet = (function cljs$core$__GT_PersistentHashSet(meta,hash_map,__hash){
return (new cljs.core.PersistentHashSet(meta,hash_map,__hash));
});

cljs.core.PersistentHashSet.EMPTY = (new cljs.core.PersistentHashSet(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashSet.fromArray = (function (items,no_clone){
var len = items.length;
if((len <= cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr = ((no_clone)?items:cljs.core.aclone(items));
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__44266 = (i + (1));
var G__44267 = cljs.core._assoc_BANG_(out,(items[i]),null);
i = G__44266;
out = G__44267;
continue;
} else {
return (new cljs.core.PersistentHashSet(null,cljs.core._persistent_BANG_(out),null));
}
break;
}
} else {
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < len)){
var G__44268 = (i + (1));
var G__44269 = cljs.core._conj_BANG_(out,(items[i]));
i = G__44268;
out = G__44269;
continue;
} else {
return cljs.core._persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentHashSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ITransientSet}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientHashSet = (function (transient_map){
this.transient_map = transient_map;
this.cljs$lang$protocol_mask$partition1$ = 136;
this.cljs$lang$protocol_mask$partition0$ = 259;
})
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(self__.transient_map,o,null);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return (new cljs.core.PersistentHashSet(null,cljs.core.persistent_BANG_(self__.transient_map),null));
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(self__.transient_map,v);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return cljs.core.count(self__.transient_map);
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,v,null);
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,v,not_found){
var self__ = this;
var tcoll__$1 = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return v;
}
});

cljs.core.TransientHashSet.prototype.call = (function() {
var G__44271 = null;
var G__44271__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});
var G__44271__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});
G__44271 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__44271__2.call(this,self__,k);
case 3:
return G__44271__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44271.cljs$core$IFn$_invoke$arity$2 = G__44271__2;
G__44271.cljs$core$IFn$_invoke$arity$3 = G__44271__3;
return G__44271;
})()
;

cljs.core.TransientHashSet.prototype.apply = (function (self__,args44270){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args44270)));
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});

cljs.core.TransientHashSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$transient_DASH_map,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.TransientHashSet.cljs$lang$type = true;

cljs.core.TransientHashSet.cljs$lang$ctorStr = "cljs.core/TransientHashSet";

cljs.core.TransientHashSet.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/TransientHashSet");
});

cljs.core.__GT_TransientHashSet = (function cljs$core$__GT_TransientHashSet(transient_map){
return (new cljs.core.TransientHashSet(transient_map));
});


/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ISet}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentTreeSet = (function (meta,tree_map,__hash){
this.meta = meta;
this.tree_map = tree_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 417730831;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__44274 = cljs.core.seq(coll);
var chunk__44275 = null;
var count__44276 = (0);
var i__44277 = (0);
while(true){
if((i__44277 < count__44276)){
var vec__44278 = chunk__44275.cljs$core$IIndexed$_nth$arity$2(null,i__44277);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44278,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44278,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__44284 = seq__44274;
var G__44285 = chunk__44275;
var G__44286 = count__44276;
var G__44287 = (i__44277 + (1));
seq__44274 = G__44284;
chunk__44275 = G__44285;
count__44276 = G__44286;
i__44277 = G__44287;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__44274);
if(temp__4657__auto__){
var seq__44274__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__44274__$1)){
var c__7357__auto__ = cljs.core.chunk_first(seq__44274__$1);
var G__44288 = cljs.core.chunk_rest(seq__44274__$1);
var G__44289 = c__7357__auto__;
var G__44290 = cljs.core.count(c__7357__auto__);
var G__44291 = (0);
seq__44274 = G__44288;
chunk__44275 = G__44289;
count__44276 = G__44290;
i__44277 = G__44291;
continue;
} else {
var vec__44281 = cljs.core.first(seq__44274__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44281,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44281,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__44292 = cljs.core.next(seq__44274__$1);
var G__44293 = null;
var G__44294 = (0);
var G__44295 = (0);
seq__44274 = G__44292;
chunk__44275 = G__44293;
count__44276 = G__44294;
i__44277 = G__44295;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
var n = self__.tree_map.entry_at(v);
if(!((n == null))){
return n.key;
} else {
return not_found;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.count(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.count(self__.tree_map) > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core.rseq(self__.tree_map));
} else {
return null;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__44272_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__44272_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core._empty(self__.tree_map),(0)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.tree_map,v),null));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(meta__$1,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.tree_map,o,null),null));
});

cljs.core.PersistentTreeSet.prototype.call = (function() {
var G__44296 = null;
var G__44296__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__44296__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__44296 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__44296__2.call(this,self__,k);
case 3:
return G__44296__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44296.cljs$core$IFn$_invoke$arity$2 = G__44296__2;
G__44296.cljs$core$IFn$_invoke$arity$3 = G__44296__3;
return G__44296;
})()
;

cljs.core.PersistentTreeSet.prototype.apply = (function (self__,args44273){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args44273)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq(self__.tree_map,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq_from(self__.tree_map,k,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return entry;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._comparator(self__.tree_map);
});

cljs.core.PersistentTreeSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$tree_DASH_map,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentTreeSet.cljs$lang$type = true;

cljs.core.PersistentTreeSet.cljs$lang$ctorStr = "cljs.core/PersistentTreeSet";

cljs.core.PersistentTreeSet.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/PersistentTreeSet");
});

cljs.core.__GT_PersistentTreeSet = (function cljs$core$__GT_PersistentTreeSet(meta,tree_map,__hash){
return (new cljs.core.PersistentTreeSet(meta,tree_map,__hash));
});

cljs.core.PersistentTreeSet.EMPTY = (new cljs.core.PersistentTreeSet(null,cljs.core.PersistentTreeMap.EMPTY,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
cljs.core.set_from_indexed_seq = (function cljs$core$set_from_indexed_seq(iseq){
var arr = iseq.arr;
var ret = (function (){var a__7455__auto__ = arr;
var i = (0);
var res = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < a__7455__auto__.length)){
var G__44297 = (i + (1));
var G__44298 = res.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,(arr[i]));
i = G__44297;
res = G__44298;
continue;
} else {
return res;
}
break;
}
})();
return ret.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
});
/**
 * Returns a set of the distinct elements of coll.
 */
cljs.core.set = (function cljs$core$set(coll){
var in$ = cljs.core.seq(coll);
if((in$ == null)){
return cljs.core.PersistentHashSet.EMPTY;
} else {
if(((in$ instanceof cljs.core.IndexedSeq)) && ((in$.i === (0)))){
return cljs.core.set_from_indexed_seq(in$);
} else {
var in$__$1 = in$;
var out = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if(!((in$__$1 == null))){
var G__44299 = cljs.core.next(in$__$1);
var G__44300 = out.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,in$__$1.cljs$core$ISeq$_first$arity$1(null));
in$__$1 = G__44299;
out = G__44300;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}

}
}
});
/**
 * Returns a new hash set with supplied keys.  Any equal keys are
 *   handled as if by repeated uses of conj.
 */
cljs.core.hash_set = (function cljs$core$hash_set(var_args){
var args44301 = [];
var len__7651__auto___44305 = arguments.length;
var i__7652__auto___44306 = (0);
while(true){
if((i__7652__auto___44306 < len__7651__auto___44305)){
args44301.push((arguments[i__7652__auto___44306]));

var G__44307 = (i__7652__auto___44306 + (1));
i__7652__auto___44306 = G__44307;
continue;
} else {
}
break;
}

var G__44304 = args44301.length;
switch (G__44304) {
case 0:
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args44301.slice((0)),(0),null));
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__7670__auto__);

}
});

cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentHashSet.EMPTY;
});

cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (keys){
return cljs.core.set(keys);
});

cljs.core.hash_set.cljs$lang$applyTo = (function (seq44302){
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44302));
});

cljs.core.hash_set.cljs$lang$maxFixedArity = (0);

/**
 * Returns a new sorted set with supplied keys.
 */
cljs.core.sorted_set = (function cljs$core$sorted_set(var_args){
var args__7658__auto__ = [];
var len__7651__auto___44310 = arguments.length;
var i__7652__auto___44311 = (0);
while(true){
if((i__7652__auto___44311 < len__7651__auto___44310)){
args__7658__auto__.push((arguments[i__7652__auto___44311]));

var G__44312 = (i__7652__auto___44311 + (1));
i__7652__auto___44311 = G__44312;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic = (function (keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,cljs.core.PersistentTreeSet.EMPTY,keys);
});

cljs.core.sorted_set.cljs$lang$maxFixedArity = (0);

cljs.core.sorted_set.cljs$lang$applyTo = (function (seq44309){
return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44309));
});

/**
 * Returns a new sorted set with supplied keys, using the supplied comparator.
 */
cljs.core.sorted_set_by = (function cljs$core$sorted_set_by(var_args){
var args__7658__auto__ = [];
var len__7651__auto___44315 = arguments.length;
var i__7652__auto___44316 = (0);
while(true){
if((i__7652__auto___44316 < len__7651__auto___44315)){
args__7658__auto__.push((arguments[i__7652__auto___44316]));

var G__44317 = (i__7652__auto___44316 + (1));
i__7652__auto___44316 = G__44317;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,(new cljs.core.PersistentTreeSet(null,cljs.core.sorted_map_by(comparator),(0))),keys);
});

cljs.core.sorted_set_by.cljs$lang$maxFixedArity = (1);

cljs.core.sorted_set_by.cljs$lang$applyTo = (function (seq44313){
var G__44314 = cljs.core.first(seq44313);
var seq44313__$1 = cljs.core.next(seq44313);
return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(G__44314,seq44313__$1);
});

/**
 * Given a map of replacement pairs and a vector/collection, returns a
 *   vector/seq with any elements = a key in smap replaced with the
 *   corresponding val in smap.  Returns a transducer when no collection
 *   is provided.
 */
cljs.core.replace = (function cljs$core$replace(var_args){
var args44320 = [];
var len__7651__auto___44323 = arguments.length;
var i__7652__auto___44324 = (0);
while(true){
if((i__7652__auto___44324 < len__7651__auto___44323)){
args44320.push((arguments[i__7652__auto___44324]));

var G__44325 = (i__7652__auto___44324 + (1));
i__7652__auto___44324 = G__44325;
continue;
} else {
}
break;
}

var G__44322 = args44320.length;
switch (G__44322) {
case 1:
return cljs.core.replace.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.replace.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args44320.length)].join('')));

}
});

cljs.core.replace.cljs$core$IFn$_invoke$arity$1 = (function (smap){
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__44318_SHARP_){
var temp__4655__auto__ = cljs.core.find(smap,p1__44318_SHARP_);
if(cljs.core.truth_(temp__4655__auto__)){
var e = temp__4655__auto__;
return cljs.core.val(e);
} else {
return p1__44318_SHARP_;
}
}));
});

cljs.core.replace.cljs$core$IFn$_invoke$arity$2 = (function (smap,coll){
if(cljs.core.vector_QMARK_(coll)){
var n = cljs.core.count(coll);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (n){
return (function (v,i){
var temp__4655__auto__ = cljs.core.find(smap,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(v,i));
if(cljs.core.truth_(temp__4655__auto__)){
var e = temp__4655__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,i,cljs.core.second(e));
} else {
return v;
}
});})(n))
,coll,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.iterate(cljs.core.inc,(0))));
} else {
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__44319_SHARP_){
var temp__4655__auto__ = cljs.core.find(smap,p1__44319_SHARP_);
if(cljs.core.truth_(temp__4655__auto__)){
var e = temp__4655__auto__;
return cljs.core.second(e);
} else {
return p1__44319_SHARP_;
}
}),coll);
}
});

cljs.core.replace.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence of the elements of coll with duplicates removed.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.distinct = (function cljs$core$distinct(var_args){
var args44327 = [];
var len__7651__auto___44340 = arguments.length;
var i__7652__auto___44341 = (0);
while(true){
if((i__7652__auto___44341 < len__7651__auto___44340)){
args44327.push((arguments[i__7652__auto___44341]));

var G__44342 = (i__7652__auto___44341 + (1));
i__7652__auto___44341 = G__44342;
continue;
} else {
}
break;
}

var G__44329 = args44327.length;
switch (G__44329) {
case 0:
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args44327.length)].join('')));

}
});

cljs.core.distinct.cljs$core$IFn$_invoke$arity$0 = (function (){
return (function (rf){
var seen = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
return ((function (seen){
return (function() {
var G__44344 = null;
var G__44344__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__44344__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__44344__2 = (function (result,input){
if(cljs.core.contains_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(seen) : cljs.core.deref.call(null,seen)),input)){
return result;
} else {
cljs.core._vreset_BANG_(seen,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core._deref(seen),input));

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__44344 = function(result,input){
switch(arguments.length){
case 0:
return G__44344__0.call(this);
case 1:
return G__44344__1.call(this,result);
case 2:
return G__44344__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44344.cljs$core$IFn$_invoke$arity$0 = G__44344__0;
G__44344.cljs$core$IFn$_invoke$arity$1 = G__44344__1;
G__44344.cljs$core$IFn$_invoke$arity$2 = G__44344__2;
return G__44344;
})()
;})(seen))
});
});

cljs.core.distinct.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var step = (function cljs$core$step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
return (function (p__44336,seen__$1){
while(true){
var vec__44337 = p__44336;
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44337,(0),null);
var xs__$1 = vec__44337;
var temp__4657__auto__ = cljs.core.seq(xs__$1);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.contains_QMARK_(seen__$1,f)){
var G__44345 = cljs.core.rest(s);
var G__44346 = seen__$1;
p__44336 = G__44345;
seen__$1 = G__44346;
continue;
} else {
return cljs.core.cons(f,cljs$core$step(cljs.core.rest(s),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1,f)));
}
} else {
return null;
}
break;
}
}).call(null,xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
});

cljs.core.distinct.cljs$lang$maxFixedArity = 1;

/**
 * Return a seq of all but the last item in coll, in linear time
 */
cljs.core.butlast = (function cljs$core$butlast(s){
var ret = cljs.core.PersistentVector.EMPTY;
var s__$1 = s;
while(true){
if(cljs.core.next(s__$1)){
var G__44347 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,cljs.core.first(s__$1));
var G__44348 = cljs.core.next(s__$1);
ret = G__44347;
s__$1 = G__44348;
continue;
} else {
return cljs.core.seq(ret);
}
break;
}
});
/**
 * Returns the name String of a string, symbol or keyword.
 */
cljs.core.name = (function cljs$core$name(x){
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition1$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$INamed$)))?true:false):false)){
return x.cljs$core$INamed$_name$arity$1(null);
} else {
if(typeof x === 'string'){
return x;
} else {
throw (new Error([cljs.core.str("Doesn't support name: "),cljs.core.str(x)].join('')));
}
}
});
/**
 * Returns a map with the keys mapped to the corresponding vals.
 */
cljs.core.zipmap = (function cljs$core$zipmap(keys,vals){
var map = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var ks = cljs.core.seq(keys);
var vs = cljs.core.seq(vals);
while(true){
if((ks) && (vs)){
var G__44351 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(map,cljs.core.first(ks),cljs.core.first(vs));
var G__44352 = cljs.core.next(ks);
var G__44353 = cljs.core.next(vs);
map = G__44351;
ks = G__44352;
vs = G__44353;
continue;
} else {
return cljs.core.persistent_BANG_(map);
}
break;
}
});
/**
 * Returns the x for which (k x), a number, is greatest.
 */
cljs.core.max_key = (function cljs$core$max_key(var_args){
var args44356 = [];
var len__7651__auto___44363 = arguments.length;
var i__7652__auto___44364 = (0);
while(true){
if((i__7652__auto___44364 < len__7651__auto___44363)){
args44356.push((arguments[i__7652__auto___44364]));

var G__44365 = (i__7652__auto___44364 + (1));
i__7652__auto___44364 = G__44365;
continue;
} else {
}
break;
}

var G__44362 = args44356.length;
switch (G__44362) {
case 2:
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args44356.slice((3)),(0),null));
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7670__auto__);

}
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$2 = (function (k,x){
return x;
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$3 = (function (k,x,y){
if(((k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(x) : k.call(null,x)) > (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(y) : k.call(null,y)))){
return x;
} else {
return y;
}
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic = (function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__44354_SHARP_,p2__44355_SHARP_){
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k,p1__44354_SHARP_,p2__44355_SHARP_);
}),cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
});

cljs.core.max_key.cljs$lang$applyTo = (function (seq44357){
var G__44358 = cljs.core.first(seq44357);
var seq44357__$1 = cljs.core.next(seq44357);
var G__44359 = cljs.core.first(seq44357__$1);
var seq44357__$2 = cljs.core.next(seq44357__$1);
var G__44360 = cljs.core.first(seq44357__$2);
var seq44357__$3 = cljs.core.next(seq44357__$2);
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic(G__44358,G__44359,G__44360,seq44357__$3);
});

cljs.core.max_key.cljs$lang$maxFixedArity = (3);

/**
 * Returns the x for which (k x), a number, is least.
 */
cljs.core.min_key = (function cljs$core$min_key(var_args){
var args44369 = [];
var len__7651__auto___44376 = arguments.length;
var i__7652__auto___44377 = (0);
while(true){
if((i__7652__auto___44377 < len__7651__auto___44376)){
args44369.push((arguments[i__7652__auto___44377]));

var G__44378 = (i__7652__auto___44377 + (1));
i__7652__auto___44377 = G__44378;
continue;
} else {
}
break;
}

var G__44375 = args44369.length;
switch (G__44375) {
case 2:
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args44369.slice((3)),(0),null));
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7670__auto__);

}
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$2 = (function (k,x){
return x;
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$3 = (function (k,x,y){
if(((k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(x) : k.call(null,x)) < (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(y) : k.call(null,y)))){
return x;
} else {
return y;
}
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic = (function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__44367_SHARP_,p2__44368_SHARP_){
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k,p1__44367_SHARP_,p2__44368_SHARP_);
}),cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
});

cljs.core.min_key.cljs$lang$applyTo = (function (seq44370){
var G__44371 = cljs.core.first(seq44370);
var seq44370__$1 = cljs.core.next(seq44370);
var G__44372 = cljs.core.first(seq44370__$1);
var seq44370__$2 = cljs.core.next(seq44370__$1);
var G__44373 = cljs.core.first(seq44370__$2);
var seq44370__$3 = cljs.core.next(seq44370__$2);
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic(G__44371,G__44372,G__44373,seq44370__$3);
});

cljs.core.min_key.cljs$lang$maxFixedArity = (3);


/**
* @constructor
*/
cljs.core.ArrayList = (function (arr){
this.arr = arr;
})
cljs.core.ArrayList.prototype.add = (function (x){
var self__ = this;
var _ = this;
return self__.arr.push(x);
});

cljs.core.ArrayList.prototype.size = (function (){
var self__ = this;
var _ = this;
return self__.arr.length;
});

cljs.core.ArrayList.prototype.clear = (function (){
var self__ = this;
var _ = this;
return self__.arr = [];
});

cljs.core.ArrayList.prototype.isEmpty = (function (){
var self__ = this;
var _ = this;
return (self__.arr.length === (0));
});

cljs.core.ArrayList.prototype.toArray = (function (){
var self__ = this;
var _ = this;
return self__.arr;
});

cljs.core.ArrayList.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayList.cljs$lang$type = true;

cljs.core.ArrayList.cljs$lang$ctorStr = "cljs.core/ArrayList";

cljs.core.ArrayList.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/ArrayList");
});

cljs.core.__GT_ArrayList = (function cljs$core$__GT_ArrayList(arr){
return (new cljs.core.ArrayList(arr));
});

cljs.core.array_list = (function cljs$core$array_list(){
return (new cljs.core.ArrayList([]));
});
/**
 * Returns a lazy sequence of lists like partition, but may include
 *   partitions with fewer than n items at the end.  Returns a stateful
 *   transducer when no collection is provided.
 */
cljs.core.partition_all = (function cljs$core$partition_all(var_args){
var args44380 = [];
var len__7651__auto___44383 = arguments.length;
var i__7652__auto___44384 = (0);
while(true){
if((i__7652__auto___44384 < len__7651__auto___44383)){
args44380.push((arguments[i__7652__auto___44384]));

var G__44385 = (i__7652__auto___44384 + (1));
i__7652__auto___44384 = G__44385;
continue;
} else {
}
break;
}

var G__44382 = args44380.length;
switch (G__44382) {
case 1:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args44380.length)].join('')));

}
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1 = (function (n){
return (function (rf){
var a = cljs.core.array_list();
return ((function (a){
return (function() {
var G__44387 = null;
var G__44387__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__44387__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v)));
})());
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result__$1) : rf.call(null,result__$1));
});
var G__44387__2 = (function (result,input){
a.add(input);

if((n === a.size())){
var v = cljs.core.vec(a.toArray());
a.clear();

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
} else {
return result;
}
});
G__44387 = function(result,input){
switch(arguments.length){
case 0:
return G__44387__0.call(this);
case 1:
return G__44387__1.call(this,result);
case 2:
return G__44387__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44387.cljs$core$IFn$_invoke$arity$0 = G__44387__0;
G__44387.cljs$core$IFn$_invoke$arity$1 = G__44387__1;
G__44387.cljs$core$IFn$_invoke$arity$2 = G__44387__2;
return G__44387;
})()
;})(a))
});
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
return cljs.core.cons(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s),cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
}),null,null));
});

cljs.core.partition_all.cljs$lang$maxFixedArity = 3;

/**
 * Returns a lazy sequence of successive items from coll while
 *   (pred item) returns true. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.take_while = (function cljs$core$take_while(var_args){
var args44388 = [];
var len__7651__auto___44392 = arguments.length;
var i__7652__auto___44393 = (0);
while(true){
if((i__7652__auto___44393 < len__7651__auto___44392)){
args44388.push((arguments[i__7652__auto___44393]));

var G__44394 = (i__7652__auto___44393 + (1));
i__7652__auto___44393 = G__44394;
continue;
} else {
}
break;
}

var G__44390 = args44388.length;
switch (G__44390) {
case 1:
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args44388.length)].join('')));

}
});

cljs.core.take_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
return (function() {
var G__44396 = null;
var G__44396__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__44396__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__44396__2 = (function (result,input){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input)))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return cljs.core.reduced(result);
}
});
G__44396 = function(result,input){
switch(arguments.length){
case 0:
return G__44396__0.call(this);
case 1:
return G__44396__1.call(this,result);
case 2:
return G__44396__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44396.cljs$core$IFn$_invoke$arity$0 = G__44396__0;
G__44396.cljs$core$IFn$_invoke$arity$1 = G__44396__1;
G__44396.cljs$core$IFn$_invoke$arity$2 = G__44396__2;
return G__44396;
})()
});
});

cljs.core.take_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.truth_((function (){var G__44391 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__44391) : pred.call(null,G__44391));
})())){
return cljs.core.cons(cljs.core.first(s),cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.take_while.cljs$lang$maxFixedArity = 2;

cljs.core.mk_bound_fn = (function cljs$core$mk_bound_fn(sc,test,key){
return (function (e){
var comp = cljs.core._comparator(sc);
var G__44401 = (function (){var G__44403 = cljs.core._entry_key(sc,e);
var G__44404 = key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__44403,G__44404) : comp.call(null,G__44403,G__44404));
})();
var G__44402 = (0);
return (test.cljs$core$IFn$_invoke$arity$2 ? test.cljs$core$IFn$_invoke$arity$2(G__44401,G__44402) : test.call(null,G__44401,G__44402));
});
});
/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 *   >=. Returns a seq of those entries with keys ek for
 *   which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.subseq = (function cljs$core$subseq(var_args){
var args44405 = [];
var len__7651__auto___44414 = arguments.length;
var i__7652__auto___44415 = (0);
while(true){
if((i__7652__auto___44415 < len__7651__auto___44414)){
args44405.push((arguments[i__7652__auto___44415]));

var G__44416 = (i__7652__auto___44415 + (1));
i__7652__auto___44415 = G__44416;
continue;
} else {
}
break;
}

var G__44407 = args44405.length;
switch (G__44407) {
case 3:
return cljs.core.subseq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.subseq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args44405.length)].join('')));

}
});

cljs.core.subseq.cljs$core$IFn$_invoke$arity$3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._GT_,cljs.core._GT__EQ_], true).call(null,test))){
var temp__4657__auto__ = cljs.core._sorted_seq_from(sc,key,true);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__44408 = temp__4657__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44408,(0),null);
var s = vec__44408;
if(cljs.core.truth_((include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(e) : include.call(null,e)))){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,true));
}
});

cljs.core.subseq.cljs$core$IFn$_invoke$arity$5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4657__auto__ = cljs.core._sorted_seq_from(sc,start_key,true);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__44411 = temp__4657__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44411,(0),null);
var s = vec__44411;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,end_test,end_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,start_test,start_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});

cljs.core.subseq.cljs$lang$maxFixedArity = 5;

/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 *   >=. Returns a reverse seq of those entries with keys ek for
 *   which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.rsubseq = (function cljs$core$rsubseq(var_args){
var args44418 = [];
var len__7651__auto___44427 = arguments.length;
var i__7652__auto___44428 = (0);
while(true){
if((i__7652__auto___44428 < len__7651__auto___44427)){
args44418.push((arguments[i__7652__auto___44428]));

var G__44429 = (i__7652__auto___44428 + (1));
i__7652__auto___44428 = G__44429;
continue;
} else {
}
break;
}

var G__44420 = args44418.length;
switch (G__44420) {
case 3:
return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args44418.length)].join('')));

}
});

cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._LT_,cljs.core._LT__EQ_], true).call(null,test))){
var temp__4657__auto__ = cljs.core._sorted_seq_from(sc,key,false);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__44421 = temp__4657__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44421,(0),null);
var s = vec__44421;
if(cljs.core.truth_((include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(e) : include.call(null,e)))){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,false));
}
});

cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4657__auto__ = cljs.core._sorted_seq_from(sc,end_key,false);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__44424 = temp__4657__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44424,(0),null);
var s = vec__44424;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,start_test,start_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,end_test,end_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});

cljs.core.rsubseq.cljs$lang$maxFixedArity = 5;


/**
* @constructor
*/
cljs.core.RangeIterator = (function (i,end,step){
this.i = i;
this.end = end;
this.step = step;
})
cljs.core.RangeIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__.step > (0))){
return (self__.i < self__.end);
} else {
return (self__.i > self__.end);
}
});

cljs.core.RangeIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.i;
self__.i = (self__.i + self__.step);

return ret;
});

cljs.core.RangeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$end,cljs.core.cst$sym$step], null);
});

cljs.core.RangeIterator.cljs$lang$type = true;

cljs.core.RangeIterator.cljs$lang$ctorStr = "cljs.core/RangeIterator";

cljs.core.RangeIterator.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/RangeIterator");
});

cljs.core.__GT_RangeIterator = (function cljs$core$__GT_RangeIterator(i,end,step){
return (new cljs.core.RangeIterator(i,end,step));
});


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Range = (function (meta,start,end,step,__hash){
this.meta = meta;
this.start = start;
this.end = end;
this.step = step;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375006;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Range.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Range.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Range.prototype.indexOf = (function() {
var G__44432 = null;
var G__44432__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__44432__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
G__44432 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__44432__1.call(this,x);
case 2:
return G__44432__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44432.cljs$core$IFn$_invoke$arity$1 = G__44432__1;
G__44432.cljs$core$IFn$_invoke$arity$2 = G__44432__2;
return G__44432;
})()
;

cljs.core.Range.prototype.lastIndexOf = (function() {
var G__44433 = null;
var G__44433__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__44433__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
G__44433 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__44433__1.call(this,x);
case 2:
return G__44433__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44433.cljs$core$IFn$_invoke$arity$1 = G__44433__1;
G__44433.cljs$core$IFn$_invoke$arity$2 = G__44433__2;
return G__44433;
})()
;

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (rng,n){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
throw (new Error("Index out of bounds"));
}
}
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (rng,n,not_found){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
return not_found;
}
}
});

cljs.core.Range.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Range.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RangeIterator(self__.start,self__.end,self__.step));
});

cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return self__.meta;
});

cljs.core.Range.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Range(self__.meta,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$INext$_next$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if(((self__.start + self__.step) < self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
} else {
if(((self__.start + self__.step) > self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
}
});

cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(cljs.core.not(cljs.core._seq(rng__$1))){
return (0);
} else {
var G__44431 = ((self__.end - self__.start) / self__.step);
return Math.ceil(G__44431);
}
});

cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
var h__6978__auto__ = self__.__hash;
if(!((h__6978__auto__ == null))){
return h__6978__auto__;
} else {
var h__6978__auto____$1 = cljs.core.hash_ordered_coll(rng__$1);
self__.__hash = h__6978__auto____$1;

return h__6978__auto____$1;
}
});

cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (rng,other){
var self__ = this;
var rng__$1 = this;
return cljs.core.equiv_sequential(rng__$1,other);
});

cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (rng,f){
var self__ = this;
var rng__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(rng__$1,f);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (rng,f,init){
var self__ = this;
var rng__$1 = this;
var i = self__.start;
var ret = init;
while(true){
if((((self__.step > (0)))?(i < self__.end):(i > self__.end))){
var ret__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,i) : f.call(null,ret,i));
if(cljs.core.reduced_QMARK_(ret__$1)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret__$1) : cljs.core.deref.call(null,ret__$1));
} else {
var G__44434 = (i + self__.step);
var G__44435 = ret__$1;
i = G__44434;
ret = G__44435;
continue;
}
} else {
return ret;
}
break;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((cljs.core._seq(rng__$1) == null)){
return null;
} else {
return self__.start;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(!((cljs.core._seq(rng__$1) == null))){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if((self__.start < self__.end)){
return rng__$1;
} else {
return null;
}
} else {
if((self__.step < (0))){
if((self__.start > self__.end)){
return rng__$1;
} else {
return null;
}
} else {
if((self__.start === self__.end)){
return null;
} else {
return rng__$1;
}

}
}
});

cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (rng,meta__$1){
var self__ = this;
var rng__$1 = this;
return (new cljs.core.Range(meta__$1,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = (function (rng,o){
var self__ = this;
var rng__$1 = this;
return cljs.core.cons(o,rng__$1);
});

cljs.core.Range.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.cst$sym$step,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Range.cljs$lang$type = true;

cljs.core.Range.cljs$lang$ctorStr = "cljs.core/Range";

cljs.core.Range.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core/Range");
});

cljs.core.__GT_Range = (function cljs$core$__GT_Range(meta,start,end,step,__hash){
return (new cljs.core.Range(meta,start,end,step,__hash));
});

(cljs.core.Range.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7552__auto__ = this;
return cljs.core.es6_iterator(this__7552__auto__);
}));
/**
 * Returns a lazy seq of nums from start (inclusive) to end
 * (exclusive), by step, where start defaults to 0, step to 1,
 * and end to infinity.
 */
cljs.core.range = (function cljs$core$range(var_args){
var args44436 = [];
var len__7651__auto___44439 = arguments.length;
var i__7652__auto___44440 = (0);
while(true){
if((i__7652__auto___44440 < len__7651__auto___44439)){
args44436.push((arguments[i__7652__auto___44440]));

var G__44441 = (i__7652__auto___44440 + (1));
i__7652__auto___44440 = G__44441;
continue;
} else {
}
break;
}

var G__44438 = args44436.length;
switch (G__44438) {
case 0:
return cljs.core.range.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.range.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args44436.length)].join('')));

}
});

cljs.core.range.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((0),Number.MAX_VALUE,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$1 = (function (end){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((0),end,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$2 = (function (start,end){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3(start,end,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$3 = (function (start,end,step){
return (new cljs.core.Range(null,start,end,step,null));
});

cljs.core.range.cljs$lang$maxFixedArity = 3;

/**
 * Returns a lazy seq of every nth item in coll.  Returns a stateful
 *   transducer when no collection is provided.
 */
cljs.core.take_nth = (function cljs$core$take_nth(var_args){
var args44443 = [];
var len__7651__auto___44446 = arguments.length;
var i__7652__auto___44447 = (0);
while(true){
if((i__7652__auto___44447 < len__7651__auto___44446)){
args44443.push((arguments[i__7652__auto___44447]));

var G__44448 = (i__7652__auto___44447 + (1));
i__7652__auto___44447 = G__44448;
continue;
} else {
}
break;
}

var G__44445 = args44443.length;
switch (G__44445) {
case 1:
return cljs.core.take_nth.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args44443.length)].join('')));

}
});

cljs.core.take_nth.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__44450 = null;
var G__44450__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__44450__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__44450__2 = (function (result,input){
var i = cljs.core._vreset_BANG_(ia,(cljs.core._deref(ia) + (1)));
if((cljs.core.rem(i,n) === (0))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return result;
}
});
G__44450 = function(result,input){
switch(arguments.length){
case 0:
return G__44450__0.call(this);
case 1:
return G__44450__1.call(this,result);
case 2:
return G__44450__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44450.cljs$core$IFn$_invoke$arity$0 = G__44450__0;
G__44450.cljs$core$IFn$_invoke$arity$1 = G__44450__1;
G__44450.cljs$core$IFn$_invoke$arity$2 = G__44450__2;
return G__44450;
})()
;})(ia))
});
});

cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2(n,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s)));
} else {
return null;
}
}),null,null));
});

cljs.core.take_nth.cljs$lang$maxFixedArity = 2;

/**
 * Returns a vector of [(take-while pred coll) (drop-while pred coll)]
 */
cljs.core.split_with = (function cljs$core$split_with(pred,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred,coll),cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(pred,coll)], null);
});
/**
 * Applies f to each value in coll, splitting it each time f returns a
 * new value.  Returns a lazy seq of partitions.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.partition_by = (function cljs$core$partition_by(var_args){
var args44452 = [];
var len__7651__auto___44455 = arguments.length;
var i__7652__auto___44456 = (0);
while(true){
if((i__7652__auto___44456 < len__7651__auto___44455)){
args44452.push((arguments[i__7652__auto___44456]));

var G__44457 = (i__7652__auto___44456 + (1));
i__7652__auto___44456 = G__44457;
continue;
} else {
}
break;
}

var G__44454 = args44452.length;
switch (G__44454) {
case 1:
return cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args44452.length)].join('')));

}
});

cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var a = cljs.core.array_list();
var pa = cljs.core.volatile_BANG_(cljs.core.cst$kw$cljs$core_SLASH_none);
return ((function (a,pa){
return (function() {
var G__44459 = null;
var G__44459__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__44459__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v)));
})());
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result__$1) : rf.call(null,result__$1));
});
var G__44459__2 = (function (result,input){
var pval = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(pa) : cljs.core.deref.call(null,pa));
var val = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
cljs.core.vreset_BANG_(pa,val);

if((cljs.core.keyword_identical_QMARK_(pval,cljs.core.cst$kw$cljs$core_SLASH_none)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,pval))){
a.add(input);

return result;
} else {
var v = cljs.core.vec(a.toArray());
a.clear();

var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
if(cljs.core.reduced_QMARK_(ret)){
} else {
a.add(input);
}

return ret;
}
});
G__44459 = function(result,input){
switch(arguments.length){
case 0:
return G__44459__0.call(this);
case 1:
return G__44459__1.call(this,result);
case 2:
return G__44459__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44459.cljs$core$IFn$_invoke$arity$0 = G__44459__0;
G__44459.cljs$core$IFn$_invoke$arity$1 = G__44459__1;
G__44459.cljs$core$IFn$_invoke$arity$2 = G__44459__2;
return G__44459;
})()
;})(a,pa))
});
});

cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
var fst = cljs.core.first(s);
var fv = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(fst) : f.call(null,fst));
var run = cljs.core.cons(fst,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (fst,fv,s,temp__4657__auto__){
return (function (p1__44451_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fv,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(p1__44451_SHARP_) : f.call(null,p1__44451_SHARP_)));
});})(fst,fv,s,temp__4657__auto__))
,cljs.core.next(s)));
return cljs.core.cons(run,cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(cljs.core.count(run),s))));
} else {
return null;
}
}),null,null));
});

cljs.core.partition_by.cljs$lang$maxFixedArity = 2;

/**
 * Returns a map from distinct items in coll to the number of times
 *   they appear.
 */
cljs.core.frequencies = (function cljs$core$frequencies(coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (counts,x){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(counts,x,(cljs.core.get.cljs$core$IFn$_invoke$arity$3(counts,x,(0)) + (1)));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Returns a lazy seq of the intermediate values of the reduction (as
 *   per reduce) of coll by f, starting with init.
 */
cljs.core.reductions = (function cljs$core$reductions(var_args){
var args44460 = [];
var len__7651__auto___44465 = arguments.length;
var i__7652__auto___44466 = (0);
while(true){
if((i__7652__auto___44466 < len__7651__auto___44465)){
args44460.push((arguments[i__7652__auto___44466]));

var G__44467 = (i__7652__auto___44466 + (1));
i__7652__auto___44466 = G__44467;
continue;
} else {
}
break;
}

var G__44462 = args44460.length;
switch (G__44462) {
case 2:
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args44460.length)].join('')));

}
});

cljs.core.reductions.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4655__auto__ = cljs.core.seq(coll);
if(temp__4655__auto__){
var s = temp__4655__auto__;
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3(f,cljs.core.first(s),cljs.core.rest(s));
} else {
var x__7380__auto__ = (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
return cljs.core._conj(cljs.core.List.EMPTY,x__7380__auto__);
}
}),null,null));
});

cljs.core.reductions.cljs$core$IFn$_invoke$arity$3 = (function (f,init,coll){
if(cljs.core.reduced_QMARK_(init)){
var x__7380__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init) : cljs.core.deref.call(null,init));
return cljs.core._conj(cljs.core.List.EMPTY,x__7380__auto__);
} else {
return cljs.core.cons(init,(new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3(f,(function (){var G__44463 = init;
var G__44464 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__44463,G__44464) : f.call(null,G__44463,G__44464));
})(),cljs.core.rest(s));
} else {
return null;
}
}),null,null)));
}
});

cljs.core.reductions.cljs$lang$maxFixedArity = 3;

/**
 * Takes a set of functions and returns a fn that is the juxtaposition
 *   of those fns.  The returned fn takes a variable number of args, and
 *   returns a vector containing the result of applying each fn to the
 *   args (left-to-right).
 *   ((juxt a b c) x) => [(a x) (b x) (c x)]
 */
cljs.core.juxt = (function cljs$core$juxt(var_args){
var args44479 = [];
var len__7651__auto___44486 = arguments.length;
var i__7652__auto___44487 = (0);
while(true){
if((i__7652__auto___44487 < len__7651__auto___44486)){
args44479.push((arguments[i__7652__auto___44487]));

var G__44488 = (i__7652__auto___44487 + (1));
i__7652__auto___44487 = G__44488;
continue;
} else {
}
break;
}

var G__44485 = args44479.length;
switch (G__44485) {
case 1:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args44479.slice((3)),(0),null));
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7670__auto__);

}
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function() {
var G__44490 = null;
var G__44490__0 = (function (){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null))],null));
});
var G__44490__1 = (function (x){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x))],null));
});
var G__44490__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y))],null));
});
var G__44490__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(x,y,z) : f.call(null,x,y,z))],null));
});
var G__44490__4 = (function() { 
var G__44491__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args)],null));
};
var G__44491 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__44492__i = 0, G__44492__a = new Array(arguments.length -  3);
while (G__44492__i < G__44492__a.length) {G__44492__a[G__44492__i] = arguments[G__44492__i + 3]; ++G__44492__i;}
  args = new cljs.core.IndexedSeq(G__44492__a,0);
} 
return G__44491__delegate.call(this,x,y,z,args);};
G__44491.cljs$lang$maxFixedArity = 3;
G__44491.cljs$lang$applyTo = (function (arglist__44493){
var x = cljs.core.first(arglist__44493);
arglist__44493 = cljs.core.next(arglist__44493);
var y = cljs.core.first(arglist__44493);
arglist__44493 = cljs.core.next(arglist__44493);
var z = cljs.core.first(arglist__44493);
var args = cljs.core.rest(arglist__44493);
return G__44491__delegate(x,y,z,args);
});
G__44491.cljs$core$IFn$_invoke$arity$variadic = G__44491__delegate;
return G__44491;
})()
;
G__44490 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__44490__0.call(this);
case 1:
return G__44490__1.call(this,x);
case 2:
return G__44490__2.call(this,x,y);
case 3:
return G__44490__3.call(this,x,y,z);
default:
var G__44494 = null;
if (arguments.length > 3) {
var G__44495__i = 0, G__44495__a = new Array(arguments.length -  3);
while (G__44495__i < G__44495__a.length) {G__44495__a[G__44495__i] = arguments[G__44495__i + 3]; ++G__44495__i;}
G__44494 = new cljs.core.IndexedSeq(G__44495__a,0);
}
return G__44490__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__44494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44490.cljs$lang$maxFixedArity = 3;
G__44490.cljs$lang$applyTo = G__44490__4.cljs$lang$applyTo;
G__44490.cljs$core$IFn$_invoke$arity$0 = G__44490__0;
G__44490.cljs$core$IFn$_invoke$arity$1 = G__44490__1;
G__44490.cljs$core$IFn$_invoke$arity$2 = G__44490__2;
G__44490.cljs$core$IFn$_invoke$arity$3 = G__44490__3;
G__44490.cljs$core$IFn$_invoke$arity$variadic = G__44490__4.cljs$core$IFn$_invoke$arity$variadic;
return G__44490;
})()
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$2 = (function (f,g){
return (function() {
var G__44496 = null;
var G__44496__0 = (function (){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),(g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null))],null));
});
var G__44496__1 = (function (x){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)),(g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x))],null));
});
var G__44496__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)),(g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y))],null));
});
var G__44496__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(x,y,z) : f.call(null,x,y,z)),(g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z))],null));
});
var G__44496__4 = (function() { 
var G__44497__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args)],null));
};
var G__44497 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__44498__i = 0, G__44498__a = new Array(arguments.length -  3);
while (G__44498__i < G__44498__a.length) {G__44498__a[G__44498__i] = arguments[G__44498__i + 3]; ++G__44498__i;}
  args = new cljs.core.IndexedSeq(G__44498__a,0);
} 
return G__44497__delegate.call(this,x,y,z,args);};
G__44497.cljs$lang$maxFixedArity = 3;
G__44497.cljs$lang$applyTo = (function (arglist__44499){
var x = cljs.core.first(arglist__44499);
arglist__44499 = cljs.core.next(arglist__44499);
var y = cljs.core.first(arglist__44499);
arglist__44499 = cljs.core.next(arglist__44499);
var z = cljs.core.first(arglist__44499);
var args = cljs.core.rest(arglist__44499);
return G__44497__delegate(x,y,z,args);
});
G__44497.cljs$core$IFn$_invoke$arity$variadic = G__44497__delegate;
return G__44497;
})()
;
G__44496 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__44496__0.call(this);
case 1:
return G__44496__1.call(this,x);
case 2:
return G__44496__2.call(this,x,y);
case 3:
return G__44496__3.call(this,x,y,z);
default:
var G__44500 = null;
if (arguments.length > 3) {
var G__44501__i = 0, G__44501__a = new Array(arguments.length -  3);
while (G__44501__i < G__44501__a.length) {G__44501__a[G__44501__i] = arguments[G__44501__i + 3]; ++G__44501__i;}
G__44500 = new cljs.core.IndexedSeq(G__44501__a,0);
}
return G__44496__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__44500);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44496.cljs$lang$maxFixedArity = 3;
G__44496.cljs$lang$applyTo = G__44496__4.cljs$lang$applyTo;
G__44496.cljs$core$IFn$_invoke$arity$0 = G__44496__0;
G__44496.cljs$core$IFn$_invoke$arity$1 = G__44496__1;
G__44496.cljs$core$IFn$_invoke$arity$2 = G__44496__2;
G__44496.cljs$core$IFn$_invoke$arity$3 = G__44496__3;
G__44496.cljs$core$IFn$_invoke$arity$variadic = G__44496__4.cljs$core$IFn$_invoke$arity$variadic;
return G__44496;
})()
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$3 = (function (f,g,h){
return (function() {
var G__44502 = null;
var G__44502__0 = (function (){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),(g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null)),(h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null))],null));
});
var G__44502__1 = (function (x){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)),(g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x)),(h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null,x))],null));
});
var G__44502__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)),(g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y)),(h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x,y) : h.call(null,x,y))],null));
});
var G__44502__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(x,y,z) : f.call(null,x,y,z)),(g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z)),(h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x,y,z) : h.call(null,x,y,z))],null));
});
var G__44502__4 = (function() { 
var G__44503__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args)],null));
};
var G__44503 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__44504__i = 0, G__44504__a = new Array(arguments.length -  3);
while (G__44504__i < G__44504__a.length) {G__44504__a[G__44504__i] = arguments[G__44504__i + 3]; ++G__44504__i;}
  args = new cljs.core.IndexedSeq(G__44504__a,0);
} 
return G__44503__delegate.call(this,x,y,z,args);};
G__44503.cljs$lang$maxFixedArity = 3;
G__44503.cljs$lang$applyTo = (function (arglist__44505){
var x = cljs.core.first(arglist__44505);
arglist__44505 = cljs.core.next(arglist__44505);
var y = cljs.core.first(arglist__44505);
arglist__44505 = cljs.core.next(arglist__44505);
var z = cljs.core.first(arglist__44505);
var args = cljs.core.rest(arglist__44505);
return G__44503__delegate(x,y,z,args);
});
G__44503.cljs$core$IFn$_invoke$arity$variadic = G__44503__delegate;
return G__44503;
})()
;
G__44502 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__44502__0.call(this);
case 1:
return G__44502__1.call(this,x);
case 2:
return G__44502__2.call(this,x,y);
case 3:
return G__44502__3.call(this,x,y,z);
default:
var G__44506 = null;
if (arguments.length > 3) {
var G__44507__i = 0, G__44507__a = new Array(arguments.length -  3);
while (G__44507__i < G__44507__a.length) {G__44507__a[G__44507__i] = arguments[G__44507__i + 3]; ++G__44507__i;}
G__44506 = new cljs.core.IndexedSeq(G__44507__a,0);
}
return G__44502__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__44506);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44502.cljs$lang$maxFixedArity = 3;
G__44502.cljs$lang$applyTo = G__44502__4.cljs$lang$applyTo;
G__44502.cljs$core$IFn$_invoke$arity$0 = G__44502__0;
G__44502.cljs$core$IFn$_invoke$arity$1 = G__44502__1;
G__44502.cljs$core$IFn$_invoke$arity$2 = G__44502__2;
G__44502.cljs$core$IFn$_invoke$arity$3 = G__44502__3;
G__44502.cljs$core$IFn$_invoke$arity$variadic = G__44502__4.cljs$core$IFn$_invoke$arity$variadic;
return G__44502;
})()
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic = (function (f,g,h,fs){
var fs__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f,g,h,fs);
return ((function (fs__$1){
return (function() {
var G__44508 = null;
var G__44508__0 = (function (){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__44469_SHARP_,p2__44470_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__44469_SHARP_,(p2__44470_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p2__44470_SHARP_.cljs$core$IFn$_invoke$arity$0() : p2__44470_SHARP_.call(null)));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__44508__1 = (function (x){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__44471_SHARP_,p2__44472_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__44471_SHARP_,(p2__44472_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p2__44472_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p2__44472_SHARP_.call(null,x)));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__44508__2 = (function (x,y){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__44473_SHARP_,p2__44474_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__44473_SHARP_,(p2__44474_SHARP_.cljs$core$IFn$_invoke$arity$2 ? p2__44474_SHARP_.cljs$core$IFn$_invoke$arity$2(x,y) : p2__44474_SHARP_.call(null,x,y)));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__44508__3 = (function (x,y,z){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__44475_SHARP_,p2__44476_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__44475_SHARP_,(p2__44476_SHARP_.cljs$core$IFn$_invoke$arity$3 ? p2__44476_SHARP_.cljs$core$IFn$_invoke$arity$3(x,y,z) : p2__44476_SHARP_.call(null,x,y,z)));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__44508__4 = (function() { 
var G__44509__delegate = function (x,y,z,args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__44477_SHARP_,p2__44478_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__44477_SHARP_,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(p2__44478_SHARP_,x,y,z,args));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
};
var G__44509 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__44510__i = 0, G__44510__a = new Array(arguments.length -  3);
while (G__44510__i < G__44510__a.length) {G__44510__a[G__44510__i] = arguments[G__44510__i + 3]; ++G__44510__i;}
  args = new cljs.core.IndexedSeq(G__44510__a,0);
} 
return G__44509__delegate.call(this,x,y,z,args);};
G__44509.cljs$lang$maxFixedArity = 3;
G__44509.cljs$lang$applyTo = (function (arglist__44511){
var x = cljs.core.first(arglist__44511);
arglist__44511 = cljs.core.next(arglist__44511);
var y = cljs.core.first(arglist__44511);
arglist__44511 = cljs.core.next(arglist__44511);
var z = cljs.core.first(arglist__44511);
var args = cljs.core.rest(arglist__44511);
return G__44509__delegate(x,y,z,args);
});
G__44509.cljs$core$IFn$_invoke$arity$variadic = G__44509__delegate;
return G__44509;
})()
;
G__44508 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__44508__0.call(this);
case 1:
return G__44508__1.call(this,x);
case 2:
return G__44508__2.call(this,x,y);
case 3:
return G__44508__3.call(this,x,y,z);
default:
var G__44512 = null;
if (arguments.length > 3) {
var G__44513__i = 0, G__44513__a = new Array(arguments.length -  3);
while (G__44513__i < G__44513__a.length) {G__44513__a[G__44513__i] = arguments[G__44513__i + 3]; ++G__44513__i;}
G__44512 = new cljs.core.IndexedSeq(G__44513__a,0);
}
return G__44508__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__44512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44508.cljs$lang$maxFixedArity = 3;
G__44508.cljs$lang$applyTo = G__44508__4.cljs$lang$applyTo;
G__44508.cljs$core$IFn$_invoke$arity$0 = G__44508__0;
G__44508.cljs$core$IFn$_invoke$arity$1 = G__44508__1;
G__44508.cljs$core$IFn$_invoke$arity$2 = G__44508__2;
G__44508.cljs$core$IFn$_invoke$arity$3 = G__44508__3;
G__44508.cljs$core$IFn$_invoke$arity$variadic = G__44508__4.cljs$core$IFn$_invoke$arity$variadic;
return G__44508;
})()
;})(fs__$1))
});

cljs.core.juxt.cljs$lang$applyTo = (function (seq44480){
var G__44481 = cljs.core.first(seq44480);
var seq44480__$1 = cljs.core.next(seq44480);
var G__44482 = cljs.core.first(seq44480__$1);
var seq44480__$2 = cljs.core.next(seq44480__$1);
var G__44483 = cljs.core.first(seq44480__$2);
var seq44480__$3 = cljs.core.next(seq44480__$2);
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic(G__44481,G__44482,G__44483,seq44480__$3);
});

cljs.core.juxt.cljs$lang$maxFixedArity = (3);

/**
 * When lazy sequences are produced via functions that have side
 *   effects, any effects other than those needed to produce the first
 *   element in the seq do not occur until the seq is consumed. dorun can
 *   be used to force any effects. Walks through the successive nexts of
 *   the seq, does not retain the head and returns nil.
 */
cljs.core.dorun = (function cljs$core$dorun(var_args){
var args44514 = [];
var len__7651__auto___44517 = arguments.length;
var i__7652__auto___44518 = (0);
while(true){
if((i__7652__auto___44518 < len__7651__auto___44517)){
args44514.push((arguments[i__7652__auto___44518]));

var G__44519 = (i__7652__auto___44518 + (1));
i__7652__auto___44518 = G__44519;
continue;
} else {
}
break;
}

var G__44516 = args44514.length;
switch (G__44516) {
case 1:
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args44514.length)].join('')));

}
});

cljs.core.dorun.cljs$core$IFn$_invoke$arity$1 = (function (coll){
while(true){
if(cljs.core.seq(coll)){
var G__44521 = cljs.core.next(coll);
coll = G__44521;
continue;
} else {
return null;
}
break;
}
});

cljs.core.dorun.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
while(true){
if((cljs.core.seq(coll)) && ((n > (0)))){
var G__44522 = (n - (1));
var G__44523 = cljs.core.next(coll);
n = G__44522;
coll = G__44523;
continue;
} else {
return null;
}
break;
}
});

cljs.core.dorun.cljs$lang$maxFixedArity = 2;

/**
 * When lazy sequences are produced via functions that have side
 *   effects, any effects other than those needed to produce the first
 *   element in the seq do not occur until the seq is consumed. doall can
 *   be used to force any effects. Walks through the successive nexts of
 *   the seq, retains the head and returns it, thus causing the entire
 *   seq to reside in memory at one time.
 */
cljs.core.doall = (function cljs$core$doall(var_args){
var args44524 = [];
var len__7651__auto___44527 = arguments.length;
var i__7652__auto___44528 = (0);
while(true){
if((i__7652__auto___44528 < len__7651__auto___44527)){
args44524.push((arguments[i__7652__auto___44528]));

var G__44529 = (i__7652__auto___44528 + (1));
i__7652__auto___44528 = G__44529;
continue;
} else {
}
break;
}

var G__44526 = args44524.length;
switch (G__44526) {
case 1:
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.doall.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args44524.length)].join('')));

}
});

cljs.core.doall.cljs$core$IFn$_invoke$arity$1 = (function (coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(coll);

return coll;
});

cljs.core.doall.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$2(n,coll);

return coll;
});

cljs.core.doall.cljs$lang$maxFixedArity = 2;

/**
 * Returns true if x is a JavaScript RegExp instance.
 */
cljs.core.regexp_QMARK_ = (function cljs$core$regexp_QMARK_(x){
return (x instanceof RegExp);
});
/**
 * Returns the result of (re-find re s) if re fully matches s.
 */
cljs.core.re_matches = (function cljs$core$re_matches(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(matches),s)){
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
} else {
return null;
}
} else {
throw (new TypeError("re-matches must match against a string."));
}
});
/**
 * Returns the first regex match, if any, of s to re, using
 *   re.exec(s). Returns a vector, containing first the matching
 *   substring, then any capturing groups if the regular expression contains
 *   capturing groups.
 */
cljs.core.re_find = (function cljs$core$re_find(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if((matches == null)){
return null;
} else {
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
}
} else {
throw (new TypeError("re-find must match against a string."));
}
});
/**
 * Returns a lazy sequence of successive matches of re in s.
 */
cljs.core.re_seq = (function cljs$core$re_seq(re,s){
var match_data = cljs.core.re_find(re,s);
var match_idx = s.search(re);
var match_str = ((cljs.core.coll_QMARK_(match_data))?cljs.core.first(match_data):match_data);
var post_match = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,(match_idx + cljs.core.count(match_str)));
if(cljs.core.truth_(match_data)){
return (new cljs.core.LazySeq(null,((function (match_data,match_idx,match_str,post_match){
return (function (){
return cljs.core.cons(match_data,((cljs.core.seq(post_match))?(cljs.core.re_seq.cljs$core$IFn$_invoke$arity$2 ? cljs.core.re_seq.cljs$core$IFn$_invoke$arity$2(re,post_match) : cljs.core.re_seq.call(null,re,post_match)):null));
});})(match_data,match_idx,match_str,post_match))
,null,null));
} else {
return null;
}
});
/**
 * Returns an instance of RegExp which has compiled the provided string.
 */
cljs.core.re_pattern = (function cljs$core$re_pattern(s){
if((s instanceof RegExp)){
return s;
} else {
var vec__44534 = cljs.core.re_find(/^\(\?([idmsux]*)\)/,s);
var prefix = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44534,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44534,(1),null);
var pattern = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,cljs.core.count(prefix));
return (new RegExp(pattern,(function (){var or__6543__auto__ = flags;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return "";
}
})()));
}
});
cljs.core.pr_sequential_writer = (function cljs$core$pr_sequential_writer(writer,print_one,begin,sep,end,opts,coll){
var _STAR_print_level_STAR_44544 = cljs.core._STAR_print_level_STAR_;
cljs.core._STAR_print_level_STAR_ = (((cljs.core._STAR_print_level_STAR_ == null))?null:(cljs.core._STAR_print_level_STAR_ - (1)));

try{if((!((cljs.core._STAR_print_level_STAR_ == null))) && ((cljs.core._STAR_print_level_STAR_ < (0)))){
return cljs.core._write(writer,"#");
} else {
cljs.core._write(writer,begin);

if((cljs.core.cst$kw$print_DASH_length.cljs$core$IFn$_invoke$arity$1(opts) === (0))){
if(cljs.core.seq(coll)){
cljs.core._write(writer,(function (){var or__6543__auto__ = cljs.core.cst$kw$more_DASH_marker.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return "...";
}
})());
} else {
}
} else {
if(cljs.core.seq(coll)){
var G__44545_44551 = cljs.core.first(coll);
var G__44546_44552 = writer;
var G__44547_44553 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__44545_44551,G__44546_44552,G__44547_44553) : print_one.call(null,G__44545_44551,G__44546_44552,G__44547_44553));
} else {
}

var coll_44554__$1 = cljs.core.next(coll);
var n_44555 = (cljs.core.cst$kw$print_DASH_length.cljs$core$IFn$_invoke$arity$1(opts) - (1));
while(true){
if((coll_44554__$1) && (((n_44555 == null)) || (!((n_44555 === (0)))))){
cljs.core._write(writer,sep);

var G__44548_44556 = cljs.core.first(coll_44554__$1);
var G__44549_44557 = writer;
var G__44550_44558 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__44548_44556,G__44549_44557,G__44550_44558) : print_one.call(null,G__44548_44556,G__44549_44557,G__44550_44558));

var G__44559 = cljs.core.next(coll_44554__$1);
var G__44560 = (n_44555 - (1));
coll_44554__$1 = G__44559;
n_44555 = G__44560;
continue;
} else {
if((cljs.core.seq(coll_44554__$1)) && ((n_44555 === (0)))){
cljs.core._write(writer,sep);

cljs.core._write(writer,(function (){var or__6543__auto__ = cljs.core.cst$kw$more_DASH_marker.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return "...";
}
})());
} else {
}
}
break;
}
}

return cljs.core._write(writer,end);
}
}finally {cljs.core._STAR_print_level_STAR_ = _STAR_print_level_STAR_44544;
}});
cljs.core.write_all = (function cljs$core$write_all(var_args){
var args__7658__auto__ = [];
var len__7651__auto___44567 = arguments.length;
var i__7652__auto___44568 = (0);
while(true){
if((i__7652__auto___44568 < len__7651__auto___44567)){
args__7658__auto__.push((arguments[i__7652__auto___44568]));

var G__44569 = (i__7652__auto___44568 + (1));
i__7652__auto___44568 = G__44569;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic = (function (writer,ss){
var seq__44563 = cljs.core.seq(ss);
var chunk__44564 = null;
var count__44565 = (0);
var i__44566 = (0);
while(true){
if((i__44566 < count__44565)){
var s = chunk__44564.cljs$core$IIndexed$_nth$arity$2(null,i__44566);
cljs.core._write(writer,s);

var G__44570 = seq__44563;
var G__44571 = chunk__44564;
var G__44572 = count__44565;
var G__44573 = (i__44566 + (1));
seq__44563 = G__44570;
chunk__44564 = G__44571;
count__44565 = G__44572;
i__44566 = G__44573;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__44563);
if(temp__4657__auto__){
v