/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ResponseFormatter {
    Response response;

    public ResponseFormatter(Response response) {
        this.response = response;
    }

    public byte[] formatResponse() {
        ByteArrayOutputStream responseStream = new ByteArrayOutputStream();
        try {
            responseStream.write(this.formatStatusLine().getBytes());
            responseStream.write(this.formatHeaders().getBytes());
            responseStream.write("\r\n".getBytes());
            responseStream.write(this.response.getMessageBody());
        }
        catch (IOException e) {
            System.err.println("Could not format response.");
            e.printStackTrace();
        }
        return responseStream.toByteArray();
    }

    private String formatStatusLine() {
        return this.formatHttpVersion() + " " + this.response.getStatusCode() + " " + this.response.getReasonPhrase() + "\r\n";
    }

    private String formatHttpVersion() {
        return "HTTP/" + this.response.getHTTPVersion();
    }

    private String formatHeaders() {
        Object formattedHeaders = "";
        HashMap headersMap = this.response.getHeaders();
        for (Map.Entry fieldValuePair : headersMap.entrySet()) {
            String field = (String)fieldValuePair.getKey();
            Object value = fieldValuePair.getValue();
            formattedHeaders = (String)formattedHeaders + field + ": " + value + "\r\n";
        }
        return formattedHeaders;
    }
}

