/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;

public class RequestParser {
    BufferedReader reader;

    public RequestParser(BufferedReader reader) {
        this.reader = reader;
    }

    public Request generateRequest() throws BadRequestException {
        RequestLineParser requestLineParser = this.parseRequestLine();
        HashMap<String, String> headers = this.parseHeaders();
        String method = this.extractMethod(requestLineParser.getMethod(), headers);
        String body = this.parseBody();
        return new Request.Builder().method(method).uri(requestLineParser.getURI()).query(requestLineParser.getQuery()).version(requestLineParser.getHTTPVersion()).headers(headers).body(body).build();
    }

    private RequestLineParser parseRequestLine() throws BadRequestException {
        try {
            String requestLineString = this.reader.readLine();
            return new RequestLineParser(requestLineString);
        }
        catch (IOException e) {
            throw new BadRequestException("Could not parse request line.");
        }
    }

    private HashMap<String, String> parseHeaders() throws BadRequestException {
        try {
            String line;
            HashMap<String, String> headers = new HashMap<String, String>();
            while ((line = this.reader.readLine()) != null && line.length() != 0) {
                headers = this.putLineInHeaders(line, headers);
            }
            return headers;
        }
        catch (IOException | ArrayIndexOutOfBoundsException e) {
            throw new BadRequestException("Could not parse request headers.");
        }
    }

    private String extractMethod(String givenMethod, HashMap<String, String> headers) {
        String method = givenMethod;
        if (headers.containsKey("X-HTTP-Method-Override")) {
            method = headers.get("X-HTTP-Method-Override");
        }
        return method;
    }

    private HashMap<String, String> putLineInHeaders(String headersLine, HashMap<String, String> headers) {
        HashMap<String, String> updatedHeaders = headers;
        String[] splitLine = headersLine.split(": ");
        String field = splitLine[0];
        String val = splitLine[1];
        updatedHeaders.put(field, val);
        return updatedHeaders;
    }

    private String parseBody() throws BadRequestException {
        try {
            String stringifiedMessageBody = this.stringifyMessageBody();
            return stringifiedMessageBody.length() > 0 ? stringifiedMessageBody : "";
        }
        catch (IOException | ArrayIndexOutOfBoundsException e) {
            throw new BadRequestException("Could not parse request message body.");
        }
    }

    private String stringifyMessageBody() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.reader.ready()) {
            stringBuilder.append((char)this.reader.read());
        }
        return stringBuilder.toString();
    }
}

