/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import java.util.List;

public class PeopleHandler
implements Handler {
    private static final String DESTINATION_DIRECTORY_URI = "/people";
    private static final String[] SUPPORTED_MEDIA_TYPES = new String[]{"application/json", "text/plain"};
    private static final List<String> SUPPORTED_METHODS = Arrays.asList("OPTIONS", "POST");
    private Directory directory;

    public PeopleHandler(Directory directory) {
        this.directory = directory;
        this.directory.createDirectory(DESTINATION_DIRECTORY_URI);
    }

    @Override
    public Response generateResponse(Request request) {
        switch (request.getMethod()) {
            case "OPTIONS": {
                return ResponseUtil.buildOptionsResponse(SUPPORTED_METHODS);
            }
            case "POST": {
                return this.handlePostRequest(request);
            }
        }
        return new Response.Builder(405).build();
    }

    private Response handlePostRequest(Request request) {
        String contentType = request.getHeader("Content-Type");
        if (Arrays.asList(SUPPORTED_MEDIA_TYPES).contains(contentType)) {
            String seeOtherUri = this.createFile(request);
            return this.buildPostResponse(seeOtherUri);
        }
        return this.buildUnsupportedMediaTypeResponse();
    }

    private String createFile(Request request) {
        String contentType = request.getHeader("Content-Type");
        String extension = MimeType.getExtension(contentType);
        byte[] content = request.getBody().getBytes();
        String uri = "/people/" + Util.createRandomFileName(extension);
        this.directory.createFileWithContent(uri, content);
        return uri;
    }

    private Response buildPostResponse(String seeOtherUri) {
        return new Response.Builder(201).setHeader("Location", seeOtherUri).build();
    }

    private Response buildUnsupportedMediaTypeResponse() {
        return new Response.Builder(415).build();
    }
}

